// +build !ignore_autogenerated_openshift

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package v1

import (
	api "k8s.io/kubernetes/pkg/api"
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	conversion "k8s.io/kubernetes/pkg/conversion"
	intstr "k8s.io/kubernetes/pkg/util/intstr"
)

func init() {
	if err := api.Scheme.AddGeneratedDeepCopyFuncs(
		DeepCopy_v1_Route,
		DeepCopy_v1_RouteIngress,
		DeepCopy_v1_RouteIngressCondition,
		DeepCopy_v1_RouteList,
		DeepCopy_v1_RoutePort,
		DeepCopy_v1_RouteSpec,
		DeepCopy_v1_RouteStatus,
		DeepCopy_v1_RouteTargetReference,
		DeepCopy_v1_RouterShard,
		DeepCopy_v1_TLSConfig,
	); err != nil {
		// if one of the deep copy functions is malformed, detect it immediately.
		panic(err)
	}
}

func DeepCopy_v1_Route(in Route, out *Route, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api_v1.DeepCopy_v1_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_v1_RouteSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_v1_RouteStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_v1_RouteIngress(in RouteIngress, out *RouteIngress, c *conversion.Cloner) error {
	out.Host = in.Host
	out.RouterName = in.RouterName
	if in.Conditions != nil {
		in, out := in.Conditions, &out.Conditions
		*out = make([]RouteIngressCondition, len(in))
		for i := range in {
			if err := DeepCopy_v1_RouteIngressCondition(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	return nil
}

func DeepCopy_v1_RouteIngressCondition(in RouteIngressCondition, out *RouteIngressCondition, c *conversion.Cloner) error {
	out.Type = in.Type
	out.Status = in.Status
	out.Reason = in.Reason
	out.Message = in.Message
	if in.LastTransitionTime != nil {
		in, out := in.LastTransitionTime, &out.LastTransitionTime
		*out = new(unversioned.Time)
		if err := unversioned.DeepCopy_unversioned_Time(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.LastTransitionTime = nil
	}
	return nil
}

func DeepCopy_v1_RouteList(in RouteList, out *RouteList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Route, len(in))
		for i := range in {
			if err := DeepCopy_v1_Route(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_v1_RoutePort(in RoutePort, out *RoutePort, c *conversion.Cloner) error {
	if err := intstr.DeepCopy_intstr_IntOrString(in.TargetPort, &out.TargetPort, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_v1_RouteSpec(in RouteSpec, out *RouteSpec, c *conversion.Cloner) error {
	out.Host = in.Host
	out.Path = in.Path
	if err := DeepCopy_v1_RouteTargetReference(in.To, &out.To, c); err != nil {
		return err
	}
	if in.AlternateBackends != nil {
		in, out := in.AlternateBackends, &out.AlternateBackends
		*out = make([]RouteTargetReference, len(in))
		for i := range in {
			if err := DeepCopy_v1_RouteTargetReference(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.AlternateBackends = nil
	}
	if in.Port != nil {
		in, out := in.Port, &out.Port
		*out = new(RoutePort)
		if err := DeepCopy_v1_RoutePort(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Port = nil
	}
	if in.TLS != nil {
		in, out := in.TLS, &out.TLS
		*out = new(TLSConfig)
		if err := DeepCopy_v1_TLSConfig(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.TLS = nil
	}
	return nil
}

func DeepCopy_v1_RouteStatus(in RouteStatus, out *RouteStatus, c *conversion.Cloner) error {
	if in.Ingress != nil {
		in, out := in.Ingress, &out.Ingress
		*out = make([]RouteIngress, len(in))
		for i := range in {
			if err := DeepCopy_v1_RouteIngress(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Ingress = nil
	}
	return nil
}

func DeepCopy_v1_RouteTargetReference(in RouteTargetReference, out *RouteTargetReference, c *conversion.Cloner) error {
	out.Kind = in.Kind
	out.Name = in.Name
	if in.Weight != nil {
		in, out := in.Weight, &out.Weight
		*out = new(int32)
		**out = *in
	} else {
		out.Weight = nil
	}
	return nil
}

func DeepCopy_v1_RouterShard(in RouterShard, out *RouterShard, c *conversion.Cloner) error {
	out.ShardName = in.ShardName
	out.DNSSuffix = in.DNSSuffix
	return nil
}

func DeepCopy_v1_TLSConfig(in TLSConfig, out *TLSConfig, c *conversion.Cloner) error {
	out.Termination = in.Termination
	out.Certificate = in.Certificate
	out.Key = in.Key
	out.CACertificate = in.CACertificate
	out.DestinationCACertificate = in.DestinationCACertificate
	out.InsecureEdgeTerminationPolicy = in.InsecureEdgeTerminationPolicy
	return nil
}
