// +build !ignore_autogenerated_openshift

// This file was autogenerated by defaulter-gen. Do not edit it manually!

package v1

import (
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	runtime "k8s.io/kubernetes/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&Build{}, func(obj interface{}) { SetObjectDefaults_Build(obj.(*Build)) })
	scheme.AddTypeDefaultingFunc(&BuildConfig{}, func(obj interface{}) { SetObjectDefaults_BuildConfig(obj.(*BuildConfig)) })
	scheme.AddTypeDefaultingFunc(&BuildConfigList{}, func(obj interface{}) { SetObjectDefaults_BuildConfigList(obj.(*BuildConfigList)) })
	scheme.AddTypeDefaultingFunc(&BuildList{}, func(obj interface{}) { SetObjectDefaults_BuildList(obj.(*BuildList)) })
	scheme.AddTypeDefaultingFunc(&BuildRequest{}, func(obj interface{}) { SetObjectDefaults_BuildRequest(obj.(*BuildRequest)) })
	return nil
}

func SetObjectDefaults_Build(in *Build) {
	SetDefaults_BuildSource(&in.Spec.CommonSpec.Source)
	SetDefaults_BuildStrategy(&in.Spec.CommonSpec.Strategy)
	if in.Spec.CommonSpec.Strategy.DockerStrategy != nil {
		SetDefaults_DockerBuildStrategy(in.Spec.CommonSpec.Strategy.DockerStrategy)
		for i := range in.Spec.CommonSpec.Strategy.DockerStrategy.Env {
			a := &in.Spec.CommonSpec.Strategy.DockerStrategy.Env[i]
			if a.ValueFrom != nil {
				if a.ValueFrom.FieldRef != nil {
					api_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
				}
			}
		}
	}
	if in.Spec.CommonSpec.Strategy.SourceStrategy != nil {
		SetDefaults_SourceBuildStrategy(in.Spec.CommonSpec.Strategy.SourceStrategy)
		for i := range in.Spec.CommonSpec.Strategy.SourceStrategy.Env {
			a := &in.Spec.CommonSpec.Strategy.SourceStrategy.Env[i]
			if a.ValueFrom != nil {
				if a.ValueFrom.FieldRef != nil {
					api_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
				}
			}
		}
	}
	if in.Spec.CommonSpec.Strategy.CustomStrategy != nil {
		SetDefaults_CustomBuildStrategy(in.Spec.CommonSpec.Strategy.CustomStrategy)
		for i := range in.Spec.CommonSpec.Strategy.CustomStrategy.Env {
			a := &in.Spec.CommonSpec.Strategy.CustomStrategy.Env[i]
			if a.ValueFrom != nil {
				if a.ValueFrom.FieldRef != nil {
					api_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
				}
			}
		}
	}
	api_v1.SetDefaults_ResourceList(&in.Spec.CommonSpec.Resources.Limits)
	api_v1.SetDefaults_ResourceList(&in.Spec.CommonSpec.Resources.Requests)
}

func SetObjectDefaults_BuildConfig(in *BuildConfig) {
	SetDefaults_BuildConfigSpec(&in.Spec)
	for i := range in.Spec.Triggers {
		a := &in.Spec.Triggers[i]
		SetDefaults_BuildTriggerPolicy(a)
	}
	SetDefaults_BuildSource(&in.Spec.CommonSpec.Source)
	SetDefaults_BuildStrategy(&in.Spec.CommonSpec.Strategy)
	if in.Spec.CommonSpec.Strategy.DockerStrategy != nil {
		SetDefaults_DockerBuildStrategy(in.Spec.CommonSpec.Strategy.DockerStrategy)
		for i := range in.Spec.CommonSpec.Strategy.DockerStrategy.Env {
			a := &in.Spec.CommonSpec.Strategy.DockerStrategy.Env[i]
			if a.ValueFrom != nil {
				if a.ValueFrom.FieldRef != nil {
					api_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
				}
			}
		}
	}
	if in.Spec.CommonSpec.Strategy.SourceStrategy != nil {
		SetDefaults_SourceBuildStrategy(in.Spec.CommonSpec.Strategy.SourceStrategy)
		for i := range in.Spec.CommonSpec.Strategy.SourceStrategy.Env {
			a := &in.Spec.CommonSpec.Strategy.SourceStrategy.Env[i]
			if a.ValueFrom != nil {
				if a.ValueFrom.FieldRef != nil {
					api_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
				}
			}
		}
	}
	if in.Spec.CommonSpec.Strategy.CustomStrategy != nil {
		SetDefaults_CustomBuildStrategy(in.Spec.CommonSpec.Strategy.CustomStrategy)
		for i := range in.Spec.CommonSpec.Strategy.CustomStrategy.Env {
			a := &in.Spec.CommonSpec.Strategy.CustomStrategy.Env[i]
			if a.ValueFrom != nil {
				if a.ValueFrom.FieldRef != nil {
					api_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
				}
			}
		}
	}
	api_v1.SetDefaults_ResourceList(&in.Spec.CommonSpec.Resources.Limits)
	api_v1.SetDefaults_ResourceList(&in.Spec.CommonSpec.Resources.Requests)
}

func SetObjectDefaults_BuildConfigList(in *BuildConfigList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_BuildConfig(a)
	}
}

func SetObjectDefaults_BuildList(in *BuildList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Build(a)
	}
}

func SetObjectDefaults_BuildRequest(in *BuildRequest) {
	for i := range in.Env {
		a := &in.Env[i]
		if a.ValueFrom != nil {
			if a.ValueFrom.FieldRef != nil {
				api_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
			}
		}
	}
}
