package v1

// This file contains methods that can be used by the go-restful package to generate Swagger
// documentation for the object types found in 'types.go' This file is automatically generated
// by hack/update-generated-swagger-descriptions.sh and should be run after a full build of OpenShift.
// ==== DO NOT EDIT THIS FILE MANUALLY ====

var map_BuildDefaultsConfig = map[string]string{
	"":              "BuildDefaultsConfig controls the default information for Builds",
	"gitHTTPProxy":  "gitHTTPProxy is the location of the HTTPProxy for Git source",
	"gitHTTPSProxy": "gitHTTPSProxy is the location of the HTTPSProxy for Git source",
	"gitNoProxy":    "gitNoProxy is the list of domains for which the proxy should not be used",
	"env":           "env is a set of default environment variables that will be applied to the build if the specified variables do not exist on the build",
	"sourceStrategyDefaults": "sourceStrategyDefaults are default values that apply to builds using the source strategy.",
	"imageLabels":            "imageLabels is a list of docker labels that are applied to the resulting image. User can override a default label by providing a label with the same name in their Build/BuildConfig.",
	"nodeSelector":           "nodeSelector is a selector which must be true for the build pod to fit on a node",
	"annotations":            "annotations are annotations that will be added to the build pod",
	"resources":              "resources defines resource requirements to execute the build.",
}

func (BuildDefaultsConfig) SwaggerDoc() map[string]string {
	return map_BuildDefaultsConfig
}

var map_SourceStrategyDefaultsConfig = map[string]string{
	"":            "SourceStrategyDefaultsConfig contains values that apply to builds using the source strategy.",
	"incremental": "incremental indicates if s2i build strategies should perform an incremental build or not",
}

func (SourceStrategyDefaultsConfig) SwaggerDoc() map[string]string {
	return map_SourceStrategyDefaultsConfig
}
