// conversion-gen is a tool for auto-generating Conversion functions.
//
// Structs in the input directories with the below line in their comments
// will be ignored during generation.
// // +genconversion=false
package main

import (
	"github.com/golang/glog"
	"github.com/spf13/pflag"

	"k8s.io/gengo/args"
	"k8s.io/gengo/examples/defaulter-gen/generators"
)

func main() {
	arguments := args.Default()

	// Override defaults.
	arguments.OutputFileBaseName = "zz_generated.defaults"
	arguments.GoHeaderFilePath = "hack/boilerplate.txt"
	arguments.GeneratedBuildTag = "ignore_autogenerated_openshift"

	// Custom args.
	customArgs := &generators.CustomArgs{
		ExtraPeerDirs: []string{},
	}
	pflag.CommandLine.StringSliceVar(&customArgs.ExtraPeerDirs, "extra-peer-dirs", customArgs.ExtraPeerDirs,
		"Comma-separated list of import paths which are considered, after tag-specified peers, for conversions.")
	arguments.CustomArgs = customArgs

	// Run it.
	if err := arguments.Execute(
		generators.NameSystems(),
		generators.DefaultNameSystem(),
		generators.Packages,
	); err != nil {
		glog.Fatalf("Error: %v", err)
	}
	glog.V(2).Info("Completed successfully.")

}
