/*
Copyright 2015 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package api

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg2_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg7_fields "k8s.io/kubernetes/pkg/fields"
	pkg6_labels "k8s.io/kubernetes/pkg/labels"
	pkg8_runtime "k8s.io/kubernetes/pkg/runtime"
	pkg1_types "k8s.io/kubernetes/pkg/types"
	pkg5_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	pkg4_inf "speter.net/go/exp/math/dec/inf"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg2_unversioned.Time
		var v2 pkg7_fields.Selector
		var v3 pkg6_labels.Selector
		var v4 pkg8_runtime.Object
		var v5 pkg1_types.UID
		var v6 pkg5_intstr.IntOrString
		var v7 pkg4_inf.Dec
		var v8 time.Time
		_, _, _, _, _, _, _, _, _ = v0, v1, v2, v3, v4, v5, v6, v7, v8
	}
}

func (x *ObjectMeta) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [12]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.GenerateName != ""
			yyq2[2] = x.Namespace != ""
			yyq2[3] = x.SelfLink != ""
			yyq2[4] = x.UID != ""
			yyq2[5] = x.ResourceVersion != ""
			yyq2[6] = x.Generation != 0
			yyq2[7] = true
			yyq2[8] = x.DeletionTimestamp != nil
			yyq2[9] = x.DeletionGracePeriodSeconds != nil
			yyq2[10] = len(x.Labels) != 0
			yyq2[11] = len(x.Annotations) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(12)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yy25 := &x.CreationTimestamp
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else if z.HasExtensions() && z.EncExt(yy25) {
					} else if yym26 {
						z.EncBinaryMarshal(yy25)
					} else if !yym26 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy25)
					} else {
						z.EncFallback(yy25)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy27 := &x.CreationTimestamp
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else if z.HasExtensions() && z.EncExt(yy27) {
					} else if yym28 {
						z.EncBinaryMarshal(yy27)
					} else if !yym28 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy27)
					} else {
						z.EncFallback(yy27)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym30 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym30 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym31 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym31 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy33 := *x.DeletionGracePeriodSeconds
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							r.EncodeInt(int64(yy33))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy35 := *x.DeletionGracePeriodSeconds
						yym36 := z.EncBinary()
						_ = yym36
						if false {
						} else {
							r.EncodeInt(int64(yy35))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym38 := z.EncBinary()
						_ = yym38
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym42 := z.EncBinary()
						_ = yym42
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectMeta) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym43 := z.DecBinary()
	_ = yym43
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct44 := r.ContainerType()
		if yyct44 == codecSelferValueTypeMap1234 {
			yyl44 := r.ReadMapStart()
			if yyl44 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl44, d)
			}
		} else if yyct44 == codecSelferValueTypeArray1234 {
			yyl44 := r.ReadArrayStart()
			if yyl44 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl44, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectMeta) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys45Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys45Slc
	var yyhl45 bool = l >= 0
	for yyj45 := 0; ; yyj45++ {
		if yyhl45 {
			if yyj45 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys45Slc = r.DecodeBytes(yys45Slc, true, true)
		yys45 := string(yys45Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys45 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv53 := &x.CreationTimestamp
				yym54 := z.DecBinary()
				_ = yym54
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv53) {
				} else if yym54 {
					z.DecBinaryUnmarshal(yyv53)
				} else if !yym54 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv53)
				} else {
					z.DecFallback(yyv53, false)
				}
			}
		case "deletionTimestamp":
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg2_unversioned.Time)
				}
				yym56 := z.DecBinary()
				_ = yym56
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym56 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym56 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym58 := z.DecBinary()
				_ = yym58
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv59 := &x.Labels
				yym60 := z.DecBinary()
				_ = yym60
				if false {
				} else {
					z.F.DecMapStringStringX(yyv59, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv61 := &x.Annotations
				yym62 := z.DecBinary()
				_ = yym62
				if false {
				} else {
					z.F.DecMapStringStringX(yyv61, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys45)
		} // end switch yys45
	} // end for yyj45
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectMeta) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj63 int
	var yyb63 bool
	var yyhl63 bool = l >= 0
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv71 := &x.CreationTimestamp
		yym72 := z.DecBinary()
		_ = yym72
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv71) {
		} else if yym72 {
			z.DecBinaryUnmarshal(yyv71)
		} else if !yym72 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv71)
		} else {
			z.DecFallback(yyv71, false)
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg2_unversioned.Time)
		}
		yym74 := z.DecBinary()
		_ = yym74
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym74 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym74 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym76 := z.DecBinary()
		_ = yym76
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv77 := &x.Labels
		yym78 := z.DecBinary()
		_ = yym78
		if false {
		} else {
			z.F.DecMapStringStringX(yyv77, false, d)
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv79 := &x.Annotations
		yym80 := z.DecBinary()
		_ = yym80
		if false {
		} else {
			z.F.DecMapStringStringX(yyv79, false, d)
		}
	}
	for {
		yyj63++
		if yyhl63 {
			yyb63 = yyj63 > l
		} else {
			yyb63 = r.CheckBreak()
		}
		if yyb63 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj63-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Volume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym81 := z.EncBinary()
		_ = yym81
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep82 := !z.EncBinary()
			yy2arr82 := z.EncBasicHandle().StructToArray
			var yyq82 [18]bool
			_, _, _ = yysep82, yyq82, yy2arr82
			const yyr82 bool = false
			yyq82[1] = x.VolumeSource.HostPath != nil && x.HostPath != nil
			yyq82[2] = x.VolumeSource.EmptyDir != nil && x.EmptyDir != nil
			yyq82[3] = x.VolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq82[4] = x.VolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq82[5] = x.VolumeSource.GitRepo != nil && x.GitRepo != nil
			yyq82[6] = x.VolumeSource.Secret != nil && x.Secret != nil
			yyq82[7] = x.VolumeSource.NFS != nil && x.NFS != nil
			yyq82[8] = x.VolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq82[9] = x.VolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq82[10] = x.VolumeSource.PersistentVolumeClaim != nil && x.PersistentVolumeClaim != nil
			yyq82[11] = x.VolumeSource.RBD != nil && x.RBD != nil
			yyq82[12] = x.VolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq82[13] = x.VolumeSource.Cinder != nil && x.Cinder != nil
			yyq82[14] = x.VolumeSource.CephFS != nil && x.CephFS != nil
			yyq82[15] = x.VolumeSource.Flocker != nil && x.Flocker != nil
			yyq82[16] = x.VolumeSource.DownwardAPI != nil && x.DownwardAPI != nil
			yyq82[17] = x.VolumeSource.FC != nil && x.FC != nil
			var yynn82 int
			if yyr82 || yy2arr82 {
				r.EncodeArrayStart(18)
			} else {
				yynn82 = 1
				for _, b := range yyq82 {
					if b {
						yynn82++
					}
				}
				r.EncodeMapStart(yynn82)
				yynn82 = 0
			}
			if yyr82 || yy2arr82 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym84 := z.EncBinary()
				_ = yym84
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym85 := z.EncBinary()
				_ = yym85
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			var yyn86 bool
			if x.VolumeSource.HostPath == nil {
				yyn86 = true
				goto LABEL86
			}
		LABEL86:
			if yyr82 || yy2arr82 {
				if yyn86 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[1] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn86 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn87 bool
			if x.VolumeSource.EmptyDir == nil {
				yyn87 = true
				goto LABEL87
			}
		LABEL87:
			if yyr82 || yy2arr82 {
				if yyn87 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[2] {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn87 {
						r.EncodeNil()
					} else {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn88 bool
			if x.VolumeSource.GCEPersistentDisk == nil {
				yyn88 = true
				goto LABEL88
			}
		LABEL88:
			if yyr82 || yy2arr82 {
				if yyn88 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[3] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn88 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn89 bool
			if x.VolumeSource.AWSElasticBlockStore == nil {
				yyn89 = true
				goto LABEL89
			}
		LABEL89:
			if yyr82 || yy2arr82 {
				if yyn89 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[4] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn89 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn90 bool
			if x.VolumeSource.GitRepo == nil {
				yyn90 = true
				goto LABEL90
			}
		LABEL90:
			if yyr82 || yy2arr82 {
				if yyn90 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[5] {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn90 {
						r.EncodeNil()
					} else {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn91 bool
			if x.VolumeSource.Secret == nil {
				yyn91 = true
				goto LABEL91
			}
		LABEL91:
			if yyr82 || yy2arr82 {
				if yyn91 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[6] {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn91 {
						r.EncodeNil()
					} else {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn92 bool
			if x.VolumeSource.NFS == nil {
				yyn92 = true
				goto LABEL92
			}
		LABEL92:
			if yyr82 || yy2arr82 {
				if yyn92 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[7] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn92 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn93 bool
			if x.VolumeSource.ISCSI == nil {
				yyn93 = true
				goto LABEL93
			}
		LABEL93:
			if yyr82 || yy2arr82 {
				if yyn93 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn93 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn94 bool
			if x.VolumeSource.Glusterfs == nil {
				yyn94 = true
				goto LABEL94
			}
		LABEL94:
			if yyr82 || yy2arr82 {
				if yyn94 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[9] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn94 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn95 bool
			if x.VolumeSource.PersistentVolumeClaim == nil {
				yyn95 = true
				goto LABEL95
			}
		LABEL95:
			if yyr82 || yy2arr82 {
				if yyn95 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[10] {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn95 {
						r.EncodeNil()
					} else {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn96 bool
			if x.VolumeSource.RBD == nil {
				yyn96 = true
				goto LABEL96
			}
		LABEL96:
			if yyr82 || yy2arr82 {
				if yyn96 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[11] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn96 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn97 bool
			if x.VolumeSource.FlexVolume == nil {
				yyn97 = true
				goto LABEL97
			}
		LABEL97:
			if yyr82 || yy2arr82 {
				if yyn97 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn97 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn98 bool
			if x.VolumeSource.Cinder == nil {
				yyn98 = true
				goto LABEL98
			}
		LABEL98:
			if yyr82 || yy2arr82 {
				if yyn98 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[13] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn98 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn99 bool
			if x.VolumeSource.CephFS == nil {
				yyn99 = true
				goto LABEL99
			}
		LABEL99:
			if yyr82 || yy2arr82 {
				if yyn99 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[14] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn99 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn100 bool
			if x.VolumeSource.Flocker == nil {
				yyn100 = true
				goto LABEL100
			}
		LABEL100:
			if yyr82 || yy2arr82 {
				if yyn100 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[15] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn100 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn101 bool
			if x.VolumeSource.DownwardAPI == nil {
				yyn101 = true
				goto LABEL101
			}
		LABEL101:
			if yyr82 || yy2arr82 {
				if yyn101 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[16] {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn101 {
						r.EncodeNil()
					} else {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn102 bool
			if x.VolumeSource.FC == nil {
				yyn102 = true
				goto LABEL102
			}
		LABEL102:
			if yyr82 || yy2arr82 {
				if yyn102 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[17] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn102 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr82 || yy2arr82 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Volume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym103 := z.DecBinary()
	_ = yym103
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct104 := r.ContainerType()
		if yyct104 == codecSelferValueTypeMap1234 {
			yyl104 := r.ReadMapStart()
			if yyl104 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl104, d)
			}
		} else if yyct104 == codecSelferValueTypeArray1234 {
			yyl104 := r.ReadArrayStart()
			if yyl104 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl104, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Volume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys105Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys105Slc
	var yyhl105 bool = l >= 0
	for yyj105 := 0; ; yyj105++ {
		if yyhl105 {
			if yyj105 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys105Slc = r.DecodeBytes(yys105Slc, true, true)
		yys105 := string(yys105Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys105 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPath":
			if x.VolumeSource.HostPath == nil {
				x.VolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if x.VolumeSource.EmptyDir == nil {
				x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.VolumeSource.GCEPersistentDisk == nil {
				x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.VolumeSource.AWSElasticBlockStore == nil {
				x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if x.VolumeSource.GitRepo == nil {
				x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if x.VolumeSource.Secret == nil {
				x.VolumeSource.Secret = new(SecretVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.VolumeSource.NFS == nil {
				x.VolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.VolumeSource.ISCSI == nil {
				x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.VolumeSource.Glusterfs == nil {
				x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if x.VolumeSource.PersistentVolumeClaim == nil {
				x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.VolumeSource.RBD == nil {
				x.VolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.VolumeSource.FlexVolume == nil {
				x.VolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.VolumeSource.Cinder == nil {
				x.VolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.VolumeSource.CephFS == nil {
				x.VolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.VolumeSource.Flocker == nil {
				x.VolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if x.VolumeSource.DownwardAPI == nil {
				x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if x.VolumeSource.FC == nil {
				x.VolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys105)
		} // end switch yys105
	} // end for yyj105
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Volume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj124 int
	var yyb124 bool
	var yyhl124 bool = l >= 0
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	if x.VolumeSource.HostPath == nil {
		x.VolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.VolumeSource.EmptyDir == nil {
		x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GCEPersistentDisk == nil {
		x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AWSElasticBlockStore == nil {
		x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GitRepo == nil {
		x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Secret == nil {
		x.VolumeSource.Secret = new(SecretVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	if x.VolumeSource.NFS == nil {
		x.VolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ISCSI == nil {
		x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Glusterfs == nil {
		x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PersistentVolumeClaim == nil {
		x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	if x.VolumeSource.RBD == nil {
		x.VolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FlexVolume == nil {
		x.VolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Cinder == nil {
		x.VolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.VolumeSource.CephFS == nil {
		x.VolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Flocker == nil {
		x.VolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.VolumeSource.DownwardAPI == nil {
		x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FC == nil {
		x.VolumeSource.FC = new(FCVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	for {
		yyj124++
		if yyhl124 {
			yyb124 = yyj124 > l
		} else {
			yyb124 = r.CheckBreak()
		}
		if yyb124 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj124-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym143 := z.EncBinary()
		_ = yym143
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep144 := !z.EncBinary()
			yy2arr144 := z.EncBasicHandle().StructToArray
			var yyq144 [17]bool
			_, _, _ = yysep144, yyq144, yy2arr144
			const yyr144 bool = false
			yyq144[0] = x.HostPath != nil
			yyq144[1] = x.EmptyDir != nil
			yyq144[2] = x.GCEPersistentDisk != nil
			yyq144[3] = x.AWSElasticBlockStore != nil
			yyq144[4] = x.GitRepo != nil
			yyq144[5] = x.Secret != nil
			yyq144[6] = x.NFS != nil
			yyq144[7] = x.ISCSI != nil
			yyq144[8] = x.Glusterfs != nil
			yyq144[9] = x.PersistentVolumeClaim != nil
			yyq144[10] = x.RBD != nil
			yyq144[11] = x.FlexVolume != nil
			yyq144[12] = x.Cinder != nil
			yyq144[13] = x.CephFS != nil
			yyq144[14] = x.Flocker != nil
			yyq144[15] = x.DownwardAPI != nil
			yyq144[16] = x.FC != nil
			var yynn144 int
			if yyr144 || yy2arr144 {
				r.EncodeArrayStart(17)
			} else {
				yynn144 = 0
				for _, b := range yyq144 {
					if b {
						yynn144++
					}
				}
				r.EncodeMapStart(yynn144)
				yynn144 = 0
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[0] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[1] {
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[2] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[3] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[4] {
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[5] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[6] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[8] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[9] {
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[10] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[12] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[13] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[14] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[15] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[16] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym162 := z.DecBinary()
	_ = yym162
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct163 := r.ContainerType()
		if yyct163 == codecSelferValueTypeMap1234 {
			yyl163 := r.ReadMapStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl163, d)
			}
		} else if yyct163 == codecSelferValueTypeArray1234 {
			yyl163 := r.ReadArrayStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl163, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys164Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys164Slc
	var yyhl164 bool = l >= 0
	for yyj164 := 0; ; yyj164++ {
		if yyhl164 {
			if yyj164 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys164Slc = r.DecodeBytes(yys164Slc, true, true)
		yys164 := string(yys164Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys164 {
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys164)
		} // end switch yys164
	} // end for yyj164
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj182 int
	var yyb182 bool
	var yyhl182 bool = l >= 0
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	for {
		yyj182++
		if yyhl182 {
			yyb182 = yyj182 > l
		} else {
			yyb182 = r.CheckBreak()
		}
		if yyb182 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj182-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym200 := z.EncBinary()
		_ = yym200
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep201 := !z.EncBinary()
			yy2arr201 := z.EncBasicHandle().StructToArray
			var yyq201 [12]bool
			_, _, _ = yysep201, yyq201, yy2arr201
			const yyr201 bool = false
			yyq201[0] = x.GCEPersistentDisk != nil
			yyq201[1] = x.AWSElasticBlockStore != nil
			yyq201[2] = x.HostPath != nil
			yyq201[3] = x.Glusterfs != nil
			yyq201[4] = x.NFS != nil
			yyq201[5] = x.RBD != nil
			yyq201[6] = x.ISCSI != nil
			yyq201[7] = x.FlexVolume != nil
			yyq201[8] = x.Cinder != nil
			yyq201[9] = x.CephFS != nil
			yyq201[10] = x.FC != nil
			yyq201[11] = x.Flocker != nil
			var yynn201 int
			if yyr201 || yy2arr201 {
				r.EncodeArrayStart(12)
			} else {
				yynn201 = 0
				for _, b := range yyq201 {
					if b {
						yynn201++
					}
				}
				r.EncodeMapStart(yynn201)
				yynn201 = 0
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[0] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[1] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[2] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[3] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[4] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[5] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[6] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[7] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[8] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[9] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[10] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[11] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym214 := z.DecBinary()
	_ = yym214
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct215 := r.ContainerType()
		if yyct215 == codecSelferValueTypeMap1234 {
			yyl215 := r.ReadMapStart()
			if yyl215 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl215, d)
			}
		} else if yyct215 == codecSelferValueTypeArray1234 {
			yyl215 := r.ReadArrayStart()
			if yyl215 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl215, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys216Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys216Slc
	var yyhl216 bool = l >= 0
	for yyj216 := 0; ; yyj216++ {
		if yyhl216 {
			if yyj216 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys216Slc = r.DecodeBytes(yys216Slc, true, true)
		yys216 := string(yys216Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys216 {
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys216)
		} // end switch yys216
	} // end for yyj216
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj229 int
	var yyb229 bool
	var yyhl229 bool = l >= 0
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj229++
	if yyhl229 {
		yyb229 = yyj229 > l
	} else {
		yyb229 = r.CheckBreak()
	}
	if yyb229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	for {
		yyj229++
		if yyhl229 {
			yyb229 = yyj229 > l
		} else {
			yyb229 = r.CheckBreak()
		}
		if yyb229 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj229-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym242 := z.EncBinary()
		_ = yym242
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep243 := !z.EncBinary()
			yy2arr243 := z.EncBasicHandle().StructToArray
			var yyq243 [2]bool
			_, _, _ = yysep243, yyq243, yy2arr243
			const yyr243 bool = false
			yyq243[1] = x.ReadOnly != false
			var yynn243 int
			if yyr243 || yy2arr243 {
				r.EncodeArrayStart(2)
			} else {
				yynn243 = 1
				for _, b := range yyq243 {
					if b {
						yynn243++
					}
				}
				r.EncodeMapStart(yynn243)
				yynn243 = 0
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym245 := z.EncBinary()
				_ = yym245
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("claimName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym246 := z.EncBinary()
				_ = yym246
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq243[1] {
					yym248 := z.EncBinary()
					_ = yym248
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq243[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym249 := z.EncBinary()
					_ = yym249
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym250 := z.DecBinary()
	_ = yym250
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct251 := r.ContainerType()
		if yyct251 == codecSelferValueTypeMap1234 {
			yyl251 := r.ReadMapStart()
			if yyl251 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl251, d)
			}
		} else if yyct251 == codecSelferValueTypeArray1234 {
			yyl251 := r.ReadArrayStart()
			if yyl251 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl251, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys252Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys252Slc
	var yyhl252 bool = l >= 0
	for yyj252 := 0; ; yyj252++ {
		if yyhl252 {
			if yyj252 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys252Slc = r.DecodeBytes(yys252Slc, true, true)
		yys252 := string(yys252Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys252 {
		case "claimName":
			if r.TryDecodeAsNil() {
				x.ClaimName = ""
			} else {
				x.ClaimName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys252)
		} // end switch yys252
	} // end for yyj252
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj255 int
	var yyb255 bool
	var yyhl255 bool = l >= 0
	yyj255++
	if yyhl255 {
		yyb255 = yyj255 > l
	} else {
		yyb255 = r.CheckBreak()
	}
	if yyb255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClaimName = ""
	} else {
		x.ClaimName = string(r.DecodeString())
	}
	yyj255++
	if yyhl255 {
		yyb255 = yyj255 > l
	} else {
		yyb255 = r.CheckBreak()
	}
	if yyb255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj255++
		if yyhl255 {
			yyb255 = yyj255 > l
		} else {
			yyb255 = r.CheckBreak()
		}
		if yyb255 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj255-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym258 := z.EncBinary()
		_ = yym258
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep259 := !z.EncBinary()
			yy2arr259 := z.EncBasicHandle().StructToArray
			var yyq259 [5]bool
			_, _, _ = yysep259, yyq259, yy2arr259
			const yyr259 bool = false
			yyq259[0] = x.Kind != ""
			yyq259[1] = x.APIVersion != ""
			yyq259[2] = true
			yyq259[3] = true
			yyq259[4] = true
			var yynn259 int
			if yyr259 || yy2arr259 {
				r.EncodeArrayStart(5)
			} else {
				yynn259 = 0
				for _, b := range yyq259 {
					if b {
						yynn259++
					}
				}
				r.EncodeMapStart(yynn259)
				yynn259 = 0
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[0] {
					yym261 := z.EncBinary()
					_ = yym261
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq259[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym262 := z.EncBinary()
					_ = yym262
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[1] {
					yym264 := z.EncBinary()
					_ = yym264
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq259[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym265 := z.EncBinary()
					_ = yym265
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[2] {
					yy267 := &x.ObjectMeta
					yy267.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq259[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy268 := &x.ObjectMeta
					yy268.CodecEncodeSelf(e)
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[3] {
					yy270 := &x.Spec
					yy270.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq259[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy271 := &x.Spec
					yy271.CodecEncodeSelf(e)
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[4] {
					yy273 := &x.Status
					yy273.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq259[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy274 := &x.Status
					yy274.CodecEncodeSelf(e)
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym275 := z.DecBinary()
	_ = yym275
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct276 := r.ContainerType()
		if yyct276 == codecSelferValueTypeMap1234 {
			yyl276 := r.ReadMapStart()
			if yyl276 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl276, d)
			}
		} else if yyct276 == codecSelferValueTypeArray1234 {
			yyl276 := r.ReadArrayStart()
			if yyl276 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl276, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys277Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys277Slc
	var yyhl277 bool = l >= 0
	for yyj277 := 0; ; yyj277++ {
		if yyhl277 {
			if yyj277 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys277Slc = r.DecodeBytes(yys277Slc, true, true)
		yys277 := string(yys277Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys277 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv280 := &x.ObjectMeta
				yyv280.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeSpec{}
			} else {
				yyv281 := &x.Spec
				yyv281.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeStatus{}
			} else {
				yyv282 := &x.Status
				yyv282.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys277)
		} // end switch yys277
	} // end for yyj277
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj283 int
	var yyb283 bool
	var yyhl283 bool = l >= 0
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv286 := &x.ObjectMeta
		yyv286.CodecDecodeSelf(d)
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeSpec{}
	} else {
		yyv287 := &x.Spec
		yyv287.CodecDecodeSelf(d)
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeStatus{}
	} else {
		yyv288 := &x.Status
		yyv288.CodecDecodeSelf(d)
	}
	for {
		yyj283++
		if yyhl283 {
			yyb283 = yyj283 > l
		} else {
			yyb283 = r.CheckBreak()
		}
		if yyb283 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj283-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym289 := z.EncBinary()
		_ = yym289
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep290 := !z.EncBinary()
			yy2arr290 := z.EncBasicHandle().StructToArray
			var yyq290 [16]bool
			_, _, _ = yysep290, yyq290, yy2arr290
			const yyr290 bool = false
			yyq290[1] = x.PersistentVolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq290[2] = x.PersistentVolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq290[3] = x.PersistentVolumeSource.HostPath != nil && x.HostPath != nil
			yyq290[4] = x.PersistentVolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq290[5] = x.PersistentVolumeSource.NFS != nil && x.NFS != nil
			yyq290[6] = x.PersistentVolumeSource.RBD != nil && x.RBD != nil
			yyq290[7] = x.PersistentVolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq290[8] = x.PersistentVolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq290[9] = x.PersistentVolumeSource.Cinder != nil && x.Cinder != nil
			yyq290[10] = x.PersistentVolumeSource.CephFS != nil && x.CephFS != nil
			yyq290[11] = x.PersistentVolumeSource.FC != nil && x.FC != nil
			yyq290[12] = x.PersistentVolumeSource.Flocker != nil && x.Flocker != nil
			yyq290[13] = len(x.AccessModes) != 0
			yyq290[14] = x.ClaimRef != nil
			yyq290[15] = x.PersistentVolumeReclaimPolicy != ""
			var yynn290 int
			if yyr290 || yy2arr290 {
				r.EncodeArrayStart(16)
			} else {
				yynn290 = 1
				for _, b := range yyq290 {
					if b {
						yynn290++
					}
				}
				r.EncodeMapStart(yynn290)
				yynn290 = 0
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Capacity == nil {
					r.EncodeNil()
				} else {
					x.Capacity.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("capacity"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Capacity == nil {
					r.EncodeNil()
				} else {
					x.Capacity.CodecEncodeSelf(e)
				}
			}
			var yyn292 bool
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				yyn292 = true
				goto LABEL292
			}
		LABEL292:
			if yyr290 || yy2arr290 {
				if yyn292 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[1] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn292 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn293 bool
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				yyn293 = true
				goto LABEL293
			}
		LABEL293:
			if yyr290 || yy2arr290 {
				if yyn293 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[2] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn293 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn294 bool
			if x.PersistentVolumeSource.HostPath == nil {
				yyn294 = true
				goto LABEL294
			}
		LABEL294:
			if yyr290 || yy2arr290 {
				if yyn294 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[3] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn294 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn295 bool
			if x.PersistentVolumeSource.Glusterfs == nil {
				yyn295 = true
				goto LABEL295
			}
		LABEL295:
			if yyr290 || yy2arr290 {
				if yyn295 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[4] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn295 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn296 bool
			if x.PersistentVolumeSource.NFS == nil {
				yyn296 = true
				goto LABEL296
			}
		LABEL296:
			if yyr290 || yy2arr290 {
				if yyn296 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[5] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn296 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn297 bool
			if x.PersistentVolumeSource.RBD == nil {
				yyn297 = true
				goto LABEL297
			}
		LABEL297:
			if yyr290 || yy2arr290 {
				if yyn297 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[6] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn297 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn298 bool
			if x.PersistentVolumeSource.ISCSI == nil {
				yyn298 = true
				goto LABEL298
			}
		LABEL298:
			if yyr290 || yy2arr290 {
				if yyn298 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[7] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn298 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn299 bool
			if x.PersistentVolumeSource.FlexVolume == nil {
				yyn299 = true
				goto LABEL299
			}
		LABEL299:
			if yyr290 || yy2arr290 {
				if yyn299 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[8] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn299 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn300 bool
			if x.PersistentVolumeSource.Cinder == nil {
				yyn300 = true
				goto LABEL300
			}
		LABEL300:
			if yyr290 || yy2arr290 {
				if yyn300 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[9] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn300 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn301 bool
			if x.PersistentVolumeSource.CephFS == nil {
				yyn301 = true
				goto LABEL301
			}
		LABEL301:
			if yyr290 || yy2arr290 {
				if yyn301 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[10] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn301 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn302 bool
			if x.PersistentVolumeSource.FC == nil {
				yyn302 = true
				goto LABEL302
			}
		LABEL302:
			if yyr290 || yy2arr290 {
				if yyn302 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[11] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn302 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn303 bool
			if x.PersistentVolumeSource.Flocker == nil {
				yyn303 = true
				goto LABEL303
			}
		LABEL303:
			if yyr290 || yy2arr290 {
				if yyn303 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[12] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn303 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq290[13] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym305 := z.EncBinary()
						_ = yym305
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq290[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym306 := z.EncBinary()
						_ = yym306
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq290[14] {
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq290[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("claimRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq290[15] {
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq290[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeReclaimPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym309 := z.DecBinary()
	_ = yym309
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct310 := r.ContainerType()
		if yyct310 == codecSelferValueTypeMap1234 {
			yyl310 := r.ReadMapStart()
			if yyl310 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl310, d)
			}
		} else if yyct310 == codecSelferValueTypeArray1234 {
			yyl310 := r.ReadArrayStart()
			if yyl310 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl310, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys311Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys311Slc
	var yyhl311 bool = l >= 0
	for yyj311 := 0; ; yyj311++ {
		if yyhl311 {
			if yyj311 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys311Slc = r.DecodeBytes(yys311Slc, true, true)
		yys311 := string(yys311Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys311 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv312 := &x.Capacity
				yyv312.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if x.PersistentVolumeSource.HostPath == nil {
				x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.PersistentVolumeSource.Glusterfs == nil {
				x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.PersistentVolumeSource.NFS == nil {
				x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.PersistentVolumeSource.RBD == nil {
				x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.PersistentVolumeSource.ISCSI == nil {
				x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.PersistentVolumeSource.FlexVolume == nil {
				x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.PersistentVolumeSource.Cinder == nil {
				x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.PersistentVolumeSource.CephFS == nil {
				x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if x.PersistentVolumeSource.FC == nil {
				x.PersistentVolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.PersistentVolumeSource.Flocker == nil {
				x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv325 := &x.AccessModes
				yym326 := z.DecBinary()
				_ = yym326
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv325), d)
				}
			}
		case "claimRef":
			if r.TryDecodeAsNil() {
				if x.ClaimRef != nil {
					x.ClaimRef = nil
				}
			} else {
				if x.ClaimRef == nil {
					x.ClaimRef = new(ObjectReference)
				}
				x.ClaimRef.CodecDecodeSelf(d)
			}
		case "persistentVolumeReclaimPolicy":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeReclaimPolicy = ""
			} else {
				x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys311)
		} // end switch yys311
	} // end for yyj311
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj329 int
	var yyb329 bool
	var yyhl329 bool = l >= 0
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv330 := &x.Capacity
		yyv330.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.GCEPersistentDisk == nil {
		x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
		x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.HostPath == nil {
		x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Glusterfs == nil {
		x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.NFS == nil {
		x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.RBD == nil {
		x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ISCSI == nil {
		x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FlexVolume == nil {
		x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Cinder == nil {
		x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.CephFS == nil {
		x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FC == nil {
		x.PersistentVolumeSource.FC = new(FCVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Flocker == nil {
		x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv343 := &x.AccessModes
		yym344 := z.DecBinary()
		_ = yym344
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv343), d)
		}
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ClaimRef != nil {
			x.ClaimRef = nil
		}
	} else {
		if x.ClaimRef == nil {
			x.ClaimRef = new(ObjectReference)
		}
		x.ClaimRef.CodecDecodeSelf(d)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeReclaimPolicy = ""
	} else {
		x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
	}
	for {
		yyj329++
		if yyhl329 {
			yyb329 = yyj329 > l
		} else {
			yyb329 = r.CheckBreak()
		}
		if yyb329 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj329-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeReclaimPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym347 := z.EncBinary()
	_ = yym347
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeReclaimPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym348 := z.DecBinary()
	_ = yym348
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PersistentVolumeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym349 := z.EncBinary()
		_ = yym349
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep350 := !z.EncBinary()
			yy2arr350 := z.EncBasicHandle().StructToArray
			var yyq350 [3]bool
			_, _, _ = yysep350, yyq350, yy2arr350
			const yyr350 bool = false
			yyq350[0] = x.Phase != ""
			yyq350[1] = x.Message != ""
			yyq350[2] = x.Reason != ""
			var yynn350 int
			if yyr350 || yy2arr350 {
				r.EncodeArrayStart(3)
			} else {
				yynn350 = 0
				for _, b := range yyq350 {
					if b {
						yynn350++
					}
				}
				r.EncodeMapStart(yynn350)
				yynn350 = 0
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq350[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq350[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq350[1] {
					yym353 := z.EncBinary()
					_ = yym353
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq350[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq350[2] {
					yym356 := z.EncBinary()
					_ = yym356
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq350[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym357 := z.EncBinary()
					_ = yym357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym358 := z.DecBinary()
	_ = yym358
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct359 := r.ContainerType()
		if yyct359 == codecSelferValueTypeMap1234 {
			yyl359 := r.ReadMapStart()
			if yyl359 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl359, d)
			}
		} else if yyct359 == codecSelferValueTypeArray1234 {
			yyl359 := r.ReadArrayStart()
			if yyl359 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl359, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys360Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys360Slc
	var yyhl360 bool = l >= 0
	for yyj360 := 0; ; yyj360++ {
		if yyhl360 {
			if yyj360 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys360Slc = r.DecodeBytes(yys360Slc, true, true)
		yys360 := string(yys360Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys360 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumePhase(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys360)
		} // end switch yys360
	} // end for yyj360
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj364 int
	var yyb364 bool
	var yyhl364 bool = l >= 0
	yyj364++
	if yyhl364 {
		yyb364 = yyj364 > l
	} else {
		yyb364 = r.CheckBreak()
	}
	if yyb364 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumePhase(r.DecodeString())
	}
	yyj364++
	if yyhl364 {
		yyb364 = yyj364 > l
	} else {
		yyb364 = r.CheckBreak()
	}
	if yyb364 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj364++
	if yyhl364 {
		yyb364 = yyj364 > l
	} else {
		yyb364 = r.CheckBreak()
	}
	if yyb364 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	for {
		yyj364++
		if yyhl364 {
			yyb364 = yyj364 > l
		} else {
			yyb364 = r.CheckBreak()
		}
		if yyb364 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj364-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym368 := z.EncBinary()
		_ = yym368
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep369 := !z.EncBinary()
			yy2arr369 := z.EncBasicHandle().StructToArray
			var yyq369 [4]bool
			_, _, _ = yysep369, yyq369, yy2arr369
			const yyr369 bool = false
			yyq369[0] = x.Kind != ""
			yyq369[1] = x.APIVersion != ""
			yyq369[2] = true
			var yynn369 int
			if yyr369 || yy2arr369 {
				r.EncodeArrayStart(4)
			} else {
				yynn369 = 1
				for _, b := range yyq369 {
					if b {
						yynn369++
					}
				}
				r.EncodeMapStart(yynn369)
				yynn369 = 0
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq369[0] {
					yym371 := z.EncBinary()
					_ = yym371
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq369[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym372 := z.EncBinary()
					_ = yym372
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq369[1] {
					yym374 := z.EncBinary()
					_ = yym374
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq369[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym375 := z.EncBinary()
					_ = yym375
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq369[2] {
					yy377 := &x.ListMeta
					yym378 := z.EncBinary()
					_ = yym378
					if false {
					} else if z.HasExtensions() && z.EncExt(yy377) {
					} else {
						z.EncFallback(yy377)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq369[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy379 := &x.ListMeta
					yym380 := z.EncBinary()
					_ = yym380
					if false {
					} else if z.HasExtensions() && z.EncExt(yy379) {
					} else {
						z.EncFallback(yy379)
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym382 := z.EncBinary()
					_ = yym382
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym383 := z.EncBinary()
					_ = yym383
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym384 := z.DecBinary()
	_ = yym384
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct385 := r.ContainerType()
		if yyct385 == codecSelferValueTypeMap1234 {
			yyl385 := r.ReadMapStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl385, d)
			}
		} else if yyct385 == codecSelferValueTypeArray1234 {
			yyl385 := r.ReadArrayStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl385, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys386Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys386Slc
	var yyhl386 bool = l >= 0
	for yyj386 := 0; ; yyj386++ {
		if yyhl386 {
			if yyj386 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys386Slc = r.DecodeBytes(yys386Slc, true, true)
		yys386 := string(yys386Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys386 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv389 := &x.ListMeta
				yym390 := z.DecBinary()
				_ = yym390
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv389) {
				} else {
					z.DecFallback(yyv389, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv391 := &x.Items
				yym392 := z.DecBinary()
				_ = yym392
				if false {
				} else {
					h.decSlicePersistentVolume((*[]PersistentVolume)(yyv391), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys386)
		} // end switch yys386
	} // end for yyj386
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj393 int
	var yyb393 bool
	var yyhl393 bool = l >= 0
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv396 := &x.ListMeta
		yym397 := z.DecBinary()
		_ = yym397
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv396) {
		} else {
			z.DecFallback(yyv396, false)
		}
	}
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv398 := &x.Items
		yym399 := z.DecBinary()
		_ = yym399
		if false {
		} else {
			h.decSlicePersistentVolume((*[]PersistentVolume)(yyv398), d)
		}
	}
	for {
		yyj393++
		if yyhl393 {
			yyb393 = yyj393 > l
		} else {
			yyb393 = r.CheckBreak()
		}
		if yyb393 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj393-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaim) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym400 := z.EncBinary()
		_ = yym400
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep401 := !z.EncBinary()
			yy2arr401 := z.EncBasicHandle().StructToArray
			var yyq401 [5]bool
			_, _, _ = yysep401, yyq401, yy2arr401
			const yyr401 bool = false
			yyq401[0] = x.Kind != ""
			yyq401[1] = x.APIVersion != ""
			yyq401[2] = true
			yyq401[3] = true
			yyq401[4] = true
			var yynn401 int
			if yyr401 || yy2arr401 {
				r.EncodeArrayStart(5)
			} else {
				yynn401 = 0
				for _, b := range yyq401 {
					if b {
						yynn401++
					}
				}
				r.EncodeMapStart(yynn401)
				yynn401 = 0
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[0] {
					yym403 := z.EncBinary()
					_ = yym403
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq401[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym404 := z.EncBinary()
					_ = yym404
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[1] {
					yym406 := z.EncBinary()
					_ = yym406
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq401[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym407 := z.EncBinary()
					_ = yym407
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[2] {
					yy409 := &x.ObjectMeta
					yy409.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq401[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy410 := &x.ObjectMeta
					yy410.CodecEncodeSelf(e)
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[3] {
					yy412 := &x.Spec
					yy412.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq401[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy413 := &x.Spec
					yy413.CodecEncodeSelf(e)
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[4] {
					yy415 := &x.Status
					yy415.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq401[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy416 := &x.Status
					yy416.CodecEncodeSelf(e)
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaim) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym417 := z.DecBinary()
	_ = yym417
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct418 := r.ContainerType()
		if yyct418 == codecSelferValueTypeMap1234 {
			yyl418 := r.ReadMapStart()
			if yyl418 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl418, d)
			}
		} else if yyct418 == codecSelferValueTypeArray1234 {
			yyl418 := r.ReadArrayStart()
			if yyl418 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl418, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys419Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys419Slc
	var yyhl419 bool = l >= 0
	for yyj419 := 0; ; yyj419++ {
		if yyhl419 {
			if yyj419 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys419Slc = r.DecodeBytes(yys419Slc, true, true)
		yys419 := string(yys419Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys419 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv422 := &x.ObjectMeta
				yyv422.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeClaimSpec{}
			} else {
				yyv423 := &x.Spec
				yyv423.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeClaimStatus{}
			} else {
				yyv424 := &x.Status
				yyv424.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys419)
		} // end switch yys419
	} // end for yyj419
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj425 int
	var yyb425 bool
	var yyhl425 bool = l >= 0
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv428 := &x.ObjectMeta
		yyv428.CodecDecodeSelf(d)
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeClaimSpec{}
	} else {
		yyv429 := &x.Spec
		yyv429.CodecDecodeSelf(d)
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeClaimStatus{}
	} else {
		yyv430 := &x.Status
		yyv430.CodecDecodeSelf(d)
	}
	for {
		yyj425++
		if yyhl425 {
			yyb425 = yyj425 > l
		} else {
			yyb425 = r.CheckBreak()
		}
		if yyb425 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj425-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym431 := z.EncBinary()
		_ = yym431
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep432 := !z.EncBinary()
			yy2arr432 := z.EncBasicHandle().StructToArray
			var yyq432 [4]bool
			_, _, _ = yysep432, yyq432, yy2arr432
			const yyr432 bool = false
			yyq432[0] = x.Kind != ""
			yyq432[1] = x.APIVersion != ""
			yyq432[2] = true
			var yynn432 int
			if yyr432 || yy2arr432 {
				r.EncodeArrayStart(4)
			} else {
				yynn432 = 1
				for _, b := range yyq432 {
					if b {
						yynn432++
					}
				}
				r.EncodeMapStart(yynn432)
				yynn432 = 0
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq432[0] {
					yym434 := z.EncBinary()
					_ = yym434
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq432[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym435 := z.EncBinary()
					_ = yym435
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq432[1] {
					yym437 := z.EncBinary()
					_ = yym437
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq432[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym438 := z.EncBinary()
					_ = yym438
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq432[2] {
					yy440 := &x.ListMeta
					yym441 := z.EncBinary()
					_ = yym441
					if false {
					} else if z.HasExtensions() && z.EncExt(yy440) {
					} else {
						z.EncFallback(yy440)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq432[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy442 := &x.ListMeta
					yym443 := z.EncBinary()
					_ = yym443
					if false {
					} else if z.HasExtensions() && z.EncExt(yy442) {
					} else {
						z.EncFallback(yy442)
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym446 := z.EncBinary()
					_ = yym446
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym447 := z.DecBinary()
	_ = yym447
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct448 := r.ContainerType()
		if yyct448 == codecSelferValueTypeMap1234 {
			yyl448 := r.ReadMapStart()
			if yyl448 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl448, d)
			}
		} else if yyct448 == codecSelferValueTypeArray1234 {
			yyl448 := r.ReadArrayStart()
			if yyl448 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl448, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys449Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys449Slc
	var yyhl449 bool = l >= 0
	for yyj449 := 0; ; yyj449++ {
		if yyhl449 {
			if yyj449 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys449Slc = r.DecodeBytes(yys449Slc, true, true)
		yys449 := string(yys449Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys449 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv452 := &x.ListMeta
				yym453 := z.DecBinary()
				_ = yym453
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv452) {
				} else {
					z.DecFallback(yyv452, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv454 := &x.Items
				yym455 := z.DecBinary()
				_ = yym455
				if false {
				} else {
					h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv454), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys449)
		} // end switch yys449
	} // end for yyj449
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj456 int
	var yyb456 bool
	var yyhl456 bool = l >= 0
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv459 := &x.ListMeta
		yym460 := z.DecBinary()
		_ = yym460
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv459) {
		} else {
			z.DecFallback(yyv459, false)
		}
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv461 := &x.Items
		yym462 := z.DecBinary()
		_ = yym462
		if false {
		} else {
			h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv461), d)
		}
	}
	for {
		yyj456++
		if yyhl456 {
			yyb456 = yyj456 > l
		} else {
			yyb456 = r.CheckBreak()
		}
		if yyb456 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj456-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym463 := z.EncBinary()
		_ = yym463
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep464 := !z.EncBinary()
			yy2arr464 := z.EncBasicHandle().StructToArray
			var yyq464 [3]bool
			_, _, _ = yysep464, yyq464, yy2arr464
			const yyr464 bool = false
			yyq464[0] = len(x.AccessModes) != 0
			yyq464[1] = true
			yyq464[2] = x.VolumeName != ""
			var yynn464 int
			if yyr464 || yy2arr464 {
				r.EncodeArrayStart(3)
			} else {
				yynn464 = 0
				for _, b := range yyq464 {
					if b {
						yynn464++
					}
				}
				r.EncodeMapStart(yynn464)
				yynn464 = 0
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq464[0] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym466 := z.EncBinary()
						_ = yym466
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq464[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym467 := z.EncBinary()
						_ = yym467
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq464[1] {
					yy469 := &x.Resources
					yy469.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq464[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy470 := &x.Resources
					yy470.CodecEncodeSelf(e)
				}
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq464[2] {
					yym472 := z.EncBinary()
					_ = yym472
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq464[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym473 := z.EncBinary()
					_ = yym473
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym474 := z.DecBinary()
	_ = yym474
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct475 := r.ContainerType()
		if yyct475 == codecSelferValueTypeMap1234 {
			yyl475 := r.ReadMapStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl475, d)
			}
		} else if yyct475 == codecSelferValueTypeArray1234 {
			yyl475 := r.ReadArrayStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl475, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys476Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys476Slc
	var yyhl476 bool = l >= 0
	for yyj476 := 0; ; yyj476++ {
		if yyhl476 {
			if yyj476 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys476Slc = r.DecodeBytes(yys476Slc, true, true)
		yys476 := string(yys476Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys476 {
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv477 := &x.AccessModes
				yym478 := z.DecBinary()
				_ = yym478
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv477), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv479 := &x.Resources
				yyv479.CodecDecodeSelf(d)
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				x.VolumeName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys476)
		} // end switch yys476
	} // end for yyj476
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj481 int
	var yyb481 bool
	var yyhl481 bool = l >= 0
	yyj481++
	if yyhl481 {
		yyb481 = yyj481 > l
	} else {
		yyb481 = r.CheckBreak()
	}
	if yyb481 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv482 := &x.AccessModes
		yym483 := z.DecBinary()
		_ = yym483
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv482), d)
		}
	}
	yyj481++
	if yyhl481 {
		yyb481 = yyj481 > l
	} else {
		yyb481 = r.CheckBreak()
	}
	if yyb481 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv484 := &x.Resources
		yyv484.CodecDecodeSelf(d)
	}
	yyj481++
	if yyhl481 {
		yyb481 = yyj481 > l
	} else {
		yyb481 = r.CheckBreak()
	}
	if yyb481 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		x.VolumeName = string(r.DecodeString())
	}
	for {
		yyj481++
		if yyhl481 {
			yyb481 = yyj481 > l
		} else {
			yyb481 = r.CheckBreak()
		}
		if yyb481 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj481-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym486 := z.EncBinary()
		_ = yym486
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep487 := !z.EncBinary()
			yy2arr487 := z.EncBasicHandle().StructToArray
			var yyq487 [3]bool
			_, _, _ = yysep487, yyq487, yy2arr487
			const yyr487 bool = false
			yyq487[0] = x.Phase != ""
			yyq487[1] = len(x.AccessModes) != 0
			yyq487[2] = len(x.Capacity) != 0
			var yynn487 int
			if yyr487 || yy2arr487 {
				r.EncodeArrayStart(3)
			} else {
				yynn487 = 0
				for _, b := range yyq487 {
					if b {
						yynn487++
					}
				}
				r.EncodeMapStart(yynn487)
				yynn487 = 0
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq487[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq487[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq487[1] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym490 := z.EncBinary()
						_ = yym490
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq487[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym491 := z.EncBinary()
						_ = yym491
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq487[2] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq487[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym493 := z.DecBinary()
	_ = yym493
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct494 := r.ContainerType()
		if yyct494 == codecSelferValueTypeMap1234 {
			yyl494 := r.ReadMapStart()
			if yyl494 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl494, d)
			}
		} else if yyct494 == codecSelferValueTypeArray1234 {
			yyl494 := r.ReadArrayStart()
			if yyl494 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl494, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys495Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys495Slc
	var yyhl495 bool = l >= 0
	for yyj495 := 0; ; yyj495++ {
		if yyhl495 {
			if yyj495 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys495Slc = r.DecodeBytes(yys495Slc, true, true)
		yys495 := string(yys495Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys495 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv497 := &x.AccessModes
				yym498 := z.DecBinary()
				_ = yym498
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv497), d)
				}
			}
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv499 := &x.Capacity
				yyv499.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys495)
		} // end switch yys495
	} // end for yyj495
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj500 int
	var yyb500 bool
	var yyhl500 bool = l >= 0
	yyj500++
	if yyhl500 {
		yyb500 = yyj500 > l
	} else {
		yyb500 = r.CheckBreak()
	}
	if yyb500 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
	}
	yyj500++
	if yyhl500 {
		yyb500 = yyj500 > l
	} else {
		yyb500 = r.CheckBreak()
	}
	if yyb500 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv502 := &x.AccessModes
		yym503 := z.DecBinary()
		_ = yym503
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv502), d)
		}
	}
	yyj500++
	if yyhl500 {
		yyb500 = yyj500 > l
	} else {
		yyb500 = r.CheckBreak()
	}
	if yyb500 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv504 := &x.Capacity
		yyv504.CodecDecodeSelf(d)
	}
	for {
		yyj500++
		if yyhl500 {
			yyb500 = yyj500 > l
		} else {
			yyb500 = r.CheckBreak()
		}
		if yyb500 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj500-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeAccessMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym505 := z.EncBinary()
	_ = yym505
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeAccessMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym506 := z.DecBinary()
	_ = yym506
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym507 := z.EncBinary()
	_ = yym507
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym508 := z.DecBinary()
	_ = yym508
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumeClaimPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym509 := z.EncBinary()
	_ = yym509
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeClaimPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym510 := z.DecBinary()
	_ = yym510
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPathVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym511 := z.EncBinary()
		_ = yym511
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep512 := !z.EncBinary()
			yy2arr512 := z.EncBasicHandle().StructToArray
			var yyq512 [1]bool
			_, _, _ = yysep512, yyq512, yy2arr512
			const yyr512 bool = false
			var yynn512 int
			if yyr512 || yy2arr512 {
				r.EncodeArrayStart(1)
			} else {
				yynn512 = 1
				for _, b := range yyq512 {
					if b {
						yynn512++
					}
				}
				r.EncodeMapStart(yynn512)
				yynn512 = 0
			}
			if yyr512 || yy2arr512 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym514 := z.EncBinary()
				_ = yym514
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym515 := z.EncBinary()
				_ = yym515
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr512 || yy2arr512 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPathVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym516 := z.DecBinary()
	_ = yym516
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct517 := r.ContainerType()
		if yyct517 == codecSelferValueTypeMap1234 {
			yyl517 := r.ReadMapStart()
			if yyl517 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl517, d)
			}
		} else if yyct517 == codecSelferValueTypeArray1234 {
			yyl517 := r.ReadArrayStart()
			if yyl517 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl517, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPathVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys518Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys518Slc
	var yyhl518 bool = l >= 0
	for yyj518 := 0; ; yyj518++ {
		if yyhl518 {
			if yyj518 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys518Slc = r.DecodeBytes(yys518Slc, true, true)
		yys518 := string(yys518Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys518 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys518)
		} // end switch yys518
	} // end for yyj518
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPathVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj520 int
	var yyb520 bool
	var yyhl520 bool = l >= 0
	yyj520++
	if yyhl520 {
		yyb520 = yyj520 > l
	} else {
		yyb520 = r.CheckBreak()
	}
	if yyb520 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj520++
		if yyhl520 {
			yyb520 = yyj520 > l
		} else {
			yyb520 = r.CheckBreak()
		}
		if yyb520 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj520-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EmptyDirVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym522 := z.EncBinary()
		_ = yym522
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep523 := !z.EncBinary()
			yy2arr523 := z.EncBasicHandle().StructToArray
			var yyq523 [1]bool
			_, _, _ = yysep523, yyq523, yy2arr523
			const yyr523 bool = false
			yyq523[0] = x.Medium != ""
			var yynn523 int
			if yyr523 || yy2arr523 {
				r.EncodeArrayStart(1)
			} else {
				yynn523 = 0
				for _, b := range yyq523 {
					if b {
						yynn523++
					}
				}
				r.EncodeMapStart(yynn523)
				yynn523 = 0
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq523[0] {
					x.Medium.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq523[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("medium"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Medium.CodecEncodeSelf(e)
				}
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EmptyDirVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym525 := z.DecBinary()
	_ = yym525
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct526 := r.ContainerType()
		if yyct526 == codecSelferValueTypeMap1234 {
			yyl526 := r.ReadMapStart()
			if yyl526 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl526, d)
			}
		} else if yyct526 == codecSelferValueTypeArray1234 {
			yyl526 := r.ReadArrayStart()
			if yyl526 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl526, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys527Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys527Slc
	var yyhl527 bool = l >= 0
	for yyj527 := 0; ; yyj527++ {
		if yyhl527 {
			if yyj527 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys527Slc = r.DecodeBytes(yys527Slc, true, true)
		yys527 := string(yys527Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys527 {
		case "medium":
			if r.TryDecodeAsNil() {
				x.Medium = ""
			} else {
				x.Medium = StorageMedium(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys527)
		} // end switch yys527
	} // end for yyj527
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj529 int
	var yyb529 bool
	var yyhl529 bool = l >= 0
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Medium = ""
	} else {
		x.Medium = StorageMedium(r.DecodeString())
	}
	for {
		yyj529++
		if yyhl529 {
			yyb529 = yyj529 > l
		} else {
			yyb529 = r.CheckBreak()
		}
		if yyb529 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj529-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x StorageMedium) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym531 := z.EncBinary()
	_ = yym531
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *StorageMedium) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym532 := z.DecBinary()
	_ = yym532
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Protocol) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym533 := z.EncBinary()
	_ = yym533
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Protocol) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym534 := z.DecBinary()
	_ = yym534
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym535 := z.EncBinary()
		_ = yym535
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep536 := !z.EncBinary()
			yy2arr536 := z.EncBasicHandle().StructToArray
			var yyq536 [4]bool
			_, _, _ = yysep536, yyq536, yy2arr536
			const yyr536 bool = false
			yyq536[1] = x.FSType != ""
			yyq536[2] = x.Partition != 0
			yyq536[3] = x.ReadOnly != false
			var yynn536 int
			if yyr536 || yy2arr536 {
				r.EncodeArrayStart(4)
			} else {
				yynn536 = 1
				for _, b := range yyq536 {
					if b {
						yynn536++
					}
				}
				r.EncodeMapStart(yynn536)
				yynn536 = 0
			}
			if yyr536 || yy2arr536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym538 := z.EncBinary()
				_ = yym538
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym539 := z.EncBinary()
				_ = yym539
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			}
			if yyr536 || yy2arr536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq536[1] {
					yym541 := z.EncBinary()
					_ = yym541
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq536[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym542 := z.EncBinary()
					_ = yym542
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr536 || yy2arr536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq536[2] {
					yym544 := z.EncBinary()
					_ = yym544
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq536[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym545 := z.EncBinary()
					_ = yym545
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr536 || yy2arr536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq536[3] {
					yym547 := z.EncBinary()
					_ = yym547
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq536[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym548 := z.EncBinary()
					_ = yym548
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr536 || yy2arr536 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym549 := z.DecBinary()
	_ = yym549
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct550 := r.ContainerType()
		if yyct550 == codecSelferValueTypeMap1234 {
			yyl550 := r.ReadMapStart()
			if yyl550 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl550, d)
			}
		} else if yyct550 == codecSelferValueTypeArray1234 {
			yyl550 := r.ReadArrayStart()
			if yyl550 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl550, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys551Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys551Slc
	var yyhl551 bool = l >= 0
	for yyj551 := 0; ; yyj551++ {
		if yyhl551 {
			if yyj551 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys551Slc = r.DecodeBytes(yys551Slc, true, true)
		yys551 := string(yys551Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys551 {
		case "pdName":
			if r.TryDecodeAsNil() {
				x.PDName = ""
			} else {
				x.PDName = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys551)
		} // end switch yys551
	} // end for yyj551
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj556 int
	var yyb556 bool
	var yyhl556 bool = l >= 0
	yyj556++
	if yyhl556 {
		yyb556 = yyj556 > l
	} else {
		yyb556 = r.CheckBreak()
	}
	if yyb556 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PDName = ""
	} else {
		x.PDName = string(r.DecodeString())
	}
	yyj556++
	if yyhl556 {
		yyb556 = yyj556 > l
	} else {
		yyb556 = r.CheckBreak()
	}
	if yyb556 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj556++
	if yyhl556 {
		yyb556 = yyj556 > l
	} else {
		yyb556 = r.CheckBreak()
	}
	if yyb556 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj556++
	if yyhl556 {
		yyb556 = yyj556 > l
	} else {
		yyb556 = r.CheckBreak()
	}
	if yyb556 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj556++
		if yyhl556 {
			yyb556 = yyj556 > l
		} else {
			yyb556 = r.CheckBreak()
		}
		if yyb556 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj556-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ISCSIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym561 := z.EncBinary()
		_ = yym561
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep562 := !z.EncBinary()
			yy2arr562 := z.EncBasicHandle().StructToArray
			var yyq562 [6]bool
			_, _, _ = yysep562, yyq562, yy2arr562
			const yyr562 bool = false
			yyq562[0] = x.TargetPortal != ""
			yyq562[1] = x.IQN != ""
			yyq562[2] = x.Lun != 0
			yyq562[3] = x.ISCSIInterface != ""
			yyq562[4] = x.FSType != ""
			yyq562[5] = x.ReadOnly != false
			var yynn562 int
			if yyr562 || yy2arr562 {
				r.EncodeArrayStart(6)
			} else {
				yynn562 = 0
				for _, b := range yyq562 {
					if b {
						yynn562++
					}
				}
				r.EncodeMapStart(yynn562)
				yynn562 = 0
			}
			if yyr562 || yy2arr562 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq562[0] {
					yym564 := z.EncBinary()
					_ = yym564
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq562[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetPortal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym565 := z.EncBinary()
					_ = yym565
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
					}
				}
			}
			if yyr562 || yy2arr562 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq562[1] {
					yym567 := z.EncBinary()
					_ = yym567
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq562[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iqn"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym568 := z.EncBinary()
					_ = yym568
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
					}
				}
			}
			if yyr562 || yy2arr562 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq562[2] {
					yym570 := z.EncBinary()
					_ = yym570
					if false {
					} else {
						r.EncodeInt(int64(x.Lun))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq562[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lun"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym571 := z.EncBinary()
					_ = yym571
					if false {
					} else {
						r.EncodeInt(int64(x.Lun))
					}
				}
			}
			if yyr562 || yy2arr562 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq562[3] {
					yym573 := z.EncBinary()
					_ = yym573
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq562[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsiInterface"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym574 := z.EncBinary()
					_ = yym574
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				}
			}
			if yyr562 || yy2arr562 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq562[4] {
					yym576 := z.EncBinary()
					_ = yym576
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq562[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym577 := z.EncBinary()
					_ = yym577
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr562 || yy2arr562 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq562[5] {
					yym579 := z.EncBinary()
					_ = yym579
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq562[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym580 := z.EncBinary()
					_ = yym580
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr562 || yy2arr562 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ISCSIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym581 := z.DecBinary()
	_ = yym581
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct582 := r.ContainerType()
		if yyct582 == codecSelferValueTypeMap1234 {
			yyl582 := r.ReadMapStart()
			if yyl582 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl582, d)
			}
		} else if yyct582 == codecSelferValueTypeArray1234 {
			yyl582 := r.ReadArrayStart()
			if yyl582 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl582, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys583Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys583Slc
	var yyhl583 bool = l >= 0
	for yyj583 := 0; ; yyj583++ {
		if yyhl583 {
			if yyj583 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys583Slc = r.DecodeBytes(yys583Slc, true, true)
		yys583 := string(yys583Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys583 {
		case "targetPortal":
			if r.TryDecodeAsNil() {
				x.TargetPortal = ""
			} else {
				x.TargetPortal = string(r.DecodeString())
			}
		case "iqn":
			if r.TryDecodeAsNil() {
				x.IQN = ""
			} else {
				x.IQN = string(r.DecodeString())
			}
		case "lun":
			if r.TryDecodeAsNil() {
				x.Lun = 0
			} else {
				x.Lun = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "iscsiInterface":
			if r.TryDecodeAsNil() {
				x.ISCSIInterface = ""
			} else {
				x.ISCSIInterface = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys583)
		} // end switch yys583
	} // end for yyj583
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj590 int
	var yyb590 bool
	var yyhl590 bool = l >= 0
	yyj590++
	if yyhl590 {
		yyb590 = yyj590 > l
	} else {
		yyb590 = r.CheckBreak()
	}
	if yyb590 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPortal = ""
	} else {
		x.TargetPortal = string(r.DecodeString())
	}
	yyj590++
	if yyhl590 {
		yyb590 = yyj590 > l
	} else {
		yyb590 = r.CheckBreak()
	}
	if yyb590 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IQN = ""
	} else {
		x.IQN = string(r.DecodeString())
	}
	yyj590++
	if yyhl590 {
		yyb590 = yyj590 > l
	} else {
		yyb590 = r.CheckBreak()
	}
	if yyb590 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Lun = 0
	} else {
		x.Lun = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj590++
	if yyhl590 {
		yyb590 = yyj590 > l
	} else {
		yyb590 = r.CheckBreak()
	}
	if yyb590 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ISCSIInterface = ""
	} else {
		x.ISCSIInterface = string(r.DecodeString())
	}
	yyj590++
	if yyhl590 {
		yyb590 = yyj590 > l
	} else {
		yyb590 = r.CheckBreak()
	}
	if yyb590 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj590++
	if yyhl590 {
		yyb590 = yyj590 > l
	} else {
		yyb590 = r.CheckBreak()
	}
	if yyb590 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj590++
		if yyhl590 {
			yyb590 = yyj590 > l
		} else {
			yyb590 = r.CheckBreak()
		}
		if yyb590 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj590-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FCVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym597 := z.EncBinary()
		_ = yym597
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep598 := !z.EncBinary()
			yy2arr598 := z.EncBasicHandle().StructToArray
			var yyq598 [4]bool
			_, _, _ = yysep598, yyq598, yy2arr598
			const yyr598 bool = false
			yyq598[3] = x.ReadOnly != false
			var yynn598 int
			if yyr598 || yy2arr598 {
				r.EncodeArrayStart(4)
			} else {
				yynn598 = 3
				for _, b := range yyq598 {
					if b {
						yynn598++
					}
				}
				r.EncodeMapStart(yynn598)
				yynn598 = 0
			}
			if yyr598 || yy2arr598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym600 := z.EncBinary()
					_ = yym600
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetWWNs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym601 := z.EncBinary()
					_ = yym601
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			}
			if yyr598 || yy2arr598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy603 := *x.Lun
					yym604 := z.EncBinary()
					_ = yym604
					if false {
					} else {
						r.EncodeInt(int64(yy603))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy605 := *x.Lun
					yym606 := z.EncBinary()
					_ = yym606
					if false {
					} else {
						r.EncodeInt(int64(yy605))
					}
				}
			}
			if yyr598 || yy2arr598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym608 := z.EncBinary()
				_ = yym608
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym609 := z.EncBinary()
				_ = yym609
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			}
			if yyr598 || yy2arr598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq598[3] {
					yym611 := z.EncBinary()
					_ = yym611
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq598[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym612 := z.EncBinary()
					_ = yym612
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr598 || yy2arr598 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FCVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym613 := z.DecBinary()
	_ = yym613
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct614 := r.ContainerType()
		if yyct614 == codecSelferValueTypeMap1234 {
			yyl614 := r.ReadMapStart()
			if yyl614 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl614, d)
			}
		} else if yyct614 == codecSelferValueTypeArray1234 {
			yyl614 := r.ReadArrayStart()
			if yyl614 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl614, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FCVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys615Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys615Slc
	var yyhl615 bool = l >= 0
	for yyj615 := 0; ; yyj615++ {
		if yyhl615 {
			if yyj615 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys615Slc = r.DecodeBytes(yys615Slc, true, true)
		yys615 := string(yys615Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys615 {
		case "targetWWNs":
			if r.TryDecodeAsNil() {
				x.TargetWWNs = nil
			} else {
				yyv616 := &x.TargetWWNs
				yym617 := z.DecBinary()
				_ = yym617
				if false {
				} else {
					z.F.DecSliceStringX(yyv616, false, d)
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				if x.Lun != nil {
					x.Lun = nil
				}
			} else {
				if x.Lun == nil {
					x.Lun = new(int)
				}
				yym619 := z.DecBinary()
				_ = yym619
				if false {
				} else {
					*((*int)(x.Lun)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys615)
		} // end switch yys615
	} // end for yyj615
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FCVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj622 int
	var yyb622 bool
	var yyhl622 bool = l >= 0
	yyj622++
	if yyhl622 {
		yyb622 = yyj622 > l
	} else {
		yyb622 = r.CheckBreak()
	}
	if yyb622 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetWWNs = nil
	} else {
		yyv623 := &x.TargetWWNs
		yym624 := z.DecBinary()
		_ = yym624
		if false {
		} else {
			z.F.DecSliceStringX(yyv623, false, d)
		}
	}
	yyj622++
	if yyhl622 {
		yyb622 = yyj622 > l
	} else {
		yyb622 = r.CheckBreak()
	}
	if yyb622 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lun != nil {
			x.Lun = nil
		}
	} else {
		if x.Lun == nil {
			x.Lun = new(int)
		}
		yym626 := z.DecBinary()
		_ = yym626
		if false {
		} else {
			*((*int)(x.Lun)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	yyj622++
	if yyhl622 {
		yyb622 = yyj622 > l
	} else {
		yyb622 = r.CheckBreak()
	}
	if yyb622 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj622++
	if yyhl622 {
		yyb622 = yyj622 > l
	} else {
		yyb622 = r.CheckBreak()
	}
	if yyb622 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj622++
		if yyhl622 {
			yyb622 = yyj622 > l
		} else {
			yyb622 = r.CheckBreak()
		}
		if yyb622 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj622-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlexVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym629 := z.EncBinary()
		_ = yym629
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep630 := !z.EncBinary()
			yy2arr630 := z.EncBasicHandle().StructToArray
			var yyq630 [5]bool
			_, _, _ = yysep630, yyq630, yy2arr630
			const yyr630 bool = false
			yyq630[1] = x.FSType != ""
			yyq630[2] = x.SecretRef != nil
			yyq630[3] = x.ReadOnly != false
			yyq630[4] = len(x.Options) != 0
			var yynn630 int
			if yyr630 || yy2arr630 {
				r.EncodeArrayStart(5)
			} else {
				yynn630 = 1
				for _, b := range yyq630 {
					if b {
						yynn630++
					}
				}
				r.EncodeMapStart(yynn630)
				yynn630 = 0
			}
			if yyr630 || yy2arr630 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym632 := z.EncBinary()
				_ = yym632
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("driver"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym633 := z.EncBinary()
				_ = yym633
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			}
			if yyr630 || yy2arr630 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq630[1] {
					yym635 := z.EncBinary()
					_ = yym635
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq630[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym636 := z.EncBinary()
					_ = yym636
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr630 || yy2arr630 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq630[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq630[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr630 || yy2arr630 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq630[3] {
					yym639 := z.EncBinary()
					_ = yym639
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq630[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym640 := z.EncBinary()
					_ = yym640
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr630 || yy2arr630 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq630[4] {
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym642 := z.EncBinary()
						_ = yym642
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq630[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("options"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym643 := z.EncBinary()
						_ = yym643
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				}
			}
			if yyr630 || yy2arr630 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlexVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym644 := z.DecBinary()
	_ = yym644
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct645 := r.ContainerType()
		if yyct645 == codecSelferValueTypeMap1234 {
			yyl645 := r.ReadMapStart()
			if yyl645 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl645, d)
			}
		} else if yyct645 == codecSelferValueTypeArray1234 {
			yyl645 := r.ReadArrayStart()
			if yyl645 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl645, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlexVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys646Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys646Slc
	var yyhl646 bool = l >= 0
	for yyj646 := 0; ; yyj646++ {
		if yyhl646 {
			if yyj646 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys646Slc = r.DecodeBytes(yys646Slc, true, true)
		yys646 := string(yys646Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys646 {
		case "driver":
			if r.TryDecodeAsNil() {
				x.Driver = ""
			} else {
				x.Driver = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "options":
			if r.TryDecodeAsNil() {
				x.Options = nil
			} else {
				yyv651 := &x.Options
				yym652 := z.DecBinary()
				_ = yym652
				if false {
				} else {
					z.F.DecMapStringStringX(yyv651, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys646)
		} // end switch yys646
	} // end for yyj646
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlexVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj653 int
	var yyb653 bool
	var yyhl653 bool = l >= 0
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Driver = ""
	} else {
		x.Driver = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Options = nil
	} else {
		yyv658 := &x.Options
		yym659 := z.DecBinary()
		_ = yym659
		if false {
		} else {
			z.F.DecMapStringStringX(yyv658, false, d)
		}
	}
	for {
		yyj653++
		if yyhl653 {
			yyb653 = yyj653 > l
		} else {
			yyb653 = r.CheckBreak()
		}
		if yyb653 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj653-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym660 := z.EncBinary()
		_ = yym660
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep661 := !z.EncBinary()
			yy2arr661 := z.EncBasicHandle().StructToArray
			var yyq661 [4]bool
			_, _, _ = yysep661, yyq661, yy2arr661
			const yyr661 bool = false
			yyq661[1] = x.FSType != ""
			yyq661[2] = x.Partition != 0
			yyq661[3] = x.ReadOnly != false
			var yynn661 int
			if yyr661 || yy2arr661 {
				r.EncodeArrayStart(4)
			} else {
				yynn661 = 1
				for _, b := range yyq661 {
					if b {
						yynn661++
					}
				}
				r.EncodeMapStart(yynn661)
				yynn661 = 0
			}
			if yyr661 || yy2arr661 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym663 := z.EncBinary()
				_ = yym663
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym664 := z.EncBinary()
				_ = yym664
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr661 || yy2arr661 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq661[1] {
					yym666 := z.EncBinary()
					_ = yym666
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq661[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym667 := z.EncBinary()
					_ = yym667
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr661 || yy2arr661 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq661[2] {
					yym669 := z.EncBinary()
					_ = yym669
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq661[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym670 := z.EncBinary()
					_ = yym670
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr661 || yy2arr661 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq661[3] {
					yym672 := z.EncBinary()
					_ = yym672
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq661[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym673 := z.EncBinary()
					_ = yym673
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr661 || yy2arr661 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym674 := z.DecBinary()
	_ = yym674
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct675 := r.ContainerType()
		if yyct675 == codecSelferValueTypeMap1234 {
			yyl675 := r.ReadMapStart()
			if yyl675 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl675, d)
			}
		} else if yyct675 == codecSelferValueTypeArray1234 {
			yyl675 := r.ReadArrayStart()
			if yyl675 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl675, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys676Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys676Slc
	var yyhl676 bool = l >= 0
	for yyj676 := 0; ; yyj676++ {
		if yyhl676 {
			if yyj676 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys676Slc = r.DecodeBytes(yys676Slc, true, true)
		yys676 := string(yys676Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys676 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys676)
		} // end switch yys676
	} // end for yyj676
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj681 int
	var yyb681 bool
	var yyhl681 bool = l >= 0
	yyj681++
	if yyhl681 {
		yyb681 = yyj681 > l
	} else {
		yyb681 = r.CheckBreak()
	}
	if yyb681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj681++
	if yyhl681 {
		yyb681 = yyj681 > l
	} else {
		yyb681 = r.CheckBreak()
	}
	if yyb681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj681++
	if yyhl681 {
		yyb681 = yyj681 > l
	} else {
		yyb681 = r.CheckBreak()
	}
	if yyb681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj681++
	if yyhl681 {
		yyb681 = yyj681 > l
	} else {
		yyb681 = r.CheckBreak()
	}
	if yyb681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj681++
		if yyhl681 {
			yyb681 = yyj681 > l
		} else {
			yyb681 = r.CheckBreak()
		}
		if yyb681 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj681-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GitRepoVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym686 := z.EncBinary()
		_ = yym686
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep687 := !z.EncBinary()
			yy2arr687 := z.EncBasicHandle().StructToArray
			var yyq687 [3]bool
			_, _, _ = yysep687, yyq687, yy2arr687
			const yyr687 bool = false
			yyq687[1] = x.Revision != ""
			yyq687[2] = x.Directory != ""
			var yynn687 int
			if yyr687 || yy2arr687 {
				r.EncodeArrayStart(3)
			} else {
				yynn687 = 1
				for _, b := range yyq687 {
					if b {
						yynn687++
					}
				}
				r.EncodeMapStart(yynn687)
				yynn687 = 0
			}
			if yyr687 || yy2arr687 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym689 := z.EncBinary()
				_ = yym689
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("repository"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym690 := z.EncBinary()
				_ = yym690
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			}
			if yyr687 || yy2arr687 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq687[1] {
					yym692 := z.EncBinary()
					_ = yym692
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq687[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym693 := z.EncBinary()
					_ = yym693
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				}
			}
			if yyr687 || yy2arr687 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq687[2] {
					yym695 := z.EncBinary()
					_ = yym695
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq687[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("directory"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym696 := z.EncBinary()
					_ = yym696
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				}
			}
			if yyr687 || yy2arr687 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GitRepoVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym697 := z.DecBinary()
	_ = yym697
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct698 := r.ContainerType()
		if yyct698 == codecSelferValueTypeMap1234 {
			yyl698 := r.ReadMapStart()
			if yyl698 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl698, d)
			}
		} else if yyct698 == codecSelferValueTypeArray1234 {
			yyl698 := r.ReadArrayStart()
			if yyl698 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl698, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys699Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys699Slc
	var yyhl699 bool = l >= 0
	for yyj699 := 0; ; yyj699++ {
		if yyhl699 {
			if yyj699 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys699Slc = r.DecodeBytes(yys699Slc, true, true)
		yys699 := string(yys699Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys699 {
		case "repository":
			if r.TryDecodeAsNil() {
				x.Repository = ""
			} else {
				x.Repository = string(r.DecodeString())
			}
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = ""
			} else {
				x.Revision = string(r.DecodeString())
			}
		case "directory":
			if r.TryDecodeAsNil() {
				x.Directory = ""
			} else {
				x.Directory = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys699)
		} // end switch yys699
	} // end for yyj699
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj703 int
	var yyb703 bool
	var yyhl703 bool = l >= 0
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Repository = ""
	} else {
		x.Repository = string(r.DecodeString())
	}
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = ""
	} else {
		x.Revision = string(r.DecodeString())
	}
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Directory = ""
	} else {
		x.Directory = string(r.DecodeString())
	}
	for {
		yyj703++
		if yyhl703 {
			yyb703 = yyj703 > l
		} else {
			yyb703 = r.CheckBreak()
		}
		if yyb703 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj703-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym707 := z.EncBinary()
		_ = yym707
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep708 := !z.EncBinary()
			yy2arr708 := z.EncBasicHandle().StructToArray
			var yyq708 [1]bool
			_, _, _ = yysep708, yyq708, yy2arr708
			const yyr708 bool = false
			var yynn708 int
			if yyr708 || yy2arr708 {
				r.EncodeArrayStart(1)
			} else {
				yynn708 = 1
				for _, b := range yyq708 {
					if b {
						yynn708++
					}
				}
				r.EncodeMapStart(yynn708)
				yynn708 = 0
			}
			if yyr708 || yy2arr708 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym710 := z.EncBinary()
				_ = yym710
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym711 := z.EncBinary()
				_ = yym711
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			}
			if yyr708 || yy2arr708 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym712 := z.DecBinary()
	_ = yym712
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct713 := r.ContainerType()
		if yyct713 == codecSelferValueTypeMap1234 {
			yyl713 := r.ReadMapStart()
			if yyl713 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl713, d)
			}
		} else if yyct713 == codecSelferValueTypeArray1234 {
			yyl713 := r.ReadArrayStart()
			if yyl713 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl713, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys714Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys714Slc
	var yyhl714 bool = l >= 0
	for yyj714 := 0; ; yyj714++ {
		if yyhl714 {
			if yyj714 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys714Slc = r.DecodeBytes(yys714Slc, true, true)
		yys714 := string(yys714Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys714 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys714)
		} // end switch yys714
	} // end for yyj714
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj716 int
	var yyb716 bool
	var yyhl716 bool = l >= 0
	yyj716++
	if yyhl716 {
		yyb716 = yyj716 > l
	} else {
		yyb716 = r.CheckBreak()
	}
	if yyb716 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	for {
		yyj716++
		if yyhl716 {
			yyb716 = yyj716 > l
		} else {
			yyb716 = r.CheckBreak()
		}
		if yyb716 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj716-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym718 := z.EncBinary()
		_ = yym718
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep719 := !z.EncBinary()
			yy2arr719 := z.EncBasicHandle().StructToArray
			var yyq719 [3]bool
			_, _, _ = yysep719, yyq719, yy2arr719
			const yyr719 bool = false
			yyq719[2] = x.ReadOnly != false
			var yynn719 int
			if yyr719 || yy2arr719 {
				r.EncodeArrayStart(3)
			} else {
				yynn719 = 2
				for _, b := range yyq719 {
					if b {
						yynn719++
					}
				}
				r.EncodeMapStart(yynn719)
				yynn719 = 0
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym721 := z.EncBinary()
				_ = yym721
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("server"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym722 := z.EncBinary()
				_ = yym722
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym724 := z.EncBinary()
				_ = yym724
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym725 := z.EncBinary()
				_ = yym725
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq719[2] {
					yym727 := z.EncBinary()
					_ = yym727
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq719[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym728 := z.EncBinary()
					_ = yym728
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym729 := z.DecBinary()
	_ = yym729
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct730 := r.ContainerType()
		if yyct730 == codecSelferValueTypeMap1234 {
			yyl730 := r.ReadMapStart()
			if yyl730 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl730, d)
			}
		} else if yyct730 == codecSelferValueTypeArray1234 {
			yyl730 := r.ReadArrayStart()
			if yyl730 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl730, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys731Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys731Slc
	var yyhl731 bool = l >= 0
	for yyj731 := 0; ; yyj731++ {
		if yyhl731 {
			if yyj731 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys731Slc = r.DecodeBytes(yys731Slc, true, true)
		yys731 := string(yys731Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys731 {
		case "server":
			if r.TryDecodeAsNil() {
				x.Server = ""
			} else {
				x.Server = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys731)
		} // end switch yys731
	} // end for yyj731
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj735 int
	var yyb735 bool
	var yyhl735 bool = l >= 0
	yyj735++
	if yyhl735 {
		yyb735 = yyj735 > l
	} else {
		yyb735 = r.CheckBreak()
	}
	if yyb735 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Server = ""
	} else {
		x.Server = string(r.DecodeString())
	}
	yyj735++
	if yyhl735 {
		yyb735 = yyj735 > l
	} else {
		yyb735 = r.CheckBreak()
	}
	if yyb735 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj735++
	if yyhl735 {
		yyb735 = yyj735 > l
	} else {
		yyb735 = r.CheckBreak()
	}
	if yyb735 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj735++
		if yyhl735 {
			yyb735 = yyj735 > l
		} else {
			yyb735 = r.CheckBreak()
		}
		if yyb735 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj735-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GlusterfsVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym739 := z.EncBinary()
		_ = yym739
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep740 := !z.EncBinary()
			yy2arr740 := z.EncBasicHandle().StructToArray
			var yyq740 [3]bool
			_, _, _ = yysep740, yyq740, yy2arr740
			const yyr740 bool = false
			yyq740[2] = x.ReadOnly != false
			var yynn740 int
			if yyr740 || yy2arr740 {
				r.EncodeArrayStart(3)
			} else {
				yynn740 = 2
				for _, b := range yyq740 {
					if b {
						yynn740++
					}
				}
				r.EncodeMapStart(yynn740)
				yynn740 = 0
			}
			if yyr740 || yy2arr740 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym742 := z.EncBinary()
				_ = yym742
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("endpoints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym743 := z.EncBinary()
				_ = yym743
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			}
			if yyr740 || yy2arr740 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym745 := z.EncBinary()
				_ = yym745
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym746 := z.EncBinary()
				_ = yym746
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr740 || yy2arr740 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq740[2] {
					yym748 := z.EncBinary()
					_ = yym748
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq740[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym749 := z.EncBinary()
					_ = yym749
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr740 || yy2arr740 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GlusterfsVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym750 := z.DecBinary()
	_ = yym750
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct751 := r.ContainerType()
		if yyct751 == codecSelferValueTypeMap1234 {
			yyl751 := r.ReadMapStart()
			if yyl751 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl751, d)
			}
		} else if yyct751 == codecSelferValueTypeArray1234 {
			yyl751 := r.ReadArrayStart()
			if yyl751 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl751, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys752Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys752Slc
	var yyhl752 bool = l >= 0
	for yyj752 := 0; ; yyj752++ {
		if yyhl752 {
			if yyj752 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys752Slc = r.DecodeBytes(yys752Slc, true, true)
		yys752 := string(yys752Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys752 {
		case "endpoints":
			if r.TryDecodeAsNil() {
				x.EndpointsName = ""
			} else {
				x.EndpointsName = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys752)
		} // end switch yys752
	} // end for yyj752
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj756 int
	var yyb756 bool
	var yyhl756 bool = l >= 0
	yyj756++
	if yyhl756 {
		yyb756 = yyj756 > l
	} else {
		yyb756 = r.CheckBreak()
	}
	if yyb756 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EndpointsName = ""
	} else {
		x.EndpointsName = string(r.DecodeString())
	}
	yyj756++
	if yyhl756 {
		yyb756 = yyj756 > l
	} else {
		yyb756 = r.CheckBreak()
	}
	if yyb756 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj756++
	if yyhl756 {
		yyb756 = yyj756 > l
	} else {
		yyb756 = r.CheckBreak()
	}
	if yyb756 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj756++
		if yyhl756 {
			yyb756 = yyj756 > l
		} else {
			yyb756 = r.CheckBreak()
		}
		if yyb756 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj756-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RBDVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym760 := z.EncBinary()
		_ = yym760
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep761 := !z.EncBinary()
			yy2arr761 := z.EncBasicHandle().StructToArray
			var yyq761 [8]bool
			_, _, _ = yysep761, yyq761, yy2arr761
			const yyr761 bool = false
			yyq761[2] = x.FSType != ""
			yyq761[7] = x.ReadOnly != false
			var yynn761 int
			if yyr761 || yy2arr761 {
				r.EncodeArrayStart(8)
			} else {
				yynn761 = 6
				for _, b := range yyq761 {
					if b {
						yynn761++
					}
				}
				r.EncodeMapStart(yynn761)
				yynn761 = 0
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym763 := z.EncBinary()
					_ = yym763
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym764 := z.EncBinary()
					_ = yym764
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym766 := z.EncBinary()
				_ = yym766
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym767 := z.EncBinary()
				_ = yym767
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq761[2] {
					yym769 := z.EncBinary()
					_ = yym769
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq761[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym770 := z.EncBinary()
					_ = yym770
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym772 := z.EncBinary()
				_ = yym772
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pool"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym773 := z.EncBinary()
				_ = yym773
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym775 := z.EncBinary()
				_ = yym775
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("user"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym776 := z.EncBinary()
				_ = yym776
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym778 := z.EncBinary()
				_ = yym778
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("keyring"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym779 := z.EncBinary()
				_ = yym779
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SecretRef == nil {
					r.EncodeNil()
				} else {
					x.SecretRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SecretRef == nil {
					r.EncodeNil()
				} else {
					x.SecretRef.CodecEncodeSelf(e)
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq761[7] {
					yym782 := z.EncBinary()
					_ = yym782
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq761[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym783 := z.EncBinary()
					_ = yym783
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr761 || yy2arr761 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RBDVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym784 := z.DecBinary()
	_ = yym784
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct785 := r.ContainerType()
		if yyct785 == codecSelferValueTypeMap1234 {
			yyl785 := r.ReadMapStart()
			if yyl785 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl785, d)
			}
		} else if yyct785 == codecSelferValueTypeArray1234 {
			yyl785 := r.ReadArrayStart()
			if yyl785 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl785, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RBDVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys786Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys786Slc
	var yyhl786 bool = l >= 0
	for yyj786 := 0; ; yyj786++ {
		if yyhl786 {
			if yyj786 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys786Slc = r.DecodeBytes(yys786Slc, true, true)
		yys786 := string(yys786Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys786 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.CephMonitors = nil
			} else {
				yyv787 := &x.CephMonitors
				yym788 := z.DecBinary()
				_ = yym788
				if false {
				} else {
					z.F.DecSliceStringX(yyv787, false, d)
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.RBDImage = ""
			} else {
				x.RBDImage = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "pool":
			if r.TryDecodeAsNil() {
				x.RBDPool = ""
			} else {
				x.RBDPool = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.RadosUser = ""
			} else {
				x.RadosUser = string(r.DecodeString())
			}
		case "keyring":
			if r.TryDecodeAsNil() {
				x.Keyring = ""
			} else {
				x.Keyring = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys786)
		} // end switch yys786
	} // end for yyj786
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RBDVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj796 int
	var yyb796 bool
	var yyhl796 bool = l >= 0
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CephMonitors = nil
	} else {
		yyv797 := &x.CephMonitors
		yym798 := z.DecBinary()
		_ = yym798
		if false {
		} else {
			z.F.DecSliceStringX(yyv797, false, d)
		}
	}
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDImage = ""
	} else {
		x.RBDImage = string(r.DecodeString())
	}
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDPool = ""
	} else {
		x.RBDPool = string(r.DecodeString())
	}
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RadosUser = ""
	} else {
		x.RadosUser = string(r.DecodeString())
	}
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Keyring = ""
	} else {
		x.Keyring = string(r.DecodeString())
	}
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj796++
	if yyhl796 {
		yyb796 = yyj796 > l
	} else {
		yyb796 = r.CheckBreak()
	}
	if yyb796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj796++
		if yyhl796 {
			yyb796 = yyj796 > l
		} else {
			yyb796 = r.CheckBreak()
		}
		if yyb796 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj796-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CinderVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym806 := z.EncBinary()
		_ = yym806
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep807 := !z.EncBinary()
			yy2arr807 := z.EncBasicHandle().StructToArray
			var yyq807 [3]bool
			_, _, _ = yysep807, yyq807, yy2arr807
			const yyr807 bool = false
			yyq807[1] = x.FSType != ""
			yyq807[2] = x.ReadOnly != false
			var yynn807 int
			if yyr807 || yy2arr807 {
				r.EncodeArrayStart(3)
			} else {
				yynn807 = 1
				for _, b := range yyq807 {
					if b {
						yynn807++
					}
				}
				r.EncodeMapStart(yynn807)
				yynn807 = 0
			}
			if yyr807 || yy2arr807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym809 := z.EncBinary()
				_ = yym809
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym810 := z.EncBinary()
				_ = yym810
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr807 || yy2arr807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq807[1] {
					yym812 := z.EncBinary()
					_ = yym812
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq807[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym813 := z.EncBinary()
					_ = yym813
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr807 || yy2arr807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq807[2] {
					yym815 := z.EncBinary()
					_ = yym815
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq807[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym816 := z.EncBinary()
					_ = yym816
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr807 || yy2arr807 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CinderVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym817 := z.DecBinary()
	_ = yym817
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct818 := r.ContainerType()
		if yyct818 == codecSelferValueTypeMap1234 {
			yyl818 := r.ReadMapStart()
			if yyl818 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl818, d)
			}
		} else if yyct818 == codecSelferValueTypeArray1234 {
			yyl818 := r.ReadArrayStart()
			if yyl818 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl818, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CinderVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys819Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys819Slc
	var yyhl819 bool = l >= 0
	for yyj819 := 0; ; yyj819++ {
		if yyhl819 {
			if yyj819 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys819Slc = r.DecodeBytes(yys819Slc, true, true)
		yys819 := string(yys819Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys819 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys819)
		} // end switch yys819
	} // end for yyj819
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CinderVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj823 int
	var yyb823 bool
	var yyhl823 bool = l >= 0
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj823++
		if yyhl823 {
			yyb823 = yyj823 > l
		} else {
			yyb823 = r.CheckBreak()
		}
		if yyb823 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj823-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CephFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym827 := z.EncBinary()
		_ = yym827
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep828 := !z.EncBinary()
			yy2arr828 := z.EncBasicHandle().StructToArray
			var yyq828 [5]bool
			_, _, _ = yysep828, yyq828, yy2arr828
			const yyr828 bool = false
			yyq828[1] = x.User != ""
			yyq828[2] = x.SecretFile != ""
			yyq828[3] = x.SecretRef != nil
			yyq828[4] = x.ReadOnly != false
			var yynn828 int
			if yyr828 || yy2arr828 {
				r.EncodeArrayStart(5)
			} else {
				yynn828 = 1
				for _, b := range yyq828 {
					if b {
						yynn828++
					}
				}
				r.EncodeMapStart(yynn828)
				yynn828 = 0
			}
			if yyr828 || yy2arr828 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym830 := z.EncBinary()
					_ = yym830
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym831 := z.EncBinary()
					_ = yym831
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			}
			if yyr828 || yy2arr828 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq828[1] {
					yym833 := z.EncBinary()
					_ = yym833
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq828[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym834 := z.EncBinary()
					_ = yym834
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr828 || yy2arr828 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq828[2] {
					yym836 := z.EncBinary()
					_ = yym836
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq828[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym837 := z.EncBinary()
					_ = yym837
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				}
			}
			if yyr828 || yy2arr828 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq828[3] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq828[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr828 || yy2arr828 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq828[4] {
					yym840 := z.EncBinary()
					_ = yym840
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq828[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym841 := z.EncBinary()
					_ = yym841
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr828 || yy2arr828 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CephFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym842 := z.DecBinary()
	_ = yym842
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct843 := r.ContainerType()
		if yyct843 == codecSelferValueTypeMap1234 {
			yyl843 := r.ReadMapStart()
			if yyl843 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl843, d)
			}
		} else if yyct843 == codecSelferValueTypeArray1234 {
			yyl843 := r.ReadArrayStart()
			if yyl843 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl843, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CephFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys844Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys844Slc
	var yyhl844 bool = l >= 0
	for yyj844 := 0; ; yyj844++ {
		if yyhl844 {
			if yyj844 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys844Slc = r.DecodeBytes(yys844Slc, true, true)
		yys844 := string(yys844Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys844 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.Monitors = nil
			} else {
				yyv845 := &x.Monitors
				yym846 := z.DecBinary()
				_ = yym846
				if false {
				} else {
					z.F.DecSliceStringX(yyv845, false, d)
				}
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "secretFile":
			if r.TryDecodeAsNil() {
				x.SecretFile = ""
			} else {
				x.SecretFile = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys844)
		} // end switch yys844
	} // end for yyj844
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CephFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj851 int
	var yyb851 bool
	var yyhl851 bool = l >= 0
	yyj851++
	if yyhl851 {
		yyb851 = yyj851 > l
	} else {
		yyb851 = r.CheckBreak()
	}
	if yyb851 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Monitors = nil
	} else {
		yyv852 := &x.Monitors
		yym853 := z.DecBinary()
		_ = yym853
		if false {
		} else {
			z.F.DecSliceStringX(yyv852, false, d)
		}
	}
	yyj851++
	if yyhl851 {
		yyb851 = yyj851 > l
	} else {
		yyb851 = r.CheckBreak()
	}
	if yyb851 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj851++
	if yyhl851 {
		yyb851 = yyj851 > l
	} else {
		yyb851 = r.CheckBreak()
	}
	if yyb851 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretFile = ""
	} else {
		x.SecretFile = string(r.DecodeString())
	}
	yyj851++
	if yyhl851 {
		yyb851 = yyj851 > l
	} else {
		yyb851 = r.CheckBreak()
	}
	if yyb851 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj851++
	if yyhl851 {
		yyb851 = yyj851 > l
	} else {
		yyb851 = r.CheckBreak()
	}
	if yyb851 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj851++
		if yyhl851 {
			yyb851 = yyj851 > l
		} else {
			yyb851 = r.CheckBreak()
		}
		if yyb851 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj851-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlockerVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym858 := z.EncBinary()
		_ = yym858
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep859 := !z.EncBinary()
			yy2arr859 := z.EncBasicHandle().StructToArray
			var yyq859 [1]bool
			_, _, _ = yysep859, yyq859, yy2arr859
			const yyr859 bool = false
			var yynn859 int
			if yyr859 || yy2arr859 {
				r.EncodeArrayStart(1)
			} else {
				yynn859 = 1
				for _, b := range yyq859 {
					if b {
						yynn859++
					}
				}
				r.EncodeMapStart(yynn859)
				yynn859 = 0
			}
			if yyr859 || yy2arr859 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym861 := z.EncBinary()
				_ = yym861
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("datasetName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym862 := z.EncBinary()
				_ = yym862
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			}
			if yyr859 || yy2arr859 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlockerVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym863 := z.DecBinary()
	_ = yym863
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct864 := r.ContainerType()
		if yyct864 == codecSelferValueTypeMap1234 {
			yyl864 := r.ReadMapStart()
			if yyl864 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl864, d)
			}
		} else if yyct864 == codecSelferValueTypeArray1234 {
			yyl864 := r.ReadArrayStart()
			if yyl864 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl864, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlockerVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys865Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys865Slc
	var yyhl865 bool = l >= 0
	for yyj865 := 0; ; yyj865++ {
		if yyhl865 {
			if yyj865 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys865Slc = r.DecodeBytes(yys865Slc, true, true)
		yys865 := string(yys865Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys865 {
		case "datasetName":
			if r.TryDecodeAsNil() {
				x.DatasetName = ""
			} else {
				x.DatasetName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys865)
		} // end switch yys865
	} // end for yyj865
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlockerVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj867 int
	var yyb867 bool
	var yyhl867 bool = l >= 0
	yyj867++
	if yyhl867 {
		yyb867 = yyj867 > l
	} else {
		yyb867 = r.CheckBreak()
	}
	if yyb867 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetName = ""
	} else {
		x.DatasetName = string(r.DecodeString())
	}
	for {
		yyj867++
		if yyhl867 {
			yyb867 = yyj867 > l
		} else {
			yyb867 = r.CheckBreak()
		}
		if yyb867 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj867-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DownwardAPIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym869 := z.EncBinary()
		_ = yym869
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep870 := !z.EncBinary()
			yy2arr870 := z.EncBasicHandle().StructToArray
			var yyq870 [1]bool
			_, _, _ = yysep870, yyq870, yy2arr870
			const yyr870 bool = false
			yyq870[0] = len(x.Items) != 0
			var yynn870 int
			if yyr870 || yy2arr870 {
				r.EncodeArrayStart(1)
			} else {
				yynn870 = 0
				for _, b := range yyq870 {
					if b {
						yynn870++
					}
				}
				r.EncodeMapStart(yynn870)
				yynn870 = 0
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq870[0] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym872 := z.EncBinary()
						_ = yym872
						if false {
						} else {
							h.encSliceDownwardAPIVolumeFile(([]DownwardAPIVolumeFile)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq870[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym873 := z.EncBinary()
						_ = yym873
						if false {
						} else {
							h.encSliceDownwardAPIVolumeFile(([]DownwardAPIVolumeFile)(x.Items), e)
						}
					}
				}
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DownwardAPIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym874 := z.DecBinary()
	_ = yym874
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct875 := r.ContainerType()
		if yyct875 == codecSelferValueTypeMap1234 {
			yyl875 := r.ReadMapStart()
			if yyl875 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl875, d)
			}
		} else if yyct875 == codecSelferValueTypeArray1234 {
			yyl875 := r.ReadArrayStart()
			if yyl875 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl875, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DownwardAPIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys876Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys876Slc
	var yyhl876 bool = l >= 0
	for yyj876 := 0; ; yyj876++ {
		if yyhl876 {
			if yyj876 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys876Slc = r.DecodeBytes(yys876Slc, true, true)
		yys876 := string(yys876Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys876 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv877 := &x.Items
				yym878 := z.DecBinary()
				_ = yym878
				if false {
				} else {
					h.decSliceDownwardAPIVolumeFile((*[]DownwardAPIVolumeFile)(yyv877), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys876)
		} // end switch yys876
	} // end for yyj876
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DownwardAPIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj879 int
	var yyb879 bool
	var yyhl879 bool = l >= 0
	yyj879++
	if yyhl879 {
		yyb879 = yyj879 > l
	} else {
		yyb879 = r.CheckBreak()
	}
	if yyb879 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv880 := &x.Items
		yym881 := z.DecBinary()
		_ = yym881
		if false {
		} else {
			h.decSliceDownwardAPIVolumeFile((*[]DownwardAPIVolumeFile)(yyv880), d)
		}
	}
	for {
		yyj879++
		if yyhl879 {
			yyb879 = yyj879 > l
		} else {
			yyb879 = r.CheckBreak()
		}
		if yyb879 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj879-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DownwardAPIVolumeFile) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym882 := z.EncBinary()
		_ = yym882
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep883 := !z.EncBinary()
			yy2arr883 := z.EncBasicHandle().StructToArray
			var yyq883 [2]bool
			_, _, _ = yysep883, yyq883, yy2arr883
			const yyr883 bool = false
			var yynn883 int
			if yyr883 || yy2arr883 {
				r.EncodeArrayStart(2)
			} else {
				yynn883 = 2
				for _, b := range yyq883 {
					if b {
						yynn883++
					}
				}
				r.EncodeMapStart(yynn883)
				yynn883 = 0
			}
			if yyr883 || yy2arr883 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym885 := z.EncBinary()
				_ = yym885
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym886 := z.EncBinary()
				_ = yym886
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr883 || yy2arr883 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy888 := &x.FieldRef
				yy888.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy889 := &x.FieldRef
				yy889.CodecEncodeSelf(e)
			}
			if yyr883 || yy2arr883 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DownwardAPIVolumeFile) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym890 := z.DecBinary()
	_ = yym890
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct891 := r.ContainerType()
		if yyct891 == codecSelferValueTypeMap1234 {
			yyl891 := r.ReadMapStart()
			if yyl891 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl891, d)
			}
		} else if yyct891 == codecSelferValueTypeArray1234 {
			yyl891 := r.ReadArrayStart()
			if yyl891 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl891, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DownwardAPIVolumeFile) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys892Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys892Slc
	var yyhl892 bool = l >= 0
	for yyj892 := 0; ; yyj892++ {
		if yyhl892 {
			if yyj892 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys892Slc = r.DecodeBytes(yys892Slc, true, true)
		yys892 := string(yys892Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys892 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "fieldRef":
			if r.TryDecodeAsNil() {
				x.FieldRef = ObjectFieldSelector{}
			} else {
				yyv894 := &x.FieldRef
				yyv894.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys892)
		} // end switch yys892
	} // end for yyj892
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DownwardAPIVolumeFile) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj895 int
	var yyb895 bool
	var yyhl895 bool = l >= 0
	yyj895++
	if yyhl895 {
		yyb895 = yyj895 > l
	} else {
		yyb895 = r.CheckBreak()
	}
	if yyb895 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj895++
	if yyhl895 {
		yyb895 = yyj895 > l
	} else {
		yyb895 = r.CheckBreak()
	}
	if yyb895 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldRef = ObjectFieldSelector{}
	} else {
		yyv897 := &x.FieldRef
		yyv897.CodecDecodeSelf(d)
	}
	for {
		yyj895++
		if yyhl895 {
			yyb895 = yyj895 > l
		} else {
			yyb895 = r.CheckBreak()
		}
		if yyb895 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj895-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym898 := z.EncBinary()
		_ = yym898
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep899 := !z.EncBinary()
			yy2arr899 := z.EncBasicHandle().StructToArray
			var yyq899 [5]bool
			_, _, _ = yysep899, yyq899, yy2arr899
			const yyr899 bool = false
			yyq899[0] = x.Name != ""
			yyq899[1] = x.HostPort != 0
			yyq899[3] = x.Protocol != ""
			yyq899[4] = x.HostIP != ""
			var yynn899 int
			if yyr899 || yy2arr899 {
				r.EncodeArrayStart(5)
			} else {
				yynn899 = 1
				for _, b := range yyq899 {
					if b {
						yynn899++
					}
				}
				r.EncodeMapStart(yynn899)
				yynn899 = 0
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq899[0] {
					yym901 := z.EncBinary()
					_ = yym901
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq899[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym902 := z.EncBinary()
					_ = yym902
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq899[1] {
					yym904 := z.EncBinary()
					_ = yym904
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq899[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym905 := z.EncBinary()
					_ = yym905
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym907 := z.EncBinary()
				_ = yym907
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym908 := z.EncBinary()
				_ = yym908
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq899[3] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq899[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq899[4] {
					yym911 := z.EncBinary()
					_ = yym911
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq899[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym912 := z.EncBinary()
					_ = yym912
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym913 := z.DecBinary()
	_ = yym913
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct914 := r.ContainerType()
		if yyct914 == codecSelferValueTypeMap1234 {
			yyl914 := r.ReadMapStart()
			if yyl914 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl914, d)
			}
		} else if yyct914 == codecSelferValueTypeArray1234 {
			yyl914 := r.ReadArrayStart()
			if yyl914 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl914, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys915Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys915Slc
	var yyhl915 bool = l >= 0
	for yyj915 := 0; ; yyj915++ {
		if yyhl915 {
			if yyj915 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys915Slc = r.DecodeBytes(yys915Slc, true, true)
		yys915 := string(yys915Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys915 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPort":
			if r.TryDecodeAsNil() {
				x.HostPort = 0
			} else {
				x.HostPort = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "containerPort":
			if r.TryDecodeAsNil() {
				x.ContainerPort = 0
			} else {
				x.ContainerPort = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys915)
		} // end switch yys915
	} // end for yyj915
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj921 int
	var yyb921 bool
	var yyhl921 bool = l >= 0
	yyj921++
	if yyhl921 {
		yyb921 = yyj921 > l
	} else {
		yyb921 = r.CheckBreak()
	}
	if yyb921 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj921++
	if yyhl921 {
		yyb921 = yyj921 > l
	} else {
		yyb921 = r.CheckBreak()
	}
	if yyb921 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPort = 0
	} else {
		x.HostPort = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj921++
	if yyhl921 {
		yyb921 = yyj921 > l
	} else {
		yyb921 = r.CheckBreak()
	}
	if yyb921 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerPort = 0
	} else {
		x.ContainerPort = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj921++
	if yyhl921 {
		yyb921 = yyj921 > l
	} else {
		yyb921 = r.CheckBreak()
	}
	if yyb921 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj921++
	if yyhl921 {
		yyb921 = yyj921 > l
	} else {
		yyb921 = r.CheckBreak()
	}
	if yyb921 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	for {
		yyj921++
		if yyhl921 {
			yyb921 = yyj921 > l
		} else {
			yyb921 = r.CheckBreak()
		}
		if yyb921 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj921-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeMount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym927 := z.EncBinary()
		_ = yym927
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep928 := !z.EncBinary()
			yy2arr928 := z.EncBasicHandle().StructToArray
			var yyq928 [3]bool
			_, _, _ = yysep928, yyq928, yy2arr928
			const yyr928 bool = false
			yyq928[1] = x.ReadOnly != false
			var yynn928 int
			if yyr928 || yy2arr928 {
				r.EncodeArrayStart(3)
			} else {
				yynn928 = 2
				for _, b := range yyq928 {
					if b {
						yynn928++
					}
				}
				r.EncodeMapStart(yynn928)
				yynn928 = 0
			}
			if yyr928 || yy2arr928 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym930 := z.EncBinary()
				_ = yym930
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym931 := z.EncBinary()
				_ = yym931
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr928 || yy2arr928 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq928[1] {
					yym933 := z.EncBinary()
					_ = yym933
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq928[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym934 := z.EncBinary()
					_ = yym934
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr928 || yy2arr928 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym936 := z.EncBinary()
				_ = yym936
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mountPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym937 := z.EncBinary()
				_ = yym937
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			}
			if yyr928 || yy2arr928 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeMount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym938 := z.DecBinary()
	_ = yym938
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct939 := r.ContainerType()
		if yyct939 == codecSelferValueTypeMap1234 {
			yyl939 := r.ReadMapStart()
			if yyl939 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl939, d)
			}
		} else if yyct939 == codecSelferValueTypeArray1234 {
			yyl939 := r.ReadArrayStart()
			if yyl939 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl939, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeMount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys940Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys940Slc
	var yyhl940 bool = l >= 0
	for yyj940 := 0; ; yyj940++ {
		if yyhl940 {
			if yyj940 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys940Slc = r.DecodeBytes(yys940Slc, true, true)
		yys940 := string(yys940Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys940 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "mountPath":
			if r.TryDecodeAsNil() {
				x.MountPath = ""
			} else {
				x.MountPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys940)
		} // end switch yys940
	} // end for yyj940
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeMount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj944 int
	var yyb944 bool
	var yyhl944 bool = l >= 0
	yyj944++
	if yyhl944 {
		yyb944 = yyj944 > l
	} else {
		yyb944 = r.CheckBreak()
	}
	if yyb944 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj944++
	if yyhl944 {
		yyb944 = yyj944 > l
	} else {
		yyb944 = r.CheckBreak()
	}
	if yyb944 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj944++
	if yyhl944 {
		yyb944 = yyj944 > l
	} else {
		yyb944 = r.CheckBreak()
	}
	if yyb944 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MountPath = ""
	} else {
		x.MountPath = string(r.DecodeString())
	}
	for {
		yyj944++
		if yyhl944 {
			yyb944 = yyj944 > l
		} else {
			yyb944 = r.CheckBreak()
		}
		if yyb944 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj944-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVar) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym948 := z.EncBinary()
		_ = yym948
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep949 := !z.EncBinary()
			yy2arr949 := z.EncBasicHandle().StructToArray
			var yyq949 [3]bool
			_, _, _ = yysep949, yyq949, yy2arr949
			const yyr949 bool = false
			yyq949[1] = x.Value != ""
			yyq949[2] = x.ValueFrom != nil
			var yynn949 int
			if yyr949 || yy2arr949 {
				r.EncodeArrayStart(3)
			} else {
				yynn949 = 1
				for _, b := range yyq949 {
					if b {
						yynn949++
					}
				}
				r.EncodeMapStart(yynn949)
				yynn949 = 0
			}
			if yyr949 || yy2arr949 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym951 := z.EncBinary()
				_ = yym951
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym952 := z.EncBinary()
				_ = yym952
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr949 || yy2arr949 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq949[1] {
					yym954 := z.EncBinary()
					_ = yym954
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq949[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym955 := z.EncBinary()
					_ = yym955
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr949 || yy2arr949 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq949[2] {
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq949[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("valueFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				}
			}
			if yyr949 || yy2arr949 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVar) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym957 := z.DecBinary()
	_ = yym957
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct958 := r.ContainerType()
		if yyct958 == codecSelferValueTypeMap1234 {
			yyl958 := r.ReadMapStart()
			if yyl958 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl958, d)
			}
		} else if yyct958 == codecSelferValueTypeArray1234 {
			yyl958 := r.ReadArrayStart()
			if yyl958 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl958, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVar) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys959Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys959Slc
	var yyhl959 bool = l >= 0
	for yyj959 := 0; ; yyj959++ {
		if yyhl959 {
			if yyj959 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys959Slc = r.DecodeBytes(yys959Slc, true, true)
		yys959 := string(yys959Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys959 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "valueFrom":
			if r.TryDecodeAsNil() {
				if x.ValueFrom != nil {
					x.ValueFrom = nil
				}
			} else {
				if x.ValueFrom == nil {
					x.ValueFrom = new(EnvVarSource)
				}
				x.ValueFrom.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys959)
		} // end switch yys959
	} // end for yyj959
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVar) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj963 int
	var yyb963 bool
	var yyhl963 bool = l >= 0
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ValueFrom != nil {
			x.ValueFrom = nil
		}
	} else {
		if x.ValueFrom == nil {
			x.ValueFrom = new(EnvVarSource)
		}
		x.ValueFrom.CodecDecodeSelf(d)
	}
	for {
		yyj963++
		if yyhl963 {
			yyb963 = yyj963 > l
		} else {
			yyb963 = r.CheckBreak()
		}
		if yyb963 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj963-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVarSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym967 := z.EncBinary()
		_ = yym967
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep968 := !z.EncBinary()
			yy2arr968 := z.EncBasicHandle().StructToArray
			var yyq968 [1]bool
			_, _, _ = yysep968, yyq968, yy2arr968
			const yyr968 bool = false
			var yynn968 int
			if yyr968 || yy2arr968 {
				r.EncodeArrayStart(1)
			} else {
				yynn968 = 1
				for _, b := range yyq968 {
					if b {
						yynn968++
					}
				}
				r.EncodeMapStart(yynn968)
				yynn968 = 0
			}
			if yyr968 || yy2arr968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.FieldRef == nil {
					r.EncodeNil()
				} else {
					x.FieldRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.FieldRef == nil {
					r.EncodeNil()
				} else {
					x.FieldRef.CodecEncodeSelf(e)
				}
			}
			if yyr968 || yy2arr968 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVarSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym970 := z.DecBinary()
	_ = yym970
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct971 := r.ContainerType()
		if yyct971 == codecSelferValueTypeMap1234 {
			yyl971 := r.ReadMapStart()
			if yyl971 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl971, d)
			}
		} else if yyct971 == codecSelferValueTypeArray1234 {
			yyl971 := r.ReadArrayStart()
			if yyl971 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl971, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVarSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys972Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys972Slc
	var yyhl972 bool = l >= 0
	for yyj972 := 0; ; yyj972++ {
		if yyhl972 {
			if yyj972 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys972Slc = r.DecodeBytes(yys972Slc, true, true)
		yys972 := string(yys972Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys972 {
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys972)
		} // end switch yys972
	} // end for yyj972
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVarSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj974 int
	var yyb974 bool
	var yyhl974 bool = l >= 0
	yyj974++
	if yyhl974 {
		yyb974 = yyj974 > l
	} else {
		yyb974 = r.CheckBreak()
	}
	if yyb974 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	for {
		yyj974++
		if yyhl974 {
			yyb974 = yyj974 > l
		} else {
			yyb974 = r.CheckBreak()
		}
		if yyb974 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj974-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym976 := z.EncBinary()
		_ = yym976
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep977 := !z.EncBinary()
			yy2arr977 := z.EncBasicHandle().StructToArray
			var yyq977 [2]bool
			_, _, _ = yysep977, yyq977, yy2arr977
			const yyr977 bool = false
			var yynn977 int
			if yyr977 || yy2arr977 {
				r.EncodeArrayStart(2)
			} else {
				yynn977 = 2
				for _, b := range yyq977 {
					if b {
						yynn977++
					}
				}
				r.EncodeMapStart(yynn977)
				yynn977 = 0
			}
			if yyr977 || yy2arr977 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym979 := z.EncBinary()
				_ = yym979
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym980 := z.EncBinary()
				_ = yym980
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
				}
			}
			if yyr977 || yy2arr977 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym982 := z.EncBinary()
				_ = yym982
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym983 := z.EncBinary()
				_ = yym983
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			}
			if yyr977 || yy2arr977 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym984 := z.DecBinary()
	_ = yym984
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct985 := r.ContainerType()
		if yyct985 == codecSelferValueTypeMap1234 {
			yyl985 := r.ReadMapStart()
			if yyl985 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl985, d)
			}
		} else if yyct985 == codecSelferValueTypeArray1234 {
			yyl985 := r.ReadArrayStart()
			if yyl985 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl985, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys986Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys986Slc
	var yyhl986 bool = l >= 0
	for yyj986 := 0; ; yyj986++ {
		if yyhl986 {
			if yyj986 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys986Slc = r.DecodeBytes(yys986Slc, true, true)
		yys986 := string(yys986Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys986 {
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys986)
		} // end switch yys986
	} // end for yyj986
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj989 int
	var yyb989 bool
	var yyhl989 bool = l >= 0
	yyj989++
	if yyhl989 {
		yyb989 = yyj989 > l
	} else {
		yyb989 = r.CheckBreak()
	}
	if yyb989 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj989++
	if yyhl989 {
		yyb989 = yyj989 > l
	} else {
		yyb989 = r.CheckBreak()
	}
	if yyb989 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj989++
		if yyhl989 {
			yyb989 = yyj989 > l
		} else {
			yyb989 = r.CheckBreak()
		}
		if yyb989 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj989-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPGetAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym992 := z.EncBinary()
		_ = yym992
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep993 := !z.EncBinary()
			yy2arr993 := z.EncBasicHandle().StructToArray
			var yyq993 [4]bool
			_, _, _ = yysep993, yyq993, yy2arr993
			const yyr993 bool = false
			yyq993[0] = x.Path != ""
			yyq993[1] = true
			yyq993[2] = x.Host != ""
			yyq993[3] = x.Scheme != ""
			var yynn993 int
			if yyr993 || yy2arr993 {
				r.EncodeArrayStart(4)
			} else {
				yynn993 = 0
				for _, b := range yyq993 {
					if b {
						yynn993++
					}
				}
				r.EncodeMapStart(yynn993)
				yynn993 = 0
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq993[0] {
					yym995 := z.EncBinary()
					_ = yym995
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq993[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym996 := z.EncBinary()
					_ = yym996
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq993[1] {
					yy998 := &x.Port
					yym999 := z.EncBinary()
					_ = yym999
					if false {
					} else if z.HasExtensions() && z.EncExt(yy998) {
					} else if !yym999 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy998)
					} else {
						z.EncFallback(yy998)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq993[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1000 := &x.Port
					yym1001 := z.EncBinary()
					_ = yym1001
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1000) {
					} else if !yym1001 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1000)
					} else {
						z.EncFallback(yy1000)
					}
				}
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq993[2] {
					yym1003 := z.EncBinary()
					_ = yym1003
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq993[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1004 := z.EncBinary()
					_ = yym1004
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq993[3] {
					x.Scheme.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq993[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scheme"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Scheme.CodecEncodeSelf(e)
				}
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPGetAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1006 := z.DecBinary()
	_ = yym1006
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1007 := r.ContainerType()
		if yyct1007 == codecSelferValueTypeMap1234 {
			yyl1007 := r.ReadMapStart()
			if yyl1007 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1007, d)
			}
		} else if yyct1007 == codecSelferValueTypeArray1234 {
			yyl1007 := r.ReadArrayStart()
			if yyl1007 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1007, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPGetAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1008Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1008Slc
	var yyhl1008 bool = l >= 0
	for yyj1008 := 0; ; yyj1008++ {
		if yyhl1008 {
			if yyj1008 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1008Slc = r.DecodeBytes(yys1008Slc, true, true)
		yys1008 := string(yys1008Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1008 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg5_intstr.IntOrString{}
			} else {
				yyv1010 := &x.Port
				yym1011 := z.DecBinary()
				_ = yym1011
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1010) {
				} else if !yym1011 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1010)
				} else {
					z.DecFallback(yyv1010, false)
				}
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "scheme":
			if r.TryDecodeAsNil() {
				x.Scheme = ""
			} else {
				x.Scheme = URIScheme(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1008)
		} // end switch yys1008
	} // end for yyj1008
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPGetAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1014 int
	var yyb1014 bool
	var yyhl1014 bool = l >= 0
	yyj1014++
	if yyhl1014 {
		yyb1014 = yyj1014 > l
	} else {
		yyb1014 = r.CheckBreak()
	}
	if yyb1014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1014++
	if yyhl1014 {
		yyb1014 = yyj1014 > l
	} else {
		yyb1014 = r.CheckBreak()
	}
	if yyb1014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg5_intstr.IntOrString{}
	} else {
		yyv1016 := &x.Port
		yym1017 := z.DecBinary()
		_ = yym1017
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1016) {
		} else if !yym1017 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1016)
		} else {
			z.DecFallback(yyv1016, false)
		}
	}
	yyj1014++
	if yyhl1014 {
		yyb1014 = yyj1014 > l
	} else {
		yyb1014 = r.CheckBreak()
	}
	if yyb1014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	yyj1014++
	if yyhl1014 {
		yyb1014 = yyj1014 > l
	} else {
		yyb1014 = r.CheckBreak()
	}
	if yyb1014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Scheme = ""
	} else {
		x.Scheme = URIScheme(r.DecodeString())
	}
	for {
		yyj1014++
		if yyhl1014 {
			yyb1014 = yyj1014 > l
		} else {
			yyb1014 = r.CheckBreak()
		}
		if yyb1014 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1014-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x URIScheme) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1020 := z.EncBinary()
	_ = yym1020
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *URIScheme) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1021 := z.DecBinary()
	_ = yym1021
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *TCPSocketAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1022 := z.EncBinary()
		_ = yym1022
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1023 := !z.EncBinary()
			yy2arr1023 := z.EncBasicHandle().StructToArray
			var yyq1023 [1]bool
			_, _, _ = yysep1023, yyq1023, yy2arr1023
			const yyr1023 bool = false
			yyq1023[0] = true
			var yynn1023 int
			if yyr1023 || yy2arr1023 {
				r.EncodeArrayStart(1)
			} else {
				yynn1023 = 0
				for _, b := range yyq1023 {
					if b {
						yynn1023++
					}
				}
				r.EncodeMapStart(yynn1023)
				yynn1023 = 0
			}
			if yyr1023 || yy2arr1023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1023[0] {
					yy1025 := &x.Port
					yym1026 := z.EncBinary()
					_ = yym1026
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1025) {
					} else if !yym1026 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1025)
					} else {
						z.EncFallback(yy1025)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1023[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1027 := &x.Port
					yym1028 := z.EncBinary()
					_ = yym1028
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1027) {
					} else if !yym1028 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1027)
					} else {
						z.EncFallback(yy1027)
					}
				}
			}
			if yyr1023 || yy2arr1023 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TCPSocketAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1029 := z.DecBinary()
	_ = yym1029
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1030 := r.ContainerType()
		if yyct1030 == codecSelferValueTypeMap1234 {
			yyl1030 := r.ReadMapStart()
			if yyl1030 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1030, d)
			}
		} else if yyct1030 == codecSelferValueTypeArray1234 {
			yyl1030 := r.ReadArrayStart()
			if yyl1030 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1030, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TCPSocketAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1031Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1031Slc
	var yyhl1031 bool = l >= 0
	for yyj1031 := 0; ; yyj1031++ {
		if yyhl1031 {
			if yyj1031 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1031Slc = r.DecodeBytes(yys1031Slc, true, true)
		yys1031 := string(yys1031Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1031 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg5_intstr.IntOrString{}
			} else {
				yyv1032 := &x.Port
				yym1033 := z.DecBinary()
				_ = yym1033
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1032) {
				} else if !yym1033 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1032)
				} else {
					z.DecFallback(yyv1032, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1031)
		} // end switch yys1031
	} // end for yyj1031
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TCPSocketAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1034 int
	var yyb1034 bool
	var yyhl1034 bool = l >= 0
	yyj1034++
	if yyhl1034 {
		yyb1034 = yyj1034 > l
	} else {
		yyb1034 = r.CheckBreak()
	}
	if yyb1034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg5_intstr.IntOrString{}
	} else {
		yyv1035 := &x.Port
		yym1036 := z.DecBinary()
		_ = yym1036
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1035) {
		} else if !yym1036 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1035)
		} else {
			z.DecFallback(yyv1035, false)
		}
	}
	for {
		yyj1034++
		if yyhl1034 {
			yyb1034 = yyj1034 > l
		} else {
			yyb1034 = r.CheckBreak()
		}
		if yyb1034 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1034-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExecAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1037 := z.EncBinary()
		_ = yym1037
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1038 := !z.EncBinary()
			yy2arr1038 := z.EncBasicHandle().StructToArray
			var yyq1038 [1]bool
			_, _, _ = yysep1038, yyq1038, yy2arr1038
			const yyr1038 bool = false
			yyq1038[0] = len(x.Command) != 0
			var yynn1038 int
			if yyr1038 || yy2arr1038 {
				r.EncodeArrayStart(1)
			} else {
				yynn1038 = 0
				for _, b := range yyq1038 {
					if b {
						yynn1038++
					}
				}
				r.EncodeMapStart(yynn1038)
				yynn1038 = 0
			}
			if yyr1038 || yy2arr1038 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1038[0] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1040 := z.EncBinary()
						_ = yym1040
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1038[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1041 := z.EncBinary()
						_ = yym1041
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1038 || yy2arr1038 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExecAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1042 := z.DecBinary()
	_ = yym1042
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1043 := r.ContainerType()
		if yyct1043 == codecSelferValueTypeMap1234 {
			yyl1043 := r.ReadMapStart()
			if yyl1043 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1043, d)
			}
		} else if yyct1043 == codecSelferValueTypeArray1234 {
			yyl1043 := r.ReadArrayStart()
			if yyl1043 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1043, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExecAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1044Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1044Slc
	var yyhl1044 bool = l >= 0
	for yyj1044 := 0; ; yyj1044++ {
		if yyhl1044 {
			if yyj1044 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1044Slc = r.DecodeBytes(yys1044Slc, true, true)
		yys1044 := string(yys1044Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1044 {
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1045 := &x.Command
				yym1046 := z.DecBinary()
				_ = yym1046
				if false {
				} else {
					z.F.DecSliceStringX(yyv1045, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1044)
		} // end switch yys1044
	} // end for yyj1044
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExecAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1047 int
	var yyb1047 bool
	var yyhl1047 bool = l >= 0
	yyj1047++
	if yyhl1047 {
		yyb1047 = yyj1047 > l
	} else {
		yyb1047 = r.CheckBreak()
	}
	if yyb1047 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1048 := &x.Command
		yym1049 := z.DecBinary()
		_ = yym1049
		if false {
		} else {
			z.F.DecSliceStringX(yyv1048, false, d)
		}
	}
	for {
		yyj1047++
		if yyhl1047 {
			yyb1047 = yyj1047 > l
		} else {
			yyb1047 = r.CheckBreak()
		}
		if yyb1047 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1047-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Probe) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1050 := z.EncBinary()
		_ = yym1050
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1051 := !z.EncBinary()
			yy2arr1051 := z.EncBasicHandle().StructToArray
			var yyq1051 [8]bool
			_, _, _ = yysep1051, yyq1051, yy2arr1051
			const yyr1051 bool = false
			yyq1051[0] = x.Handler.Exec != nil && x.Exec != nil
			yyq1051[1] = x.Handler.HTTPGet != nil && x.HTTPGet != nil
			yyq1051[2] = x.Handler.TCPSocket != nil && x.TCPSocket != nil
			yyq1051[3] = x.InitialDelaySeconds != 0
			yyq1051[4] = x.TimeoutSeconds != 0
			yyq1051[5] = x.PeriodSeconds != 0
			yyq1051[6] = x.SuccessThreshold != 0
			yyq1051[7] = x.FailureThreshold != 0
			var yynn1051 int
			if yyr1051 || yy2arr1051 {
				r.EncodeArrayStart(8)
			} else {
				yynn1051 = 0
				for _, b := range yyq1051 {
					if b {
						yynn1051++
					}
				}
				r.EncodeMapStart(yynn1051)
				yynn1051 = 0
			}
			var yyn1052 bool
			if x.Handler.Exec == nil {
				yyn1052 = true
				goto LABEL1052
			}
		LABEL1052:
			if yyr1051 || yy2arr1051 {
				if yyn1052 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1051[0] {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1051[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1052 {
						r.EncodeNil()
					} else {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1053 bool
			if x.Handler.HTTPGet == nil {
				yyn1053 = true
				goto LABEL1053
			}
		LABEL1053:
			if yyr1051 || yy2arr1051 {
				if yyn1053 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1051[1] {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1051[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1053 {
						r.EncodeNil()
					} else {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1054 bool
			if x.Handler.TCPSocket == nil {
				yyn1054 = true
				goto LABEL1054
			}
		LABEL1054:
			if yyr1051 || yy2arr1051 {
				if yyn1054 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1051[2] {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1051[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1054 {
						r.EncodeNil()
					} else {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1051[3] {
					yym1056 := z.EncBinary()
					_ = yym1056
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1051[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initialDelaySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1057 := z.EncBinary()
					_ = yym1057
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				}
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1051[4] {
					yym1059 := z.EncBinary()
					_ = yym1059
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1051[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1060 := z.EncBinary()
					_ = yym1060
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				}
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1051[5] {
					yym1062 := z.EncBinary()
					_ = yym1062
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1051[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("periodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1063 := z.EncBinary()
					_ = yym1063
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				}
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1051[6] {
					yym1065 := z.EncBinary()
					_ = yym1065
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1051[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("successThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1066 := z.EncBinary()
					_ = yym1066
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				}
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1051[7] {
					yym1068 := z.EncBinary()
					_ = yym1068
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1051[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failureThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1069 := z.EncBinary()
					_ = yym1069
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				}
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Probe) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1070 := z.DecBinary()
	_ = yym1070
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1071 := r.ContainerType()
		if yyct1071 == codecSelferValueTypeMap1234 {
			yyl1071 := r.ReadMapStart()
			if yyl1071 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1071, d)
			}
		} else if yyct1071 == codecSelferValueTypeArray1234 {
			yyl1071 := r.ReadArrayStart()
			if yyl1071 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1071, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Probe) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1072Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1072Slc
	var yyhl1072 bool = l >= 0
	for yyj1072 := 0; ; yyj1072++ {
		if yyhl1072 {
			if yyj1072 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1072Slc = r.DecodeBytes(yys1072Slc, true, true)
		yys1072 := string(yys1072Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1072 {
		case "exec":
			if x.Handler.Exec == nil {
				x.Handler.Exec = new(ExecAction)
			}
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if x.Handler.HTTPGet == nil {
				x.Handler.HTTPGet = new(HTTPGetAction)
			}
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if x.Handler.TCPSocket == nil {
				x.Handler.TCPSocket = new(TCPSocketAction)
			}
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		case "initialDelaySeconds":
			if r.TryDecodeAsNil() {
				x.InitialDelaySeconds = 0
			} else {
				x.InitialDelaySeconds = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				x.TimeoutSeconds = 0
			} else {
				x.TimeoutSeconds = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "periodSeconds":
			if r.TryDecodeAsNil() {
				x.PeriodSeconds = 0
			} else {
				x.PeriodSeconds = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "successThreshold":
			if r.TryDecodeAsNil() {
				x.SuccessThreshold = 0
			} else {
				x.SuccessThreshold = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failureThreshold":
			if r.TryDecodeAsNil() {
				x.FailureThreshold = 0
			} else {
				x.FailureThreshold = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1072)
		} // end switch yys1072
	} // end for yyj1072
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Probe) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1081 int
	var yyb1081 bool
	var yyhl1081 bool = l >= 0
	if x.Handler.Exec == nil {
		x.Handler.Exec = new(ExecAction)
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	if x.Handler.HTTPGet == nil {
		x.Handler.HTTPGet = new(HTTPGetAction)
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	if x.Handler.TCPSocket == nil {
		x.Handler.TCPSocket = new(TCPSocketAction)
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitialDelaySeconds = 0
	} else {
		x.InitialDelaySeconds = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeoutSeconds = 0
	} else {
		x.TimeoutSeconds = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PeriodSeconds = 0
	} else {
		x.PeriodSeconds = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SuccessThreshold = 0
	} else {
		x.SuccessThreshold = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1081++
	if yyhl1081 {
		yyb1081 = yyj1081 > l
	} else {
		yyb1081 = r.CheckBreak()
	}
	if yyb1081 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureThreshold = 0
	} else {
		x.FailureThreshold = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj1081++
		if yyhl1081 {
			yyb1081 = yyj1081 > l
		} else {
			yyb1081 = r.CheckBreak()
		}
		if yyb1081 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1081-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PullPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1090 := z.EncBinary()
	_ = yym1090
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PullPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1091 := z.DecBinary()
	_ = yym1091
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Capability) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1092 := z.EncBinary()
	_ = yym1092
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Capability) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1093 := z.DecBinary()
	_ = yym1093
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Capabilities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1094 := z.EncBinary()
		_ = yym1094
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1095 := !z.EncBinary()
			yy2arr1095 := z.EncBasicHandle().StructToArray
			var yyq1095 [2]bool
			_, _, _ = yysep1095, yyq1095, yy2arr1095
			const yyr1095 bool = false
			yyq1095[0] = len(x.Add) != 0
			yyq1095[1] = len(x.Drop) != 0
			var yynn1095 int
			if yyr1095 || yy2arr1095 {
				r.EncodeArrayStart(2)
			} else {
				yynn1095 = 0
				for _, b := range yyq1095 {
					if b {
						yynn1095++
					}
				}
				r.EncodeMapStart(yynn1095)
				yynn1095 = 0
			}
			if yyr1095 || yy2arr1095 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1095[0] {
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1097 := z.EncBinary()
						_ = yym1097
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1095[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("add"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1098 := z.EncBinary()
						_ = yym1098
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				}
			}
			if yyr1095 || yy2arr1095 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1095[1] {
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1100 := z.EncBinary()
						_ = yym1100
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1095[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("drop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1101 := z.EncBinary()
						_ = yym1101
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				}
			}
			if yyr1095 || yy2arr1095 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Capabilities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1102 := z.DecBinary()
	_ = yym1102
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1103 := r.ContainerType()
		if yyct1103 == codecSelferValueTypeMap1234 {
			yyl1103 := r.ReadMapStart()
			if yyl1103 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1103, d)
			}
		} else if yyct1103 == codecSelferValueTypeArray1234 {
			yyl1103 := r.ReadArrayStart()
			if yyl1103 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1103, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Capabilities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1104Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1104Slc
	var yyhl1104 bool = l >= 0
	for yyj1104 := 0; ; yyj1104++ {
		if yyhl1104 {
			if yyj1104 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1104Slc = r.DecodeBytes(yys1104Slc, true, true)
		yys1104 := string(yys1104Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1104 {
		case "add":
			if r.TryDecodeAsNil() {
				x.Add = nil
			} else {
				yyv1105 := &x.Add
				yym1106 := z.DecBinary()
				_ = yym1106
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1105), d)
				}
			}
		case "drop":
			if r.TryDecodeAsNil() {
				x.Drop = nil
			} else {
				yyv1107 := &x.Drop
				yym1108 := z.DecBinary()
				_ = yym1108
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1107), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1104)
		} // end switch yys1104
	} // end for yyj1104
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Capabilities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1109 int
	var yyb1109 bool
	var yyhl1109 bool = l >= 0
	yyj1109++
	if yyhl1109 {
		yyb1109 = yyj1109 > l
	} else {
		yyb1109 = r.CheckBreak()
	}
	if yyb1109 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Add = nil
	} else {
		yyv1110 := &x.Add
		yym1111 := z.DecBinary()
		_ = yym1111
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1110), d)
		}
	}
	yyj1109++
	if yyhl1109 {
		yyb1109 = yyj1109 > l
	} else {
		yyb1109 = r.CheckBreak()
	}
	if yyb1109 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Drop = nil
	} else {
		yyv1112 := &x.Drop
		yym1113 := z.DecBinary()
		_ = yym1113
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1112), d)
		}
	}
	for {
		yyj1109++
		if yyhl1109 {
			yyb1109 = yyj1109 > l
		} else {
			yyb1109 = r.CheckBreak()
		}
		if yyb1109 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1109-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceRequirements) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1114 := z.EncBinary()
		_ = yym1114
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1115 := !z.EncBinary()
			yy2arr1115 := z.EncBasicHandle().StructToArray
			var yyq1115 [2]bool
			_, _, _ = yysep1115, yyq1115, yy2arr1115
			const yyr1115 bool = false
			yyq1115[0] = len(x.Limits) != 0
			yyq1115[1] = len(x.Requests) != 0
			var yynn1115 int
			if yyr1115 || yy2arr1115 {
				r.EncodeArrayStart(2)
			} else {
				yynn1115 = 0
				for _, b := range yyq1115 {
					if b {
						yynn1115++
					}
				}
				r.EncodeMapStart(yynn1115)
				yynn1115 = 0
			}
			if yyr1115 || yy2arr1115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1115[0] {
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1115[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limits"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1115 || yy2arr1115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1115[1] {
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1115[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requests"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1115 || yy2arr1115 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceRequirements) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1118 := z.DecBinary()
	_ = yym1118
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1119 := r.ContainerType()
		if yyct1119 == codecSelferValueTypeMap1234 {
			yyl1119 := r.ReadMapStart()
			if yyl1119 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1119, d)
			}
		} else if yyct1119 == codecSelferValueTypeArray1234 {
			yyl1119 := r.ReadArrayStart()
			if yyl1119 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1119, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceRequirements) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1120Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1120Slc
	var yyhl1120 bool = l >= 0
	for yyj1120 := 0; ; yyj1120++ {
		if yyhl1120 {
			if yyj1120 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1120Slc = r.DecodeBytes(yys1120Slc, true, true)
		yys1120 := string(yys1120Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1120 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv1121 := &x.Limits
				yyv1121.CodecDecodeSelf(d)
			}
		case "requests":
			if r.TryDecodeAsNil() {
				x.Requests = nil
			} else {
				yyv1122 := &x.Requests
				yyv1122.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1120)
		} // end switch yys1120
	} // end for yyj1120
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceRequirements) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1123 int
	var yyb1123 bool
	var yyhl1123 bool = l >= 0
	yyj1123++
	if yyhl1123 {
		yyb1123 = yyj1123 > l
	} else {
		yyb1123 = r.CheckBreak()
	}
	if yyb1123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv1124 := &x.Limits
		yyv1124.CodecDecodeSelf(d)
	}
	yyj1123++
	if yyhl1123 {
		yyb1123 = yyj1123 > l
	} else {
		yyb1123 = r.CheckBreak()
	}
	if yyb1123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Requests = nil
	} else {
		yyv1125 := &x.Requests
		yyv1125.CodecDecodeSelf(d)
	}
	for {
		yyj1123++
		if yyhl1123 {
			yyb1123 = yyj1123 > l
		} else {
			yyb1123 = r.CheckBreak()
		}
		if yyb1123 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1123-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Container) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1126 := z.EncBinary()
		_ = yym1126
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1127 := !z.EncBinary()
			yy2arr1127 := z.EncBasicHandle().StructToArray
			var yyq1127 [18]bool
			_, _, _ = yysep1127, yyq1127, yy2arr1127
			const yyr1127 bool = false
			yyq1127[2] = len(x.Command) != 0
			yyq1127[3] = len(x.Args) != 0
			yyq1127[4] = x.WorkingDir != ""
			yyq1127[5] = len(x.Ports) != 0
			yyq1127[6] = len(x.Env) != 0
			yyq1127[7] = true
			yyq1127[8] = len(x.VolumeMounts) != 0
			yyq1127[9] = x.LivenessProbe != nil
			yyq1127[10] = x.ReadinessProbe != nil
			yyq1127[11] = x.Lifecycle != nil
			yyq1127[12] = x.TerminationMessagePath != ""
			yyq1127[14] = x.SecurityContext != nil
			yyq1127[15] = x.Stdin != false
			yyq1127[16] = x.StdinOnce != false
			yyq1127[17] = x.TTY != false
			var yynn1127 int
			if yyr1127 || yy2arr1127 {
				r.EncodeArrayStart(18)
			} else {
				yynn1127 = 3
				for _, b := range yyq1127 {
					if b {
						yynn1127++
					}
				}
				r.EncodeMapStart(yynn1127)
				yynn1127 = 0
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1129 := z.EncBinary()
				_ = yym1129
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1130 := z.EncBinary()
				_ = yym1130
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1132 := z.EncBinary()
				_ = yym1132
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1133 := z.EncBinary()
				_ = yym1133
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[2] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1135 := z.EncBinary()
						_ = yym1135
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1136 := z.EncBinary()
						_ = yym1136
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[3] {
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1138 := z.EncBinary()
						_ = yym1138
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("args"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1139 := z.EncBinary()
						_ = yym1139
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[4] {
					yym1141 := z.EncBinary()
					_ = yym1141
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1127[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("workingDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1142 := z.EncBinary()
					_ = yym1142
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[5] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1144 := z.EncBinary()
						_ = yym1144
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1145 := z.EncBinary()
						_ = yym1145
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[6] {
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1147 := z.EncBinary()
						_ = yym1147
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("env"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1148 := z.EncBinary()
						_ = yym1148
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[7] {
					yy1150 := &x.Resources
					yy1150.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1151 := &x.Resources
					yy1151.CodecEncodeSelf(e)
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[8] {
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1153 := z.EncBinary()
						_ = yym1153
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeMounts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1154 := z.EncBinary()
						_ = yym1154
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[9] {
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("livenessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[10] {
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readinessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[11] {
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lifecycle"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[12] {
					yym1159 := z.EncBinary()
					_ = yym1159
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1127[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1160 := z.EncBinary()
					_ = yym1160
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.ImagePullPolicy.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imagePullPolicy"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.ImagePullPolicy.CodecEncodeSelf(e)
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[14] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1127[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[15] {
					yym1164 := z.EncBinary()
					_ = yym1164
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1127[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1165 := z.EncBinary()
					_ = yym1165
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[16] {
					yym1167 := z.EncBinary()
					_ = yym1167
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1127[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdinOnce"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1168 := z.EncBinary()
					_ = yym1168
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1127[17] {
					yym1170 := z.EncBinary()
					_ = yym1170
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1127[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1171 := z.EncBinary()
					_ = yym1171
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr1127 || yy2arr1127 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Container) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1172 := z.DecBinary()
	_ = yym1172
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1173 := r.ContainerType()
		if yyct1173 == codecSelferValueTypeMap1234 {
			yyl1173 := r.ReadMapStart()
			if yyl1173 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1173, d)
			}
		} else if yyct1173 == codecSelferValueTypeArray1234 {
			yyl1173 := r.ReadArrayStart()
			if yyl1173 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1173, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Container) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1174Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1174Slc
	var yyhl1174 bool = l >= 0
	for yyj1174 := 0; ; yyj1174++ {
		if yyhl1174 {
			if yyj1174 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1174Slc = r.DecodeBytes(yys1174Slc, true, true)
		yys1174 := string(yys1174Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1174 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1177 := &x.Command
				yym1178 := z.DecBinary()
				_ = yym1178
				if false {
				} else {
					z.F.DecSliceStringX(yyv1177, false, d)
				}
			}
		case "args":
			if r.TryDecodeAsNil() {
				x.Args = nil
			} else {
				yyv1179 := &x.Args
				yym1180 := z.DecBinary()
				_ = yym1180
				if false {
				} else {
					z.F.DecSliceStringX(yyv1179, false, d)
				}
			}
		case "workingDir":
			if r.TryDecodeAsNil() {
				x.WorkingDir = ""
			} else {
				x.WorkingDir = string(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1182 := &x.Ports
				yym1183 := z.DecBinary()
				_ = yym1183
				if false {
				} else {
					h.decSliceContainerPort((*[]ContainerPort)(yyv1182), d)
				}
			}
		case "env":
			if r.TryDecodeAsNil() {
				x.Env = nil
			} else {
				yyv1184 := &x.Env
				yym1185 := z.DecBinary()
				_ = yym1185
				if false {
				} else {
					h.decSliceEnvVar((*[]EnvVar)(yyv1184), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv1186 := &x.Resources
				yyv1186.CodecDecodeSelf(d)
			}
		case "volumeMounts":
			if r.TryDecodeAsNil() {
				x.VolumeMounts = nil
			} else {
				yyv1187 := &x.VolumeMounts
				yym1188 := z.DecBinary()
				_ = yym1188
				if false {
				} else {
					h.decSliceVolumeMount((*[]VolumeMount)(yyv1187), d)
				}
			}
		case "livenessProbe":
			if r.TryDecodeAsNil() {
				if x.LivenessProbe != nil {
					x.LivenessProbe = nil
				}
			} else {
				if x.LivenessProbe == nil {
					x.LivenessProbe = new(Probe)
				}
				x.LivenessProbe.CodecDecodeSelf(d)
			}
		case "readinessProbe":
			if r.TryDecodeAsNil() {
				if x.ReadinessProbe != nil {
					x.ReadinessProbe = nil
				}
			} else {
				if x.ReadinessProbe == nil {
					x.ReadinessProbe = new(Probe)
				}
				x.ReadinessProbe.CodecDecodeSelf(d)
			}
		case "lifecycle":
			if r.TryDecodeAsNil() {
				if x.Lifecycle != nil {
					x.Lifecycle = nil
				}
			} else {
				if x.Lifecycle == nil {
					x.Lifecycle = new(Lifecycle)
				}
				x.Lifecycle.CodecDecodeSelf(d)
			}
		case "terminationMessagePath":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePath = ""
			} else {
				x.TerminationMessagePath = string(r.DecodeString())
			}
		case "imagePullPolicy":
			if r.TryDecodeAsNil() {
				x.ImagePullPolicy = ""
			} else {
				x.ImagePullPolicy = PullPolicy(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(SecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdinOnce":
			if r.TryDecodeAsNil() {
				x.StdinOnce = false
			} else {
				x.StdinOnce = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1174)
		} // end switch yys1174
	} // end for yyj1174
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Container) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1198 int
	var yyb1198 bool
	var yyhl1198 bool = l >= 0
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1201 := &x.Command
		yym1202 := z.DecBinary()
		_ = yym1202
		if false {
		} else {
			z.F.DecSliceStringX(yyv1201, false, d)
		}
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Args = nil
	} else {
		yyv1203 := &x.Args
		yym1204 := z.DecBinary()
		_ = yym1204
		if false {
		} else {
			z.F.DecSliceStringX(yyv1203, false, d)
		}
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.WorkingDir = ""
	} else {
		x.WorkingDir = string(r.DecodeString())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1206 := &x.Ports
		yym1207 := z.DecBinary()
		_ = yym1207
		if false {
		} else {
			h.decSliceContainerPort((*[]ContainerPort)(yyv1206), d)
		}
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Env = nil
	} else {
		yyv1208 := &x.Env
		yym1209 := z.DecBinary()
		_ = yym1209
		if false {
		} else {
			h.decSliceEnvVar((*[]EnvVar)(yyv1208), d)
		}
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv1210 := &x.Resources
		yyv1210.CodecDecodeSelf(d)
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeMounts = nil
	} else {
		yyv1211 := &x.VolumeMounts
		yym1212 := z.DecBinary()
		_ = yym1212
		if false {
		} else {
			h.decSliceVolumeMount((*[]VolumeMount)(yyv1211), d)
		}
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LivenessProbe != nil {
			x.LivenessProbe = nil
		}
	} else {
		if x.LivenessProbe == nil {
			x.LivenessProbe = new(Probe)
		}
		x.LivenessProbe.CodecDecodeSelf(d)
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadinessProbe != nil {
			x.ReadinessProbe = nil
		}
	} else {
		if x.ReadinessProbe == nil {
			x.ReadinessProbe = new(Probe)
		}
		x.ReadinessProbe.CodecDecodeSelf(d)
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lifecycle != nil {
			x.Lifecycle = nil
		}
	} else {
		if x.Lifecycle == nil {
			x.Lifecycle = new(Lifecycle)
		}
		x.Lifecycle.CodecDecodeSelf(d)
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePath = ""
	} else {
		x.TerminationMessagePath = string(r.DecodeString())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullPolicy = ""
	} else {
		x.ImagePullPolicy = PullPolicy(r.DecodeString())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(SecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StdinOnce = false
	} else {
		x.StdinOnce = bool(r.DecodeBool())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	for {
		yyj1198++
		if yyhl1198 {
			yyb1198 = yyj1198 > l
		} else {
			yyb1198 = r.CheckBreak()
		}
		if yyb1198 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1198-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Handler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1222 := z.EncBinary()
		_ = yym1222
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1223 := !z.EncBinary()
			yy2arr1223 := z.EncBasicHandle().StructToArray
			var yyq1223 [3]bool
			_, _, _ = yysep1223, yyq1223, yy2arr1223
			const yyr1223 bool = false
			yyq1223[0] = x.Exec != nil
			yyq1223[1] = x.HTTPGet != nil
			yyq1223[2] = x.TCPSocket != nil
			var yynn1223 int
			if yyr1223 || yy2arr1223 {
				r.EncodeArrayStart(3)
			} else {
				yynn1223 = 0
				for _, b := range yyq1223 {
					if b {
						yynn1223++
					}
				}
				r.EncodeMapStart(yynn1223)
				yynn1223 = 0
			}
			if yyr1223 || yy2arr1223 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1223[0] {
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1223[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1223 || yy2arr1223 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1223[1] {
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1223[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1223 || yy2arr1223 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1223[2] {
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1223[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1223 || yy2arr1223 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Handler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1227 := z.DecBinary()
	_ = yym1227
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1228 := r.ContainerType()
		if yyct1228 == codecSelferValueTypeMap1234 {
			yyl1228 := r.ReadMapStart()
			if yyl1228 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1228, d)
			}
		} else if yyct1228 == codecSelferValueTypeArray1234 {
			yyl1228 := r.ReadArrayStart()
			if yyl1228 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1228, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Handler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1229Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1229Slc
	var yyhl1229 bool = l >= 0
	for yyj1229 := 0; ; yyj1229++ {
		if yyhl1229 {
			if yyj1229 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1229Slc = r.DecodeBytes(yys1229Slc, true, true)
		yys1229 := string(yys1229Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1229 {
		case "exec":
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1229)
		} // end switch yys1229
	} // end for yyj1229
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Handler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1233 int
	var yyb1233 bool
	var yyhl1233 bool = l >= 0
	yyj1233++
	if yyhl1233 {
		yyb1233 = yyj1233 > l
	} else {
		yyb1233 = r.CheckBreak()
	}
	if yyb1233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	yyj1233++
	if yyhl1233 {
		yyb1233 = yyj1233 > l
	} else {
		yyb1233 = r.CheckBreak()
	}
	if yyb1233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	yyj1233++
	if yyhl1233 {
		yyb1233 = yyj1233 > l
	} else {
		yyb1233 = r.CheckBreak()
	}
	if yyb1233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	for {
		yyj1233++
		if yyhl1233 {
			yyb1233 = yyj1233 > l
		} else {
			yyb1233 = r.CheckBreak()
		}
		if yyb1233 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1233-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Lifecycle) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1237 := z.EncBinary()
		_ = yym1237
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1238 := !z.EncBinary()
			yy2arr1238 := z.EncBasicHandle().StructToArray
			var yyq1238 [2]bool
			_, _, _ = yysep1238, yyq1238, yy2arr1238
			const yyr1238 bool = false
			yyq1238[0] = x.PostStart != nil
			yyq1238[1] = x.PreStop != nil
			var yynn1238 int
			if yyr1238 || yy2arr1238 {
				r.EncodeArrayStart(2)
			} else {
				yynn1238 = 0
				for _, b := range yyq1238 {
					if b {
						yynn1238++
					}
				}
				r.EncodeMapStart(yynn1238)
				yynn1238 = 0
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1238[0] {
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1238[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("postStart"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1238[1] {
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1238[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preStop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Lifecycle) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1241 := z.DecBinary()
	_ = yym1241
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1242 := r.ContainerType()
		if yyct1242 == codecSelferValueTypeMap1234 {
			yyl1242 := r.ReadMapStart()
			if yyl1242 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1242, d)
			}
		} else if yyct1242 == codecSelferValueTypeArray1234 {
			yyl1242 := r.ReadArrayStart()
			if yyl1242 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1242, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Lifecycle) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1243Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1243Slc
	var yyhl1243 bool = l >= 0
	for yyj1243 := 0; ; yyj1243++ {
		if yyhl1243 {
			if yyj1243 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1243Slc = r.DecodeBytes(yys1243Slc, true, true)
		yys1243 := string(yys1243Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1243 {
		case "postStart":
			if r.TryDecodeAsNil() {
				if x.PostStart != nil {
					x.PostStart = nil
				}
			} else {
				if x.PostStart == nil {
					x.PostStart = new(Handler)
				}
				x.PostStart.CodecDecodeSelf(d)
			}
		case "preStop":
			if r.TryDecodeAsNil() {
				if x.PreStop != nil {
					x.PreStop = nil
				}
			} else {
				if x.PreStop == nil {
					x.PreStop = new(Handler)
				}
				x.PreStop.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1243)
		} // end switch yys1243
	} // end for yyj1243
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Lifecycle) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1246 int
	var yyb1246 bool
	var yyhl1246 bool = l >= 0
	yyj1246++
	if yyhl1246 {
		yyb1246 = yyj1246 > l
	} else {
		yyb1246 = r.CheckBreak()
	}
	if yyb1246 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PostStart != nil {
			x.PostStart = nil
		}
	} else {
		if x.PostStart == nil {
			x.PostStart = new(Handler)
		}
		x.PostStart.CodecDecodeSelf(d)
	}
	yyj1246++
	if yyhl1246 {
		yyb1246 = yyj1246 > l
	} else {
		yyb1246 = r.CheckBreak()
	}
	if yyb1246 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PreStop != nil {
			x.PreStop = nil
		}
	} else {
		if x.PreStop == nil {
			x.PreStop = new(Handler)
		}
		x.PreStop.CodecDecodeSelf(d)
	}
	for {
		yyj1246++
		if yyhl1246 {
			yyb1246 = yyj1246 > l
		} else {
			yyb1246 = r.CheckBreak()
		}
		if yyb1246 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1246-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConditionStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1249 := z.EncBinary()
	_ = yym1249
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConditionStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1250 := z.DecBinary()
	_ = yym1250
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ContainerStateWaiting) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1251 := z.EncBinary()
		_ = yym1251
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1252 := !z.EncBinary()
			yy2arr1252 := z.EncBasicHandle().StructToArray
			var yyq1252 [2]bool
			_, _, _ = yysep1252, yyq1252, yy2arr1252
			const yyr1252 bool = false
			yyq1252[0] = x.Reason != ""
			yyq1252[1] = x.Message != ""
			var yynn1252 int
			if yyr1252 || yy2arr1252 {
				r.EncodeArrayStart(2)
			} else {
				yynn1252 = 0
				for _, b := range yyq1252 {
					if b {
						yynn1252++
					}
				}
				r.EncodeMapStart(yynn1252)
				yynn1252 = 0
			}
			if yyr1252 || yy2arr1252 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1252[0] {
					yym1254 := z.EncBinary()
					_ = yym1254
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1252[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1255 := z.EncBinary()
					_ = yym1255
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1252 || yy2arr1252 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1252[1] {
					yym1257 := z.EncBinary()
					_ = yym1257
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1252[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1258 := z.EncBinary()
					_ = yym1258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1252 || yy2arr1252 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateWaiting) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1259 := z.DecBinary()
	_ = yym1259
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1260 := r.ContainerType()
		if yyct1260 == codecSelferValueTypeMap1234 {
			yyl1260 := r.ReadMapStart()
			if yyl1260 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1260, d)
			}
		} else if yyct1260 == codecSelferValueTypeArray1234 {
			yyl1260 := r.ReadArrayStart()
			if yyl1260 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1260, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateWaiting) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1261Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1261Slc
	var yyhl1261 bool = l >= 0
	for yyj1261 := 0; ; yyj1261++ {
		if yyhl1261 {
			if yyj1261 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1261Slc = r.DecodeBytes(yys1261Slc, true, true)
		yys1261 := string(yys1261Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1261 {
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1261)
		} // end switch yys1261
	} // end for yyj1261
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateWaiting) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1264 int
	var yyb1264 bool
	var yyhl1264 bool = l >= 0
	yyj1264++
	if yyhl1264 {
		yyb1264 = yyj1264 > l
	} else {
		yyb1264 = r.CheckBreak()
	}
	if yyb1264 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1264++
	if yyhl1264 {
		yyb1264 = yyj1264 > l
	} else {
		yyb1264 = r.CheckBreak()
	}
	if yyb1264 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1264++
		if yyhl1264 {
			yyb1264 = yyj1264 > l
		} else {
			yyb1264 = r.CheckBreak()
		}
		if yyb1264 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1264-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateRunning) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1267 := z.EncBinary()
		_ = yym1267
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1268 := !z.EncBinary()
			yy2arr1268 := z.EncBasicHandle().StructToArray
			var yyq1268 [1]bool
			_, _, _ = yysep1268, yyq1268, yy2arr1268
			const yyr1268 bool = false
			yyq1268[0] = true
			var yynn1268 int
			if yyr1268 || yy2arr1268 {
				r.EncodeArrayStart(1)
			} else {
				yynn1268 = 0
				for _, b := range yyq1268 {
					if b {
						yynn1268++
					}
				}
				r.EncodeMapStart(yynn1268)
				yynn1268 = 0
			}
			if yyr1268 || yy2arr1268 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1268[0] {
					yy1270 := &x.StartedAt
					yym1271 := z.EncBinary()
					_ = yym1271
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1270) {
					} else if yym1271 {
						z.EncBinaryMarshal(yy1270)
					} else if !yym1271 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1270)
					} else {
						z.EncFallback(yy1270)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1268[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1272 := &x.StartedAt
					yym1273 := z.EncBinary()
					_ = yym1273
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1272) {
					} else if yym1273 {
						z.EncBinaryMarshal(yy1272)
					} else if !yym1273 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1272)
					} else {
						z.EncFallback(yy1272)
					}
				}
			}
			if yyr1268 || yy2arr1268 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateRunning) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1274 := z.DecBinary()
	_ = yym1274
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1275 := r.ContainerType()
		if yyct1275 == codecSelferValueTypeMap1234 {
			yyl1275 := r.ReadMapStart()
			if yyl1275 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1275, d)
			}
		} else if yyct1275 == codecSelferValueTypeArray1234 {
			yyl1275 := r.ReadArrayStart()
			if yyl1275 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1275, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateRunning) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1276Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1276Slc
	var yyhl1276 bool = l >= 0
	for yyj1276 := 0; ; yyj1276++ {
		if yyhl1276 {
			if yyj1276 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1276Slc = r.DecodeBytes(yys1276Slc, true, true)
		yys1276 := string(yys1276Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1276 {
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1277 := &x.StartedAt
				yym1278 := z.DecBinary()
				_ = yym1278
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1277) {
				} else if yym1278 {
					z.DecBinaryUnmarshal(yyv1277)
				} else if !yym1278 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1277)
				} else {
					z.DecFallback(yyv1277, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1276)
		} // end switch yys1276
	} // end for yyj1276
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateRunning) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1279 int
	var yyb1279 bool
	var yyhl1279 bool = l >= 0
	yyj1279++
	if yyhl1279 {
		yyb1279 = yyj1279 > l
	} else {
		yyb1279 = r.CheckBreak()
	}
	if yyb1279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1280 := &x.StartedAt
		yym1281 := z.DecBinary()
		_ = yym1281
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1280) {
		} else if yym1281 {
			z.DecBinaryUnmarshal(yyv1280)
		} else if !yym1281 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1280)
		} else {
			z.DecFallback(yyv1280, false)
		}
	}
	for {
		yyj1279++
		if yyhl1279 {
			yyb1279 = yyj1279 > l
		} else {
			yyb1279 = r.CheckBreak()
		}
		if yyb1279 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1279-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateTerminated) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1282 := z.EncBinary()
		_ = yym1282
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1283 := !z.EncBinary()
			yy2arr1283 := z.EncBasicHandle().StructToArray
			var yyq1283 [7]bool
			_, _, _ = yysep1283, yyq1283, yy2arr1283
			const yyr1283 bool = false
			yyq1283[1] = x.Signal != 0
			yyq1283[2] = x.Reason != ""
			yyq1283[3] = x.Message != ""
			yyq1283[4] = true
			yyq1283[5] = true
			yyq1283[6] = x.ContainerID != ""
			var yynn1283 int
			if yyr1283 || yy2arr1283 {
				r.EncodeArrayStart(7)
			} else {
				yynn1283 = 1
				for _, b := range yyq1283 {
					if b {
						yynn1283++
					}
				}
				r.EncodeMapStart(yynn1283)
				yynn1283 = 0
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1285 := z.EncBinary()
				_ = yym1285
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitCode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1286 := z.EncBinary()
				_ = yym1286
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1283[1] {
					yym1288 := z.EncBinary()
					_ = yym1288
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1283[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("signal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1289 := z.EncBinary()
					_ = yym1289
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				}
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1283[2] {
					yym1291 := z.EncBinary()
					_ = yym1291
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1283[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1292 := z.EncBinary()
					_ = yym1292
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1283[3] {
					yym1294 := z.EncBinary()
					_ = yym1294
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1283[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1295 := z.EncBinary()
					_ = yym1295
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1283[4] {
					yy1297 := &x.StartedAt
					yym1298 := z.EncBinary()
					_ = yym1298
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1297) {
					} else if yym1298 {
						z.EncBinaryMarshal(yy1297)
					} else if !yym1298 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1297)
					} else {
						z.EncFallback(yy1297)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1283[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1299 := &x.StartedAt
					yym1300 := z.EncBinary()
					_ = yym1300
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1299) {
					} else if yym1300 {
						z.EncBinaryMarshal(yy1299)
					} else if !yym1300 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1299)
					} else {
						z.EncFallback(yy1299)
					}
				}
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1283[5] {
					yy1302 := &x.FinishedAt
					yym1303 := z.EncBinary()
					_ = yym1303
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1302) {
					} else if yym1303 {
						z.EncBinaryMarshal(yy1302)
					} else if !yym1303 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1302)
					} else {
						z.EncFallback(yy1302)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1283[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finishedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1304 := &x.FinishedAt
					yym1305 := z.EncBinary()
					_ = yym1305
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1304) {
					} else if yym1305 {
						z.EncBinaryMarshal(yy1304)
					} else if !yym1305 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1304)
					} else {
						z.EncFallback(yy1304)
					}
				}
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1283[6] {
					yym1307 := z.EncBinary()
					_ = yym1307
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1283[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1308 := z.EncBinary()
					_ = yym1308
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1283 || yy2arr1283 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateTerminated) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1309 := z.DecBinary()
	_ = yym1309
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1310 := r.ContainerType()
		if yyct1310 == codecSelferValueTypeMap1234 {
			yyl1310 := r.ReadMapStart()
			if yyl1310 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1310, d)
			}
		} else if yyct1310 == codecSelferValueTypeArray1234 {
			yyl1310 := r.ReadArrayStart()
			if yyl1310 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1310, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateTerminated) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1311Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1311Slc
	var yyhl1311 bool = l >= 0
	for yyj1311 := 0; ; yyj1311++ {
		if yyhl1311 {
			if yyj1311 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1311Slc = r.DecodeBytes(yys1311Slc, true, true)
		yys1311 := string(yys1311Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1311 {
		case "exitCode":
			if r.TryDecodeAsNil() {
				x.ExitCode = 0
			} else {
				x.ExitCode = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "signal":
			if r.TryDecodeAsNil() {
				x.Signal = 0
			} else {
				x.Signal = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1316 := &x.StartedAt
				yym1317 := z.DecBinary()
				_ = yym1317
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1316) {
				} else if yym1317 {
					z.DecBinaryUnmarshal(yyv1316)
				} else if !yym1317 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1316)
				} else {
					z.DecFallback(yyv1316, false)
				}
			}
		case "finishedAt":
			if r.TryDecodeAsNil() {
				x.FinishedAt = pkg2_unversioned.Time{}
			} else {
				yyv1318 := &x.FinishedAt
				yym1319 := z.DecBinary()
				_ = yym1319
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1318) {
				} else if yym1319 {
					z.DecBinaryUnmarshal(yyv1318)
				} else if !yym1319 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1318)
				} else {
					z.DecFallback(yyv1318, false)
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1311)
		} // end switch yys1311
	} // end for yyj1311
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateTerminated) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1321 int
	var yyb1321 bool
	var yyhl1321 bool = l >= 0
	yyj1321++
	if yyhl1321 {
		yyb1321 = yyj1321 > l
	} else {
		yyb1321 = r.CheckBreak()
	}
	if yyb1321 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitCode = 0
	} else {
		x.ExitCode = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1321++
	if yyhl1321 {
		yyb1321 = yyj1321 > l
	} else {
		yyb1321 = r.CheckBreak()
	}
	if yyb1321 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Signal = 0
	} else {
		x.Signal = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1321++
	if yyhl1321 {
		yyb1321 = yyj1321 > l
	} else {
		yyb1321 = r.CheckBreak()
	}
	if yyb1321 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1321++
	if yyhl1321 {
		yyb1321 = yyj1321 > l
	} else {
		yyb1321 = r.CheckBreak()
	}
	if yyb1321 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1321++
	if yyhl1321 {
		yyb1321 = yyj1321 > l
	} else {
		yyb1321 = r.CheckBreak()
	}
	if yyb1321 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1326 := &x.StartedAt
		yym1327 := z.DecBinary()
		_ = yym1327
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1326) {
		} else if yym1327 {
			z.DecBinaryUnmarshal(yyv1326)
		} else if !yym1327 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1326)
		} else {
			z.DecFallback(yyv1326, false)
		}
	}
	yyj1321++
	if yyhl1321 {
		yyb1321 = yyj1321 > l
	} else {
		yyb1321 = r.CheckBreak()
	}
	if yyb1321 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FinishedAt = pkg2_unversioned.Time{}
	} else {
		yyv1328 := &x.FinishedAt
		yym1329 := z.DecBinary()
		_ = yym1329
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1328) {
		} else if yym1329 {
			z.DecBinaryUnmarshal(yyv1328)
		} else if !yym1329 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1328)
		} else {
			z.DecFallback(yyv1328, false)
		}
	}
	yyj1321++
	if yyhl1321 {
		yyb1321 = yyj1321 > l
	} else {
		yyb1321 = r.CheckBreak()
	}
	if yyb1321 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1321++
		if yyhl1321 {
			yyb1321 = yyj1321 > l
		} else {
			yyb1321 = r.CheckBreak()
		}
		if yyb1321 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1321-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerState) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1331 := z.EncBinary()
		_ = yym1331
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1332 := !z.EncBinary()
			yy2arr1332 := z.EncBasicHandle().StructToArray
			var yyq1332 [3]bool
			_, _, _ = yysep1332, yyq1332, yy2arr1332
			const yyr1332 bool = false
			yyq1332[0] = x.Waiting != nil
			yyq1332[1] = x.Running != nil
			yyq1332[2] = x.Terminated != nil
			var yynn1332 int
			if yyr1332 || yy2arr1332 {
				r.EncodeArrayStart(3)
			} else {
				yynn1332 = 0
				for _, b := range yyq1332 {
					if b {
						yynn1332++
					}
				}
				r.EncodeMapStart(yynn1332)
				yynn1332 = 0
			}
			if yyr1332 || yy2arr1332 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1332[0] {
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1332[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("waiting"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1332 || yy2arr1332 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1332[1] {
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1332[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("running"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1332 || yy2arr1332 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1332[2] {
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1332[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminated"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1332 || yy2arr1332 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerState) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1336 := z.DecBinary()
	_ = yym1336
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1337 := r.ContainerType()
		if yyct1337 == codecSelferValueTypeMap1234 {
			yyl1337 := r.ReadMapStart()
			if yyl1337 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1337, d)
			}
		} else if yyct1337 == codecSelferValueTypeArray1234 {
			yyl1337 := r.ReadArrayStart()
			if yyl1337 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1337, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerState) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1338Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1338Slc
	var yyhl1338 bool = l >= 0
	for yyj1338 := 0; ; yyj1338++ {
		if yyhl1338 {
			if yyj1338 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1338Slc = r.DecodeBytes(yys1338Slc, true, true)
		yys1338 := string(yys1338Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1338 {
		case "waiting":
			if r.TryDecodeAsNil() {
				if x.Waiting != nil {
					x.Waiting = nil
				}
			} else {
				if x.Waiting == nil {
					x.Waiting = new(ContainerStateWaiting)
				}
				x.Waiting.CodecDecodeSelf(d)
			}
		case "running":
			if r.TryDecodeAsNil() {
				if x.Running != nil {
					x.Running = nil
				}
			} else {
				if x.Running == nil {
					x.Running = new(ContainerStateRunning)
				}
				x.Running.CodecDecodeSelf(d)
			}
		case "terminated":
			if r.TryDecodeAsNil() {
				if x.Terminated != nil {
					x.Terminated = nil
				}
			} else {
				if x.Terminated == nil {
					x.Terminated = new(ContainerStateTerminated)
				}
				x.Terminated.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1338)
		} // end switch yys1338
	} // end for yyj1338
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerState) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1342 int
	var yyb1342 bool
	var yyhl1342 bool = l >= 0
	yyj1342++
	if yyhl1342 {
		yyb1342 = yyj1342 > l
	} else {
		yyb1342 = r.CheckBreak()
	}
	if yyb1342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Waiting != nil {
			x.Waiting = nil
		}
	} else {
		if x.Waiting == nil {
			x.Waiting = new(ContainerStateWaiting)
		}
		x.Waiting.CodecDecodeSelf(d)
	}
	yyj1342++
	if yyhl1342 {
		yyb1342 = yyj1342 > l
	} else {
		yyb1342 = r.CheckBreak()
	}
	if yyb1342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Running != nil {
			x.Running = nil
		}
	} else {
		if x.Running == nil {
			x.Running = new(ContainerStateRunning)
		}
		x.Running.CodecDecodeSelf(d)
	}
	yyj1342++
	if yyhl1342 {
		yyb1342 = yyj1342 > l
	} else {
		yyb1342 = r.CheckBreak()
	}
	if yyb1342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Terminated != nil {
			x.Terminated = nil
		}
	} else {
		if x.Terminated == nil {
			x.Terminated = new(ContainerStateTerminated)
		}
		x.Terminated.CodecDecodeSelf(d)
	}
	for {
		yyj1342++
		if yyhl1342 {
			yyb1342 = yyj1342 > l
		} else {
			yyb1342 = r.CheckBreak()
		}
		if yyb1342 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1342-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1346 := z.EncBinary()
		_ = yym1346
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1347 := !z.EncBinary()
			yy2arr1347 := z.EncBasicHandle().StructToArray
			var yyq1347 [8]bool
			_, _, _ = yysep1347, yyq1347, yy2arr1347
			const yyr1347 bool = false
			yyq1347[1] = true
			yyq1347[2] = true
			yyq1347[7] = x.ContainerID != ""
			var yynn1347 int
			if yyr1347 || yy2arr1347 {
				r.EncodeArrayStart(8)
			} else {
				yynn1347 = 5
				for _, b := range yyq1347 {
					if b {
						yynn1347++
					}
				}
				r.EncodeMapStart(yynn1347)
				yynn1347 = 0
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1349 := z.EncBinary()
				_ = yym1349
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1350 := z.EncBinary()
				_ = yym1350
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1347[1] {
					yy1352 := &x.State
					yy1352.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1347[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("state"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1353 := &x.State
					yy1353.CodecEncodeSelf(e)
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1347[2] {
					yy1355 := &x.LastTerminationState
					yy1355.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1347[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastState"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1356 := &x.LastTerminationState
					yy1356.CodecEncodeSelf(e)
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1358 := z.EncBinary()
				_ = yym1358
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ready"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1359 := z.EncBinary()
				_ = yym1359
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1361 := z.EncBinary()
				_ = yym1361
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("restartCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1362 := z.EncBinary()
				_ = yym1362
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1364 := z.EncBinary()
				_ = yym1364
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1365 := z.EncBinary()
				_ = yym1365
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1367 := z.EncBinary()
				_ = yym1367
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1368 := z.EncBinary()
				_ = yym1368
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1347[7] {
					yym1370 := z.EncBinary()
					_ = yym1370
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1347[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1371 := z.EncBinary()
					_ = yym1371
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1347 || yy2arr1347 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1372 := z.DecBinary()
	_ = yym1372
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1373 := r.ContainerType()
		if yyct1373 == codecSelferValueTypeMap1234 {
			yyl1373 := r.ReadMapStart()
			if yyl1373 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1373, d)
			}
		} else if yyct1373 == codecSelferValueTypeArray1234 {
			yyl1373 := r.ReadArrayStart()
			if yyl1373 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1373, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1374Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1374Slc
	var yyhl1374 bool = l >= 0
	for yyj1374 := 0; ; yyj1374++ {
		if yyhl1374 {
			if yyj1374 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1374Slc = r.DecodeBytes(yys1374Slc, true, true)
		yys1374 := string(yys1374Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1374 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "state":
			if r.TryDecodeAsNil() {
				x.State = ContainerState{}
			} else {
				yyv1376 := &x.State
				yyv1376.CodecDecodeSelf(d)
			}
		case "lastState":
			if r.TryDecodeAsNil() {
				x.LastTerminationState = ContainerState{}
			} else {
				yyv1377 := &x.LastTerminationState
				yyv1377.CodecDecodeSelf(d)
			}
		case "ready":
			if r.TryDecodeAsNil() {
				x.Ready = false
			} else {
				x.Ready = bool(r.DecodeBool())
			}
		case "restartCount":
			if r.TryDecodeAsNil() {
				x.RestartCount = 0
			} else {
				x.RestartCount = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "imageID":
			if r.TryDecodeAsNil() {
				x.ImageID = ""
			} else {
				x.ImageID = string(r.DecodeString())
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1374)
		} // end switch yys1374
	} // end for yyj1374
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1383 int
	var yyb1383 bool
	var yyhl1383 bool = l >= 0
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.State = ContainerState{}
	} else {
		yyv1385 := &x.State
		yyv1385.CodecDecodeSelf(d)
	}
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTerminationState = ContainerState{}
	} else {
		yyv1386 := &x.LastTerminationState
		yyv1386.CodecDecodeSelf(d)
	}
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ready = false
	} else {
		x.Ready = bool(r.DecodeBool())
	}
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartCount = 0
	} else {
		x.RestartCount = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageID = ""
	} else {
		x.ImageID = string(r.DecodeString())
	}
	yyj1383++
	if yyhl1383 {
		yyb1383 = yyj1383 > l
	} else {
		yyb1383 = r.CheckBreak()
	}
	if yyb1383 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1383++
		if yyhl1383 {
			yyb1383 = yyj1383 > l
		} else {
			yyb1383 = r.CheckBreak()
		}
		if yyb1383 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1383-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1392 := z.EncBinary()
	_ = yym1392
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1393 := z.DecBinary()
	_ = yym1393
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PodConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1394 := z.EncBinary()
	_ = yym1394
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1395 := z.DecBinary()
	_ = yym1395
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1396 := z.EncBinary()
		_ = yym1396
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1397 := !z.EncBinary()
			yy2arr1397 := z.EncBasicHandle().StructToArray
			var yyq1397 [6]bool
			_, _, _ = yysep1397, yyq1397, yy2arr1397
			const yyr1397 bool = false
			yyq1397[2] = true
			yyq1397[3] = true
			yyq1397[4] = x.Reason != ""
			yyq1397[5] = x.Message != ""
			var yynn1397 int
			if yyr1397 || yy2arr1397 {
				r.EncodeArrayStart(6)
			} else {
				yynn1397 = 2
				for _, b := range yyq1397 {
					if b {
						yynn1397++
					}
				}
				r.EncodeMapStart(yynn1397)
				yynn1397 = 0
			}
			if yyr1397 || yy2arr1397 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1397 || yy2arr1397 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr1397 || yy2arr1397 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1397[2] {
					yy1401 := &x.LastProbeTime
					yym1402 := z.EncBinary()
					_ = yym1402
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1401) {
					} else if yym1402 {
						z.EncBinaryMarshal(yy1401)
					} else if !yym1402 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1401)
					} else {
						z.EncFallback(yy1401)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1397[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1403 := &x.LastProbeTime
					yym1404 := z.EncBinary()
					_ = yym1404
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1403) {
					} else if yym1404 {
						z.EncBinaryMarshal(yy1403)
					} else if !yym1404 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1403)
					} else {
						z.EncFallback(yy1403)
					}
				}
			}
			if yyr1397 || yy2arr1397 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1397[3] {
					yy1406 := &x.LastTransitionTime
					yym1407 := z.EncBinary()
					_ = yym1407
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1406) {
					} else if yym1407 {
						z.EncBinaryMarshal(yy1406)
					} else if !yym1407 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1406)
					} else {
						z.EncFallback(yy1406)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1397[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1408 := &x.LastTransitionTime
					yym1409 := z.EncBinary()
					_ = yym1409
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1408) {
					} else if yym1409 {
						z.EncBinaryMarshal(yy1408)
					} else if !yym1409 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1408)
					} else {
						z.EncFallback(yy1408)
					}
				}
			}
			if yyr1397 || yy2arr1397 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1397[4] {
					yym1411 := z.EncBinary()
					_ = yym1411
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1397[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1412 := z.EncBinary()
					_ = yym1412
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1397 || yy2arr1397 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1397[5] {
					yym1414 := z.EncBinary()
					_ = yym1414
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1397[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1415 := z.EncBinary()
					_ = yym1415
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1397 || yy2arr1397 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1416 := z.DecBinary()
	_ = yym1416
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1417 := r.ContainerType()
		if yyct1417 == codecSelferValueTypeMap1234 {
			yyl1417 := r.ReadMapStart()
			if yyl1417 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1417, d)
			}
		} else if yyct1417 == codecSelferValueTypeArray1234 {
			yyl1417 := r.ReadArrayStart()
			if yyl1417 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1417, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1418Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1418Slc
	var yyhl1418 bool = l >= 0
	for yyj1418 := 0; ; yyj1418++ {
		if yyhl1418 {
			if yyj1418 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1418Slc = r.DecodeBytes(yys1418Slc, true, true)
		yys1418 := string(yys1418Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1418 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = PodConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg2_unversioned.Time{}
			} else {
				yyv1421 := &x.LastProbeTime
				yym1422 := z.DecBinary()
				_ = yym1422
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1421) {
				} else if yym1422 {
					z.DecBinaryUnmarshal(yyv1421)
				} else if !yym1422 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1421)
				} else {
					z.DecFallback(yyv1421, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv1423 := &x.LastTransitionTime
				yym1424 := z.DecBinary()
				_ = yym1424
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1423) {
				} else if yym1424 {
					z.DecBinaryUnmarshal(yyv1423)
				} else if !yym1424 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1423)
				} else {
					z.DecFallback(yyv1423, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1418)
		} // end switch yys1418
	} // end for yyj1418
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1427 int
	var yyb1427 bool
	var yyhl1427 bool = l >= 0
	yyj1427++
	if yyhl1427 {
		yyb1427 = yyj1427 > l
	} else {
		yyb1427 = r.CheckBreak()
	}
	if yyb1427 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = PodConditionType(r.DecodeString())
	}
	yyj1427++
	if yyhl1427 {
		yyb1427 = yyj1427 > l
	} else {
		yyb1427 = r.CheckBreak()
	}
	if yyb1427 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj1427++
	if yyhl1427 {
		yyb1427 = yyj1427 > l
	} else {
		yyb1427 = r.CheckBreak()
	}
	if yyb1427 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg2_unversioned.Time{}
	} else {
		yyv1430 := &x.LastProbeTime
		yym1431 := z.DecBinary()
		_ = yym1431
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1430) {
		} else if yym1431 {
			z.DecBinaryUnmarshal(yyv1430)
		} else if !yym1431 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1430)
		} else {
			z.DecFallback(yyv1430, false)
		}
	}
	yyj1427++
	if yyhl1427 {
		yyb1427 = yyj1427 > l
	} else {
		yyb1427 = r.CheckBreak()
	}
	if yyb1427 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv1432 := &x.LastTransitionTime
		yym1433 := z.DecBinary()
		_ = yym1433
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1432) {
		} else if yym1433 {
			z.DecBinaryUnmarshal(yyv1432)
		} else if !yym1433 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1432)
		} else {
			z.DecFallback(yyv1432, false)
		}
	}
	yyj1427++
	if yyhl1427 {
		yyb1427 = yyj1427 > l
	} else {
		yyb1427 = r.CheckBreak()
	}
	if yyb1427 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1427++
	if yyhl1427 {
		yyb1427 = yyj1427 > l
	} else {
		yyb1427 = r.CheckBreak()
	}
	if yyb1427 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1427++
		if yyhl1427 {
			yyb1427 = yyj1427 > l
		} else {
			yyb1427 = r.CheckBreak()
		}
		if yyb1427 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1427-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RestartPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1436 := z.EncBinary()
	_ = yym1436
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RestartPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1437 := z.DecBinary()
	_ = yym1437
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1438 := z.EncBinary()
		_ = yym1438
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1439 := !z.EncBinary()
			yy2arr1439 := z.EncBasicHandle().StructToArray
			var yyq1439 [4]bool
			_, _, _ = yysep1439, yyq1439, yy2arr1439
			const yyr1439 bool = false
			yyq1439[0] = x.Kind != ""
			yyq1439[1] = x.APIVersion != ""
			yyq1439[2] = true
			var yynn1439 int
			if yyr1439 || yy2arr1439 {
				r.EncodeArrayStart(4)
			} else {
				yynn1439 = 1
				for _, b := range yyq1439 {
					if b {
						yynn1439++
					}
				}
				r.EncodeMapStart(yynn1439)
				yynn1439 = 0
			}
			if yyr1439 || yy2arr1439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1439[0] {
					yym1441 := z.EncBinary()
					_ = yym1441
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1439[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1442 := z.EncBinary()
					_ = yym1442
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1439 || yy2arr1439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1439[1] {
					yym1444 := z.EncBinary()
					_ = yym1444
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1439[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1445 := z.EncBinary()
					_ = yym1445
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1439 || yy2arr1439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1439[2] {
					yy1447 := &x.ListMeta
					yym1448 := z.EncBinary()
					_ = yym1448
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1447) {
					} else {
						z.EncFallback(yy1447)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1439[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1449 := &x.ListMeta
					yym1450 := z.EncBinary()
					_ = yym1450
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1449) {
					} else {
						z.EncFallback(yy1449)
					}
				}
			}
			if yyr1439 || yy2arr1439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1452 := z.EncBinary()
					_ = yym1452
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1453 := z.EncBinary()
					_ = yym1453
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			}
			if yyr1439 || yy2arr1439 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1454 := z.DecBinary()
	_ = yym1454
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1455 := r.ContainerType()
		if yyct1455 == codecSelferValueTypeMap1234 {
			yyl1455 := r.ReadMapStart()
			if yyl1455 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1455, d)
			}
		} else if yyct1455 == codecSelferValueTypeArray1234 {
			yyl1455 := r.ReadArrayStart()
			if yyl1455 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1455, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1456Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1456Slc
	var yyhl1456 bool = l >= 0
	for yyj1456 := 0; ; yyj1456++ {
		if yyhl1456 {
			if yyj1456 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1456Slc = r.DecodeBytes(yys1456Slc, true, true)
		yys1456 := string(yys1456Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1456 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1459 := &x.ListMeta
				yym1460 := z.DecBinary()
				_ = yym1460
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1459) {
				} else {
					z.DecFallback(yyv1459, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1461 := &x.Items
				yym1462 := z.DecBinary()
				_ = yym1462
				if false {
				} else {
					h.decSlicePod((*[]Pod)(yyv1461), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1456)
		} // end switch yys1456
	} // end for yyj1456
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1463 int
	var yyb1463 bool
	var yyhl1463 bool = l >= 0
	yyj1463++
	if yyhl1463 {
		yyb1463 = yyj1463 > l
	} else {
		yyb1463 = r.CheckBreak()
	}
	if yyb1463 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1463++
	if yyhl1463 {
		yyb1463 = yyj1463 > l
	} else {
		yyb1463 = r.CheckBreak()
	}
	if yyb1463 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1463++
	if yyhl1463 {
		yyb1463 = yyj1463 > l
	} else {
		yyb1463 = r.CheckBreak()
	}
	if yyb1463 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1466 := &x.ListMeta
		yym1467 := z.DecBinary()
		_ = yym1467
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1466) {
		} else {
			z.DecFallback(yyv1466, false)
		}
	}
	yyj1463++
	if yyhl1463 {
		yyb1463 = yyj1463 > l
	} else {
		yyb1463 = r.CheckBreak()
	}
	if yyb1463 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1468 := &x.Items
		yym1469 := z.DecBinary()
		_ = yym1469
		if false {
		} else {
			h.decSlicePod((*[]Pod)(yyv1468), d)
		}
	}
	for {
		yyj1463++
		if yyhl1463 {
			yyb1463 = yyj1463 > l
		} else {
			yyb1463 = r.CheckBreak()
		}
		if yyb1463 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1463-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DNSPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1470 := z.EncBinary()
	_ = yym1470
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DNSPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1471 := z.DecBinary()
	_ = yym1471
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1472 := z.EncBinary()
		_ = yym1472
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1473 := !z.EncBinary()
			yy2arr1473 := z.EncBasicHandle().StructToArray
			var yyq1473 [11]bool
			_, _, _ = yysep1473, yyq1473, yy2arr1473
			const yyr1473 bool = false
			yyq1473[2] = x.RestartPolicy != ""
			yyq1473[3] = x.TerminationGracePeriodSeconds != nil
			yyq1473[4] = x.ActiveDeadlineSeconds != nil
			yyq1473[5] = x.DNSPolicy != ""
			yyq1473[6] = len(x.NodeSelector) != 0
			yyq1473[8] = x.NodeName != ""
			yyq1473[9] = x.SecurityContext != nil
			yyq1473[10] = len(x.ImagePullSecrets) != 0
			var yynn1473 int
			if yyr1473 || yy2arr1473 {
				r.EncodeArrayStart(11)
			} else {
				yynn1473 = 3
				for _, b := range yyq1473 {
					if b {
						yynn1473++
					}
				}
				r.EncodeMapStart(yynn1473)
				yynn1473 = 0
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Volumes == nil {
					r.EncodeNil()
				} else {
					yym1475 := z.EncBinary()
					_ = yym1475
					if false {
					} else {
						h.encSliceVolume(([]Volume)(x.Volumes), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Volumes == nil {
					r.EncodeNil()
				} else {
					yym1476 := z.EncBinary()
					_ = yym1476
					if false {
					} else {
						h.encSliceVolume(([]Volume)(x.Volumes), e)
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym1478 := z.EncBinary()
					_ = yym1478
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym1479 := z.EncBinary()
					_ = yym1479
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[2] {
					x.RestartPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1473[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("restartPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.RestartPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[3] {
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy1482 := *x.TerminationGracePeriodSeconds
						yym1483 := z.EncBinary()
						_ = yym1483
						if false {
						} else {
							r.EncodeInt(int64(yy1482))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1473[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy1484 := *x.TerminationGracePeriodSeconds
						yym1485 := z.EncBinary()
						_ = yym1485
						if false {
						} else {
							r.EncodeInt(int64(yy1484))
						}
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[4] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy1487 := *x.ActiveDeadlineSeconds
						yym1488 := z.EncBinary()
						_ = yym1488
						if false {
						} else {
							r.EncodeInt(int64(yy1487))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1473[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy1489 := *x.ActiveDeadlineSeconds
						yym1490 := z.EncBinary()
						_ = yym1490
						if false {
						} else {
							r.EncodeInt(int64(yy1489))
						}
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[5] {
					x.DNSPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1473[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("dnsPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.DNSPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[6] {
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym1493 := z.EncBinary()
						_ = yym1493
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1473[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym1494 := z.EncBinary()
						_ = yym1494
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1496 := z.EncBinary()
				_ = yym1496
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1497 := z.EncBinary()
				_ = yym1497
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[8] {
					yym1499 := z.EncBinary()
					_ = yym1499
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1473[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1500 := z.EncBinary()
					_ = yym1500
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[9] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1473[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1473[10] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym1503 := z.EncBinary()
						_ = yym1503
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1473[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym1504 := z.EncBinary()
						_ = yym1504
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr1473 || yy2arr1473 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1505 := z.DecBinary()
	_ = yym1505
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1506 := r.ContainerType()
		if yyct1506 == codecSelferValueTypeMap1234 {
			yyl1506 := r.ReadMapStart()
			if yyl1506 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1506, d)
			}
		} else if yyct1506 == codecSelferValueTypeArray1234 {
			yyl1506 := r.ReadArrayStart()
			if yyl1506 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1506, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1507Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1507Slc
	var yyhl1507 bool = l >= 0
	for yyj1507 := 0; ; yyj1507++ {
		if yyhl1507 {
			if yyj1507 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1507Slc = r.DecodeBytes(yys1507Slc, true, true)
		yys1507 := string(yys1507Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1507 {
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv1508 := &x.Volumes
				yym1509 := z.DecBinary()
				_ = yym1509
				if false {
				} else {
					h.decSliceVolume((*[]Volume)(yyv1508), d)
				}
			}
		case "containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv1510 := &x.Containers
				yym1511 := z.DecBinary()
				_ = yym1511
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv1510), d)
				}
			}
		case "restartPolicy":
			if r.TryDecodeAsNil() {
				x.RestartPolicy = ""
			} else {
				x.RestartPolicy = RestartPolicy(r.DecodeString())
			}
		case "terminationGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.TerminationGracePeriodSeconds != nil {
					x.TerminationGracePeriodSeconds = nil
				}
			} else {
				if x.TerminationGracePeriodSeconds == nil {
					x.TerminationGracePeriodSeconds = new(int64)
				}
				yym1514 := z.DecBinary()
				_ = yym1514
				if false {
				} else {
					*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym1516 := z.DecBinary()
				_ = yym1516
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "dnsPolicy":
			if r.TryDecodeAsNil() {
				x.DNSPolicy = ""
			} else {
				x.DNSPolicy = DNSPolicy(r.DecodeString())
			}
		case "nodeSelector":
			if r.TryDecodeAsNil() {
				x.NodeSelector = nil
			} else {
				yyv1518 := &x.NodeSelector
				yym1519 := z.DecBinary()
				_ = yym1519
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1518, false, d)
				}
			}
		case "serviceAccountName":
			if r.TryDecodeAsNil() {
				x.ServiceAccountName = ""
			} else {
				x.ServiceAccountName = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				x.NodeName = ""
			} else {
				x.NodeName = string(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(PodSecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv1523 := &x.ImagePullSecrets
				yym1524 := z.DecBinary()
				_ = yym1524
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv1523), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1507)
		} // end switch yys1507
	} // end for yyj1507
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1525 int
	var yyb1525 bool
	var yyhl1525 bool = l >= 0
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv1526 := &x.Volumes
		yym1527 := z.DecBinary()
		_ = yym1527
		if false {
		} else {
			h.decSliceVolume((*[]Volume)(yyv1526), d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv1528 := &x.Containers
		yym1529 := z.DecBinary()
		_ = yym1529
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv1528), d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartPolicy = ""
	} else {
		x.RestartPolicy = RestartPolicy(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TerminationGracePeriodSeconds != nil {
			x.TerminationGracePeriodSeconds = nil
		}
	} else {
		if x.TerminationGracePeriodSeconds == nil {
			x.TerminationGracePeriodSeconds = new(int64)
		}
		yym1532 := z.DecBinary()
		_ = yym1532
		if false {
		} else {
			*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym1534 := z.DecBinary()
		_ = yym1534
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DNSPolicy = ""
	} else {
		x.DNSPolicy = DNSPolicy(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelector = nil
	} else {
		yyv1536 := &x.NodeSelector
		yym1537 := z.DecBinary()
		_ = yym1537
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1536, false, d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountName = ""
	} else {
		x.ServiceAccountName = string(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeName = ""
	} else {
		x.NodeName = string(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(PodSecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv1541 := &x.ImagePullSecrets
		yym1542 := z.DecBinary()
		_ = yym1542
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv1541), d)
		}
	}
	for {
		yyj1525++
		if yyhl1525 {
			yyb1525 = yyj1525 > l
		} else {
			yyb1525 = r.CheckBreak()
		}
		if yyb1525 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1525-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityContext) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1543 := z.EncBinary()
		_ = yym1543
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1544 := !z.EncBinary()
			yy2arr1544 := z.EncBasicHandle().StructToArray
			var yyq1544 [8]bool
			_, _, _ = yysep1544, yyq1544, yy2arr1544
			const yyr1544 bool = false
			yyq1544[0] = x.HostNetwork != false
			yyq1544[1] = x.HostPID != false
			yyq1544[2] = x.HostIPC != false
			yyq1544[3] = x.SELinuxOptions != nil
			yyq1544[4] = x.RunAsUser != nil
			yyq1544[5] = x.RunAsNonRoot != nil
			yyq1544[6] = len(x.SupplementalGroups) != 0
			yyq1544[7] = x.FSGroup != nil
			var yynn1544 int
			if yyr1544 || yy2arr1544 {
				r.EncodeArrayStart(8)
			} else {
				yynn1544 = 0
				for _, b := range yyq1544 {
					if b {
						yynn1544++
					}
				}
				r.EncodeMapStart(yynn1544)
				yynn1544 = 0
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[0] {
					yym1546 := z.EncBinary()
					_ = yym1546
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1544[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1547 := z.EncBinary()
					_ = yym1547
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[1] {
					yym1549 := z.EncBinary()
					_ = yym1549
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1544[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1550 := z.EncBinary()
					_ = yym1550
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[2] {
					yym1552 := z.EncBinary()
					_ = yym1552
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1544[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1553 := z.EncBinary()
					_ = yym1553
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[3] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1544[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[4] {
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy1556 := *x.RunAsUser
						yym1557 := z.EncBinary()
						_ = yym1557
						if false {
						} else {
							r.EncodeInt(int64(yy1556))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1544[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy1558 := *x.RunAsUser
						yym1559 := z.EncBinary()
						_ = yym1559
						if false {
						} else {
							r.EncodeInt(int64(yy1558))
						}
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[5] {
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy1561 := *x.RunAsNonRoot
						yym1562 := z.EncBinary()
						_ = yym1562
						if false {
						} else {
							r.EncodeBool(bool(yy1561))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1544[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsNonRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy1563 := *x.RunAsNonRoot
						yym1564 := z.EncBinary()
						_ = yym1564
						if false {
						} else {
							r.EncodeBool(bool(yy1563))
						}
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[6] {
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym1566 := z.EncBinary()
						_ = yym1566
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1544[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym1567 := z.EncBinary()
						_ = yym1567
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1544[7] {
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy1569 := *x.FSGroup
						yym1570 := z.EncBinary()
						_ = yym1570
						if false {
						} else {
							r.EncodeInt(int64(yy1569))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1544[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy1571 := *x.FSGroup
						yym1572 := z.EncBinary()
						_ = yym1572
						if false {
						} else {
							r.EncodeInt(int64(yy1571))
						}
					}
				}
			}
			if yyr1544 || yy2arr1544 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityContext) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1573 := z.DecBinary()
	_ = yym1573
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1574 := r.ContainerType()
		if yyct1574 == codecSelferValueTypeMap1234 {
			yyl1574 := r.ReadMapStart()
			if yyl1574 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1574, d)
			}
		} else if yyct1574 == codecSelferValueTypeArray1234 {
			yyl1574 := r.ReadArrayStart()
			if yyl1574 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1574, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityContext) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1575Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1575Slc
	var yyhl1575 bool = l >= 0
	for yyj1575 := 0; ; yyj1575++ {
		if yyhl1575 {
			if yyj1575 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1575Slc = r.DecodeBytes(yys1575Slc, true, true)
		yys1575 := string(yys1575Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1575 {
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				if x.RunAsUser != nil {
					x.RunAsUser = nil
				}
			} else {
				if x.RunAsUser == nil {
					x.RunAsUser = new(int64)
				}
				yym1581 := z.DecBinary()
				_ = yym1581
				if false {
				} else {
					*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
				}
			}
		case "runAsNonRoot":
			if r.TryDecodeAsNil() {
				if x.RunAsNonRoot != nil {
					x.RunAsNonRoot = nil
				}
			} else {
				if x.RunAsNonRoot == nil {
					x.RunAsNonRoot = new(bool)
				}
				yym1583 := z.DecBinary()
				_ = yym1583
				if false {
				} else {
					*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
				}
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = nil
			} else {
				yyv1584 := &x.SupplementalGroups
				yym1585 := z.DecBinary()
				_ = yym1585
				if false {
				} else {
					z.F.DecSliceInt64X(yyv1584, false, d)
				}
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				if x.FSGroup != nil {
					x.FSGroup = nil
				}
			} else {
				if x.FSGroup == nil {
					x.FSGroup = new(int64)
				}
				yym1587 := z.DecBinary()
				_ = yym1587
				if false {
				} else {
					*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1575)
		} // end switch yys1575
	} // end for yyj1575
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityContext) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1588 int
	var yyb1588 bool
	var yyhl1588 bool = l >= 0
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsUser != nil {
			x.RunAsUser = nil
		}
	} else {
		if x.RunAsUser == nil {
			x.RunAsUser = new(int64)
		}
		yym1594 := z.DecBinary()
		_ = yym1594
		if false {
		} else {
			*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
		}
	}
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsNonRoot != nil {
			x.RunAsNonRoot = nil
		}
	} else {
		if x.RunAsNonRoot == nil {
			x.RunAsNonRoot = new(bool)
		}
		yym1596 := z.DecBinary()
		_ = yym1596
		if false {
		} else {
			*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
		}
	}
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = nil
	} else {
		yyv1597 := &x.SupplementalGroups
		yym1598 := z.DecBinary()
		_ = yym1598
		if false {
		} else {
			z.F.DecSliceInt64X(yyv1597, false, d)
		}
	}
	yyj1588++
	if yyhl1588 {
		yyb1588 = yyj1588 > l
	} else {
		yyb1588 = r.CheckBreak()
	}
	if yyb1588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSGroup != nil {
			x.FSGroup = nil
		}
	} else {
		if x.FSGroup == nil {
			x.FSGroup = new(int64)
		}
		yym1600 := z.DecBinary()
		_ = yym1600
		if false {
		} else {
			*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj1588++
		if yyhl1588 {
			yyb1588 = yyj1588 > l
		} else {
			yyb1588 = r.CheckBreak()
		}
		if yyb1588 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1588-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1601 := z.EncBinary()
		_ = yym1601
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1602 := !z.EncBinary()
			yy2arr1602 := z.EncBasicHandle().StructToArray
			var yyq1602 [8]bool
			_, _, _ = yysep1602, yyq1602, yy2arr1602
			const yyr1602 bool = false
			yyq1602[0] = x.Phase != ""
			yyq1602[1] = len(x.Conditions) != 0
			yyq1602[2] = x.Message != ""
			yyq1602[3] = x.Reason != ""
			yyq1602[4] = x.HostIP != ""
			yyq1602[5] = x.PodIP != ""
			yyq1602[6] = x.StartTime != nil
			yyq1602[7] = len(x.ContainerStatuses) != 0
			var yynn1602 int
			if yyr1602 || yy2arr1602 {
				r.EncodeArrayStart(8)
			} else {
				yynn1602 = 0
				for _, b := range yyq1602 {
					if b {
						yynn1602++
					}
				}
				r.EncodeMapStart(yynn1602)
				yynn1602 = 0
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1602[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[1] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym1605 := z.EncBinary()
						_ = yym1605
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1602[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym1606 := z.EncBinary()
						_ = yym1606
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[2] {
					yym1608 := z.EncBinary()
					_ = yym1608
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1602[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1609 := z.EncBinary()
					_ = yym1609
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[3] {
					yym1611 := z.EncBinary()
					_ = yym1611
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1602[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1612 := z.EncBinary()
					_ = yym1612
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[4] {
					yym1614 := z.EncBinary()
					_ = yym1614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1602[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1615 := z.EncBinary()
					_ = yym1615
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[5] {
					yym1617 := z.EncBinary()
					_ = yym1617
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1602[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1618 := z.EncBinary()
					_ = yym1618
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[6] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym1620 := z.EncBinary()
						_ = yym1620
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym1620 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym1620 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1602[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym1621 := z.EncBinary()
						_ = yym1621
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym1621 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym1621 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1602[7] {
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym1623 := z.EncBinary()
						_ = yym1623
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1602[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym1624 := z.EncBinary()
						_ = yym1624
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				}
			}
			if yyr1602 || yy2arr1602 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1625 := z.DecBinary()
	_ = yym1625
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1626 := r.ContainerType()
		if yyct1626 == codecSelferValueTypeMap1234 {
			yyl1626 := r.ReadMapStart()
			if yyl1626 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1626, d)
			}
		} else if yyct1626 == codecSelferValueTypeArray1234 {
			yyl1626 := r.ReadArrayStart()
			if yyl1626 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1626, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1627Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1627Slc
	var yyhl1627 bool = l >= 0
	for yyj1627 := 0; ; yyj1627++ {
		if yyhl1627 {
			if yyj1627 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1627Slc = r.DecodeBytes(yys1627Slc, true, true)
		yys1627 := string(yys1627Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1627 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PodPhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv1629 := &x.Conditions
				yym1630 := z.DecBinary()
				_ = yym1630
				if false {
				} else {
					h.decSlicePodCondition((*[]PodCondition)(yyv1629), d)
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		case "podIP":
			if r.TryDecodeAsNil() {
				x.PodIP = ""
			} else {
				x.PodIP = string(r.DecodeString())
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg2_unversioned.Time)
				}
				yym1636 := z.DecBinary()
				_ = yym1636
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym1636 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym1636 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "containerStatuses":
			if r.TryDecodeAsNil() {
				x.ContainerStatuses = nil
			} else {
				yyv1637 := &x.ContainerStatuses
				yym1638 := z.DecBinary()
				_ = yym1638
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv1637), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1627)
		} // end switch yys1627
	} // end for yyj1627
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1639 int
	var yyb1639 bool
	var yyhl1639 bool = l >= 0
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PodPhase(r.DecodeString())
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv1641 := &x.Conditions
		yym1642 := z.DecBinary()
		_ = yym1642
		if false {
		} else {
			h.decSlicePodCondition((*[]PodCondition)(yyv1641), d)
		}
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodIP = ""
	} else {
		x.PodIP = string(r.DecodeString())
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg2_unversioned.Time)
		}
		yym1648 := z.DecBinary()
		_ = yym1648
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym1648 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym1648 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerStatuses = nil
	} else {
		yyv1649 := &x.ContainerStatuses
		yym1650 := z.DecBinary()
		_ = yym1650
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv1649), d)
		}
	}
	for {
		yyj1639++
		if yyhl1639 {
			yyb1639 = yyj1639 > l
		} else {
			yyb1639 = r.CheckBreak()
		}
		if yyb1639 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1639-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatusResult) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1651 := z.EncBinary()
		_ = yym1651
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1652 := !z.EncBinary()
			yy2arr1652 := z.EncBasicHandle().StructToArray
			var yyq1652 [4]bool
			_, _, _ = yysep1652, yyq1652, yy2arr1652
			const yyr1652 bool = false
			yyq1652[0] = x.Kind != ""
			yyq1652[1] = x.APIVersion != ""
			yyq1652[2] = true
			yyq1652[3] = true
			var yynn1652 int
			if yyr1652 || yy2arr1652 {
				r.EncodeArrayStart(4)
			} else {
				yynn1652 = 0
				for _, b := range yyq1652 {
					if b {
						yynn1652++
					}
				}
				r.EncodeMapStart(yynn1652)
				yynn1652 = 0
			}
			if yyr1652 || yy2arr1652 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1652[0] {
					yym1654 := z.EncBinary()
					_ = yym1654
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1652[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1655 := z.EncBinary()
					_ = yym1655
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1652 || yy2arr1652 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1652[1] {
					yym1657 := z.EncBinary()
					_ = yym1657
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1652[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1658 := z.EncBinary()
					_ = yym1658
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1652 || yy2arr1652 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1652[2] {
					yy1660 := &x.ObjectMeta
					yy1660.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1652[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1661 := &x.ObjectMeta
					yy1661.CodecEncodeSelf(e)
				}
			}
			if yyr1652 || yy2arr1652 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1652[3] {
					yy1663 := &x.Status
					yy1663.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1652[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1664 := &x.Status
					yy1664.CodecEncodeSelf(e)
				}
			}
			if yyr1652 || yy2arr1652 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatusResult) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1665 := z.DecBinary()
	_ = yym1665
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1666 := r.ContainerType()
		if yyct1666 == codecSelferValueTypeMap1234 {
			yyl1666 := r.ReadMapStart()
			if yyl1666 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1666, d)
			}
		} else if yyct1666 == codecSelferValueTypeArray1234 {
			yyl1666 := r.ReadArrayStart()
			if yyl1666 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1666, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatusResult) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1667Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1667Slc
	var yyhl1667 bool = l >= 0
	for yyj1667 := 0; ; yyj1667++ {
		if yyhl1667 {
			if yyj1667 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1667Slc = r.DecodeBytes(yys1667Slc, true, true)
		yys1667 := string(yys1667Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1667 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1670 := &x.ObjectMeta
				yyv1670.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv1671 := &x.Status
				yyv1671.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1667)
		} // end switch yys1667
	} // end for yyj1667
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatusResult) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1672 int
	var yyb1672 bool
	var yyhl1672 bool = l >= 0
	yyj1672++
	if yyhl1672 {
		yyb1672 = yyj1672 > l
	} else {
		yyb1672 = r.CheckBreak()
	}
	if yyb1672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1672++
	if yyhl1672 {
		yyb1672 = yyj1672 > l
	} else {
		yyb1672 = r.CheckBreak()
	}
	if yyb1672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1672++
	if yyhl1672 {
		yyb1672 = yyj1672 > l
	} else {
		yyb1672 = r.CheckBreak()
	}
	if yyb1672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1675 := &x.ObjectMeta
		yyv1675.CodecDecodeSelf(d)
	}
	yyj1672++
	if yyhl1672 {
		yyb1672 = yyj1672 > l
	} else {
		yyb1672 = r.CheckBreak()
	}
	if yyb1672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv1676 := &x.Status
		yyv1676.CodecDecodeSelf(d)
	}
	for {
		yyj1672++
		if yyhl1672 {
			yyb1672 = yyj1672 > l
		} else {
			yyb1672 = r.CheckBreak()
		}
		if yyb1672 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1672-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Pod) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1677 := z.EncBinary()
		_ = yym1677
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1678 := !z.EncBinary()
			yy2arr1678 := z.EncBasicHandle().StructToArray
			var yyq1678 [5]bool
			_, _, _ = yysep1678, yyq1678, yy2arr1678
			const yyr1678 bool = false
			yyq1678[0] = x.Kind != ""
			yyq1678[1] = x.APIVersion != ""
			yyq1678[2] = true
			yyq1678[3] = true
			yyq1678[4] = true
			var yynn1678 int
			if yyr1678 || yy2arr1678 {
				r.EncodeArrayStart(5)
			} else {
				yynn1678 = 0
				for _, b := range yyq1678 {
					if b {
						yynn1678++
					}
				}
				r.EncodeMapStart(yynn1678)
				yynn1678 = 0
			}
			if yyr1678 || yy2arr1678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1678[0] {
					yym1680 := z.EncBinary()
					_ = yym1680
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1678[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1681 := z.EncBinary()
					_ = yym1681
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1678 || yy2arr1678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1678[1] {
					yym1683 := z.EncBinary()
					_ = yym1683
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1678[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1684 := z.EncBinary()
					_ = yym1684
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1678 || yy2arr1678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1678[2] {
					yy1686 := &x.ObjectMeta
					yy1686.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1678[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1687 := &x.ObjectMeta
					yy1687.CodecEncodeSelf(e)
				}
			}
			if yyr1678 || yy2arr1678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1678[3] {
					yy1689 := &x.Spec
					yy1689.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1678[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1690 := &x.Spec
					yy1690.CodecEncodeSelf(e)
				}
			}
			if yyr1678 || yy2arr1678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1678[4] {
					yy1692 := &x.Status
					yy1692.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1678[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1693 := &x.Status
					yy1693.CodecEncodeSelf(e)
				}
			}
			if yyr1678 || yy2arr1678 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Pod) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1694 := z.DecBinary()
	_ = yym1694
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1695 := r.ContainerType()
		if yyct1695 == codecSelferValueTypeMap1234 {
			yyl1695 := r.ReadMapStart()
			if yyl1695 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1695, d)
			}
		} else if yyct1695 == codecSelferValueTypeArray1234 {
			yyl1695 := r.ReadArrayStart()
			if yyl1695 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1695, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Pod) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1696Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1696Slc
	var yyhl1696 bool = l >= 0
	for yyj1696 := 0; ; yyj1696++ {
		if yyhl1696 {
			if yyj1696 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1696Slc = r.DecodeBytes(yys1696Slc, true, true)
		yys1696 := string(yys1696Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1696 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1699 := &x.ObjectMeta
				yyv1699.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv1700 := &x.Spec
				yyv1700.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv1701 := &x.Status
				yyv1701.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1696)
		} // end switch yys1696
	} // end for yyj1696
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Pod) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1702 int
	var yyb1702 bool
	var yyhl1702 bool = l >= 0
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1705 := &x.ObjectMeta
		yyv1705.CodecDecodeSelf(d)
	}
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv1706 := &x.Spec
		yyv1706.CodecDecodeSelf(d)
	}
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv1707 := &x.Status
		yyv1707.CodecDecodeSelf(d)
	}
	for {
		yyj1702++
		if yyhl1702 {
			yyb1702 = yyj1702 > l
		} else {
			yyb1702 = r.CheckBreak()
		}
		if yyb1702 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1702-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1708 := z.EncBinary()
		_ = yym1708
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1709 := !z.EncBinary()
			yy2arr1709 := z.EncBasicHandle().StructToArray
			var yyq1709 [2]bool
			_, _, _ = yysep1709, yyq1709, yy2arr1709
			const yyr1709 bool = false
			yyq1709[0] = true
			yyq1709[1] = true
			var yynn1709 int
			if yyr1709 || yy2arr1709 {
				r.EncodeArrayStart(2)
			} else {
				yynn1709 = 0
				for _, b := range yyq1709 {
					if b {
						yynn1709++
					}
				}
				r.EncodeMapStart(yynn1709)
				yynn1709 = 0
			}
			if yyr1709 || yy2arr1709 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1709[0] {
					yy1711 := &x.ObjectMeta
					yy1711.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1709[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1712 := &x.ObjectMeta
					yy1712.CodecEncodeSelf(e)
				}
			}
			if yyr1709 || yy2arr1709 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1709[1] {
					yy1714 := &x.Spec
					yy1714.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1709[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1715 := &x.Spec
					yy1715.CodecEncodeSelf(e)
				}
			}
			if yyr1709 || yy2arr1709 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1716 := z.DecBinary()
	_ = yym1716
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1717 := r.ContainerType()
		if yyct1717 == codecSelferValueTypeMap1234 {
			yyl1717 := r.ReadMapStart()
			if yyl1717 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1717, d)
			}
		} else if yyct1717 == codecSelferValueTypeArray1234 {
			yyl1717 := r.ReadArrayStart()
			if yyl1717 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1717, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1718Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1718Slc
	var yyhl1718 bool = l >= 0
	for yyj1718 := 0; ; yyj1718++ {
		if yyhl1718 {
			if yyj1718 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1718Slc = r.DecodeBytes(yys1718Slc, true, true)
		yys1718 := string(yys1718Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1718 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1719 := &x.ObjectMeta
				yyv1719.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv1720 := &x.Spec
				yyv1720.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1718)
		} // end switch yys1718
	} // end for yyj1718
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1721 int
	var yyb1721 bool
	var yyhl1721 bool = l >= 0
	yyj1721++
	if yyhl1721 {
		yyb1721 = yyj1721 > l
	} else {
		yyb1721 = r.CheckBreak()
	}
	if yyb1721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1722 := &x.ObjectMeta
		yyv1722.CodecDecodeSelf(d)
	}
	yyj1721++
	if yyhl1721 {
		yyb1721 = yyj1721 > l
	} else {
		yyb1721 = r.CheckBreak()
	}
	if yyb1721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv1723 := &x.Spec
		yyv1723.CodecDecodeSelf(d)
	}
	for {
		yyj1721++
		if yyhl1721 {
			yyb1721 = yyj1721 > l
		} else {
			yyb1721 = r.CheckBreak()
		}
		if yyb1721 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1721-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1724 := z.EncBinary()
		_ = yym1724
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1725 := !z.EncBinary()
			yy2arr1725 := z.EncBasicHandle().StructToArray
			var yyq1725 [4]bool
			_, _, _ = yysep1725, yyq1725, yy2arr1725
			const yyr1725 bool = false
			yyq1725[0] = x.Kind != ""
			yyq1725[1] = x.APIVersion != ""
			yyq1725[2] = true
			yyq1725[3] = true
			var yynn1725 int
			if yyr1725 || yy2arr1725 {
				r.EncodeArrayStart(4)
			} else {
				yynn1725 = 0
				for _, b := range yyq1725 {
					if b {
						yynn1725++
					}
				}
				r.EncodeMapStart(yynn1725)
				yynn1725 = 0
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1725[0] {
					yym1727 := z.EncBinary()
					_ = yym1727
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1725[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1728 := z.EncBinary()
					_ = yym1728
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1725[1] {
					yym1730 := z.EncBinary()
					_ = yym1730
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1725[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1731 := z.EncBinary()
					_ = yym1731
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1725[2] {
					yy1733 := &x.ObjectMeta
					yy1733.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1725[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1734 := &x.ObjectMeta
					yy1734.CodecEncodeSelf(e)
				}
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1725[3] {
					yy1736 := &x.Template
					yy1736.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1725[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1737 := &x.Template
					yy1737.CodecEncodeSelf(e)
				}
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1738 := z.DecBinary()
	_ = yym1738
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1739 := r.ContainerType()
		if yyct1739 == codecSelferValueTypeMap1234 {
			yyl1739 := r.ReadMapStart()
			if yyl1739 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1739, d)
			}
		} else if yyct1739 == codecSelferValueTypeArray1234 {
			yyl1739 := r.ReadArrayStart()
			if yyl1739 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1739, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1740Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1740Slc
	var yyhl1740 bool = l >= 0
	for yyj1740 := 0; ; yyj1740++ {
		if yyhl1740 {
			if yyj1740 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1740Slc = r.DecodeBytes(yys1740Slc, true, true)
		yys1740 := string(yys1740Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1740 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1743 := &x.ObjectMeta
				yyv1743.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = PodTemplateSpec{}
			} else {
				yyv1744 := &x.Template
				yyv1744.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1740)
		} // end switch yys1740
	} // end for yyj1740
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1745 int
	var yyb1745 bool
	var yyhl1745 bool = l >= 0
	yyj1745++
	if yyhl1745 {
		yyb1745 = yyj1745 > l
	} else {
		yyb1745 = r.CheckBreak()
	}
	if yyb1745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1745++
	if yyhl1745 {
		yyb1745 = yyj1745 > l
	} else {
		yyb1745 = r.CheckBreak()
	}
	if yyb1745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1745++
	if yyhl1745 {
		yyb1745 = yyj1745 > l
	} else {
		yyb1745 = r.CheckBreak()
	}
	if yyb1745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1748 := &x.ObjectMeta
		yyv1748.CodecDecodeSelf(d)
	}
	yyj1745++
	if yyhl1745 {
		yyb1745 = yyj1745 > l
	} else {
		yyb1745 = r.CheckBreak()
	}
	if yyb1745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = PodTemplateSpec{}
	} else {
		yyv1749 := &x.Template
		yyv1749.CodecDecodeSelf(d)
	}
	for {
		yyj1745++
		if yyhl1745 {
			yyb1745 = yyj1745 > l
		} else {
			yyb1745 = r.CheckBreak()
		}
		if yyb1745 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1745-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1750 := z.EncBinary()
		_ = yym1750
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1751 := !z.EncBinary()
			yy2arr1751 := z.EncBasicHandle().StructToArray
			var yyq1751 [4]bool
			_, _, _ = yysep1751, yyq1751, yy2arr1751
			const yyr1751 bool = false
			yyq1751[0] = x.Kind != ""
			yyq1751[1] = x.APIVersion != ""
			yyq1751[2] = true
			var yynn1751 int
			if yyr1751 || yy2arr1751 {
				r.EncodeArrayStart(4)
			} else {
				yynn1751 = 1
				for _, b := range yyq1751 {
					if b {
						yynn1751++
					}
				}
				r.EncodeMapStart(yynn1751)
				yynn1751 = 0
			}
			if yyr1751 || yy2arr1751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1751[0] {
					yym1753 := z.EncBinary()
					_ = yym1753
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1751[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1754 := z.EncBinary()
					_ = yym1754
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1751 || yy2arr1751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1751[1] {
					yym1756 := z.EncBinary()
					_ = yym1756
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1751[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1757 := z.EncBinary()
					_ = yym1757
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1751 || yy2arr1751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1751[2] {
					yy1759 := &x.ListMeta
					yym1760 := z.EncBinary()
					_ = yym1760
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1759) {
					} else {
						z.EncFallback(yy1759)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1751[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1761 := &x.ListMeta
					yym1762 := z.EncBinary()
					_ = yym1762
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1761) {
					} else {
						z.EncFallback(yy1761)
					}
				}
			}
			if yyr1751 || yy2arr1751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1764 := z.EncBinary()
					_ = yym1764
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1765 := z.EncBinary()
					_ = yym1765
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			}
			if yyr1751 || yy2arr1751 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1766 := z.DecBinary()
	_ = yym1766
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1767 := r.ContainerType()
		if yyct1767 == codecSelferValueTypeMap1234 {
			yyl1767 := r.ReadMapStart()
			if yyl1767 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1767, d)
			}
		} else if yyct1767 == codecSelferValueTypeArray1234 {
			yyl1767 := r.ReadArrayStart()
			if yyl1767 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1767, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1768Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1768Slc
	var yyhl1768 bool = l >= 0
	for yyj1768 := 0; ; yyj1768++ {
		if yyhl1768 {
			if yyj1768 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1768Slc = r.DecodeBytes(yys1768Slc, true, true)
		yys1768 := string(yys1768Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1768 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1771 := &x.ListMeta
				yym1772 := z.DecBinary()
				_ = yym1772
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1771) {
				} else {
					z.DecFallback(yyv1771, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1773 := &x.Items
				yym1774 := z.DecBinary()
				_ = yym1774
				if false {
				} else {
					h.decSlicePodTemplate((*[]PodTemplate)(yyv1773), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1768)
		} // end switch yys1768
	} // end for yyj1768
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1775 int
	var yyb1775 bool
	var yyhl1775 bool = l >= 0
	yyj1775++
	if yyhl1775 {
		yyb1775 = yyj1775 > l
	} else {
		yyb1775 = r.CheckBreak()
	}
	if yyb1775 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1775++
	if yyhl1775 {
		yyb1775 = yyj1775 > l
	} else {
		yyb1775 = r.CheckBreak()
	}
	if yyb1775 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1775++
	if yyhl1775 {
		yyb1775 = yyj1775 > l
	} else {
		yyb1775 = r.CheckBreak()
	}
	if yyb1775 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1778 := &x.ListMeta
		yym1779 := z.DecBinary()
		_ = yym1779
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1778) {
		} else {
			z.DecFallback(yyv1778, false)
		}
	}
	yyj1775++
	if yyhl1775 {
		yyb1775 = yyj1775 > l
	} else {
		yyb1775 = r.CheckBreak()
	}
	if yyb1775 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1780 := &x.Items
		yym1781 := z.DecBinary()
		_ = yym1781
		if false {
		} else {
			h.decSlicePodTemplate((*[]PodTemplate)(yyv1780), d)
		}
	}
	for {
		yyj1775++
		if yyhl1775 {
			yyb1775 = yyj1775 > l
		} else {
			yyb1775 = r.CheckBreak()
		}
		if yyb1775 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1775-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1782 := z.EncBinary()
		_ = yym1782
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1783 := !z.EncBinary()
			yy2arr1783 := z.EncBasicHandle().StructToArray
			var yyq1783 [3]bool
			_, _, _ = yysep1783, yyq1783, yy2arr1783
			const yyr1783 bool = false
			yyq1783[2] = x.Template != nil
			var yynn1783 int
			if yyr1783 || yy2arr1783 {
				r.EncodeArrayStart(3)
			} else {
				yynn1783 = 2
				for _, b := range yyq1783 {
					if b {
						yynn1783++
					}
				}
				r.EncodeMapStart(yynn1783)
				yynn1783 = 0
			}
			if yyr1783 || yy2arr1783 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1785 := z.EncBinary()
				_ = yym1785
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1786 := z.EncBinary()
				_ = yym1786
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr1783 || yy2arr1783 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym1788 := z.EncBinary()
					_ = yym1788
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("selector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym1789 := z.EncBinary()
					_ = yym1789
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			}
			if yyr1783 || yy2arr1783 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1783[2] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1783[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1783 || yy2arr1783 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1791 := z.DecBinary()
	_ = yym1791
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1792 := r.ContainerType()
		if yyct1792 == codecSelferValueTypeMap1234 {
			yyl1792 := r.ReadMapStart()
			if yyl1792 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1792, d)
			}
		} else if yyct1792 == codecSelferValueTypeArray1234 {
			yyl1792 := r.ReadArrayStart()
			if yyl1792 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1792, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1793Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1793Slc
	var yyhl1793 bool = l >= 0
	for yyj1793 := 0; ; yyj1793++ {
		if yyhl1793 {
			if yyj1793 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1793Slc = r.DecodeBytes(yys1793Slc, true, true)
		yys1793 := string(yys1793Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1793 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv1795 := &x.Selector
				yym1796 := z.DecBinary()
				_ = yym1796
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1795, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1793)
		} // end switch yys1793
	} // end for yyj1793
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1798 int
	var yyb1798 bool
	var yyhl1798 bool = l >= 0
	yyj1798++
	if yyhl1798 {
		yyb1798 = yyj1798 > l
	} else {
		yyb1798 = r.CheckBreak()
	}
	if yyb1798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1798++
	if yyhl1798 {
		yyb1798 = yyj1798 > l
	} else {
		yyb1798 = r.CheckBreak()
	}
	if yyb1798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv1800 := &x.Selector
		yym1801 := z.DecBinary()
		_ = yym1801
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1800, false, d)
		}
	}
	yyj1798++
	if yyhl1798 {
		yyb1798 = yyj1798 > l
	} else {
		yyb1798 = r.CheckBreak()
	}
	if yyb1798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj1798++
		if yyhl1798 {
			yyb1798 = yyj1798 > l
		} else {
			yyb1798 = r.CheckBreak()
		}
		if yyb1798 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1798-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1803 := z.EncBinary()
		_ = yym1803
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1804 := !z.EncBinary()
			yy2arr1804 := z.EncBasicHandle().StructToArray
			var yyq1804 [2]bool
			_, _, _ = yysep1804, yyq1804, yy2arr1804
			const yyr1804 bool = false
			yyq1804[1] = x.ObservedGeneration != 0
			var yynn1804 int
			if yyr1804 || yy2arr1804 {
				r.EncodeArrayStart(2)
			} else {
				yynn1804 = 1
				for _, b := range yyq1804 {
					if b {
						yynn1804++
					}
				}
				r.EncodeMapStart(yynn1804)
				yynn1804 = 0
			}
			if yyr1804 || yy2arr1804 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1806 := z.EncBinary()
				_ = yym1806
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1807 := z.EncBinary()
				_ = yym1807
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr1804 || yy2arr1804 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1804[1] {
					yym1809 := z.EncBinary()
					_ = yym1809
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1804[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1810 := z.EncBinary()
					_ = yym1810
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr1804 || yy2arr1804 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1811 := z.DecBinary()
	_ = yym1811
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1812 := r.ContainerType()
		if yyct1812 == codecSelferValueTypeMap1234 {
			yyl1812 := r.ReadMapStart()
			if yyl1812 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1812, d)
			}
		} else if yyct1812 == codecSelferValueTypeArray1234 {
			yyl1812 := r.ReadArrayStart()
			if yyl1812 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1812, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1813Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1813Slc
	var yyhl1813 bool = l >= 0
	for yyj1813 := 0; ; yyj1813++ {
		if yyhl1813 {
			if yyj1813 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1813Slc = r.DecodeBytes(yys1813Slc, true, true)
		yys1813 := string(yys1813Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1813 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1813)
		} // end switch yys1813
	} // end for yyj1813
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1816 int
	var yyb1816 bool
	var yyhl1816 bool = l >= 0
	yyj1816++
	if yyhl1816 {
		yyb1816 = yyj1816 > l
	} else {
		yyb1816 = r.CheckBreak()
	}
	if yyb1816 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1816++
	if yyhl1816 {
		yyb1816 = yyj1816 > l
	} else {
		yyb1816 = r.CheckBreak()
	}
	if yyb1816 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	for {
		yyj1816++
		if yyhl1816 {
			yyb1816 = yyj1816 > l
		} else {
			yyb1816 = r.CheckBreak()
		}
		if yyb1816 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1816-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationController) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1819 := z.EncBinary()
		_ = yym1819
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1820 := !z.EncBinary()
			yy2arr1820 := z.EncBasicHandle().StructToArray
			var yyq1820 [5]bool
			_, _, _ = yysep1820, yyq1820, yy2arr1820
			const yyr1820 bool = false
			yyq1820[0] = x.Kind != ""
			yyq1820[1] = x.APIVersion != ""
			yyq1820[2] = true
			yyq1820[3] = true
			yyq1820[4] = true
			var yynn1820 int
			if yyr1820 || yy2arr1820 {
				r.EncodeArrayStart(5)
			} else {
				yynn1820 = 0
				for _, b := range yyq1820 {
					if b {
						yynn1820++
					}
				}
				r.EncodeMapStart(yynn1820)
				yynn1820 = 0
			}
			if yyr1820 || yy2arr1820 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1820[0] {
					yym1822 := z.EncBinary()
					_ = yym1822
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1820[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1823 := z.EncBinary()
					_ = yym1823
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1820 || yy2arr1820 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1820[1] {
					yym1825 := z.EncBinary()
					_ = yym1825
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1820[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1826 := z.EncBinary()
					_ = yym1826
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1820 || yy2arr1820 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1820[2] {
					yy1828 := &x.ObjectMeta
					yy1828.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1820[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1829 := &x.ObjectMeta
					yy1829.CodecEncodeSelf(e)
				}
			}
			if yyr1820 || yy2arr1820 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1820[3] {
					yy1831 := &x.Spec
					yy1831.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1820[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1832 := &x.Spec
					yy1832.CodecEncodeSelf(e)
				}
			}
			if yyr1820 || yy2arr1820 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1820[4] {
					yy1834 := &x.Status
					yy1834.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1820[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1835 := &x.Status
					yy1835.CodecEncodeSelf(e)
				}
			}
			if yyr1820 || yy2arr1820 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationController) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1836 := z.DecBinary()
	_ = yym1836
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1837 := r.ContainerType()
		if yyct1837 == codecSelferValueTypeMap1234 {
			yyl1837 := r.ReadMapStart()
			if yyl1837 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1837, d)
			}
		} else if yyct1837 == codecSelferValueTypeArray1234 {
			yyl1837 := r.ReadArrayStart()
			if yyl1837 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1837, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationController) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1838Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1838Slc
	var yyhl1838 bool = l >= 0
	for yyj1838 := 0; ; yyj1838++ {
		if yyhl1838 {
			if yyj1838 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1838Slc = r.DecodeBytes(yys1838Slc, true, true)
		yys1838 := string(yys1838Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1838 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1841 := &x.ObjectMeta
				yyv1841.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicationControllerSpec{}
			} else {
				yyv1842 := &x.Spec
				yyv1842.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicationControllerStatus{}
			} else {
				yyv1843 := &x.Status
				yyv1843.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1838)
		} // end switch yys1838
	} // end for yyj1838
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationController) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1844 int
	var yyb1844 bool
	var yyhl1844 bool = l >= 0
	yyj1844++
	if yyhl1844 {
		yyb1844 = yyj1844 > l
	} else {
		yyb1844 = r.CheckBreak()
	}
	if yyb1844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1844++
	if yyhl1844 {
		yyb1844 = yyj1844 > l
	} else {
		yyb1844 = r.CheckBreak()
	}
	if yyb1844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1844++
	if yyhl1844 {
		yyb1844 = yyj1844 > l
	} else {
		yyb1844 = r.CheckBreak()
	}
	if yyb1844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1847 := &x.ObjectMeta
		yyv1847.CodecDecodeSelf(d)
	}
	yyj1844++
	if yyhl1844 {
		yyb1844 = yyj1844 > l
	} else {
		yyb1844 = r.CheckBreak()
	}
	if yyb1844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicationControllerSpec{}
	} else {
		yyv1848 := &x.Spec
		yyv1848.CodecDecodeSelf(d)
	}
	yyj1844++
	if yyhl1844 {
		yyb1844 = yyj1844 > l
	} else {
		yyb1844 = r.CheckBreak()
	}
	if yyb1844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicationControllerStatus{}
	} else {
		yyv1849 := &x.Status
		yyv1849.CodecDecodeSelf(d)
	}
	for {
		yyj1844++
		if yyhl1844 {
			yyb1844 = yyj1844 > l
		} else {
			yyb1844 = r.CheckBreak()
		}
		if yyb1844 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1844-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1850 := z.EncBinary()
		_ = yym1850
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1851 := !z.EncBinary()
			yy2arr1851 := z.EncBasicHandle().StructToArray
			var yyq1851 [4]bool
			_, _, _ = yysep1851, yyq1851, yy2arr1851
			const yyr1851 bool = false
			yyq1851[0] = x.Kind != ""
			yyq1851[1] = x.APIVersion != ""
			yyq1851[2] = true
			var yynn1851 int
			if yyr1851 || yy2arr1851 {
				r.EncodeArrayStart(4)
			} else {
				yynn1851 = 1
				for _, b := range yyq1851 {
					if b {
						yynn1851++
					}
				}
				r.EncodeMapStart(yynn1851)
				yynn1851 = 0
			}
			if yyr1851 || yy2arr1851 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1851[0] {
					yym1853 := z.EncBinary()
					_ = yym1853
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1851[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1854 := z.EncBinary()
					_ = yym1854
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1851 || yy2arr1851 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1851[1] {
					yym1856 := z.EncBinary()
					_ = yym1856
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1851[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1857 := z.EncBinary()
					_ = yym1857
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1851 || yy2arr1851 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1851[2] {
					yy1859 := &x.ListMeta
					yym1860 := z.EncBinary()
					_ = yym1860
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1859) {
					} else {
						z.EncFallback(yy1859)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1851[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1861 := &x.ListMeta
					yym1862 := z.EncBinary()
					_ = yym1862
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1861) {
					} else {
						z.EncFallback(yy1861)
					}
				}
			}
			if yyr1851 || yy2arr1851 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1864 := z.EncBinary()
					_ = yym1864
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1865 := z.EncBinary()
					_ = yym1865
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			}
			if yyr1851 || yy2arr1851 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1866 := z.DecBinary()
	_ = yym1866
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1867 := r.ContainerType()
		if yyct1867 == codecSelferValueTypeMap1234 {
			yyl1867 := r.ReadMapStart()
			if yyl1867 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1867, d)
			}
		} else if yyct1867 == codecSelferValueTypeArray1234 {
			yyl1867 := r.ReadArrayStart()
			if yyl1867 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1867, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1868Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1868Slc
	var yyhl1868 bool = l >= 0
	for yyj1868 := 0; ; yyj1868++ {
		if yyhl1868 {
			if yyj1868 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1868Slc = r.DecodeBytes(yys1868Slc, true, true)
		yys1868 := string(yys1868Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1868 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1871 := &x.ListMeta
				yym1872 := z.DecBinary()
				_ = yym1872
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1871) {
				} else {
					z.DecFallback(yyv1871, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1873 := &x.Items
				yym1874 := z.DecBinary()
				_ = yym1874
				if false {
				} else {
					h.decSliceReplicationController((*[]ReplicationController)(yyv1873), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1868)
		} // end switch yys1868
	} // end for yyj1868
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1875 int
	var yyb1875 bool
	var yyhl1875 bool = l >= 0
	yyj1875++
	if yyhl1875 {
		yyb1875 = yyj1875 > l
	} else {
		yyb1875 = r.CheckBreak()
	}
	if yyb1875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1875++
	if yyhl1875 {
		yyb1875 = yyj1875 > l
	} else {
		yyb1875 = r.CheckBreak()
	}
	if yyb1875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1875++
	if yyhl1875 {
		yyb1875 = yyj1875 > l
	} else {
		yyb1875 = r.CheckBreak()
	}
	if yyb1875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1878 := &x.ListMeta
		yym1879 := z.DecBinary()
		_ = yym1879
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1878) {
		} else {
			z.DecFallback(yyv1878, false)
		}
	}
	yyj1875++
	if yyhl1875 {
		yyb1875 = yyj1875 > l
	} else {
		yyb1875 = r.CheckBreak()
	}
	if yyb1875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1880 := &x.Items
		yym1881 := z.DecBinary()
		_ = yym1881
		if false {
		} else {
			h.decSliceReplicationController((*[]ReplicationController)(yyv1880), d)
		}
	}
	for {
		yyj1875++
		if yyhl1875 {
			yyb1875 = yyj1875 > l
		} else {
			yyb1875 = r.CheckBreak()
		}
		if yyb1875 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1875-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1882 := z.EncBinary()
		_ = yym1882
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1883 := !z.EncBinary()
			yy2arr1883 := z.EncBasicHandle().StructToArray
			var yyq1883 [4]bool
			_, _, _ = yysep1883, yyq1883, yy2arr1883
			const yyr1883 bool = false
			yyq1883[0] = x.Kind != ""
			yyq1883[1] = x.APIVersion != ""
			yyq1883[2] = true
			var yynn1883 int
			if yyr1883 || yy2arr1883 {
				r.EncodeArrayStart(4)
			} else {
				yynn1883 = 1
				for _, b := range yyq1883 {
					if b {
						yynn1883++
					}
				}
				r.EncodeMapStart(yynn1883)
				yynn1883 = 0
			}
			if yyr1883 || yy2arr1883 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1883[0] {
					yym1885 := z.EncBinary()
					_ = yym1885
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1883[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1886 := z.EncBinary()
					_ = yym1886
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1883 || yy2arr1883 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1883[1] {
					yym1888 := z.EncBinary()
					_ = yym1888
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1883[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1889 := z.EncBinary()
					_ = yym1889
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1883 || yy2arr1883 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1883[2] {
					yy1891 := &x.ListMeta
					yym1892 := z.EncBinary()
					_ = yym1892
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1891) {
					} else {
						z.EncFallback(yy1891)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1883[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1893 := &x.ListMeta
					yym1894 := z.EncBinary()
					_ = yym1894
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1893) {
					} else {
						z.EncFallback(yy1893)
					}
				}
			}
			if yyr1883 || yy2arr1883 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1896 := z.EncBinary()
					_ = yym1896
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1897 := z.EncBinary()
					_ = yym1897
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			}
			if yyr1883 || yy2arr1883 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1898 := z.DecBinary()
	_ = yym1898
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1899 := r.ContainerType()
		if yyct1899 == codecSelferValueTypeMap1234 {
			yyl1899 := r.ReadMapStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1899, d)
			}
		} else if yyct1899 == codecSelferValueTypeArray1234 {
			yyl1899 := r.ReadArrayStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1899, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1900Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1900Slc
	var yyhl1900 bool = l >= 0
	for yyj1900 := 0; ; yyj1900++ {
		if yyhl1900 {
			if yyj1900 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1900Slc = r.DecodeBytes(yys1900Slc, true, true)
		yys1900 := string(yys1900Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1900 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1903 := &x.ListMeta
				yym1904 := z.DecBinary()
				_ = yym1904
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1903) {
				} else {
					z.DecFallback(yyv1903, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1905 := &x.Items
				yym1906 := z.DecBinary()
				_ = yym1906
				if false {
				} else {
					h.decSliceService((*[]Service)(yyv1905), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1900)
		} // end switch yys1900
	} // end for yyj1900
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1907 int
	var yyb1907 bool
	var yyhl1907 bool = l >= 0
	yyj1907++
	if yyhl1907 {
		yyb1907 = yyj1907 > l
	} else {
		yyb1907 = r.CheckBreak()
	}
	if yyb1907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1907++
	if yyhl1907 {
		yyb1907 = yyj1907 > l
	} else {
		yyb1907 = r.CheckBreak()
	}
	if yyb1907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1907++
	if yyhl1907 {
		yyb1907 = yyj1907 > l
	} else {
		yyb1907 = r.CheckBreak()
	}
	if yyb1907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1910 := &x.ListMeta
		yym1911 := z.DecBinary()
		_ = yym1911
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1910) {
		} else {
			z.DecFallback(yyv1910, false)
		}
	}
	yyj1907++
	if yyhl1907 {
		yyb1907 = yyj1907 > l
	} else {
		yyb1907 = r.CheckBreak()
	}
	if yyb1907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1912 := &x.Items
		yym1913 := z.DecBinary()
		_ = yym1913
		if false {
		} else {
			h.decSliceService((*[]Service)(yyv1912), d)
		}
	}
	for {
		yyj1907++
		if yyhl1907 {
			yyb1907 = yyj1907 > l
		} else {
			yyb1907 = r.CheckBreak()
		}
		if yyb1907 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1907-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ServiceAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1914 := z.EncBinary()
	_ = yym1914
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1915 := z.DecBinary()
	_ = yym1915
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ServiceType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1916 := z.EncBinary()
	_ = yym1916
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1917 := z.DecBinary()
	_ = yym1917
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ServiceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1918 := z.EncBinary()
		_ = yym1918
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1919 := !z.EncBinary()
			yy2arr1919 := z.EncBasicHandle().StructToArray
			var yyq1919 [1]bool
			_, _, _ = yysep1919, yyq1919, yy2arr1919
			const yyr1919 bool = false
			yyq1919[0] = true
			var yynn1919 int
			if yyr1919 || yy2arr1919 {
				r.EncodeArrayStart(1)
			} else {
				yynn1919 = 0
				for _, b := range yyq1919 {
					if b {
						yynn1919++
					}
				}
				r.EncodeMapStart(yynn1919)
				yynn1919 = 0
			}
			if yyr1919 || yy2arr1919 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1919[0] {
					yy1921 := &x.LoadBalancer
					yy1921.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1919[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1922 := &x.LoadBalancer
					yy1922.CodecEncodeSelf(e)
				}
			}
			if yyr1919 || yy2arr1919 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1923 := z.DecBinary()
	_ = yym1923
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1924 := r.ContainerType()
		if yyct1924 == codecSelferValueTypeMap1234 {
			yyl1924 := r.ReadMapStart()
			if yyl1924 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1924, d)
			}
		} else if yyct1924 == codecSelferValueTypeArray1234 {
			yyl1924 := r.ReadArrayStart()
			if yyl1924 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1924, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1925Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1925Slc
	var yyhl1925 bool = l >= 0
	for yyj1925 := 0; ; yyj1925++ {
		if yyhl1925 {
			if yyj1925 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1925Slc = r.DecodeBytes(yys1925Slc, true, true)
		yys1925 := string(yys1925Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1925 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = LoadBalancerStatus{}
			} else {
				yyv1926 := &x.LoadBalancer
				yyv1926.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1925)
		} // end switch yys1925
	} // end for yyj1925
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1927 int
	var yyb1927 bool
	var yyhl1927 bool = l >= 0
	yyj1927++
	if yyhl1927 {
		yyb1927 = yyj1927 > l
	} else {
		yyb1927 = r.CheckBreak()
	}
	if yyb1927 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = LoadBalancerStatus{}
	} else {
		yyv1928 := &x.LoadBalancer
		yyv1928.CodecDecodeSelf(d)
	}
	for {
		yyj1927++
		if yyhl1927 {
			yyb1927 = yyj1927 > l
		} else {
			yyb1927 = r.CheckBreak()
		}
		if yyb1927 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1927-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1929 := z.EncBinary()
		_ = yym1929
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1930 := !z.EncBinary()
			yy2arr1930 := z.EncBasicHandle().StructToArray
			var yyq1930 [1]bool
			_, _, _ = yysep1930, yyq1930, yy2arr1930
			const yyr1930 bool = false
			yyq1930[0] = len(x.Ingress) != 0
			var yynn1930 int
			if yyr1930 || yy2arr1930 {
				r.EncodeArrayStart(1)
			} else {
				yynn1930 = 0
				for _, b := range yyq1930 {
					if b {
						yynn1930++
					}
				}
				r.EncodeMapStart(yynn1930)
				yynn1930 = 0
			}
			if yyr1930 || yy2arr1930 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1930[0] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1932 := z.EncBinary()
						_ = yym1932
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1930[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1933 := z.EncBinary()
						_ = yym1933
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				}
			}
			if yyr1930 || yy2arr1930 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1934 := z.DecBinary()
	_ = yym1934
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1935 := r.ContainerType()
		if yyct1935 == codecSelferValueTypeMap1234 {
			yyl1935 := r.ReadMapStart()
			if yyl1935 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1935, d)
			}
		} else if yyct1935 == codecSelferValueTypeArray1234 {
			yyl1935 := r.ReadArrayStart()
			if yyl1935 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1935, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1936Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1936Slc
	var yyhl1936 bool = l >= 0
	for yyj1936 := 0; ; yyj1936++ {
		if yyhl1936 {
			if yyj1936 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1936Slc = r.DecodeBytes(yys1936Slc, true, true)
		yys1936 := string(yys1936Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1936 {
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv1937 := &x.Ingress
				yym1938 := z.DecBinary()
				_ = yym1938
				if false {
				} else {
					h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv1937), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1936)
		} // end switch yys1936
	} // end for yyj1936
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1939 int
	var yyb1939 bool
	var yyhl1939 bool = l >= 0
	yyj1939++
	if yyhl1939 {
		yyb1939 = yyj1939 > l
	} else {
		yyb1939 = r.CheckBreak()
	}
	if yyb1939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv1940 := &x.Ingress
		yym1941 := z.DecBinary()
		_ = yym1941
		if false {
		} else {
			h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv1940), d)
		}
	}
	for {
		yyj1939++
		if yyhl1939 {
			yyb1939 = yyj1939 > l
		} else {
			yyb1939 = r.CheckBreak()
		}
		if yyb1939 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1939-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerIngress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1942 := z.EncBinary()
		_ = yym1942
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1943 := !z.EncBinary()
			yy2arr1943 := z.EncBasicHandle().StructToArray
			var yyq1943 [2]bool
			_, _, _ = yysep1943, yyq1943, yy2arr1943
			const yyr1943 bool = false
			yyq1943[0] = x.IP != ""
			yyq1943[1] = x.Hostname != ""
			var yynn1943 int
			if yyr1943 || yy2arr1943 {
				r.EncodeArrayStart(2)
			} else {
				yynn1943 = 0
				for _, b := range yyq1943 {
					if b {
						yynn1943++
					}
				}
				r.EncodeMapStart(yynn1943)
				yynn1943 = 0
			}
			if yyr1943 || yy2arr1943 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1943[0] {
					yym1945 := z.EncBinary()
					_ = yym1945
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1943[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ip"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1946 := z.EncBinary()
					_ = yym1946
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				}
			}
			if yyr1943 || yy2arr1943 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1943[1] {
					yym1948 := z.EncBinary()
					_ = yym1948
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1943[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1949 := z.EncBinary()
					_ = yym1949
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr1943 || yy2arr1943 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerIngress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1950 := z.DecBinary()
	_ = yym1950
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1951 := r.ContainerType()
		if yyct1951 == codecSelferValueTypeMap1234 {
			yyl1951 := r.ReadMapStart()
			if yyl1951 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1951, d)
			}
		} else if yyct1951 == codecSelferValueTypeArray1234 {
			yyl1951 := r.ReadArrayStart()
			if yyl1951 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1951, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerIngress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1952Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1952Slc
	var yyhl1952 bool = l >= 0
	for yyj1952 := 0; ; yyj1952++ {
		if yyhl1952 {
			if yyj1952 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1952Slc = r.DecodeBytes(yys1952Slc, true, true)
		yys1952 := string(yys1952Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1952 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1952)
		} // end switch yys1952
	} // end for yyj1952
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerIngress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1955 int
	var yyb1955 bool
	var yyhl1955 bool = l >= 0
	yyj1955++
	if yyhl1955 {
		yyb1955 = yyj1955 > l
	} else {
		yyb1955 = r.CheckBreak()
	}
	if yyb1955 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj1955++
	if yyhl1955 {
		yyb1955 = yyj1955 > l
	} else {
		yyb1955 = r.CheckBreak()
	}
	if yyb1955 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	for {
		yyj1955++
		if yyhl1955 {
			yyb1955 = yyj1955 > l
		} else {
			yyb1955 = r.CheckBreak()
		}
		if yyb1955 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1955-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1958 := z.EncBinary()
		_ = yym1958
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1959 := !z.EncBinary()
			yy2arr1959 := z.EncBasicHandle().StructToArray
			var yyq1959 [7]bool
			_, _, _ = yysep1959, yyq1959, yy2arr1959
			const yyr1959 bool = false
			yyq1959[0] = x.Type != ""
			yyq1959[3] = x.ClusterIP != ""
			yyq1959[4] = len(x.ExternalIPs) != 0
			yyq1959[5] = x.LoadBalancerIP != ""
			yyq1959[6] = x.SessionAffinity != ""
			var yynn1959 int
			if yyr1959 || yy2arr1959 {
				r.EncodeArrayStart(7)
			} else {
				yynn1959 = 2
				for _, b := range yyq1959 {
					if b {
						yynn1959++
					}
				}
				r.EncodeMapStart(yynn1959)
				yynn1959 = 0
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1959[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1959[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym1962 := z.EncBinary()
					_ = yym1962
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym1963 := z.EncBinary()
					_ = yym1963
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym1965 := z.EncBinary()
					_ = yym1965
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("selector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym1966 := z.EncBinary()
					_ = yym1966
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1959[3] {
					yym1968 := z.EncBinary()
					_ = yym1968
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1959[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1969 := z.EncBinary()
					_ = yym1969
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				}
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1959[4] {
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym1971 := z.EncBinary()
						_ = yym1971
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1959[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym1972 := z.EncBinary()
						_ = yym1972
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				}
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1959[5] {
					yym1974 := z.EncBinary()
					_ = yym1974
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1959[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1975 := z.EncBinary()
					_ = yym1975
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				}
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1959[6] {
					x.SessionAffinity.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1959[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sessionAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.SessionAffinity.CodecEncodeSelf(e)
				}
			}
			if yyr1959 || yy2arr1959 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1977 := z.DecBinary()
	_ = yym1977
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1978 := r.ContainerType()
		if yyct1978 == codecSelferValueTypeMap1234 {
			yyl1978 := r.ReadMapStart()
			if yyl1978 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1978, d)
			}
		} else if yyct1978 == codecSelferValueTypeArray1234 {
			yyl1978 := r.ReadArrayStart()
			if yyl1978 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1978, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1979Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1979Slc
	var yyhl1979 bool = l >= 0
	for yyj1979 := 0; ; yyj1979++ {
		if yyhl1979 {
			if yyj1979 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1979Slc = r.DecodeBytes(yys1979Slc, true, true)
		yys1979 := string(yys1979Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1979 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ServiceType(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1981 := &x.Ports
				yym1982 := z.DecBinary()
				_ = yym1982
				if false {
				} else {
					h.decSliceServicePort((*[]ServicePort)(yyv1981), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv1983 := &x.Selector
				yym1984 := z.DecBinary()
				_ = yym1984
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1983, false, d)
				}
			}
		case "clusterIP":
			if r.TryDecodeAsNil() {
				x.ClusterIP = ""
			} else {
				x.ClusterIP = string(r.DecodeString())
			}
		case "externalIPs":
			if r.TryDecodeAsNil() {
				x.ExternalIPs = nil
			} else {
				yyv1986 := &x.ExternalIPs
				yym1987 := z.DecBinary()
				_ = yym1987
				if false {
				} else {
					z.F.DecSliceStringX(yyv1986, false, d)
				}
			}
		case "loadBalancerIP":
			if r.TryDecodeAsNil() {
				x.LoadBalancerIP = ""
			} else {
				x.LoadBalancerIP = string(r.DecodeString())
			}
		case "sessionAffinity":
			if r.TryDecodeAsNil() {
				x.SessionAffinity = ""
			} else {
				x.SessionAffinity = ServiceAffinity(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1979)
		} // end switch yys1979
	} // end for yyj1979
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1990 int
	var yyb1990 bool
	var yyhl1990 bool = l >= 0
	yyj1990++
	if yyhl1990 {
		yyb1990 = yyj1990 > l
	} else {
		yyb1990 = r.CheckBreak()
	}
	if yyb1990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ServiceType(r.DecodeString())
	}
	yyj1990++
	if yyhl1990 {
		yyb1990 = yyj1990 > l
	} else {
		yyb1990 = r.CheckBreak()
	}
	if yyb1990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1992 := &x.Ports
		yym1993 := z.DecBinary()
		_ = yym1993
		if false {
		} else {
			h.decSliceServicePort((*[]ServicePort)(yyv1992), d)
		}
	}
	yyj1990++
	if yyhl1990 {
		yyb1990 = yyj1990 > l
	} else {
		yyb1990 = r.CheckBreak()
	}
	if yyb1990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv1994 := &x.Selector
		yym1995 := z.DecBinary()
		_ = yym1995
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1994, false, d)
		}
	}
	yyj1990++
	if yyhl1990 {
		yyb1990 = yyj1990 > l
	} else {
		yyb1990 = r.CheckBreak()
	}
	if yyb1990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterIP = ""
	} else {
		x.ClusterIP = string(r.DecodeString())
	}
	yyj1990++
	if yyhl1990 {
		yyb1990 = yyj1990 > l
	} else {
		yyb1990 = r.CheckBreak()
	}
	if yyb1990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalIPs = nil
	} else {
		yyv1997 := &x.ExternalIPs
		yym1998 := z.DecBinary()
		_ = yym1998
		if false {
		} else {
			z.F.DecSliceStringX(yyv1997, false, d)
		}
	}
	yyj1990++
	if yyhl1990 {
		yyb1990 = yyj1990 > l
	} else {
		yyb1990 = r.CheckBreak()
	}
	if yyb1990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerIP = ""
	} else {
		x.LoadBalancerIP = string(r.DecodeString())
	}
	yyj1990++
	if yyhl1990 {
		yyb1990 = yyj1990 > l
	} else {
		yyb1990 = r.CheckBreak()
	}
	if yyb1990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SessionAffinity = ""
	} else {
		x.SessionAffinity = ServiceAffinity(r.DecodeString())
	}
	for {
		yyj1990++
		if yyhl1990 {
			yyb1990 = yyj1990 > l
		} else {
			yyb1990 = r.CheckBreak()
		}
		if yyb1990 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1990-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServicePort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2001 := z.EncBinary()
		_ = yym2001
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2002 := !z.EncBinary()
			yy2arr2002 := z.EncBasicHandle().StructToArray
			var yyq2002 [5]bool
			_, _, _ = yysep2002, yyq2002, yy2arr2002
			const yyr2002 bool = false
			var yynn2002 int
			if yyr2002 || yy2arr2002 {
				r.EncodeArrayStart(5)
			} else {
				yynn2002 = 5
				for _, b := range yyq2002 {
					if b {
						yynn2002++
					}
				}
				r.EncodeMapStart(yynn2002)
				yynn2002 = 0
			}
			if yyr2002 || yy2arr2002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2004 := z.EncBinary()
				_ = yym2004
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2005 := z.EncBinary()
				_ = yym2005
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2002 || yy2arr2002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Protocol.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protocol"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Protocol.CodecEncodeSelf(e)
			}
			if yyr2002 || yy2arr2002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2008 := z.EncBinary()
				_ = yym2008
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2009 := z.EncBinary()
				_ = yym2009
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2002 || yy2arr2002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2011 := &x.TargetPort
				yym2012 := z.EncBinary()
				_ = yym2012
				if false {
				} else if z.HasExtensions() && z.EncExt(yy2011) {
				} else if !yym2012 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy2011)
				} else {
					z.EncFallback(yy2011)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2013 := &x.TargetPort
				yym2014 := z.EncBinary()
				_ = yym2014
				if false {
				} else if z.HasExtensions() && z.EncExt(yy2013) {
				} else if !yym2014 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy2013)
				} else {
					z.EncFallback(yy2013)
				}
			}
			if yyr2002 || yy2arr2002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2016 := z.EncBinary()
				_ = yym2016
				if false {
				} else {
					r.EncodeInt(int64(x.NodePort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2017 := z.EncBinary()
				_ = yym2017
				if false {
				} else {
					r.EncodeInt(int64(x.NodePort))
				}
			}
			if yyr2002 || yy2arr2002 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServicePort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2018 := z.DecBinary()
	_ = yym2018
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2019 := r.ContainerType()
		if yyct2019 == codecSelferValueTypeMap1234 {
			yyl2019 := r.ReadMapStart()
			if yyl2019 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2019, d)
			}
		} else if yyct2019 == codecSelferValueTypeArray1234 {
			yyl2019 := r.ReadArrayStart()
			if yyl2019 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2019, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServicePort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2020Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2020Slc
	var yyhl2020 bool = l >= 0
	for yyj2020 := 0; ; yyj2020++ {
		if yyhl2020 {
			if yyj2020 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2020Slc = r.DecodeBytes(yys2020Slc, true, true)
		yys2020 := string(yys2020Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2020 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "targetPort":
			if r.TryDecodeAsNil() {
				x.TargetPort = pkg5_intstr.IntOrString{}
			} else {
				yyv2024 := &x.TargetPort
				yym2025 := z.DecBinary()
				_ = yym2025
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2024) {
				} else if !yym2025 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2024)
				} else {
					z.DecFallback(yyv2024, false)
				}
			}
		case "nodePort":
			if r.TryDecodeAsNil() {
				x.NodePort = 0
			} else {
				x.NodePort = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2020)
		} // end switch yys2020
	} // end for yyj2020
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServicePort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2027 int
	var yyb2027 bool
	var yyhl2027 bool = l >= 0
	yyj2027++
	if yyhl2027 {
		yyb2027 = yyj2027 > l
	} else {
		yyb2027 = r.CheckBreak()
	}
	if yyb2027 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2027++
	if yyhl2027 {
		yyb2027 = yyj2027 > l
	} else {
		yyb2027 = r.CheckBreak()
	}
	if yyb2027 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj2027++
	if yyhl2027 {
		yyb2027 = yyj2027 > l
	} else {
		yyb2027 = r.CheckBreak()
	}
	if yyb2027 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj2027++
	if yyhl2027 {
		yyb2027 = yyj2027 > l
	} else {
		yyb2027 = r.CheckBreak()
	}
	if yyb2027 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPort = pkg5_intstr.IntOrString{}
	} else {
		yyv2031 := &x.TargetPort
		yym2032 := z.DecBinary()
		_ = yym2032
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2031) {
		} else if !yym2032 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2031)
		} else {
			z.DecFallback(yyv2031, false)
		}
	}
	yyj2027++
	if yyhl2027 {
		yyb2027 = yyj2027 > l
	} else {
		yyb2027 = r.CheckBreak()
	}
	if yyb2027 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodePort = 0
	} else {
		x.NodePort = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj2027++
		if yyhl2027 {
			yyb2027 = yyj2027 > l
		} else {
			yyb2027 = r.CheckBreak()
		}
		if yyb2027 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2027-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Service) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2034 := z.EncBinary()
		_ = yym2034
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2035 := !z.EncBinary()
			yy2arr2035 := z.EncBasicHandle().StructToArray
			var yyq2035 [5]bool
			_, _, _ = yysep2035, yyq2035, yy2arr2035
			const yyr2035 bool = false
			yyq2035[0] = x.Kind != ""
			yyq2035[1] = x.APIVersion != ""
			yyq2035[2] = true
			yyq2035[3] = true
			yyq2035[4] = true
			var yynn2035 int
			if yyr2035 || yy2arr2035 {
				r.EncodeArrayStart(5)
			} else {
				yynn2035 = 0
				for _, b := range yyq2035 {
					if b {
						yynn2035++
					}
				}
				r.EncodeMapStart(yynn2035)
				yynn2035 = 0
			}
			if yyr2035 || yy2arr2035 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2035[0] {
					yym2037 := z.EncBinary()
					_ = yym2037
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2035[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2038 := z.EncBinary()
					_ = yym2038
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2035 || yy2arr2035 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2035[1] {
					yym2040 := z.EncBinary()
					_ = yym2040
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2035[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2041 := z.EncBinary()
					_ = yym2041
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2035 || yy2arr2035 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2035[2] {
					yy2043 := &x.ObjectMeta
					yy2043.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2035[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2044 := &x.ObjectMeta
					yy2044.CodecEncodeSelf(e)
				}
			}
			if yyr2035 || yy2arr2035 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2035[3] {
					yy2046 := &x.Spec
					yy2046.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2035[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2047 := &x.Spec
					yy2047.CodecEncodeSelf(e)
				}
			}
			if yyr2035 || yy2arr2035 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2035[4] {
					yy2049 := &x.Status
					yy2049.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2035[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2050 := &x.Status
					yy2050.CodecEncodeSelf(e)
				}
			}
			if yyr2035 || yy2arr2035 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Service) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2051 := z.DecBinary()
	_ = yym2051
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2052 := r.ContainerType()
		if yyct2052 == codecSelferValueTypeMap1234 {
			yyl2052 := r.ReadMapStart()
			if yyl2052 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2052, d)
			}
		} else if yyct2052 == codecSelferValueTypeArray1234 {
			yyl2052 := r.ReadArrayStart()
			if yyl2052 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2052, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Service) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2053Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2053Slc
	var yyhl2053 bool = l >= 0
	for yyj2053 := 0; ; yyj2053++ {
		if yyhl2053 {
			if yyj2053 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2053Slc = r.DecodeBytes(yys2053Slc, true, true)
		yys2053 := string(yys2053Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2053 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2056 := &x.ObjectMeta
				yyv2056.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ServiceSpec{}
			} else {
				yyv2057 := &x.Spec
				yyv2057.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ServiceStatus{}
			} else {
				yyv2058 := &x.Status
				yyv2058.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2053)
		} // end switch yys2053
	} // end for yyj2053
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Service) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2059 int
	var yyb2059 bool
	var yyhl2059 bool = l >= 0
	yyj2059++
	if yyhl2059 {
		yyb2059 = yyj2059 > l
	} else {
		yyb2059 = r.CheckBreak()
	}
	if yyb2059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2059++
	if yyhl2059 {
		yyb2059 = yyj2059 > l
	} else {
		yyb2059 = r.CheckBreak()
	}
	if yyb2059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2059++
	if yyhl2059 {
		yyb2059 = yyj2059 > l
	} else {
		yyb2059 = r.CheckBreak()
	}
	if yyb2059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2062 := &x.ObjectMeta
		yyv2062.CodecDecodeSelf(d)
	}
	yyj2059++
	if yyhl2059 {
		yyb2059 = yyj2059 > l
	} else {
		yyb2059 = r.CheckBreak()
	}
	if yyb2059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ServiceSpec{}
	} else {
		yyv2063 := &x.Spec
		yyv2063.CodecDecodeSelf(d)
	}
	yyj2059++
	if yyhl2059 {
		yyb2059 = yyj2059 > l
	} else {
		yyb2059 = r.CheckBreak()
	}
	if yyb2059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ServiceStatus{}
	} else {
		yyv2064 := &x.Status
		yyv2064.CodecDecodeSelf(d)
	}
	for {
		yyj2059++
		if yyhl2059 {
			yyb2059 = yyj2059 > l
		} else {
			yyb2059 = r.CheckBreak()
		}
		if yyb2059 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2059-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2065 := z.EncBinary()
		_ = yym2065
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2066 := !z.EncBinary()
			yy2arr2066 := z.EncBasicHandle().StructToArray
			var yyq2066 [5]bool
			_, _, _ = yysep2066, yyq2066, yy2arr2066
			const yyr2066 bool = false
			yyq2066[0] = x.Kind != ""
			yyq2066[1] = x.APIVersion != ""
			yyq2066[2] = true
			yyq2066[4] = len(x.ImagePullSecrets) != 0
			var yynn2066 int
			if yyr2066 || yy2arr2066 {
				r.EncodeArrayStart(5)
			} else {
				yynn2066 = 1
				for _, b := range yyq2066 {
					if b {
						yynn2066++
					}
				}
				r.EncodeMapStart(yynn2066)
				yynn2066 = 0
			}
			if yyr2066 || yy2arr2066 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2066[0] {
					yym2068 := z.EncBinary()
					_ = yym2068
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2066[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2069 := z.EncBinary()
					_ = yym2069
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2066 || yy2arr2066 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2066[1] {
					yym2071 := z.EncBinary()
					_ = yym2071
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2066[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2072 := z.EncBinary()
					_ = yym2072
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2066 || yy2arr2066 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2066[2] {
					yy2074 := &x.ObjectMeta
					yy2074.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2066[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2075 := &x.ObjectMeta
					yy2075.CodecEncodeSelf(e)
				}
			}
			if yyr2066 || yy2arr2066 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Secrets == nil {
					r.EncodeNil()
				} else {
					yym2077 := z.EncBinary()
					_ = yym2077
					if false {
					} else {
						h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secrets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Secrets == nil {
					r.EncodeNil()
				} else {
					yym2078 := z.EncBinary()
					_ = yym2078
					if false {
					} else {
						h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
					}
				}
			}
			if yyr2066 || yy2arr2066 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2066[4] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2080 := z.EncBinary()
						_ = yym2080
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2066[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2081 := z.EncBinary()
						_ = yym2081
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2066 || yy2arr2066 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2082 := z.DecBinary()
	_ = yym2082
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2083 := r.ContainerType()
		if yyct2083 == codecSelferValueTypeMap1234 {
			yyl2083 := r.ReadMapStart()
			if yyl2083 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2083, d)
			}
		} else if yyct2083 == codecSelferValueTypeArray1234 {
			yyl2083 := r.ReadArrayStart()
			if yyl2083 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2083, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2084Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2084Slc
	var yyhl2084 bool = l >= 0
	for yyj2084 := 0; ; yyj2084++ {
		if yyhl2084 {
			if yyj2084 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2084Slc = r.DecodeBytes(yys2084Slc, true, true)
		yys2084 := string(yys2084Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2084 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2087 := &x.ObjectMeta
				yyv2087.CodecDecodeSelf(d)
			}
		case "secrets":
			if r.TryDecodeAsNil() {
				x.Secrets = nil
			} else {
				yyv2088 := &x.Secrets
				yym2089 := z.DecBinary()
				_ = yym2089
				if false {
				} else {
					h.decSliceObjectReference((*[]ObjectReference)(yyv2088), d)
				}
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2090 := &x.ImagePullSecrets
				yym2091 := z.DecBinary()
				_ = yym2091
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2090), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2084)
		} // end switch yys2084
	} // end for yyj2084
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2092 int
	var yyb2092 bool
	var yyhl2092 bool = l >= 0
	yyj2092++
	if yyhl2092 {
		yyb2092 = yyj2092 > l
	} else {
		yyb2092 = r.CheckBreak()
	}
	if yyb2092 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2092++
	if yyhl2092 {
		yyb2092 = yyj2092 > l
	} else {
		yyb2092 = r.CheckBreak()
	}
	if yyb2092 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2092++
	if yyhl2092 {
		yyb2092 = yyj2092 > l
	} else {
		yyb2092 = r.CheckBreak()
	}
	if yyb2092 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2095 := &x.ObjectMeta
		yyv2095.CodecDecodeSelf(d)
	}
	yyj2092++
	if yyhl2092 {
		yyb2092 = yyj2092 > l
	} else {
		yyb2092 = r.CheckBreak()
	}
	if yyb2092 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Secrets = nil
	} else {
		yyv2096 := &x.Secrets
		yym2097 := z.DecBinary()
		_ = yym2097
		if false {
		} else {
			h.decSliceObjectReference((*[]ObjectReference)(yyv2096), d)
		}
	}
	yyj2092++
	if yyhl2092 {
		yyb2092 = yyj2092 > l
	} else {
		yyb2092 = r.CheckBreak()
	}
	if yyb2092 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2098 := &x.ImagePullSecrets
		yym2099 := z.DecBinary()
		_ = yym2099
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2098), d)
		}
	}
	for {
		yyj2092++
		if yyhl2092 {
			yyb2092 = yyj2092 > l
		} else {
			yyb2092 = r.CheckBreak()
		}
		if yyb2092 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2092-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccountList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2100 := z.EncBinary()
		_ = yym2100
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2101 := !z.EncBinary()
			yy2arr2101 := z.EncBasicHandle().StructToArray
			var yyq2101 [4]bool
			_, _, _ = yysep2101, yyq2101, yy2arr2101
			const yyr2101 bool = false
			yyq2101[0] = x.Kind != ""
			yyq2101[1] = x.APIVersion != ""
			yyq2101[2] = true
			var yynn2101 int
			if yyr2101 || yy2arr2101 {
				r.EncodeArrayStart(4)
			} else {
				yynn2101 = 1
				for _, b := range yyq2101 {
					if b {
						yynn2101++
					}
				}
				r.EncodeMapStart(yynn2101)
				yynn2101 = 0
			}
			if yyr2101 || yy2arr2101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2101[0] {
					yym2103 := z.EncBinary()
					_ = yym2103
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2101[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2104 := z.EncBinary()
					_ = yym2104
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2101 || yy2arr2101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2101[1] {
					yym2106 := z.EncBinary()
					_ = yym2106
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2101[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2107 := z.EncBinary()
					_ = yym2107
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2101 || yy2arr2101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2101[2] {
					yy2109 := &x.ListMeta
					yym2110 := z.EncBinary()
					_ = yym2110
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2109) {
					} else {
						z.EncFallback(yy2109)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2101[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2111 := &x.ListMeta
					yym2112 := z.EncBinary()
					_ = yym2112
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2111) {
					} else {
						z.EncFallback(yy2111)
					}
				}
			}
			if yyr2101 || yy2arr2101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2114 := z.EncBinary()
					_ = yym2114
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2115 := z.EncBinary()
					_ = yym2115
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			}
			if yyr2101 || yy2arr2101 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccountList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2116 := z.DecBinary()
	_ = yym2116
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2117 := r.ContainerType()
		if yyct2117 == codecSelferValueTypeMap1234 {
			yyl2117 := r.ReadMapStart()
			if yyl2117 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2117, d)
			}
		} else if yyct2117 == codecSelferValueTypeArray1234 {
			yyl2117 := r.ReadArrayStart()
			if yyl2117 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2117, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccountList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2118Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2118Slc
	var yyhl2118 bool = l >= 0
	for yyj2118 := 0; ; yyj2118++ {
		if yyhl2118 {
			if yyj2118 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2118Slc = r.DecodeBytes(yys2118Slc, true, true)
		yys2118 := string(yys2118Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2118 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2121 := &x.ListMeta
				yym2122 := z.DecBinary()
				_ = yym2122
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2121) {
				} else {
					z.DecFallback(yyv2121, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2123 := &x.Items
				yym2124 := z.DecBinary()
				_ = yym2124
				if false {
				} else {
					h.decSliceServiceAccount((*[]ServiceAccount)(yyv2123), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2118)
		} // end switch yys2118
	} // end for yyj2118
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccountList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2125 int
	var yyb2125 bool
	var yyhl2125 bool = l >= 0
	yyj2125++
	if yyhl2125 {
		yyb2125 = yyj2125 > l
	} else {
		yyb2125 = r.CheckBreak()
	}
	if yyb2125 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2125++
	if yyhl2125 {
		yyb2125 = yyj2125 > l
	} else {
		yyb2125 = r.CheckBreak()
	}
	if yyb2125 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2125++
	if yyhl2125 {
		yyb2125 = yyj2125 > l
	} else {
		yyb2125 = r.CheckBreak()
	}
	if yyb2125 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2128 := &x.ListMeta
		yym2129 := z.DecBinary()
		_ = yym2129
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2128) {
		} else {
			z.DecFallback(yyv2128, false)
		}
	}
	yyj2125++
	if yyhl2125 {
		yyb2125 = yyj2125 > l
	} else {
		yyb2125 = r.CheckBreak()
	}
	if yyb2125 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2130 := &x.Items
		yym2131 := z.DecBinary()
		_ = yym2131
		if false {
		} else {
			h.decSliceServiceAccount((*[]ServiceAccount)(yyv2130), d)
		}
	}
	for {
		yyj2125++
		if yyhl2125 {
			yyb2125 = yyj2125 > l
		} else {
			yyb2125 = r.CheckBreak()
		}
		if yyb2125 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2125-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Endpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2132 := z.EncBinary()
		_ = yym2132
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2133 := !z.EncBinary()
			yy2arr2133 := z.EncBasicHandle().StructToArray
			var yyq2133 [4]bool
			_, _, _ = yysep2133, yyq2133, yy2arr2133
			const yyr2133 bool = false
			yyq2133[0] = x.Kind != ""
			yyq2133[1] = x.APIVersion != ""
			yyq2133[2] = true
			var yynn2133 int
			if yyr2133 || yy2arr2133 {
				r.EncodeArrayStart(4)
			} else {
				yynn2133 = 1
				for _, b := range yyq2133 {
					if b {
						yynn2133++
					}
				}
				r.EncodeMapStart(yynn2133)
				yynn2133 = 0
			}
			if yyr2133 || yy2arr2133 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2133[0] {
					yym2135 := z.EncBinary()
					_ = yym2135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2133[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2136 := z.EncBinary()
					_ = yym2136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2133 || yy2arr2133 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2133[1] {
					yym2138 := z.EncBinary()
					_ = yym2138
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2133[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2139 := z.EncBinary()
					_ = yym2139
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2133 || yy2arr2133 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2133[2] {
					yy2141 := &x.ObjectMeta
					yy2141.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2133[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2142 := &x.ObjectMeta
					yy2142.CodecEncodeSelf(e)
				}
			}
			if yyr2133 || yy2arr2133 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2144 := z.EncBinary()
					_ = yym2144
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Subsets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2145 := z.EncBinary()
					_ = yym2145
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			}
			if yyr2133 || yy2arr2133 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Endpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2146 := z.DecBinary()
	_ = yym2146
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2147 := r.ContainerType()
		if yyct2147 == codecSelferValueTypeMap1234 {
			yyl2147 := r.ReadMapStart()
			if yyl2147 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2147, d)
			}
		} else if yyct2147 == codecSelferValueTypeArray1234 {
			yyl2147 := r.ReadArrayStart()
			if yyl2147 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2147, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Endpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2148Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2148Slc
	var yyhl2148 bool = l >= 0
	for yyj2148 := 0; ; yyj2148++ {
		if yyhl2148 {
			if yyj2148 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2148Slc = r.DecodeBytes(yys2148Slc, true, true)
		yys2148 := string(yys2148Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2148 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2151 := &x.ObjectMeta
				yyv2151.CodecDecodeSelf(d)
			}
		case "Subsets":
			if r.TryDecodeAsNil() {
				x.Subsets = nil
			} else {
				yyv2152 := &x.Subsets
				yym2153 := z.DecBinary()
				_ = yym2153
				if false {
				} else {
					h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2152), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2148)
		} // end switch yys2148
	} // end for yyj2148
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Endpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2154 int
	var yyb2154 bool
	var yyhl2154 bool = l >= 0
	yyj2154++
	if yyhl2154 {
		yyb2154 = yyj2154 > l
	} else {
		yyb2154 = r.CheckBreak()
	}
	if yyb2154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2154++
	if yyhl2154 {
		yyb2154 = yyj2154 > l
	} else {
		yyb2154 = r.CheckBreak()
	}
	if yyb2154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2154++
	if yyhl2154 {
		yyb2154 = yyj2154 > l
	} else {
		yyb2154 = r.CheckBreak()
	}
	if yyb2154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2157 := &x.ObjectMeta
		yyv2157.CodecDecodeSelf(d)
	}
	yyj2154++
	if yyhl2154 {
		yyb2154 = yyj2154 > l
	} else {
		yyb2154 = r.CheckBreak()
	}
	if yyb2154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subsets = nil
	} else {
		yyv2158 := &x.Subsets
		yym2159 := z.DecBinary()
		_ = yym2159
		if false {
		} else {
			h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2158), d)
		}
	}
	for {
		yyj2154++
		if yyhl2154 {
			yyb2154 = yyj2154 > l
		} else {
			yyb2154 = r.CheckBreak()
		}
		if yyb2154 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2154-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointSubset) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2160 := z.EncBinary()
		_ = yym2160
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2161 := !z.EncBinary()
			yy2arr2161 := z.EncBasicHandle().StructToArray
			var yyq2161 [3]bool
			_, _, _ = yysep2161, yyq2161, yy2arr2161
			const yyr2161 bool = false
			var yynn2161 int
			if yyr2161 || yy2arr2161 {
				r.EncodeArrayStart(3)
			} else {
				yynn2161 = 3
				for _, b := range yyq2161 {
					if b {
						yynn2161++
					}
				}
				r.EncodeMapStart(yynn2161)
				yynn2161 = 0
			}
			if yyr2161 || yy2arr2161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Addresses == nil {
					r.EncodeNil()
				} else {
					yym2163 := z.EncBinary()
					_ = yym2163
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Addresses"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Addresses == nil {
					r.EncodeNil()
				} else {
					yym2164 := z.EncBinary()
					_ = yym2164
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
					}
				}
			}
			if yyr2161 || yy2arr2161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NotReadyAddresses == nil {
					r.EncodeNil()
				} else {
					yym2166 := z.EncBinary()
					_ = yym2166
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("NotReadyAddresses"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NotReadyAddresses == nil {
					r.EncodeNil()
				} else {
					yym2167 := z.EncBinary()
					_ = yym2167
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
					}
				}
			}
			if yyr2161 || yy2arr2161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2169 := z.EncBinary()
					_ = yym2169
					if false {
					} else {
						h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2170 := z.EncBinary()
					_ = yym2170
					if false {
					} else {
						h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
					}
				}
			}
			if yyr2161 || yy2arr2161 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointSubset) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2171 := z.DecBinary()
	_ = yym2171
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2172 := r.ContainerType()
		if yyct2172 == codecSelferValueTypeMap1234 {
			yyl2172 := r.ReadMapStart()
			if yyl2172 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2172, d)
			}
		} else if yyct2172 == codecSelferValueTypeArray1234 {
			yyl2172 := r.ReadArrayStart()
			if yyl2172 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2172, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointSubset) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2173Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2173Slc
	var yyhl2173 bool = l >= 0
	for yyj2173 := 0; ; yyj2173++ {
		if yyhl2173 {
			if yyj2173 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2173Slc = r.DecodeBytes(yys2173Slc, true, true)
		yys2173 := string(yys2173Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2173 {
		case "Addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2174 := &x.Addresses
				yym2175 := z.DecBinary()
				_ = yym2175
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2174), d)
				}
			}
		case "NotReadyAddresses":
			if r.TryDecodeAsNil() {
				x.NotReadyAddresses = nil
			} else {
				yyv2176 := &x.NotReadyAddresses
				yym2177 := z.DecBinary()
				_ = yym2177
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2176), d)
				}
			}
		case "Ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2178 := &x.Ports
				yym2179 := z.DecBinary()
				_ = yym2179
				if false {
				} else {
					h.decSliceEndpointPort((*[]EndpointPort)(yyv2178), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2173)
		} // end switch yys2173
	} // end for yyj2173
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointSubset) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2180 int
	var yyb2180 bool
	var yyhl2180 bool = l >= 0
	yyj2180++
	if yyhl2180 {
		yyb2180 = yyj2180 > l
	} else {
		yyb2180 = r.CheckBreak()
	}
	if yyb2180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2181 := &x.Addresses
		yym2182 := z.DecBinary()
		_ = yym2182
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2181), d)
		}
	}
	yyj2180++
	if yyhl2180 {
		yyb2180 = yyj2180 > l
	} else {
		yyb2180 = r.CheckBreak()
	}
	if yyb2180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NotReadyAddresses = nil
	} else {
		yyv2183 := &x.NotReadyAddresses
		yym2184 := z.DecBinary()
		_ = yym2184
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2183), d)
		}
	}
	yyj2180++
	if yyhl2180 {
		yyb2180 = yyj2180 > l
	} else {
		yyb2180 = r.CheckBreak()
	}
	if yyb2180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2185 := &x.Ports
		yym2186 := z.DecBinary()
		_ = yym2186
		if false {
		} else {
			h.decSliceEndpointPort((*[]EndpointPort)(yyv2185), d)
		}
	}
	for {
		yyj2180++
		if yyhl2180 {
			yyb2180 = yyj2180 > l
		} else {
			yyb2180 = r.CheckBreak()
		}
		if yyb2180 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2180-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2187 := z.EncBinary()
		_ = yym2187
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2188 := !z.EncBinary()
			yy2arr2188 := z.EncBasicHandle().StructToArray
			var yyq2188 [2]bool
			_, _, _ = yysep2188, yyq2188, yy2arr2188
			const yyr2188 bool = false
			var yynn2188 int
			if yyr2188 || yy2arr2188 {
				r.EncodeArrayStart(2)
			} else {
				yynn2188 = 2
				for _, b := range yyq2188 {
					if b {
						yynn2188++
					}
				}
				r.EncodeMapStart(yynn2188)
				yynn2188 = 0
			}
			if yyr2188 || yy2arr2188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2190 := z.EncBinary()
				_ = yym2190
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("IP"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2191 := z.EncBinary()
				_ = yym2191
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			}
			if yyr2188 || yy2arr2188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetRef == nil {
					r.EncodeNil()
				} else {
					x.TargetRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("TargetRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetRef == nil {
					r.EncodeNil()
				} else {
					x.TargetRef.CodecEncodeSelf(e)
				}
			}
			if yyr2188 || yy2arr2188 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2193 := z.DecBinary()
	_ = yym2193
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2194 := r.ContainerType()
		if yyct2194 == codecSelferValueTypeMap1234 {
			yyl2194 := r.ReadMapStart()
			if yyl2194 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2194, d)
			}
		} else if yyct2194 == codecSelferValueTypeArray1234 {
			yyl2194 := r.ReadArrayStart()
			if yyl2194 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2194, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2195Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2195Slc
	var yyhl2195 bool = l >= 0
	for yyj2195 := 0; ; yyj2195++ {
		if yyhl2195 {
			if yyj2195 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2195Slc = r.DecodeBytes(yys2195Slc, true, true)
		yys2195 := string(yys2195Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2195 {
		case "IP":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "TargetRef":
			if r.TryDecodeAsNil() {
				if x.TargetRef != nil {
					x.TargetRef = nil
				}
			} else {
				if x.TargetRef == nil {
					x.TargetRef = new(ObjectReference)
				}
				x.TargetRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2195)
		} // end switch yys2195
	} // end for yyj2195
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2198 int
	var yyb2198 bool
	var yyhl2198 bool = l >= 0
	yyj2198++
	if yyhl2198 {
		yyb2198 = yyj2198 > l
	} else {
		yyb2198 = r.CheckBreak()
	}
	if yyb2198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2198++
	if yyhl2198 {
		yyb2198 = yyj2198 > l
	} else {
		yyb2198 = r.CheckBreak()
	}
	if yyb2198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetRef != nil {
			x.TargetRef = nil
		}
	} else {
		if x.TargetRef == nil {
			x.TargetRef = new(ObjectReference)
		}
		x.TargetRef.CodecDecodeSelf(d)
	}
	for {
		yyj2198++
		if yyhl2198 {
			yyb2198 = yyj2198 > l
		} else {
			yyb2198 = r.CheckBreak()
		}
		if yyb2198 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2198-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2201 := z.EncBinary()
		_ = yym2201
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2202 := !z.EncBinary()
			yy2arr2202 := z.EncBasicHandle().StructToArray
			var yyq2202 [3]bool
			_, _, _ = yysep2202, yyq2202, yy2arr2202
			const yyr2202 bool = false
			var yynn2202 int
			if yyr2202 || yy2arr2202 {
				r.EncodeArrayStart(3)
			} else {
				yynn2202 = 3
				for _, b := range yyq2202 {
					if b {
						yynn2202++
					}
				}
				r.EncodeMapStart(yynn2202)
				yynn2202 = 0
			}
			if yyr2202 || yy2arr2202 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2204 := z.EncBinary()
				_ = yym2204
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2205 := z.EncBinary()
				_ = yym2205
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2202 || yy2arr2202 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2207 := z.EncBinary()
				_ = yym2207
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2208 := z.EncBinary()
				_ = yym2208
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2202 || yy2arr2202 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Protocol.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Protocol"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Protocol.CodecEncodeSelf(e)
			}
			if yyr2202 || yy2arr2202 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2210 := z.DecBinary()
	_ = yym2210
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2211 := r.ContainerType()
		if yyct2211 == codecSelferValueTypeMap1234 {
			yyl2211 := r.ReadMapStart()
			if yyl2211 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2211, d)
			}
		} else if yyct2211 == codecSelferValueTypeArray1234 {
			yyl2211 := r.ReadArrayStart()
			if yyl2211 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2211, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2212Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2212Slc
	var yyhl2212 bool = l >= 0
	for yyj2212 := 0; ; yyj2212++ {
		if yyhl2212 {
			if yyj2212 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2212Slc = r.DecodeBytes(yys2212Slc, true, true)
		yys2212 := string(yys2212Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2212 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "Protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2212)
		} // end switch yys2212
	} // end for yyj2212
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2216 int
	var yyb2216 bool
	var yyhl2216 bool = l >= 0
	yyj2216++
	if yyhl2216 {
		yyb2216 = yyj2216 > l
	} else {
		yyb2216 = r.CheckBreak()
	}
	if yyb2216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2216++
	if yyhl2216 {
		yyb2216 = yyj2216 > l
	} else {
		yyb2216 = r.CheckBreak()
	}
	if yyb2216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj2216++
	if yyhl2216 {
		yyb2216 = yyj2216 > l
	} else {
		yyb2216 = r.CheckBreak()
	}
	if yyb2216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	for {
		yyj2216++
		if yyhl2216 {
			yyb2216 = yyj2216 > l
		} else {
			yyb2216 = r.CheckBreak()
		}
		if yyb2216 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2216-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2220 := z.EncBinary()
		_ = yym2220
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2221 := !z.EncBinary()
			yy2arr2221 := z.EncBasicHandle().StructToArray
			var yyq2221 [4]bool
			_, _, _ = yysep2221, yyq2221, yy2arr2221
			const yyr2221 bool = false
			yyq2221[0] = x.Kind != ""
			yyq2221[1] = x.APIVersion != ""
			yyq2221[2] = true
			var yynn2221 int
			if yyr2221 || yy2arr2221 {
				r.EncodeArrayStart(4)
			} else {
				yynn2221 = 1
				for _, b := range yyq2221 {
					if b {
						yynn2221++
					}
				}
				r.EncodeMapStart(yynn2221)
				yynn2221 = 0
			}
			if yyr2221 || yy2arr2221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2221[0] {
					yym2223 := z.EncBinary()
					_ = yym2223
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2221[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2224 := z.EncBinary()
					_ = yym2224
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2221 || yy2arr2221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2221[1] {
					yym2226 := z.EncBinary()
					_ = yym2226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2221[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2227 := z.EncBinary()
					_ = yym2227
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2221 || yy2arr2221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2221[2] {
					yy2229 := &x.ListMeta
					yym2230 := z.EncBinary()
					_ = yym2230
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2229) {
					} else {
						z.EncFallback(yy2229)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2221[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2231 := &x.ListMeta
					yym2232 := z.EncBinary()
					_ = yym2232
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2231) {
					} else {
						z.EncFallback(yy2231)
					}
				}
			}
			if yyr2221 || yy2arr2221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2234 := z.EncBinary()
					_ = yym2234
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2235 := z.EncBinary()
					_ = yym2235
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			}
			if yyr2221 || yy2arr2221 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2236 := z.DecBinary()
	_ = yym2236
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2237 := r.ContainerType()
		if yyct2237 == codecSelferValueTypeMap1234 {
			yyl2237 := r.ReadMapStart()
			if yyl2237 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2237, d)
			}
		} else if yyct2237 == codecSelferValueTypeArray1234 {
			yyl2237 := r.ReadArrayStart()
			if yyl2237 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2237, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2238Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2238Slc
	var yyhl2238 bool = l >= 0
	for yyj2238 := 0; ; yyj2238++ {
		if yyhl2238 {
			if yyj2238 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2238Slc = r.DecodeBytes(yys2238Slc, true, true)
		yys2238 := string(yys2238Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2238 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2241 := &x.ListMeta
				yym2242 := z.DecBinary()
				_ = yym2242
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2241) {
				} else {
					z.DecFallback(yyv2241, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2243 := &x.Items
				yym2244 := z.DecBinary()
				_ = yym2244
				if false {
				} else {
					h.decSliceEndpoints((*[]Endpoints)(yyv2243), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2238)
		} // end switch yys2238
	} // end for yyj2238
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2245 int
	var yyb2245 bool
	var yyhl2245 bool = l >= 0
	yyj2245++
	if yyhl2245 {
		yyb2245 = yyj2245 > l
	} else {
		yyb2245 = r.CheckBreak()
	}
	if yyb2245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2245++
	if yyhl2245 {
		yyb2245 = yyj2245 > l
	} else {
		yyb2245 = r.CheckBreak()
	}
	if yyb2245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2245++
	if yyhl2245 {
		yyb2245 = yyj2245 > l
	} else {
		yyb2245 = r.CheckBreak()
	}
	if yyb2245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2248 := &x.ListMeta
		yym2249 := z.DecBinary()
		_ = yym2249
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2248) {
		} else {
			z.DecFallback(yyv2248, false)
		}
	}
	yyj2245++
	if yyhl2245 {
		yyb2245 = yyj2245 > l
	} else {
		yyb2245 = r.CheckBreak()
	}
	if yyb2245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2250 := &x.Items
		yym2251 := z.DecBinary()
		_ = yym2251
		if false {
		} else {
			h.decSliceEndpoints((*[]Endpoints)(yyv2250), d)
		}
	}
	for {
		yyj2245++
		if yyhl2245 {
			yyb2245 = yyj2245 > l
		} else {
			yyb2245 = r.CheckBreak()
		}
		if yyb2245 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2245-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2252 := z.EncBinary()
		_ = yym2252
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2253 := !z.EncBinary()
			yy2arr2253 := z.EncBasicHandle().StructToArray
			var yyq2253 [4]bool
			_, _, _ = yysep2253, yyq2253, yy2arr2253
			const yyr2253 bool = false
			yyq2253[0] = x.PodCIDR != ""
			yyq2253[1] = x.ExternalID != ""
			yyq2253[2] = x.ProviderID != ""
			yyq2253[3] = x.Unschedulable != false
			var yynn2253 int
			if yyr2253 || yy2arr2253 {
				r.EncodeArrayStart(4)
			} else {
				yynn2253 = 0
				for _, b := range yyq2253 {
					if b {
						yynn2253++
					}
				}
				r.EncodeMapStart(yynn2253)
				yynn2253 = 0
			}
			if yyr2253 || yy2arr2253 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2253[0] {
					yym2255 := z.EncBinary()
					_ = yym2255
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2253[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2256 := z.EncBinary()
					_ = yym2256
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				}
			}
			if yyr2253 || yy2arr2253 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2253[1] {
					yym2258 := z.EncBinary()
					_ = yym2258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2253[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2259 := z.EncBinary()
					_ = yym2259
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				}
			}
			if yyr2253 || yy2arr2253 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2253[2] {
					yym2261 := z.EncBinary()
					_ = yym2261
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2253[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("providerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2262 := z.EncBinary()
					_ = yym2262
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				}
			}
			if yyr2253 || yy2arr2253 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2253[3] {
					yym2264 := z.EncBinary()
					_ = yym2264
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2253[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unschedulable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2265 := z.EncBinary()
					_ = yym2265
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				}
			}
			if yyr2253 || yy2arr2253 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2266 := z.DecBinary()
	_ = yym2266
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2267 := r.ContainerType()
		if yyct2267 == codecSelferValueTypeMap1234 {
			yyl2267 := r.ReadMapStart()
			if yyl2267 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2267, d)
			}
		} else if yyct2267 == codecSelferValueTypeArray1234 {
			yyl2267 := r.ReadArrayStart()
			if yyl2267 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2267, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2268Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2268Slc
	var yyhl2268 bool = l >= 0
	for yyj2268 := 0; ; yyj2268++ {
		if yyhl2268 {
			if yyj2268 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2268Slc = r.DecodeBytes(yys2268Slc, true, true)
		yys2268 := string(yys2268Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2268 {
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "externalID":
			if r.TryDecodeAsNil() {
				x.ExternalID = ""
			} else {
				x.ExternalID = string(r.DecodeString())
			}
		case "providerID":
			if r.TryDecodeAsNil() {
				x.ProviderID = ""
			} else {
				x.ProviderID = string(r.DecodeString())
			}
		case "unschedulable":
			if r.TryDecodeAsNil() {
				x.Unschedulable = false
			} else {
				x.Unschedulable = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2268)
		} // end switch yys2268
	} // end for yyj2268
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2273 int
	var yyb2273 bool
	var yyhl2273 bool = l >= 0
	yyj2273++
	if yyhl2273 {
		yyb2273 = yyj2273 > l
	} else {
		yyb2273 = r.CheckBreak()
	}
	if yyb2273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj2273++
	if yyhl2273 {
		yyb2273 = yyj2273 > l
	} else {
		yyb2273 = r.CheckBreak()
	}
	if yyb2273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalID = ""
	} else {
		x.ExternalID = string(r.DecodeString())
	}
	yyj2273++
	if yyhl2273 {
		yyb2273 = yyj2273 > l
	} else {
		yyb2273 = r.CheckBreak()
	}
	if yyb2273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProviderID = ""
	} else {
		x.ProviderID = string(r.DecodeString())
	}
	yyj2273++
	if yyhl2273 {
		yyb2273 = yyj2273 > l
	} else {
		yyb2273 = r.CheckBreak()
	}
	if yyb2273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Unschedulable = false
	} else {
		x.Unschedulable = bool(r.DecodeBool())
	}
	for {
		yyj2273++
		if yyhl2273 {
			yyb2273 = yyj2273 > l
		} else {
			yyb2273 = r.CheckBreak()
		}
		if yyb2273 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2273-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonEndpoint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2278 := z.EncBinary()
		_ = yym2278
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2279 := !z.EncBinary()
			yy2arr2279 := z.EncBasicHandle().StructToArray
			var yyq2279 [1]bool
			_, _, _ = yysep2279, yyq2279, yy2arr2279
			const yyr2279 bool = false
			var yynn2279 int
			if yyr2279 || yy2arr2279 {
				r.EncodeArrayStart(1)
			} else {
				yynn2279 = 1
				for _, b := range yyq2279 {
					if b {
						yynn2279++
					}
				}
				r.EncodeMapStart(yynn2279)
				yynn2279 = 0
			}
			if yyr2279 || yy2arr2279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2281 := z.EncBinary()
				_ = yym2281
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2282 := z.EncBinary()
				_ = yym2282
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2279 || yy2arr2279 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonEndpoint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2283 := z.DecBinary()
	_ = yym2283
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2284 := r.ContainerType()
		if yyct2284 == codecSelferValueTypeMap1234 {
			yyl2284 := r.ReadMapStart()
			if yyl2284 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2284, d)
			}
		} else if yyct2284 == codecSelferValueTypeArray1234 {
			yyl2284 := r.ReadArrayStart()
			if yyl2284 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2284, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonEndpoint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2285Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2285Slc
	var yyhl2285 bool = l >= 0
	for yyj2285 := 0; ; yyj2285++ {
		if yyhl2285 {
			if yyj2285 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2285Slc = r.DecodeBytes(yys2285Slc, true, true)
		yys2285 := string(yys2285Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2285 {
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2285)
		} // end switch yys2285
	} // end for yyj2285
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonEndpoint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2287 int
	var yyb2287 bool
	var yyhl2287 bool = l >= 0
	yyj2287++
	if yyhl2287 {
		yyb2287 = yyj2287 > l
	} else {
		yyb2287 = r.CheckBreak()
	}
	if yyb2287 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj2287++
		if yyhl2287 {
			yyb2287 = yyj2287 > l
		} else {
			yyb2287 = r.CheckBreak()
		}
		if yyb2287 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2287-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeDaemonEndpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2289 := z.EncBinary()
		_ = yym2289
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2290 := !z.EncBinary()
			yy2arr2290 := z.EncBasicHandle().StructToArray
			var yyq2290 [1]bool
			_, _, _ = yysep2290, yyq2290, yy2arr2290
			const yyr2290 bool = false
			yyq2290[0] = true
			var yynn2290 int
			if yyr2290 || yy2arr2290 {
				r.EncodeArrayStart(1)
			} else {
				yynn2290 = 0
				for _, b := range yyq2290 {
					if b {
						yynn2290++
					}
				}
				r.EncodeMapStart(yynn2290)
				yynn2290 = 0
			}
			if yyr2290 || yy2arr2290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2290[0] {
					yy2292 := &x.KubeletEndpoint
					yy2292.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2290[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2293 := &x.KubeletEndpoint
					yy2293.CodecEncodeSelf(e)
				}
			}
			if yyr2290 || yy2arr2290 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeDaemonEndpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2294 := z.DecBinary()
	_ = yym2294
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2295 := r.ContainerType()
		if yyct2295 == codecSelferValueTypeMap1234 {
			yyl2295 := r.ReadMapStart()
			if yyl2295 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2295, d)
			}
		} else if yyct2295 == codecSelferValueTypeArray1234 {
			yyl2295 := r.ReadArrayStart()
			if yyl2295 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2295, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2296Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2296Slc
	var yyhl2296 bool = l >= 0
	for yyj2296 := 0; ; yyj2296++ {
		if yyhl2296 {
			if yyj2296 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2296Slc = r.DecodeBytes(yys2296Slc, true, true)
		yys2296 := string(yys2296Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2296 {
		case "kubeletEndpoint":
			if r.TryDecodeAsNil() {
				x.KubeletEndpoint = DaemonEndpoint{}
			} else {
				yyv2297 := &x.KubeletEndpoint
				yyv2297.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2296)
		} // end switch yys2296
	} // end for yyj2296
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2298 int
	var yyb2298 bool
	var yyhl2298 bool = l >= 0
	yyj2298++
	if yyhl2298 {
		yyb2298 = yyj2298 > l
	} else {
		yyb2298 = r.CheckBreak()
	}
	if yyb2298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletEndpoint = DaemonEndpoint{}
	} else {
		yyv2299 := &x.KubeletEndpoint
		yyv2299.CodecDecodeSelf(d)
	}
	for {
		yyj2298++
		if yyhl2298 {
			yyb2298 = yyj2298 > l
		} else {
			yyb2298 = r.CheckBreak()
		}
		if yyb2298 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2298-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSystemInfo) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2300 := z.EncBinary()
		_ = yym2300
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2301 := !z.EncBinary()
			yy2arr2301 := z.EncBasicHandle().StructToArray
			var yyq2301 [8]bool
			_, _, _ = yysep2301, yyq2301, yy2arr2301
			const yyr2301 bool = false
			var yynn2301 int
			if yyr2301 || yy2arr2301 {
				r.EncodeArrayStart(8)
			} else {
				yynn2301 = 8
				for _, b := range yyq2301 {
					if b {
						yynn2301++
					}
				}
				r.EncodeMapStart(yynn2301)
				yynn2301 = 0
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2303 := z.EncBinary()
				_ = yym2303
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("machineID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2304 := z.EncBinary()
				_ = yym2304
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2306 := z.EncBinary()
				_ = yym2306
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemUUID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2307 := z.EncBinary()
				_ = yym2307
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2309 := z.EncBinary()
				_ = yym2309
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bootID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2310 := z.EncBinary()
				_ = yym2310
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2312 := z.EncBinary()
				_ = yym2312
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kernelVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2313 := z.EncBinary()
				_ = yym2313
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2315 := z.EncBinary()
				_ = yym2315
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("osImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2316 := z.EncBinary()
				_ = yym2316
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2318 := z.EncBinary()
				_ = yym2318
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntimeVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2319 := z.EncBinary()
				_ = yym2319
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2321 := z.EncBinary()
				_ = yym2321
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeletVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2322 := z.EncBinary()
				_ = yym2322
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2324 := z.EncBinary()
				_ = yym2324
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeProxyVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2325 := z.EncBinary()
				_ = yym2325
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSystemInfo) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2326 := z.DecBinary()
	_ = yym2326
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2327 := r.ContainerType()
		if yyct2327 == codecSelferValueTypeMap1234 {
			yyl2327 := r.ReadMapStart()
			if yyl2327 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2327, d)
			}
		} else if yyct2327 == codecSelferValueTypeArray1234 {
			yyl2327 := r.ReadArrayStart()
			if yyl2327 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2327, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSystemInfo) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2328Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2328Slc
	var yyhl2328 bool = l >= 0
	for yyj2328 := 0; ; yyj2328++ {
		if yyhl2328 {
			if yyj2328 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2328Slc = r.DecodeBytes(yys2328Slc, true, true)
		yys2328 := string(yys2328Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2328 {
		case "machineID":
			if r.TryDecodeAsNil() {
				x.MachineID = ""
			} else {
				x.MachineID = string(r.DecodeString())
			}
		case "systemUUID":
			if r.TryDecodeAsNil() {
				x.SystemUUID = ""
			} else {
				x.SystemUUID = string(r.DecodeString())
			}
		case "bootID":
			if r.TryDecodeAsNil() {
				x.BootID = ""
			} else {
				x.BootID = string(r.DecodeString())
			}
		case "kernelVersion":
			if r.TryDecodeAsNil() {
				x.KernelVersion = ""
			} else {
				x.KernelVersion = string(r.DecodeString())
			}
		case "osImage":
			if r.TryDecodeAsNil() {
				x.OSImage = ""
			} else {
				x.OSImage = string(r.DecodeString())
			}
		case "containerRuntimeVersion":
			if r.TryDecodeAsNil() {
				x.ContainerRuntimeVersion = ""
			} else {
				x.ContainerRuntimeVersion = string(r.DecodeString())
			}
		case "kubeletVersion":
			if r.TryDecodeAsNil() {
				x.KubeletVersion = ""
			} else {
				x.KubeletVersion = string(r.DecodeString())
			}
		case "kubeProxyVersion":
			if r.TryDecodeAsNil() {
				x.KubeProxyVersion = ""
			} else {
				x.KubeProxyVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2328)
		} // end switch yys2328
	} // end for yyj2328
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSystemInfo) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2337 int
	var yyb2337 bool
	var yyhl2337 bool = l >= 0
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MachineID = ""
	} else {
		x.MachineID = string(r.DecodeString())
	}
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemUUID = ""
	} else {
		x.SystemUUID = string(r.DecodeString())
	}
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BootID = ""
	} else {
		x.BootID = string(r.DecodeString())
	}
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KernelVersion = ""
	} else {
		x.KernelVersion = string(r.DecodeString())
	}
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OSImage = ""
	} else {
		x.OSImage = string(r.DecodeString())
	}
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntimeVersion = ""
	} else {
		x.ContainerRuntimeVersion = string(r.DecodeString())
	}
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletVersion = ""
	} else {
		x.KubeletVersion = string(r.DecodeString())
	}
	yyj2337++
	if yyhl2337 {
		yyb2337 = yyj2337 > l
	} else {
		yyb2337 = r.CheckBreak()
	}
	if yyb2337 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeProxyVersion = ""
	} else {
		x.KubeProxyVersion = string(r.DecodeString())
	}
	for {
		yyj2337++
		if yyhl2337 {
			yyb2337 = yyj2337 > l
		} else {
			yyb2337 = r.CheckBreak()
		}
		if yyb2337 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2337-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2346 := z.EncBinary()
		_ = yym2346
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2347 := !z.EncBinary()
			yy2arr2347 := z.EncBasicHandle().StructToArray
			var yyq2347 [7]bool
			_, _, _ = yysep2347, yyq2347, yy2arr2347
			const yyr2347 bool = false
			yyq2347[0] = len(x.Capacity) != 0
			yyq2347[1] = len(x.Allocatable) != 0
			yyq2347[2] = x.Phase != ""
			yyq2347[3] = len(x.Conditions) != 0
			yyq2347[4] = len(x.Addresses) != 0
			yyq2347[5] = true
			yyq2347[6] = true
			var yynn2347 int
			if yyr2347 || yy2arr2347 {
				r.EncodeArrayStart(7)
			} else {
				yynn2347 = 0
				for _, b := range yyq2347 {
					if b {
						yynn2347++
					}
				}
				r.EncodeMapStart(yynn2347)
				yynn2347 = 0
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[1] {
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allocatable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[2] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2347[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[3] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2352 := z.EncBinary()
						_ = yym2352
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2353 := z.EncBinary()
						_ = yym2353
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[4] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2355 := z.EncBinary()
						_ = yym2355
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2356 := z.EncBinary()
						_ = yym2356
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[5] {
					yy2358 := &x.DaemonEndpoints
					yy2358.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("daemonEndpoints"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2359 := &x.DaemonEndpoints
					yy2359.CodecEncodeSelf(e)
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[6] {
					yy2361 := &x.NodeInfo
					yy2361.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeInfo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2362 := &x.NodeInfo
					yy2362.CodecEncodeSelf(e)
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2363 := z.DecBinary()
	_ = yym2363
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2364 := r.ContainerType()
		if yyct2364 == codecSelferValueTypeMap1234 {
			yyl2364 := r.ReadMapStart()
			if yyl2364 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2364, d)
			}
		} else if yyct2364 == codecSelferValueTypeArray1234 {
			yyl2364 := r.ReadArrayStart()
			if yyl2364 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2364, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2365Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2365Slc
	var yyhl2365 bool = l >= 0
	for yyj2365 := 0; ; yyj2365++ {
		if yyhl2365 {
			if yyj2365 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2365Slc = r.DecodeBytes(yys2365Slc, true, true)
		yys2365 := string(yys2365Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2365 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv2366 := &x.Capacity
				yyv2366.CodecDecodeSelf(d)
			}
		case "allocatable":
			if r.TryDecodeAsNil() {
				x.Allocatable = nil
			} else {
				yyv2367 := &x.Allocatable
				yyv2367.CodecDecodeSelf(d)
			}
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NodePhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2369 := &x.Conditions
				yym2370 := z.DecBinary()
				_ = yym2370
				if false {
				} else {
					h.decSliceNodeCondition((*[]NodeCondition)(yyv2369), d)
				}
			}
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2371 := &x.Addresses
				yym2372 := z.DecBinary()
				_ = yym2372
				if false {
				} else {
					h.decSliceNodeAddress((*[]NodeAddress)(yyv2371), d)
				}
			}
		case "daemonEndpoints":
			if r.TryDecodeAsNil() {
				x.DaemonEndpoints = NodeDaemonEndpoints{}
			} else {
				yyv2373 := &x.DaemonEndpoints
				yyv2373.CodecDecodeSelf(d)
			}
		case "nodeInfo":
			if r.TryDecodeAsNil() {
				x.NodeInfo = NodeSystemInfo{}
			} else {
				yyv2374 := &x.NodeInfo
				yyv2374.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2365)
		} // end switch yys2365
	} // end for yyj2365
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2375 int
	var yyb2375 bool
	var yyhl2375 bool = l >= 0
	yyj2375++
	if yyhl2375 {
		yyb2375 = yyj2375 > l
	} else {
		yyb2375 = r.CheckBreak()
	}
	if yyb2375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv2376 := &x.Capacity
		yyv2376.CodecDecodeSelf(d)
	}
	yyj2375++
	if yyhl2375 {
		yyb2375 = yyj2375 > l
	} else {
		yyb2375 = r.CheckBreak()
	}
	if yyb2375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allocatable = nil
	} else {
		yyv2377 := &x.Allocatable
		yyv2377.CodecDecodeSelf(d)
	}
	yyj2375++
	if yyhl2375 {
		yyb2375 = yyj2375 > l
	} else {
		yyb2375 = r.CheckBreak()
	}
	if yyb2375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NodePhase(r.DecodeString())
	}
	yyj2375++
	if yyhl2375 {
		yyb2375 = yyj2375 > l
	} else {
		yyb2375 = r.CheckBreak()
	}
	if yyb2375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2379 := &x.Conditions
		yym2380 := z.DecBinary()
		_ = yym2380
		if false {
		} else {
			h.decSliceNodeCondition((*[]NodeCondition)(yyv2379), d)
		}
	}
	yyj2375++
	if yyhl2375 {
		yyb2375 = yyj2375 > l
	} else {
		yyb2375 = r.CheckBreak()
	}
	if yyb2375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2381 := &x.Addresses
		yym2382 := z.DecBinary()
		_ = yym2382
		if false {
		} else {
			h.decSliceNodeAddress((*[]NodeAddress)(yyv2381), d)
		}
	}
	yyj2375++
	if yyhl2375 {
		yyb2375 = yyj2375 > l
	} else {
		yyb2375 = r.CheckBreak()
	}
	if yyb2375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DaemonEndpoints = NodeDaemonEndpoints{}
	} else {
		yyv2383 := &x.DaemonEndpoints
		yyv2383.CodecDecodeSelf(d)
	}
	yyj2375++
	if yyhl2375 {
		yyb2375 = yyj2375 > l
	} else {
		yyb2375 = r.CheckBreak()
	}
	if yyb2375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeInfo = NodeSystemInfo{}
	} else {
		yyv2384 := &x.NodeInfo
		yyv2384.CodecDecodeSelf(d)
	}
	for {
		yyj2375++
		if yyhl2375 {
			yyb2375 = yyj2375 > l
		} else {
			yyb2375 = r.CheckBreak()
		}
		if yyb2375 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2375-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2385 := z.EncBinary()
	_ = yym2385
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2386 := z.DecBinary()
	_ = yym2386
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x NodeConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2387 := z.EncBinary()
	_ = yym2387
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2388 := z.DecBinary()
	_ = yym2388
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2389 := z.EncBinary()
		_ = yym2389
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2390 := !z.EncBinary()
			yy2arr2390 := z.EncBasicHandle().StructToArray
			var yyq2390 [6]bool
			_, _, _ = yysep2390, yyq2390, yy2arr2390
			const yyr2390 bool = false
			yyq2390[2] = true
			yyq2390[3] = true
			yyq2390[4] = x.Reason != ""
			yyq2390[5] = x.Message != ""
			var yynn2390 int
			if yyr2390 || yy2arr2390 {
				r.EncodeArrayStart(6)
			} else {
				yynn2390 = 2
				for _, b := range yyq2390 {
					if b {
						yynn2390++
					}
				}
				r.EncodeMapStart(yynn2390)
				yynn2390 = 0
			}
			if yyr2390 || yy2arr2390 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2390 || yy2arr2390 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr2390 || yy2arr2390 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2390[2] {
					yy2394 := &x.LastHeartbeatTime
					yym2395 := z.EncBinary()
					_ = yym2395
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2394) {
					} else if yym2395 {
						z.EncBinaryMarshal(yy2394)
					} else if !yym2395 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2394)
					} else {
						z.EncFallback(yy2394)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2390[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastHeartbeatTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2396 := &x.LastHeartbeatTime
					yym2397 := z.EncBinary()
					_ = yym2397
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2396) {
					} else if yym2397 {
						z.EncBinaryMarshal(yy2396)
					} else if !yym2397 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2396)
					} else {
						z.EncFallback(yy2396)
					}
				}
			}
			if yyr2390 || yy2arr2390 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2390[3] {
					yy2399 := &x.LastTransitionTime
					yym2400 := z.EncBinary()
					_ = yym2400
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2399) {
					} else if yym2400 {
						z.EncBinaryMarshal(yy2399)
					} else if !yym2400 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2399)
					} else {
						z.EncFallback(yy2399)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2390[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2401 := &x.LastTransitionTime
					yym2402 := z.EncBinary()
					_ = yym2402
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2401) {
					} else if yym2402 {
						z.EncBinaryMarshal(yy2401)
					} else if !yym2402 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2401)
					} else {
						z.EncFallback(yy2401)
					}
				}
			}
			if yyr2390 || yy2arr2390 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2390[4] {
					yym2404 := z.EncBinary()
					_ = yym2404
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2390[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2405 := z.EncBinary()
					_ = yym2405
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2390 || yy2arr2390 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2390[5] {
					yym2407 := z.EncBinary()
					_ = yym2407
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2390[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2408 := z.EncBinary()
					_ = yym2408
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2390 || yy2arr2390 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2409 := z.DecBinary()
	_ = yym2409
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2410 := r.ContainerType()
		if yyct2410 == codecSelferValueTypeMap1234 {
			yyl2410 := r.ReadMapStart()
			if yyl2410 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2410, d)
			}
		} else if yyct2410 == codecSelferValueTypeArray1234 {
			yyl2410 := r.ReadArrayStart()
			if yyl2410 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2410, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2411Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2411Slc
	var yyhl2411 bool = l >= 0
	for yyj2411 := 0; ; yyj2411++ {
		if yyhl2411 {
			if yyj2411 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2411Slc = r.DecodeBytes(yys2411Slc, true, true)
		yys2411 := string(yys2411Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2411 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = NodeConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastHeartbeatTime":
			if r.TryDecodeAsNil() {
				x.LastHeartbeatTime = pkg2_unversioned.Time{}
			} else {
				yyv2414 := &x.LastHeartbeatTime
				yym2415 := z.DecBinary()
				_ = yym2415
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2414) {
				} else if yym2415 {
					z.DecBinaryUnmarshal(yyv2414)
				} else if !yym2415 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2414)
				} else {
					z.DecFallback(yyv2414, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv2416 := &x.LastTransitionTime
				yym2417 := z.DecBinary()
				_ = yym2417
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2416) {
				} else if yym2417 {
					z.DecBinaryUnmarshal(yyv2416)
				} else if !yym2417 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2416)
				} else {
					z.DecFallback(yyv2416, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2411)
		} // end switch yys2411
	} // end for yyj2411
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2420 int
	var yyb2420 bool
	var yyhl2420 bool = l >= 0
	yyj2420++
	if yyhl2420 {
		yyb2420 = yyj2420 > l
	} else {
		yyb2420 = r.CheckBreak()
	}
	if yyb2420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = NodeConditionType(r.DecodeString())
	}
	yyj2420++
	if yyhl2420 {
		yyb2420 = yyj2420 > l
	} else {
		yyb2420 = r.CheckBreak()
	}
	if yyb2420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj2420++
	if yyhl2420 {
		yyb2420 = yyj2420 > l
	} else {
		yyb2420 = r.CheckBreak()
	}
	if yyb2420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastHeartbeatTime = pkg2_unversioned.Time{}
	} else {
		yyv2423 := &x.LastHeartbeatTime
		yym2424 := z.DecBinary()
		_ = yym2424
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2423) {
		} else if yym2424 {
			z.DecBinaryUnmarshal(yyv2423)
		} else if !yym2424 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2423)
		} else {
			z.DecFallback(yyv2423, false)
		}
	}
	yyj2420++
	if yyhl2420 {
		yyb2420 = yyj2420 > l
	} else {
		yyb2420 = r.CheckBreak()
	}
	if yyb2420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv2425 := &x.LastTransitionTime
		yym2426 := z.DecBinary()
		_ = yym2426
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2425) {
		} else if yym2426 {
			z.DecBinaryUnmarshal(yyv2425)
		} else if !yym2426 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2425)
		} else {
			z.DecFallback(yyv2425, false)
		}
	}
	yyj2420++
	if yyhl2420 {
		yyb2420 = yyj2420 > l
	} else {
		yyb2420 = r.CheckBreak()
	}
	if yyb2420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2420++
	if yyhl2420 {
		yyb2420 = yyj2420 > l
	} else {
		yyb2420 = r.CheckBreak()
	}
	if yyb2420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj2420++
		if yyhl2420 {
			yyb2420 = yyj2420 > l
		} else {
			yyb2420 = r.CheckBreak()
		}
		if yyb2420 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2420-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeAddressType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2429 := z.EncBinary()
	_ = yym2429
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeAddressType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2430 := z.DecBinary()
	_ = yym2430
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2431 := z.EncBinary()
		_ = yym2431
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2432 := !z.EncBinary()
			yy2arr2432 := z.EncBasicHandle().StructToArray
			var yyq2432 [2]bool
			_, _, _ = yysep2432, yyq2432, yy2arr2432
			const yyr2432 bool = false
			var yynn2432 int
			if yyr2432 || yy2arr2432 {
				r.EncodeArrayStart(2)
			} else {
				yynn2432 = 2
				for _, b := range yyq2432 {
					if b {
						yynn2432++
					}
				}
				r.EncodeMapStart(yynn2432)
				yynn2432 = 0
			}
			if yyr2432 || yy2arr2432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2432 || yy2arr2432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2435 := z.EncBinary()
				_ = yym2435
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2436 := z.EncBinary()
				_ = yym2436
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr2432 || yy2arr2432 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2437 := z.DecBinary()
	_ = yym2437
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2438 := r.ContainerType()
		if yyct2438 == codecSelferValueTypeMap1234 {
			yyl2438 := r.ReadMapStart()
			if yyl2438 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2438, d)
			}
		} else if yyct2438 == codecSelferValueTypeArray1234 {
			yyl2438 := r.ReadArrayStart()
			if yyl2438 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2438, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2439Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2439Slc
	var yyhl2439 bool = l >= 0
	for yyj2439 := 0; ; yyj2439++ {
		if yyhl2439 {
			if yyj2439 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2439Slc = r.DecodeBytes(yys2439Slc, true, true)
		yys2439 := string(yys2439Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2439 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = NodeAddressType(r.DecodeString())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2439)
		} // end switch yys2439
	} // end for yyj2439
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2442 int
	var yyb2442 bool
	var yyhl2442 bool = l >= 0
	yyj2442++
	if yyhl2442 {
		yyb2442 = yyj2442 > l
	} else {
		yyb2442 = r.CheckBreak()
	}
	if yyb2442 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = NodeAddressType(r.DecodeString())
	}
	yyj2442++
	if yyhl2442 {
		yyb2442 = yyj2442 > l
	} else {
		yyb2442 = r.CheckBreak()
	}
	if yyb2442 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	for {
		yyj2442++
		if yyhl2442 {
			yyb2442 = yyj2442 > l
		} else {
			yyb2442 = r.CheckBreak()
		}
		if yyb2442 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2442-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeResources) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2445 := z.EncBinary()
		_ = yym2445
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2446 := !z.EncBinary()
			yy2arr2446 := z.EncBasicHandle().StructToArray
			var yyq2446 [1]bool
			_, _, _ = yysep2446, yyq2446, yy2arr2446
			const yyr2446 bool = false
			yyq2446[0] = len(x.Capacity) != 0
			var yynn2446 int
			if yyr2446 || yy2arr2446 {
				r.EncodeArrayStart(1)
			} else {
				yynn2446 = 0
				for _, b := range yyq2446 {
					if b {
						yynn2446++
					}
				}
				r.EncodeMapStart(yynn2446)
				yynn2446 = 0
			}
			if yyr2446 || yy2arr2446 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2446[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2446[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2446 || yy2arr2446 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeResources) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2448 := z.DecBinary()
	_ = yym2448
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2449 := r.ContainerType()
		if yyct2449 == codecSelferValueTypeMap1234 {
			yyl2449 := r.ReadMapStart()
			if yyl2449 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2449, d)
			}
		} else if yyct2449 == codecSelferValueTypeArray1234 {
			yyl2449 := r.ReadArrayStart()
			if yyl2449 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2449, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeResources) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2450Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2450Slc
	var yyhl2450 bool = l >= 0
	for yyj2450 := 0; ; yyj2450++ {
		if yyhl2450 {
			if yyj2450 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2450Slc = r.DecodeBytes(yys2450Slc, true, true)
		yys2450 := string(yys2450Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2450 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv2451 := &x.Capacity
				yyv2451.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2450)
		} // end switch yys2450
	} // end for yyj2450
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeResources) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2452 int
	var yyb2452 bool
	var yyhl2452 bool = l >= 0
	yyj2452++
	if yyhl2452 {
		yyb2452 = yyj2452 > l
	} else {
		yyb2452 = r.CheckBreak()
	}
	if yyb2452 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv2453 := &x.Capacity
		yyv2453.CodecDecodeSelf(d)
	}
	for {
		yyj2452++
		if yyhl2452 {
			yyb2452 = yyj2452 > l
		} else {
			yyb2452 = r.CheckBreak()
		}
		if yyb2452 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2452-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ResourceName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2454 := z.EncBinary()
	_ = yym2454
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ResourceName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2455 := z.DecBinary()
	_ = yym2455
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2456 := z.EncBinary()
		_ = yym2456
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			h.encResourceList((ResourceList)(x), e)
		}
	}
}

func (x *ResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2457 := z.DecBinary()
	_ = yym2457
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		h.decResourceList((*ResourceList)(x), d)
	}
}

func (x *Node) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2458 := z.EncBinary()
		_ = yym2458
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2459 := !z.EncBinary()
			yy2arr2459 := z.EncBasicHandle().StructToArray
			var yyq2459 [5]bool
			_, _, _ = yysep2459, yyq2459, yy2arr2459
			const yyr2459 bool = false
			yyq2459[0] = x.Kind != ""
			yyq2459[1] = x.APIVersion != ""
			yyq2459[2] = true
			yyq2459[3] = true
			yyq2459[4] = true
			var yynn2459 int
			if yyr2459 || yy2arr2459 {
				r.EncodeArrayStart(5)
			} else {
				yynn2459 = 0
				for _, b := range yyq2459 {
					if b {
						yynn2459++
					}
				}
				r.EncodeMapStart(yynn2459)
				yynn2459 = 0
			}
			if yyr2459 || yy2arr2459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2459[0] {
					yym2461 := z.EncBinary()
					_ = yym2461
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2459[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2462 := z.EncBinary()
					_ = yym2462
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2459 || yy2arr2459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2459[1] {
					yym2464 := z.EncBinary()
					_ = yym2464
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2459[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2465 := z.EncBinary()
					_ = yym2465
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2459 || yy2arr2459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2459[2] {
					yy2467 := &x.ObjectMeta
					yy2467.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2459[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2468 := &x.ObjectMeta
					yy2468.CodecEncodeSelf(e)
				}
			}
			if yyr2459 || yy2arr2459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2459[3] {
					yy2470 := &x.Spec
					yy2470.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2459[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2471 := &x.Spec
					yy2471.CodecEncodeSelf(e)
				}
			}
			if yyr2459 || yy2arr2459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2459[4] {
					yy2473 := &x.Status
					yy2473.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2459[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2474 := &x.Status
					yy2474.CodecEncodeSelf(e)
				}
			}
			if yyr2459 || yy2arr2459 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Node) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2475 := z.DecBinary()
	_ = yym2475
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2476 := r.ContainerType()
		if yyct2476 == codecSelferValueTypeMap1234 {
			yyl2476 := r.ReadMapStart()
			if yyl2476 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2476, d)
			}
		} else if yyct2476 == codecSelferValueTypeArray1234 {
			yyl2476 := r.ReadArrayStart()
			if yyl2476 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2476, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Node) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2477Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2477Slc
	var yyhl2477 bool = l >= 0
	for yyj2477 := 0; ; yyj2477++ {
		if yyhl2477 {
			if yyj2477 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2477Slc = r.DecodeBytes(yys2477Slc, true, true)
		yys2477 := string(yys2477Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2477 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2480 := &x.ObjectMeta
				yyv2480.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NodeSpec{}
			} else {
				yyv2481 := &x.Spec
				yyv2481.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = NodeStatus{}
			} else {
				yyv2482 := &x.Status
				yyv2482.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2477)
		} // end switch yys2477
	} // end for yyj2477
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Node) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2483 int
	var yyb2483 bool
	var yyhl2483 bool = l >= 0
	yyj2483++
	if yyhl2483 {
		yyb2483 = yyj2483 > l
	} else {
		yyb2483 = r.CheckBreak()
	}
	if yyb2483 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2483++
	if yyhl2483 {
		yyb2483 = yyj2483 > l
	} else {
		yyb2483 = r.CheckBreak()
	}
	if yyb2483 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2483++
	if yyhl2483 {
		yyb2483 = yyj2483 > l
	} else {
		yyb2483 = r.CheckBreak()
	}
	if yyb2483 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2486 := &x.ObjectMeta
		yyv2486.CodecDecodeSelf(d)
	}
	yyj2483++
	if yyhl2483 {
		yyb2483 = yyj2483 > l
	} else {
		yyb2483 = r.CheckBreak()
	}
	if yyb2483 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NodeSpec{}
	} else {
		yyv2487 := &x.Spec
		yyv2487.CodecDecodeSelf(d)
	}
	yyj2483++
	if yyhl2483 {
		yyb2483 = yyj2483 > l
	} else {
		yyb2483 = r.CheckBreak()
	}
	if yyb2483 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = NodeStatus{}
	} else {
		yyv2488 := &x.Status
		yyv2488.CodecDecodeSelf(d)
	}
	for {
		yyj2483++
		if yyhl2483 {
			yyb2483 = yyj2483 > l
		} else {
			yyb2483 = r.CheckBreak()
		}
		if yyb2483 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2483-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2489 := z.EncBinary()
		_ = yym2489
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2490 := !z.EncBinary()
			yy2arr2490 := z.EncBasicHandle().StructToArray
			var yyq2490 [4]bool
			_, _, _ = yysep2490, yyq2490, yy2arr2490
			const yyr2490 bool = false
			yyq2490[0] = x.Kind != ""
			yyq2490[1] = x.APIVersion != ""
			yyq2490[2] = true
			var yynn2490 int
			if yyr2490 || yy2arr2490 {
				r.EncodeArrayStart(4)
			} else {
				yynn2490 = 1
				for _, b := range yyq2490 {
					if b {
						yynn2490++
					}
				}
				r.EncodeMapStart(yynn2490)
				yynn2490 = 0
			}
			if yyr2490 || yy2arr2490 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2490[0] {
					yym2492 := z.EncBinary()
					_ = yym2492
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2490[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2493 := z.EncBinary()
					_ = yym2493
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2490 || yy2arr2490 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2490[1] {
					yym2495 := z.EncBinary()
					_ = yym2495
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2490[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2496 := z.EncBinary()
					_ = yym2496
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2490 || yy2arr2490 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2490[2] {
					yy2498 := &x.ListMeta
					yym2499 := z.EncBinary()
					_ = yym2499
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2498) {
					} else {
						z.EncFallback(yy2498)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2490[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2500 := &x.ListMeta
					yym2501 := z.EncBinary()
					_ = yym2501
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2500) {
					} else {
						z.EncFallback(yy2500)
					}
				}
			}
			if yyr2490 || yy2arr2490 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2503 := z.EncBinary()
					_ = yym2503
					if false {
					} else {
						h.encSliceNode(([]Node)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2504 := z.EncBinary()
					_ = yym2504
					if false {
					} else {
						h.encSliceNode(([]Node)(x.Items), e)
					}
				}
			}
			if yyr2490 || yy2arr2490 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2505 := z.DecBinary()
	_ = yym2505
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2506 := r.ContainerType()
		if yyct2506 == codecSelferValueTypeMap1234 {
			yyl2506 := r.ReadMapStart()
			if yyl2506 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2506, d)
			}
		} else if yyct2506 == codecSelferValueTypeArray1234 {
			yyl2506 := r.ReadArrayStart()
			if yyl2506 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2506, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2507Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2507Slc
	var yyhl2507 bool = l >= 0
	for yyj2507 := 0; ; yyj2507++ {
		if yyhl2507 {
			if yyj2507 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2507Slc = r.DecodeBytes(yys2507Slc, true, true)
		yys2507 := string(yys2507Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2507 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2510 := &x.ListMeta
				yym2511 := z.DecBinary()
				_ = yym2511
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2510) {
				} else {
					z.DecFallback(yyv2510, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2512 := &x.Items
				yym2513 := z.DecBinary()
				_ = yym2513
				if false {
				} else {
					h.decSliceNode((*[]Node)(yyv2512), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2507)
		} // end switch yys2507
	} // end for yyj2507
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2514 int
	var yyb2514 bool
	var yyhl2514 bool = l >= 0
	yyj2514++
	if yyhl2514 {
		yyb2514 = yyj2514 > l
	} else {
		yyb2514 = r.CheckBreak()
	}
	if yyb2514 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2514++
	if yyhl2514 {
		yyb2514 = yyj2514 > l
	} else {
		yyb2514 = r.CheckBreak()
	}
	if yyb2514 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2514++
	if yyhl2514 {
		yyb2514 = yyj2514 > l
	} else {
		yyb2514 = r.CheckBreak()
	}
	if yyb2514 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2517 := &x.ListMeta
		yym2518 := z.DecBinary()
		_ = yym2518
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2517) {
		} else {
			z.DecFallback(yyv2517, false)
		}
	}
	yyj2514++
	if yyhl2514 {
		yyb2514 = yyj2514 > l
	} else {
		yyb2514 = r.CheckBreak()
	}
	if yyb2514 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2519 := &x.Items
		yym2520 := z.DecBinary()
		_ = yym2520
		if false {
		} else {
			h.decSliceNode((*[]Node)(yyv2519), d)
		}
	}
	for {
		yyj2514++
		if yyhl2514 {
			yyb2514 = yyj2514 > l
		} else {
			yyb2514 = r.CheckBreak()
		}
		if yyb2514 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2514-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NamespaceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2521 := z.EncBinary()
		_ = yym2521
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2522 := !z.EncBinary()
			yy2arr2522 := z.EncBasicHandle().StructToArray
			var yyq2522 [1]bool
			_, _, _ = yysep2522, yyq2522, yy2arr2522
			const yyr2522 bool = false
			var yynn2522 int
			if yyr2522 || yy2arr2522 {
				r.EncodeArrayStart(1)
			} else {
				yynn2522 = 1
				for _, b := range yyq2522 {
					if b {
						yynn2522++
					}
				}
				r.EncodeMapStart(yynn2522)
				yynn2522 = 0
			}
			if yyr2522 || yy2arr2522 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Finalizers == nil {
					r.EncodeNil()
				} else {
					yym2524 := z.EncBinary()
					_ = yym2524
					if false {
					} else {
						h.encSliceFinalizerName(([]FinalizerName)(x.Finalizers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Finalizers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Finalizers == nil {
					r.EncodeNil()
				} else {
					yym2525 := z.EncBinary()
					_ = yym2525
					if false {
					} else {
						h.encSliceFinalizerName(([]FinalizerName)(x.Finalizers), e)
					}
				}
			}
			if yyr2522 || yy2arr2522 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NamespaceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2526 := z.DecBinary()
	_ = yym2526
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2527 := r.ContainerType()
		if yyct2527 == codecSelferValueTypeMap1234 {
			yyl2527 := r.ReadMapStart()
			if yyl2527 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2527, d)
			}
		} else if yyct2527 == codecSelferValueTypeArray1234 {
			yyl2527 := r.ReadArrayStart()
			if yyl2527 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2527, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NamespaceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2528Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2528Slc
	var yyhl2528 bool = l >= 0
	for yyj2528 := 0; ; yyj2528++ {
		if yyhl2528 {
			if yyj2528 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2528Slc = r.DecodeBytes(yys2528Slc, true, true)
		yys2528 := string(yys2528Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2528 {
		case "Finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv2529 := &x.Finalizers
				yym2530 := z.DecBinary()
				_ = yym2530
				if false {
				} else {
					h.decSliceFinalizerName((*[]FinalizerName)(yyv2529), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2528)
		} // end switch yys2528
	} // end for yyj2528
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NamespaceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2531 int
	var yyb2531 bool
	var yyhl2531 bool = l >= 0
	yyj2531++
	if yyhl2531 {
		yyb2531 = yyj2531 > l
	} else {
		yyb2531 = r.CheckBreak()
	}
	if yyb2531 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv2532 := &x.Finalizers
		yym2533 := z.DecBinary()
		_ = yym2533
		if false {
		} else {
			h.decSliceFinalizerName((*[]FinalizerName)(yyv2532), d)
		}
	}
	for {
		yyj2531++
		if yyhl2531 {
			yyb2531 = yyj2531 > l
		} else {
			yyb2531 = r.CheckBreak()
		}
		if yyb2531 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2531-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FinalizerName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2534 := z.EncBinary()
	_ = yym2534
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FinalizerName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2535 := z.DecBinary()
	_ = yym2535
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NamespaceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2536 := z.EncBinary()
		_ = yym2536
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2537 := !z.EncBinary()
			yy2arr2537 := z.EncBasicHandle().StructToArray
			var yyq2537 [1]bool
			_, _, _ = yysep2537, yyq2537, yy2arr2537
			const yyr2537 bool = false
			yyq2537[0] = x.Phase != ""
			var yynn2537 int
			if yyr2537 || yy2arr2537 {
				r.EncodeArrayStart(1)
			} else {
				yynn2537 = 0
				for _, b := range yyq2537 {
					if b {
						yynn2537++
					}
				}
				r.EncodeMapStart(yynn2537)
				yynn2537 = 0
			}
			if yyr2537 || yy2arr2537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2537[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2537[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2537 || yy2arr2537 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NamespaceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2539 := z.DecBinary()
	_ = yym2539
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2540 := r.ContainerType()
		if yyct2540 == codecSelferValueTypeMap1234 {
			yyl2540 := r.ReadMapStart()
			if yyl2540 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2540, d)
			}
		} else if yyct2540 == codecSelferValueTypeArray1234 {
			yyl2540 := r.ReadArrayStart()
			if yyl2540 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2540, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NamespaceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2541Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2541Slc
	var yyhl2541 bool = l >= 0
	for yyj2541 := 0; ; yyj2541++ {
		if yyhl2541 {
			if yyj2541 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2541Slc = r.DecodeBytes(yys2541Slc, true, true)
		yys2541 := string(yys2541Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2541 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NamespacePhase(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2541)
		} // end switch yys2541
	} // end for yyj2541
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NamespaceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2543 int
	var yyb2543 bool
	var yyhl2543 bool = l >= 0
	yyj2543++
	if yyhl2543 {
		yyb2543 = yyj2543 > l
	} else {
		yyb2543 = r.CheckBreak()
	}
	if yyb2543 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NamespacePhase(r.DecodeString())
	}
	for {
		yyj2543++
		if yyhl2543 {
			yyb2543 = yyj2543 > l
		} else {
			yyb2543 = r.CheckBreak()
		}
		if yyb2543 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2543-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NamespacePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2545 := z.EncBinary()
	_ = yym2545
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NamespacePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2546 := z.DecBinary()
	_ = yym2546
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Namespace) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2547 := z.EncBinary()
		_ = yym2547
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2548 := !z.EncBinary()
			yy2arr2548 := z.EncBasicHandle().StructToArray
			var yyq2548 [5]bool
			_, _, _ = yysep2548, yyq2548, yy2arr2548
			const yyr2548 bool = false
			yyq2548[0] = x.Kind != ""
			yyq2548[1] = x.APIVersion != ""
			yyq2548[2] = true
			yyq2548[3] = true
			yyq2548[4] = true
			var yynn2548 int
			if yyr2548 || yy2arr2548 {
				r.EncodeArrayStart(5)
			} else {
				yynn2548 = 0
				for _, b := range yyq2548 {
					if b {
						yynn2548++
					}
				}
				r.EncodeMapStart(yynn2548)
				yynn2548 = 0
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2548[0] {
					yym2550 := z.EncBinary()
					_ = yym2550
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2548[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2551 := z.EncBinary()
					_ = yym2551
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2548[1] {
					yym2553 := z.EncBinary()
					_ = yym2553
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2548[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2554 := z.EncBinary()
					_ = yym2554
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2548[2] {
					yy2556 := &x.ObjectMeta
					yy2556.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2548[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2557 := &x.ObjectMeta
					yy2557.CodecEncodeSelf(e)
				}
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2548[3] {
					yy2559 := &x.Spec
					yy2559.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2548[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2560 := &x.Spec
					yy2560.CodecEncodeSelf(e)
				}
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2548[4] {
					yy2562 := &x.Status
					yy2562.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2548[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2563 := &x.Status
					yy2563.CodecEncodeSelf(e)
				}
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Namespace) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2564 := z.DecBinary()
	_ = yym2564
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2565 := r.ContainerType()
		if yyct2565 == codecSelferValueTypeMap1234 {
			yyl2565 := r.ReadMapStart()
			if yyl2565 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2565, d)
			}
		} else if yyct2565 == codecSelferValueTypeArray1234 {
			yyl2565 := r.ReadArrayStart()
			if yyl2565 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2565, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Namespace) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2566Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2566Slc
	var yyhl2566 bool = l >= 0
	for yyj2566 := 0; ; yyj2566++ {
		if yyhl2566 {
			if yyj2566 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2566Slc = r.DecodeBytes(yys2566Slc, true, true)
		yys2566 := string(yys2566Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2566 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2569 := &x.ObjectMeta
				yyv2569.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NamespaceSpec{}
			} else {
				yyv2570 := &x.Spec
				yyv2570.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = NamespaceStatus{}
			} else {
				yyv2571 := &x.Status
				yyv2571.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2566)
		} // end switch yys2566
	} // end for yyj2566
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Namespace) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2572 int
	var yyb2572 bool
	var yyhl2572 bool = l >= 0
	yyj2572++
	if yyhl2572 {
		yyb2572 = yyj2572 > l
	} else {
		yyb2572 = r.CheckBreak()
	}
	if yyb2572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2572++
	if yyhl2572 {
		yyb2572 = yyj2572 > l
	} else {
		yyb2572 = r.CheckBreak()
	}
	if yyb2572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2572++
	if yyhl2572 {
		yyb2572 = yyj2572 > l
	} else {
		yyb2572 = r.CheckBreak()
	}
	if yyb2572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2575 := &x.ObjectMeta
		yyv2575.CodecDecodeSelf(d)
	}
	yyj2572++
	if yyhl2572 {
		yyb2572 = yyj2572 > l
	} else {
		yyb2572 = r.CheckBreak()
	}
	if yyb2572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NamespaceSpec{}
	} else {
		yyv2576 := &x.Spec
		yyv2576.CodecDecodeSelf(d)
	}
	yyj2572++
	if yyhl2572 {
		yyb2572 = yyj2572 > l
	} else {
		yyb2572 = r.CheckBreak()
	}
	if yyb2572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = NamespaceStatus{}
	} else {
		yyv2577 := &x.Status
		yyv2577.CodecDecodeSelf(d)
	}
	for {
		yyj2572++
		if yyhl2572 {
			yyb2572 = yyj2572 > l
		} else {
			yyb2572 = r.CheckBreak()
		}
		if yyb2572 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2572-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NamespaceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2578 := z.EncBinary()
		_ = yym2578
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2579 := !z.EncBinary()
			yy2arr2579 := z.EncBasicHandle().StructToArray
			var yyq2579 [4]bool
			_, _, _ = yysep2579, yyq2579, yy2arr2579
			const yyr2579 bool = false
			yyq2579[0] = x.Kind != ""
			yyq2579[1] = x.APIVersion != ""
			yyq2579[2] = true
			var yynn2579 int
			if yyr2579 || yy2arr2579 {
				r.EncodeArrayStart(4)
			} else {
				yynn2579 = 1
				for _, b := range yyq2579 {
					if b {
						yynn2579++
					}
				}
				r.EncodeMapStart(yynn2579)
				yynn2579 = 0
			}
			if yyr2579 || yy2arr2579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2579[0] {
					yym2581 := z.EncBinary()
					_ = yym2581
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2579[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2582 := z.EncBinary()
					_ = yym2582
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2579 || yy2arr2579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2579[1] {
					yym2584 := z.EncBinary()
					_ = yym2584
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2579[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2585 := z.EncBinary()
					_ = yym2585
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2579 || yy2arr2579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2579[2] {
					yy2587 := &x.ListMeta
					yym2588 := z.EncBinary()
					_ = yym2588
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2587) {
					} else {
						z.EncFallback(yy2587)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2579[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2589 := &x.ListMeta
					yym2590 := z.EncBinary()
					_ = yym2590
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2589) {
					} else {
						z.EncFallback(yy2589)
					}
				}
			}
			if yyr2579 || yy2arr2579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2592 := z.EncBinary()
					_ = yym2592
					if false {
					} else {
						h.encSliceNamespace(([]Namespace)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2593 := z.EncBinary()
					_ = yym2593
					if false {
					} else {
						h.encSliceNamespace(([]Namespace)(x.Items), e)
					}
				}
			}
			if yyr2579 || yy2arr2579 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NamespaceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2594 := z.DecBinary()
	_ = yym2594
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2595 := r.ContainerType()
		if yyct2595 == codecSelferValueTypeMap1234 {
			yyl2595 := r.ReadMapStart()
			if yyl2595 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2595, d)
			}
		} else if yyct2595 == codecSelferValueTypeArray1234 {
			yyl2595 := r.ReadArrayStart()
			if yyl2595 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2595, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NamespaceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2596Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2596Slc
	var yyhl2596 bool = l >= 0
	for yyj2596 := 0; ; yyj2596++ {
		if yyhl2596 {
			if yyj2596 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2596Slc = r.DecodeBytes(yys2596Slc, true, true)
		yys2596 := string(yys2596Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2596 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2599 := &x.ListMeta
				yym2600 := z.DecBinary()
				_ = yym2600
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2599) {
				} else {
					z.DecFallback(yyv2599, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2601 := &x.Items
				yym2602 := z.DecBinary()
				_ = yym2602
				if false {
				} else {
					h.decSliceNamespace((*[]Namespace)(yyv2601), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2596)
		} // end switch yys2596
	} // end for yyj2596
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NamespaceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2603 int
	var yyb2603 bool
	var yyhl2603 bool = l >= 0
	yyj2603++
	if yyhl2603 {
		yyb2603 = yyj2603 > l
	} else {
		yyb2603 = r.CheckBreak()
	}
	if yyb2603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2603++
	if yyhl2603 {
		yyb2603 = yyj2603 > l
	} else {
		yyb2603 = r.CheckBreak()
	}
	if yyb2603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2603++
	if yyhl2603 {
		yyb2603 = yyj2603 > l
	} else {
		yyb2603 = r.CheckBreak()
	}
	if yyb2603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2606 := &x.ListMeta
		yym2607 := z.DecBinary()
		_ = yym2607
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2606) {
		} else {
			z.DecFallback(yyv2606, false)
		}
	}
	yyj2603++
	if yyhl2603 {
		yyb2603 = yyj2603 > l
	} else {
		yyb2603 = r.CheckBreak()
	}
	if yyb2603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2608 := &x.Items
		yym2609 := z.DecBinary()
		_ = yym2609
		if false {
		} else {
			h.decSliceNamespace((*[]Namespace)(yyv2608), d)
		}
	}
	for {
		yyj2603++
		if yyhl2603 {
			yyb2603 = yyj2603 > l
		} else {
			yyb2603 = r.CheckBreak()
		}
		if yyb2603 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2603-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Binding) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2610 := z.EncBinary()
		_ = yym2610
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2611 := !z.EncBinary()
			yy2arr2611 := z.EncBasicHandle().StructToArray
			var yyq2611 [4]bool
			_, _, _ = yysep2611, yyq2611, yy2arr2611
			const yyr2611 bool = false
			yyq2611[0] = x.Kind != ""
			yyq2611[1] = x.APIVersion != ""
			yyq2611[2] = true
			var yynn2611 int
			if yyr2611 || yy2arr2611 {
				r.EncodeArrayStart(4)
			} else {
				yynn2611 = 1
				for _, b := range yyq2611 {
					if b {
						yynn2611++
					}
				}
				r.EncodeMapStart(yynn2611)
				yynn2611 = 0
			}
			if yyr2611 || yy2arr2611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2611[0] {
					yym2613 := z.EncBinary()
					_ = yym2613
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2611[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2614 := z.EncBinary()
					_ = yym2614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2611 || yy2arr2611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2611[1] {
					yym2616 := z.EncBinary()
					_ = yym2616
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2611[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2617 := z.EncBinary()
					_ = yym2617
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2611 || yy2arr2611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2611[2] {
					yy2619 := &x.ObjectMeta
					yy2619.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2611[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2620 := &x.ObjectMeta
					yy2620.CodecEncodeSelf(e)
				}
			}
			if yyr2611 || yy2arr2611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2622 := &x.Target
				yy2622.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("target"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2623 := &x.Target
				yy2623.CodecEncodeSelf(e)
			}
			if yyr2611 || yy2arr2611 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Binding) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2624 := z.DecBinary()
	_ = yym2624
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2625 := r.ContainerType()
		if yyct2625 == codecSelferValueTypeMap1234 {
			yyl2625 := r.ReadMapStart()
			if yyl2625 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2625, d)
			}
		} else if yyct2625 == codecSelferValueTypeArray1234 {
			yyl2625 := r.ReadArrayStart()
			if yyl2625 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2625, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Binding) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2626Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2626Slc
	var yyhl2626 bool = l >= 0
	for yyj2626 := 0; ; yyj2626++ {
		if yyhl2626 {
			if yyj2626 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2626Slc = r.DecodeBytes(yys2626Slc, true, true)
		yys2626 := string(yys2626Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2626 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2629 := &x.ObjectMeta
				yyv2629.CodecDecodeSelf(d)
			}
		case "target":
			if r.TryDecodeAsNil() {
				x.Target = ObjectReference{}
			} else {
				yyv2630 := &x.Target
				yyv2630.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2626)
		} // end switch yys2626
	} // end for yyj2626
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Binding) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2631 int
	var yyb2631 bool
	var yyhl2631 bool = l >= 0
	yyj2631++
	if yyhl2631 {
		yyb2631 = yyj2631 > l
	} else {
		yyb2631 = r.CheckBreak()
	}
	if yyb2631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2631++
	if yyhl2631 {
		yyb2631 = yyj2631 > l
	} else {
		yyb2631 = r.CheckBreak()
	}
	if yyb2631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2631++
	if yyhl2631 {
		yyb2631 = yyj2631 > l
	} else {
		yyb2631 = r.CheckBreak()
	}
	if yyb2631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2634 := &x.ObjectMeta
		yyv2634.CodecDecodeSelf(d)
	}
	yyj2631++
	if yyhl2631 {
		yyb2631 = yyj2631 > l
	} else {
		yyb2631 = r.CheckBreak()
	}
	if yyb2631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Target = ObjectReference{}
	} else {
		yyv2635 := &x.Target
		yyv2635.CodecDecodeSelf(d)
	}
	for {
		yyj2631++
		if yyhl2631 {
			yyb2631 = yyj2631 > l
		} else {
			yyb2631 = r.CheckBreak()
		}
		if yyb2631 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2631-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeleteOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2636 := z.EncBinary()
		_ = yym2636
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2637 := !z.EncBinary()
			yy2arr2637 := z.EncBasicHandle().StructToArray
			var yyq2637 [3]bool
			_, _, _ = yysep2637, yyq2637, yy2arr2637
			const yyr2637 bool = false
			yyq2637[0] = x.Kind != ""
			yyq2637[1] = x.APIVersion != ""
			var yynn2637 int
			if yyr2637 || yy2arr2637 {
				r.EncodeArrayStart(3)
			} else {
				yynn2637 = 1
				for _, b := range yyq2637 {
					if b {
						yynn2637++
					}
				}
				r.EncodeMapStart(yynn2637)
				yynn2637 = 0
			}
			if yyr2637 || yy2arr2637 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2637[0] {
					yym2639 := z.EncBinary()
					_ = yym2639
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2637[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2640 := z.EncBinary()
					_ = yym2640
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2637 || yy2arr2637 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2637[1] {
					yym2642 := z.EncBinary()
					_ = yym2642
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2637[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2643 := z.EncBinary()
					_ = yym2643
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2637 || yy2arr2637 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.GracePeriodSeconds == nil {
					r.EncodeNil()
				} else {
					yy2645 := *x.GracePeriodSeconds
					yym2646 := z.EncBinary()
					_ = yym2646
					if false {
					} else {
						r.EncodeInt(int64(yy2645))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("gracePeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.GracePeriodSeconds == nil {
					r.EncodeNil()
				} else {
					yy2647 := *x.GracePeriodSeconds
					yym2648 := z.EncBinary()
					_ = yym2648
					if false {
					} else {
						r.EncodeInt(int64(yy2647))
					}
				}
			}
			if yyr2637 || yy2arr2637 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeleteOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2649 := z.DecBinary()
	_ = yym2649
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2650 := r.ContainerType()
		if yyct2650 == codecSelferValueTypeMap1234 {
			yyl2650 := r.ReadMapStart()
			if yyl2650 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2650, d)
			}
		} else if yyct2650 == codecSelferValueTypeArray1234 {
			yyl2650 := r.ReadArrayStart()
			if yyl2650 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2650, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeleteOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2651Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2651Slc
	var yyhl2651 bool = l >= 0
	for yyj2651 := 0; ; yyj2651++ {
		if yyhl2651 {
			if yyj2651 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2651Slc = r.DecodeBytes(yys2651Slc, true, true)
		yys2651 := string(yys2651Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2651 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "gracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.GracePeriodSeconds != nil {
					x.GracePeriodSeconds = nil
				}
			} else {
				if x.GracePeriodSeconds == nil {
					x.GracePeriodSeconds = new(int64)
				}
				yym2655 := z.DecBinary()
				_ = yym2655
				if false {
				} else {
					*((*int64)(x.GracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2651)
		} // end switch yys2651
	} // end for yyj2651
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeleteOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2656 int
	var yyb2656 bool
	var yyhl2656 bool = l >= 0
	yyj2656++
	if yyhl2656 {
		yyb2656 = yyj2656 > l
	} else {
		yyb2656 = r.CheckBreak()
	}
	if yyb2656 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2656++
	if yyhl2656 {
		yyb2656 = yyj2656 > l
	} else {
		yyb2656 = r.CheckBreak()
	}
	if yyb2656 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2656++
	if yyhl2656 {
		yyb2656 = yyj2656 > l
	} else {
		yyb2656 = r.CheckBreak()
	}
	if yyb2656 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GracePeriodSeconds != nil {
			x.GracePeriodSeconds = nil
		}
	} else {
		if x.GracePeriodSeconds == nil {
			x.GracePeriodSeconds = new(int64)
		}
		yym2660 := z.DecBinary()
		_ = yym2660
		if false {
		} else {
			*((*int64)(x.GracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2656++
		if yyhl2656 {
			yyb2656 = yyj2656 > l
		} else {
			yyb2656 = r.CheckBreak()
		}
		if yyb2656 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2656-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExportOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2661 := z.EncBinary()
		_ = yym2661
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2662 := !z.EncBinary()
			yy2arr2662 := z.EncBasicHandle().StructToArray
			var yyq2662 [4]bool
			_, _, _ = yysep2662, yyq2662, yy2arr2662
			const yyr2662 bool = false
			yyq2662[0] = x.Kind != ""
			yyq2662[1] = x.APIVersion != ""
			var yynn2662 int
			if yyr2662 || yy2arr2662 {
				r.EncodeArrayStart(4)
			} else {
				yynn2662 = 2
				for _, b := range yyq2662 {
					if b {
						yynn2662++
					}
				}
				r.EncodeMapStart(yynn2662)
				yynn2662 = 0
			}
			if yyr2662 || yy2arr2662 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2662[0] {
					yym2664 := z.EncBinary()
					_ = yym2664
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2662[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2665 := z.EncBinary()
					_ = yym2665
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2662 || yy2arr2662 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2662[1] {
					yym2667 := z.EncBinary()
					_ = yym2667
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2662[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2668 := z.EncBinary()
					_ = yym2668
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2662 || yy2arr2662 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2670 := z.EncBinary()
				_ = yym2670
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("export"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2671 := z.EncBinary()
				_ = yym2671
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			}
			if yyr2662 || yy2arr2662 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2673 := z.EncBinary()
				_ = yym2673
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exact"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2674 := z.EncBinary()
				_ = yym2674
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			}
			if yyr2662 || yy2arr2662 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExportOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2675 := z.DecBinary()
	_ = yym2675
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2676 := r.ContainerType()
		if yyct2676 == codecSelferValueTypeMap1234 {
			yyl2676 := r.ReadMapStart()
			if yyl2676 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2676, d)
			}
		} else if yyct2676 == codecSelferValueTypeArray1234 {
			yyl2676 := r.ReadArrayStart()
			if yyl2676 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2676, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExportOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2677Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2677Slc
	var yyhl2677 bool = l >= 0
	for yyj2677 := 0; ; yyj2677++ {
		if yyhl2677 {
			if yyj2677 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2677Slc = r.DecodeBytes(yys2677Slc, true, true)
		yys2677 := string(yys2677Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2677 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "export":
			if r.TryDecodeAsNil() {
				x.Export = false
			} else {
				x.Export = bool(r.DecodeBool())
			}
		case "exact":
			if r.TryDecodeAsNil() {
				x.Exact = false
			} else {
				x.Exact = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2677)
		} // end switch yys2677
	} // end for yyj2677
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExportOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2682 int
	var yyb2682 bool
	var yyhl2682 bool = l >= 0
	yyj2682++
	if yyhl2682 {
		yyb2682 = yyj2682 > l
	} else {
		yyb2682 = r.CheckBreak()
	}
	if yyb2682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2682++
	if yyhl2682 {
		yyb2682 = yyj2682 > l
	} else {
		yyb2682 = r.CheckBreak()
	}
	if yyb2682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2682++
	if yyhl2682 {
		yyb2682 = yyj2682 > l
	} else {
		yyb2682 = r.CheckBreak()
	}
	if yyb2682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Export = false
	} else {
		x.Export = bool(r.DecodeBool())
	}
	yyj2682++
	if yyhl2682 {
		yyb2682 = yyj2682 > l
	} else {
		yyb2682 = r.CheckBreak()
	}
	if yyb2682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Exact = false
	} else {
		x.Exact = bool(r.DecodeBool())
	}
	for {
		yyj2682++
		if yyhl2682 {
			yyb2682 = yyj2682 > l
		} else {
			yyb2682 = r.CheckBreak()
		}
		if yyb2682 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2682-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ListOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2687 := z.EncBinary()
		_ = yym2687
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2688 := !z.EncBinary()
			yy2arr2688 := z.EncBasicHandle().StructToArray
			var yyq2688 [7]bool
			_, _, _ = yysep2688, yyq2688, yy2arr2688
			const yyr2688 bool = false
			yyq2688[0] = x.Kind != ""
			yyq2688[1] = x.APIVersion != ""
			var yynn2688 int
			if yyr2688 || yy2arr2688 {
				r.EncodeArrayStart(7)
			} else {
				yynn2688 = 5
				for _, b := range yyq2688 {
					if b {
						yynn2688++
					}
				}
				r.EncodeMapStart(yynn2688)
				yynn2688 = 0
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2688[0] {
					yym2690 := z.EncBinary()
					_ = yym2690
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2688[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2691 := z.EncBinary()
					_ = yym2691
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2688[1] {
					yym2693 := z.EncBinary()
					_ = yym2693
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2688[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2694 := z.EncBinary()
					_ = yym2694
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.LabelSelector == nil {
					r.EncodeNil()
				} else {
					yym2696 := z.EncBinary()
					_ = yym2696
					if false {
					} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
					} else {
						z.EncFallback(x.LabelSelector)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("LabelSelector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.LabelSelector == nil {
					r.EncodeNil()
				} else {
					yym2697 := z.EncBinary()
					_ = yym2697
					if false {
					} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
					} else {
						z.EncFallback(x.LabelSelector)
					}
				}
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.FieldSelector == nil {
					r.EncodeNil()
				} else {
					yym2699 := z.EncBinary()
					_ = yym2699
					if false {
					} else if z.HasExtensions() && z.EncExt(x.FieldSelector) {
					} else {
						z.EncFallback(x.FieldSelector)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("FieldSelector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.FieldSelector == nil {
					r.EncodeNil()
				} else {
					yym2700 := z.EncBinary()
					_ = yym2700
					if false {
					} else if z.HasExtensions() && z.EncExt(x.FieldSelector) {
					} else {
						z.EncFallback(x.FieldSelector)
					}
				}
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2702 := z.EncBinary()
				_ = yym2702
				if false {
				} else {
					r.EncodeBool(bool(x.Watch))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Watch"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2703 := z.EncBinary()
				_ = yym2703
				if false {
				} else {
					r.EncodeBool(bool(x.Watch))
				}
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2705 := z.EncBinary()
				_ = yym2705
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ResourceVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2706 := z.EncBinary()
				_ = yym2706
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
				}
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TimeoutSeconds == nil {
					r.EncodeNil()
				} else {
					yy2708 := *x.TimeoutSeconds
					yym2709 := z.EncBinary()
					_ = yym2709
					if false {
					} else {
						r.EncodeInt(int64(yy2708))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("TimeoutSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TimeoutSeconds == nil {
					r.EncodeNil()
				} else {
					yy2710 := *x.TimeoutSeconds
					yym2711 := z.EncBinary()
					_ = yym2711
					if false {
					} else {
						r.EncodeInt(int64(yy2710))
					}
				}
			}
			if yyr2688 || yy2arr2688 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ListOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2712 := z.DecBinary()
	_ = yym2712
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2713 := r.ContainerType()
		if yyct2713 == codecSelferValueTypeMap1234 {
			yyl2713 := r.ReadMapStart()
			if yyl2713 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2713, d)
			}
		} else if yyct2713 == codecSelferValueTypeArray1234 {
			yyl2713 := r.ReadArrayStart()
			if yyl2713 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2713, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ListOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2714Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2714Slc
	var yyhl2714 bool = l >= 0
	for yyj2714 := 0; ; yyj2714++ {
		if yyhl2714 {
			if yyj2714 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2714Slc = r.DecodeBytes(yys2714Slc, true, true)
		yys2714 := string(yys2714Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2714 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "LabelSelector":
			if r.TryDecodeAsNil() {
				x.LabelSelector = nil
			} else {
				yyv2717 := &x.LabelSelector
				yym2718 := z.DecBinary()
				_ = yym2718
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2717) {
				} else {
					z.DecFallback(yyv2717, true)
				}
			}
		case "FieldSelector":
			if r.TryDecodeAsNil() {
				x.FieldSelector = nil
			} else {
				yyv2719 := &x.FieldSelector
				yym2720 := z.DecBinary()
				_ = yym2720
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2719) {
				} else {
					z.DecFallback(yyv2719, true)
				}
			}
		case "Watch":
			if r.TryDecodeAsNil() {
				x.Watch = false
			} else {
				x.Watch = bool(r.DecodeBool())
			}
		case "ResourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "TimeoutSeconds":
			if r.TryDecodeAsNil() {
				if x.TimeoutSeconds != nil {
					x.TimeoutSeconds = nil
				}
			} else {
				if x.TimeoutSeconds == nil {
					x.TimeoutSeconds = new(int64)
				}
				yym2724 := z.DecBinary()
				_ = yym2724
				if false {
				} else {
					*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2714)
		} // end switch yys2714
	} // end for yyj2714
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ListOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2725 int
	var yyb2725 bool
	var yyhl2725 bool = l >= 0
	yyj2725++
	if yyhl2725 {
		yyb2725 = yyj2725 > l
	} else {
		yyb2725 = r.CheckBreak()
	}
	if yyb2725 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2725++
	if yyhl2725 {
		yyb2725 = yyj2725 > l
	} else {
		yyb2725 = r.CheckBreak()
	}
	if yyb2725 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2725++
	if yyhl2725 {
		yyb2725 = yyj2725 > l
	} else {
		yyb2725 = r.CheckBreak()
	}
	if yyb2725 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LabelSelector = nil
	} else {
		yyv2728 := &x.LabelSelector
		yym2729 := z.DecBinary()
		_ = yym2729
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2728) {
		} else {
			z.DecFallback(yyv2728, true)
		}
	}
	yyj2725++
	if yyhl2725 {
		yyb2725 = yyj2725 > l
	} else {
		yyb2725 = r.CheckBreak()
	}
	if yyb2725 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldSelector = nil
	} else {
		yyv2730 := &x.FieldSelector
		yym2731 := z.DecBinary()
		_ = yym2731
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2730) {
		} else {
			z.DecFallback(yyv2730, true)
		}
	}
	yyj2725++
	if yyhl2725 {
		yyb2725 = yyj2725 > l
	} else {
		yyb2725 = r.CheckBreak()
	}
	if yyb2725 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Watch = false
	} else {
		x.Watch = bool(r.DecodeBool())
	}
	yyj2725++
	if yyhl2725 {
		yyb2725 = yyj2725 > l
	} else {
		yyb2725 = r.CheckBreak()
	}
	if yyb2725 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj2725++
	if yyhl2725 {
		yyb2725 = yyj2725 > l
	} else {
		yyb2725 = r.CheckBreak()
	}
	if yyb2725 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TimeoutSeconds != nil {
			x.TimeoutSeconds = nil
		}
	} else {
		if x.TimeoutSeconds == nil {
			x.TimeoutSeconds = new(int64)
		}
		yym2735 := z.DecBinary()
		_ = yym2735
		if false {
		} else {
			*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2725++
		if yyhl2725 {
			yyb2725 = yyj2725 > l
		} else {
			yyb2725 = r.CheckBreak()
		}
		if yyb2725 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2725-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodLogOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2736 := z.EncBinary()
		_ = yym2736
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2737 := !z.EncBinary()
			yy2arr2737 := z.EncBasicHandle().StructToArray
			var yyq2737 [10]bool
			_, _, _ = yysep2737, yyq2737, yy2arr2737
			const yyr2737 bool = false
			yyq2737[0] = x.Kind != ""
			yyq2737[1] = x.APIVersion != ""
			var yynn2737 int
			if yyr2737 || yy2arr2737 {
				r.EncodeArrayStart(10)
			} else {
				yynn2737 = 8
				for _, b := range yyq2737 {
					if b {
						yynn2737++
					}
				}
				r.EncodeMapStart(yynn2737)
				yynn2737 = 0
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2737[0] {
					yym2739 := z.EncBinary()
					_ = yym2739
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2737[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2740 := z.EncBinary()
					_ = yym2740
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2737[1] {
					yym2742 := z.EncBinary()
					_ = yym2742
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2737[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2743 := z.EncBinary()
					_ = yym2743
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2745 := z.EncBinary()
				_ = yym2745
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Container))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Container"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2746 := z.EncBinary()
				_ = yym2746
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Container))
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2748 := z.EncBinary()
				_ = yym2748
				if false {
				} else {
					r.EncodeBool(bool(x.Follow))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Follow"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2749 := z.EncBinary()
				_ = yym2749
				if false {
				} else {
					r.EncodeBool(bool(x.Follow))
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2751 := z.EncBinary()
				_ = yym2751
				if false {
				} else {
					r.EncodeBool(bool(x.Previous))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Previous"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2752 := z.EncBinary()
				_ = yym2752
				if false {
				} else {
					r.EncodeBool(bool(x.Previous))
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SinceSeconds == nil {
					r.EncodeNil()
				} else {
					yy2754 := *x.SinceSeconds
					yym2755 := z.EncBinary()
					_ = yym2755
					if false {
					} else {
						r.EncodeInt(int64(yy2754))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("SinceSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SinceSeconds == nil {
					r.EncodeNil()
				} else {
					yy2756 := *x.SinceSeconds
					yym2757 := z.EncBinary()
					_ = yym2757
					if false {
					} else {
						r.EncodeInt(int64(yy2756))
					}
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SinceTime == nil {
					r.EncodeNil()
				} else {
					yym2759 := z.EncBinary()
					_ = yym2759
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SinceTime) {
					} else if yym2759 {
						z.EncBinaryMarshal(x.SinceTime)
					} else if !yym2759 && z.IsJSONHandle() {
						z.EncJSONMarshal(x.SinceTime)
					} else {
						z.EncFallback(x.SinceTime)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("SinceTime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SinceTime == nil {
					r.EncodeNil()
				} else {
					yym2760 := z.EncBinary()
					_ = yym2760
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SinceTime) {
					} else if yym2760 {
						z.EncBinaryMarshal(x.SinceTime)
					} else if !yym2760 && z.IsJSONHandle() {
						z.EncJSONMarshal(x.SinceTime)
					} else {
						z.EncFallback(x.SinceTime)
					}
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2762 := z.EncBinary()
				_ = yym2762
				if false {
				} else {
					r.EncodeBool(bool(x.Timestamps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Timestamps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2763 := z.EncBinary()
				_ = yym2763
				if false {
				} else {
					r.EncodeBool(bool(x.Timestamps))
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TailLines == nil {
					r.EncodeNil()
				} else {
					yy2765 := *x.TailLines
					yym2766 := z.EncBinary()
					_ = yym2766
					if false {
					} else {
						r.EncodeInt(int64(yy2765))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("TailLines"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TailLines == nil {
					r.EncodeNil()
				} else {
					yy2767 := *x.TailLines
					yym2768 := z.EncBinary()
					_ = yym2768
					if false {
					} else {
						r.EncodeInt(int64(yy2767))
					}
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.LimitBytes == nil {
					r.EncodeNil()
				} else {
					yy2770 := *x.LimitBytes
					yym2771 := z.EncBinary()
					_ = yym2771
					if false {
					} else {
						r.EncodeInt(int64(yy2770))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("LimitBytes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.LimitBytes == nil {
					r.EncodeNil()
				} else {
					yy2772 := *x.LimitBytes
					yym2773 := z.EncBinary()
					_ = yym2773
					if false {
					} else {
						r.EncodeInt(int64(yy2772))
					}
				}
			}
			if yyr2737 || yy2arr2737 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodLogOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2774 := z.DecBinary()
	_ = yym2774
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2775 := r.ContainerType()
		if yyct2775 == codecSelferValueTypeMap1234 {
			yyl2775 := r.ReadMapStart()
			if yyl2775 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2775, d)
			}
		} else if yyct2775 == codecSelferValueTypeArray1234 {
			yyl2775 := r.ReadArrayStart()
			if yyl2775 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2775, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodLogOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2776Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2776Slc
	var yyhl2776 bool = l >= 0
	for yyj2776 := 0; ; yyj2776++ {
		if yyhl2776 {
			if yyj2776 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2776Slc = r.DecodeBytes(yys2776Slc, true, true)
		yys2776 := string(yys2776Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2776 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "Container":
			if r.TryDecodeAsNil() {
				x.Container = ""
			} else {
				x.Container = string(r.DecodeString())
			}
		case "Follow":
			if r.TryDecodeAsNil() {
				x.Follow = false
			} else {
				x.Follow = bool(r.DecodeBool())
			}
		case "Previous":
			if r.TryDecodeAsNil() {
				x.Previous = false
			} else {
				x.Previous = bool(r.DecodeBool())
			}
		case "SinceSeconds":
			if r.TryDecodeAsNil() {
				if x.SinceSeconds != nil {
					x.SinceSeconds = nil
				}
			} else {
				if x.SinceSeconds == nil {
					x.SinceSeconds = new(int64)
				}
				yym2783 := z.DecBinary()
				_ = yym2783
				if false {
				} else {
					*((*int64)(x.SinceSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "SinceTime":
			if r.TryDecodeAsNil() {
				if x.SinceTime != nil {
					x.SinceTime = nil
				}
			} else {
				if x.SinceTime == nil {
					x.SinceTime = new(pkg2_unversioned.Time)
				}
				yym2785 := z.DecBinary()
				_ = yym2785
				if false {
				} else if z.HasExtensions() && z.DecExt(x.SinceTime) {
				} else if yym2785 {
					z.DecBinaryUnmarshal(x.SinceTime)
				} else if !yym2785 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.SinceTime)
				} else {
					z.DecFallback(x.SinceTime, false)
				}
			}
		case "Timestamps":
			if r.TryDecodeAsNil() {
				x.Timestamps = false
			} else {
				x.Timestamps = bool(r.DecodeBool())
			}
		case "TailLines":
			if r.TryDecodeAsNil() {
				if x.TailLines != nil {
					x.TailLines = nil
				}
			} else {
				if x.TailLines == nil {
					x.TailLines = new(int64)
				}
				yym2788 := z.DecBinary()
				_ = yym2788
				if false {
				} else {
					*((*int64)(x.TailLines)) = int64(r.DecodeInt(64))
				}
			}
		case "LimitBytes":
			if r.TryDecodeAsNil() {
				if x.LimitBytes != nil {
					x.LimitBytes = nil
				}
			} else {
				if x.LimitBytes == nil {
					x.LimitBytes = new(int64)
				}
				yym2790 := z.DecBinary()
				_ = yym2790
				if false {
				} else {
					*((*int64)(x.LimitBytes)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2776)
		} // end switch yys2776
	} // end for yyj2776
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodLogOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2791 int
	var yyb2791 bool
	var yyhl2791 bool = l >= 0
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Container = ""
	} else {
		x.Container = string(r.DecodeString())
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Follow = false
	} else {
		x.Follow = bool(r.DecodeBool())
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Previous = false
	} else {
		x.Previous = bool(r.DecodeBool())
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SinceSeconds != nil {
			x.SinceSeconds = nil
		}
	} else {
		if x.SinceSeconds == nil {
			x.SinceSeconds = new(int64)
		}
		yym2798 := z.DecBinary()
		_ = yym2798
		if false {
		} else {
			*((*int64)(x.SinceSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SinceTime != nil {
			x.SinceTime = nil
		}
	} else {
		if x.SinceTime == nil {
			x.SinceTime = new(pkg2_unversioned.Time)
		}
		yym2800 := z.DecBinary()
		_ = yym2800
		if false {
		} else if z.HasExtensions() && z.DecExt(x.SinceTime) {
		} else if yym2800 {
			z.DecBinaryUnmarshal(x.SinceTime)
		} else if !yym2800 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.SinceTime)
		} else {
			z.DecFallback(x.SinceTime, false)
		}
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Timestamps = false
	} else {
		x.Timestamps = bool(r.DecodeBool())
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TailLines != nil {
			x.TailLines = nil
		}
	} else {
		if x.TailLines == nil {
			x.TailLines = new(int64)
		}
		yym2803 := z.DecBinary()
		_ = yym2803
		if false {
		} else {
			*((*int64)(x.TailLines)) = int64(r.DecodeInt(64))
		}
	}
	yyj2791++
	if yyhl2791 {
		yyb2791 = yyj2791 > l
	} else {
		yyb2791 = r.CheckBreak()
	}
	if yyb2791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LimitBytes != nil {
			x.LimitBytes = nil
		}
	} else {
		if x.LimitBytes == nil {
			x.LimitBytes = new(int64)
		}
		yym2805 := z.DecBinary()
		_ = yym2805
		if false {
		} else {
			*((*int64)(x.LimitBytes)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2791++
		if yyhl2791 {
			yyb2791 = yyj2791 > l
		} else {
			yyb2791 = r.CheckBreak()
		}
		if yyb2791 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2791-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAttachOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2806 := z.EncBinary()
		_ = yym2806
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2807 := !z.EncBinary()
			yy2arr2807 := z.EncBasicHandle().StructToArray
			var yyq2807 [7]bool
			_, _, _ = yysep2807, yyq2807, yy2arr2807
			const yyr2807 bool = false
			yyq2807[0] = x.Kind != ""
			yyq2807[1] = x.APIVersion != ""
			yyq2807[2] = x.Stdin != false
			yyq2807[3] = x.Stdout != false
			yyq2807[4] = x.Stderr != false
			yyq2807[5] = x.TTY != false
			yyq2807[6] = x.Container != ""
			var yynn2807 int
			if yyr2807 || yy2arr2807 {
				r.EncodeArrayStart(7)
			} else {
				yynn2807 = 0
				for _, b := range yyq2807 {
					if b {
						yynn2807++
					}
				}
				r.EncodeMapStart(yynn2807)
				yynn2807 = 0
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2807[0] {
					yym2809 := z.EncBinary()
					_ = yym2809
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2807[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2810 := z.EncBinary()
					_ = yym2810
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2807[1] {
					yym2812 := z.EncBinary()
					_ = yym2812
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2807[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2813 := z.EncBinary()
					_ = yym2813
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2807[2] {
					yym2815 := z.EncBinary()
					_ = yym2815
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2807[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2816 := z.EncBinary()
					_ = yym2816
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2807[3] {
					yym2818 := z.EncBinary()
					_ = yym2818
					if false {
					} else {
						r.EncodeBool(bool(x.Stdout))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2807[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2819 := z.EncBinary()
					_ = yym2819
					if false {
					} else {
						r.EncodeBool(bool(x.Stdout))
					}
				}
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2807[4] {
					yym2821 := z.EncBinary()
					_ = yym2821
					if false {
					} else {
						r.EncodeBool(bool(x.Stderr))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2807[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stderr"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2822 := z.EncBinary()
					_ = yym2822
					if false {
					} else {
						r.EncodeBool(bool(x.Stderr))
					}
				}
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2807[5] {
					yym2824 := z.EncBinary()
					_ = yym2824
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2807[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2825 := z.EncBinary()
					_ = yym2825
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2807[6] {
					yym2827 := z.EncBinary()
					_ = yym2827
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2807[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("container"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2828 := z.EncBinary()
					_ = yym2828
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				}
			}
			if yyr2807 || yy2arr2807 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAttachOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2829 := z.DecBinary()
	_ = yym2829
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2830 := r.ContainerType()
		if yyct2830 == codecSelferValueTypeMap1234 {
			yyl2830 := r.ReadMapStart()
			if yyl2830 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2830, d)
			}
		} else if yyct2830 == codecSelferValueTypeArray1234 {
			yyl2830 := r.ReadArrayStart()
			if yyl2830 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2830, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAttachOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2831Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2831Slc
	var yyhl2831 bool = l >= 0
	for yyj2831 := 0; ; yyj2831++ {
		if yyhl2831 {
			if yyj2831 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2831Slc = r.DecodeBytes(yys2831Slc, true, true)
		yys2831 := string(yys2831Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2831 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdout":
			if r.TryDecodeAsNil() {
				x.Stdout = false
			} else {
				x.Stdout = bool(r.DecodeBool())
			}
		case "stderr":
			if r.TryDecodeAsNil() {
				x.Stderr = false
			} else {
				x.Stderr = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		case "container":
			if r.TryDecodeAsNil() {
				x.Container = ""
			} else {
				x.Container = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2831)
		} // end switch yys2831
	} // end for yyj2831
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAttachOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2839 int
	var yyb2839 bool
	var yyhl2839 bool = l >= 0
	yyj2839++
	if yyhl2839 {
		yyb2839 = yyj2839 > l
	} else {
		yyb2839 = r.CheckBreak()
	}
	if yyb2839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2839++
	if yyhl2839 {
		yyb2839 = yyj2839 > l
	} else {
		yyb2839 = r.CheckBreak()
	}
	if yyb2839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2839++
	if yyhl2839 {
		yyb2839 = yyj2839 > l
	} else {
		yyb2839 = r.CheckBreak()
	}
	if yyb2839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj2839++
	if yyhl2839 {
		yyb2839 = yyj2839 > l
	} else {
		yyb2839 = r.CheckBreak()
	}
	if yyb2839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdout = false
	} else {
		x.Stdout = bool(r.DecodeBool())
	}
	yyj2839++
	if yyhl2839 {
		yyb2839 = yyj2839 > l
	} else {
		yyb2839 = r.CheckBreak()
	}
	if yyb2839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stderr = false
	} else {
		x.Stderr = bool(r.DecodeBool())
	}
	yyj2839++
	if yyhl2839 {
		yyb2839 = yyj2839 > l
	} else {
		yyb2839 = r.CheckBreak()
	}
	if yyb2839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	yyj2839++
	if yyhl2839 {
		yyb2839 = yyj2839 > l
	} else {
		yyb2839 = r.CheckBreak()
	}
	if yyb2839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Container = ""
	} else {
		x.Container = string(r.DecodeString())
	}
	for {
		yyj2839++
		if yyhl2839 {
			yyb2839 = yyj2839 > l
		} else {
			yyb2839 = r.CheckBreak()
		}
		if yyb2839 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2839-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodExecOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2847 := z.EncBinary()
		_ = yym2847
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2848 := !z.EncBinary()
			yy2arr2848 := z.EncBasicHandle().StructToArray
			var yyq2848 [8]bool
			_, _, _ = yysep2848, yyq2848, yy2arr2848
			const yyr2848 bool = false
			yyq2848[0] = x.Kind != ""
			yyq2848[1] = x.APIVersion != ""
			var yynn2848 int
			if yyr2848 || yy2arr2848 {
				r.EncodeArrayStart(8)
			} else {
				yynn2848 = 6
				for _, b := range yyq2848 {
					if b {
						yynn2848++
					}
				}
				r.EncodeMapStart(yynn2848)
				yynn2848 = 0
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2848[0] {
					yym2850 := z.EncBinary()
					_ = yym2850
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2848[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2851 := z.EncBinary()
					_ = yym2851
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2848[1] {
					yym2853 := z.EncBinary()
					_ = yym2853
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2848[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2854 := z.EncBinary()
					_ = yym2854
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2856 := z.EncBinary()
				_ = yym2856
				if false {
				} else {
					r.EncodeBool(bool(x.Stdin))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Stdin"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2857 := z.EncBinary()
				_ = yym2857
				if false {
				} else {
					r.EncodeBool(bool(x.Stdin))
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2859 := z.EncBinary()
				_ = yym2859
				if false {
				} else {
					r.EncodeBool(bool(x.Stdout))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Stdout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2860 := z.EncBinary()
				_ = yym2860
				if false {
				} else {
					r.EncodeBool(bool(x.Stdout))
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2862 := z.EncBinary()
				_ = yym2862
				if false {
				} else {
					r.EncodeBool(bool(x.Stderr))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Stderr"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2863 := z.EncBinary()
				_ = yym2863
				if false {
				} else {
					r.EncodeBool(bool(x.Stderr))
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2865 := z.EncBinary()
				_ = yym2865
				if false {
				} else {
					r.EncodeBool(bool(x.TTY))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("TTY"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2866 := z.EncBinary()
				_ = yym2866
				if false {
				} else {
					r.EncodeBool(bool(x.TTY))
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2868 := z.EncBinary()
				_ = yym2868
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Container))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Container"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2869 := z.EncBinary()
				_ = yym2869
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Container))
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Command == nil {
					r.EncodeNil()
				} else {
					yym2871 := z.EncBinary()
					_ = yym2871
					if false {
					} else {
						z.F.EncSliceStringV(x.Command, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Command"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Command == nil {
					r.EncodeNil()
				} else {
					yym2872 := z.EncBinary()
					_ = yym2872
					if false {
					} else {
						z.F.EncSliceStringV(x.Command, false, e)
					}
				}
			}
			if yyr2848 || yy2arr2848 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodExecOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2873 := z.DecBinary()
	_ = yym2873
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2874 := r.ContainerType()
		if yyct2874 == codecSelferValueTypeMap1234 {
			yyl2874 := r.ReadMapStart()
			if yyl2874 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2874, d)
			}
		} else if yyct2874 == codecSelferValueTypeArray1234 {
			yyl2874 := r.ReadArrayStart()
			if yyl2874 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2874, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodExecOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2875Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2875Slc
	var yyhl2875 bool = l >= 0
	for yyj2875 := 0; ; yyj2875++ {
		if yyhl2875 {
			if yyj2875 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2875Slc = r.DecodeBytes(yys2875Slc, true, true)
		yys2875 := string(yys2875Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2875 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "Stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "Stdout":
			if r.TryDecodeAsNil() {
				x.Stdout = false
			} else {
				x.Stdout = bool(r.DecodeBool())
			}
		case "Stderr":
			if r.TryDecodeAsNil() {
				x.Stderr = false
			} else {
				x.Stderr = bool(r.DecodeBool())
			}
		case "TTY":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		case "Container":
			if r.TryDecodeAsNil() {
				x.Container = ""
			} else {
				x.Container = string(r.DecodeString())
			}
		case "Command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv2883 := &x.Command
				yym2884 := z.DecBinary()
				_ = yym2884
				if false {
				} else {
					z.F.DecSliceStringX(yyv2883, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2875)
		} // end switch yys2875
	} // end for yyj2875
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodExecOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2885 int
	var yyb2885 bool
	var yyhl2885 bool = l >= 0
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdout = false
	} else {
		x.Stdout = bool(r.DecodeBool())
	}
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stderr = false
	} else {
		x.Stderr = bool(r.DecodeBool())
	}
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Container = ""
	} else {
		x.Container = string(r.DecodeString())
	}
	yyj2885++
	if yyhl2885 {
		yyb2885 = yyj2885 > l
	} else {
		yyb2885 = r.CheckBreak()
	}
	if yyb2885 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv2893 := &x.Command
		yym2894 := z.DecBinary()
		_ = yym2894
		if false {
		} else {
			z.F.DecSliceStringX(yyv2893, false, d)
		}
	}
	for {
		yyj2885++
		if yyhl2885 {
			yyb2885 = yyj2885 > l
		} else {
			yyb2885 = r.CheckBreak()
		}
		if yyb2885 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2885-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodProxyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2895 := z.EncBinary()
		_ = yym2895
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2896 := !z.EncBinary()
			yy2arr2896 := z.EncBasicHandle().StructToArray
			var yyq2896 [3]bool
			_, _, _ = yysep2896, yyq2896, yy2arr2896
			const yyr2896 bool = false
			yyq2896[0] = x.Kind != ""
			yyq2896[1] = x.APIVersion != ""
			var yynn2896 int
			if yyr2896 || yy2arr2896 {
				r.EncodeArrayStart(3)
			} else {
				yynn2896 = 1
				for _, b := range yyq2896 {
					if b {
						yynn2896++
					}
				}
				r.EncodeMapStart(yynn2896)
				yynn2896 = 0
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2896[0] {
					yym2898 := z.EncBinary()
					_ = yym2898
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2896[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2899 := z.EncBinary()
					_ = yym2899
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2896[1] {
					yym2901 := z.EncBinary()
					_ = yym2901
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2896[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2902 := z.EncBinary()
					_ = yym2902
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2904 := z.EncBinary()
				_ = yym2904
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2905 := z.EncBinary()
				_ = yym2905
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodProxyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2906 := z.DecBinary()
	_ = yym2906
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2907 := r.ContainerType()
		if yyct2907 == codecSelferValueTypeMap1234 {
			yyl2907 := r.ReadMapStart()
			if yyl2907 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2907, d)
			}
		} else if yyct2907 == codecSelferValueTypeArray1234 {
			yyl2907 := r.ReadArrayStart()
			if yyl2907 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2907, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodProxyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2908Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2908Slc
	var yyhl2908 bool = l >= 0
	for yyj2908 := 0; ; yyj2908++ {
		if yyhl2908 {
			if yyj2908 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2908Slc = r.DecodeBytes(yys2908Slc, true, true)
		yys2908 := string(yys2908Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2908 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "Path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2908)
		} // end switch yys2908
	} // end for yyj2908
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodProxyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2912 int
	var yyb2912 bool
	var yyhl2912 bool = l >= 0
	yyj2912++
	if yyhl2912 {
		yyb2912 = yyj2912 > l
	} else {
		yyb2912 = r.CheckBreak()
	}
	if yyb2912 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2912++
	if yyhl2912 {
		yyb2912 = yyj2912 > l
	} else {
		yyb2912 = r.CheckBreak()
	}
	if yyb2912 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2912++
	if yyhl2912 {
		yyb2912 = yyj2912 > l
	} else {
		yyb2912 = r.CheckBreak()
	}
	if yyb2912 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj2912++
		if yyhl2912 {
			yyb2912 = yyj2912 > l
		} else {
			yyb2912 = r.CheckBreak()
		}
		if yyb2912 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2912-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2916 := z.EncBinary()
		_ = yym2916
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2917 := !z.EncBinary()
			yy2arr2917 := z.EncBasicHandle().StructToArray
			var yyq2917 [7]bool
			_, _, _ = yysep2917, yyq2917, yy2arr2917
			const yyr2917 bool = false
			yyq2917[0] = x.Kind != ""
			yyq2917[1] = x.Namespace != ""
			yyq2917[2] = x.Name != ""
			yyq2917[3] = x.UID != ""
			yyq2917[4] = x.APIVersion != ""
			yyq2917[5] = x.ResourceVersion != ""
			yyq2917[6] = x.FieldPath != ""
			var yynn2917 int
			if yyr2917 || yy2arr2917 {
				r.EncodeArrayStart(7)
			} else {
				yynn2917 = 0
				for _, b := range yyq2917 {
					if b {
						yynn2917++
					}
				}
				r.EncodeMapStart(yynn2917)
				yynn2917 = 0
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2917[0] {
					yym2919 := z.EncBinary()
					_ = yym2919
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2917[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2920 := z.EncBinary()
					_ = yym2920
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2917[1] {
					yym2922 := z.EncBinary()
					_ = yym2922
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2917[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2923 := z.EncBinary()
					_ = yym2923
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2917[2] {
					yym2925 := z.EncBinary()
					_ = yym2925
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2917[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2926 := z.EncBinary()
					_ = yym2926
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2917[3] {
					yym2928 := z.EncBinary()
					_ = yym2928
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2917[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2929 := z.EncBinary()
					_ = yym2929
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2917[4] {
					yym2931 := z.EncBinary()
					_ = yym2931
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2917[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2932 := z.EncBinary()
					_ = yym2932
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2917[5] {
					yym2934 := z.EncBinary()
					_ = yym2934
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2917[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2935 := z.EncBinary()
					_ = yym2935
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2917[6] {
					yym2937 := z.EncBinary()
					_ = yym2937
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2917[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2938 := z.EncBinary()
					_ = yym2938
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
					}
				}
			}
			if yyr2917 || yy2arr2917 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2939 := z.DecBinary()
	_ = yym2939
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2940 := r.ContainerType()
		if yyct2940 == codecSelferValueTypeMap1234 {
			yyl2940 := r.ReadMapStart()
			if yyl2940 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2940, d)
			}
		} else if yyct2940 == codecSelferValueTypeArray1234 {
			yyl2940 := r.ReadArrayStart()
			if yyl2940 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2940, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2941Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2941Slc
	var yyhl2941 bool = l >= 0
	for yyj2941 := 0; ; yyj2941++ {
		if yyhl2941 {
			if yyj2941 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2941Slc = r.DecodeBytes(yys2941Slc, true, true)
		yys2941 := string(yys2941Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2941 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2941)
		} // end switch yys2941
	} // end for yyj2941
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2949 int
	var yyb2949 bool
	var yyhl2949 bool = l >= 0
	yyj2949++
	if yyhl2949 {
		yyb2949 = yyj2949 > l
	} else {
		yyb2949 = r.CheckBreak()
	}
	if yyb2949 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2949++
	if yyhl2949 {
		yyb2949 = yyj2949 > l
	} else {
		yyb2949 = r.CheckBreak()
	}
	if yyb2949 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj2949++
	if yyhl2949 {
		yyb2949 = yyj2949 > l
	} else {
		yyb2949 = r.CheckBreak()
	}
	if yyb2949 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2949++
	if yyhl2949 {
		yyb2949 = yyj2949 > l
	} else {
		yyb2949 = r.CheckBreak()
	}
	if yyb2949 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj2949++
	if yyhl2949 {
		yyb2949 = yyj2949 > l
	} else {
		yyb2949 = r.CheckBreak()
	}
	if yyb2949 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2949++
	if yyhl2949 {
		yyb2949 = yyj2949 > l
	} else {
		yyb2949 = r.CheckBreak()
	}
	if yyb2949 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj2949++
	if yyhl2949 {
		yyb2949 = yyj2949 > l
	} else {
		yyb2949 = r.CheckBreak()
	}
	if yyb2949 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj2949++
		if yyhl2949 {
			yyb2949 = yyj2949 > l
		} else {
			yyb2949 = r.CheckBreak()
		}
		if yyb2949 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2949-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LocalObjectReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2957 := z.EncBinary()
		_ = yym2957
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2958 := !z.EncBinary()
			yy2arr2958 := z.EncBasicHandle().StructToArray
			var yyq2958 [1]bool
			_, _, _ = yysep2958, yyq2958, yy2arr2958
			const yyr2958 bool = false
			var yynn2958 int
			if yyr2958 || yy2arr2958 {
				r.EncodeArrayStart(1)
			} else {
				yynn2958 = 1
				for _, b := range yyq2958 {
					if b {
						yynn2958++
					}
				}
				r.EncodeMapStart(yynn2958)
				yynn2958 = 0
			}
			if yyr2958 || yy2arr2958 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2960 := z.EncBinary()
				_ = yym2960
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2961 := z.EncBinary()
				_ = yym2961
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2958 || yy2arr2958 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LocalObjectReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2962 := z.DecBinary()
	_ = yym2962
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2963 := r.ContainerType()
		if yyct2963 == codecSelferValueTypeMap1234 {
			yyl2963 := r.ReadMapStart()
			if yyl2963 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2963, d)
			}
		} else if yyct2963 == codecSelferValueTypeArray1234 {
			yyl2963 := r.ReadArrayStart()
			if yyl2963 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2963, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LocalObjectReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2964Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2964Slc
	var yyhl2964 bool = l >= 0
	for yyj2964 := 0; ; yyj2964++ {
		if yyhl2964 {
			if yyj2964 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2964Slc = r.DecodeBytes(yys2964Slc, true, true)
		yys2964 := string(yys2964Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2964 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2964)
		} // end switch yys2964
	} // end for yyj2964
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LocalObjectReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2966 int
	var yyb2966 bool
	var yyhl2966 bool = l >= 0
	yyj2966++
	if yyhl2966 {
		yyb2966 = yyj2966 > l
	} else {
		yyb2966 = r.CheckBreak()
	}
	if yyb2966 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj2966++
		if yyhl2966 {
			yyb2966 = yyj2966 > l
		} else {
			yyb2966 = r.CheckBreak()
		}
		if yyb2966 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2966-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SerializedReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2968 := z.EncBinary()
		_ = yym2968
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2969 := !z.EncBinary()
			yy2arr2969 := z.EncBasicHandle().StructToArray
			var yyq2969 [3]bool
			_, _, _ = yysep2969, yyq2969, yy2arr2969
			const yyr2969 bool = false
			yyq2969[0] = x.Kind != ""
			yyq2969[1] = x.APIVersion != ""
			yyq2969[2] = true
			var yynn2969 int
			if yyr2969 || yy2arr2969 {
				r.EncodeArrayStart(3)
			} else {
				yynn2969 = 0
				for _, b := range yyq2969 {
					if b {
						yynn2969++
					}
				}
				r.EncodeMapStart(yynn2969)
				yynn2969 = 0
			}
			if yyr2969 || yy2arr2969 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2969[0] {
					yym2971 := z.EncBinary()
					_ = yym2971
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2969[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2972 := z.EncBinary()
					_ = yym2972
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2969 || yy2arr2969 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2969[1] {
					yym2974 := z.EncBinary()
					_ = yym2974
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2969[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2975 := z.EncBinary()
					_ = yym2975
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2969 || yy2arr2969 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2969[2] {
					yy2977 := &x.Reference
					yy2977.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2969[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reference"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2978 := &x.Reference
					yy2978.CodecEncodeSelf(e)
				}
			}
			if yyr2969 || yy2arr2969 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SerializedReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2979 := z.DecBinary()
	_ = yym2979
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2980 := r.ContainerType()
		if yyct2980 == codecSelferValueTypeMap1234 {
			yyl2980 := r.ReadMapStart()
			if yyl2980 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2980, d)
			}
		} else if yyct2980 == codecSelferValueTypeArray1234 {
			yyl2980 := r.ReadArrayStart()
			if yyl2980 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2980, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SerializedReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2981Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2981Slc
	var yyhl2981 bool = l >= 0
	for yyj2981 := 0; ; yyj2981++ {
		if yyhl2981 {
			if yyj2981 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2981Slc = r.DecodeBytes(yys2981Slc, true, true)
		yys2981 := string(yys2981Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2981 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "reference":
			if r.TryDecodeAsNil() {
				x.Reference = ObjectReference{}
			} else {
				yyv2984 := &x.Reference
				yyv2984.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2981)
		} // end switch yys2981
	} // end for yyj2981
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SerializedReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2985 int
	var yyb2985 bool
	var yyhl2985 bool = l >= 0
	yyj2985++
	if yyhl2985 {
		yyb2985 = yyj2985 > l
	} else {
		yyb2985 = r.CheckBreak()
	}
	if yyb2985 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2985++
	if yyhl2985 {
		yyb2985 = yyj2985 > l
	} else {
		yyb2985 = r.CheckBreak()
	}
	if yyb2985 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2985++
	if yyhl2985 {
		yyb2985 = yyj2985 > l
	} else {
		yyb2985 = r.CheckBreak()
	}
	if yyb2985 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reference = ObjectReference{}
	} else {
		yyv2988 := &x.Reference
		yyv2988.CodecDecodeSelf(d)
	}
	for {
		yyj2985++
		if yyhl2985 {
			yyb2985 = yyj2985 > l
		} else {
			yyb2985 = r.CheckBreak()
		}
		if yyb2985 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2985-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EventSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2989 := z.EncBinary()
		_ = yym2989
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2990 := !z.EncBinary()
			yy2arr2990 := z.EncBasicHandle().StructToArray
			var yyq2990 [2]bool
			_, _, _ = yysep2990, yyq2990, yy2arr2990
			const yyr2990 bool = false
			yyq2990[0] = x.Component != ""
			yyq2990[1] = x.Host != ""
			var yynn2990 int
			if yyr2990 || yy2arr2990 {
				r.EncodeArrayStart(2)
			} else {
				yynn2990 = 0
				for _, b := range yyq2990 {
					if b {
						yynn2990++
					}
				}
				r.EncodeMapStart(yynn2990)
				yynn2990 = 0
			}
			if yyr2990 || yy2arr2990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2990[0] {
					yym2992 := z.EncBinary()
					_ = yym2992
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Component))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2990[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("component"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2993 := z.EncBinary()
					_ = yym2993
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Component))
					}
				}
			}
			if yyr2990 || yy2arr2990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2990[1] {
					yym2995 := z.EncBinary()
					_ = yym2995
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2990[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2996 := z.EncBinary()
					_ = yym2996
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr2990 || yy2arr2990 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EventSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2997 := z.DecBinary()
	_ = yym2997
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2998 := r.ContainerType()
		if yyct2998 == codecSelferValueTypeMap1234 {
			yyl2998 := r.ReadMapStart()
			if yyl2998 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2998, d)
			}
		} else if yyct2998 == codecSelferValueTypeArray1234 {
			yyl2998 := r.ReadArrayStart()
			if yyl2998 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2998, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EventSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2999Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2999Slc
	var yyhl2999 bool = l >= 0
	for yyj2999 := 0; ; yyj2999++ {
		if yyhl2999 {
			if yyj2999 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2999Slc = r.DecodeBytes(yys2999Slc, true, true)
		yys2999 := string(yys2999Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2999 {
		case "component":
			if r.TryDecodeAsNil() {
				x.Component = ""
			} else {
				x.Component = string(r.DecodeString())
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2999)
		} // end switch yys2999
	} // end for yyj2999
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EventSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3002 int
	var yyb3002 bool
	var yyhl3002 bool = l >= 0
	yyj3002++
	if yyhl3002 {
		yyb3002 = yyj3002 > l
	} else {
		yyb3002 = r.CheckBreak()
	}
	if yyb3002 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Component = ""
	} else {
		x.Component = string(r.DecodeString())
	}
	yyj3002++
	if yyhl3002 {
		yyb3002 = yyj3002 > l
	} else {
		yyb3002 = r.CheckBreak()
	}
	if yyb3002 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	for {
		yyj3002++
		if yyhl3002 {
			yyb3002 = yyj3002 > l
		} else {
			yyb3002 = r.CheckBreak()
		}
		if yyb3002 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3002-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Event) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3005 := z.EncBinary()
		_ = yym3005
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3006 := !z.EncBinary()
			yy2arr3006 := z.EncBasicHandle().StructToArray
			var yyq3006 [11]bool
			_, _, _ = yysep3006, yyq3006, yy2arr3006
			const yyr3006 bool = false
			yyq3006[0] = x.Kind != ""
			yyq3006[1] = x.APIVersion != ""
			yyq3006[2] = true
			yyq3006[3] = true
			yyq3006[4] = x.Reason != ""
			yyq3006[5] = x.Message != ""
			yyq3006[6] = true
			yyq3006[7] = true
			yyq3006[8] = true
			yyq3006[9] = x.Count != 0
			yyq3006[10] = x.Type != ""
			var yynn3006 int
			if yyr3006 || yy2arr3006 {
				r.EncodeArrayStart(11)
			} else {
				yynn3006 = 0
				for _, b := range yyq3006 {
					if b {
						yynn3006++
					}
				}
				r.EncodeMapStart(yynn3006)
				yynn3006 = 0
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[0] {
					yym3008 := z.EncBinary()
					_ = yym3008
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3006[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3009 := z.EncBinary()
					_ = yym3009
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[1] {
					yym3011 := z.EncBinary()
					_ = yym3011
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3006[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3012 := z.EncBinary()
					_ = yym3012
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[2] {
					yy3014 := &x.ObjectMeta
					yy3014.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3006[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3015 := &x.ObjectMeta
					yy3015.CodecEncodeSelf(e)
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[3] {
					yy3017 := &x.InvolvedObject
					yy3017.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3006[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("involvedObject"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3018 := &x.InvolvedObject
					yy3018.CodecEncodeSelf(e)
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[4] {
					yym3020 := z.EncBinary()
					_ = yym3020
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3006[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3021 := z.EncBinary()
					_ = yym3021
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[5] {
					yym3023 := z.EncBinary()
					_ = yym3023
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3006[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3024 := z.EncBinary()
					_ = yym3024
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[6] {
					yy3026 := &x.Source
					yy3026.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3006[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("source"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3027 := &x.Source
					yy3027.CodecEncodeSelf(e)
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[7] {
					yy3029 := &x.FirstTimestamp
					yym3030 := z.EncBinary()
					_ = yym3030
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3029) {
					} else if yym3030 {
						z.EncBinaryMarshal(yy3029)
					} else if !yym3030 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3029)
					} else {
						z.EncFallback(yy3029)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3006[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("firstTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3031 := &x.FirstTimestamp
					yym3032 := z.EncBinary()
					_ = yym3032
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3031) {
					} else if yym3032 {
						z.EncBinaryMarshal(yy3031)
					} else if !yym3032 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3031)
					} else {
						z.EncFallback(yy3031)
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[8] {
					yy3034 := &x.LastTimestamp
					yym3035 := z.EncBinary()
					_ = yym3035
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3034) {
					} else if yym3035 {
						z.EncBinaryMarshal(yy3034)
					} else if !yym3035 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3034)
					} else {
						z.EncFallback(yy3034)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3006[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3036 := &x.LastTimestamp
					yym3037 := z.EncBinary()
					_ = yym3037
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3036) {
					} else if yym3037 {
						z.EncBinaryMarshal(yy3036)
					} else if !yym3037 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3036)
					} else {
						z.EncFallback(yy3036)
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[9] {
					yym3039 := z.EncBinary()
					_ = yym3039
					if false {
					} else {
						r.EncodeInt(int64(x.Count))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq3006[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("count"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3040 := z.EncBinary()
					_ = yym3040
					if false {
					} else {
						r.EncodeInt(int64(x.Count))
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3006[10] {
					yym3042 := z.EncBinary()
					_ = yym3042
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Type))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3006[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3043 := z.EncBinary()
					_ = yym3043
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Type))
					}
				}
			}
			if yyr3006 || yy2arr3006 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Event) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3044 := z.DecBinary()
	_ = yym3044
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3045 := r.ContainerType()
		if yyct3045 == codecSelferValueTypeMap1234 {
			yyl3045 := r.ReadMapStart()
			if yyl3045 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3045, d)
			}
		} else if yyct3045 == codecSelferValueTypeArray1234 {
			yyl3045 := r.ReadArrayStart()
			if yyl3045 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3045, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Event) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3046Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3046Slc
	var yyhl3046 bool = l >= 0
	for yyj3046 := 0; ; yyj3046++ {
		if yyhl3046 {
			if yyj3046 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3046Slc = r.DecodeBytes(yys3046Slc, true, true)
		yys3046 := string(yys3046Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3046 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv3049 := &x.ObjectMeta
				yyv3049.CodecDecodeSelf(d)
			}
		case "involvedObject":
			if r.TryDecodeAsNil() {
				x.InvolvedObject = ObjectReference{}
			} else {
				yyv3050 := &x.InvolvedObject
				yyv3050.CodecDecodeSelf(d)
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "source":
			if r.TryDecodeAsNil() {
				x.Source = EventSource{}
			} else {
				yyv3053 := &x.Source
				yyv3053.CodecDecodeSelf(d)
			}
		case "firstTimestamp":
			if r.TryDecodeAsNil() {
				x.FirstTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv3054 := &x.FirstTimestamp
				yym3055 := z.DecBinary()
				_ = yym3055
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3054) {
				} else if yym3055 {
					z.DecBinaryUnmarshal(yyv3054)
				} else if !yym3055 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3054)
				} else {
					z.DecFallback(yyv3054, false)
				}
			}
		case "lastTimestamp":
			if r.TryDecodeAsNil() {
				x.LastTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv3056 := &x.LastTimestamp
				yym3057 := z.DecBinary()
				_ = yym3057
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3056) {
				} else if yym3057 {
					z.DecBinaryUnmarshal(yyv3056)
				} else if !yym3057 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3056)
				} else {
					z.DecFallback(yyv3056, false)
				}
			}
		case "count":
			if r.TryDecodeAsNil() {
				x.Count = 0
			} else {
				x.Count = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3046)
		} // end switch yys3046
	} // end for yyj3046
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Event) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3060 int
	var yyb3060 bool
	var yyhl3060 bool = l >= 0
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv3063 := &x.ObjectMeta
		yyv3063.CodecDecodeSelf(d)
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InvolvedObject = ObjectReference{}
	} else {
		yyv3064 := &x.InvolvedObject
		yyv3064.CodecDecodeSelf(d)
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Source = EventSource{}
	} else {
		yyv3067 := &x.Source
		yyv3067.CodecDecodeSelf(d)
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FirstTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv3068 := &x.FirstTimestamp
		yym3069 := z.DecBinary()
		_ = yym3069
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3068) {
		} else if yym3069 {
			z.DecBinaryUnmarshal(yyv3068)
		} else if !yym3069 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3068)
		} else {
			z.DecFallback(yyv3068, false)
		}
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv3070 := &x.LastTimestamp
		yym3071 := z.DecBinary()
		_ = yym3071
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3070) {
		} else if yym3071 {
			z.DecBinaryUnmarshal(yyv3070)
		} else if !yym3071 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3070)
		} else {
			z.DecFallback(yyv3070, false)
		}
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Count = 0
	} else {
		x.Count = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj3060++
	if yyhl3060 {
		yyb3060 = yyj3060 > l
	} else {
		yyb3060 = r.CheckBreak()
	}
	if yyb3060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = string(r.DecodeString())
	}
	for {
		yyj3060++
		if yyhl3060 {
			yyb3060 = yyj3060 > l
		} else {
			yyb3060 = r.CheckBreak()
		}
		if yyb3060 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3060-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EventList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3074 := z.EncBinary()
		_ = yym3074
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3075 := !z.EncBinary()
			yy2arr3075 := z.EncBasicHandle().StructToArray
			var yyq3075 [4]bool
			_, _, _ = yysep3075, yyq3075, yy2arr3075
			const yyr3075 bool = false
			yyq3075[0] = x.Kind != ""
			yyq3075[1] = x.APIVersion != ""
			yyq3075[2] = true
			var yynn3075 int
			if yyr3075 || yy2arr3075 {
				r.EncodeArrayStart(4)
			} else {
				yynn3075 = 1
				for _, b := range yyq3075 {
					if b {
						yynn3075++
					}
				}
				r.EncodeMapStart(yynn3075)
				yynn3075 = 0
			}
			if yyr3075 || yy2arr3075 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3075[0] {
					yym3077 := z.EncBinary()
					_ = yym3077
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3075[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3078 := z.EncBinary()
					_ = yym3078
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3075 || yy2arr3075 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3075[1] {
					yym3080 := z.EncBinary()
					_ = yym3080
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3075[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3081 := z.EncBinary()
					_ = yym3081
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3075 || yy2arr3075 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3075[2] {
					yy3083 := &x.ListMeta
					yym3084 := z.EncBinary()
					_ = yym3084
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3083) {
					} else {
						z.EncFallback(yy3083)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3075[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3085 := &x.ListMeta
					yym3086 := z.EncBinary()
					_ = yym3086
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3085) {
					} else {
						z.EncFallback(yy3085)
					}
				}
			}
			if yyr3075 || yy2arr3075 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3088 := z.EncBinary()
					_ = yym3088
					if false {
					} else {
						h.encSliceEvent(([]Event)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3089 := z.EncBinary()
					_ = yym3089
					if false {
					} else {
						h.encSliceEvent(([]Event)(x.Items), e)
					}
				}
			}
			if yyr3075 || yy2arr3075 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EventList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3090 := z.DecBinary()
	_ = yym3090
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3091 := r.ContainerType()
		if yyct3091 == codecSelferValueTypeMap1234 {
			yyl3091 := r.ReadMapStart()
			if yyl3091 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3091, d)
			}
		} else if yyct3091 == codecSelferValueTypeArray1234 {
			yyl3091 := r.ReadArrayStart()
			if yyl3091 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3091, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EventList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3092Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3092Slc
	var yyhl3092 bool = l >= 0
	for yyj3092 := 0; ; yyj3092++ {
		if yyhl3092 {
			if yyj3092 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3092Slc = r.DecodeBytes(yys3092Slc, true, true)
		yys3092 := string(yys3092Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3092 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv3095 := &x.ListMeta
				yym3096 := z.DecBinary()
				_ = yym3096
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3095) {
				} else {
					z.DecFallback(yyv3095, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv3097 := &x.Items
				yym3098 := z.DecBinary()
				_ = yym3098
				if false {
				} else {
					h.decSliceEvent((*[]Event)(yyv3097), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3092)
		} // end switch yys3092
	} // end for yyj3092
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EventList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3099 int
	var yyb3099 bool
	var yyhl3099 bool = l >= 0
	yyj3099++
	if yyhl3099 {
		yyb3099 = yyj3099 > l
	} else {
		yyb3099 = r.CheckBreak()
	}
	if yyb3099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3099++
	if yyhl3099 {
		yyb3099 = yyj3099 > l
	} else {
		yyb3099 = r.CheckBreak()
	}
	if yyb3099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3099++
	if yyhl3099 {
		yyb3099 = yyj3099 > l
	} else {
		yyb3099 = r.CheckBreak()
	}
	if yyb3099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv3102 := &x.ListMeta
		yym3103 := z.DecBinary()
		_ = yym3103
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3102) {
		} else {
			z.DecFallback(yyv3102, false)
		}
	}
	yyj3099++
	if yyhl3099 {
		yyb3099 = yyj3099 > l
	} else {
		yyb3099 = r.CheckBreak()
	}
	if yyb3099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv3104 := &x.Items
		yym3105 := z.DecBinary()
		_ = yym3105
		if false {
		} else {
			h.decSliceEvent((*[]Event)(yyv3104), d)
		}
	}
	for {
		yyj3099++
		if yyhl3099 {
			yyb3099 = yyj3099 > l
		} else {
			yyb3099 = r.CheckBreak()
		}
		if yyb3099 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3099-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *List) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3106 := z.EncBinary()
		_ = yym3106
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3107 := !z.EncBinary()
			yy2arr3107 := z.EncBasicHandle().StructToArray
			var yyq3107 [4]bool
			_, _, _ = yysep3107, yyq3107, yy2arr3107
			const yyr3107 bool = false
			yyq3107[0] = x.Kind != ""
			yyq3107[1] = x.APIVersion != ""
			yyq3107[2] = true
			var yynn3107 int
			if yyr3107 || yy2arr3107 {
				r.EncodeArrayStart(4)
			} else {
				yynn3107 = 1
				for _, b := range yyq3107 {
					if b {
						yynn3107++
					}
				}
				r.EncodeMapStart(yynn3107)
				yynn3107 = 0
			}
			if yyr3107 || yy2arr3107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3107[0] {
					yym3109 := z.EncBinary()
					_ = yym3109
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3107[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3110 := z.EncBinary()
					_ = yym3110
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3107 || yy2arr3107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3107[1] {
					yym3112 := z.EncBinary()
					_ = yym3112
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3107[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3113 := z.EncBinary()
					_ = yym3113
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3107 || yy2arr3107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3107[2] {
					yy3115 := &x.ListMeta
					yym3116 := z.EncBinary()
					_ = yym3116
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3115) {
					} else {
						z.EncFallback(yy3115)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3107[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3117 := &x.ListMeta
					yym3118 := z.EncBinary()
					_ = yym3118
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3117) {
					} else {
						z.EncFallback(yy3117)
					}
				}
			}
			if yyr3107 || yy2arr3107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3120 := z.EncBinary()
					_ = yym3120
					if false {
					} else {
						h.encSliceruntime_Object(([]pkg8_runtime.Object)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3121 := z.EncBinary()
					_ = yym3121
					if false {
					} else {
						h.encSliceruntime_Object(([]pkg8_runtime.Object)(x.Items), e)
					}
				}
			}
			if yyr3107 || yy2arr3107 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *List) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3122 := z.DecBinary()
	_ = yym3122
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3123 := r.ContainerType()
		if yyct3123 == codecSelferValueTypeMap1234 {
			yyl3123 := r.ReadMapStart()
			if yyl3123 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3123, d)
			}
		} else if yyct3123 == codecSelferValueTypeArray1234 {
			yyl3123 := r.ReadArrayStart()
			if yyl3123 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3123, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *List) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3124Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3124Slc
	var yyhl3124 bool = l >= 0
	for yyj3124 := 0; ; yyj3124++ {
		if yyhl3124 {
			if yyj3124 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3124Slc = r.DecodeBytes(yys3124Slc, true, true)
		yys3124 := string(yys3124Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3124 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv3127 := &x.ListMeta
				yym3128 := z.DecBinary()
				_ = yym3128
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3127) {
				} else {
					z.DecFallback(yyv3127, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv3129 := &x.Items
				yym3130 := z.DecBinary()
				_ = yym3130
				if false {
				} else {
					h.decSliceruntime_Object((*[]pkg8_runtime.Object)(yyv3129), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3124)
		} // end switch yys3124
	} // end for yyj3124
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *List) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3131 int
	var yyb3131 bool
	var yyhl3131 bool = l >= 0
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv3134 := &x.ListMeta
		yym3135 := z.DecBinary()
		_ = yym3135
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3134) {
		} else {
			z.DecFallback(yyv3134, false)
		}
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv3136 := &x.Items
		yym3137 := z.DecBinary()
		_ = yym3137
		if false {
		} else {
			h.decSliceruntime_Object((*[]pkg8_runtime.Object)(yyv3136), d)
		}
	}
	for {
		yyj3131++
		if yyhl3131 {
			yyb3131 = yyj3131 > l
		} else {
			yyb3131 = r.CheckBreak()
		}
		if yyb3131 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3131-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x LimitType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3138 := z.EncBinary()
	_ = yym3138
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *LimitType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3139 := z.DecBinary()
	_ = yym3139
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *LimitRangeItem) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3140 := z.EncBinary()
		_ = yym3140
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3141 := !z.EncBinary()
			yy2arr3141 := z.EncBasicHandle().StructToArray
			var yyq3141 [6]bool
			_, _, _ = yysep3141, yyq3141, yy2arr3141
			const yyr3141 bool = false
			yyq3141[0] = x.Type != ""
			yyq3141[1] = len(x.Max) != 0
			yyq3141[2] = len(x.Min) != 0
			yyq3141[3] = len(x.Default) != 0
			yyq3141[4] = len(x.DefaultRequest) != 0
			yyq3141[5] = len(x.MaxLimitRequestRatio) != 0
			var yynn3141 int
			if yyr3141 || yy2arr3141 {
				r.EncodeArrayStart(6)
			} else {
				yynn3141 = 0
				for _, b := range yyq3141 {
					if b {
						yynn3141++
					}
				}
				r.EncodeMapStart(yynn3141)
				yynn3141 = 0
			}
			if yyr3141 || yy2arr3141 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3141[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3141[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr3141 || yy2arr3141 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3141[1] {
					if x.Max == nil {
						r.EncodeNil()
					} else {
						x.Max.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3141[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("max"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Max == nil {
						r.EncodeNil()
					} else {
						x.Max.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3141 || yy2arr3141 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3141[2] {
					if x.Min == nil {
						r.EncodeNil()
					} else {
						x.Min.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3141[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("min"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Min == nil {
						r.EncodeNil()
					} else {
						x.Min.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3141 || yy2arr3141 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3141[3] {
					if x.Default == nil {
						r.EncodeNil()
					} else {
						x.Default.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3141[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("default"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Default == nil {
						r.EncodeNil()
					} else {
						x.Default.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3141 || yy2arr3141 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3141[4] {
					if x.DefaultRequest == nil {
						r.EncodeNil()
					} else {
						x.DefaultRequest.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3141[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultRequest"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultRequest == nil {
						r.EncodeNil()
					} else {
						x.DefaultRequest.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3141 || yy2arr3141 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3141[5] {
					if x.MaxLimitRequestRatio == nil {
						r.EncodeNil()
					} else {
						x.MaxLimitRequestRatio.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3141[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxLimitRequestRatio"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxLimitRequestRatio == nil {
						r.EncodeNil()
					} else {
						x.MaxLimitRequestRatio.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3141 || yy2arr3141 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRangeItem) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3148 := z.DecBinary()
	_ = yym3148
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3149 := r.ContainerType()
		if yyct3149 == codecSelferValueTypeMap1234 {
			yyl3149 := r.ReadMapStart()
			if yyl3149 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3149, d)
			}
		} else if yyct3149 == codecSelferValueTypeArray1234 {
			yyl3149 := r.ReadArrayStart()
			if yyl3149 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3149, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRangeItem) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3150Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3150Slc
	var yyhl3150 bool = l >= 0
	for yyj3150 := 0; ; yyj3150++ {
		if yyhl3150 {
			if yyj3150 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3150Slc = r.DecodeBytes(yys3150Slc, true, true)
		yys3150 := string(yys3150Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3150 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = LimitType(r.DecodeString())
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = nil
			} else {
				yyv3152 := &x.Max
				yyv3152.CodecDecodeSelf(d)
			}
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = nil
			} else {
				yyv3153 := &x.Min
				yyv3153.CodecDecodeSelf(d)
			}
		case "default":
			if r.TryDecodeAsNil() {
				x.Default = nil
			} else {
				yyv3154 := &x.Default
				yyv3154.CodecDecodeSelf(d)
			}
		case "defaultRequest":
			if r.TryDecodeAsNil() {
				x.DefaultRequest = nil
			} else {
				yyv3155 := &x.DefaultRequest
				yyv3155.CodecDecodeSelf(d)
			}
		case "maxLimitRequestRatio":
			if r.TryDecodeAsNil() {
				x.MaxLimitRequestRatio = nil
			} else {
				yyv3156 := &x.MaxLimitRequestRatio
				yyv3156.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3150)
		} // end switch yys3150
	} // end for yyj3150
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRangeItem) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3157 int
	var yyb3157 bool
	var yyhl3157 bool = l >= 0
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = LimitType(r.DecodeString())
	}
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = nil
	} else {
		yyv3159 := &x.Max
		yyv3159.CodecDecodeSelf(d)
	}
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = nil
	} else {
		yyv3160 := &x.Min
		yyv3160.CodecDecodeSelf(d)
	}
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Default = nil
	} else {
		yyv3161 := &x.Default
		yyv3161.CodecDecodeSelf(d)
	}
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DefaultRequest = nil
	} else {
		yyv3162 := &x.DefaultRequest
		yyv3162.CodecDecodeSelf(d)
	}
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxLimitRequestRatio = nil
	} else {
		yyv3163 := &x.MaxLimitRequestRatio
		yyv3163.CodecDecodeSelf(d)
	}
	for {
		yyj3157++
		if yyhl3157 {
			yyb3157 = yyj3157 > l
		} else {
			yyb3157 = r.CheckBreak()
		}
		if yyb3157 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3157-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LimitRangeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3164 := z.EncBinary()
		_ = yym3164
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3165 := !z.EncBinary()
			yy2arr3165 := z.EncBasicHandle().StructToArray
			var yyq3165 [1]bool
			_, _, _ = yysep3165, yyq3165, yy2arr3165
			const yyr3165 bool = false
			var yynn3165 int
			if yyr3165 || yy2arr3165 {
				r.EncodeArrayStart(1)
			} else {
				yynn3165 = 1
				for _, b := range yyq3165 {
					if b {
						yynn3165++
					}
				}
				r.EncodeMapStart(yynn3165)
				yynn3165 = 0
			}
			if yyr3165 || yy2arr3165 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Limits == nil {
					r.EncodeNil()
				} else {
					yym3167 := z.EncBinary()
					_ = yym3167
					if false {
					} else {
						h.encSliceLimitRangeItem(([]LimitRangeItem)(x.Limits), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("limits"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Limits == nil {
					r.EncodeNil()
				} else {
					yym3168 := z.EncBinary()
					_ = yym3168
					if false {
					} else {
						h.encSliceLimitRangeItem(([]LimitRangeItem)(x.Limits), e)
					}
				}
			}
			if yyr3165 || yy2arr3165 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRangeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3169 := z.DecBinary()
	_ = yym3169
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3170 := r.ContainerType()
		if yyct3170 == codecSelferValueTypeMap1234 {
			yyl3170 := r.ReadMapStart()
			if yyl3170 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3170, d)
			}
		} else if yyct3170 == codecSelferValueTypeArray1234 {
			yyl3170 := r.ReadArrayStart()
			if yyl3170 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3170, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRangeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3171Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3171Slc
	var yyhl3171 bool = l >= 0
	for yyj3171 := 0; ; yyj3171++ {
		if yyhl3171 {
			if yyj3171 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3171Slc = r.DecodeBytes(yys3171Slc, true, true)
		yys3171 := string(yys3171Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3171 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv3172 := &x.Limits
				yym3173 := z.DecBinary()
				_ = yym3173
				if false {
				} else {
					h.decSliceLimitRangeItem((*[]LimitRangeItem)(yyv3172), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3171)
		} // end switch yys3171
	} // end for yyj3171
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRangeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3174 int
	var yyb3174 bool
	var yyhl3174 bool = l >= 0
	yyj3174++
	if yyhl3174 {
		yyb3174 = yyj3174 > l
	} else {
		yyb3174 = r.CheckBreak()
	}
	if yyb3174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv3175 := &x.Limits
		yym3176 := z.DecBinary()
		_ = yym3176
		if false {
		} else {
			h.decSliceLimitRangeItem((*[]LimitRangeItem)(yyv3175), d)
		}
	}
	for {
		yyj3174++
		if yyhl3174 {
			yyb3174 = yyj3174 > l
		} else {
			yyb3174 = r.CheckBreak()
		}
		if yyb3174 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3174-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LimitRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3177 := z.EncBinary()
		_ = yym3177
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3178 := !z.EncBinary()
			yy2arr3178 := z.EncBasicHandle().StructToArray
			var yyq3178 [4]bool
			_, _, _ = yysep3178, yyq3178, yy2arr3178
			const yyr3178 bool = false
			yyq3178[0] = x.Kind != ""
			yyq3178[1] = x.APIVersion != ""
			yyq3178[2] = true
			yyq3178[3] = true
			var yynn3178 int
			if yyr3178 || yy2arr3178 {
				r.EncodeArrayStart(4)
			} else {
				yynn3178 = 0
				for _, b := range yyq3178 {
					if b {
						yynn3178++
					}
				}
				r.EncodeMapStart(yynn3178)
				yynn3178 = 0
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[0] {
					yym3180 := z.EncBinary()
					_ = yym3180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3178[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3181 := z.EncBinary()
					_ = yym3181
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[1] {
					yym3183 := z.EncBinary()
					_ = yym3183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3178[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3184 := z.EncBinary()
					_ = yym3184
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[2] {
					yy3186 := &x.ObjectMeta
					yy3186.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3178[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3187 := &x.ObjectMeta
					yy3187.CodecEncodeSelf(e)
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[3] {
					yy3189 := &x.Spec
					yy3189.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3178[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3190 := &x.Spec
					yy3190.CodecEncodeSelf(e)
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3191 := z.DecBinary()
	_ = yym3191
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3192 := r.ContainerType()
		if yyct3192 == codecSelferValueTypeMap1234 {
			yyl3192 := r.ReadMapStart()
			if yyl3192 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3192, d)
			}
		} else if yyct3192 == codecSelferValueTypeArray1234 {
			yyl3192 := r.ReadArrayStart()
			if yyl3192 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3192, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3193Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3193Slc
	var yyhl3193 bool = l >= 0
	for yyj3193 := 0; ; yyj3193++ {
		if yyhl3193 {
			if yyj3193 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3193Slc = r.DecodeBytes(yys3193Slc, true, true)
		yys3193 := string(yys3193Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3193 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv3196 := &x.ObjectMeta
				yyv3196.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = LimitRangeSpec{}
			} else {
				yyv3197 := &x.Spec
				yyv3197.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3193)
		} // end switch yys3193
	} // end for yyj3193
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3198 int
	var yyb3198 bool
	var yyhl3198 bool = l >= 0
	yyj3198++
	if yyhl3198 {
		yyb3198 = yyj3198 > l
	} else {
		yyb3198 = r.CheckBreak()
	}
	if yyb3198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3198++
	if yyhl3198 {
		yyb3198 = yyj3198 > l
	} else {
		yyb3198 = r.CheckBreak()
	}
	if yyb3198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3198++
	if yyhl3198 {
		yyb3198 = yyj3198 > l
	} else {
		yyb3198 = r.CheckBreak()
	}
	if yyb3198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv3201 := &x.ObjectMeta
		yyv3201.CodecDecodeSelf(d)
	}
	yyj3198++
	if yyhl3198 {
		yyb3198 = yyj3198 > l
	} else {
		yyb3198 = r.CheckBreak()
	}
	if yyb3198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = LimitRangeSpec{}
	} else {
		yyv3202 := &x.Spec
		yyv3202.CodecDecodeSelf(d)
	}
	for {
		yyj3198++
		if yyhl3198 {
			yyb3198 = yyj3198 > l
		} else {
			yyb3198 = r.CheckBreak()
		}
		if yyb3198 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3198-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LimitRangeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3203 := z.EncBinary()
		_ = yym3203
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3204 := !z.EncBinary()
			yy2arr3204 := z.EncBasicHandle().StructToArray
			var yyq3204 [4]bool
			_, _, _ = yysep3204, yyq3204, yy2arr3204
			const yyr3204 bool = false
			yyq3204[0] = x.Kind != ""
			yyq3204[1] = x.APIVersion != ""
			yyq3204[2] = true
			var yynn3204 int
			if yyr3204 || yy2arr3204 {
				r.EncodeArrayStart(4)
			} else {
				yynn3204 = 1
				for _, b := range yyq3204 {
					if b {
						yynn3204++
					}
				}
				r.EncodeMapStart(yynn3204)
				yynn3204 = 0
			}
			if yyr3204 || yy2arr3204 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3204[0] {
					yym3206 := z.EncBinary()
					_ = yym3206
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3204[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3207 := z.EncBinary()
					_ = yym3207
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3204 || yy2arr3204 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3204[1] {
					yym3209 := z.EncBinary()
					_ = yym3209
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3204[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3210 := z.EncBinary()
					_ = yym3210
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3204 || yy2arr3204 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3204[2] {
					yy3212 := &x.ListMeta
					yym3213 := z.EncBinary()
					_ = yym3213
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3212) {
					} else {
						z.EncFallback(yy3212)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3204[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3214 := &x.ListMeta
					yym3215 := z.EncBinary()
					_ = yym3215
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3214) {
					} else {
						z.EncFallback(yy3214)
					}
				}
			}
			if yyr3204 || yy2arr3204 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3217 := z.EncBinary()
					_ = yym3217
					if false {
					} else {
						h.encSliceLimitRange(([]LimitRange)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3218 := z.EncBinary()
					_ = yym3218
					if false {
					} else {
						h.encSliceLimitRange(([]LimitRange)(x.Items), e)
					}
				}
			}
			if yyr3204 || yy2arr3204 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRangeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3219 := z.DecBinary()
	_ = yym3219
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3220 := r.ContainerType()
		if yyct3220 == codecSelferValueTypeMap1234 {
			yyl3220 := r.ReadMapStart()
			if yyl3220 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3220, d)
			}
		} else if yyct3220 == codecSelferValueTypeArray1234 {
			yyl3220 := r.ReadArrayStart()
			if yyl3220 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3220, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRangeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3221Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3221Slc
	var yyhl3221 bool = l >= 0
	for yyj3221 := 0; ; yyj3221++ {
		if yyhl3221 {
			if yyj3221 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3221Slc = r.DecodeBytes(yys3221Slc, true, true)
		yys3221 := string(yys3221Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3221 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv3224 := &x.ListMeta
				yym3225 := z.DecBinary()
				_ = yym3225
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3224) {
				} else {
					z.DecFallback(yyv3224, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv3226 := &x.Items
				yym3227 := z.DecBinary()
				_ = yym3227
				if false {
				} else {
					h.decSliceLimitRange((*[]LimitRange)(yyv3226), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3221)
		} // end switch yys3221
	} // end for yyj3221
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRangeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3228 int
	var yyb3228 bool
	var yyhl3228 bool = l >= 0
	yyj3228++
	if yyhl3228 {
		yyb3228 = yyj3228 > l
	} else {
		yyb3228 = r.CheckBreak()
	}
	if yyb3228 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3228++
	if yyhl3228 {
		yyb3228 = yyj3228 > l
	} else {
		yyb3228 = r.CheckBreak()
	}
	if yyb3228 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3228++
	if yyhl3228 {
		yyb3228 = yyj3228 > l
	} else {
		yyb3228 = r.CheckBreak()
	}
	if yyb3228 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv3231 := &x.ListMeta
		yym3232 := z.DecBinary()
		_ = yym3232
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3231) {
		} else {
			z.DecFallback(yyv3231, false)
		}
	}
	yyj3228++
	if yyhl3228 {
		yyb3228 = yyj3228 > l
	} else {
		yyb3228 = r.CheckBreak()
	}
	if yyb3228 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv3233 := &x.Items
		yym3234 := z.DecBinary()
		_ = yym3234
		if false {
		} else {
			h.decSliceLimitRange((*[]LimitRange)(yyv3233), d)
		}
	}
	for {
		yyj3228++
		if yyhl3228 {
			yyb3228 = yyj3228 > l
		} else {
			yyb3228 = r.CheckBreak()
		}
		if yyb3228 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3228-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuotaSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3235 := z.EncBinary()
		_ = yym3235
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3236 := !z.EncBinary()
			yy2arr3236 := z.EncBasicHandle().StructToArray
			var yyq3236 [1]bool
			_, _, _ = yysep3236, yyq3236, yy2arr3236
			const yyr3236 bool = false
			yyq3236[0] = len(x.Hard) != 0
			var yynn3236 int
			if yyr3236 || yy2arr3236 {
				r.EncodeArrayStart(1)
			} else {
				yynn3236 = 0
				for _, b := range yyq3236 {
					if b {
						yynn3236++
					}
				}
				r.EncodeMapStart(yynn3236)
				yynn3236 = 0
			}
			if yyr3236 || yy2arr3236 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3236[0] {
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3236[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3236 || yy2arr3236 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceQuotaSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3238 := z.DecBinary()
	_ = yym3238
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3239 := r.ContainerType()
		if yyct3239 == codecSelferValueTypeMap1234 {
			yyl3239 := r.ReadMapStart()
			if yyl3239 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3239, d)
			}
		} else if yyct3239 == codecSelferValueTypeArray1234 {
			yyl3239 := r.ReadArrayStart()
			if yyl3239 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3239, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceQuotaSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3240Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3240Slc
	var yyhl3240 bool = l >= 0
	for yyj3240 := 0; ; yyj3240++ {
		if yyhl3240 {
			if yyj3240 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3240Slc = r.DecodeBytes(yys3240Slc, true, true)
		yys3240 := string(yys3240Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3240 {
		case "hard":
			if r.TryDecodeAsNil() {
				x.Hard = nil
			} else {
				yyv3241 := &x.Hard
				yyv3241.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3240)
		} // end switch yys3240
	} // end for yyj3240
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceQuotaSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3242 int
	var yyb3242 bool
	var yyhl3242 bool = l >= 0
	yyj3242++
	if yyhl3242 {
		yyb3242 = yyj3242 > l
	} else {
		yyb3242 = r.CheckBreak()
	}
	if yyb3242 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hard = nil
	} else {
		yyv3243 := &x.Hard
		yyv3243.CodecDecodeSelf(d)
	}
	for {
		yyj3242++
		if yyhl3242 {
			yyb3242 = yyj3242 > l
		} else {
			yyb3242 = r.CheckBreak()
		}
		if yyb3242 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3242-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuotaStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3244 := z.EncBinary()
		_ = yym3244
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3245 := !z.EncBinary()
			yy2arr3245 := z.EncBasicHandle().StructToArray
			var yyq3245 [2]bool
			_, _, _ = yysep3245, yyq3245, yy2arr3245
			const yyr3245 bool = false
			yyq3245[0] = len(x.Hard) != 0
			yyq3245[1] = len(x.Used) != 0
			var yynn3245 int
			if yyr3245 || yy2arr3245 {
				r.EncodeArrayStart(2)
			} else {
				yynn3245 = 0
				for _, b := range yyq3245 {
					if b {
						yynn3245++
					}
				}
				r.EncodeMapStart(yynn3245)
				yynn3245 = 0
			}
			if yyr3245 || yy2arr3245 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3245[0] {
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3245[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3245 || yy2arr3245 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3245[1] {
					if x.Used == nil {
						r.EncodeNil()
					} else {
						x.Used.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3245[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("used"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Used == nil {
						r.EncodeNil()
					} else {
						x.Used.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3245 || yy2arr3245 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceQuotaStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3248 := z.DecBinary()
	_ = yym3248
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3249 := r.ContainerType()
		if yyct3249 == codecSelferValueTypeMap1234 {
			yyl3249 := r.ReadMapStart()
			if yyl3249 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3249, d)
			}
		} else if yyct3249 == codecSelferValueTypeArray1234 {
			yyl3249 := r.ReadArrayStart()
			if yyl3249 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3249, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceQuotaStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3250Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3250Slc
	var yyhl3250 bool = l >= 0
	for yyj3250 := 0; ; yyj3250++ {
		if yyhl3250 {
			if yyj3250 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3250Slc = r.DecodeBytes(yys3250Slc, true, true)
		yys3250 := string(yys3250Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3250 {
		case "hard":
			if r.TryDecodeAsNil() {
				x.Hard = nil
			} else {
				yyv3251 := &x.Hard
				yyv3251.CodecDecodeSelf(d)
			}
		case "used":
			if r.TryDecodeAsNil() {
				x.Used = nil
			} else {
				yyv3252 := &x.Used
				yyv3252.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3250)
		} // end switch yys3250
	} // end for yyj3250
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceQuotaStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3253 int
	var yyb3253 bool
	var yyhl3253 bool = l >= 0
	yyj3253++
	if yyhl3253 {
		yyb3253 = yyj3253 > l
	} else {
		yyb3253 = r.CheckBreak()
	}
	if yyb3253 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hard = nil
	} else {
		yyv3254 := &x.Hard
		yyv3254.CodecDecodeSelf(d)
	}
	yyj3253++
	if yyhl3253 {
		yyb3253 = yyj3253 > l
	} else {
		yyb3253 = r.CheckBreak()
	}
	if yyb3253 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Used = nil
	} else {
		yyv3255 := &x.Used
		yyv3255.CodecDecodeSelf(d)
	}
	for {
		yyj3253++
		if yyhl3253 {
			yyb3253 = yyj3253 > l
		} else {
			yyb3253 = r.CheckBreak()
		}
		if yyb3253 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3253-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuota) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3256 := z.EncBinary()
		_ = yym3256
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3257 := !z.EncBinary()
			yy2arr3257 := z.EncBasicHandle().StructToArray
			var yyq3257 [5]bool
			_, _, _ = yysep3257, yyq3257, yy2arr3257
			const yyr3257 bool = false
			yyq3257[0] = x.Kind != ""
			yyq3257[1] = x.APIVersion != ""
			yyq3257[2] = true
			yyq3257[3] = true
			yyq3257[4] = true
			var yynn3257 int
			if yyr3257 || yy2arr3257 {
				r.EncodeArrayStart(5)
			} else {
				yynn3257 = 0
				for _, b := range yyq3257 {
					if b {
						yynn3257++
					}
				}
				r.EncodeMapStart(yynn3257)
				yynn3257 = 0
			}
			if yyr3257 || yy2arr3257 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3257[0] {
					yym3259 := z.EncBinary()
					_ = yym3259
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3257[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3260 := z.EncBinary()
					_ = yym3260
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3257 || yy2arr3257 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3257[1] {
					yym3262 := z.EncBinary()
					_ = yym3262
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3257[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3263 := z.EncBinary()
					_ = yym3263
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3257 || yy2arr3257 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3257[2] {
					yy3265 := &x.ObjectMeta
					yy3265.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3257[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3266 := &x.ObjectMeta
					yy3266.CodecEncodeSelf(e)
				}
			}
			if yyr3257 || yy2arr3257 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3257[3] {
					yy3268 := &x.Spec
					yy3268.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3257[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3269 := &x.Spec
					yy3269.CodecEncodeSelf(e)
				}
			}
			if yyr3257 || yy2arr3257 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3257[4] {
					yy3271 := &x.Status
					yy3271.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3257[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3272 := &x.Status
					yy3272.CodecEncodeSelf(e)
				}
			}
			if yyr3257 || yy2arr3257 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceQuota) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3273 := z.DecBinary()
	_ = yym3273
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3274 := r.ContainerType()
		if yyct3274 == codecSelferValueTypeMap1234 {
			yyl3274 := r.ReadMapStart()
			if yyl3274 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3274, d)
			}
		} else if yyct3274 == codecSelferValueTypeArray1234 {
			yyl3274 := r.ReadArrayStart()
			if yyl3274 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3274, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceQuota) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3275Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3275Slc
	var yyhl3275 bool = l >= 0
	for yyj3275 := 0; ; yyj3275++ {
		if yyhl3275 {
			if yyj3275 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3275Slc = r.DecodeBytes(yys3275Slc, true, true)
		yys3275 := string(yys3275Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3275 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv3278 := &x.ObjectMeta
				yyv3278.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ResourceQuotaSpec{}
			} else {
				yyv3279 := &x.Spec
				yyv3279.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ResourceQuotaStatus{}
			} else {
				yyv3280 := &x.Status
				yyv3280.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3275)
		} // end switch yys3275
	} // end for yyj3275
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceQuota) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3281 int
	var yyb3281 bool
	var yyhl3281 bool = l >= 0
	yyj3281++
	if yyhl3281 {
		yyb3281 = yyj3281 > l
	} else {
		yyb3281 = r.CheckBreak()
	}
	if yyb3281 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3281++
	if yyhl3281 {
		yyb3281 = yyj3281 > l
	} else {
		yyb3281 = r.CheckBreak()
	}
	if yyb3281 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3281++
	if yyhl3281 {
		yyb3281 = yyj3281 > l
	} else {
		yyb3281 = r.CheckBreak()
	}
	if yyb3281 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv3284 := &x.ObjectMeta
		yyv3284.CodecDecodeSelf(d)
	}
	yyj3281++
	if yyhl3281 {
		yyb3281 = yyj3281 > l
	} else {
		yyb3281 = r.CheckBreak()
	}
	if yyb3281 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ResourceQuotaSpec{}
	} else {
		yyv3285 := &x.Spec
		yyv3285.CodecDecodeSelf(d)
	}
	yyj3281++
	if yyhl3281 {
		yyb3281 = yyj3281 > l
	} else {
		yyb3281 = r.CheckBreak()
	}
	if yyb3281 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ResourceQuotaStatus{}
	} else {
		yyv3286 := &x.Status
		yyv3286.CodecDecodeSelf(d)
	}
	for {
		yyj3281++
		if yyhl3281 {
			yyb3281 = yyj3281 > l
		} else {
			yyb3281 = r.CheckBreak()
		}
		if yyb3281 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3281-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuotaList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3287 := z.EncBinary()
		_ = yym3287
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3288 := !z.EncBinary()
			yy2arr3288 := z.EncBasicHandle().StructToArray
			var yyq3288 [4]bool
			_, _, _ = yysep3288, yyq3288, yy2arr3288
			const yyr3288 bool = false
			yyq3288[0] = x.Kind != ""
			yyq3288[1] = x.APIVersion != ""
			yyq3288[2] = true
			var yynn3288 int
			if yyr3288 || yy2arr3288 {
				r.EncodeArrayStart(4)
			} else {
				yynn3288 = 1
				for _, b := range yyq3288 {
					if b {
						yynn3288++
					}
				}
				r.EncodeMapStart(yynn3288)
				yynn3288 = 0
			}
			if yyr3288 || yy2arr3288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3288[0] {
					yym3290 := z.EncBinary()
					_ = yym3290
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3288[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3291 := z.EncBinary()
					_ = yym3291
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3288 || yy2arr3288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3288[1] {
					yym3293 := z.EncBinary()
					_ = yym3293
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3288[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3294 := z.EncBinary()
					_ = yym3294
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3288 || yy2arr3288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3288[2] {
					yy3296 := &x.ListMeta
					yym3297 := z.EncBinary()
					_ = yym3297
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3296) {
					} else {
						z.EncFallback(yy3296)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3288[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3298 := &x.ListMeta
					yym3299 := z.EncBinary()
					_ = yym3299
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3298) {
					} else {
					