/*
Copyright 2015 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 time.Duration
		_, _ = v0, v1
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [18]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(18)
			} else {
				yynn2 = 16
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeBool(bool(x.CleanupIPTables))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cleanupIPTables"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeBool(bool(x.CleanupIPTables))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym25 := z.EncBinary()
				_ = yym25
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesSyncePeriodSeconds))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym26 := z.EncBinary()
				_ = yym26
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesSyncePeriodSeconds))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym28 := z.EncBinary()
				_ = yym28
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym29 := z.EncBinary()
				_ = yym29
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym32 := z.EncBinary()
				_ = yym32
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym34 := z.EncBinary()
				_ = yym34
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym35 := z.EncBinary()
				_ = yym35
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym37 := z.EncBinary()
				_ = yym37
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym40 := z.EncBinary()
				_ = yym40
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy43 := *x.OOMScoreAdj
					yym44 := z.EncBinary()
					_ = yym44
					if false {
					} else {
						r.EncodeInt(int64(yy43))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy45 := *x.OOMScoreAdj
					yym46 := z.EncBinary()
					_ = yym46
					if false {
					} else {
						r.EncodeInt(int64(yy45))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym49 := z.EncBinary()
				_ = yym49
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym50 := z.EncBinary()
				_ = yym50
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym52 := z.EncBinary()
				_ = yym52
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceContainer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym53 := z.EncBinary()
				_ = yym53
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeInt(int64(x.UDPTimeoutMilliseconds))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym56 := z.EncBinary()
				_ = yym56
				if false {
				} else {
					r.EncodeInt(int64(x.UDPTimeoutMilliseconds))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym57 := z.DecBinary()
	_ = yym57
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct58 := r.ContainerType()
		if yyct58 == codecSelferValueTypeMap1234 {
			yyl58 := r.ReadMapStart()
			if yyl58 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl58, d)
			}
		} else if yyct58 == codecSelferValueTypeArray1234 {
			yyl58 := r.ReadArrayStart()
			if yyl58 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl58, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys59Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys59Slc
	var yyhl59 bool = l >= 0
	for yyj59 := 0; ; yyj59++ {
		if yyhl59 {
			if yyj59 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys59Slc = r.DecodeBytes(yys59Slc, true, true)
		yys59 := string(yys59Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys59 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "cleanupIPTables":
			if r.TryDecodeAsNil() {
				x.CleanupIPTables = false
			} else {
				x.CleanupIPTables = bool(r.DecodeBool())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncePeriodSeconds = 0
			} else {
				x.IPTablesSyncePeriodSeconds = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int)
				}
				yym74 := z.DecBinary()
				_ = yym74
				if false {
				} else {
					*((*int)(x.OOMScoreAdj)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "resourceContainer":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPTimeoutMilliseconds = 0
			} else {
				x.UDPTimeoutMilliseconds = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys59)
		} // end switch yys59
	} // end for yyj59
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj79 int
	var yyb79 bool
	var yyhl79 bool = l >= 0
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CleanupIPTables = false
	} else {
		x.CleanupIPTables = bool(r.DecodeBool())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncePeriodSeconds = 0
	} else {
		x.IPTablesSyncePeriodSeconds = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int)
		}
		yym94 := z.DecBinary()
		_ = yym94
		if false {
		} else {
			*((*int)(x.OOMScoreAdj)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPTimeoutMilliseconds = 0
	} else {
		x.UDPTimeoutMilliseconds = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj79++
		if yyhl79 {
			yyb79 = yyj79 > l
		} else {
			yyb79 = r.CheckBreak()
		}
		if yyb79 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj79-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym99 := z.EncBinary()
	_ = yym99
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym100 := z.DecBinary()
	_ = yym100
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym101 := z.EncBinary()
		_ = yym101
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep102 := !z.EncBinary()
			yy2arr102 := z.EncBasicHandle().StructToArray
			var yyq102 [4]bool
			_, _, _ = yysep102, yyq102, yy2arr102
			const yyr102 bool = false
			var yynn102 int
			if yyr102 || yy2arr102 {
				r.EncodeArrayStart(4)
			} else {
				yynn102 = 4
				for _, b := range yyq102 {
					if b {
						yynn102++
					}
				}
				r.EncodeMapStart(yynn102)
				yynn102 = 0
			}
			if yyr102 || yy2arr102 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym104 := z.EncBinary()
				_ = yym104
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym105 := z.EncBinary()
				_ = yym105
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr102 || yy2arr102 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy107 := &x.LeaseDuration
				yym108 := z.EncBinary()
				_ = yym108
				if false {
				} else if z.HasExtensions() && z.EncExt(yy107) {
				} else if !yym108 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy107)
				} else {
					z.EncFallback(yy107)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy109 := &x.LeaseDuration
				yym110 := z.EncBinary()
				_ = yym110
				if false {
				} else if z.HasExtensions() && z.EncExt(yy109) {
				} else if !yym110 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy109)
				} else {
					z.EncFallback(yy109)
				}
			}
			if yyr102 || yy2arr102 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy112 := &x.RenewDeadline
				yym113 := z.EncBinary()
				_ = yym113
				if false {
				} else if z.HasExtensions() && z.EncExt(yy112) {
				} else if !yym113 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy112)
				} else {
					z.EncFallback(yy112)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy114 := &x.RenewDeadline
				yym115 := z.EncBinary()
				_ = yym115
				if false {
				} else if z.HasExtensions() && z.EncExt(yy114) {
				} else if !yym115 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy114)
				} else {
					z.EncFallback(yy114)
				}
			}
			if yyr102 || yy2arr102 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy117 := &x.RetryPeriod
				yym118 := z.EncBinary()
				_ = yym118
				if false {
				} else if z.HasExtensions() && z.EncExt(yy117) {
				} else if !yym118 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy117)
				} else {
					z.EncFallback(yy117)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy119 := &x.RetryPeriod
				yym120 := z.EncBinary()
				_ = yym120
				if false {
				} else if z.HasExtensions() && z.EncExt(yy119) {
				} else if !yym120 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy119)
				} else {
					z.EncFallback(yy119)
				}
			}
			if yyr102 || yy2arr102 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym121 := z.DecBinary()
	_ = yym121
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct122 := r.ContainerType()
		if yyct122 == codecSelferValueTypeMap1234 {
			yyl122 := r.ReadMapStart()
			if yyl122 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl122, d)
			}
		} else if yyct122 == codecSelferValueTypeArray1234 {
			yyl122 := r.ReadArrayStart()
			if yyl122 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl122, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys123Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys123Slc
	var yyhl123 bool = l >= 0
	for yyj123 := 0; ; yyj123++ {
		if yyhl123 {
			if yyj123 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys123Slc = r.DecodeBytes(yys123Slc, true, true)
		yys123 := string(yys123Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys123 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_unversioned.Duration{}
			} else {
				yyv125 := &x.LeaseDuration
				yym126 := z.DecBinary()
				_ = yym126
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv125) {
				} else if !yym126 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv125)
				} else {
					z.DecFallback(yyv125, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_unversioned.Duration{}
			} else {
				yyv127 := &x.RenewDeadline
				yym128 := z.DecBinary()
				_ = yym128
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv127) {
				} else if !yym128 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv127)
				} else {
					z.DecFallback(yyv127, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv129 := &x.RetryPeriod
				yym130 := z.DecBinary()
				_ = yym130
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv129) {
				} else if !yym130 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv129)
				} else {
					z.DecFallback(yyv129, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys123)
		} // end switch yys123
	} // end for yyj123
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj131 int
	var yyb131 bool
	var yyhl131 bool = l >= 0
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_unversioned.Duration{}
	} else {
		yyv133 := &x.LeaseDuration
		yym134 := z.DecBinary()
		_ = yym134
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv133) {
		} else if !yym134 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv133)
		} else {
			z.DecFallback(yyv133, false)
		}
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_unversioned.Duration{}
	} else {
		yyv135 := &x.RenewDeadline
		yym136 := z.DecBinary()
		_ = yym136
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv135) {
		} else if !yym136 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv135)
		} else {
			z.DecFallback(yyv135, false)
		}
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv137 := &x.RetryPeriod
		yym138 := z.DecBinary()
		_ = yym138
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv137) {
		} else if !yym138 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv137)
		} else {
			z.DecFallback(yyv137, false)
		}
	}
	for {
		yyj131++
		if yyhl131 {
			yyb131 = yyj131 > l
		} else {
			yyb131 = r.CheckBreak()
		}
		if yyb131 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj131-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}
