/*
Copyright 2015 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg2_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg6_runtime "k8s.io/kubernetes/pkg/runtime"
	pkg1_types "k8s.io/kubernetes/pkg/types"
	pkg5_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	pkg4_inf "speter.net/go/exp/math/dec/inf"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg2_unversioned.Time
		var v2 pkg6_runtime.RawExtension
		var v3 pkg1_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 pkg4_inf.Dec
		var v6 time.Time
		_, _, _, _, _, _, _ = v0, v1, v2, v3, v4, v5, v6
	}
}

func (x *ObjectMeta) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [12]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.GenerateName != ""
			yyq2[2] = x.Namespace != ""
			yyq2[3] = x.SelfLink != ""
			yyq2[4] = x.UID != ""
			yyq2[5] = x.ResourceVersion != ""
			yyq2[6] = x.Generation != 0
			yyq2[7] = true
			yyq2[8] = x.DeletionTimestamp != nil
			yyq2[9] = x.DeletionGracePeriodSeconds != nil
			yyq2[10] = len(x.Labels) != 0
			yyq2[11] = len(x.Annotations) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(12)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yy25 := &x.CreationTimestamp
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else if z.HasExtensions() && z.EncExt(yy25) {
					} else if yym26 {
						z.EncBinaryMarshal(yy25)
					} else if !yym26 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy25)
					} else {
						z.EncFallback(yy25)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy27 := &x.CreationTimestamp
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else if z.HasExtensions() && z.EncExt(yy27) {
					} else if yym28 {
						z.EncBinaryMarshal(yy27)
					} else if !yym28 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy27)
					} else {
						z.EncFallback(yy27)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym30 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym30 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym31 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym31 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy33 := *x.DeletionGracePeriodSeconds
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							r.EncodeInt(int64(yy33))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy35 := *x.DeletionGracePeriodSeconds
						yym36 := z.EncBinary()
						_ = yym36
						if false {
						} else {
							r.EncodeInt(int64(yy35))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym38 := z.EncBinary()
						_ = yym38
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym42 := z.EncBinary()
						_ = yym42
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectMeta) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym43 := z.DecBinary()
	_ = yym43
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct44 := r.ContainerType()
		if yyct44 == codecSelferValueTypeMap1234 {
			yyl44 := r.ReadMapStart()
			if yyl44 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl44, d)
			}
		} else if yyct44 == codecSelferValueTypeArray1234 {
			yyl44 := r.ReadArrayStart()
			if yyl44 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl44, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectMeta) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys45Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys45Slc
	var yyhl45 bool = l >= 0
	for yyj45 := 0; ; yyj45++ {
		if yyhl45 {
			if yyj45 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys45Slc = r.DecodeBytes(yys45Slc, true, true)
		yys45 := string(yys45Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys45 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv53 := &x.CreationTimestamp
				yym54 := z.DecBinary()
				_ = yym54
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv53) {
				} else if yym54 {
					z.DecBinaryUnmarshal(yyv53)
				} else if !yym54 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv53)
				} else {
					z.DecFallback(yyv53, false)
				}
			}
		case "deletionTimestamp":
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg2_unversioned.Time)
				}
				yym56 := z.DecBinary()
				_ = yym56
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym56 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym56 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym58 := z.DecBinary()
				_ = yym58
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv59 := &x.Labels
				yym60 := z.DecBinary()
				_ = yym60
				if false {
				} else {
					z.F.DecMapStringStringX(yyv59, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv61 := &x.Annotations
				yym62 := z.DecBinary()
				_ = yym62
				if false {
				} else {
					z.F.DecMapStringStringX(yyv61, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys45)
		} // end switch yys45
	} // end for yyj45
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectMeta) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj63 int
	var yyb63 bool
	var yyhl63 bool = l >= 0
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv71 := &x.CreationTimestamp
		yym72 := z.DecBinary()
		_ = yym72
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv71) {
		} else if yym72 {
			z.DecBinaryUnmarshal(yyv71)
		} else if !yym72 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv71)
		} else {
			z.DecFallback(yyv71, false)
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg2_unversioned.Time)
		}
		yym74 := z.DecBinary()
		_ = yym74
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym74 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym74 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym76 := z.DecBinary()
		_ = yym76
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv77 := &x.Labels
		yym78 := z.DecBinary()
		_ = yym78
		if false {
		} else {
			z.F.DecMapStringStringX(yyv77, false, d)
		}
	}
	yyj63++
	if yyhl63 {
		yyb63 = yyj63 > l
	} else {
		yyb63 = r.CheckBreak()
	}
	if yyb63 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv79 := &x.Annotations
		yym80 := z.DecBinary()
		_ = yym80
		if false {
		} else {
			z.F.DecMapStringStringX(yyv79, false, d)
		}
	}
	for {
		yyj63++
		if yyhl63 {
			yyb63 = yyj63 > l
		} else {
			yyb63 = r.CheckBreak()
		}
		if yyb63 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj63-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Volume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym81 := z.EncBinary()
		_ = yym81
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep82 := !z.EncBinary()
			yy2arr82 := z.EncBasicHandle().StructToArray
			var yyq82 [18]bool
			_, _, _ = yysep82, yyq82, yy2arr82
			const yyr82 bool = false
			yyq82[1] = x.VolumeSource.HostPath != nil && x.HostPath != nil
			yyq82[2] = x.VolumeSource.EmptyDir != nil && x.EmptyDir != nil
			yyq82[3] = x.VolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq82[4] = x.VolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq82[5] = x.VolumeSource.GitRepo != nil && x.GitRepo != nil
			yyq82[6] = x.VolumeSource.Secret != nil && x.Secret != nil
			yyq82[7] = x.VolumeSource.NFS != nil && x.NFS != nil
			yyq82[8] = x.VolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq82[9] = x.VolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq82[10] = x.VolumeSource.PersistentVolumeClaim != nil && x.PersistentVolumeClaim != nil
			yyq82[11] = x.VolumeSource.RBD != nil && x.RBD != nil
			yyq82[12] = x.VolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq82[13] = x.VolumeSource.Cinder != nil && x.Cinder != nil
			yyq82[14] = x.VolumeSource.CephFS != nil && x.CephFS != nil
			yyq82[15] = x.VolumeSource.Flocker != nil && x.Flocker != nil
			yyq82[16] = x.VolumeSource.DownwardAPI != nil && x.DownwardAPI != nil
			yyq82[17] = x.VolumeSource.FC != nil && x.FC != nil
			var yynn82 int
			if yyr82 || yy2arr82 {
				r.EncodeArrayStart(18)
			} else {
				yynn82 = 1
				for _, b := range yyq82 {
					if b {
						yynn82++
					}
				}
				r.EncodeMapStart(yynn82)
				yynn82 = 0
			}
			if yyr82 || yy2arr82 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym84 := z.EncBinary()
				_ = yym84
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym85 := z.EncBinary()
				_ = yym85
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			var yyn86 bool
			if x.VolumeSource.HostPath == nil {
				yyn86 = true
				goto LABEL86
			}
		LABEL86:
			if yyr82 || yy2arr82 {
				if yyn86 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[1] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn86 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn87 bool
			if x.VolumeSource.EmptyDir == nil {
				yyn87 = true
				goto LABEL87
			}
		LABEL87:
			if yyr82 || yy2arr82 {
				if yyn87 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[2] {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn87 {
						r.EncodeNil()
					} else {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn88 bool
			if x.VolumeSource.GCEPersistentDisk == nil {
				yyn88 = true
				goto LABEL88
			}
		LABEL88:
			if yyr82 || yy2arr82 {
				if yyn88 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[3] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn88 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn89 bool
			if x.VolumeSource.AWSElasticBlockStore == nil {
				yyn89 = true
				goto LABEL89
			}
		LABEL89:
			if yyr82 || yy2arr82 {
				if yyn89 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[4] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn89 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn90 bool
			if x.VolumeSource.GitRepo == nil {
				yyn90 = true
				goto LABEL90
			}
		LABEL90:
			if yyr82 || yy2arr82 {
				if yyn90 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[5] {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn90 {
						r.EncodeNil()
					} else {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn91 bool
			if x.VolumeSource.Secret == nil {
				yyn91 = true
				goto LABEL91
			}
		LABEL91:
			if yyr82 || yy2arr82 {
				if yyn91 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[6] {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn91 {
						r.EncodeNil()
					} else {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn92 bool
			if x.VolumeSource.NFS == nil {
				yyn92 = true
				goto LABEL92
			}
		LABEL92:
			if yyr82 || yy2arr82 {
				if yyn92 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[7] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn92 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn93 bool
			if x.VolumeSource.ISCSI == nil {
				yyn93 = true
				goto LABEL93
			}
		LABEL93:
			if yyr82 || yy2arr82 {
				if yyn93 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn93 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn94 bool
			if x.VolumeSource.Glusterfs == nil {
				yyn94 = true
				goto LABEL94
			}
		LABEL94:
			if yyr82 || yy2arr82 {
				if yyn94 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[9] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn94 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn95 bool
			if x.VolumeSource.PersistentVolumeClaim == nil {
				yyn95 = true
				goto LABEL95
			}
		LABEL95:
			if yyr82 || yy2arr82 {
				if yyn95 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[10] {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn95 {
						r.EncodeNil()
					} else {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn96 bool
			if x.VolumeSource.RBD == nil {
				yyn96 = true
				goto LABEL96
			}
		LABEL96:
			if yyr82 || yy2arr82 {
				if yyn96 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[11] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn96 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn97 bool
			if x.VolumeSource.FlexVolume == nil {
				yyn97 = true
				goto LABEL97
			}
		LABEL97:
			if yyr82 || yy2arr82 {
				if yyn97 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn97 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn98 bool
			if x.VolumeSource.Cinder == nil {
				yyn98 = true
				goto LABEL98
			}
		LABEL98:
			if yyr82 || yy2arr82 {
				if yyn98 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[13] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn98 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn99 bool
			if x.VolumeSource.CephFS == nil {
				yyn99 = true
				goto LABEL99
			}
		LABEL99:
			if yyr82 || yy2arr82 {
				if yyn99 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[14] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn99 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn100 bool
			if x.VolumeSource.Flocker == nil {
				yyn100 = true
				goto LABEL100
			}
		LABEL100:
			if yyr82 || yy2arr82 {
				if yyn100 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[15] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn100 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn101 bool
			if x.VolumeSource.DownwardAPI == nil {
				yyn101 = true
				goto LABEL101
			}
		LABEL101:
			if yyr82 || yy2arr82 {
				if yyn101 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[16] {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn101 {
						r.EncodeNil()
					} else {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn102 bool
			if x.VolumeSource.FC == nil {
				yyn102 = true
				goto LABEL102
			}
		LABEL102:
			if yyr82 || yy2arr82 {
				if yyn102 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq82[17] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq82[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn102 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr82 || yy2arr82 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Volume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym103 := z.DecBinary()
	_ = yym103
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct104 := r.ContainerType()
		if yyct104 == codecSelferValueTypeMap1234 {
			yyl104 := r.ReadMapStart()
			if yyl104 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl104, d)
			}
		} else if yyct104 == codecSelferValueTypeArray1234 {
			yyl104 := r.ReadArrayStart()
			if yyl104 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl104, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Volume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys105Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys105Slc
	var yyhl105 bool = l >= 0
	for yyj105 := 0; ; yyj105++ {
		if yyhl105 {
			if yyj105 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys105Slc = r.DecodeBytes(yys105Slc, true, true)
		yys105 := string(yys105Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys105 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPath":
			if x.VolumeSource.HostPath == nil {
				x.VolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if x.VolumeSource.EmptyDir == nil {
				x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.VolumeSource.GCEPersistentDisk == nil {
				x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.VolumeSource.AWSElasticBlockStore == nil {
				x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if x.VolumeSource.GitRepo == nil {
				x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if x.VolumeSource.Secret == nil {
				x.VolumeSource.Secret = new(SecretVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.VolumeSource.NFS == nil {
				x.VolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.VolumeSource.ISCSI == nil {
				x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.VolumeSource.Glusterfs == nil {
				x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if x.VolumeSource.PersistentVolumeClaim == nil {
				x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.VolumeSource.RBD == nil {
				x.VolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.VolumeSource.FlexVolume == nil {
				x.VolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.VolumeSource.Cinder == nil {
				x.VolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.VolumeSource.CephFS == nil {
				x.VolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.VolumeSource.Flocker == nil {
				x.VolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if x.VolumeSource.DownwardAPI == nil {
				x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if x.VolumeSource.FC == nil {
				x.VolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys105)
		} // end switch yys105
	} // end for yyj105
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Volume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj124 int
	var yyb124 bool
	var yyhl124 bool = l >= 0
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	if x.VolumeSource.HostPath == nil {
		x.VolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.VolumeSource.EmptyDir == nil {
		x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GCEPersistentDisk == nil {
		x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AWSElasticBlockStore == nil {
		x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GitRepo == nil {
		x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Secret == nil {
		x.VolumeSource.Secret = new(SecretVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	if x.VolumeSource.NFS == nil {
		x.VolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ISCSI == nil {
		x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Glusterfs == nil {
		x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PersistentVolumeClaim == nil {
		x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	if x.VolumeSource.RBD == nil {
		x.VolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FlexVolume == nil {
		x.VolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Cinder == nil {
		x.VolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.VolumeSource.CephFS == nil {
		x.VolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Flocker == nil {
		x.VolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.VolumeSource.DownwardAPI == nil {
		x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FC == nil {
		x.VolumeSource.FC = new(FCVolumeSource)
	}
	yyj124++
	if yyhl124 {
		yyb124 = yyj124 > l
	} else {
		yyb124 = r.CheckBreak()
	}
	if yyb124 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	for {
		yyj124++
		if yyhl124 {
			yyb124 = yyj124 > l
		} else {
			yyb124 = r.CheckBreak()
		}
		if yyb124 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj124-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym143 := z.EncBinary()
		_ = yym143
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep144 := !z.EncBinary()
			yy2arr144 := z.EncBasicHandle().StructToArray
			var yyq144 [17]bool
			_, _, _ = yysep144, yyq144, yy2arr144
			const yyr144 bool = false
			yyq144[0] = x.HostPath != nil
			yyq144[1] = x.EmptyDir != nil
			yyq144[2] = x.GCEPersistentDisk != nil
			yyq144[3] = x.AWSElasticBlockStore != nil
			yyq144[4] = x.GitRepo != nil
			yyq144[5] = x.Secret != nil
			yyq144[6] = x.NFS != nil
			yyq144[7] = x.ISCSI != nil
			yyq144[8] = x.Glusterfs != nil
			yyq144[9] = x.PersistentVolumeClaim != nil
			yyq144[10] = x.RBD != nil
			yyq144[11] = x.FlexVolume != nil
			yyq144[12] = x.Cinder != nil
			yyq144[13] = x.CephFS != nil
			yyq144[14] = x.Flocker != nil
			yyq144[15] = x.DownwardAPI != nil
			yyq144[16] = x.FC != nil
			var yynn144 int
			if yyr144 || yy2arr144 {
				r.EncodeArrayStart(17)
			} else {
				yynn144 = 0
				for _, b := range yyq144 {
					if b {
						yynn144++
					}
				}
				r.EncodeMapStart(yynn144)
				yynn144 = 0
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[0] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[1] {
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[2] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[3] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[4] {
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[5] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[6] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[8] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[9] {
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[10] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[12] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[13] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[14] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[15] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[16] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym162 := z.DecBinary()
	_ = yym162
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct163 := r.ContainerType()
		if yyct163 == codecSelferValueTypeMap1234 {
			yyl163 := r.ReadMapStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl163, d)
			}
		} else if yyct163 == codecSelferValueTypeArray1234 {
			yyl163 := r.ReadArrayStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl163, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys164Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys164Slc
	var yyhl164 bool = l >= 0
	for yyj164 := 0; ; yyj164++ {
		if yyhl164 {
			if yyj164 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys164Slc = r.DecodeBytes(yys164Slc, true, true)
		yys164 := string(yys164Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys164 {
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys164)
		} // end switch yys164
	} // end for yyj164
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj182 int
	var yyb182 bool
	var yyhl182 bool = l >= 0
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	for {
		yyj182++
		if yyhl182 {
			yyb182 = yyj182 > l
		} else {
			yyb182 = r.CheckBreak()
		}
		if yyb182 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj182-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym200 := z.EncBinary()
		_ = yym200
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep201 := !z.EncBinary()
			yy2arr201 := z.EncBasicHandle().StructToArray
			var yyq201 [2]bool
			_, _, _ = yysep201, yyq201, yy2arr201
			const yyr201 bool = false
			yyq201[1] = x.ReadOnly != false
			var yynn201 int
			if yyr201 || yy2arr201 {
				r.EncodeArrayStart(2)
			} else {
				yynn201 = 1
				for _, b := range yyq201 {
					if b {
						yynn201++
					}
				}
				r.EncodeMapStart(yynn201)
				yynn201 = 0
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym203 := z.EncBinary()
				_ = yym203
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("claimName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym204 := z.EncBinary()
				_ = yym204
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[1] {
					yym206 := z.EncBinary()
					_ = yym206
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq201[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym207 := z.EncBinary()
					_ = yym207
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym208 := z.DecBinary()
	_ = yym208
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct209 := r.ContainerType()
		if yyct209 == codecSelferValueTypeMap1234 {
			yyl209 := r.ReadMapStart()
			if yyl209 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl209, d)
			}
		} else if yyct209 == codecSelferValueTypeArray1234 {
			yyl209 := r.ReadArrayStart()
			if yyl209 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl209, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys210Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys210Slc
	var yyhl210 bool = l >= 0
	for yyj210 := 0; ; yyj210++ {
		if yyhl210 {
			if yyj210 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys210Slc = r.DecodeBytes(yys210Slc, true, true)
		yys210 := string(yys210Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys210 {
		case "claimName":
			if r.TryDecodeAsNil() {
				x.ClaimName = ""
			} else {
				x.ClaimName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys210)
		} // end switch yys210
	} // end for yyj210
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj213 int
	var yyb213 bool
	var yyhl213 bool = l >= 0
	yyj213++
	if yyhl213 {
		yyb213 = yyj213 > l
	} else {
		yyb213 = r.CheckBreak()
	}
	if yyb213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClaimName = ""
	} else {
		x.ClaimName = string(r.DecodeString())
	}
	yyj213++
	if yyhl213 {
		yyb213 = yyj213 > l
	} else {
		yyb213 = r.CheckBreak()
	}
	if yyb213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj213++
		if yyhl213 {
			yyb213 = yyj213 > l
		} else {
			yyb213 = r.CheckBreak()
		}
		if yyb213 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj213-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym216 := z.EncBinary()
		_ = yym216
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep217 := !z.EncBinary()
			yy2arr217 := z.EncBasicHandle().StructToArray
			var yyq217 [12]bool
			_, _, _ = yysep217, yyq217, yy2arr217
			const yyr217 bool = false
			yyq217[0] = x.GCEPersistentDisk != nil
			yyq217[1] = x.AWSElasticBlockStore != nil
			yyq217[2] = x.HostPath != nil
			yyq217[3] = x.Glusterfs != nil
			yyq217[4] = x.NFS != nil
			yyq217[5] = x.RBD != nil
			yyq217[6] = x.ISCSI != nil
			yyq217[7] = x.Cinder != nil
			yyq217[8] = x.CephFS != nil
			yyq217[9] = x.FC != nil
			yyq217[10] = x.Flocker != nil
			yyq217[11] = x.FlexVolume != nil
			var yynn217 int
			if yyr217 || yy2arr217 {
				r.EncodeArrayStart(12)
			} else {
				yynn217 = 0
				for _, b := range yyq217 {
					if b {
						yynn217++
					}
				}
				r.EncodeMapStart(yynn217)
				yynn217 = 0
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[0] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[1] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[2] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[3] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[4] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[5] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[6] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[7] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[8] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[9] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[10] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq217[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq217[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr217 || yy2arr217 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym230 := z.DecBinary()
	_ = yym230
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct231 := r.ContainerType()
		if yyct231 == codecSelferValueTypeMap1234 {
			yyl231 := r.ReadMapStart()
			if yyl231 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl231, d)
			}
		} else if yyct231 == codecSelferValueTypeArray1234 {
			yyl231 := r.ReadArrayStart()
			if yyl231 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl231, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys232Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys232Slc
	var yyhl232 bool = l >= 0
	for yyj232 := 0; ; yyj232++ {
		if yyhl232 {
			if yyj232 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys232Slc = r.DecodeBytes(yys232Slc, true, true)
		yys232 := string(yys232Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys232 {
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys232)
		} // end switch yys232
	} // end for yyj232
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj245 int
	var yyb245 bool
	var yyhl245 bool = l >= 0
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	for {
		yyj245++
		if yyhl245 {
			yyb245 = yyj245 > l
		} else {
			yyb245 = r.CheckBreak()
		}
		if yyb245 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj245-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym258 := z.EncBinary()
		_ = yym258
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep259 := !z.EncBinary()
			yy2arr259 := z.EncBasicHandle().StructToArray
			var yyq259 [5]bool
			_, _, _ = yysep259, yyq259, yy2arr259
			const yyr259 bool = false
			yyq259[0] = x.Kind != ""
			yyq259[1] = x.APIVersion != ""
			yyq259[2] = true
			yyq259[3] = true
			yyq259[4] = true
			var yynn259 int
			if yyr259 || yy2arr259 {
				r.EncodeArrayStart(5)
			} else {
				yynn259 = 0
				for _, b := range yyq259 {
					if b {
						yynn259++
					}
				}
				r.EncodeMapStart(yynn259)
				yynn259 = 0
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[0] {
					yym261 := z.EncBinary()
					_ = yym261
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq259[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym262 := z.EncBinary()
					_ = yym262
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[1] {
					yym264 := z.EncBinary()
					_ = yym264
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq259[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym265 := z.EncBinary()
					_ = yym265
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[2] {
					yy267 := &x.ObjectMeta
					yy267.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq259[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy268 := &x.ObjectMeta
					yy268.CodecEncodeSelf(e)
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[3] {
					yy270 := &x.Spec
					yy270.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq259[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy271 := &x.Spec
					yy271.CodecEncodeSelf(e)
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq259[4] {
					yy273 := &x.Status
					yy273.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq259[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy274 := &x.Status
					yy274.CodecEncodeSelf(e)
				}
			}
			if yyr259 || yy2arr259 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym275 := z.DecBinary()
	_ = yym275
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct276 := r.ContainerType()
		if yyct276 == codecSelferValueTypeMap1234 {
			yyl276 := r.ReadMapStart()
			if yyl276 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl276, d)
			}
		} else if yyct276 == codecSelferValueTypeArray1234 {
			yyl276 := r.ReadArrayStart()
			if yyl276 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl276, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys277Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys277Slc
	var yyhl277 bool = l >= 0
	for yyj277 := 0; ; yyj277++ {
		if yyhl277 {
			if yyj277 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys277Slc = r.DecodeBytes(yys277Slc, true, true)
		yys277 := string(yys277Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys277 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv280 := &x.ObjectMeta
				yyv280.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeSpec{}
			} else {
				yyv281 := &x.Spec
				yyv281.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeStatus{}
			} else {
				yyv282 := &x.Status
				yyv282.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys277)
		} // end switch yys277
	} // end for yyj277
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj283 int
	var yyb283 bool
	var yyhl283 bool = l >= 0
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv286 := &x.ObjectMeta
		yyv286.CodecDecodeSelf(d)
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeSpec{}
	} else {
		yyv287 := &x.Spec
		yyv287.CodecDecodeSelf(d)
	}
	yyj283++
	if yyhl283 {
		yyb283 = yyj283 > l
	} else {
		yyb283 = r.CheckBreak()
	}
	if yyb283 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeStatus{}
	} else {
		yyv288 := &x.Status
		yyv288.CodecDecodeSelf(d)
	}
	for {
		yyj283++
		if yyhl283 {
			yyb283 = yyj283 > l
		} else {
			yyb283 = r.CheckBreak()
		}
		if yyb283 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj283-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym289 := z.EncBinary()
		_ = yym289
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep290 := !z.EncBinary()
			yy2arr290 := z.EncBasicHandle().StructToArray
			var yyq290 [16]bool
			_, _, _ = yysep290, yyq290, yy2arr290
			const yyr290 bool = false
			yyq290[0] = len(x.Capacity) != 0
			yyq290[1] = x.PersistentVolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq290[2] = x.PersistentVolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq290[3] = x.PersistentVolumeSource.HostPath != nil && x.HostPath != nil
			yyq290[4] = x.PersistentVolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq290[5] = x.PersistentVolumeSource.NFS != nil && x.NFS != nil
			yyq290[6] = x.PersistentVolumeSource.RBD != nil && x.RBD != nil
			yyq290[7] = x.PersistentVolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq290[8] = x.PersistentVolumeSource.Cinder != nil && x.Cinder != nil
			yyq290[9] = x.PersistentVolumeSource.CephFS != nil && x.CephFS != nil
			yyq290[10] = x.PersistentVolumeSource.FC != nil && x.FC != nil
			yyq290[11] = x.PersistentVolumeSource.Flocker != nil && x.Flocker != nil
			yyq290[12] = x.PersistentVolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq290[13] = len(x.AccessModes) != 0
			yyq290[14] = x.ClaimRef != nil
			yyq290[15] = x.PersistentVolumeReclaimPolicy != ""
			var yynn290 int
			if yyr290 || yy2arr290 {
				r.EncodeArrayStart(16)
			} else {
				yynn290 = 0
				for _, b := range yyq290 {
					if b {
						yynn290++
					}
				}
				r.EncodeMapStart(yynn290)
				yynn290 = 0
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq290[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq290[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			var yyn292 bool
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				yyn292 = true
				goto LABEL292
			}
		LABEL292:
			if yyr290 || yy2arr290 {
				if yyn292 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[1] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn292 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn293 bool
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				yyn293 = true
				goto LABEL293
			}
		LABEL293:
			if yyr290 || yy2arr290 {
				if yyn293 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[2] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn293 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn294 bool
			if x.PersistentVolumeSource.HostPath == nil {
				yyn294 = true
				goto LABEL294
			}
		LABEL294:
			if yyr290 || yy2arr290 {
				if yyn294 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[3] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn294 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn295 bool
			if x.PersistentVolumeSource.Glusterfs == nil {
				yyn295 = true
				goto LABEL295
			}
		LABEL295:
			if yyr290 || yy2arr290 {
				if yyn295 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[4] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn295 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn296 bool
			if x.PersistentVolumeSource.NFS == nil {
				yyn296 = true
				goto LABEL296
			}
		LABEL296:
			if yyr290 || yy2arr290 {
				if yyn296 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[5] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn296 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn297 bool
			if x.PersistentVolumeSource.RBD == nil {
				yyn297 = true
				goto LABEL297
			}
		LABEL297:
			if yyr290 || yy2arr290 {
				if yyn297 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[6] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn297 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn298 bool
			if x.PersistentVolumeSource.ISCSI == nil {
				yyn298 = true
				goto LABEL298
			}
		LABEL298:
			if yyr290 || yy2arr290 {
				if yyn298 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[7] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn298 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn299 bool
			if x.PersistentVolumeSource.Cinder == nil {
				yyn299 = true
				goto LABEL299
			}
		LABEL299:
			if yyr290 || yy2arr290 {
				if yyn299 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[8] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn299 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn300 bool
			if x.PersistentVolumeSource.CephFS == nil {
				yyn300 = true
				goto LABEL300
			}
		LABEL300:
			if yyr290 || yy2arr290 {
				if yyn300 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[9] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn300 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn301 bool
			if x.PersistentVolumeSource.FC == nil {
				yyn301 = true
				goto LABEL301
			}
		LABEL301:
			if yyr290 || yy2arr290 {
				if yyn301 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[10] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn301 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn302 bool
			if x.PersistentVolumeSource.Flocker == nil {
				yyn302 = true
				goto LABEL302
			}
		LABEL302:
			if yyr290 || yy2arr290 {
				if yyn302 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[11] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn302 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn303 bool
			if x.PersistentVolumeSource.FlexVolume == nil {
				yyn303 = true
				goto LABEL303
			}
		LABEL303:
			if yyr290 || yy2arr290 {
				if yyn303 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq290[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq290[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn303 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq290[13] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym305 := z.EncBinary()
						_ = yym305
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq290[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym306 := z.EncBinary()
						_ = yym306
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq290[14] {
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq290[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("claimRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq290[15] {
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq290[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeReclaimPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr290 || yy2arr290 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym309 := z.DecBinary()
	_ = yym309
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct310 := r.ContainerType()
		if yyct310 == codecSelferValueTypeMap1234 {
			yyl310 := r.ReadMapStart()
			if yyl310 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl310, d)
			}
		} else if yyct310 == codecSelferValueTypeArray1234 {
			yyl310 := r.ReadArrayStart()
			if yyl310 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl310, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys311Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys311Slc
	var yyhl311 bool = l >= 0
	for yyj311 := 0; ; yyj311++ {
		if yyhl311 {
			if yyj311 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys311Slc = r.DecodeBytes(yys311Slc, true, true)
		yys311 := string(yys311Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys311 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv312 := &x.Capacity
				yyv312.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if x.PersistentVolumeSource.HostPath == nil {
				x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.PersistentVolumeSource.Glusterfs == nil {
				x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.PersistentVolumeSource.NFS == nil {
				x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.PersistentVolumeSource.RBD == nil {
				x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.PersistentVolumeSource.ISCSI == nil {
				x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.PersistentVolumeSource.Cinder == nil {
				x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.PersistentVolumeSource.CephFS == nil {
				x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if x.PersistentVolumeSource.FC == nil {
				x.PersistentVolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.PersistentVolumeSource.Flocker == nil {
				x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.PersistentVolumeSource.FlexVolume == nil {
				x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv325 := &x.AccessModes
				yym326 := z.DecBinary()
				_ = yym326
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv325), d)
				}
			}
		case "claimRef":
			if r.TryDecodeAsNil() {
				if x.ClaimRef != nil {
					x.ClaimRef = nil
				}
			} else {
				if x.ClaimRef == nil {
					x.ClaimRef = new(ObjectReference)
				}
				x.ClaimRef.CodecDecodeSelf(d)
			}
		case "persistentVolumeReclaimPolicy":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeReclaimPolicy = ""
			} else {
				x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys311)
		} // end switch yys311
	} // end for yyj311
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj329 int
	var yyb329 bool
	var yyhl329 bool = l >= 0
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv330 := &x.Capacity
		yyv330.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.GCEPersistentDisk == nil {
		x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
		x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.HostPath == nil {
		x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Glusterfs == nil {
		x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.NFS == nil {
		x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.RBD == nil {
		x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ISCSI == nil {
		x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Cinder == nil {
		x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.CephFS == nil {
		x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FC == nil {
		x.PersistentVolumeSource.FC = new(FCVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Flocker == nil {
		x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FlexVolume == nil {
		x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv343 := &x.AccessModes
		yym344 := z.DecBinary()
		_ = yym344
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv343), d)
		}
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ClaimRef != nil {
			x.ClaimRef = nil
		}
	} else {
		if x.ClaimRef == nil {
			x.ClaimRef = new(ObjectReference)
		}
		x.ClaimRef.CodecDecodeSelf(d)
	}
	yyj329++
	if yyhl329 {
		yyb329 = yyj329 > l
	} else {
		yyb329 = r.CheckBreak()
	}
	if yyb329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeReclaimPolicy = ""
	} else {
		x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
	}
	for {
		yyj329++
		if yyhl329 {
			yyb329 = yyj329 > l
		} else {
			yyb329 = r.CheckBreak()
		}
		if yyb329 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj329-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeReclaimPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym347 := z.EncBinary()
	_ = yym347
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeReclaimPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym348 := z.DecBinary()
	_ = yym348
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PersistentVolumeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym349 := z.EncBinary()
		_ = yym349
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep350 := !z.EncBinary()
			yy2arr350 := z.EncBasicHandle().StructToArray
			var yyq350 [3]bool
			_, _, _ = yysep350, yyq350, yy2arr350
			const yyr350 bool = false
			yyq350[0] = x.Phase != ""
			yyq350[1] = x.Message != ""
			yyq350[2] = x.Reason != ""
			var yynn350 int
			if yyr350 || yy2arr350 {
				r.EncodeArrayStart(3)
			} else {
				yynn350 = 0
				for _, b := range yyq350 {
					if b {
						yynn350++
					}
				}
				r.EncodeMapStart(yynn350)
				yynn350 = 0
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq350[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq350[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq350[1] {
					yym353 := z.EncBinary()
					_ = yym353
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq350[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq350[2] {
					yym356 := z.EncBinary()
					_ = yym356
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq350[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym357 := z.EncBinary()
					_ = yym357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr350 || yy2arr350 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym358 := z.DecBinary()
	_ = yym358
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct359 := r.ContainerType()
		if yyct359 == codecSelferValueTypeMap1234 {
			yyl359 := r.ReadMapStart()
			if yyl359 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl359, d)
			}
		} else if yyct359 == codecSelferValueTypeArray1234 {
			yyl359 := r.ReadArrayStart()
			if yyl359 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl359, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys360Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys360Slc
	var yyhl360 bool = l >= 0
	for yyj360 := 0; ; yyj360++ {
		if yyhl360 {
			if yyj360 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys360Slc = r.DecodeBytes(yys360Slc, true, true)
		yys360 := string(yys360Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys360 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumePhase(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys360)
		} // end switch yys360
	} // end for yyj360
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj364 int
	var yyb364 bool
	var yyhl364 bool = l >= 0
	yyj364++
	if yyhl364 {
		yyb364 = yyj364 > l
	} else {
		yyb364 = r.CheckBreak()
	}
	if yyb364 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumePhase(r.DecodeString())
	}
	yyj364++
	if yyhl364 {
		yyb364 = yyj364 > l
	} else {
		yyb364 = r.CheckBreak()
	}
	if yyb364 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj364++
	if yyhl364 {
		yyb364 = yyj364 > l
	} else {
		yyb364 = r.CheckBreak()
	}
	if yyb364 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	for {
		yyj364++
		if yyhl364 {
			yyb364 = yyj364 > l
		} else {
			yyb364 = r.CheckBreak()
		}
		if yyb364 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj364-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym368 := z.EncBinary()
		_ = yym368
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep369 := !z.EncBinary()
			yy2arr369 := z.EncBasicHandle().StructToArray
			var yyq369 [4]bool
			_, _, _ = yysep369, yyq369, yy2arr369
			const yyr369 bool = false
			yyq369[0] = x.Kind != ""
			yyq369[1] = x.APIVersion != ""
			yyq369[2] = true
			var yynn369 int
			if yyr369 || yy2arr369 {
				r.EncodeArrayStart(4)
			} else {
				yynn369 = 1
				for _, b := range yyq369 {
					if b {
						yynn369++
					}
				}
				r.EncodeMapStart(yynn369)
				yynn369 = 0
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq369[0] {
					yym371 := z.EncBinary()
					_ = yym371
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq369[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym372 := z.EncBinary()
					_ = yym372
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq369[1] {
					yym374 := z.EncBinary()
					_ = yym374
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq369[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym375 := z.EncBinary()
					_ = yym375
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq369[2] {
					yy377 := &x.ListMeta
					yym378 := z.EncBinary()
					_ = yym378
					if false {
					} else if z.HasExtensions() && z.EncExt(yy377) {
					} else {
						z.EncFallback(yy377)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq369[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy379 := &x.ListMeta
					yym380 := z.EncBinary()
					_ = yym380
					if false {
					} else if z.HasExtensions() && z.EncExt(yy379) {
					} else {
						z.EncFallback(yy379)
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym382 := z.EncBinary()
					_ = yym382
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym383 := z.EncBinary()
					_ = yym383
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			}
			if yyr369 || yy2arr369 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym384 := z.DecBinary()
	_ = yym384
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct385 := r.ContainerType()
		if yyct385 == codecSelferValueTypeMap1234 {
			yyl385 := r.ReadMapStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl385, d)
			}
		} else if yyct385 == codecSelferValueTypeArray1234 {
			yyl385 := r.ReadArrayStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl385, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys386Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys386Slc
	var yyhl386 bool = l >= 0
	for yyj386 := 0; ; yyj386++ {
		if yyhl386 {
			if yyj386 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys386Slc = r.DecodeBytes(yys386Slc, true, true)
		yys386 := string(yys386Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys386 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv389 := &x.ListMeta
				yym390 := z.DecBinary()
				_ = yym390
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv389) {
				} else {
					z.DecFallback(yyv389, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv391 := &x.Items
				yym392 := z.DecBinary()
				_ = yym392
				if false {
				} else {
					h.decSlicePersistentVolume((*[]PersistentVolume)(yyv391), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys386)
		} // end switch yys386
	} // end for yyj386
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj393 int
	var yyb393 bool
	var yyhl393 bool = l >= 0
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv396 := &x.ListMeta
		yym397 := z.DecBinary()
		_ = yym397
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv396) {
		} else {
			z.DecFallback(yyv396, false)
		}
	}
	yyj393++
	if yyhl393 {
		yyb393 = yyj393 > l
	} else {
		yyb393 = r.CheckBreak()
	}
	if yyb393 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv398 := &x.Items
		yym399 := z.DecBinary()
		_ = yym399
		if false {
		} else {
			h.decSlicePersistentVolume((*[]PersistentVolume)(yyv398), d)
		}
	}
	for {
		yyj393++
		if yyhl393 {
			yyb393 = yyj393 > l
		} else {
			yyb393 = r.CheckBreak()
		}
		if yyb393 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj393-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaim) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym400 := z.EncBinary()
		_ = yym400
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep401 := !z.EncBinary()
			yy2arr401 := z.EncBasicHandle().StructToArray
			var yyq401 [5]bool
			_, _, _ = yysep401, yyq401, yy2arr401
			const yyr401 bool = false
			yyq401[0] = x.Kind != ""
			yyq401[1] = x.APIVersion != ""
			yyq401[2] = true
			yyq401[3] = true
			yyq401[4] = true
			var yynn401 int
			if yyr401 || yy2arr401 {
				r.EncodeArrayStart(5)
			} else {
				yynn401 = 0
				for _, b := range yyq401 {
					if b {
						yynn401++
					}
				}
				r.EncodeMapStart(yynn401)
				yynn401 = 0
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[0] {
					yym403 := z.EncBinary()
					_ = yym403
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq401[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym404 := z.EncBinary()
					_ = yym404
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[1] {
					yym406 := z.EncBinary()
					_ = yym406
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq401[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym407 := z.EncBinary()
					_ = yym407
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[2] {
					yy409 := &x.ObjectMeta
					yy409.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq401[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy410 := &x.ObjectMeta
					yy410.CodecEncodeSelf(e)
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[3] {
					yy412 := &x.Spec
					yy412.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq401[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy413 := &x.Spec
					yy413.CodecEncodeSelf(e)
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq401[4] {
					yy415 := &x.Status
					yy415.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq401[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy416 := &x.Status
					yy416.CodecEncodeSelf(e)
				}
			}
			if yyr401 || yy2arr401 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaim) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym417 := z.DecBinary()
	_ = yym417
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct418 := r.ContainerType()
		if yyct418 == codecSelferValueTypeMap1234 {
			yyl418 := r.ReadMapStart()
			if yyl418 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl418, d)
			}
		} else if yyct418 == codecSelferValueTypeArray1234 {
			yyl418 := r.ReadArrayStart()
			if yyl418 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl418, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys419Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys419Slc
	var yyhl419 bool = l >= 0
	for yyj419 := 0; ; yyj419++ {
		if yyhl419 {
			if yyj419 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys419Slc = r.DecodeBytes(yys419Slc, true, true)
		yys419 := string(yys419Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys419 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv422 := &x.ObjectMeta
				yyv422.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeClaimSpec{}
			} else {
				yyv423 := &x.Spec
				yyv423.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeClaimStatus{}
			} else {
				yyv424 := &x.Status
				yyv424.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys419)
		} // end switch yys419
	} // end for yyj419
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj425 int
	var yyb425 bool
	var yyhl425 bool = l >= 0
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv428 := &x.ObjectMeta
		yyv428.CodecDecodeSelf(d)
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeClaimSpec{}
	} else {
		yyv429 := &x.Spec
		yyv429.CodecDecodeSelf(d)
	}
	yyj425++
	if yyhl425 {
		yyb425 = yyj425 > l
	} else {
		yyb425 = r.CheckBreak()
	}
	if yyb425 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeClaimStatus{}
	} else {
		yyv430 := &x.Status
		yyv430.CodecDecodeSelf(d)
	}
	for {
		yyj425++
		if yyhl425 {
			yyb425 = yyj425 > l
		} else {
			yyb425 = r.CheckBreak()
		}
		if yyb425 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj425-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym431 := z.EncBinary()
		_ = yym431
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep432 := !z.EncBinary()
			yy2arr432 := z.EncBasicHandle().StructToArray
			var yyq432 [4]bool
			_, _, _ = yysep432, yyq432, yy2arr432
			const yyr432 bool = false
			yyq432[0] = x.Kind != ""
			yyq432[1] = x.APIVersion != ""
			yyq432[2] = true
			var yynn432 int
			if yyr432 || yy2arr432 {
				r.EncodeArrayStart(4)
			} else {
				yynn432 = 1
				for _, b := range yyq432 {
					if b {
						yynn432++
					}
				}
				r.EncodeMapStart(yynn432)
				yynn432 = 0
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq432[0] {
					yym434 := z.EncBinary()
					_ = yym434
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq432[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym435 := z.EncBinary()
					_ = yym435
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq432[1] {
					yym437 := z.EncBinary()
					_ = yym437
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq432[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym438 := z.EncBinary()
					_ = yym438
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq432[2] {
					yy440 := &x.ListMeta
					yym441 := z.EncBinary()
					_ = yym441
					if false {
					} else if z.HasExtensions() && z.EncExt(yy440) {
					} else {
						z.EncFallback(yy440)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq432[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy442 := &x.ListMeta
					yym443 := z.EncBinary()
					_ = yym443
					if false {
					} else if z.HasExtensions() && z.EncExt(yy442) {
					} else {
						z.EncFallback(yy442)
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym446 := z.EncBinary()
					_ = yym446
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			}
			if yyr432 || yy2arr432 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym447 := z.DecBinary()
	_ = yym447
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct448 := r.ContainerType()
		if yyct448 == codecSelferValueTypeMap1234 {
			yyl448 := r.ReadMapStart()
			if yyl448 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl448, d)
			}
		} else if yyct448 == codecSelferValueTypeArray1234 {
			yyl448 := r.ReadArrayStart()
			if yyl448 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl448, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys449Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys449Slc
	var yyhl449 bool = l >= 0
	for yyj449 := 0; ; yyj449++ {
		if yyhl449 {
			if yyj449 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys449Slc = r.DecodeBytes(yys449Slc, true, true)
		yys449 := string(yys449Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys449 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv452 := &x.ListMeta
				yym453 := z.DecBinary()
				_ = yym453
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv452) {
				} else {
					z.DecFallback(yyv452, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv454 := &x.Items
				yym455 := z.DecBinary()
				_ = yym455
				if false {
				} else {
					h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv454), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys449)
		} // end switch yys449
	} // end for yyj449
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj456 int
	var yyb456 bool
	var yyhl456 bool = l >= 0
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv459 := &x.ListMeta
		yym460 := z.DecBinary()
		_ = yym460
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv459) {
		} else {
			z.DecFallback(yyv459, false)
		}
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv461 := &x.Items
		yym462 := z.DecBinary()
		_ = yym462
		if false {
		} else {
			h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv461), d)
		}
	}
	for {
		yyj456++
		if yyhl456 {
			yyb456 = yyj456 > l
		} else {
			yyb456 = r.CheckBreak()
		}
		if yyb456 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj456-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym463 := z.EncBinary()
		_ = yym463
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep464 := !z.EncBinary()
			yy2arr464 := z.EncBasicHandle().StructToArray
			var yyq464 [3]bool
			_, _, _ = yysep464, yyq464, yy2arr464
			const yyr464 bool = false
			yyq464[0] = len(x.AccessModes) != 0
			yyq464[1] = true
			yyq464[2] = x.VolumeName != ""
			var yynn464 int
			if yyr464 || yy2arr464 {
				r.EncodeArrayStart(3)
			} else {
				yynn464 = 0
				for _, b := range yyq464 {
					if b {
						yynn464++
					}
				}
				r.EncodeMapStart(yynn464)
				yynn464 = 0
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq464[0] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym466 := z.EncBinary()
						_ = yym466
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq464[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym467 := z.EncBinary()
						_ = yym467
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq464[1] {
					yy469 := &x.Resources
					yy469.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq464[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy470 := &x.Resources
					yy470.CodecEncodeSelf(e)
				}
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq464[2] {
					yym472 := z.EncBinary()
					_ = yym472
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq464[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym473 := z.EncBinary()
					_ = yym473
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr464 || yy2arr464 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym474 := z.DecBinary()
	_ = yym474
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct475 := r.ContainerType()
		if yyct475 == codecSelferValueTypeMap1234 {
			yyl475 := r.ReadMapStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl475, d)
			}
		} else if yyct475 == codecSelferValueTypeArray1234 {
			yyl475 := r.ReadArrayStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl475, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys476Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys476Slc
	var yyhl476 bool = l >= 0
	for yyj476 := 0; ; yyj476++ {
		if yyhl476 {
			if yyj476 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys476Slc = r.DecodeBytes(yys476Slc, true, true)
		yys476 := string(yys476Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys476 {
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv477 := &x.AccessModes
				yym478 := z.DecBinary()
				_ = yym478
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv477), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv479 := &x.Resources
				yyv479.CodecDecodeSelf(d)
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				x.VolumeName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys476)
		} // end switch yys476
	} // end for yyj476
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj481 int
	var yyb481 bool
	var yyhl481 bool = l >= 0
	yyj481++
	if yyhl481 {
		yyb481 = yyj481 > l
	} else {
		yyb481 = r.CheckBreak()
	}
	if yyb481 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv482 := &x.AccessModes
		yym483 := z.DecBinary()
		_ = yym483
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv482), d)
		}
	}
	yyj481++
	if yyhl481 {
		yyb481 = yyj481 > l
	} else {
		yyb481 = r.CheckBreak()
	}
	if yyb481 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv484 := &x.Resources
		yyv484.CodecDecodeSelf(d)
	}
	yyj481++
	if yyhl481 {
		yyb481 = yyj481 > l
	} else {
		yyb481 = r.CheckBreak()
	}
	if yyb481 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		x.VolumeName = string(r.DecodeString())
	}
	for {
		yyj481++
		if yyhl481 {
			yyb481 = yyj481 > l
		} else {
			yyb481 = r.CheckBreak()
		}
		if yyb481 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj481-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym486 := z.EncBinary()
		_ = yym486
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep487 := !z.EncBinary()
			yy2arr487 := z.EncBasicHandle().StructToArray
			var yyq487 [3]bool
			_, _, _ = yysep487, yyq487, yy2arr487
			const yyr487 bool = false
			yyq487[0] = x.Phase != ""
			yyq487[1] = len(x.AccessModes) != 0
			yyq487[2] = len(x.Capacity) != 0
			var yynn487 int
			if yyr487 || yy2arr487 {
				r.EncodeArrayStart(3)
			} else {
				yynn487 = 0
				for _, b := range yyq487 {
					if b {
						yynn487++
					}
				}
				r.EncodeMapStart(yynn487)
				yynn487 = 0
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq487[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq487[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq487[1] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym490 := z.EncBinary()
						_ = yym490
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq487[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym491 := z.EncBinary()
						_ = yym491
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq487[2] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq487[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr487 || yy2arr487 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym493 := z.DecBinary()
	_ = yym493
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct494 := r.ContainerType()
		if yyct494 == codecSelferValueTypeMap1234 {
			yyl494 := r.ReadMapStart()
			if yyl494 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl494, d)
			}
		} else if yyct494 == codecSelferValueTypeArray1234 {
			yyl494 := r.ReadArrayStart()
			if yyl494 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl494, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys495Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys495Slc
	var yyhl495 bool = l >= 0
	for yyj495 := 0; ; yyj495++ {
		if yyhl495 {
			if yyj495 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys495Slc = r.DecodeBytes(yys495Slc, true, true)
		yys495 := string(yys495Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys495 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv497 := &x.AccessModes
				yym498 := z.DecBinary()
				_ = yym498
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv497), d)
				}
			}
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv499 := &x.Capacity
				yyv499.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys495)
		} // end switch yys495
	} // end for yyj495
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj500 int
	var yyb500 bool
	var yyhl500 bool = l >= 0
	yyj500++
	if yyhl500 {
		yyb500 = yyj500 > l
	} else {
		yyb500 = r.CheckBreak()
	}
	if yyb500 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
	}
	yyj500++
	if yyhl500 {
		yyb500 = yyj500 > l
	} else {
		yyb500 = r.CheckBreak()
	}
	if yyb500 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv502 := &x.AccessModes
		yym503 := z.DecBinary()
		_ = yym503
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv502), d)
		}
	}
	yyj500++
	if yyhl500 {
		yyb500 = yyj500 > l
	} else {
		yyb500 = r.CheckBreak()
	}
	if yyb500 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv504 := &x.Capacity
		yyv504.CodecDecodeSelf(d)
	}
	for {
		yyj500++
		if yyhl500 {
			yyb500 = yyj500 > l
		} else {
			yyb500 = r.CheckBreak()
		}
		if yyb500 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj500-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeAccessMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym505 := z.EncBinary()
	_ = yym505
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeAccessMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym506 := z.DecBinary()
	_ = yym506
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym507 := z.EncBinary()
	_ = yym507
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym508 := z.DecBinary()
	_ = yym508
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumeClaimPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym509 := z.EncBinary()
	_ = yym509
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeClaimPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym510 := z.DecBinary()
	_ = yym510
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPathVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym511 := z.EncBinary()
		_ = yym511
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep512 := !z.EncBinary()
			yy2arr512 := z.EncBasicHandle().StructToArray
			var yyq512 [1]bool
			_, _, _ = yysep512, yyq512, yy2arr512
			const yyr512 bool = false
			var yynn512 int
			if yyr512 || yy2arr512 {
				r.EncodeArrayStart(1)
			} else {
				yynn512 = 1
				for _, b := range yyq512 {
					if b {
						yynn512++
					}
				}
				r.EncodeMapStart(yynn512)
				yynn512 = 0
			}
			if yyr512 || yy2arr512 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym514 := z.EncBinary()
				_ = yym514
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym515 := z.EncBinary()
				_ = yym515
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr512 || yy2arr512 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPathVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym516 := z.DecBinary()
	_ = yym516
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct517 := r.ContainerType()
		if yyct517 == codecSelferValueTypeMap1234 {
			yyl517 := r.ReadMapStart()
			if yyl517 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl517, d)
			}
		} else if yyct517 == codecSelferValueTypeArray1234 {
			yyl517 := r.ReadArrayStart()
			if yyl517 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl517, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPathVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys518Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys518Slc
	var yyhl518 bool = l >= 0
	for yyj518 := 0; ; yyj518++ {
		if yyhl518 {
			if yyj518 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys518Slc = r.DecodeBytes(yys518Slc, true, true)
		yys518 := string(yys518Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys518 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys518)
		} // end switch yys518
	} // end for yyj518
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPathVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj520 int
	var yyb520 bool
	var yyhl520 bool = l >= 0
	yyj520++
	if yyhl520 {
		yyb520 = yyj520 > l
	} else {
		yyb520 = r.CheckBreak()
	}
	if yyb520 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj520++
		if yyhl520 {
			yyb520 = yyj520 > l
		} else {
			yyb520 = r.CheckBreak()
		}
		if yyb520 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj520-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EmptyDirVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym522 := z.EncBinary()
		_ = yym522
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep523 := !z.EncBinary()
			yy2arr523 := z.EncBasicHandle().StructToArray
			var yyq523 [1]bool
			_, _, _ = yysep523, yyq523, yy2arr523
			const yyr523 bool = false
			yyq523[0] = x.Medium != ""
			var yynn523 int
			if yyr523 || yy2arr523 {
				r.EncodeArrayStart(1)
			} else {
				yynn523 = 0
				for _, b := range yyq523 {
					if b {
						yynn523++
					}
				}
				r.EncodeMapStart(yynn523)
				yynn523 = 0
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq523[0] {
					x.Medium.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq523[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("medium"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Medium.CodecEncodeSelf(e)
				}
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EmptyDirVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym525 := z.DecBinary()
	_ = yym525
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct526 := r.ContainerType()
		if yyct526 == codecSelferValueTypeMap1234 {
			yyl526 := r.ReadMapStart()
			if yyl526 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl526, d)
			}
		} else if yyct526 == codecSelferValueTypeArray1234 {
			yyl526 := r.ReadArrayStart()
			if yyl526 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl526, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys527Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys527Slc
	var yyhl527 bool = l >= 0
	for yyj527 := 0; ; yyj527++ {
		if yyhl527 {
			if yyj527 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys527Slc = r.DecodeBytes(yys527Slc, true, true)
		yys527 := string(yys527Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys527 {
		case "medium":
			if r.TryDecodeAsNil() {
				x.Medium = ""
			} else {
				x.Medium = StorageMedium(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys527)
		} // end switch yys527
	} // end for yyj527
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj529 int
	var yyb529 bool
	var yyhl529 bool = l >= 0
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Medium = ""
	} else {
		x.Medium = StorageMedium(r.DecodeString())
	}
	for {
		yyj529++
		if yyhl529 {
			yyb529 = yyj529 > l
		} else {
			yyb529 = r.CheckBreak()
		}
		if yyb529 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj529-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GlusterfsVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym531 := z.EncBinary()
		_ = yym531
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep532 := !z.EncBinary()
			yy2arr532 := z.EncBasicHandle().StructToArray
			var yyq532 [3]bool
			_, _, _ = yysep532, yyq532, yy2arr532
			const yyr532 bool = false
			yyq532[2] = x.ReadOnly != false
			var yynn532 int
			if yyr532 || yy2arr532 {
				r.EncodeArrayStart(3)
			} else {
				yynn532 = 2
				for _, b := range yyq532 {
					if b {
						yynn532++
					}
				}
				r.EncodeMapStart(yynn532)
				yynn532 = 0
			}
			if yyr532 || yy2arr532 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym534 := z.EncBinary()
				_ = yym534
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("endpoints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym535 := z.EncBinary()
				_ = yym535
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			}
			if yyr532 || yy2arr532 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym537 := z.EncBinary()
				_ = yym537
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym538 := z.EncBinary()
				_ = yym538
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr532 || yy2arr532 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq532[2] {
					yym540 := z.EncBinary()
					_ = yym540
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq532[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym541 := z.EncBinary()
					_ = yym541
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr532 || yy2arr532 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GlusterfsVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym542 := z.DecBinary()
	_ = yym542
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct543 := r.ContainerType()
		if yyct543 == codecSelferValueTypeMap1234 {
			yyl543 := r.ReadMapStart()
			if yyl543 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl543, d)
			}
		} else if yyct543 == codecSelferValueTypeArray1234 {
			yyl543 := r.ReadArrayStart()
			if yyl543 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl543, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys544Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys544Slc
	var yyhl544 bool = l >= 0
	for yyj544 := 0; ; yyj544++ {
		if yyhl544 {
			if yyj544 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys544Slc = r.DecodeBytes(yys544Slc, true, true)
		yys544 := string(yys544Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys544 {
		case "endpoints":
			if r.TryDecodeAsNil() {
				x.EndpointsName = ""
			} else {
				x.EndpointsName = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys544)
		} // end switch yys544
	} // end for yyj544
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj548 int
	var yyb548 bool
	var yyhl548 bool = l >= 0
	yyj548++
	if yyhl548 {
		yyb548 = yyj548 > l
	} else {
		yyb548 = r.CheckBreak()
	}
	if yyb548 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EndpointsName = ""
	} else {
		x.EndpointsName = string(r.DecodeString())
	}
	yyj548++
	if yyhl548 {
		yyb548 = yyj548 > l
	} else {
		yyb548 = r.CheckBreak()
	}
	if yyb548 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj548++
	if yyhl548 {
		yyb548 = yyj548 > l
	} else {
		yyb548 = r.CheckBreak()
	}
	if yyb548 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj548++
		if yyhl548 {
			yyb548 = yyj548 > l
		} else {
			yyb548 = r.CheckBreak()
		}
		if yyb548 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj548-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RBDVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym552 := z.EncBinary()
		_ = yym552
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep553 := !z.EncBinary()
			yy2arr553 := z.EncBasicHandle().StructToArray
			var yyq553 [8]bool
			_, _, _ = yysep553, yyq553, yy2arr553
			const yyr553 bool = false
			yyq553[2] = x.FSType != ""
			yyq553[7] = x.ReadOnly != false
			var yynn553 int
			if yyr553 || yy2arr553 {
				r.EncodeArrayStart(8)
			} else {
				yynn553 = 6
				for _, b := range yyq553 {
					if b {
						yynn553++
					}
				}
				r.EncodeMapStart(yynn553)
				yynn553 = 0
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym555 := z.EncBinary()
					_ = yym555
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym556 := z.EncBinary()
					_ = yym556
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym558 := z.EncBinary()
				_ = yym558
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym559 := z.EncBinary()
				_ = yym559
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq553[2] {
					yym561 := z.EncBinary()
					_ = yym561
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq553[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym562 := z.EncBinary()
					_ = yym562
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym564 := z.EncBinary()
				_ = yym564
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pool"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym565 := z.EncBinary()
				_ = yym565
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym567 := z.EncBinary()
				_ = yym567
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("user"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym568 := z.EncBinary()
				_ = yym568
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym570 := z.EncBinary()
				_ = yym570
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("keyring"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym571 := z.EncBinary()
				_ = yym571
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SecretRef == nil {
					r.EncodeNil()
				} else {
					x.SecretRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SecretRef == nil {
					r.EncodeNil()
				} else {
					x.SecretRef.CodecEncodeSelf(e)
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq553[7] {
					yym574 := z.EncBinary()
					_ = yym574
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq553[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym575 := z.EncBinary()
					_ = yym575
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr553 || yy2arr553 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RBDVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym576 := z.DecBinary()
	_ = yym576
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct577 := r.ContainerType()
		if yyct577 == codecSelferValueTypeMap1234 {
			yyl577 := r.ReadMapStart()
			if yyl577 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl577, d)
			}
		} else if yyct577 == codecSelferValueTypeArray1234 {
			yyl577 := r.ReadArrayStart()
			if yyl577 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl577, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RBDVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys578Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys578Slc
	var yyhl578 bool = l >= 0
	for yyj578 := 0; ; yyj578++ {
		if yyhl578 {
			if yyj578 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys578Slc = r.DecodeBytes(yys578Slc, true, true)
		yys578 := string(yys578Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys578 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.CephMonitors = nil
			} else {
				yyv579 := &x.CephMonitors
				yym580 := z.DecBinary()
				_ = yym580
				if false {
				} else {
					z.F.DecSliceStringX(yyv579, false, d)
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.RBDImage = ""
			} else {
				x.RBDImage = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "pool":
			if r.TryDecodeAsNil() {
				x.RBDPool = ""
			} else {
				x.RBDPool = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.RadosUser = ""
			} else {
				x.RadosUser = string(r.DecodeString())
			}
		case "keyring":
			if r.TryDecodeAsNil() {
				x.Keyring = ""
			} else {
				x.Keyring = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys578)
		} // end switch yys578
	} // end for yyj578
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RBDVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj588 int
	var yyb588 bool
	var yyhl588 bool = l >= 0
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CephMonitors = nil
	} else {
		yyv589 := &x.CephMonitors
		yym590 := z.DecBinary()
		_ = yym590
		if false {
		} else {
			z.F.DecSliceStringX(yyv589, false, d)
		}
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDImage = ""
	} else {
		x.RBDImage = string(r.DecodeString())
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDPool = ""
	} else {
		x.RBDPool = string(r.DecodeString())
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RadosUser = ""
	} else {
		x.RadosUser = string(r.DecodeString())
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Keyring = ""
	} else {
		x.Keyring = string(r.DecodeString())
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj588++
		if yyhl588 {
			yyb588 = yyj588 > l
		} else {
			yyb588 = r.CheckBreak()
		}
		if yyb588 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj588-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CinderVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym598 := z.EncBinary()
		_ = yym598
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep599 := !z.EncBinary()
			yy2arr599 := z.EncBasicHandle().StructToArray
			var yyq599 [3]bool
			_, _, _ = yysep599, yyq599, yy2arr599
			const yyr599 bool = false
			yyq599[1] = x.FSType != ""
			yyq599[2] = x.ReadOnly != false
			var yynn599 int
			if yyr599 || yy2arr599 {
				r.EncodeArrayStart(3)
			} else {
				yynn599 = 1
				for _, b := range yyq599 {
					if b {
						yynn599++
					}
				}
				r.EncodeMapStart(yynn599)
				yynn599 = 0
			}
			if yyr599 || yy2arr599 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym601 := z.EncBinary()
				_ = yym601
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym602 := z.EncBinary()
				_ = yym602
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr599 || yy2arr599 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq599[1] {
					yym604 := z.EncBinary()
					_ = yym604
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq599[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym605 := z.EncBinary()
					_ = yym605
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr599 || yy2arr599 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq599[2] {
					yym607 := z.EncBinary()
					_ = yym607
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq599[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym608 := z.EncBinary()
					_ = yym608
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr599 || yy2arr599 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CinderVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym609 := z.DecBinary()
	_ = yym609
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct610 := r.ContainerType()
		if yyct610 == codecSelferValueTypeMap1234 {
			yyl610 := r.ReadMapStart()
			if yyl610 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl610, d)
			}
		} else if yyct610 == codecSelferValueTypeArray1234 {
			yyl610 := r.ReadArrayStart()
			if yyl610 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl610, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CinderVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys611Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys611Slc
	var yyhl611 bool = l >= 0
	for yyj611 := 0; ; yyj611++ {
		if yyhl611 {
			if yyj611 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys611Slc = r.DecodeBytes(yys611Slc, true, true)
		yys611 := string(yys611Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys611 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys611)
		} // end switch yys611
	} // end for yyj611
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CinderVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj615 int
	var yyb615 bool
	var yyhl615 bool = l >= 0
	yyj615++
	if yyhl615 {
		yyb615 = yyj615 > l
	} else {
		yyb615 = r.CheckBreak()
	}
	if yyb615 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj615++
	if yyhl615 {
		yyb615 = yyj615 > l
	} else {
		yyb615 = r.CheckBreak()
	}
	if yyb615 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj615++
	if yyhl615 {
		yyb615 = yyj615 > l
	} else {
		yyb615 = r.CheckBreak()
	}
	if yyb615 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj615++
		if yyhl615 {
			yyb615 = yyj615 > l
		} else {
			yyb615 = r.CheckBreak()
		}
		if yyb615 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj615-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CephFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym619 := z.EncBinary()
		_ = yym619
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep620 := !z.EncBinary()
			yy2arr620 := z.EncBasicHandle().StructToArray
			var yyq620 [5]bool
			_, _, _ = yysep620, yyq620, yy2arr620
			const yyr620 bool = false
			yyq620[1] = x.User != ""
			yyq620[2] = x.SecretFile != ""
			yyq620[3] = x.SecretRef != nil
			yyq620[4] = x.ReadOnly != false
			var yynn620 int
			if yyr620 || yy2arr620 {
				r.EncodeArrayStart(5)
			} else {
				yynn620 = 1
				for _, b := range yyq620 {
					if b {
						yynn620++
					}
				}
				r.EncodeMapStart(yynn620)
				yynn620 = 0
			}
			if yyr620 || yy2arr620 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym622 := z.EncBinary()
					_ = yym622
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym623 := z.EncBinary()
					_ = yym623
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			}
			if yyr620 || yy2arr620 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq620[1] {
					yym625 := z.EncBinary()
					_ = yym625
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq620[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym626 := z.EncBinary()
					_ = yym626
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr620 || yy2arr620 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq620[2] {
					yym628 := z.EncBinary()
					_ = yym628
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq620[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym629 := z.EncBinary()
					_ = yym629
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				}
			}
			if yyr620 || yy2arr620 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq620[3] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq620[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr620 || yy2arr620 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq620[4] {
					yym632 := z.EncBinary()
					_ = yym632
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq620[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym633 := z.EncBinary()
					_ = yym633
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr620 || yy2arr620 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CephFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym634 := z.DecBinary()
	_ = yym634
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct635 := r.ContainerType()
		if yyct635 == codecSelferValueTypeMap1234 {
			yyl635 := r.ReadMapStart()
			if yyl635 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl635, d)
			}
		} else if yyct635 == codecSelferValueTypeArray1234 {
			yyl635 := r.ReadArrayStart()
			if yyl635 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl635, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CephFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys636Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys636Slc
	var yyhl636 bool = l >= 0
	for yyj636 := 0; ; yyj636++ {
		if yyhl636 {
			if yyj636 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys636Slc = r.DecodeBytes(yys636Slc, true, true)
		yys636 := string(yys636Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys636 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.Monitors = nil
			} else {
				yyv637 := &x.Monitors
				yym638 := z.DecBinary()
				_ = yym638
				if false {
				} else {
					z.F.DecSliceStringX(yyv637, false, d)
				}
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "secretFile":
			if r.TryDecodeAsNil() {
				x.SecretFile = ""
			} else {
				x.SecretFile = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys636)
		} // end switch yys636
	} // end for yyj636
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CephFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj643 int
	var yyb643 bool
	var yyhl643 bool = l >= 0
	yyj643++
	if yyhl643 {
		yyb643 = yyj643 > l
	} else {
		yyb643 = r.CheckBreak()
	}
	if yyb643 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Monitors = nil
	} else {
		yyv644 := &x.Monitors
		yym645 := z.DecBinary()
		_ = yym645
		if false {
		} else {
			z.F.DecSliceStringX(yyv644, false, d)
		}
	}
	yyj643++
	if yyhl643 {
		yyb643 = yyj643 > l
	} else {
		yyb643 = r.CheckBreak()
	}
	if yyb643 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj643++
	if yyhl643 {
		yyb643 = yyj643 > l
	} else {
		yyb643 = r.CheckBreak()
	}
	if yyb643 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretFile = ""
	} else {
		x.SecretFile = string(r.DecodeString())
	}
	yyj643++
	if yyhl643 {
		yyb643 = yyj643 > l
	} else {
		yyb643 = r.CheckBreak()
	}
	if yyb643 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj643++
	if yyhl643 {
		yyb643 = yyj643 > l
	} else {
		yyb643 = r.CheckBreak()
	}
	if yyb643 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj643++
		if yyhl643 {
			yyb643 = yyj643 > l
		} else {
			yyb643 = r.CheckBreak()
		}
		if yyb643 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj643-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlockerVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym650 := z.EncBinary()
		_ = yym650
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep651 := !z.EncBinary()
			yy2arr651 := z.EncBasicHandle().StructToArray
			var yyq651 [1]bool
			_, _, _ = yysep651, yyq651, yy2arr651
			const yyr651 bool = false
			var yynn651 int
			if yyr651 || yy2arr651 {
				r.EncodeArrayStart(1)
			} else {
				yynn651 = 1
				for _, b := range yyq651 {
					if b {
						yynn651++
					}
				}
				r.EncodeMapStart(yynn651)
				yynn651 = 0
			}
			if yyr651 || yy2arr651 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym653 := z.EncBinary()
				_ = yym653
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("datasetName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym654 := z.EncBinary()
				_ = yym654
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			}
			if yyr651 || yy2arr651 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlockerVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym655 := z.DecBinary()
	_ = yym655
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct656 := r.ContainerType()
		if yyct656 == codecSelferValueTypeMap1234 {
			yyl656 := r.ReadMapStart()
			if yyl656 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl656, d)
			}
		} else if yyct656 == codecSelferValueTypeArray1234 {
			yyl656 := r.ReadArrayStart()
			if yyl656 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl656, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlockerVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys657Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys657Slc
	var yyhl657 bool = l >= 0
	for yyj657 := 0; ; yyj657++ {
		if yyhl657 {
			if yyj657 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys657Slc = r.DecodeBytes(yys657Slc, true, true)
		yys657 := string(yys657Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys657 {
		case "datasetName":
			if r.TryDecodeAsNil() {
				x.DatasetName = ""
			} else {
				x.DatasetName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys657)
		} // end switch yys657
	} // end for yyj657
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlockerVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj659 int
	var yyb659 bool
	var yyhl659 bool = l >= 0
	yyj659++
	if yyhl659 {
		yyb659 = yyj659 > l
	} else {
		yyb659 = r.CheckBreak()
	}
	if yyb659 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetName = ""
	} else {
		x.DatasetName = string(r.DecodeString())
	}
	for {
		yyj659++
		if yyhl659 {
			yyb659 = yyj659 > l
		} else {
			yyb659 = r.CheckBreak()
		}
		if yyb659 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj659-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x StorageMedium) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym661 := z.EncBinary()
	_ = yym661
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *StorageMedium) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym662 := z.DecBinary()
	_ = yym662
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Protocol) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym663 := z.EncBinary()
	_ = yym663
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Protocol) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym664 := z.DecBinary()
	_ = yym664
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym665 := z.EncBinary()
		_ = yym665
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep666 := !z.EncBinary()
			yy2arr666 := z.EncBasicHandle().StructToArray
			var yyq666 [4]bool
			_, _, _ = yysep666, yyq666, yy2arr666
			const yyr666 bool = false
			yyq666[2] = x.Partition != 0
			yyq666[3] = x.ReadOnly != false
			var yynn666 int
			if yyr666 || yy2arr666 {
				r.EncodeArrayStart(4)
			} else {
				yynn666 = 2
				for _, b := range yyq666 {
					if b {
						yynn666++
					}
				}
				r.EncodeMapStart(yynn666)
				yynn666 = 0
			}
			if yyr666 || yy2arr666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym668 := z.EncBinary()
				_ = yym668
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym669 := z.EncBinary()
				_ = yym669
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			}
			if yyr666 || yy2arr666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym671 := z.EncBinary()
				_ = yym671
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym672 := z.EncBinary()
				_ = yym672
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			}
			if yyr666 || yy2arr666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq666[2] {
					yym674 := z.EncBinary()
					_ = yym674
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq666[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym675 := z.EncBinary()
					_ = yym675
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr666 || yy2arr666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq666[3] {
					yym677 := z.EncBinary()
					_ = yym677
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq666[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym678 := z.EncBinary()
					_ = yym678
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr666 || yy2arr666 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym679 := z.DecBinary()
	_ = yym679
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct680 := r.ContainerType()
		if yyct680 == codecSelferValueTypeMap1234 {
			yyl680 := r.ReadMapStart()
			if yyl680 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl680, d)
			}
		} else if yyct680 == codecSelferValueTypeArray1234 {
			yyl680 := r.ReadArrayStart()
			if yyl680 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl680, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys681Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys681Slc
	var yyhl681 bool = l >= 0
	for yyj681 := 0; ; yyj681++ {
		if yyhl681 {
			if yyj681 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys681Slc = r.DecodeBytes(yys681Slc, true, true)
		yys681 := string(yys681Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys681 {
		case "pdName":
			if r.TryDecodeAsNil() {
				x.PDName = ""
			} else {
				x.PDName = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys681)
		} // end switch yys681
	} // end for yyj681
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj686 int
	var yyb686 bool
	var yyhl686 bool = l >= 0
	yyj686++
	if yyhl686 {
		yyb686 = yyj686 > l
	} else {
		yyb686 = r.CheckBreak()
	}
	if yyb686 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PDName = ""
	} else {
		x.PDName = string(r.DecodeString())
	}
	yyj686++
	if yyhl686 {
		yyb686 = yyj686 > l
	} else {
		yyb686 = r.CheckBreak()
	}
	if yyb686 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj686++
	if yyhl686 {
		yyb686 = yyj686 > l
	} else {
		yyb686 = r.CheckBreak()
	}
	if yyb686 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj686++
	if yyhl686 {
		yyb686 = yyj686 > l
	} else {
		yyb686 = r.CheckBreak()
	}
	if yyb686 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj686++
		if yyhl686 {
			yyb686 = yyj686 > l
		} else {
			yyb686 = r.CheckBreak()
		}
		if yyb686 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj686-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlexVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym691 := z.EncBinary()
		_ = yym691
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep692 := !z.EncBinary()
			yy2arr692 := z.EncBasicHandle().StructToArray
			var yyq692 [5]bool
			_, _, _ = yysep692, yyq692, yy2arr692
			const yyr692 bool = false
			yyq692[1] = x.FSType != ""
			yyq692[2] = x.SecretRef != nil
			yyq692[3] = x.ReadOnly != false
			yyq692[4] = len(x.Options) != 0
			var yynn692 int
			if yyr692 || yy2arr692 {
				r.EncodeArrayStart(5)
			} else {
				yynn692 = 1
				for _, b := range yyq692 {
					if b {
						yynn692++
					}
				}
				r.EncodeMapStart(yynn692)
				yynn692 = 0
			}
			if yyr692 || yy2arr692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym694 := z.EncBinary()
				_ = yym694
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("driver"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym695 := z.EncBinary()
				_ = yym695
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			}
			if yyr692 || yy2arr692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq692[1] {
					yym697 := z.EncBinary()
					_ = yym697
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq692[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym698 := z.EncBinary()
					_ = yym698
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr692 || yy2arr692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq692[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq692[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr692 || yy2arr692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq692[3] {
					yym701 := z.EncBinary()
					_ = yym701
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq692[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym702 := z.EncBinary()
					_ = yym702
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr692 || yy2arr692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq692[4] {
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym704 := z.EncBinary()
						_ = yym704
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq692[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("options"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym705 := z.EncBinary()
						_ = yym705
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				}
			}
			if yyr692 || yy2arr692 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlexVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym706 := z.DecBinary()
	_ = yym706
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct707 := r.ContainerType()
		if yyct707 == codecSelferValueTypeMap1234 {
			yyl707 := r.ReadMapStart()
			if yyl707 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl707, d)
			}
		} else if yyct707 == codecSelferValueTypeArray1234 {
			yyl707 := r.ReadArrayStart()
			if yyl707 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl707, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlexVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys708Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys708Slc
	var yyhl708 bool = l >= 0
	for yyj708 := 0; ; yyj708++ {
		if yyhl708 {
			if yyj708 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys708Slc = r.DecodeBytes(yys708Slc, true, true)
		yys708 := string(yys708Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys708 {
		case "driver":
			if r.TryDecodeAsNil() {
				x.Driver = ""
			} else {
				x.Driver = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "options":
			if r.TryDecodeAsNil() {
				x.Options = nil
			} else {
				yyv713 := &x.Options
				yym714 := z.DecBinary()
				_ = yym714
				if false {
				} else {
					z.F.DecMapStringStringX(yyv713, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys708)
		} // end switch yys708
	} // end for yyj708
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlexVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj715 int
	var yyb715 bool
	var yyhl715 bool = l >= 0
	yyj715++
	if yyhl715 {
		yyb715 = yyj715 > l
	} else {
		yyb715 = r.CheckBreak()
	}
	if yyb715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Driver = ""
	} else {
		x.Driver = string(r.DecodeString())
	}
	yyj715++
	if yyhl715 {
		yyb715 = yyj715 > l
	} else {
		yyb715 = r.CheckBreak()
	}
	if yyb715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj715++
	if yyhl715 {
		yyb715 = yyj715 > l
	} else {
		yyb715 = r.CheckBreak()
	}
	if yyb715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj715++
	if yyhl715 {
		yyb715 = yyj715 > l
	} else {
		yyb715 = r.CheckBreak()
	}
	if yyb715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj715++
	if yyhl715 {
		yyb715 = yyj715 > l
	} else {
		yyb715 = r.CheckBreak()
	}
	if yyb715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Options = nil
	} else {
		yyv720 := &x.Options
		yym721 := z.DecBinary()
		_ = yym721
		if false {
		} else {
			z.F.DecMapStringStringX(yyv720, false, d)
		}
	}
	for {
		yyj715++
		if yyhl715 {
			yyb715 = yyj715 > l
		} else {
			yyb715 = r.CheckBreak()
		}
		if yyb715 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj715-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym722 := z.EncBinary()
		_ = yym722
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep723 := !z.EncBinary()
			yy2arr723 := z.EncBasicHandle().StructToArray
			var yyq723 [4]bool
			_, _, _ = yysep723, yyq723, yy2arr723
			const yyr723 bool = false
			yyq723[2] = x.Partition != 0
			yyq723[3] = x.ReadOnly != false
			var yynn723 int
			if yyr723 || yy2arr723 {
				r.EncodeArrayStart(4)
			} else {
				yynn723 = 2
				for _, b := range yyq723 {
					if b {
						yynn723++
					}
				}
				r.EncodeMapStart(yynn723)
				yynn723 = 0
			}
			if yyr723 || yy2arr723 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym725 := z.EncBinary()
				_ = yym725
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym726 := z.EncBinary()
				_ = yym726
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr723 || yy2arr723 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym728 := z.EncBinary()
				_ = yym728
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym729 := z.EncBinary()
				_ = yym729
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			}
			if yyr723 || yy2arr723 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq723[2] {
					yym731 := z.EncBinary()
					_ = yym731
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq723[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym732 := z.EncBinary()
					_ = yym732
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr723 || yy2arr723 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq723[3] {
					yym734 := z.EncBinary()
					_ = yym734
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq723[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym735 := z.EncBinary()
					_ = yym735
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr723 || yy2arr723 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym736 := z.DecBinary()
	_ = yym736
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct737 := r.ContainerType()
		if yyct737 == codecSelferValueTypeMap1234 {
			yyl737 := r.ReadMapStart()
			if yyl737 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl737, d)
			}
		} else if yyct737 == codecSelferValueTypeArray1234 {
			yyl737 := r.ReadArrayStart()
			if yyl737 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl737, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys738Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys738Slc
	var yyhl738 bool = l >= 0
	for yyj738 := 0; ; yyj738++ {
		if yyhl738 {
			if yyj738 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys738Slc = r.DecodeBytes(yys738Slc, true, true)
		yys738 := string(yys738Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys738 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys738)
		} // end switch yys738
	} // end for yyj738
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj743 int
	var yyb743 bool
	var yyhl743 bool = l >= 0
	yyj743++
	if yyhl743 {
		yyb743 = yyj743 > l
	} else {
		yyb743 = r.CheckBreak()
	}
	if yyb743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj743++
	if yyhl743 {
		yyb743 = yyj743 > l
	} else {
		yyb743 = r.CheckBreak()
	}
	if yyb743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj743++
	if yyhl743 {
		yyb743 = yyj743 > l
	} else {
		yyb743 = r.CheckBreak()
	}
	if yyb743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj743++
	if yyhl743 {
		yyb743 = yyj743 > l
	} else {
		yyb743 = r.CheckBreak()
	}
	if yyb743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj743++
		if yyhl743 {
			yyb743 = yyj743 > l
		} else {
			yyb743 = r.CheckBreak()
		}
		if yyb743 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj743-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GitRepoVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym748 := z.EncBinary()
		_ = yym748
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep749 := !z.EncBinary()
			yy2arr749 := z.EncBasicHandle().StructToArray
			var yyq749 [3]bool
			_, _, _ = yysep749, yyq749, yy2arr749
			const yyr749 bool = false
			yyq749[1] = x.Revision != ""
			yyq749[2] = x.Directory != ""
			var yynn749 int
			if yyr749 || yy2arr749 {
				r.EncodeArrayStart(3)
			} else {
				yynn749 = 1
				for _, b := range yyq749 {
					if b {
						yynn749++
					}
				}
				r.EncodeMapStart(yynn749)
				yynn749 = 0
			}
			if yyr749 || yy2arr749 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym751 := z.EncBinary()
				_ = yym751
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("repository"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym752 := z.EncBinary()
				_ = yym752
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			}
			if yyr749 || yy2arr749 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq749[1] {
					yym754 := z.EncBinary()
					_ = yym754
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq749[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym755 := z.EncBinary()
					_ = yym755
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				}
			}
			if yyr749 || yy2arr749 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq749[2] {
					yym757 := z.EncBinary()
					_ = yym757
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq749[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("directory"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym758 := z.EncBinary()
					_ = yym758
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				}
			}
			if yyr749 || yy2arr749 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GitRepoVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym759 := z.DecBinary()
	_ = yym759
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct760 := r.ContainerType()
		if yyct760 == codecSelferValueTypeMap1234 {
			yyl760 := r.ReadMapStart()
			if yyl760 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl760, d)
			}
		} else if yyct760 == codecSelferValueTypeArray1234 {
			yyl760 := r.ReadArrayStart()
			if yyl760 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl760, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys761Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys761Slc
	var yyhl761 bool = l >= 0
	for yyj761 := 0; ; yyj761++ {
		if yyhl761 {
			if yyj761 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys761Slc = r.DecodeBytes(yys761Slc, true, true)
		yys761 := string(yys761Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys761 {
		case "repository":
			if r.TryDecodeAsNil() {
				x.Repository = ""
			} else {
				x.Repository = string(r.DecodeString())
			}
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = ""
			} else {
				x.Revision = string(r.DecodeString())
			}
		case "directory":
			if r.TryDecodeAsNil() {
				x.Directory = ""
			} else {
				x.Directory = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys761)
		} // end switch yys761
	} // end for yyj761
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj765 int
	var yyb765 bool
	var yyhl765 bool = l >= 0
	yyj765++
	if yyhl765 {
		yyb765 = yyj765 > l
	} else {
		yyb765 = r.CheckBreak()
	}
	if yyb765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Repository = ""
	} else {
		x.Repository = string(r.DecodeString())
	}
	yyj765++
	if yyhl765 {
		yyb765 = yyj765 > l
	} else {
		yyb765 = r.CheckBreak()
	}
	if yyb765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = ""
	} else {
		x.Revision = string(r.DecodeString())
	}
	yyj765++
	if yyhl765 {
		yyb765 = yyj765 > l
	} else {
		yyb765 = r.CheckBreak()
	}
	if yyb765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Directory = ""
	} else {
		x.Directory = string(r.DecodeString())
	}
	for {
		yyj765++
		if yyhl765 {
			yyb765 = yyj765 > l
		} else {
			yyb765 = r.CheckBreak()
		}
		if yyb765 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj765-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym769 := z.EncBinary()
		_ = yym769
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep770 := !z.EncBinary()
			yy2arr770 := z.EncBasicHandle().StructToArray
			var yyq770 [1]bool
			_, _, _ = yysep770, yyq770, yy2arr770
			const yyr770 bool = false
			var yynn770 int
			if yyr770 || yy2arr770 {
				r.EncodeArrayStart(1)
			} else {
				yynn770 = 1
				for _, b := range yyq770 {
					if b {
						yynn770++
					}
				}
				r.EncodeMapStart(yynn770)
				yynn770 = 0
			}
			if yyr770 || yy2arr770 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym772 := z.EncBinary()
				_ = yym772
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym773 := z.EncBinary()
				_ = yym773
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			}
			if yyr770 || yy2arr770 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym774 := z.DecBinary()
	_ = yym774
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct775 := r.ContainerType()
		if yyct775 == codecSelferValueTypeMap1234 {
			yyl775 := r.ReadMapStart()
			if yyl775 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl775, d)
			}
		} else if yyct775 == codecSelferValueTypeArray1234 {
			yyl775 := r.ReadArrayStart()
			if yyl775 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl775, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys776Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys776Slc
	var yyhl776 bool = l >= 0
	for yyj776 := 0; ; yyj776++ {
		if yyhl776 {
			if yyj776 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys776Slc = r.DecodeBytes(yys776Slc, true, true)
		yys776 := string(yys776Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys776 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys776)
		} // end switch yys776
	} // end for yyj776
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj778 int
	var yyb778 bool
	var yyhl778 bool = l >= 0
	yyj778++
	if yyhl778 {
		yyb778 = yyj778 > l
	} else {
		yyb778 = r.CheckBreak()
	}
	if yyb778 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	for {
		yyj778++
		if yyhl778 {
			yyb778 = yyj778 > l
		} else {
			yyb778 = r.CheckBreak()
		}
		if yyb778 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj778-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym780 := z.EncBinary()
		_ = yym780
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep781 := !z.EncBinary()
			yy2arr781 := z.EncBasicHandle().StructToArray
			var yyq781 [3]bool
			_, _, _ = yysep781, yyq781, yy2arr781
			const yyr781 bool = false
			yyq781[2] = x.ReadOnly != false
			var yynn781 int
			if yyr781 || yy2arr781 {
				r.EncodeArrayStart(3)
			} else {
				yynn781 = 2
				for _, b := range yyq781 {
					if b {
						yynn781++
					}
				}
				r.EncodeMapStart(yynn781)
				yynn781 = 0
			}
			if yyr781 || yy2arr781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym783 := z.EncBinary()
				_ = yym783
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("server"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym784 := z.EncBinary()
				_ = yym784
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			}
			if yyr781 || yy2arr781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym786 := z.EncBinary()
				_ = yym786
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym787 := z.EncBinary()
				_ = yym787
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr781 || yy2arr781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq781[2] {
					yym789 := z.EncBinary()
					_ = yym789
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq781[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym790 := z.EncBinary()
					_ = yym790
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr781 || yy2arr781 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym791 := z.DecBinary()
	_ = yym791
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct792 := r.ContainerType()
		if yyct792 == codecSelferValueTypeMap1234 {
			yyl792 := r.ReadMapStart()
			if yyl792 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl792, d)
			}
		} else if yyct792 == codecSelferValueTypeArray1234 {
			yyl792 := r.ReadArrayStart()
			if yyl792 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl792, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys793Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys793Slc
	var yyhl793 bool = l >= 0
	for yyj793 := 0; ; yyj793++ {
		if yyhl793 {
			if yyj793 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys793Slc = r.DecodeBytes(yys793Slc, true, true)
		yys793 := string(yys793Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys793 {
		case "server":
			if r.TryDecodeAsNil() {
				x.Server = ""
			} else {
				x.Server = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys793)
		} // end switch yys793
	} // end for yyj793
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj797 int
	var yyb797 bool
	var yyhl797 bool = l >= 0
	yyj797++
	if yyhl797 {
		yyb797 = yyj797 > l
	} else {
		yyb797 = r.CheckBreak()
	}
	if yyb797 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Server = ""
	} else {
		x.Server = string(r.DecodeString())
	}
	yyj797++
	if yyhl797 {
		yyb797 = yyj797 > l
	} else {
		yyb797 = r.CheckBreak()
	}
	if yyb797 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj797++
	if yyhl797 {
		yyb797 = yyj797 > l
	} else {
		yyb797 = r.CheckBreak()
	}
	if yyb797 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj797++
		if yyhl797 {
			yyb797 = yyj797 > l
		} else {
			yyb797 = r.CheckBreak()
		}
		if yyb797 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj797-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ISCSIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym801 := z.EncBinary()
		_ = yym801
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep802 := !z.EncBinary()
			yy2arr802 := z.EncBasicHandle().StructToArray
			var yyq802 [6]bool
			_, _, _ = yysep802, yyq802, yy2arr802
			const yyr802 bool = false
			yyq802[3] = x.ISCSIInterface != ""
			yyq802[5] = x.ReadOnly != false
			var yynn802 int
			if yyr802 || yy2arr802 {
				r.EncodeArrayStart(6)
			} else {
				yynn802 = 4
				for _, b := range yyq802 {
					if b {
						yynn802++
					}
				}
				r.EncodeMapStart(yynn802)
				yynn802 = 0
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym804 := z.EncBinary()
				_ = yym804
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPortal"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym805 := z.EncBinary()
				_ = yym805
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym807 := z.EncBinary()
				_ = yym807
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iqn"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym808 := z.EncBinary()
				_ = yym808
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym810 := z.EncBinary()
				_ = yym810
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym811 := z.EncBinary()
				_ = yym811
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq802[3] {
					yym813 := z.EncBinary()
					_ = yym813
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq802[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsiInterface"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym814 := z.EncBinary()
					_ = yym814
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				}
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym816 := z.EncBinary()
				_ = yym816
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym817 := z.EncBinary()
				_ = yym817
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq802[5] {
					yym819 := z.EncBinary()
					_ = yym819
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq802[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym820 := z.EncBinary()
					_ = yym820
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ISCSIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym821 := z.DecBinary()
	_ = yym821
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct822 := r.ContainerType()
		if yyct822 == codecSelferValueTypeMap1234 {
			yyl822 := r.ReadMapStart()
			if yyl822 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl822, d)
			}
		} else if yyct822 == codecSelferValueTypeArray1234 {
			yyl822 := r.ReadArrayStart()
			if yyl822 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl822, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys823Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys823Slc
	var yyhl823 bool = l >= 0
	for yyj823 := 0; ; yyj823++ {
		if yyhl823 {
			if yyj823 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys823Slc = r.DecodeBytes(yys823Slc, true, true)
		yys823 := string(yys823Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys823 {
		case "targetPortal":
			if r.TryDecodeAsNil() {
				x.TargetPortal = ""
			} else {
				x.TargetPortal = string(r.DecodeString())
			}
		case "iqn":
			if r.TryDecodeAsNil() {
				x.IQN = ""
			} else {
				x.IQN = string(r.DecodeString())
			}
		case "lun":
			if r.TryDecodeAsNil() {
				x.Lun = 0
			} else {
				x.Lun = int32(r.DecodeInt(32))
			}
		case "iscsiInterface":
			if r.TryDecodeAsNil() {
				x.ISCSIInterface = ""
			} else {
				x.ISCSIInterface = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys823)
		} // end switch yys823
	} // end for yyj823
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj830 int
	var yyb830 bool
	var yyhl830 bool = l >= 0
	yyj830++
	if yyhl830 {
		yyb830 = yyj830 > l
	} else {
		yyb830 = r.CheckBreak()
	}
	if yyb830 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPortal = ""
	} else {
		x.TargetPortal = string(r.DecodeString())
	}
	yyj830++
	if yyhl830 {
		yyb830 = yyj830 > l
	} else {
		yyb830 = r.CheckBreak()
	}
	if yyb830 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IQN = ""
	} else {
		x.IQN = string(r.DecodeString())
	}
	yyj830++
	if yyhl830 {
		yyb830 = yyj830 > l
	} else {
		yyb830 = r.CheckBreak()
	}
	if yyb830 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Lun = 0
	} else {
		x.Lun = int32(r.DecodeInt(32))
	}
	yyj830++
	if yyhl830 {
		yyb830 = yyj830 > l
	} else {
		yyb830 = r.CheckBreak()
	}
	if yyb830 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ISCSIInterface = ""
	} else {
		x.ISCSIInterface = string(r.DecodeString())
	}
	yyj830++
	if yyhl830 {
		yyb830 = yyj830 > l
	} else {
		yyb830 = r.CheckBreak()
	}
	if yyb830 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj830++
	if yyhl830 {
		yyb830 = yyj830 > l
	} else {
		yyb830 = r.CheckBreak()
	}
	if yyb830 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj830++
		if yyhl830 {
			yyb830 = yyj830 > l
		} else {
			yyb830 = r.CheckBreak()
		}
		if yyb830 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj830-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FCVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym837 := z.EncBinary()
		_ = yym837
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep838 := !z.EncBinary()
			yy2arr838 := z.EncBasicHandle().StructToArray
			var yyq838 [4]bool
			_, _, _ = yysep838, yyq838, yy2arr838
			const yyr838 bool = false
			yyq838[3] = x.ReadOnly != false
			var yynn838 int
			if yyr838 || yy2arr838 {
				r.EncodeArrayStart(4)
			} else {
				yynn838 = 3
				for _, b := range yyq838 {
					if b {
						yynn838++
					}
				}
				r.EncodeMapStart(yynn838)
				yynn838 = 0
			}
			if yyr838 || yy2arr838 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym840 := z.EncBinary()
					_ = yym840
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetWWNs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym841 := z.EncBinary()
					_ = yym841
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			}
			if yyr838 || yy2arr838 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy843 := *x.Lun
					yym844 := z.EncBinary()
					_ = yym844
					if false {
					} else {
						r.EncodeInt(int64(yy843))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy845 := *x.Lun
					yym846 := z.EncBinary()
					_ = yym846
					if false {
					} else {
						r.EncodeInt(int64(yy845))
					}
				}
			}
			if yyr838 || yy2arr838 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym848 := z.EncBinary()
				_ = yym848
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym849 := z.EncBinary()
				_ = yym849
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
				}
			}
			if yyr838 || yy2arr838 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq838[3] {
					yym851 := z.EncBinary()
					_ = yym851
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq838[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym852 := z.EncBinary()
					_ = yym852
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr838 || yy2arr838 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FCVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym853 := z.DecBinary()
	_ = yym853
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct854 := r.ContainerType()
		if yyct854 == codecSelferValueTypeMap1234 {
			yyl854 := r.ReadMapStart()
			if yyl854 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl854, d)
			}
		} else if yyct854 == codecSelferValueTypeArray1234 {
			yyl854 := r.ReadArrayStart()
			if yyl854 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl854, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FCVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys855Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys855Slc
	var yyhl855 bool = l >= 0
	for yyj855 := 0; ; yyj855++ {
		if yyhl855 {
			if yyj855 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys855Slc = r.DecodeBytes(yys855Slc, true, true)
		yys855 := string(yys855Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys855 {
		case "targetWWNs":
			if r.TryDecodeAsNil() {
				x.TargetWWNs = nil
			} else {
				yyv856 := &x.TargetWWNs
				yym857 := z.DecBinary()
				_ = yym857
				if false {
				} else {
					z.F.DecSliceStringX(yyv856, false, d)
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				if x.Lun != nil {
					x.Lun = nil
				}
			} else {
				if x.Lun == nil {
					x.Lun = new(int32)
				}
				yym859 := z.DecBinary()
				_ = yym859
				if false {
				} else {
					*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys855)
		} // end switch yys855
	} // end for yyj855
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FCVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj862 int
	var yyb862 bool
	var yyhl862 bool = l >= 0
	yyj862++
	if yyhl862 {
		yyb862 = yyj862 > l
	} else {
		yyb862 = r.CheckBreak()
	}
	if yyb862 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetWWNs = nil
	} else {
		yyv863 := &x.TargetWWNs
		yym864 := z.DecBinary()
		_ = yym864
		if false {
		} else {
			z.F.DecSliceStringX(yyv863, false, d)
		}
	}
	yyj862++
	if yyhl862 {
		yyb862 = yyj862 > l
	} else {
		yyb862 = r.CheckBreak()
	}
	if yyb862 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lun != nil {
			x.Lun = nil
		}
	} else {
		if x.Lun == nil {
			x.Lun = new(int32)
		}
		yym866 := z.DecBinary()
		_ = yym866
		if false {
		} else {
			*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
		}
	}
	yyj862++
	if yyhl862 {
		yyb862 = yyj862 > l
	} else {
		yyb862 = r.CheckBreak()
	}
	if yyb862 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj862++
	if yyhl862 {
		yyb862 = yyj862 > l
	} else {
		yyb862 = r.CheckBreak()
	}
	if yyb862 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj862++
		if yyhl862 {
			yyb862 = yyj862 > l
		} else {
			yyb862 = r.CheckBreak()
		}
		if yyb862 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj862-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym869 := z.EncBinary()
		_ = yym869
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep870 := !z.EncBinary()
			yy2arr870 := z.EncBasicHandle().StructToArray
			var yyq870 [5]bool
			_, _, _ = yysep870, yyq870, yy2arr870
			const yyr870 bool = false
			yyq870[0] = x.Name != ""
			yyq870[1] = x.HostPort != 0
			yyq870[3] = x.Protocol != ""
			yyq870[4] = x.HostIP != ""
			var yynn870 int
			if yyr870 || yy2arr870 {
				r.EncodeArrayStart(5)
			} else {
				yynn870 = 1
				for _, b := range yyq870 {
					if b {
						yynn870++
					}
				}
				r.EncodeMapStart(yynn870)
				yynn870 = 0
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq870[0] {
					yym872 := z.EncBinary()
					_ = yym872
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq870[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym873 := z.EncBinary()
					_ = yym873
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq870[1] {
					yym875 := z.EncBinary()
					_ = yym875
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq870[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym876 := z.EncBinary()
					_ = yym876
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				}
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym878 := z.EncBinary()
				_ = yym878
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym879 := z.EncBinary()
				_ = yym879
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq870[3] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq870[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq870[4] {
					yym882 := z.EncBinary()
					_ = yym882
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq870[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym883 := z.EncBinary()
					_ = yym883
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr870 || yy2arr870 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym884 := z.DecBinary()
	_ = yym884
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct885 := r.ContainerType()
		if yyct885 == codecSelferValueTypeMap1234 {
			yyl885 := r.ReadMapStart()
			if yyl885 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl885, d)
			}
		} else if yyct885 == codecSelferValueTypeArray1234 {
			yyl885 := r.ReadArrayStart()
			if yyl885 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl885, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys886Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys886Slc
	var yyhl886 bool = l >= 0
	for yyj886 := 0; ; yyj886++ {
		if yyhl886 {
			if yyj886 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys886Slc = r.DecodeBytes(yys886Slc, true, true)
		yys886 := string(yys886Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys886 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPort":
			if r.TryDecodeAsNil() {
				x.HostPort = 0
			} else {
				x.HostPort = int32(r.DecodeInt(32))
			}
		case "containerPort":
			if r.TryDecodeAsNil() {
				x.ContainerPort = 0
			} else {
				x.ContainerPort = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys886)
		} // end switch yys886
	} // end for yyj886
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj892 int
	var yyb892 bool
	var yyhl892 bool = l >= 0
	yyj892++
	if yyhl892 {
		yyb892 = yyj892 > l
	} else {
		yyb892 = r.CheckBreak()
	}
	if yyb892 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj892++
	if yyhl892 {
		yyb892 = yyj892 > l
	} else {
		yyb892 = r.CheckBreak()
	}
	if yyb892 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPort = 0
	} else {
		x.HostPort = int32(r.DecodeInt(32))
	}
	yyj892++
	if yyhl892 {
		yyb892 = yyj892 > l
	} else {
		yyb892 = r.CheckBreak()
	}
	if yyb892 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerPort = 0
	} else {
		x.ContainerPort = int32(r.DecodeInt(32))
	}
	yyj892++
	if yyhl892 {
		yyb892 = yyj892 > l
	} else {
		yyb892 = r.CheckBreak()
	}
	if yyb892 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj892++
	if yyhl892 {
		yyb892 = yyj892 > l
	} else {
		yyb892 = r.CheckBreak()
	}
	if yyb892 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	for {
		yyj892++
		if yyhl892 {
			yyb892 = yyj892 > l
		} else {
			yyb892 = r.CheckBreak()
		}
		if yyb892 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj892-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeMount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym898 := z.EncBinary()
		_ = yym898
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep899 := !z.EncBinary()
			yy2arr899 := z.EncBasicHandle().StructToArray
			var yyq899 [3]bool
			_, _, _ = yysep899, yyq899, yy2arr899
			const yyr899 bool = false
			yyq899[1] = x.ReadOnly != false
			var yynn899 int
			if yyr899 || yy2arr899 {
				r.EncodeArrayStart(3)
			} else {
				yynn899 = 2
				for _, b := range yyq899 {
					if b {
						yynn899++
					}
				}
				r.EncodeMapStart(yynn899)
				yynn899 = 0
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym901 := z.EncBinary()
				_ = yym901
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym902 := z.EncBinary()
				_ = yym902
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq899[1] {
					yym904 := z.EncBinary()
					_ = yym904
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq899[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym905 := z.EncBinary()
					_ = yym905
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym907 := z.EncBinary()
				_ = yym907
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mountPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym908 := z.EncBinary()
				_ = yym908
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			}
			if yyr899 || yy2arr899 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeMount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym909 := z.DecBinary()
	_ = yym909
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct910 := r.ContainerType()
		if yyct910 == codecSelferValueTypeMap1234 {
			yyl910 := r.ReadMapStart()
			if yyl910 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl910, d)
			}
		} else if yyct910 == codecSelferValueTypeArray1234 {
			yyl910 := r.ReadArrayStart()
			if yyl910 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl910, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeMount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys911Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys911Slc
	var yyhl911 bool = l >= 0
	for yyj911 := 0; ; yyj911++ {
		if yyhl911 {
			if yyj911 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys911Slc = r.DecodeBytes(yys911Slc, true, true)
		yys911 := string(yys911Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys911 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "mountPath":
			if r.TryDecodeAsNil() {
				x.MountPath = ""
			} else {
				x.MountPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys911)
		} // end switch yys911
	} // end for yyj911
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeMount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj915 int
	var yyb915 bool
	var yyhl915 bool = l >= 0
	yyj915++
	if yyhl915 {
		yyb915 = yyj915 > l
	} else {
		yyb915 = r.CheckBreak()
	}
	if yyb915 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj915++
	if yyhl915 {
		yyb915 = yyj915 > l
	} else {
		yyb915 = r.CheckBreak()
	}
	if yyb915 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj915++
	if yyhl915 {
		yyb915 = yyj915 > l
	} else {
		yyb915 = r.CheckBreak()
	}
	if yyb915 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MountPath = ""
	} else {
		x.MountPath = string(r.DecodeString())
	}
	for {
		yyj915++
		if yyhl915 {
			yyb915 = yyj915 > l
		} else {
			yyb915 = r.CheckBreak()
		}
		if yyb915 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj915-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVar) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym919 := z.EncBinary()
		_ = yym919
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep920 := !z.EncBinary()
			yy2arr920 := z.EncBasicHandle().StructToArray
			var yyq920 [3]bool
			_, _, _ = yysep920, yyq920, yy2arr920
			const yyr920 bool = false
			yyq920[1] = x.Value != ""
			yyq920[2] = x.ValueFrom != nil
			var yynn920 int
			if yyr920 || yy2arr920 {
				r.EncodeArrayStart(3)
			} else {
				yynn920 = 1
				for _, b := range yyq920 {
					if b {
						yynn920++
					}
				}
				r.EncodeMapStart(yynn920)
				yynn920 = 0
			}
			if yyr920 || yy2arr920 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym922 := z.EncBinary()
				_ = yym922
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym923 := z.EncBinary()
				_ = yym923
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr920 || yy2arr920 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq920[1] {
					yym925 := z.EncBinary()
					_ = yym925
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq920[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym926 := z.EncBinary()
					_ = yym926
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr920 || yy2arr920 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq920[2] {
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq920[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("valueFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				}
			}
			if yyr920 || yy2arr920 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVar) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym928 := z.DecBinary()
	_ = yym928
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct929 := r.ContainerType()
		if yyct929 == codecSelferValueTypeMap1234 {
			yyl929 := r.ReadMapStart()
			if yyl929 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl929, d)
			}
		} else if yyct929 == codecSelferValueTypeArray1234 {
			yyl929 := r.ReadArrayStart()
			if yyl929 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl929, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVar) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys930Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys930Slc
	var yyhl930 bool = l >= 0
	for yyj930 := 0; ; yyj930++ {
		if yyhl930 {
			if yyj930 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys930Slc = r.DecodeBytes(yys930Slc, true, true)
		yys930 := string(yys930Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys930 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "valueFrom":
			if r.TryDecodeAsNil() {
				if x.ValueFrom != nil {
					x.ValueFrom = nil
				}
			} else {
				if x.ValueFrom == nil {
					x.ValueFrom = new(EnvVarSource)
				}
				x.ValueFrom.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys930)
		} // end switch yys930
	} // end for yyj930
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVar) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj934 int
	var yyb934 bool
	var yyhl934 bool = l >= 0
	yyj934++
	if yyhl934 {
		yyb934 = yyj934 > l
	} else {
		yyb934 = r.CheckBreak()
	}
	if yyb934 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj934++
	if yyhl934 {
		yyb934 = yyj934 > l
	} else {
		yyb934 = r.CheckBreak()
	}
	if yyb934 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj934++
	if yyhl934 {
		yyb934 = yyj934 > l
	} else {
		yyb934 = r.CheckBreak()
	}
	if yyb934 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ValueFrom != nil {
			x.ValueFrom = nil
		}
	} else {
		if x.ValueFrom == nil {
			x.ValueFrom = new(EnvVarSource)
		}
		x.ValueFrom.CodecDecodeSelf(d)
	}
	for {
		yyj934++
		if yyhl934 {
			yyb934 = yyj934 > l
		} else {
			yyb934 = r.CheckBreak()
		}
		if yyb934 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj934-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVarSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym938 := z.EncBinary()
		_ = yym938
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep939 := !z.EncBinary()
			yy2arr939 := z.EncBasicHandle().StructToArray
			var yyq939 [1]bool
			_, _, _ = yysep939, yyq939, yy2arr939
			const yyr939 bool = false
			var yynn939 int
			if yyr939 || yy2arr939 {
				r.EncodeArrayStart(1)
			} else {
				yynn939 = 1
				for _, b := range yyq939 {
					if b {
						yynn939++
					}
				}
				r.EncodeMapStart(yynn939)
				yynn939 = 0
			}
			if yyr939 || yy2arr939 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.FieldRef == nil {
					r.EncodeNil()
				} else {
					x.FieldRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.FieldRef == nil {
					r.EncodeNil()
				} else {
					x.FieldRef.CodecEncodeSelf(e)
				}
			}
			if yyr939 || yy2arr939 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVarSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym941 := z.DecBinary()
	_ = yym941
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct942 := r.ContainerType()
		if yyct942 == codecSelferValueTypeMap1234 {
			yyl942 := r.ReadMapStart()
			if yyl942 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl942, d)
			}
		} else if yyct942 == codecSelferValueTypeArray1234 {
			yyl942 := r.ReadArrayStart()
			if yyl942 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl942, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVarSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys943Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys943Slc
	var yyhl943 bool = l >= 0
	for yyj943 := 0; ; yyj943++ {
		if yyhl943 {
			if yyj943 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys943Slc = r.DecodeBytes(yys943Slc, true, true)
		yys943 := string(yys943Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys943 {
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys943)
		} // end switch yys943
	} // end for yyj943
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVarSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj945 int
	var yyb945 bool
	var yyhl945 bool = l >= 0
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	for {
		yyj945++
		if yyhl945 {
			yyb945 = yyj945 > l
		} else {
			yyb945 = r.CheckBreak()
		}
		if yyb945 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj945-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym947 := z.EncBinary()
		_ = yym947
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep948 := !z.EncBinary()
			yy2arr948 := z.EncBasicHandle().StructToArray
			var yyq948 [2]bool
			_, _, _ = yysep948, yyq948, yy2arr948
			const yyr948 bool = false
			yyq948[0] = x.APIVersion != ""
			var yynn948 int
			if yyr948 || yy2arr948 {
				r.EncodeArrayStart(2)
			} else {
				yynn948 = 1
				for _, b := range yyq948 {
					if b {
						yynn948++
					}
				}
				r.EncodeMapStart(yynn948)
				yynn948 = 0
			}
			if yyr948 || yy2arr948 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq948[0] {
					yym950 := z.EncBinary()
					_ = yym950
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq948[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym951 := z.EncBinary()
					_ = yym951
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr948 || yy2arr948 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym953 := z.EncBinary()
				_ = yym953
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym954 := z.EncBinary()
				_ = yym954
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			}
			if yyr948 || yy2arr948 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym955 := z.DecBinary()
	_ = yym955
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct956 := r.ContainerType()
		if yyct956 == codecSelferValueTypeMap1234 {
			yyl956 := r.ReadMapStart()
			if yyl956 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl956, d)
			}
		} else if yyct956 == codecSelferValueTypeArray1234 {
			yyl956 := r.ReadArrayStart()
			if yyl956 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl956, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys957Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys957Slc
	var yyhl957 bool = l >= 0
	for yyj957 := 0; ; yyj957++ {
		if yyhl957 {
			if yyj957 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys957Slc = r.DecodeBytes(yys957Slc, true, true)
		yys957 := string(yys957Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys957 {
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys957)
		} // end switch yys957
	} // end for yyj957
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj960 int
	var yyb960 bool
	var yyhl960 bool = l >= 0
	yyj960++
	if yyhl960 {
		yyb960 = yyj960 > l
	} else {
		yyb960 = r.CheckBreak()
	}
	if yyb960 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj960++
	if yyhl960 {
		yyb960 = yyj960 > l
	} else {
		yyb960 = r.CheckBreak()
	}
	if yyb960 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj960++
		if yyhl960 {
			yyb960 = yyj960 > l
		} else {
			yyb960 = r.CheckBreak()
		}
		if yyb960 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj960-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPGetAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym963 := z.EncBinary()
		_ = yym963
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep964 := !z.EncBinary()
			yy2arr964 := z.EncBasicHandle().StructToArray
			var yyq964 [4]bool
			_, _, _ = yysep964, yyq964, yy2arr964
			const yyr964 bool = false
			yyq964[0] = x.Path != ""
			yyq964[2] = x.Host != ""
			yyq964[3] = x.Scheme != ""
			var yynn964 int
			if yyr964 || yy2arr964 {
				r.EncodeArrayStart(4)
			} else {
				yynn964 = 1
				for _, b := range yyq964 {
					if b {
						yynn964++
					}
				}
				r.EncodeMapStart(yynn964)
				yynn964 = 0
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[0] {
					yym966 := z.EncBinary()
					_ = yym966
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq964[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym967 := z.EncBinary()
					_ = yym967
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy969 := &x.Port
				yym970 := z.EncBinary()
				_ = yym970
				if false {
				} else if z.HasExtensions() && z.EncExt(yy969) {
				} else if !yym970 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy969)
				} else {
					z.EncFallback(yy969)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy971 := &x.Port
				yym972 := z.EncBinary()
				_ = yym972
				if false {
				} else if z.HasExtensions() && z.EncExt(yy971) {
				} else if !yym972 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy971)
				} else {
					z.EncFallback(yy971)
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[2] {
					yym974 := z.EncBinary()
					_ = yym974
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq964[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym975 := z.EncBinary()
					_ = yym975
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[3] {
					x.Scheme.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq964[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scheme"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Scheme.CodecEncodeSelf(e)
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPGetAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym977 := z.DecBinary()
	_ = yym977
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct978 := r.ContainerType()
		if yyct978 == codecSelferValueTypeMap1234 {
			yyl978 := r.ReadMapStart()
			if yyl978 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl978, d)
			}
		} else if yyct978 == codecSelferValueTypeArray1234 {
			yyl978 := r.ReadArrayStart()
			if yyl978 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl978, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPGetAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys979Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys979Slc
	var yyhl979 bool = l >= 0
	for yyj979 := 0; ; yyj979++ {
		if yyhl979 {
			if yyj979 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys979Slc = r.DecodeBytes(yys979Slc, true, true)
		yys979 := string(yys979Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys979 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg5_intstr.IntOrString{}
			} else {
				yyv981 := &x.Port
				yym982 := z.DecBinary()
				_ = yym982
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv981) {
				} else if !yym982 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv981)
				} else {
					z.DecFallback(yyv981, false)
				}
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "scheme":
			if r.TryDecodeAsNil() {
				x.Scheme = ""
			} else {
				x.Scheme = URIScheme(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys979)
		} // end switch yys979
	} // end for yyj979
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPGetAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj985 int
	var yyb985 bool
	var yyhl985 bool = l >= 0
	yyj985++
	if yyhl985 {
		yyb985 = yyj985 > l
	} else {
		yyb985 = r.CheckBreak()
	}
	if yyb985 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj985++
	if yyhl985 {
		yyb985 = yyj985 > l
	} else {
		yyb985 = r.CheckBreak()
	}
	if yyb985 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg5_intstr.IntOrString{}
	} else {
		yyv987 := &x.Port
		yym988 := z.DecBinary()
		_ = yym988
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv987) {
		} else if !yym988 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv987)
		} else {
			z.DecFallback(yyv987, false)
		}
	}
	yyj985++
	if yyhl985 {
		yyb985 = yyj985 > l
	} else {
		yyb985 = r.CheckBreak()
	}
	if yyb985 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	yyj985++
	if yyhl985 {
		yyb985 = yyj985 > l
	} else {
		yyb985 = r.CheckBreak()
	}
	if yyb985 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Scheme = ""
	} else {
		x.Scheme = URIScheme(r.DecodeString())
	}
	for {
		yyj985++
		if yyhl985 {
			yyb985 = yyj985 > l
		} else {
			yyb985 = r.CheckBreak()
		}
		if yyb985 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj985-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x URIScheme) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym991 := z.EncBinary()
	_ = yym991
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *URIScheme) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym992 := z.DecBinary()
	_ = yym992
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *TCPSocketAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym993 := z.EncBinary()
		_ = yym993
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep994 := !z.EncBinary()
			yy2arr994 := z.EncBasicHandle().StructToArray
			var yyq994 [1]bool
			_, _, _ = yysep994, yyq994, yy2arr994
			const yyr994 bool = false
			var yynn994 int
			if yyr994 || yy2arr994 {
				r.EncodeArrayStart(1)
			} else {
				yynn994 = 1
				for _, b := range yyq994 {
					if b {
						yynn994++
					}
				}
				r.EncodeMapStart(yynn994)
				yynn994 = 0
			}
			if yyr994 || yy2arr994 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy996 := &x.Port
				yym997 := z.EncBinary()
				_ = yym997
				if false {
				} else if z.HasExtensions() && z.EncExt(yy996) {
				} else if !yym997 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy996)
				} else {
					z.EncFallback(yy996)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy998 := &x.Port
				yym999 := z.EncBinary()
				_ = yym999
				if false {
				} else if z.HasExtensions() && z.EncExt(yy998) {
				} else if !yym999 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy998)
				} else {
					z.EncFallback(yy998)
				}
			}
			if yyr994 || yy2arr994 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TCPSocketAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1000 := z.DecBinary()
	_ = yym1000
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1001 := r.ContainerType()
		if yyct1001 == codecSelferValueTypeMap1234 {
			yyl1001 := r.ReadMapStart()
			if yyl1001 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1001, d)
			}
		} else if yyct1001 == codecSelferValueTypeArray1234 {
			yyl1001 := r.ReadArrayStart()
			if yyl1001 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1001, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TCPSocketAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1002Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1002Slc
	var yyhl1002 bool = l >= 0
	for yyj1002 := 0; ; yyj1002++ {
		if yyhl1002 {
			if yyj1002 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1002Slc = r.DecodeBytes(yys1002Slc, true, true)
		yys1002 := string(yys1002Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1002 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg5_intstr.IntOrString{}
			} else {
				yyv1003 := &x.Port
				yym1004 := z.DecBinary()
				_ = yym1004
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1003) {
				} else if !yym1004 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1003)
				} else {
					z.DecFallback(yyv1003, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1002)
		} // end switch yys1002
	} // end for yyj1002
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TCPSocketAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1005 int
	var yyb1005 bool
	var yyhl1005 bool = l >= 0
	yyj1005++
	if yyhl1005 {
		yyb1005 = yyj1005 > l
	} else {
		yyb1005 = r.CheckBreak()
	}
	if yyb1005 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg5_intstr.IntOrString{}
	} else {
		yyv1006 := &x.Port
		yym1007 := z.DecBinary()
		_ = yym1007
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1006) {
		} else if !yym1007 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1006)
		} else {
			z.DecFallback(yyv1006, false)
		}
	}
	for {
		yyj1005++
		if yyhl1005 {
			yyb1005 = yyj1005 > l
		} else {
			yyb1005 = r.CheckBreak()
		}
		if yyb1005 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1005-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExecAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1008 := z.EncBinary()
		_ = yym1008
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1009 := !z.EncBinary()
			yy2arr1009 := z.EncBasicHandle().StructToArray
			var yyq1009 [1]bool
			_, _, _ = yysep1009, yyq1009, yy2arr1009
			const yyr1009 bool = false
			yyq1009[0] = len(x.Command) != 0
			var yynn1009 int
			if yyr1009 || yy2arr1009 {
				r.EncodeArrayStart(1)
			} else {
				yynn1009 = 0
				for _, b := range yyq1009 {
					if b {
						yynn1009++
					}
				}
				r.EncodeMapStart(yynn1009)
				yynn1009 = 0
			}
			if yyr1009 || yy2arr1009 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1009[0] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1011 := z.EncBinary()
						_ = yym1011
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1009[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1012 := z.EncBinary()
						_ = yym1012
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1009 || yy2arr1009 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExecAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1013 := z.DecBinary()
	_ = yym1013
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1014 := r.ContainerType()
		if yyct1014 == codecSelferValueTypeMap1234 {
			yyl1014 := r.ReadMapStart()
			if yyl1014 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1014, d)
			}
		} else if yyct1014 == codecSelferValueTypeArray1234 {
			yyl1014 := r.ReadArrayStart()
			if yyl1014 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1014, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExecAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1015Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1015Slc
	var yyhl1015 bool = l >= 0
	for yyj1015 := 0; ; yyj1015++ {
		if yyhl1015 {
			if yyj1015 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1015Slc = r.DecodeBytes(yys1015Slc, true, true)
		yys1015 := string(yys1015Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1015 {
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1016 := &x.Command
				yym1017 := z.DecBinary()
				_ = yym1017
				if false {
				} else {
					z.F.DecSliceStringX(yyv1016, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1015)
		} // end switch yys1015
	} // end for yyj1015
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExecAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1018 int
	var yyb1018 bool
	var yyhl1018 bool = l >= 0
	yyj1018++
	if yyhl1018 {
		yyb1018 = yyj1018 > l
	} else {
		yyb1018 = r.CheckBreak()
	}
	if yyb1018 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1019 := &x.Command
		yym1020 := z.DecBinary()
		_ = yym1020
		if false {
		} else {
			z.F.DecSliceStringX(yyv1019, false, d)
		}
	}
	for {
		yyj1018++
		if yyhl1018 {
			yyb1018 = yyj1018 > l
		} else {
			yyb1018 = r.CheckBreak()
		}
		if yyb1018 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1018-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Probe) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1021 := z.EncBinary()
		_ = yym1021
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1022 := !z.EncBinary()
			yy2arr1022 := z.EncBasicHandle().StructToArray
			var yyq1022 [8]bool
			_, _, _ = yysep1022, yyq1022, yy2arr1022
			const yyr1022 bool = false
			yyq1022[0] = x.Handler.Exec != nil && x.Exec != nil
			yyq1022[1] = x.Handler.HTTPGet != nil && x.HTTPGet != nil
			yyq1022[2] = x.Handler.TCPSocket != nil && x.TCPSocket != nil
			yyq1022[3] = x.InitialDelaySeconds != 0
			yyq1022[4] = x.TimeoutSeconds != 0
			yyq1022[5] = x.PeriodSeconds != 0
			yyq1022[6] = x.SuccessThreshold != 0
			yyq1022[7] = x.FailureThreshold != 0
			var yynn1022 int
			if yyr1022 || yy2arr1022 {
				r.EncodeArrayStart(8)
			} else {
				yynn1022 = 0
				for _, b := range yyq1022 {
					if b {
						yynn1022++
					}
				}
				r.EncodeMapStart(yynn1022)
				yynn1022 = 0
			}
			var yyn1023 bool
			if x.Handler.Exec == nil {
				yyn1023 = true
				goto LABEL1023
			}
		LABEL1023:
			if yyr1022 || yy2arr1022 {
				if yyn1023 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1022[0] {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1022[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1023 {
						r.EncodeNil()
					} else {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1024 bool
			if x.Handler.HTTPGet == nil {
				yyn1024 = true
				goto LABEL1024
			}
		LABEL1024:
			if yyr1022 || yy2arr1022 {
				if yyn1024 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1022[1] {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1022[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1024 {
						r.EncodeNil()
					} else {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1025 bool
			if x.Handler.TCPSocket == nil {
				yyn1025 = true
				goto LABEL1025
			}
		LABEL1025:
			if yyr1022 || yy2arr1022 {
				if yyn1025 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1022[2] {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1022[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1025 {
						r.EncodeNil()
					} else {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1022 || yy2arr1022 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1022[3] {
					yym1027 := z.EncBinary()
					_ = yym1027
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1022[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initialDelaySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1028 := z.EncBinary()
					_ = yym1028
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				}
			}
			if yyr1022 || yy2arr1022 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1022[4] {
					yym1030 := z.EncBinary()
					_ = yym1030
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1022[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1031 := z.EncBinary()
					_ = yym1031
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				}
			}
			if yyr1022 || yy2arr1022 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1022[5] {
					yym1033 := z.EncBinary()
					_ = yym1033
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1022[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("periodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1034 := z.EncBinary()
					_ = yym1034
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				}
			}
			if yyr1022 || yy2arr1022 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1022[6] {
					yym1036 := z.EncBinary()
					_ = yym1036
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1022[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("successThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1037 := z.EncBinary()
					_ = yym1037
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				}
			}
			if yyr1022 || yy2arr1022 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1022[7] {
					yym1039 := z.EncBinary()
					_ = yym1039
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1022[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failureThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1040 := z.EncBinary()
					_ = yym1040
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				}
			}
			if yyr1022 || yy2arr1022 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Probe) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1041 := z.DecBinary()
	_ = yym1041
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1042 := r.ContainerType()
		if yyct1042 == codecSelferValueTypeMap1234 {
			yyl1042 := r.ReadMapStart()
			if yyl1042 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1042, d)
			}
		} else if yyct1042 == codecSelferValueTypeArray1234 {
			yyl1042 := r.ReadArrayStart()
			if yyl1042 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1042, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Probe) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1043Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1043Slc
	var yyhl1043 bool = l >= 0
	for yyj1043 := 0; ; yyj1043++ {
		if yyhl1043 {
			if yyj1043 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1043Slc = r.DecodeBytes(yys1043Slc, true, true)
		yys1043 := string(yys1043Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1043 {
		case "exec":
			if x.Handler.Exec == nil {
				x.Handler.Exec = new(ExecAction)
			}
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if x.Handler.HTTPGet == nil {
				x.Handler.HTTPGet = new(HTTPGetAction)
			}
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if x.Handler.TCPSocket == nil {
				x.Handler.TCPSocket = new(TCPSocketAction)
			}
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		case "initialDelaySeconds":
			if r.TryDecodeAsNil() {
				x.InitialDelaySeconds = 0
			} else {
				x.InitialDelaySeconds = int32(r.DecodeInt(32))
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				x.TimeoutSeconds = 0
			} else {
				x.TimeoutSeconds = int32(r.DecodeInt(32))
			}
		case "periodSeconds":
			if r.TryDecodeAsNil() {
				x.PeriodSeconds = 0
			} else {
				x.PeriodSeconds = int32(r.DecodeInt(32))
			}
		case "successThreshold":
			if r.TryDecodeAsNil() {
				x.SuccessThreshold = 0
			} else {
				x.SuccessThreshold = int32(r.DecodeInt(32))
			}
		case "failureThreshold":
			if r.TryDecodeAsNil() {
				x.FailureThreshold = 0
			} else {
				x.FailureThreshold = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1043)
		} // end switch yys1043
	} // end for yyj1043
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Probe) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1052 int
	var yyb1052 bool
	var yyhl1052 bool = l >= 0
	if x.Handler.Exec == nil {
		x.Handler.Exec = new(ExecAction)
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	if x.Handler.HTTPGet == nil {
		x.Handler.HTTPGet = new(HTTPGetAction)
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	if x.Handler.TCPSocket == nil {
		x.Handler.TCPSocket = new(TCPSocketAction)
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitialDelaySeconds = 0
	} else {
		x.InitialDelaySeconds = int32(r.DecodeInt(32))
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeoutSeconds = 0
	} else {
		x.TimeoutSeconds = int32(r.DecodeInt(32))
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PeriodSeconds = 0
	} else {
		x.PeriodSeconds = int32(r.DecodeInt(32))
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SuccessThreshold = 0
	} else {
		x.SuccessThreshold = int32(r.DecodeInt(32))
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureThreshold = 0
	} else {
		x.FailureThreshold = int32(r.DecodeInt(32))
	}
	for {
		yyj1052++
		if yyhl1052 {
			yyb1052 = yyj1052 > l
		} else {
			yyb1052 = r.CheckBreak()
		}
		if yyb1052 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1052-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PullPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1061 := z.EncBinary()
	_ = yym1061
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PullPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1062 := z.DecBinary()
	_ = yym1062
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Capability) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1063 := z.EncBinary()
	_ = yym1063
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Capability) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1064 := z.DecBinary()
	_ = yym1064
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Capabilities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1065 := z.EncBinary()
		_ = yym1065
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1066 := !z.EncBinary()
			yy2arr1066 := z.EncBasicHandle().StructToArray
			var yyq1066 [2]bool
			_, _, _ = yysep1066, yyq1066, yy2arr1066
			const yyr1066 bool = false
			yyq1066[0] = len(x.Add) != 0
			yyq1066[1] = len(x.Drop) != 0
			var yynn1066 int
			if yyr1066 || yy2arr1066 {
				r.EncodeArrayStart(2)
			} else {
				yynn1066 = 0
				for _, b := range yyq1066 {
					if b {
						yynn1066++
					}
				}
				r.EncodeMapStart(yynn1066)
				yynn1066 = 0
			}
			if yyr1066 || yy2arr1066 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1066[0] {
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1068 := z.EncBinary()
						_ = yym1068
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1066[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("add"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1069 := z.EncBinary()
						_ = yym1069
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				}
			}
			if yyr1066 || yy2arr1066 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1066[1] {
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1071 := z.EncBinary()
						_ = yym1071
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1066[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("drop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1072 := z.EncBinary()
						_ = yym1072
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				}
			}
			if yyr1066 || yy2arr1066 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Capabilities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1073 := z.DecBinary()
	_ = yym1073
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1074 := r.ContainerType()
		if yyct1074 == codecSelferValueTypeMap1234 {
			yyl1074 := r.ReadMapStart()
			if yyl1074 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1074, d)
			}
		} else if yyct1074 == codecSelferValueTypeArray1234 {
			yyl1074 := r.ReadArrayStart()
			if yyl1074 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1074, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Capabilities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1075Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1075Slc
	var yyhl1075 bool = l >= 0
	for yyj1075 := 0; ; yyj1075++ {
		if yyhl1075 {
			if yyj1075 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1075Slc = r.DecodeBytes(yys1075Slc, true, true)
		yys1075 := string(yys1075Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1075 {
		case "add":
			if r.TryDecodeAsNil() {
				x.Add = nil
			} else {
				yyv1076 := &x.Add
				yym1077 := z.DecBinary()
				_ = yym1077
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1076), d)
				}
			}
		case "drop":
			if r.TryDecodeAsNil() {
				x.Drop = nil
			} else {
				yyv1078 := &x.Drop
				yym1079 := z.DecBinary()
				_ = yym1079
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1078), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1075)
		} // end switch yys1075
	} // end for yyj1075
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Capabilities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1080 int
	var yyb1080 bool
	var yyhl1080 bool = l >= 0
	yyj1080++
	if yyhl1080 {
		yyb1080 = yyj1080 > l
	} else {
		yyb1080 = r.CheckBreak()
	}
	if yyb1080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Add = nil
	} else {
		yyv1081 := &x.Add
		yym1082 := z.DecBinary()
		_ = yym1082
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1081), d)
		}
	}
	yyj1080++
	if yyhl1080 {
		yyb1080 = yyj1080 > l
	} else {
		yyb1080 = r.CheckBreak()
	}
	if yyb1080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Drop = nil
	} else {
		yyv1083 := &x.Drop
		yym1084 := z.DecBinary()
		_ = yym1084
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1083), d)
		}
	}
	for {
		yyj1080++
		if yyhl1080 {
			yyb1080 = yyj1080 > l
		} else {
			yyb1080 = r.CheckBreak()
		}
		if yyb1080 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1080-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceRequirements) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1085 := z.EncBinary()
		_ = yym1085
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1086 := !z.EncBinary()
			yy2arr1086 := z.EncBasicHandle().StructToArray
			var yyq1086 [2]bool
			_, _, _ = yysep1086, yyq1086, yy2arr1086
			const yyr1086 bool = false
			yyq1086[0] = len(x.Limits) != 0
			yyq1086[1] = len(x.Requests) != 0
			var yynn1086 int
			if yyr1086 || yy2arr1086 {
				r.EncodeArrayStart(2)
			} else {
				yynn1086 = 0
				for _, b := range yyq1086 {
					if b {
						yynn1086++
					}
				}
				r.EncodeMapStart(yynn1086)
				yynn1086 = 0
			}
			if yyr1086 || yy2arr1086 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1086[0] {
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1086[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limits"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1086 || yy2arr1086 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1086[1] {
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1086[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requests"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1086 || yy2arr1086 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceRequirements) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1089 := z.DecBinary()
	_ = yym1089
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1090 := r.ContainerType()
		if yyct1090 == codecSelferValueTypeMap1234 {
			yyl1090 := r.ReadMapStart()
			if yyl1090 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1090, d)
			}
		} else if yyct1090 == codecSelferValueTypeArray1234 {
			yyl1090 := r.ReadArrayStart()
			if yyl1090 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1090, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceRequirements) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1091Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1091Slc
	var yyhl1091 bool = l >= 0
	for yyj1091 := 0; ; yyj1091++ {
		if yyhl1091 {
			if yyj1091 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1091Slc = r.DecodeBytes(yys1091Slc, true, true)
		yys1091 := string(yys1091Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1091 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv1092 := &x.Limits
				yyv1092.CodecDecodeSelf(d)
			}
		case "requests":
			if r.TryDecodeAsNil() {
				x.Requests = nil
			} else {
				yyv1093 := &x.Requests
				yyv1093.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1091)
		} // end switch yys1091
	} // end for yyj1091
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceRequirements) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1094 int
	var yyb1094 bool
	var yyhl1094 bool = l >= 0
	yyj1094++
	if yyhl1094 {
		yyb1094 = yyj1094 > l
	} else {
		yyb1094 = r.CheckBreak()
	}
	if yyb1094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv1095 := &x.Limits
		yyv1095.CodecDecodeSelf(d)
	}
	yyj1094++
	if yyhl1094 {
		yyb1094 = yyj1094 > l
	} else {
		yyb1094 = r.CheckBreak()
	}
	if yyb1094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Requests = nil
	} else {
		yyv1096 := &x.Requests
		yyv1096.CodecDecodeSelf(d)
	}
	for {
		yyj1094++
		if yyhl1094 {
			yyb1094 = yyj1094 > l
		} else {
			yyb1094 = r.CheckBreak()
		}
		if yyb1094 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1094-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Container) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1097 := z.EncBinary()
		_ = yym1097
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1098 := !z.EncBinary()
			yy2arr1098 := z.EncBasicHandle().StructToArray
			var yyq1098 [18]bool
			_, _, _ = yysep1098, yyq1098, yy2arr1098
			const yyr1098 bool = false
			yyq1098[1] = x.Image != ""
			yyq1098[2] = len(x.Command) != 0
			yyq1098[3] = len(x.Args) != 0
			yyq1098[4] = x.WorkingDir != ""
			yyq1098[5] = len(x.Ports) != 0
			yyq1098[6] = len(x.Env) != 0
			yyq1098[7] = true
			yyq1098[8] = len(x.VolumeMounts) != 0
			yyq1098[9] = x.LivenessProbe != nil
			yyq1098[10] = x.ReadinessProbe != nil
			yyq1098[11] = x.Lifecycle != nil
			yyq1098[12] = x.TerminationMessagePath != ""
			yyq1098[13] = x.ImagePullPolicy != ""
			yyq1098[14] = x.SecurityContext != nil
			yyq1098[15] = x.Stdin != false
			yyq1098[16] = x.StdinOnce != false
			yyq1098[17] = x.TTY != false
			var yynn1098 int
			if yyr1098 || yy2arr1098 {
				r.EncodeArrayStart(18)
			} else {
				yynn1098 = 1
				for _, b := range yyq1098 {
					if b {
						yynn1098++
					}
				}
				r.EncodeMapStart(yynn1098)
				yynn1098 = 0
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1100 := z.EncBinary()
				_ = yym1100
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1101 := z.EncBinary()
				_ = yym1101
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[1] {
					yym1103 := z.EncBinary()
					_ = yym1103
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1098[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1104 := z.EncBinary()
					_ = yym1104
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[2] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1106 := z.EncBinary()
						_ = yym1106
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1107 := z.EncBinary()
						_ = yym1107
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[3] {
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1109 := z.EncBinary()
						_ = yym1109
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("args"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1110 := z.EncBinary()
						_ = yym1110
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[4] {
					yym1112 := z.EncBinary()
					_ = yym1112
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1098[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("workingDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1113 := z.EncBinary()
					_ = yym1113
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[5] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1115 := z.EncBinary()
						_ = yym1115
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1116 := z.EncBinary()
						_ = yym1116
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[6] {
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1118 := z.EncBinary()
						_ = yym1118
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("env"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1119 := z.EncBinary()
						_ = yym1119
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[7] {
					yy1121 := &x.Resources
					yy1121.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1122 := &x.Resources
					yy1122.CodecEncodeSelf(e)
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[8] {
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1124 := z.EncBinary()
						_ = yym1124
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeMounts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1125 := z.EncBinary()
						_ = yym1125
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[9] {
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("livenessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[10] {
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readinessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[11] {
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lifecycle"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[12] {
					yym1130 := z.EncBinary()
					_ = yym1130
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1098[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1131 := z.EncBinary()
					_ = yym1131
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[13] {
					x.ImagePullPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1098[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.ImagePullPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[14] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1098[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[15] {
					yym1135 := z.EncBinary()
					_ = yym1135
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1098[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1136 := z.EncBinary()
					_ = yym1136
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[16] {
					yym1138 := z.EncBinary()
					_ = yym1138
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1098[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdinOnce"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1139 := z.EncBinary()
					_ = yym1139
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1098[17] {
					yym1141 := z.EncBinary()
					_ = yym1141
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1098[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1142 := z.EncBinary()
					_ = yym1142
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr1098 || yy2arr1098 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Container) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1143 := z.DecBinary()
	_ = yym1143
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1144 := r.ContainerType()
		if yyct1144 == codecSelferValueTypeMap1234 {
			yyl1144 := r.ReadMapStart()
			if yyl1144 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1144, d)
			}
		} else if yyct1144 == codecSelferValueTypeArray1234 {
			yyl1144 := r.ReadArrayStart()
			if yyl1144 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1144, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Container) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1145Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1145Slc
	var yyhl1145 bool = l >= 0
	for yyj1145 := 0; ; yyj1145++ {
		if yyhl1145 {
			if yyj1145 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1145Slc = r.DecodeBytes(yys1145Slc, true, true)
		yys1145 := string(yys1145Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1145 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1148 := &x.Command
				yym1149 := z.DecBinary()
				_ = yym1149
				if false {
				} else {
					z.F.DecSliceStringX(yyv1148, false, d)
				}
			}
		case "args":
			if r.TryDecodeAsNil() {
				x.Args = nil
			} else {
				yyv1150 := &x.Args
				yym1151 := z.DecBinary()
				_ = yym1151
				if false {
				} else {
					z.F.DecSliceStringX(yyv1150, false, d)
				}
			}
		case "workingDir":
			if r.TryDecodeAsNil() {
				x.WorkingDir = ""
			} else {
				x.WorkingDir = string(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1153 := &x.Ports
				yym1154 := z.DecBinary()
				_ = yym1154
				if false {
				} else {
					h.decSliceContainerPort((*[]ContainerPort)(yyv1153), d)
				}
			}
		case "env":
			if r.TryDecodeAsNil() {
				x.Env = nil
			} else {
				yyv1155 := &x.Env
				yym1156 := z.DecBinary()
				_ = yym1156
				if false {
				} else {
					h.decSliceEnvVar((*[]EnvVar)(yyv1155), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv1157 := &x.Resources
				yyv1157.CodecDecodeSelf(d)
			}
		case "volumeMounts":
			if r.TryDecodeAsNil() {
				x.VolumeMounts = nil
			} else {
				yyv1158 := &x.VolumeMounts
				yym1159 := z.DecBinary()
				_ = yym1159
				if false {
				} else {
					h.decSliceVolumeMount((*[]VolumeMount)(yyv1158), d)
				}
			}
		case "livenessProbe":
			if r.TryDecodeAsNil() {
				if x.LivenessProbe != nil {
					x.LivenessProbe = nil
				}
			} else {
				if x.LivenessProbe == nil {
					x.LivenessProbe = new(Probe)
				}
				x.LivenessProbe.CodecDecodeSelf(d)
			}
		case "readinessProbe":
			if r.TryDecodeAsNil() {
				if x.ReadinessProbe != nil {
					x.ReadinessProbe = nil
				}
			} else {
				if x.ReadinessProbe == nil {
					x.ReadinessProbe = new(Probe)
				}
				x.ReadinessProbe.CodecDecodeSelf(d)
			}
		case "lifecycle":
			if r.TryDecodeAsNil() {
				if x.Lifecycle != nil {
					x.Lifecycle = nil
				}
			} else {
				if x.Lifecycle == nil {
					x.Lifecycle = new(Lifecycle)
				}
				x.Lifecycle.CodecDecodeSelf(d)
			}
		case "terminationMessagePath":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePath = ""
			} else {
				x.TerminationMessagePath = string(r.DecodeString())
			}
		case "imagePullPolicy":
			if r.TryDecodeAsNil() {
				x.ImagePullPolicy = ""
			} else {
				x.ImagePullPolicy = PullPolicy(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(SecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdinOnce":
			if r.TryDecodeAsNil() {
				x.StdinOnce = false
			} else {
				x.StdinOnce = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1145)
		} // end switch yys1145
	} // end for yyj1145
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Container) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1169 int
	var yyb1169 bool
	var yyhl1169 bool = l >= 0
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1172 := &x.Command
		yym1173 := z.DecBinary()
		_ = yym1173
		if false {
		} else {
			z.F.DecSliceStringX(yyv1172, false, d)
		}
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Args = nil
	} else {
		yyv1174 := &x.Args
		yym1175 := z.DecBinary()
		_ = yym1175
		if false {
		} else {
			z.F.DecSliceStringX(yyv1174, false, d)
		}
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.WorkingDir = ""
	} else {
		x.WorkingDir = string(r.DecodeString())
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1177 := &x.Ports
		yym1178 := z.DecBinary()
		_ = yym1178
		if false {
		} else {
			h.decSliceContainerPort((*[]ContainerPort)(yyv1177), d)
		}
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Env = nil
	} else {
		yyv1179 := &x.Env
		yym1180 := z.DecBinary()
		_ = yym1180
		if false {
		} else {
			h.decSliceEnvVar((*[]EnvVar)(yyv1179), d)
		}
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv1181 := &x.Resources
		yyv1181.CodecDecodeSelf(d)
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeMounts = nil
	} else {
		yyv1182 := &x.VolumeMounts
		yym1183 := z.DecBinary()
		_ = yym1183
		if false {
		} else {
			h.decSliceVolumeMount((*[]VolumeMount)(yyv1182), d)
		}
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LivenessProbe != nil {
			x.LivenessProbe = nil
		}
	} else {
		if x.LivenessProbe == nil {
			x.LivenessProbe = new(Probe)
		}
		x.LivenessProbe.CodecDecodeSelf(d)
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadinessProbe != nil {
			x.ReadinessProbe = nil
		}
	} else {
		if x.ReadinessProbe == nil {
			x.ReadinessProbe = new(Probe)
		}
		x.ReadinessProbe.CodecDecodeSelf(d)
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lifecycle != nil {
			x.Lifecycle = nil
		}
	} else {
		if x.Lifecycle == nil {
			x.Lifecycle = new(Lifecycle)
		}
		x.Lifecycle.CodecDecodeSelf(d)
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePath = ""
	} else {
		x.TerminationMessagePath = string(r.DecodeString())
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullPolicy = ""
	} else {
		x.ImagePullPolicy = PullPolicy(r.DecodeString())
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(SecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StdinOnce = false
	} else {
		x.StdinOnce = bool(r.DecodeBool())
	}
	yyj1169++
	if yyhl1169 {
		yyb1169 = yyj1169 > l
	} else {
		yyb1169 = r.CheckBreak()
	}
	if yyb1169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	for {
		yyj1169++
		if yyhl1169 {
			yyb1169 = yyj1169 > l
		} else {
			yyb1169 = r.CheckBreak()
		}
		if yyb1169 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1169-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Handler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1193 := z.EncBinary()
		_ = yym1193
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1194 := !z.EncBinary()
			yy2arr1194 := z.EncBasicHandle().StructToArray
			var yyq1194 [3]bool
			_, _, _ = yysep1194, yyq1194, yy2arr1194
			const yyr1194 bool = false
			yyq1194[0] = x.Exec != nil
			yyq1194[1] = x.HTTPGet != nil
			yyq1194[2] = x.TCPSocket != nil
			var yynn1194 int
			if yyr1194 || yy2arr1194 {
				r.EncodeArrayStart(3)
			} else {
				yynn1194 = 0
				for _, b := range yyq1194 {
					if b {
						yynn1194++
					}
				}
				r.EncodeMapStart(yynn1194)
				yynn1194 = 0
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1194[0] {
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1194[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1194[1] {
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1194[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1194[2] {
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1194[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Handler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1198 := z.DecBinary()
	_ = yym1198
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1199 := r.ContainerType()
		if yyct1199 == codecSelferValueTypeMap1234 {
			yyl1199 := r.ReadMapStart()
			if yyl1199 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1199, d)
			}
		} else if yyct1199 == codecSelferValueTypeArray1234 {
			yyl1199 := r.ReadArrayStart()
			if yyl1199 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1199, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Handler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1200Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1200Slc
	var yyhl1200 bool = l >= 0
	for yyj1200 := 0; ; yyj1200++ {
		if yyhl1200 {
			if yyj1200 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1200Slc = r.DecodeBytes(yys1200Slc, true, true)
		yys1200 := string(yys1200Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1200 {
		case "exec":
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1200)
		} // end switch yys1200
	} // end for yyj1200
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Handler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1204 int
	var yyb1204 bool
	var yyhl1204 bool = l >= 0
	yyj1204++
	if yyhl1204 {
		yyb1204 = yyj1204 > l
	} else {
		yyb1204 = r.CheckBreak()
	}
	if yyb1204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	yyj1204++
	if yyhl1204 {
		yyb1204 = yyj1204 > l
	} else {
		yyb1204 = r.CheckBreak()
	}
	if yyb1204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	yyj1204++
	if yyhl1204 {
		yyb1204 = yyj1204 > l
	} else {
		yyb1204 = r.CheckBreak()
	}
	if yyb1204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	for {
		yyj1204++
		if yyhl1204 {
			yyb1204 = yyj1204 > l
		} else {
			yyb1204 = r.CheckBreak()
		}
		if yyb1204 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1204-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Lifecycle) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1208 := z.EncBinary()
		_ = yym1208
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1209 := !z.EncBinary()
			yy2arr1209 := z.EncBasicHandle().StructToArray
			var yyq1209 [2]bool
			_, _, _ = yysep1209, yyq1209, yy2arr1209
			const yyr1209 bool = false
			yyq1209[0] = x.PostStart != nil
			yyq1209[1] = x.PreStop != nil
			var yynn1209 int
			if yyr1209 || yy2arr1209 {
				r.EncodeArrayStart(2)
			} else {
				yynn1209 = 0
				for _, b := range yyq1209 {
					if b {
						yynn1209++
					}
				}
				r.EncodeMapStart(yynn1209)
				yynn1209 = 0
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1209[0] {
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1209[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("postStart"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1209[1] {
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1209[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preStop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Lifecycle) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1212 := z.DecBinary()
	_ = yym1212
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1213 := r.ContainerType()
		if yyct1213 == codecSelferValueTypeMap1234 {
			yyl1213 := r.ReadMapStart()
			if yyl1213 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1213, d)
			}
		} else if yyct1213 == codecSelferValueTypeArray1234 {
			yyl1213 := r.ReadArrayStart()
			if yyl1213 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1213, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Lifecycle) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1214Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1214Slc
	var yyhl1214 bool = l >= 0
	for yyj1214 := 0; ; yyj1214++ {
		if yyhl1214 {
			if yyj1214 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1214Slc = r.DecodeBytes(yys1214Slc, true, true)
		yys1214 := string(yys1214Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1214 {
		case "postStart":
			if r.TryDecodeAsNil() {
				if x.PostStart != nil {
					x.PostStart = nil
				}
			} else {
				if x.PostStart == nil {
					x.PostStart = new(Handler)
				}
				x.PostStart.CodecDecodeSelf(d)
			}
		case "preStop":
			if r.TryDecodeAsNil() {
				if x.PreStop != nil {
					x.PreStop = nil
				}
			} else {
				if x.PreStop == nil {
					x.PreStop = new(Handler)
				}
				x.PreStop.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1214)
		} // end switch yys1214
	} // end for yyj1214
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Lifecycle) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1217 int
	var yyb1217 bool
	var yyhl1217 bool = l >= 0
	yyj1217++
	if yyhl1217 {
		yyb1217 = yyj1217 > l
	} else {
		yyb1217 = r.CheckBreak()
	}
	if yyb1217 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PostStart != nil {
			x.PostStart = nil
		}
	} else {
		if x.PostStart == nil {
			x.PostStart = new(Handler)
		}
		x.PostStart.CodecDecodeSelf(d)
	}
	yyj1217++
	if yyhl1217 {
		yyb1217 = yyj1217 > l
	} else {
		yyb1217 = r.CheckBreak()
	}
	if yyb1217 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PreStop != nil {
			x.PreStop = nil
		}
	} else {
		if x.PreStop == nil {
			x.PreStop = new(Handler)
		}
		x.PreStop.CodecDecodeSelf(d)
	}
	for {
		yyj1217++
		if yyhl1217 {
			yyb1217 = yyj1217 > l
		} else {
			yyb1217 = r.CheckBreak()
		}
		if yyb1217 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1217-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConditionStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1220 := z.EncBinary()
	_ = yym1220
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConditionStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1221 := z.DecBinary()
	_ = yym1221
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ContainerStateWaiting) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1222 := z.EncBinary()
		_ = yym1222
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1223 := !z.EncBinary()
			yy2arr1223 := z.EncBasicHandle().StructToArray
			var yyq1223 [2]bool
			_, _, _ = yysep1223, yyq1223, yy2arr1223
			const yyr1223 bool = false
			yyq1223[0] = x.Reason != ""
			yyq1223[1] = x.Message != ""
			var yynn1223 int
			if yyr1223 || yy2arr1223 {
				r.EncodeArrayStart(2)
			} else {
				yynn1223 = 0
				for _, b := range yyq1223 {
					if b {
						yynn1223++
					}
				}
				r.EncodeMapStart(yynn1223)
				yynn1223 = 0
			}
			if yyr1223 || yy2arr1223 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1223[0] {
					yym1225 := z.EncBinary()
					_ = yym1225
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1223[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1226 := z.EncBinary()
					_ = yym1226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1223 || yy2arr1223 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1223[1] {
					yym1228 := z.EncBinary()
					_ = yym1228
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1223[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1229 := z.EncBinary()
					_ = yym1229
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1223 || yy2arr1223 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateWaiting) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1230 := z.DecBinary()
	_ = yym1230
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1231 := r.ContainerType()
		if yyct1231 == codecSelferValueTypeMap1234 {
			yyl1231 := r.ReadMapStart()
			if yyl1231 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1231, d)
			}
		} else if yyct1231 == codecSelferValueTypeArray1234 {
			yyl1231 := r.ReadArrayStart()
			if yyl1231 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1231, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateWaiting) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1232Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1232Slc
	var yyhl1232 bool = l >= 0
	for yyj1232 := 0; ; yyj1232++ {
		if yyhl1232 {
			if yyj1232 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1232Slc = r.DecodeBytes(yys1232Slc, true, true)
		yys1232 := string(yys1232Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1232 {
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1232)
		} // end switch yys1232
	} // end for yyj1232
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateWaiting) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1235 int
	var yyb1235 bool
	var yyhl1235 bool = l >= 0
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1235++
		if yyhl1235 {
			yyb1235 = yyj1235 > l
		} else {
			yyb1235 = r.CheckBreak()
		}
		if yyb1235 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1235-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateRunning) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1238 := z.EncBinary()
		_ = yym1238
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1239 := !z.EncBinary()
			yy2arr1239 := z.EncBasicHandle().StructToArray
			var yyq1239 [1]bool
			_, _, _ = yysep1239, yyq1239, yy2arr1239
			const yyr1239 bool = false
			yyq1239[0] = true
			var yynn1239 int
			if yyr1239 || yy2arr1239 {
				r.EncodeArrayStart(1)
			} else {
				yynn1239 = 0
				for _, b := range yyq1239 {
					if b {
						yynn1239++
					}
				}
				r.EncodeMapStart(yynn1239)
				yynn1239 = 0
			}
			if yyr1239 || yy2arr1239 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1239[0] {
					yy1241 := &x.StartedAt
					yym1242 := z.EncBinary()
					_ = yym1242
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1241) {
					} else if yym1242 {
						z.EncBinaryMarshal(yy1241)
					} else if !yym1242 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1241)
					} else {
						z.EncFallback(yy1241)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1239[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1243 := &x.StartedAt
					yym1244 := z.EncBinary()
					_ = yym1244
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1243) {
					} else if yym1244 {
						z.EncBinaryMarshal(yy1243)
					} else if !yym1244 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1243)
					} else {
						z.EncFallback(yy1243)
					}
				}
			}
			if yyr1239 || yy2arr1239 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateRunning) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1245 := z.DecBinary()
	_ = yym1245
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1246 := r.ContainerType()
		if yyct1246 == codecSelferValueTypeMap1234 {
			yyl1246 := r.ReadMapStart()
			if yyl1246 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1246, d)
			}
		} else if yyct1246 == codecSelferValueTypeArray1234 {
			yyl1246 := r.ReadArrayStart()
			if yyl1246 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1246, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateRunning) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1247Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1247Slc
	var yyhl1247 bool = l >= 0
	for yyj1247 := 0; ; yyj1247++ {
		if yyhl1247 {
			if yyj1247 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1247Slc = r.DecodeBytes(yys1247Slc, true, true)
		yys1247 := string(yys1247Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1247 {
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1248 := &x.StartedAt
				yym1249 := z.DecBinary()
				_ = yym1249
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1248) {
				} else if yym1249 {
					z.DecBinaryUnmarshal(yyv1248)
				} else if !yym1249 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1248)
				} else {
					z.DecFallback(yyv1248, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1247)
		} // end switch yys1247
	} // end for yyj1247
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateRunning) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1250 int
	var yyb1250 bool
	var yyhl1250 bool = l >= 0
	yyj1250++
	if yyhl1250 {
		yyb1250 = yyj1250 > l
	} else {
		yyb1250 = r.CheckBreak()
	}
	if yyb1250 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1251 := &x.StartedAt
		yym1252 := z.DecBinary()
		_ = yym1252
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1251) {
		} else if yym1252 {
			z.DecBinaryUnmarshal(yyv1251)
		} else if !yym1252 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1251)
		} else {
			z.DecFallback(yyv1251, false)
		}
	}
	for {
		yyj1250++
		if yyhl1250 {
			yyb1250 = yyj1250 > l
		} else {
			yyb1250 = r.CheckBreak()
		}
		if yyb1250 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1250-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateTerminated) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1253 := z.EncBinary()
		_ = yym1253
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1254 := !z.EncBinary()
			yy2arr1254 := z.EncBasicHandle().StructToArray
			var yyq1254 [7]bool
			_, _, _ = yysep1254, yyq1254, yy2arr1254
			const yyr1254 bool = false
			yyq1254[1] = x.Signal != 0
			yyq1254[2] = x.Reason != ""
			yyq1254[3] = x.Message != ""
			yyq1254[4] = true
			yyq1254[5] = true
			yyq1254[6] = x.ContainerID != ""
			var yynn1254 int
			if yyr1254 || yy2arr1254 {
				r.EncodeArrayStart(7)
			} else {
				yynn1254 = 1
				for _, b := range yyq1254 {
					if b {
						yynn1254++
					}
				}
				r.EncodeMapStart(yynn1254)
				yynn1254 = 0
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1256 := z.EncBinary()
				_ = yym1256
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitCode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1257 := z.EncBinary()
				_ = yym1257
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[1] {
					yym1259 := z.EncBinary()
					_ = yym1259
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1254[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("signal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1260 := z.EncBinary()
					_ = yym1260
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[2] {
					yym1262 := z.EncBinary()
					_ = yym1262
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1254[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1263 := z.EncBinary()
					_ = yym1263
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[3] {
					yym1265 := z.EncBinary()
					_ = yym1265
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1254[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1266 := z.EncBinary()
					_ = yym1266
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[4] {
					yy1268 := &x.StartedAt
					yym1269 := z.EncBinary()
					_ = yym1269
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1268) {
					} else if yym1269 {
						z.EncBinaryMarshal(yy1268)
					} else if !yym1269 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1268)
					} else {
						z.EncFallback(yy1268)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1254[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1270 := &x.StartedAt
					yym1271 := z.EncBinary()
					_ = yym1271
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1270) {
					} else if yym1271 {
						z.EncBinaryMarshal(yy1270)
					} else if !yym1271 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1270)
					} else {
						z.EncFallback(yy1270)
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[5] {
					yy1273 := &x.FinishedAt
					yym1274 := z.EncBinary()
					_ = yym1274
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1273) {
					} else if yym1274 {
						z.EncBinaryMarshal(yy1273)
					} else if !yym1274 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1273)
					} else {
						z.EncFallback(yy1273)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1254[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finishedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1275 := &x.FinishedAt
					yym1276 := z.EncBinary()
					_ = yym1276
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1275) {
					} else if yym1276 {
						z.EncBinaryMarshal(yy1275)
					} else if !yym1276 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1275)
					} else {
						z.EncFallback(yy1275)
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[6] {
					yym1278 := z.EncBinary()
					_ = yym1278
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1254[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1279 := z.EncBinary()
					_ = yym1279
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateTerminated) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1280 := z.DecBinary()
	_ = yym1280
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1281 := r.ContainerType()
		if yyct1281 == codecSelferValueTypeMap1234 {
			yyl1281 := r.ReadMapStart()
			if yyl1281 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1281, d)
			}
		} else if yyct1281 == codecSelferValueTypeArray1234 {
			yyl1281 := r.ReadArrayStart()
			if yyl1281 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1281, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateTerminated) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1282Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1282Slc
	var yyhl1282 bool = l >= 0
	for yyj1282 := 0; ; yyj1282++ {
		if yyhl1282 {
			if yyj1282 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1282Slc = r.DecodeBytes(yys1282Slc, true, true)
		yys1282 := string(yys1282Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1282 {
		case "exitCode":
			if r.TryDecodeAsNil() {
				x.ExitCode = 0
			} else {
				x.ExitCode = int32(r.DecodeInt(32))
			}
		case "signal":
			if r.TryDecodeAsNil() {
				x.Signal = 0
			} else {
				x.Signal = int32(r.DecodeInt(32))
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1287 := &x.StartedAt
				yym1288 := z.DecBinary()
				_ = yym1288
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1287) {
				} else if yym1288 {
					z.DecBinaryUnmarshal(yyv1287)
				} else if !yym1288 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1287)
				} else {
					z.DecFallback(yyv1287, false)
				}
			}
		case "finishedAt":
			if r.TryDecodeAsNil() {
				x.FinishedAt = pkg2_unversioned.Time{}
			} else {
				yyv1289 := &x.FinishedAt
				yym1290 := z.DecBinary()
				_ = yym1290
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1289) {
				} else if yym1290 {
					z.DecBinaryUnmarshal(yyv1289)
				} else if !yym1290 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1289)
				} else {
					z.DecFallback(yyv1289, false)
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1282)
		} // end switch yys1282
	} // end for yyj1282
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateTerminated) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1292 int
	var yyb1292 bool
	var yyhl1292 bool = l >= 0
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitCode = 0
	} else {
		x.ExitCode = int32(r.DecodeInt(32))
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Signal = 0
	} else {
		x.Signal = int32(r.DecodeInt(32))
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1297 := &x.StartedAt
		yym1298 := z.DecBinary()
		_ = yym1298
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1297) {
		} else if yym1298 {
			z.DecBinaryUnmarshal(yyv1297)
		} else if !yym1298 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1297)
		} else {
			z.DecFallback(yyv1297, false)
		}
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FinishedAt = pkg2_unversioned.Time{}
	} else {
		yyv1299 := &x.FinishedAt
		yym1300 := z.DecBinary()
		_ = yym1300
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1299) {
		} else if yym1300 {
			z.DecBinaryUnmarshal(yyv1299)
		} else if !yym1300 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1299)
		} else {
			z.DecFallback(yyv1299, false)
		}
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1292++
		if yyhl1292 {
			yyb1292 = yyj1292 > l
		} else {
			yyb1292 = r.CheckBreak()
		}
		if yyb1292 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1292-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerState) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1302 := z.EncBinary()
		_ = yym1302
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1303 := !z.EncBinary()
			yy2arr1303 := z.EncBasicHandle().StructToArray
			var yyq1303 [3]bool
			_, _, _ = yysep1303, yyq1303, yy2arr1303
			const yyr1303 bool = false
			yyq1303[0] = x.Waiting != nil
			yyq1303[1] = x.Running != nil
			yyq1303[2] = x.Terminated != nil
			var yynn1303 int
			if yyr1303 || yy2arr1303 {
				r.EncodeArrayStart(3)
			} else {
				yynn1303 = 0
				for _, b := range yyq1303 {
					if b {
						yynn1303++
					}
				}
				r.EncodeMapStart(yynn1303)
				yynn1303 = 0
			}
			if yyr1303 || yy2arr1303 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1303[0] {
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1303[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("waiting"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1303 || yy2arr1303 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1303[1] {
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1303[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("running"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1303 || yy2arr1303 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1303[2] {
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1303[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminated"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1303 || yy2arr1303 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerState) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1307 := z.DecBinary()
	_ = yym1307
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1308 := r.ContainerType()
		if yyct1308 == codecSelferValueTypeMap1234 {
			yyl1308 := r.ReadMapStart()
			if yyl1308 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1308, d)
			}
		} else if yyct1308 == codecSelferValueTypeArray1234 {
			yyl1308 := r.ReadArrayStart()
			if yyl1308 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1308, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerState) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1309Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1309Slc
	var yyhl1309 bool = l >= 0
	for yyj1309 := 0; ; yyj1309++ {
		if yyhl1309 {
			if yyj1309 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1309Slc = r.DecodeBytes(yys1309Slc, true, true)
		yys1309 := string(yys1309Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1309 {
		case "waiting":
			if r.TryDecodeAsNil() {
				if x.Waiting != nil {
					x.Waiting = nil
				}
			} else {
				if x.Waiting == nil {
					x.Waiting = new(ContainerStateWaiting)
				}
				x.Waiting.CodecDecodeSelf(d)
			}
		case "running":
			if r.TryDecodeAsNil() {
				if x.Running != nil {
					x.Running = nil
				}
			} else {
				if x.Running == nil {
					x.Running = new(ContainerStateRunning)
				}
				x.Running.CodecDecodeSelf(d)
			}
		case "terminated":
			if r.TryDecodeAsNil() {
				if x.Terminated != nil {
					x.Terminated = nil
				}
			} else {
				if x.Terminated == nil {
					x.Terminated = new(ContainerStateTerminated)
				}
				x.Terminated.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1309)
		} // end switch yys1309
	} // end for yyj1309
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerState) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1313 int
	var yyb1313 bool
	var yyhl1313 bool = l >= 0
	yyj1313++
	if yyhl1313 {
		yyb1313 = yyj1313 > l
	} else {
		yyb1313 = r.CheckBreak()
	}
	if yyb1313 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Waiting != nil {
			x.Waiting = nil
		}
	} else {
		if x.Waiting == nil {
			x.Waiting = new(ContainerStateWaiting)
		}
		x.Waiting.CodecDecodeSelf(d)
	}
	yyj1313++
	if yyhl1313 {
		yyb1313 = yyj1313 > l
	} else {
		yyb1313 = r.CheckBreak()
	}
	if yyb1313 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Running != nil {
			x.Running = nil
		}
	} else {
		if x.Running == nil {
			x.Running = new(ContainerStateRunning)
		}
		x.Running.CodecDecodeSelf(d)
	}
	yyj1313++
	if yyhl1313 {
		yyb1313 = yyj1313 > l
	} else {
		yyb1313 = r.CheckBreak()
	}
	if yyb1313 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Terminated != nil {
			x.Terminated = nil
		}
	} else {
		if x.Terminated == nil {
			x.Terminated = new(ContainerStateTerminated)
		}
		x.Terminated.CodecDecodeSelf(d)
	}
	for {
		yyj1313++
		if yyhl1313 {
			yyb1313 = yyj1313 > l
		} else {
			yyb1313 = r.CheckBreak()
		}
		if yyb1313 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1313-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1317 := z.EncBinary()
		_ = yym1317
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1318 := !z.EncBinary()
			yy2arr1318 := z.EncBasicHandle().StructToArray
			var yyq1318 [8]bool
			_, _, _ = yysep1318, yyq1318, yy2arr1318
			const yyr1318 bool = false
			yyq1318[1] = true
			yyq1318[2] = true
			yyq1318[7] = x.ContainerID != ""
			var yynn1318 int
			if yyr1318 || yy2arr1318 {
				r.EncodeArrayStart(8)
			} else {
				yynn1318 = 5
				for _, b := range yyq1318 {
					if b {
						yynn1318++
					}
				}
				r.EncodeMapStart(yynn1318)
				yynn1318 = 0
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1320 := z.EncBinary()
				_ = yym1320
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1321 := z.EncBinary()
				_ = yym1321
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1318[1] {
					yy1323 := &x.State
					yy1323.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1318[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("state"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1324 := &x.State
					yy1324.CodecEncodeSelf(e)
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1318[2] {
					yy1326 := &x.LastTerminationState
					yy1326.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1318[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastState"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1327 := &x.LastTerminationState
					yy1327.CodecEncodeSelf(e)
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1329 := z.EncBinary()
				_ = yym1329
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ready"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1330 := z.EncBinary()
				_ = yym1330
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1332 := z.EncBinary()
				_ = yym1332
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("restartCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1333 := z.EncBinary()
				_ = yym1333
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1335 := z.EncBinary()
				_ = yym1335
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1336 := z.EncBinary()
				_ = yym1336
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1338 := z.EncBinary()
				_ = yym1338
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1339 := z.EncBinary()
				_ = yym1339
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1318[7] {
					yym1341 := z.EncBinary()
					_ = yym1341
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1318[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1342 := z.EncBinary()
					_ = yym1342
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1343 := z.DecBinary()
	_ = yym1343
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1344 := r.ContainerType()
		if yyct1344 == codecSelferValueTypeMap1234 {
			yyl1344 := r.ReadMapStart()
			if yyl1344 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1344, d)
			}
		} else if yyct1344 == codecSelferValueTypeArray1234 {
			yyl1344 := r.ReadArrayStart()
			if yyl1344 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1344, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1345Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1345Slc
	var yyhl1345 bool = l >= 0
	for yyj1345 := 0; ; yyj1345++ {
		if yyhl1345 {
			if yyj1345 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1345Slc = r.DecodeBytes(yys1345Slc, true, true)
		yys1345 := string(yys1345Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1345 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "state":
			if r.TryDecodeAsNil() {
				x.State = ContainerState{}
			} else {
				yyv1347 := &x.State
				yyv1347.CodecDecodeSelf(d)
			}
		case "lastState":
			if r.TryDecodeAsNil() {
				x.LastTerminationState = ContainerState{}
			} else {
				yyv1348 := &x.LastTerminationState
				yyv1348.CodecDecodeSelf(d)
			}
		case "ready":
			if r.TryDecodeAsNil() {
				x.Ready = false
			} else {
				x.Ready = bool(r.DecodeBool())
			}
		case "restartCount":
			if r.TryDecodeAsNil() {
				x.RestartCount = 0
			} else {
				x.RestartCount = int32(r.DecodeInt(32))
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "imageID":
			if r.TryDecodeAsNil() {
				x.ImageID = ""
			} else {
				x.ImageID = string(r.DecodeString())
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1345)
		} // end switch yys1345
	} // end for yyj1345
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1354 int
	var yyb1354 bool
	var yyhl1354 bool = l >= 0
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.State = ContainerState{}
	} else {
		yyv1356 := &x.State
		yyv1356.CodecDecodeSelf(d)
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTerminationState = ContainerState{}
	} else {
		yyv1357 := &x.LastTerminationState
		yyv1357.CodecDecodeSelf(d)
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ready = false
	} else {
		x.Ready = bool(r.DecodeBool())
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartCount = 0
	} else {
		x.RestartCount = int32(r.DecodeInt(32))
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageID = ""
	} else {
		x.ImageID = string(r.DecodeString())
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1354++
		if yyhl1354 {
			yyb1354 = yyj1354 > l
		} else {
			yyb1354 = r.CheckBreak()
		}
		if yyb1354 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1354-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1363 := z.EncBinary()
	_ = yym1363
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1364 := z.DecBinary()
	_ = yym1364
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PodConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1365 := z.EncBinary()
	_ = yym1365
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1366 := z.DecBinary()
	_ = yym1366
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1367 := z.EncBinary()
		_ = yym1367
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1368 := !z.EncBinary()
			yy2arr1368 := z.EncBasicHandle().StructToArray
			var yyq1368 [6]bool
			_, _, _ = yysep1368, yyq1368, yy2arr1368
			const yyr1368 bool = false
			yyq1368[2] = true
			yyq1368[3] = true
			yyq1368[4] = x.Reason != ""
			yyq1368[5] = x.Message != ""
			var yynn1368 int
			if yyr1368 || yy2arr1368 {
				r.EncodeArrayStart(6)
			} else {
				yynn1368 = 2
				for _, b := range yyq1368 {
					if b {
						yynn1368++
					}
				}
				r.EncodeMapStart(yynn1368)
				yynn1368 = 0
			}
			if yyr1368 || yy2arr1368 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1368 || yy2arr1368 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr1368 || yy2arr1368 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1368[2] {
					yy1372 := &x.LastProbeTime
					yym1373 := z.EncBinary()
					_ = yym1373
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1372) {
					} else if yym1373 {
						z.EncBinaryMarshal(yy1372)
					} else if !yym1373 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1372)
					} else {
						z.EncFallback(yy1372)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1368[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1374 := &x.LastProbeTime
					yym1375 := z.EncBinary()
					_ = yym1375
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1374) {
					} else if yym1375 {
						z.EncBinaryMarshal(yy1374)
					} else if !yym1375 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1374)
					} else {
						z.EncFallback(yy1374)
					}
				}
			}
			if yyr1368 || yy2arr1368 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1368[3] {
					yy1377 := &x.LastTransitionTime
					yym1378 := z.EncBinary()
					_ = yym1378
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1377) {
					} else if yym1378 {
						z.EncBinaryMarshal(yy1377)
					} else if !yym1378 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1377)
					} else {
						z.EncFallback(yy1377)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1368[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1379 := &x.LastTransitionTime
					yym1380 := z.EncBinary()
					_ = yym1380
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1379) {
					} else if yym1380 {
						z.EncBinaryMarshal(yy1379)
					} else if !yym1380 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1379)
					} else {
						z.EncFallback(yy1379)
					}
				}
			}
			if yyr1368 || yy2arr1368 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1368[4] {
					yym1382 := z.EncBinary()
					_ = yym1382
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1368[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1383 := z.EncBinary()
					_ = yym1383
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1368 || yy2arr1368 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1368[5] {
					yym1385 := z.EncBinary()
					_ = yym1385
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1368[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1386 := z.EncBinary()
					_ = yym1386
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1368 || yy2arr1368 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1387 := z.DecBinary()
	_ = yym1387
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1388 := r.ContainerType()
		if yyct1388 == codecSelferValueTypeMap1234 {
			yyl1388 := r.ReadMapStart()
			if yyl1388 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1388, d)
			}
		} else if yyct1388 == codecSelferValueTypeArray1234 {
			yyl1388 := r.ReadArrayStart()
			if yyl1388 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1388, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1389Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1389Slc
	var yyhl1389 bool = l >= 0
	for yyj1389 := 0; ; yyj1389++ {
		if yyhl1389 {
			if yyj1389 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1389Slc = r.DecodeBytes(yys1389Slc, true, true)
		yys1389 := string(yys1389Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1389 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = PodConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg2_unversioned.Time{}
			} else {
				yyv1392 := &x.LastProbeTime
				yym1393 := z.DecBinary()
				_ = yym1393
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1392) {
				} else if yym1393 {
					z.DecBinaryUnmarshal(yyv1392)
				} else if !yym1393 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1392)
				} else {
					z.DecFallback(yyv1392, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv1394 := &x.LastTransitionTime
				yym1395 := z.DecBinary()
				_ = yym1395
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1394) {
				} else if yym1395 {
					z.DecBinaryUnmarshal(yyv1394)
				} else if !yym1395 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1394)
				} else {
					z.DecFallback(yyv1394, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1389)
		} // end switch yys1389
	} // end for yyj1389
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1398 int
	var yyb1398 bool
	var yyhl1398 bool = l >= 0
	yyj1398++
	if yyhl1398 {
		yyb1398 = yyj1398 > l
	} else {
		yyb1398 = r.CheckBreak()
	}
	if yyb1398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = PodConditionType(r.DecodeString())
	}
	yyj1398++
	if yyhl1398 {
		yyb1398 = yyj1398 > l
	} else {
		yyb1398 = r.CheckBreak()
	}
	if yyb1398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj1398++
	if yyhl1398 {
		yyb1398 = yyj1398 > l
	} else {
		yyb1398 = r.CheckBreak()
	}
	if yyb1398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg2_unversioned.Time{}
	} else {
		yyv1401 := &x.LastProbeTime
		yym1402 := z.DecBinary()
		_ = yym1402
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1401) {
		} else if yym1402 {
			z.DecBinaryUnmarshal(yyv1401)
		} else if !yym1402 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1401)
		} else {
			z.DecFallback(yyv1401, false)
		}
	}
	yyj1398++
	if yyhl1398 {
		yyb1398 = yyj1398 > l
	} else {
		yyb1398 = r.CheckBreak()
	}
	if yyb1398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv1403 := &x.LastTransitionTime
		yym1404 := z.DecBinary()
		_ = yym1404
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1403) {
		} else if yym1404 {
			z.DecBinaryUnmarshal(yyv1403)
		} else if !yym1404 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1403)
		} else {
			z.DecFallback(yyv1403, false)
		}
	}
	yyj1398++
	if yyhl1398 {
		yyb1398 = yyj1398 > l
	} else {
		yyb1398 = r.CheckBreak()
	}
	if yyb1398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1398++
	if yyhl1398 {
		yyb1398 = yyj1398 > l
	} else {
		yyb1398 = r.CheckBreak()
	}
	if yyb1398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1398++
		if yyhl1398 {
			yyb1398 = yyj1398 > l
		} else {
			yyb1398 = r.CheckBreak()
		}
		if yyb1398 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1398-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RestartPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1407 := z.EncBinary()
	_ = yym1407
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RestartPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1408 := z.DecBinary()
	_ = yym1408
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x DNSPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1409 := z.EncBinary()
	_ = yym1409
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DNSPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1410 := z.DecBinary()
	_ = yym1410
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1411 := z.EncBinary()
		_ = yym1411
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1412 := !z.EncBinary()
			yy2arr1412 := z.EncBasicHandle().StructToArray
			var yyq1412 [15]bool
			_, _, _ = yysep1412, yyq1412, yy2arr1412
			const yyr1412 bool = false
			yyq1412[0] = len(x.Volumes) != 0
			yyq1412[2] = x.RestartPolicy != ""
			yyq1412[3] = x.TerminationGracePeriodSeconds != nil
			yyq1412[4] = x.ActiveDeadlineSeconds != nil
			yyq1412[5] = x.DNSPolicy != ""
			yyq1412[6] = len(x.NodeSelector) != 0
			yyq1412[7] = x.ServiceAccountName != ""
			yyq1412[8] = x.DeprecatedServiceAccount != ""
			yyq1412[9] = x.NodeName != ""
			yyq1412[10] = x.HostNetwork != false
			yyq1412[11] = x.HostPID != false
			yyq1412[12] = x.HostIPC != false
			yyq1412[13] = x.SecurityContext != nil
			yyq1412[14] = len(x.ImagePullSecrets) != 0
			var yynn1412 int
			if yyr1412 || yy2arr1412 {
				r.EncodeArrayStart(15)
			} else {
				yynn1412 = 1
				for _, b := range yyq1412 {
					if b {
						yynn1412++
					}
				}
				r.EncodeMapStart(yynn1412)
				yynn1412 = 0
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[0] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1414 := z.EncBinary()
						_ = yym1414
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1415 := z.EncBinary()
						_ = yym1415
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym1417 := z.EncBinary()
					_ = yym1417
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym1418 := z.EncBinary()
					_ = yym1418
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[2] {
					x.RestartPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1412[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("restartPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.RestartPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[3] {
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy1421 := *x.TerminationGracePeriodSeconds
						yym1422 := z.EncBinary()
						_ = yym1422
						if false {
						} else {
							r.EncodeInt(int64(yy1421))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy1423 := *x.TerminationGracePeriodSeconds
						yym1424 := z.EncBinary()
						_ = yym1424
						if false {
						} else {
							r.EncodeInt(int64(yy1423))
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[4] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy1426 := *x.ActiveDeadlineSeconds
						yym1427 := z.EncBinary()
						_ = yym1427
						if false {
						} else {
							r.EncodeInt(int64(yy1426))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy1428 := *x.ActiveDeadlineSeconds
						yym1429 := z.EncBinary()
						_ = yym1429
						if false {
						} else {
							r.EncodeInt(int64(yy1428))
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[5] {
					x.DNSPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1412[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("dnsPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.DNSPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[6] {
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym1432 := z.EncBinary()
						_ = yym1432
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym1433 := z.EncBinary()
						_ = yym1433
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[7] {
					yym1435 := z.EncBinary()
					_ = yym1435
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1412[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccountName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1436 := z.EncBinary()
					_ = yym1436
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[8] {
					yym1438 := z.EncBinary()
					_ = yym1438
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1412[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccount"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1439 := z.EncBinary()
					_ = yym1439
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[9] {
					yym1441 := z.EncBinary()
					_ = yym1441
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1412[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1442 := z.EncBinary()
					_ = yym1442
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[10] {
					yym1444 := z.EncBinary()
					_ = yym1444
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1445 := z.EncBinary()
					_ = yym1445
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[11] {
					yym1447 := z.EncBinary()
					_ = yym1447
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1448 := z.EncBinary()
					_ = yym1448
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[12] {
					yym1450 := z.EncBinary()
					_ = yym1450
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1451 := z.EncBinary()
					_ = yym1451
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[13] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[14] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym1454 := z.EncBinary()
						_ = yym1454
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym1455 := z.EncBinary()
						_ = yym1455
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1456 := z.DecBinary()
	_ = yym1456
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1457 := r.ContainerType()
		if yyct1457 == codecSelferValueTypeMap1234 {
			yyl1457 := r.ReadMapStart()
			if yyl1457 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1457, d)
			}
		} else if yyct1457 == codecSelferValueTypeArray1234 {
			yyl1457 := r.ReadArrayStart()
			if yyl1457 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1457, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1458Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1458Slc
	var yyhl1458 bool = l >= 0
	for yyj1458 := 0; ; yyj1458++ {
		if yyhl1458 {
			if yyj1458 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1458Slc = r.DecodeBytes(yys1458Slc, true, true)
		yys1458 := string(yys1458Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1458 {
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv1459 := &x.Volumes
				yym1460 := z.DecBinary()
				_ = yym1460
				if false {
				} else {
					h.decSliceVolume((*[]Volume)(yyv1459), d)
				}
			}
		case "containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv1461 := &x.Containers
				yym1462 := z.DecBinary()
				_ = yym1462
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv1461), d)
				}
			}
		case "restartPolicy":
			if r.TryDecodeAsNil() {
				x.RestartPolicy = ""
			} else {
				x.RestartPolicy = RestartPolicy(r.DecodeString())
			}
		case "terminationGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.TerminationGracePeriodSeconds != nil {
					x.TerminationGracePeriodSeconds = nil
				}
			} else {
				if x.TerminationGracePeriodSeconds == nil {
					x.TerminationGracePeriodSeconds = new(int64)
				}
				yym1465 := z.DecBinary()
				_ = yym1465
				if false {
				} else {
					*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym1467 := z.DecBinary()
				_ = yym1467
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "dnsPolicy":
			if r.TryDecodeAsNil() {
				x.DNSPolicy = ""
			} else {
				x.DNSPolicy = DNSPolicy(r.DecodeString())
			}
		case "nodeSelector":
			if r.TryDecodeAsNil() {
				x.NodeSelector = nil
			} else {
				yyv1469 := &x.NodeSelector
				yym1470 := z.DecBinary()
				_ = yym1470
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1469, false, d)
				}
			}
		case "serviceAccountName":
			if r.TryDecodeAsNil() {
				x.ServiceAccountName = ""
			} else {
				x.ServiceAccountName = string(r.DecodeString())
			}
		case "serviceAccount":
			if r.TryDecodeAsNil() {
				x.DeprecatedServiceAccount = ""
			} else {
				x.DeprecatedServiceAccount = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				x.NodeName = ""
			} else {
				x.NodeName = string(r.DecodeString())
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(PodSecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv1478 := &x.ImagePullSecrets
				yym1479 := z.DecBinary()
				_ = yym1479
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv1478), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1458)
		} // end switch yys1458
	} // end for yyj1458
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1480 int
	var yyb1480 bool
	var yyhl1480 bool = l >= 0
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv1481 := &x.Volumes
		yym1482 := z.DecBinary()
		_ = yym1482
		if false {
		} else {
			h.decSliceVolume((*[]Volume)(yyv1481), d)
		}
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv1483 := &x.Containers
		yym1484 := z.DecBinary()
		_ = yym1484
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv1483), d)
		}
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartPolicy = ""
	} else {
		x.RestartPolicy = RestartPolicy(r.DecodeString())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TerminationGracePeriodSeconds != nil {
			x.TerminationGracePeriodSeconds = nil
		}
	} else {
		if x.TerminationGracePeriodSeconds == nil {
			x.TerminationGracePeriodSeconds = new(int64)
		}
		yym1487 := z.DecBinary()
		_ = yym1487
		if false {
		} else {
			*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym1489 := z.DecBinary()
		_ = yym1489
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DNSPolicy = ""
	} else {
		x.DNSPolicy = DNSPolicy(r.DecodeString())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelector = nil
	} else {
		yyv1491 := &x.NodeSelector
		yym1492 := z.DecBinary()
		_ = yym1492
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1491, false, d)
		}
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountName = ""
	} else {
		x.ServiceAccountName = string(r.DecodeString())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedServiceAccount = ""
	} else {
		x.DeprecatedServiceAccount = string(r.DecodeString())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeName = ""
	} else {
		x.NodeName = string(r.DecodeString())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(PodSecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1480++
	if yyhl1480 {
		yyb1480 = yyj1480 > l
	} else {
		yyb1480 = r.CheckBreak()
	}
	if yyb1480 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv1500 := &x.ImagePullSecrets
		yym1501 := z.DecBinary()
		_ = yym1501
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv1500), d)
		}
	}
	for {
		yyj1480++
		if yyhl1480 {
			yyb1480 = yyj1480 > l
		} else {
			yyb1480 = r.CheckBreak()
		}
		if yyb1480 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1480-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityContext) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1502 := z.EncBinary()
		_ = yym1502
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1503 := !z.EncBinary()
			yy2arr1503 := z.EncBasicHandle().StructToArray
			var yyq1503 [5]bool
			_, _, _ = yysep1503, yyq1503, yy2arr1503
			const yyr1503 bool = false
			yyq1503[0] = x.SELinuxOptions != nil
			yyq1503[1] = x.RunAsUser != nil
			yyq1503[2] = x.RunAsNonRoot != nil
			yyq1503[3] = len(x.SupplementalGroups) != 0
			yyq1503[4] = x.FSGroup != nil
			var yynn1503 int
			if yyr1503 || yy2arr1503 {
				r.EncodeArrayStart(5)
			} else {
				yynn1503 = 0
				for _, b := range yyq1503 {
					if b {
						yynn1503++
					}
				}
				r.EncodeMapStart(yynn1503)
				yynn1503 = 0
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1503[0] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1503[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1503[1] {
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy1506 := *x.RunAsUser
						yym1507 := z.EncBinary()
						_ = yym1507
						if false {
						} else {
							r.EncodeInt(int64(yy1506))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1503[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy1508 := *x.RunAsUser
						yym1509 := z.EncBinary()
						_ = yym1509
						if false {
						} else {
							r.EncodeInt(int64(yy1508))
						}
					}
				}
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1503[2] {
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy1511 := *x.RunAsNonRoot
						yym1512 := z.EncBinary()
						_ = yym1512
						if false {
						} else {
							r.EncodeBool(bool(yy1511))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1503[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsNonRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy1513 := *x.RunAsNonRoot
						yym1514 := z.EncBinary()
						_ = yym1514
						if false {
						} else {
							r.EncodeBool(bool(yy1513))
						}
					}
				}
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1503[3] {
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym1516 := z.EncBinary()
						_ = yym1516
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1503[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym1517 := z.EncBinary()
						_ = yym1517
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				}
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1503[4] {
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy1519 := *x.FSGroup
						yym1520 := z.EncBinary()
						_ = yym1520
						if false {
						} else {
							r.EncodeInt(int64(yy1519))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1503[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy1521 := *x.FSGroup
						yym1522 := z.EncBinary()
						_ = yym1522
						if false {
						} else {
							r.EncodeInt(int64(yy1521))
						}
					}
				}
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityContext) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1523 := z.DecBinary()
	_ = yym1523
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1524 := r.ContainerType()
		if yyct1524 == codecSelferValueTypeMap1234 {
			yyl1524 := r.ReadMapStart()
			if yyl1524 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1524, d)
			}
		} else if yyct1524 == codecSelferValueTypeArray1234 {
			yyl1524 := r.ReadArrayStart()
			if yyl1524 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1524, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityContext) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1525Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1525Slc
	var yyhl1525 bool = l >= 0
	for yyj1525 := 0; ; yyj1525++ {
		if yyhl1525 {
			if yyj1525 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1525Slc = r.DecodeBytes(yys1525Slc, true, true)
		yys1525 := string(yys1525Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1525 {
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				if x.RunAsUser != nil {
					x.RunAsUser = nil
				}
			} else {
				if x.RunAsUser == nil {
					x.RunAsUser = new(int64)
				}
				yym1528 := z.DecBinary()
				_ = yym1528
				if false {
				} else {
					*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
				}
			}
		case "runAsNonRoot":
			if r.TryDecodeAsNil() {
				if x.RunAsNonRoot != nil {
					x.RunAsNonRoot = nil
				}
			} else {
				if x.RunAsNonRoot == nil {
					x.RunAsNonRoot = new(bool)
				}
				yym1530 := z.DecBinary()
				_ = yym1530
				if false {
				} else {
					*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
				}
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = nil
			} else {
				yyv1531 := &x.SupplementalGroups
				yym1532 := z.DecBinary()
				_ = yym1532
				if false {
				} else {
					z.F.DecSliceInt64X(yyv1531, false, d)
				}
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				if x.FSGroup != nil {
					x.FSGroup = nil
				}
			} else {
				if x.FSGroup == nil {
					x.FSGroup = new(int64)
				}
				yym1534 := z.DecBinary()
				_ = yym1534
				if false {
				} else {
					*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1525)
		} // end switch yys1525
	} // end for yyj1525
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityContext) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1535 int
	var yyb1535 bool
	var yyhl1535 bool = l >= 0
	yyj1535++
	if yyhl1535 {
		yyb1535 = yyj1535 > l
	} else {
		yyb1535 = r.CheckBreak()
	}
	if yyb1535 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	yyj1535++
	if yyhl1535 {
		yyb1535 = yyj1535 > l
	} else {
		yyb1535 = r.CheckBreak()
	}
	if yyb1535 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsUser != nil {
			x.RunAsUser = nil
		}
	} else {
		if x.RunAsUser == nil {
			x.RunAsUser = new(int64)
		}
		yym1538 := z.DecBinary()
		_ = yym1538
		if false {
		} else {
			*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
		}
	}
	yyj1535++
	if yyhl1535 {
		yyb1535 = yyj1535 > l
	} else {
		yyb1535 = r.CheckBreak()
	}
	if yyb1535 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsNonRoot != nil {
			x.RunAsNonRoot = nil
		}
	} else {
		if x.RunAsNonRoot == nil {
			x.RunAsNonRoot = new(bool)
		}
		yym1540 := z.DecBinary()
		_ = yym1540
		if false {
		} else {
			*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
		}
	}
	yyj1535++
	if yyhl1535 {
		yyb1535 = yyj1535 > l
	} else {
		yyb1535 = r.CheckBreak()
	}
	if yyb1535 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = nil
	} else {
		yyv1541 := &x.SupplementalGroups
		yym1542 := z.DecBinary()
		_ = yym1542
		if false {
		} else {
			z.F.DecSliceInt64X(yyv1541, false, d)
		}
	}
	yyj1535++
	if yyhl1535 {
		yyb1535 = yyj1535 > l
	} else {
		yyb1535 = r.CheckBreak()
	}
	if yyb1535 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSGroup != nil {
			x.FSGroup = nil
		}
	} else {
		if x.FSGroup == nil {
			x.FSGroup = new(int64)
		}
		yym1544 := z.DecBinary()
		_ = yym1544
		if false {
		} else {
			*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj1535++
		if yyhl1535 {
			yyb1535 = yyj1535 > l
		} else {
			yyb1535 = r.CheckBreak()
		}
		if yyb1535 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1535-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1545 := z.EncBinary()
		_ = yym1545
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1546 := !z.EncBinary()
			yy2arr1546 := z.EncBasicHandle().StructToArray
			var yyq1546 [8]bool
			_, _, _ = yysep1546, yyq1546, yy2arr1546
			const yyr1546 bool = false
			yyq1546[0] = x.Phase != ""
			yyq1546[1] = len(x.Conditions) != 0
			yyq1546[2] = x.Message != ""
			yyq1546[3] = x.Reason != ""
			yyq1546[4] = x.HostIP != ""
			yyq1546[5] = x.PodIP != ""
			yyq1546[6] = x.StartTime != nil
			yyq1546[7] = len(x.ContainerStatuses) != 0
			var yynn1546 int
			if yyr1546 || yy2arr1546 {
				r.EncodeArrayStart(8)
			} else {
				yynn1546 = 0
				for _, b := range yyq1546 {
					if b {
						yynn1546++
					}
				}
				r.EncodeMapStart(yynn1546)
				yynn1546 = 0
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1546[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[1] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym1549 := z.EncBinary()
						_ = yym1549
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1546[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym1550 := z.EncBinary()
						_ = yym1550
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[2] {
					yym1552 := z.EncBinary()
					_ = yym1552
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1546[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1553 := z.EncBinary()
					_ = yym1553
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[3] {
					yym1555 := z.EncBinary()
					_ = yym1555
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1546[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1556 := z.EncBinary()
					_ = yym1556
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[4] {
					yym1558 := z.EncBinary()
					_ = yym1558
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1546[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1559 := z.EncBinary()
					_ = yym1559
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[5] {
					yym1561 := z.EncBinary()
					_ = yym1561
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1546[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1562 := z.EncBinary()
					_ = yym1562
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[6] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym1564 := z.EncBinary()
						_ = yym1564
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym1564 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym1564 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1546[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym1565 := z.EncBinary()
						_ = yym1565
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym1565 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym1565 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1546[7] {
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym1567 := z.EncBinary()
						_ = yym1567
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1546[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym1568 := z.EncBinary()
						_ = yym1568
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1569 := z.DecBinary()
	_ = yym1569
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1570 := r.ContainerType()
		if yyct1570 == codecSelferValueTypeMap1234 {
			yyl1570 := r.ReadMapStart()
			if yyl1570 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1570, d)
			}
		} else if yyct1570 == codecSelferValueTypeArray1234 {
			yyl1570 := r.ReadArrayStart()
			if yyl1570 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1570, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1571Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1571Slc
	var yyhl1571 bool = l >= 0
	for yyj1571 := 0; ; yyj1571++ {
		if yyhl1571 {
			if yyj1571 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1571Slc = r.DecodeBytes(yys1571Slc, true, true)
		yys1571 := string(yys1571Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1571 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PodPhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv1573 := &x.Conditions
				yym1574 := z.DecBinary()
				_ = yym1574
				if false {
				} else {
					h.decSlicePodCondition((*[]PodCondition)(yyv1573), d)
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		case "podIP":
			if r.TryDecodeAsNil() {
				x.PodIP = ""
			} else {
				x.PodIP = string(r.DecodeString())
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg2_unversioned.Time)
				}
				yym1580 := z.DecBinary()
				_ = yym1580
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym1580 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym1580 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "containerStatuses":
			if r.TryDecodeAsNil() {
				x.ContainerStatuses = nil
			} else {
				yyv1581 := &x.ContainerStatuses
				yym1582 := z.DecBinary()
				_ = yym1582
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv1581), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1571)
		} // end switch yys1571
	} // end for yyj1571
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1583 int
	var yyb1583 bool
	var yyhl1583 bool = l >= 0
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PodPhase(r.DecodeString())
	}
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv1585 := &x.Conditions
		yym1586 := z.DecBinary()
		_ = yym1586
		if false {
		} else {
			h.decSlicePodCondition((*[]PodCondition)(yyv1585), d)
		}
	}
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodIP = ""
	} else {
		x.PodIP = string(r.DecodeString())
	}
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg2_unversioned.Time)
		}
		yym1592 := z.DecBinary()
		_ = yym1592
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym1592 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym1592 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj1583++
	if yyhl1583 {
		yyb1583 = yyj1583 > l
	} else {
		yyb1583 = r.CheckBreak()
	}
	if yyb1583 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerStatuses = nil
	} else {
		yyv1593 := &x.ContainerStatuses
		yym1594 := z.DecBinary()
		_ = yym1594
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv1593), d)
		}
	}
	for {
		yyj1583++
		if yyhl1583 {
			yyb1583 = yyj1583 > l
		} else {
			yyb1583 = r.CheckBreak()
		}
		if yyb1583 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1583-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatusResult) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1595 := z.EncBinary()
		_ = yym1595
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1596 := !z.EncBinary()
			yy2arr1596 := z.EncBasicHandle().StructToArray
			var yyq1596 [4]bool
			_, _, _ = yysep1596, yyq1596, yy2arr1596
			const yyr1596 bool = false
			yyq1596[0] = x.Kind != ""
			yyq1596[1] = x.APIVersion != ""
			yyq1596[2] = true
			yyq1596[3] = true
			var yynn1596 int
			if yyr1596 || yy2arr1596 {
				r.EncodeArrayStart(4)
			} else {
				yynn1596 = 0
				for _, b := range yyq1596 {
					if b {
						yynn1596++
					}
				}
				r.EncodeMapStart(yynn1596)
				yynn1596 = 0
			}
			if yyr1596 || yy2arr1596 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1596[0] {
					yym1598 := z.EncBinary()
					_ = yym1598
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1596[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1599 := z.EncBinary()
					_ = yym1599
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1596 || yy2arr1596 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1596[1] {
					yym1601 := z.EncBinary()
					_ = yym1601
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1596[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1602 := z.EncBinary()
					_ = yym1602
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1596 || yy2arr1596 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1596[2] {
					yy1604 := &x.ObjectMeta
					yy1604.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1596[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1605 := &x.ObjectMeta
					yy1605.CodecEncodeSelf(e)
				}
			}
			if yyr1596 || yy2arr1596 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1596[3] {
					yy1607 := &x.Status
					yy1607.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1596[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1608 := &x.Status
					yy1608.CodecEncodeSelf(e)
				}
			}
			if yyr1596 || yy2arr1596 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatusResult) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1609 := z.DecBinary()
	_ = yym1609
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1610 := r.ContainerType()
		if yyct1610 == codecSelferValueTypeMap1234 {
			yyl1610 := r.ReadMapStart()
			if yyl1610 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1610, d)
			}
		} else if yyct1610 == codecSelferValueTypeArray1234 {
			yyl1610 := r.ReadArrayStart()
			if yyl1610 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1610, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatusResult) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1611Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1611Slc
	var yyhl1611 bool = l >= 0
	for yyj1611 := 0; ; yyj1611++ {
		if yyhl1611 {
			if yyj1611 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1611Slc = r.DecodeBytes(yys1611Slc, true, true)
		yys1611 := string(yys1611Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1611 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1614 := &x.ObjectMeta
				yyv1614.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv1615 := &x.Status
				yyv1615.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1611)
		} // end switch yys1611
	} // end for yyj1611
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatusResult) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1616 int
	var yyb1616 bool
	var yyhl1616 bool = l >= 0
	yyj1616++
	if yyhl1616 {
		yyb1616 = yyj1616 > l
	} else {
		yyb1616 = r.CheckBreak()
	}
	if yyb1616 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1616++
	if yyhl1616 {
		yyb1616 = yyj1616 > l
	} else {
		yyb1616 = r.CheckBreak()
	}
	if yyb1616 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1616++
	if yyhl1616 {
		yyb1616 = yyj1616 > l
	} else {
		yyb1616 = r.CheckBreak()
	}
	if yyb1616 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1619 := &x.ObjectMeta
		yyv1619.CodecDecodeSelf(d)
	}
	yyj1616++
	if yyhl1616 {
		yyb1616 = yyj1616 > l
	} else {
		yyb1616 = r.CheckBreak()
	}
	if yyb1616 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv1620 := &x.Status
		yyv1620.CodecDecodeSelf(d)
	}
	for {
		yyj1616++
		if yyhl1616 {
			yyb1616 = yyj1616 > l
		} else {
			yyb1616 = r.CheckBreak()
		}
		if yyb1616 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1616-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Pod) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1621 := z.EncBinary()
		_ = yym1621
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1622 := !z.EncBinary()
			yy2arr1622 := z.EncBasicHandle().StructToArray
			var yyq1622 [5]bool
			_, _, _ = yysep1622, yyq1622, yy2arr1622
			const yyr1622 bool = false
			yyq1622[0] = x.Kind != ""
			yyq1622[1] = x.APIVersion != ""
			yyq1622[2] = true
			yyq1622[3] = true
			yyq1622[4] = true
			var yynn1622 int
			if yyr1622 || yy2arr1622 {
				r.EncodeArrayStart(5)
			} else {
				yynn1622 = 0
				for _, b := range yyq1622 {
					if b {
						yynn1622++
					}
				}
				r.EncodeMapStart(yynn1622)
				yynn1622 = 0
			}
			if yyr1622 || yy2arr1622 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1622[0] {
					yym1624 := z.EncBinary()
					_ = yym1624
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1622[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1625 := z.EncBinary()
					_ = yym1625
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1622 || yy2arr1622 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1622[1] {
					yym1627 := z.EncBinary()
					_ = yym1627
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1622[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1628 := z.EncBinary()
					_ = yym1628
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1622 || yy2arr1622 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1622[2] {
					yy1630 := &x.ObjectMeta
					yy1630.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1622[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1631 := &x.ObjectMeta
					yy1631.CodecEncodeSelf(e)
				}
			}
			if yyr1622 || yy2arr1622 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1622[3] {
					yy1633 := &x.Spec
					yy1633.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1622[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1634 := &x.Spec
					yy1634.CodecEncodeSelf(e)
				}
			}
			if yyr1622 || yy2arr1622 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1622[4] {
					yy1636 := &x.Status
					yy1636.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1622[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1637 := &x.Status
					yy1637.CodecEncodeSelf(e)
				}
			}
			if yyr1622 || yy2arr1622 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Pod) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1638 := z.DecBinary()
	_ = yym1638
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1639 := r.ContainerType()
		if yyct1639 == codecSelferValueTypeMap1234 {
			yyl1639 := r.ReadMapStart()
			if yyl1639 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1639, d)
			}
		} else if yyct1639 == codecSelferValueTypeArray1234 {
			yyl1639 := r.ReadArrayStart()
			if yyl1639 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1639, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Pod) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1640Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1640Slc
	var yyhl1640 bool = l >= 0
	for yyj1640 := 0; ; yyj1640++ {
		if yyhl1640 {
			if yyj1640 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1640Slc = r.DecodeBytes(yys1640Slc, true, true)
		yys1640 := string(yys1640Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1640 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1643 := &x.ObjectMeta
				yyv1643.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv1644 := &x.Spec
				yyv1644.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv1645 := &x.Status
				yyv1645.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1640)
		} // end switch yys1640
	} // end for yyj1640
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Pod) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1646 int
	var yyb1646 bool
	var yyhl1646 bool = l >= 0
	yyj1646++
	if yyhl1646 {
		yyb1646 = yyj1646 > l
	} else {
		yyb1646 = r.CheckBreak()
	}
	if yyb1646 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1646++
	if yyhl1646 {
		yyb1646 = yyj1646 > l
	} else {
		yyb1646 = r.CheckBreak()
	}
	if yyb1646 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1646++
	if yyhl1646 {
		yyb1646 = yyj1646 > l
	} else {
		yyb1646 = r.CheckBreak()
	}
	if yyb1646 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1649 := &x.ObjectMeta
		yyv1649.CodecDecodeSelf(d)
	}
	yyj1646++
	if yyhl1646 {
		yyb1646 = yyj1646 > l
	} else {
		yyb1646 = r.CheckBreak()
	}
	if yyb1646 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv1650 := &x.Spec
		yyv1650.CodecDecodeSelf(d)
	}
	yyj1646++
	if yyhl1646 {
		yyb1646 = yyj1646 > l
	} else {
		yyb1646 = r.CheckBreak()
	}
	if yyb1646 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv1651 := &x.Status
		yyv1651.CodecDecodeSelf(d)
	}
	for {
		yyj1646++
		if yyhl1646 {
			yyb1646 = yyj1646 > l
		} else {
			yyb1646 = r.CheckBreak()
		}
		if yyb1646 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1646-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1652 := z.EncBinary()
		_ = yym1652
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1653 := !z.EncBinary()
			yy2arr1653 := z.EncBasicHandle().StructToArray
			var yyq1653 [4]bool
			_, _, _ = yysep1653, yyq1653, yy2arr1653
			const yyr1653 bool = false
			yyq1653[0] = x.Kind != ""
			yyq1653[1] = x.APIVersion != ""
			yyq1653[2] = true
			var yynn1653 int
			if yyr1653 || yy2arr1653 {
				r.EncodeArrayStart(4)
			} else {
				yynn1653 = 1
				for _, b := range yyq1653 {
					if b {
						yynn1653++
					}
				}
				r.EncodeMapStart(yynn1653)
				yynn1653 = 0
			}
			if yyr1653 || yy2arr1653 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1653[0] {
					yym1655 := z.EncBinary()
					_ = yym1655
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1653[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1656 := z.EncBinary()
					_ = yym1656
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1653 || yy2arr1653 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1653[1] {
					yym1658 := z.EncBinary()
					_ = yym1658
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1653[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1659 := z.EncBinary()
					_ = yym1659
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1653 || yy2arr1653 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1653[2] {
					yy1661 := &x.ListMeta
					yym1662 := z.EncBinary()
					_ = yym1662
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1661) {
					} else {
						z.EncFallback(yy1661)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1653[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1663 := &x.ListMeta
					yym1664 := z.EncBinary()
					_ = yym1664
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1663) {
					} else {
						z.EncFallback(yy1663)
					}
				}
			}
			if yyr1653 || yy2arr1653 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1666 := z.EncBinary()
					_ = yym1666
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1667 := z.EncBinary()
					_ = yym1667
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			}
			if yyr1653 || yy2arr1653 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1668 := z.DecBinary()
	_ = yym1668
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1669 := r.ContainerType()
		if yyct1669 == codecSelferValueTypeMap1234 {
			yyl1669 := r.ReadMapStart()
			if yyl1669 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1669, d)
			}
		} else if yyct1669 == codecSelferValueTypeArray1234 {
			yyl1669 := r.ReadArrayStart()
			if yyl1669 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1669, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1670Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1670Slc
	var yyhl1670 bool = l >= 0
	for yyj1670 := 0; ; yyj1670++ {
		if yyhl1670 {
			if yyj1670 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1670Slc = r.DecodeBytes(yys1670Slc, true, true)
		yys1670 := string(yys1670Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1670 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1673 := &x.ListMeta
				yym1674 := z.DecBinary()
				_ = yym1674
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1673) {
				} else {
					z.DecFallback(yyv1673, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1675 := &x.Items
				yym1676 := z.DecBinary()
				_ = yym1676
				if false {
				} else {
					h.decSlicePod((*[]Pod)(yyv1675), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1670)
		} // end switch yys1670
	} // end for yyj1670
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1677 int
	var yyb1677 bool
	var yyhl1677 bool = l >= 0
	yyj1677++
	if yyhl1677 {
		yyb1677 = yyj1677 > l
	} else {
		yyb1677 = r.CheckBreak()
	}
	if yyb1677 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1677++
	if yyhl1677 {
		yyb1677 = yyj1677 > l
	} else {
		yyb1677 = r.CheckBreak()
	}
	if yyb1677 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1677++
	if yyhl1677 {
		yyb1677 = yyj1677 > l
	} else {
		yyb1677 = r.CheckBreak()
	}
	if yyb1677 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1680 := &x.ListMeta
		yym1681 := z.DecBinary()
		_ = yym1681
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1680) {
		} else {
			z.DecFallback(yyv1680, false)
		}
	}
	yyj1677++
	if yyhl1677 {
		yyb1677 = yyj1677 > l
	} else {
		yyb1677 = r.CheckBreak()
	}
	if yyb1677 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1682 := &x.Items
		yym1683 := z.DecBinary()
		_ = yym1683
		if false {
		} else {
			h.decSlicePod((*[]Pod)(yyv1682), d)
		}
	}
	for {
		yyj1677++
		if yyhl1677 {
			yyb1677 = yyj1677 > l
		} else {
			yyb1677 = r.CheckBreak()
		}
		if yyb1677 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1677-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1684 := z.EncBinary()
		_ = yym1684
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1685 := !z.EncBinary()
			yy2arr1685 := z.EncBasicHandle().StructToArray
			var yyq1685 [2]bool
			_, _, _ = yysep1685, yyq1685, yy2arr1685
			const yyr1685 bool = false
			yyq1685[0] = true
			yyq1685[1] = true
			var yynn1685 int
			if yyr1685 || yy2arr1685 {
				r.EncodeArrayStart(2)
			} else {
				yynn1685 = 0
				for _, b := range yyq1685 {
					if b {
						yynn1685++
					}
				}
				r.EncodeMapStart(yynn1685)
				yynn1685 = 0
			}
			if yyr1685 || yy2arr1685 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1685[0] {
					yy1687 := &x.ObjectMeta
					yy1687.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1685[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1688 := &x.ObjectMeta
					yy1688.CodecEncodeSelf(e)
				}
			}
			if yyr1685 || yy2arr1685 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1685[1] {
					yy1690 := &x.Spec
					yy1690.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1685[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1691 := &x.Spec
					yy1691.CodecEncodeSelf(e)
				}
			}
			if yyr1685 || yy2arr1685 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1692 := z.DecBinary()
	_ = yym1692
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1693 := r.ContainerType()
		if yyct1693 == codecSelferValueTypeMap1234 {
			yyl1693 := r.ReadMapStart()
			if yyl1693 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1693, d)
			}
		} else if yyct1693 == codecSelferValueTypeArray1234 {
			yyl1693 := r.ReadArrayStart()
			if yyl1693 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1693, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1694Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1694Slc
	var yyhl1694 bool = l >= 0
	for yyj1694 := 0; ; yyj1694++ {
		if yyhl1694 {
			if yyj1694 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1694Slc = r.DecodeBytes(yys1694Slc, true, true)
		yys1694 := string(yys1694Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1694 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1695 := &x.ObjectMeta
				yyv1695.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv1696 := &x.Spec
				yyv1696.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1694)
		} // end switch yys1694
	} // end for yyj1694
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1697 int
	var yyb1697 bool
	var yyhl1697 bool = l >= 0
	yyj1697++
	if yyhl1697 {
		yyb1697 = yyj1697 > l
	} else {
		yyb1697 = r.CheckBreak()
	}
	if yyb1697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1698 := &x.ObjectMeta
		yyv1698.CodecDecodeSelf(d)
	}
	yyj1697++
	if yyhl1697 {
		yyb1697 = yyj1697 > l
	} else {
		yyb1697 = r.CheckBreak()
	}
	if yyb1697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv1699 := &x.Spec
		yyv1699.CodecDecodeSelf(d)
	}
	for {
		yyj1697++
		if yyhl1697 {
			yyb1697 = yyj1697 > l
		} else {
			yyb1697 = r.CheckBreak()
		}
		if yyb1697 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1697-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1700 := z.EncBinary()
		_ = yym1700
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1701 := !z.EncBinary()
			yy2arr1701 := z.EncBasicHandle().StructToArray
			var yyq1701 [4]bool
			_, _, _ = yysep1701, yyq1701, yy2arr1701
			const yyr1701 bool = false
			yyq1701[0] = x.Kind != ""
			yyq1701[1] = x.APIVersion != ""
			yyq1701[2] = true
			yyq1701[3] = true
			var yynn1701 int
			if yyr1701 || yy2arr1701 {
				r.EncodeArrayStart(4)
			} else {
				yynn1701 = 0
				for _, b := range yyq1701 {
					if b {
						yynn1701++
					}
				}
				r.EncodeMapStart(yynn1701)
				yynn1701 = 0
			}
			if yyr1701 || yy2arr1701 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1701[0] {
					yym1703 := z.EncBinary()
					_ = yym1703
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1701[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1704 := z.EncBinary()
					_ = yym1704
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1701 || yy2arr1701 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1701[1] {
					yym1706 := z.EncBinary()
					_ = yym1706
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1701[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1707 := z.EncBinary()
					_ = yym1707
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1701 || yy2arr1701 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1701[2] {
					yy1709 := &x.ObjectMeta
					yy1709.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1701[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1710 := &x.ObjectMeta
					yy1710.CodecEncodeSelf(e)
				}
			}
			if yyr1701 || yy2arr1701 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1701[3] {
					yy1712 := &x.Template
					yy1712.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1701[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1713 := &x.Template
					yy1713.CodecEncodeSelf(e)
				}
			}
			if yyr1701 || yy2arr1701 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1714 := z.DecBinary()
	_ = yym1714
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1715 := r.ContainerType()
		if yyct1715 == codecSelferValueTypeMap1234 {
			yyl1715 := r.ReadMapStart()
			if yyl1715 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1715, d)
			}
		} else if yyct1715 == codecSelferValueTypeArray1234 {
			yyl1715 := r.ReadArrayStart()
			if yyl1715 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1715, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1716Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1716Slc
	var yyhl1716 bool = l >= 0
	for yyj1716 := 0; ; yyj1716++ {
		if yyhl1716 {
			if yyj1716 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1716Slc = r.DecodeBytes(yys1716Slc, true, true)
		yys1716 := string(yys1716Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1716 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1719 := &x.ObjectMeta
				yyv1719.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = PodTemplateSpec{}
			} else {
				yyv1720 := &x.Template
				yyv1720.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1716)
		} // end switch yys1716
	} // end for yyj1716
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1721 int
	var yyb1721 bool
	var yyhl1721 bool = l >= 0
	yyj1721++
	if yyhl1721 {
		yyb1721 = yyj1721 > l
	} else {
		yyb1721 = r.CheckBreak()
	}
	if yyb1721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1721++
	if yyhl1721 {
		yyb1721 = yyj1721 > l
	} else {
		yyb1721 = r.CheckBreak()
	}
	if yyb1721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1721++
	if yyhl1721 {
		yyb1721 = yyj1721 > l
	} else {
		yyb1721 = r.CheckBreak()
	}
	if yyb1721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1724 := &x.ObjectMeta
		yyv1724.CodecDecodeSelf(d)
	}
	yyj1721++
	if yyhl1721 {
		yyb1721 = yyj1721 > l
	} else {
		yyb1721 = r.CheckBreak()
	}
	if yyb1721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = PodTemplateSpec{}
	} else {
		yyv1725 := &x.Template
		yyv1725.CodecDecodeSelf(d)
	}
	for {
		yyj1721++
		if yyhl1721 {
			yyb1721 = yyj1721 > l
		} else {
			yyb1721 = r.CheckBreak()
		}
		if yyb1721 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1721-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1726 := z.EncBinary()
		_ = yym1726
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1727 := !z.EncBinary()
			yy2arr1727 := z.EncBasicHandle().StructToArray
			var yyq1727 [4]bool
			_, _, _ = yysep1727, yyq1727, yy2arr1727
			const yyr1727 bool = false
			yyq1727[0] = x.Kind != ""
			yyq1727[1] = x.APIVersion != ""
			yyq1727[2] = true
			var yynn1727 int
			if yyr1727 || yy2arr1727 {
				r.EncodeArrayStart(4)
			} else {
				yynn1727 = 1
				for _, b := range yyq1727 {
					if b {
						yynn1727++
					}
				}
				r.EncodeMapStart(yynn1727)
				yynn1727 = 0
			}
			if yyr1727 || yy2arr1727 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1727[0] {
					yym1729 := z.EncBinary()
					_ = yym1729
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1727[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1730 := z.EncBinary()
					_ = yym1730
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1727 || yy2arr1727 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1727[1] {
					yym1732 := z.EncBinary()
					_ = yym1732
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1727[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1733 := z.EncBinary()
					_ = yym1733
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1727 || yy2arr1727 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1727[2] {
					yy1735 := &x.ListMeta
					yym1736 := z.EncBinary()
					_ = yym1736
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1735) {
					} else {
						z.EncFallback(yy1735)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1727[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1737 := &x.ListMeta
					yym1738 := z.EncBinary()
					_ = yym1738
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1737) {
					} else {
						z.EncFallback(yy1737)
					}
				}
			}
			if yyr1727 || yy2arr1727 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1740 := z.EncBinary()
					_ = yym1740
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1741 := z.EncBinary()
					_ = yym1741
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			}
			if yyr1727 || yy2arr1727 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1742 := z.DecBinary()
	_ = yym1742
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1743 := r.ContainerType()
		if yyct1743 == codecSelferValueTypeMap1234 {
			yyl1743 := r.ReadMapStart()
			if yyl1743 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1743, d)
			}
		} else if yyct1743 == codecSelferValueTypeArray1234 {
			yyl1743 := r.ReadArrayStart()
			if yyl1743 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1743, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1744Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1744Slc
	var yyhl1744 bool = l >= 0
	for yyj1744 := 0; ; yyj1744++ {
		if yyhl1744 {
			if yyj1744 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1744Slc = r.DecodeBytes(yys1744Slc, true, true)
		yys1744 := string(yys1744Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1744 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1747 := &x.ListMeta
				yym1748 := z.DecBinary()
				_ = yym1748
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1747) {
				} else {
					z.DecFallback(yyv1747, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1749 := &x.Items
				yym1750 := z.DecBinary()
				_ = yym1750
				if false {
				} else {
					h.decSlicePodTemplate((*[]PodTemplate)(yyv1749), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1744)
		} // end switch yys1744
	} // end for yyj1744
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1751 int
	var yyb1751 bool
	var yyhl1751 bool = l >= 0
	yyj1751++
	if yyhl1751 {
		yyb1751 = yyj1751 > l
	} else {
		yyb1751 = r.CheckBreak()
	}
	if yyb1751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1751++
	if yyhl1751 {
		yyb1751 = yyj1751 > l
	} else {
		yyb1751 = r.CheckBreak()
	}
	if yyb1751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1751++
	if yyhl1751 {
		yyb1751 = yyj1751 > l
	} else {
		yyb1751 = r.CheckBreak()
	}
	if yyb1751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1754 := &x.ListMeta
		yym1755 := z.DecBinary()
		_ = yym1755
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1754) {
		} else {
			z.DecFallback(yyv1754, false)
		}
	}
	yyj1751++
	if yyhl1751 {
		yyb1751 = yyj1751 > l
	} else {
		yyb1751 = r.CheckBreak()
	}
	if yyb1751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1756 := &x.Items
		yym1757 := z.DecBinary()
		_ = yym1757
		if false {
		} else {
			h.decSlicePodTemplate((*[]PodTemplate)(yyv1756), d)
		}
	}
	for {
		yyj1751++
		if yyhl1751 {
			yyb1751 = yyj1751 > l
		} else {
			yyb1751 = r.CheckBreak()
		}
		if yyb1751 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1751-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1758 := z.EncBinary()
		_ = yym1758
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1759 := !z.EncBinary()
			yy2arr1759 := z.EncBasicHandle().StructToArray
			var yyq1759 [3]bool
			_, _, _ = yysep1759, yyq1759, yy2arr1759
			const yyr1759 bool = false
			yyq1759[0] = x.Replicas != nil
			yyq1759[1] = len(x.Selector) != 0
			yyq1759[2] = x.Template != nil
			var yynn1759 int
			if yyr1759 || yy2arr1759 {
				r.EncodeArrayStart(3)
			} else {
				yynn1759 = 0
				for _, b := range yyq1759 {
					if b {
						yynn1759++
					}
				}
				r.EncodeMapStart(yynn1759)
				yynn1759 = 0
			}
			if yyr1759 || yy2arr1759 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1759[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy1761 := *x.Replicas
						yym1762 := z.EncBinary()
						_ = yym1762
						if false {
						} else {
							r.EncodeInt(int64(yy1761))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1759[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy1763 := *x.Replicas
						yym1764 := z.EncBinary()
						_ = yym1764
						if false {
						} else {
							r.EncodeInt(int64(yy1763))
						}
					}
				}
			}
			if yyr1759 || yy2arr1759 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1759[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym1766 := z.EncBinary()
						_ = yym1766
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1759[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym1767 := z.EncBinary()
						_ = yym1767
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr1759 || yy2arr1759 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1759[2] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1759[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1759 || yy2arr1759 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1769 := z.DecBinary()
	_ = yym1769
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1770 := r.ContainerType()
		if yyct1770 == codecSelferValueTypeMap1234 {
			yyl1770 := r.ReadMapStart()
			if yyl1770 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1770, d)
			}
		} else if yyct1770 == codecSelferValueTypeArray1234 {
			yyl1770 := r.ReadArrayStart()
			if yyl1770 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1770, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1771Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1771Slc
	var yyhl1771 bool = l >= 0
	for yyj1771 := 0; ; yyj1771++ {
		if yyhl1771 {
			if yyj1771 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1771Slc = r.DecodeBytes(yys1771Slc, true, true)
		yys1771 := string(yys1771Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1771 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym1773 := z.DecBinary()
				_ = yym1773
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv1774 := &x.Selector
				yym1775 := z.DecBinary()
				_ = yym1775
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1774, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1771)
		} // end switch yys1771
	} // end for yyj1771
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1777 int
	var yyb1777 bool
	var yyhl1777 bool = l >= 0
	yyj1777++
	if yyhl1777 {
		yyb1777 = yyj1777 > l
	} else {
		yyb1777 = r.CheckBreak()
	}
	if yyb1777 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym1779 := z.DecBinary()
		_ = yym1779
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj1777++
	if yyhl1777 {
		yyb1777 = yyj1777 > l
	} else {
		yyb1777 = r.CheckBreak()
	}
	if yyb1777 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv1780 := &x.Selector
		yym1781 := z.DecBinary()
		_ = yym1781
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1780, false, d)
		}
	}
	yyj1777++
	if yyhl1777 {
		yyb1777 = yyj1777 > l
	} else {
		yyb1777 = r.CheckBreak()
	}
	if yyb1777 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj1777++
		if yyhl1777 {
			yyb1777 = yyj1777 > l
		} else {
			yyb1777 = r.CheckBreak()
		}
		if yyb1777 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1777-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1783 := z.EncBinary()
		_ = yym1783
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1784 := !z.EncBinary()
			yy2arr1784 := z.EncBasicHandle().StructToArray
			var yyq1784 [2]bool
			_, _, _ = yysep1784, yyq1784, yy2arr1784
			const yyr1784 bool = false
			yyq1784[1] = x.ObservedGeneration != 0
			var yynn1784 int
			if yyr1784 || yy2arr1784 {
				r.EncodeArrayStart(2)
			} else {
				yynn1784 = 1
				for _, b := range yyq1784 {
					if b {
						yynn1784++
					}
				}
				r.EncodeMapStart(yynn1784)
				yynn1784 = 0
			}
			if yyr1784 || yy2arr1784 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1786 := z.EncBinary()
				_ = yym1786
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1787 := z.EncBinary()
				_ = yym1787
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr1784 || yy2arr1784 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1784[1] {
					yym1789 := z.EncBinary()
					_ = yym1789
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1784[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1790 := z.EncBinary()
					_ = yym1790
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr1784 || yy2arr1784 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1791 := z.DecBinary()
	_ = yym1791
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1792 := r.ContainerType()
		if yyct1792 == codecSelferValueTypeMap1234 {
			yyl1792 := r.ReadMapStart()
			if yyl1792 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1792, d)
			}
		} else if yyct1792 == codecSelferValueTypeArray1234 {
			yyl1792 := r.ReadArrayStart()
			if yyl1792 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1792, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1793Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1793Slc
	var yyhl1793 bool = l >= 0
	for yyj1793 := 0; ; yyj1793++ {
		if yyhl1793 {
			if yyj1793 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1793Slc = r.DecodeBytes(yys1793Slc, true, true)
		yys1793 := string(yys1793Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1793 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1793)
		} // end switch yys1793
	} // end for yyj1793
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1796 int
	var yyb1796 bool
	var yyhl1796 bool = l >= 0
	yyj1796++
	if yyhl1796 {
		yyb1796 = yyj1796 > l
	} else {
		yyb1796 = r.CheckBreak()
	}
	if yyb1796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj1796++
	if yyhl1796 {
		yyb1796 = yyj1796 > l
	} else {
		yyb1796 = r.CheckBreak()
	}
	if yyb1796 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	for {
		yyj1796++
		if yyhl1796 {
			yyb1796 = yyj1796 > l
		} else {
			yyb1796 = r.CheckBreak()
		}
		if yyb1796 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1796-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationController) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1799 := z.EncBinary()
		_ = yym1799
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1800 := !z.EncBinary()
			yy2arr1800 := z.EncBasicHandle().StructToArray
			var yyq1800 [5]bool
			_, _, _ = yysep1800, yyq1800, yy2arr1800
			const yyr1800 bool = false
			yyq1800[0] = x.Kind != ""
			yyq1800[1] = x.APIVersion != ""
			yyq1800[2] = true
			yyq1800[3] = true
			yyq1800[4] = true
			var yynn1800 int
			if yyr1800 || yy2arr1800 {
				r.EncodeArrayStart(5)
			} else {
				yynn1800 = 0
				for _, b := range yyq1800 {
					if b {
						yynn1800++
					}
				}
				r.EncodeMapStart(yynn1800)
				yynn1800 = 0
			}
			if yyr1800 || yy2arr1800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1800[0] {
					yym1802 := z.EncBinary()
					_ = yym1802
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1800[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1803 := z.EncBinary()
					_ = yym1803
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1800 || yy2arr1800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1800[1] {
					yym1805 := z.EncBinary()
					_ = yym1805
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1800[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1806 := z.EncBinary()
					_ = yym1806
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1800 || yy2arr1800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1800[2] {
					yy1808 := &x.ObjectMeta
					yy1808.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1800[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1809 := &x.ObjectMeta
					yy1809.CodecEncodeSelf(e)
				}
			}
			if yyr1800 || yy2arr1800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1800[3] {
					yy1811 := &x.Spec
					yy1811.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1800[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1812 := &x.Spec
					yy1812.CodecEncodeSelf(e)
				}
			}
			if yyr1800 || yy2arr1800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1800[4] {
					yy1814 := &x.Status
					yy1814.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1800[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1815 := &x.Status
					yy1815.CodecEncodeSelf(e)
				}
			}
			if yyr1800 || yy2arr1800 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationController) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1816 := z.DecBinary()
	_ = yym1816
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1817 := r.ContainerType()
		if yyct1817 == codecSelferValueTypeMap1234 {
			yyl1817 := r.ReadMapStart()
			if yyl1817 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1817, d)
			}
		} else if yyct1817 == codecSelferValueTypeArray1234 {
			yyl1817 := r.ReadArrayStart()
			if yyl1817 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1817, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationController) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1818Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1818Slc
	var yyhl1818 bool = l >= 0
	for yyj1818 := 0; ; yyj1818++ {
		if yyhl1818 {
			if yyj1818 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1818Slc = r.DecodeBytes(yys1818Slc, true, true)
		yys1818 := string(yys1818Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1818 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv1821 := &x.ObjectMeta
				yyv1821.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicationControllerSpec{}
			} else {
				yyv1822 := &x.Spec
				yyv1822.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicationControllerStatus{}
			} else {
				yyv1823 := &x.Status
				yyv1823.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1818)
		} // end switch yys1818
	} // end for yyj1818
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationController) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1824 int
	var yyb1824 bool
	var yyhl1824 bool = l >= 0
	yyj1824++
	if yyhl1824 {
		yyb1824 = yyj1824 > l
	} else {
		yyb1824 = r.CheckBreak()
	}
	if yyb1824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1824++
	if yyhl1824 {
		yyb1824 = yyj1824 > l
	} else {
		yyb1824 = r.CheckBreak()
	}
	if yyb1824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1824++
	if yyhl1824 {
		yyb1824 = yyj1824 > l
	} else {
		yyb1824 = r.CheckBreak()
	}
	if yyb1824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv1827 := &x.ObjectMeta
		yyv1827.CodecDecodeSelf(d)
	}
	yyj1824++
	if yyhl1824 {
		yyb1824 = yyj1824 > l
	} else {
		yyb1824 = r.CheckBreak()
	}
	if yyb1824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicationControllerSpec{}
	} else {
		yyv1828 := &x.Spec
		yyv1828.CodecDecodeSelf(d)
	}
	yyj1824++
	if yyhl1824 {
		yyb1824 = yyj1824 > l
	} else {
		yyb1824 = r.CheckBreak()
	}
	if yyb1824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicationControllerStatus{}
	} else {
		yyv1829 := &x.Status
		yyv1829.CodecDecodeSelf(d)
	}
	for {
		yyj1824++
		if yyhl1824 {
			yyb1824 = yyj1824 > l
		} else {
			yyb1824 = r.CheckBreak()
		}
		if yyb1824 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1824-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1830 := z.EncBinary()
		_ = yym1830
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1831 := !z.EncBinary()
			yy2arr1831 := z.EncBasicHandle().StructToArray
			var yyq1831 [4]bool
			_, _, _ = yysep1831, yyq1831, yy2arr1831
			const yyr1831 bool = false
			yyq1831[0] = x.Kind != ""
			yyq1831[1] = x.APIVersion != ""
			yyq1831[2] = true
			var yynn1831 int
			if yyr1831 || yy2arr1831 {
				r.EncodeArrayStart(4)
			} else {
				yynn1831 = 1
				for _, b := range yyq1831 {
					if b {
						yynn1831++
					}
				}
				r.EncodeMapStart(yynn1831)
				yynn1831 = 0
			}
			if yyr1831 || yy2arr1831 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1831[0] {
					yym1833 := z.EncBinary()
					_ = yym1833
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1831[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1834 := z.EncBinary()
					_ = yym1834
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1831 || yy2arr1831 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1831[1] {
					yym1836 := z.EncBinary()
					_ = yym1836
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1831[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1837 := z.EncBinary()
					_ = yym1837
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1831 || yy2arr1831 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1831[2] {
					yy1839 := &x.ListMeta
					yym1840 := z.EncBinary()
					_ = yym1840
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1839) {
					} else {
						z.EncFallback(yy1839)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1831[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1841 := &x.ListMeta
					yym1842 := z.EncBinary()
					_ = yym1842
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1841) {
					} else {
						z.EncFallback(yy1841)
					}
				}
			}
			if yyr1831 || yy2arr1831 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1844 := z.EncBinary()
					_ = yym1844
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1845 := z.EncBinary()
					_ = yym1845
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			}
			if yyr1831 || yy2arr1831 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1846 := z.DecBinary()
	_ = yym1846
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1847 := r.ContainerType()
		if yyct1847 == codecSelferValueTypeMap1234 {
			yyl1847 := r.ReadMapStart()
			if yyl1847 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1847, d)
			}
		} else if yyct1847 == codecSelferValueTypeArray1234 {
			yyl1847 := r.ReadArrayStart()
			if yyl1847 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1847, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1848Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1848Slc
	var yyhl1848 bool = l >= 0
	for yyj1848 := 0; ; yyj1848++ {
		if yyhl1848 {
			if yyj1848 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1848Slc = r.DecodeBytes(yys1848Slc, true, true)
		yys1848 := string(yys1848Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1848 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1851 := &x.ListMeta
				yym1852 := z.DecBinary()
				_ = yym1852
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1851) {
				} else {
					z.DecFallback(yyv1851, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1853 := &x.Items
				yym1854 := z.DecBinary()
				_ = yym1854
				if false {
				} else {
					h.decSliceReplicationController((*[]ReplicationController)(yyv1853), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1848)
		} // end switch yys1848
	} // end for yyj1848
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1855 int
	var yyb1855 bool
	var yyhl1855 bool = l >= 0
	yyj1855++
	if yyhl1855 {
		yyb1855 = yyj1855 > l
	} else {
		yyb1855 = r.CheckBreak()
	}
	if yyb1855 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1855++
	if yyhl1855 {
		yyb1855 = yyj1855 > l
	} else {
		yyb1855 = r.CheckBreak()
	}
	if yyb1855 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1855++
	if yyhl1855 {
		yyb1855 = yyj1855 > l
	} else {
		yyb1855 = r.CheckBreak()
	}
	if yyb1855 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1858 := &x.ListMeta
		yym1859 := z.DecBinary()
		_ = yym1859
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1858) {
		} else {
			z.DecFallback(yyv1858, false)
		}
	}
	yyj1855++
	if yyhl1855 {
		yyb1855 = yyj1855 > l
	} else {
		yyb1855 = r.CheckBreak()
	}
	if yyb1855 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1860 := &x.Items
		yym1861 := z.DecBinary()
		_ = yym1861
		if false {
		} else {
			h.decSliceReplicationController((*[]ReplicationController)(yyv1860), d)
		}
	}
	for {
		yyj1855++
		if yyhl1855 {
			yyb1855 = yyj1855 > l
		} else {
			yyb1855 = r.CheckBreak()
		}
		if yyb1855 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1855-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ServiceAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1862 := z.EncBinary()
	_ = yym1862
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1863 := z.DecBinary()
	_ = yym1863
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ServiceType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1864 := z.EncBinary()
	_ = yym1864
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1865 := z.DecBinary()
	_ = yym1865
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ServiceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1866 := z.EncBinary()
		_ = yym1866
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1867 := !z.EncBinary()
			yy2arr1867 := z.EncBasicHandle().StructToArray
			var yyq1867 [1]bool
			_, _, _ = yysep1867, yyq1867, yy2arr1867
			const yyr1867 bool = false
			yyq1867[0] = true
			var yynn1867 int
			if yyr1867 || yy2arr1867 {
				r.EncodeArrayStart(1)
			} else {
				yynn1867 = 0
				for _, b := range yyq1867 {
					if b {
						yynn1867++
					}
				}
				r.EncodeMapStart(yynn1867)
				yynn1867 = 0
			}
			if yyr1867 || yy2arr1867 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1867[0] {
					yy1869 := &x.LoadBalancer
					yy1869.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1867[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1870 := &x.LoadBalancer
					yy1870.CodecEncodeSelf(e)
				}
			}
			if yyr1867 || yy2arr1867 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1871 := z.DecBinary()
	_ = yym1871
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1872 := r.ContainerType()
		if yyct1872 == codecSelferValueTypeMap1234 {
			yyl1872 := r.ReadMapStart()
			if yyl1872 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1872, d)
			}
		} else if yyct1872 == codecSelferValueTypeArray1234 {
			yyl1872 := r.ReadArrayStart()
			if yyl1872 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1872, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1873Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1873Slc
	var yyhl1873 bool = l >= 0
	for yyj1873 := 0; ; yyj1873++ {
		if yyhl1873 {
			if yyj1873 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1873Slc = r.DecodeBytes(yys1873Slc, true, true)
		yys1873 := string(yys1873Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1873 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = LoadBalancerStatus{}
			} else {
				yyv1874 := &x.LoadBalancer
				yyv1874.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1873)
		} // end switch yys1873
	} // end for yyj1873
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1875 int
	var yyb1875 bool
	var yyhl1875 bool = l >= 0
	yyj1875++
	if yyhl1875 {
		yyb1875 = yyj1875 > l
	} else {
		yyb1875 = r.CheckBreak()
	}
	if yyb1875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = LoadBalancerStatus{}
	} else {
		yyv1876 := &x.LoadBalancer
		yyv1876.CodecDecodeSelf(d)
	}
	for {
		yyj1875++
		if yyhl1875 {
			yyb1875 = yyj1875 > l
		} else {
			yyb1875 = r.CheckBreak()
		}
		if yyb1875 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1875-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1877 := z.EncBinary()
		_ = yym1877
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1878 := !z.EncBinary()
			yy2arr1878 := z.EncBasicHandle().StructToArray
			var yyq1878 [1]bool
			_, _, _ = yysep1878, yyq1878, yy2arr1878
			const yyr1878 bool = false
			yyq1878[0] = len(x.Ingress) != 0
			var yynn1878 int
			if yyr1878 || yy2arr1878 {
				r.EncodeArrayStart(1)
			} else {
				yynn1878 = 0
				for _, b := range yyq1878 {
					if b {
						yynn1878++
					}
				}
				r.EncodeMapStart(yynn1878)
				yynn1878 = 0
			}
			if yyr1878 || yy2arr1878 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1878[0] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1880 := z.EncBinary()
						_ = yym1880
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1878[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1881 := z.EncBinary()
						_ = yym1881
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				}
			}
			if yyr1878 || yy2arr1878 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1882 := z.DecBinary()
	_ = yym1882
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1883 := r.ContainerType()
		if yyct1883 == codecSelferValueTypeMap1234 {
			yyl1883 := r.ReadMapStart()
			if yyl1883 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1883, d)
			}
		} else if yyct1883 == codecSelferValueTypeArray1234 {
			yyl1883 := r.ReadArrayStart()
			if yyl1883 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1883, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1884Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1884Slc
	var yyhl1884 bool = l >= 0
	for yyj1884 := 0; ; yyj1884++ {
		if yyhl1884 {
			if yyj1884 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1884Slc = r.DecodeBytes(yys1884Slc, true, true)
		yys1884 := string(yys1884Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1884 {
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv1885 := &x.Ingress
				yym1886 := z.DecBinary()
				_ = yym1886
				if false {
				} else {
					h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv1885), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1884)
		} // end switch yys1884
	} // end for yyj1884
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1887 int
	var yyb1887 bool
	var yyhl1887 bool = l >= 0
	yyj1887++
	if yyhl1887 {
		yyb1887 = yyj1887 > l
	} else {
		yyb1887 = r.CheckBreak()
	}
	if yyb1887 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv1888 := &x.Ingress
		yym1889 := z.DecBinary()
		_ = yym1889
		if false {
		} else {
			h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv1888), d)
		}
	}
	for {
		yyj1887++
		if yyhl1887 {
			yyb1887 = yyj1887 > l
		} else {
			yyb1887 = r.CheckBreak()
		}
		if yyb1887 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1887-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerIngress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1890 := z.EncBinary()
		_ = yym1890
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1891 := !z.EncBinary()
			yy2arr1891 := z.EncBasicHandle().StructToArray
			var yyq1891 [2]bool
			_, _, _ = yysep1891, yyq1891, yy2arr1891
			const yyr1891 bool = false
			yyq1891[0] = x.IP != ""
			yyq1891[1] = x.Hostname != ""
			var yynn1891 int
			if yyr1891 || yy2arr1891 {
				r.EncodeArrayStart(2)
			} else {
				yynn1891 = 0
				for _, b := range yyq1891 {
					if b {
						yynn1891++
					}
				}
				r.EncodeMapStart(yynn1891)
				yynn1891 = 0
			}
			if yyr1891 || yy2arr1891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1891[0] {
					yym1893 := z.EncBinary()
					_ = yym1893
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1891[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ip"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1894 := z.EncBinary()
					_ = yym1894
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				}
			}
			if yyr1891 || yy2arr1891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1891[1] {
					yym1896 := z.EncBinary()
					_ = yym1896
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1891[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1897 := z.EncBinary()
					_ = yym1897
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr1891 || yy2arr1891 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerIngress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1898 := z.DecBinary()
	_ = yym1898
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1899 := r.ContainerType()
		if yyct1899 == codecSelferValueTypeMap1234 {
			yyl1899 := r.ReadMapStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1899, d)
			}
		} else if yyct1899 == codecSelferValueTypeArray1234 {
			yyl1899 := r.ReadArrayStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1899, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerIngress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1900Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1900Slc
	var yyhl1900 bool = l >= 0
	for yyj1900 := 0; ; yyj1900++ {
		if yyhl1900 {
			if yyj1900 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1900Slc = r.DecodeBytes(yys1900Slc, true, true)
		yys1900 := string(yys1900Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1900 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1900)
		} // end switch yys1900
	} // end for yyj1900
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerIngress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1903 int
	var yyb1903 bool
	var yyhl1903 bool = l >= 0
	yyj1903++
	if yyhl1903 {
		yyb1903 = yyj1903 > l
	} else {
		yyb1903 = r.CheckBreak()
	}
	if yyb1903 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj1903++
	if yyhl1903 {
		yyb1903 = yyj1903 > l
	} else {
		yyb1903 = r.CheckBreak()
	}
	if yyb1903 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	for {
		yyj1903++
		if yyhl1903 {
			yyb1903 = yyj1903 > l
		} else {
			yyb1903 = r.CheckBreak()
		}
		if yyb1903 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1903-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1906 := z.EncBinary()
		_ = yym1906
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1907 := !z.EncBinary()
			yy2arr1907 := z.EncBasicHandle().StructToArray
			var yyq1907 [8]bool
			_, _, _ = yysep1907, yyq1907, yy2arr1907
			const yyr1907 bool = false
			yyq1907[1] = len(x.Selector) != 0
			yyq1907[2] = x.ClusterIP != ""
			yyq1907[3] = x.Type != ""
			yyq1907[4] = len(x.ExternalIPs) != 0
			yyq1907[5] = len(x.DeprecatedPublicIPs) != 0
			yyq1907[6] = x.SessionAffinity != ""
			yyq1907[7] = x.LoadBalancerIP != ""
			var yynn1907 int
			if yyr1907 || yy2arr1907 {
				r.EncodeArrayStart(8)
			} else {
				yynn1907 = 1
				for _, b := range yyq1907 {
					if b {
						yynn1907++
					}
				}
				r.EncodeMapStart(yynn1907)
				yynn1907 = 0
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym1909 := z.EncBinary()
					_ = yym1909
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym1910 := z.EncBinary()
					_ = yym1910
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym1912 := z.EncBinary()
						_ = yym1912
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1907[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym1913 := z.EncBinary()
						_ = yym1913
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[2] {
					yym1915 := z.EncBinary()
					_ = yym1915
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1907[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1916 := z.EncBinary()
					_ = yym1916
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[3] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1907[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[4] {
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym1919 := z.EncBinary()
						_ = yym1919
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1907[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym1920 := z.EncBinary()
						_ = yym1920
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[5] {
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym1922 := z.EncBinary()
						_ = yym1922
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1907[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deprecatedPublicIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym1923 := z.EncBinary()
						_ = yym1923
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[6] {
					x.SessionAffinity.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1907[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sessionAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.SessionAffinity.CodecEncodeSelf(e)
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[7] {
					yym1926 := z.EncBinary()
					_ = yym1926
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1907[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1927 := z.EncBinary()
					_ = yym1927
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1928 := z.DecBinary()
	_ = yym1928
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1929 := r.ContainerType()
		if yyct1929 == codecSelferValueTypeMap1234 {
			yyl1929 := r.ReadMapStart()
			if yyl1929 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1929, d)
			}
		} else if yyct1929 == codecSelferValueTypeArray1234 {
			yyl1929 := r.ReadArrayStart()
			if yyl1929 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1929, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1930Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1930Slc
	var yyhl1930 bool = l >= 0
	for yyj1930 := 0; ; yyj1930++ {
		if yyhl1930 {
			if yyj1930 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1930Slc = r.DecodeBytes(yys1930Slc, true, true)
		yys1930 := string(yys1930Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1930 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1931 := &x.Ports
				yym1932 := z.DecBinary()
				_ = yym1932
				if false {
				} else {
					h.decSliceServicePort((*[]ServicePort)(yyv1931), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv1933 := &x.Selector
				yym1934 := z.DecBinary()
				_ = yym1934
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1933, false, d)
				}
			}
		case "clusterIP":
			if r.TryDecodeAsNil() {
				x.ClusterIP = ""
			} else {
				x.ClusterIP = string(r.DecodeString())
			}
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ServiceType(r.DecodeString())
			}
		case "externalIPs":
			if r.TryDecodeAsNil() {
				x.ExternalIPs = nil
			} else {
				yyv1937 := &x.ExternalIPs
				yym1938 := z.DecBinary()
				_ = yym1938
				if false {
				} else {
					z.F.DecSliceStringX(yyv1937, false, d)
				}
			}
		case "deprecatedPublicIPs":
			if r.TryDecodeAsNil() {
				x.DeprecatedPublicIPs = nil
			} else {
				yyv1939 := &x.DeprecatedPublicIPs
				yym1940 := z.DecBinary()
				_ = yym1940
				if false {
				} else {
					z.F.DecSliceStringX(yyv1939, false, d)
				}
			}
		case "sessionAffinity":
			if r.TryDecodeAsNil() {
				x.SessionAffinity = ""
			} else {
				x.SessionAffinity = ServiceAffinity(r.DecodeString())
			}
		case "loadBalancerIP":
			if r.TryDecodeAsNil() {
				x.LoadBalancerIP = ""
			} else {
				x.LoadBalancerIP = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1930)
		} // end switch yys1930
	} // end for yyj1930
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1943 int
	var yyb1943 bool
	var yyhl1943 bool = l >= 0
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1944 := &x.Ports
		yym1945 := z.DecBinary()
		_ = yym1945
		if false {
		} else {
			h.decSliceServicePort((*[]ServicePort)(yyv1944), d)
		}
	}
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv1946 := &x.Selector
		yym1947 := z.DecBinary()
		_ = yym1947
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1946, false, d)
		}
	}
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterIP = ""
	} else {
		x.ClusterIP = string(r.DecodeString())
	}
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ServiceType(r.DecodeString())
	}
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalIPs = nil
	} else {
		yyv1950 := &x.ExternalIPs
		yym1951 := z.DecBinary()
		_ = yym1951
		if false {
		} else {
			z.F.DecSliceStringX(yyv1950, false, d)
		}
	}
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedPublicIPs = nil
	} else {
		yyv1952 := &x.DeprecatedPublicIPs
		yym1953 := z.DecBinary()
		_ = yym1953
		if false {
		} else {
			z.F.DecSliceStringX(yyv1952, false, d)
		}
	}
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SessionAffinity = ""
	} else {
		x.SessionAffinity = ServiceAffinity(r.DecodeString())
	}
	yyj1943++
	if yyhl1943 {
		yyb1943 = yyj1943 > l
	} else {
		yyb1943 = r.CheckBreak()
	}
	if yyb1943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerIP = ""
	} else {
		x.LoadBalancerIP = string(r.DecodeString())
	}
	for {
		yyj1943++
		if yyhl1943 {
			yyb1943 = yyj1943 > l
		} else {
			yyb1943 = r.CheckBreak()
		}
		if yyb1943 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1943-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServicePort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1956 := z.EncBinary()
		_ = yym1956
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1957 := !z.EncBinary()
			yy2arr1957 := z.EncBasicHandle().StructToArray
			var yyq1957 [5]bool
			_, _, _ = yysep1957, yyq1957, yy2arr1957
			const yyr1957 bool = false
			yyq1957[0] = x.Name != ""
			yyq1957[1] = x.Protocol != ""
			yyq1957[3] = true
			yyq1957[4] = x.NodePort != 0
			var yynn1957 int
			if yyr1957 || yy2arr1957 {
				r.EncodeArrayStart(5)
			} else {
				yynn1957 = 1
				for _, b := range yyq1957 {
					if b {
						yynn1957++
					}
				}
				r.EncodeMapStart(yynn1957)
				yynn1957 = 0
			}
			if yyr1957 || yy2arr1957 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1957[0] {
					yym1959 := z.EncBinary()
					_ = yym1959
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1957[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1960 := z.EncBinary()
					_ = yym1960
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1957 || yy2arr1957 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1957[1] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1957[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr1957 || yy2arr1957 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1963 := z.EncBinary()
				_ = yym1963
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1964 := z.EncBinary()
				_ = yym1964
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr1957 || yy2arr1957 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1957[3] {
					yy1966 := &x.TargetPort
					yym1967 := z.EncBinary()
					_ = yym1967
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1966) {
					} else if !yym1967 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1966)
					} else {
						z.EncFallback(yy1966)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1957[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1968 := &x.TargetPort
					yym1969 := z.EncBinary()
					_ = yym1969
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1968) {
					} else if !yym1969 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1968)
					} else {
						z.EncFallback(yy1968)
					}
				}
			}
			if yyr1957 || yy2arr1957 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1957[4] {
					yym1971 := z.EncBinary()
					_ = yym1971
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1957[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodePort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1972 := z.EncBinary()
					_ = yym1972
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				}
			}
			if yyr1957 || yy2arr1957 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServicePort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1973 := z.DecBinary()
	_ = yym1973
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1974 := r.ContainerType()
		if yyct1974 == codecSelferValueTypeMap1234 {
			yyl1974 := r.ReadMapStart()
			if yyl1974 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1974, d)
			}
		} else if yyct1974 == codecSelferValueTypeArray1234 {
			yyl1974 := r.ReadArrayStart()
			if yyl1974 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1974, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServicePort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1975Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1975Slc
	var yyhl1975 bool = l >= 0
	for yyj1975 := 0; ; yyj1975++ {
		if yyhl1975 {
			if yyj1975 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1975Slc = r.DecodeBytes(yys1975Slc, true, true)
		yys1975 := string(yys1975Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1975 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "targetPort":
			if r.TryDecodeAsNil() {
				x.TargetPort = pkg5_intstr.IntOrString{}
			} else {
				yyv1979 := &x.TargetPort
				yym1980 := z.DecBinary()
				_ = yym1980
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1979) {
				} else if !yym1980 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1979)
				} else {
					z.DecFallback(yyv1979, false)
				}
			}
		case "nodePort":
			if r.TryDecodeAsNil() {
				x.NodePort = 0
			} else {
				x.NodePort = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1975)
		} // end switch yys1975
	} // end for yyj1975
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServicePort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1982 int
	var yyb1982 bool
	var yyhl1982 bool = l >= 0
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPort = pkg5_intstr.IntOrString{}
	} else {
		yyv1986 := &x.TargetPort
		yym1987 := z.DecBinary()
		_ = yym1987
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1986) {
		} else if !yym1987 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1986)
		} else {
			z.DecFallback(yyv1986, false)
		}
	}
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodePort = 0
	} else {
		x.NodePort = int32(r.DecodeInt(32))
	}
	for {
		yyj1982++
		if yyhl1982 {
			yyb1982 = yyj1982 > l
		} else {
			yyb1982 = r.CheckBreak()
		}
		if yyb1982 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1982-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Service) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1989 := z.EncBinary()
		_ = yym1989
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1990 := !z.EncBinary()
			yy2arr1990 := z.EncBasicHandle().StructToArray
			var yyq1990 [5]bool
			_, _, _ = yysep1990, yyq1990, yy2arr1990
			const yyr1990 bool = false
			yyq1990[0] = x.Kind != ""
			yyq1990[1] = x.APIVersion != ""
			yyq1990[2] = true
			yyq1990[3] = true
			yyq1990[4] = true
			var yynn1990 int
			if yyr1990 || yy2arr1990 {
				r.EncodeArrayStart(5)
			} else {
				yynn1990 = 0
				for _, b := range yyq1990 {
					if b {
						yynn1990++
					}
				}
				r.EncodeMapStart(yynn1990)
				yynn1990 = 0
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[0] {
					yym1992 := z.EncBinary()
					_ = yym1992
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1993 := z.EncBinary()
					_ = yym1993
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[1] {
					yym1995 := z.EncBinary()
					_ = yym1995
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1996 := z.EncBinary()
					_ = yym1996
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[2] {
					yy1998 := &x.ObjectMeta
					yy1998.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1999 := &x.ObjectMeta
					yy1999.CodecEncodeSelf(e)
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[3] {
					yy2001 := &x.Spec
					yy2001.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2002 := &x.Spec
					yy2002.CodecEncodeSelf(e)
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[4] {
					yy2004 := &x.Status
					yy2004.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2005 := &x.Status
					yy2005.CodecEncodeSelf(e)
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Service) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2006 := z.DecBinary()
	_ = yym2006
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2007 := r.ContainerType()
		if yyct2007 == codecSelferValueTypeMap1234 {
			yyl2007 := r.ReadMapStart()
			if yyl2007 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2007, d)
			}
		} else if yyct2007 == codecSelferValueTypeArray1234 {
			yyl2007 := r.ReadArrayStart()
			if yyl2007 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2007, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Service) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2008Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2008Slc
	var yyhl2008 bool = l >= 0
	for yyj2008 := 0; ; yyj2008++ {
		if yyhl2008 {
			if yyj2008 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2008Slc = r.DecodeBytes(yys2008Slc, true, true)
		yys2008 := string(yys2008Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2008 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2011 := &x.ObjectMeta
				yyv2011.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ServiceSpec{}
			} else {
				yyv2012 := &x.Spec
				yyv2012.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ServiceStatus{}
			} else {
				yyv2013 := &x.Status
				yyv2013.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2008)
		} // end switch yys2008
	} // end for yyj2008
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Service) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2014 int
	var yyb2014 bool
	var yyhl2014 bool = l >= 0
	yyj2014++
	if yyhl2014 {
		yyb2014 = yyj2014 > l
	} else {
		yyb2014 = r.CheckBreak()
	}
	if yyb2014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2014++
	if yyhl2014 {
		yyb2014 = yyj2014 > l
	} else {
		yyb2014 = r.CheckBreak()
	}
	if yyb2014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2014++
	if yyhl2014 {
		yyb2014 = yyj2014 > l
	} else {
		yyb2014 = r.CheckBreak()
	}
	if yyb2014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2017 := &x.ObjectMeta
		yyv2017.CodecDecodeSelf(d)
	}
	yyj2014++
	if yyhl2014 {
		yyb2014 = yyj2014 > l
	} else {
		yyb2014 = r.CheckBreak()
	}
	if yyb2014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ServiceSpec{}
	} else {
		yyv2018 := &x.Spec
		yyv2018.CodecDecodeSelf(d)
	}
	yyj2014++
	if yyhl2014 {
		yyb2014 = yyj2014 > l
	} else {
		yyb2014 = r.CheckBreak()
	}
	if yyb2014 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ServiceStatus{}
	} else {
		yyv2019 := &x.Status
		yyv2019.CodecDecodeSelf(d)
	}
	for {
		yyj2014++
		if yyhl2014 {
			yyb2014 = yyj2014 > l
		} else {
			yyb2014 = r.CheckBreak()
		}
		if yyb2014 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2014-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2020 := z.EncBinary()
		_ = yym2020
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2021 := !z.EncBinary()
			yy2arr2021 := z.EncBasicHandle().StructToArray
			var yyq2021 [4]bool
			_, _, _ = yysep2021, yyq2021, yy2arr2021
			const yyr2021 bool = false
			yyq2021[0] = x.Kind != ""
			yyq2021[1] = x.APIVersion != ""
			yyq2021[2] = true
			var yynn2021 int
			if yyr2021 || yy2arr2021 {
				r.EncodeArrayStart(4)
			} else {
				yynn2021 = 1
				for _, b := range yyq2021 {
					if b {
						yynn2021++
					}
				}
				r.EncodeMapStart(yynn2021)
				yynn2021 = 0
			}
			if yyr2021 || yy2arr2021 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2021[0] {
					yym2023 := z.EncBinary()
					_ = yym2023
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2021[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2024 := z.EncBinary()
					_ = yym2024
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2021 || yy2arr2021 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2021[1] {
					yym2026 := z.EncBinary()
					_ = yym2026
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2021[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2027 := z.EncBinary()
					_ = yym2027
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2021 || yy2arr2021 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2021[2] {
					yy2029 := &x.ListMeta
					yym2030 := z.EncBinary()
					_ = yym2030
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2029) {
					} else {
						z.EncFallback(yy2029)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2021[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2031 := &x.ListMeta
					yym2032 := z.EncBinary()
					_ = yym2032
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2031) {
					} else {
						z.EncFallback(yy2031)
					}
				}
			}
			if yyr2021 || yy2arr2021 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2034 := z.EncBinary()
					_ = yym2034
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2035 := z.EncBinary()
					_ = yym2035
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			}
			if yyr2021 || yy2arr2021 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2036 := z.DecBinary()
	_ = yym2036
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2037 := r.ContainerType()
		if yyct2037 == codecSelferValueTypeMap1234 {
			yyl2037 := r.ReadMapStart()
			if yyl2037 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2037, d)
			}
		} else if yyct2037 == codecSelferValueTypeArray1234 {
			yyl2037 := r.ReadArrayStart()
			if yyl2037 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2037, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2038Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2038Slc
	var yyhl2038 bool = l >= 0
	for yyj2038 := 0; ; yyj2038++ {
		if yyhl2038 {
			if yyj2038 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2038Slc = r.DecodeBytes(yys2038Slc, true, true)
		yys2038 := string(yys2038Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2038 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2041 := &x.ListMeta
				yym2042 := z.DecBinary()
				_ = yym2042
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2041) {
				} else {
					z.DecFallback(yyv2041, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2043 := &x.Items
				yym2044 := z.DecBinary()
				_ = yym2044
				if false {
				} else {
					h.decSliceService((*[]Service)(yyv2043), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2038)
		} // end switch yys2038
	} // end for yyj2038
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2045 int
	var yyb2045 bool
	var yyhl2045 bool = l >= 0
	yyj2045++
	if yyhl2045 {
		yyb2045 = yyj2045 > l
	} else {
		yyb2045 = r.CheckBreak()
	}
	if yyb2045 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2045++
	if yyhl2045 {
		yyb2045 = yyj2045 > l
	} else {
		yyb2045 = r.CheckBreak()
	}
	if yyb2045 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2045++
	if yyhl2045 {
		yyb2045 = yyj2045 > l
	} else {
		yyb2045 = r.CheckBreak()
	}
	if yyb2045 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2048 := &x.ListMeta
		yym2049 := z.DecBinary()
		_ = yym2049
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2048) {
		} else {
			z.DecFallback(yyv2048, false)
		}
	}
	yyj2045++
	if yyhl2045 {
		yyb2045 = yyj2045 > l
	} else {
		yyb2045 = r.CheckBreak()
	}
	if yyb2045 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2050 := &x.Items
		yym2051 := z.DecBinary()
		_ = yym2051
		if false {
		} else {
			h.decSliceService((*[]Service)(yyv2050), d)
		}
	}
	for {
		yyj2045++
		if yyhl2045 {
			yyb2045 = yyj2045 > l
		} else {
			yyb2045 = r.CheckBreak()
		}
		if yyb2045 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2045-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2052 := z.EncBinary()
		_ = yym2052
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2053 := !z.EncBinary()
			yy2arr2053 := z.EncBasicHandle().StructToArray
			var yyq2053 [5]bool
			_, _, _ = yysep2053, yyq2053, yy2arr2053
			const yyr2053 bool = false
			yyq2053[0] = x.Kind != ""
			yyq2053[1] = x.APIVersion != ""
			yyq2053[2] = true
			yyq2053[3] = len(x.Secrets) != 0
			yyq2053[4] = len(x.ImagePullSecrets) != 0
			var yynn2053 int
			if yyr2053 || yy2arr2053 {
				r.EncodeArrayStart(5)
			} else {
				yynn2053 = 0
				for _, b := range yyq2053 {
					if b {
						yynn2053++
					}
				}
				r.EncodeMapStart(yynn2053)
				yynn2053 = 0
			}
			if yyr2053 || yy2arr2053 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2053[0] {
					yym2055 := z.EncBinary()
					_ = yym2055
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2053[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2056 := z.EncBinary()
					_ = yym2056
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2053 || yy2arr2053 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2053[1] {
					yym2058 := z.EncBinary()
					_ = yym2058
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2053[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2059 := z.EncBinary()
					_ = yym2059
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2053 || yy2arr2053 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2053[2] {
					yy2061 := &x.ObjectMeta
					yy2061.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2053[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2062 := &x.ObjectMeta
					yy2062.CodecEncodeSelf(e)
				}
			}
			if yyr2053 || yy2arr2053 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2053[3] {
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym2064 := z.EncBinary()
						_ = yym2064
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2053[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym2065 := z.EncBinary()
						_ = yym2065
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				}
			}
			if yyr2053 || yy2arr2053 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2053[4] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2067 := z.EncBinary()
						_ = yym2067
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2053[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2068 := z.EncBinary()
						_ = yym2068
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2053 || yy2arr2053 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2069 := z.DecBinary()
	_ = yym2069
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2070 := r.ContainerType()
		if yyct2070 == codecSelferValueTypeMap1234 {
			yyl2070 := r.ReadMapStart()
			if yyl2070 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2070, d)
			}
		} else if yyct2070 == codecSelferValueTypeArray1234 {
			yyl2070 := r.ReadArrayStart()
			if yyl2070 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2070, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2071Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2071Slc
	var yyhl2071 bool = l >= 0
	for yyj2071 := 0; ; yyj2071++ {
		if yyhl2071 {
			if yyj2071 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2071Slc = r.DecodeBytes(yys2071Slc, true, true)
		yys2071 := string(yys2071Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2071 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2074 := &x.ObjectMeta
				yyv2074.CodecDecodeSelf(d)
			}
		case "secrets":
			if r.TryDecodeAsNil() {
				x.Secrets = nil
			} else {
				yyv2075 := &x.Secrets
				yym2076 := z.DecBinary()
				_ = yym2076
				if false {
				} else {
					h.decSliceObjectReference((*[]ObjectReference)(yyv2075), d)
				}
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2077 := &x.ImagePullSecrets
				yym2078 := z.DecBinary()
				_ = yym2078
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2077), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2071)
		} // end switch yys2071
	} // end for yyj2071
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2079 int
	var yyb2079 bool
	var yyhl2079 bool = l >= 0
	yyj2079++
	if yyhl2079 {
		yyb2079 = yyj2079 > l
	} else {
		yyb2079 = r.CheckBreak()
	}
	if yyb2079 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2079++
	if yyhl2079 {
		yyb2079 = yyj2079 > l
	} else {
		yyb2079 = r.CheckBreak()
	}
	if yyb2079 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2079++
	if yyhl2079 {
		yyb2079 = yyj2079 > l
	} else {
		yyb2079 = r.CheckBreak()
	}
	if yyb2079 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2082 := &x.ObjectMeta
		yyv2082.CodecDecodeSelf(d)
	}
	yyj2079++
	if yyhl2079 {
		yyb2079 = yyj2079 > l
	} else {
		yyb2079 = r.CheckBreak()
	}
	if yyb2079 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Secrets = nil
	} else {
		yyv2083 := &x.Secrets
		yym2084 := z.DecBinary()
		_ = yym2084
		if false {
		} else {
			h.decSliceObjectReference((*[]ObjectReference)(yyv2083), d)
		}
	}
	yyj2079++
	if yyhl2079 {
		yyb2079 = yyj2079 > l
	} else {
		yyb2079 = r.CheckBreak()
	}
	if yyb2079 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2085 := &x.ImagePullSecrets
		yym2086 := z.DecBinary()
		_ = yym2086
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2085), d)
		}
	}
	for {
		yyj2079++
		if yyhl2079 {
			yyb2079 = yyj2079 > l
		} else {
			yyb2079 = r.CheckBreak()
		}
		if yyb2079 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2079-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccountList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2087 := z.EncBinary()
		_ = yym2087
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2088 := !z.EncBinary()
			yy2arr2088 := z.EncBasicHandle().StructToArray
			var yyq2088 [4]bool
			_, _, _ = yysep2088, yyq2088, yy2arr2088
			const yyr2088 bool = false
			yyq2088[0] = x.Kind != ""
			yyq2088[1] = x.APIVersion != ""
			yyq2088[2] = true
			var yynn2088 int
			if yyr2088 || yy2arr2088 {
				r.EncodeArrayStart(4)
			} else {
				yynn2088 = 1
				for _, b := range yyq2088 {
					if b {
						yynn2088++
					}
				}
				r.EncodeMapStart(yynn2088)
				yynn2088 = 0
			}
			if yyr2088 || yy2arr2088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2088[0] {
					yym2090 := z.EncBinary()
					_ = yym2090
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2088[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2091 := z.EncBinary()
					_ = yym2091
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2088 || yy2arr2088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2088[1] {
					yym2093 := z.EncBinary()
					_ = yym2093
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2088[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2094 := z.EncBinary()
					_ = yym2094
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2088 || yy2arr2088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2088[2] {
					yy2096 := &x.ListMeta
					yym2097 := z.EncBinary()
					_ = yym2097
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2096) {
					} else {
						z.EncFallback(yy2096)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2088[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2098 := &x.ListMeta
					yym2099 := z.EncBinary()
					_ = yym2099
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2098) {
					} else {
						z.EncFallback(yy2098)
					}
				}
			}
			if yyr2088 || yy2arr2088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2101 := z.EncBinary()
					_ = yym2101
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2102 := z.EncBinary()
					_ = yym2102
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			}
			if yyr2088 || yy2arr2088 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccountList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2103 := z.DecBinary()
	_ = yym2103
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2104 := r.ContainerType()
		if yyct2104 == codecSelferValueTypeMap1234 {
			yyl2104 := r.ReadMapStart()
			if yyl2104 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2104, d)
			}
		} else if yyct2104 == codecSelferValueTypeArray1234 {
			yyl2104 := r.ReadArrayStart()
			if yyl2104 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2104, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccountList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2105Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2105Slc
	var yyhl2105 bool = l >= 0
	for yyj2105 := 0; ; yyj2105++ {
		if yyhl2105 {
			if yyj2105 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2105Slc = r.DecodeBytes(yys2105Slc, true, true)
		yys2105 := string(yys2105Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2105 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2108 := &x.ListMeta
				yym2109 := z.DecBinary()
				_ = yym2109
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2108) {
				} else {
					z.DecFallback(yyv2108, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2110 := &x.Items
				yym2111 := z.DecBinary()
				_ = yym2111
				if false {
				} else {
					h.decSliceServiceAccount((*[]ServiceAccount)(yyv2110), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2105)
		} // end switch yys2105
	} // end for yyj2105
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccountList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2112 int
	var yyb2112 bool
	var yyhl2112 bool = l >= 0
	yyj2112++
	if yyhl2112 {
		yyb2112 = yyj2112 > l
	} else {
		yyb2112 = r.CheckBreak()
	}
	if yyb2112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2112++
	if yyhl2112 {
		yyb2112 = yyj2112 > l
	} else {
		yyb2112 = r.CheckBreak()
	}
	if yyb2112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2112++
	if yyhl2112 {
		yyb2112 = yyj2112 > l
	} else {
		yyb2112 = r.CheckBreak()
	}
	if yyb2112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2115 := &x.ListMeta
		yym2116 := z.DecBinary()
		_ = yym2116
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2115) {
		} else {
			z.DecFallback(yyv2115, false)
		}
	}
	yyj2112++
	if yyhl2112 {
		yyb2112 = yyj2112 > l
	} else {
		yyb2112 = r.CheckBreak()
	}
	if yyb2112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2117 := &x.Items
		yym2118 := z.DecBinary()
		_ = yym2118
		if false {
		} else {
			h.decSliceServiceAccount((*[]ServiceAccount)(yyv2117), d)
		}
	}
	for {
		yyj2112++
		if yyhl2112 {
			yyb2112 = yyj2112 > l
		} else {
			yyb2112 = r.CheckBreak()
		}
		if yyb2112 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2112-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Endpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2119 := z.EncBinary()
		_ = yym2119
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2120 := !z.EncBinary()
			yy2arr2120 := z.EncBasicHandle().StructToArray
			var yyq2120 [4]bool
			_, _, _ = yysep2120, yyq2120, yy2arr2120
			const yyr2120 bool = false
			yyq2120[0] = x.Kind != ""
			yyq2120[1] = x.APIVersion != ""
			yyq2120[2] = true
			var yynn2120 int
			if yyr2120 || yy2arr2120 {
				r.EncodeArrayStart(4)
			} else {
				yynn2120 = 1
				for _, b := range yyq2120 {
					if b {
						yynn2120++
					}
				}
				r.EncodeMapStart(yynn2120)
				yynn2120 = 0
			}
			if yyr2120 || yy2arr2120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2120[0] {
					yym2122 := z.EncBinary()
					_ = yym2122
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2120[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2123 := z.EncBinary()
					_ = yym2123
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2120 || yy2arr2120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2120[1] {
					yym2125 := z.EncBinary()
					_ = yym2125
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2120[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2126 := z.EncBinary()
					_ = yym2126
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2120 || yy2arr2120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2120[2] {
					yy2128 := &x.ObjectMeta
					yy2128.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2120[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2129 := &x.ObjectMeta
					yy2129.CodecEncodeSelf(e)
				}
			}
			if yyr2120 || yy2arr2120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2131 := z.EncBinary()
					_ = yym2131
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("subsets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2132 := z.EncBinary()
					_ = yym2132
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			}
			if yyr2120 || yy2arr2120 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Endpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2133 := z.DecBinary()
	_ = yym2133
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2134 := r.ContainerType()
		if yyct2134 == codecSelferValueTypeMap1234 {
			yyl2134 := r.ReadMapStart()
			if yyl2134 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2134, d)
			}
		} else if yyct2134 == codecSelferValueTypeArray1234 {
			yyl2134 := r.ReadArrayStart()
			if yyl2134 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2134, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Endpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2135Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2135Slc
	var yyhl2135 bool = l >= 0
	for yyj2135 := 0; ; yyj2135++ {
		if yyhl2135 {
			if yyj2135 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2135Slc = r.DecodeBytes(yys2135Slc, true, true)
		yys2135 := string(yys2135Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2135 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2138 := &x.ObjectMeta
				yyv2138.CodecDecodeSelf(d)
			}
		case "subsets":
			if r.TryDecodeAsNil() {
				x.Subsets = nil
			} else {
				yyv2139 := &x.Subsets
				yym2140 := z.DecBinary()
				_ = yym2140
				if false {
				} else {
					h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2139), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2135)
		} // end switch yys2135
	} // end for yyj2135
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Endpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2141 int
	var yyb2141 bool
	var yyhl2141 bool = l >= 0
	yyj2141++
	if yyhl2141 {
		yyb2141 = yyj2141 > l
	} else {
		yyb2141 = r.CheckBreak()
	}
	if yyb2141 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2141++
	if yyhl2141 {
		yyb2141 = yyj2141 > l
	} else {
		yyb2141 = r.CheckBreak()
	}
	if yyb2141 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2141++
	if yyhl2141 {
		yyb2141 = yyj2141 > l
	} else {
		yyb2141 = r.CheckBreak()
	}
	if yyb2141 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2144 := &x.ObjectMeta
		yyv2144.CodecDecodeSelf(d)
	}
	yyj2141++
	if yyhl2141 {
		yyb2141 = yyj2141 > l
	} else {
		yyb2141 = r.CheckBreak()
	}
	if yyb2141 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subsets = nil
	} else {
		yyv2145 := &x.Subsets
		yym2146 := z.DecBinary()
		_ = yym2146
		if false {
		} else {
			h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2145), d)
		}
	}
	for {
		yyj2141++
		if yyhl2141 {
			yyb2141 = yyj2141 > l
		} else {
			yyb2141 = r.CheckBreak()
		}
		if yyb2141 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2141-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointSubset) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2147 := z.EncBinary()
		_ = yym2147
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2148 := !z.EncBinary()
			yy2arr2148 := z.EncBasicHandle().StructToArray
			var yyq2148 [3]bool
			_, _, _ = yysep2148, yyq2148, yy2arr2148
			const yyr2148 bool = false
			yyq2148[0] = len(x.Addresses) != 0
			yyq2148[1] = len(x.NotReadyAddresses) != 0
			yyq2148[2] = len(x.Ports) != 0
			var yynn2148 int
			if yyr2148 || yy2arr2148 {
				r.EncodeArrayStart(3)
			} else {
				yynn2148 = 0
				for _, b := range yyq2148 {
					if b {
						yynn2148++
					}
				}
				r.EncodeMapStart(yynn2148)
				yynn2148 = 0
			}
			if yyr2148 || yy2arr2148 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2148[0] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2150 := z.EncBinary()
						_ = yym2150
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2148[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2151 := z.EncBinary()
						_ = yym2151
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr2148 || yy2arr2148 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2148[1] {
					if x.NotReadyAddresses == nil {
						r.EncodeNil()
					} else {
						yym2153 := z.EncBinary()
						_ = yym2153
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2148[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("notReadyAddresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NotReadyAddresses == nil {
						r.EncodeNil()
					} else {
						yym2154 := z.EncBinary()
						_ = yym2154
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
						}
					}
				}
			}
			if yyr2148 || yy2arr2148 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2148[2] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym2156 := z.EncBinary()
						_ = yym2156
						if false {
						} else {
							h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2148[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym2157 := z.EncBinary()
						_ = yym2157
						if false {
						} else {
							h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr2148 || yy2arr2148 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointSubset) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2158 := z.DecBinary()
	_ = yym2158
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2159 := r.ContainerType()
		if yyct2159 == codecSelferValueTypeMap1234 {
			yyl2159 := r.ReadMapStart()
			if yyl2159 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2159, d)
			}
		} else if yyct2159 == codecSelferValueTypeArray1234 {
			yyl2159 := r.ReadArrayStart()
			if yyl2159 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2159, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointSubset) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2160Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2160Slc
	var yyhl2160 bool = l >= 0
	for yyj2160 := 0; ; yyj2160++ {
		if yyhl2160 {
			if yyj2160 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2160Slc = r.DecodeBytes(yys2160Slc, true, true)
		yys2160 := string(yys2160Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2160 {
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2161 := &x.Addresses
				yym2162 := z.DecBinary()
				_ = yym2162
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2161), d)
				}
			}
		case "notReadyAddresses":
			if r.TryDecodeAsNil() {
				x.NotReadyAddresses = nil
			} else {
				yyv2163 := &x.NotReadyAddresses
				yym2164 := z.DecBinary()
				_ = yym2164
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2163), d)
				}
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2165 := &x.Ports
				yym2166 := z.DecBinary()
				_ = yym2166
				if false {
				} else {
					h.decSliceEndpointPort((*[]EndpointPort)(yyv2165), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2160)
		} // end switch yys2160
	} // end for yyj2160
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointSubset) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2167 int
	var yyb2167 bool
	var yyhl2167 bool = l >= 0
	yyj2167++
	if yyhl2167 {
		yyb2167 = yyj2167 > l
	} else {
		yyb2167 = r.CheckBreak()
	}
	if yyb2167 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2168 := &x.Addresses
		yym2169 := z.DecBinary()
		_ = yym2169
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2168), d)
		}
	}
	yyj2167++
	if yyhl2167 {
		yyb2167 = yyj2167 > l
	} else {
		yyb2167 = r.CheckBreak()
	}
	if yyb2167 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NotReadyAddresses = nil
	} else {
		yyv2170 := &x.NotReadyAddresses
		yym2171 := z.DecBinary()
		_ = yym2171
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2170), d)
		}
	}
	yyj2167++
	if yyhl2167 {
		yyb2167 = yyj2167 > l
	} else {
		yyb2167 = r.CheckBreak()
	}
	if yyb2167 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2172 := &x.Ports
		yym2173 := z.DecBinary()
		_ = yym2173
		if false {
		} else {
			h.decSliceEndpointPort((*[]EndpointPort)(yyv2172), d)
		}
	}
	for {
		yyj2167++
		if yyhl2167 {
			yyb2167 = yyj2167 > l
		} else {
			yyb2167 = r.CheckBreak()
		}
		if yyb2167 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2167-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2174 := z.EncBinary()
		_ = yym2174
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2175 := !z.EncBinary()
			yy2arr2175 := z.EncBasicHandle().StructToArray
			var yyq2175 [2]bool
			_, _, _ = yysep2175, yyq2175, yy2arr2175
			const yyr2175 bool = false
			yyq2175[1] = x.TargetRef != nil
			var yynn2175 int
			if yyr2175 || yy2arr2175 {
				r.EncodeArrayStart(2)
			} else {
				yynn2175 = 1
				for _, b := range yyq2175 {
					if b {
						yynn2175++
					}
				}
				r.EncodeMapStart(yynn2175)
				yynn2175 = 0
			}
			if yyr2175 || yy2arr2175 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2177 := z.EncBinary()
				_ = yym2177
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ip"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2178 := z.EncBinary()
				_ = yym2178
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			}
			if yyr2175 || yy2arr2175 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2175[1] {
					if x.TargetRef == nil {
						r.EncodeNil()
					} else {
						x.TargetRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2175[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TargetRef == nil {
						r.EncodeNil()
					} else {
						x.TargetRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2175 || yy2arr2175 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2180 := z.DecBinary()
	_ = yym2180
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2181 := r.ContainerType()
		if yyct2181 == codecSelferValueTypeMap1234 {
			yyl2181 := r.ReadMapStart()
			if yyl2181 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2181, d)
			}
		} else if yyct2181 == codecSelferValueTypeArray1234 {
			yyl2181 := r.ReadArrayStart()
			if yyl2181 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2181, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2182Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2182Slc
	var yyhl2182 bool = l >= 0
	for yyj2182 := 0; ; yyj2182++ {
		if yyhl2182 {
			if yyj2182 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2182Slc = r.DecodeBytes(yys2182Slc, true, true)
		yys2182 := string(yys2182Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2182 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "targetRef":
			if r.TryDecodeAsNil() {
				if x.TargetRef != nil {
					x.TargetRef = nil
				}
			} else {
				if x.TargetRef == nil {
					x.TargetRef = new(ObjectReference)
				}
				x.TargetRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2182)
		} // end switch yys2182
	} // end for yyj2182
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2185 int
	var yyb2185 bool
	var yyhl2185 bool = l >= 0
	yyj2185++
	if yyhl2185 {
		yyb2185 = yyj2185 > l
	} else {
		yyb2185 = r.CheckBreak()
	}
	if yyb2185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2185++
	if yyhl2185 {
		yyb2185 = yyj2185 > l
	} else {
		yyb2185 = r.CheckBreak()
	}
	if yyb2185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetRef != nil {
			x.TargetRef = nil
		}
	} else {
		if x.TargetRef == nil {
			x.TargetRef = new(ObjectReference)
		}
		x.TargetRef.CodecDecodeSelf(d)
	}
	for {
		yyj2185++
		if yyhl2185 {
			yyb2185 = yyj2185 > l
		} else {
			yyb2185 = r.CheckBreak()
		}
		if yyb2185 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2185-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2188 := z.EncBinary()
		_ = yym2188
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2189 := !z.EncBinary()
			yy2arr2189 := z.EncBasicHandle().StructToArray
			var yyq2189 [3]bool
			_, _, _ = yysep2189, yyq2189, yy2arr2189
			const yyr2189 bool = false
			yyq2189[0] = x.Name != ""
			yyq2189[2] = x.Protocol != ""
			var yynn2189 int
			if yyr2189 || yy2arr2189 {
				r.EncodeArrayStart(3)
			} else {
				yynn2189 = 1
				for _, b := range yyq2189 {
					if b {
						yynn2189++
					}
				}
				r.EncodeMapStart(yynn2189)
				yynn2189 = 0
			}
			if yyr2189 || yy2arr2189 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2189[0] {
					yym2191 := z.EncBinary()
					_ = yym2191
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2189[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2192 := z.EncBinary()
					_ = yym2192
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2189 || yy2arr2189 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2194 := z.EncBinary()
				_ = yym2194
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2195 := z.EncBinary()
				_ = yym2195
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2189 || yy2arr2189 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2189[2] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2189[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr2189 || yy2arr2189 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2197 := z.DecBinary()
	_ = yym2197
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2198 := r.ContainerType()
		if yyct2198 == codecSelferValueTypeMap1234 {
			yyl2198 := r.ReadMapStart()
			if yyl2198 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2198, d)
			}
		} else if yyct2198 == codecSelferValueTypeArray1234 {
			yyl2198 := r.ReadArrayStart()
			if yyl2198 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2198, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2199Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2199Slc
	var yyhl2199 bool = l >= 0
	for yyj2199 := 0; ; yyj2199++ {
		if yyhl2199 {
			if yyj2199 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2199Slc = r.DecodeBytes(yys2199Slc, true, true)
		yys2199 := string(yys2199Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2199 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2199)
		} // end switch yys2199
	} // end for yyj2199
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2203 int
	var yyb2203 bool
	var yyhl2203 bool = l >= 0
	yyj2203++
	if yyhl2203 {
		yyb2203 = yyj2203 > l
	} else {
		yyb2203 = r.CheckBreak()
	}
	if yyb2203 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2203++
	if yyhl2203 {
		yyb2203 = yyj2203 > l
	} else {
		yyb2203 = r.CheckBreak()
	}
	if yyb2203 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2203++
	if yyhl2203 {
		yyb2203 = yyj2203 > l
	} else {
		yyb2203 = r.CheckBreak()
	}
	if yyb2203 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	for {
		yyj2203++
		if yyhl2203 {
			yyb2203 = yyj2203 > l
		} else {
			yyb2203 = r.CheckBreak()
		}
		if yyb2203 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2203-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2207 := z.EncBinary()
		_ = yym2207
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2208 := !z.EncBinary()
			yy2arr2208 := z.EncBasicHandle().StructToArray
			var yyq2208 [4]bool
			_, _, _ = yysep2208, yyq2208, yy2arr2208
			const yyr2208 bool = false
			yyq2208[0] = x.Kind != ""
			yyq2208[1] = x.APIVersion != ""
			yyq2208[2] = true
			var yynn2208 int
			if yyr2208 || yy2arr2208 {
				r.EncodeArrayStart(4)
			} else {
				yynn2208 = 1
				for _, b := range yyq2208 {
					if b {
						yynn2208++
					}
				}
				r.EncodeMapStart(yynn2208)
				yynn2208 = 0
			}
			if yyr2208 || yy2arr2208 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2208[0] {
					yym2210 := z.EncBinary()
					_ = yym2210
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2208[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2211 := z.EncBinary()
					_ = yym2211
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2208 || yy2arr2208 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2208[1] {
					yym2213 := z.EncBinary()
					_ = yym2213
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2208[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2214 := z.EncBinary()
					_ = yym2214
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2208 || yy2arr2208 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2208[2] {
					yy2216 := &x.ListMeta
					yym2217 := z.EncBinary()
					_ = yym2217
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2216) {
					} else {
						z.EncFallback(yy2216)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2208[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2218 := &x.ListMeta
					yym2219 := z.EncBinary()
					_ = yym2219
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2218) {
					} else {
						z.EncFallback(yy2218)
					}
				}
			}
			if yyr2208 || yy2arr2208 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2221 := z.EncBinary()
					_ = yym2221
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2222 := z.EncBinary()
					_ = yym2222
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			}
			if yyr2208 || yy2arr2208 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2223 := z.DecBinary()
	_ = yym2223
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2224 := r.ContainerType()
		if yyct2224 == codecSelferValueTypeMap1234 {
			yyl2224 := r.ReadMapStart()
			if yyl2224 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2224, d)
			}
		} else if yyct2224 == codecSelferValueTypeArray1234 {
			yyl2224 := r.ReadArrayStart()
			if yyl2224 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2224, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2225Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2225Slc
	var yyhl2225 bool = l >= 0
	for yyj2225 := 0; ; yyj2225++ {
		if yyhl2225 {
			if yyj2225 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2225Slc = r.DecodeBytes(yys2225Slc, true, true)
		yys2225 := string(yys2225Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2225 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2228 := &x.ListMeta
				yym2229 := z.DecBinary()
				_ = yym2229
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2228) {
				} else {
					z.DecFallback(yyv2228, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2230 := &x.Items
				yym2231 := z.DecBinary()
				_ = yym2231
				if false {
				} else {
					h.decSliceEndpoints((*[]Endpoints)(yyv2230), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2225)
		} // end switch yys2225
	} // end for yyj2225
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2232 int
	var yyb2232 bool
	var yyhl2232 bool = l >= 0
	yyj2232++
	if yyhl2232 {
		yyb2232 = yyj2232 > l
	} else {
		yyb2232 = r.CheckBreak()
	}
	if yyb2232 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2232++
	if yyhl2232 {
		yyb2232 = yyj2232 > l
	} else {
		yyb2232 = r.CheckBreak()
	}
	if yyb2232 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2232++
	if yyhl2232 {
		yyb2232 = yyj2232 > l
	} else {
		yyb2232 = r.CheckBreak()
	}
	if yyb2232 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2235 := &x.ListMeta
		yym2236 := z.DecBinary()
		_ = yym2236
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2235) {
		} else {
			z.DecFallback(yyv2235, false)
		}
	}
	yyj2232++
	if yyhl2232 {
		yyb2232 = yyj2232 > l
	} else {
		yyb2232 = r.CheckBreak()
	}
	if yyb2232 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2237 := &x.Items
		yym2238 := z.DecBinary()
		_ = yym2238
		if false {
		} else {
			h.decSliceEndpoints((*[]Endpoints)(yyv2237), d)
		}
	}
	for {
		yyj2232++
		if yyhl2232 {
			yyb2232 = yyj2232 > l
		} else {
			yyb2232 = r.CheckBreak()
		}
		if yyb2232 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2232-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2239 := z.EncBinary()
		_ = yym2239
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2240 := !z.EncBinary()
			yy2arr2240 := z.EncBasicHandle().StructToArray
			var yyq2240 [4]bool
			_, _, _ = yysep2240, yyq2240, yy2arr2240
			const yyr2240 bool = false
			yyq2240[0] = x.PodCIDR != ""
			yyq2240[1] = x.ExternalID != ""
			yyq2240[2] = x.ProviderID != ""
			yyq2240[3] = x.Unschedulable != false
			var yynn2240 int
			if yyr2240 || yy2arr2240 {
				r.EncodeArrayStart(4)
			} else {
				yynn2240 = 0
				for _, b := range yyq2240 {
					if b {
						yynn2240++
					}
				}
				r.EncodeMapStart(yynn2240)
				yynn2240 = 0
			}
			if yyr2240 || yy2arr2240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2240[0] {
					yym2242 := z.EncBinary()
					_ = yym2242
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2240[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2243 := z.EncBinary()
					_ = yym2243
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				}
			}
			if yyr2240 || yy2arr2240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2240[1] {
					yym2245 := z.EncBinary()
					_ = yym2245
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2240[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2246 := z.EncBinary()
					_ = yym2246
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				}
			}
			if yyr2240 || yy2arr2240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2240[2] {
					yym2248 := z.EncBinary()
					_ = yym2248
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2240[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("providerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2249 := z.EncBinary()
					_ = yym2249
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				}
			}
			if yyr2240 || yy2arr2240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2240[3] {
					yym2251 := z.EncBinary()
					_ = yym2251
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2240[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unschedulable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2252 := z.EncBinary()
					_ = yym2252
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				}
			}
			if yyr2240 || yy2arr2240 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2253 := z.DecBinary()
	_ = yym2253
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2254 := r.ContainerType()
		if yyct2254 == codecSelferValueTypeMap1234 {
			yyl2254 := r.ReadMapStart()
			if yyl2254 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2254, d)
			}
		} else if yyct2254 == codecSelferValueTypeArray1234 {
			yyl2254 := r.ReadArrayStart()
			if yyl2254 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2254, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2255Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2255Slc
	var yyhl2255 bool = l >= 0
	for yyj2255 := 0; ; yyj2255++ {
		if yyhl2255 {
			if yyj2255 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2255Slc = r.DecodeBytes(yys2255Slc, true, true)
		yys2255 := string(yys2255Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2255 {
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "externalID":
			if r.TryDecodeAsNil() {
				x.ExternalID = ""
			} else {
				x.ExternalID = string(r.DecodeString())
			}
		case "providerID":
			if r.TryDecodeAsNil() {
				x.ProviderID = ""
			} else {
				x.ProviderID = string(r.DecodeString())
			}
		case "unschedulable":
			if r.TryDecodeAsNil() {
				x.Unschedulable = false
			} else {
				x.Unschedulable = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2255)
		} // end switch yys2255
	} // end for yyj2255
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2260 int
	var yyb2260 bool
	var yyhl2260 bool = l >= 0
	yyj2260++
	if yyhl2260 {
		yyb2260 = yyj2260 > l
	} else {
		yyb2260 = r.CheckBreak()
	}
	if yyb2260 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj2260++
	if yyhl2260 {
		yyb2260 = yyj2260 > l
	} else {
		yyb2260 = r.CheckBreak()
	}
	if yyb2260 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalID = ""
	} else {
		x.ExternalID = string(r.DecodeString())
	}
	yyj2260++
	if yyhl2260 {
		yyb2260 = yyj2260 > l
	} else {
		yyb2260 = r.CheckBreak()
	}
	if yyb2260 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProviderID = ""
	} else {
		x.ProviderID = string(r.DecodeString())
	}
	yyj2260++
	if yyhl2260 {
		yyb2260 = yyj2260 > l
	} else {
		yyb2260 = r.CheckBreak()
	}
	if yyb2260 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Unschedulable = false
	} else {
		x.Unschedulable = bool(r.DecodeBool())
	}
	for {
		yyj2260++
		if yyhl2260 {
			yyb2260 = yyj2260 > l
		} else {
			yyb2260 = r.CheckBreak()
		}
		if yyb2260 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2260-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonEndpoint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2265 := z.EncBinary()
		_ = yym2265
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2266 := !z.EncBinary()
			yy2arr2266 := z.EncBasicHandle().StructToArray
			var yyq2266 [1]bool
			_, _, _ = yysep2266, yyq2266, yy2arr2266
			const yyr2266 bool = false
			var yynn2266 int
			if yyr2266 || yy2arr2266 {
				r.EncodeArrayStart(1)
			} else {
				yynn2266 = 1
				for _, b := range yyq2266 {
					if b {
						yynn2266++
					}
				}
				r.EncodeMapStart(yynn2266)
				yynn2266 = 0
			}
			if yyr2266 || yy2arr2266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2268 := z.EncBinary()
				_ = yym2268
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2269 := z.EncBinary()
				_ = yym2269
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2266 || yy2arr2266 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonEndpoint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2270 := z.DecBinary()
	_ = yym2270
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2271 := r.ContainerType()
		if yyct2271 == codecSelferValueTypeMap1234 {
			yyl2271 := r.ReadMapStart()
			if yyl2271 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2271, d)
			}
		} else if yyct2271 == codecSelferValueTypeArray1234 {
			yyl2271 := r.ReadArrayStart()
			if yyl2271 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2271, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonEndpoint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2272Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2272Slc
	var yyhl2272 bool = l >= 0
	for yyj2272 := 0; ; yyj2272++ {
		if yyhl2272 {
			if yyj2272 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2272Slc = r.DecodeBytes(yys2272Slc, true, true)
		yys2272 := string(yys2272Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2272 {
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2272)
		} // end switch yys2272
	} // end for yyj2272
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonEndpoint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2274 int
	var yyb2274 bool
	var yyhl2274 bool = l >= 0
	yyj2274++
	if yyhl2274 {
		yyb2274 = yyj2274 > l
	} else {
		yyb2274 = r.CheckBreak()
	}
	if yyb2274 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	for {
		yyj2274++
		if yyhl2274 {
			yyb2274 = yyj2274 > l
		} else {
			yyb2274 = r.CheckBreak()
		}
		if yyb2274 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2274-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeDaemonEndpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2276 := z.EncBinary()
		_ = yym2276
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2277 := !z.EncBinary()
			yy2arr2277 := z.EncBasicHandle().StructToArray
			var yyq2277 [1]bool
			_, _, _ = yysep2277, yyq2277, yy2arr2277
			const yyr2277 bool = false
			yyq2277[0] = true
			var yynn2277 int
			if yyr2277 || yy2arr2277 {
				r.EncodeArrayStart(1)
			} else {
				yynn2277 = 0
				for _, b := range yyq2277 {
					if b {
						yynn2277++
					}
				}
				r.EncodeMapStart(yynn2277)
				yynn2277 = 0
			}
			if yyr2277 || yy2arr2277 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2277[0] {
					yy2279 := &x.KubeletEndpoint
					yy2279.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2277[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2280 := &x.KubeletEndpoint
					yy2280.CodecEncodeSelf(e)
				}
			}
			if yyr2277 || yy2arr2277 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeDaemonEndpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2281 := z.DecBinary()
	_ = yym2281
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2282 := r.ContainerType()
		if yyct2282 == codecSelferValueTypeMap1234 {
			yyl2282 := r.ReadMapStart()
			if yyl2282 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2282, d)
			}
		} else if yyct2282 == codecSelferValueTypeArray1234 {
			yyl2282 := r.ReadArrayStart()
			if yyl2282 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2282, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2283Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2283Slc
	var yyhl2283 bool = l >= 0
	for yyj2283 := 0; ; yyj2283++ {
		if yyhl2283 {
			if yyj2283 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2283Slc = r.DecodeBytes(yys2283Slc, true, true)
		yys2283 := string(yys2283Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2283 {
		case "kubeletEndpoint":
			if r.TryDecodeAsNil() {
				x.KubeletEndpoint = DaemonEndpoint{}
			} else {
				yyv2284 := &x.KubeletEndpoint
				yyv2284.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2283)
		} // end switch yys2283
	} // end for yyj2283
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2285 int
	var yyb2285 bool
	var yyhl2285 bool = l >= 0
	yyj2285++
	if yyhl2285 {
		yyb2285 = yyj2285 > l
	} else {
		yyb2285 = r.CheckBreak()
	}
	if yyb2285 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletEndpoint = DaemonEndpoint{}
	} else {
		yyv2286 := &x.KubeletEndpoint
		yyv2286.CodecDecodeSelf(d)
	}
	for {
		yyj2285++
		if yyhl2285 {
			yyb2285 = yyj2285 > l
		} else {
			yyb2285 = r.CheckBreak()
		}
		if yyb2285 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2285-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSystemInfo) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2287 := z.EncBinary()
		_ = yym2287
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2288 := !z.EncBinary()
			yy2arr2288 := z.EncBasicHandle().StructToArray
			var yyq2288 [8]bool
			_, _, _ = yysep2288, yyq2288, yy2arr2288
			const yyr2288 bool = false
			var yynn2288 int
			if yyr2288 || yy2arr2288 {
				r.EncodeArrayStart(8)
			} else {
				yynn2288 = 8
				for _, b := range yyq2288 {
					if b {
						yynn2288++
					}
				}
				r.EncodeMapStart(yynn2288)
				yynn2288 = 0
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2290 := z.EncBinary()
				_ = yym2290
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("machineID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2291 := z.EncBinary()
				_ = yym2291
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2293 := z.EncBinary()
				_ = yym2293
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemUUID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2294 := z.EncBinary()
				_ = yym2294
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2296 := z.EncBinary()
				_ = yym2296
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bootID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2297 := z.EncBinary()
				_ = yym2297
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2299 := z.EncBinary()
				_ = yym2299
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kernelVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2300 := z.EncBinary()
				_ = yym2300
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2302 := z.EncBinary()
				_ = yym2302
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("osImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2303 := z.EncBinary()
				_ = yym2303
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2305 := z.EncBinary()
				_ = yym2305
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntimeVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2306 := z.EncBinary()
				_ = yym2306
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2308 := z.EncBinary()
				_ = yym2308
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeletVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2309 := z.EncBinary()
				_ = yym2309
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2311 := z.EncBinary()
				_ = yym2311
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeProxyVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2312 := z.EncBinary()
				_ = yym2312
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			}
			if yyr2288 || yy2arr2288 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSystemInfo) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2313 := z.DecBinary()
	_ = yym2313
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2314 := r.ContainerType()
		if yyct2314 == codecSelferValueTypeMap1234 {
			yyl2314 := r.ReadMapStart()
			if yyl2314 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2314, d)
			}
		} else if yyct2314 == codecSelferValueTypeArray1234 {
			yyl2314 := r.ReadArrayStart()
			if yyl2314 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2314, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSystemInfo) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2315Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2315Slc
	var yyhl2315 bool = l >= 0
	for yyj2315 := 0; ; yyj2315++ {
		if yyhl2315 {
			if yyj2315 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2315Slc = r.DecodeBytes(yys2315Slc, true, true)
		yys2315 := string(yys2315Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2315 {
		case "machineID":
			if r.TryDecodeAsNil() {
				x.MachineID = ""
			} else {
				x.MachineID = string(r.DecodeString())
			}
		case "systemUUID":
			if r.TryDecodeAsNil() {
				x.SystemUUID = ""
			} else {
				x.SystemUUID = string(r.DecodeString())
			}
		case "bootID":
			if r.TryDecodeAsNil() {
				x.BootID = ""
			} else {
				x.BootID = string(r.DecodeString())
			}
		case "kernelVersion":
			if r.TryDecodeAsNil() {
				x.KernelVersion = ""
			} else {
				x.KernelVersion = string(r.DecodeString())
			}
		case "osImage":
			if r.TryDecodeAsNil() {
				x.OSImage = ""
			} else {
				x.OSImage = string(r.DecodeString())
			}
		case "containerRuntimeVersion":
			if r.TryDecodeAsNil() {
				x.ContainerRuntimeVersion = ""
			} else {
				x.ContainerRuntimeVersion = string(r.DecodeString())
			}
		case "kubeletVersion":
			if r.TryDecodeAsNil() {
				x.KubeletVersion = ""
			} else {
				x.KubeletVersion = string(r.DecodeString())
			}
		case "kubeProxyVersion":
			if r.TryDecodeAsNil() {
				x.KubeProxyVersion = ""
			} else {
				x.KubeProxyVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2315)
		} // end switch yys2315
	} // end for yyj2315
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSystemInfo) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2324 int
	var yyb2324 bool
	var yyhl2324 bool = l >= 0
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MachineID = ""
	} else {
		x.MachineID = string(r.DecodeString())
	}
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemUUID = ""
	} else {
		x.SystemUUID = string(r.DecodeString())
	}
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BootID = ""
	} else {
		x.BootID = string(r.DecodeString())
	}
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KernelVersion = ""
	} else {
		x.KernelVersion = string(r.DecodeString())
	}
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OSImage = ""
	} else {
		x.OSImage = string(r.DecodeString())
	}
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntimeVersion = ""
	} else {
		x.ContainerRuntimeVersion = string(r.DecodeString())
	}
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletVersion = ""
	} else {
		x.KubeletVersion = string(r.DecodeString())
	}
	yyj2324++
	if yyhl2324 {
		yyb2324 = yyj2324 > l
	} else {
		yyb2324 = r.CheckBreak()
	}
	if yyb2324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeProxyVersion = ""
	} else {
		x.KubeProxyVersion = string(r.DecodeString())
	}
	for {
		yyj2324++
		if yyhl2324 {
			yyb2324 = yyj2324 > l
		} else {
			yyb2324 = r.CheckBreak()
		}
		if yyb2324 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2324-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2333 := z.EncBinary()
		_ = yym2333
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2334 := !z.EncBinary()
			yy2arr2334 := z.EncBasicHandle().StructToArray
			var yyq2334 [7]bool
			_, _, _ = yysep2334, yyq2334, yy2arr2334
			const yyr2334 bool = false
			yyq2334[0] = len(x.Capacity) != 0
			yyq2334[1] = len(x.Allocatable) != 0
			yyq2334[2] = x.Phase != ""
			yyq2334[3] = len(x.Conditions) != 0
			yyq2334[4] = len(x.Addresses) != 0
			yyq2334[5] = true
			yyq2334[6] = true
			var yynn2334 int
			if yyr2334 || yy2arr2334 {
				r.EncodeArrayStart(7)
			} else {
				yynn2334 = 0
				for _, b := range yyq2334 {
					if b {
						yynn2334++
					}
				}
				r.EncodeMapStart(yynn2334)
				yynn2334 = 0
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[1] {
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allocatable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[2] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2334[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[3] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2339 := z.EncBinary()
						_ = yym2339
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2340 := z.EncBinary()
						_ = yym2340
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[4] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2342 := z.EncBinary()
						_ = yym2342
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2343 := z.EncBinary()
						_ = yym2343
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[5] {
					yy2345 := &x.DaemonEndpoints
					yy2345.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("daemonEndpoints"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2346 := &x.DaemonEndpoints
					yy2346.CodecEncodeSelf(e)
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[6] {
					yy2348 := &x.NodeInfo
					yy2348.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeInfo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2349 := &x.NodeInfo
					yy2349.CodecEncodeSelf(e)
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2350 := z.DecBinary()
	_ = yym2350
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2351 := r.ContainerType()
		if yyct2351 == codecSelferValueTypeMap1234 {
			yyl2351 := r.ReadMapStart()
			if yyl2351 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2351, d)
			}
		} else if yyct2351 == codecSelferValueTypeArray1234 {
			yyl2351 := r.ReadArrayStart()
			if yyl2351 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2351, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2352Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2352Slc
	var yyhl2352 bool = l >= 0
	for yyj2352 := 0; ; yyj2352++ {
		if yyhl2352 {
			if yyj2352 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2352Slc = r.DecodeBytes(yys2352Slc, true, true)
		yys2352 := string(yys2352Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2352 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv2353 := &x.Capacity
				yyv2353.CodecDecodeSelf(d)
			}
		case "allocatable":
			if r.TryDecodeAsNil() {
				x.Allocatable = nil
			} else {
				yyv2354 := &x.Allocatable
				yyv2354.CodecDecodeSelf(d)
			}
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NodePhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2356 := &x.Conditions
				yym2357 := z.DecBinary()
				_ = yym2357
				if false {
				} else {
					h.decSliceNodeCondition((*[]NodeCondition)(yyv2356), d)
				}
			}
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2358 := &x.Addresses
				yym2359 := z.DecBinary()
				_ = yym2359
				if false {
				} else {
					h.decSliceNodeAddress((*[]NodeAddress)(yyv2358), d)
				}
			}
		case "daemonEndpoints":
			if r.TryDecodeAsNil() {
				x.DaemonEndpoints = NodeDaemonEndpoints{}
			} else {
				yyv2360 := &x.DaemonEndpoints
				yyv2360.CodecDecodeSelf(d)
			}
		case "nodeInfo":
			if r.TryDecodeAsNil() {
				x.NodeInfo = NodeSystemInfo{}
			} else {
				yyv2361 := &x.NodeInfo
				yyv2361.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2352)
		} // end switch yys2352
	} // end for yyj2352
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2362 int
	var yyb2362 bool
	var yyhl2362 bool = l >= 0
	yyj2362++
	if yyhl2362 {
		yyb2362 = yyj2362 > l
	} else {
		yyb2362 = r.CheckBreak()
	}
	if yyb2362 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv2363 := &x.Capacity
		yyv2363.CodecDecodeSelf(d)
	}
	yyj2362++
	if yyhl2362 {
		yyb2362 = yyj2362 > l
	} else {
		yyb2362 = r.CheckBreak()
	}
	if yyb2362 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allocatable = nil
	} else {
		yyv2364 := &x.Allocatable
		yyv2364.CodecDecodeSelf(d)
	}
	yyj2362++
	if yyhl2362 {
		yyb2362 = yyj2362 > l
	} else {
		yyb2362 = r.CheckBreak()
	}
	if yyb2362 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NodePhase(r.DecodeString())
	}
	yyj2362++
	if yyhl2362 {
		yyb2362 = yyj2362 > l
	} else {
		yyb2362 = r.CheckBreak()
	}
	if yyb2362 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2366 := &x.Conditions
		yym2367 := z.DecBinary()
		_ = yym2367
		if false {
		} else {
			h.decSliceNodeCondition((*[]NodeCondition)(yyv2366), d)
		}
	}
	yyj2362++
	if yyhl2362 {
		yyb2362 = yyj2362 > l
	} else {
		yyb2362 = r.CheckBreak()
	}
	if yyb2362 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2368 := &x.Addresses
		yym2369 := z.DecBinary()
		_ = yym2369
		if false {
		} else {
			h.decSliceNodeAddress((*[]NodeAddress)(yyv2368), d)
		}
	}
	yyj2362++
	if yyhl2362 {
		yyb2362 = yyj2362 > l
	} else {
		yyb2362 = r.CheckBreak()
	}
	if yyb2362 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DaemonEndpoints = NodeDaemonEndpoints{}
	} else {
		yyv2370 := &x.DaemonEndpoints
		yyv2370.CodecDecodeSelf(d)
	}
	yyj2362++
	if yyhl2362 {
		yyb2362 = yyj2362 > l
	} else {
		yyb2362 = r.CheckBreak()
	}
	if yyb2362 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeInfo = NodeSystemInfo{}
	} else {
		yyv2371 := &x.NodeInfo
		yyv2371.CodecDecodeSelf(d)
	}
	for {
		yyj2362++
		if yyhl2362 {
			yyb2362 = yyj2362 > l
		} else {
			yyb2362 = r.CheckBreak()
		}
		if yyb2362 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2362-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2372 := z.EncBinary()
	_ = yym2372
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2373 := z.DecBinary()
	_ = yym2373
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x NodeConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2374 := z.EncBinary()
	_ = yym2374
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2375 := z.DecBinary()
	_ = yym2375
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2376 := z.EncBinary()
		_ = yym2376
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2377 := !z.EncBinary()
			yy2arr2377 := z.EncBasicHandle().StructToArray
			var yyq2377 [6]bool
			_, _, _ = yysep2377, yyq2377, yy2arr2377
			const yyr2377 bool = false
			yyq2377[2] = true
			yyq2377[3] = true
			yyq2377[4] = x.Reason != ""
			yyq2377[5] = x.Message != ""
			var yynn2377 int
			if yyr2377 || yy2arr2377 {
				r.EncodeArrayStart(6)
			} else {
				yynn2377 = 2
				for _, b := range yyq2377 {
					if b {
						yynn2377++
					}
				}
				r.EncodeMapStart(yynn2377)
				yynn2377 = 0
			}
			if yyr2377 || yy2arr2377 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2377 || yy2arr2377 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr2377 || yy2arr2377 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2377[2] {
					yy2381 := &x.LastHeartbeatTime
					yym2382 := z.EncBinary()
					_ = yym2382
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2381) {
					} else if yym2382 {
						z.EncBinaryMarshal(yy2381)
					} else if !yym2382 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2381)
					} else {
						z.EncFallback(yy2381)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2377[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastHeartbeatTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2383 := &x.LastHeartbeatTime
					yym2384 := z.EncBinary()
					_ = yym2384
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2383) {
					} else if yym2384 {
						z.EncBinaryMarshal(yy2383)
					} else if !yym2384 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2383)
					} else {
						z.EncFallback(yy2383)
					}
				}
			}
			if yyr2377 || yy2arr2377 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2377[3] {
					yy2386 := &x.LastTransitionTime
					yym2387 := z.EncBinary()
					_ = yym2387
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2386) {
					} else if yym2387 {
						z.EncBinaryMarshal(yy2386)
					} else if !yym2387 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2386)
					} else {
						z.EncFallback(yy2386)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2377[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2388 := &x.LastTransitionTime
					yym2389 := z.EncBinary()
					_ = yym2389
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2388) {
					} else if yym2389 {
						z.EncBinaryMarshal(yy2388)
					} else if !yym2389 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2388)
					} else {
						z.EncFallback(yy2388)
					}
				}
			}
			if yyr2377 || yy2arr2377 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2377[4] {
					yym2391 := z.EncBinary()
					_ = yym2391
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2377[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2392 := z.EncBinary()
					_ = yym2392
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2377 || yy2arr2377 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2377[5] {
					yym2394 := z.EncBinary()
					_ = yym2394
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2377[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2395 := z.EncBinary()
					_ = yym2395
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2377 || yy2arr2377 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2396 := z.DecBinary()
	_ = yym2396
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2397 := r.ContainerType()
		if yyct2397 == codecSelferValueTypeMap1234 {
			yyl2397 := r.ReadMapStart()
			if yyl2397 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2397, d)
			}
		} else if yyct2397 == codecSelferValueTypeArray1234 {
			yyl2397 := r.ReadArrayStart()
			if yyl2397 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2397, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2398Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2398Slc
	var yyhl2398 bool = l >= 0
	for yyj2398 := 0; ; yyj2398++ {
		if yyhl2398 {
			if yyj2398 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2398Slc = r.DecodeBytes(yys2398Slc, true, true)
		yys2398 := string(yys2398Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2398 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = NodeConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastHeartbeatTime":
			if r.TryDecodeAsNil() {
				x.LastHeartbeatTime = pkg2_unversioned.Time{}
			} else {
				yyv2401 := &x.LastHeartbeatTime
				yym2402 := z.DecBinary()
				_ = yym2402
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2401) {
				} else if yym2402 {
					z.DecBinaryUnmarshal(yyv2401)
				} else if !yym2402 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2401)
				} else {
					z.DecFallback(yyv2401, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv2403 := &x.LastTransitionTime
				yym2404 := z.DecBinary()
				_ = yym2404
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2403) {
				} else if yym2404 {
					z.DecBinaryUnmarshal(yyv2403)
				} else if !yym2404 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2403)
				} else {
					z.DecFallback(yyv2403, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2398)
		} // end switch yys2398
	} // end for yyj2398
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2407 int
	var yyb2407 bool
	var yyhl2407 bool = l >= 0
	yyj2407++
	if yyhl2407 {
		yyb2407 = yyj2407 > l
	} else {
		yyb2407 = r.CheckBreak()
	}
	if yyb2407 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = NodeConditionType(r.DecodeString())
	}
	yyj2407++
	if yyhl2407 {
		yyb2407 = yyj2407 > l
	} else {
		yyb2407 = r.CheckBreak()
	}
	if yyb2407 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj2407++
	if yyhl2407 {
		yyb2407 = yyj2407 > l
	} else {
		yyb2407 = r.CheckBreak()
	}
	if yyb2407 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastHeartbeatTime = pkg2_unversioned.Time{}
	} else {
		yyv2410 := &x.LastHeartbeatTime
		yym2411 := z.DecBinary()
		_ = yym2411
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2410) {
		} else if yym2411 {
			z.DecBinaryUnmarshal(yyv2410)
		} else if !yym2411 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2410)
		} else {
			z.DecFallback(yyv2410, false)
		}
	}
	yyj2407++
	if yyhl2407 {
		yyb2407 = yyj2407 > l
	} else {
		yyb2407 = r.CheckBreak()
	}
	if yyb2407 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv2412 := &x.LastTransitionTime
		yym2413 := z.DecBinary()
		_ = yym2413
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2412) {
		} else if yym2413 {
			z.DecBinaryUnmarshal(yyv2412)
		} else if !yym2413 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2412)
		} else {
			z.DecFallback(yyv2412, false)
		}
	}
	yyj2407++
	if yyhl2407 {
		yyb2407 = yyj2407 > l
	} else {
		yyb2407 = r.CheckBreak()
	}
	if yyb2407 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2407++
	if yyhl2407 {
		yyb2407 = yyj2407 > l
	} else {
		yyb2407 = r.CheckBreak()
	}
	if yyb2407 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj2407++
		if yyhl2407 {
			yyb2407 = yyj2407 > l
		} else {
			yyb2407 = r.CheckBreak()
		}
		if yyb2407 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2407-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeAddressType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2416 := z.EncBinary()
	_ = yym2416
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeAddressType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2417 := z.DecBinary()
	_ = yym2417
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2418 := z.EncBinary()
		_ = yym2418
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2419 := !z.EncBinary()
			yy2arr2419 := z.EncBasicHandle().StructToArray
			var yyq2419 [2]bool
			_, _, _ = yysep2419, yyq2419, yy2arr2419
			const yyr2419 bool = false
			var yynn2419 int
			if yyr2419 || yy2arr2419 {
				r.EncodeArrayStart(2)
			} else {
				yynn2419 = 2
				for _, b := range yyq2419 {
					if b {
						yynn2419++
					}
				}
				r.EncodeMapStart(yynn2419)
				yynn2419 = 0
			}
			if yyr2419 || yy2arr2419 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2419 || yy2arr2419 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2422 := z.EncBinary()
				_ = yym2422
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2423 := z.EncBinary()
				_ = yym2423
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr2419 || yy2arr2419 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2424 := z.DecBinary()
	_ = yym2424
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2425 := r.ContainerType()
		if yyct2425 == codecSelferValueTypeMap1234 {
			yyl2425 := r.ReadMapStart()
			if yyl2425 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2425, d)
			}
		} else if yyct2425 == codecSelferValueTypeArray1234 {
			yyl2425 := r.ReadArrayStart()
			if yyl2425 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2425, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2426Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2426Slc
	var yyhl2426 bool = l >= 0
	for yyj2426 := 0; ; yyj2426++ {
		if yyhl2426 {
			if yyj2426 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2426Slc = r.DecodeBytes(yys2426Slc, true, true)
		yys2426 := string(yys2426Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2426 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = NodeAddressType(r.DecodeString())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2426)
		} // end switch yys2426
	} // end for yyj2426
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2429 int
	var yyb2429 bool
	var yyhl2429 bool = l >= 0
	yyj2429++
	if yyhl2429 {
		yyb2429 = yyj2429 > l
	} else {
		yyb2429 = r.CheckBreak()
	}
	if yyb2429 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = NodeAddressType(r.DecodeString())
	}
	yyj2429++
	if yyhl2429 {
		yyb2429 = yyj2429 > l
	} else {
		yyb2429 = r.CheckBreak()
	}
	if yyb2429 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	for {
		yyj2429++
		if yyhl2429 {
			yyb2429 = yyj2429 > l
		} else {
			yyb2429 = r.CheckBreak()
		}
		if yyb2429 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2429-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ResourceName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2432 := z.EncBinary()
	_ = yym2432
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ResourceName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2433 := z.DecBinary()
	_ = yym2433
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2434 := z.EncBinary()
		_ = yym2434
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			h.encResourceList((ResourceList)(x), e)
		}
	}
}

func (x *ResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2435 := z.DecBinary()
	_ = yym2435
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		h.decResourceList((*ResourceList)(x), d)
	}
}

func (x *Node) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2436 := z.EncBinary()
		_ = yym2436
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2437 := !z.EncBinary()
			yy2arr2437 := z.EncBasicHandle().StructToArray
			var yyq2437 [5]bool
			_, _, _ = yysep2437, yyq2437, yy2arr2437
			const yyr2437 bool = false
			yyq2437[0] = x.Kind != ""
			yyq2437[1] = x.APIVersion != ""
			yyq2437[2] = true
			yyq2437[3] = true
			yyq2437[4] = true
			var yynn2437 int
			if yyr2437 || yy2arr2437 {
				r.EncodeArrayStart(5)
			} else {
				yynn2437 = 0
				for _, b := range yyq2437 {
					if b {
						yynn2437++
					}
				}
				r.EncodeMapStart(yynn2437)
				yynn2437 = 0
			}
			if yyr2437 || yy2arr2437 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2437[0] {
					yym2439 := z.EncBinary()
					_ = yym2439
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2437[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2440 := z.EncBinary()
					_ = yym2440
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2437 || yy2arr2437 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2437[1] {
					yym2442 := z.EncBinary()
					_ = yym2442
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2437[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2443 := z.EncBinary()
					_ = yym2443
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2437 || yy2arr2437 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2437[2] {
					yy2445 := &x.ObjectMeta
					yy2445.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2437[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2446 := &x.ObjectMeta
					yy2446.CodecEncodeSelf(e)
				}
			}
			if yyr2437 || yy2arr2437 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2437[3] {
					yy2448 := &x.Spec
					yy2448.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2437[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2449 := &x.Spec
					yy2449.CodecEncodeSelf(e)
				}
			}
			if yyr2437 || yy2arr2437 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2437[4] {
					yy2451 := &x.Status
					yy2451.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2437[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2452 := &x.Status
					yy2452.CodecEncodeSelf(e)
				}
			}
			if yyr2437 || yy2arr2437 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Node) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2453 := z.DecBinary()
	_ = yym2453
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2454 := r.ContainerType()
		if yyct2454 == codecSelferValueTypeMap1234 {
			yyl2454 := r.ReadMapStart()
			if yyl2454 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2454, d)
			}
		} else if yyct2454 == codecSelferValueTypeArray1234 {
			yyl2454 := r.ReadArrayStart()
			if yyl2454 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2454, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Node) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2455Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2455Slc
	var yyhl2455 bool = l >= 0
	for yyj2455 := 0; ; yyj2455++ {
		if yyhl2455 {
			if yyj2455 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2455Slc = r.DecodeBytes(yys2455Slc, true, true)
		yys2455 := string(yys2455Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2455 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2458 := &x.ObjectMeta
				yyv2458.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NodeSpec{}
			} else {
				yyv2459 := &x.Spec
				yyv2459.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = NodeStatus{}
			} else {
				yyv2460 := &x.Status
				yyv2460.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2455)
		} // end switch yys2455
	} // end for yyj2455
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Node) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2461 int
	var yyb2461 bool
	var yyhl2461 bool = l >= 0
	yyj2461++
	if yyhl2461 {
		yyb2461 = yyj2461 > l
	} else {
		yyb2461 = r.CheckBreak()
	}
	if yyb2461 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2461++
	if yyhl2461 {
		yyb2461 = yyj2461 > l
	} else {
		yyb2461 = r.CheckBreak()
	}
	if yyb2461 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2461++
	if yyhl2461 {
		yyb2461 = yyj2461 > l
	} else {
		yyb2461 = r.CheckBreak()
	}
	if yyb2461 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2464 := &x.ObjectMeta
		yyv2464.CodecDecodeSelf(d)
	}
	yyj2461++
	if yyhl2461 {
		yyb2461 = yyj2461 > l
	} else {
		yyb2461 = r.CheckBreak()
	}
	if yyb2461 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NodeSpec{}
	} else {
		yyv2465 := &x.Spec
		yyv2465.CodecDecodeSelf(d)
	}
	yyj2461++
	if yyhl2461 {
		yyb2461 = yyj2461 > l
	} else {
		yyb2461 = r.CheckBreak()
	}
	if yyb2461 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = NodeStatus{}
	} else {
		yyv2466 := &x.Status
		yyv2466.CodecDecodeSelf(d)
	}
	for {
		yyj2461++
		if yyhl2461 {
			yyb2461 = yyj2461 > l
		} else {
			yyb2461 = r.CheckBreak()
		}
		if yyb2461 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2461-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2467 := z.EncBinary()
		_ = yym2467
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2468 := !z.EncBinary()
			yy2arr2468 := z.EncBasicHandle().StructToArray
			var yyq2468 [4]bool
			_, _, _ = yysep2468, yyq2468, yy2arr2468
			const yyr2468 bool = false
			yyq2468[0] = x.Kind != ""
			yyq2468[1] = x.APIVersion != ""
			yyq2468[2] = true
			var yynn2468 int
			if yyr2468 || yy2arr2468 {
				r.EncodeArrayStart(4)
			} else {
				yynn2468 = 1
				for _, b := range yyq2468 {
					if b {
						yynn2468++
					}
				}
				r.EncodeMapStart(yynn2468)
				yynn2468 = 0
			}
			if yyr2468 || yy2arr2468 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2468[0] {
					yym2470 := z.EncBinary()
					_ = yym2470
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2468[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2471 := z.EncBinary()
					_ = yym2471
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2468 || yy2arr2468 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2468[1] {
					yym2473 := z.EncBinary()
					_ = yym2473
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2468[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2474 := z.EncBinary()
					_ = yym2474
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2468 || yy2arr2468 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2468[2] {
					yy2476 := &x.ListMeta
					yym2477 := z.EncBinary()
					_ = yym2477
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2476) {
					} else {
						z.EncFallback(yy2476)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2468[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2478 := &x.ListMeta
					yym2479 := z.EncBinary()
					_ = yym2479
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2478) {
					} else {
						z.EncFallback(yy2478)
					}
				}
			}
			if yyr2468 || yy2arr2468 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2481 := z.EncBinary()
					_ = yym2481
					if false {
					} else {
						h.encSliceNode(([]Node)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2482 := z.EncBinary()
					_ = yym2482
					if false {
					} else {
						h.encSliceNode(([]Node)(x.Items), e)
					}
				}
			}
			if yyr2468 || yy2arr2468 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2483 := z.DecBinary()
	_ = yym2483
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2484 := r.ContainerType()
		if yyct2484 == codecSelferValueTypeMap1234 {
			yyl2484 := r.ReadMapStart()
			if yyl2484 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2484, d)
			}
		} else if yyct2484 == codecSelferValueTypeArray1234 {
			yyl2484 := r.ReadArrayStart()
			if yyl2484 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2484, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2485Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2485Slc
	var yyhl2485 bool = l >= 0
	for yyj2485 := 0; ; yyj2485++ {
		if yyhl2485 {
			if yyj2485 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2485Slc = r.DecodeBytes(yys2485Slc, true, true)
		yys2485 := string(yys2485Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2485 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2488 := &x.ListMeta
				yym2489 := z.DecBinary()
				_ = yym2489
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2488) {
				} else {
					z.DecFallback(yyv2488, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2490 := &x.Items
				yym2491 := z.DecBinary()
				_ = yym2491
				if false {
				} else {
					h.decSliceNode((*[]Node)(yyv2490), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2485)
		} // end switch yys2485
	} // end for yyj2485
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2492 int
	var yyb2492 bool
	var yyhl2492 bool = l >= 0
	yyj2492++
	if yyhl2492 {
		yyb2492 = yyj2492 > l
	} else {
		yyb2492 = r.CheckBreak()
	}
	if yyb2492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2492++
	if yyhl2492 {
		yyb2492 = yyj2492 > l
	} else {
		yyb2492 = r.CheckBreak()
	}
	if yyb2492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2492++
	if yyhl2492 {
		yyb2492 = yyj2492 > l
	} else {
		yyb2492 = r.CheckBreak()
	}
	if yyb2492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2495 := &x.ListMeta
		yym2496 := z.DecBinary()
		_ = yym2496
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2495) {
		} else {
			z.DecFallback(yyv2495, false)
		}
	}
	yyj2492++
	if yyhl2492 {
		yyb2492 = yyj2492 > l
	} else {
		yyb2492 = r.CheckBreak()
	}
	if yyb2492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2497 := &x.Items
		yym2498 := z.DecBinary()
		_ = yym2498
		if false {
		} else {
			h.decSliceNode((*[]Node)(yyv2497), d)
		}
	}
	for {
		yyj2492++
		if yyhl2492 {
			yyb2492 = yyj2492 > l
		} else {
			yyb2492 = r.CheckBreak()
		}
		if yyb2492 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2492-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FinalizerName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2499 := z.EncBinary()
	_ = yym2499
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FinalizerName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2500 := z.DecBinary()
	_ = yym2500
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NamespaceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2501 := z.EncBinary()
		_ = yym2501
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2502 := !z.EncBinary()
			yy2arr2502 := z.EncBasicHandle().StructToArray
			var yyq2502 [1]bool
			_, _, _ = yysep2502, yyq2502, yy2arr2502
			const yyr2502 bool = false
			yyq2502[0] = len(x.Finalizers) != 0
			var yynn2502 int
			if yyr2502 || yy2arr2502 {
				r.EncodeArrayStart(1)
			} else {
				yynn2502 = 0
				for _, b := range yyq2502 {
					if b {
						yynn2502++
					}
				}
				r.EncodeMapStart(yynn2502)
				yynn2502 = 0
			}
			if yyr2502 || yy2arr2502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2502[0] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym2504 := z.EncBinary()
						_ = yym2504
						if false {
						} else {
							h.encSliceFinalizerName(([]FinalizerName)(x.Finalizers), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2502[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym2505 := z.EncBinary()
						_ = yym2505
						if false {
						} else {
							h.encSliceFinalizerName(([]FinalizerName)(x.Finalizers), e)
						}
					}
				}
			}
			if yyr2502 || yy2arr2502 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NamespaceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2506 := z.DecBinary()
	_ = yym2506
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2507 := r.ContainerType()
		if yyct2507 == codecSelferValueTypeMap1234 {
			yyl2507 := r.ReadMapStart()
			if yyl2507 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2507, d)
			}
		} else if yyct2507 == codecSelferValueTypeArray1234 {
			yyl2507 := r.ReadArrayStart()
			if yyl2507 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2507, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NamespaceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2508Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2508Slc
	var yyhl2508 bool = l >= 0
	for yyj2508 := 0; ; yyj2508++ {
		if yyhl2508 {
			if yyj2508 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2508Slc = r.DecodeBytes(yys2508Slc, true, true)
		yys2508 := string(yys2508Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2508 {
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv2509 := &x.Finalizers
				yym2510 := z.DecBinary()
				_ = yym2510
				if false {
				} else {
					h.decSliceFinalizerName((*[]FinalizerName)(yyv2509), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2508)
		} // end switch yys2508
	} // end for yyj2508
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NamespaceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2511 int
	var yyb2511 bool
	var yyhl2511 bool = l >= 0
	yyj2511++
	if yyhl2511 {
		yyb2511 = yyj2511 > l
	} else {
		yyb2511 = r.CheckBreak()
	}
	if yyb2511 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv2512 := &x.Finalizers
		yym2513 := z.DecBinary()
		_ = yym2513
		if false {
		} else {
			h.decSliceFinalizerName((*[]FinalizerName)(yyv2512), d)
		}
	}
	for {
		yyj2511++
		if yyhl2511 {
			yyb2511 = yyj2511 > l
		} else {
			yyb2511 = r.CheckBreak()
		}
		if yyb2511 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2511-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NamespaceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2514 := z.EncBinary()
		_ = yym2514
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2515 := !z.EncBinary()
			yy2arr2515 := z.EncBasicHandle().StructToArray
			var yyq2515 [1]bool
			_, _, _ = yysep2515, yyq2515, yy2arr2515
			const yyr2515 bool = false
			yyq2515[0] = x.Phase != ""
			var yynn2515 int
			if yyr2515 || yy2arr2515 {
				r.EncodeArrayStart(1)
			} else {
				yynn2515 = 0
				for _, b := range yyq2515 {
					if b {
						yynn2515++
					}
				}
				r.EncodeMapStart(yynn2515)
				yynn2515 = 0
			}
			if yyr2515 || yy2arr2515 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2515[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2515[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2515 || yy2arr2515 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NamespaceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2517 := z.DecBinary()
	_ = yym2517
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2518 := r.ContainerType()
		if yyct2518 == codecSelferValueTypeMap1234 {
			yyl2518 := r.ReadMapStart()
			if yyl2518 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2518, d)
			}
		} else if yyct2518 == codecSelferValueTypeArray1234 {
			yyl2518 := r.ReadArrayStart()
			if yyl2518 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2518, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NamespaceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2519Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2519Slc
	var yyhl2519 bool = l >= 0
	for yyj2519 := 0; ; yyj2519++ {
		if yyhl2519 {
			if yyj2519 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2519Slc = r.DecodeBytes(yys2519Slc, true, true)
		yys2519 := string(yys2519Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2519 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NamespacePhase(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2519)
		} // end switch yys2519
	} // end for yyj2519
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NamespaceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2521 int
	var yyb2521 bool
	var yyhl2521 bool = l >= 0
	yyj2521++
	if yyhl2521 {
		yyb2521 = yyj2521 > l
	} else {
		yyb2521 = r.CheckBreak()
	}
	if yyb2521 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NamespacePhase(r.DecodeString())
	}
	for {
		yyj2521++
		if yyhl2521 {
			yyb2521 = yyj2521 > l
		} else {
			yyb2521 = r.CheckBreak()
		}
		if yyb2521 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2521-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NamespacePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2523 := z.EncBinary()
	_ = yym2523
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NamespacePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2524 := z.DecBinary()
	_ = yym2524
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Namespace) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2525 := z.EncBinary()
		_ = yym2525
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2526 := !z.EncBinary()
			yy2arr2526 := z.EncBasicHandle().StructToArray
			var yyq2526 [5]bool
			_, _, _ = yysep2526, yyq2526, yy2arr2526
			const yyr2526 bool = false
			yyq2526[0] = x.Kind != ""
			yyq2526[1] = x.APIVersion != ""
			yyq2526[2] = true
			yyq2526[3] = true
			yyq2526[4] = true
			var yynn2526 int
			if yyr2526 || yy2arr2526 {
				r.EncodeArrayStart(5)
			} else {
				yynn2526 = 0
				for _, b := range yyq2526 {
					if b {
						yynn2526++
					}
				}
				r.EncodeMapStart(yynn2526)
				yynn2526 = 0
			}
			if yyr2526 || yy2arr2526 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2526[0] {
					yym2528 := z.EncBinary()
					_ = yym2528
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2526[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2529 := z.EncBinary()
					_ = yym2529
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2526 || yy2arr2526 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2526[1] {
					yym2531 := z.EncBinary()
					_ = yym2531
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2526[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2532 := z.EncBinary()
					_ = yym2532
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2526 || yy2arr2526 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2526[2] {
					yy2534 := &x.ObjectMeta
					yy2534.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2526[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2535 := &x.ObjectMeta
					yy2535.CodecEncodeSelf(e)
				}
			}
			if yyr2526 || yy2arr2526 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2526[3] {
					yy2537 := &x.Spec
					yy2537.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2526[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2538 := &x.Spec
					yy2538.CodecEncodeSelf(e)
				}
			}
			if yyr2526 || yy2arr2526 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2526[4] {
					yy2540 := &x.Status
					yy2540.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2526[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2541 := &x.Status
					yy2541.CodecEncodeSelf(e)
				}
			}
			if yyr2526 || yy2arr2526 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Namespace) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2542 := z.DecBinary()
	_ = yym2542
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2543 := r.ContainerType()
		if yyct2543 == codecSelferValueTypeMap1234 {
			yyl2543 := r.ReadMapStart()
			if yyl2543 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2543, d)
			}
		} else if yyct2543 == codecSelferValueTypeArray1234 {
			yyl2543 := r.ReadArrayStart()
			if yyl2543 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2543, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Namespace) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2544Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2544Slc
	var yyhl2544 bool = l >= 0
	for yyj2544 := 0; ; yyj2544++ {
		if yyhl2544 {
			if yyj2544 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2544Slc = r.DecodeBytes(yys2544Slc, true, true)
		yys2544 := string(yys2544Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2544 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2547 := &x.ObjectMeta
				yyv2547.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NamespaceSpec{}
			} else {
				yyv2548 := &x.Spec
				yyv2548.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = NamespaceStatus{}
			} else {
				yyv2549 := &x.Status
				yyv2549.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2544)
		} // end switch yys2544
	} // end for yyj2544
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Namespace) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2550 int
	var yyb2550 bool
	var yyhl2550 bool = l >= 0
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2553 := &x.ObjectMeta
		yyv2553.CodecDecodeSelf(d)
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NamespaceSpec{}
	} else {
		yyv2554 := &x.Spec
		yyv2554.CodecDecodeSelf(d)
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = NamespaceStatus{}
	} else {
		yyv2555 := &x.Status
		yyv2555.CodecDecodeSelf(d)
	}
	for {
		yyj2550++
		if yyhl2550 {
			yyb2550 = yyj2550 > l
		} else {
			yyb2550 = r.CheckBreak()
		}
		if yyb2550 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2550-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NamespaceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2556 := z.EncBinary()
		_ = yym2556
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2557 := !z.EncBinary()
			yy2arr2557 := z.EncBasicHandle().StructToArray
			var yyq2557 [4]bool
			_, _, _ = yysep2557, yyq2557, yy2arr2557
			const yyr2557 bool = false
			yyq2557[0] = x.Kind != ""
			yyq2557[1] = x.APIVersion != ""
			yyq2557[2] = true
			var yynn2557 int
			if yyr2557 || yy2arr2557 {
				r.EncodeArrayStart(4)
			} else {
				yynn2557 = 1
				for _, b := range yyq2557 {
					if b {
						yynn2557++
					}
				}
				r.EncodeMapStart(yynn2557)
				yynn2557 = 0
			}
			if yyr2557 || yy2arr2557 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2557[0] {
					yym2559 := z.EncBinary()
					_ = yym2559
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2557[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2560 := z.EncBinary()
					_ = yym2560
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2557 || yy2arr2557 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2557[1] {
					yym2562 := z.EncBinary()
					_ = yym2562
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2557[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2563 := z.EncBinary()
					_ = yym2563
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2557 || yy2arr2557 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2557[2] {
					yy2565 := &x.ListMeta
					yym2566 := z.EncBinary()
					_ = yym2566
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2565) {
					} else {
						z.EncFallback(yy2565)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2557[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2567 := &x.ListMeta
					yym2568 := z.EncBinary()
					_ = yym2568
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2567) {
					} else {
						z.EncFallback(yy2567)
					}
				}
			}
			if yyr2557 || yy2arr2557 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2570 := z.EncBinary()
					_ = yym2570
					if false {
					} else {
						h.encSliceNamespace(([]Namespace)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2571 := z.EncBinary()
					_ = yym2571
					if false {
					} else {
						h.encSliceNamespace(([]Namespace)(x.Items), e)
					}
				}
			}
			if yyr2557 || yy2arr2557 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NamespaceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2572 := z.DecBinary()
	_ = yym2572
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2573 := r.ContainerType()
		if yyct2573 == codecSelferValueTypeMap1234 {
			yyl2573 := r.ReadMapStart()
			if yyl2573 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2573, d)
			}
		} else if yyct2573 == codecSelferValueTypeArray1234 {
			yyl2573 := r.ReadArrayStart()
			if yyl2573 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2573, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NamespaceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2574Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2574Slc
	var yyhl2574 bool = l >= 0
	for yyj2574 := 0; ; yyj2574++ {
		if yyhl2574 {
			if yyj2574 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2574Slc = r.DecodeBytes(yys2574Slc, true, true)
		yys2574 := string(yys2574Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2574 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2577 := &x.ListMeta
				yym2578 := z.DecBinary()
				_ = yym2578
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2577) {
				} else {
					z.DecFallback(yyv2577, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2579 := &x.Items
				yym2580 := z.DecBinary()
				_ = yym2580
				if false {
				} else {
					h.decSliceNamespace((*[]Namespace)(yyv2579), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2574)
		} // end switch yys2574
	} // end for yyj2574
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NamespaceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2581 int
	var yyb2581 bool
	var yyhl2581 bool = l >= 0
	yyj2581++
	if yyhl2581 {
		yyb2581 = yyj2581 > l
	} else {
		yyb2581 = r.CheckBreak()
	}
	if yyb2581 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2581++
	if yyhl2581 {
		yyb2581 = yyj2581 > l
	} else {
		yyb2581 = r.CheckBreak()
	}
	if yyb2581 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2581++
	if yyhl2581 {
		yyb2581 = yyj2581 > l
	} else {
		yyb2581 = r.CheckBreak()
	}
	if yyb2581 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2584 := &x.ListMeta
		yym2585 := z.DecBinary()
		_ = yym2585
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2584) {
		} else {
			z.DecFallback(yyv2584, false)
		}
	}
	yyj2581++
	if yyhl2581 {
		yyb2581 = yyj2581 > l
	} else {
		yyb2581 = r.CheckBreak()
	}
	if yyb2581 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2586 := &x.Items
		yym2587 := z.DecBinary()
		_ = yym2587
		if false {
		} else {
			h.decSliceNamespace((*[]Namespace)(yyv2586), d)
		}
	}
	for {
		yyj2581++
		if yyhl2581 {
			yyb2581 = yyj2581 > l
		} else {
			yyb2581 = r.CheckBreak()
		}
		if yyb2581 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2581-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Binding) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2588 := z.EncBinary()
		_ = yym2588
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2589 := !z.EncBinary()
			yy2arr2589 := z.EncBasicHandle().StructToArray
			var yyq2589 [4]bool
			_, _, _ = yysep2589, yyq2589, yy2arr2589
			const yyr2589 bool = false
			yyq2589[0] = x.Kind != ""
			yyq2589[1] = x.APIVersion != ""
			yyq2589[2] = true
			var yynn2589 int
			if yyr2589 || yy2arr2589 {
				r.EncodeArrayStart(4)
			} else {
				yynn2589 = 1
				for _, b := range yyq2589 {
					if b {
						yynn2589++
					}
				}
				r.EncodeMapStart(yynn2589)
				yynn2589 = 0
			}
			if yyr2589 || yy2arr2589 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2589[0] {
					yym2591 := z.EncBinary()
					_ = yym2591
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2589[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2592 := z.EncBinary()
					_ = yym2592
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2589 || yy2arr2589 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2589[1] {
					yym2594 := z.EncBinary()
					_ = yym2594
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2589[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2595 := z.EncBinary()
					_ = yym2595
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2589 || yy2arr2589 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2589[2] {
					yy2597 := &x.ObjectMeta
					yy2597.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2589[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2598 := &x.ObjectMeta
					yy2598.CodecEncodeSelf(e)
				}
			}
			if yyr2589 || yy2arr2589 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2600 := &x.Target
				yy2600.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("target"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2601 := &x.Target
				yy2601.CodecEncodeSelf(e)
			}
			if yyr2589 || yy2arr2589 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Binding) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2602 := z.DecBinary()
	_ = yym2602
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2603 := r.ContainerType()
		if yyct2603 == codecSelferValueTypeMap1234 {
			yyl2603 := r.ReadMapStart()
			if yyl2603 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2603, d)
			}
		} else if yyct2603 == codecSelferValueTypeArray1234 {
			yyl2603 := r.ReadArrayStart()
			if yyl2603 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2603, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Binding) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2604Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2604Slc
	var yyhl2604 bool = l >= 0
	for yyj2604 := 0; ; yyj2604++ {
		if yyhl2604 {
			if yyj2604 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2604Slc = r.DecodeBytes(yys2604Slc, true, true)
		yys2604 := string(yys2604Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2604 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2607 := &x.ObjectMeta
				yyv2607.CodecDecodeSelf(d)
			}
		case "target":
			if r.TryDecodeAsNil() {
				x.Target = ObjectReference{}
			} else {
				yyv2608 := &x.Target
				yyv2608.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2604)
		} // end switch yys2604
	} // end for yyj2604
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Binding) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2609 int
	var yyb2609 bool
	var yyhl2609 bool = l >= 0
	yyj2609++
	if yyhl2609 {
		yyb2609 = yyj2609 > l
	} else {
		yyb2609 = r.CheckBreak()
	}
	if yyb2609 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2609++
	if yyhl2609 {
		yyb2609 = yyj2609 > l
	} else {
		yyb2609 = r.CheckBreak()
	}
	if yyb2609 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2609++
	if yyhl2609 {
		yyb2609 = yyj2609 > l
	} else {
		yyb2609 = r.CheckBreak()
	}
	if yyb2609 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2612 := &x.ObjectMeta
		yyv2612.CodecDecodeSelf(d)
	}
	yyj2609++
	if yyhl2609 {
		yyb2609 = yyj2609 > l
	} else {
		yyb2609 = r.CheckBreak()
	}
	if yyb2609 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Target = ObjectReference{}
	} else {
		yyv2613 := &x.Target
		yyv2613.CodecDecodeSelf(d)
	}
	for {
		yyj2609++
		if yyhl2609 {
			yyb2609 = yyj2609 > l
		} else {
			yyb2609 = r.CheckBreak()
		}
		if yyb2609 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2609-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeleteOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2614 := z.EncBinary()
		_ = yym2614
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2615 := !z.EncBinary()
			yy2arr2615 := z.EncBasicHandle().StructToArray
			var yyq2615 [3]bool
			_, _, _ = yysep2615, yyq2615, yy2arr2615
			const yyr2615 bool = false
			yyq2615[0] = x.Kind != ""
			yyq2615[1] = x.APIVersion != ""
			var yynn2615 int
			if yyr2615 || yy2arr2615 {
				r.EncodeArrayStart(3)
			} else {
				yynn2615 = 1
				for _, b := range yyq2615 {
					if b {
						yynn2615++
					}
				}
				r.EncodeMapStart(yynn2615)
				yynn2615 = 0
			}
			if yyr2615 || yy2arr2615 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2615[0] {
					yym2617 := z.EncBinary()
					_ = yym2617
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2615[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2618 := z.EncBinary()
					_ = yym2618
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2615 || yy2arr2615 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2615[1] {
					yym2620 := z.EncBinary()
					_ = yym2620
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2615[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2621 := z.EncBinary()
					_ = yym2621
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2615 || yy2arr2615 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.GracePeriodSeconds == nil {
					r.EncodeNil()
				} else {
					yy2623 := *x.GracePeriodSeconds
					yym2624 := z.EncBinary()
					_ = yym2624
					if false {
					} else {
						r.EncodeInt(int64(yy2623))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("gracePeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.GracePeriodSeconds == nil {
					r.EncodeNil()
				} else {
					yy2625 := *x.GracePeriodSeconds
					yym2626 := z.EncBinary()
					_ = yym2626
					if false {
					} else {
						r.EncodeInt(int64(yy2625))
					}
				}
			}
			if yyr2615 || yy2arr2615 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeleteOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2627 := z.DecBinary()
	_ = yym2627
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2628 := r.ContainerType()
		if yyct2628 == codecSelferValueTypeMap1234 {
			yyl2628 := r.ReadMapStart()
			if yyl2628 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2628, d)
			}
		} else if yyct2628 == codecSelferValueTypeArray1234 {
			yyl2628 := r.ReadArrayStart()
			if yyl2628 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2628, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeleteOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2629Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2629Slc
	var yyhl2629 bool = l >= 0
	for yyj2629 := 0; ; yyj2629++ {
		if yyhl2629 {
			if yyj2629 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2629Slc = r.DecodeBytes(yys2629Slc, true, true)
		yys2629 := string(yys2629Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2629 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "gracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.GracePeriodSeconds != nil {
					x.GracePeriodSeconds = nil
				}
			} else {
				if x.GracePeriodSeconds == nil {
					x.GracePeriodSeconds = new(int64)
				}
				yym2633 := z.DecBinary()
				_ = yym2633
				if false {
				} else {
					*((*int64)(x.GracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2629)
		} // end switch yys2629
	} // end for yyj2629
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeleteOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2634 int
	var yyb2634 bool
	var yyhl2634 bool = l >= 0
	yyj2634++
	if yyhl2634 {
		yyb2634 = yyj2634 > l
	} else {
		yyb2634 = r.CheckBreak()
	}
	if yyb2634 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2634++
	if yyhl2634 {
		yyb2634 = yyj2634 > l
	} else {
		yyb2634 = r.CheckBreak()
	}
	if yyb2634 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2634++
	if yyhl2634 {
		yyb2634 = yyj2634 > l
	} else {
		yyb2634 = r.CheckBreak()
	}
	if yyb2634 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GracePeriodSeconds != nil {
			x.GracePeriodSeconds = nil
		}
	} else {
		if x.GracePeriodSeconds == nil {
			x.GracePeriodSeconds = new(int64)
		}
		yym2638 := z.DecBinary()
		_ = yym2638
		if false {
		} else {
			*((*int64)(x.GracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2634++
		if yyhl2634 {
			yyb2634 = yyj2634 > l
		} else {
			yyb2634 = r.CheckBreak()
		}
		if yyb2634 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2634-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExportOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2639 := z.EncBinary()
		_ = yym2639
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2640 := !z.EncBinary()
			yy2arr2640 := z.EncBasicHandle().StructToArray
			var yyq2640 [4]bool
			_, _, _ = yysep2640, yyq2640, yy2arr2640
			const yyr2640 bool = false
			yyq2640[0] = x.Kind != ""
			yyq2640[1] = x.APIVersion != ""
			var yynn2640 int
			if yyr2640 || yy2arr2640 {
				r.EncodeArrayStart(4)
			} else {
				yynn2640 = 2
				for _, b := range yyq2640 {
					if b {
						yynn2640++
					}
				}
				r.EncodeMapStart(yynn2640)
				yynn2640 = 0
			}
			if yyr2640 || yy2arr2640 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2640[0] {
					yym2642 := z.EncBinary()
					_ = yym2642
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2640[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2643 := z.EncBinary()
					_ = yym2643
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2640 || yy2arr2640 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2640[1] {
					yym2645 := z.EncBinary()
					_ = yym2645
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2640[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2646 := z.EncBinary()
					_ = yym2646
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2640 || yy2arr2640 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2648 := z.EncBinary()
				_ = yym2648
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("export"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2649 := z.EncBinary()
				_ = yym2649
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			}
			if yyr2640 || yy2arr2640 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2651 := z.EncBinary()
				_ = yym2651
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exact"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2652 := z.EncBinary()
				_ = yym2652
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			}
			if yyr2640 || yy2arr2640 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExportOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2653 := z.DecBinary()
	_ = yym2653
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2654 := r.ContainerType()
		if yyct2654 == codecSelferValueTypeMap1234 {
			yyl2654 := r.ReadMapStart()
			if yyl2654 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2654, d)
			}
		} else if yyct2654 == codecSelferValueTypeArray1234 {
			yyl2654 := r.ReadArrayStart()
			if yyl2654 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2654, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExportOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2655Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2655Slc
	var yyhl2655 bool = l >= 0
	for yyj2655 := 0; ; yyj2655++ {
		if yyhl2655 {
			if yyj2655 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2655Slc = r.DecodeBytes(yys2655Slc, true, true)
		yys2655 := string(yys2655Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2655 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "export":
			if r.TryDecodeAsNil() {
				x.Export = false
			} else {
				x.Export = bool(r.DecodeBool())
			}
		case "exact":
			if r.TryDecodeAsNil() {
				x.Exact = false
			} else {
				x.Exact = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2655)
		} // end switch yys2655
	} // end for yyj2655
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExportOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2660 int
	var yyb2660 bool
	var yyhl2660 bool = l >= 0
	yyj2660++
	if yyhl2660 {
		yyb2660 = yyj2660 > l
	} else {
		yyb2660 = r.CheckBreak()
	}
	if yyb2660 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2660++
	if yyhl2660 {
		yyb2660 = yyj2660 > l
	} else {
		yyb2660 = r.CheckBreak()
	}
	if yyb2660 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2660++
	if yyhl2660 {
		yyb2660 = yyj2660 > l
	} else {
		yyb2660 = r.CheckBreak()
	}
	if yyb2660 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Export = false
	} else {
		x.Export = bool(r.DecodeBool())
	}
	yyj2660++
	if yyhl2660 {
		yyb2660 = yyj2660 > l
	} else {
		yyb2660 = r.CheckBreak()
	}
	if yyb2660 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Exact = false
	} else {
		x.Exact = bool(r.DecodeBool())
	}
	for {
		yyj2660++
		if yyhl2660 {
			yyb2660 = yyj2660 > l
		} else {
			yyb2660 = r.CheckBreak()
		}
		if yyb2660 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2660-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ListOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2665 := z.EncBinary()
		_ = yym2665
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2666 := !z.EncBinary()
			yy2arr2666 := z.EncBasicHandle().StructToArray
			var yyq2666 [7]bool
			_, _, _ = yysep2666, yyq2666, yy2arr2666
			const yyr2666 bool = false
			yyq2666[0] = x.Kind != ""
			yyq2666[1] = x.APIVersion != ""
			yyq2666[2] = x.LabelSelector != ""
			yyq2666[3] = x.FieldSelector != ""
			yyq2666[4] = x.Watch != false
			yyq2666[5] = x.ResourceVersion != ""
			yyq2666[6] = x.TimeoutSeconds != nil
			var yynn2666 int
			if yyr2666 || yy2arr2666 {
				r.EncodeArrayStart(7)
			} else {
				yynn2666 = 0
				for _, b := range yyq2666 {
					if b {
						yynn2666++
					}
				}
				r.EncodeMapStart(yynn2666)
				yynn2666 = 0
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2666[0] {
					yym2668 := z.EncBinary()
					_ = yym2668
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2666[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2669 := z.EncBinary()
					_ = yym2669
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2666[1] {
					yym2671 := z.EncBinary()
					_ = yym2671
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2666[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2672 := z.EncBinary()
					_ = yym2672
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2666[2] {
					yym2674 := z.EncBinary()
					_ = yym2674
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LabelSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2666[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2675 := z.EncBinary()
					_ = yym2675
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LabelSelector))
					}
				}
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2666[3] {
					yym2677 := z.EncBinary()
					_ = yym2677
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2666[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2678 := z.EncBinary()
					_ = yym2678
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldSelector))
					}
				}
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2666[4] {
					yym2680 := z.EncBinary()
					_ = yym2680
					if false {
					} else {
						r.EncodeBool(bool(x.Watch))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2666[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("watch"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2681 := z.EncBinary()
					_ = yym2681
					if false {
					} else {
						r.EncodeBool(bool(x.Watch))
					}
				}
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2666[5] {
					yym2683 := z.EncBinary()
					_ = yym2683
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2666[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2684 := z.EncBinary()
					_ = yym2684
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2666[6] {
					if x.TimeoutSeconds == nil {
						r.EncodeNil()
					} else {
						yy2686 := *x.TimeoutSeconds
						yym2687 := z.EncBinary()
						_ = yym2687
						if false {
						} else {
							r.EncodeInt(int64(yy2686))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2666[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TimeoutSeconds == nil {
						r.EncodeNil()
					} else {
						yy2688 := *x.TimeoutSeconds
						yym2689 := z.EncBinary()
						_ = yym2689
						if false {
						} else {
							r.EncodeInt(int64(yy2688))
						}
					}
				}
			}
			if yyr2666 || yy2arr2666 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ListOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2690 := z.DecBinary()
	_ = yym2690
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2691 := r.ContainerType()
		if yyct2691 == codecSelferValueTypeMap1234 {
			yyl2691 := r.ReadMapStart()
			if yyl2691 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2691, d)
			}
		} else if yyct2691 == codecSelferValueTypeArray1234 {
			yyl2691 := r.ReadArrayStart()
			if yyl2691 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2691, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ListOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2692Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2692Slc
	var yyhl2692 bool = l >= 0
	for yyj2692 := 0; ; yyj2692++ {
		if yyhl2692 {
			if yyj2692 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2692Slc = r.DecodeBytes(yys2692Slc, true, true)
		yys2692 := string(yys2692Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2692 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "labelSelector":
			if r.TryDecodeAsNil() {
				x.LabelSelector = ""
			} else {
				x.LabelSelector = string(r.DecodeString())
			}
		case "fieldSelector":
			if r.TryDecodeAsNil() {
				x.FieldSelector = ""
			} else {
				x.FieldSelector = string(r.DecodeString())
			}
		case "watch":
			if r.TryDecodeAsNil() {
				x.Watch = false
			} else {
				x.Watch = bool(r.DecodeBool())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				if x.TimeoutSeconds != nil {
					x.TimeoutSeconds = nil
				}
			} else {
				if x.TimeoutSeconds == nil {
					x.TimeoutSeconds = new(int64)
				}
				yym2700 := z.DecBinary()
				_ = yym2700
				if false {
				} else {
					*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2692)
		} // end switch yys2692
	} // end for yyj2692
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ListOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2701 int
	var yyb2701 bool
	var yyhl2701 bool = l >= 0
	yyj2701++
	if yyhl2701 {
		yyb2701 = yyj2701 > l
	} else {
		yyb2701 = r.CheckBreak()
	}
	if yyb2701 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2701++
	if yyhl2701 {
		yyb2701 = yyj2701 > l
	} else {
		yyb2701 = r.CheckBreak()
	}
	if yyb2701 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2701++
	if yyhl2701 {
		yyb2701 = yyj2701 > l
	} else {
		yyb2701 = r.CheckBreak()
	}
	if yyb2701 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LabelSelector = ""
	} else {
		x.LabelSelector = string(r.DecodeString())
	}
	yyj2701++
	if yyhl2701 {
		yyb2701 = yyj2701 > l
	} else {
		yyb2701 = r.CheckBreak()
	}
	if yyb2701 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldSelector = ""
	} else {
		x.FieldSelector = string(r.DecodeString())
	}
	yyj2701++
	if yyhl2701 {
		yyb2701 = yyj2701 > l
	} else {
		yyb2701 = r.CheckBreak()
	}
	if yyb2701 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Watch = false
	} else {
		x.Watch = bool(r.DecodeBool())
	}
	yyj2701++
	if yyhl2701 {
		yyb2701 = yyj2701 > l
	} else {
		yyb2701 = r.CheckBreak()
	}
	if yyb2701 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj2701++
	if yyhl2701 {
		yyb2701 = yyj2701 > l
	} else {
		yyb2701 = r.CheckBreak()
	}
	if yyb2701 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TimeoutSeconds != nil {
			x.TimeoutSeconds = nil
		}
	} else {
		if x.TimeoutSeconds == nil {
			x.TimeoutSeconds = new(int64)
		}
		yym2709 := z.DecBinary()
		_ = yym2709
		if false {
		} else {
			*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2701++
		if yyhl2701 {
			yyb2701 = yyj2701 > l
		} else {
			yyb2701 = r.CheckBreak()
		}
		if yyb2701 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2701-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodLogOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2710 := z.EncBinary()
		_ = yym2710
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2711 := !z.EncBinary()
			yy2arr2711 := z.EncBasicHandle().StructToArray
			var yyq2711 [10]bool
			_, _, _ = yysep2711, yyq2711, yy2arr2711
			const yyr2711 bool = false
			yyq2711[0] = x.Kind != ""
			yyq2711[1] = x.APIVersion != ""
			yyq2711[2] = x.Container != ""
			yyq2711[3] = x.Follow != false
			yyq2711[4] = x.Previous != false
			yyq2711[5] = x.SinceSeconds != nil
			yyq2711[6] = x.SinceTime != nil
			yyq2711[7] = x.Timestamps != false
			yyq2711[8] = x.TailLines != nil
			yyq2711[9] = x.LimitBytes != nil
			var yynn2711 int
			if yyr2711 || yy2arr2711 {
				r.EncodeArrayStart(10)
			} else {
				yynn2711 = 0
				for _, b := range yyq2711 {
					if b {
						yynn2711++
					}
				}
				r.EncodeMapStart(yynn2711)
				yynn2711 = 0
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[0] {
					yym2713 := z.EncBinary()
					_ = yym2713
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2711[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2714 := z.EncBinary()
					_ = yym2714
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[1] {
					yym2716 := z.EncBinary()
					_ = yym2716
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2711[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2717 := z.EncBinary()
					_ = yym2717
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[2] {
					yym2719 := z.EncBinary()
					_ = yym2719
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2711[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("container"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2720 := z.EncBinary()
					_ = yym2720
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[3] {
					yym2722 := z.EncBinary()
					_ = yym2722
					if false {
					} else {
						r.EncodeBool(bool(x.Follow))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2711[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("follow"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2723 := z.EncBinary()
					_ = yym2723
					if false {
					} else {
						r.EncodeBool(bool(x.Follow))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[4] {
					yym2725 := z.EncBinary()
					_ = yym2725
					if false {
					} else {
						r.EncodeBool(bool(x.Previous))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2711[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("previous"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2726 := z.EncBinary()
					_ = yym2726
					if false {
					} else {
						r.EncodeBool(bool(x.Previous))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[5] {
					if x.SinceSeconds == nil {
						r.EncodeNil()
					} else {
						yy2728 := *x.SinceSeconds
						yym2729 := z.EncBinary()
						_ = yym2729
						if false {
						} else {
							r.EncodeInt(int64(yy2728))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2711[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sinceSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SinceSeconds == nil {
						r.EncodeNil()
					} else {
						yy2730 := *x.SinceSeconds
						yym2731 := z.EncBinary()
						_ = yym2731
						if false {
						} else {
							r.EncodeInt(int64(yy2730))
						}
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[6] {
					if x.SinceTime == nil {
						r.EncodeNil()
					} else {
						yym2733 := z.EncBinary()
						_ = yym2733
						if false {
						} else if z.HasExtensions() && z.EncExt(x.SinceTime) {
						} else if yym2733 {
							z.EncBinaryMarshal(x.SinceTime)
						} else if !yym2733 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.SinceTime)
						} else {
							z.EncFallback(x.SinceTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2711[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sinceTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SinceTime == nil {
						r.EncodeNil()
					} else {
						yym2734 := z.EncBinary()
						_ = yym2734
						if false {
						} else if z.HasExtensions() && z.EncExt(x.SinceTime) {
						} else if yym2734 {
							z.EncBinaryMarshal(x.SinceTime)
						} else if !yym2734 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.SinceTime)
						} else {
							z.EncFallback(x.SinceTime)
						}
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[7] {
					yym2736 := z.EncBinary()
					_ = yym2736
					if false {
					} else {
						r.EncodeBool(bool(x.Timestamps))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2711[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timestamps"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2737 := z.EncBinary()
					_ = yym2737
					if false {
					} else {
						r.EncodeBool(bool(x.Timestamps))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[8] {
					if x.TailLines == nil {
						r.EncodeNil()
					} else {
						yy2739 := *x.TailLines
						yym2740 := z.EncBinary()
						_ = yym2740
						if false {
						} else {
							r.EncodeInt(int64(yy2739))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2711[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tailLines"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TailLines == nil {
						r.EncodeNil()
					} else {
						yy2741 := *x.TailLines
						yym2742 := z.EncBinary()
						_ = yym2742
						if false {
						} else {
							r.EncodeInt(int64(yy2741))
						}
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[9] {
					if x.LimitBytes == nil {
						r.EncodeNil()
					} else {
						yy2744 := *x.LimitBytes
						yym2745 := z.EncBinary()
						_ = yym2745
						if false {
						} else {
							r.EncodeInt(int64(yy2744))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2711[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limitBytes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LimitBytes == nil {
						r.EncodeNil()
					} else {
						yy2746 := *x.LimitBytes
						yym2747 := z.EncBinary()
						_ = yym2747
						if false {
						} else {
							r.EncodeInt(int64(yy2746))
						}
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodLogOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2748 := z.DecBinary()
	_ = yym2748
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2749 := r.ContainerType()
		if yyct2749 == codecSelferValueTypeMap1234 {
			yyl2749 := r.ReadMapStart()
			if yyl2749 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2749, d)
			}
		} else if yyct2749 == codecSelferValueTypeArray1234 {
			yyl2749 := r.ReadArrayStart()
			if yyl2749 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2749, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodLogOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2750Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2750Slc
	var yyhl2750 bool = l >= 0
	for yyj2750 := 0; ; yyj2750++ {
		if yyhl2750 {
			if yyj2750 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2750Slc = r.DecodeBytes(yys2750Slc, true, true)
		yys2750 := string(yys2750Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2750 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "container":
			if r.TryDecodeAsNil() {
				x.Container = ""
			} else {
				x.Container = string(r.DecodeString())
			}
		case "follow":
			if r.TryDecodeAsNil() {
				x.Follow = false
			} else {
				x.Follow = bool(r.DecodeBool())
			}
		case "previous":
			if r.TryDecodeAsNil() {
				x.Previous = false
			} else {
				x.Previous = bool(r.DecodeBool())
			}
		case "sinceSeconds":
			if r.TryDecodeAsNil() {
				if x.SinceSeconds != nil {
					x.SinceSeconds = nil
				}
			} else {
				if x.SinceSeconds == nil {
					x.SinceSeconds = new(int64)
				}
				yym2757 := z.DecBinary()
				_ = yym2757
				if false {
				} else {
					*((*int64)(x.SinceSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "sinceTime":
			if r.TryDecodeAsNil() {
				if x.SinceTime != nil {
					x.SinceTime = nil
				}
			} else {
				if x.SinceTime == nil {
					x.SinceTime = new(pkg2_unversioned.Time)
				}
				yym2759 := z.DecBinary()
				_ = yym2759
				if false {
				} else if z.HasExtensions() && z.DecExt(x.SinceTime) {
				} else if yym2759 {
					z.DecBinaryUnmarshal(x.SinceTime)
				} else if !yym2759 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.SinceTime)
				} else {
					z.DecFallback(x.SinceTime, false)
				}
			}
		case "timestamps":
			if r.TryDecodeAsNil() {
				x.Timestamps = false
			} else {
				x.Timestamps = bool(r.DecodeBool())
			}
		case "tailLines":
			if r.TryDecodeAsNil() {
				if x.TailLines != nil {
					x.TailLines = nil
				}
			} else {
				if x.TailLines == nil {
					x.TailLines = new(int64)
				}
				yym2762 := z.DecBinary()
				_ = yym2762
				if false {
				} else {
					*((*int64)(x.TailLines)) = int64(r.DecodeInt(64))
				}
			}
		case "limitBytes":
			if r.TryDecodeAsNil() {
				if x.LimitBytes != nil {
					x.LimitBytes = nil
				}
			} else {
				if x.LimitBytes == nil {
					x.LimitBytes = new(int64)
				}
				yym2764 := z.DecBinary()
				_ = yym2764
				if false {
				} else {
					*((*int64)(x.LimitBytes)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2750)
		} // end switch yys2750
	} // end for yyj2750
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodLogOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2765 int
	var yyb2765 bool
	var yyhl2765 bool = l >= 0
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Container = ""
	} else {
		x.Container = string(r.DecodeString())
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Follow = false
	} else {
		x.Follow = bool(r.DecodeBool())
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Previous = false
	} else {
		x.Previous = bool(r.DecodeBool())
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SinceSeconds != nil {
			x.SinceSeconds = nil
		}
	} else {
		if x.SinceSeconds == nil {
			x.SinceSeconds = new(int64)
		}
		yym2772 := z.DecBinary()
		_ = yym2772
		if false {
		} else {
			*((*int64)(x.SinceSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SinceTime != nil {
			x.SinceTime = nil
		}
	} else {
		if x.SinceTime == nil {
			x.SinceTime = new(pkg2_unversioned.Time)
		}
		yym2774 := z.DecBinary()
		_ = yym2774
		if false {
		} else if z.HasExtensions() && z.DecExt(x.SinceTime) {
		} else if yym2774 {
			z.DecBinaryUnmarshal(x.SinceTime)
		} else if !yym2774 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.SinceTime)
		} else {
			z.DecFallback(x.SinceTime, false)
		}
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Timestamps = false
	} else {
		x.Timestamps = bool(r.DecodeBool())
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TailLines != nil {
			x.TailLines = nil
		}
	} else {
		if x.TailLines == nil {
			x.TailLines = new(int64)
		}
		yym2777 := z.DecBinary()
		_ = yym2777
		if false {
		} else {
			*((*int64)(x.TailLines)) = int64(r.DecodeInt(64))
		}
	}
	yyj2765++
	if yyhl2765 {
		yyb2765 = yyj2765 > l
	} else {
		yyb2765 = r.CheckBreak()
	}
	if yyb2765 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LimitBytes != nil {
			x.LimitBytes = nil
		}
	} else {
		if x.LimitBytes == nil {
			x.LimitBytes = new(int64)
		}
		yym2779 := z.DecBinary()
		_ = yym2779
		if false {
		} else {
			*((*int64)(x.LimitBytes)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2765++
		if yyhl2765 {
			yyb2765 = yyj2765 > l
		} else {
			yyb2765 = r.CheckBreak()
		}
		if yyb2765 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2765-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAttachOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2780 := z.EncBinary()
		_ = yym2780
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2781 := !z.EncBinary()
			yy2arr2781 := z.EncBasicHandle().StructToArray
			var yyq2781 [7]bool
			_, _, _ = yysep2781, yyq2781, yy2arr2781
			const yyr2781 bool = false
			yyq2781[0] = x.Kind != ""
			yyq2781[1] = x.APIVersion != ""
			yyq2781[2] = x.Stdin != false
			yyq2781[3] = x.Stdout != false
			yyq2781[4] = x.Stderr != false
			yyq2781[5] = x.TTY != false
			yyq2781[6] = x.Container != ""
			var yynn2781 int
			if yyr2781 || yy2arr2781 {
				r.EncodeArrayStart(7)
			} else {
				yynn2781 = 0
				for _, b := range yyq2781 {
					if b {
						yynn2781++
					}
				}
				r.EncodeMapStart(yynn2781)
				yynn2781 = 0
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[0] {
					yym2783 := z.EncBinary()
					_ = yym2783
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2781[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2784 := z.EncBinary()
					_ = yym2784
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[1] {
					yym2786 := z.EncBinary()
					_ = yym2786
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2781[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2787 := z.EncBinary()
					_ = yym2787
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[2] {
					yym2789 := z.EncBinary()
					_ = yym2789
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2781[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2790 := z.EncBinary()
					_ = yym2790
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[3] {
					yym2792 := z.EncBinary()
					_ = yym2792
					if false {
					} else {
						r.EncodeBool(bool(x.Stdout))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2781[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2793 := z.EncBinary()
					_ = yym2793
					if false {
					} else {
						r.EncodeBool(bool(x.Stdout))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[4] {
					yym2795 := z.EncBinary()
					_ = yym2795
					if false {
					} else {
						r.EncodeBool(bool(x.Stderr))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2781[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stderr"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2796 := z.EncBinary()
					_ = yym2796
					if false {
					} else {
						r.EncodeBool(bool(x.Stderr))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[5] {
					yym2798 := z.EncBinary()
					_ = yym2798
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2781[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2799 := z.EncBinary()
					_ = yym2799
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[6] {
					yym2801 := z.EncBinary()
					_ = yym2801
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2781[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("container"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2802 := z.EncBinary()
					_ = yym2802
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAttachOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2803 := z.DecBinary()
	_ = yym2803
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2804 := r.ContainerType()
		if yyct2804 == codecSelferValueTypeMap1234 {
			yyl2804 := r.ReadMapStart()
			if yyl2804 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2804, d)
			}
		} else if yyct2804 == codecSelferValueTypeArray1234 {
			yyl2804 := r.ReadArrayStart()
			if yyl2804 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2804, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAttachOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2805Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2805Slc
	var yyhl2805 bool = l >= 0
	for yyj2805 := 0; ; yyj2805++ {
		if yyhl2805 {
			if yyj2805 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2805Slc = r.DecodeBytes(yys2805Slc, true, true)
		yys2805 := string(yys2805Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2805 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdout":
			if r.TryDecodeAsNil() {
				x.Stdout = false
			} else {
				x.Stdout = bool(r.DecodeBool())
			}
		case "stderr":
			if r.TryDecodeAsNil() {
				x.Stderr = false
			} else {
				x.Stderr = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		case "container":
			if r.TryDecodeAsNil() {
				x.Container = ""
			} else {
				x.Container = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2805)
		} // end switch yys2805
	} // end for yyj2805
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAttachOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2813 int
	var yyb2813 bool
	var yyhl2813 bool = l >= 0
	yyj2813++
	if yyhl2813 {
		yyb2813 = yyj2813 > l
	} else {
		yyb2813 = r.CheckBreak()
	}
	if yyb2813 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2813++
	if yyhl2813 {
		yyb2813 = yyj2813 > l
	} else {
		yyb2813 = r.CheckBreak()
	}
	if yyb2813 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2813++
	if yyhl2813 {
		yyb2813 = yyj2813 > l
	} else {
		yyb2813 = r.CheckBreak()
	}
	if yyb2813 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj2813++
	if yyhl2813 {
		yyb2813 = yyj2813 > l
	} else {
		yyb2813 = r.CheckBreak()
	}
	if yyb2813 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdout = false
	} else {
		x.Stdout = bool(r.DecodeBool())
	}
	yyj2813++
	if yyhl2813 {
		yyb2813 = yyj2813 > l
	} else {
		yyb2813 = r.CheckBreak()
	}
	if yyb2813 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stderr = false
	} else {
		x.Stderr = bool(r.DecodeBool())
	}
	yyj2813++
	if yyhl2813 {
		yyb2813 = yyj2813 > l
	} else {
		yyb2813 = r.CheckBreak()
	}
	if yyb2813 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	yyj2813++
	if yyhl2813 {
		yyb2813 = yyj2813 > l
	} else {
		yyb2813 = r.CheckBreak()
	}
	if yyb2813 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Container = ""
	} else {
		x.Container = string(r.DecodeString())
	}
	for {
		yyj2813++
		if yyhl2813 {
			yyb2813 = yyj2813 > l
		} else {
			yyb2813 = r.CheckBreak()
		}
		if yyb2813 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2813-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodExecOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2821 := z.EncBinary()
		_ = yym2821
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2822 := !z.EncBinary()
			yy2arr2822 := z.EncBasicHandle().StructToArray
			var yyq2822 [8]bool
			_, _, _ = yysep2822, yyq2822, yy2arr2822
			const yyr2822 bool = false
			yyq2822[0] = x.Kind != ""
			yyq2822[1] = x.APIVersion != ""
			yyq2822[2] = x.Stdin != false
			yyq2822[3] = x.Stdout != false
			yyq2822[4] = x.Stderr != false
			yyq2822[5] = x.TTY != false
			yyq2822[6] = x.Container != ""
			var yynn2822 int
			if yyr2822 || yy2arr2822 {
				r.EncodeArrayStart(8)
			} else {
				yynn2822 = 1
				for _, b := range yyq2822 {
					if b {
						yynn2822++
					}
				}
				r.EncodeMapStart(yynn2822)
				yynn2822 = 0
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2822[0] {
					yym2824 := z.EncBinary()
					_ = yym2824
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2822[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2825 := z.EncBinary()
					_ = yym2825
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2822[1] {
					yym2827 := z.EncBinary()
					_ = yym2827
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2822[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2828 := z.EncBinary()
					_ = yym2828
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2822[2] {
					yym2830 := z.EncBinary()
					_ = yym2830
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2822[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2831 := z.EncBinary()
					_ = yym2831
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2822[3] {
					yym2833 := z.EncBinary()
					_ = yym2833
					if false {
					} else {
						r.EncodeBool(bool(x.Stdout))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2822[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2834 := z.EncBinary()
					_ = yym2834
					if false {
					} else {
						r.EncodeBool(bool(x.Stdout))
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2822[4] {
					yym2836 := z.EncBinary()
					_ = yym2836
					if false {
					} else {
						r.EncodeBool(bool(x.Stderr))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2822[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stderr"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2837 := z.EncBinary()
					_ = yym2837
					if false {
					} else {
						r.EncodeBool(bool(x.Stderr))
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2822[5] {
					yym2839 := z.EncBinary()
					_ = yym2839
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2822[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2840 := z.EncBinary()
					_ = yym2840
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2822[6] {
					yym2842 := z.EncBinary()
					_ = yym2842
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2822[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("container"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2843 := z.EncBinary()
					_ = yym2843
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Container))
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Command == nil {
					r.EncodeNil()
				} else {
					yym2845 := z.EncBinary()
					_ = yym2845
					if false {
					} else {
						z.F.EncSliceStringV(x.Command, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("command"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Command == nil {
					r.EncodeNil()
				} else {
					yym2846 := z.EncBinary()
					_ = yym2846
					if false {
					} else {
						z.F.EncSliceStringV(x.Command, false, e)
					}
				}
			}
			if yyr2822 || yy2arr2822 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodExecOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2847 := z.DecBinary()
	_ = yym2847
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2848 := r.ContainerType()
		if yyct2848 == codecSelferValueTypeMap1234 {
			yyl2848 := r.ReadMapStart()
			if yyl2848 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2848, d)
			}
		} else if yyct2848 == codecSelferValueTypeArray1234 {
			yyl2848 := r.ReadArrayStart()
			if yyl2848 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2848, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodExecOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2849Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2849Slc
	var yyhl2849 bool = l >= 0
	for yyj2849 := 0; ; yyj2849++ {
		if yyhl2849 {
			if yyj2849 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2849Slc = r.DecodeBytes(yys2849Slc, true, true)
		yys2849 := string(yys2849Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2849 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdout":
			if r.TryDecodeAsNil() {
				x.Stdout = false
			} else {
				x.Stdout = bool(r.DecodeBool())
			}
		case "stderr":
			if r.TryDecodeAsNil() {
				x.Stderr = false
			} else {
				x.Stderr = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		case "container":
			if r.TryDecodeAsNil() {
				x.Container = ""
			} else {
				x.Container = string(r.DecodeString())
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv2857 := &x.Command
				yym2858 := z.DecBinary()
				_ = yym2858
				if false {
				} else {
					z.F.DecSliceStringX(yyv2857, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2849)
		} // end switch yys2849
	} // end for yyj2849
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodExecOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2859 int
	var yyb2859 bool
	var yyhl2859 bool = l >= 0
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdout = false
	} else {
		x.Stdout = bool(r.DecodeBool())
	}
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stderr = false
	} else {
		x.Stderr = bool(r.DecodeBool())
	}
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Container = ""
	} else {
		x.Container = string(r.DecodeString())
	}
	yyj2859++
	if yyhl2859 {
		yyb2859 = yyj2859 > l
	} else {
		yyb2859 = r.CheckBreak()
	}
	if yyb2859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv2867 := &x.Command
		yym2868 := z.DecBinary()
		_ = yym2868
		if false {
		} else {
			z.F.DecSliceStringX(yyv2867, false, d)
		}
	}
	for {
		yyj2859++
		if yyhl2859 {
			yyb2859 = yyj2859 > l
		} else {
			yyb2859 = r.CheckBreak()
		}
		if yyb2859 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2859-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodProxyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2869 := z.EncBinary()
		_ = yym2869
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2870 := !z.EncBinary()
			yy2arr2870 := z.EncBasicHandle().StructToArray
			var yyq2870 [3]bool
			_, _, _ = yysep2870, yyq2870, yy2arr2870
			const yyr2870 bool = false
			yyq2870[0] = x.Kind != ""
			yyq2870[1] = x.APIVersion != ""
			yyq2870[2] = x.Path != ""
			var yynn2870 int
			if yyr2870 || yy2arr2870 {
				r.EncodeArrayStart(3)
			} else {
				yynn2870 = 0
				for _, b := range yyq2870 {
					if b {
						yynn2870++
					}
				}
				r.EncodeMapStart(yynn2870)
				yynn2870 = 0
			}
			if yyr2870 || yy2arr2870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2870[0] {
					yym2872 := z.EncBinary()
					_ = yym2872
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2870[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2873 := z.EncBinary()
					_ = yym2873
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2870 || yy2arr2870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2870[1] {
					yym2875 := z.EncBinary()
					_ = yym2875
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2870[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2876 := z.EncBinary()
					_ = yym2876
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2870 || yy2arr2870 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2870[2] {
					yym2878 := z.EncBinary()
					_ = yym2878
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2870[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2879 := z.EncBinary()
					_ = yym2879
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr2870 || yy2arr2870 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodProxyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2880 := z.DecBinary()
	_ = yym2880
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2881 := r.ContainerType()
		if yyct2881 == codecSelferValueTypeMap1234 {
			yyl2881 := r.ReadMapStart()
			if yyl2881 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2881, d)
			}
		} else if yyct2881 == codecSelferValueTypeArray1234 {
			yyl2881 := r.ReadArrayStart()
			if yyl2881 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2881, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodProxyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2882Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2882Slc
	var yyhl2882 bool = l >= 0
	for yyj2882 := 0; ; yyj2882++ {
		if yyhl2882 {
			if yyj2882 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2882Slc = r.DecodeBytes(yys2882Slc, true, true)
		yys2882 := string(yys2882Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2882 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2882)
		} // end switch yys2882
	} // end for yyj2882
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodProxyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2886 int
	var yyb2886 bool
	var yyhl2886 bool = l >= 0
	yyj2886++
	if yyhl2886 {
		yyb2886 = yyj2886 > l
	} else {
		yyb2886 = r.CheckBreak()
	}
	if yyb2886 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2886++
	if yyhl2886 {
		yyb2886 = yyj2886 > l
	} else {
		yyb2886 = r.CheckBreak()
	}
	if yyb2886 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2886++
	if yyhl2886 {
		yyb2886 = yyj2886 > l
	} else {
		yyb2886 = r.CheckBreak()
	}
	if yyb2886 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj2886++
		if yyhl2886 {
			yyb2886 = yyj2886 > l
		} else {
			yyb2886 = r.CheckBreak()
		}
		if yyb2886 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2886-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2890 := z.EncBinary()
		_ = yym2890
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2891 := !z.EncBinary()
			yy2arr2891 := z.EncBasicHandle().StructToArray
			var yyq2891 [7]bool
			_, _, _ = yysep2891, yyq2891, yy2arr2891
			const yyr2891 bool = false
			yyq2891[0] = x.Kind != ""
			yyq2891[1] = x.Namespace != ""
			yyq2891[2] = x.Name != ""
			yyq2891[3] = x.UID != ""
			yyq2891[4] = x.APIVersion != ""
			yyq2891[5] = x.ResourceVersion != ""
			yyq2891[6] = x.FieldPath != ""
			var yynn2891 int
			if yyr2891 || yy2arr2891 {
				r.EncodeArrayStart(7)
			} else {
				yynn2891 = 0
				for _, b := range yyq2891 {
					if b {
						yynn2891++
					}
				}
				r.EncodeMapStart(yynn2891)
				yynn2891 = 0
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2891[0] {
					yym2893 := z.EncBinary()
					_ = yym2893
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2891[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2894 := z.EncBinary()
					_ = yym2894
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2891[1] {
					yym2896 := z.EncBinary()
					_ = yym2896
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2891[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2897 := z.EncBinary()
					_ = yym2897
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2891[2] {
					yym2899 := z.EncBinary()
					_ = yym2899
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2891[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2900 := z.EncBinary()
					_ = yym2900
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2891[3] {
					yym2902 := z.EncBinary()
					_ = yym2902
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2891[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2903 := z.EncBinary()
					_ = yym2903
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2891[4] {
					yym2905 := z.EncBinary()
					_ = yym2905
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2891[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2906 := z.EncBinary()
					_ = yym2906
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2891[5] {
					yym2908 := z.EncBinary()
					_ = yym2908
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2891[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2909 := z.EncBinary()
					_ = yym2909
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2891[6] {
					yym2911 := z.EncBinary()
					_ = yym2911
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2891[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2912 := z.EncBinary()
					_ = yym2912
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
					}
				}
			}
			if yyr2891 || yy2arr2891 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2913 := z.DecBinary()
	_ = yym2913
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2914 := r.ContainerType()
		if yyct2914 == codecSelferValueTypeMap1234 {
			yyl2914 := r.ReadMapStart()
			if yyl2914 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2914, d)
			}
		} else if yyct2914 == codecSelferValueTypeArray1234 {
			yyl2914 := r.ReadArrayStart()
			if yyl2914 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2914, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2915Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2915Slc
	var yyhl2915 bool = l >= 0
	for yyj2915 := 0; ; yyj2915++ {
		if yyhl2915 {
			if yyj2915 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2915Slc = r.DecodeBytes(yys2915Slc, true, true)
		yys2915 := string(yys2915Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2915 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2915)
		} // end switch yys2915
	} // end for yyj2915
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2923 int
	var yyb2923 bool
	var yyhl2923 bool = l >= 0
	yyj2923++
	if yyhl2923 {
		yyb2923 = yyj2923 > l
	} else {
		yyb2923 = r.CheckBreak()
	}
	if yyb2923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2923++
	if yyhl2923 {
		yyb2923 = yyj2923 > l
	} else {
		yyb2923 = r.CheckBreak()
	}
	if yyb2923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj2923++
	if yyhl2923 {
		yyb2923 = yyj2923 > l
	} else {
		yyb2923 = r.CheckBreak()
	}
	if yyb2923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2923++
	if yyhl2923 {
		yyb2923 = yyj2923 > l
	} else {
		yyb2923 = r.CheckBreak()
	}
	if yyb2923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj2923++
	if yyhl2923 {
		yyb2923 = yyj2923 > l
	} else {
		yyb2923 = r.CheckBreak()
	}
	if yyb2923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2923++
	if yyhl2923 {
		yyb2923 = yyj2923 > l
	} else {
		yyb2923 = r.CheckBreak()
	}
	if yyb2923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj2923++
	if yyhl2923 {
		yyb2923 = yyj2923 > l
	} else {
		yyb2923 = r.CheckBreak()
	}
	if yyb2923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj2923++
		if yyhl2923 {
			yyb2923 = yyj2923 > l
		} else {
			yyb2923 = r.CheckBreak()
		}
		if yyb2923 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2923-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LocalObjectReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2931 := z.EncBinary()
		_ = yym2931
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2932 := !z.EncBinary()
			yy2arr2932 := z.EncBasicHandle().StructToArray
			var yyq2932 [1]bool
			_, _, _ = yysep2932, yyq2932, yy2arr2932
			const yyr2932 bool = false
			yyq2932[0] = x.Name != ""
			var yynn2932 int
			if yyr2932 || yy2arr2932 {
				r.EncodeArrayStart(1)
			} else {
				yynn2932 = 0
				for _, b := range yyq2932 {
					if b {
						yynn2932++
					}
				}
				r.EncodeMapStart(yynn2932)
				yynn2932 = 0
			}
			if yyr2932 || yy2arr2932 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2932[0] {
					yym2934 := z.EncBinary()
					_ = yym2934
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2932[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2935 := z.EncBinary()
					_ = yym2935
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2932 || yy2arr2932 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LocalObjectReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2936 := z.DecBinary()
	_ = yym2936
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2937 := r.ContainerType()
		if yyct2937 == codecSelferValueTypeMap1234 {
			yyl2937 := r.ReadMapStart()
			if yyl2937 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2937, d)
			}
		} else if yyct2937 == codecSelferValueTypeArray1234 {
			yyl2937 := r.ReadArrayStart()
			if yyl2937 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2937, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LocalObjectReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2938Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2938Slc
	var yyhl2938 bool = l >= 0
	for yyj2938 := 0; ; yyj2938++ {
		if yyhl2938 {
			if yyj2938 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2938Slc = r.DecodeBytes(yys2938Slc, true, true)
		yys2938 := string(yys2938Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2938 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2938)
		} // end switch yys2938
	} // end for yyj2938
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LocalObjectReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2940 int
	var yyb2940 bool
	var yyhl2940 bool = l >= 0
	yyj2940++
	if yyhl2940 {
		yyb2940 = yyj2940 > l
	} else {
		yyb2940 = r.CheckBreak()
	}
	if yyb2940 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj2940++
		if yyhl2940 {
			yyb2940 = yyj2940 > l
		} else {
			yyb2940 = r.CheckBreak()
		}
		if yyb2940 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2940-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SerializedReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2942 := z.EncBinary()
		_ = yym2942
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2943 := !z.EncBinary()
			yy2arr2943 := z.EncBasicHandle().StructToArray
			var yyq2943 [3]bool
			_, _, _ = yysep2943, yyq2943, yy2arr2943
			const yyr2943 bool = false
			yyq2943[0] = x.Kind != ""
			yyq2943[1] = x.APIVersion != ""
			yyq2943[2] = true
			var yynn2943 int
			if yyr2943 || yy2arr2943 {
				r.EncodeArrayStart(3)
			} else {
				yynn2943 = 0
				for _, b := range yyq2943 {
					if b {
						yynn2943++
					}
				}
				r.EncodeMapStart(yynn2943)
				yynn2943 = 0
			}
			if yyr2943 || yy2arr2943 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2943[0] {
					yym2945 := z.EncBinary()
					_ = yym2945
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2943[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2946 := z.EncBinary()
					_ = yym2946
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2943 || yy2arr2943 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2943[1] {
					yym2948 := z.EncBinary()
					_ = yym2948
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2943[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2949 := z.EncBinary()
					_ = yym2949
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2943 || yy2arr2943 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2943[2] {
					yy2951 := &x.Reference
					yy2951.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2943[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reference"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2952 := &x.Reference
					yy2952.CodecEncodeSelf(e)
				}
			}
			if yyr2943 || yy2arr2943 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SerializedReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2953 := z.DecBinary()
	_ = yym2953
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2954 := r.ContainerType()
		if yyct2954 == codecSelferValueTypeMap1234 {
			yyl2954 := r.ReadMapStart()
			if yyl2954 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2954, d)
			}
		} else if yyct2954 == codecSelferValueTypeArray1234 {
			yyl2954 := r.ReadArrayStart()
			if yyl2954 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2954, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SerializedReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2955Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2955Slc
	var yyhl2955 bool = l >= 0
	for yyj2955 := 0; ; yyj2955++ {
		if yyhl2955 {
			if yyj2955 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2955Slc = r.DecodeBytes(yys2955Slc, true, true)
		yys2955 := string(yys2955Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2955 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "reference":
			if r.TryDecodeAsNil() {
				x.Reference = ObjectReference{}
			} else {
				yyv2958 := &x.Reference
				yyv2958.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2955)
		} // end switch yys2955
	} // end for yyj2955
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SerializedReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2959 int
	var yyb2959 bool
	var yyhl2959 bool = l >= 0
	yyj2959++
	if yyhl2959 {
		yyb2959 = yyj2959 > l
	} else {
		yyb2959 = r.CheckBreak()
	}
	if yyb2959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2959++
	if yyhl2959 {
		yyb2959 = yyj2959 > l
	} else {
		yyb2959 = r.CheckBreak()
	}
	if yyb2959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2959++
	if yyhl2959 {
		yyb2959 = yyj2959 > l
	} else {
		yyb2959 = r.CheckBreak()
	}
	if yyb2959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reference = ObjectReference{}
	} else {
		yyv2962 := &x.Reference
		yyv2962.CodecDecodeSelf(d)
	}
	for {
		yyj2959++
		if yyhl2959 {
			yyb2959 = yyj2959 > l
		} else {
			yyb2959 = r.CheckBreak()
		}
		if yyb2959 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2959-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EventSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2963 := z.EncBinary()
		_ = yym2963
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2964 := !z.EncBinary()
			yy2arr2964 := z.EncBasicHandle().StructToArray
			var yyq2964 [2]bool
			_, _, _ = yysep2964, yyq2964, yy2arr2964
			const yyr2964 bool = false
			yyq2964[0] = x.Component != ""
			yyq2964[1] = x.Host != ""
			var yynn2964 int
			if yyr2964 || yy2arr2964 {
				r.EncodeArrayStart(2)
			} else {
				yynn2964 = 0
				for _, b := range yyq2964 {
					if b {
						yynn2964++
					}
				}
				r.EncodeMapStart(yynn2964)
				yynn2964 = 0
			}
			if yyr2964 || yy2arr2964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2964[0] {
					yym2966 := z.EncBinary()
					_ = yym2966
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Component))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2964[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("component"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2967 := z.EncBinary()
					_ = yym2967
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Component))
					}
				}
			}
			if yyr2964 || yy2arr2964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2964[1] {
					yym2969 := z.EncBinary()
					_ = yym2969
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2964[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2970 := z.EncBinary()
					_ = yym2970
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr2964 || yy2arr2964 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EventSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2971 := z.DecBinary()
	_ = yym2971
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2972 := r.ContainerType()
		if yyct2972 == codecSelferValueTypeMap1234 {
			yyl2972 := r.ReadMapStart()
			if yyl2972 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2972, d)
			}
		} else if yyct2972 == codecSelferValueTypeArray1234 {
			yyl2972 := r.ReadArrayStart()
			if yyl2972 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2972, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EventSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2973Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2973Slc
	var yyhl2973 bool = l >= 0
	for yyj2973 := 0; ; yyj2973++ {
		if yyhl2973 {
			if yyj2973 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2973Slc = r.DecodeBytes(yys2973Slc, true, true)
		yys2973 := string(yys2973Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2973 {
		case "component":
			if r.TryDecodeAsNil() {
				x.Component = ""
			} else {
				x.Component = string(r.DecodeString())
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2973)
		} // end switch yys2973
	} // end for yyj2973
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EventSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2976 int
	var yyb2976 bool
	var yyhl2976 bool = l >= 0
	yyj2976++
	if yyhl2976 {
		yyb2976 = yyj2976 > l
	} else {
		yyb2976 = r.CheckBreak()
	}
	if yyb2976 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Component = ""
	} else {
		x.Component = string(r.DecodeString())
	}
	yyj2976++
	if yyhl2976 {
		yyb2976 = yyj2976 > l
	} else {
		yyb2976 = r.CheckBreak()
	}
	if yyb2976 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	for {
		yyj2976++
		if yyhl2976 {
			yyb2976 = yyj2976 > l
		} else {
			yyb2976 = r.CheckBreak()
		}
		if yyb2976 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2976-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Event) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2979 := z.EncBinary()
		_ = yym2979
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2980 := !z.EncBinary()
			yy2arr2980 := z.EncBasicHandle().StructToArray
			var yyq2980 [11]bool
			_, _, _ = yysep2980, yyq2980, yy2arr2980
			const yyr2980 bool = false
			yyq2980[0] = x.Kind != ""
			yyq2980[1] = x.APIVersion != ""
			yyq2980[4] = x.Reason != ""
			yyq2980[5] = x.Message != ""
			yyq2980[6] = true
			yyq2980[7] = true
			yyq2980[8] = true
			yyq2980[9] = x.Count != 0
			yyq2980[10] = x.Type != ""
			var yynn2980 int
			if yyr2980 || yy2arr2980 {
				r.EncodeArrayStart(11)
			} else {
				yynn2980 = 2
				for _, b := range yyq2980 {
					if b {
						yynn2980++
					}
				}
				r.EncodeMapStart(yynn2980)
				yynn2980 = 0
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[0] {
					yym2982 := z.EncBinary()
					_ = yym2982
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2980[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2983 := z.EncBinary()
					_ = yym2983
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[1] {
					yym2985 := z.EncBinary()
					_ = yym2985
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2980[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2986 := z.EncBinary()
					_ = yym2986
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2988 := &x.ObjectMeta
				yy2988.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("metadata"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2989 := &x.ObjectMeta
				yy2989.CodecEncodeSelf(e)
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2991 := &x.InvolvedObject
				yy2991.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("involvedObject"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2992 := &x.InvolvedObject
				yy2992.CodecEncodeSelf(e)
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[4] {
					yym2994 := z.EncBinary()
					_ = yym2994
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2980[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2995 := z.EncBinary()
					_ = yym2995
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[5] {
					yym2997 := z.EncBinary()
					_ = yym2997
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2980[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2998 := z.EncBinary()
					_ = yym2998
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[6] {
					yy3000 := &x.Source
					yy3000.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2980[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("source"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3001 := &x.Source
					yy3001.CodecEncodeSelf(e)
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[7] {
					yy3003 := &x.FirstTimestamp
					yym3004 := z.EncBinary()
					_ = yym3004
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3003) {
					} else if yym3004 {
						z.EncBinaryMarshal(yy3003)
					} else if !yym3004 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3003)
					} else {
						z.EncFallback(yy3003)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2980[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("firstTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3005 := &x.FirstTimestamp
					yym3006 := z.EncBinary()
					_ = yym3006
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3005) {
					} else if yym3006 {
						z.EncBinaryMarshal(yy3005)
					} else if !yym3006 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3005)
					} else {
						z.EncFallback(yy3005)
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[8] {
					yy3008 := &x.LastTimestamp
					yym3009 := z.EncBinary()
					_ = yym3009
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3008) {
					} else if yym3009 {
						z.EncBinaryMarshal(yy3008)
					} else if !yym3009 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3008)
					} else {
						z.EncFallback(yy3008)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2980[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3010 := &x.LastTimestamp
					yym3011 := z.EncBinary()
					_ = yym3011
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3010) {
					} else if yym3011 {
						z.EncBinaryMarshal(yy3010)
					} else if !yym3011 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3010)
					} else {
						z.EncFallback(yy3010)
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[9] {
					yym3013 := z.EncBinary()
					_ = yym3013
					if false {
					} else {
						r.EncodeInt(int64(x.Count))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2980[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("count"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3014 := z.EncBinary()
					_ = yym3014
					if false {
					} else {
						r.EncodeInt(int64(x.Count))
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2980[10] {
					yym3016 := z.EncBinary()
					_ = yym3016
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Type))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2980[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3017 := z.EncBinary()
					_ = yym3017
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Type))
					}
				}
			}
			if yyr2980 || yy2arr2980 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Event) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3018 := z.DecBinary()
	_ = yym3018
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3019 := r.ContainerType()
		if yyct3019 == codecSelferValueTypeMap1234 {
			yyl3019 := r.ReadMapStart()
			if yyl3019 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3019, d)
			}
		} else if yyct3019 == codecSelferValueTypeArray1234 {
			yyl3019 := r.ReadArrayStart()
			if yyl3019 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3019, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Event) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3020Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3020Slc
	var yyhl3020 bool = l >= 0
	for yyj3020 := 0; ; yyj3020++ {
		if yyhl3020 {
			if yyj3020 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3020Slc = r.DecodeBytes(yys3020Slc, true, true)
		yys3020 := string(yys3020Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3020 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv3023 := &x.ObjectMeta
				yyv3023.CodecDecodeSelf(d)
			}
		case "involvedObject":
			if r.TryDecodeAsNil() {
				x.InvolvedObject = ObjectReference{}
			} else {
				yyv3024 := &x.InvolvedObject
				yyv3024.CodecDecodeSelf(d)
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "source":
			if r.TryDecodeAsNil() {
				x.Source = EventSource{}
			} else {
				yyv3027 := &x.Source
				yyv3027.CodecDecodeSelf(d)
			}
		case "firstTimestamp":
			if r.TryDecodeAsNil() {
				x.FirstTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv3028 := &x.FirstTimestamp
				yym3029 := z.DecBinary()
				_ = yym3029
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3028) {
				} else if yym3029 {
					z.DecBinaryUnmarshal(yyv3028)
				} else if !yym3029 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3028)
				} else {
					z.DecFallback(yyv3028, false)
				}
			}
		case "lastTimestamp":
			if r.TryDecodeAsNil() {
				x.LastTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv3030 := &x.LastTimestamp
				yym3031 := z.DecBinary()
				_ = yym3031
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3030) {
				} else if yym3031 {
					z.DecBinaryUnmarshal(yyv3030)
				} else if !yym3031 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3030)
				} else {
					z.DecFallback(yyv3030, false)
				}
			}
		case "count":
			if r.TryDecodeAsNil() {
				x.Count = 0
			} else {
				x.Count = int32(r.DecodeInt(32))
			}
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3020)
		} // end switch yys3020
	} // end for yyj3020
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Event) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3034 int
	var yyb3034 bool
	var yyhl3034 bool = l >= 0
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv3037 := &x.ObjectMeta
		yyv3037.CodecDecodeSelf(d)
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InvolvedObject = ObjectReference{}
	} else {
		yyv3038 := &x.InvolvedObject
		yyv3038.CodecDecodeSelf(d)
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Source = EventSource{}
	} else {
		yyv3041 := &x.Source
		yyv3041.CodecDecodeSelf(d)
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FirstTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv3042 := &x.FirstTimestamp
		yym3043 := z.DecBinary()
		_ = yym3043
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3042) {
		} else if yym3043 {
			z.DecBinaryUnmarshal(yyv3042)
		} else if !yym3043 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3042)
		} else {
			z.DecFallback(yyv3042, false)
		}
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv3044 := &x.LastTimestamp
		yym3045 := z.DecBinary()
		_ = yym3045
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3044) {
		} else if yym3045 {
			z.DecBinaryUnmarshal(yyv3044)
		} else if !yym3045 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3044)
		} else {
			z.DecFallback(yyv3044, false)
		}
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Count = 0
	} else {
		x.Count = int32(r.DecodeInt(32))
	}
	yyj3034++
	if yyhl3034 {
		yyb3034 = yyj3034 > l
	} else {
		yyb3034 = r.CheckBreak()
	}
	if yyb3034 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = string(r.DecodeString())
	}
	for {
		yyj3034++
		if yyhl3034 {
			yyb3034 = yyj3034 > l
		} else {
			yyb3034 = r.CheckBreak()
		}
		if yyb3034 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3034-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EventList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3048 := z.EncBinary()
		_ = yym3048
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3049 := !z.EncBinary()
			yy2arr3049 := z.EncBasicHandle().StructToArray
			var yyq3049 [4]bool
			_, _, _ = yysep3049, yyq3049, yy2arr3049
			const yyr3049 bool = false
			yyq3049[0] = x.Kind != ""
			yyq3049[1] = x.APIVersion != ""
			yyq3049[2] = true
			var yynn3049 int
			if yyr3049 || yy2arr3049 {
				r.EncodeArrayStart(4)
			} else {
				yynn3049 = 1
				for _, b := range yyq3049 {
					if b {
						yynn3049++
					}
				}
				r.EncodeMapStart(yynn3049)
				yynn3049 = 0
			}
			if yyr3049 || yy2arr3049 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3049[0] {
					yym3051 := z.EncBinary()
					_ = yym3051
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3049[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3052 := z.EncBinary()
					_ = yym3052
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3049 || yy2arr3049 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3049[1] {
					yym3054 := z.EncBinary()
					_ = yym3054
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3049[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3055 := z.EncBinary()
					_ = yym3055
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3049 || yy2arr3049 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3049[2] {
					yy3057 := &x.ListMeta
					yym3058 := z.EncBinary()
					_ = yym3058
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3057) {
					} else {
						z.EncFallback(yy3057)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3049[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3059 := &x.ListMeta
					yym3060 := z.EncBinary()
					_ = yym3060
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3059) {
					} else {
						z.EncFallback(yy3059)
					}
				}
			}
			if yyr3049 || yy2arr3049 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3062 := z.EncBinary()
					_ = yym3062
					if false {
					} else {
						h.encSliceEvent(([]Event)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3063 := z.EncBinary()
					_ = yym3063
					if false {
					} else {
						h.encSliceEvent(([]Event)(x.Items), e)
					}
				}
			}
			if yyr3049 || yy2arr3049 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EventList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3064 := z.DecBinary()
	_ = yym3064
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3065 := r.ContainerType()
		if yyct3065 == codecSelferValueTypeMap1234 {
			yyl3065 := r.ReadMapStart()
			if yyl3065 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3065, d)
			}
		} else if yyct3065 == codecSelferValueTypeArray1234 {
			yyl3065 := r.ReadArrayStart()
			if yyl3065 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3065, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EventList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3066Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3066Slc
	var yyhl3066 bool = l >= 0
	for yyj3066 := 0; ; yyj3066++ {
		if yyhl3066 {
			if yyj3066 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3066Slc = r.DecodeBytes(yys3066Slc, true, true)
		yys3066 := string(yys3066Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3066 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv3069 := &x.ListMeta
				yym3070 := z.DecBinary()
				_ = yym3070
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3069) {
				} else {
					z.DecFallback(yyv3069, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv3071 := &x.Items
				yym3072 := z.DecBinary()
				_ = yym3072
				if false {
				} else {
					h.decSliceEvent((*[]Event)(yyv3071), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3066)
		} // end switch yys3066
	} // end for yyj3066
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EventList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3073 int
	var yyb3073 bool
	var yyhl3073 bool = l >= 0
	yyj3073++
	if yyhl3073 {
		yyb3073 = yyj3073 > l
	} else {
		yyb3073 = r.CheckBreak()
	}
	if yyb3073 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3073++
	if yyhl3073 {
		yyb3073 = yyj3073 > l
	} else {
		yyb3073 = r.CheckBreak()
	}
	if yyb3073 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3073++
	if yyhl3073 {
		yyb3073 = yyj3073 > l
	} else {
		yyb3073 = r.CheckBreak()
	}
	if yyb3073 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv3076 := &x.ListMeta
		yym3077 := z.DecBinary()
		_ = yym3077
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3076) {
		} else {
			z.DecFallback(yyv3076, false)
		}
	}
	yyj3073++
	if yyhl3073 {
		yyb3073 = yyj3073 > l
	} else {
		yyb3073 = r.CheckBreak()
	}
	if yyb3073 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv3078 := &x.Items
		yym3079 := z.DecBinary()
		_ = yym3079
		if false {
		} else {
			h.decSliceEvent((*[]Event)(yyv3078), d)
		}
	}
	for {
		yyj3073++
		if yyhl3073 {
			yyb3073 = yyj3073 > l
		} else {
			yyb3073 = r.CheckBreak()
		}
		if yyb3073 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3073-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *List) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3080 := z.EncBinary()
		_ = yym3080
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3081 := !z.EncBinary()
			yy2arr3081 := z.EncBasicHandle().StructToArray
			var yyq3081 [4]bool
			_, _, _ = yysep3081, yyq3081, yy2arr3081
			const yyr3081 bool = false
			yyq3081[0] = x.Kind != ""
			yyq3081[1] = x.APIVersion != ""
			yyq3081[2] = true
			var yynn3081 int
			if yyr3081 || yy2arr3081 {
				r.EncodeArrayStart(4)
			} else {
				yynn3081 = 1
				for _, b := range yyq3081 {
					if b {
						yynn3081++
					}
				}
				r.EncodeMapStart(yynn3081)
				yynn3081 = 0
			}
			if yyr3081 || yy2arr3081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3081[0] {
					yym3083 := z.EncBinary()
					_ = yym3083
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3081[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3084 := z.EncBinary()
					_ = yym3084
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3081 || yy2arr3081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3081[1] {
					yym3086 := z.EncBinary()
					_ = yym3086
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3081[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3087 := z.EncBinary()
					_ = yym3087
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3081 || yy2arr3081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3081[2] {
					yy3089 := &x.ListMeta
					yym3090 := z.EncBinary()
					_ = yym3090
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3089) {
					} else {
						z.EncFallback(yy3089)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3081[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3091 := &x.ListMeta
					yym3092 := z.EncBinary()
					_ = yym3092
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3091) {
					} else {
						z.EncFallback(yy3091)
					}
				}
			}
			if yyr3081 || yy2arr3081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3094 := z.EncBinary()
					_ = yym3094
					if false {
					} else {
						h.encSliceruntime_RawExtension(([]pkg6_runtime.RawExtension)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3095 := z.EncBinary()
					_ = yym3095
					if false {
					} else {
						h.encSliceruntime_RawExtension(([]pkg6_runtime.RawExtension)(x.Items), e)
					}
				}
			}
			if yyr3081 || yy2arr3081 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *List) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3096 := z.DecBinary()
	_ = yym3096
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3097 := r.ContainerType()
		if yyct3097 == codecSelferValueTypeMap1234 {
			yyl3097 := r.ReadMapStart()
			if yyl3097 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3097, d)
			}
		} else if yyct3097 == codecSelferValueTypeArray1234 {
			yyl3097 := r.ReadArrayStart()
			if yyl3097 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3097, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *List) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3098Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3098Slc
	var yyhl3098 bool = l >= 0
	for yyj3098 := 0; ; yyj3098++ {
		if yyhl3098 {
			if yyj3098 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3098Slc = r.DecodeBytes(yys3098Slc, true, true)
		yys3098 := string(yys3098Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3098 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv3101 := &x.ListMeta
				yym3102 := z.DecBinary()
				_ = yym3102
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3101) {
				} else {
					z.DecFallback(yyv3101, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv3103 := &x.Items
				yym3104 := z.DecBinary()
				_ = yym3104
				if false {
				} else {
					h.decSliceruntime_RawExtension((*[]pkg6_runtime.RawExtension)(yyv3103), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3098)
		} // end switch yys3098
	} // end for yyj3098
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *List) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3105 int
	var yyb3105 bool
	var yyhl3105 bool = l >= 0
	yyj3105++
	if yyhl3105 {
		yyb3105 = yyj3105 > l
	} else {
		yyb3105 = r.CheckBreak()
	}
	if yyb3105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3105++
	if yyhl3105 {
		yyb3105 = yyj3105 > l
	} else {
		yyb3105 = r.CheckBreak()
	}
	if yyb3105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3105++
	if yyhl3105 {
		yyb3105 = yyj3105 > l
	} else {
		yyb3105 = r.CheckBreak()
	}
	if yyb3105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv3108 := &x.ListMeta
		yym3109 := z.DecBinary()
		_ = yym3109
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3108) {
		} else {
			z.DecFallback(yyv3108, false)
		}
	}
	yyj3105++
	if yyhl3105 {
		yyb3105 = yyj3105 > l
	} else {
		yyb3105 = r.CheckBreak()
	}
	if yyb3105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv3110 := &x.Items
		yym3111 := z.DecBinary()
		_ = yym3111
		if false {
		} else {
			h.decSliceruntime_RawExtension((*[]pkg6_runtime.RawExtension)(yyv3110), d)
		}
	}
	for {
		yyj3105++
		if yyhl3105 {
			yyb3105 = yyj3105 > l
		} else {
			yyb3105 = r.CheckBreak()
		}
		if yyb3105 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3105-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x LimitType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3112 := z.EncBinary()
	_ = yym3112
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *LimitType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3113 := z.DecBinary()
	_ = yym3113
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *LimitRangeItem) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3114 := z.EncBinary()
		_ = yym3114
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3115 := !z.EncBinary()
			yy2arr3115 := z.EncBasicHandle().StructToArray
			var yyq3115 [6]bool
			_, _, _ = yysep3115, yyq3115, yy2arr3115
			const yyr3115 bool = false
			yyq3115[0] = x.Type != ""
			yyq3115[1] = len(x.Max) != 0
			yyq3115[2] = len(x.Min) != 0
			yyq3115[3] = len(x.Default) != 0
			yyq3115[4] = len(x.DefaultRequest) != 0
			yyq3115[5] = len(x.MaxLimitRequestRatio) != 0
			var yynn3115 int
			if yyr3115 || yy2arr3115 {
				r.EncodeArrayStart(6)
			} else {
				yynn3115 = 0
				for _, b := range yyq3115 {
					if b {
						yynn3115++
					}
				}
				r.EncodeMapStart(yynn3115)
				yynn3115 = 0
			}
			if yyr3115 || yy2arr3115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3115[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3115[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr3115 || yy2arr3115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3115[1] {
					if x.Max == nil {
						r.EncodeNil()
					} else {
						x.Max.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3115[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("max"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Max == nil {
						r.EncodeNil()
					} else {
						x.Max.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3115 || yy2arr3115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3115[2] {
					if x.Min == nil {
						r.EncodeNil()
					} else {
						x.Min.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3115[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("min"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Min == nil {
						r.EncodeNil()
					} else {
						x.Min.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3115 || yy2arr3115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3115[3] {
					if x.Default == nil {
						r.EncodeNil()
					} else {
						x.Default.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3115[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("default"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Default == nil {
						r.EncodeNil()
					} else {
						x.Default.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3115 || yy2arr3115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3115[4] {
					if x.DefaultRequest == nil {
						r.EncodeNil()
					} else {
						x.DefaultRequest.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3115[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultRequest"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultRequest == nil {
						r.EncodeNil()
					} else {
						x.DefaultRequest.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3115 || yy2arr3115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3115[5] {
					if x.MaxLimitRequestRatio == nil {
						r.EncodeNil()
					} else {
						x.MaxLimitRequestRatio.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3115[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxLimitRequestRatio"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxLimitRequestRatio == nil {
						r.EncodeNil()
					} else {
						x.MaxLimitRequestRatio.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3115 || yy2arr3115 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRangeItem) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3122 := z.DecBinary()
	_ = yym3122
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3123 := r.ContainerType()
		if yyct3123 == codecSelferValueTypeMap1234 {
			yyl3123 := r.ReadMapStart()
			if yyl3123 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3123, d)
			}
		} else if yyct3123 == codecSelferValueTypeArray1234 {
			yyl3123 := r.ReadArrayStart()
			if yyl3123 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3123, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRangeItem) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3124Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3124Slc
	var yyhl3124 bool = l >= 0
	for yyj3124 := 0; ; yyj3124++ {
		if yyhl3124 {
			if yyj3124 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3124Slc = r.DecodeBytes(yys3124Slc, true, true)
		yys3124 := string(yys3124Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3124 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = LimitType(r.DecodeString())
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = nil
			} else {
				yyv3126 := &x.Max
				yyv3126.CodecDecodeSelf(d)
			}
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = nil
			} else {
				yyv3127 := &x.Min
				yyv3127.CodecDecodeSelf(d)
			}
		case "default":
			if r.TryDecodeAsNil() {
				x.Default = nil
			} else {
				yyv3128 := &x.Default
				yyv3128.CodecDecodeSelf(d)
			}
		case "defaultRequest":
			if r.TryDecodeAsNil() {
				x.DefaultRequest = nil
			} else {
				yyv3129 := &x.DefaultRequest
				yyv3129.CodecDecodeSelf(d)
			}
		case "maxLimitRequestRatio":
			if r.TryDecodeAsNil() {
				x.MaxLimitRequestRatio = nil
			} else {
				yyv3130 := &x.MaxLimitRequestRatio
				yyv3130.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3124)
		} // end switch yys3124
	} // end for yyj3124
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRangeItem) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3131 int
	var yyb3131 bool
	var yyhl3131 bool = l >= 0
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = LimitType(r.DecodeString())
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = nil
	} else {
		yyv3133 := &x.Max
		yyv3133.CodecDecodeSelf(d)
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = nil
	} else {
		yyv3134 := &x.Min
		yyv3134.CodecDecodeSelf(d)
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Default = nil
	} else {
		yyv3135 := &x.Default
		yyv3135.CodecDecodeSelf(d)
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DefaultRequest = nil
	} else {
		yyv3136 := &x.DefaultRequest
		yyv3136.CodecDecodeSelf(d)
	}
	yyj3131++
	if yyhl3131 {
		yyb3131 = yyj3131 > l
	} else {
		yyb3131 = r.CheckBreak()
	}
	if yyb3131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxLimitRequestRatio = nil
	} else {
		yyv3137 := &x.MaxLimitRequestRatio
		yyv3137.CodecDecodeSelf(d)
	}
	for {
		yyj3131++
		if yyhl3131 {
			yyb3131 = yyj3131 > l
		} else {
			yyb3131 = r.CheckBreak()
		}
		if yyb3131 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3131-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LimitRangeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3138 := z.EncBinary()
		_ = yym3138
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3139 := !z.EncBinary()
			yy2arr3139 := z.EncBasicHandle().StructToArray
			var yyq3139 [1]bool
			_, _, _ = yysep3139, yyq3139, yy2arr3139
			const yyr3139 bool = false
			var yynn3139 int
			if yyr3139 || yy2arr3139 {
				r.EncodeArrayStart(1)
			} else {
				yynn3139 = 1
				for _, b := range yyq3139 {
					if b {
						yynn3139++
					}
				}
				r.EncodeMapStart(yynn3139)
				yynn3139 = 0
			}
			if yyr3139 || yy2arr3139 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Limits == nil {
					r.EncodeNil()
				} else {
					yym3141 := z.EncBinary()
					_ = yym3141
					if false {
					} else {
						h.encSliceLimitRangeItem(([]LimitRangeItem)(x.Limits), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("limits"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Limits == nil {
					r.EncodeNil()
				} else {
					yym3142 := z.EncBinary()
					_ = yym3142
					if false {
					} else {
						h.encSliceLimitRangeItem(([]LimitRangeItem)(x.Limits), e)
					}
				}
			}
			if yyr3139 || yy2arr3139 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRangeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3143 := z.DecBinary()
	_ = yym3143
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3144 := r.ContainerType()
		if yyct3144 == codecSelferValueTypeMap1234 {
			yyl3144 := r.ReadMapStart()
			if yyl3144 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3144, d)
			}
		} else if yyct3144 == codecSelferValueTypeArray1234 {
			yyl3144 := r.ReadArrayStart()
			if yyl3144 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3144, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRangeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3145Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3145Slc
	var yyhl3145 bool = l >= 0
	for yyj3145 := 0; ; yyj3145++ {
		if yyhl3145 {
			if yyj3145 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3145Slc = r.DecodeBytes(yys3145Slc, true, true)
		yys3145 := string(yys3145Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3145 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv3146 := &x.Limits
				yym3147 := z.DecBinary()
				_ = yym3147
				if false {
				} else {
					h.decSliceLimitRangeItem((*[]LimitRangeItem)(yyv3146), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3145)
		} // end switch yys3145
	} // end for yyj3145
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRangeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3148 int
	var yyb3148 bool
	var yyhl3148 bool = l >= 0
	yyj3148++
	if yyhl3148 {
		yyb3148 = yyj3148 > l
	} else {
		yyb3148 = r.CheckBreak()
	}
	if yyb3148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv3149 := &x.Limits
		yym3150 := z.DecBinary()
		_ = yym3150
		if false {
		} else {
			h.decSliceLimitRangeItem((*[]LimitRangeItem)(yyv3149), d)
		}
	}
	for {
		yyj3148++
		if yyhl3148 {
			yyb3148 = yyj3148 > l
		} else {
			yyb3148 = r.CheckBreak()
		}
		if yyb3148 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3148-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LimitRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3151 := z.EncBinary()
		_ = yym3151
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3152 := !z.EncBinary()
			yy2arr3152 := z.EncBasicHandle().StructToArray
			var yyq3152 [4]bool
			_, _, _ = yysep3152, yyq3152, yy2arr3152
			const yyr3152 bool = false
			yyq3152[0] = x.Kind != ""
			yyq3152[1] = x.APIVersion != ""
			yyq3152[2] = true
			yyq3152[3] = true
			var yynn3152 int
			if yyr3152 || yy2arr3152 {
				r.EncodeArrayStart(4)
			} else {
				yynn3152 = 0
				for _, b := range yyq3152 {
					if b {
						yynn3152++
					}
				}
				r.EncodeMapStart(yynn3152)
				yynn3152 = 0
			}
			if yyr3152 || yy2arr3152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3152[0] {
					yym3154 := z.EncBinary()
					_ = yym3154
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3152[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3155 := z.EncBinary()
					_ = yym3155
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3152 || yy2arr3152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3152[1] {
					yym3157 := z.EncBinary()
					_ = yym3157
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3152[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3158 := z.EncBinary()
					_ = yym3158
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3152 || yy2arr3152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3152[2] {
					yy3160 := &x.ObjectMeta
					yy3160.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3152[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3161 := &x.ObjectMeta
					yy3161.CodecEncodeSelf(e)
				}
			}
			if yyr3152 || yy2arr3152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3152[3] {
					yy3163 := &x.Spec
					yy3163.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3152[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3164 := &x.Spec
					yy3164.CodecEncodeSelf(e)
				}
			}
			if yyr3152 || yy2arr3152 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3165 := z.DecBinary()
	_ = yym3165
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3166 := r.ContainerType()
		if yyct3166 == codecSelferValueTypeMap1234 {
			yyl3166 := r.ReadMapStart()
			if yyl3166 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3166, d)
			}
		} else if yyct3166 == codecSelferValueTypeArray1234 {
			yyl3166 := r.ReadArrayStart()
			if yyl3166 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3166, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3167Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3167Slc
	var yyhl3167 bool = l >= 0
	for yyj3167 := 0; ; yyj3167++ {
		if yyhl3167 {
			if yyj3167 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3167Slc = r.DecodeBytes(yys3167Slc, true, true)
		yys3167 := string(yys3167Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3167 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv3170 := &x.ObjectMeta
				yyv3170.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = LimitRangeSpec{}
			} else {
				yyv3171 := &x.Spec
				yyv3171.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3167)
		} // end switch yys3167
	} // end for yyj3167
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3172 int
	var yyb3172 bool
	var yyhl3172 bool = l >= 0
	yyj3172++
	if yyhl3172 {
		yyb3172 = yyj3172 > l
	} else {
		yyb3172 = r.CheckBreak()
	}
	if yyb3172 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3172++
	if yyhl3172 {
		yyb3172 = yyj3172 > l
	} else {
		yyb3172 = r.CheckBreak()
	}
	if yyb3172 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3172++
	if yyhl3172 {
		yyb3172 = yyj3172 > l
	} else {
		yyb3172 = r.CheckBreak()
	}
	if yyb3172 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv3175 := &x.ObjectMeta
		yyv3175.CodecDecodeSelf(d)
	}
	yyj3172++
	if yyhl3172 {
		yyb3172 = yyj3172 > l
	} else {
		yyb3172 = r.CheckBreak()
	}
	if yyb3172 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = LimitRangeSpec{}
	} else {
		yyv3176 := &x.Spec
		yyv3176.CodecDecodeSelf(d)
	}
	for {
		yyj3172++
		if yyhl3172 {
			yyb3172 = yyj3172 > l
		} else {
			yyb3172 = r.CheckBreak()
		}
		if yyb3172 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3172-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LimitRangeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3177 := z.EncBinary()
		_ = yym3177
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3178 := !z.EncBinary()
			yy2arr3178 := z.EncBasicHandle().StructToArray
			var yyq3178 [4]bool
			_, _, _ = yysep3178, yyq3178, yy2arr3178
			const yyr3178 bool = false
			yyq3178[0] = x.Kind != ""
			yyq3178[1] = x.APIVersion != ""
			yyq3178[2] = true
			var yynn3178 int
			if yyr3178 || yy2arr3178 {
				r.EncodeArrayStart(4)
			} else {
				yynn3178 = 1
				for _, b := range yyq3178 {
					if b {
						yynn3178++
					}
				}
				r.EncodeMapStart(yynn3178)
				yynn3178 = 0
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[0] {
					yym3180 := z.EncBinary()
					_ = yym3180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3178[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3181 := z.EncBinary()
					_ = yym3181
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[1] {
					yym3183 := z.EncBinary()
					_ = yym3183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3178[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3184 := z.EncBinary()
					_ = yym3184
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[2] {
					yy3186 := &x.ListMeta
					yym3187 := z.EncBinary()
					_ = yym3187
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3186) {
					} else {
						z.EncFallback(yy3186)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3178[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3188 := &x.ListMeta
					yym3189 := z.EncBinary()
					_ = yym3189
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3188) {
					} else {
						z.EncFallback(yy3188)
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3191 := z.EncBinary()
					_ = yym3191
					if false {
					} else {
						h.encSliceLimitRange(([]LimitRange)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3192 := z.EncBinary()
					_ = yym3192
					if false {
					} else {
						h.encSliceLimitRange(([]LimitRange)(x.Items), e)
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LimitRangeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3193 := z.DecBinary()
	_ = yym3193
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3194 := r.ContainerType()
		if yyct3194 == codecSelferValueTypeMap1234 {
			yyl3194 := r.ReadMapStart()
			if yyl3194 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3194, d)
			}
		} else if yyct3194 == codecSelferValueTypeArray1234 {
			yyl3194 := r.ReadArrayStart()
			if yyl3194 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3194, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LimitRangeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3195Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3195Slc
	var yyhl3195 bool = l >= 0
	for yyj3195 := 0; ; yyj3195++ {
		if yyhl3195 {
			if yyj3195 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3195Slc = r.DecodeBytes(yys3195Slc, true, true)
		yys3195 := string(yys3195Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3195 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv3198 := &x.ListMeta
				yym3199 := z.DecBinary()
				_ = yym3199
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3198) {
				} else {
					z.DecFallback(yyv3198, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv3200 := &x.Items
				yym3201 := z.DecBinary()
				_ = yym3201
				if false {
				} else {
					h.decSliceLimitRange((*[]LimitRange)(yyv3200), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3195)
		} // end switch yys3195
	} // end for yyj3195
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LimitRangeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3202 int
	var yyb3202 bool
	var yyhl3202 bool = l >= 0
	yyj3202++
	if yyhl3202 {
		yyb3202 = yyj3202 > l
	} else {
		yyb3202 = r.CheckBreak()
	}
	if yyb3202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3202++
	if yyhl3202 {
		yyb3202 = yyj3202 > l
	} else {
		yyb3202 = r.CheckBreak()
	}
	if yyb3202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3202++
	if yyhl3202 {
		yyb3202 = yyj3202 > l
	} else {
		yyb3202 = r.CheckBreak()
	}
	if yyb3202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv3205 := &x.ListMeta
		yym3206 := z.DecBinary()
		_ = yym3206
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3205) {
		} else {
			z.DecFallback(yyv3205, false)
		}
	}
	yyj3202++
	if yyhl3202 {
		yyb3202 = yyj3202 > l
	} else {
		yyb3202 = r.CheckBreak()
	}
	if yyb3202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv3207 := &x.Items
		yym3208 := z.DecBinary()
		_ = yym3208
		if false {
		} else {
			h.decSliceLimitRange((*[]LimitRange)(yyv3207), d)
		}
	}
	for {
		yyj3202++
		if yyhl3202 {
			yyb3202 = yyj3202 > l
		} else {
			yyb3202 = r.CheckBreak()
		}
		if yyb3202 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3202-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuotaSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3209 := z.EncBinary()
		_ = yym3209
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3210 := !z.EncBinary()
			yy2arr3210 := z.EncBasicHandle().StructToArray
			var yyq3210 [1]bool
			_, _, _ = yysep3210, yyq3210, yy2arr3210
			const yyr3210 bool = false
			yyq3210[0] = len(x.Hard) != 0
			var yynn3210 int
			if yyr3210 || yy2arr3210 {
				r.EncodeArrayStart(1)
			} else {
				yynn3210 = 0
				for _, b := range yyq3210 {
					if b {
						yynn3210++
					}
				}
				r.EncodeMapStart(yynn3210)
				yynn3210 = 0
			}
			if yyr3210 || yy2arr3210 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3210[0] {
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3210[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3210 || yy2arr3210 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceQuotaSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3212 := z.DecBinary()
	_ = yym3212
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3213 := r.ContainerType()
		if yyct3213 == codecSelferValueTypeMap1234 {
			yyl3213 := r.ReadMapStart()
			if yyl3213 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3213, d)
			}
		} else if yyct3213 == codecSelferValueTypeArray1234 {
			yyl3213 := r.ReadArrayStart()
			if yyl3213 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3213, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceQuotaSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3214Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3214Slc
	var yyhl3214 bool = l >= 0
	for yyj3214 := 0; ; yyj3214++ {
		if yyhl3214 {
			if yyj3214 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3214Slc = r.DecodeBytes(yys3214Slc, true, true)
		yys3214 := string(yys3214Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3214 {
		case "hard":
			if r.TryDecodeAsNil() {
				x.Hard = nil
			} else {
				yyv3215 := &x.Hard
				yyv3215.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3214)
		} // end switch yys3214
	} // end for yyj3214
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceQuotaSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3216 int
	var yyb3216 bool
	var yyhl3216 bool = l >= 0
	yyj3216++
	if yyhl3216 {
		yyb3216 = yyj3216 > l
	} else {
		yyb3216 = r.CheckBreak()
	}
	if yyb3216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hard = nil
	} else {
		yyv3217 := &x.Hard
		yyv3217.CodecDecodeSelf(d)
	}
	for {
		yyj3216++
		if yyhl3216 {
			yyb3216 = yyj3216 > l
		} else {
			yyb3216 = r.CheckBreak()
		}
		if yyb3216 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3216-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuotaStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3218 := z.EncBinary()
		_ = yym3218
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3219 := !z.EncBinary()
			yy2arr3219 := z.EncBasicHandle().StructToArray
			var yyq3219 [2]bool
			_, _, _ = yysep3219, yyq3219, yy2arr3219
			const yyr3219 bool = false
			yyq3219[0] = len(x.Hard) != 0
			yyq3219[1] = len(x.Used) != 0
			var yynn3219 int
			if yyr3219 || yy2arr3219 {
				r.EncodeArrayStart(2)
			} else {
				yynn3219 = 0
				for _, b := range yyq3219 {
					if b {
						yynn3219++
					}
				}
				r.EncodeMapStart(yynn3219)
				yynn3219 = 0
			}
			if yyr3219 || yy2arr3219 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3219[0] {
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3219[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hard == nil {
						r.EncodeNil()
					} else {
						x.Hard.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3219 || yy2arr3219 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3219[1] {
					if x.Used == nil {
						r.EncodeNil()
					} else {
						x.Used.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3219[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("used"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Used == nil {
						r.EncodeNil()
					} else {
						x.Used.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3219 || yy2arr3219 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceQuotaStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3222 := z.DecBinary()
	_ = yym3222
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3223 := r.ContainerType()
		if yyct3223 == codecSelferValueTypeMap1234 {
			yyl3223 := r.ReadMapStart()
			if yyl3223 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3223, d)
			}
		} else if yyct3223 == codecSelferValueTypeArray1234 {
			yyl3223 := r.ReadArrayStart()
			if yyl3223 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3223, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceQuotaStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3224Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3224Slc
	var yyhl3224 bool = l >= 0
	for yyj3224 := 0; ; yyj3224++ {
		if yyhl3224 {
			if yyj3224 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3224Slc = r.DecodeBytes(yys3224Slc, true, true)
		yys3224 := string(yys3224Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3224 {
		case "hard":
			if r.TryDecodeAsNil() {
				x.Hard = nil
			} else {
				yyv3225 := &x.Hard
				yyv3225.CodecDecodeSelf(d)
			}
		case "used":
			if r.TryDecodeAsNil() {
				x.Used = nil
			} else {
				yyv3226 := &x.Used
				yyv3226.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3224)
		} // end switch yys3224
	} // end for yyj3224
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceQuotaStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3227 int
	var yyb3227 bool
	var yyhl3227 bool = l >= 0
	yyj3227++
	if yyhl3227 {
		yyb3227 = yyj3227 > l
	} else {
		yyb3227 = r.CheckBreak()
	}
	if yyb3227 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hard = nil
	} else {
		yyv3228 := &x.Hard
		yyv3228.CodecDecodeSelf(d)
	}
	yyj3227++
	if yyhl3227 {
		yyb3227 = yyj3227 > l
	} else {
		yyb3227 = r.CheckBreak()
	}
	if yyb3227 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Used = nil
	} else {
		yyv3229 := &x.Used
		yyv3229.CodecDecodeSelf(d)
	}
	for {
		yyj3227++
		if yyhl3227 {
			yyb3227 = yyj3227 > l
		} else {
			yyb3227 = r.CheckBreak()
		}
		if yyb3227 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3227-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuota) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3230 := z.EncBinary()
		_ = yym3230
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3231 := !z.EncBinary()
			yy2arr3231 := z.EncBasicHandle().StructToArray
			var yyq3231 [5]bool
			_, _, _ = yysep3231, yyq3231, yy2arr3231
			const yyr3231 bool = false
			yyq3231[0] = x.Kind != ""
			yyq3231[1] = x.APIVersion != ""
			yyq3231[2] = true
			yyq3231[3] = true
			yyq3231[4] = true
			var yynn3231 int
			if yyr3231 || yy2arr3231 {
				r.EncodeArrayStart(5)
			} else {
				yynn3231 = 0
				for _, b := range yyq3231 {
					if b {
						yynn3231++
					}
				}
				r.EncodeMapStart(yynn3231)
				yynn3231 = 0
			}
			if yyr3231 || yy2arr3231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3231[0] {
					yym3233 := z.EncBinary()
					_ = yym3233
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3231[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3234 := z.EncBinary()
					_ = yym3234
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3231 || yy2arr3231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3231[1] {
					yym3236 := z.EncBinary()
					_ = yym3236
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3231[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3237 := z.EncBinary()
					_ = yym3237
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3231 || yy2arr3231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3231[2] {
					yy3239 := &x.ObjectMeta
					yy3239.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3231[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3240 := &x.ObjectMeta
					yy3240.CodecEncodeSelf(e)
				}
			}
			if yyr3231 || yy2arr3231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3231[3] {
					yy3242 := &x.Spec
					yy3242.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3231[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3243 := &x.Spec
					yy3243.CodecEncodeSelf(e)
				}
			}
			if yyr3231 || yy2arr3231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3231[4] {
					yy3245 := &x.Status
					yy3245.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3231[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3246 := &x.Status
					yy3246.CodecEncodeSelf(e)
				}
			}
			if yyr3231 || yy2arr3231 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceQuota) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3247 := z.DecBinary()
	_ = yym3247
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3248 := r.ContainerType()
		if yyct3248 == codecSelferValueTypeMap1234 {
			yyl3248 := r.ReadMapStart()
			if yyl3248 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3248, d)
			}
		} else if yyct3248 == codecSelferValueTypeArray1234 {
			yyl3248 := r.ReadArrayStart()
			if yyl3248 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3248, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceQuota) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3249Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3249Slc
	var yyhl3249 bool = l >= 0
	for yyj3249 := 0; ; yyj3249++ {
		if yyhl3249 {
			if yyj3249 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3249Slc = r.DecodeBytes(yys3249Slc, true, true)
		yys3249 := string(yys3249Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3249 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv3252 := &x.ObjectMeta
				yyv3252.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ResourceQuotaSpec{}
			} else {
				yyv3253 := &x.Spec
				yyv3253.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ResourceQuotaStatus{}
			} else {
				yyv3254 := &x.Status
				yyv3254.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3249)
		} // end switch yys3249
	} // end for yyj3249
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceQuota) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3255 int
	var yyb3255 bool
	var yyhl3255 bool = l >= 0
	yyj3255++
	if yyhl3255 {
		yyb3255 = yyj3255 > l
	} else {
		yyb3255 = r.CheckBreak()
	}
	if yyb3255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3255++
	if yyhl3255 {
		yyb3255 = yyj3255 > l
	} else {
		yyb3255 = r.CheckBreak()
	}
	if yyb3255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3255++
	if yyhl3255 {
		yyb3255 = yyj3255 > l
	} else {
		yyb3255 = r.CheckBreak()
	}
	if yyb3255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv3258 := &x.ObjectMeta
		yyv3258.CodecDecodeSelf(d)
	}
	yyj3255++
	if yyhl3255 {
		yyb3255 = yyj3255 > l
	} else {
		yyb3255 = r.CheckBreak()
	}
	if yyb3255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ResourceQuotaSpec{}
	} else {
		yyv3259 := &x.Spec
		yyv3259.CodecDecodeSelf(d)
	}
	yyj3255++
	if yyhl3255 {
		yyb3255 = yyj3255 > l
	} else {
		yyb3255 = r.CheckBreak()
	}
	if yyb3255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ResourceQuotaStatus{}
	} else {
		yyv3260 := &x.Status
		yyv3260.CodecDecodeSelf(d)
	}
	for {
		yyj3255++
		if yyhl3255 {
			yyb3255 = yyj3255 > l
		} else {
			yyb3255 = r.CheckBreak()
		}
		if yyb3255 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3255-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceQuotaList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3261 := z.EncBinary()
		_ = yym3261
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3262 := !z.EncBinary()
			yy2arr3262 := z.EncBasicHandle().StructToArray
			var yyq3262 [4]bool
			_, _, _ = yysep3262, yyq3262, yy2arr3262
			const yyr3262 bool = false
			yyq3262[0] = x.Kind != ""
			yyq3262[1] = x.APIVersion != ""
			yyq3262[2] = true
			var yynn3262 int
			if yyr3262 || yy2arr3262 {
				r.EncodeArrayStart(4)
			} else {
				yynn3262 = 1
				for _, b := range yyq3262 {
					if b {
						yynn3262++
					}
				}
				r.EncodeMapStart(yynn3262)
				yynn3262 = 0
			}
			if yyr3262 || yy2arr3262 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3262[0] {
					yym3264 := z.EncBinary()
					_ = yym3264
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3262[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3265 := z.EncBinary()
					_ = yym3265
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3262 || yy2arr3262 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3262[1] {
					yym3267 := z.EncBinary()
					_ = yym3267
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3262[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3268 := z.EncBinary()
					_ = yym3268
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3262 || yy2arr3262 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3262[2] {
					yy3270 := &x.ListMeta
					yym3271 := z.EncBinary()
					_ = yym3271
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3270) {
					} else {
						z.EncFallback(yy3270)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3262[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3272 := &x.ListMeta
					yym3273 := z.EncBinary()
					_ = yym3273
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3272) {
					} else {
						z.EncFallback(yy3272)
					}
				}
			}
			if yyr3262 || yy2arr3262 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3275 := z.EncBinary()
					_ = yym3275
					if false {
					} else {
						h.encSliceResourceQuota(([]ResourceQuota)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym3276 := z.EncBinary()
					_ = yym3276
					if false {
					} else {
						h.encSliceResourceQuota(([]ResourceQuota)(x.Items), e)
					}
				}
			}
			if yyr3262 || yy2arr3262 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceQuotaList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3277 := z.DecBinary()
	_ = yym3277
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3278 := r.ContainerType()
		if yyct3278 == codecSelferValueTypeMap1234 {
			yyl3278 := r.ReadMapStart()
			if yyl3278 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3278, d)
			}
		} else if yyct3278 == codecSelferValueTypeArray1234 {
			yyl3278 := r.ReadArrayStart()
			if yyl3278 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3278, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceQuotaList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3279Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3279Slc
	var yyhl3279 bool = l >= 0
	for yyj3279 := 0; ; yyj3279++ {
		if yyhl3279 {
			if yyj3279 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3279Slc = r.DecodeBytes(yys3279Slc, true, true)
		yys3279 := string(yys3279Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3279 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv3282 := &x.ListMeta
				yym3283 := z.DecBinary()
				_ = yym3283
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3282) {
				} else {
					z.DecFallback(yyv3282, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv3284 := &x.Items
				yym3285 := z.DecBinary()
				_ = yym3285
				if false {
				} else {
					h.decSliceResourceQuota((*[]ResourceQuota)(yyv3284), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3279)
		} // end switch yys3279
	} // end for yyj3279
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceQuotaList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3286 int
	var yyb3286 bool
	var yyhl3286 bool = l >= 0
	yyj3286++
	if yyhl3286 {
		yyb3286 = yyj3286 > l
	} else {
		yyb3286 = r.CheckBreak()
	}
	if yyb3286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3286++
	if yyhl3286 {
		yyb3286 = yyj3286 > l
	} else {
		yyb3286 = r.CheckBreak()
	}
	if yyb3286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3286++
	if yyhl3286 {
		yyb3286 = yyj3286 > l
	} else {
		yyb3286 = r.CheckBreak()
	}
	if yyb3286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv3289 := &x.ListMeta
		yym3290 := z.DecBinary()
		_ = yym3290
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3289) {
		} else {
			z.DecFallback(yyv3289, false)
		}
	}
	yyj3286++
	if yyhl3286 {
		yyb3286 = yyj3286 > l
	} else {
		yyb3286 = r.CheckBreak()
	}
	if yyb3286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv3291 := &x.Items
		yym3292 := z.DecBinary()
		_ = yym3292
		if false {
		} else {
			h.decSliceResourceQuota((*[]ResourceQuota)(yyv3291), d)
		}
	}
	for {
		yyj3286++
		if yyhl3286 {
			yyb3286 = yyj3286 > l
		} else {
			yyb3286 = r.CheckBreak()
		}
		if yyb3286 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3286-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Secret) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3293 := z.EncBinary()
		_ = yym3293
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3294 := !z.EncBinary()
			yy2arr3294 := z.EncBasicHandle().StructToArray
			var yyq3294 [5]bool
			_, _, _ = yysep3294, yyq3294, yy2arr3294
			const yyr3294 bool = false
			yyq3294[0] = x.Kind != ""
			yyq3294[1] = x.APIVersion != ""
			yyq3294[2] = true
			yyq3294[3] = len(x.Data) != 0
			yyq3294[4] = x.Type != ""
			var yynn3294 int
			if yyr3294 || yy2arr3294 {
				r.EncodeArrayStart(5)
			} else {
				yynn3294 = 0
				for _, b := range yyq3294 {
					if b {
						yynn3294++
					}
				}
				r.EncodeMapStart(yynn3294)
				yynn3294 = 0
			}
			if yyr3294 || yy2arr3294 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3294[0] {
					yym3296 := z.EncBinary()
					_ = yym3296
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3294[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3297 := z.EncBinary()
					_ = yym3297
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3294 || yy2arr3294 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3294[1] {
					yym3299 := z.EncBinary()
					_ = yym3299
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3294[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeSt