## Community Expectations

Kubernetes is a community project. Consequently, it is wholly dependent on
its community to provide a productive, friendly and collaborative environment.

The first and foremost goal of the Kubernetes community to develop orchestration
technology that radically simplifies the process of creating reliable
distributed systems. However a second, equally important goal is the creation
of a community that fosters easy, agile development of such orchestration
systems.

We therefore describe the expectations for
members of the Kubernetes community.  This document is intended to be a living one
that evolves as the community evolves via the same PR and code review process
that shapes the rest of the project.  It currently covers the expectations
of conduct that govern all members of the community as well as the expectations
around code review that govern all active contributors to Kubernetes.

### Code of Conduct

The most important expectation of the Kubernetes community is that all members
abide by the Kubernetes [community code of conduct](../../code-of-conduct.md).
Only by respecting each other can we develop a productive, collaborative
community.

### Code review

As a community we believe in the [value of code review for all contributions](collab.md).
Code review increases both the quality and readability of our codebase, which
in turn produces high quality software.

However, the code review process can also introduce latency for contributors
and additional work for reviewers that can frustrate both parties.

Consequently, as a community we expect that all active participants in the
community will also be active reviewers.

We ask that active contributors to the project participate in the code review process
in areas where that contributor has expertise. Active
contributors are considered to be anyone who meets any of the following criteria:
   * Sent more than two pull requests (PRs) in the previous one month, or more
   than 20 PRs in the previous year.
   * Filed more than three issues in the previous month, or more than 30 issues in
   the previous 12 months.
   * Commented on more than pull requests in the previous month, or
   more than 50 pull requests in the previous 12 months.
   * Marked any PR as LGTM in the previous month.
   * Have *collaborator* permissions in the Kubernetes github project.

In addition to these community expectations, any community member who wants to
be an active reviewer can also add their name to an *active reviewer* file
(location tbd) which will make them an active reviewer for as long as they
are included in the file.

#### Expectations of reviewers: Review comments

Because reviewers are often the first points of contact between new members of
the community and can significantly impact the first impression of the
Kubernetes community, reviewers are especially important in shaping the
Kubernetes community.  Reviewers are highly encouraged to review the
[code of conduct](../../code-of-conduct.md) and are strongly encouraged to go above
and beyond the code of conduct to promote a collaborative, respectful
Kubernetes community.

#### Expectations of reviewers: Review latency

Reviewers are expected to respond in a timely fashion to PRs that are assigned
to them.  Reviewers are expected to respond to an *active* PRs with reasonable
latency, and if reviewers fail to respond, those PRs may be assigned to other
reviewers.

*Active* PRs are considered those which have a proper CLA (`cla:yes`) label
and do not need rebase to be merged.  PRs that do not have a proper CLA, or
require a rebase are not considered active PRs.

## Thanks

Many thanks in advance to everyone who contributes their time and effort to
making Kubernetes both a successful system as well as a successful community.
The strength of our software shines in the strengths of each individual
community member.  Thanks!



<!-- BEGIN MUNGE: GENERATED_ANALYTICS -->
[![Analytics](https://kubernetes-site.appspot.com/UA-36037335-10/GitHub/docs/devel/community-expectations.md?pixel)]()
<!-- END MUNGE: GENERATED_ANALYTICS -->
