package v1

// This file contains methods that can be used by the go-restful package to generate Swagger
// documentation for the object types found in 'types.go' This file is automatically generated
// by hack/update-generated-swagger-descriptions.sh and should be run after a full build of OpenShift.
// ==== DO NOT EDIT THIS FILE MANUALLY ====

var map_ClusterNetwork = map[string]string{
	"":                 "ClusterNetwork describes a cluster network",
	"metadata":         "Standard object's metadata.",
	"network":          "Network is a CIDR string to specify the global overlay network's L3 space",
	"hostsubnetlength": "HostSubnetLength is the number of bits to allocate to each host's subnet e.g. 8 would mean a /24 network on the host",
	"serviceNetwork":   "ServiceNetwork is the CIDR string to specify the service network",
}

func (ClusterNetwork) SwaggerDoc() map[string]string {
	return map_ClusterNetwork
}

var map_ClusterNetworkList = map[string]string{
	"":         "ClusterNetworkList is a collection of ClusterNetworks",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of cluster networks",
}

func (ClusterNetworkList) SwaggerDoc() map[string]string {
	return map_ClusterNetworkList
}

var map_HostSubnet = map[string]string{
	"":         "HostSubnet encapsulates the inputs needed to define the container subnet network on a node",
	"metadata": "Standard object's metadata.",
	"host":     "Host is the name of the host that is registered at the master. May just be an IP address, resolvable hostname or a complete DNS. A lease will be sought after this name.",
	"hostIP":   "HostIP is the IP address to be used as vtep by other hosts in the overlay network",
	"subnet":   "Subnet is the actual subnet CIDR lease assigned to the host",
}

func (HostSubnet) SwaggerDoc() map[string]string {
	return map_HostSubnet
}

var map_HostSubnetList = map[string]string{
	"":         "HostSubnetList is a collection of HostSubnets",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of host subnets",
}

func (HostSubnetList) SwaggerDoc() map[string]string {
	return map_HostSubnetList
}

var map_NetNamespace = map[string]string{
	"":         "NetNamespace encapsulates the inputs needed to define a unique network namespace on the cluster",
	"metadata": "Standard object's metadata.",
	"netname":  "NetName is the name of the network namespace",
	"netid":    "NetID is the network identifier of the network namespace assigned to each overlay network packet",
}

func (NetNamespace) SwaggerDoc() map[string]string {
	return map_NetNamespace
}

var map_NetNamespaceList = map[string]string{
	"":         "NetNamespaceList is a collection of NetNamespaces",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of net namespaces",
}

func (NetNamespaceList) SwaggerDoc() map[string]string {
	return map_NetNamespaceList
}
