// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ec2 provides a client for Amazon Elastic Compute Cloud.
package ec2

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAcceptVpcPeeringConnection = "AcceptVpcPeeringConnection"

// AcceptVpcPeeringConnectionRequest generates a request for the AcceptVpcPeeringConnection operation.
func (c *EC2) AcceptVpcPeeringConnectionRequest(input *AcceptVpcPeeringConnectionInput) (req *request.Request, output *AcceptVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptVpcPeeringConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AcceptVpcPeeringConnectionOutput{}
	req.Data = output
	return
}

// Accept a VPC peering connection request. To accept a request, the VPC peering
// connection must be in the pending-acceptance state, and you must be the owner
// of the peer VPC. Use the DescribeVpcPeeringConnections request to view your
// outstanding VPC peering connection requests.
func (c *EC2) AcceptVpcPeeringConnection(input *AcceptVpcPeeringConnectionInput) (*AcceptVpcPeeringConnectionOutput, error) {
	req, out := c.AcceptVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opAllocateAddress = "AllocateAddress"

// AllocateAddressRequest generates a request for the AllocateAddress operation.
func (c *EC2) AllocateAddressRequest(input *AllocateAddressInput) (req *request.Request, output *AllocateAddressOutput) {
	op := &request.Operation{
		Name:       opAllocateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AllocateAddressOutput{}
	req.Data = output
	return
}

// Acquires an Elastic IP address.
//
// An Elastic IP address is for use either in the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) AllocateAddress(input *AllocateAddressInput) (*AllocateAddressOutput, error) {
	req, out := c.AllocateAddressRequest(input)
	err := req.Send()
	return out, err
}

const opAllocateHosts = "AllocateHosts"

// AllocateHostsRequest generates a request for the AllocateHosts operation.
func (c *EC2) AllocateHostsRequest(input *AllocateHostsInput) (req *request.Request, output *AllocateHostsOutput) {
	op := &request.Operation{
		Name:       opAllocateHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateHostsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AllocateHostsOutput{}
	req.Data = output
	return
}

// Allocates a Dedicated host to your account. At minimum you need to specify
// the instance size type, Availability Zone, and quantity of hosts you want
// to allocate.
func (c *EC2) AllocateHosts(input *AllocateHostsInput) (*AllocateHostsOutput, error) {
	req, out := c.AllocateHostsRequest(input)
	err := req.Send()
	return out, err
}

const opAssignPrivateIpAddresses = "AssignPrivateIpAddresses"

// AssignPrivateIpAddressesRequest generates a request for the AssignPrivateIpAddresses operation.
func (c *EC2) AssignPrivateIpAddressesRequest(input *AssignPrivateIpAddressesInput) (req *request.Request, output *AssignPrivateIpAddressesOutput) {
	op := &request.Operation{
		Name:       opAssignPrivateIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignPrivateIpAddressesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssignPrivateIpAddressesOutput{}
	req.Data = output
	return
}

// Assigns one or more secondary private IP addresses to the specified network
// interface. You can specify one or more specific secondary IP addresses, or
// you can specify the number of secondary IP addresses to be automatically
// assigned within the subnet's CIDR block range. The number of secondary IP
// addresses that you can assign to an instance varies by instance type. For
// information about instance types, see Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// Elastic IP addresses, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// AssignPrivateIpAddresses is available only in EC2-VPC.
func (c *EC2) AssignPrivateIpAddresses(input *AssignPrivateIpAddressesInput) (*AssignPrivateIpAddressesOutput, error) {
	req, out := c.AssignPrivateIpAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateAddress = "AssociateAddress"

// AssociateAddressRequest generates a request for the AssociateAddress operation.
func (c *EC2) AssociateAddressRequest(input *AssociateAddressInput) (req *request.Request, output *AssociateAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssociateAddressOutput{}
	req.Data = output
	return
}

// Associates an Elastic IP address with an instance or a network interface.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address
// is already associated with a different instance, it is disassociated from
// that instance and associated with the specified instance.
//
// [VPC in an EC2-Classic account] If you don't specify a private IP address,
// the Elastic IP address is associated with the primary IP address. If the
// Elastic IP address is already associated with a different instance or a network
// interface, you get an error unless you allow reassociation.
//
// This is an idempotent operation. If you perform the operation more than
// once, Amazon EC2 doesn't return an error.
func (c *EC2) AssociateAddress(input *AssociateAddressInput) (*AssociateAddressOutput, error) {
	req, out := c.AssociateAddressRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateDhcpOptions = "AssociateDhcpOptions"

// AssociateDhcpOptionsRequest generates a request for the AssociateDhcpOptions operation.
func (c *EC2) AssociateDhcpOptionsRequest(input *AssociateDhcpOptionsInput) (req *request.Request, output *AssociateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opAssociateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDhcpOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssociateDhcpOptionsOutput{}
	req.Data = output
	return
}

// Associates a set of DHCP options (that you've previously created) with the
// specified VPC, or associates no DHCP options with the VPC.
//
// After you associate the options with the VPC, any existing instances and
// all new instances that you launch in that VPC use the options. You don't
// need to restart or relaunch the instances. They automatically pick up the
// changes within a few hours, depending on how frequently the instance renews
// its DHCP lease. You can explicitly renew the lease using the operating system
// on the instance.
//
// For more information, see DHCP Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) AssociateDhcpOptions(input *AssociateDhcpOptionsInput) (*AssociateDhcpOptionsOutput, error) {
	req, out := c.AssociateDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateRouteTable = "AssociateRouteTable"

// AssociateRouteTableRequest generates a request for the AssociateRouteTable operation.
func (c *EC2) AssociateRouteTableRequest(input *AssociateRouteTableInput) (req *request.Request, output *AssociateRouteTableOutput) {
	op := &request.Operation{
		Name:       opAssociateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateRouteTableInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssociateRouteTableOutput{}
	req.Data = output
	return
}

// Associates a subnet with a route table. The subnet and route table must be
// in the same VPC. This association causes traffic originating from the subnet
// to be routed according to the routes in the route table. The action returns
// an association ID, which you need in order to disassociate the route table
// from the subnet later. A route table can be associated with multiple subnets.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) AssociateRouteTable(input *AssociateRouteTableInput) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opAttachClassicLinkVpc = "AttachClassicLinkVpc"

// AttachClassicLinkVpcRequest generates a request for the AttachClassicLinkVpc operation.
func (c *EC2) AttachClassicLinkVpcRequest(input *AttachClassicLinkVpcInput) (req *request.Request, output *AttachClassicLinkVpcOutput) {
	op := &request.Operation{
		Name:       opAttachClassicLinkVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachClassicLinkVpcInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachClassicLinkVpcOutput{}
	req.Data = output
	return
}

// Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or
// more of the VPC's security groups. You cannot link an EC2-Classic instance
// to more than one VPC at a time. You can only link an instance that's in the
// running state. An instance is automatically unlinked from a VPC when it's
// stopped - you can link it to the VPC again when you restart it.
//
// After you've linked an instance, you cannot change the VPC security groups
// that are associated with it. To change the security groups, you must first
// unlink the instance, and then link it again.
//
// Linking your instance to a VPC is sometimes referred to as attaching your
// instance.
func (c *EC2) AttachClassicLinkVpc(input *AttachClassicLinkVpcInput) (*AttachClassicLinkVpcOutput, error) {
	req, out := c.AttachClassicLinkVpcRequest(input)
	err := req.Send()
	return out, err
}

const opAttachInternetGateway = "AttachInternetGateway"

// AttachInternetGatewayRequest generates a request for the AttachInternetGateway operation.
func (c *EC2) AttachInternetGatewayRequest(input *AttachInternetGatewayInput) (req *request.Request, output *AttachInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInternetGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachInternetGatewayOutput{}
	req.Data = output
	return
}

// Attaches an Internet gateway to a VPC, enabling connectivity between the
// Internet and the VPC. For more information about your VPC and Internet gateway,
// see the Amazon Virtual Private Cloud User Guide (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/).
func (c *EC2) AttachInternetGateway(input *AttachInternetGatewayInput) (*AttachInternetGatewayOutput, error) {
	req, out := c.AttachInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opAttachNetworkInterface = "AttachNetworkInterface"

// AttachNetworkInterfaceRequest generates a request for the AttachNetworkInterface operation.
func (c *EC2) AttachNetworkInterfaceRequest(input *AttachNetworkInterfaceInput) (req *request.Request, output *AttachNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opAttachNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachNetworkInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachNetworkInterfaceOutput{}
	req.Data = output
	return
}

// Attaches a network interface to an instance.
func (c *EC2) AttachNetworkInterface(input *AttachNetworkInterfaceInput) (*AttachNetworkInterfaceOutput, error) {
	req, out := c.AttachNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opAttachVolume = "AttachVolume"

// AttachVolumeRequest generates a request for the AttachVolume operation.
func (c *EC2) AttachVolumeRequest(input *AttachVolumeInput) (req *request.Request, output *VolumeAttachment) {
	op := &request.Operation{
		Name:       opAttachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VolumeAttachment{}
	req.Data = output
	return
}

// Attaches an EBS volume to a running or stopped instance and exposes it to
// the instance with the specified device name.
//
// Encrypted EBS volumes may only be attached to instances that support Amazon
// EBS encryption. For more information, see Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For a list of supported device names, see Attaching an EBS Volume to an
// Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html).
// Any device names that aren't reserved for instance store volumes can be used
// for EBS volumes. For more information, see Amazon EC2 Instance Store (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// If a volume has an AWS Marketplace product code:
//
//  The volume can be attached only to a stopped instance. AWS Marketplace
// product codes are copied from the volume to the instance. You must be subscribed
// to the product. The instance type and operating system of the instance must
// support the product. For example, you can't detach a volume from a Windows
// instance and attach it to a Linux instance.  For an overview of the AWS Marketplace,
// see Introducing AWS Marketplace (https://aws.amazon.com/marketplace/help/200900000).
//
// For more information about EBS volumes, see Attaching Amazon EBS Volumes
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) AttachVolume(input *AttachVolumeInput) (*VolumeAttachment, error) {
	req, out := c.AttachVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opAttachVpnGateway = "AttachVpnGateway"

// AttachVpnGatewayRequest generates a request for the AttachVpnGateway operation.
func (c *EC2) AttachVpnGatewayRequest(input *AttachVpnGatewayInput) (req *request.Request, output *AttachVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVpnGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachVpnGatewayOutput{}
	req.Data = output
	return
}

// Attaches a virtual private gateway to a VPC. For more information, see Adding
// a Hardware Virtual Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) AttachVpnGateway(input *AttachVpnGatewayInput) (*AttachVpnGatewayOutput, error) {
	req, out := c.AttachVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeSecurityGroupEgress = "AuthorizeSecurityGroupEgress"

// AuthorizeSecurityGroupEgressRequest generates a request for the AuthorizeSecurityGroupEgress operation.
func (c *EC2) AuthorizeSecurityGroupEgressRequest(input *AuthorizeSecurityGroupEgressInput) (req *request.Request, output *AuthorizeSecurityGroupEgressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupEgressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AuthorizeSecurityGroupEgressOutput{}
	req.Data = output
	return
}

// [EC2-VPC only] Adds one or more egress rules to a security group for use
// with a VPC. Specifically, this action permits instances to send traffic to
// one or more destination CIDR IP address ranges, or to one or more destination
// security groups for the same VPC. This action doesn't apply to security groups
// for use in EC2-Classic. For more information, see Security Groups for Your
// VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
//  You can have up to 50 rules per security group (covering both ingress and
// egress rules).
//
//  Each rule consists of the protocol (for example, TCP), plus either a CIDR
// range or a source group. For the TCP and UDP protocols, you must also specify
// the destination port or port range. For the ICMP protocol, you must also
// specify the ICMP type and code. You can use -1 for the type or code to mean
// all types or all codes.
//
// Rule changes are propagated to affected instances as quickly as possible.
// However, a small delay might occur.
func (c *EC2) AuthorizeSecurityGroupEgress(input *AuthorizeSecurityGroupEgressInput) (*AuthorizeSecurityGroupEgressOutput, error) {
	req, out := c.AuthorizeSecurityGroupEgressRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeSecurityGroupIngress = "AuthorizeSecurityGroupIngress"

// AuthorizeSecurityGroupIngressRequest generates a request for the AuthorizeSecurityGroupIngress operation.
func (c *EC2) AuthorizeSecurityGroupIngressRequest(input *AuthorizeSecurityGroupIngressInput) (req *request.Request, output *AuthorizeSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AuthorizeSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// Adds one or more ingress rules to a security group.
//
//  EC2-Classic: You can have up to 100 rules per group.
//
// EC2-VPC: You can have up to 50 rules per group (covering both ingress and
// egress rules).
//
//  Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
//
// [EC2-Classic] This action gives one or more CIDR IP address ranges permission
// to access a security group in your account, or gives one or more security
// groups (called the source groups) permission to access a security group for
// your account. A source group can be for your own AWS account, or another.
//
// [EC2-VPC] This action gives one or more CIDR IP address ranges permission
// to access a security group in your VPC, or gives one or more other security
// groups (called the source groups) permission to access a security group for
// your VPC. The security groups must all be for the same VPC.
func (c *EC2) AuthorizeSecurityGroupIngress(input *AuthorizeSecurityGroupIngressInput) (*AuthorizeSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opBundleInstance = "BundleInstance"

// BundleInstanceRequest generates a request for the BundleInstance operation.
func (c *EC2) BundleInstanceRequest(input *BundleInstanceInput) (req *request.Request, output *BundleInstanceOutput) {
	op := &request.Operation{
		Name:       opBundleInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BundleInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BundleInstanceOutput{}
	req.Data = output
	return
}

// Bundles an Amazon instance store-backed Windows instance.
//
// During bundling, only the root device volume (C:\) is bundled. Data on other
// instance store volumes is not preserved.
//
//  This action is not applicable for Linux/Unix instances or Windows instances
// that are backed by Amazon EBS.
//
//  For more information, see Creating an Instance Store-Backed Windows AMI
// (http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/Creating_InstanceStoreBacked_WinAMI.html).
func (c *EC2) BundleInstance(input *BundleInstanceInput) (*BundleInstanceOutput, error) {
	req, out := c.BundleInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCancelBundleTask = "CancelBundleTask"

// CancelBundleTaskRequest generates a request for the CancelBundleTask operation.
func (c *EC2) CancelBundleTaskRequest(input *CancelBundleTaskInput) (req *request.Request, output *CancelBundleTaskOutput) {
	op := &request.Operation{
		Name:       opCancelBundleTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelBundleTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelBundleTaskOutput{}
	req.Data = output
	return
}

// Cancels a bundling operation for an instance store-backed Windows instance.
func (c *EC2) CancelBundleTask(input *CancelBundleTaskInput) (*CancelBundleTaskOutput, error) {
	req, out := c.CancelBundleTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelConversionTask = "CancelConversionTask"

// CancelConversionTaskRequest generates a request for the CancelConversionTask operation.
func (c *EC2) CancelConversionTaskRequest(input *CancelConversionTaskInput) (req *request.Request, output *CancelConversionTaskOutput) {
	op := &request.Operation{
		Name:       opCancelConversionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelConversionTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelConversionTaskOutput{}
	req.Data = output
	return
}

// Cancels an active conversion task. The task can be the import of an instance
// or volume. The action removes all artifacts of the conversion, including
// a partially uploaded volume or instance. If the conversion is complete or
// is in the process of transferring the final disk image, the command fails
// and returns an exception.
//
// For more information, see Using the Command Line Tools to Import Your Virtual
// Machine to Amazon EC2 (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UploadingYourInstancesandVolumes.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CancelConversionTask(input *CancelConversionTaskInput) (*CancelConversionTaskOutput, error) {
	req, out := c.CancelConversionTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelExportTask = "CancelExportTask"

// CancelExportTaskRequest generates a request for the CancelExportTask operation.
func (c *EC2) CancelExportTaskRequest(input *CancelExportTaskInput) (req *request.Request, output *CancelExportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelExportTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelExportTaskOutput{}
	req.Data = output
	return
}

// Cancels an active export task. The request removes all artifacts of the export,
// including any partially-created Amazon S3 objects. If the export task is
// complete or is in the process of transferring the final disk image, the command
// fails and returns an error.
func (c *EC2) CancelExportTask(input *CancelExportTaskInput) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelImportTask = "CancelImportTask"

// CancelImportTaskRequest generates a request for the CancelImportTask operation.
func (c *EC2) CancelImportTaskRequest(input *CancelImportTaskInput) (req *request.Request, output *CancelImportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelImportTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelImportTaskOutput{}
	req.Data = output
	return
}

// Cancels an in-process import virtual machine or import snapshot task.
func (c *EC2) CancelImportTask(input *CancelImportTaskInput) (*CancelImportTaskOutput, error) {
	req, out := c.CancelImportTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelReservedInstancesListing = "CancelReservedInstancesListing"

// CancelReservedInstancesListingRequest generates a request for the CancelReservedInstancesListing operation.
func (c *EC2) CancelReservedInstancesListingRequest(input *CancelReservedInstancesListingInput) (req *request.Request, output *CancelReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCancelReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelReservedInstancesListingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelReservedInstancesListingOutput{}
	req.Data = output
	return
}

// Cancels the specified Reserved instance listing in the Reserved Instance
// Marketplace.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CancelReservedInstancesListing(input *CancelReservedInstancesListingInput) (*CancelReservedInstancesListingOutput, error) {
	req, out := c.CancelReservedInstancesListingRequest(input)
	err := req.Send()
	return out, err
}

const opCancelSpotFleetRequests = "CancelSpotFleetRequests"

// CancelSpotFleetRequestsRequest generates a request for the CancelSpotFleetRequests operation.
func (c *EC2) CancelSpotFleetRequestsRequest(input *CancelSpotFleetRequestsInput) (req *request.Request, output *CancelSpotFleetRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotFleetRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotFleetRequestsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelSpotFleetRequestsOutput{}
	req.Data = output
	return
}

// Cancels the specified Spot fleet requests.
//
// After you cancel a Spot fleet request, the Spot fleet launches no new Spot
// instances. You must specify whether the Spot fleet should also terminate
// its Spot instances. If you terminate the instances, the Spot fleet request
// enters the cancelled_terminating state. Otherwise, the Spot fleet request
// enters the cancelled_running state and the instances continue to run until
// they are interrupted or you terminate them manually.
func (c *EC2) CancelSpotFleetRequests(input *CancelSpotFleetRequestsInput) (*CancelSpotFleetRequestsOutput, error) {
	req, out := c.CancelSpotFleetRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opCancelSpotInstanceRequests = "CancelSpotInstanceRequests"

// CancelSpotInstanceRequestsRequest generates a request for the CancelSpotInstanceRequests operation.
func (c *EC2) CancelSpotInstanceRequestsRequest(input *CancelSpotInstanceRequestsInput) (req *request.Request, output *CancelSpotInstanceRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotInstanceRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotInstanceRequestsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelSpotInstanceRequestsOutput{}
	req.Data = output
	return
}

// Cancels one or more Spot instance requests. Spot instances are instances
// that Amazon EC2 starts on your behalf when the bid price that you specify
// exceeds the current Spot price. Amazon EC2 periodically sets the Spot price
// based on available Spot instance capacity and current Spot instance requests.
// For more information, see Spot Instance Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//  Canceling a Spot instance request does not terminate running Spot instances
// associated with the request.
func (c *EC2) CancelSpotInstanceRequests(input *CancelSpotInstanceRequestsInput) (*CancelSpotInstanceRequestsOutput, error) {
	req, out := c.CancelSpotInstanceRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmProductInstance = "ConfirmProductInstance"

// ConfirmProductInstanceRequest generates a request for the ConfirmProductInstance operation.
func (c *EC2) ConfirmProductInstanceRequest(input *ConfirmProductInstanceInput) (req *request.Request, output *ConfirmProductInstanceOutput) {
	op := &request.Operation{
		Name:       opConfirmProductInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmProductInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfirmProductInstanceOutput{}
	req.Data = output
	return
}

// Determines whether a product code is associated with an instance. This action
// can only be used by the owner of the product code. It is useful when a product
// code owner needs to verify whether another user's instance is eligible for
// support.
func (c *EC2) ConfirmProductInstance(input *ConfirmProductInstanceInput) (*ConfirmProductInstanceOutput, error) {
	req, out := c.ConfirmProductInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCopyImage = "CopyImage"

// CopyImageRequest generates a request for the CopyImage operation.
func (c *EC2) CopyImageRequest(input *CopyImageInput) (req *request.Request, output *CopyImageOutput) {
	op := &request.Operation{
		Name:       opCopyImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyImageOutput{}
	req.Data = output
	return
}

// Initiates the copy of an AMI from the specified source region to the current
// region. You specify the destination region by using its endpoint when making
// the request.
//
// For more information, see Copying AMIs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CopyImage(input *CopyImageInput) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	err := req.Send()
	return out, err
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a request for the CopySnapshot operation.
func (c *EC2) CopySnapshotRequest(input *CopySnapshotInput) (req *request.Request, output *CopySnapshotOutput) {
	op := &request.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopySnapshotOutput{}
	req.Data = output
	return
}

// Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
// S3. You can copy the snapshot within the same region or from one region to
// another. You can use the snapshot to create EBS volumes or Amazon Machine
// Images (AMIs). The snapshot is copied to the regional endpoint that you send
// the HTTP request to.
//
// Copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
// snapshots remain unencrypted, unless the Encrypted flag is specified during
// the snapshot copy operation. By default, encrypted snapshot copies use the
// default AWS Key Management Service (AWS KMS) customer master key (CMK); however,
// you can specify a non-default CMK with the KmsKeyId parameter.
//
// For more information, see Copying an Amazon EBS Snapshot (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCustomerGateway = "CreateCustomerGateway"

// CreateCustomerGatewayRequest generates a request for the CreateCustomerGateway operation.
func (c *EC2) CreateCustomerGatewayRequest(input *CreateCustomerGatewayInput) (req *request.Request, output *CreateCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomerGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCustomerGatewayOutput{}
	req.Data = output
	return
}

// Provides information to AWS about your VPN customer gateway device. The customer
// gateway is the appliance at your end of the VPN connection. (The device on
// the AWS side of the VPN connection is the virtual private gateway.) You must
// provide the Internet-routable IP address of the customer gateway's external
// interface. The IP address must be static and may be behind a device performing
// network address translation (NAT).
//
// For devices that use Border Gateway Protocol (BGP), you can also provide
// the device's BGP Autonomous System Number (ASN). You can use an existing
// ASN assigned to your network. If you don't have an ASN already, you can use
// a private ASN (in the 64512 - 65534 range).
//
//  Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534, with
// the exception of 7224, which is reserved in the us-east-1 region, and 9059,
// which is reserved in the eu-west-1 region.
//
//  For more information about VPN customer gateways, see Adding a Hardware
// Virtual Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
//  You cannot create more than one customer gateway with the same VPN type,
// IP address, and BGP ASN parameter values. If you run an identical request
// more than one time, the first request creates the customer gateway, and subsequent
// requests return information about the existing customer gateway. The subsequent
// requests do not create new customer gateway resources.
func (c *EC2) CreateCustomerGateway(input *CreateCustomerGatewayInput) (*CreateCustomerGatewayOutput, error) {
	req, out := c.CreateCustomerGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDhcpOptions = "CreateDhcpOptions"

// CreateDhcpOptionsRequest generates a request for the CreateDhcpOptions operation.
func (c *EC2) CreateDhcpOptionsRequest(input *CreateDhcpOptionsInput) (req *request.Request, output *CreateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opCreateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDhcpOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDhcpOptionsOutput{}
	req.Data = output
	return
}

// Creates a set of DHCP options for your VPC. After creating the set, you must
// associate it with the VPC, causing all existing and new instances that you
// launch in the VPC to use this set of DHCP options. The following are the
// individual DHCP options you can specify. For more information about the options,
// see RFC 2132 (http://www.ietf.org/rfc/rfc2132.txt).
//
//  domain-name-servers - The IP addresses of up to four domain name servers,
// or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS.
// If specifying more than one domain name server, specify the IP addresses
// in a single parameter, separated by commas. domain-name - If you're using
// AmazonProvidedDNS in us-east-1, specify ec2.internal. If you're using AmazonProvidedDNS
// in another region, specify region.compute.internal (for example, ap-northeast-1.compute.internal).
// Otherwise, specify a domain name (for example, MyCompany.com). Important:
// Some Linux operating systems accept multiple domain names separated by spaces.
// However, Windows and other Linux operating systems treat the value as a single
// domain, which results in unexpected behavior. If your DHCP options set is
// associated with a VPC that has instances with multiple operating systems,
// specify only one domain name. ntp-servers - The IP addresses of up to four
// Network Time Protocol (NTP) servers. netbios-name-servers - The IP addresses
// of up to four NetBIOS name servers. netbios-node-type - The NetBIOS node
// type (1, 2, 4, or 8). We recommend that you specify 2 (broadcast and multicast
// are not currently supported). For more information about these node types,
// see RFC 2132 (http://www.ietf.org/rfc/rfc2132.txt).   Your VPC automatically
// starts out with a set of DHCP options that includes only a DNS server that
// we provide (AmazonProvidedDNS). If you create a set of options, and if your
// VPC has an Internet gateway, make sure to set the domain-name-servers option
// either to AmazonProvidedDNS or to a domain name server of your choice. For
// more information about DHCP options, see DHCP Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateDhcpOptions(input *CreateDhcpOptionsInput) (*CreateDhcpOptionsOutput, error) {
	req, out := c.CreateDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateFlowLogs = "CreateFlowLogs"

// CreateFlowLogsRequest generates a request for the CreateFlowLogs operation.
func (c *EC2) CreateFlowLogsRequest(input *CreateFlowLogsInput) (req *request.Request, output *CreateFlowLogsOutput) {
	op := &request.Operation{
		Name:       opCreateFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowLogsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateFlowLogsOutput{}
	req.Data = output
	return
}

// Creates one or more flow logs to capture IP traffic for a specific network
// interface, subnet, or VPC. Flow logs are delivered to a specified log group
// in Amazon CloudWatch Logs. If you specify a VPC or subnet in the request,
// a log stream is created in CloudWatch Logs for each network interface in
// the subnet or VPC. Log streams can include information about accepted and
// rejected traffic to a network interface. You can view the data in your log
// streams using Amazon CloudWatch Logs.
//
// In your request, you must also specify an IAM role that has permission to
// publish logs to CloudWatch Logs.
func (c *EC2) CreateFlowLogs(input *CreateFlowLogsInput) (*CreateFlowLogsOutput, error) {
	req, out := c.CreateFlowLogsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateImage = "CreateImage"

// CreateImageRequest generates a request for the CreateImage operation.
func (c *EC2) CreateImageRequest(input *CreateImageInput) (req *request.Request, output *CreateImageOutput) {
	op := &request.Operation{
		Name:       opCreateImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateImageOutput{}
	req.Data = output
	return
}

// Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
// is either running or stopped.
//
// If you customized your instance with instance store volumes or EBS volumes
// in addition to the root device volume, the new AMI contains block device
// mapping information for those volumes. When you launch an instance from this
// new AMI, the instance automatically launches with those additional volumes.
//
// For more information, see Creating Amazon EBS-Backed Linux AMIs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateImage(input *CreateImageInput) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInstanceExportTask = "CreateInstanceExportTask"

// CreateInstanceExportTaskRequest generates a request for the CreateInstanceExportTask operation.
func (c *EC2) CreateInstanceExportTaskRequest(input *CreateInstanceExportTaskInput) (req *request.Request, output *CreateInstanceExportTaskOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceExportTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateInstanceExportTaskOutput{}
	req.Data = output
	return
}

// Exports a running or stopped instance to an S3 bucket.
//
// For information about the supported operating systems, image formats, and
// known limitations for the types of instances you can export, see Exporting
// EC2 Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ExportingEC2Instances.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateInstanceExportTask(input *CreateInstanceExportTaskInput) (*CreateInstanceExportTaskOutput, error) {
	req, out := c.CreateInstanceExportTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInternetGateway = "CreateInternetGateway"

// CreateInternetGatewayRequest generates a request for the CreateInternetGateway operation.
func (c *EC2) CreateInternetGatewayRequest(input *CreateInternetGatewayInput) (req *request.Request, output *CreateInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInternetGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateInternetGatewayOutput{}
	req.Data = output
	return
}

// Creates an Internet gateway for use with a VPC. After creating the Internet
// gateway, you attach it to a VPC using AttachInternetGateway.
//
// For more information about your VPC and Internet gateway, see the Amazon
// Virtual Private Cloud User Guide (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/).
func (c *EC2) CreateInternetGateway(input *CreateInternetGatewayInput) (*CreateInternetGatewayOutput, error) {
	req, out := c.CreateInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a request for the CreateKeyPair operation.
func (c *EC2) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateKeyPairOutput{}
	req.Data = output
	return
}

// Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores
// the public key and displays the private key for you to save to a file. The
// private key is returned as an unencrypted PEM encoded PKCS#8 private key.
// If a key with the specified name already exists, Amazon EC2 returns an error.
//
// You can have up to five thousand key pairs per region.
//
// The key pair returned to you is available only in the region in which you
// create it. To create a key pair that is available in all regions, use ImportKeyPair.
//
// For more information about key pairs, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNatGateway = "CreateNatGateway"

// CreateNatGatewayRequest generates a request for the CreateNatGateway operation.
func (c *EC2) CreateNatGatewayRequest(input *CreateNatGatewayInput) (req *request.Request, output *CreateNatGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNatGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateNatGatewayOutput{}
	req.Data = output
	return
}

// Creates a NAT gateway in the specified subnet. A NAT gateway can be used
// to enable instances in a private subnet to connect to the Internet. This
// action creates a network interface in the specified subnet with a private
// IP address from the IP address range of the subnet. For more information,
// see NAT Gateways (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateNatGateway(input *CreateNatGatewayInput) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNetworkAcl = "CreateNetworkAcl"

// CreateNetworkAclRequest generates a request for the CreateNetworkAcl operation.
func (c *EC2) CreateNetworkAclRequest(input *CreateNetworkAclInput) (req *request.Request, output *CreateNetworkAclOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateNetworkAclOutput{}
	req.Data = output
	return
}

// Creates a network ACL in a VPC. Network ACLs provide an optional layer of
// security (in addition to security groups) for the instances in your VPC.
//
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateNetworkAcl(input *CreateNetworkAclInput) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNetworkAclEntry = "CreateNetworkAclEntry"

// CreateNetworkAclEntryRequest generates a request for the CreateNetworkAclEntry operation.
func (c *EC2) CreateNetworkAclEntryRequest(input *CreateNetworkAclEntryInput) (req *request.Request, output *CreateNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclEntryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateNetworkAclEntryOutput{}
	req.Data = output
	return
}

// Creates an entry (a rule) in a network ACL with the specified rule number.
// Each network ACL has a set of numbered ingress rules and a separate set of
// numbered egress rules. When determining whether a packet should be allowed
// in or out of a subnet associated with the ACL, we process the entries in
// the ACL according to the rule numbers, in ascending order. Each network ACL
// has a set of ingress rules and a separate set of egress rules.
//
// We recommend that you leave room between the rule numbers (for example,
// 100, 110, 120, ...), and not number them one right after the other (for example,
// 101, 102, 103, ...). This makes it easier to add a rule between existing
// ones without having to renumber the rules.
//
// After you add an entry, you can't modify it; you must either replace it,
// or create an entry and delete the old one.
//
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateNetworkAclEntry(input *CreateNetworkAclEntryInput) (*CreateNetworkAclEntryOutput, error) {
	req, out := c.CreateNetworkAclEntryRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNetworkInterface = "CreateNetworkInterface"

// CreateNetworkInterfaceRequest generates a request for the CreateNetworkInterface operation.
func (c *EC2) CreateNetworkInterfaceRequest(input *CreateNetworkInterfaceInput) (req *request.Request, output *CreateNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateNetworkInterfaceOutput{}
	req.Data = output
	return
}

// Creates a network interface in the specified subnet.
//
// For more information about network interfaces, see Elastic Network Interfaces
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the
// Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateNetworkInterface(input *CreateNetworkInterfaceInput) (*CreateNetworkInterfaceOutput, error) {
	req, out := c.CreateNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlacementGroup = "CreatePlacementGroup"

// CreatePlacementGroupRequest generates a request for the CreatePlacementGroup operation.
func (c *EC2) CreatePlacementGroupRequest(input *CreatePlacementGroupInput) (req *request.Request, output *CreatePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opCreatePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlacementGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePlacementGroupOutput{}
	req.Data = output
	return
}

// Creates a placement group that you launch cluster instances into. You must
// give the group a name that's unique within the scope of your account.
//
// For more information about placement groups and cluster instances, see Cluster
// Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreatePlacementGroup(input *CreatePlacementGroupInput) (*CreatePlacementGroupOutput, error) {
	req, out := c.CreatePlacementGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReservedInstancesListing = "CreateReservedInstancesListing"

// CreateReservedInstancesListingRequest generates a request for the CreateReservedInstancesListing operation.
func (c *EC2) CreateReservedInstancesListingRequest(input *CreateReservedInstancesListingInput) (req *request.Request, output *CreateReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCreateReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReservedInstancesListingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReservedInstancesListingOutput{}
	req.Data = output
	return
}

// Creates a listing for Amazon EC2 Reserved instances to be sold in the Reserved
// Instance Marketplace. You can submit one Reserved instance listing at a time.
// To get a list of your Reserved instances, you can use the DescribeReservedInstances
// operation.
//
// The Reserved Instance Marketplace matches sellers who want to resell Reserved
// instance capacity that they no longer need with buyers who want to purchase
// additional capacity. Reserved instances bought and sold through the Reserved
// Instance Marketplace work like any other Reserved instances.
//
// To sell your Reserved instances, you must first register as a seller in
// the Reserved Instance Marketplace. After completing the registration process,
// you can create a Reserved Instance Marketplace listing of some or all of
// your Reserved instances, and specify the upfront price to receive for them.
// Your Reserved instance listings then become available for purchase. To view
// the details of your Reserved instance listing, you can use the DescribeReservedInstancesListings
// operation.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateReservedInstancesListing(input *CreateReservedInstancesListingInput) (*CreateReservedInstancesListingOutput, error) {
	req, out := c.CreateReservedInstancesListingRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a request for the CreateRoute operation.
func (c *EC2) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRouteOutput{}
	req.Data = output
	return
}

// Creates a route in a route table within a VPC.
//
// You must specify one of the following targets: Internet gateway or virtual
// private gateway, NAT instance, NAT gateway, VPC peering connection, or network
// interface.
//
// When determining how to route traffic, we use the route with the most specific
// match. For example, let's say the traffic is destined for 192.0.2.3, and
// the route table includes the following two routes:
//
//   192.0.2.0/24 (goes to some target A)
//
//   192.0.2.0/28 (goes to some target B)
//
//   Both routes apply to the traffic destined for 192.0.2.3. However, the
// second route in the list covers a smaller number of IP addresses and is therefore
// more specific, so we use that route to determine where to target the traffic.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRouteTable = "CreateRouteTable"

// CreateRouteTableRequest generates a request for the CreateRouteTable operation.
func (c *EC2) CreateRouteTableRequest(input *CreateRouteTableInput) (req *request.Request, output *CreateRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteTableInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRouteTableOutput{}
	req.Data = output
	return
}

// Creates a route table for the specified VPC. After you create a route table,
// you can add routes and associate the table with a subnet.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateRouteTable(input *CreateRouteTableInput) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSecurityGroup = "CreateSecurityGroup"

// CreateSecurityGroupRequest generates a request for the CreateSecurityGroup operation.
func (c *EC2) CreateSecurityGroupRequest(input *CreateSecurityGroupInput) (req *request.Request, output *CreateSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSecurityGroupOutput{}
	req.Data = output
	return
}

// Creates a security group.
//
// A security group is for use with instances either in the EC2-Classic platform
// or in a specific VPC. For more information, see Amazon EC2 Security Groups
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security Groups for Your
// VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
//  EC2-Classic: You can have up to 500 security groups.
//
// EC2-VPC: You can create up to 100 security groups per VPC.
//
//  When you create a security group, you specify a friendly name of your choice.
// You can have a security group for use in EC2-Classic with the same name as
// a security group for use in a VPC. However, you can't have two security groups
// for use in EC2-Classic with the same name or two security groups for use
// in a VPC with the same name.
//
// You have a default security group for use in EC2-Classic and a default security
// group for use in your VPC. If you don't specify a security group when you
// launch an instance, the instance is launched into the appropriate default
// security group. A default security group includes a default rule that grants
// instances unrestricted network access to each other.
//
// You can add or remove rules from your security groups using AuthorizeSecurityGroupIngress,
// AuthorizeSecurityGroupEgress, RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
func (c *EC2) CreateSecurityGroup(input *CreateSecurityGroupInput) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a request for the CreateSnapshot operation.
func (c *EC2) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *Snapshot) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Snapshot{}
	req.Data = output
	return
}

// Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use
// snapshots for backups, to make copies of EBS volumes, and to save data before
// shutting down an instance.
//
// When a snapshot is created, any AWS Marketplace product codes that are associated
// with the source volume are propagated to the snapshot.
//
// You can take a snapshot of an attached volume that is in use. However, snapshots
// only capture data that has been written to your EBS volume at the time the
// snapshot command is issued; this may exclude any data that has been cached
// by any applications or the operating system. If you can pause any file systems
// on the volume long enough to take a snapshot, your snapshot should be complete.
// However, if you cannot pause all file writes to the volume, you should unmount
// the volume from within the instance, issue the snapshot command, and then
// remount the volume to ensure a consistent and complete snapshot. You may
// remount and use your volume while the snapshot status is pending.
//
// To create a snapshot for EBS volumes that serve as root devices, you should
// stop the instance before taking the snapshot.
//
// Snapshots that are taken from encrypted volumes are automatically encrypted.
// Volumes that are created from encrypted snapshots are also automatically
// encrypted. Your encrypted volumes and any associated snapshots always remain
// protected.
//
// For more information, see Amazon Elastic Block Store (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html)
// and Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateSnapshot(input *CreateSnapshotInput) (*Snapshot, error) {
	req, out := c.CreateSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSpotDatafeedSubscription = "CreateSpotDatafeedSubscription"

// CreateSpotDatafeedSubscriptionRequest generates a request for the CreateSpotDatafeedSubscription operation.
func (c *EC2) CreateSpotDatafeedSubscriptionRequest(input *CreateSpotDatafeedSubscriptionInput) (req *request.Request, output *CreateSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSpotDatafeedSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSpotDatafeedSubscriptionOutput{}
	req.Data = output
	return
}

// Creates a data feed for Spot instances, enabling you to view Spot instance
// usage logs. You can create one data feed per AWS account. For more information,
// see Spot Instance Data Feed (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateSpotDatafeedSubscription(input *CreateSpotDatafeedSubscriptionInput) (*CreateSpotDatafeedSubscriptionOutput, error) {
	req, out := c.CreateSpotDatafeedSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSubnet = "CreateSubnet"

// CreateSubnetRequest generates a request for the CreateSubnet operation.
func (c *EC2) CreateSubnetRequest(input *CreateSubnetInput) (req *request.Request, output *CreateSubnetOutput) {
	op := &request.Operation{
		Name:       opCreateSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSubnetOutput{}
	req.Data = output
	return
}

// Creates a subnet in an existing VPC.
//
// When you create each subnet, you provide the VPC ID and the CIDR block you
// want for the subnet. After you create a subnet, you can't change its CIDR
// block. The subnet's CIDR block can be the same as the VPC's CIDR block (assuming
// you want only a single subnet in the VPC), or a subset of the VPC's CIDR
// block. If you create more than one subnet in a VPC, the subnets' CIDR blocks
// must not overlap. The smallest subnet (and VPC) you can create uses a /28
// netmask (16 IP addresses), and the largest uses a /16 netmask (65,536 IP
// addresses).
//
//  AWS reserves both the first four and the last IP address in each subnet's
// CIDR block. They're not available for use.
//
//  If you add more than one subnet to a VPC, they're set up in a star topology
// with a logical router in the middle.
//
// If you launch an instance in a VPC using an Amazon EBS-backed AMI, the IP
// address doesn't change if you stop and restart the instance (unlike a similar
// instance launched outside a VPC, which gets a new IP address when restarted).
// It's therefore possible to have a subnet with no running instances (they're
// all stopped), but no remaining IP addresses available.
//
// For more information about subnets, see Your VPC and Subnets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateSubnet(input *CreateSubnetInput) (*CreateSubnetOutput, error) {
	req, out := c.CreateSubnetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a request for the CreateTags operation.
func (c *EC2) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTagsOutput{}
	req.Data = output
	return
}

// Adds or overwrites one or more tags for the specified Amazon EC2 resource
// or resources. Each resource can have a maximum of 10 tags. Each tag consists
// of a key and optional value. Tag keys must be unique per resource.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// creating IAM policies that control users' access to resources based on tags,
// see Supported Resource-Level Permissions for Amazon EC2 API Actions (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVolume = "CreateVolume"

// CreateVolumeRequest generates a request for the CreateVolume operation.
func (c *EC2) CreateVolumeRequest(input *CreateVolumeInput) (req *request.Request, output *Volume) {
	op := &request.Operation{
		Name:       opCreateVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Volume{}
	req.Data = output
	return
}

// Creates an EBS volume that can be attached to an instance in the same Availability
// Zone. The volume is created in the regional endpoint that you send the HTTP
// request to. For more information see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
//
// You can create a new empty volume or restore a volume from an EBS snapshot.
// Any AWS Marketplace product codes from the snapshot are propagated to the
// volume.
//
// You can create encrypted volumes with the Encrypted parameter. Encrypted
// volumes may only be attached to instances that support Amazon EBS encryption.
// Volumes that are created from encrypted snapshots are also automatically
// encrypted. For more information, see Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information, see Creating or Restoring an Amazon EBS Volume (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) CreateVolume(input *CreateVolumeInput) (*Volume, error) {
	req, out := c.CreateVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpc = "CreateVpc"

// CreateVpcRequest generates a request for the CreateVpc operation.
func (c *EC2) CreateVpcRequest(input *CreateVpcInput) (req *request.Request, output *CreateVpcOutput) {
	op := &request.Operation{
		Name:       opCreateVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVpcOutput{}
	req.Data = output
	return
}

// Creates a VPC with the specified CIDR block.
//
// The smallest VPC you can create uses a /28 netmask (16 IP addresses), and
// the largest uses a /16 netmask (65,536 IP addresses). To help you decide
// how big to make your VPC, see Your VPC and Subnets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// By default, each instance you launch in the VPC has the default DHCP options,
// which includes only a default DNS server that we provide (AmazonProvidedDNS).
// For more information about DHCP options, see DHCP Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateVpc(input *CreateVpcInput) (*CreateVpcOutput, error) {
	req, out := c.CreateVpcRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpcEndpoint = "CreateVpcEndpoint"

// CreateVpcEndpointRequest generates a request for the CreateVpcEndpoint operation.
func (c *EC2) CreateVpcEndpointRequest(input *CreateVpcEndpointInput) (req *request.Request, output *CreateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVpcEndpointOutput{}
	req.Data = output
	return
}

// Creates a VPC endpoint for a specified AWS service. An endpoint enables you
// to create a private connection between your VPC and another AWS service in
// your account. You can specify an endpoint policy to attach to the endpoint
// that will control access to the service from your VPC. You can also specify
// the VPC route tables that use the endpoint.
//
// Currently, only endpoints to Amazon S3 are supported.
func (c *EC2) CreateVpcEndpoint(input *CreateVpcEndpointInput) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpcPeeringConnection = "CreateVpcPeeringConnection"

// CreateVpcPeeringConnectionRequest generates a request for the CreateVpcPeeringConnection operation.
func (c *EC2) CreateVpcPeeringConnectionRequest(input *CreateVpcPeeringConnectionInput) (req *request.Request, output *CreateVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVpcPeeringConnectionOutput{}
	req.Data = output
	return
}

// Requests a VPC peering connection between two VPCs: a requester VPC that
// you own and a peer VPC with which to create the connection. The peer VPC
// can belong to another AWS account. The requester VPC and peer VPC cannot
// have overlapping CIDR blocks.
//
// The owner of the peer VPC must accept the peering request to activate the
// peering connection. The VPC peering connection request expires after 7 days,
// after which it cannot be accepted or rejected.
//
// A CreateVpcPeeringConnection request between VPCs with overlapping CIDR
// blocks results in the VPC peering connection having a status of failed.
func (c *EC2) CreateVpcPeeringConnection(input *CreateVpcPeeringConnectionInput) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpnConnection = "CreateVpnConnection"

// CreateVpnConnectionRequest generates a request for the CreateVpnConnection operation.
func (c *EC2) CreateVpnConnectionRequest(input *CreateVpnConnectionInput) (req *request.Request, output *CreateVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVpnConnectionOutput{}
	req.Data = output
	return
}

// Creates a VPN connection between an existing virtual private gateway and
// a VPN customer gateway. The only supported connection type is ipsec.1.
//
// The response includes information that you need to give to your network
// administrator to configure your customer gateway.
//
//  We strongly recommend that you use HTTPS when calling this operation because
// the response contains sensitive cryptographic information for configuring
// your customer gateway.
//
//  If you decide to shut down your VPN connection for any reason and later
// create a new VPN connection, you must reconfigure your customer gateway with
// the new information returned from this call.
//
// For more information about VPN connections, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateVpnConnection(input *CreateVpnConnectionInput) (*CreateVpnConnectionOutput, error) {
	req, out := c.CreateVpnConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpnConnectionRoute = "CreateVpnConnectionRoute"

// CreateVpnConnectionRouteRequest generates a request for the CreateVpnConnectionRoute operation.
func (c *EC2) CreateVpnConnectionRouteRequest(input *CreateVpnConnectionRouteInput) (req *request.Request, output *CreateVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionRouteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVpnConnectionRouteOutput{}
	req.Data = output
	return
}

// Creates a static route associated with a VPN connection between an existing
// virtual private gateway and a VPN customer gateway. The static route allows
// traffic to be routed from the virtual private gateway to the VPN customer
// gateway.
//
// For more information about VPN connections, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateVpnConnectionRoute(input *CreateVpnConnectionRouteInput) (*CreateVpnConnectionRouteOutput, error) {
	req, out := c.CreateVpnConnectionRouteRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpnGateway = "CreateVpnGateway"

// CreateVpnGatewayRequest generates a request for the CreateVpnGateway operation.
func (c *EC2) CreateVpnGatewayRequest(input *CreateVpnGatewayInput) (req *request.Request, output *CreateVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVpnGatewayOutput{}
	req.Data = output
	return
}

// Creates a virtual private gateway. A virtual private gateway is the endpoint
// on the VPC side of your VPN connection. You can create a virtual private
// gateway before creating the VPC itself.
//
// For more information about virtual private gateways, see Adding a Hardware
// Virtual Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) CreateVpnGateway(input *CreateVpnGatewayInput) (*CreateVpnGatewayOutput, error) {
	req, out := c.CreateVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCustomerGateway = "DeleteCustomerGateway"

// DeleteCustomerGatewayRequest generates a request for the DeleteCustomerGateway operation.
func (c *EC2) DeleteCustomerGatewayRequest(input *DeleteCustomerGatewayInput) (req *request.Request, output *DeleteCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomerGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteCustomerGatewayOutput{}
	req.Data = output
	return
}

// Deletes the specified customer gateway. You must delete the VPN connection
// before you can delete the customer gateway.
func (c *EC2) DeleteCustomerGateway(input *DeleteCustomerGatewayInput) (*DeleteCustomerGatewayOutput, error) {
	req, out := c.DeleteCustomerGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDhcpOptions = "DeleteDhcpOptions"

// DeleteDhcpOptionsRequest generates a request for the DeleteDhcpOptions operation.
func (c *EC2) DeleteDhcpOptionsRequest(input *DeleteDhcpOptionsInput) (req *request.Request, output *DeleteDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDeleteDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDhcpOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDhcpOptionsOutput{}
	req.Data = output
	return
}

// Deletes the specified set of DHCP options. You must disassociate the set
// of DHCP options before you can delete it. You can disassociate the set of
// DHCP options by associating either a new set of options or the default set
// of options with the VPC.
func (c *EC2) DeleteDhcpOptions(input *DeleteDhcpOptionsInput) (*DeleteDhcpOptionsOutput, error) {
	req, out := c.DeleteDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteFlowLogs = "DeleteFlowLogs"

// DeleteFlowLogsRequest generates a request for the DeleteFlowLogs operation.
func (c *EC2) DeleteFlowLogsRequest(input *DeleteFlowLogsInput) (req *request.Request, output *DeleteFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowLogsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteFlowLogsOutput{}
	req.Data = output
	return
}

// Deletes one or more flow logs.
func (c *EC2) DeleteFlowLogs(input *DeleteFlowLogsInput) (*DeleteFlowLogsOutput, error) {
	req, out := c.DeleteFlowLogsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteInternetGateway = "DeleteInternetGateway"

// DeleteInternetGatewayRequest generates a request for the DeleteInternetGateway operation.
func (c *EC2) DeleteInternetGatewayRequest(input *DeleteInternetGatewayInput) (req *request.Request, output *DeleteInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInternetGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteInternetGatewayOutput{}
	req.Data = output
	return
}

// Deletes the specified Internet gateway. You must detach the Internet gateway
// from the VPC before you can delete it.
func (c *EC2) DeleteInternetGateway(input *DeleteInternetGatewayInput) (*DeleteInternetGatewayOutput, error) {
	req, out := c.DeleteInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest generates a request for the DeleteKeyPair operation.
func (c *EC2) DeleteKeyPairRequest(input *DeleteKeyPairInput) (req *request.Request, output *DeleteKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteKeyPairOutput{}
	req.Data = output
	return
}

// Deletes the specified key pair, by removing the public key from Amazon EC2.
func (c *EC2) DeleteKeyPair(input *DeleteKeyPairInput) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNatGateway = "DeleteNatGateway"

// DeleteNatGatewayRequest generates a request for the DeleteNatGateway operation.
func (c *EC2) DeleteNatGatewayRequest(input *DeleteNatGatewayInput) (req *request.Request, output *DeleteNatGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNatGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteNatGatewayOutput{}
	req.Data = output
	return
}

// Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its
// Elastic IP address, but does not release the address from your account. Deleting
// a NAT gateway does not delete any NAT gateway routes in your route tables.
func (c *EC2) DeleteNatGateway(input *DeleteNatGatewayInput) (*DeleteNatGatewayOutput, error) {
	req, out := c.DeleteNatGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNetworkAcl = "DeleteNetworkAcl"

// DeleteNetworkAclRequest generates a request for the DeleteNetworkAcl operation.
func (c *EC2) DeleteNetworkAclRequest(input *DeleteNetworkAclInput) (req *request.Request, output *DeleteNetworkAclOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteNetworkAclOutput{}
	req.Data = output
	return
}

// Deletes the specified network ACL. You can't delete the ACL if it's associated
// with any subnets. You can't delete the default network ACL.
func (c *EC2) DeleteNetworkAcl(input *DeleteNetworkAclInput) (*DeleteNetworkAclOutput, error) {
	req, out := c.DeleteNetworkAclRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNetworkAclEntry = "DeleteNetworkAclEntry"

// DeleteNetworkAclEntryRequest generates a request for the DeleteNetworkAclEntry operation.
func (c *EC2) DeleteNetworkAclEntryRequest(input *DeleteNetworkAclEntryInput) (req *request.Request, output *DeleteNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclEntryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteNetworkAclEntryOutput{}
	req.Data = output
	return
}

// Deletes the specified ingress or egress entry (rule) from the specified network
// ACL.
func (c *EC2) DeleteNetworkAclEntry(input *DeleteNetworkAclEntryInput) (*DeleteNetworkAclEntryOutput, error) {
	req, out := c.DeleteNetworkAclEntryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNetworkInterface = "DeleteNetworkInterface"

// DeleteNetworkInterfaceRequest generates a request for the DeleteNetworkInterface operation.
func (c *EC2) DeleteNetworkInterfaceRequest(input *DeleteNetworkInterfaceInput) (req *request.Request, output *DeleteNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteNetworkInterfaceOutput{}
	req.Data = output
	return
}

// Deletes the specified network interface. You must detach the network interface
// before you can delete it.
func (c *EC2) DeleteNetworkInterface(input *DeleteNetworkInterfaceInput) (*DeleteNetworkInterfaceOutput, error) {
	req, out := c.DeleteNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePlacementGroup = "DeletePlacementGroup"

// DeletePlacementGroupRequest generates a request for the DeletePlacementGroup operation.
func (c *EC2) DeletePlacementGroupRequest(input *DeletePlacementGroupInput) (req *request.Request, output *DeletePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opDeletePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlacementGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeletePlacementGroupOutput{}
	req.Data = output
	return
}

// Deletes the specified placement group. You must terminate all instances in
// the placement group before you can delete the placement group. For more information
// about placement groups and cluster instances, see Cluster Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DeletePlacementGroup(input *DeletePlacementGroupInput) (*DeletePlacementGroupOutput, error) {
	req, out := c.DeletePlacementGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a request for the DeleteRoute operation.
func (c *EC2) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRouteOutput{}
	req.Data = output
	return
}

// Deletes the specified route from the specified route table.
func (c *EC2) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRouteTable = "DeleteRouteTable"

// DeleteRouteTableRequest generates a request for the DeleteRouteTable operation.
func (c *EC2) DeleteRouteTableRequest(input *DeleteRouteTableInput) (req *request.Request, output *DeleteRouteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteTableInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRouteTableOutput{}
	req.Data = output
	return
}

// Deletes the specified route table. You must disassociate the route table
// from any subnets before you can delete it. You can't delete the main route
// table.
func (c *EC2) DeleteRouteTable(input *DeleteRouteTableInput) (*DeleteRouteTableOutput, error) {
	req, out := c.DeleteRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSecurityGroup = "DeleteSecurityGroup"

// DeleteSecurityGroupRequest generates a request for the DeleteSecurityGroup operation.
func (c *EC2) DeleteSecurityGroupRequest(input *DeleteSecurityGroupInput) (req *request.Request, output *DeleteSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSecurityGroupOutput{}
	req.Data = output
	return
}

// Deletes a security group.
//
// If you attempt to delete a security group that is associated with an instance,
// or is referenced by another security group, the operation fails with InvalidGroup.InUse
// in EC2-Classic or DependencyViolation in EC2-VPC.
func (c *EC2) DeleteSecurityGroup(input *DeleteSecurityGroupInput) (*DeleteSecurityGroupOutput, error) {
	req, out := c.DeleteSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a request for the DeleteSnapshot operation.
func (c *EC2) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSnapshotOutput{}
	req.Data = output
	return
}

// Deletes the specified snapshot.
//
// When you make periodic snapshots of a volume, the snapshots are incremental,
// and only the blocks on the device that have changed since your last snapshot
// are saved in the new snapshot. When you delete a snapshot, only the data
// not needed for any other snapshot is removed. So regardless of which prior
// snapshots have been deleted, all active snapshots will have access to all
// the information needed to restore the volume.
//
// You cannot delete a snapshot of the root device of an EBS volume used by
// a registered AMI. You must first de-register the AMI before you can delete
// the snapshot.
//
// For more information, see Deleting an Amazon EBS Snapshot (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSpotDatafeedSubscription = "DeleteSpotDatafeedSubscription"

// DeleteSpotDatafeedSubscriptionRequest generates a request for the DeleteSpotDatafeedSubscription operation.
func (c *EC2) DeleteSpotDatafeedSubscriptionRequest(input *DeleteSpotDatafeedSubscriptionInput) (req *request.Request, output *DeleteSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSpotDatafeedSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSpotDatafeedSubscriptionOutput{}
	req.Data = output
	return
}

// Deletes the data feed for Spot instances.
func (c *EC2) DeleteSpotDatafeedSubscription(input *DeleteSpotDatafeedSubscriptionInput) (*DeleteSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DeleteSpotDatafeedSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSubnet = "DeleteSubnet"

// DeleteSubnetRequest generates a request for the DeleteSubnet operation.
func (c *EC2) DeleteSubnetRequest(input *DeleteSubnetInput) (req *request.Request, output *DeleteSubnetOutput) {
	op := &request.Operation{
		Name:       opDeleteSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSubnetOutput{}
	req.Data = output
	return
}

// Deletes the specified subnet. You must terminate all running instances in
// the subnet before you can delete the subnet.
func (c *EC2) DeleteSubnet(input *DeleteSubnetInput) (*DeleteSubnetOutput, error) {
	req, out := c.DeleteSubnetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a request for the DeleteTags operation.
func (c *EC2) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTagsOutput{}
	req.Data = output
	return
}

// Deletes the specified set of tags from the specified set of resources. This
// call is designed to follow a DescribeTags request.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a request for the DeleteVolume operation.
func (c *EC2) DeleteVolumeRequest(input *DeleteVolumeInput) (req *request.Request, output *DeleteVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVolumeOutput{}
	req.Data = output
	return
}

// Deletes the specified EBS volume. The volume must be in the available state
// (not attached to an instance).
//
//  The volume may remain in the deleting state for several minutes.
//
//  For more information, see Deleting an Amazon EBS Volume (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpc = "DeleteVpc"

// DeleteVpcRequest generates a request for the DeleteVpc operation.
func (c *EC2) DeleteVpcRequest(input *DeleteVpcInput) (req *request.Request, output *DeleteVpcOutput) {
	op := &request.Operation{
		Name:       opDeleteVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVpcOutput{}
	req.Data = output
	return
}

// Deletes the specified VPC. You must detach or delete all gateways and resources
// that are associated with the VPC before you can delete it. For example, you
// must terminate all instances running in the VPC, delete all security groups
// associated with the VPC (except the default one), delete all route tables
// associated with the VPC (except the default one), and so on.
func (c *EC2) DeleteVpc(input *DeleteVpcInput) (*DeleteVpcOutput, error) {
	req, out := c.DeleteVpcRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpcEndpoints = "DeleteVpcEndpoints"

// DeleteVpcEndpointsRequest generates a request for the DeleteVpcEndpoints operation.
func (c *EC2) DeleteVpcEndpointsRequest(input *DeleteVpcEndpointsInput) (req *request.Request, output *DeleteVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVpcEndpointsOutput{}
	req.Data = output
	return
}

// Deletes one or more specified VPC endpoints. Deleting the endpoint also deletes
// the endpoint routes in the route tables that were associated with the endpoint.
func (c *EC2) DeleteVpcEndpoints(input *DeleteVpcEndpointsInput) (*DeleteVpcEndpointsOutput, error) {
	req, out := c.DeleteVpcEndpointsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest generates a request for the DeleteVpcPeeringConnection operation.
func (c *EC2) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) (req *request.Request, output *DeleteVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVpcPeeringConnectionOutput{}
	req.Data = output
	return
}

// Deletes a VPC peering connection. Either the owner of the requester VPC or
// the owner of the peer VPC can delete the VPC peering connection if it's in
// the active state. The owner of the requester VPC can delete a VPC peering
// connection in the pending-acceptance state.
func (c *EC2) DeleteVpcPeeringConnection(input *DeleteVpcPeeringConnectionInput) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpnConnection = "DeleteVpnConnection"

// DeleteVpnConnectionRequest generates a request for the DeleteVpnConnection operation.
func (c *EC2) DeleteVpnConnectionRequest(input *DeleteVpnConnectionInput) (req *request.Request, output *DeleteVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVpnConnectionOutput{}
	req.Data = output
	return
}

// Deletes the specified VPN connection.
//
// If you're deleting the VPC and its associated components, we recommend that
// you detach the virtual private gateway from the VPC and delete the VPC before
// deleting the VPN connection. If you believe that the tunnel credentials for
// your VPN connection have been compromised, you can delete the VPN connection
// and create a new one that has new keys, without needing to delete the VPC
// or virtual private gateway. If you create a new VPN connection, you must
// reconfigure the customer gateway using the new configuration information
// returned with the new VPN connection ID.
func (c *EC2) DeleteVpnConnection(input *DeleteVpnConnectionInput) (*DeleteVpnConnectionOutput, error) {
	req, out := c.DeleteVpnConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpnConnectionRoute = "DeleteVpnConnectionRoute"

// DeleteVpnConnectionRouteRequest generates a request for the DeleteVpnConnectionRoute operation.
func (c *EC2) DeleteVpnConnectionRouteRequest(input *DeleteVpnConnectionRouteInput) (req *request.Request, output *DeleteVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionRouteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVpnConnectionRouteOutput{}
	req.Data = output
	return
}

// Deletes the specified static route associated with a VPN connection between
// an existing virtual private gateway and a VPN customer gateway. The static
// route allows traffic to be routed from the virtual private gateway to the
// VPN customer gateway.
func (c *EC2) DeleteVpnConnectionRoute(input *DeleteVpnConnectionRouteInput) (*DeleteVpnConnectionRouteOutput, error) {
	req, out := c.DeleteVpnConnectionRouteRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpnGateway = "DeleteVpnGateway"

// DeleteVpnGatewayRequest generates a request for the DeleteVpnGateway operation.
func (c *EC2) DeleteVpnGatewayRequest(input *DeleteVpnGatewayInput) (req *request.Request, output *DeleteVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVpnGatewayOutput{}
	req.Data = output
	return
}

// Deletes the specified virtual private gateway. We recommend that before you
// delete a virtual private gateway, you detach it from the VPC and delete the
// VPN connection. Note that you don't need to delete the virtual private gateway
// if you plan to delete and recreate the VPN connection between your VPC and
// your network.
func (c *EC2) DeleteVpnGateway(input *DeleteVpnGatewayInput) (*DeleteVpnGatewayOutput, error) {
	req, out := c.DeleteVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterImage = "DeregisterImage"

// DeregisterImageRequest generates a request for the DeregisterImage operation.
func (c *EC2) DeregisterImageRequest(input *DeregisterImageInput) (req *request.Request, output *DeregisterImageOutput) {
	op := &request.Operation{
		Name:       opDeregisterImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterImageOutput{}
	req.Data = output
	return
}

// Deregisters the specified AMI. After you deregister an AMI, it can't be used
// to launch new instances.
//
// This command does not delete the AMI.
func (c *EC2) DeregisterImage(input *DeregisterImageInput) (*DeregisterImageOutput, error) {
	req, out := c.DeregisterImageRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a request for the DescribeAccountAttributes operation.
func (c *EC2) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAccountAttributesOutput{}
	req.Data = output
	return
}

// Describes attributes of your AWS account. The following are the supported
// account attributes:
//
//   supported-platforms: Indicates whether your account can launch instances
// into EC2-Classic and EC2-VPC, or only into EC2-VPC.
//
//   default-vpc: The ID of the default VPC for your account, or none.
//
//   max-instances: The maximum number of On-Demand instances that you can
// run.
//
//   vpc-max-security-groups-per-interface: The maximum number of security
// groups that you can assign to a network interface.
//
//   max-elastic-ips: The maximum number of Elastic IP addresses that you can
// allocate for use with EC2-Classic.
//
//   vpc-max-elastic-ips: The maximum number of Elastic IP addresses that you
// can allocate for use with EC2-VPC.
func (c *EC2) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest generates a request for the DescribeAddresses operation.
func (c *EC2) DescribeAddressesRequest(input *DescribeAddressesInput) (req *request.Request, output *DescribeAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAddressesOutput{}
	req.Data = output
	return
}

// Describes one or more of your Elastic IP addresses.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeAddresses(input *DescribeAddressesInput) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAvailabilityZones = "DescribeAvailabilityZones"

// DescribeAvailabilityZonesRequest generates a request for the DescribeAvailabilityZones operation.
func (c *EC2) DescribeAvailabilityZonesRequest(input *DescribeAvailabilityZonesInput) (req *request.Request, output *DescribeAvailabilityZonesOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailabilityZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityZonesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAvailabilityZonesOutput{}
	req.Data = output
	return
}

// Describes one or more of the Availability Zones that are available to you.
// The results include zones only for the region you're currently using. If
// there is an event impacting an Availability Zone, you can use this request
// to view the state and any provided message for that Availability Zone.
//
// For more information, see Regions and Availability Zones (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeAvailabilityZones(input *DescribeAvailabilityZonesInput) (*DescribeAvailabilityZonesOutput, error) {
	req, out := c.DescribeAvailabilityZonesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeBundleTasks = "DescribeBundleTasks"

// DescribeBundleTasksRequest generates a request for the DescribeBundleTasks operation.
func (c *EC2) DescribeBundleTasksRequest(input *DescribeBundleTasksInput) (req *request.Request, output *DescribeBundleTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeBundleTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBundleTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeBundleTasksOutput{}
	req.Data = output
	return
}

// Describes one or more of your bundling tasks.
//
// Completed bundle tasks are listed for only a limited time. If your bundle
// task is no longer in the list, you can still register an AMI from it. Just
// use RegisterImage with the Amazon S3 bucket name and image manifest name
// you provided to the bundle task.
func (c *EC2) DescribeBundleTasks(input *DescribeBundleTasksInput) (*DescribeBundleTasksOutput, error) {
	req, out := c.DescribeBundleTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeClassicLinkInstances = "DescribeClassicLinkInstances"

// DescribeClassicLinkInstancesRequest generates a request for the DescribeClassicLinkInstances operation.
func (c *EC2) DescribeClassicLinkInstancesRequest(input *DescribeClassicLinkInstancesInput) (req *request.Request, output *DescribeClassicLinkInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeClassicLinkInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClassicLinkInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClassicLinkInstancesOutput{}
	req.Data = output
	return
}

// Describes one or more of your linked EC2-Classic instances. This request
// only returns information about EC2-Classic instances linked to a VPC through
// ClassicLink; you cannot use this request to return information about other
// instances.
func (c *EC2) DescribeClassicLinkInstances(input *DescribeClassicLinkInstancesInput) (*DescribeClassicLinkInstancesOutput, error) {
	req, out := c.DescribeClassicLinkInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConversionTasks = "DescribeConversionTasks"

// DescribeConversionTasksRequest generates a request for the DescribeConversionTasks operation.
func (c *EC2) DescribeConversionTasksRequest(input *DescribeConversionTasksInput) (req *request.Request, output *DescribeConversionTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeConversionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConversionTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeConversionTasksOutput{}
	req.Data = output
	return
}

// Describes one or more of your conversion tasks. For more information, see
// Using the Command Line Tools to Import Your Virtual Machine to Amazon EC2
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UploadingYourInstancesandVolumes.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeConversionTasks(input *DescribeConversionTasksInput) (*DescribeConversionTasksOutput, error) {
	req, out := c.DescribeConversionTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCustomerGateways = "DescribeCustomerGateways"

// DescribeCustomerGatewaysRequest generates a request for the DescribeCustomerGateways operation.
func (c *EC2) DescribeCustomerGatewaysRequest(input *DescribeCustomerGatewaysInput) (req *request.Request, output *DescribeCustomerGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomerGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomerGatewaysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCustomerGatewaysOutput{}
	req.Data = output
	return
}

// Describes one or more of your VPN customer gateways.
//
// For more information about VPN customer gateways, see Adding a Hardware
// Virtual Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeCustomerGateways(input *DescribeCustomerGatewaysInput) (*DescribeCustomerGatewaysOutput, error) {
	req, out := c.DescribeCustomerGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDhcpOptions = "DescribeDhcpOptions"

// DescribeDhcpOptionsRequest generates a request for the DescribeDhcpOptions operation.
func (c *EC2) DescribeDhcpOptionsRequest(input *DescribeDhcpOptionsInput) (req *request.Request, output *DescribeDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDhcpOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDhcpOptionsOutput{}
	req.Data = output
	return
}

// Describes one or more of your DHCP options sets.
//
// For more information about DHCP options sets, see DHCP Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeDhcpOptions(input *DescribeDhcpOptionsInput) (*DescribeDhcpOptionsOutput, error) {
	req, out := c.DescribeDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest generates a request for the DescribeExportTasks operation.
func (c *EC2) DescribeExportTasksRequest(input *DescribeExportTasksInput) (req *request.Request, output *DescribeExportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeExportTasksOutput{}
	req.Data = output
	return
}

// Describes one or more of your export tasks.
func (c *EC2) DescribeExportTasks(input *DescribeExportTasksInput) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFlowLogs = "DescribeFlowLogs"

// DescribeFlowLogsRequest generates a request for the DescribeFlowLogs operation.
func (c *EC2) DescribeFlowLogsRequest(input *DescribeFlowLogsInput) (req *request.Request, output *DescribeFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFlowLogsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeFlowLogsOutput{}
	req.Data = output
	return
}

// Describes one or more flow logs. To view the information in your flow logs
// (the log streams for the network interfaces), you must use the CloudWatch
// Logs console or the CloudWatch Logs API.
func (c *EC2) DescribeFlowLogs(input *DescribeFlowLogsInput) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHosts = "DescribeHosts"

// DescribeHostsRequest generates a request for the DescribeHosts operation.
func (c *EC2) DescribeHostsRequest(input *DescribeHostsInput) (req *request.Request, output *DescribeHostsOutput) {
	op := &request.Operation{
		Name:       opDescribeHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHostsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeHostsOutput{}
	req.Data = output
	return
}

// Describes one or more of your Dedicated hosts.
//
// The results describe only the Dedicated hosts in the region you're currently
// using. All listed instances consume capacity on your Dedicated host. Dedicated
// hosts that have recently been released will be listed with the state released.
func (c *EC2) DescribeHosts(input *DescribeHostsInput) (*DescribeHostsOutput, error) {
	req, out := c.DescribeHostsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIdFormat = "DescribeIdFormat"

// DescribeIdFormatRequest generates a request for the DescribeIdFormat operation.
func (c *EC2) DescribeIdFormatRequest(input *DescribeIdFormatInput) (req *request.Request, output *DescribeIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdFormatInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeIdFormatOutput{}
	req.Data = output
	return
}

// Important: This command is reserved for future use, and is currently not
// available for you to use.
//
// Describes the ID format settings for your resources, for example, to view
// which resource types are enabled for longer IDs. This request only returns
// information about resource types whose ID formats can be modified; it does
// not return information about other resource types.
//
// The following resource types support longer IDs: instance | reservation.
//
// These settings apply to the IAM user who makes the request; they do not
// apply to the entire AWS account. By default, an IAM user defaults to the
// same settings as the root user, unless they explicitly override the settings
// by running the ModifyIdFormat command. These settings are applied on a per-region
// basis.
func (c *EC2) DescribeIdFormat(input *DescribeIdFormatInput) (*DescribeIdFormatOutput, error) {
	req, out := c.DescribeIdFormatRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImageAttribute = "DescribeImageAttribute"

// DescribeImageAttributeRequest generates a request for the DescribeImageAttribute operation.
func (c *EC2) DescribeImageAttributeRequest(input *DescribeImageAttributeInput) (req *request.Request, output *DescribeImageAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeImageAttributeOutput{}
	req.Data = output
	return
}

// Describes the specified attribute of the specified AMI. You can specify only
// one attribute at a time.
func (c *EC2) DescribeImageAttribute(input *DescribeImageAttributeInput) (*DescribeImageAttributeOutput, error) {
	req, out := c.DescribeImageAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a request for the DescribeImages operation.
func (c *EC2) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeImagesOutput{}
	req.Data = output
	return
}

// Describes one or more of the images (AMIs, AKIs, and ARIs) available to you.
// Images available to you include public images, private images that you own,
// and private images owned by other AWS accounts but for which you have explicit
// launch permissions.
//
// Deregistered images are included in the returned results for an unspecified
// interval after deregistration.
func (c *EC2) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImportImageTasks = "DescribeImportImageTasks"

// DescribeImportImageTasksRequest generates a request for the DescribeImportImageTasks operation.
func (c *EC2) DescribeImportImageTasksRequest(input *DescribeImportImageTasksInput) (req *request.Request, output *DescribeImportImageTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImportImageTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeImportImageTasksOutput{}
	req.Data = output
	return
}

// Displays details about an import virtual machine or import snapshot tasks
// that are already created.
func (c *EC2) DescribeImportImageTasks(input *DescribeImportImageTasksInput) (*DescribeImportImageTasksOutput, error) {
	req, out := c.DescribeImportImageTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImportSnapshotTasks = "DescribeImportSnapshotTasks"

// DescribeImportSnapshotTasksRequest generates a request for the DescribeImportSnapshotTasks operation.
func (c *EC2) DescribeImportSnapshotTasksRequest(input *DescribeImportSnapshotTasksInput) (req *request.Request, output *DescribeImportSnapshotTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportSnapshotTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImportSnapshotTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeImportSnapshotTasksOutput{}
	req.Data = output
	return
}

// Describes your import snapshot tasks.
func (c *EC2) DescribeImportSnapshotTasks(input *DescribeImportSnapshotTasksInput) (*DescribeImportSnapshotTasksOutput, error) {
	req, out := c.DescribeImportSnapshotTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstanceAttribute = "DescribeInstanceAttribute"

// DescribeInstanceAttributeRequest generates a request for the DescribeInstanceAttribute operation.
func (c *EC2) DescribeInstanceAttributeRequest(input *DescribeInstanceAttributeInput) (req *request.Request, output *DescribeInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstanceAttributeOutput{}
	req.Data = output
	return
}

// Describes the specified attribute of the specified instance. You can specify
// only one attribute at a time. Valid attribute values are: instanceType |
// kernel | ramdisk | userData | disableApiTermination | instanceInitiatedShutdownBehavior
// | rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck |
// groupSet | ebsOptimized | sriovNetSupport
func (c *EC2) DescribeInstanceAttribute(input *DescribeInstanceAttributeInput) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstanceStatus = "DescribeInstanceStatus"

// DescribeInstanceStatusRequest generates a request for the DescribeInstanceStatus operation.
func (c *EC2) DescribeInstanceStatusRequest(input *DescribeInstanceStatusInput) (req *request.Request, output *DescribeInstanceStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstanceStatusOutput{}
	req.Data = output
	return
}

// Describes the status of one or more instances.
//
// Instance status includes the following components:
//
//   Status checks - Amazon EC2 performs status checks on running EC2 instances
// to identify hardware and software issues. For more information, see Status
// Checks for Your Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html)
// and Troubleshooting Instances with Failed Status Checks (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//  Scheduled events - Amazon EC2 can schedule events (such as reboot, stop,
// or terminate) for your instances related to hardware issues, software updates,
// or system maintenance. For more information, see Scheduled Events for Your
// Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//   Instance state - You can manage your instances from the moment you launch
// them through their termination. For more information, see Instance Lifecycle
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeInstanceStatus(input *DescribeInstanceStatusInput) (*DescribeInstanceStatusOutput, error) {
	req, out := c.DescribeInstanceStatusRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeInstanceStatusPages(input *DescribeInstanceStatusInput, fn func(p *DescribeInstanceStatusOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeInstanceStatusRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeInstanceStatusOutput), lastPage)
	})
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a request for the DescribeInstances operation.
func (c *EC2) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstancesOutput{}
	req.Data = output
	return
}

// Describes one or more of your instances.
//
// If you specify one or more instance IDs, Amazon EC2 returns information
// for those instances. If you do not specify instance IDs, Amazon EC2 returns
// information for all relevant instances. If you specify an instance ID that
// is not valid, an error is returned. If you specify an instance that you do
// not own, it is not included in the returned results.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
func (c *EC2) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeInstancesPages(input *DescribeInstancesInput, fn func(p *DescribeInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeInstancesOutput), lastPage)
	})
}

const opDescribeInternetGateways = "DescribeInternetGateways"

// DescribeInternetGatewaysRequest generates a request for the DescribeInternetGateways operation.
func (c *EC2) DescribeInternetGatewaysRequest(input *DescribeInternetGatewaysInput) (req *request.Request, output *DescribeInternetGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeInternetGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInternetGatewaysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInternetGatewaysOutput{}
	req.Data = output
	return
}

// Describes one or more of your Internet gateways.
func (c *EC2) DescribeInternetGateways(input *DescribeInternetGatewaysInput) (*DescribeInternetGatewaysOutput, error) {
	req, out := c.DescribeInternetGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeKeyPairs = "DescribeKeyPairs"

// DescribeKeyPairsRequest generates a request for the DescribeKeyPairs operation.
func (c *EC2) DescribeKeyPairsRequest(input *DescribeKeyPairsInput) (req *request.Request, output *DescribeKeyPairsOutput) {
	op := &request.Operation{
		Name:       opDescribeKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyPairsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeKeyPairsOutput{}
	req.Data = output
	return
}

// Describes one or more of your key pairs.
//
// For more information about key pairs, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeKeyPairs(input *DescribeKeyPairsInput) (*DescribeKeyPairsOutput, error) {
	req, out := c.DescribeKeyPairsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeMovingAddresses = "DescribeMovingAddresses"

// DescribeMovingAddressesRequest generates a request for the DescribeMovingAddresses operation.
func (c *EC2) DescribeMovingAddressesRequest(input *DescribeMovingAddressesInput) (req *request.Request, output *DescribeMovingAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeMovingAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMovingAddressesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeMovingAddressesOutput{}
	req.Data = output
	return
}

// Describes your Elastic IP addresses that are being moved to the EC2-VPC platform,
// or that are being restored to the EC2-Classic platform. This request does
// not return information about any other Elastic IP addresses in your account.
func (c *EC2) DescribeMovingAddresses(input *DescribeMovingAddressesInput) (*DescribeMovingAddressesOutput, error) {
	req, out := c.DescribeMovingAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNatGateways = "DescribeNatGateways"

// DescribeNatGatewaysRequest generates a request for the DescribeNatGateways operation.
func (c *EC2) DescribeNatGatewaysRequest(input *DescribeNatGatewaysInput) (req *request.Request, output *DescribeNatGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeNatGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNatGatewaysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeNatGatewaysOutput{}
	req.Data = output
	return
}

// Describes one or more of the your NAT gateways.
func (c *EC2) DescribeNatGateways(input *DescribeNatGatewaysInput) (*DescribeNatGatewaysOutput, error) {
	req, out := c.DescribeNatGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNetworkAcls = "DescribeNetworkAcls"

// DescribeNetworkAclsRequest generates a request for the DescribeNetworkAcls operation.
func (c *EC2) DescribeNetworkAclsRequest(input *DescribeNetworkAclsInput) (req *request.Request, output *DescribeNetworkAclsOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkAcls,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNetworkAclsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeNetworkAclsOutput{}
	req.Data = output
	return
}

// Describes one or more of your network ACLs.
//
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeNetworkAcls(input *DescribeNetworkAclsInput) (*DescribeNetworkAclsOutput, error) {
	req, out := c.DescribeNetworkAclsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNetworkInterfaceAttribute = "DescribeNetworkInterfaceAttribute"

// DescribeNetworkInterfaceAttributeRequest generates a request for the DescribeNetworkInterfaceAttribute operation.
func (c *EC2) DescribeNetworkInterfaceAttributeRequest(input *DescribeNetworkInterfaceAttributeInput) (req *request.Request, output *DescribeNetworkInterfaceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInterfaceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNetworkInterfaceAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeNetworkInterfaceAttributeOutput{}
	req.Data = output
	return
}

// Describes a network interface attribute. You can specify only one attribute
// at a time.
func (c *EC2) DescribeNetworkInterfaceAttribute(input *DescribeNetworkInterfaceAttributeInput) (*DescribeNetworkInterfaceAttributeOutput, error) {
	req, out := c.DescribeNetworkInterfaceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNetworkInterfaces = "DescribeNetworkInterfaces"

// DescribeNetworkInterfacesRequest generates a request for the DescribeNetworkInterfaces operation.
func (c *EC2) DescribeNetworkInterfacesRequest(input *DescribeNetworkInterfacesInput) (req *request.Request, output *DescribeNetworkInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNetworkInterfacesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeNetworkInterfacesOutput{}
	req.Data = output
	return
}

// Describes one or more of your network interfaces.
func (c *EC2) DescribeNetworkInterfaces(input *DescribeNetworkInterfacesInput) (*DescribeNetworkInterfacesOutput, error) {
	req, out := c.DescribeNetworkInterfacesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribePlacementGroups = "DescribePlacementGroups"

// DescribePlacementGroupsRequest generates a request for the DescribePlacementGroups operation.
func (c *EC2) DescribePlacementGroupsRequest(input *DescribePlacementGroupsInput) (req *request.Request, output *DescribePlacementGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribePlacementGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePlacementGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePlacementGroupsOutput{}
	req.Data = output
	return
}

// Describes one or more of your placement groups. For more information about
// placement groups and cluster instances, see Cluster Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribePlacementGroups(input *DescribePlacementGroupsInput) (*DescribePlacementGroupsOutput, error) {
	req, out := c.DescribePlacementGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribePrefixLists = "DescribePrefixLists"

// DescribePrefixListsRequest generates a request for the DescribePrefixLists operation.
func (c *EC2) DescribePrefixListsRequest(input *DescribePrefixListsInput) (req *request.Request, output *DescribePrefixListsOutput) {
	op := &request.Operation{
		Name:       opDescribePrefixLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePrefixListsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePrefixListsOutput{}
	req.Data = output
	return
}

// Describes available AWS services in a prefix list format, which includes
// the prefix list name and prefix list ID of the service and the IP address
// range for the service. A prefix list ID is required for creating an outbound
// security group rule that allows traffic from a VPC to access an AWS service
// through a VPC endpoint.
func (c *EC2) DescribePrefixLists(input *DescribePrefixListsInput) (*DescribePrefixListsOutput, error) {
	req, out := c.DescribePrefixListsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRegions = "DescribeRegions"

// DescribeRegionsRequest generates a request for the DescribeRegions operation.
func (c *EC2) DescribeRegionsRequest(input *DescribeRegionsInput) (req *request.Request, output *DescribeRegionsOutput) {
	op := &request.Operation{
		Name:       opDescribeRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRegionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRegionsOutput{}
	req.Data = output
	return
}

// Describes one or more regions that are currently available to you.
//
// For a list of the regions supported by Amazon EC2, see Regions and Endpoints
// (http://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region).
func (c *EC2) DescribeRegions(input *DescribeRegionsInput) (*DescribeRegionsOutput, error) {
	req, out := c.DescribeRegionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReservedInstances = "DescribeReservedInstances"

// DescribeReservedInstancesRequest generates a request for the DescribeReservedInstances operation.
func (c *EC2) DescribeReservedInstancesRequest(input *DescribeReservedInstancesInput) (req *request.Request, output *DescribeReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReservedInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedInstancesOutput{}
	req.Data = output
	return
}

// Describes one or more of the Reserved instances that you purchased.
//
// For more information about Reserved instances, see Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeReservedInstances(input *DescribeReservedInstancesInput) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReservedInstancesListings = "DescribeReservedInstancesListings"

// DescribeReservedInstancesListingsRequest generates a request for the DescribeReservedInstancesListings operation.
func (c *EC2) DescribeReservedInstancesListingsRequest(input *DescribeReservedInstancesListingsInput) (req *request.Request, output *DescribeReservedInstancesListingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesListings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReservedInstancesListingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedInstancesListingsOutput{}
	req.Data = output
	return
}

// Describes your account's Reserved instance listings in the Reserved Instance
// Marketplace.
//
// The Reserved Instance Marketplace matches sellers who want to resell Reserved
// instance capacity that they no longer need with buyers who want to purchase
// additional capacity. Reserved instances bought and sold through the Reserved
// Instance Marketplace work like any other Reserved Instances.
//
// As a seller, you choose to list some or all of your Reserved instances,
// and you specify the upfront price to receive for them. Your Reserved instances
// are then listed in the Reserved Instance Marketplace and are available for
// purchase.
//
// As a buyer, you specify the configuration of the Reserved instance to purchase,
// and the Marketplace matches what you're searching for with what's available.
// The Marketplace first sells the lowest priced Reserved instances to you,
// and continues to sell available Reserved Instance listings to you until your
// demand is met. You are charged based on the total price of all of the listings
// that you purchase.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeReservedInstancesListings(input *DescribeReservedInstancesListingsInput) (*DescribeReservedInstancesListingsOutput, error) {
	req, out := c.DescribeReservedInstancesListingsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReservedInstancesModifications = "DescribeReservedInstancesModifications"

// DescribeReservedInstancesModificationsRequest generates a request for the DescribeReservedInstancesModifications operation.
func (c *EC2) DescribeReservedInstancesModificationsRequest(input *DescribeReservedInstancesModificationsInput) (req *request.Request, output *DescribeReservedInstancesModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesModificationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedInstancesModificationsOutput{}
	req.Data = output
	return
}

// Describes the modifications made to your Reserved instances. If no parameter
// is specified, information about all your Reserved instances modification
// requests is returned. If a modification ID is specified, only information
// about the specific modification is returned.
//
// For more information, see Modifying Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeReservedInstancesModifications(input *DescribeReservedInstancesModificationsInput) (*DescribeReservedInstancesModificationsOutput, error) {
	req, out := c.DescribeReservedInstancesModificationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeReservedInstancesModificationsPages(input *DescribeReservedInstancesModificationsInput, fn func(p *DescribeReservedInstancesModificationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedInstancesModificationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedInstancesModificationsOutput), lastPage)
	})
}

const opDescribeReservedInstancesOfferings = "DescribeReservedInstancesOfferings"

// DescribeReservedInstancesOfferingsRequest generates a request for the DescribeReservedInstancesOfferings operation.
func (c *EC2) DescribeReservedInstancesOfferingsRequest(input *DescribeReservedInstancesOfferingsInput) (req *request.Request, output *DescribeReservedInstancesOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesOfferingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedInstancesOfferingsOutput{}
	req.Data = output
	return
}

// Describes Reserved instance offerings that are available for purchase. With
// Reserved instances, you purchase the right to launch instances for a period
// of time. During that time period, you do not receive insufficient capacity
// errors, and you pay a lower usage rate than the rate charged for On-Demand
// instances for the actual time used.
//
// If you have listed your own Reserved instances for sale in the Reserved
// Instance Marketplace, they will be excluded from these results. This is to
// ensure that you do not purchase your own Reserved instances.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeReservedInstancesOfferings(input *DescribeReservedInstancesOfferingsInput) (*DescribeReservedInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedInstancesOfferingsRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeReservedInstancesOfferingsPages(input *DescribeReservedInstancesOfferingsInput, fn func(p *DescribeReservedInstancesOfferingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedInstancesOfferingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedInstancesOfferingsOutput), lastPage)
	})
}

const opDescribeRouteTables = "DescribeRouteTables"

// DescribeRouteTablesRequest generates a request for the DescribeRouteTables operation.
func (c *EC2) DescribeRouteTablesRequest(input *DescribeRouteTablesInput) (req *request.Request, output *DescribeRouteTablesOutput) {
	op := &request.Operation{
		Name:       opDescribeRouteTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRouteTablesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRouteTablesOutput{}
	req.Data = output
	return
}

// Describes one or more of your route tables.
//
// Each subnet in your VPC must be associated with a route table. If a subnet
// is not explicitly associated with any route table, it is implicitly associated
// with the main route table. This command does not return the subnet ID for
// implicit associations.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeRouteTables(input *DescribeRouteTablesInput) (*DescribeRouteTablesOutput, error) {
	req, out := c.DescribeRouteTablesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSecurityGroups = "DescribeSecurityGroups"

// DescribeSecurityGroupsRequest generates a request for the DescribeSecurityGroups operation.
func (c *EC2) DescribeSecurityGroupsRequest(input *DescribeSecurityGroupsInput) (req *request.Request, output *DescribeSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSecurityGroupsOutput{}
	req.Data = output
	return
}

// Describes one or more of your security groups.
//
// A security group is for use with instances either in the EC2-Classic platform
// or in a specific VPC. For more information, see Amazon EC2 Security Groups
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security Groups for Your
// VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeSecurityGroups(input *DescribeSecurityGroupsInput) (*DescribeSecurityGroupsOutput, error) {
	req, out := c.DescribeSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshotAttribute = "DescribeSnapshotAttribute"

// DescribeSnapshotAttributeRequest generates a request for the DescribeSnapshotAttribute operation.
func (c *EC2) DescribeSnapshotAttributeRequest(input *DescribeSnapshotAttributeInput) (req *request.Request, output *DescribeSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotAttributeOutput{}
	req.Data = output
	return
}

// Describes the specified attribute of the specified snapshot. You can specify
// only one attribute at a time.
//
// For more information about EBS snapshots, see Amazon EBS Snapshots in the
// Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeSnapshotAttribute(input *DescribeSnapshotAttributeInput) (*DescribeSnapshotAttributeOutput, error) {
	req, out := c.DescribeSnapshotAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a request for the DescribeSnapshots operation.
func (c *EC2) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotsOutput{}
	req.Data = output
	return
}

// Describes one or more of the EBS snapshots available to you. Available snapshots
// include public snapshots available for any AWS account to launch, private
// snapshots that you own, and private snapshots owned by another AWS account
// but for which you've been given explicit create volume permissions.
//
// The create volume permissions fall into the following categories:
//
//  public: The owner of the snapshot granted create volume permissions for
// the snapshot to the all group. All AWS accounts have create volume permissions
// for these snapshots. explicit: The owner of the snapshot granted create volume
// permissions to a specific AWS account. implicit: An AWS account has implicit
// create volume permissions for all snapshots it owns.  The list of snapshots
// returned can be modified by specifying snapshot IDs, snapshot owners, or
// AWS accounts with create volume permissions. If no options are specified,
// Amazon EC2 returns all snapshots for which you have create volume permissions.
//
// If you specify one or more snapshot IDs, only snapshots that have the specified
// IDs are returned. If you specify an invalid snapshot ID, an error is returned.
// If you specify a snapshot ID for which you do not have access, it is not
// included in the returned results.
//
// If you specify one or more snapshot owners, only snapshots from the specified
// owners and for which you have access are returned. The results can include
// the AWS account IDs of the specified owners, amazon for snapshots owned by
// Amazon, or self for snapshots that you own.
//
// If you specify a list of restorable users, only snapshots with create snapshot
// permissions for those users are returned. You can specify AWS account IDs
// (if you own the snapshots), self for snapshots for which you own or have
// explicit permissions, or all for public snapshots.
//
// If you are describing a long list of snapshots, you can paginate the output
// to make the list more manageable. The MaxResults parameter sets the maximum
// number of results returned in a single page. If the list of results exceeds
// your MaxResults value, then that number of results is returned along with
// a NextToken value that can be passed to a subsequent DescribeSnapshots request
// to retrieve the remaining results.
//
// For more information about EBS snapshots, see Amazon EBS Snapshots in the
// Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeSnapshotsPages(input *DescribeSnapshotsInput, fn func(p *DescribeSnapshotsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeSnapshotsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeSnapshotsOutput), lastPage)
	})
}

const opDescribeSpotDatafeedSubscription = "DescribeSpotDatafeedSubscription"

// DescribeSpotDatafeedSubscriptionRequest generates a request for the DescribeSpotDatafeedSubscription operation.
func (c *EC2) DescribeSpotDatafeedSubscriptionRequest(input *DescribeSpotDatafeedSubscriptionInput) (req *request.Request, output *DescribeSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotDatafeedSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSpotDatafeedSubscriptionOutput{}
	req.Data = output
	return
}

// Describes the data feed for Spot instances. For more information, see Spot
// Instance Data Feed (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeSpotDatafeedSubscription(input *DescribeSpotDatafeedSubscriptionInput) (*DescribeSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DescribeSpotDatafeedSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotFleetInstances = "DescribeSpotFleetInstances"

// DescribeSpotFleetInstancesRequest generates a request for the DescribeSpotFleetInstances operation.
func (c *EC2) DescribeSpotFleetInstancesRequest(input *DescribeSpotFleetInstancesInput) (req *request.Request, output *DescribeSpotFleetInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSpotFleetInstancesOutput{}
	req.Data = output
	return
}

// Describes the running instances for the specified Spot fleet.
func (c *EC2) DescribeSpotFleetInstances(input *DescribeSpotFleetInstancesInput) (*DescribeSpotFleetInstancesOutput, error) {
	req, out := c.DescribeSpotFleetInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotFleetRequestHistory = "DescribeSpotFleetRequestHistory"

// DescribeSpotFleetRequestHistoryRequest generates a request for the DescribeSpotFleetRequestHistory operation.
func (c *EC2) DescribeSpotFleetRequestHistoryRequest(input *DescribeSpotFleetRequestHistoryInput) (req *request.Request, output *DescribeSpotFleetRequestHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetRequestHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetRequestHistoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSpotFleetRequestHistoryOutput{}
	req.Data = output
	return
}

// Describes the events for the specified Spot fleet request during the specified
// time.
//
// Spot fleet events are delayed by up to 30 seconds before they can be described.
// This ensures that you can query by the last evaluated time and not miss a
// recorded event.
func (c *EC2) DescribeSpotFleetRequestHistory(input *DescribeSpotFleetRequestHistoryInput) (*DescribeSpotFleetRequestHistoryOutput, error) {
	req, out := c.DescribeSpotFleetRequestHistoryRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotFleetRequests = "DescribeSpotFleetRequests"

// DescribeSpotFleetRequestsRequest generates a request for the DescribeSpotFleetRequests operation.
func (c *EC2) DescribeSpotFleetRequestsRequest(input *DescribeSpotFleetRequestsInput) (req *request.Request, output *DescribeSpotFleetRequestsOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetRequestsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSpotFleetRequestsOutput{}
	req.Data = output
	return
}

// Describes your Spot fleet requests.
func (c *EC2) DescribeSpotFleetRequests(input *DescribeSpotFleetRequestsInput) (*DescribeSpotFleetRequestsOutput, error) {
	req, out := c.DescribeSpotFleetRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotInstanceRequests = "DescribeSpotInstanceRequests"

// DescribeSpotInstanceRequestsRequest generates a request for the DescribeSpotInstanceRequests operation.
func (c *EC2) DescribeSpotInstanceRequestsRequest(input *DescribeSpotInstanceRequestsInput) (req *request.Request, output *DescribeSpotInstanceRequestsOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotInstanceRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotInstanceRequestsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSpotInstanceRequestsOutput{}
	req.Data = output
	return
}

// Describes the Spot instance requests that belong to your account. Spot instances
// are instances that Amazon EC2 launches when the bid price that you specify
// exceeds the current Spot price. Amazon EC2 periodically sets the Spot price
// based on available Spot instance capacity and current Spot instance requests.
// For more information, see Spot Instance Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You can use DescribeSpotInstanceRequests to find a running Spot instance
// by examining the response. If the status of the Spot instance is fulfilled,
// the instance ID appears in the response and contains the identifier of the
// instance. Alternatively, you can use DescribeInstances with a filter to look
// for instances where the instance lifecycle is spot.
func (c *EC2) DescribeSpotInstanceRequests(input *DescribeSpotInstanceRequestsInput) (*DescribeSpotInstanceRequestsOutput, error) {
	req, out := c.DescribeSpotInstanceRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotPriceHistory = "DescribeSpotPriceHistory"

// DescribeSpotPriceHistoryRequest generates a request for the DescribeSpotPriceHistory operation.
func (c *EC2) DescribeSpotPriceHistoryRequest(input *DescribeSpotPriceHistoryInput) (req *request.Request, output *DescribeSpotPriceHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotPriceHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSpotPriceHistoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSpotPriceHistoryOutput{}
	req.Data = output
	return
}

// Describes the Spot price history. The prices returned are listed in chronological
// order, from the oldest to the most recent, for up to the past 90 days. For
// more information, see Spot Instance Pricing History (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// When you specify a start and end time, this operation returns the prices
// of the instance types within the time range that you specified and the time
// when the price changed. The price is valid within the time period that you
// specified; the response merely indicates the last time that the price changed.
func (c *EC2) DescribeSpotPriceHistory(input *DescribeSpotPriceHistoryInput) (*DescribeSpotPriceHistoryOutput, error) {
	req, out := c.DescribeSpotPriceHistoryRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeSpotPriceHistoryPages(input *DescribeSpotPriceHistoryInput, fn func(p *DescribeSpotPriceHistoryOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeSpotPriceHistoryRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeSpotPriceHistoryOutput), lastPage)
	})
}

const opDescribeSubnets = "DescribeSubnets"

// DescribeSubnetsRequest generates a request for the DescribeSubnets operation.
func (c *EC2) DescribeSubnetsRequest(input *DescribeSubnetsInput) (req *request.Request, output *DescribeSubnetsOutput) {
	op := &request.Operation{
		Name:       opDescribeSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubnetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSubnetsOutput{}
	req.Data = output
	return
}

// Describes one or more of your subnets.
//
// For more information about subnets, see Your VPC and Subnets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeSubnets(input *DescribeSubnetsInput) (*DescribeSubnetsOutput, error) {
	req, out := c.DescribeSubnetsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a request for the DescribeTags operation.
func (c *EC2) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// Describes one or more of the tags for your EC2 resources.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeTagsPages(input *DescribeTagsInput, fn func(p *DescribeTagsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTagsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTagsOutput), lastPage)
	})
}

const opDescribeVolumeAttribute = "DescribeVolumeAttribute"

// DescribeVolumeAttributeRequest generates a request for the DescribeVolumeAttribute operation.
func (c *EC2) DescribeVolumeAttributeRequest(input *DescribeVolumeAttributeInput) (req *request.Request, output *DescribeVolumeAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumeAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVolumeAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVolumeAttributeOutput{}
	req.Data = output
	return
}

// Describes the specified attribute of the specified volume. You can specify
// only one attribute at a time.
//
// For more information about EBS volumes, see Amazon EBS Volumes in the Amazon
// Elastic Compute Cloud User Guide.
func (c *EC2) DescribeVolumeAttribute(input *DescribeVolumeAttributeInput) (*DescribeVolumeAttributeOutput, error) {
	req, out := c.DescribeVolumeAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVolumeStatus = "DescribeVolumeStatus"

// DescribeVolumeStatusRequest generates a request for the DescribeVolumeStatus operation.
func (c *EC2) DescribeVolumeStatusRequest(input *DescribeVolumeStatusInput) (req *request.Request, output *DescribeVolumeStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumeStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVolumeStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVolumeStatusOutput{}
	req.Data = output
	return
}

// Describes the status of the specified volumes. Volume status provides the
// result of the checks performed on your volumes to determine events that can
// impair the performance of your volumes. The performance of a volume can be
// affected if an issue occurs on the volume's underlying host. If the volume's
// underlying host experiences a power outage or system issue, after the system
// is restored, there could be data inconsistencies on the volume. Volume events
// notify you if this occurs. Volume actions notify you if any action needs
// to be taken in response to the event.
//
// The DescribeVolumeStatus operation provides the following information about
// the specified volumes:
//
// Status: Reflects the current status of the volume. The possible values are
// ok, impaired , warning, or insufficient-data. If all checks pass, the overall
// status of the volume is ok. If the check fails, the overall status is impaired.
// If the status is insufficient-data, then the checks may still be taking place
// on your volume at the time. We recommend that you retry the request. For
// more information on volume status, see Monitoring the Status of Your Volumes
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html).
//
// Events: Reflect the cause of a volume status and may require you to take
// action. For example, if your volume returns an impaired status, then the
// volume event might be potential-data-inconsistency. This means that your
// volume has been affected by an issue with the underlying host, has all I/O
// operations disabled, and may have inconsistent data.
//
// Actions: Reflect the actions you may have to take in response to an event.
// For example, if the status of the volume is impaired and the volume event
// shows potential-data-inconsistency, then the action shows enable-volume-io.
// This means that you may want to enable the I/O operations for the volume
// by calling the EnableVolumeIO action and then check the volume for data consistency.
//
//  Volume status is based on the volume status checks, and does not reflect
// the volume state. Therefore, volume status does not indicate volumes in the
// error state (for example, when a volume is incapable of accepting I/O.)
func (c *EC2) DescribeVolumeStatus(input *DescribeVolumeStatusInput) (*DescribeVolumeStatusOutput, error) {
	req, out := c.DescribeVolumeStatusRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeVolumeStatusPages(input *DescribeVolumeStatusInput, fn func(p *DescribeVolumeStatusOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeVolumeStatusRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeVolumeStatusOutput), lastPage)
	})
}

const opDescribeVolumes = "DescribeVolumes"

// DescribeVolumesRequest generates a request for the DescribeVolumes operation.
func (c *EC2) DescribeVolumesRequest(input *DescribeVolumesInput) (req *request.Request, output *DescribeVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVolumesOutput{}
	req.Data = output
	return
}

// Describes the specified EBS volumes.
//
// If you are describing a long list of volumes, you can paginate the output
// to make the list more manageable. The MaxResults parameter sets the maximum
// number of results returned in a single page. If the list of results exceeds
// your MaxResults value, then that number of results is returned along with
// a NextToken value that can be passed to a subsequent DescribeVolumes request
// to retrieve the remaining results.
//
// For more information about EBS volumes, see Amazon EBS Volumes in the Amazon
// Elastic Compute Cloud User Guide.
func (c *EC2) DescribeVolumes(input *DescribeVolumesInput) (*DescribeVolumesOutput, error) {
	req, out := c.DescribeVolumesRequest(input)
	err := req.Send()
	return out, err
}

func (c *EC2) DescribeVolumesPages(input *DescribeVolumesInput, fn func(p *DescribeVolumesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeVolumesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeVolumesOutput), lastPage)
	})
}

const opDescribeVpcAttribute = "DescribeVpcAttribute"

// DescribeVpcAttributeRequest generates a request for the DescribeVpcAttribute operation.
func (c *EC2) DescribeVpcAttributeRequest(input *DescribeVpcAttributeInput) (req *request.Request, output *DescribeVpcAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpcAttributeOutput{}
	req.Data = output
	return
}

// Describes the specified attribute of the specified VPC. You can specify only
// one attribute at a time.
func (c *EC2) DescribeVpcAttribute(input *DescribeVpcAttributeInput) (*DescribeVpcAttributeOutput, error) {
	req, out := c.DescribeVpcAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcClassicLink = "DescribeVpcClassicLink"

// DescribeVpcClassicLinkRequest generates a request for the DescribeVpcClassicLink operation.
func (c *EC2) DescribeVpcClassicLinkRequest(input *DescribeVpcClassicLinkInput) (req *request.Request, output *DescribeVpcClassicLinkOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcClassicLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcClassicLinkInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpcClassicLinkOutput{}
	req.Data = output
	return
}

// Describes the ClassicLink status of one or more VPCs.
func (c *EC2) DescribeVpcClassicLink(input *DescribeVpcClassicLinkInput) (*DescribeVpcClassicLinkOutput, error) {
	req, out := c.DescribeVpcClassicLinkRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcEndpointServices = "DescribeVpcEndpointServices"

// DescribeVpcEndpointServicesRequest generates a request for the DescribeVpcEndpointServices operation.
func (c *EC2) DescribeVpcEndpointServicesRequest(input *DescribeVpcEndpointServicesInput) (req *request.Request, output *DescribeVpcEndpointServicesOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcEndpointServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcEndpointServicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpcEndpointServicesOutput{}
	req.Data = output
	return
}

// Describes all supported AWS services that can be specified when creating
// a VPC endpoint.
func (c *EC2) DescribeVpcEndpointServices(input *DescribeVpcEndpointServicesInput) (*DescribeVpcEndpointServicesOutput, error) {
	req, out := c.DescribeVpcEndpointServicesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcEndpoints = "DescribeVpcEndpoints"

// DescribeVpcEndpointsRequest generates a request for the DescribeVpcEndpoints operation.
func (c *EC2) DescribeVpcEndpointsRequest(input *DescribeVpcEndpointsInput) (req *request.Request, output *DescribeVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcEndpointsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpcEndpointsOutput{}
	req.Data = output
	return
}

// Describes one or more of your VPC endpoints.
func (c *EC2) DescribeVpcEndpoints(input *DescribeVpcEndpointsInput) (*DescribeVpcEndpointsOutput, error) {
	req, out := c.DescribeVpcEndpointsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcPeeringConnections = "DescribeVpcPeeringConnections"

// DescribeVpcPeeringConnectionsRequest generates a request for the DescribeVpcPeeringConnections operation.
func (c *EC2) DescribeVpcPeeringConnectionsRequest(input *DescribeVpcPeeringConnectionsInput) (req *request.Request, output *DescribeVpcPeeringConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcPeeringConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcPeeringConnectionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpcPeeringConnectionsOutput{}
	req.Data = output
	return
}

// Describes one or more of your VPC peering connections.
func (c *EC2) DescribeVpcPeeringConnections(input *DescribeVpcPeeringConnectionsInput) (*DescribeVpcPeeringConnectionsOutput, error) {
	req, out := c.DescribeVpcPeeringConnectionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcs = "DescribeVpcs"

// DescribeVpcsRequest generates a request for the DescribeVpcs operation.
func (c *EC2) DescribeVpcsRequest(input *DescribeVpcsInput) (req *request.Request, output *DescribeVpcsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpcsOutput{}
	req.Data = output
	return
}

// Describes one or more of your VPCs.
func (c *EC2) DescribeVpcs(input *DescribeVpcsInput) (*DescribeVpcsOutput, error) {
	req, out := c.DescribeVpcsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpnConnections = "DescribeVpnConnections"

// DescribeVpnConnectionsRequest generates a request for the DescribeVpnConnections operation.
func (c *EC2) DescribeVpnConnectionsRequest(input *DescribeVpnConnectionsInput) (req *request.Request, output *DescribeVpnConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpnConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpnConnectionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpnConnectionsOutput{}
	req.Data = output
	return
}

// Describes one or more of your VPN connections.
//
// For more information about VPN connections, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeVpnConnections(input *DescribeVpnConnectionsInput) (*DescribeVpnConnectionsOutput, error) {
	req, out := c.DescribeVpnConnectionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpnGateways = "DescribeVpnGateways"

// DescribeVpnGatewaysRequest generates a request for the DescribeVpnGateways operation.
func (c *EC2) DescribeVpnGatewaysRequest(input *DescribeVpnGatewaysInput) (req *request.Request, output *DescribeVpnGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeVpnGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpnGatewaysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVpnGatewaysOutput{}
	req.Data = output
	return
}

// Describes one or more of your virtual private gateways.
//
// For more information about virtual private gateways, see Adding an IPsec
// Hardware VPN to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DescribeVpnGateways(input *DescribeVpnGatewaysInput) (*DescribeVpnGatewaysOutput, error) {
	req, out := c.DescribeVpnGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDetachClassicLinkVpc = "DetachClassicLinkVpc"

// DetachClassicLinkVpcRequest generates a request for the DetachClassicLinkVpc operation.
func (c *EC2) DetachClassicLinkVpcRequest(input *DetachClassicLinkVpcInput) (req *request.Request, output *DetachClassicLinkVpcOutput) {
	op := &request.Operation{
		Name:       opDetachClassicLinkVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachClassicLinkVpcInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachClassicLinkVpcOutput{}
	req.Data = output
	return
}

// Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance
// has been unlinked, the VPC security groups are no longer associated with
// it. An instance is automatically unlinked from a VPC when it's stopped.
func (c *EC2) DetachClassicLinkVpc(input *DetachClassicLinkVpcInput) (*DetachClassicLinkVpcOutput, error) {
	req, out := c.DetachClassicLinkVpcRequest(input)
	err := req.Send()
	return out, err
}

const opDetachInternetGateway = "DetachInternetGateway"

// DetachInternetGatewayRequest generates a request for the DetachInternetGateway operation.
func (c *EC2) DetachInternetGatewayRequest(input *DetachInternetGatewayInput) (req *request.Request, output *DetachInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDetachInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInternetGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachInternetGatewayOutput{}
	req.Data = output
	return
}

// Detaches an Internet gateway from a VPC, disabling connectivity between the
// Internet and the VPC. The VPC must not contain any running instances with
// Elastic IP addresses.
func (c *EC2) DetachInternetGateway(input *DetachInternetGatewayInput) (*DetachInternetGatewayOutput, error) {
	req, out := c.DetachInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDetachNetworkInterface = "DetachNetworkInterface"

// DetachNetworkInterfaceRequest generates a request for the DetachNetworkInterface operation.
func (c *EC2) DetachNetworkInterfaceRequest(input *DetachNetworkInterfaceInput) (req *request.Request, output *DetachNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opDetachNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachNetworkInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachNetworkInterfaceOutput{}
	req.Data = output
	return
}

// Detaches a network interface from an instance.
func (c *EC2) DetachNetworkInterface(input *DetachNetworkInterfaceInput) (*DetachNetworkInterfaceOutput, error) {
	req, out := c.DetachNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDetachVolume = "DetachVolume"

// DetachVolumeRequest generates a request for the DetachVolume operation.
func (c *EC2) DetachVolumeRequest(input *DetachVolumeInput) (req *request.Request, output *VolumeAttachment) {
	op := &request.Operation{
		Name:       opDetachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VolumeAttachment{}
	req.Data = output
	return
}

// Detaches an EBS volume from an instance. Make sure to unmount any file systems
// on the device within your operating system before detaching the volume. Failure
// to do so results in the volume being stuck in a busy state while detaching.
//
// If an Amazon EBS volume is the root device of an instance, it can't be detached
// while the instance is running. To detach the root volume, stop the instance
// first.
//
// When a volume with an AWS Marketplace product code is detached from an instance,
// the product code is no longer associated with the instance.
//
// For more information, see Detaching an Amazon EBS Volume (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) DetachVolume(input *DetachVolumeInput) (*VolumeAttachment, error) {
	req, out := c.DetachVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opDetachVpnGateway = "DetachVpnGateway"

// DetachVpnGatewayRequest generates a request for the DetachVpnGateway operation.
func (c *EC2) DetachVpnGatewayRequest(input *DetachVpnGatewayInput) (req *request.Request, output *DetachVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opDetachVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachVpnGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachVpnGatewayOutput{}
	req.Data = output
	return
}

// Detaches a virtual private gateway from a VPC. You do this if you're planning
// to turn off the VPC and not use it anymore. You can confirm a virtual private
// gateway has been completely detached from a VPC by describing the virtual
// private gateway (any attachments to the virtual private gateway are also
// described).
//
// You must wait for the attachment's state to switch to detached before you
// can delete the VPC or attach a different VPC to the virtual private gateway.
func (c *EC2) DetachVpnGateway(input *DetachVpnGatewayInput) (*DetachVpnGatewayOutput, error) {
	req, out := c.DetachVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDisableVgwRoutePropagation = "DisableVgwRoutePropagation"

// DisableVgwRoutePropagationRequest generates a request for the DisableVgwRoutePropagation operation.
func (c *EC2) DisableVgwRoutePropagationRequest(input *DisableVgwRoutePropagationInput) (req *request.Request, output *DisableVgwRoutePropagationOutput) {
	op := &request.Operation{
		Name:       opDisableVgwRoutePropagation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVgwRoutePropagationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableVgwRoutePropagationOutput{}
	req.Data = output
	return
}

// Disables a virtual private gateway (VGW) from propagating routes to a specified
// route table of a VPC.
func (c *EC2) DisableVgwRoutePropagation(input *DisableVgwRoutePropagationInput) (*DisableVgwRoutePropagationOutput, error) {
	req, out := c.DisableVgwRoutePropagationRequest(input)
	err := req.Send()
	return out, err
}

const opDisableVpcClassicLink = "DisableVpcClassicLink"

// DisableVpcClassicLinkRequest generates a request for the DisableVpcClassicLink operation.
func (c *EC2) DisableVpcClassicLinkRequest(input *DisableVpcClassicLinkInput) (req *request.Request, output *DisableVpcClassicLinkOutput) {
	op := &request.Operation{
		Name:       opDisableVpcClassicLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVpcClassicLinkInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableVpcClassicLinkOutput{}
	req.Data = output
	return
}

// Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC
// that has EC2-Classic instances linked to it.
func (c *EC2) DisableVpcClassicLink(input *DisableVpcClassicLinkInput) (*DisableVpcClassicLinkOutput, error) {
	req, out := c.DisableVpcClassicLinkRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateAddress = "DisassociateAddress"

// DisassociateAddressRequest generates a request for the DisassociateAddress operation.
func (c *EC2) DisassociateAddressRequest(input *DisassociateAddressInput) (req *request.Request, output *DisassociateAddressOutput) {
	op := &request.Operation{
		Name:       opDisassociateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisassociateAddressOutput{}
	req.Data = output
	return
}

// Disassociates an Elastic IP address from the instance or network interface
// it's associated with.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// This is an idempotent operation. If you perform the operation more than
// once, Amazon EC2 doesn't return an error.
func (c *EC2) DisassociateAddress(input *DisassociateAddressInput) (*DisassociateAddressOutput, error) {
	req, out := c.DisassociateAddressRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateRouteTable = "DisassociateRouteTable"

// DisassociateRouteTableRequest generates a request for the DisassociateRouteTable operation.
func (c *EC2) DisassociateRouteTableRequest(input *DisassociateRouteTableInput) (req *request.Request, output *DisassociateRouteTableOutput) {
	op := &request.Operation{
		Name:       opDisassociateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateRouteTableInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisassociateRouteTableOutput{}
	req.Data = output
	return
}

// Disassociates a subnet from a route table.
//
// After you perform this action, the subnet no longer uses the routes in the
// route table. Instead, it uses the routes in the VPC's main route table. For
// more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) DisassociateRouteTable(input *DisassociateRouteTableInput) (*DisassociateRouteTableOutput, error) {
	req, out := c.DisassociateRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opEnableVgwRoutePropagation = "EnableVgwRoutePropagation"

// EnableVgwRoutePropagationRequest generates a request for the EnableVgwRoutePropagation operation.
func (c *EC2) EnableVgwRoutePropagationRequest(input *EnableVgwRoutePropagationInput) (req *request.Request, output *EnableVgwRoutePropagationOutput) {
	op := &request.Operation{
		Name:       opEnableVgwRoutePropagation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableVgwRoutePropagationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableVgwRoutePropagationOutput{}
	req.Data = output
	return
}

// Enables a virtual private gateway (VGW) to propagate routes to the specified
// route table of a VPC.
func (c *EC2) EnableVgwRoutePropagation(input *EnableVgwRoutePropagationInput) (*EnableVgwRoutePropagationOutput, error) {
	req, out := c.EnableVgwRoutePropagationRequest(input)
	err := req.Send()
	return out, err
}

const opEnableVolumeIO = "EnableVolumeIO"

// EnableVolumeIORequest generates a request for the EnableVolumeIO operation.
func (c *EC2) EnableVolumeIORequest(input *EnableVolumeIOInput) (req *request.Request, output *EnableVolumeIOOutput) {
	op := &request.Operation{
		Name:       opEnableVolumeIO,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableVolumeIOInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableVolumeIOOutput{}
	req.Data = output
	return
}

// Enables I/O operations for a volume that had I/O operations disabled because
// the data on the volume was potentially inconsistent.
func (c *EC2) EnableVolumeIO(input *EnableVolumeIOInput) (*EnableVolumeIOOutput, error) {
	req, out := c.EnableVolumeIORequest(input)
	err := req.Send()
	return out, err
}

const opEnableVpcClassicLink = "EnableVpcClassicLink"

// EnableVpcClassicLinkRequest generates a request for the EnableVpcClassicLink operation.
func (c *EC2) EnableVpcClassicLinkRequest(input *EnableVpcClassicLinkInput) (req *request.Request, output *EnableVpcClassicLinkOutput) {
	op := &request.Operation{
		Name:       opEnableVpcClassicLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableVpcClassicLinkInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableVpcClassicLinkOutput{}
	req.Data = output
	return
}

// Enables a VPC for ClassicLink. You can then link EC2-Classic instances to
// your ClassicLink-enabled VPC to allow communication over private IP addresses.
// You cannot enable your VPC for ClassicLink if any of your VPC's route tables
// have existing routes for address ranges within the 10.0.0.0/8 IP address
// range, excluding local routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16
// IP address ranges. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) EnableVpcClassicLink(input *EnableVpcClassicLinkInput) (*EnableVpcClassicLinkOutput, error) {
	req, out := c.EnableVpcClassicLinkRequest(input)
	err := req.Send()
	return out, err
}

const opGetConsoleOutput = "GetConsoleOutput"

// GetConsoleOutputRequest generates a request for the GetConsoleOutput operation.
func (c *EC2) GetConsoleOutputRequest(input *GetConsoleOutputInput) (req *request.Request, output *GetConsoleOutputOutput) {
	op := &request.Operation{
		Name:       opGetConsoleOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConsoleOutputInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetConsoleOutputOutput{}
	req.Data = output
	return
}

// Gets the console output for the specified instance.
//
// Instances do not have a physical monitor through which you can view their
// console output. They also lack physical controls that allow you to power
// up, reboot, or shut them down. To allow these actions, we provide them through
// the Amazon EC2 API and command line interface.
//
// Instance console output is buffered and posted shortly after instance boot,
// reboot, and termination. Amazon EC2 preserves the most recent 64 KB output
// which is available for at least one hour after the most recent post.
//
// For Linux instances, the instance console output displays the exact console
// output that would normally be displayed on a physical monitor attached to
// a computer. This output is buffered because the instance produces it and
// then posts it to a store where the instance's owner can retrieve it.
//
// For Windows instances, the instance console output includes output from
// the EC2Config service.
func (c *EC2) GetConsoleOutput(input *GetConsoleOutputInput) (*GetConsoleOutputOutput, error) {
	req, out := c.GetConsoleOutputRequest(input)
	err := req.Send()
	return out, err
}

const opGetPasswordData = "GetPasswordData"

// GetPasswordDataRequest generates a request for the GetPasswordData operation.
func (c *EC2) GetPasswordDataRequest(input *GetPasswordDataInput) (req *request.Request, output *GetPasswordDataOutput) {
	op := &request.Operation{
		Name:       opGetPasswordData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPasswordDataInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPasswordDataOutput{}
	req.Data = output
	return
}

// Retrieves the encrypted administrator password for an instance running Windows.
//
// The Windows password is generated at boot if the EC2Config service plugin,
// Ec2SetPassword, is enabled. This usually only happens the first time an AMI
// is launched, and then Ec2SetPassword is automatically disabled. The password
// is not generated for rebundled AMIs unless Ec2SetPassword is enabled before
// bundling.
//
// The password is encrypted using the key pair that you specified when you
// launched the instance. You must provide the corresponding key pair file.
//
// Password generation and encryption takes a few moments. We recommend that
// you wait up to 15 minutes after launching an instance before trying to retrieve
// the generated password.
func (c *EC2) GetPasswordData(input *GetPasswordDataInput) (*GetPasswordDataOutput, error) {
	req, out := c.GetPasswordDataRequest(input)
	err := req.Send()
	return out, err
}

const opImportImage = "ImportImage"

// ImportImageRequest generates a request for the ImportImage operation.
func (c *EC2) ImportImageRequest(input *ImportImageInput) (req *request.Request, output *ImportImageOutput) {
	op := &request.Operation{
		Name:       opImportImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportImageOutput{}
	req.Data = output
	return
}

// Import single or multi-volume disk images or EBS snapshots into an Amazon
// Machine Image (AMI).
func (c *EC2) ImportImage(input *ImportImageInput) (*ImportImageOutput, error) {
	req, out := c.ImportImageRequest(input)
	err := req.Send()
	return out, err
}

const opImportInstance = "ImportInstance"

// ImportInstanceRequest generates a request for the ImportInstance operation.
func (c *EC2) ImportInstanceRequest(input *ImportInstanceInput) (req *request.Request, output *ImportInstanceOutput) {
	op := &request.Operation{
		Name:       opImportInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportInstanceOutput{}
	req.Data = output
	return
}

// Creates an import instance task using metadata from the specified disk image.
// ImportInstance only supports single-volume VMs. To import multi-volume VMs,
// use ImportImage. After importing the image, you then upload it using the
// ec2-import-volume command in the EC2 command line tools. For more information,
// see Using the Command Line Tools to Import Your Virtual Machine to Amazon
// EC2 (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UploadingYourInstancesandVolumes.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) ImportInstance(input *ImportInstanceInput) (*ImportInstanceOutput, error) {
	req, out := c.ImportInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest generates a request for the ImportKeyPair operation.
func (c *EC2) ImportKeyPairRequest(input *ImportKeyPairInput) (req *request.Request, output *ImportKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportKeyPairOutput{}
	req.Data = output
	return
}

// Imports the public key from an RSA key pair that you created with a third-party
// tool. Compare this with CreateKeyPair, in which AWS creates the key pair
// and gives the keys to you (AWS keeps a copy of the public key). With ImportKeyPair,
// you create the key pair and give AWS just the public key. The private key
// is never transferred between you and AWS.
//
// For more information about key pairs, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) ImportKeyPair(input *ImportKeyPairInput) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	err := req.Send()
	return out, err
}

const opImportSnapshot = "ImportSnapshot"

// ImportSnapshotRequest generates a request for the ImportSnapshot operation.
func (c *EC2) ImportSnapshotRequest(input *ImportSnapshotInput) (req *request.Request, output *ImportSnapshotOutput) {
	op := &request.Operation{
		Name:       opImportSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportSnapshotOutput{}
	req.Data = output
	return
}

// Imports a disk into an EBS snapshot.
func (c *EC2) ImportSnapshot(input *ImportSnapshotInput) (*ImportSnapshotOutput, error) {
	req, out := c.ImportSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opImportVolume = "ImportVolume"

// ImportVolumeRequest generates a request for the ImportVolume operation.
func (c *EC2) ImportVolumeRequest(input *ImportVolumeInput) (req *request.Request, output *ImportVolumeOutput) {
	op := &request.Operation{
		Name:       opImportVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportVolumeOutput{}
	req.Data = output
	return
}

// Creates an import volume task using metadata from the specified disk image.
// After importing the image, you then upload it using the ec2-import-volume
// command in the Amazon EC2 command-line interface (CLI) tools. For more information,
// see Using the Command Line Tools to Import Your Virtual Machine to Amazon
// EC2 (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UploadingYourInstancesandVolumes.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) ImportVolume(input *ImportVolumeInput) (*ImportVolumeOutput, error) {
	req, out := c.ImportVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyHosts = "ModifyHosts"

// ModifyHostsRequest generates a request for the ModifyHosts operation.
func (c *EC2) ModifyHostsRequest(input *ModifyHostsInput) (req *request.Request, output *ModifyHostsOutput) {
	op := &request.Operation{
		Name:       opModifyHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHostsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyHostsOutput{}
	req.Data = output
	return
}

// Modify the auto-placement setting of a Dedicated host. When auto-placement
// is enabled, AWS will place instances that you launch with a tenancy of host,
// but without targeting a specific host ID, onto any available Dedicated host
// in your account which has auto-placement enabled. When auto-placement is
// disabled, you need to provide a host ID if you want the instance to launch
// onto a specific host. If no host ID is provided, the instance will be launched
// onto a suitable host which has auto-placement enabled.
func (c *EC2) ModifyHosts(input *ModifyHostsInput) (*ModifyHostsOutput, error) {
	req, out := c.ModifyHostsRequest(input)
	err := req.Send()
	return out, err
}

const opModifyIdFormat = "ModifyIdFormat"

// ModifyIdFormatRequest generates a request for the ModifyIdFormat operation.
func (c *EC2) ModifyIdFormatRequest(input *ModifyIdFormatInput) (req *request.Request, output *ModifyIdFormatOutput) {
	op := &request.Operation{
		Name:       opModifyIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyIdFormatInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyIdFormatOutput{}
	req.Data = output
	return
}

// Important: This command is reserved for future use, and is currently not
// available for you to use.
//
// Modifies the ID format for the specified resource. You can specify that
// resources should receive longer IDs (17-character IDs) when they are created.
// The following resource types support longer IDs: instance | reservation.
//
// This setting applies to the IAM user who makes the request; it does not
// apply to the entire AWS account. By default, an IAM user defaults to the
// same settings as the root user, unless they explicitly override the settings
// by running this request. These settings are applied on a per-region basis.
func (c *EC2) ModifyIdFormat(input *ModifyIdFormatInput) (*ModifyIdFormatOutput, error) {
	req, out := c.ModifyIdFormatRequest(input)
	err := req.Send()
	return out, err
}

const opModifyImageAttribute = "ModifyImageAttribute"

// ModifyImageAttributeRequest generates a request for the ModifyImageAttribute operation.
func (c *EC2) ModifyImageAttributeRequest(input *ModifyImageAttributeInput) (req *request.Request, output *ModifyImageAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyImageAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyImageAttributeOutput{}
	req.Data = output
	return
}

// Modifies the specified attribute of the specified AMI. You can specify only
// one attribute at a time.
//
// AWS Marketplace product codes cannot be modified. Images with an AWS Marketplace
// product code cannot be made public.
func (c *EC2) ModifyImageAttribute(input *ModifyImageAttributeInput) (*ModifyImageAttributeOutput, error) {
	req, out := c.ModifyImageAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyInstanceAttribute = "ModifyInstanceAttribute"

// ModifyInstanceAttributeRequest generates a request for the ModifyInstanceAttribute operation.
func (c *EC2) ModifyInstanceAttributeRequest(input *ModifyInstanceAttributeInput) (req *request.Request, output *ModifyInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyInstanceAttributeOutput{}
	req.Data = output
	return
}

// Modifies the specified attribute of the specified instance. You can specify
// only one attribute at a time.
//
// To modify some attributes, the instance must be stopped. For more information,
// see Modifying Attributes of a Stopped Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) ModifyInstanceAttribute(input *ModifyInstanceAttributeInput) (*ModifyInstanceAttributeOutput, error) {
	req, out := c.ModifyInstanceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyInstancePlacement = "ModifyInstancePlacement"

// ModifyInstancePlacementRequest generates a request for the ModifyInstancePlacement operation.
func (c *EC2) ModifyInstancePlacementRequest(input *ModifyInstancePlacementInput) (req *request.Request, output *ModifyInstancePlacementOutput) {
	op := &request.Operation{
		Name:       opModifyInstancePlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstancePlacementInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyInstancePlacementOutput{}
	req.Data = output
	return
}

// Set the instance affinity value for a specific stopped instance and modify
// the instance tenancy setting.
//
// Instance affinity is disabled by default. When instance affinity is host
// and it is not associated with a specific Dedicated host, the next time it
// is launched it will automatically be associated with the host it lands on.
// This relationship will persist if the instance is stopped/started, or rebooted.
//
// You can modify the host ID associated with a stopped instance. If a stopped
// instance has a new host ID association, the instance will target that host
// when restarted.
//
// You can modify the tenancy of a stopped instance with a tenancy of host
// or dedicated.
//
// Affinity, hostID, and tenancy are not required parameters, but at least
// one of them must be specified in the request. Affinity and tenancy can be
// modified in the same request, but tenancy can only be modified on instances
// that are stopped.
func (c *EC2) ModifyInstancePlacement(input *ModifyInstancePlacementInput) (*ModifyInstancePlacementOutput, error) {
	req, out := c.ModifyInstancePlacementRequest(input)
	err := req.Send()
	return out, err
}

const opModifyNetworkInterfaceAttribute = "ModifyNetworkInterfaceAttribute"

// ModifyNetworkInterfaceAttributeRequest generates a request for the ModifyNetworkInterfaceAttribute operation.
func (c *EC2) ModifyNetworkInterfaceAttributeRequest(input *ModifyNetworkInterfaceAttributeInput) (req *request.Request, output *ModifyNetworkInterfaceAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyNetworkInterfaceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyNetworkInterfaceAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyNetworkInterfaceAttributeOutput{}
	req.Data = output
	return
}

// Modifies the specified network interface attribute. You can specify only
// one attribute at a time.
func (c *EC2) ModifyNetworkInterfaceAttribute(input *ModifyNetworkInterfaceAttributeInput) (*ModifyNetworkInterfaceAttributeOutput, error) {
	req, out := c.ModifyNetworkInterfaceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyReservedInstances = "ModifyReservedInstances"

// ModifyReservedInstancesRequest generates a request for the ModifyReservedInstances operation.
func (c *EC2) ModifyReservedInstancesRequest(input *ModifyReservedInstancesInput) (req *request.Request, output *ModifyReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opModifyReservedInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReservedInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyReservedInstancesOutput{}
	req.Data = output
	return
}

// Modifies the Availability Zone, instance count, instance type, or network
// platform (EC2-Classic or EC2-VPC) of your Reserved instances. The Reserved
// instances to be modified must be identical, except for Availability Zone,
// network platform, and instance type.
//
// For more information, see Modifying Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) ModifyReservedInstances(input *ModifyReservedInstancesInput) (*ModifyReservedInstancesOutput, error) {
	req, out := c.ModifyReservedInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opModifySnapshotAttribute = "ModifySnapshotAttribute"

// ModifySnapshotAttributeRequest generates a request for the ModifySnapshotAttribute operation.
func (c *EC2) ModifySnapshotAttributeRequest(input *ModifySnapshotAttributeInput) (req *request.Request, output *ModifySnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifySnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySnapshotAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifySnapshotAttributeOutput{}
	req.Data = output
	return
}

// Adds or removes permission settings for the specified snapshot. You may add
// or remove specified AWS account IDs from a snapshot's list of create volume
// permissions, but you cannot do both in a single API call. If you need to
// both add and remove account IDs for a snapshot, you must use multiple API
// calls.
//
// For more information on modifying snapshot permissions, see Sharing Snapshots
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//  Snapshots with AWS Marketplace product codes cannot be made public.
func (c *EC2) ModifySnapshotAttribute(input *ModifySnapshotAttributeInput) (*ModifySnapshotAttributeOutput, error) {
	req, out := c.ModifySnapshotAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifySpotFleetRequest = "ModifySpotFleetRequest"

// ModifySpotFleetRequestRequest generates a request for the ModifySpotFleetRequest operation.
func (c *EC2) ModifySpotFleetRequestRequest(input *ModifySpotFleetRequestInput) (req *request.Request, output *ModifySpotFleetRequestOutput) {
	op := &request.Operation{
		Name:       opModifySpotFleetRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySpotFleetRequestInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifySpotFleetRequestOutput{}
	req.Data = output
	return
}

// Modifies the specified Spot fleet request.
//
// While the Spot fleet request is being modified, it is in the modifying state.
//
// To scale up your Spot fleet, increase its target capacity. The Spot fleet
// launches the additional Spot instances according to the allocation strategy
// for the Spot fleet request. If the allocation strategy is lowestPrice, the
// Spot fleet launches instances using the Spot pool with the lowest price.
// If the allocation strategy is diversified, the Spot fleet distributes the
// instances across the Spot pools.
//
// To scale down your Spot fleet, decrease its target capacity. First, the
// Spot fleet cancels any open bids that exceed the new target capacity. You
// can request that the Spot fleet terminate Spot instances until the size of
// the fleet no longer exceeds the new target capacity. If the allocation strategy
// is lowestPrice, the Spot fleet terminates the instances with the highest
// price per unit. If the allocation strategy is diversified, the Spot fleet
// terminates instances across the Spot pools. Alternatively, you can request
// that the Spot fleet keep the fleet at its current size, but not replace any
// Spot instances that are interrupted or that you terminate manually.
func (c *EC2) ModifySpotFleetRequest(input *ModifySpotFleetRequestInput) (*ModifySpotFleetRequestOutput, error) {
	req, out := c.ModifySpotFleetRequestRequest(input)
	err := req.Send()
	return out, err
}

const opModifySubnetAttribute = "ModifySubnetAttribute"

// ModifySubnetAttributeRequest generates a request for the ModifySubnetAttribute operation.
func (c *EC2) ModifySubnetAttributeRequest(input *ModifySubnetAttributeInput) (req *request.Request, output *ModifySubnetAttributeOutput) {
	op := &request.Operation{
		Name:       opModifySubnetAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySubnetAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifySubnetAttributeOutput{}
	req.Data = output
	return
}

// Modifies a subnet attribute.
func (c *EC2) ModifySubnetAttribute(input *ModifySubnetAttributeInput) (*ModifySubnetAttributeOutput, error) {
	req, out := c.ModifySubnetAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyVolumeAttribute = "ModifyVolumeAttribute"

// ModifyVolumeAttributeRequest generates a request for the ModifyVolumeAttribute operation.
func (c *EC2) ModifyVolumeAttributeRequest(input *ModifyVolumeAttributeInput) (req *request.Request, output *ModifyVolumeAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyVolumeAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVolumeAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyVolumeAttributeOutput{}
	req.Data = output
	return
}

// Modifies a volume attribute.
//
// By default, all I/O operations for the volume are suspended when the data
// on the volume is determined to be potentially inconsistent, to prevent undetectable,
// latent data corruption. The I/O access to the volume can be resumed by first
// enabling I/O access and then checking the data consistency on your volume.
//
// You can change the default behavior to resume I/O operations. We recommend
// that you change this only for boot volumes or for volumes that are stateless
// or disposable.
func (c *EC2) ModifyVolumeAttribute(input *ModifyVolumeAttributeInput) (*ModifyVolumeAttributeOutput, error) {
	req, out := c.ModifyVolumeAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyVpcAttribute = "ModifyVpcAttribute"

// ModifyVpcAttributeRequest generates a request for the ModifyVpcAttribute operation.
func (c *EC2) ModifyVpcAttributeRequest(input *ModifyVpcAttributeInput) (req *request.Request, output *ModifyVpcAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyVpcAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpcAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyVpcAttributeOutput{}
	req.Data = output
	return
}

// Modifies the specified attribute of the specified VPC.
func (c *EC2) ModifyVpcAttribute(input *ModifyVpcAttributeInput) (*ModifyVpcAttributeOutput, error) {
	req, out := c.ModifyVpcAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyVpcEndpoint = "ModifyVpcEndpoint"

// ModifyVpcEndpointRequest generates a request for the ModifyVpcEndpoint operation.
func (c *EC2) ModifyVpcEndpointRequest(input *ModifyVpcEndpointInput) (req *request.Request, output *ModifyVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opModifyVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpcEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyVpcEndpointOutput{}
	req.Data = output
	return
}

// Modifies attributes of a specified VPC endpoint. You can modify the policy
// associated with the endpoint, and you can add and remove route tables associated
// with the endpoint.
func (c *EC2) ModifyVpcEndpoint(input *ModifyVpcEndpointInput) (*ModifyVpcEndpointOutput, error) {
	req, out := c.ModifyVpcEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opMonitorInstances = "MonitorInstances"

// MonitorInstancesRequest generates a request for the MonitorInstances operation.
func (c *EC2) MonitorInstancesRequest(input *MonitorInstancesInput) (req *request.Request, output *MonitorInstancesOutput) {
	op := &request.Operation{
		Name:       opMonitorInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MonitorInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &MonitorInstancesOutput{}
	req.Data = output
	return
}

// Enables monitoring for a running instance. For more information about monitoring
// instances, see Monitoring Your Instances and Volumes (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) MonitorInstances(input *MonitorInstancesInput) (*MonitorInstancesOutput, error) {
	req, out := c.MonitorInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opMoveAddressToVpc = "MoveAddressToVpc"

// MoveAddressToVpcRequest generates a request for the MoveAddressToVpc operation.
func (c *EC2) MoveAddressToVpcRequest(input *MoveAddressToVpcInput) (req *request.Request, output *MoveAddressToVpcOutput) {
	op := &request.Operation{
		Name:       opMoveAddressToVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MoveAddressToVpcInput{}
	}

	req = c.newRequest(op, input, output)
	output = &MoveAddressToVpcOutput{}
	req.Data = output
	return
}

// Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC
// platform. The Elastic IP address must be allocated to your account, and it
// must not be associated with an instance. After the Elastic IP address is
// moved, it is no longer available for use in the EC2-Classic platform, unless
// you move it back using the RestoreAddressToClassic request. You cannot move
// an Elastic IP address that's allocated for use in the EC2-VPC platform to
// the EC2-Classic platform.
func (c *EC2) MoveAddressToVpc(input *MoveAddressToVpcInput) (*MoveAddressToVpcOutput, error) {
	req, out := c.MoveAddressToVpcRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseReservedInstancesOffering = "PurchaseReservedInstancesOffering"

// PurchaseReservedInstancesOfferingRequest generates a request for the PurchaseReservedInstancesOffering operation.
func (c *EC2) PurchaseReservedInstancesOfferingRequest(input *PurchaseReservedInstancesOfferingInput) (req *request.Request, output *PurchaseReservedInstancesOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedInstancesOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedInstancesOfferingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PurchaseReservedInstancesOfferingOutput{}
	req.Data = output
	return
}

// Purchases a Reserved instance for use with your account. With Amazon EC2
// Reserved instances, you obtain a capacity reservation for a certain instance
// configuration over a specified period of time and pay a lower hourly rate
// compared to On-Demand Instance pricing.
//
// Use DescribeReservedInstancesOfferings to get a list of Reserved instance
// offerings that match your specifications. After you've purchased a Reserved
// instance, you can check for your new Reserved instance with DescribeReservedInstances.
//
// For more information, see Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html)
// and Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) PurchaseReservedInstancesOffering(input *PurchaseReservedInstancesOfferingInput) (*PurchaseReservedInstancesOfferingOutput, error) {
	req, out := c.PurchaseReservedInstancesOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opRebootInstances = "RebootInstances"

// RebootInstancesRequest generates a request for the RebootInstances operation.
func (c *EC2) RebootInstancesRequest(input *RebootInstancesInput) (req *request.Request, output *RebootInstancesOutput) {
	op := &request.Operation{
		Name:       opRebootInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RebootInstancesOutput{}
	req.Data = output
	return
}

// Requests a reboot of one or more instances. This operation is asynchronous;
// it only queues a request to reboot the specified instances. The operation
// succeeds if the instances are valid and belong to you. Requests to reboot
// terminated instances are ignored.
//
// If a Linux/Unix instance does not cleanly shut down within four minutes,
// Amazon EC2 performs a hard reboot.
//
// For more information about troubleshooting, see Getting Console Output and
// Rebooting Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) RebootInstances(input *RebootInstancesInput) (*RebootInstancesOutput, error) {
	req, out := c.RebootInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterImage = "RegisterImage"

// RegisterImageRequest generates a request for the RegisterImage operation.
func (c *EC2) RegisterImageRequest(input *RegisterImageInput) (req *request.Request, output *RegisterImageOutput) {
	op := &request.Operation{
		Name:       opRegisterImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterImageOutput{}
	req.Data = output
	return
}

// Registers an AMI. When you're creating an AMI, this is the final step you
// must complete before you can launch an instance from the AMI. For more information
// about creating AMIs, see Creating Your Own AMIs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For Amazon EBS-backed instances, CreateImage creates and registers the AMI
// in a single request, so you don't have to register the AMI yourself.
//
// You can also use RegisterImage to create an Amazon EBS-backed Linux AMI
// from a snapshot of a root device volume. For more information, see Launching
// an Instance from a Snapshot (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_LaunchingInstanceFromSnapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//  Some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE
// Linux Enterprise Server (SLES), use the EC2 billingProduct code associated
// with an AMI to verify subscription status for package updates. Creating an
// AMI from an EBS snapshot does not maintain this billing code, and subsequent
// instances launched from such an AMI will not be able to connect to package
// update infrastructure.
//
// Similarly, although you can create a Windows AMI from a snapshot, you can't
// successfully launch an instance from the AMI.
//
// To create Windows AMIs or to create AMIs for Linux operating systems that
// must retain AMI billing codes to work properly, see CreateImage.
//
//  If needed, you can deregister an AMI at any time. Any modifications you
// make to an AMI backed by an instance store volume invalidates its registration.
// If you make changes to an image, deregister the previous image and register
// the new image.
//
// You can't register an image where a secondary (non-root) snapshot has AWS
// Marketplace product codes.
func (c *EC2) RegisterImage(input *RegisterImageInput) (*RegisterImageOutput, error) {
	req, out := c.RegisterImageRequest(input)
	err := req.Send()
	return out, err
}

const opRejectVpcPeeringConnection = "RejectVpcPeeringConnection"

// RejectVpcPeeringConnectionRequest generates a request for the RejectVpcPeeringConnection operation.
func (c *EC2) RejectVpcPeeringConnectionRequest(input *RejectVpcPeeringConnectionInput) (req *request.Request, output *RejectVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opRejectVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectVpcPeeringConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RejectVpcPeeringConnectionOutput{}
	req.Data = output
	return
}

// Rejects a VPC peering connection request. The VPC peering connection must
// be in the pending-acceptance state. Use the DescribeVpcPeeringConnections
// request to view your outstanding VPC peering connection requests. To delete
// an active VPC peering connection, or to delete a VPC peering connection request
// that you initiated, use DeleteVpcPeeringConnection.
func (c *EC2) RejectVpcPeeringConnection(input *RejectVpcPeeringConnectionInput) (*RejectVpcPeeringConnectionOutput, error) {
	req, out := c.RejectVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opReleaseAddress = "ReleaseAddress"

// ReleaseAddressRequest generates a request for the ReleaseAddress operation.
func (c *EC2) ReleaseAddressRequest(input *ReleaseAddressInput) (req *request.Request, output *ReleaseAddressOutput) {
	op := &request.Operation{
		Name:       opReleaseAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleaseAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReleaseAddressOutput{}
	req.Data = output
	return
}

// Releases the specified Elastic IP address.
//
// After releasing an Elastic IP address, it is released to the IP address
// pool and might be unavailable to you. Be sure to update your DNS records
// and any servers or devices that communicate with the address. If you attempt
// to release an Elastic IP address that you already released, you'll get an
// AuthFailure error if the address is already allocated to another AWS account.
//
// [EC2-Classic, default VPC] Releasing an Elastic IP address automatically
// disassociates it from any instance that it's associated with. To disassociate
// an Elastic IP address without releasing it, use DisassociateAddress.
//
// [Nondefault VPC] You must use DisassociateAddress to disassociate the Elastic
// IP address before you try to release it. Otherwise, Amazon EC2 returns an
// error (InvalidIPAddress.InUse).
func (c *EC2) ReleaseAddress(input *ReleaseAddressInput) (*ReleaseAddressOutput, error) {
	req, out := c.ReleaseAddressRequest(input)
	err := req.Send()
	return out, err
}

const opReleaseHosts = "ReleaseHosts"

// ReleaseHostsRequest generates a request for the ReleaseHosts operation.
func (c *EC2) ReleaseHostsRequest(input *ReleaseHostsInput) (req *request.Request, output *ReleaseHostsOutput) {
	op := &request.Operation{
		Name:       opReleaseHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleaseHostsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReleaseHostsOutput{}
	req.Data = output
	return
}

// When you no longer want to use a Dedicated host it can be released. On-Demand
// billing is stopped and the host goes into released state. The host ID of
// Dedicated hosts that have been released can no longer be specified in another
// request, e.g., ModifyHosts. You must stop or terminate all instances on a
// host before it can be released.
//
// When Dedicated hosts are released, it make take some time for them to stop
// counting toward your limit and you may receive capacity errors when trying
// to allocate new Dedicated hosts. Try waiting a few minutes, and then try
// again.
//
// Released hosts will still appear in a DescribeHosts response.
func (c *EC2) ReleaseHosts(input *ReleaseHostsInput) (*ReleaseHostsOutput, error) {
	req, out := c.ReleaseHostsRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceNetworkAclAssociation = "ReplaceNetworkAclAssociation"

// ReplaceNetworkAclAssociationRequest generates a request for the ReplaceNetworkAclAssociation operation.
func (c *EC2) ReplaceNetworkAclAssociationRequest(input *ReplaceNetworkAclAssociationInput) (req *request.Request, output *ReplaceNetworkAclAssociationOutput) {
	op := &request.Operation{
		Name:       opReplaceNetworkAclAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceNetworkAclAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReplaceNetworkAclAssociationOutput{}
	req.Data = output
	return
}

// Changes which network ACL a subnet is associated with. By default when you
// create a subnet, it's automatically associated with the default network ACL.
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) ReplaceNetworkAclAssociation(input *ReplaceNetworkAclAssociationInput) (*ReplaceNetworkAclAssociationOutput, error) {
	req, out := c.ReplaceNetworkAclAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceNetworkAclEntry = "ReplaceNetworkAclEntry"

// ReplaceNetworkAclEntryRequest generates a request for the ReplaceNetworkAclEntry operation.
func (c *EC2) ReplaceNetworkAclEntryRequest(input *ReplaceNetworkAclEntryInput) (req *request.Request, output *ReplaceNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opReplaceNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceNetworkAclEntryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReplaceNetworkAclEntryOutput{}
	req.Data = output
	return
}

// Replaces an entry (rule) in a network ACL. For more information about network
// ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) ReplaceNetworkAclEntry(input *ReplaceNetworkAclEntryInput) (*ReplaceNetworkAclEntryOutput, error) {
	req, out := c.ReplaceNetworkAclEntryRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceRoute = "ReplaceRoute"

// ReplaceRouteRequest generates a request for the ReplaceRoute operation.
func (c *EC2) ReplaceRouteRequest(input *ReplaceRouteInput) (req *request.Request, output *ReplaceRouteOutput) {
	op := &request.Operation{
		Name:       opReplaceRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceRouteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReplaceRouteOutput{}
	req.Data = output
	return
}

// Replaces an existing route within a route table in a VPC. You must provide
// only one of the following: Internet gateway or virtual private gateway, NAT
// instance, NAT gateway, VPC peering connection, or network interface.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) ReplaceRoute(input *ReplaceRouteInput) (*ReplaceRouteOutput, error) {
	req, out := c.ReplaceRouteRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceRouteTableAssociation = "ReplaceRouteTableAssociation"

// ReplaceRouteTableAssociationRequest generates a request for the ReplaceRouteTableAssociation operation.
func (c *EC2) ReplaceRouteTableAssociationRequest(input *ReplaceRouteTableAssociationInput) (req *request.Request, output *ReplaceRouteTableAssociationOutput) {
	op := &request.Operation{
		Name:       opReplaceRouteTableAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceRouteTableAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReplaceRouteTableAssociationOutput{}
	req.Data = output
	return
}

// Changes the route table associated with a given subnet in a VPC. After the
// operation completes, the subnet uses the routes in the new route table it's
// associated with. For more information about route tables, see Route Tables
// (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can also use ReplaceRouteTableAssociation to change which table is the
// main route table in the VPC. You just specify the main route table's association
// ID and the route table to be the new main route table.
func (c *EC2) ReplaceRouteTableAssociation(input *ReplaceRouteTableAssociationInput) (*ReplaceRouteTableAssociationOutput, error) {
	req, out := c.ReplaceRouteTableAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opReportInstanceStatus = "ReportInstanceStatus"

// ReportInstanceStatusRequest generates a request for the ReportInstanceStatus operation.
func (c *EC2) ReportInstanceStatusRequest(input *ReportInstanceStatusInput) (req *request.Request, output *ReportInstanceStatusOutput) {
	op := &request.Operation{
		Name:       opReportInstanceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReportInstanceStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReportInstanceStatusOutput{}
	req.Data = output
	return
}

// Submits feedback about the status of an instance. The instance must be in
// the running state. If your experience with the instance differs from the
// instance status returned by DescribeInstanceStatus, use ReportInstanceStatus
// to report your experience with the instance. Amazon EC2 collects this information
// to improve the accuracy of status checks.
//
// Use of this action does not change the value returned by DescribeInstanceStatus.
func (c *EC2) ReportInstanceStatus(input *ReportInstanceStatusInput) (*ReportInstanceStatusOutput, error) {
	req, out := c.ReportInstanceStatusRequest(input)
	err := req.Send()
	return out, err
}

const opRequestSpotFleet = "RequestSpotFleet"

// RequestSpotFleetRequest generates a request for the RequestSpotFleet operation.
func (c *EC2) RequestSpotFleetRequest(input *RequestSpotFleetInput) (req *request.Request, output *RequestSpotFleetOutput) {
	op := &request.Operation{
		Name:       opRequestSpotFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestSpotFleetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RequestSpotFleetOutput{}
	req.Data = output
	return
}

// Creates a Spot fleet request.
//
// You can submit a single request that includes multiple launch specifications
// that vary by instance type, AMI, Availability Zone, or subnet.
//
// By default, the Spot fleet requests Spot instances in the Spot pool where
// the price per unit is the lowest. Each launch specification can include its
// own instance weighting that reflects the value of the instance type to your
// application workload.
//
// Alternatively, you can specify that the Spot fleet distribute the target
// capacity across the Spot pools included in its launch specifications. By
// ensuring that the Spot instances in your Spot fleet are in different Spot
// pools, you can improve the availability of your fleet.
//
// For more information, see Spot Fleet Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) RequestSpotFleet(input *RequestSpotFleetInput) (*RequestSpotFleetOutput, error) {
	req, out := c.RequestSpotFleetRequest(input)
	err := req.Send()
	return out, err
}

const opRequestSpotInstances = "RequestSpotInstances"

// RequestSpotInstancesRequest generates a request for the RequestSpotInstances operation.
func (c *EC2) RequestSpotInstancesRequest(input *RequestSpotInstancesInput) (req *request.Request, output *RequestSpotInstancesOutput) {
	op := &request.Operation{
		Name:       opRequestSpotInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestSpotInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RequestSpotInstancesOutput{}
	req.Data = output
	return
}

// Creates a Spot instance request. Spot instances are instances that Amazon
// EC2 launches when the bid price that you specify exceeds the current Spot
// price. Amazon EC2 periodically sets the Spot price based on available Spot
// Instance capacity and current Spot instance requests. For more information,
// see Spot Instance Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) RequestSpotInstances(input *RequestSpotInstancesInput) (*RequestSpotInstancesOutput, error) {
	req, out := c.RequestSpotInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opResetImageAttribute = "ResetImageAttribute"

// ResetImageAttributeRequest generates a request for the ResetImageAttribute operation.
func (c *EC2) ResetImageAttributeRequest(input *ResetImageAttributeInput) (req *request.Request, output *ResetImageAttributeOutput) {
	op := &request.Operation{
		Name:       opResetImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetImageAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResetImageAttributeOutput{}
	req.Data = output
	return
}

// Resets an attribute of an AMI to its default value.
//
//  The productCodes attribute can't be reset.
func (c *EC2) ResetImageAttribute(input *ResetImageAttributeInput) (*ResetImageAttributeOutput, error) {
	req, out := c.ResetImageAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opResetInstanceAttribute = "ResetInstanceAttribute"

// ResetInstanceAttributeRequest generates a request for the ResetInstanceAttribute operation.
func (c *EC2) ResetInstanceAttributeRequest(input *ResetInstanceAttributeInput) (req *request.Request, output *ResetInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opResetInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetInstanceAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResetInstanceAttributeOutput{}
	req.Data = output
	return
}

// Resets an attribute of an instance to its default value. To reset the kernel
// or ramdisk, the instance must be in a stopped state. To reset the SourceDestCheck,
// the instance can be either running or stopped.
//
// The SourceDestCheck attribute controls whether source/destination checking
// is enabled. The default value is true, which means checking is enabled. This
// value must be false for a NAT instance to perform NAT. For more information,
// see NAT Instances (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *EC2) ResetInstanceAttribute(input *ResetInstanceAttributeInput) (*ResetInstanceAttributeOutput, error) {
	req, out := c.ResetInstanceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opResetNetworkInterfaceAttribute = "ResetNetworkInterfaceAttribute"

// ResetNetworkInterfaceAttributeRequest generates a request for the ResetNetworkInterfaceAttribute operation.
func (c *EC2) ResetNetworkInterfaceAttributeRequest(input *ResetNetworkInterfaceAttributeInput) (req *request.Request, output *ResetNetworkInterfaceAttributeOutput) {
	op := &request.Operation{
		Name:       opResetNetworkInterfaceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetNetworkInterfaceAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResetNetworkInterfaceAttributeOutput{}
	req.Data = output
	return
}

// Resets a network interface attribute. You can specify only one attribute
// at a time.
func (c *EC2) ResetNetworkInterfaceAttribute(input *ResetNetworkInterfaceAttributeInput) (*ResetNetworkInterfaceAttributeOutput, error) {
	req, out := c.ResetNetworkInterfaceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opResetSnapshotAttribute = "ResetSnapshotAttribute"

// ResetSnapshotAttributeRequest generates a request for the ResetSnapshotAttribute operation.
func (c *EC2) ResetSnapshotAttributeRequest(input *ResetSnapshotAttributeInput) (req *request.Request, output *ResetSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opResetSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetSnapshotAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResetSnapshotAttributeOutput{}
	req.Data = output
	return
}

// Resets permission settings for the specified snapshot.
//
// For more information on modifying snapshot permissions, see Sharing Snapshots
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) ResetSnapshotAttribute(input *ResetSnapshotAttributeInput) (*ResetSnapshotAttributeOutput, error) {
	req, out := c.ResetSnapshotAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreAddressToClassic = "RestoreAddressToClassic"

// RestoreAddressToClassicRequest generates a request for the RestoreAddressToClassic operation.
func (c *EC2) RestoreAddressToClassicRequest(input *RestoreAddressToClassicInput) (req *request.Request, output *RestoreAddressToClassicOutput) {
	op := &request.Operation{
		Name:       opRestoreAddressToClassic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreAddressToClassicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreAddressToClassicOutput{}
	req.Data = output
	return
}

// Restores an Elastic IP address that was previously moved to the EC2-VPC platform
// back to the EC2-Classic platform. You cannot move an Elastic IP address that
// was originally allocated for use in EC2-VPC. The Elastic IP address must
// not be associated with an instance or network interface.
func (c *EC2) RestoreAddressToClassic(input *RestoreAddressToClassicInput) (*RestoreAddressToClassicOutput, error) {
	req, out := c.RestoreAddressToClassicRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeSecurityGroupEgress = "RevokeSecurityGroupEgress"

// RevokeSecurityGroupEgressRequest generates a request for the RevokeSecurityGroupEgress operation.
func (c *EC2) RevokeSecurityGroupEgressRequest(input *RevokeSecurityGroupEgressInput) (req *request.Request, output *RevokeSecurityGroupEgressOutput) {
	op := &request.Operation{
		Name:       opRevokeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSecurityGroupEgressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeSecurityGroupEgressOutput{}
	req.Data = output
	return
}

// [EC2-VPC only] Removes one or more egress rules from a security group for
// EC2-VPC. This action doesn't apply to security groups for use in EC2-Classic.
// The values that you specify in the revoke request (for example, ports) must
// match the existing rule's values for the rule to be revoked.
//
// Each rule consists of the protocol and the CIDR range or source security
// group. For the TCP and UDP protocols, you must also specify the destination
// port or range of ports. For the ICMP protocol, you must also specify the
// ICMP type and code.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
func (c *EC2) RevokeSecurityGroupEgress(input *RevokeSecurityGroupEgressInput) (*RevokeSecurityGroupEgressOutput, error) {
	req, out := c.RevokeSecurityGroupEgressRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeSecurityGroupIngress = "RevokeSecurityGroupIngress"

// RevokeSecurityGroupIngressRequest generates a request for the RevokeSecurityGroupIngress operation.
func (c *EC2) RevokeSecurityGroupIngressRequest(input *RevokeSecurityGroupIngressInput) (req *request.Request, output *RevokeSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// Removes one or more ingress rules from a security group. The values that
// you specify in the revoke request (for example, ports) must match the existing
// rule's values for the rule to be removed.
//
// Each rule consists of the protocol and the CIDR range or source security
// group. For the TCP and UDP protocols, you must also specify the destination
// port or range of ports. For the ICMP protocol, you must also specify the
// ICMP type and code.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
func (c *EC2) RevokeSecurityGroupIngress(input *RevokeSecurityGroupIngressInput) (*RevokeSecurityGroupIngressOutput, error) {
	req, out := c.RevokeSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opRunInstances = "RunInstances"

// RunInstancesRequest generates a request for the RunInstances operation.
func (c *EC2) RunInstancesRequest(input *RunInstancesInput) (req *request.Request, output *Reservation) {
	op := &request.Operation{
		Name:       opRunInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Reservation{}
	req.Data = output
	return
}

// Launches the specified number of instances using an AMI for which you have
// permissions.
//
// When you launch an instance, it enters the pending state. After the instance
// is ready for you, it enters the running state. To check the state of your
// instance, call DescribeInstances.
//
// If you don't specify a security group when launching an instance, Amazon
// EC2 uses the default security group. For more information, see Security Groups
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// [EC2-VPC only accounts] If you don't specify a subnet in the request, we
// choose a default subnet from your default VPC for you.
//
// [EC2-Classic accounts] If you're launching into EC2-Classic and you don't
// specify an Availability Zone, we choose one for you.
//
// Linux instances have access to the public key of the key pair at boot. You
// can use this key to provide secure access to the instance. Amazon EC2 public
// images use this feature to provide secure access without passwords. For more
// information, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You can provide optional user data when launching an instance. For more
// information, see Instance Metadata (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// If any of the AMIs have a product code attached for which the user has not
// subscribed, RunInstances fails.
//
// T2 instance types can only be launched into a VPC. If you do not have a
// default VPC, or if you do not specify a subnet ID in the request, RunInstances
// fails.
//
// For more information about troubleshooting, see What To Do If An Instance
// Immediately Terminates (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html),
// and Troubleshooting Connecting to Your Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) RunInstances(input *RunInstancesInput) (*Reservation, error) {
	req, out := c.RunInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opStartInstances = "StartInstances"

// StartInstancesRequest generates a request for the StartInstances operation.
func (c *EC2) StartInstancesRequest(input *StartInstancesInput) (req *request.Request, output *StartInstancesOutput) {
	op := &request.Operation{
		Name:       opStartInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartInstancesOutput{}
	req.Data = output
	return
}

// Starts an Amazon EBS-backed AMI that you've previously stopped.
//
// Instances that use Amazon EBS volumes as their root devices can be quickly
// stopped and started. When an instance is stopped, the compute resources are
// released and you are not billed for hourly instance usage. However, your
// root partition Amazon EBS volume remains, continues to persist your data,
// and you are charged for Amazon EBS volume usage. You can restart your instance
// at any time. Each time you transition an instance from stopped to started,
// Amazon EC2 charges a full instance hour, even if transitions happen multiple
// times within a single hour.
//
// Before stopping an instance, make sure it is in a state from which it can
// be restarted. Stopping an instance does not preserve data stored in RAM.
//
// Performing this operation on an instance that uses an instance store as
// its root device returns an error.
//
// For more information, see Stopping Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) StartInstances(input *StartInstancesInput) (*StartInstancesOutput, error) {
	req, out := c.StartInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opStopInstances = "StopInstances"

// StopInstancesRequest generates a request for the StopInstances operation.
func (c *EC2) StopInstancesRequest(input *StopInstancesInput) (req *request.Request, output *StopInstancesOutput) {
	op := &request.Operation{
		Name:       opStopInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopInstancesOutput{}
	req.Data = output
	return
}

// Stops an Amazon EBS-backed instance. Each time you transition an instance
// from stopped to started, Amazon EC2 charges a full instance hour, even if
// transitions happen multiple times within a single hour.
//
// You can't start or stop Spot instances.
//
// Instances that use Amazon EBS volumes as their root devices can be quickly
// stopped and started. When an instance is stopped, the compute resources are
// released and you are not billed for hourly instance usage. However, your
// root partition Amazon EBS volume remains, continues to persist your data,
// and you are charged for Amazon EBS volume usage. You can restart your instance
// at any time.
//
// Before stopping an instance, make sure it is in a state from which it can
// be restarted. Stopping an instance does not preserve data stored in RAM.
//
// Performing this operation on an instance that uses an instance store as
// its root device returns an error.
//
// You can stop, start, and terminate EBS-backed instances. You can only terminate
// instance store-backed instances. What happens to an instance differs if you
// stop it or terminate it. For example, when you stop an instance, the root
// device and any other devices attached to the instance persist. When you terminate
// an instance, the root device and any other devices attached during the instance
// launch are automatically deleted. For more information about the differences
// between stopping and terminating instances, see Instance Lifecycle (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information about troubleshooting, see Troubleshooting Stopping
// Your Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) StopInstances(input *StopInstancesInput) (*StopInstancesOutput, error) {
	req, out := c.StopInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateInstances = "TerminateInstances"

// TerminateInstancesRequest generates a request for the TerminateInstances operation.
func (c *EC2) TerminateInstancesRequest(input *TerminateInstancesInput) (req *request.Request, output *TerminateInstancesOutput) {
	op := &request.Operation{
		Name:       opTerminateInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TerminateInstancesOutput{}
	req.Data = output
	return
}

// Shuts down one or more instances. This operation is idempotent; if you terminate
// an instance more than once, each call succeeds.
//
// Terminated instances remain visible after termination (for approximately
// one hour).
//
// By default, Amazon EC2 deletes all EBS volumes that were attached when the
// instance launched. Volumes attached after instance launch continue running.
//
// You can stop, start, and terminate EBS-backed instances. You can only terminate
// instance store-backed instances. What happens to an instance differs if you
// stop it or terminate it. For example, when you stop an instance, the root
// device and any other devices attached to the instance persist. When you terminate
// an instance, any attached EBS volumes with the DeleteOnTermination block
// device mapping parameter set to true are automatically deleted. For more
// information about the differences between stopping and terminating instances,
// see Instance Lifecycle (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information about troubleshooting, see Troubleshooting Terminating
// Your Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) TerminateInstances(input *TerminateInstancesInput) (*TerminateInstancesOutput, error) {
	req, out := c.TerminateInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opUnassignPrivateIpAddresses = "UnassignPrivateIpAddresses"

// UnassignPrivateIpAddressesRequest generates a request for the UnassignPrivateIpAddresses operation.
func (c *EC2) UnassignPrivateIpAddressesRequest(input *UnassignPrivateIpAddressesInput) (req *request.Request, output *UnassignPrivateIpAddressesOutput) {
	op := &request.Operation{
		Name:       opUnassignPrivateIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignPrivateIpAddressesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UnassignPrivateIpAddressesOutput{}
	req.Data = output
	return
}

// Unassigns one or more secondary private IP addresses from a network interface.
func (c *EC2) UnassignPrivateIpAddresses(input *UnassignPrivateIpAddressesInput) (*UnassignPrivateIpAddressesOutput, error) {
	req, out := c.UnassignPrivateIpAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opUnmonitorInstances = "UnmonitorInstances"

// UnmonitorInstancesRequest generates a request for the UnmonitorInstances operation.
func (c *EC2) UnmonitorInstancesRequest(input *UnmonitorInstancesInput) (req *request.Request, output *UnmonitorInstancesOutput) {
	op := &request.Operation{
		Name:       opUnmonitorInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnmonitorInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UnmonitorInstancesOutput{}
	req.Data = output
	return
}

// Disables monitoring for a running instance. For more information about monitoring
// instances, see Monitoring Your Instances and Volumes (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *EC2) UnmonitorInstances(input *UnmonitorInstancesInput) (*UnmonitorInstancesOutput, error) {
	req, out := c.UnmonitorInstancesRequest(input)
	err := req.Send()
	return out, err
}

type AcceptVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s AcceptVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

type AcceptVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC peering connection.
	VpcPeeringConnection *VpcPeeringConnection `locationName:"vpcPeeringConnection" type:"structure"`
}

// String returns the string representation
func (s AcceptVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

// Describes an account attribute.
type AccountAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the account attribute.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// One or more values for the account attribute.
	AttributeValues []*AccountAttributeValue `locationName:"attributeValueSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s AccountAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAttribute) GoString() string {
	return s.String()
}

// Describes a value of an account attribute.
type AccountAttributeValue struct {
	_ struct{} `type:"structure"`

	// The value of the attribute.
	AttributeValue *string `locationName:"attributeValue" type:"string"`
}

// String returns the string representation
func (s AccountAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAttributeValue) GoString() string {
	return s.String()
}

// Describes a running instance in a Spot fleet.
type ActiveInstance struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The ID of the Spot instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`
}

// String returns the string representation
func (s ActiveInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveInstance) GoString() string {
	return s.String()
}

// Describes an Elastic IP address.
type Address struct {
	_ struct{} `type:"structure"`

	// The ID representing the allocation of the address for use with EC2-VPC.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The ID representing the association of the address with an instance in a
	// VPC.
	AssociationId *string `locationName:"associationId" type:"string"`

	// Indicates whether this Elastic IP address is for use with instances in EC2-Classic
	// (standard) or instances in a VPC (vpc).
	Domain *string `locationName:"domain" type:"string" enum:"DomainType"`

	// The ID of the instance that the address is associated with (if any).
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the AWS account that owns the network interface.
	NetworkInterfaceOwnerId *string `locationName:"networkInterfaceOwnerId" type:"string"`

	// The private IP address associated with the Elastic IP address.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Address) GoString() string {
	return s.String()
}

type AllocateAddressInput struct {
	_ struct{} `type:"structure"`

	// Set to vpc to allocate the address for use with instances in a VPC.
	//
	// Default: The address is for use with instances in EC2-Classic.
	Domain *string `type:"string" enum:"DomainType"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s AllocateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateAddressInput) GoString() string {
	return s.String()
}

type AllocateAddressOutput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic
	// IP address for use with instances in a VPC.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// Indicates whether this Elastic IP address is for use with instances in EC2-Classic
	// (standard) or instances in a VPC (vpc).
	Domain *string `locationName:"domain" type:"string" enum:"DomainType"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s AllocateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateAddressOutput) GoString() string {
	return s.String()
}

type AllocateHostsInput struct {
	_ struct{} `type:"structure"`

	// This is enabled by default. This property allows instances to be automatically
	// placed onto available Dedicated hosts, when you are launching instances without
	// specifying a host ID.
	//
	// Default: Enabled
	AutoPlacement *string `locationName:"autoPlacement" type:"string" enum:"AutoPlacement"`

	// The Availability Zone for the Dedicated hosts.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specify the instance type that you want your Dedicated hosts to be configured
	// for. When you specify the instance type, that is the only instance type that
	// you can launch onto that host.
	InstanceType *string `locationName:"instanceType" type:"string" required:"true"`

	// The number of Dedicated hosts you want to allocate to your account with these
	// parameters.
	Quantity *int64 `locationName:"quantity" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateHostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateHostsInput) GoString() string {
	return s.String()
}

type AllocateHostsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the allocated Dedicated host. This is used when you want to launch
	// an instance onto a specific host.
	HostIds []*string `locationName:"hostIdSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s AllocateHostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateHostsOutput) GoString() string {
	return s.String()
}

type AssignPrivateIpAddressesInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to allow an IP address that is already assigned to another
	// network interface or instance to be reassigned to the specified network interface.
	AllowReassignment *bool `locationName:"allowReassignment" type:"boolean"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`

	// One or more IP addresses to be assigned as a secondary private IP address
	// to the network interface. You can't specify this parameter when also specifying
	// a number of secondary IP addresses.
	//
	// If you don't specify an IP address, Amazon EC2 automatically selects an
	// IP address within the subnet range.
	PrivateIpAddresses []*string `locationName:"privateIpAddress" locationNameList:"PrivateIpAddress" type:"list"`

	// The number of secondary IP addresses to assign to the network interface.
	// You can't specify this parameter when also specifying private IP addresses.
	SecondaryPrivateIpAddressCount *int64 `locationName:"secondaryPrivateIpAddressCount" type:"integer"`
}

// String returns the string representation
func (s AssignPrivateIpAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignPrivateIpAddressesInput) GoString() string {
	return s.String()
}

type AssignPrivateIpAddressesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssignPrivateIpAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignPrivateIpAddressesOutput) GoString() string {
	return s.String()
}

type AssociateAddressInput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The allocation ID. This is required for EC2-VPC.
	AllocationId *string `type:"string"`

	// [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic
	// IP address that is already associated with an instance or network interface
	// to be reassociated with the specified instance or network interface. Otherwise,
	// the operation fails. In a VPC in an EC2-VPC-only account, reassociation is
	// automatic, therefore you can specify false to ensure the operation fails
	// if the Elastic IP address is already associated with another resource.
	AllowReassociation *bool `locationName:"allowReassociation" type:"boolean"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you
	// can specify either the instance ID or the network interface ID, but not both.
	// The operation fails if you specify an instance ID unless exactly one network
	// interface is attached.
	InstanceId *string `type:"string"`

	// [EC2-VPC] The ID of the network interface. If the instance has more than
	// one network interface, you must specify a network interface ID.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// [EC2-VPC] The primary or secondary private IP address to associate with the
	// Elastic IP address. If no private IP address is specified, the Elastic IP
	// address is associated with the primary private IP address.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The Elastic IP address. This is required for EC2-Classic.
	PublicIp *string `type:"string"`
}

// String returns the string representation
func (s AssociateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAddressInput) GoString() string {
	return s.String()
}

type AssociateAddressOutput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The ID that represents the association of the Elastic IP address
	// with an instance.
	AssociationId *string `locationName:"associationId" type:"string"`
}

// String returns the string representation
func (s AssociateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAddressOutput) GoString() string {
	return s.String()
}

type AssociateDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DHCP options set, or default to associate no DHCP options with
	// the VPC.
	DhcpOptionsId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDhcpOptionsInput) GoString() string {
	return s.String()
}

type AssociateDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDhcpOptionsOutput) GoString() string {
	return s.String()
}

type AssociateRouteTableInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRouteTableInput) GoString() string {
	return s.String()
}

type AssociateRouteTableOutput struct {
	_ struct{} `type:"structure"`

	// The route table association ID (needed to disassociate the route table).
	AssociationId *string `locationName:"associationId" type:"string"`
}

// String returns the string representation
func (s AssociateRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRouteTableOutput) GoString() string {
	return s.String()
}

type AttachClassicLinkVpcInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of one or more of the VPC's security groups. You cannot specify security
	// groups from a different VPC.
	Groups []*string `locationName:"SecurityGroupId" locationNameList:"groupId" type:"list" required:"true"`

	// The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The ID of a ClassicLink-enabled VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachClassicLinkVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachClassicLinkVpcInput) GoString() string {
	return s.String()
}

type AttachClassicLinkVpcOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s AttachClassicLinkVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachClassicLinkVpcOutput) GoString() string {
	return s.String()
}

type AttachInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the Internet gateway.
	InternetGatewayId *string `locationName:"internetGatewayId" type:"string" required:"true"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInternetGatewayInput) GoString() string {
	return s.String()
}

type AttachInternetGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInternetGatewayOutput) GoString() string {
	return s.String()
}

type AttachNetworkInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The index of the device for the network interface attachment.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachNetworkInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachNetworkInterfaceInput) GoString() string {
	return s.String()
}

type AttachNetworkInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`
}

// String returns the string representation
func (s AttachNetworkInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachNetworkInterfaceOutput) GoString() string {
	return s.String()
}

type AttachVolumeInput struct {
	_ struct{} `type:"structure"`

	// The device name to expose to the instance (for example, /dev/sdh or xvdh).
	Device *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	InstanceId *string `type:"string" required:"true"`

	// The ID of the EBS volume. The volume and instance must be within the same
	// Availability Zone.
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVolumeInput) GoString() string {
	return s.String()
}

type AttachVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `type:"string" required:"true"`

	// The ID of the virtual private gateway.
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVpnGatewayInput) GoString() string {
	return s.String()
}

type AttachVpnGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the attachment.
	VpcAttachment *VpcAttachment `locationName:"attachment" type:"structure"`
}

// String returns the string representation
func (s AttachVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVpnGatewayOutput) GoString() string {
	return s.String()
}

// The value to use when a resource attribute accepts a Boolean value.
type AttributeBooleanValue struct {
	_ struct{} `type:"structure"`

	// Valid values are true or false.
	Value *bool `locationName:"value" type:"boolean"`
}

// String returns the string representation
func (s AttributeBooleanValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeBooleanValue) GoString() string {
	return s.String()
}

// The value to use for a resource attribute.
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// Valid values are case-sensitive and vary by action.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValue) GoString() string {
	return s.String()
}

type AuthorizeSecurityGroupEgressInput struct {
	_ struct{} `type:"structure"`

	// The CIDR IP address range. We recommend that you specify the CIDR range in
	// a set of IP permissions instead.
	CidrIp *string `locationName:"cidrIp" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The start of port range for the TCP and UDP protocols, or an ICMP type number.
	// We recommend that you specify the port range in a set of IP permissions instead.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string" required:"true"`

	// A set of IP permissions. You can't specify a destination security group and
	// a CIDR IP address range.
	IpPermissions []*IpPermission `locationName:"ipPermissions" locationNameList:"item" type:"list"`

	// The IP protocol name or number. We recommend that you specify the protocol
	// in a set of IP permissions instead.
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// The name of a destination security group. To authorize outbound access to
	// a destination security group, we recommend that you use a set of IP permissions
	// instead.
	SourceSecurityGroupName *string `locationName:"sourceSecurityGroupName" type:"string"`

	// The AWS account number for a destination security group. To authorize outbound
	// access to a destination security group, we recommend that you use a set of
	// IP permissions instead.
	SourceSecurityGroupOwnerId *string `locationName:"sourceSecurityGroupOwnerId" type:"string"`

	// The end of port range for the TCP and UDP protocols, or an ICMP type number.
	// We recommend that you specify the port range in a set of IP permissions instead.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupEgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupEgressInput) GoString() string {
	return s.String()
}

type AuthorizeSecurityGroupEgressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupEgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupEgressOutput) GoString() string {
	return s.String()
}

type AuthorizeSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The CIDR IP address range. You can't specify this parameter when specifying
	// a source security group.
	CidrIp *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The start of port range for the TCP and UDP protocols, or an ICMP type number.
	// For the ICMP type number, use -1 to specify all ICMP types.
	FromPort *int64 `type:"integer"`

	// The ID of the security group. Required for a nondefault VPC.
	GroupId *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the security group.
	GroupName *string `type:"string"`

	// A set of IP permissions. Can be used to specify multiple rules in a single
	// command.
	IpPermissions []*IpPermission `locationNameList:"item" type:"list"`

	// The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers (http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
	// (VPC only) Use -1 to specify all.
	IpProtocol *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the source security group. You can't
	// specify this parameter in combination with the following parameters: the
	// CIDR IP address range, the start of the port range, the IP protocol, and
	// the end of the port range. For EC2-VPC, the source security group must be
	// in the same VPC.
	SourceSecurityGroupName *string `type:"string"`

	// [EC2-Classic, default VPC] The AWS account number for the source security
	// group. For EC2-VPC, the source security group must be in the same VPC. You
	// can't specify this parameter in combination with the following parameters:
	// the CIDR IP address range, the IP protocol, the start of the port range,
	// and the end of the port range. Creates rules that grant full ICMP, UDP, and
	// TCP access. To create a rule with a specific IP protocol and port range,
	// use a set of IP permissions instead.
	SourceSecurityGroupOwnerId *string `type:"string"`

	// The end of port range for the TCP and UDP protocols, or an ICMP code number.
	// For the ICMP code number, use -1 to specify all ICMP codes for the ICMP type.
	ToPort *int64 `type:"integer"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type AuthorizeSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// Describes an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// Any messages about the Availability Zone.
	Messages []*AvailabilityZoneMessage `locationName:"messageSet" locationNameList:"item" type:"list"`

	// The name of the region.
	RegionName *string `locationName:"regionName" type:"string"`

	// The state of the Availability Zone.
	State *string `locationName:"zoneState" type:"string" enum:"AvailabilityZoneState"`

	// The name of the Availability Zone.
	ZoneName *string `locationName:"zoneName" type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// Describes a message about an Availability Zone.
type AvailabilityZoneMessage struct {
	_ struct{} `type:"structure"`

	// The message about the Availability Zone.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AvailabilityZoneMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZoneMessage) GoString() string {
	return s.String()
}

// The capacity information for instances launched onto the Dedicated host.
type AvailableCapacity struct {
	_ struct{} `type:"structure"`

	// The total number of instances that the Dedicated host supports.
	AvailableInstanceCapacity []*InstanceCapacity `locationName:"availableInstanceCapacity" locationNameList:"item" type:"list"`

	// The number of vCPUs available on the Dedicated host.
	AvailableVCpus *int64 `locationName:"availableVCpus" type:"integer"`
}

// String returns the string representation
func (s AvailableCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailableCapacity) GoString() string {
	return s.String()
}

type BlobAttributeValue struct {
	_ struct{} `type:"structure"`

	Value []byte `locationName:"value" type:"blob"`
}

// String returns the string representation
func (s BlobAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlobAttributeValue) GoString() string {
	return s.String()
}

// Describes a block device mapping.
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the instance (for example, /dev/sdh or xvdh).
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *EbsBlockDevice `locationName:"ebs" type:"structure"`

	// Suppresses the specified device included in the block device mapping of the
	// AMI.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// The virtual device name (ephemeralN). Instance store volumes are numbered
	// starting from 0. An instance type with 2 available instance store volumes
	// can specify mappings for ephemeral0 and ephemeral1.The number of available
	// instance store volumes depends on the instance type. After you connect to
	// the instance, you must mount the volume.
	//
	// Constraints: For M3 instances, you must specify instance store volumes in
	// the block device mapping for the instance. When you launch an M3 instance,
	// we ignore any instance store volumes specified in the block device mapping
	// for the AMI.
	VirtualName *string `locationName:"virtualName" type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockDeviceMapping) GoString() string {
	return s.String()
}

type BundleInstanceInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance to bundle.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: Yes
	InstanceId *string `type:"string" required:"true"`

	// The bucket in which to store the AMI. You can specify a bucket that you already
	// own or a new bucket that Amazon EC2 creates on your behalf. If you specify
	// a bucket that belongs to someone else, Amazon EC2 returns an error.
	Storage *Storage `type:"structure" required:"true"`
}

// String returns the string representation
func (s BundleInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleInstanceInput) GoString() string {
	return s.String()
}

type BundleInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundle task.
	BundleTask *BundleTask `locationName:"bundleInstanceTask" type:"structure"`
}

// String returns the string representation
func (s BundleInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleInstanceOutput) GoString() string {
	return s.String()
}

// Describes a bundle task.
type BundleTask struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle task.
	BundleId *string `locationName:"bundleId" type:"string"`

	// If the task fails, a description of the error.
	BundleTaskError *BundleTaskError `locationName:"error" type:"structure"`

	// The ID of the instance associated with this bundle task.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The level of task completion, as a percent (for example, 20%).
	Progress *string `locationName:"progress" type:"string"`

	// The time this task started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The state of the task.
	State *string `locationName:"state" type:"string" enum:"BundleTaskState"`

	// The Amazon S3 storage locations.
	Storage *Storage `locationName:"storage" type:"structure"`

	// The time of the most recent update for the task.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s BundleTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleTask) GoString() string {
	return s.String()
}

// Describes an error for BundleInstance.
type BundleTaskError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BundleTaskError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleTaskError) GoString() string {
	return s.String()
}

type CancelBundleTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle task.
	BundleId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s CancelBundleTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelBundleTaskInput) GoString() string {
	return s.String()
}

type CancelBundleTaskOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundle task.
	BundleTask *BundleTask `locationName:"bundleInstanceTask" type:"structure"`
}

// String returns the string representation
func (s CancelBundleTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelBundleTaskOutput) GoString() string {
	return s.String()
}

type CancelConversionTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the conversion task.
	ConversionTaskId *string `locationName:"conversionTaskId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The reason for canceling the conversion task.
	ReasonMessage *string `locationName:"reasonMessage" type:"string"`
}

// String returns the string representation
func (s CancelConversionTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelConversionTaskInput) GoString() string {
	return s.String()
}

type CancelConversionTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelConversionTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelConversionTaskOutput) GoString() string {
	return s.String()
}

type CancelExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the export task. This is the ID returned by CreateInstanceExportTask.
	ExportTaskId *string `locationName:"exportTaskId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskInput) GoString() string {
	return s.String()
}

type CancelExportTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskOutput) GoString() string {
	return s.String()
}

type CancelImportTaskInput struct {
	_ struct{} `type:"structure"`

	// The reason for canceling the task.
	CancelReason *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the import image or import snapshot task to be canceled.
	ImportTaskId *string `type:"string"`
}

// String returns the string representation
func (s CancelImportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelImportTaskInput) GoString() string {
	return s.String()
}

type CancelImportTaskOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the task being canceled.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// The current state of the task being canceled.
	PreviousState *string `locationName:"previousState" type:"string"`

	// The current state of the task being canceled.
	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s CancelImportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelImportTaskOutput) GoString() string {
	return s.String()
}

type CancelReservedInstancesListingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Reserved instance listing.
	ReservedInstancesListingId *string `locationName:"reservedInstancesListingId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelReservedInstancesListingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelReservedInstancesListingInput) GoString() string {
	return s.String()
}

type CancelReservedInstancesListingOutput struct {
	_ struct{} `type:"structure"`

	// The Reserved instance listing.
	ReservedInstancesListings []*ReservedInstancesListing `locationName:"reservedInstancesListingsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CancelReservedInstancesListingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelReservedInstancesListingOutput) GoString() string {
	return s.String()
}

// Describes a Spot fleet error.
type CancelSpotFleetRequestsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string" required:"true" enum:"CancelBatchErrorCode"`

	// The description for the error code.
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsError) GoString() string {
	return s.String()
}

// Describes a Spot fleet request that was not successfully canceled.
type CancelSpotFleetRequestsErrorItem struct {
	_ struct{} `type:"structure"`

	// The error.
	Error *CancelSpotFleetRequestsError `locationName:"error" type:"structure" required:"true"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsErrorItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsErrorItem) GoString() string {
	return s.String()
}

// Contains the parameters for CancelSpotFleetRequests.
type CancelSpotFleetRequestsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IDs of the Spot fleet requests.
	SpotFleetRequestIds []*string `locationName:"spotFleetRequestId" locationNameList:"item" type:"list" required:"true"`

	// Indicates whether to terminate instances for a Spot fleet request if it is
	// canceled successfully.
	TerminateInstances *bool `locationName:"terminateInstances" type:"boolean" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsInput) GoString() string {
	return s.String()
}

// Contains the output of CancelSpotFleetRequests.
type CancelSpotFleetRequestsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Spot fleet requests that are successfully canceled.
	SuccessfulFleetRequests []*CancelSpotFleetRequestsSuccessItem `locationName:"successfulFleetRequestSet" locationNameList:"item" type:"list"`

	// Information about the Spot fleet requests that are not successfully canceled.
	UnsuccessfulFleetRequests []*CancelSpotFleetRequestsErrorItem `locationName:"unsuccessfulFleetRequestSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsOutput) GoString() string {
	return s.String()
}

// Describes a Spot fleet request that was successfully canceled.
type CancelSpotFleetRequestsSuccessItem struct {
	_ struct{} `type:"structure"`

	// The current state of the Spot fleet request.
	CurrentSpotFleetRequestState *string `locationName:"currentSpotFleetRequestState" type:"string" required:"true" enum:"BatchState"`

	// The previous state of the Spot fleet request.
	PreviousSpotFleetRequestState *string `locationName:"previousSpotFleetRequestState" type:"string" required:"true" enum:"BatchState"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsSuccessItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsSuccessItem) GoString() string {
	return s.String()
}

// Contains the parameters for CancelSpotInstanceRequests.
type CancelSpotInstanceRequestsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more Spot instance request IDs.
	SpotInstanceRequestIds []*string `locationName:"SpotInstanceRequestId" locationNameList:"SpotInstanceRequestId" type:"list" required:"true"`
}

// String returns the string representation
func (s CancelSpotInstanceRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotInstanceRequestsInput) GoString() string {
	return s.String()
}

// Contains the output of CancelSpotInstanceRequests.
type CancelSpotInstanceRequestsOutput struct {
	_ struct{} `type:"structure"`

	// One or more Spot instance requests.
	CancelledSpotInstanceRequests []*CancelledSpotInstanceRequest `locationName:"spotInstanceRequestSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CancelSpotInstanceRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotInstanceRequestsOutput) GoString() string {
	return s.String()
}

// Describes a request to cancel a Spot instance.
type CancelledSpotInstanceRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the Spot instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`

	// The state of the Spot instance request.
	State *string `locationName:"state" type:"string" enum:"CancelSpotInstanceRequestState"`
}

// String returns the string representation
func (s CancelledSpotInstanceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelledSpotInstanceRequest) GoString() string {
	return s.String()
}

// Describes a linked EC2-Classic instance.
type ClassicLinkInstance struct {
	_ struct{} `type:"structure"`

	// A list of security groups.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Any tags assigned to the instance.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s ClassicLinkInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassicLinkInstance) GoString() string {
	return s.String()
}

// Describes the client-specific data.
type ClientData struct {
	_ struct{} `type:"structure"`

	// A user-defined comment about the disk upload.
	Comment *string `type:"string"`

	// The time that the disk upload ends.
	UploadEnd *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The size of the uploaded disk image, in GiB.
	UploadSize *float64 `type:"double"`

	// The time that the disk upload starts.
	UploadStart *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ClientData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientData) GoString() string {
	return s.String()
}

type ConfirmProductInstanceInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	InstanceId *string `type:"string" required:"true"`

	// The product code. This must be a product code that you own.
	ProductCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmProductInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmProductInstanceInput) GoString() string {
	return s.String()
}

type ConfirmProductInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the instance owner. This is only present if the product
	// code is attached to the instance.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The return value of the request. Returns true if the specified product code
	// is owned by the requester and associated with the specified instance.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ConfirmProductInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmProductInstanceOutput) GoString() string {
	return s.String()
}

// Describes a conversion task.
type ConversionTask struct {
	_ struct{} `type:"structure"`

	// The ID of the conversion task.
	ConversionTaskId *string `locationName:"conversionTaskId" type:"string" required:"true"`

	// The time when the task expires. If the upload isn't complete before the expiration
	// time, we automatically cancel the task.
	ExpirationTime *string `locationName:"expirationTime" type:"string"`

	// If the task is for importing an instance, this contains information about
	// the import instance task.
	ImportInstance *ImportInstanceTaskDetails `locationName:"importInstance" type:"structure"`

	// If the task is for importing a volume, this contains information about the
	// import volume task.
	ImportVolume *ImportVolumeTaskDetails `locationName:"importVolume" type:"structure"`

	// The state of the conversion task.
	State *string `locationName:"state" type:"string" required:"true" enum:"ConversionTaskState"`

	// The status message related to the conversion task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Any tags assigned to the task.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ConversionTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConversionTask) GoString() string {
	return s.String()
}

type CopyImageInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `type:"string"`

	// A description for the new AMI in the destination region.
	Description *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether the destination snapshots of the copied image should be
	// encrypted. The default CMK for EBS is used unless a non-default AWS Key Management
	// Service (AWS KMS) CMK is specified with KmsKeyId. For more information, see
	// Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when
	// encrypting the snapshots of an image during a copy operation. This parameter
	// is only required if you want to use a non-default CMK; if this parameter
	// is not specified, the default CMK for EBS is used. The ARN contains the arn:aws:kms
	// namespace, followed by the region of the CMK, the AWS account ID of the CMK
	// owner, the key namespace, and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	// The specified CMK must exist in the region that the snapshot is being copied
	// to. If a KmsKeyId is specified, the Encrypted flag must also be set.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The name of the new AMI in the destination region.
	Name *string `type:"string" required:"true"`

	// The ID of the AMI to copy.
	SourceImageId *string `type:"string" required:"true"`

	// The name of the region that contains the AMI to copy.
	SourceRegion *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageInput) GoString() string {
	return s.String()
}

type CopyImageOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new AMI.
	ImageId *string `locationName:"imageId" type:"string"`
}

// String returns the string representation
func (s CopyImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageOutput) GoString() string {
	return s.String()
}

type CopySnapshotInput struct {
	_ struct{} `type:"structure"`

	// A description for the EBS snapshot.
	Description *string `type:"string"`

	// The destination region to use in the PresignedUrl parameter of a snapshot
	// copy operation. This parameter is only valid for specifying the destination
	// region in a PresignedUrl parameter, where it is required.
	//
	//  CopySnapshot sends the snapshot copy to the regional endpoint that you
	// send the HTTP request to, such as ec2.us-east-1.amazonaws.com (in the AWS
	// CLI, this is specified with the --region parameter or the default region
	// in your AWS configuration file).
	DestinationRegion *string `locationName:"destinationRegion" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether the destination snapshot should be encrypted. There is
	// no way to create an unencrypted snapshot copy from an encrypted snapshot;
	// however, you can encrypt a copy of an unencrypted snapshot with this flag.
	// The default CMK for EBS is used unless a non-default AWS Key Management Service
	// (AWS KMS) CMK is specified with KmsKeyId. For more information, see Amazon
	// EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when
	// creating the snapshot copy. This parameter is only required if you want to
	// use a non-default CMK; if this parameter is not specified, the default CMK
	// for EBS is used. The ARN contains the arn:aws:kms namespace, followed by
	// the region of the CMK, the AWS account ID of the CMK owner, the key namespace,
	// and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	// The specified CMK must exist in the region that the snapshot is being copied
	// to. If a KmsKeyId is specified, the Encrypted flag must also be set.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The pre-signed URL that facilitates copying an encrypted snapshot. This parameter
	// is only required when copying an encrypted snapshot with the Amazon EC2 Query
	// API; it is available as an optional parameter in all other cases. The PresignedUrl
	// should use the snapshot source endpoint, the CopySnapshot action, and include
	// the SourceRegion, SourceSnapshotId, and DestinationRegion parameters. The
	// PresignedUrl must be signed using AWS Signature Version 4. Because EBS snapshots
	// are stored in Amazon S3, the signing algorithm for this parameter uses the
	// same logic that is described in Authenticating Requests by Using Query Parameters
	// (AWS Signature Version 4) (http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// in the Amazon Simple Storage Service API Reference. An invalid or improperly
	// signed PresignedUrl will cause the copy operation to fail asynchronously,
	// and the snapshot will move to an error state.
	PresignedUrl *string `locationName:"presignedUrl" type:"string"`

	// The ID of the region that contains the snapshot to be copied.
	SourceRegion *string `type:"string" required:"true"`

	// The ID of the EBS snapshot to copy.
	SourceSnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotInput) GoString() string {
	return s.String()
}

type CopySnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new snapshot.
	SnapshotId *string `locationName:"snapshotId" type:"string"`
}

// String returns the string representation
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotOutput) GoString() string {
	return s.String()
}

type CreateCustomerGatewayInput struct {
	_ struct{} `type:"structure"`

	// For devices that support BGP, the customer gateway's BGP ASN.
	//
	// Default: 65000
	BgpAsn *int64 `type:"integer" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The Internet-routable IP address for the customer gateway's outside interface.
	// The address must be static.
	PublicIp *string `locationName:"IpAddress" type:"string" required:"true"`

	// The type of VPN connection that this customer gateway supports (ipsec.1).
	Type *string `type:"string" required:"true" enum:"GatewayType"`
}

// String returns the string representation
func (s CreateCustomerGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomerGatewayInput) GoString() string {
	return s.String()
}

type CreateCustomerGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the customer gateway.
	CustomerGateway *CustomerGateway `locationName:"customerGateway" type:"structure"`
}

// String returns the string representation
func (s CreateCustomerGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomerGatewayOutput) GoString() string {
	return s.String()
}

type CreateDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// A DHCP configuration option.
	DhcpConfigurations []*NewDhcpConfiguration `locationName:"dhcpConfiguration" locationNameList:"item" type:"list" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s CreateDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDhcpOptionsInput) GoString() string {
	return s.String()
}

type CreateDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A set of DHCP options.
	DhcpOptions *DhcpOptions `locationName:"dhcpOptions" type:"structure"`
}

// String returns the string representation
func (s CreateDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDhcpOptionsOutput) GoString() string {
	return s.String()
}

type CreateFlowLogsInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string"`

	// The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs
	// log group.
	DeliverLogsPermissionArn *string `type:"string" required:"true"`

	// The name of the CloudWatch log group.
	LogGroupName *string `type:"string" required:"true"`

	// One or more subnet, network interface, or VPC IDs.
	ResourceIds []*string `locationName:"ResourceId" locationNameList:"item" type:"list" required:"true"`

	// The type of resource on which to create the flow log.
	ResourceType *string `type:"string" required:"true" enum:"FlowLogsResourceType"`

	// The type of traffic to log.
	TrafficType *string `type:"string" required:"true" enum:"TrafficType"`
}

// String returns the string representation
func (s CreateFlowLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowLogsInput) GoString() string {
	return s.String()
}

type CreateFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The IDs of the flow logs.
	FlowLogIds []*string `locationName:"flowLogIdSet" locationNameList:"item" type:"list"`

	// Information about the flow logs that could not be created successfully.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateFlowLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowLogsOutput) GoString() string {
	return s.String()
}

type CreateImageInput struct {
	_ struct{} `type:"structure"`

	// Information about one or more block device mappings.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"BlockDeviceMapping" type:"list"`

	// A description for the new image.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// A name for the new image.
	//
	// Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets
	// ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('),
	// at-signs (@), or underscores(_)
	Name *string `locationName:"name" type:"string" required:"true"`

	// By default, this parameter is set to false, which means Amazon EC2 attempts
	// to shut down the instance cleanly before image creation and then reboots
	// the instance. When the parameter is set to true, Amazon EC2 doesn't shut
	// down the instance before creating the image. When this option is used, file
	// system integrity on the created image can't be guaranteed.
	NoReboot *bool `locationName:"noReboot" type:"boolean"`
}

// String returns the string representation
func (s CreateImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageInput) GoString() string {
	return s.String()
}

type CreateImageOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new AMI.
	ImageId *string `locationName:"imageId" type:"string"`
}

// String returns the string representation
func (s CreateImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageOutput) GoString() string {
	return s.String()
}

type CreateInstanceExportTaskInput struct {
	_ struct{} `type:"structure"`

	// A description for the conversion task or the resource being exported. The
	// maximum length is 255 bytes.
	Description *string `locationName:"description" type:"string"`

	// The format and location for an instance export task.
	ExportToS3Task *ExportToS3TaskSpecification `locationName:"exportToS3" type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The target virtualization environment.
	TargetEnvironment *string `locationName:"targetEnvironment" type:"string" enum:"ExportEnvironment"`
}

// String returns the string representation
func (s CreateInstanceExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceExportTaskInput) GoString() string {
	return s.String()
}

type CreateInstanceExportTaskOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance export task.
	ExportTask *ExportTask `locationName:"exportTask" type:"structure"`
}

// String returns the string representation
func (s CreateInstanceExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceExportTaskOutput) GoString() string {
	return s.String()
}

type CreateInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s CreateInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInternetGatewayInput) GoString() string {
	return s.String()
}

type CreateInternetGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Internet gateway.
	InternetGateway *InternetGateway `locationName:"internetGateway" type:"structure"`
}

// String returns the string representation
func (s CreateInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInternetGatewayOutput) GoString() string {
	return s.String()
}

type CreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A unique name for the key pair.
	//
	// Constraints: Up to 255 ASCII characters
	KeyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairInput) GoString() string {
	return s.String()
}

// Describes a key pair.
type CreateKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// The SHA-1 digest of the DER encoded private key.
	KeyFingerprint *string `locationName:"keyFingerprint" type:"string"`

	// An unencrypted PEM encoded RSA private key.
	KeyMaterial *string `locationName:"keyMaterial" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`
}

// String returns the string representation
func (s CreateKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairOutput) GoString() string {
	return s.String()
}

type CreateNatGatewayInput struct {
	_ struct{} `type:"structure"`

	// The allocation ID of an Elastic IP address to associate with the NAT gateway.
	// If the Elastic IP address is associated with another resource, you must first
	// disassociate it.
	AllocationId *string `type:"string" required:"true"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	//
	// Constraint: Maximum 64 ASCII characters.
	ClientToken *string `type:"string"`

	// The subnet in which to create the NAT gateway.
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNatGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatGatewayInput) GoString() string {
	return s.String()
}

type CreateNatGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure the idempotency of the request.
	// Only returned if a client token was provided in the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the NAT gateway.
	NatGateway *NatGateway `locationName:"natGateway" type:"structure"`
}

// String returns the string representation
func (s CreateNatGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatGatewayOutput) GoString() string {
	return s.String()
}

type CreateNetworkAclEntryInput struct {
	_ struct{} `type:"structure"`

	// The network range to allow or deny, in CIDR notation (for example 172.16.0.0/24).
	CidrBlock *string `locationName:"cidrBlock" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether this is an egress rule (rule is applied to traffic leaving
	// the subnet).
	Egress *bool `locationName:"egress" type:"boolean" required:"true"`

	// ICMP protocol: The ICMP type and code. Required if specifying ICMP for the
	// protocol.
	IcmpTypeCode *IcmpTypeCode `locationName:"Icmp" type:"structure"`

	// The ID of the network ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`

	// TCP or UDP protocols: The range of ports the rule applies to.
	PortRange *PortRange `locationName:"portRange" type:"structure"`

	// The protocol. A value of -1 means all protocols.
	Protocol *string `locationName:"protocol" type:"string" required:"true"`

	// Indicates whether to allow or deny the traffic that matches the rule.
	RuleAction *string `locationName:"ruleAction" type:"string" required:"true" enum:"RuleAction"`

	// The rule number for the entry (for example, 100). ACL entries are processed
	// in ascending order by rule number.
	//
	// Constraints: Positive integer from 1 to 32766
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateNetworkAclEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclEntryInput) GoString() string {
	return s.String()
}

type CreateNetworkAclEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateNetworkAclEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclEntryOutput) GoString() string {
	return s.String()
}

type CreateNetworkAclInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNetworkAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclInput) GoString() string {
	return s.String()
}

type CreateNetworkAclOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network ACL.
	NetworkAcl *NetworkAcl `locationName:"networkAcl" type:"structure"`
}

// String returns the string representation
func (s CreateNetworkAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclOutput) GoString() string {
	return s.String()
}

type CreateNetworkInterfaceInput struct {
	_ struct{} `type:"structure"`

	// A description for the network interface.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IDs of one or more security groups.
	Groups []*string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The primary private IP address of the network interface. If you don't specify
	// an IP address, Amazon EC2 selects one for you from the subnet range. If you
	// specify an IP address, you cannot indicate any IP addresses specified in
	// privateIpAddresses as primary (only one IP address can be designated as primary).
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// One or more private IP addresses.
	PrivateIpAddresses []*PrivateIpAddressSpecification `locationName:"privateIpAddresses" locationNameList:"item" type:"list"`

	// The number of secondary private IP addresses to assign to a network interface.
	// When you specify a number of secondary IP addresses, Amazon EC2 selects these
	// IP addresses within the subnet range. You can't specify this option and specify
	// more than one private IP address using privateIpAddresses.
	//
	// The number of IP addresses you can assign to a network interface varies
	// by instance type. For more information, see Private IP Addresses Per ENI
	// Per Instance Type (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
	// in the Amazon Elastic Compute Cloud User Guide.
	SecondaryPrivateIpAddressCount *int64 `locationName:"secondaryPrivateIpAddressCount" type:"integer"`

	// The ID of the subnet to associate with the network interface.
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNetworkInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkInterfaceInput) GoString() string {
	return s.String()
}

type CreateNetworkInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network interface.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`
}

// String returns the string representation
func (s CreateNetworkInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkInterfaceOutput) GoString() string {
	return s.String()
}

type CreatePlacementGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A name for the placement group.
	//
	// Constraints: Up to 255 ASCII characters
	GroupName *string `locationName:"groupName" type:"string" required:"true"`

	// The placement strategy.
	Strategy *string `locationName:"strategy" type:"string" required:"true" enum:"PlacementStrategy"`
}

// String returns the string representation
func (s CreatePlacementGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlacementGroupInput) GoString() string {
	return s.String()
}

type CreatePlacementGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePlacementGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlacementGroupOutput) GoString() string {
	return s.String()
}

type CreateReservedInstancesListingInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of your
	// listings. This helps avoid duplicate listings. For more information, see
	// Ensuring Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string" required:"true"`

	// The number of instances that are a part of a Reserved instance account to
	// be listed in the Reserved Instance Marketplace. This number should be less
	// than or equal to the instance count associated with the Reserved instance
	// ID specified in this call.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer" required:"true"`

	// A list specifying the price of the Reserved instance for each month remaining
	// in the Reserved instance term.
	PriceSchedules []*PriceScheduleSpecification `locationName:"priceSchedules" locationNameList:"item" type:"list" required:"true"`

	// The ID of the active Reserved instance.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReservedInstancesListingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReservedInstancesListingInput) GoString() string {
	return s.String()
}

type CreateReservedInstancesListingOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Reserved instance listing.
	ReservedInstancesListings []*ReservedInstancesListing `locationName:"reservedInstancesListingsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateReservedInstancesListingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReservedInstancesListingOutput) GoString() string {
	return s.String()
}

type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR address block used for the destination match. Routing decisions
	// are based on the most specific match.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of an Internet gateway or virtual private gateway attached to your
	// VPC.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of a NAT instance in your VPC. The operation fails if you specify
	// an instance ID unless exactly one network interface is attached.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The ID of a NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// The ID of a network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the route table for the route.
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`

	// The ID of a VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteInput) GoString() string {
	return s.String()
}

type CreateRouteOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteOutput) GoString() string {
	return s.String()
}

type CreateRouteTableInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteTableInput) GoString() string {
	return s.String()
}

type CreateRouteTableOutput struct {
	_ struct{} `type:"structure"`

	// Information about the route table.
	RouteTable *RouteTable `locationName:"routeTable" type:"structure"`
}

// String returns the string representation
func (s CreateRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteTableOutput) GoString() string {
	return s.String()
}

type CreateSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the security group. This is informational only.
	//
	// Constraints: Up to 255 characters in length
	//
	// Constraints for EC2-Classic: ASCII characters
	//
	// Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*
	Description *string `locationName:"GroupDescription" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the security group.
	//
	// Constraints: Up to 255 characters in length
	//
	// Constraints for EC2-Classic: ASCII characters
	//
	// Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*
	GroupName *string `type:"string" required:"true"`

	// [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CreateSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityGroupInput) GoString() string {
	return s.String()
}

type CreateSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`
}

// String returns the string representation
func (s CreateSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityGroupOutput) GoString() string {
	return s.String()
}

type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A description for the snapshot.
	Description *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the EBS volume.
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateSpotDatafeedSubscription.
type CreateSpotDatafeedSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket in which to store the Spot instance data feed.
	Bucket *string `locationName:"bucket" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A prefix for the data feed file names.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s CreateSpotDatafeedSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSpotDatafeedSubscriptionInput) GoString() string {
	return s.String()
}

// Contains the output of CreateSpotDatafeedSubscription.
type CreateSpotDatafeedSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Spot instance data feed subscription.
	SpotDatafeedSubscription *SpotDatafeedSubscription `locationName:"spotDatafeedSubscription" type:"structure"`
}

// String returns the string representation
func (s CreateSpotDatafeedSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSpotDatafeedSubscriptionOutput) GoString() string {
	return s.String()
}

type CreateSubnetInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone for the subnet.
	//
	// Default: AWS selects one for you. If you create more than one subnet in
	// your VPC, we may not necessarily select a different zone for each subnet.
	AvailabilityZone *string `type:"string"`

	// The network range for the subnet, in CIDR notation. For example, 10.0.0.0/24.
	CidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSubnetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubnetInput) GoString() string {
	return s.String()
}

type CreateSubnetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the subnet.
	Subnet *Subnet `locationName:"subnet" type:"structure"`
}

// String returns the string representation
func (s CreateSubnetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubnetOutput) GoString() string {
	return s.String()
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
	Resources []*string `locationName:"ResourceId" type:"list" required:"true"`

	// One or more tags. The value parameter is required, but if you don't want
	// the tag to have a value, specify the parameter with no value, and we set
	// the value to an empty string.
	Tags []*Tag `locationName:"Tag" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type CreateVolumeInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create the volume. Use DescribeAvailabilityZones
	// to list the Availability Zones that are currently available to you.
	AvailabilityZone *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether the volume should be encrypted. Encrypted Amazon EBS volumes
	// may only be attached to instances that support Amazon EBS encryption. Volumes
	// that are created from encrypted snapshots are automatically encrypted. There
	// is no way to create an encrypted volume from an unencrypted snapshot or vice
	// versa. If your AMI uses encrypted volumes, you can only launch it on supported
	// instance types. For more information, see Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// Only valid for Provisioned IOPS (SSD) volumes. The number of I/O operations
	// per second (IOPS) to provision for the volume, with a maximum ratio of 30
	// IOPS/GiB.
	//
	// Constraint: Range is 100 to 20000 for Provisioned IOPS (SSD) volumes
	Iops *int64 `type:"integer"`

	// The full ARN of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) to use when creating the encrypted volume. This parameter is only
	// required if you want to use a non-default CMK; if this parameter is not specified,
	// the default CMK for EBS is used. The ARN contains the arn:aws:kms namespace,
	// followed by the region of the CMK, the AWS account ID of the CMK owner, the
	// key namespace, and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	// If a KmsKeyId is specified, the Encrypted flag must also be set.
	KmsKeyId *string `type:"string"`

	// The size of the volume, in GiBs.
	//
	// Constraints: 1-1024 for standard volumes, 1-16384 for gp2 volumes, and 4-16384
	// for io1 volumes. If you specify a snapshot, the volume size must be equal
	// to or larger than the snapshot size.
	//
	// Default: If you're creating the volume from a snapshot and don't specify
	// a volume size, the default is the snapshot size.
	Size *int64 `type:"integer"`

	// The snapshot from which to create the volume.
	SnapshotId *string `type:"string"`

	// The volume type. This can be gp2 for General Purpose (SSD) volumes, io1 for
	// Provisioned IOPS (SSD) volumes, or standard for Magnetic volumes.
	//
	// Default: standard
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s CreateVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVolumeInput) GoString() string {
	return s.String()
}

// Describes the user or group to be added or removed from the permissions for
// a volume.
type CreateVolumePermission struct {
	_ struct{} `type:"structure"`

	// The specific group that is to be added or removed from a volume's list of
	// create volume permissions.
	Group *string `locationName:"group" type:"string" enum:"PermissionGroup"`

	// The specific AWS account ID that is to be added or removed from a volume's
	// list of create volume permissions.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s CreateVolumePermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVolumePermission) GoString() string {
	return s.String()
}

// Describes modifications to the permissions for a volume.
type CreateVolumePermissionModifications struct {
	_ struct{} `type:"structure"`

	// Adds a specific AWS account ID or group to a volume's list of create volume
	// permissions.
	Add []*CreateVolumePermission `locationNameList:"item" type:"list"`

	// Removes a specific AWS account ID or group from a volume's list of create
	// volume permissions.
	Remove []*CreateVolumePermission `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateVolumePermissionModifications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVolumePermissionModifications) GoString() string {
	return s.String()
}

type CreateVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// A policy to attach to the endpoint that controls access to the service. The
	// policy must be in valid JSON format. If this parameter is not specified,
	// we attach a default policy that allows full access to the service.
	PolicyDocument *string `type:"string"`

	// One or more route table IDs.
	RouteTableIds []*string `locationName:"RouteTableId" locationNameList:"item" type:"list"`

	// The AWS service name, in the form com.amazonaws.region.service. To get a
	// list of available services, use the DescribeVpcEndpointServices request.
	ServiceName *string `type:"string" required:"true"`

	// The ID of the VPC in which the endpoint will be used.
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcEndpointInput) GoString() string {
	return s.String()
}

type CreateVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the endpoint.
	VpcEndpoint *VpcEndpoint `locationName:"vpcEndpoint" type:"structure"`
}

// String returns the string representation
func (s CreateVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcEndpointOutput) GoString() string {
	return s.String()
}

type CreateVpcInput struct {
	_ struct{} `type:"structure"`

	// The network range for the VPC, in CIDR notation. For example, 10.0.0.0/16.
	CidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The supported tenancy options for instances launched into the VPC. A value
	// of default means that instances can be launched with any tenancy; a value
	// of dedicated means all instances launched into the VPC are launched as dedicated
	// tenancy instances regardless of the tenancy assigned to the instance at launch.
	// Dedicated tenancy instances run on single-tenant hardware.
	//
	// Important: The host value cannot be used with this parameter. Use the default
	// or dedicated values only.
	//
	// Default: default
	InstanceTenancy *string `locationName:"instanceTenancy" type:"string" enum:"Tenancy"`
}

// String returns the string representation
func (s CreateVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcInput) GoString() string {
	return s.String()
}

type CreateVpcOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC.
	Vpc *Vpc `locationName:"vpc" type:"structure"`
}

// String returns the string representation
func (s CreateVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcOutput) GoString() string {
	return s.String()
}

type CreateVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The AWS account ID of the owner of the peer VPC.
	//
	// Default: Your AWS account ID
	PeerOwnerId *string `locationName:"peerOwnerId" type:"string"`

	// The ID of the VPC with which you are creating the VPC peering connection.
	PeerVpcId *string `locationName:"peerVpcId" type:"string"`

	// The ID of the requester VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s CreateVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

type CreateVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC peering connection.
	VpcPeeringConnection *VpcPeeringConnection `locationName:"vpcPeeringConnection" type:"structure"`
}

// String returns the string representation
func (s CreateVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

type CreateVpnConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the customer gateway.
	CustomerGatewayId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether the VPN connection requires static routes. If you are creating
	// a VPN connection for a device that does not support BGP, you must specify
	// true.
	//
	// Default: false
	Options *VpnConnectionOptionsSpecification `locationName:"options" type:"structure"`

	// The type of VPN connection (ipsec.1).
	Type *string `type:"string" required:"true"`

	// The ID of the virtual private gateway.
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpnConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionInput) GoString() string {
	return s.String()
}

type CreateVpnConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPN connection.
	VpnConnection *VpnConnection `locationName:"vpnConnection" type:"structure"`
}

// String returns the string representation
func (s CreateVpnConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionOutput) GoString() string {
	return s.String()
}

type CreateVpnConnectionRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer network.
	DestinationCidrBlock *string `type:"string" required:"true"`

	// The ID of the VPN connection.
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpnConnectionRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionRouteInput) GoString() string {
	return s.String()
}

type CreateVpnConnectionRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateVpnConnectionRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionRouteOutput) GoString() string {
	return s.String()
}

type CreateVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone for the virtual private gateway.
	AvailabilityZone *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The type of VPN connection this virtual private gateway supports.
	Type *string `type:"string" required:"true" enum:"GatewayType"`
}

// String returns the string representation
func (s CreateVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnGatewayInput) GoString() string {
	return s.String()
}

type CreateVpnGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the virtual private gateway.
	VpnGateway *VpnGateway `locationName:"vpnGateway" type:"structure"`
}

// String returns the string representation
func (s CreateVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnGatewayOutput) GoString() string {
	return s.String()
}

// Describes a customer gateway.
type CustomerGateway struct {
	_ struct{} `type:"structure"`

	// The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
	// (ASN).
	BgpAsn *string `locationName:"bgpAsn" type:"string"`

	// The ID of the customer gateway.
	CustomerGatewayId *string `locationName:"customerGatewayId" type:"string"`

	// The Internet-routable IP address of the customer gateway's outside interface.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The current state of the customer gateway (pending | available | deleting
	// | deleted).
	State *string `locationName:"state" type:"string"`

	// Any tags assigned to the customer gateway.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of VPN connection the customer gateway supports (ipsec.1).
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s CustomerGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerGateway) GoString() string {
	return s.String()
}

type DeleteCustomerGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the customer gateway.
	CustomerGatewayId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DeleteCustomerGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomerGatewayInput) GoString() string {
	return s.String()
}

type DeleteCustomerGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomerGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomerGatewayOutput) GoString() string {
	return s.String()
}

type DeleteDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DHCP options set.
	DhcpOptionsId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DeleteDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDhcpOptionsInput) GoString() string {
	return s.String()
}

type DeleteDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDhcpOptionsOutput) GoString() string {
	return s.String()
}

type DeleteFlowLogsInput struct {
	_ struct{} `type:"structure"`

	// One or more flow log IDs.
	FlowLogIds []*string `locationName:"FlowLogId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteFlowLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowLogsInput) GoString() string {
	return s.String()
}

type DeleteFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the flow logs that could not be deleted successfully.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteFlowLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowLogsOutput) GoString() string {
	return s.String()
}

type DeleteInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the Internet gateway.
	InternetGatewayId *string `locationName:"internetGatewayId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInternetGatewayInput) GoString() string {
	return s.String()
}

type DeleteInternetGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInternetGatewayOutput) GoString() string {
	return s.String()
}

type DeleteKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the key pair.
	KeyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairInput) GoString() string {
	return s.String()
}

type DeleteKeyPairOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairOutput) GoString() string {
	return s.String()
}

type DeleteNatGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the NAT gateway.
	NatGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNatGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNatGatewayInput) GoString() string {
	return s.String()
}

type DeleteNatGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`
}

// String returns the string representation
func (s DeleteNatGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNatGatewayOutput) GoString() string {
	return s.String()
}

type DeleteNetworkAclEntryInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether the rule is an egress rule.
	Egress *bool `locationName:"egress" type:"boolean" required:"true"`

	// The ID of the network ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`

	// The rule number of the entry to delete.
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteNetworkAclEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclEntryInput) GoString() string {
	return s.String()
}

type DeleteNetworkAclEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNetworkAclEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclEntryOutput) GoString() string {
	return s.String()
}

type DeleteNetworkAclInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the network ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNetworkAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclInput) GoString() string {
	return s.String()
}

type DeleteNetworkAclOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNetworkAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclOutput) GoString() string {
	return s.String()
}

type DeleteNetworkInterfaceInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNetworkInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkInterfaceInput) GoString() string {
	return s.String()
}

type DeleteNetworkInterfaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNetworkInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkInterfaceOutput) GoString() string {
	return s.String()
}

type DeletePlacementGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the placement group.
	GroupName *string `locationName:"groupName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePlacementGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlacementGroupInput) GoString() string {
	return s.String()
}

type DeletePlacementGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePlacementGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlacementGroupOutput) GoString() string {
	return s.String()
}

type DeleteRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR range for the route. The value you specify must match the CIDR for
	// the route exactly.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteInput) GoString() string {
	return s.String()
}

type DeleteRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteOutput) GoString() string {
	return s.String()
}

type DeleteRouteTableInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteTableInput) GoString() string {
	return s.String()
}

type DeleteRouteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteTableOutput) GoString() string {
	return s.String()
}

type DeleteSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the security group. Required for a nondefault VPC.
	GroupId *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the security group. You can specify
	// either the security group name or the security group ID.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s DeleteSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityGroupInput) GoString() string {
	return s.String()
}

type DeleteSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityGroupOutput) GoString() string {
	return s.String()
}

type DeleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the EBS snapshot.
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

type DeleteSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteSpotDatafeedSubscription.
type DeleteSpotDatafeedSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DeleteSpotDatafeedSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSpotDatafeedSubscriptionInput) GoString() string {
	return s.String()
}

type DeleteSpotDatafeedSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSpotDatafeedSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSpotDatafeedSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteSubnetInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the subnet.
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubnetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubnetInput) GoString() string {
	return s.String()
}

type DeleteSubnetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubnetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubnetOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the resource. For example, ami-1a2b3c4d. You can specify more than
	// one resource ID.
	Resources []*string `locationName:"resourceId" type:"list" required:"true"`

	// One or more tags to delete. If you omit the value parameter, we delete the
	// tag regardless of its value. If you specify this parameter with an empty
	// string as the value, we delete the key only if its value is an empty string.
	Tags []*Tag `locationName:"tag" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DeleteVolumeInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the volume.
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeInput) GoString() string {
	return s.String()
}

type DeleteVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeOutput) GoString() string {
	return s.String()
}

type DeleteVpcEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more endpoint IDs.
	VpcEndpointIds []*string `locationName:"VpcEndpointId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteVpcEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcEndpointsInput) GoString() string {
	return s.String()
}

type DeleteVpcEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the endpoints that were not successfully deleted.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteVpcEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcEndpointsOutput) GoString() string {
	return s.String()
}

type DeleteVpcInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcInput) GoString() string {
	return s.String()
}

type DeleteVpcOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcOutput) GoString() string {
	return s.String()
}

type DeleteVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

type DeleteVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

type DeleteVpnConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPN connection.
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionInput) GoString() string {
	return s.String()
}

type DeleteVpnConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionOutput) GoString() string {
	return s.String()
}

type DeleteVpnConnectionRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer network.
	DestinationCidrBlock *string `type:"string" required:"true"`

	// The ID of the VPN connection.
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnConnectionRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionRouteInput) GoString() string {
	return s.String()
}

type DeleteVpnConnectionRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnConnectionRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionRouteOutput) GoString() string {
	return s.String()
}

type DeleteVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the virtual private gateway.
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnGatewayInput) GoString() string {
	return s.String()
}

type DeleteVpnGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnGatewayOutput) GoString() string {
	return s.String()
}

type DeregisterImageInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterImageInput) GoString() string {
	return s.String()
}

type DeregisterImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterImageOutput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`

	// One or more account attribute names.
	AttributeNames []*string `locationName:"attributeName" locationNameList:"attributeName" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more account attributes.
	AccountAttributes []*AccountAttribute `locationName:"accountAttributeSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

type DescribeAddressesInput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] One or more allocation IDs.
	//
	// Default: Describes all your Elastic IP addresses.
	AllocationIds []*string `locationName:"AllocationId" locationNameList:"AllocationId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters. Filter names and values are case-sensitive.
	//
	//   allocation-id - [EC2-VPC] The allocation ID for the address.
	//
	//   association-id - [EC2-VPC] The association ID for the address.
	//
	//   domain - Indicates whether the address is for use in EC2-Classic (standard)
	// or in a VPC (vpc).
	//
	//   instance-id - The ID of the instance the address is associated with, if
	// any.
	//
	//   network-interface-id - [EC2-VPC] The ID of the network interface that
	// the address is associated with, if any.
	//
	//   network-interface-owner-id - The AWS account ID of the owner.
	//
	//   private-ip-address - [EC2-VPC] The private IP address associated with
	// the Elastic IP address.
	//
	//   public-ip - The Elastic IP address.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// [EC2-Classic] One or more Elastic IP addresses.
	//
	// Default: Describes all your Elastic IP addresses.
	PublicIps []*string `locationName:"PublicIp" locationNameList:"PublicIp" type:"list"`
}

// String returns the string representation
func (s DescribeAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesInput) GoString() string {
	return s.String()
}

type DescribeAddressesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more Elastic IP addresses.
	Addresses []*Address `locationName:"addressesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesOutput) GoString() string {
	return s.String()
}

type DescribeAvailabilityZonesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   message - Information about the Availability Zone.
	//
	//   region-name - The name of the region for the Availability Zone (for example,
	// us-east-1).
	//
	//   state - The state of the Availability Zone (available | information |
	// impaired | unavailable).
	//
	//   zone-name - The name of the Availability Zone (for example, us-east-1a).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The names of one or more Availability Zones.
	ZoneNames []*string `locationName:"ZoneName" locationNameList:"ZoneName" type:"list"`
}

// String returns the string representation
func (s DescribeAvailabilityZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityZonesInput) GoString() string {
	return s.String()
}

type DescribeAvailabilityZonesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more Availability Zones.
	AvailabilityZones []*AvailabilityZone `locationName:"availabilityZoneInfo" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeAvailabilityZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityZonesOutput) GoString() string {
	return s.String()
}

type DescribeBundleTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more bundle task IDs.
	//
	// Default: Describes all your bundle tasks.
	BundleIds []*string `locationName:"BundleId" locationNameList:"BundleId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   bundle-id - The ID of the bundle task.
	//
	//   error-code - If the task failed, the error code returned.
	//
	//   error-message - If the task failed, the error message returned.
	//
	//   instance-id - The ID of the instance.
	//
	//   progress - The level of task completion, as a percentage (for example,
	// 20%).
	//
	//   s3-bucket - The Amazon S3 bucket to store the AMI.
	//
	//   s3-prefix - The beginning of the AMI name.
	//
	//   start-time - The time the task started (for example, 2013-09-15T17:15:20.000Z).
	//
	//   state - The state of the task (pending | waiting-for-shutdown | bundling
	// | storing | cancelling | complete | failed).
	//
	//   update-time - The time of the most recent update for the task.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeBundleTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBundleTasksInput) GoString() string {
	return s.String()
}

type DescribeBundleTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more bundle tasks.
	BundleTasks []*BundleTask `locationName:"bundleInstanceTasksSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeBundleTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBundleTasksOutput) GoString() string {
	return s.String()
}

type DescribeClassicLinkInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//  group-id - The ID of a VPC security group that's associated with the instance.
	//
	//  instance-id - The ID of the instance.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   vpc-id - The ID of the VPC that the instance is linked to.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value larger than 1000, only 1000 results
	// are returned. You cannot specify this parameter and the instance IDs parameter
	// in the same request.
	//
	// Constraint: If the value is greater than 1000, we return only 1000 items.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeClassicLinkInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClassicLinkInstancesInput) GoString() string {
	return s.String()
}

type DescribeClassicLinkInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more linked EC2-Classic instances.
	Instances []*ClassicLinkInstance `locationName:"instancesSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeClassicLinkInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClassicLinkInstancesOutput) GoString() string {
	return s.String()
}

type DescribeConversionTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more conversion task IDs.
	ConversionTaskIds []*string `locationName:"conversionTaskId" locationNameList:"item" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	Filters []*Filter `locationName:"filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeConversionTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConversionTasksInput) GoString() string {
	return s.String()
}

type DescribeConversionTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the conversion tasks.
	ConversionTasks []*ConversionTask `locationName:"conversionTasks" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeConversionTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConversionTasksOutput) GoString() string {
	return s.String()
}

type DescribeCustomerGatewaysInput struct {
	_ struct{} `type:"structure"`

	// One or more customer gateway IDs.
	//
	// Default: Describes all your customer gateways.
	CustomerGatewayIds []*string `locationName:"CustomerGatewayId" locationNameList:"CustomerGatewayId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   bgp-asn - The customer gateway's Border Gateway Protocol (BGP) Autonomous
	// System Number (ASN).
	//
	//   customer-gateway-id - The ID of the customer gateway.
	//
	//   ip-address - The IP address of the customer gateway's Internet-routable
	// external interface.
	//
	//   state - The state of the customer gateway (pending | available | deleting
	// | deleted).
	//
	//   type - The type of customer gateway. Currently, the only supported type
	// is ipsec.1.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeCustomerGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomerGatewaysInput) GoString() string {
	return s.String()
}

type DescribeCustomerGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more customer gateways.
	CustomerGateways []*CustomerGateway `locationName:"customerGatewaySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeCustomerGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomerGatewaysOutput) GoString() string {
	return s.String()
}

type DescribeDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of one or more DHCP options sets.
	//
	// Default: Describes all your DHCP options sets.
	DhcpOptionsIds []*string `locationName:"DhcpOptionsId" locationNameList:"DhcpOptionsId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   dhcp-options-id - The ID of a set of DHCP options.
	//
	//   key - The key for one of the options (for example, domain-name).
	//
	//   value - The value for one of the options.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDhcpOptionsInput) GoString() string {
	return s.String()
}

type DescribeDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more DHCP options sets.
	DhcpOptions []*DhcpOptions `locationName:"dhcpOptionsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDhcpOptionsOutput) GoString() string {
	return s.String()
}

type DescribeExportTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more export task IDs.
	ExportTaskIds []*string `locationName:"exportTaskId" locationNameList:"ExportTaskId" type:"list"`
}

// String returns the string representation
func (s DescribeExportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksInput) GoString() string {
	return s.String()
}

type DescribeExportTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the export tasks.
	ExportTasks []*ExportTask `locationName:"exportTaskSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeExportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksOutput) GoString() string {
	return s.String()
}

type DescribeFlowLogsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//  deliver-log-status - The status of the logs delivery (SUCCESS | FAILED).
	//
	// flow-log-id - The ID of the flow log.
	//
	// log-group-name - The name of the log group.
	//
	// resource-id - The ID of the VPC, subnet, or network interface.
	//
	// traffic-type - The type of traffic (ACCEPT | REJECT | ALL)
	Filter []*Filter `locationNameList:"Filter" type:"list"`

	// One or more flow log IDs.
	FlowLogIds []*string `locationName:"FlowLogId" locationNameList:"item" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the returned
	// NextToken value. This value can be between 5 and 1000; if MaxResults is given
	// a value larger than 1000, only 1000 results are returned. You cannot specify
	// this parameter and the flow log IDs parameter in the same request.
	MaxResults *int64 `type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeFlowLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowLogsInput) GoString() string {
	return s.String()
}

type DescribeFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the flow logs.
	FlowLogs []*FlowLog `locationName:"flowLogSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeFlowLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowLogsOutput) GoString() string {
	return s.String()
}

type DescribeHostsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//  instance-type - The instance type size that the Dedicated host is configured
	// to support.
	//
	// auto-placement - Whether auto-placement is enabled or disabled (on | off).
	//
	// host-reservation-id - The ID of the reservation associated with this host.
	//
	// client-token - The idempotency token you provided when you launched the
	// instance
	//
	// state- The allocation state of the Dedicated host (available | under-assessment
	// | permanent-failure | released | released-permanent-failure).
	//
	// availability-zone - The Availability Zone of the host.
	Filter []*Filter `locationName:"filter" locationNameList:"Filter" type:"list"`

	// The IDs of the Dedicated hosts. The IDs are used for targeted instance launches.
	HostIds []*string `locationName:"hostId" locationNameList:"item" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500; if maxResults is given
	// a larger value than 500, you will receive an error. You cannot specify this
	// parameter and the host IDs parameter in the same request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeHostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostsInput) GoString() string {
	return s.String()
}

type DescribeHostsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Dedicated hosts.
	Hosts []*Host `locationName:"hostSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeHostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostsOutput) GoString() string {
	return s.String()
}

type DescribeIdFormatInput struct {
	_ struct{} `type:"structure"`

	// The type of resource.
	Resource *string `type:"string"`
}

// String returns the string representation
func (s DescribeIdFormatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdFormatInput) GoString() string {
	return s.String()
}

type DescribeIdFormatOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ID format for the resource.
	Statuses []*IdFormat `locationName:"statusSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeIdFormatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdFormatOutput) GoString() string {
	return s.String()
}

type DescribeImageAttributeInput struct {
	_ struct{} `type:"structure"`

	// The AMI attribute.
	//
	// Note: Depending on your account privileges, the blockDeviceMapping attribute
	// may return a Client.AuthFailure error. If this happens, use DescribeImages
	// to get information about the block device mapping for the AMI.
	Attribute *string `type:"string" required:"true" enum:"ImageAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeImageAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageAttributeInput) GoString() string {
	return s.String()
}

// Describes an image attribute.
type DescribeImageAttributeOutput struct {
	_ struct{} `type:"structure"`

	// One or more block device mapping entries.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// A description for the AMI.
	Description *AttributeValue `locationName:"description" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The kernel ID.
	KernelId *AttributeValue `locationName:"kernel" type:"structure"`

	// One or more launch permissions.
	LaunchPermissions []*LaunchPermission `locationName:"launchPermission" locationNameList:"item" type:"list"`

	// One or more product codes.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// The RAM disk ID.
	RamdiskId *AttributeValue `locationName:"ramdisk" type:"structure"`

	// The value to use for a resource attribute.
	SriovNetSupport *AttributeValue `locationName:"sriovNetSupport" type:"structure"`
}

// String returns the string representation
func (s DescribeImageAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageAttributeOutput) GoString() string {
	return s.String()
}

type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Scopes the images by users with explicit launch permissions. Specify an AWS
	// account ID, self (the sender of the request), or all (public AMIs).
	ExecutableUsers []*string `locationName:"ExecutableBy" locationNameList:"ExecutableBy" type:"list"`

	// One or more filters.
	//
	//   architecture - The image architecture (i386 | x86_64).
	//
	//   block-device-mapping.delete-on-termination - A Boolean value that indicates
	// whether the Amazon EBS volume is deleted on instance termination.
	//
	//   block-device-mapping.device-name - The device name for the EBS volume
	// (for example, /dev/sdh).
	//
	//   block-device-mapping.snapshot-id - The ID of the snapshot used for the
	// EBS volume.
	//
	//   block-device-mapping.volume-size - The volume size of the EBS volume,
	// in GiB.
	//
	//   block-device-mapping.volume-type - The volume type of the EBS volume (gp2
	// | standard | io1).
	//
	//   description - The description of the image (provided during image creation).
	//
	//   hypervisor - The hypervisor type (ovm | xen).
	//
	//   image-id - The ID of the image.
	//
	//   image-type - The image type (machine | kernel | ramdisk).
	//
	//   is-public - A Boolean that indicates whether the image is public.
	//
	//   kernel-id - The kernel ID.
	//
	//   manifest-location - The location of the image manifest.
	//
	//   name - The name of the AMI (provided during image creation).
	//
	//   owner-alias - The AWS account alias (for example, amazon).
	//
	//   owner-id - The AWS account ID of the image owner.
	//
	//   platform - The platform. To only list Windows-based AMIs, use windows.
	//
	//   product-code - The product code.
	//
	//   product-code.type - The type of the product code (devpay | marketplace).
	//
	//   ramdisk-id - The RAM disk ID.
	//
	//   root-device-name - The name of the root device volume (for example, /dev/sda1).
	//
	//   root-device-type - The type of the root device volume (ebs | instance-store).
	//
	//   state - The state of the image (available | pending | failed).
	//
	//   state-reason-code - The reason code for the state change.
	//
	//   state-reason-message - The message for the state change.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   virtualization-type - The virtualization type (paravirtual | hvm).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more image IDs.
	//
	// Default: Describes all images available to you.
	ImageIds []*string `locationName:"ImageId" locationNameList:"ImageId" type:"list"`

	// Filters the images by the owner. Specify an AWS account ID, amazon (owner
	// is Amazon), aws-marketplace (owner is AWS Marketplace), self (owner is the
	// sender of the request). Omitting this option returns all images for which
	// you have launch permissions, regardless of ownership.
	Owners []*string `locationName:"Owner" locationNameList:"Owner" type:"list"`
}

// String returns the string representation
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesInput) GoString() string {
	return s.String()
}

type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more images.
	Images []*Image `locationName:"imagesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesOutput) GoString() string {
	return s.String()
}

type DescribeImportImageTasksInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// A list of import image task IDs.
	ImportTaskIds []*string `locationName:"ImportTaskId" locationNameList:"ImportTaskId" type:"list"`

	// The maximum number of results to return in a single request.
	MaxResults *int64 `type:"integer"`

	// A token that indicates the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeImportImageTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportImageTasksInput) GoString() string {
	return s.String()
}

type DescribeImportImageTasksOutput struct {
	_ struct{} `type:"structure"`

	// A list of zero or more import image tasks that are currently active or were
	// completed or canceled in the previous 7 days.
	ImportImageTasks []*ImportImageTask `locationName:"importImageTaskSet" locationNameList:"item" type:"list"`

	// The token to use to get the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImportImageTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportImageTasksOutput) GoString() string {
	return s.String()
}

type DescribeImportSnapshotTasksInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// A list of import snapshot task IDs.
	ImportTaskIds []*string `locationName:"ImportTaskId" locationNameList:"ImportTaskId" type:"list"`

	// The maximum number of results to return in a single request.
	MaxResults *int64 `type:"integer"`

	// A token that indicates the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeImportSnapshotTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportSnapshotTasksInput) GoString() string {
	return s.String()
}

type DescribeImportSnapshotTasksOutput struct {
	_ struct{} `type:"structure"`

	// A list of zero or more import snapshot tasks that are currently active or
	// were completed or canceled in the previous 7 days.
	ImportSnapshotTasks []*ImportSnapshotTask `locationName:"importSnapshotTaskSet" locationNameList:"item" type:"list"`

	// The token to use to get the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImportSnapshotTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportSnapshotTasksOutput) GoString() string {
	return s.String()
}

type DescribeInstanceAttributeInput struct {
	_ struct{} `type:"structure"`

	// The instance attribute.
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"InstanceAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInstanceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAttributeInput) GoString() string {
	return s.String()
}

// Describes an instance attribute.
type DescribeInstanceAttributeOutput struct {
	_ struct{} `type:"structure"`

	// The block device mapping of the instance.
	BlockDeviceMappings []*InstanceBlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// If the value is true, you can't terminate the instance through the Amazon
	// EC2 console, CLI, or API; otherwise, you can.
	DisableApiTermination *AttributeBooleanValue `locationName:"disableApiTermination" type:"structure"`

	// Indicates whether the instance is optimized for EBS I/O.
	EbsOptimized *AttributeBooleanValue `locationName:"ebsOptimized" type:"structure"`

	// The security groups associated with the instance.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Indicates whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	InstanceInitiatedShutdownBehavior *AttributeValue `locationName:"instanceInitiatedShutdownBehavior" type:"structure"`

	// The instance type.
	InstanceType *AttributeValue `locationName:"instanceType" type:"structure"`

	// The kernel ID.
	KernelId *AttributeValue `locationName:"kernel" type:"structure"`

	// A list of product codes.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// The RAM disk ID.
	RamdiskId *AttributeValue `locationName:"ramdisk" type:"structure"`

	// The name of the root device (for example, /dev/sda1 or /dev/xvda).
	RootDeviceName *AttributeValue `locationName:"rootDeviceName" type:"structure"`

	// Indicates whether source/destination checking is enabled. A value of true
	// means checking is enabled, and false means checking is disabled. This value
	// must be false for a NAT instance to perform NAT.
	SourceDestCheck *AttributeBooleanValue `locationName:"sourceDestCheck" type:"structure"`

	// The value to use for a resource attribute.
	SriovNetSupport *AttributeValue `locationName:"sriovNetSupport" type:"structure"`

	// The Base64-encoded MIME user data.
	UserData *AttributeValue `locationName:"userData" type:"structure"`
}

// String returns the string representation
func (s DescribeInstanceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAttributeOutput) GoString() string {
	return s.String()
}

type DescribeInstanceStatusInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   availability-zone - The Availability Zone of the instance.
	//
	//   event.code - The code for the scheduled event (instance-reboot | system-reboot
	// | system-maintenance | instance-retirement | instance-stop).
	//
	//   event.description - A description of the event.
	//
	//   event.not-after - The latest end time for the scheduled event (for example,
	// 2014-09-15T17:15:20.000Z).
	//
	//   event.not-before - The earliest start time for the scheduled event (for
	// example, 2014-09-15T17:15:20.000Z).
	//
	//   instance-state-code - The code for the instance state, as a 16-bit unsigned
	// integer. The high byte is an opaque internal value and should be ignored.
	// The low byte is set based on the state represented. The valid values are
	// 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping),
	// and 80 (stopped).
	//
	//   instance-state-name - The state of the instance (pending | running | shutting-down
	// | terminated | stopping | stopped).
	//
	//   instance-status.reachability - Filters on instance status where the name
	// is reachability (passed | failed | initializing | insufficient-data).
	//
	//   instance-status.status - The status of the instance (ok | impaired | initializing
	// | insufficient-data | not-applicable).
	//
	//   system-status.reachability - Filters on system status where the name is
	// reachability (passed | failed | initializing | insufficient-data).
	//
	//   system-status.status - The system status of the instance (ok | impaired
	// | initializing | insufficient-data | not-applicable).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// When true, includes the health status for all instances. When false, includes
	// the health status for running instances only.
	//
	// Default: false
	IncludeAllInstances *bool `locationName:"includeAllInstances" type:"boolean"`

	// One or more instance IDs.
	//
	// Default: Describes all your instances.
	//
	// Constraints: Maximum 100 explicitly specified instance IDs.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value larger than 1000, only 1000 results
	// are returned. You cannot specify this parameter and the instance IDs parameter
	// in the same request.
	MaxResults *int64 `type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceStatusInput) GoString() string {
	return s.String()
}

type DescribeInstanceStatusOutput struct {
	_ struct{} `type:"structure"`

	// One or more instance status descriptions.
	InstanceStatuses []*InstanceStatus `locationName:"instanceStatusSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeInstanceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceStatusOutput) GoString() string {
	return s.String()
}

type DescribeInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   affinity - The affinity setting for an instance running on a Dedicated
	// host (default | host).
	//
	//   architecture - The instance architecture (i386 | x86_64).
	//
	//   availability-zone - The Availability Zone of the instance.
	//
	//   block-device-mapping.attach-time - The attach time for an EBS volume mapped
	// to the instance, for example, 2010-09-15T17:15:20.000Z.
	//
	//   block-device-mapping.delete-on-termination - A Boolean that indicates
	// whether the EBS volume is deleted on instance termination.
	//
	//   block-device-mapping.device-name - The device name for the EBS volume
	// (for example, /dev/sdh or xvdh).
	//
	//   block-device-mapping.status - The status for the EBS volume (attaching
	// | attached | detaching | detached).
	//
	//   block-device-mapping.volume-id - The volume ID of the EBS volume.
	//
	//   client-token - The idempotency token you provided when you launched the
	// instance.
	//
	//   dns-name - The public DNS name of the instance.
	//
	//   group-id - The ID of the security group for the instance. EC2-Classic
	// only.
	//
	//   group-name - The name of the security group for the instance. EC2-Classic
	// only.
	//
	//   host-Id - The ID of the Dedicated host on which the instance is running,
	// if applicable.
	//
	//   hypervisor - The hypervisor type of the instance (ovm | xen).
	//
	//   iam-instance-profile.arn - The instance profile associated with the instance.
	// Specified as an ARN.
	//
	//   image-id - The ID of the image used to launch the instance.
	//
	//   instance-id - The ID of the instance.
	//
	//   instance-lifecycle - Indicates whether this is a Spot Instance (spot).
	//
	//   instance-state-code - The state of the instance, as a 16-bit unsigned
	// integer. The high byte is an opaque internal value and should be ignored.
	// The low byte is set based on the state represented. The valid values are:
	// 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping),
	// and 80 (stopped).
	//
	//   instance-state-name - The state of the instance (pending | running | shutting-down
	// | terminated | stopping | stopped).
	//
	//   instance-type - The type of instance (for example, t2.micro).
	//
	//   instance.group-id - The ID of the security group for the instance.
	//
	//   instance.group-name - The name of the security group for the instance.
	//
	//   ip-address - The public IP address of the instance.
	//
	//   kernel-id - The kernel ID.
	//
	//   key-name - The name of the key pair used when the instance was launched.
	//
	//   launch-index - When launching multiple instances, this is the index for
	// the instance in the launch group (for example, 0, 1, 2, and so on).
	//
	//   launch-time - The time when the instance was launched.
	//
	//   monitoring-state - Indicates whether monitoring is enabled for the instance
	// (disabled | enabled).
	//
	//   owner-id - The AWS account ID of the instance owner.
	//
	//   placement-group-name - The name of the placement group for the instance.
	//
	//   platform - The platform. Use windows if you have Windows instances; otherwise,
	// leave blank.
	//
	//   private-dns-name - The private DNS name of the instance.
	//
	//   private-ip-address - The private IP address of the instance.
	//
	//   product-code - The product code associated with the AMI used to launch
	// the instance.
	//
	//   product-code.type - The type of product code (devpay | marketplace).
	//
	//   ramdisk-id - The RAM disk ID.
	//
	//   reason - The reason for the current state of the instance (for example,
	// shows "User Initiated [date]" when you stop or terminate the instance). Similar
	// to the state-reason-code filter.
	//
	//   requester-id - The ID of the entity that launched the instance on your
	// behalf (for example, AWS Management Console, Auto Scaling, and so on).
	//
	//   reservation-id - The ID of the instance's reservation. A reservation ID
	// is created any time you launch an instance. A reservation ID has a one-to-one
	// relationship with an instance launch request, but can be associated with
	// more than one instance if you launch multiple instances using the same launch
	// request. For example, if you launch one instance, you'll get one reservation
	// ID. If you launch ten instances using the same launch request, you'll also
	// get one reservation ID.
	//
	//   root-device-name - The name of the root device for the instance (for example,
	// /dev/sda1 or /dev/xvda).
	//
	//   root-device-type - The type of root device that the instance uses (ebs
	// | instance-store).
	//
	//   source-dest-check - Indicates whether the instance performs source/destination
	// checking. A value of true means that checking is enabled, and false means
	// checking is disabled. The value must be false for the instance to perform
	// network address translation (NAT) in your VPC.
	//
	//   spot-instance-request-id - The ID of the Spot instance request.
	//
	//   state-reason-code - The reason code for the state change.
	//
	//   state-reason-message - A message that describes the state change.
	//
	//   subnet-id - The ID of the subnet for the instance.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource,
	// where tag:key is the tag's key.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   tenancy - The tenancy of an instance (dedicated | default | host).
	//
	//   virtualization-type - The virtualization type of the instance (paravirtual
	// | hvm).
	//
	//   vpc-id - The ID of the VPC that the instance is running in.
	//
	//   network-interface.description - The description of the network interface.
	//
	//   network-interface.subnet-id - The ID of the subnet for the network interface.
	//
	//   network-interface.vpc-id - The ID of the VPC for the network interface.
	//
	//   network-interface.network-interface-id - The ID of the network interface.
	//
	//   network-interface.owner-id - The ID of the owner of the network interface.
	//
	//   network-interface.availability-zone - The Availability Zone for the network
	// interface.
	//
	//   network-interface.requester-id - The requester ID for the network interface.
	//
	//   network-interface.requester-managed - Indicates whether the network interface
	// is being managed by AWS.
	//
	//   network-interface.status - The status of the network interface (available)
	// | in-use).
	//
	//   network-interface.mac-address - The MAC address of the network interface.
	//
	//   network-interface-private-dns-name - The private DNS name of the network
	// interface.
	//
	//   network-interface.source-dest-check - Whether the network interface performs
	// source/destination checking. A value of true means checking is enabled, and
	// false means checking is disabled. The value must be false for the network
	// interface to perform network address translation (NAT) in your VPC.
	//
	//   network-interface.group-id - The ID of a security group associated with
	// the network interface.
	//
	//   network-interface.group-name - The name of a security group associated
	// with the network interface.
	//
	//   network-interface.attachment.attachment-id - The ID of the interface attachment.
	//
	//   network-interface.attachment.instance-id - The ID of the instance to which
	// the network interface is attached.
	//
	//   network-interface.attachment.instance-owner-id - The owner ID of the instance
	// to which the network interface is attached.
	//
	//   network-interface.addresses.private-ip-address - The private IP address
	// associated with the network interface.
	//
	//   network-interface.attachment.device-index - The device index to which
	// the network interface is attached.
	//
	//   network-interface.attachment.status - The status of the attachment (attaching
	// | attached | detaching | detached).
	//
	//   network-interface.attachment.attach-time - The time that the network interface
	// was attached to an instance.
	//
	//   network-interface.attachment.delete-on-termination - Specifies whether
	// the attachment is deleted when an instance is terminated.
	//
	//   network-interface.addresses.primary - Specifies whether the IP address
	// of the network interface is the primary private IP address.
	//
	//   network-interface.addresses.association.public-ip - The ID of the association
	// of an Elastic IP address with a network interface.
	//
	//   network-interface.addresses.association.ip-owner-id - The owner ID of
	// the private IP address associated with the network interface.
	//
	//   association.public-ip - The address of the Elastic IP address bound to
	// the network interface.
	//
	//   association.ip-owner-id - The owner of the Elastic IP address associated
	// with the network interface.
	//
	//   association.allocation-id - The allocation ID returned when you allocated
	// the Elastic IP address for your network interface.
	//
	//   association.association-id - The association ID returned when the network
	// interface was associated with an IP address.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more instance IDs.
	//
	// Default: Describes all your instances.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value larger than 1000, only 1000 results
	// are returned. You cannot specify this parameter and the instance IDs parameter
	// in the same request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesInput) GoString() string {
	return s.String()
}

type DescribeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Zero or more reservations.
	Reservations []*Reservation `locationName:"reservationSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesOutput) GoString() string {
	return s.String()
}

type DescribeInternetGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   attachment.state - The current state of the attachment between the gateway
	// and the VPC (available). Present only if a VPC is attached.
	//
	//   attachment.vpc-id - The ID of an attached VPC.
	//
	//   internet-gateway-id - The ID of the Internet gateway.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more Internet gateway IDs.
	//
	// Default: Describes all your Internet gateways.
	InternetGatewayIds []*string `locationName:"internetGatewayId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeInternetGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInternetGatewaysInput) GoString() string {
	return s.String()
}

type DescribeInternetGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more Internet gateways.
	InternetGateways []*InternetGateway `locationName:"internetGatewaySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeInternetGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInternetGatewaysOutput) GoString() string {
	return s.String()
}

type DescribeKeyPairsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   fingerprint - The fingerprint of the key pair.
	//
	//   key-name - The name of the key pair.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more key pair names.
	//
	// Default: Describes all your key pairs.
	KeyNames []*string `locationName:"KeyName" locationNameList:"KeyName" type:"list"`
}

// String returns the string representation
func (s DescribeKeyPairsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyPairsInput) GoString() string {
	return s.String()
}

type DescribeKeyPairsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more key pairs.
	KeyPairs []*KeyPairInfo `locationName:"keySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeKeyPairsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyPairsOutput) GoString() string {
	return s.String()
}

type DescribeMovingAddressesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   moving-status - The status of the Elastic IP address (MovingToVpc | RestoringToClassic).
	Filters []*Filter `locationName:"filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value outside of this range, an error is returned.
	//
	// Default: If no value is provided, the default is 1000.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// One or more Elastic IP addresses.
	PublicIps []*string `locationName:"publicIp" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeMovingAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMovingAddressesInput) GoString() string {
	return s.String()
}

type DescribeMovingAddressesOutput struct {
	_ struct{} `type:"structure"`

	// The status for each Elastic IP address.
	MovingAddressStatuses []*MovingAddressStatus `locationName:"movingAddressStatusSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeMovingAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMovingAddressesOutput) GoString() string {
	return s.String()
}

type DescribeNatGatewaysInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//   nat-gateway-id - The ID of the NAT gateway.
	//
	//   state - The state of the NAT gateway (pending | failed | available | deleting
	// | deleted).
	//
	//   subnet-id - The ID of the subnet in which the NAT gateway resides.
	//
	//   vpc-id - The ID of the VPC in which the NAT gateway resides.
	Filter []*Filter `locationNameList:"Filter" type:"list"`

	// The maximum number of items to return for this request. The request returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	//
	// Constraint: If the value specified is greater than 1000, we return only
	// 1000 items.
	MaxResults *int64 `type:"integer"`

	// One or more NAT gateway IDs.
	NatGatewayIds []*string `locationName:"NatGatewayId" locationNameList:"item" type:"list"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeNatGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNatGatewaysInput) GoString() string {
	return s.String()
}

type DescribeNatGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about the NAT gateways.
	NatGateways []*NatGateway `locationName:"natGatewaySet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeNatGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNatGatewaysOutput) GoString() string {
	return s.String()
}

type DescribeNetworkAclsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   association.association-id - The ID of an association ID for the ACL.
	//
	//   association.network-acl-id - The ID of the network ACL involved in the
	// association.
	//
	//   association.subnet-id - The ID of the subnet involved in the association.
	//
	//   default - Indicates whether the ACL is the default network ACL for the
	// VPC.
	//
	//   entry.cidr - The CIDR range specified in the entry.
	//
	//   entry.egress - Indicates whether the entry applies to egress traffic.
	//
	//   entry.icmp.code - The ICMP code specified in the entry, if any.
	//
	//   entry.icmp.type - The ICMP type specified in the entry, if any.
	//
	//   entry.port-range.from - The start of the port range specified in the entry.
	//
	//   entry.port-range.to - The end of the port range specified in the entry.
	//
	//   entry.protocol - The protocol specified in the entry (tcp | udp | icmp
	// or a protocol number).
	//
	//   entry.rule-action - Allows or denies the matching traffic (allow | deny).
	//
	//   entry.rule-number - The number of an entry (in other words, rule) in the
	// ACL's set of entries.
	//
	//   network-acl-id - The ID of the network ACL.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   vpc-id - The ID of the VPC for the network ACL.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more network ACL IDs.
	//
	// Default: Describes all your network ACLs.
	NetworkAclIds []*string `locationName:"NetworkAclId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeNetworkAclsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNetworkAclsInput) GoString() string {
	return s.String()
}

type DescribeNetworkAclsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more network ACLs.
	NetworkAcls []*NetworkAcl `locationName:"networkAclSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeNetworkAclsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNetworkAclsOutput) GoString() string {
	return s.String()
}

type DescribeNetworkInterfaceAttributeInput struct {
	_ struct{} `type:"structure"`

	// The attribute of the network interface.
	Attribute *string `locationName:"attribute" type:"string" enum:"NetworkInterfaceAttribute"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNetworkInterfaceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNetworkInterfaceAttributeInput) GoString() string {
	return s.String()
}

type DescribeNetworkInterfaceAttributeOutput struct {
	_ struct{} `type:"structure"`

	// The attachment (if any) of the network interface.
	Attachment *NetworkInterfaceAttachment `locationName:"attachment" type:"structure"`

	// The description of the network interface.
	Description *AttributeValue `locationName:"description" type:"structure"`

	// The security groups associated with the network interface.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// Indicates whether source/destination checking is enabled.
	SourceDestCheck *AttributeBooleanValue `locationName:"sourceDestCheck" type:"structure"`
}

// String returns the string representation
func (s DescribeNetworkInterfaceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNetworkInterfaceAttributeOutput) GoString() string {
	return s.String()
}

type DescribeNetworkInterfacesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   addresses.private-ip-address - The private IP addresses associated with
	// the network interface.
	//
	//   addresses.primary - Whether the private IP address is the primary IP address
	// associated with the network interface.
	//
	//   addresses.association.public-ip - The association ID returned when the
	// network interface was associated with the Elastic IP address.
	//
	//   addresses.association.owner-id - The owner ID of the addresses associated
	// with the network interface.
	//
	//   association.association-id - The association ID returned when the network
	// interface was associated with an IP address.
	//
	//   association.allocation-id - The allocation ID returned when you allocated
	// the Elastic IP address for your network interface.
	//
	//   association.ip-owner-id - The owner of the Elastic IP address associated
	// with the network interface.
	//
	//   association.public-ip - The address of the Elastic IP address bound to
	// the network interface.
	//
	//   association.public-dns-name - The public DNS name for the network interface.
	//
	//   attachment.attachment-id - The ID of the interface attachment.
	//
	//   attachment.attach.time - The time that the network interface was attached
	// to an instance.
	//
	//   attachment.delete-on-termination - Indicates whether the attachment is
	// deleted when an instance is terminated.
	//
	//   attachment.device-index - The device index to which the network interface
	// is attached.
	//
	//   attachment.instance-id - The ID of the instance to which the network interface
	// is attached.
	//
	//   attachment.instance-owner-id - The owner ID of the instance to which the
	// network interface is attached.
	//
	//   attachment.nat-gateway-id - The ID of the NAT gateway to which the network
	// interface is attached.
	//
	//   attachment.status - The status of the attachment (attaching | attached
	// | detaching | detached).
	//
	//   availability-zone - The Availability Zone of the network interface.
	//
	//   description - The description of the network interface.
	//
	//   group-id - The ID of a security group associated with the network interface.
	//
	//   group-name - The name of a security group associated with the network
	// interface.
	//
	//   mac-address - The MAC address of the network interface.
	//
	//   network-interface-id - The ID of the network interface.
	//
	//   owner-id - The AWS account ID of the network interface owner.
	//
	//   private-ip-address - The private IP address or addresses of the network
	// interface.
	//
	//   private-dns-name - The private DNS name of the network interface.
	//
	//   requester-id - The ID of the entity that launched the instance on your
	// behalf (for example, AWS Management Console, Auto Scaling, and so on).
	//
	//   requester-managed - Indicates whether the network interface is being managed
	// by an AWS service (for example, AWS Management Console, Auto Scaling, and
	// so on).
	//
	//   source-desk-check - Indicates whether the network interface performs source/destination
	// checking. A value of true means checking is enabled, and false means checking
	// is disabled. The value must be false for the network interface to perform
	// network address translation (NAT) in your VPC.
	//
	//   status - The status of the network interface. If the network interface
	// is not attached to an instance, the status is available; if a network interface
	// is attached to an instance the status is in-use.
	//
	//   subnet-id - The ID of the subnet for the network interface.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   vpc-id - The ID of the VPC for the network interface.
	Filters []*Filter `locationName:"filter" locationNameList:"Filter" type:"list"`

	// One or more network interface IDs.
	//
	// Default: Describes all your network interfaces.
	NetworkInterfaceIds []*string `locationName:"NetworkInterfaceId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeNetworkInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNetworkInterfacesInput) GoString() string {
	return s.String()
}

type DescribeNetworkInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more network interfaces.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeNetworkInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNetworkInterfacesOutput) GoString() string {
	return s.String()
}

type DescribePlacementGroupsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   group-name - The name of the placement group.
	//
	//   state - The state of the placement group (pending | available | deleting
	// | deleted).
	//
	//   strategy - The strategy of the placement group (cluster).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more placement group names.
	//
	// Default: Describes all your placement groups, or only those otherwise specified.
	GroupNames []*string `locationName:"groupName" type:"list"`
}

// String returns the string representation
func (s DescribePlacementGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlacementGroupsInput) GoString() string {
	return s.String()
}

type DescribePlacementGroupsOutput struct {
	_ struct{} `type:"structure"`

	// One or more placement groups.
	PlacementGroups []*PlacementGroup `locationName:"placementGroupSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribePlacementGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlacementGroupsOutput) GoString() string {
	return s.String()
}

type DescribePrefixListsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//   prefix-list-id: The ID of a prefix list.
	//
	//   prefix-list-name: The name of a prefix list.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of items to return for this request. The request returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	//
	// Constraint: If the value specified is greater than 1000, we return only
	// 1000 items.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a prior call.)
	NextToken *string `type:"string"`

	// One or more prefix list IDs.
	PrefixListIds []*string `locationName:"PrefixListId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribePrefixListsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePrefixListsInput) GoString() string {
	return s.String()
}

type DescribePrefixListsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `locationName:"nextToken" type:"string"`

	// All available prefix lists.
	PrefixLists []*PrefixList `locationName:"prefixListSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribePrefixListsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePrefixListsOutput) GoString() string {
	return s.String()
}

type DescribeRegionsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   endpoint - The endpoint of the region (for example, ec2.us-east-1.amazonaws.com).
	//
	//   region-name - The name of the region (for example, us-east-1).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The names of one or more regions.
	RegionNames []*string `locationName:"RegionName" locationNameList:"RegionName" type:"list"`
}

// String returns the string representation
func (s DescribeRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRegionsInput) GoString() string {
	return s.String()
}

type DescribeRegionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more regions.
	Regions []*Region `locationName:"regionInfo" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRegionsOutput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   availability-zone - The Availability Zone where the Reserved instance
	// can be used.
	//
	//   duration - The duration of the Reserved instance (one year or three years),
	// in seconds (31536000 | 94608000).
	//
	//   end - The time when the Reserved instance expires (for example, 2015-08-07T11:54:42.000Z).
	//
	//   fixed-price - The purchase price of the Reserved instance (for example,
	// 9800.0).
	//
	//   instance-type - The instance type that is covered by the reservation.
	//
	//   product-description - The Reserved instance product platform description.
	// Instances that include (Amazon VPC) in the product platform description will
	// only be displayed to EC2-Classic account holders and are for use with Amazon
	// VPC (Linux/UNIX | Linux/UNIX (Amazon VPC) | SUSE Linux | SUSE Linux (Amazon
	// VPC) | Red Hat Enterprise Linux | Red Hat Enterprise Linux (Amazon VPC) |
	// Windows | Windows (Amazon VPC) | Windows with SQL Server Standard | Windows
	// with SQL Server Standard (Amazon VPC) | Windows with SQL Server Web | Windows
	// with SQL Server Web (Amazon VPC) | Windows with SQL Server Enterprise | Windows
	// with SQL Server Enterprise (Amazon VPC)).
	//
	//   reserved-instances-id - The ID of the Reserved instance.
	//
	//   start - The time at which the Reserved instance purchase request was placed
	// (for example, 2014-08-07T11:54:42.000Z).
	//
	//   state - The state of the Reserved instance (payment-pending | active |
	// payment-failed | retired).
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   usage-price - The usage price of the Reserved instance, per hour (for
	// example, 0.84).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The Reserved instance offering type. If you are using tools that predate
	// the 2011-11-01 API version, you only have access to the Medium Utilization
	// Reserved instance offering type.
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingTypeValues"`

	// One or more Reserved instance IDs.
	//
	// Default: Describes all your Reserved instances, or only those otherwise
	// specified.
	ReservedInstancesIds []*string `locationName:"ReservedInstancesId" locationNameList:"ReservedInstancesId" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesInput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesListingsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//   reserved-instances-id - The ID of the Reserved instances.
	//
	//   reserved-instances-listing-id - The ID of the Reserved instances listing.
	//
	//   status - The status of the Reserved instance listing (pending | active
	// | cancelled | closed).
	//
	//   status-message - The reason for the status.
	Filters []*Filter `locationName:"filters" locationNameList:"Filter" type:"list"`

	// One or more Reserved instance IDs.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// One or more Reserved instance Listing IDs.
	ReservedInstancesListingId *string `locationName:"reservedInstancesListingId" type:"string"`
}

// String returns the string representation
func (s DescribeReservedInstancesListingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesListingsInput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesListingsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Reserved instance listing.
	ReservedInstancesListings []*ReservedInstancesListing `locationName:"reservedInstancesListingsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesListingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesListingsOutput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesModificationsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//   client-token - The idempotency token for the modification request.
	//
	//   create-date - The time when the modification request was created.
	//
	//   effective-date - The time when the modification becomes effective.
	//
	//   modification-result.reserved-instances-id - The ID for the Reserved instances
	// created as part of the modification request. This ID is only available when
	// the status of the modification is fulfilled.
	//
	//   modification-result.target-configuration.availability-zone - The Availability
	// Zone for the new Reserved instances.
	//
	//   modification-result.target-configuration.instance-count  - The number
	// of new Reserved instances.
	//
	//   modification-result.target-configuration.instance-type - The instance
	// type of the new Reserved instances.
	//
	//   modification-result.target-configuration.platform - The network platform
	// of the new Reserved instances (EC2-Classic | EC2-VPC).
	//
	//   reserved-instances-id - The ID of the Reserved instances modified.
	//
	//   reserved-instances-modification-id - The ID of the modification request.
	//
	//   status - The status of the Reserved instances modification request (processing
	// | fulfilled | failed).
	//
	//   status-message - The reason for the status.
	//
	//   update-date - The time when the modification request was last updated.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The token to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// IDs for the submitted modification request.
	ReservedInstancesModificationIds []*string `locationName:"ReservedInstancesModificationId" locationNameList:"ReservedInstancesModificationId" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesModificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesModificationsInput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesModificationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Reserved instance modification information.
	ReservedInstancesModifications []*ReservedInstancesModification `locationName:"reservedInstancesModificationsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesModificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesModificationsOutput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesOfferingsInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the Reserved instance can be used.
	AvailabilityZone *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   availability-zone - The Availability Zone where the Reserved instance
	// can be used.
	//
	//   duration - The duration of the Reserved instance (for example, one year
	// or three years), in seconds (31536000 | 94608000).
	//
	//   fixed-price - The purchase price of the Reserved instance (for example,
	// 9800.0).
	//
	//   instance-type - The instance type that is covered by the reservation.
	//
	//   marketplace - Set to true to show only Reserved Instance Marketplace offerings.
	// When this filter is not used, which is the default behavior, all offerings
	// from both AWS and the Reserved Instance Marketplace are listed.
	//
	//   product-description - The Reserved instance product platform description.
	// Instances that include (Amazon VPC) in the product platform description will
	// only be displayed to EC2-Classic account holders and are for use with Amazon
	// VPC. (Linux/UNIX | Linux/UNIX (Amazon VPC) | SUSE Linux | SUSE Linux (Amazon
	// VPC) | Red Hat Enterprise Linux | Red Hat Enterprise Linux (Amazon VPC) |
	// Windows | Windows (Amazon VPC) | Windows with SQL Server Standard | Windows
	// with SQL Server Standard (Amazon VPC) | Windows with SQL Server Web |  Windows
	// with SQL Server Web (Amazon VPC) | Windows with SQL Server Enterprise | Windows
	// with SQL Server Enterprise (Amazon VPC))
	//
	//   reserved-instances-offering-id - The Reserved instances' offering ID.
	//
	//   usage-price - The usage price of the Reserved instance, per hour (for
	// example, 0.84).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// Include Reserved Instance Marketplace offerings in the response.
	IncludeMarketplace *bool `type:"boolean"`

	// The tenancy of the instances covered by the reservation. A Reserved instance
	// with a tenancy of dedicated is applied to instances that run in a VPC on
	// single-tenant hardware (i.e., Dedicated instances).
	//
	// Default: default
	InstanceTenancy *string `locationName:"instanceTenancy" type:"string" enum:"Tenancy"`

	// The instance type that the reservation will cover (for example, m1.small).
	// For more information, see Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType *string `type:"string" enum:"InstanceType"`

	// The maximum duration (in seconds) to filter when searching for offerings.
	//
	// Default: 94608000 (3 years)
	MaxDuration *int64 `type:"long"`

	// The maximum number of instances to filter when searching for offerings.
	//
	// Default: 20
	MaxInstanceCount *int64 `type:"integer"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. The maximum is 100.
	//
	// Default: 100
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The minimum duration (in seconds) to filter when searching for offerings.
	//
	// Default: 2592000 (1 month)
	MinDuration *int64 `type:"long"`

	// The token to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Reserved instance offering type. If you are using tools that predate
	// the 2011-11-01 API version, you only have access to the Medium Utilization
	// Reserved instance offering type.
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingTypeValues"`

	// The Reserved instance product platform description. Instances that include
	// (Amazon VPC) in the description are for use with Amazon VPC.
	ProductDescription *string `type:"string" enum:"RIProductDescription"`

	// One or more Reserved instances offering IDs.
	ReservedInstancesOfferingIds []*string `locationName:"ReservedInstancesOfferingId" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesOfferingsInput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of Reserved instances offerings.
	ReservedInstancesOfferings []*ReservedInstancesOffering `locationName:"reservedInstancesOfferingsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesOfferingsOutput) GoString() string {
	return s.String()
}

type DescribeReservedInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of Reserved instances.
	ReservedInstances []*ReservedInstances `locationName:"reservedInstancesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedInstancesOutput) GoString() string {
	return s.String()
}

type DescribeRouteTablesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   association.route-table-association-id - The ID of an association ID for
	// the route table.
	//
	//   association.route-table-id - The ID of the route table involved in the
	// association.
	//
	//   association.subnet-id - The ID of the subnet involved in the association.
	//
	//   association.main - Indicates whether the route table is the main route
	// table for the VPC (true | false).
	//
	//   route-table-id - The ID of the route table.
	//
	//   route.destination-cidr-block - The CIDR range specified in a route in
	// the table.
	//
	//   route.destination-prefix-list-id - The ID (prefix) of the AWS service
	// specified in a route in the table.
	//
	//   route.gateway-id - The ID of a gateway specified in a route in the table.
	//
	//   route.instance-id - The ID of an instance specified in a route in the
	// table.
	//
	//   route.nat-gateway-id - The ID of a NAT gateway.
	//
	//   route.origin - Describes how the route was created. CreateRouteTable indicates
	// that the route was automatically created when the route table was created;
	// CreateRoute indicates that the route was manually added to the route table;
	// EnableVgwRoutePropagation indicates that the route was propagated by route
	// propagation.
	//
	//   route.state - The state of a route in the route table (active | blackhole).
	// The blackhole state indicates that the route's target isn't available (for
	// example, the specified gateway isn't attached to the VPC, the specified NAT
	// instance has been terminated, and so on).
	//
	//   route.vpc-peering-connection-id - The ID of a VPC peering connection specified
	// in a route in the table.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   vpc-id - The ID of the VPC for the route table.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more route table IDs.
	//
	// Default: Describes all your route tables.
	RouteTableIds []*string `locationName:"RouteTableId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeRouteTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRouteTablesInput) GoString() string {
	return s.String()
}

type DescribeRouteTablesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more route tables.
	RouteTables []*RouteTable `locationName:"routeTableSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeRouteTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRouteTablesOutput) GoString() string {
	return s.String()
}

type DescribeSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters. If using multiple filters for rules, the results include
	// security groups for which any combination of rules - not necessarily a single
	// rule - match all filters.
	//
	//   description - The description of the security group.
	//
	//   egress.ip-permission.prefix-list-id - The ID (prefix) of the AWS service
	// to which the security group allows access.
	//
	//   group-id - The ID of the security group.
	//
	//   group-name - The name of the security group.
	//
	//   ip-permission.cidr - A CIDR range that has been granted permission.
	//
	//   ip-permission.from-port - The start of port range for the TCP and UDP
	// protocols, or an ICMP type number.
	//
	//   ip-permission.group-id - The ID of a security group that has been granted
	// permission.
	//
	//   ip-permission.group-name - The name of a security group that has been
	// granted permission.
	//
	//   ip-permission.protocol - The IP protocol for the permission (tcp | udp
	// | icmp or a protocol number).
	//
	//   ip-permission.to-port - The end of port range for the TCP and UDP protocols,
	// or an ICMP code.
	//
	//   ip-permission.user-id - The ID of an AWS account that has been granted
	// permission.
	//
	//   owner-id - The AWS account ID of the owner of the security group.
	//
	//   tag-key - The key of a tag assigned to the security group.
	//
	//   tag-value - The value of a tag assigned to the security group.
	//
	//   vpc-id - The ID of the VPC specified when the security group was created.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more security group IDs. Required for security groups in a nondefault
	// VPC.
	//
	// Default: Describes all your security groups.
	GroupIds []*string `locationName:"GroupId" locationNameList:"groupId" type:"list"`

	// [EC2-Classic and default VPC only] One or more security group names. You
	// can specify either the security group name or the security group ID. For
	// security groups in a nondefault VPC, use the group-name filter to describe
	// security groups by name.
	//
	// Default: Describes all your security groups.
	GroupNames []*string `locationName:"GroupName" locationNameList:"GroupName" type:"list"`
}

// String returns the string representation
func (s DescribeSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityGroupsInput) GoString() string {
	return s.String()
}

type DescribeSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more security groups.
	SecurityGroups []*SecurityGroup `locationName:"securityGroupInfo" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityGroupsOutput) GoString() string {
	return s.String()
}

type DescribeSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The snapshot attribute you would like to view.
	Attribute *string `type:"string" required:"true" enum:"SnapshotAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the EBS snapshot.
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotAttributeInput) GoString() string {
	return s.String()
}

type DescribeSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`

	// A list of permissions for creating volumes from the snapshot.
	CreateVolumePermissions []*CreateVolumePermission `locationName:"createVolumePermission" locationNameList:"item" type:"list"`

	// A list of product codes.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// The ID of the EBS snapshot.
	SnapshotId *string `locationName:"snapshotId" type:"string"`
}

// String returns the string representation
func (s DescribeSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotAttributeOutput) GoString() string {
	return s.String()
}

type DescribeSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   description - A description of the snapshot.
	//
	//   owner-alias - The AWS account alias (for example, amazon) that owns the
	// snapshot.
	//
	//   owner-id - The ID of the AWS account that owns the snapshot.
	//
	//   progress - The progress of the snapshot, as a percentage (for example,
	// 80%).
	//
	//   snapshot-id - The snapshot ID.
	//
	//   start-time - The time stamp when the snapshot was initiated.
	//
	//   status - The status of the snapshot (pending | completed | error).
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   volume-id - The ID of the volume the snapshot is for.
	//
	//   volume-size - The size of the volume, in GiB.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of snapshot results returned by DescribeSnapshots in paginated
	// output. When this parameter is used, DescribeSnapshots only returns MaxResults
	// results in a single page along with a NextToken response element. The remaining
	// results of the initial request can be seen by sending another DescribeSnapshots
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value larger than 1000, only 1000 results
	// are returned. If this parameter is not used, then DescribeSnapshots returns
	// all results. You cannot specify this parameter and the snapshot IDs parameter
	// in the same request.
	MaxResults *int64 `type:"integer"`

	// The NextToken value returned from a previous paginated DescribeSnapshots
	// request where MaxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the NextToken value. This value is null when there are no more results
	// to return.
	NextToken *string `type:"string"`

	// Returns the snapshots owned by the specified owner. Multiple owners can be
	// specified.
	OwnerIds []*string `locationName:"Owner" locationNameList:"Owner" type:"list"`

	// One or more AWS accounts IDs that can create volumes from the snapshot.
	RestorableByUserIds []*string `locationName:"RestorableBy" type:"list"`

	// One or more snapshot IDs.
	//
	// Default: Describes snapshots for which you have launch permissions.
	SnapshotIds []*string `locationName:"SnapshotId" locationNameList:"SnapshotId" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsInput) GoString() string {
	return s.String()
}

type DescribeSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a future DescribeSnapshots request. When
	// the results of a DescribeSnapshots request exceed MaxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the snapshots.
	Snapshots []*Snapshot `locationName:"snapshotSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeSpotDatafeedSubscription.
type DescribeSpotDatafeedSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DescribeSpotDatafeedSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotDatafeedSubscriptionInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeSpotDatafeedSubscription.
type DescribeSpotDatafeedSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Spot instance data feed subscription.
	SpotDatafeedSubscription *SpotDatafeedSubscription `locationName:"spotDatafeedSubscription" type:"structure"`
}

// String returns the string representation
func (s DescribeSpotDatafeedSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotDatafeedSubscriptionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeSpotFleetInstances.
type DescribeSpotFleetInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The maximum number of results to return in a single call. Specify a value
	// between 1 and 1000. The default value is 1000. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSpotFleetInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotFleetInstancesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeSpotFleetInstances.
type DescribeSpotFleetInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The running instances. Note that this list is refreshed periodically and
	// might be out of date.
	ActiveInstances []*ActiveInstance `locationName:"activeInstanceSet" locationNameList:"item" type:"list" required:"true"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSpotFleetInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotFleetInstancesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeSpotFleetRequestHistory.
type DescribeSpotFleetRequestHistoryInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The type of events to describe. By default, all events are described.
	EventType *string `locationName:"eventType" type:"string" enum:"EventType"`

	// The maximum number of results to return in a single call. Specify a value
	// between 1 and 1000. The default value is 1000. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`

	// The starting date and time for the events, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DescribeSpotFleetRequestHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotFleetRequestHistoryInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeSpotFleetRequestHistory.
type DescribeSpotFleetRequestHistoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the events in the history of the Spot fleet request.
	HistoryRecords []*HistoryRecord `locationName:"historyRecordSet" locationNameList:"item" type:"list" required:"true"`

	// The last date and time for the events, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// All records up to this time were retrieved.
	//
	// If nextToken indicates that there are more results, this value is not present.
	LastEvaluatedTime *time.Time `locationName:"lastEvaluatedTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`

	// The starting date and time for the events, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DescribeSpotFleetRequestHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotFleetRequestHistoryOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeSpotFleetRequests.
type DescribeSpotFleetRequestsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The maximum number of results to return in a single call. Specify a value
	// between 1 and 1000. The default value is 1000. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of the Spot fleet requests.
	SpotFleetRequestIds []*string `locationName:"spotFleetRequestId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSpotFleetRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotFleetRequestsInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeSpotFleetRequests.
type DescribeSpotFleetRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the configuration of your Spot fleet.
	SpotFleetRequestConfigs []*SpotFleetRequestConfig `locationName:"spotFleetRequestConfigSet" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeSpotFleetRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotFleetRequestsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeSpotInstanceRequests.
type DescribeSpotInstanceRequestsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   availability-zone-group - The Availability Zone group.
	//
	//   create-time - The time stamp when the Spot instance request was created.
	//
	//   fault-code - The fault code related to the request.
	//
	//   fault-message - The fault message related to the request.
	//
	//   instance-id - The ID of the instance that fulfilled the request.
	//
	//   launch-group - The Spot instance launch group.
	//
	//   launch.block-device-mapping.delete-on-termination - Indicates whether
	// the Amazon EBS volume is deleted on instance termination.
	//
	//   launch.block-device-mapping.device-name - The device name for the Amazon
	// EBS volume (for example, /dev/sdh).
	//
	//   launch.block-device-mapping.snapshot-id - The ID of the snapshot used
	// for the Amazon EBS volume.
	//
	//   launch.block-device-mapping.volume-size - The size of the Amazon EBS volume,
	// in GiB.
	//
	//   launch.block-device-mapping.volume-type - The type of the Amazon EBS volume
	// (gp2 | standard | io1).
	//
	//   launch.group-id - The security group for the instance.
	//
	//   launch.image-id - The ID of the AMI.
	//
	//   launch.instance-type - The type of instance (for example, m3.medium).
	//
	//   launch.kernel-id - The kernel ID.
	//
	//   launch.key-name - The name of the key pair the instance launched with.
	//
	//   launch.monitoring-enabled - Whether monitoring is enabled for the Spot
	// instance.
	//
	//   launch.ramdisk-id - The RAM disk ID.
	//
	//   network-interface.network-interface-id - The ID of the network interface.
	//
	//   network-interface.device-index - The index of the device for the network
	// interface attachment on the instance.
	//
	//   network-interface.subnet-id - The ID of the subnet for the instance.
	//
	//   network-interface.description - A description of the network interface.
	//
	//   network-interface.private-ip-address - The primary private IP address
	// of the network interface.
	//
	//   network-interface.delete-on-termination - Indicates whether the network
	// interface is deleted when the instance is terminated.
	//
	//   network-interface.group-id - The ID of the security group associated with
	// the network interface.
	//
	//   network-interface.group-name - The name of the security group associated
	// with the network interface.
	//
	//   network-interface.addresses.primary - Indicates whether the IP address
	// is the primary private IP address.
	//
	//   product-description - The product description associated with the instance
	// (Linux/UNIX | Windows).
	//
	//   spot-instance-request-id - The Spot instance request ID.
	//
	//   spot-price - The maximum hourly price for any Spot instance launched to
	// fulfill the request.
	//
	//   state - The state of the Spot instance request (open | active | closed
	// | cancelled | failed). Spot bid status information can help you track your
	// Amazon EC2 Spot instance requests. For more information, see Spot Bid Status
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	//   status-code - The short code describing the most recent evaluation of
	// your Spot instance request.
	//
	//   status-message - The message explaining the status of the Spot instance
	// request.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   type - The type of Spot instance request (one-time | persistent).
	//
	//   launched-availability-zone - The Availability Zone in which the bid is
	// launched.
	//
	//   valid-from - The start date of the request.
	//
	//   valid-until - The end date of the request.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more Spot instance request IDs.
	SpotInstanceRequestIds []*string `locationName:"SpotInstanceRequestId" locationNameList:"SpotInstanceRequestId" type:"list"`
}

// String returns the string representation
func (s DescribeSpotInstanceRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotInstanceRequestsInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeSpotInstanceRequests.
type DescribeSpotInstanceRequestsOutput struct {
	_ struct{} `type:"structure"`

	// One or more Spot instance requests.
	SpotInstanceRequests []*SpotInstanceRequest `locationName:"spotInstanceRequestSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSpotInstanceRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotInstanceRequestsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeSpotPriceHistory.
type DescribeSpotPriceHistoryInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by the specified Availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The date and time, up to the current date, from which to stop retrieving
	// the price history data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// One or more filters.
	//
	//   availability-zone - The Availability Zone for which prices should be returned.
	//
	//   instance-type - The type of instance (for example, m3.medium).
	//
	//   product-description - The product description for the Spot price (Linux/UNIX
	// | SUSE Linux | Windows | Linux/UNIX (Amazon VPC) | SUSE Linux (Amazon VPC)
	// | Windows (Amazon VPC)).
	//
	//   spot-price - The Spot price. The value must match exactly (or use wildcards;
	// greater than or less than comparison is not supported).
	//
	//   timestamp - The timestamp of the Spot price history, in UTC format (for
	// example, YYYY-MM-DDTHH:MM:SSZ). You can use wildcards (* and ?). Greater
	// than or less than comparison is not supported.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// Filters the results by the specified instance types.
	InstanceTypes []*string `locationName:"InstanceType" type:"list"`

	// The maximum number of results to return in a single call. Specify a value
	// between 1 and 1000. The default value is 1000. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Filters the results by the specified basic product descriptions.
	ProductDescriptions []*string `locationName:"ProductDescription" type:"list"`

	// The date and time, up to the past 90 days, from which to start retrieving
	// the price history data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeSpotPriceHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotPriceHistoryInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeSpotPriceHistory.
type DescribeSpotPriceHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The historical Spot prices.
	SpotPriceHistory []*SpotPrice `locationName:"spotPriceHistorySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSpotPriceHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSpotPriceHistoryOutput) GoString() string {
	return s.String()
}

type DescribeSubnetsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   availabilityZone - The Availability Zone for the subnet. You can also
	// use availability-zone as the filter name.
	//
	//   available-ip-address-count - The number of IP addresses in the subnet
	// that are available.
	//
	//   cidrBlock - The CIDR block of the subnet. The CIDR block you specify must
	// exactly match the subnet's CIDR block for information to be returned for
	// the subnet. You can also use cidr or cidr-block as the filter names.
	//
	//   defaultForAz - Indicates whether this is the default subnet for the Availability
	// Zone. You can also use default-for-az as the filter name.
	//
	//   state - The state of the subnet (pending | available).
	//
	//   subnet-id - The ID of the subnet.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   vpc-id - The ID of the VPC for the subnet.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more subnet IDs.
	//
	// Default: Describes all your subnets.
	SubnetIds []*string `locationName:"SubnetId" locationNameList:"SubnetId" type:"list"`
}

// String returns the string representation
func (s DescribeSubnetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubnetsInput) GoString() string {
	return s.String()
}

type DescribeSubnetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more subnets.
	Subnets []*Subnet `locationName:"subnetSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSubnetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubnetsOutput) GoString() string {
	return s.String()
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   key - The tag key.
	//
	//   resource-id - The resource ID.
	//
	//   resource-type - The resource type (customer-gateway | dhcp-options | image
	// | instance | internet-gateway | network-acl | network-interface | reserved-instances
	// | route-table | security-group | snapshot | spot-instances-request | subnet
	// | volume | vpc | vpn-connection | vpn-gateway).
	//
	//   value - The tag value.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value larger than 1000, only 1000 results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return..
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of tags.
	Tags []*TagDescription `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

type DescribeVolumeAttributeInput struct {
	_ struct{} `type:"structure"`

	// The instance attribute.
	Attribute *string `type:"string" enum:"VolumeAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the volume.
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVolumeAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumeAttributeInput) GoString() string {
	return s.String()
}

type DescribeVolumeAttributeOutput struct {
	_ struct{} `type:"structure"`

	// The state of autoEnableIO attribute.
	AutoEnableIO *AttributeBooleanValue `locationName:"autoEnableIO" type:"structure"`

	// A list of product codes.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// The ID of the volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s DescribeVolumeAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumeAttributeOutput) GoString() string {
	return s.String()
}

type DescribeVolumeStatusInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   action.code - The action code for the event (for example, enable-volume-io).
	//
	//   action.description - A description of the action.
	//
	//   action.event-id - The event ID associated with the action.
	//
	//   availability-zone - The Availability Zone of the instance.
	//
	//   event.description - A description of the event.
	//
	//   event.event-id - The event ID.
	//
	//   event.event-type - The event type (for io-enabled: passed | failed; for
	// io-performance: io-performance:degraded | io-performance:severely-degraded
	// | io-performance:stalled).
	//
	//   event.not-after - The latest end time for the event.
	//
	//   event.not-before - The earliest start time for the event.
	//
	//   volume-status.details-name - The cause for volume-status.status (io-enabled
	// | io-performance).
	//
	//   volume-status.details-status - The status of volume-status.details-name
	// (for io-enabled: passed | failed; for io-performance: normal | degraded |
	// severely-degraded | stalled).
	//
	//   volume-status.status - The status of the volume (ok | impaired | warning
	// | insufficient-data).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of volume results returned by DescribeVolumeStatus in
	// paginated output. When this parameter is used, the request only returns MaxResults
	// results in a single page along with a NextToken response element. The remaining
	// results of the initial request can be seen by sending another request with
	// the returned NextToken value. This value can be between 5 and 1000; if MaxResults
	// is given a value larger than 1000, only 1000 results are returned. If this
	// parameter is not used, then DescribeVolumeStatus returns all results. You
	// cannot specify this parameter and the volume IDs parameter in the same request.
	MaxResults *int64 `type:"integer"`

	// The NextToken value to include in a future DescribeVolumeStatus request.
	// When the results of the request exceed MaxResults, this value can be used
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `type:"string"`

	// One or more volume IDs.
	//
	// Default: Describes all your volumes.
	VolumeIds []*string `locationName:"VolumeId" locationNameList:"VolumeId" type:"list"`
}

// String returns the string representation
func (s DescribeVolumeStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumeStatusInput) GoString() string {
	return s.String()
}

type DescribeVolumeStatusOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of volumes.
	VolumeStatuses []*VolumeStatusItem `locationName:"volumeStatusSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVolumeStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumeStatusOutput) GoString() string {
	return s.String()
}

type DescribeVolumesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   attachment.attach-time - The time stamp when the attachment initiated.
	//
	//   attachment.delete-on-termination - Whether the volume is deleted on instance
	// termination.
	//
	//   attachment.device - The device name that is exposed to the instance (for
	// example, /dev/sda1).
	//
	//   attachment.instance-id - The ID of the instance the volume is attached
	// to.
	//
	//   attachment.status - The attachment state (attaching | attached | detaching
	// | detached).
	//
	//   availability-zone - The Availability Zone in which the volume was created.
	//
	//   create-time - The time stamp when the volume was created.
	//
	//   encrypted - The encryption status of the volume.
	//
	//   size - The size of the volume, in GiB.
	//
	//   snapshot-id - The snapshot from which the volume was created.
	//
	//   status - The status of the volume (creating | available | in-use | deleting
	// | deleted | error).
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   volume-id - The volume ID.
	//
	//   volume-type - The Amazon EBS volume type. This can be gp2 for General
	// Purpose (SSD) volumes, io1 for Provisioned IOPS (SSD) volumes, or standard
	// for Magnetic volumes.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of volume results returned by DescribeVolumes in paginated
	// output. When this parameter is used, DescribeVolumes only returns MaxResults
	// results in a single page along with a NextToken response element. The remaining
	// results of the initial request can be seen by sending another DescribeVolumes
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value larger than 1000, only 1000 results
	// are returned. If this parameter is not used, then DescribeVolumes returns
	// all results. You cannot specify this parameter and the volume IDs parameter
	// in the same request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The NextToken value returned from a previous paginated DescribeVolumes request
	// where MaxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// NextToken value. This value is null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// One or more volume IDs.
	VolumeIds []*string `locationName:"VolumeId" locationNameList:"VolumeId" type:"list"`
}

// String returns the string representation
func (s DescribeVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumesInput) GoString() string {
	return s.String()
}

type DescribeVolumesOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a future DescribeVolumes request. When
	// the results of a DescribeVolumes request exceed MaxResults, this value can
	// be used to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the volumes.
	Volumes []*Volume `locationName:"volumeSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumesOutput) GoString() string {
	return s.String()
}

type DescribeVpcAttributeInput struct {
	_ struct{} `type:"structure"`

	// The VPC attribute.
	Attribute *string `type:"string" required:"true" enum:"VpcAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVpcAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcAttributeInput) GoString() string {
	return s.String()
}

type DescribeVpcAttributeOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the instances launched in the VPC get DNS hostnames. If
	// this attribute is true, instances in the VPC get DNS hostnames; otherwise,
	// they do not.
	EnableDnsHostnames *AttributeBooleanValue `locationName:"enableDnsHostnames" type:"structure"`

	// Indicates whether DNS resolution is enabled for the VPC. If this attribute
	// is true, the Amazon DNS server resolves DNS hostnames for your instances
	// to their corresponding IP addresses; otherwise, it does not.
	EnableDnsSupport *AttributeBooleanValue `locationName:"enableDnsSupport" type:"structure"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s DescribeVpcAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcAttributeOutput) GoString() string {
	return s.String()
}

type DescribeVpcClassicLinkInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   is-classic-link-enabled - Whether the VPC is enabled for ClassicLink (true
	// | false).
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more VPCs for which you want to describe the ClassicLink status.
	VpcIds []*string `locationName:"VpcId" locationNameList:"VpcId" type:"list"`
}

// String returns the string representation
func (s DescribeVpcClassicLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcClassicLinkInput) GoString() string {
	return s.String()
}

type DescribeVpcClassicLinkOutput struct {
	_ struct{} `type:"structure"`

	// The ClassicLink status of one or more VPCs.
	Vpcs []*VpcClassicLink `locationName:"vpcSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcClassicLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcClassicLinkOutput) GoString() string {
	return s.String()
}

type DescribeVpcEndpointServicesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The maximum number of items to return for this request. The request returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	//
	// Constraint: If the value is greater than 1000, we return only 1000 items.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a prior call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeVpcEndpointServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcEndpointServicesInput) GoString() string {
	return s.String()
}

type DescribeVpcEndpointServicesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of supported AWS services.
	ServiceNames []*string `locationName:"serviceNameSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcEndpointServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcEndpointServicesOutput) GoString() string {
	return s.String()
}

type DescribeVpcEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//   service-name: The name of the AWS service.
	//
	//   vpc-id: The ID of the VPC in which the endpoint resides.
	//
	//   vpc-endpoint-id: The ID of the endpoint.
	//
	//   vpc-endpoint-state: The state of the endpoint. (pending | available |
	// deleting | deleted)
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of items to return for this request. The request returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	//
	// Constraint: If the value is greater than 1000, we return only 1000 items.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a prior call.)
	NextToken *string `type:"string"`

	// One or more endpoint IDs.
	VpcEndpointIds []*string `locationName:"VpcEndpointId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcEndpointsInput) GoString() string {
	return s.String()
}

type DescribeVpcEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the endpoints.
	VpcEndpoints []*VpcEndpoint `locationName:"vpcEndpointSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcEndpointsOutput) GoString() string {
	return s.String()
}

type DescribeVpcPeeringConnectionsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   accepter-vpc-info.cidr-block - The CIDR block of the peer VPC.
	//
	//   accepter-vpc-info.owner-id - The AWS account ID of the owner of the peer
	// VPC.
	//
	//   accepter-vpc-info.vpc-id - The ID of the peer VPC.
	//
	//   expiration-time - The expiration date and time for the VPC peering connection.
	//
	//   requester-vpc-info.cidr-block - The CIDR block of the requester's VPC.
	//
	//   requester-vpc-info.owner-id - The AWS account ID of the owner of the requester
	// VPC.
	//
	//   requester-vpc-info.vpc-id - The ID of the requester VPC.
	//
	//   status-code - The status of the VPC peering connection (pending-acceptance
	// | failed | expired | provisioning | active | deleted | rejected).
	//
	//   status-message - A message that provides more information about the status
	// of the VPC peering connection, if applicable.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   vpc-peering-connection-id - The ID of the VPC peering connection.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more VPC peering connection IDs.
	//
	// Default: Describes all your VPC peering connections.
	VpcPeeringConnectionIds []*string `locationName:"VpcPeeringConnectionId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcPeeringConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcPeeringConnectionsInput) GoString() string {
	return s.String()
}

type DescribeVpcPeeringConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC peering connections.
	VpcPeeringConnections []*VpcPeeringConnection `locationName:"vpcPeeringConnectionSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcPeeringConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcPeeringConnectionsOutput) GoString() string {
	return s.String()
}

type DescribeVpcsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   cidr - The CIDR block of the VPC. The CIDR block you specify must exactly
	// match the VPC's CIDR block for information to be returned for the VPC. Must
	// contain the slash followed by one or two digits (for example, /28).
	//
	//   dhcp-options-id - The ID of a set of DHCP options.
	//
	//   isDefault - Indicates whether the VPC is the default VPC.
	//
	//   state - The state of the VPC (pending | available).
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   vpc-id - The ID of the VPC.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more VPC IDs.
	//
	// Default: Describes all your VPCs.
	VpcIds []*string `locationName:"VpcId" locationNameList:"VpcId" type:"list"`
}

// String returns the string representation
func (s DescribeVpcsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcsInput) GoString() string {
	return s.String()
}

type DescribeVpcsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more VPCs.
	Vpcs []*Vpc `locationName:"vpcSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcsOutput) GoString() string {
	return s.String()
}

type DescribeVpnConnectionsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   customer-gateway-configuration - The configuration information for the
	// customer gateway.
	//
	//   customer-gateway-id - The ID of a customer gateway associated with the
	// VPN connection.
	//
	//   state - The state of the VPN connection (pending | available | deleting
	// | deleted).
	//
	//   option.static-routes-only - Indicates whether the connection has static
	// routes only. Used for devices that do not support Border Gateway Protocol
	// (BGP).
	//
	//   route.destination-cidr-block - The destination CIDR block. This corresponds
	// to the subnet used in a customer data center.
	//
	//   bgp-asn - The BGP Autonomous System Number (ASN) associated with a BGP
	// device.
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   type - The type of VPN connection. Currently the only supported type is
	// ipsec.1.
	//
	//   vpn-connection-id - The ID of the VPN connection.
	//
	//   vpn-gateway-id - The ID of a virtual private gateway associated with the
	// VPN connection.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more VPN connection IDs.
	//
	// Default: Describes your VPN connections.
	VpnConnectionIds []*string `locationName:"VpnConnectionId" locationNameList:"VpnConnectionId" type:"list"`
}

// String returns the string representation
func (s DescribeVpnConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpnConnectionsInput) GoString() string {
	return s.String()
}

type DescribeVpnConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more VPN connections.
	VpnConnections []*VpnConnection `locationName:"vpnConnectionSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpnConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpnConnectionsOutput) GoString() string {
	return s.String()
}

type DescribeVpnGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//   attachment.state - The current state of the attachment between the gateway
	// and the VPC (attaching | attached | detaching | detached).
	//
	//   attachment.vpc-id - The ID of an attached VPC.
	//
	//   availability-zone - The Availability Zone for the virtual private gateway.
	//
	//   state - The state of the virtual private gateway (pending | available
	// | deleting | deleted).
	//
	//   tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//   tag-key - The key of a tag assigned to the resource. This filter is independent
	// of the tag-value filter. For example, if you use both the filter "tag-key=Purpose"
	// and the filter "tag-value=X", you get any resources assigned both the tag
	// key Purpose (regardless of what the tag's value is), and the tag value X
	// (regardless of what the tag's key is). If you want to list only resources
	// where Purpose is X, see the tag:key=value filter.
	//
	//   tag-value - The value of a tag assigned to the resource. This filter is
	// independent of the tag-key filter.
	//
	//   type - The type of virtual private gateway. Currently the only supported
	// type is ipsec.1.
	//
	//   vpn-gateway-id - The ID of the virtual private gateway.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more virtual private gateway IDs.
	//
	// Default: Describes all your virtual private gateways.
	VpnGatewayIds []*string `locationName:"VpnGatewayId" locationNameList:"VpnGatewayId" type:"list"`
}

// String returns the string representation
func (s DescribeVpnGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpnGatewaysInput) GoString() string {
	return s.String()
}

type DescribeVpnGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more virtual private gateways.
	VpnGateways []*VpnGateway `locationName:"vpnGatewaySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpnGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpnGatewaysOutput) GoString() string {
	return s.String()
}

type DetachClassicLinkVpcInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance to unlink from the VPC.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The ID of the VPC to which the instance is linked.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachClassicLinkVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachClassicLinkVpcInput) GoString() string {
	return s.String()
}

type DetachClassicLinkVpcOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DetachClassicLinkVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachClassicLinkVpcOutput) GoString() string {
	return s.String()
}

type DetachInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the Internet gateway.
	InternetGatewayId *string `locationName:"internetGatewayId" type:"string" required:"true"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInternetGatewayInput) GoString() string {
	return s.String()
}

type DetachInternetGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInternetGatewayOutput) GoString() string {
	return s.String()
}

type DetachNetworkInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether to force a detachment.
	Force *bool `locationName:"force" type:"boolean"`
}

// String returns the string representation
func (s DetachNetworkInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachNetworkInterfaceInput) GoString() string {
	return s.String()
}

type DetachNetworkInterfaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachNetworkInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachNetworkInterfaceOutput) GoString() string {
	return s.String()
}

type DetachVolumeInput struct {
	_ struct{} `type:"structure"`

	// The device name.
	Device *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Forces detachment if the previous detachment attempt did not occur cleanly
	// (for example, logging into an instance, unmounting the volume, and detaching
	// normally). This option can lead to data loss or a corrupted file system.
	// Use this option only as a last resort to detach a volume from a failed instance.
	// The instance won't have an opportunity to flush file system caches or file
	// system metadata. If you use this option, you must perform file system check
	// and repair procedures.
	Force *bool `type:"boolean"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The ID of the volume.
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DetachVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachVolumeInput) GoString() string {
	return s.String()
}

type DetachVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `type:"string" required:"true"`

	// The ID of the virtual private gateway.
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DetachVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachVpnGatewayInput) GoString() string {
	return s.String()
}

type DetachVpnGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachVpnGatewayOutput) GoString() string {
	return s.String()
}

// Describes a DHCP configuration option.
type DhcpConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of a DHCP option.
	Key *string `locationName:"key" type:"string"`

	// One or more values for the DHCP option.
	Values []*AttributeValue `locationName:"valueSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DhcpConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DhcpConfiguration) GoString() string {
	return s.String()
}

// Describes a set of DHCP options.
type DhcpOptions struct {
	_ struct{} `type:"structure"`

	// One or more DHCP options in the set.
	DhcpConfigurations []*DhcpConfiguration `locationName:"dhcpConfigurationSet" locationNameList:"item" type:"list"`

	// The ID of the set of DHCP options.
	DhcpOptionsId *string `locationName:"dhcpOptionsId" type:"string"`

	// Any tags assigned to the DHCP options set.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DhcpOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DhcpOptions) GoString() string {
	return s.String()
}

type DisableVgwRoutePropagationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway.
	GatewayId *string `type:"string" required:"true"`

	// The ID of the route table.
	RouteTableId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableVgwRoutePropagationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableVgwRoutePropagationInput) GoString() string {
	return s.String()
}

type DisableVgwRoutePropagationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableVgwRoutePropagationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableVgwRoutePropagationOutput) GoString() string {
	return s.String()
}

type DisableVpcClassicLinkInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableVpcClassicLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableVpcClassicLinkInput) GoString() string {
	return s.String()
}

type DisableVpcClassicLinkOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DisableVpcClassicLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableVpcClassicLinkOutput) GoString() string {
	return s.String()
}

type DisassociateAddressInput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The association ID. Required for EC2-VPC.
	AssociationId *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// [EC2-Classic] The Elastic IP address. Required for EC2-Classic.
	PublicIp *string `type:"string"`
}

// String returns the string representation
func (s DisassociateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAddressInput) GoString() string {
	return s.String()
}

type DisassociateAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAddressOutput) GoString() string {
	return s.String()
}

type DisassociateRouteTableInput struct {
	_ struct{} `type:"structure"`

	// The association ID representing the current association between the route
	// table and subnet.
	AssociationId *string `locationName:"associationId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DisassociateRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRouteTableInput) GoString() string {
	return s.String()
}

type DisassociateRouteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRouteTableOutput) GoString() string {
	return s.String()
}

// Describes a disk image.
type DiskImage struct {
	_ struct{} `type:"structure"`

	// A description of the disk image.
	Description *string `type:"string"`

	// Information about the disk image.
	Image *DiskImageDetail `type:"structure"`

	// Information about the volume.
	Volume *VolumeDetail `type:"structure"`
}

// String returns the string representation
func (s DiskImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskImage) GoString() string {
	return s.String()
}

// Describes a disk image.
type DiskImageDescription struct {
	_ struct{} `type:"structure"`

	// The checksum computed for the disk image.
	Checksum *string `locationName:"checksum" type:"string"`

	// The disk image format.
	Format *string `locationName:"format" type:"string" required:"true" enum:"DiskImageFormat"`

	// A presigned URL for the import manifest stored in Amazon S3. For information
	// about creating a presigned URL for an Amazon S3 object, read the "Query String
	// Request Authentication Alternative" section of the Authenticating REST Requests
	// (http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html)
	// topic in the Amazon Simple Storage Service Developer Guide.
	ImportManifestUrl *string `locationName:"importManifestUrl" type:"string" required:"true"`

	// The size of the disk image, in GiB.
	Size *int64 `locationName:"size" type:"long" required:"true"`
}

// String returns the string representation
func (s DiskImageDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskImageDescription) GoString() string {
	return s.String()
}

// Describes a disk image.
type DiskImageDetail struct {
	_ struct{} `type:"structure"`

	// The size of the disk image, in GiB.
	Bytes *int64 `locationName:"bytes" type:"long" required:"true"`

	// The disk image format.
	Format *string `locationName:"format" type:"string" required:"true" enum:"DiskImageFormat"`

	// A presigned URL for the import manifest stored in Amazon S3 and presented
	// here as an Amazon S3 presigned URL. For information about creating a presigned
	// URL for an Amazon S3 object, read the "Query String Request Authentication
	// Alternative" section of the Authenticating REST Requests (http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html)
	// topic in the Amazon Simple Storage Service Developer Guide.
	ImportManifestUrl *string `locationName:"importManifestUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s DiskImageDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskImageDetail) GoString() string {
	return s.String()
}

// Describes a disk image volume.
type DiskImageVolumeDescription struct {
	_ struct{} `type:"structure"`

	// The volume identifier.
	Id *string `locationName:"id" type:"string" required:"true"`

	// The size of the volume, in GiB.
	Size *int64 `locationName:"size" type:"long"`
}

// String returns the string representation
func (s DiskImageVolumeDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskImageVolumeDescription) GoString() string {
	return s.String()
}

// Describes a block device for an EBS volume.
type EbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// Indicates whether the EBS volume is encrypted. Encrypted Amazon EBS volumes
	// may only be attached to instances that support Amazon EBS encryption.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For Provisioned IOPS (SSD) volumes, this represents the number of IOPS that
	// are provisioned for the volume. For General Purpose (SSD) volumes, this represents
	// the baseline performance of the volume and the rate at which the volume accumulates
	// I/O credits for bursting. For more information on General Purpose (SSD) baseline
	// performance, I/O credits, and bursting, see Amazon EBS Volume Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Constraint: Range is 100 to 20000 for Provisioned IOPS (SSD) volumes and
	// 3 to 10000 for General Purpose (SSD) volumes.
	//
	// Condition: This parameter is required for requests to create io1 volumes;
	// it is not used in requests to create standard or gp2 volumes.
	Iops *int64 `locationName:"iops" type:"integer"`

	// The ID of the snapshot.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// The size of the volume, in GiB.
	//
	// Constraints: 1-1024 for standard volumes, 1-16384 for gp2 volumes, and 4-16384
	// for io1 volumes. If you specify a snapshot, the volume size must be equal
	// to or larger than the snapshot size.
	//
	// Default: If you're creating the volume from a snapshot and don't specify
	// a volume size, the default is the snapshot size.
	VolumeSize *int64 `locationName:"volumeSize" type:"integer"`

	// The volume type. gp2 for General Purpose (SSD) volumes, io1 for Provisioned
	// IOPS (SSD) volumes, and standard for Magnetic volumes.
	//
	// Default: standard
	VolumeType *string `locationName:"volumeType" type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsBlockDevice) GoString() string {
	return s.String()
}

// Describes a parameter used to set up an EBS volume in a block device mapping.
type EbsInstanceBlockDevice struct {
	_ struct{} `type:"structure"`

	// The time stamp when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The attachment state.
	Status *string `locationName:"status" type:"string" enum:"AttachmentStatus"`

	// The ID of the EBS volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s EbsInstanceBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsInstanceBlockDevice) GoString() string {
	return s.String()
}

type EbsInstanceBlockDeviceSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The ID of the EBS volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s EbsInstanceBlockDeviceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsInstanceBlockDeviceSpecification) GoString() string {
	return s.String()
}

type EnableVgwRoutePropagationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway.
	GatewayId *string `type:"string" required:"true"`

	// The ID of the route table.
	RouteTableId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableVgwRoutePropagationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableVgwRoutePropagationInput) GoString() string {
	return s.String()
}

type EnableVgwRoutePropagationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableVgwRoutePropagationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableVgwRoutePropagationOutput) GoString() string {
	return s.String()
}

type EnableVolumeIOInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the volume.
	VolumeId *string `locationName:"volumeId" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableVolumeIOInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableVolumeIOInput) GoString() string {
	return s.String()
}

type EnableVolumeIOOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableVolumeIOOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableVolumeIOOutput) GoString() string {
	return s.String()
}

type EnableVpcClassicLinkInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableVpcClassicLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableVpcClassicLinkInput) GoString() string {
	return s.String()
}

type EnableVpcClassicLinkOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s EnableVpcClassicLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableVpcClassicLinkOutput) GoString() string {
	return s.String()
}

// Describes a Spot fleet event.
type EventInformation struct {
	_ struct{} `type:"structure"`

	// The description of the event.
	EventDescription *string `locationName:"eventDescription" type:"string"`

	// The event.
	//
	// The following are the error events.
	//
	//   iamFleetRoleInvalid - The Spot fleet did not have the required permissions
	// either to launch or terminate an instance.
	//
	//   launchSpecTemporarilyBlacklisted - The configuration is not valid and
	// several attempts to launch instances have failed. For more information, see
	// the description of the event.
	//
	//   spotFleetRequestConfigurationInvalid - The configuration is not valid.
	// For more information, see the description of the event.
	//
	//   spotInstanceCountLimitExceeded - You've reached the limit on the number
	// of Spot instances that you can launch.
	//
	//   The following are the fleetRequestChange events.
	//
	//   active - The Spot fleet has been validated and Amazon EC2 is attempting
	// to maintain the target number of running Spot instances.
	//
	//   cancelled - The Spot fleet is canceled and has no running Spot instances.
	// The Spot fleet will be deleted two days after its instances were terminated.
	//
	//   cancelled_running - The Spot fleet is canceled and will not launch additional
	// Spot instances, but its existing Spot instances continue to run until they
	// are interrupted or terminated.
	//
	//   cancelled_terminating - The Spot fleet is canceled and its Spot instances
	// are terminating.
	//
	//   expired - The Spot fleet request has expired. A subsequent event indicates
	// that the instances were terminated, if the request was created with TerminateInstancesWithExpiration
	// set.
	//
	//   modify_in_progress - A request to modify the Spot fleet request was accepted
	// and is in progress.
	//
	//   modify_successful - The Spot fleet request was modified.
	//
	//   price_update - The bid price for a launch configuration was adjusted because
	// it was too high. This change is permanent.
	//
	//   submitted - The Spot fleet request is being evaluated and Amazon EC2 is
	// preparing to launch the target number of Spot instances.
	//
	//   The following are the instanceChange events.
	//
	//   launched - A bid was fulfilled and a new instance was launched.
	//
	//   terminated - An instance was terminated by the user.
	EventSubType *string `locationName:"eventSubType" type:"string"`

	// The ID of the instance. This information is available only for instanceChange
	// events.
	InstanceId *string `locationName:"instanceId" type:"string"`
}

// String returns the string representation
func (s EventInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventInformation) GoString() string {
	return s.String()
}

// Describes an instance export task.
type ExportTask struct {
	_ struct{} `type:"structure"`

	// A description of the resource being exported.
	Description *string `locationName:"description" type:"string"`

	// The ID of the export task.
	ExportTaskId *string `locationName:"exportTaskId" type:"string"`

	// Information about the export task.
	ExportToS3Task *ExportToS3Task `locationName:"exportToS3" type:"structure"`

	// Information about the instance to export.
	InstanceExportDetails *InstanceExportDetails `locationName:"instanceExport" type:"structure"`

	// The state of the export task.
	State *string `locationName:"state" type:"string" enum:"ExportTaskState"`

	// The status message related to the export task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s ExportTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportTask) GoString() string {
	return s.String()
}

// Describes the format and location for an instance export task.
type ExportToS3Task struct {
	_ struct{} `type:"structure"`

	// The container format used to combine disk images with metadata (such as OVF).
	// If absent, only the disk image is exported.
	ContainerFormat *string `locationName:"containerFormat" type:"string" enum:"ContainerFormat"`

	// The format for the exported image.
	DiskImageFormat *string `locationName:"diskImageFormat" type:"string" enum:"DiskImageFormat"`

	// The S3 bucket for the destination image. The destination bucket must exist
	// and grant WRITE and READ_ACP permissions to the AWS account vm-import-export@amazon.com.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The encryption key for your S3 bucket.
	S3Key *string `locationName:"s3Key" type:"string"`
}

// String returns the string representation
func (s ExportToS3Task) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportToS3Task) GoString() string {
	return s.String()
}

// Describes an instance export task.
type ExportToS3TaskSpecification struct {
	_ struct{} `type:"structure"`

	// The container format used to combine disk images with metadata (such as OVF).
	// If absent, only the disk image is exported.
	ContainerFormat *string `locationName:"containerFormat" type:"string" enum:"ContainerFormat"`

	// The format for the exported image.
	DiskImageFormat *string `locationName:"diskImageFormat" type:"string" enum:"DiskImageFormat"`

	// The S3 bucket for the destination image. The destination bucket must exist
	// and grant WRITE and READ_ACP permissions to the AWS account vm-import-export@amazon.com.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The image is written to a single object in the S3 bucket at the S3 key s3prefix
	// + exportTaskId + '.' + diskImageFormat.
	S3Prefix *string `locationName:"s3Prefix" type:"string"`
}

// String returns the string representation
func (s ExportToS3TaskSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportToS3TaskSpecification) GoString() string {
	return s.String()
}

// A filter name and value pair that is used to return a more specific list
// of results. Filters can be used to match a set of resources by various criteria,
// such as tags, attributes, or IDs.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	Name *string `type:"string"`

	// One or more filter values. Filter values are case-sensitive.
	Values []*string `locationName:"Value" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Describes a flow log.
type FlowLog struct {
	_ struct{} `type:"structure"`

	// The date and time the flow log was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about the error that occurred. Rate limited indicates that CloudWatch
	// logs throttling has been applied for one or more network interfaces, or that
	// you've reached the limit on the number of CloudWatch Logs log groups that
	// you can create. Access error indicates that the IAM role associated with
	// the flow log does not have sufficient permissions to publish to CloudWatch
	// Logs. Unknown error indicates an internal error.
	DeliverLogsErrorMessage *string `locationName:"deliverLogsErrorMessage" type:"string"`

	// The ARN of the IAM role that posts logs to CloudWatch Logs.
	DeliverLogsPermissionArn *string `locationName:"deliverLogsPermissionArn" type:"string"`

	// The status of the logs delivery (SUCCESS | FAILED).
	DeliverLogsStatus *string `locationName:"deliverLogsStatus" type:"string"`

	// The flow log ID.
	FlowLogId *string `locationName:"flowLogId" type:"string"`

	// The status of the flow log (ACTIVE).
	FlowLogStatus *string `locationName:"flowLogStatus" type:"string"`

	// The name of the flow log group.
	LogGroupName *string `locationName:"logGroupName" type:"string"`

	// The ID of the resource on which the flow log was created.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of traffic captured for the flow log.
	TrafficType *string `locationName:"trafficType" type:"string" enum:"TrafficType"`
}

// String returns the string representation
func (s FlowLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowLog) GoString() string {
	return s.String()
}

type GetConsoleOutputInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetConsoleOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConsoleOutputInput) GoString() string {
	return s.String()
}

type GetConsoleOutputOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The console output, Base64 encoded.
	Output *string `locationName:"output" type:"string"`

	// The time the output was last updated.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetConsoleOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConsoleOutputOutput) GoString() string {
	return s.String()
}

type GetPasswordDataInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the Windows instance.
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetPasswordDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPasswordDataInput) GoString() string {
	return s.String()
}

type GetPasswordDataOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Windows instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The password of the instance.
	PasswordData *string `locationName:"passwordData" type:"string"`

	// The time the data was last updated.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetPasswordDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPasswordDataOutput) GoString() string {
	return s.String()
}

// Describes a security group.
type GroupIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s GroupIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupIdentifier) GoString() string {
	return s.String()
}

// Describes an event in the history of the Spot fleet request.
type HistoryRecord struct {
	_ struct{} `type:"structure"`

	// Information about the event.
	EventInformation *EventInformation `locationName:"eventInformation" type:"structure" required:"true"`

	// The event type.
	//
	//   error - Indicates an error with the Spot fleet request.
	//
	//   fleetRequestChange - Indicates a change in the status or configuration
	// of the Spot fleet request.
	//
	//   instanceChange - Indicates that an instance was launched or terminated.
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"EventType"`

	// The date and time of the event, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s HistoryRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoryRecord) GoString() string {
	return s.String()
}

// Describes the properties of the Dedicated host.
type Host struct {
	_ struct{} `type:"structure"`

	// Whether auto-placement is on or off.
	AutoPlacement *string `locationName:"autoPlacement" type:"string" enum:"AutoPlacement"`

	// The Availability Zone of the Dedicated host.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of new instances that can be launched onto the Dedicated host.
	AvailableCapacity *AvailableCapacity `locationName:"availableCapacity" type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The ID of the Dedicated host.
	HostId *string `locationName:"hostId" type:"string"`

	// The hardware specifications of the Dedicated host.
	HostProperties *HostProperties `locationName:"hostProperties" type:"structure"`

	// The reservation ID of the Dedicated host. This returns a null response if
	// the Dedicated host doesn't have an associated reservation.
	HostReservationId *string `locationName:"hostReservationId" type:"string"`

	// The IDs and instance type that are currently running on the Dedicated host.
	Instances []*HostInstance `locationName:"instances" locationNameList:"item" type:"list"`

	// The Dedicated host's state.
	State *string `locationName:"state" type:"string" enum:"AllocationState"`
}

// String returns the string representation
func (s Host) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Host) GoString() string {
	return s.String()
}

type HostInstance struct {
	_ struct{} `type:"structure"`

	// the IDs of instances that are running on the Dedicated host.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance type size (e.g., m3.medium) of the running instance.
	InstanceType *string `locationName:"instanceType" type:"string"`
}

// String returns the string representation
func (s HostInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostInstance) GoString() string {
	return s.String()
}

type HostProperties struct {
	_ struct{} `type:"structure"`

	// The number of cores on the Dedicated host.
	Cores *int64 `locationName:"cores" type:"integer"`

	// The instance type size that the Dedicated host supports (e.g., m3.medium).
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The number of sockets on the Dedicated host.
	Sockets *int64 `locationName:"sockets" type:"integer"`

	// The number of vCPUs on the Dedicated host.
	TotalVCpus *int64 `locationName:"totalVCpus" type:"integer"`
}

// String returns the string representation
func (s HostProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostProperties) GoString() string {
	return s.String()
}

// Describes an IAM instance profile.
type IamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the instance profile.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IamInstanceProfile) GoString() string {
	return s.String()
}

// Describes an IAM instance profile.
type IamInstanceProfileSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the instance profile.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfileSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IamInstanceProfileSpecification) GoString() string {
	return s.String()
}

// Describes the ICMP type and code.
type IcmpTypeCode struct {
	_ struct{} `type:"structure"`

	// The ICMP type. A value of -1 means all types.
	Code *int64 `locationName:"code" type:"integer"`

	// The ICMP code. A value of -1 means all codes for the specified ICMP type.
	Type *int64 `locationName:"type" type:"integer"`
}

// String returns the string representation
func (s IcmpTypeCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IcmpTypeCode) GoString() string {
	return s.String()
}

// Describes the ID format for a resource.
type IdFormat struct {
	_ struct{} `type:"structure"`

	// The date in UTC at which you are permanently switched over to using longer
	// IDs.
	Deadline *time.Time `locationName:"deadline" type:"timestamp" timestampFormat:"iso8601"`

	// The type of resource.
	Resource *string `locationName:"resource" type:"string"`

	// Indicates whether longer IDs (17-character IDs) are enabled for the resource.
	UseLongIds *bool `locationName:"useLongIds" type:"boolean"`
}

// String returns the string representation
func (s IdFormat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdFormat) GoString() string {
	return s.String()
}

// Describes an image.
type Image struct {
	_ struct{} `type:"structure"`

	// The architecture of the image.
	Architecture *string `locationName:"architecture" type:"string" enum:"ArchitectureValues"`

	// Any block device mapping entries.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// The date and time the image was created.
	CreationDate *string `locationName:"creationDate" type:"string"`

	// The description of the AMI that was provided during image creation.
	Description *string `locationName:"description" type:"string"`

	// The hypervisor type of the image.
	Hypervisor *string `locationName:"hypervisor" type:"string" enum:"HypervisorType"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The location of the AMI.
	ImageLocation *string `locationName:"imageLocation" type:"string"`

	// The AWS account alias (for example, amazon, self) or the AWS account ID of
	// the AMI owner.
	ImageOwnerAlias *string `locationName:"imageOwnerAlias" type:"string"`

	// The type of image.
	ImageType *string `locationName:"imageType" type:"string" enum:"ImageTypeValues"`

	// The kernel associated with the image, if any. Only applicable for machine
	// images.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the AMI that was provided during image creation.
	Name *string `locationName:"name" type:"string"`

	// The AWS account ID of the image owner.
	OwnerId *string `locationName:"imageOwnerId" type:"string"`

	// The value is Windows for Windows AMIs; otherwise blank.
	Platform *string `locationName:"platform" type:"string" enum:"PlatformValues"`

	// Any product codes associated with the AMI.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// Indicates whether the image has public launch permissions. The value is true
	// if this image has public launch permissions or false if it has only implicit
	// and explicit launch permissions.
	Public *bool `locationName:"isPublic" type:"boolean"`

	// The RAM disk associated with the image, if any. Only applicable for machine
	// images.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// The device name of the root device (for example, /dev/sda1 or /dev/xvda).
	RootDeviceName *string `locationName:"rootDeviceName" type:"string"`

	// The type of root device used by the AMI. The AMI can use an EBS volume or
	// an instance store volume.
	RootDeviceType *string `locationName:"rootDeviceType" type:"string" enum:"DeviceType"`

	// Specifies whether enhanced networking is enabled.
	SriovNetSupport *string `locationName:"sriovNetSupport" type:"string"`

	// The current state of the AMI. If the state is available, the image is successfully
	// registered and can be used to launch an instance.
	State *string `locationName:"imageState" type:"string" enum:"ImageState"`

	// The reason for the state change.
	StateReason *StateReason `locationName:"stateReason" type:"structure"`

	// Any tags assigned to the image.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of virtualization of the AMI.
	VirtualizationType *string `locationName:"virtualizationType" type:"string" enum:"VirtualizationType"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Image) GoString() string {
	return s.String()
}

// Describes the disk container object for an import image task.
type ImageDiskContainer struct {
	_ struct{} `type:"structure"`

	// The description of the disk image.
	Description *string `type:"string"`

	// The block device mapping for the disk.
	DeviceName *string `type:"string"`

	// The format of the disk image being imported.
	//
	// Valid values: RAW | VHD | VMDK | OVA
	Format *string `type:"string"`

	// The ID of the EBS snapshot to be used for importing the snapshot.
	SnapshotId *string `type:"string"`

	// The URL to the Amazon S3-based disk image being imported. The URL can either
	// be a https URL (https://..) or an Amazon S3 URL (s3://..)
	Url *string `type:"string"`

	// The S3 bucket for the disk image.
	UserBucket *UserBucket `type:"structure"`
}

// String returns the string representation
func (s ImageDiskContainer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageDiskContainer) GoString() string {
	return s.String()
}

type ImportImageInput struct {
	_ struct{} `type:"structure"`

	// The architecture of the virtual machine.
	//
	// Valid values: i386 | x86_64
	Architecture *string `type:"string"`

	// The client-specific data.
	ClientData *ClientData `type:"structure"`

	// The token to enable idempotency for VM import requests.
	ClientToken *string `type:"string"`

	// A description string for the import image task.
	Description *string `type:"string"`

	// Information about the disk containers.
	DiskContainers []*ImageDiskContainer `locationName:"DiskContainer" locationNameList:"item" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The target hypervisor platform.
	//
	// Valid values: xen
	Hypervisor *string `type:"string"`

	// The license type to be used for the Amazon Machine Image (AMI) after importing.
	//
	// Note: You may only use BYOL if you have existing licenses with rights to
	// use these licenses in a third party cloud like AWS. For more information,
	// see VM Import/Export Prerequisites (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/VMImportPrerequisites.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Valid values: AWS | BYOL
	LicenseType *string `type:"string"`

	// The operating system of the virtual machine.
	//
	// Valid values: Windows | Linux
	Platform *string `type:"string"`

	// The name of the role to use when not using the default role, 'vmimport'.
	RoleName *string `type:"string"`
}

// String returns the string representation
func (s ImportImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportImageInput) GoString() string {
	return s.String()
}

type ImportImageOutput struct {
	_ struct{} `type:"structure"`

	// The architecture of the virtual machine.
	Architecture *string `locationName:"architecture" type:"string"`

	// A description of the import task.
	Description *string `locationName:"description" type:"string"`

	// The target hypervisor of the import task.
	Hypervisor *string `locationName:"hypervisor" type:"string"`

	// The ID of the Amazon Machine Image (AMI) created by the import task.
	ImageId *string `locationName:"imageId" type:"string"`

	// The task ID of the import image task.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// The license type of the virtual machine.
	LicenseType *string `locationName:"licenseType" type:"string"`

	// The operating system of the virtual machine.
	Platform *string `locationName:"platform" type:"string"`

	// The progress of the task.
	Progress *string `locationName:"progress" type:"string"`

	// Information about the snapshots.
	SnapshotDetails []*SnapshotDetail `locationName:"snapshotDetailSet" locationNameList:"item" type:"list"`

	// A brief status of the task.
	Status *string `locationName:"status" type:"string"`

	// A detailed status message of the import task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s ImportImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportImageOutput) GoString() string {
	return s.String()
}

// Describes an import image task.
type ImportImageTask struct {
	_ struct{} `type:"structure"`

	// The architecture of the virtual machine.
	//
	// Valid values: i386 | x86_64
	Architecture *string `locationName:"architecture" type:"string"`

	// A description of the import task.
	Description *string `locationName:"description" type:"string"`

	// The target hypervisor for the import task.
	//
	// Valid values: xen
	Hypervisor *string `locationName:"hypervisor" type:"string"`

	// The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the import image task.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// The license type of the virtual machine.
	LicenseType *string `locationName:"licenseType" type:"string"`

	// The description string for the import image task.
	Platform *string `locationName:"platform" type:"string"`

	// The percentage of progress of the import image task.
	Progress *string `locationName:"progress" type:"string"`

	// Information about the snapshots.
	SnapshotDetails []*SnapshotDetail `locationName:"snapshotDetailSet" locationNameList:"item" type:"list"`

	// A brief status for the import image task.
	Status *string `locationName:"status" type:"string"`

	// A descriptive status message for the import image task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s ImportImageTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportImageTask) GoString() string {
	return s.String()
}

type ImportInstanceInput struct {
	_ struct{} `type:"structure"`

	// A description for the instance being imported.
	Description *string `locationName:"description" type:"string"`

	// The disk image.
	DiskImages []*DiskImage `locationName:"diskImage" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The launch specification.
	LaunchSpecification *ImportInstanceLaunchSpecification `locationName:"launchSpecification" type:"structure"`

	// The instance operating system.
	Platform *string `locationName:"platform" type:"string" required:"true" enum:"PlatformValues"`
}

// String returns the string representation
func (s ImportInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportInstanceInput) GoString() string {
	return s.String()
}

// Describes the launch specification for VM import.
type ImportInstanceLaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `locationName:"additionalInfo" type:"string"`

	// The architecture of the instance.
	Architecture *string `locationName:"architecture" type:"string" enum:"ArchitectureValues"`

	// One or more security group IDs.
	GroupIds []*string `locationName:"GroupId" locationNameList:"SecurityGroupId" type:"list"`

	// One or more security group names.
	GroupNames []*string `locationName:"GroupName" locationNameList:"SecurityGroup" type:"list"`

	// Indicates whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	InstanceInitiatedShutdownBehavior *string `locationName:"instanceInitiatedShutdownBehavior" type:"string" enum:"ShutdownBehavior"`

	// The instance type. For more information about the instance types that you
	// can import, see Before You Get Started (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/VMImportPrerequisites.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// Indicates whether monitoring is enabled.
	Monitoring *bool `locationName:"monitoring" type:"boolean"`

	// The placement information for the instance.
	Placement *Placement `locationName:"placement" type:"structure"`

	// [EC2-VPC] An available IP address from the IP address range of the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// [EC2-VPC] The ID of the subnet in which to launch the instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The Base64-encoded MIME user data to be made available to the instance.
	UserData *UserData `locationName:"userData" type:"structure"`
}

// String returns the string representation
func (s ImportInstanceLaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportInstanceLaunchSpecification) GoString() string {
	return s.String()
}

type ImportInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the conversion task.
	ConversionTask *ConversionTask `locationName:"conversionTask" type:"structure"`
}

// String returns the string representation
func (s ImportInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportInstanceOutput) GoString() string {
	return s.String()
}

// Describes an import instance task.
type ImportInstanceTaskDetails struct {
	_ struct{} `type:"structure"`

	// A description of the task.
	Description *string `locationName:"description" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance operating system.
	Platform *string `locationName:"platform" type:"string" enum:"PlatformValues"`

	// One or more volumes.
	Volumes []*ImportInstanceVolumeDetailItem `locationName:"volumes" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s ImportInstanceTaskDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportInstanceTaskDetails) GoString() string {
	return s.String()
}

// Describes an import volume task.
type ImportInstanceVolumeDetailItem struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the resulting instance will reside.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The number of bytes converted so far.
	BytesConverted *int64 `locationName:"bytesConverted" type:"long" required:"true"`

	// A description of the task.
	Description *string `locationName:"description" type:"string"`

	// The image.
	Image *DiskImageDescription `locationName:"image" type:"structure" required:"true"`

	// The status of the import of this particular disk image.
	Status *string `locationName:"status" type:"string" required:"true"`

	// The status information or errors related to the disk image.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The volume.
	Volume *DiskImageVolumeDescription `locationName:"volume" type:"structure" required:"true"`
}

// String returns the string representation
func (s ImportInstanceVolumeDetailItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportInstanceVolumeDetailItem) GoString() string {
	return s.String()
}

type ImportKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A unique name for the key pair.
	KeyName *string `locationName:"keyName" type:"string" required:"true"`

	// The public key. You must base64 encode the public key material before sending
	// it to AWS.
	PublicKeyMaterial []byte `locationName:"publicKeyMaterial" type:"blob" required:"true"`
}

// String returns the string representation
func (s ImportKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairInput) GoString() string {
	return s.String()
}

type ImportKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// The MD5 public key fingerprint as specified in section 4 of RFC 4716.
	KeyFingerprint *string `locationName:"keyFingerprint" type:"string"`

	// The key pair name you provided.
	KeyName *string `locationName:"keyName" type:"string"`
}

// String returns the string representation
func (s ImportKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairOutput) GoString() string {
	return s.String()
}

type ImportSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The client-specific data.
	ClientData *ClientData `type:"structure"`

	// Token to enable idempotency for VM import requests.
	ClientToken *string `type:"string"`

	// The description string for the import snapshot task.
	Description *string `type:"string"`

	// Information about the disk container.
	DiskContainer *SnapshotDiskContainer `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The name of the role to use when not using the default role, 'vmimport'.
	RoleName *string `type:"string"`
}

// String returns the string representation
func (s ImportSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSnapshotInput) GoString() string {
	return s.String()
}

type ImportSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// A description of the import snapshot task.
	Description *string `locationName:"description" type:"string"`

	// The ID of the import snapshot task.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// Information about the import snapshot task.
	SnapshotTaskDetail *SnapshotTaskDetail `locationName:"snapshotTaskDetail" type:"structure"`
}

// String returns the string representation
func (s ImportSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSnapshotOutput) GoString() string {
	return s.String()
}

// Describes an import snapshot task.
type ImportSnapshotTask struct {
	_ struct{} `type:"structure"`

	// A description of the import snapshot task.
	Description *string `locationName:"description" type:"string"`

	// The ID of the import snapshot task.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// Describes an import snapshot task.
	SnapshotTaskDetail *SnapshotTaskDetail `locationName:"snapshotTaskDetail" type:"structure"`
}

// String returns the string representation
func (s ImportSnapshotTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSnapshotTask) GoString() string {
	return s.String()
}

type ImportVolumeInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone for the resulting EBS volume.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the volume.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The disk image.
	Image *DiskImageDetail `locationName:"image" type:"structure" required:"true"`

	// The volume size.
	Volume *VolumeDetail `locationName:"volume" type:"structure" required:"true"`
}

// String returns the string representation
func (s ImportVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportVolumeInput) GoString() string {
	return s.String()
}

type ImportVolumeOutput struct {
	_ struct{} `type:"structure"`

	// Information about the conversion task.
	ConversionTask *ConversionTask `locationName:"conversionTask" type:"structure"`
}

// String returns the string representation
func (s ImportVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportVolumeOutput) GoString() string {
	return s.String()
}

// Describes an import volume task.
type ImportVolumeTaskDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the resulting volume will reside.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The number of bytes converted so far.
	BytesConverted *int64 `locationName:"bytesConverted" type:"long" required:"true"`

	// The description you provided when starting the import volume task.
	Description *string `locationName:"description" type:"string"`

	// The image.
	Image *DiskImageDescription `locationName:"image" type:"structure" required:"true"`

	// The volume.
	Volume *DiskImageVolumeDescription `locationName:"volume" type:"structure" required:"true"`
}

// String returns the string representation
func (s ImportVolumeTaskDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportVolumeTaskDetails) GoString() string {
	return s.String()
}

// Describes an instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The AMI launch index, which can be used to find this instance in the launch
	// group.
	AmiLaunchIndex *int64 `locationName:"amiLaunchIndex" type:"integer"`

	// The architecture of the image.
	Architecture *string `locationName:"architecture" type:"string" enum:"ArchitectureValues"`

	// Any block device mapping entries for the instance.
	BlockDeviceMappings []*InstanceBlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// The idempotency token you provided when you launched the instance, if applicable.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether the instance is optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The hypervisor type of the instance.
	Hypervisor *string `locationName:"hypervisor" type:"string" enum:"HypervisorType"`

	// The IAM instance profile associated with the instance, if applicable.
	IamInstanceProfile *IamInstanceProfile `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI used to launch the instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Indicates whether this is a Spot instance.
	InstanceLifecycle *string `locationName:"instanceLifecycle" type:"string" enum:"InstanceLifecycleType"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// The kernel associated with this instance, if applicable.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair, if this instance was launched with an associated
	// key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// The time the instance was launched.
	LaunchTime *time.Time `locationName:"launchTime" type:"timestamp" timestampFormat:"iso8601"`

	// The monitoring information for the instance.
	Monitoring *Monitoring `locationName:"monitoring" type:"structure"`

	// [EC2-VPC] One or more network interfaces for the instance.
	NetworkInterfaces []*InstanceNetworkInterface `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`

	// The location where the instance launched, if applicable.
	Placement *Placement `locationName:"placement" type:"structure"`

	// The value is Windows for Windows instances; otherwise blank.
	Platform *string `locationName:"platform" type:"string" enum:"PlatformValues"`

	// The private DNS name assigned to the instance. This DNS name can only be
	// used inside the Amazon EC2 network. This name is not available until the
	// instance enters the running state. For EC2-VPC, this name is only available
	// if you've enabled DNS hostnames for your VPC.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address assigned to the instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The product codes attached to this instance, if applicable.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// The public DNS name assigned to the instance. This name is not available
	// until the instance enters the running state. For EC2-VPC, this name is only
	// available if you've enabled DNS hostnames for your VPC.
	PublicDnsName *string `locationName:"dnsName" type:"string"`

	// The public IP address assigned to the instance, if applicable.
	PublicIpAddress *string `locationName:"ipAddress" type:"string"`

	// The RAM disk associated with this instance, if applicable.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// The root device name (for example, /dev/sda1 or /dev/xvda).
	RootDeviceName *string `locationName:"rootDeviceName" type:"string"`

	// The root device type used by the AMI. The AMI can use an EBS volume or an
	// instance store volume.
	RootDeviceType *string `locationName:"rootDeviceType" type:"string" enum:"DeviceType"`

	// One or more security groups for the instance.
	SecurityGroups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// Specifies whether to enable an instance launched in a VPC to perform NAT.
	// This controls whether source/destination checking is enabled on the instance.
	// A value of true means checking is enabled, and false means checking is disabled.
	// The value must be false for the instance to perform NAT. For more information,
	// see NAT Instances (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SourceDestCheck *bool `locationName:"sourceDestCheck" type:"boolean"`

	// If the request is a Spot instance request, the ID of the request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`

	// Specifies whether enhanced networking is enabled.
	SriovNetSupport *string `locationName:"sriovNetSupport" type:"string"`

	// The current state of the instance.
	State *InstanceState `locationName:"instanceState" type:"structure"`

	// The reason for the most recent state transition.
	StateReason *StateReason `locationName:"stateReason" type:"structure"`

	// The reason for the most recent state transition. This might be an empty string.
	StateTransitionReason *string `locationName:"reason" type:"string"`

	// [EC2-VPC] The ID of the subnet in which the instance is running.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// Any tags assigned to the instance.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The virtualization type of the instance.
	VirtualizationType *string `locationName:"virtualizationType" type:"string" enum:"VirtualizationType"`

	// [EC2-VPC] The ID of the VPC in which the instance is running.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// Describes a block device mapping.
type InstanceBlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the instance (for example, /dev/sdh or xvdh).
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *EbsInstanceBlockDevice `locationName:"ebs" type:"structure"`
}

// String returns the string representation
func (s InstanceBlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceBlockDeviceMapping) GoString() string {
	return s.String()
}

// Describes a block device mapping entry.
type InstanceBlockDeviceMappingSpecification struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the instance (for example, /dev/sdh or xvdh).
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *EbsInstanceBlockDeviceSpecification `locationName:"ebs" type:"structure"`

	// suppress the specified device included in the block device mapping.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// The virtual device name.
	VirtualName *string `locationName:"virtualName" type:"string"`
}

// String returns the string representation
func (s InstanceBlockDeviceMappingSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceBlockDeviceMappingSpecification) GoString() string {
	return s.String()
}

// Information about the instance type that the Dedicated host supports.
type InstanceCapacity struct {
	_ struct{} `type:"structure"`

	// The number of instances that can still be launched onto the Dedicated host.
	AvailableCapacity *int64 `locationName:"availableCapacity" type:"integer"`

	// The instance type size supported by the Dedicated host.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The total number of instances that can be launched onto the Dedicated host.
	TotalCapacity *int64 `locationName:"totalCapacity" type:"integer"`
}

// String returns the string representation
func (s InstanceCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceCapacity) GoString() string {
	return s.String()
}

// Describes a Reserved instance listing state.
type InstanceCount struct {
	_ struct{} `type:"structure"`

	// The number of listed Reserved instances in the state specified by the state.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The states of the listed Reserved instances.
	State *string `locationName:"state" type:"string" enum:"ListingState"`
}

// String returns the string representation
func (s InstanceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceCount) GoString() string {
	return s.String()
}

// Describes an instance to export.
type InstanceExportDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the resource being exported.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The target virtualization environment.
	TargetEnvironment *string `locationName:"targetEnvironment" type:"string" enum:"ExportEnvironment"`
}

// String returns the string representation
func (s InstanceExportDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceExportDetails) GoString() string {
	return s.String()
}

// Describes the monitoring information of the instance.
type InstanceMonitoring struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The monitoring information.
	Monitoring *Monitoring `locationName:"monitoring" type:"structure"`
}

// String returns the string representation
func (s InstanceMonitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceMonitoring) GoString() string {
	return s.String()
}

// Describes a network interface.
type InstanceNetworkInterface struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IP associated with the network
	// interface.
	Association *InstanceNetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// The network interface attachment.
	Attachment *InstanceNetworkInterfaceAttachment `locationName:"attachment" type:"structure"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// One or more security groups.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The MAC address.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the AWS account that created the network interface.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The private DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The IP address of the network interface within the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The private IP addresses associated with the network interface.
	PrivateIpAddresses []*InstancePrivateIpAddress `locationName:"privateIpAddressesSet" locationNameList:"item" type:"list"`

	// Indicates whether to validate network traffic to or from this network interface.
	SourceDestCheck *bool `locationName:"sourceDestCheck" type:"boolean"`

	// The status of the network interface.
	Status *string `locationName:"status" type:"string" enum:"NetworkInterfaceStatus"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s InstanceNetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceNetworkInterface) GoString() string {
	return s.String()
}

// Describes association information for an Elastic IP address.
type InstanceNetworkInterfaceAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the owner of the Elastic IP address.
	IpOwnerId *string `locationName:"ipOwnerId" type:"string"`

	// The public DNS name.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// The public IP address or Elastic IP address bound to the network interface.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s InstanceNetworkInterfaceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceNetworkInterfaceAssociation) GoString() string {
	return s.String()
}

// Describes a network interface attachment.
type InstanceNetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The time stamp when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The index of the device on the instance for the network interface attachment.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer"`

	// The attachment state.
	Status *string `locationName:"status" type:"string" enum:"AttachmentStatus"`
}

// String returns the string representation
func (s InstanceNetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceNetworkInterfaceAttachment) GoString() string {
	return s.String()
}

// Describes a network interface.
type InstanceNetworkInterfaceSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether to assign a public IP address to an instance you launch
	// in a VPC. The public IP address can only be assigned to a network interface
	// for eth0, and can only be assigned to a new network interface, not an existing
	// one. You cannot specify more than one network interface in the request. If
	// launching into a default subnet, the default value is true.
	AssociatePublicIpAddress *bool `locationName:"associatePublicIpAddress" type:"boolean"`

	// If set to true, the interface is deleted when the instance is terminated.
	// You can specify true only if creating a new network interface when launching
	// an instance.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The description of the network interface. Applies only if creating a network
	// interface when launching an instance.
	Description *string `locationName:"description" type:"string"`

	// The index of the device on the instance for the network interface attachment.
	// If you are specifying a network interface in a RunInstances request, you
	// must provide the device index.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer"`

	// The IDs of the security groups for the network interface. Applies only if
	// creating a network interface when launching an instance.
	Groups []*string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The private IP address of the network interface. Applies only if creating
	// a network interface when launching an instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// One or more private IP addresses to assign to the network interface. Only
	// one private IP address can be designated as primary.
	PrivateIpAddresses []*PrivateIpAddressSpecification `locationName:"privateIpAddressesSet" queryName:"PrivateIpAddresses" locationNameList:"item" type:"list"`

	// The number of secondary private IP addresses. You can't specify this option
	// and specify more than one private IP address using the private IP addresses
	// option.
	SecondaryPrivateIpAddressCount *int64 `locationName:"secondaryPrivateIpAddressCount" type:"integer"`

	// The ID of the subnet associated with the network string. Applies only if
	// creating a network interface when launching an instance.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s InstanceNetworkInterfaceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceNetworkInterfaceSpecification) GoString() string {
	return s.String()
}

// Describes a private IP address.
type InstancePrivateIpAddress struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IP address for the network interface.
	Association *InstanceNetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// Indicates whether this IP address is the primary private IP address of the
	// network interface.
	Primary *bool `locationName:"primary" type:"boolean"`

	// The private DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address of the network interface.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s InstancePrivateIpAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancePrivateIpAddress) GoString() string {
	return s.String()
}

// Describes the current state of the instance.
type InstanceState struct {
	_ struct{} `type:"structure"`

	// The low byte represents the state. The high byte is an opaque internal value
	// and should be ignored.
	//
	//  0 : pending
	//
	// 16 : running
	//
	// 32 : shutting-down
	//
	// 48 : terminated
	//
	// 64 : stopping
	//
	// 80 : stopped
	Code *int64 `locationName:"code" type:"integer"`

	// The current state of the instance.
	Name *string `locationName:"name" type:"string" enum:"InstanceStateName"`
}

// String returns the string representation
func (s InstanceState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceState) GoString() string {
	return s.String()
}

// Describes an instance state change.
type InstanceStateChange struct {
	_ struct{} `type:"structure"`

	// The current state of the instance.
	CurrentState *InstanceState `locationName:"currentState" type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The previous state of the instance.
	PreviousState *InstanceState `locationName:"previousState" type:"structure"`
}

// String returns the string representation
func (s InstanceStateChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStateChange) GoString() string {
	return s.String()
}

// Describes the status of an instance.
type InstanceStatus struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// Any scheduled events associated with the instance.
	Events []*InstanceStatusEvent `locationName:"eventsSet" locationNameList:"item" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The intended state of the instance. DescribeInstanceStatus requires that
	// an instance be in the running state.
	InstanceState *InstanceState `locationName:"instanceState" type:"structure"`

	// Reports impaired functionality that stems from issues internal to the instance,
	// such as impaired reachability.
	InstanceStatus *InstanceStatusSummary `locationName:"instanceStatus" type:"structure"`

	// Reports impaired functionality that stems from issues related to the systems
	// that support an instance, such as hardware failures and network connectivity
	// problems.
	SystemStatus *InstanceStatusSummary `locationName:"systemStatus" type:"structure"`
}

// String returns the string representation
func (s InstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStatus) GoString() string {
	return s.String()
}

// Describes the instance status.
type InstanceStatusDetails struct {
	_ struct{} `type:"structure"`

	// The time when a status check failed. For an instance that was launched and
	// impaired, this is the time when the instance was launched.
	ImpairedSince *time.Time `locationName:"impairedSince" type:"timestamp" timestampFormat:"iso8601"`

	// The type of instance status.
	Name *string `locationName:"name" type:"string" enum:"StatusName"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"StatusType"`
}

// String returns the string representation
func (s InstanceStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStatusDetails) GoString() string {
	return s.String()
}

// Describes a scheduled event for an instance.
type InstanceStatusEvent struct {
	_ struct{} `type:"structure"`

	// The event code.
	Code *string `locationName:"code" type:"string" enum:"EventCode"`

	// A description of the event.
	//
	// After a scheduled event is completed, it can still be described for up to
	// a week. If the event has been completed, this description starts with the
	// following text: [Completed].
	Description *string `locationName:"description" type:"string"`

	// The latest scheduled end time for the event.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The earliest scheduled start time for the event.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s InstanceStatusEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStatusEvent) GoString() string {
	return s.String()
}

// Describes the status of an instance.
type InstanceStatusSummary struct {
	_ struct{} `type:"structure"`

	// The system instance health or application instance health.
	Details []*InstanceStatusDetails `locationName:"details" locationNameList:"item" type:"list"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"SummaryStatus"`
}

// String returns the string representation
func (s InstanceStatusSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStatusSummary) GoString() string {
	return s.String()
}

// Describes an Internet gateway.
type InternetGateway struct {
	_ struct{} `type:"structure"`

	// Any VPCs attached to the Internet gateway.
	Attachments []*InternetGatewayAttachment `locationName:"attachmentSet" locationNameList:"item" type:"list"`

	// The ID of the Internet gateway.
	InternetGatewayId *string `locationName:"internetGatewayId" type:"string"`

	// Any tags assigned to the Internet gateway.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s InternetGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternetGateway) GoString() string {
	return s.String()
}

// Describes the attachment of a VPC to an Internet gateway.
type InternetGatewayAttachment struct {
	_ struct{} `type:"structure"`

	// The current state of the attachment.
	State *string `locationName:"state" type:"string" enum:"AttachmentStatus"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s InternetGatewayAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternetGatewayAttachment) GoString() string {
	return s.String()
}

// Describes a security group rule.
type IpPermission struct {
	_ struct{} `type:"structure"`

	// The start of port range for the TCP and UDP protocols, or an ICMP type number.
	// A value of -1 indicates all ICMP types.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The IP protocol name (for tcp, udp, and icmp) or number (see Protocol Numbers
	// (http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
	//
	// [EC2-VPC only] When you authorize or revoke security group rules, you can
	// use -1 to specify all.
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// One or more IP ranges.
	IpRanges []*IpRange `locationName:"ipRanges" locationNameList:"item" type:"list"`

	// (Valid for AuthorizeSecurityGroupEgress, RevokeSecurityGroupEgress and DescribeSecurityGroups
	// only) One or more prefix list IDs for an AWS service. In an AuthorizeSecurityGroupEgress
	// request, this is the AWS service that you want to access through a VPC endpoint
	// from instances associated with the security group.
	PrefixListIds []*PrefixListId `locationName:"prefixListIds" locationNameList:"item" type:"list"`

	// The end of port range for the TCP and UDP protocols, or an ICMP code. A value
	// of -1 indicates all ICMP codes for the specified ICMP type.
	ToPort *int64 `locationName:"toPort" type:"integer"`

	// One or more security group and AWS account ID pairs.
	UserIdGroupPairs []*UserIdGroupPair `locationName:"groups" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s IpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpPermission) GoString() string {
	return s.String()
}

// Describes an IP range.
type IpRange struct {
	_ struct{} `type:"structure"`

	// The CIDR range. You can either specify a CIDR range or a source security
	// group, not both.
	CidrIp *string `locationName:"cidrIp" type:"string"`
}

// String returns the string representation
func (s IpRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRange) GoString() string {
	return s.String()
}

// Describes a key pair.
type KeyPairInfo struct {
	_ struct{} `type:"structure"`

	// If you used CreateKeyPair to create the key pair, this is the SHA-1 digest
	// of the DER encoded private key. If you used ImportKeyPair to provide AWS
	// the public key, this is the MD5 public key fingerprint as specified in section
	// 4 of RFC4716.
	KeyFingerprint *string `locationName:"keyFingerprint" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`
}

// String returns the string representation
func (s KeyPairInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPairInfo) GoString() string {
	return s.String()
}

// Describes a launch permission.
type LaunchPermission struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *string `locationName:"group" type:"string" enum:"PermissionGroup"`

	// The AWS account ID.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s LaunchPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchPermission) GoString() string {
	return s.String()
}

// Describes a launch permission modification.
type LaunchPermissionModifications struct {
	_ struct{} `type:"structure"`

	// The AWS account ID to add to the list of launch permissions for the AMI.
	Add []*LaunchPermission `locationNameList:"item" type:"list"`

	// The AWS account ID to remove from the list of launch permissions for the
	// AMI.
	Remove []*LaunchPermission `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s LaunchPermissionModifications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchPermissionModifications) GoString() string {
	return s.String()
}

// Describes the launch specification for an instance.
type LaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Deprecated.
	AddressingType *string `locationName:"addressingType" type:"string"`

	// One or more block device mapping entries.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// Indicates whether the instance is optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	//
	// Default: false
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// The ID of the kernel.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// Describes the monitoring for the instance.
	Monitoring *RunInstancesMonitoringEnabled `locationName:"monitoring" type:"structure"`

	// One or more network interfaces.
	NetworkInterfaces []*InstanceNetworkInterfaceSpecification `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`

	// The placement information for the instance.
	Placement *SpotPlacement `locationName:"placement" type:"structure"`

	// The ID of the RAM disk.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// One or more security groups. When requesting instances in a VPC, you must
	// specify the IDs of the security groups. When requesting instances in EC2-Classic,
	// you can specify the names or the IDs of the security groups.
	SecurityGroups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the subnet in which to launch the instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The Base64-encoded MIME user data to make available to the instances.
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s LaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchSpecification) GoString() string {
	return s.String()
}

type ModifyHostsInput struct {
	_ struct{} `type:"structure"`

	// Specify whether to enable or disable auto-placement.
	AutoPlacement *string `locationName:"autoPlacement" type:"string" required:"true" enum:"AutoPlacement"`

	// The host IDs of the Dedicated hosts you want to modify.
	HostIds []*string `locationName:"hostId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyHostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHostsInput) GoString() string {
	return s.String()
}

type ModifyHostsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Dedicated hosts that were successfully modified.
	Successful []*string `locationName:"successful" locationNameList:"item" type:"list"`

	// The IDs of the Dedicated hosts that could not be modified. Check whether
	// the setting you requested can be used.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ModifyHostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHostsOutput) GoString() string {
	return s.String()
}

type ModifyIdFormatInput struct {
	_ struct{} `type:"structure"`

	// The type of resource.
	Resource *string `type:"string" required:"true"`

	// Indicate whether the resource should use longer IDs (17-character IDs).
	UseLongIds *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ModifyIdFormatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyIdFormatInput) GoString() string {
	return s.String()
}

type ModifyIdFormatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyIdFormatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyIdFormatOutput) GoString() string {
	return s.String()
}

type ModifyImageAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to modify.
	Attribute *string `type:"string"`

	// A description for the AMI.
	Description *AttributeValue `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	ImageId *string `type:"string" required:"true"`

	// A launch permission modification.
	LaunchPermission *LaunchPermissionModifications `type:"structure"`

	// The operation type.
	OperationType *string `type:"string" enum:"OperationType"`

	// One or more product codes. After you add a product code to an AMI, it can't
	// be removed. This is only valid when modifying the productCodes attribute.
	ProductCodes []*string `locationName:"ProductCode" locationNameList:"ProductCode" type:"list"`

	// One or more user groups. This is only valid when modifying the launchPermission
	// attribute.
	UserGroups []*string `locationName:"UserGroup" locationNameList:"UserGroup" type:"list"`

	// One or more AWS account IDs. This is only valid when modifying the launchPermission
	// attribute.
	UserIds []*string `locationName:"UserId" locationNameList:"UserId" type:"list"`

	// The value of the attribute being modified. This is only valid when modifying
	// the description attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ModifyImageAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyImageAttributeInput) GoString() string {
	return s.String()
}

type ModifyImageAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyImageAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyImageAttributeOutput) GoString() string {
	return s.String()
}

type ModifyInstanceAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	Attribute *string `locationName:"attribute" type:"string" enum:"InstanceAttributeName"`

	// Modifies the DeleteOnTermination attribute for volumes that are currently
	// attached. The volume must be owned by the caller. If no value is specified
	// for DeleteOnTermination, the default is true and the volume is deleted when
	// the instance is terminated.
	//
	// To add instance store volumes to an Amazon EBS-backed instance, you must
	// add them when you launch the instance. For more information, see Updating
	// the Block Device Mapping when Launching an Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM)
	// in the Amazon Elastic Compute Cloud User Guide.
	BlockDeviceMappings []*InstanceBlockDeviceMappingSpecification `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// If the value is true, you can't terminate the instance using the Amazon EC2
	// console, CLI, or API; otherwise, you can. You cannot use this paramater for
	// Spot Instances.
	DisableApiTermination *AttributeBooleanValue `locationName:"disableApiTermination" type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether the instance is optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	EbsOptimized *AttributeBooleanValue `locationName:"ebsOptimized" type:"structure"`

	// [EC2-VPC] Changes the security groups of the instance. You must specify at
	// least one security group, even if it's just the default security group for
	// the VPC. You must specify the security group ID, not the security group name.
	Groups []*string `locationName:"GroupId" locationNameList:"groupId" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// Specifies whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	InstanceInitiatedShutdownBehavior *AttributeValue `locationName:"instanceInitiatedShutdownBehavior" type:"structure"`

	// Changes the instance type to the specified value. For more information, see
	// Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	// If the instance type is not valid, the error returned is InvalidInstanceAttributeValue.
	InstanceType *AttributeValue `locationName:"instanceType" type:"structure"`

	// Changes the instance's kernel to the specified value. We recommend that you
	// use PV-GRUB instead of kernels and RAM disks. For more information, see PV-GRUB
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
	Kernel *AttributeValue `locationName:"kernel" type:"structure"`

	// Changes the instance's RAM disk to the specified value. We recommend that
	// you use PV-GRUB instead of kernels and RAM disks. For more information, see
	// PV-GRUB (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
	Ramdisk *AttributeValue `locationName:"ramdisk" type:"structure"`

	// Specifies whether source/destination checking is enabled. A value of true
	// means that checking is enabled, and false means checking is disabled. This
	// value must be false for a NAT instance to perform NAT.
	SourceDestCheck *AttributeBooleanValue `type:"structure"`

	// Set to simple to enable enhanced networking for the instance.
	//
	// There is no way to disable enhanced networking at this time.
	//
	// This option is supported only for HVM instances. Specifying this option
	// with a PV instance can make it unreachable.
	SriovNetSupport *AttributeValue `locationName:"sriovNetSupport" type:"structure"`

	// Changes the instance's user data to the specified value.
	UserData *BlobAttributeValue `locationName:"userData" type:"structure"`

	// A new value for the attribute. Use only with the kernel, ramdisk, userData,
	// disableApiTermination, or instanceInitiatedShutdownBehavior attribute.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ModifyInstanceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceAttributeInput) GoString() string {
	return s.String()
}

type ModifyInstanceAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceAttributeOutput) GoString() string {
	return s.String()
}

type ModifyInstancePlacementInput struct {
	_ struct{} `type:"structure"`

	// The new affinity setting for the instance.
	Affinity *string `locationName:"affinity" type:"string" enum:"Affinity"`

	// The ID of the Dedicated host that the instance will have affinity with.
	HostId *string `locationName:"hostId" type:"string"`

	// The ID of the instance that you are modifying.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The tenancy of the instance that you are modifying.
	Tenancy *string `locationName:"tenancy" type:"string" enum:"HostTenancy"`
}

// String returns the string representation
func (s ModifyInstancePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstancePlacementInput) GoString() string {
	return s.String()
}

type ModifyInstancePlacementOutput struct {
	_ struct{} `type:"structure"`

	// Is true if the request succeeds, and an error otherwise.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ModifyInstancePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstancePlacementOutput) GoString() string {
	return s.String()
}

type ModifyNetworkInterfaceAttributeInput struct {
	_ struct{} `type:"structure"`

	// Information about the interface attachment. If modifying the 'delete on termination'
	// attribute, you must specify the ID of the interface attachment.
	Attachment *NetworkInterfaceAttachmentChanges `locationName:"attachment" type:"structure"`

	// A description for the network interface.
	Description *AttributeValue `locationName:"description" type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Changes the security groups for the network interface. The new set of groups
	// you specify replaces the current set. You must specify at least one group,
	// even if it's just the default security group in the VPC. You must specify
	// the ID of the security group, not the name.
	Groups []*string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`

	// Indicates whether source/destination checking is enabled. A value of true
	// means checking is enabled, and false means checking is disabled. This value
	// must be false for a NAT instance to perform NAT. For more information, see
	// NAT Instances (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SourceDestCheck *AttributeBooleanValue `locationName:"sourceDestCheck" type:"structure"`
}

// String returns the string representation
func (s ModifyNetworkInterfaceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyNetworkInterfaceAttributeInput) GoString() string {
	return s.String()
}

type ModifyNetworkInterfaceAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyNetworkInterfaceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyNetworkInterfaceAttributeOutput) GoString() string {
	return s.String()
}

type ModifyReservedInstancesInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive token you provide to ensure idempotency of your
	// modification request. For more information, see Ensuring Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The IDs of the Reserved instances to modify.
	ReservedInstancesIds []*string `locationName:"ReservedInstancesId" locationNameList:"ReservedInstancesId" type:"list" required:"true"`

	// The configuration settings for the Reserved instances to modify.
	TargetConfigurations []*ReservedInstancesConfiguration `locationName:"ReservedInstancesConfigurationSetItemType" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyReservedInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReservedInstancesInput) GoString() string {
	return s.String()
}

type ModifyReservedInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the modification.
	ReservedInstancesModificationId *string `locationName:"reservedInstancesModificationId" type:"string"`
}

// String returns the string representation
func (s ModifyReservedInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReservedInstancesOutput) GoString() string {
	return s.String()
}

type ModifySnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The snapshot attribute to modify.
	//
	//  Only volume creation permissions may be modified at the customer level.
	Attribute *string `type:"string" enum:"SnapshotAttributeName"`

	// A JSON representation of the snapshot attribute modification.
	CreateVolumePermission *CreateVolumePermissionModifications `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The group to modify for the snapshot.
	GroupNames []*string `locationName:"UserGroup" locationNameList:"GroupName" type:"list"`

	// The type of operation to perform to the attribute.
	OperationType *string `type:"string" enum:"OperationType"`

	// The ID of the snapshot.
	SnapshotId *string `type:"string" required:"true"`

	// The account ID to modify for the snapshot.
	UserIds []*string `locationName:"UserId" locationNameList:"UserId" type:"list"`
}

// String returns the string representation
func (s ModifySnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotAttributeInput) GoString() string {
	return s.String()
}

type ModifySnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifySnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotAttributeOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ModifySpotFleetRequest.
type ModifySpotFleetRequestInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether running Spot instances should be terminated if the target
	// capacity of the Spot fleet request is decreased below the current size of
	// the Spot fleet.
	ExcessCapacityTerminationPolicy *string `locationName:"excessCapacityTerminationPolicy" type:"string" enum:"ExcessCapacityTerminationPolicy"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`

	// The size of the fleet.
	TargetCapacity *int64 `locationName:"targetCapacity" type:"integer"`
}

// String returns the string representation
func (s ModifySpotFleetRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySpotFleetRequestInput) GoString() string {
	return s.String()
}

// Contains the output of ModifySpotFleetRequest.
type ModifySpotFleetRequestOutput struct {
	_ struct{} `type:"structure"`

	// Is true if the request succeeds, and an error otherwise.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ModifySpotFleetRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySpotFleetRequestOutput) GoString() string {
	return s.String()
}

type ModifySubnetAttributeInput struct {
	_ struct{} `type:"structure"`

	// Specify true to indicate that instances launched into the specified subnet
	// should be assigned public IP address.
	MapPublicIpOnLaunch *AttributeBooleanValue `type:"structure"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s ModifySubnetAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySubnetAttributeInput) GoString() string {
	return s.String()
}

type ModifySubnetAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifySubnetAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySubnetAttributeOutput) GoString() string {
	return s.String()
}

type ModifyVolumeAttributeInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume should be auto-enabled for I/O operations.
	AutoEnableIO *AttributeBooleanValue `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the volume.
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyVolumeAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVolumeAttributeInput) GoString() string {
	return s.String()
}

type ModifyVolumeAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyVolumeAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVolumeAttributeOutput) GoString() string {
	return s.String()
}

type ModifyVpcAttributeInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the instances launched in the VPC get DNS hostnames. If
	// enabled, instances in the VPC get DNS hostnames; otherwise, they do not.
	//
	// You cannot modify the DNS resolution and DNS hostnames attributes in the
	// same request. Use separate requests for each attribute. You can only enable
	// DNS hostnames if you've enabled DNS support.
	EnableDnsHostnames *AttributeBooleanValue `type:"structure"`

	// Indicates whether the DNS resolution is supported for the VPC. If enabled,
	// queries to the Amazon provided DNS server at the 169.254.169.253 IP address,
	// or the reserved IP address at the base of the VPC network range "plus two"
	// will succeed. If disabled, the Amazon provided DNS service in the VPC that
	// resolves public DNS hostnames to IP addresses is not enabled.
	//
	// You cannot modify the DNS resolution and DNS hostnames attributes in the
	// same request. Use separate requests for each attribute.
	EnableDnsSupport *AttributeBooleanValue `type:"structure"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyVpcAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVpcAttributeInput) GoString() string {
	return s.String()
}

type ModifyVpcAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyVpcAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVpcAttributeOutput) GoString() string {
	return s.String()
}

type ModifyVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// One or more route tables IDs to associate with the endpoint.
	AddRouteTableIds []*string `locationName:"AddRouteTableId" locationNameList:"item" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// A policy document to attach to the endpoint. The policy must be in valid
	// JSON format.
	PolicyDocument *string `type:"string"`

	// One or more route table IDs to disassociate from the endpoint.
	RemoveRouteTableIds []*string `locationName:"RemoveRouteTableId" locationNameList:"item" type:"list"`

	// Specify true to reset the policy document to the default policy. The default
	// policy allows access to the service.
	ResetPolicy *bool `type:"boolean"`

	// The ID of the endpoint.
	VpcEndpointId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVpcEndpointInput) GoString() string {
	return s.String()
}

type ModifyVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ModifyVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVpcEndpointOutput) GoString() string {
	return s.String()
}

type MonitorInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more instance IDs.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s MonitorInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonitorInstancesInput) GoString() string {
	return s.String()
}

type MonitorInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Monitoring information for one or more instances.
	InstanceMonitorings []*InstanceMonitoring `locationName:"instancesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s MonitorInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonitorInstancesOutput) GoString() string {
	return s.String()
}

// Describes the monitoring for the instance.
type Monitoring struct {
	_ struct{} `type:"structure"`

	// Indicates whether monitoring is enabled for the instance.
	State *string `locationName:"state" type:"string" enum:"MonitoringState"`
}

// String returns the string representation
func (s Monitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Monitoring) GoString() string {
	return s.String()
}

type MoveAddressToVpcInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string" required:"true"`
}

// String returns the string representation
func (s MoveAddressToVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveAddressToVpcInput) GoString() string {
	return s.String()
}

type MoveAddressToVpcOutput struct {
	_ struct{} `type:"structure"`

	// The allocation ID for the Elastic IP address.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The status of the move of the IP address.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s MoveAddressToVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveAddressToVpcOutput) GoString() string {
	return s.String()
}

// Describes the status of a moving Elastic IP address.
type MovingAddressStatus struct {
	_ struct{} `type:"structure"`

	// The status of the Elastic IP address that's being moved to the EC2-VPC platform,
	// or restored to the EC2-Classic platform.
	MoveStatus *string `locationName:"moveStatus" type:"string" enum:"MoveStatus"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s MovingAddressStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MovingAddressStatus) GoString() string {
	return s.String()
}

// Describes a NAT gateway.
type NatGateway struct {
	_ struct{} `type:"structure"`

	// The date and time the NAT gateway was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// The date and time the NAT gateway was deleted, if applicable.
	DeleteTime *time.Time `locationName:"deleteTime" type:"timestamp" timestampFormat:"iso8601"`

	// If the NAT gateway could not be created, specifies the error code for the
	// failure. (InsufficientFreeAddressesInSubnet | Gateway.NotAttached | InvalidAllocationID.NotFound
	// | Resource.AlreadyAssociated | InternalError)
	FailureCode *string `locationName:"failureCode" type:"string"`

	// If the NAT gateway could not be created, specifies the error message for
	// the failure, that corresponds to the error code.
	//
	//  For InsufficientFreeAddressesInSubnet: Subnet has insufficient free addresses
	// to create this NAT gateway For Gateway.NotAttached: Network vpc-xxxxxxxx
	// has no Internet gateway attached For InvalidAllocationID.NotFound: Elastic
	// IP address eipalloc-xxxxxxxx could not be associated with this NAT gateway
	// For Resource.AlreadyAssociated: Elastic IP address eipalloc-xxxxxxxx is already
	// associated For InternalError: Network interface eni-xxxxxxxx, created and
	// used internally by this NAT gateway is in an invalid state. Please try again.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// Information about the IP addresses and network interface associated with
	// the NAT gateway.
	NatGatewayAddresses []*NatGatewayAddress `locationName:"natGatewayAddressSet" locationNameList:"item" type:"list"`

	// The ID of the NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// The state of the NAT gateway.
	State *string `locationName:"state" type:"string" enum:"NatGatewayState"`

	// The ID of the subnet in which the NAT gateway is located.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The ID of the VPC in which the NAT gateway is located.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NatGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NatGateway) GoString() string {
	return s.String()
}

// Describes the IP addresses and network interface associated with a NAT gateway.
type NatGatewayAddress struct {
	_ struct{} `type:"structure"`

	// The allocation ID of the Elastic IP address that's associated with the NAT
	// gateway.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The ID of the network interface associated with the NAT gateway.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The private IP address associated with the Elastic IP address.
	PrivateIp *string `locationName:"privateIp" type:"string"`

	// The Elastic IP address associated with the NAT gateway.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s NatGatewayAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NatGatewayAddress) GoString() string {
	return s.String()
}

// Describes a network ACL.
type NetworkAcl struct {
	_ struct{} `type:"structure"`

	// Any associations between the network ACL and one or more subnets
	Associations []*NetworkAclAssociation `locationName:"associationSet" locationNameList:"item" type:"list"`

	// One or more entries (rules) in the network ACL.
	Entries []*NetworkAclEntry `locationName:"entrySet" locationNameList:"item" type:"list"`

	// Indicates whether this is the default network ACL for the VPC.
	IsDefault *bool `locationName:"default" type:"boolean"`

	// The ID of the network ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string"`

	// Any tags assigned to the network ACL.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC for the network ACL.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkAcl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkAcl) GoString() string {
	return s.String()
}

// Describes an association between a network ACL and a subnet.
type NetworkAclAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the association between a network ACL and a subnet.
	NetworkAclAssociationId *string `locationName:"networkAclAssociationId" type:"string"`

	// The ID of the network ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s NetworkAclAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkAclAssociation) GoString() string {
	return s.String()
}

// Describes an entry in a network ACL.
type NetworkAclEntry struct {
	_ struct{} `type:"structure"`

	// The network range to allow or deny, in CIDR notation.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Indicates whether the rule is an egress rule (applied to traffic leaving
	// the subnet).
	Egress *bool `locationName:"egress" type:"boolean"`

	// ICMP protocol: The ICMP type and code.
	IcmpTypeCode *IcmpTypeCode `locationName:"icmpTypeCode" type:"structure"`

	// TCP or UDP protocols: The range of ports the rule applies to.
	PortRange *PortRange `locationName:"portRange" type:"structure"`

	// The protocol. A value of -1 means all protocols.
	Protocol *string `locationName:"protocol" type:"string"`

	// Indicates whether to allow or deny the traffic that matches the rule.
	RuleAction *string `locationName:"ruleAction" type:"string" enum:"RuleAction"`

	// The rule number for the entry. ACL entries are processed in ascending order
	// by rule number.
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer"`
}

// String returns the string representation
func (s NetworkAclEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkAclEntry) GoString() string {
	return s.String()
}

// Describes a network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IP associated with the network
	// interface.
	Association *NetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// The network interface attachment.
	Attachment *NetworkInterfaceAttachment `locationName:"attachment" type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// A description.
	Description *string `locationName:"description" type:"string"`

	// Any security groups for the network interface.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The type of interface.
	InterfaceType *string `locationName:"interfaceType" type:"string" enum:"NetworkInterfaceType"`

	// The MAC address.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The AWS account ID of the owner of the network interface.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The private DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The IP address of the network interface within the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The private IP addresses associated with the network interface.
	PrivateIpAddresses []*NetworkInterfacePrivateIpAddress `locationName:"privateIpAddressesSet" locationNameList:"item" type:"list"`

	// The ID of the entity that launched the instance on your behalf (for example,
	// AWS Management Console or Auto Scaling).
	RequesterId *string `locationName:"requesterId" type:"string"`

	// Indicates whether the network interface is being managed by AWS.
	RequesterManaged *bool `locationName:"requesterManaged" type:"boolean"`

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool `locationName:"sourceDestCheck" type:"boolean"`

	// The status of the network interface.
	Status *string `locationName:"status" type:"string" enum:"NetworkInterfaceStatus"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// Any tags assigned to the network interface.
	TagSet []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// Describes association information for an Elastic IP address.
type NetworkInterfaceAssociation struct {
	_ struct{} `type:"structure"`

	// The allocation ID.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The association ID.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The ID of the Elastic IP address owner.
	IpOwnerId *string `locationName:"ipOwnerId" type:"string"`

	// The public DNS name.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// The address of the Elastic IP address bound to the network interface.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s NetworkInterfaceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterfaceAssociation) GoString() string {
	return s.String()
}

// Describes a network interface attachment.
type NetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The timestamp indicating when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The AWS account ID of the owner of the instance.
	InstanceOwnerId *string `locationName:"instanceOwnerId" type:"string"`

	// The attachment state.
	Status *string `locationName:"status" type:"string" enum:"AttachmentStatus"`
}

// String returns the string representation
func (s NetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterfaceAttachment) GoString() string {
	return s.String()
}

// Describes an attachment change.
type NetworkInterfaceAttachmentChanges struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`
}

// String returns the string representation
func (s NetworkInterfaceAttachmentChanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterfaceAttachmentChanges) GoString() string {
	return s.String()
}

// Describes the private IP address of a network interface.
type NetworkInterfacePrivateIpAddress struct {
	_ struct{} `type:"structure"`

	// The association information for an Elastic IP address associated with the
	// network interface.
	Association *NetworkInterfaceAssociation `locationName:"association" type:"structure"`

	// Indicates whether this IP address is the primary private IP address of the
	// network interface.
	Primary *bool `locationName:"primary" type:"boolean"`

	// The private DNS name.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s NetworkInterfacePrivateIpAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterfacePrivateIpAddress) GoString() string {
	return s.String()
}

type NewDhcpConfiguration struct {
	_ struct{} `type:"structure"`

	Key *string `locationName:"key" type:"string"`

	Values []*string `locationName:"Value" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s NewDhcpConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewDhcpConfiguration) GoString() string {
	return s.String()
}

// Describes the placement for the instance.
type Placement struct {
	_ struct{} `type:"structure"`

	// The affinity setting for the instance on the Dedicated host. This parameter
	// is not supported for the ImportInstance command.
	Affinity *string `locationName:"affinity" type:"string"`

	// The Availability Zone of the instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The name of the placement group the instance is in (for cluster compute instances).
	GroupName *string `locationName:"groupName" type:"string"`

	// The ID of the Dedicted host on which the instance resides. This parameter
	// is not support for the ImportInstance command.
	HostId *string `locationName:"hostId" type:"string"`

	// The tenancy of the instance (if the instance is running in a VPC). An instance
	// with a tenancy of dedicated runs on single-tenant hardware. The host tenancy
	// is not supported for the ImportInstance command.
	Tenancy *string `locationName:"tenancy" type:"string" enum:"Tenancy"`
}

// String returns the string representation
func (s Placement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Placement) GoString() string {
	return s.String()
}

// Describes a placement group.
type PlacementGroup struct {
	_ struct{} `type:"structure"`

	// The name of the placement group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The state of the placement group.
	State *string `locationName:"state" type:"string" enum:"PlacementGroupState"`

	// The placement strategy.
	Strategy *string `locationName:"strategy" type:"string" enum:"PlacementStrategy"`
}

// String returns the string representation
func (s PlacementGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementGroup) GoString() string {
	return s.String()
}

// Describes a range of ports.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The first port in the range.
	From *int64 `locationName:"from" type:"integer"`

	// The last port in the range.
	To *int64 `locationName:"to" type:"integer"`
}

// String returns the string representation
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortRange) GoString() string {
	return s.String()
}

// Describes prefixes for AWS services.
type PrefixList struct {
	_ struct{} `type:"structure"`

	// The IP address range of the AWS service.
	Cidrs []*string `locationName:"cidrSet" locationNameList:"item" type:"list"`

	// The ID of the prefix.
	PrefixListId *string `locationName:"prefixListId" type:"string"`

	// The name of the prefix.
	PrefixListName *string `locationName:"prefixListName" type:"string"`
}

// String returns the string representation
func (s PrefixList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrefixList) GoString() string {
	return s.String()
}

// The ID of the prefix.
type PrefixListId struct {
	_ struct{} `type:"structure"`

	// The ID of the prefix.
	PrefixListId *string `locationName:"prefixListId" type:"string"`
}

// String returns the string representation
func (s PrefixListId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrefixListId) GoString() string {
	return s.String()
}

// Describes the price for a Reserved instance.
type PriceSchedule struct {
	_ struct{} `type:"structure"`

	// The current price schedule, as determined by the term remaining for the Reserved
	// instance in the listing.
	//
	// A specific price schedule is always in effect, but only one price schedule
	// can be active at any time. Take, for example, a Reserved instance listing
	// that has five months remaining in its term. When you specify price schedules
	// for five months and two months, this means that schedule 1, covering the
	// first three months of the remaining term, will be active during months 5,
	// 4, and 3. Then schedule 2, covering the last two months of the term, will
	// be active for months 2 and 1.
	Active *bool `locationName:"active" type:"boolean"`

	// The currency for transacting the Reserved instance resale. At this time,
	// the only supported currency is USD.
	CurrencyCode *string `locationName:"currencyCode" type:"string" enum:"CurrencyCodeValues"`

	// The fixed price for the term.
	Price *float64 `locationName:"price" type:"double"`

	// The number of months remaining in the reservation. For example, 2 is the
	// second to the last month before the capacity reservation expires.
	Term *int64 `locationName:"term" type:"long"`
}

// String returns the string representation
func (s PriceSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PriceSchedule) GoString() string {
	return s.String()
}

// Describes the price for a Reserved instance.
type PriceScheduleSpecification struct {
	_ struct{} `type:"structure"`

	// The currency for transacting the Reserved instance resale. At this time,
	// the only supported currency is USD.
	CurrencyCode *string `locationName:"currencyCode" type:"string" enum:"CurrencyCodeValues"`

	// The fixed price for the term.
	Price *float64 `locationName:"price" type:"double"`

	// The number of months remaining in the reservation. For example, 2 is the
	// second to the last month before the capacity reservation expires.
	Term *int64 `locationName:"term" type:"long"`
}

// String returns the string representation
func (s PriceScheduleSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PriceScheduleSpecification) GoString() string {
	return s.String()
}

// Describes a Reserved instance offering.
type PricingDetail struct {
	_ struct{} `type:"structure"`

	// The number of reservations available for the price.
	Count *int64 `locationName:"count" type:"integer"`

	// The price per instance.
	Price *float64 `locationName:"price" type:"double"`
}

// String returns the string representation
func (s PricingDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PricingDetail) GoString() string {
	return s.String()
}

// Describes a secondary private IP address for a network interface.
type PrivateIpAddressSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether the private IP address is the primary private IP address.
	// Only one IP address can be designated as primary.
	Primary *bool `locationName:"primary" type:"boolean"`

	// The private IP addresses.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string" required:"true"`
}

// String returns the string representation
func (s PrivateIpAddressSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateIpAddressSpecification) GoString() string {
	return s.String()
}

// Describes a product code.
type ProductCode struct {
	_ struct{} `type:"structure"`

	// The product code.
	ProductCodeId *string `locationName:"productCode" type:"string"`

	// The type of product code.
	ProductCodeType *string `locationName:"type" type:"string" enum:"ProductCodeValues"`
}

// String returns the string representation
func (s ProductCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductCode) GoString() string {
	return s.String()
}

// Describes a virtual private gateway propagating route.
type PropagatingVgw struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway (VGW).
	GatewayId *string `locationName:"gatewayId" type:"string"`
}

// String returns the string representation
func (s PropagatingVgw) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PropagatingVgw) GoString() string {
	return s.String()
}

type PurchaseReservedInstancesOfferingInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The number of Reserved instances to purchase.
	InstanceCount *int64 `type:"integer" required:"true"`

	// Specified for Reserved Instance Marketplace offerings to limit the total
	// order and ensure that the Reserved instances are not purchased at unexpected
	// prices.
	LimitPrice *ReservedInstanceLimitPrice `locationName:"limitPrice" type:"structure"`

	// The ID of the Reserved instance offering to purchase.
	ReservedInstancesOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseReservedInstancesOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedInstancesOfferingInput) GoString() string {
	return s.String()
}

type PurchaseReservedInstancesOfferingOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the purchased Reserved instances.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`
}

// String returns the string representation
func (s PurchaseReservedInstancesOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedInstancesOfferingOutput) GoString() string {
	return s.String()
}

type RebootInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more instance IDs.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s RebootInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstancesInput) GoString() string {
	return s.String()
}

type RebootInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RebootInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstancesOutput) GoString() string {
	return s.String()
}

// Describes a recurring charge.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount of the recurring charge.
	Amount *float64 `locationName:"amount" type:"double"`

	// The frequency of the recurring charge.
	Frequency *string `locationName:"frequency" type:"string" enum:"RecurringChargeFrequency"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// Describes a region.
type Region struct {
	_ struct{} `type:"structure"`

	// The region service endpoint.
	Endpoint *string `locationName:"regionEndpoint" type:"string"`

	// The name of the region.
	RegionName *string `locationName:"regionName" type:"string"`
}

// String returns the string representation
func (s Region) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Region) GoString() string {
	return s.String()
}

type RegisterImageInput struct {
	_ struct{} `type:"structure"`

	// The architecture of the AMI.
	//
	// Default: For Amazon EBS-backed AMIs, i386. For instance store-backed AMIs,
	// the architecture specified in the manifest file.
	Architecture *string `locationName:"architecture" type:"string" enum:"ArchitectureValues"`

	// One or more block device mapping entries.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"BlockDeviceMapping" locationNameList:"BlockDeviceMapping" type:"list"`

	// A description for your AMI.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The full path to your AMI manifest in Amazon S3 storage.
	ImageLocation *string `type:"string"`

	// The ID of the kernel.
	KernelId *string `locationName:"kernelId" type:"string"`

	// A name for your AMI.
	//
	// Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets
	// ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('),
	// at-signs (@), or underscores(_)
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ID of the RAM disk.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// The name of the root device (for example, /dev/sda1, or /dev/xvda).
	RootDeviceName *string `locationName:"rootDeviceName" type:"string"`

	// Set to simple to enable enhanced networking for the AMI and any instances
	// that you launch from the AMI.
	//
	// There is no way to disable enhanced networking at this time.
	//
	// This option is supported only for HVM AMIs. Specifying this option with
	// a PV AMI can make instances launched from the AMI unreachable.
	SriovNetSupport *string `locationName:"sriovNetSupport" type:"string"`

	// The type of virtualization.
	//
	// Default: paravirtual
	VirtualizationType *string `locationName:"virtualizationType" type:"string"`
}

// String returns the string representation
func (s RegisterImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterImageInput) GoString() string {
	return s.String()
}

type RegisterImageOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the newly registered AMI.
	ImageId *string `locationName:"imageId" type:"string"`
}

// String returns the string representation
func (s RegisterImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterImageOutput) GoString() string {
	return s.String()
}

type RejectVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s RejectVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

type RejectVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s RejectVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

type ReleaseAddressInput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The allocation ID. Required for EC2-VPC.
	AllocationId *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// [EC2-Classic] The Elastic IP address. Required for EC2-Classic.
	PublicIp *string `type:"string"`
}

// String returns the string representation
func (s ReleaseAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseAddressInput) GoString() string {
	return s.String()
}

type ReleaseAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReleaseAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseAddressOutput) GoString() string {
	return s.String()
}

type ReleaseHostsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Dedicated hosts you want to release.
	HostIds []*string `locationName:"hostId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s ReleaseHostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseHostsInput) GoString() string {
	return s.String()
}

type ReleaseHostsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Dedicated hosts that were successfully released.
	Successful []*string `locationName:"successful" locationNameList:"item" type:"list"`

	// The IDs of the Dedicated hosts that could not be released, including an error
	// message.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ReleaseHostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseHostsOutput) GoString() string {
	return s.String()
}

type ReplaceNetworkAclAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the current association between the original network ACL and the
	// subnet.
	AssociationId *string `locationName:"associationId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the new network ACL to associate with the subnet.
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`
}

// String returns the string representation
func (s ReplaceNetworkAclAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceNetworkAclAssociationInput) GoString() string {
	return s.String()
}

type ReplaceNetworkAclAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new association.
	NewAssociationId *string `locationName:"newAssociationId" type:"string"`
}

// String returns the string representation
func (s ReplaceNetworkAclAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceNetworkAclAssociationOutput) GoString() string {
	return s.String()
}

type ReplaceNetworkAclEntryInput struct {
	_ struct{} `type:"structure"`

	// The network range to allow or deny, in CIDR notation.
	CidrBlock *string `locationName:"cidrBlock" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether to replace the egress rule.
	//
	// Default: If no value is specified, we replace the ingress rule.
	Egress *bool `locationName:"egress" type:"boolean" required:"true"`

	// ICMP protocol: The ICMP type and code. Required if specifying 1 (ICMP) for
	// the protocol.
	IcmpTypeCode *IcmpTypeCode `locationName:"Icmp" type:"structure"`

	// The ID of the ACL.
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`

	// TCP or UDP protocols: The range of ports the rule applies to. Required if
	// specifying 6 (TCP) or 17 (UDP) for the protocol.
	PortRange *PortRange `locationName:"portRange" type:"structure"`

	// The IP protocol. You can specify all or -1 to mean all protocols.
	Protocol *string `locationName:"protocol" type:"string" required:"true"`

	// Indicates whether to allow or deny the traffic that matches the rule.
	RuleAction *string `locationName:"ruleAction" type:"string" required:"true" enum:"RuleAction"`

	// The rule number of the entry to replace.
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer" required:"true"`
}

// String returns the string representation
func (s ReplaceNetworkAclEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceNetworkAclEntryInput) GoString() string {
	return s.String()
}

type ReplaceNetworkAclEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReplaceNetworkAclEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceNetworkAclEntryOutput) GoString() string {
	return s.String()
}

type ReplaceRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR address block used for the destination match. The value you provide
	// must match the CIDR of an existing route in the table.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of an Internet gateway or virtual private gateway.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of a NAT instance in your VPC.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The ID of a NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// The ID of a network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`

	// The ID of a VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s ReplaceRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceRouteInput) GoString() string {
	return s.String()
}

type ReplaceRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReplaceRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceRouteOutput) GoString() string {
	return s.String()
}

type ReplaceRouteTableAssociationInput struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `locationName:"associationId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the new route table to associate with the subnet.
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`
}

// String returns the string representation
func (s ReplaceRouteTableAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceRouteTableAssociationInput) GoString() string {
	return s.String()
}

type ReplaceRouteTableAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new association.
	NewAssociationId *string `locationName:"newAssociationId" type:"string"`
}

// String returns the string representation
func (s ReplaceRouteTableAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceRouteTableAssociationOutput) GoString() string {
	return s.String()
}

type ReportInstanceStatusInput struct {
	_ struct{} `type:"structure"`

	// Descriptive text about the health state of your instance.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The time at which the reported instance health state ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// One or more instances.
	Instances []*string `locationName:"instanceId" locationNameList:"InstanceId" type:"list" required:"true"`

	// One or more reason codes that describes the health state of your instance.
	//
	//  instance-stuck-in-state: My instance is stuck in a state.
	//
	// unresponsive: My instance is unresponsive.
	//
	// not-accepting-credentials: My instance is not accepting my credentials.
	//
	// password-not-available: A password is not available for my instance.
	//
	// performance-network: My instance is experiencing performance problems which
	// I believe are network related.
	//
	// performance-instance-store: My instance is experiencing performance problems
	// which I believe are related to the instance stores.
	//
	// performance-ebs-volume: My instance is experiencing performance problems
	// which I believe are related to an EBS volume.
	//
	// performance-other: My instance is experiencing performance problems.
	//
	// other: [explain using the description parameter]
	ReasonCodes []*string `locationName:"reasonCode" locationNameList:"item" type:"list" required:"true"`

	// The time at which the reported instance health state began.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The status of all instances listed.
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReportStatusType"`
}

// String returns the string representation
func (s ReportInstanceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportInstanceStatusInput) GoString() string {
	return s.String()
}

type ReportInstanceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReportInstanceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportInstanceStatusOutput) GoString() string {
	return s.String()
}

// Contains the parameters for RequestSpotFleet.
type RequestSpotFleetInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The configuration for the Spot fleet request.
	SpotFleetRequestConfig *SpotFleetRequestConfigData `locationName:"spotFleetRequestConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s RequestSpotFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestSpotFleetInput) GoString() string {
	return s.String()
}

// Contains the output of RequestSpotFleet.
type RequestSpotFleetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestSpotFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestSpotFleetOutput) GoString() string {
	return s.String()
}

// Contains the parameters for RequestSpotInstances.
type RequestSpotInstancesInput struct {
	_ struct{} `type:"structure"`

	// The user-specified name for a logical grouping of bids.
	//
	// When you specify an Availability Zone group in a Spot Instance request,
	// all Spot instances in the request are launched in the same Availability Zone.
	// Instance proximity is maintained with this parameter, but the choice of Availability
	// Zone is not. The group applies only to bids for Spot Instances of the same
	// instance type. Any additional Spot instance requests that are specified with
	// the same Availability Zone group name are launched in that same Availability
	// Zone, as long as at least one instance from the group is still active.
	//
	// If there is no active instance running in the Availability Zone group that
	// you specify for a new Spot instance request (all instances are terminated,
	// the bid is expired, or the bid falls below current market), then Amazon EC2
	// launches the instance in any Availability Zone where the constraint can be
	// met. Consequently, the subsequent set of Spot instances could be placed in
	// a different zone from the original request, even if you specified the same
	// Availability Zone group.
	//
	// Default: Instances are launched in any available Availability Zone.
	AvailabilityZoneGroup *string `locationName:"availabilityZoneGroup" type:"string"`

	// The required duration for the Spot instances, in minutes. This value must
	// be a multiple of 60 (60, 120, 180, 240, 300, or 360).
	//
	// The duration period starts as soon as your Spot instance receives its instance
	// ID. At the end of the duration period, Amazon EC2 marks the Spot instance
	// for termination and provides a Spot instance termination notice, which gives
	// the instance a two-minute warning before it terminates.
	//
	// Note that you can't specify an Availability Zone group or a launch group
	// if you specify a duration.
	BlockDurationMinutes *int64 `locationName:"blockDurationMinutes" type:"integer"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The maximum number of Spot instances to launch.
	//
	// Default: 1
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The instance launch group. Launch groups are Spot instances that launch together
	// and terminate together.
	//
	// Default: Instances are launched and terminated individually
	LaunchGroup *string `locationName:"launchGroup" type:"string"`

	// Describes the launch specification for an instance.
	LaunchSpecification *RequestSpotLaunchSpecification `type:"structure"`

	// The maximum hourly price (bid) for any Spot instance launched to fulfill
	// the request.
	SpotPrice *string `locationName:"spotPrice" type:"string" required:"true"`

	// The Spot instance request type.
	//
	// Default: one-time
	Type *string `locationName:"type" type:"string" enum:"SpotInstanceType"`

	// The start date of the request. If this is a one-time request, the request
	// becomes active at this date and time and remains active until all instances
	// launch, the request expires, or the request is canceled. If the request is
	// persistent, the request becomes active at this date and time and remains
	// active until it expires or is canceled.
	//
	// Default: The request is effective indefinitely.
	ValidFrom *time.Time `locationName:"validFrom" type:"timestamp" timestampFormat:"iso8601"`

	// The end date of the request. If this is a one-time request, the request remains
	// active until all instances launch, the request is canceled, or this date
	// is reached. If the request is persistent, it remains active until it is canceled
	// or this date and time is reached.
	//
	// Default: The request is effective indefinitely.
	ValidUntil *time.Time `locationName:"validUntil" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s RequestSpotInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestSpotInstancesInput) GoString() string {
	return s.String()
}

// Contains the output of RequestSpotInstances.
type RequestSpotInstancesOutput struct {
	_ struct{} `type:"structure"`

	// One or more Spot instance requests.
	SpotInstanceRequests []*SpotInstanceRequest `locationName:"spotInstanceRequestSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s RequestSpotInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestSpotInstancesOutput) GoString() string {
	return s.String()
}

// Describes the launch specification for an instance.
type RequestSpotLaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Deprecated.
	AddressingType *string `locationName:"addressingType" type:"string"`

	// One or more block device mapping entries.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// Indicates whether the instance is optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	//
	// Default: false
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// The ID of the kernel.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// Describes the monitoring for the instance.
	Monitoring *RunInstancesMonitoringEnabled `locationName:"monitoring" type:"structure"`

	// One or more network interfaces.
	NetworkInterfaces []*InstanceNetworkInterfaceSpecification `locationName:"NetworkInterface" locationNameList:"item" type:"list"`

	// The placement information for the instance.
	Placement *SpotPlacement `locationName:"placement" type:"structure"`

	// The ID of the RAM disk.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	SecurityGroupIds []*string `locationName:"SecurityGroupId" locationNameList:"item" type:"list"`

	SecurityGroups []*string `locationName:"SecurityGroup" locationNameList:"item" type:"list"`

	// The ID of the subnet in which to launch the instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The Base64-encoded MIME user data to make available to the instances.
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s RequestSpotLaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestSpotLaunchSpecification) GoString() string {
	return s.String()
}

// Describes a reservation.
type Reservation struct {
	_ struct{} `type:"structure"`

	// One or more security groups.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// One or more instances.
	Instances []*Instance `locationName:"instancesSet" locationNameList:"item" type:"list"`

	// The ID of the AWS account that owns the reservation.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The ID of the requester that launched the instances on your behalf (for example,
	// AWS Management Console or Auto Scaling).
	RequesterId *string `locationName:"requesterId" type:"string"`

	// The ID of the reservation.
	ReservationId *string `locationName:"reservationId" type:"string"`
}

// String returns the string representation
func (s Reservation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Reservation) GoString() string {
	return s.String()
}

// Describes the limit price of a Reserved instance offering.
type ReservedInstanceLimitPrice struct {
	_ struct{} `type:"structure"`

	// Used for Reserved Instance Marketplace offerings. Specifies the limit price
	// on the total order (instanceCount * price).
	Amount *float64 `locationName:"amount" type:"double"`

	// The currency in which the limitPrice amount is specified. At this time, the
	// only supported currency is USD.
	CurrencyCode *string `locationName:"currencyCode" type:"string" enum:"CurrencyCodeValues"`
}

// String returns the string representation
func (s ReservedInstanceLimitPrice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstanceLimitPrice) GoString() string {
	return s.String()
}

// Describes a Reserved instance.
type ReservedInstances struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the Reserved instance can be used.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The currency of the Reserved instance. It's specified using ISO 4217 standard
	// currency codes. At this time, the only supported currency is USD.
	CurrencyCode *string `locationName:"currencyCode" type:"string" enum:"CurrencyCodeValues"`

	// The duration of the Reserved instance, in seconds.
	Duration *int64 `locationName:"duration" type:"long"`

	// The time when the Reserved instance expires.
	End *time.Time `locationName:"end" type:"timestamp" timestampFormat:"iso8601"`

	// The purchase price of the Reserved instance.
	FixedPrice *float64 `locationName:"fixedPrice" type:"float"`

	// The number of reservations purchased.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The tenancy of the reserved instance.
	InstanceTenancy *string `locationName:"instanceTenancy" type:"string" enum:"Tenancy"`

	// The instance type on which the Reserved instance can be used.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// The Reserved instance offering type.
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingTypeValues"`

	// The Reserved instance product platform description.
	ProductDescription *string `locationName:"productDescription" type:"string" enum:"RIProductDescription"`

	// The recurring charge tag assigned to the resource.
	RecurringCharges []*RecurringCharge `locationName:"recurringCharges" locationNameList:"item" type:"list"`

	// The ID of the Reserved instance.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// The date and time the Reserved instance started.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`

	// The state of the Reserved instance purchase.
	State *string `locationName:"state" type:"string" enum:"ReservedInstanceState"`

	// Any tags assigned to the resource.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The usage price of the Reserved instance, per hour.
	UsagePrice *float64 `locationName:"usagePrice" type:"float"`
}

// String returns the string representation
func (s ReservedInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstances) GoString() string {
	return s.String()
}

// Describes the configuration settings for the modified Reserved instances.
type ReservedInstancesConfiguration struct {
	_ struct{} `type:"structure"`

	// The Availability Zone for the modified Reserved instances.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of modified Reserved instances.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The instance type for the modified Reserved instances.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// The network platform of the modified Reserved instances, which is either
	// EC2-Classic or EC2-VPC.
	Platform *string `locationName:"platform" type:"string"`
}

// String returns the string representation
func (s ReservedInstancesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstancesConfiguration) GoString() string {
	return s.String()
}

// Describes the ID of a Reserved instance.
type ReservedInstancesId struct {
	_ struct{} `type:"structure"`

	// The ID of the Reserved instance.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`
}

// String returns the string representation
func (s ReservedInstancesId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstancesId) GoString() string {
	return s.String()
}

// Describes a Reserved instance listing.
type ReservedInstancesListing struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive key supplied by the client to ensure that the request
	// is idempotent. For more information, see Ensuring Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The time the listing was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"iso8601"`

	// The number of instances in this state.
	InstanceCounts []*InstanceCount `locationName:"instanceCounts" locationNameList:"item" type:"list"`

	// The price of the Reserved instance listing.
	PriceSchedules []*PriceSchedule `locationName:"priceSchedules" locationNameList:"item" type:"list"`

	// The ID of the Reserved instance.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// The ID of the Reserved instance listing.
	ReservedInstancesListingId *string `locationName:"reservedInstancesListingId" type:"string"`

	// The status of the Reserved instance listing.
	Status *string `locationName:"status" type:"string" enum:"ListingStatus"`

	// The reason for the current status of the Reserved instance listing. The response
	// can be blank.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Any tags assigned to the resource.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The last modified timestamp of the listing.
	UpdateDate *time.Time `locationName:"updateDate" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ReservedInstancesListing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstancesListing) GoString() string {
	return s.String()
}

// Describes a Reserved instance modification.
type ReservedInstancesModification struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive key supplied by the client to ensure that the request
	// is idempotent. For more information, see Ensuring Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The time when the modification request was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"iso8601"`

	// The time for the modification to become effective.
	EffectiveDate *time.Time `locationName:"effectiveDate" type:"timestamp" timestampFormat:"iso8601"`

	// Contains target configurations along with their corresponding new Reserved
	// instance IDs.
	ModificationResults []*ReservedInstancesModificationResult `locationName:"modificationResultSet" locationNameList:"item" type:"list"`

	// The IDs of one or more Reserved instances.
	ReservedInstancesIds []*ReservedInstancesId `locationName:"reservedInstancesSet" locationNameList:"item" type:"list"`

	// A unique ID for the Reserved instance modification.
	ReservedInstancesModificationId *string `locationName:"reservedInstancesModificationId" type:"string"`

	// The status of the Reserved instances modification request.
	Status *string `locationName:"status" type:"string"`

	// The reason for the status.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The time when the modification request was last updated.
	UpdateDate *time.Time `locationName:"updateDate" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ReservedInstancesModification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstancesModification) GoString() string {
	return s.String()
}

type ReservedInstancesModificationResult struct {
	_ struct{} `type:"structure"`

	// The ID for the Reserved instances that were created as part of the modification
	// request. This field is only available when the modification is fulfilled.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// The target Reserved instances configurations supplied as part of the modification
	// request.
	TargetConfiguration *ReservedInstancesConfiguration `locationName:"targetConfiguration" type:"structure"`
}

// String returns the string representation
func (s ReservedInstancesModificationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstancesModificationResult) GoString() string {
	return s.String()
}

// Describes a Reserved instance offering.
type ReservedInstancesOffering struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the Reserved instance can be used.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The currency of the Reserved instance offering you are purchasing. It's specified
	// using ISO 4217 standard currency codes. At this time, the only supported
	// currency is USD.
	CurrencyCode *string `locationName:"currencyCode" type:"string" enum:"CurrencyCodeValues"`

	// The duration of the Reserved instance, in seconds.
	Duration *int64 `locationName:"duration" type:"long"`

	// The purchase price of the Reserved instance.
	FixedPrice *float64 `locationName:"fixedPrice" type:"float"`

	// The tenancy of the reserved instance.
	InstanceTenancy *string `locationName:"instanceTenancy" type:"string" enum:"Tenancy"`

	// The instance type on which the Reserved instance can be used.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// Indicates whether the offering is available through the Reserved Instance
	// Marketplace (resale) or AWS. If it's a Reserved Instance Marketplace offering,
	// this is true.
	Marketplace *bool `locationName:"marketplace" type:"boolean"`

	// The Reserved instance offering type.
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingTypeValues"`

	// The pricing details of the Reserved instance offering.
	PricingDetails []*PricingDetail `locationName:"pricingDetailsSet" locationNameList:"item" type:"list"`

	// The Reserved instance product platform description.
	ProductDescription *string `locationName:"productDescription" type:"string" enum:"RIProductDescription"`

	// The recurring charge tag assigned to the resource.
	RecurringCharges []*RecurringCharge `locationName:"recurringCharges" locationNameList:"item" type:"list"`

	// The ID of the Reserved instance offering.
	ReservedInstancesOfferingId *string `locationName:"reservedInstancesOfferingId" type:"string"`

	// The usage price of the Reserved instance, per hour.
	UsagePrice *float64 `locationName:"usagePrice" type:"float"`
}

// String returns the string representation
func (s ReservedInstancesOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedInstancesOffering) GoString() string {
	return s.String()
}

type ResetImageAttributeInput struct {
	_ struct{} `type:"structure"`

	// The attribute to reset (currently you can only reset the launch permission
	// attribute).
	Attribute *string `type:"string" required:"true" enum:"ResetImageAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResetImageAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetImageAttributeInput) GoString() string {
	return s.String()
}

type ResetImageAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetImageAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetImageAttributeOutput) GoString() string {
	return s.String()
}

type ResetInstanceAttributeInput struct {
	_ struct{} `type:"structure"`

	// The attribute to reset.
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"InstanceAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetInstanceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetInstanceAttributeInput) GoString() string {
	return s.String()
}

type ResetInstanceAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetInstanceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetInstanceAttributeOutput) GoString() string {
	return s.String()
}

type ResetNetworkInterfaceAttributeInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`

	// The source/destination checking attribute. Resets the value to true.
	SourceDestCheck *string `locationName:"sourceDestCheck" type:"string"`
}

// String returns the string representation
func (s ResetNetworkInterfaceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetNetworkInterfaceAttributeInput) GoString() string {
	return s.String()
}

type ResetNetworkInterfaceAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetNetworkInterfaceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetNetworkInterfaceAttributeOutput) GoString() string {
	return s.String()
}

type ResetSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The attribute to reset. Currently, only the attribute for permission to create
	// volumes can be reset.
	Attribute *string `type:"string" required:"true" enum:"SnapshotAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the snapshot.
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResetSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetSnapshotAttributeInput) GoString() string {
	return s.String()
}

type ResetSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetSnapshotAttributeOutput) GoString() string {
	return s.String()
}

type RestoreAddressToClassicInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreAddressToClassicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreAddressToClassicInput) GoString() string {
	return s.String()
}

type RestoreAddressToClassicOutput struct {
	_ struct{} `type:"structure"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// The move status for the IP address.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s RestoreAddressToClassicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreAddressToClassicOutput) GoString() string {
	return s.String()
}

type RevokeSecurityGroupEgressInput struct {
	_ struct{} `type:"structure"`

	// The CIDR IP address range. We recommend that you specify the CIDR range in
	// a set of IP permissions instead.
	CidrIp *string `locationName:"cidrIp" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The start of port range for the TCP and UDP protocols, or an ICMP type number.
	// We recommend that you specify the port range in a set of IP permissions instead.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string" required:"true"`

	// A set of IP permissions. You can't specify a destination security group and
	// a CIDR IP address range.
	IpPermissions []*IpPermission `locationName:"ipPermissions" locationNameList:"item" type:"list"`

	// The IP protocol name or number. We recommend that you specify the protocol
	// in a set of IP permissions instead.
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// The name of a destination security group. To revoke outbound access to a
	// destination security group, we recommend that you use a set of IP permissions
	// instead.
	SourceSecurityGroupName *string `locationName:"sourceSecurityGroupName" type:"string"`

	// The AWS account number for a destination security group. To revoke outbound
	// access to a destination security group, we recommend that you use a set of
	// IP permissions instead.
	SourceSecurityGroupOwnerId *string `locationName:"sourceSecurityGroupOwnerId" type:"string"`

	// The end of port range for the TCP and UDP protocols, or an ICMP type number.
	// We recommend that you specify the port range in a set of IP permissions instead.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s RevokeSecurityGroupEgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSecurityGroupEgressInput) GoString() string {
	return s.String()
}

type RevokeSecurityGroupEgressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeSecurityGroupEgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSecurityGroupEgressOutput) GoString() string {
	return s.String()
}

type RevokeSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The CIDR IP address range. You can't specify this parameter when specifying
	// a source security group.
	CidrIp *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The start of port range for the TCP and UDP protocols, or an ICMP type number.
	// For the ICMP type number, use -1 to specify all ICMP types.
	FromPort *int64 `type:"integer"`

	// The ID of the security group. Required for a security group in a nondefault
	// VPC.
	GroupId *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the security group.
	GroupName *string `type:"string"`

	// A set of IP permissions. You can't specify a source security group and a
	// CIDR IP address range.
	IpPermissions []*IpPermission `locationNameList:"item" type:"list"`

	// The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers (http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
	// Use -1 to specify all.
	IpProtocol *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the source security group. You can't
	// specify this parameter in combination with the following parameters: the
	// CIDR IP address range, the start of the port range, the IP protocol, and
	// the end of the port range. For EC2-VPC, the source security group must be
	// in the same VPC.
	SourceSecurityGroupName *string `type:"string"`

	// [EC2-Classic, default VPC] The AWS account ID of the source security group.
	// For EC2-VPC, the source security group must be in the same VPC. You can't
	// specify this parameter in combination with the following parameters: the
	// CIDR IP address range, the IP protocol, the start of the port range, and
	// the end of the port range. To revoke a specific rule for an IP protocol and
	// port range, use a set of IP permissions instead.
	SourceSecurityGroupOwnerId *string `type:"string"`

	// The end of port range for the TCP and UDP protocols, or an ICMP code number.
	// For the ICMP code number, use -1 to specify all ICMP codes for the ICMP type.
	ToPort *int64 `type:"integer"`
}

// String returns the string representation
func (s RevokeSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type RevokeSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// Describes a route in a route table.
type Route struct {
	_ struct{} `type:"structure"`

	// The CIDR block used for the destination match.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// The prefix of the AWS service.
	DestinationPrefixListId *string `locationName:"destinationPrefixListId" type:"string"`

	// The ID of a gateway attached to your VPC.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of a NAT instance in your VPC.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The AWS account ID of the owner of the instance.
	InstanceOwnerId *string `locationName:"instanceOwnerId" type:"string"`

	// The ID of a NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// Describes how the route was created.
	//
	//  CreateRouteTable indicates that route was automatically created when the
	// route table was created. CreateRoute indicates that the route was manually
	// added to the route table. EnableVgwRoutePropagation indicates that the route
	// was propagated by route propagation.
	Origin *string `locationName:"origin" type:"string" enum:"RouteOrigin"`

	// The state of the route. The blackhole state indicates that the route's target
	// isn't available (for example, the specified gateway isn't attached to the
	// VPC, or the specified NAT instance has been terminated).
	State *string `locationName:"state" type:"string" enum:"RouteState"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s Route) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Route) GoString() string {
	return s.String()
}

// Describes a route table.
type RouteTable struct {
	_ struct{} `type:"structure"`

	// The associations between the route table and one or more subnets.
	Associations []*RouteTableAssociation `locationName:"associationSet" locationNameList:"item" type:"list"`

	// Any virtual private gateway (VGW) propagating routes.
	PropagatingVgws []*PropagatingVgw `locationName:"propagatingVgwSet" locationNameList:"item" type:"list"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string"`

	// The routes in the route table.
	Routes []*Route `locationName:"routeSet" locationNameList:"item" type:"list"`

	// Any tags assigned to the route table.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s RouteTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteTable) GoString() string {
	return s.String()
}

// Describes an association between a route table and a subnet.
type RouteTableAssociation struct {
	_ struct{} `type:"structure"`

	// Indicates whether this is the main route table.
	Main *bool `locationName:"main" type:"boolean"`

	// The ID of the association between a route table and a subnet.
	RouteTableAssociationId *string `locationName:"routeTableAssociationId" type:"string"`

	// The ID of the route table.
	RouteTableId *string `locationName:"routeTableId" type:"string"`

	// The ID of the subnet. A subnet ID is not returned for an implicit association.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s RouteTableAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteTableAssociation) GoString() string {
	return s.String()
}

type RunInstancesInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `locationName:"additionalInfo" type:"string"`

	// The block device mapping.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"BlockDeviceMapping" locationNameList:"BlockDeviceMapping" type:"list"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see Ensuring Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	//
	// Constraints: Maximum 64 ASCII characters
	ClientToken *string `locationName:"clientToken" type:"string"`

	// If you set this parameter to true, you can't terminate the instance using
	// the Amazon EC2 console, CLI, or API; otherwise, you can. If you set this
	// parameter to true and then later want to be able to terminate the instance,
	// you must first change the value of the disableApiTermination attribute to
	// false using ModifyInstanceAttribute. Alternatively, if you set InstanceInitiatedShutdownBehavior
	// to terminate, you can terminate the instance by running the shutdown command
	// from the instance.
	//
	// Default: false
	DisableApiTermination *bool `locationName:"disableApiTermination" type:"boolean"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether the instance is optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS-optimized
	// instance.
	//
	// Default: false
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI, which you can get by calling DescribeImages.
	ImageId *string `type:"string" required:"true"`

	// Indicates whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	//
	// Default: stop
	InstanceInitiatedShutdownBehavior *string `locationName:"instanceInitiatedShutdownBehavior" type:"string" enum:"ShutdownBehavior"`

	// The instance type. For more information, see Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Default: m1.small
	InstanceType *string `type:"string" enum:"InstanceType"`

	// The ID of the kernel.
	//
	//  We recommend that you use PV-GRUB instead of kernels and RAM disks. For
	// more information, see  PV-GRUB (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	KernelId *string `type:"string"`

	// The name of the key pair. You can create a key pair using CreateKeyPair or
	// ImportKeyPair.
	//
	//  If you do not specify a key pair, you can't connect to the instance unless
	// you choose an AMI that is configured to allow users another way to log in.
	KeyName *string `type:"string"`

	// The maximum number of instances to launch. If you specify more instances
	// than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches
	// the largest possible number of instances above MinCount.
	//
	// Constraints: Between 1 and the maximum number you're allowed for the specified
	// instance type. For more information about the default limits, and how to
	// request an increase, see How many instances can I run in Amazon EC2 (http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2)
	// in the Amazon EC2 General FAQ.
	MaxCount *int64 `type:"integer" required:"true"`

	// The minimum number of instances to launch. If you specify a minimum that
	// is more instances than Amazon EC2 can launch in the target Availability Zone,
	// Amazon EC2 launches no instances.
	//
	// Constraints: Between 1 and the maximum number you're allowed for the specified
	// instance type. For more information about the default limits, and how to
	// request an increase, see How many instances can I run in Amazon EC2 (http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2)
	// in the Amazon EC2 General FAQ.
	MinCount *int64 `type:"integer" required:"true"`

	// The monitoring for the instance.
	Monitoring *RunInstancesMonitoringEnabled `type:"structure"`

	// One or more network interfaces.
	NetworkInterfaces []*InstanceNetworkInterfaceSpecification `locationName:"networkInterface" locationNameList:"item" type:"list"`

	// The placement for the instance.
	Placement *Placement `type:"structure"`

	// [EC2-VPC] The primary IP address. You must specify a value from the IP address
	// range of the subnet.
	//
	// Only one private IP address can be designated as primary. Therefore, you
	// can't specify this parameter if PrivateIpAddresses.n.Primary is set to true
	// and PrivateIpAddresses.n.PrivateIpAddress is set to an IP address.
	//
	// Default: We select an IP address from the IP address range of the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The ID of the RAM disk.
	//
	//  We recommend that you use PV-GRUB instead of kernels and RAM disks. For
	// more information, see  PV-GRUB (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	RamdiskId *string `type:"string"`

	// One or more security group IDs. You can create a security group using CreateSecurityGroup.
	//
	// Default: Amazon EC2 uses the default security group.
	SecurityGroupIds []*string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// [EC2-Classic, default VPC] One or more security group names. For a nondefault
	// VPC, you must use security group IDs instead.
	//
	// Default: Amazon EC2 uses the default security group.
	SecurityGroups []*string `locationName:"SecurityGroup" locationNameList:"SecurityGroup" type:"list"`

	// [EC2-VPC] The ID of the subnet to launch the instance into.
	SubnetId *string `type:"string"`

	// The Base64-encoded MIME user data for the instances.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s RunInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunInstancesInput) GoString() string {
	return s.String()
}

// Describes the monitoring for the instance.
type RunInstancesMonitoringEnabled struct {
	_ struct{} `type:"structure"`

	// Indicates whether monitoring is enabled for the instance.
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s RunInstancesMonitoringEnabled) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunInstancesMonitoringEnabled) GoString() string {
	return s.String()
}

// Describes the storage parameters for S3 and S3 buckets for an instance store-backed
// AMI.
type S3Storage struct {
	_ struct{} `type:"structure"`

	// The access key ID of the owner of the bucket. Before you specify a value
	// for your access key ID, review and follow the guidance in Best Practices
	// for Managing AWS Access Keys (http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html).
	AWSAccessKeyId *string `type:"string"`

	// The bucket in which to store the AMI. You can specify a bucket that you already
	// own or a new bucket that Amazon EC2 creates on your behalf. If you specify
	// a bucket that belongs to someone else, Amazon EC2 returns an error.
	Bucket *string `locationName:"bucket" type:"string"`

	// The beginning of the file name of the AMI.
	Prefix *string `locationName:"prefix" type:"string"`

	// A Base64-encoded Amazon S3 upload policy that gives Amazon EC2 permission
	// to upload items into Amazon S3 on your behalf.
	UploadPolicy []byte `locationName:"uploadPolicy" type:"blob"`

	// The signature of the Base64 encoded JSON document.
	UploadPolicySignature *string `locationName:"uploadPolicySignature" type:"string"`
}

// String returns the string representation
func (s S3Storage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Storage) GoString() string {
	return s.String()
}

// Describes a security group
type SecurityGroup struct {
	_ struct{} `type:"structure"`

	// A description of the security group.
	Description *string `locationName:"groupDescription" type:"string"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group.
	GroupName *string `locationName:"groupName" type:"string"`

	// One or more inbound rules associated with the security group.
	IpPermissions []*IpPermission `locationName:"ipPermissions" locationNameList:"item" type:"list"`

	// [EC2-VPC] One or more outbound rules associated with the security group.
	IpPermissionsEgress []*IpPermission `locationName:"ipPermissionsEgress" locationNameList:"item" type:"list"`

	// The AWS account ID of the owner of the security group.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// Any tags assigned to the security group.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// [EC2-VPC] The ID of the VPC for the security group.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroup) GoString() string {
	return s.String()
}

// Describes a snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The data encryption key identifier for the snapshot. This value is a unique
	// identifier that corresponds to the data encryption key that was used to encrypt
	// the original volume or snapshot copy. Because data encryption keys are inherited
	// by volumes created from snapshots, and vice versa, if snapshots share the
	// same data encryption key identifier, then they belong to the same volume/snapshot
	// lineage. This parameter is only returned by the DescribeSnapshots API operation.
	DataEncryptionKeyId *string `locationName:"dataEncryptionKeyId" type:"string"`

	// The description for the snapshot.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the snapshot is encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The full ARN of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) that was used to protect the volume encryption key for the parent
	// volume.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The AWS account alias (for example, amazon, self) or AWS account ID that
	// owns the snapshot.
	OwnerAlias *string `locationName:"ownerAlias" type:"string"`

	// The AWS account ID of the EBS snapshot owner.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The progress of the snapshot, as a percentage.
	Progress *string `locationName:"progress" type:"string"`

	// The ID of the snapshot. Each snapshot receives a unique identifier when it
	// is created.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// The time stamp when the snapshot was initiated.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The snapshot state.
	State *string `locationName:"status" type:"string" enum:"SnapshotState"`

	// Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy
	// operation fails (for example, if the proper AWS Key Management Service (AWS
	// KMS) permissions are not obtained) this field displays error state details
	// to help you diagnose why the error occurred. This parameter is only returned
	// by the DescribeSnapshots API operation.
	StateMessage *string `locationName:"statusMessage" type:"string"`

	// Any tags assigned to the snapshot.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the volume that was used to create the snapshot.
	VolumeId *string `locationName:"volumeId" type:"string"`

	// The size of the volume, in GiB.
	VolumeSize *int64 `locationName:"volumeSize" type:"integer"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// Describes the snapshot created from the imported disk.
type SnapshotDetail struct {
	_ struct{} `type:"structure"`

	// A description for the snapshot.
	Description *string `locationName:"description" type:"string"`

	// The block device mapping for the snapshot.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The size of the disk in the snapshot, in GiB.
	DiskImageSize *float64 `locationName:"diskImageSize" type:"double"`

	// The format of the disk image from which the snapshot is created.
	Format *string `locationName:"format" type:"string"`

	// The percentage of progress for the task.
	Progress *string `locationName:"progress" type:"string"`

	// The snapshot ID of the disk being imported.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// A brief status of the snapshot creation.
	Status *string `locationName:"status" type:"string"`

	// A detailed status message for the snapshot creation.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The URL used to access the disk image.
	Url *string `locationName:"url" type:"string"`

	// Describes the S3 bucket for the disk image.
	UserBucket *UserBucketDetails `locationName:"userBucket" type:"structure"`
}

// String returns the string representation
func (s SnapshotDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotDetail) GoString() string {
	return s.String()
}

// The disk container object for the import snapshot request.
type SnapshotDiskContainer struct {
	_ struct{} `type:"structure"`

	// The description of the disk image being imported.
	Description *string `type:"string"`

	// The format of the disk image being imported.
	//
	// Valid values: RAW | VHD | VMDK | OVA
	Format *string `type:"string"`

	// The URL to the Amazon S3-based disk image being imported. It can either be
	// a https URL (https://..) or an Amazon S3 URL (s3://..).
	Url *string `type:"string"`

	// Describes the S3 bucket for the disk image.
	UserBucket *UserBucket `type:"structure"`
}

// String returns the string representation
func (s SnapshotDiskContainer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotDiskContainer) GoString() string {
	return s.String()
}

// Details about the import snapshot task.
type SnapshotTaskDetail struct {
	_ struct{} `type:"structure"`

	// The description of the snapshot.
	Description *string `locationName:"description" type:"string"`

	// The size of the disk in the snapshot, in GiB.
	DiskImageSize *float64 `locationName:"diskImageSize" type:"double"`

	// The format of the disk image from which the snapshot is created.
	Format *string `locationName:"format" type:"string"`

	// The percentage of completion for the import snapshot task.
	Progress *string `locationName:"progress" type:"string"`

	// The snapshot ID of the disk being imported.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// A brief status for the import snapshot task.
	Status *string `locationName:"status" type:"string"`

	// A detailed status message for the import snapshot task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The URL of the disk image from which the snapshot is created.
	Url *string `locationName:"url" type:"string"`

	// The S3 bucket for the disk image.
	UserBucket *UserBucketDetails `locationName:"userBucket" type:"structure"`
}

// String returns the string representation
func (s SnapshotTaskDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotTaskDetail) GoString() string {
	return s.String()
}

// Describes the data feed for a Spot instance.
type SpotDatafeedSubscription struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the Spot instance data feed is located.
	Bucket *string `locationName:"bucket" type:"string"`

	// The fault codes for the Spot instance request, if any.
	Fault *SpotInstanceStateFault `locationName:"fault" type:"structure"`

	// The AWS account ID of the account.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The prefix that is prepended to data feed files.
	Prefix *string `locationName:"prefix" type:"string"`

	// The state of the Spot instance data feed subscription.
	State *string `locationName:"state" type:"string" enum:"DatafeedSubscriptionState"`
}

// String returns the string representation
func (s SpotDatafeedSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotDatafeedSubscription) GoString() string {
	return s.String()
}

// Describes the launch specification for one or more Spot instances.
type SpotFleetLaunchSpecification struct {
	_ struct{} `type:"structure"`

	// Deprecated.
	AddressingType *string `locationName:"addressingType" type:"string"`

	// One or more block device mapping entries.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// Indicates whether the instances are optimized for EBS I/O. This optimization
	// provides dedicated throughput to Amazon EBS and an optimized configuration
	// stack to provide optimal EBS I/O performance. This optimization isn't available
	// with all instance types. Additional usage charges apply when using an EBS
	// Optimized instance.
	//
	// Default: false
	EbsOptimized *bool `locationName:"ebsOptimized" type:"boolean"`

	// The IAM instance profile.
	IamInstanceProfile *IamInstanceProfileSpecification `locationName:"iamInstanceProfile" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// The ID of the kernel.
	KernelId *string `locationName:"kernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// Enable or disable monitoring for the instances.
	Monitoring *SpotFleetMonitoring `locationName:"monitoring" type:"structure"`

	// One or more network interfaces.
	NetworkInterfaces []*InstanceNetworkInterfaceSpecification `locationName:"networkInterfaceSet" locationNameList:"item" type:"list"`

	// The placement information.
	Placement *SpotPlacement `locationName:"placement" type:"structure"`

	// The ID of the RAM disk.
	RamdiskId *string `locationName:"ramdiskId" type:"string"`

	// One or more security groups. When requesting instances in a VPC, you must
	// specify the IDs of the security groups. When requesting instances in EC2-Classic,
	// you can specify the names or the IDs of the security groups.
	SecurityGroups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The bid price per unit hour for the specified instance type. If this value
	// is not specified, the default is the Spot bid price specified for the fleet.
	// To determine the bid price per unit hour, divide the Spot bid price by the
	// value of WeightedCapacity.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The ID of the subnet in which to launch the instances. To specify multiple
	// subnets, separate them using commas; for example, "subnet-a61dafcf, subnet-65ea5f08".
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The Base64-encoded MIME user data to make available to the instances.
	UserData *string `locationName:"userData" type:"string"`

	// The number of units provided by the specified instance type. These are the
	// same units that you chose to set the target capacity in terms (instances
	// or a performance characteristic such as vCPUs, memory, or I/O).
	//
	// If the target capacity divided by this value is not a whole number, we round
	// the number of instances to the next whole number. If this value is not specified,
	// the default is 1.
	WeightedCapacity *float64 `locationName:"weightedCapacity" type:"double"`
}

// String returns the string representation
func (s SpotFleetLaunchSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotFleetLaunchSpecification) GoString() string {
	return s.String()
}

// Describes whether monitoring is enabled.
type SpotFleetMonitoring struct {
	_ struct{} `type:"structure"`

	// Enables monitoring for the instance.
	//
	// Default: false
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation
func (s SpotFleetMonitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotFleetMonitoring) GoString() string {
	return s.String()
}

// Describes a Spot fleet request.
type SpotFleetRequestConfig struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the request.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Information about the configuration of the Spot fleet request.
	SpotFleetRequestConfig *SpotFleetRequestConfigData `locationName:"spotFleetRequestConfig" type:"structure" required:"true"`

	// The ID of the Spot fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`

	// The state of the Spot fleet request.
	SpotFleetRequestState *string `locationName:"spotFleetRequestState" type:"string" required:"true" enum:"BatchState"`
}

// String returns the string representation
func (s SpotFleetRequestConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotFleetRequestConfig) GoString() string {
	return s.String()
}

// Describes the configuration of a Spot fleet request.
type SpotFleetRequestConfigData struct {
	_ struct{} `type:"structure"`

	// Indicates how to allocate the target capacity across the Spot pools specified
	// by the Spot fleet request. The default is lowestPrice.
	AllocationStrategy *string `locationName:"allocationStrategy" type:"string" enum:"AllocationStrategy"`

	// A unique, case-sensitive identifier you provide to ensure idempotency of
	// your listings. This helps avoid duplicate listings. For more information,
	// see Ensuring Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether running Spot instances should be terminated if the target
	// capacity of the Spot fleet request is decreased below the current size of
	// the Spot fleet.
	ExcessCapacityTerminationPolicy *string `locationName:"excessCapacityTerminationPolicy" type:"string" enum:"ExcessCapacityTerminationPolicy"`

	// Grants the Spot fleet permission to terminate Spot instances on your behalf
	// when you cancel its Spot fleet request using CancelSpotFleetRequests or when
	// the Spot fleet request expires, if you set terminateInstancesWithExpiration.
	IamFleetRole *string `locationName:"iamFleetRole" type:"string" required:"true"`

	// Information about the launch specifications for the Spot fleet request.
	LaunchSpecifications []*SpotFleetLaunchSpecification `locationName:"launchSpecifications" locationNameList:"item" min:"1" type:"list" required:"true"`

	// The bid price per unit hour.
	SpotPrice *string `locationName:"spotPrice" type:"string" required:"true"`

	// The number of units to request. You can choose to set the target capacity
	// in terms of instances or a performance characteristic that is important to
	// your application workload, such as vCPUs, memory, or I/O.
	TargetCapacity *int64 `locationName:"targetCapacity" type:"integer" required:"true"`

	// Indicates whether running Spot instances should be terminated when the Spot
	// fleet request expires.
	TerminateInstancesWithExpiration *bool `locationName:"terminateInstancesWithExpiration" type:"boolean"`

	// The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// The default is to start fulfilling the request immediately.
	ValidFrom *time.Time `locationName:"validFrom" type:"timestamp" timestampFormat:"iso8601"`

	// The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// At this point, no new Spot instance requests are placed or enabled to fulfill
	// the request.
	ValidUntil *time.Time `locationName:"validUntil" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotFleetRequestConfigData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotFleetRequestConfigData) GoString() string {
	return s.String()
}

// Describes a Spot instance request.
type SpotInstanceRequest struct {
	_ struct{} `type:"structure"`

	// If you specified a duration and your Spot instance request was fulfilled,
	// this is the fixed hourly price in effect for the Spot instance while it runs.
	ActualBlockHourlyPrice *string `locationName:"actualBlockHourlyPrice" type:"string"`

	// The Availability Zone group. If you specify the same Availability Zone group
	// for all Spot instance requests, all Spot instances are launched in the same
	// Availability Zone.
	AvailabilityZoneGroup *string `locationName:"availabilityZoneGroup" type:"string"`

	// The duration for the Spot instance, in minutes.
	BlockDurationMinutes *int64 `locationName:"blockDurationMinutes" type:"integer"`

	// The date and time when the Spot instance request was created, in UTC format
	// (for example, YYYY-MM-DDTHH:MM:SSZ).
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// The fault codes for the Spot instance request, if any.
	Fault *SpotInstanceStateFault `locationName:"fault" type:"structure"`

	// The instance ID, if an instance has been launched to fulfill the Spot instance
	// request.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance launch group. Launch groups are Spot instances that launch together
	// and terminate together.
	LaunchGroup *string `locationName:"launchGroup" type:"string"`

	// Additional information for launching instances.
	LaunchSpecification *LaunchSpecification `locationName:"launchSpecification" type:"structure"`

	// The Availability Zone in which the bid is launched.
	LaunchedAvailabilityZone *string `locationName:"launchedAvailabilityZone" type:"string"`

	// The product description associated with the Spot instance.
	ProductDescription *string `locationName:"productDescription" type:"string" enum:"RIProductDescription"`

	// The ID of the Spot instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`

	// The maximum hourly price (bid) for the Spot instance launched to fulfill
	// the request.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The state of the Spot instance request. Spot bid status information can help
	// you track your Spot instance requests. For more information, see Spot Bid
	// Status (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	State *string `locationName:"state" type:"string" enum:"SpotInstanceState"`

	// The status code and status message describing the Spot instance request.
	Status *SpotInstanceStatus `locationName:"status" type:"structure"`

	// Any tags assigned to the resource.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The Spot instance request type.
	Type *string `locationName:"type" type:"string" enum:"SpotInstanceType"`

	// The start date of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// The request becomes active at this date and time.
	ValidFrom *time.Time `locationName:"validFrom" type:"timestamp" timestampFormat:"iso8601"`

	// The end date of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// If this is a one-time request, it remains active until all instances launch,
	// the request is canceled, or this date is reached. If the request is persistent,
	// it remains active until it is canceled or this date is reached.
	ValidUntil *time.Time `locationName:"validUntil" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotInstanceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotInstanceRequest) GoString() string {
	return s.String()
}

// Describes a Spot instance state change.
type SpotInstanceStateFault struct {
	_ struct{} `type:"structure"`

	// The reason code for the Spot instance state change.
	Code *string `locationName:"code" type:"string"`

	// The message for the Spot instance state change.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SpotInstanceStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotInstanceStateFault) GoString() string {
	return s.String()
}

// Describes the status of a Spot instance request.
type SpotInstanceStatus struct {
	_ struct{} `type:"structure"`

	// The status code. For a list of status codes, see Spot Bid Status Codes (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand)
	// in the Amazon Elastic Compute Cloud User Guide.
	Code *string `locationName:"code" type:"string"`

	// The description for the status code.
	Message *string `locationName:"message" type:"string"`

	// The date and time of the most recent status update, in UTC format (for example,
	// YYYY-MM-DDTHH:MM:SSZ).
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotInstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotInstanceStatus) GoString() string {
	return s.String()
}

// Describes Spot instance placement.
type SpotPlacement struct {
	_ struct{} `type:"structure"`

	// The Availability Zones. To specify multiple Availability Zones, separate
	// them using commas; for example, "us-west-2a, us-west-2b".
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The name of the placement group (for cluster instances).
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s SpotPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotPlacement) GoString() string {
	return s.String()
}

// Describes the maximum hourly price (bid) for any Spot instance launched to
// fulfill the request.
type SpotPrice struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// A general description of the AMI.
	ProductDescription *string `locationName:"productDescription" type:"string" enum:"RIProductDescription"`

	// The maximum price (bid) that you are willing to pay for a Spot instance.
	SpotPrice *string `locationName:"spotPrice" type:"string"`

	// The date and time the request was created, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SpotPrice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotPrice) GoString() string {
	return s.String()
}

type StartInstancesInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `locationName:"additionalInfo" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more instance IDs.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s StartInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstancesInput) GoString() string {
	return s.String()
}

type StartInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more started instances.
	StartingInstances []*InstanceStateChange `locationName:"instancesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s StartInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstancesOutput) GoString() string {
	return s.String()
}

// Describes a state change.
type StateReason struct {
	_ struct{} `type:"structure"`

	// The reason code for the state change.
	Code *string `locationName:"code" type:"string"`

	// The message for the state change.
	//
	//  Server.SpotInstanceTermination: A Spot instance was terminated due to an
	// increase in the market price.
	//
	// Server.InternalError: An internal error occurred during instance launch,
	// resulting in termination.
	//
	// Server.InsufficientInstanceCapacity: There was insufficient instance capacity
	// to satisfy the launch request.
	//
	// Client.InternalError: A client error caused the instance to terminate on
	// launch.
	//
	// Client.InstanceInitiatedShutdown: The instance was shut down using the shutdown
	// -h command from the instance.
	//
	// Client.UserInitiatedShutdown: The instance was shut down using the Amazon
	// EC2 API.
	//
	// Client.VolumeLimitExceeded: The volume limit was exceeded.
	//
	// Client.InvalidSnapshot.NotFound: The specified snapshot was not found.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s StateReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateReason) GoString() string {
	return s.String()
}

type StopInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Forces the instances to stop. The instances do not have an opportunity to
	// flush file system caches or file system metadata. If you use this option,
	// you must perform file system check and repair procedures. This option is
	// not recommended for Windows instances.
	//
	// Default: false
	Force *bool `locationName:"force" type:"boolean"`

	// One or more instance IDs.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s StopInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstancesInput) GoString() string {
	return s.String()
}

type StopInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more stopped instances.
	StoppingInstances []*InstanceStateChange `locationName:"instancesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s StopInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstancesOutput) GoString() string {
	return s.String()
}

// Describes the storage location for an instance store-backed AMI.
type Storage struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 storage location.
	S3 *S3Storage `type:"structure"`
}

// String returns the string representation
func (s Storage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Storage) GoString() string {
	return s.String()
}

// Describes a subnet.
type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the subnet.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The number of unused IP addresses in the subnet. Note that the IP addresses
	// for any stopped instances are considered unavailable.
	AvailableIpAddressCount *int64 `locationName:"availableIpAddressCount" type:"integer"`

	// The CIDR block assigned to the subnet.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Indicates whether this is the default subnet for the Availability Zone.
	DefaultForAz *bool `locationName:"defaultForAz" type:"boolean"`

	// Indicates whether instances launched in this subnet receive a public IP address.
	MapPublicIpOnLaunch *bool `locationName:"mapPublicIpOnLaunch" type:"boolean"`

	// The current state of the subnet.
	State *string `locationName:"state" type:"string" enum:"SubnetState"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// Any tags assigned to the subnet.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC the subnet is in.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode
	// characters. May not begin with aws:
	Key *string `locationName:"key" type:"string"`

	// The value of the tag.
	//
	// Constraints: Tag values are case-sensitive and accept a maximum of 255 Unicode
	// characters.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Describes a tag.
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `locationName:"key" type:"string"`

	// The ID of the resource. For example, ami-1a2b3c4d.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The tag value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagDescription) GoString() string {
	return s.String()
}

type TerminateInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more instance IDs.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s TerminateInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateInstancesInput) GoString() string {
	return s.String()
}

type TerminateInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more terminated instances.
	TerminatingInstances []*InstanceStateChange `locationName:"instancesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s TerminateInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateInstancesOutput) GoString() string {
	return s.String()
}

type UnassignPrivateIpAddressesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`

	// The secondary private IP addresses to unassign from the network interface.
	// You can specify this option multiple times to unassign more than one IP address.
	PrivateIpAddresses []*string `locationName:"privateIpAddress" locationNameList:"PrivateIpAddress" type:"list" required:"true"`
}

// String returns the string representation
func (s UnassignPrivateIpAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignPrivateIpAddressesInput) GoString() string {
	return s.String()
}

type UnassignPrivateIpAddressesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnassignPrivateIpAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignPrivateIpAddressesOutput) GoString() string {
	return s.String()
}

type UnmonitorInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more instance IDs.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s UnmonitorInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnmonitorInstancesInput) GoString() string {
	return s.String()
}

type UnmonitorInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Monitoring information for one or more instances.
	InstanceMonitorings []*InstanceMonitoring `locationName:"instancesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s UnmonitorInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnmonitorInstancesOutput) GoString() string {
	return s.String()
}

// Information about items that were not successfully processed in a batch call.
type UnsuccessfulItem struct {
	_ struct{} `type:"structure"`

	// Information about the error.
	Error *UnsuccessfulItemError `locationName:"error" type:"structure" required:"true"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`
}

// String returns the string representation
func (s UnsuccessfulItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsuccessfulItem) GoString() string {
	return s.String()
}

// Information about the error that occurred. For more information about errors,
// see Error Codes (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html).
type UnsuccessfulItemError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string" required:"true"`

	// The error message accompanying the error code.
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation
func (s UnsuccessfulItemError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsuccessfulItemError) GoString() string {
	return s.String()
}

// Describes the S3 bucket for the disk image.
type UserBucket struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the disk image is located.
	S3Bucket *string `type:"string"`

	// The key for the disk image.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s UserBucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserBucket) GoString() string {
	return s.String()
}

// Describes the S3 bucket for the disk image.
type UserBucketDetails struct {
	_ struct{} `type:"structure"`

	// The S3 bucket from which the disk image was created.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The key from which the disk image was created.
	S3Key *string `locationName:"s3Key" type:"string"`
}

// String returns the string representation
func (s UserBucketDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserBucketDetails) GoString() string {
	return s.String()
}

// Describes the user data to be made available to an instance.
type UserData struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded MIME user data for the instance.
	Data *string `locationName:"data" type:"string"`
}

// String returns the string representation
func (s UserData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserData) GoString() string {
	return s.String()
}

// Describes a security group and AWS account ID pair.
type UserIdGroupPair struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group. In a request, use this parameter for a security
	// group in EC2-Classic or a default VPC only. For a security group in a nondefault
	// VPC, use GroupId.
	GroupName *string `locationName:"groupName" type:"string"`

	// The ID of an AWS account. EC2-Classic only.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s UserIdGroupPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserIdGroupPair) GoString() string {
	return s.String()
}

// Describes telemetry for a VPN tunnel.
type VgwTelemetry struct {
	_ struct{} `type:"structure"`

	// The number of accepted routes.
	AcceptedRouteCount *int64 `locationName:"acceptedRouteCount" type:"integer"`

	// The date and time of the last change in status.
	LastStatusChange *time.Time `locationName:"lastStatusChange" type:"timestamp" timestampFormat:"iso8601"`

	// The Internet-routable IP address of the virtual private gateway's outside
	// interface.
	OutsideIpAddress *string `locationName:"outsideIpAddress" type:"string"`

	// The status of the VPN tunnel.
	Status *string `locationName:"status" type:"string" enum:"TelemetryStatus"`

	// If an error occurs, a description of the error.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s VgwTelemetry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VgwTelemetry) GoString() string {
	return s.String()
}

// Describes a volume.
type Volume struct {
	_ struct{} `type:"structure"`

	// Information about the volume attachments.
	Attachments []*VolumeAttachment `locationName:"attachmentSet" locationNameList:"item" type:"list"`

	// The Availability Zone for the volume.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The time stamp when volume creation was initiated.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the volume will be encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For Provisioned IOPS (SSD) volumes, this represents the number of IOPS that
	// are provisioned for the volume. For General Purpose (SSD) volumes, this represents
	// the baseline performance of the volume and the rate at which the volume accumulates
	// I/O credits for bursting. For more information on General Purpose (SSD) baseline
	// performance, I/O credits, and bursting, see Amazon EBS Volume Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Constraint: Range is 100 to 20000 for Provisioned IOPS (SSD) volumes and
	// 3 to 10000 for General Purpose (SSD) volumes.
	//
	// Condition: This parameter is required for requests to create io1 volumes;
	// it is not used in requests to create standard or gp2 volumes.
	Iops *int64 `locationName:"iops" type:"integer"`

	// The full ARN of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) that was used to protect the volume encryption key for the volume.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The size of the volume, in GiBs.
	Size *int64 `locationName:"size" type:"integer"`

	// The snapshot from which the volume was created, if applicable.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// The volume state.
	State *string `locationName:"status" type:"string" enum:"VolumeState"`

	// Any tags assigned to the volume.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the volume.
	VolumeId *string `locationName:"volumeId" type:"string"`

	// The volume type. This can be gp2 for General Purpose (SSD) volumes, io1 for
	// Provisioned IOPS (SSD) volumes, or standard for Magnetic volumes.
	VolumeType *string `locationName:"volumeType" type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Volume) GoString() string {
	return s.String()
}

// Describes volume attachment details.
type VolumeAttachment struct {
	_ struct{} `type:"structure"`

	// The time stamp when the attachment initiated.
	AttachTime *time.Time `locationName:"attachTime" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// The device name.
	Device *string `locationName:"device" type:"string"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The attachment state of the volume.
	State *string `locationName:"status" type:"string" enum:"VolumeAttachmentState"`

	// The ID of the volume.
	VolumeId *string `locationName:"volumeId" type:"string"`
}

// String returns the string representation
func (s VolumeAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeAttachment) GoString() string {
	return s.String()
}

// Describes an EBS volume.
type VolumeDetail struct {
	_ struct{} `type:"structure"`

	// The size of the volume, in GiB.
	Size *int64 `locationName:"size" type:"long" required:"true"`
}

// String returns the string representation
func (s VolumeDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeDetail) GoString() string {
	return s.String()
}

// Describes a volume status operation code.
type VolumeStatusAction struct {
	_ struct{} `type:"structure"`

	// The code identifying the operation, for example, enable-volume-io.
	Code *string `locationName:"code" type:"string"`

	// A description of the operation.
	Description *string `locationName:"description" type:"string"`

	// The ID of the event associated with this operation.
	EventId *string `locationName:"eventId" type:"string"`

	// The event type associated with this operation.
	EventType *string `locationName:"eventType" type:"string"`
}

// String returns the string representation
func (s VolumeStatusAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeStatusAction) GoString() string {
	return s.String()
}

// Describes a volume status.
type VolumeStatusDetails struct {
	_ struct{} `type:"structure"`

	// The name of the volume status.
	Name *string `locationName:"name" type:"string" enum:"VolumeStatusName"`

	// The intended status of the volume status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s VolumeStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeStatusDetails) GoString() string {
	return s.String()
}

// Describes a volume status event.
type VolumeStatusEvent struct {
	_ struct{} `type:"structure"`

	// A description of the event.
	Description *string `locationName:"description" type:"string"`

	// The ID of this event.
	EventId *string `locationName:"eventId" type:"string"`

	// The type of this event.
	EventType *string `locationName:"eventType" type:"string"`

	// The latest end time of the event.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The earliest start time of the event.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s VolumeStatusEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeStatusEvent) GoString() string {
	return s.String()
}

// Describes the status of a volume.
type VolumeStatusInfo struct {
	_ struct{} `type:"structure"`

	// The details of the volume status.
	Details []*VolumeStatusDetails `locationName:"details" locationNameList:"item" type:"list"`

	// The status of the volume.
	Status *string `locationName:"status" type:"string" enum:"VolumeStatusInfoStatus"`
}

// String returns the string representation
func (s VolumeStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeStatusInfo) GoString() string {
	return s.String()
}

// Describes the volume status.
type VolumeStatusItem struct {
	_ struct{} `type:"structure"`

	// The details of the operation.
	Actions []*VolumeStatusAction `locationName:"actionsSet" locationNameList:"item" type:"list"`

	// The Availability Zone of the volume.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// A list of events associated with the volume.
	Events []*VolumeStatusEvent `locationName:"eventsSet" locationNameList:"item" type:"list"`

	// The volume ID.
	VolumeId *string `locationName:"volumeId" type:"string"`

	// The volume status.
	VolumeStatus *VolumeStatusInfo `locationName:"volumeStatus" type:"structure"`
}

// String returns the string representation
func (s VolumeStatusItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeStatusItem) GoString() string {
	return s.String()
}

// Describes a VPC.
type Vpc struct {
	_ struct{} `type:"structure"`

	// The CIDR block for the VPC.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// The ID of the set of DHCP options you've associated with the VPC (or default
	// if the default options are associated with the VPC).
	DhcpOptionsId *string `locationName:"dhcpOptionsId" type:"string"`

	// The allowed tenancy of instances launched into the VPC.
	InstanceTenancy *string `locationName:"instanceTenancy" type:"string" enum:"Tenancy"`

	// Indicates whether the VPC is the default VPC.
	IsDefault *bool `locationName:"isDefault" type:"boolean"`

	// The current state of the VPC.
	State *string `locationName:"state" type:"string" enum:"VpcState"`

	// Any tags assigned to the VPC.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s Vpc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Vpc) GoString() string {
	return s.String()
}

// Describes an attachment between a virtual private gateway and a VPC.
type VpcAttachment struct {
	_ struct{} `type:"structure"`

	// The current state of the attachment.
	State *string `locationName:"state" type:"string" enum:"AttachmentStatus"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcAttachment) GoString() string {
	return s.String()
}

// Describes whether a VPC is enabled for ClassicLink.
type VpcClassicLink struct {
	_ struct{} `type:"structure"`

	// Indicates whether the VPC is enabled for ClassicLink.
	ClassicLinkEnabled *bool `locationName:"classicLinkEnabled" type:"boolean"`

	// Any tags assigned to the VPC.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcClassicLink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcClassicLink) GoString() string {
	return s.String()
}

// Describes a VPC endpoint.
type VpcEndpoint struct {
	_ struct{} `type:"structure"`

	// The date and time the VPC endpoint was created.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp" timestampFormat:"iso8601"`

	// The policy document associated with the endpoint.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// One or more route tables associated with the endpoint.
	RouteTableIds []*string `locationName:"routeTableIdSet" locationNameList:"item" type:"list"`

	// The name of the AWS service to which the endpoint is associated.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The state of the VPC endpoint.
	State *string `locationName:"state" type:"string" enum:"State"`

	// The ID of the VPC endpoint.
	VpcEndpointId *string `locationName:"vpcEndpointId" type:"string"`

	// The ID of the VPC to which the endpoint is associated.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcEndpoint) GoString() string {
	return s.String()
}

// Describes a VPC peering connection.
type VpcPeeringConnection struct {
	_ struct{} `type:"structure"`

	// The information of the peer VPC.
	AccepterVpcInfo *VpcPeeringConnectionVpcInfo `locationName:"accepterVpcInfo" type:"structure"`

	// The time that an unaccepted VPC peering connection will expire.
	ExpirationTime *time.Time `locationName:"expirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The information of the requester VPC.
	RequesterVpcInfo *VpcPeeringConnectionVpcInfo `locationName:"requesterVpcInfo" type:"structure"`

	// The status of the VPC peering connection.
	Status *VpcPeeringConnectionStateReason `locationName:"status" type:"structure"`

	// Any tags assigned to the resource.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcPeeringConnection) GoString() string {
	return s.String()
}

// Describes the status of a VPC peering connection.
type VpcPeeringConnectionStateReason struct {
	_ struct{} `type:"structure"`

	// The status of the VPC peering connection.
	Code *string `locationName:"code" type:"string" enum:"VpcPeeringConnectionStateReasonCode"`

	// A message that provides more information about the status, if applicable.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnectionStateReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcPeeringConnectionStateReason) GoString() string {
	return s.String()
}

// Describes a VPC in a VPC peering connection.
type VpcPeeringConnectionVpcInfo struct {
	_ struct{} `type:"structure"`

	// The CIDR block for the VPC.
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// The AWS account ID of the VPC owner.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnectionVpcInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcPeeringConnectionVpcInfo) GoString() string {
	return s.String()
}

// Describes a VPN connection.
type VpnConnection struct {
	_ struct{} `type:"structure"`

	// The configuration information for the VPN connection's customer gateway (in
	// the native XML format). This element is always present in the CreateVpnConnection
	// response; however, it's present in the DescribeVpnConnections response only
	// if the VPN connection is in the pending or available state.
	CustomerGatewayConfiguration *string `locationName:"customerGatewayConfiguration" type:"string"`

	// The ID of the customer gateway at your end of the VPN connection.
	CustomerGatewayId *string `locationName:"customerGatewayId" type:"string"`

	// The VPN connection options.
	Options *VpnConnectionOptions `locationName:"options" type:"structure"`

	// The static routes associated with the VPN connection.
	Routes []*VpnStaticRoute `locationName:"routes" locationNameList:"item" type:"list"`

	// The current state of the VPN connection.
	State *string `locationName:"state" type:"string" enum:"VpnState"`

	// Any tags assigned to the VPN connection.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of VPN connection.
	Type *string `locationName:"type" type:"string" enum:"GatewayType"`

	// Information about the VPN tunnel.
	VgwTelemetry []*VgwTelemetry `locationName:"vgwTelemetry" locationNameList:"item" type:"list"`

	// The ID of the VPN connection.
	VpnConnectionId *string `locationName:"vpnConnectionId" type:"string"`

	// The ID of the virtual private gateway at the AWS side of the VPN connection.
	VpnGatewayId *string `locationName:"vpnGatewayId" type:"string"`
}

// String returns the string representation
func (s VpnConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpnConnection) GoString() string {
	return s.String()
}

// Describes VPN connection options.
type VpnConnectionOptions struct {
	_ struct{} `type:"structure"`

	// Indicates whether the VPN connection uses static routes only. Static routes
	// must be used for devices that don't support BGP.
	StaticRoutesOnly *bool `locationName:"staticRoutesOnly" type:"boolean"`
}

// String returns the string representation
func (s VpnConnectionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpnConnectionOptions) GoString() string {
	return s.String()
}

// Describes VPN connection options.
type VpnConnectionOptionsSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether the VPN connection uses static routes only. Static routes
	// must be used for devices that don't support BGP.
	StaticRoutesOnly *bool `locationName:"staticRoutesOnly" type:"boolean"`
}

// String returns the string representation
func (s VpnConnectionOptionsSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpnConnectionOptionsSpecification) GoString() string {
	return s.String()
}

// Describes a virtual private gateway.
type VpnGateway struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the virtual private gateway was created.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The current state of the virtual private gateway.
	State *string `locationName:"state" type:"string" enum:"VpnState"`

	// Any tags assigned to the virtual private gateway.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of VPN connection the virtual private gateway supports.
	Type *string `locationName:"type" type:"string" enum:"GatewayType"`

	// Any VPCs attached to the virtual private gateway.
	VpcAttachments []*VpcAttachment `locationName:"attachments" locationNameList:"item" type:"list"`

	// The ID of the virtual private gateway.
	VpnGatewayId *string `locationName:"vpnGatewayId" type:"string"`
}

// String returns the string representation
func (s VpnGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpnGateway) GoString() string {
	return s.String()
}

// Describes a static route for a VPN connection.
type VpnStaticRoute struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer data center.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// Indicates how the routes were provided.
	Source *string `locationName:"source" type:"string" enum:"VpnStaticRouteSource"`

	// The current state of the static route.
	State *string `locationName:"state" type:"string" enum:"VpnState"`
}

// String returns the string representation
func (s VpnStaticRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpnStaticRoute) GoString() string {
	return s.String()
}

const (
	// @enum AccountAttributeName
	AccountAttributeNameSupportedPlatforms = "supported-platforms"
	// @enum AccountAttributeName
	AccountAttributeNameDefaultVpc = "default-vpc"
)

const (
	// @enum Affinity
	AffinityDefault = "default"
	// @enum Affinity
	AffinityHost = "host"
)

const (
	// @enum AllocationState
	AllocationStateAvailable = "available"
	// @enum AllocationState
	AllocationStateUnderAssessment = "under-assessment"
	// @enum AllocationState
	AllocationStatePermanentFailure = "permanent-failure"
	// @enum AllocationState
	AllocationStateReleased = "released"
	// @enum AllocationState
	AllocationStateReleasedPermanentFailure = "released-permanent-failure"
)

const (
	// @enum AllocationStrategy
	AllocationStrategyLowestPrice = "lowestPrice"
	// @enum AllocationStrategy
	AllocationStrategyDiversified = "diversified"
)

const (
	// @enum ArchitectureValues
	ArchitectureValuesI386 = "i386"
	// @enum ArchitectureValues
	ArchitectureValuesX8664 = "x86_64"
)

const (
	// @enum AttachmentStatus
	AttachmentStatusAttaching = "attaching"
	// @enum AttachmentStatus
	AttachmentStatusAttached = "attached"
	// @enum AttachmentStatus
	AttachmentStatusDetaching = "detaching"
	// @enum AttachmentStatus
	AttachmentStatusDetached = "detached"
)

const (
	// @enum AutoPlacement
	AutoPlacementOn = "on"
	// @enum AutoPlacement
	AutoPlacementOff = "off"
)

const (
	// @enum AvailabilityZoneState
	AvailabilityZoneStateAvailable = "available"
	// @enum AvailabilityZoneState
	AvailabilityZoneStateInformation = "information"
	// @enum AvailabilityZoneState
	AvailabilityZoneStateImpaired = "impaired"
	// @enum AvailabilityZoneState
	AvailabilityZoneStateUnavailable = "unavailable"
)

const (
	// @enum BatchState
	BatchStateSubmitted = "submitted"
	// @enum BatchState
	BatchStateActive = "active"
	// @enum BatchState
	BatchStateCancelled = "cancelled"
	// @enum BatchState
	BatchStateFailed = "failed"
	// @enum BatchState
	BatchStateCancelledRunning = "cancelled_running"
	// @enum BatchState
	BatchStateCancelledTerminating = "cancelled_terminating"
	// @enum BatchState
	BatchStateModifying = "modifying"
)

const (
	// @enum BundleTaskState
	BundleTaskStatePending = "pending"
	// @enum BundleTaskState
	BundleTaskStateWaitingForShutdown = "waiting-for-shutdown"
	// @enum BundleTaskState
	BundleTaskStateBundling = "bundling"
	// @enum BundleTaskState
	BundleTaskStateStoring = "storing"
	// @enum BundleTaskState
	BundleTaskStateCancelling = "cancelling"
	// @enum BundleTaskState
	BundleTaskStateComplete = "complete"
	// @enum BundleTaskState
	BundleTaskStateFailed = "failed"
)

const (
	// @enum CancelBatchErrorCode
	CancelBatchErrorCodeFleetRequestIdDoesNotExist = "fleetRequestIdDoesNotExist"
	// @enum CancelBatchErrorCode
	CancelBatchErrorCodeFleetRequestIdMalformed = "fleetRequestIdMalformed"
	// @enum CancelBatchErrorCode
	CancelBatchErrorCodeFleetRequestNotInCancellableState = "fleetRequestNotInCancellableState"
	// @enum CancelBatchErrorCode
	CancelBatchErrorCodeUnexpectedError = "unexpectedError"
)

const (
	// @enum CancelSpotInstanceRequestState
	CancelSpotInstanceRequestStateActive = "active"
	// @enum CancelSpotInstanceRequestState
	CancelSpotInstanceRequestStateOpen = "open"
	// @enum CancelSpotInstanceRequestState
	CancelSpotInstanceRequestStateClosed = "closed"
	// @enum CancelSpotInstanceRequestState
	CancelSpotInstanceRequestStateCancelled = "cancelled"
	// @enum CancelSpotInstanceRequestState
	CancelSpotInstanceRequestStateCompleted = "completed"
)

const (
	// @enum ContainerFormat
	ContainerFormatOva = "ova"
)

const (
	// @enum ConversionTaskState
	ConversionTaskStateActive = "active"
	// @enum ConversionTaskState
	ConversionTaskStateCancelling = "cancelling"
	// @enum ConversionTaskState
	ConversionTaskStateCancelled = "cancelled"
	// @enum ConversionTaskState
	ConversionTaskStateCompleted = "completed"
)

const (
	// @enum CurrencyCodeValues
	CurrencyCodeValuesUsd = "USD"
)

const (
	// @enum DatafeedSubscriptionState
	DatafeedSubscriptionStateActive = "Active"
	// @enum DatafeedSubscriptionState
	DatafeedSubscriptionStateInactive = "Inactive"
)

const (
	// @enum DeviceType
	DeviceTypeEbs = "ebs"
	// @enum DeviceType
	DeviceTypeInstanceStore = "instance-store"
)

const (
	// @enum DiskImageFormat
	DiskImageFormatVmdk = "VMDK"
	// @enum DiskImageFormat
	DiskImageFormatRaw = "RAW"
	// @enum DiskImageFormat
	DiskImageFormatVhd = "VHD"
)

const (
	// @enum DomainType
	DomainTypeVpc = "vpc"
	// @enum DomainType
	DomainTypeStandard = "standard"
)

const (
	// @enum EventCode
	EventCodeInstanceReboot = "instance-reboot"
	// @enum EventCode
	EventCodeSystemReboot = "system-reboot"
	// @enum EventCode
	EventCodeSystemMaintenance = "system-maintenance"
	// @enum EventCode
	EventCodeInstanceRetirement = "instance-retirement"
	// @enum EventCode
	EventCodeInstanceStop = "instance-stop"
)

const (
	// @enum EventType
	EventTypeInstanceChange = "instanceChange"
	// @enum EventType
	EventTypeFleetRequestChange = "fleetRequestChange"
	// @enum EventType
	EventTypeError = "error"
)

const (
	// @enum ExcessCapacityTerminationPolicy
	ExcessCapacityTerminationPolicyNoTermination = "noTermination"
	// @enum ExcessCapacityTerminationPolicy
	ExcessCapacityTerminationPolicyDefault = "default"
)

const (
	// @enum ExportEnvironment
	ExportEnvironmentCitrix = "citrix"
	// @enum ExportEnvironment
	ExportEnvironmentVmware = "vmware"
	// @enum ExportEnvironment
	ExportEnvironmentMicrosoft = "microsoft"
)

const (
	// @enum ExportTaskState
	ExportTaskStateActive = "active"
	// @enum ExportTaskState
	ExportTaskStateCancelling = "cancelling"
	// @enum ExportTaskState
	ExportTaskStateCancelled = "cancelled"
	// @enum ExportTaskState
	ExportTaskStateCompleted = "completed"
)

const (
	// @enum FlowLogsResourceType
	FlowLogsResourceTypeVpc = "VPC"
	// @enum FlowLogsResourceType
	FlowLogsResourceTypeSubnet = "Subnet"
	// @enum FlowLogsResourceType
	FlowLogsResourceTypeNetworkInterface = "NetworkInterface"
)

const (
	// @enum GatewayType
	GatewayTypeIpsec1 = "ipsec.1"
)

const (
	// @enum HostTenancy
	HostTenancyDedicated = "dedicated"
	// @enum HostTenancy
	HostTenancyHost = "host"
)

const (
	// @enum HypervisorType
	HypervisorTypeOvm = "ovm"
	// @enum HypervisorType
	HypervisorTypeXen = "xen"
)

const (
	// @enum ImageAttributeName
	ImageAttributeNameDescription = "description"
	// @enum ImageAttributeName
	ImageAttributeNameKernel = "kernel"
	// @enum ImageAttributeName
	ImageAttributeNameRamdisk = "ramdisk"
	// @enum ImageAttributeName
	ImageAttributeNameLaunchPermission = "launchPermission"
	// @enum ImageAttributeName
	ImageAttributeNameProductCodes = "productCodes"
	// @enum ImageAttributeName
	ImageAttributeNameBlockDeviceMapping = "blockDeviceMapping"
	// @enum ImageAttributeName
	ImageAttributeNameSriovNetSupport = "sriovNetSupport"
)

const (
	// @enum ImageState
	ImageStatePending = "pending"
	// @enum ImageState
	ImageStateAvailable = "available"
	// @enum ImageState
	ImageStateInvalid = "invalid"
	// @enum ImageState
	ImageStateDeregistered = "deregistered"
	// @enum ImageState
	ImageStateTransient = "transient"
	// @enum ImageState
	ImageStateFailed = "failed"
	// @enum ImageState
	ImageStateError = "error"
)

const (
	// @enum ImageTypeValues
	ImageTypeValuesMachine = "machine"
	// @enum ImageTypeValues
	ImageTypeValuesKernel = "kernel"
	// @enum ImageTypeValues
	ImageTypeValuesRamdisk = "ramdisk"
)

const (
	// @enum InstanceAttributeName
	InstanceAttributeNameInstanceType = "instanceType"
	// @enum InstanceAttributeName
	InstanceAttributeNameKernel = "kernel"
	// @enum InstanceAttributeName
	InstanceAttributeNameRamdisk = "ramdisk"
	// @enum InstanceAttributeName
	InstanceAttributeNameUserData = "userData"
	// @enum InstanceAttributeName
	InstanceAttributeNameDisableApiTermination = "disableApiTermination"
	// @enum InstanceAttributeName
	InstanceAttributeNameInstanceInitiatedShutdownBehavior = "instanceInitiatedShutdownBehavior"
	// @enum InstanceAttributeName
	InstanceAttributeNameRootDeviceName = "rootDeviceName"
	// @enum InstanceAttributeName
	InstanceAttributeNameBlockDeviceMapping = "blockDeviceMapping"
	// @enum InstanceAttributeName
	InstanceAttributeNameProductCodes = "productCodes"
	// @enum InstanceAttributeName
	InstanceAttributeNameSourceDestCheck = "sourceDestCheck"
	// @enum InstanceAttributeName
	InstanceAttributeNameGroupSet = "groupSet"
	// @enum InstanceAttributeName
	InstanceAttributeNameEbsOptimized = "ebsOptimized"
	// @enum InstanceAttributeName
	InstanceAttributeNameSriovNetSupport = "sriovNetSupport"
)

const (
	// @enum InstanceLifecycleType
	InstanceLifecycleTypeSpot = "spot"
)

const (
	// @enum InstanceStateName
	InstanceStateNamePending = "pending"
	// @enum InstanceStateName
	InstanceStateNameRunning = "running"
	// @enum InstanceStateName
	InstanceStateNameShuttingDown = "shutting-down"
	// @enum InstanceStateName
	InstanceStateNameTerminated = "terminated"
	// @enum InstanceStateName
	InstanceStateNameStopping = "stopping"
	// @enum InstanceStateName
	InstanceStateNameStopped = "stopped"
)

const (
	// @enum InstanceType
	InstanceTypeT1Micro = "t1.micro"
	// @enum InstanceType
	InstanceTypeM1Small = "m1.small"
	// @enum InstanceType
	InstanceTypeM1Medium = "m1.medium"
	// @enum InstanceType
	InstanceTypeM1Large = "m1.large"
	// @enum InstanceType
	InstanceTypeM1Xlarge = "m1.xlarge"
	// @enum InstanceType
	InstanceTypeM3Medium = "m3.medium"
	// @enum InstanceType
	InstanceTypeM3Large = "m3.large"
	// @enum InstanceType
	InstanceTypeM3Xlarge = "m3.xlarge"
	// @enum InstanceType
	InstanceTypeM32xlarge = "m3.2xlarge"
	// @enum InstanceType
	InstanceTypeM4Large = "m4.large"
	// @enum InstanceType
	InstanceTypeM4Xlarge = "m4.xlarge"
	// @enum InstanceType
	InstanceTypeM42xlarge = "m4.2xlarge"
	// @enum InstanceType
	InstanceTypeM44xlarge = "m4.4xlarge"
	// @enum InstanceType
	InstanceTypeM410xlarge = "m4.10xlarge"
	// @enum InstanceType
	InstanceTypeT2Micro = "t2.micro"
	// @enum InstanceType
	InstanceTypeT2Small = "t2.small"
	// @enum InstanceType
	InstanceTypeT2Medium = "t2.medium"
	// @enum InstanceType
	InstanceTypeT2Large = "t2.large"
	// @enum InstanceType
	InstanceTypeM2Xlarge = "m2.xlarge"
	// @enum InstanceType
	InstanceTypeM22xlarge = "m2.2xlarge"
	// @enum InstanceType
	InstanceTypeM24xlarge = "m2.4xlarge"
	// @enum InstanceType
	InstanceTypeCr18xlarge = "cr1.8xlarge"
	// @enum InstanceType
	InstanceTypeI2Xlarge = "i2.xlarge"
	// @enum InstanceType
	InstanceTypeI22xlarge = "i2.2xlarge"
	// @enum InstanceType
	InstanceTypeI24xlarge = "i2.4xlarge"
	// @enum InstanceType
	InstanceTypeI28xlarge = "i2.8xlarge"
	// @enum InstanceType
	InstanceTypeHi14xlarge = "hi1.4xlarge"
	// @enum InstanceType
	InstanceTypeHs18xlarge = "hs1.8xlarge"
	// @enum InstanceType
	InstanceTypeC1Medium = "c1.medium"
	// @enum InstanceType
	InstanceTypeC1Xlarge = "c1.xlarge"
	// @enum InstanceType
	InstanceTypeC3Large = "c3.large"
	// @enum InstanceType
	InstanceTypeC3Xlarge = "c3.xlarge"
	// @enum InstanceType
	InstanceTypeC32xlarge = "c3.2xlarge"
	// @enum InstanceType
	InstanceTypeC34xlarge = "c3.4xlarge"
	// @enum InstanceType
	InstanceTypeC38xlarge = "c3.8xlarge"
	// @enum InstanceType
	InstanceTypeC4Large = "c4.large"
	// @enum InstanceType
	InstanceTypeC4Xlarge = "c4.xlarge"
	// @enum InstanceType
	InstanceTypeC42xlarge = "c4.2xlarge"
	// @enum InstanceType
	InstanceTypeC44xlarge = "c4.4xlarge"
	// @enum InstanceType
	InstanceTypeC48xlarge = "c4.8xlarge"
	// @enum InstanceType
	InstanceTypeCc14xlarge = "cc1.4xlarge"
	// @enum InstanceType
	InstanceTypeCc28xlarge = "cc2.8xlarge"
	// @enum InstanceType
	InstanceTypeG22xlarge = "g2.2xlarge"
	// @enum InstanceType
	InstanceTypeCg14xlarge = "cg1.4xlarge"
	// @enum InstanceType
	InstanceTypeR3Large = "r3.large"
	// @enum InstanceType
	InstanceTypeR3Xlarge = "r3.xlarge"
	// @enum InstanceType
	InstanceTypeR32xlarge = "r3.2xlarge"
	// @enum InstanceType
	InstanceTypeR34xlarge = "r3.4xlarge"
	// @enum InstanceType
	InstanceTypeR38xlarge = "r3.8xlarge"
	// @enum InstanceType
	InstanceTypeD2Xlarge = "d2.xlarge"
	// @enum InstanceType
	InstanceTypeD22xlarge = "d2.2xlarge"
	// @enum InstanceType
	InstanceTypeD24xlarge = "d2.4xlarge"
	// @enum InstanceType
	InstanceTypeD28xlarge = "d2.8xlarge"
)

const (
	// @enum ListingState
	ListingStateAvailable = "available"
	// @enum ListingState
	ListingStateSold = "sold"
	// @enum ListingState
	ListingStateCancelled = "cancelled"
	// @enum ListingState
	ListingStatePending = "pending"
)

const (
	// @enum ListingStatus
	ListingStatusActive = "active"
	// @enum ListingStatus
	ListingStatusPending = "pending"
	// @enum ListingStatus
	ListingStatusCancelled = "cancelled"
	// @enum ListingStatus
	ListingStatusClosed = "closed"
)

const (
	// @enum MonitoringState
	MonitoringStateDisabled = "disabled"
	// @enum MonitoringState
	MonitoringStateDisabling = "disabling"
	// @enum MonitoringState
	MonitoringStateEnabled = "enabled"
	// @enum MonitoringState
	MonitoringStatePending = "pending"
)

const (
	// @enum MoveStatus
	MoveStatusMovingToVpc = "movingToVpc"
	// @enum MoveStatus
	MoveStatusRestoringToClassic = "restoringToClassic"
)

const (
	// @enum NatGatewayState
	NatGatewayStatePending = "pending"
	// @enum NatGatewayState
	NatGatewayStateFailed = "failed"
	// @enum NatGatewayState
	NatGatewayStateAvailable = "available"
	// @enum NatGatewayState
	NatGatewayStateDeleting = "deleting"
	// @enum NatGatewayState
	NatGatewayStateDeleted = "deleted"
)

const (
	// @enum NetworkInterfaceAttribute
	NetworkInterfaceAttributeDescription = "description"
	// @enum NetworkInterfaceAttribute
	NetworkInterfaceAttributeGroupSet = "groupSet"
	// @enum NetworkInterfaceAttribute
	NetworkInterfaceAttributeSourceDestCheck = "sourceDestCheck"
	// @enum NetworkInterfaceAttribute
	NetworkInterfaceAttributeAttachment = "attachment"
)

const (
	// @enum NetworkInterfaceStatus
	NetworkInterfaceStatusAvailable = "available"
	// @enum NetworkInterfaceStatus
	NetworkInterfaceStatusAttaching = "attaching"
	// @enum NetworkInterfaceStatus
	NetworkInterfaceStatusInUse = "in-use"
	// @enum NetworkInterfaceStatus
	NetworkInterfaceStatusDetaching = "detaching"
)

const (
	// @enum NetworkInterfaceType
	NetworkInterfaceTypeInterface = "interface"
	// @enum NetworkInterfaceType
	NetworkInterfaceTypeNatGateway = "natGateway"
)

const (
	// @enum OfferingTypeValues
	OfferingTypeValuesHeavyUtilization = "Heavy Utilization"
	// @enum OfferingTypeValues
	OfferingTypeValuesMediumUtilization = "Medium Utilization"
	// @enum OfferingTypeValues
	OfferingTypeValuesLightUtilization = "Light Utilization"
	// @enum OfferingTypeValues
	OfferingTypeValuesNoUpfront = "No Upfront"
	// @enum OfferingTypeValues
	OfferingTypeValuesPartialUpfront = "Partial Upfront"
	// @enum OfferingTypeValues
	OfferingTypeValuesAllUpfront = "All Upfront"
)

const (
	// @enum OperationType
	OperationTypeAdd = "add"
	// @enum OperationType
	OperationTypeRemove = "remove"
)

const (
	// @enum PermissionGroup
	PermissionGroupAll = "all"
)

const (
	// @enum PlacementGroupState
	PlacementGroupStatePending = "pending"
	// @enum PlacementGroupState
	PlacementGroupStateAvailable = "available"
	// @enum PlacementGroupState
	PlacementGroupStateDeleting = "deleting"
	// @enum PlacementGroupState
	PlacementGroupStateDeleted = "deleted"
)

const (
	// @enum PlacementStrategy
	PlacementStrategyCluster = "cluster"
)

const (
	// @enum PlatformValues
	PlatformValuesWindows = "Windows"
)

const (
	// @enum ProductCodeValues
	ProductCodeValuesDevpay = "devpay"
	// @enum ProductCodeValues
	ProductCodeValuesMarketplace = "marketplace"
)

const (
	// @enum RIProductDescription
	RIProductDescriptionLinuxUnix = "Linux/UNIX"
	// @enum RIProductDescription
	RIProductDescriptionLinuxUnixamazonVpc = "Linux/UNIX (Amazon VPC)"
	// @enum RIProductDescription
	RIProductDescriptionWindows = "Windows"
	// @enum RIProductDescription
	RIProductDescriptionWindowsAmazonVpc = "Windows (Amazon VPC)"
)

const (
	// @enum RecurringChargeFrequency
	RecurringChargeFrequencyHourly = "Hourly"
)

const (
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesInstanceStuckInState = "instance-stuck-in-state"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesUnresponsive = "unresponsive"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesNotAcceptingCredentials = "not-accepting-credentials"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesPasswordNotAvailable = "password-not-available"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesPerformanceNetwork = "performance-network"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesPerformanceInstanceStore = "performance-instance-store"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesPerformanceEbsVolume = "performance-ebs-volume"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesPerformanceOther = "performance-other"
	// @enum ReportInstanceReasonCodes
	ReportInstanceReasonCodesOther = "other"
)

const (
	// @enum ReportStatusType
	ReportStatusTypeOk = "ok"
	// @enum ReportStatusType
	ReportStatusTypeImpaired = "impaired"
)

const (
	// @enum ReservedInstanceState
	ReservedInstanceStatePaymentPending = "payment-pending"
	// @enum ReservedInstanceState
	ReservedInstanceStateActive = "active"
	// @enum ReservedInstanceState
	ReservedInstanceStatePaymentFailed = "payment-failed"
	// @enum ReservedInstanceState
	ReservedInstanceStateRetired = "retired"
)

const (
	// @enum ResetImageAttributeName
	ResetImageAttributeNameLaunchPermission = "launchPermission"
)

const (
	// @enum ResourceType
	ResourceTypeCustomerGateway = "customer-gateway"
	// @enum ResourceType
	ResourceTypeDhcpOptions = "dhcp-options"
	// @enum ResourceType
	ResourceTypeImage = "image"
	// @enum ResourceType
	ResourceTypeInstance = "instance"
	// @enum ResourceType
	ResourceTypeInternetGateway = "internet-gateway"
	// @enum ResourceType
	ResourceTypeNetworkAcl = "network-acl"
	// @enum ResourceType
	ResourceTypeNetworkInterface = "network-interface"
	// @enum ResourceType
	ResourceTypeReservedInstances = "reserved-instances"
	// @enum ResourceType
	ResourceTypeRouteTable = "route-table"
	// @enum ResourceType
	ResourceTypeSnapshot = "snapshot"
	// @enum ResourceType
	ResourceTypeSpotInstancesRequest = "spot-instances-request"
	// @enum ResourceType
	ResourceTypeSubnet = "subnet"
	// @enum ResourceType
	ResourceTypeSecurityGroup = "security-group"
	// @enum ResourceType
	ResourceTypeVolume = "volume"
	// @enum ResourceType
	ResourceTypeVpc = "vpc"
	// @enum ResourceType
	ResourceTypeVpnConnection = "vpn-connection"
	// @enum ResourceType
	ResourceTypeVpnGateway = "vpn-gateway"
)

const (
	// @enum RouteOrigin
	RouteOriginCreateRouteTable = "CreateRouteTable"
	// @enum RouteOrigin
	RouteOriginCreateRoute = "CreateRoute"
	// @enum RouteOrigin
	RouteOriginEnableVgwRoutePropagation = "EnableVgwRoutePropagation"
)

const (
	// @enum RouteState
	RouteStateActive = "active"
	// @enum RouteState
	RouteStateBlackhole = "blackhole"
)

const (
	// @enum RuleAction
	RuleActionAllow = "allow"
	// @enum RuleAction
	RuleActionDeny = "deny"
)

const (
	// @enum ShutdownBehavior
	ShutdownBehaviorStop = "stop"
	// @enum ShutdownBehavior
	ShutdownBehaviorTerminate = "terminate"
)

const (
	// @enum SnapshotAttributeName
	SnapshotAttributeNameProductCodes = "productCodes"
	// @enum SnapshotAttributeName
	SnapshotAttributeNameCreateVolumePermission = "createVolumePermission"
)

const (
	// @enum SnapshotState
	SnapshotStatePending = "pending"
	// @enum SnapshotState
	SnapshotStateCompleted = "completed"
	// @enum SnapshotState
	SnapshotStateError = "error"
)

const (
	// @enum SpotInstanceState
	SpotInstanceStateOpen = "open"
	// @enum SpotInstanceState
	SpotInstanceStateActive = "active"
	// @enum SpotInstanceState
	SpotInstanceStateClosed = "closed"
	// @enum SpotInstanceState
	SpotInstanceStateCancelled = "cancelled"
	// @enum SpotInstanceState
	SpotInstanceStateFailed = "failed"
)

const (
	// @enum SpotInstanceType
	SpotInstanceTypeOneTime = "one-time"
	// @enum SpotInstanceType
	SpotInstanceTypePersistent = "persistent"
)

const (
	// @enum State
	StatePending = "Pending"
	// @enum State
	StateAvailable = "Available"
	// @enum State
	StateDeleting = "Deleting"
	// @enum State
	StateDeleted = "Deleted"
)

const (
	// @enum Status
	StatusMoveInProgress = "MoveInProgress"
	// @enum Status
	StatusInVpc = "InVpc"
	// @enum Status
	StatusInClassic = "InClassic"
)

const (
	// @enum StatusName
	StatusNameReachability = "reachability"
)

const (
	// @enum StatusType
	StatusTypePassed = "passed"
	// @enum StatusType
	StatusTypeFailed = "failed"
	// @enum StatusType
	StatusTypeInsufficientData = "insufficient-data"
	// @enum StatusType
	StatusTypeInitializing = "initializing"
)

const (
	// @enum SubnetState
	SubnetStatePending = "pending"
	// @enum SubnetState
	SubnetStateAvailable = "available"
)

const (
	// @enum SummaryStatus
	SummaryStatusOk = "ok"
	// @enum SummaryStatus
	SummaryStatusImpaired = "impaired"
	// @enum SummaryStatus
	SummaryStatusInsufficientData = "insufficient-data"
	// @enum SummaryStatus
	SummaryStatusNotApplicable = "not-applicable"
	// @enum SummaryStatus
	SummaryStatusInitializing = "initializing"
)

const (
	// @enum TelemetryStatus
	TelemetryStatusUp = "UP"
	// @enum TelemetryStatus
	TelemetryStatusDown = "DOWN"
)

const (
	// @enum Tenancy
	TenancyDefault = "default"
	// @enum Tenancy
	TenancyDedicated = "dedicated"
	// @enum Tenancy
	TenancyHost = "host"
)

const (
	// @enum TrafficType
	TrafficTypeAccept = "ACCEPT"
	// @enum TrafficType
	TrafficTypeReject = "REJECT"
	// @enum TrafficType
	TrafficTypeAll = "ALL"
)

const (
	// @enum VirtualizationType
	VirtualizationTypeHvm = "hvm"
	// @enum VirtualizationType
	VirtualizationTypeParavirtual = "paravirtual"
)

const (
	// @enum VolumeAttachmentState
	VolumeAttachmentStateAttaching = "attaching"
	// @enum VolumeAttachmentState
	VolumeAttachmentStateAttached = "attached"
	// @enum VolumeAttachmentState
	VolumeAttachmentStateDetaching = "detaching"
	// @enum VolumeAttachmentState
	VolumeAttachmentStateDetached = "detached"
)

const (
	// @enum VolumeAttributeName
	VolumeAttributeNameAutoEnableIo = "autoEnableIO"
	// @enum VolumeAttributeName
	VolumeAttributeNameProductCodes = "productCodes"
)

const (
	// @enum VolumeState
	VolumeStateCreating = "creating"
	// @enum VolumeState
	VolumeStateAvailable = "available"
	// @enum VolumeState
	VolumeStateInUse = "in-use"
	// @enum VolumeState
	VolumeStateDeleting = "deleting"
	// @enum VolumeState
	VolumeStateDeleted = "deleted"
	// @enum VolumeState
	VolumeStateError = "error"
)

const (
	// @enum VolumeStatusInfoStatus
	VolumeStatusInfoStatusOk = "ok"
	// @enum VolumeStatusInfoStatus
	VolumeStatusInfoStatusImpaired = "impaired"
	// @enum VolumeStatusInfoStatus
	VolumeStatusInfoStatusInsufficientData = "insufficient-data"
)

const (
	// @enum VolumeStatusName
	VolumeStatusNameIoEnabled = "io-enabled"
	// @enum VolumeStatusName
	VolumeStatusNameIoPerformance = "io-performance"
)

const (
	// @enum VolumeType
	VolumeTypeStandard = "standard"
	// @enum VolumeType
	VolumeTypeIo1 = "io1"
	// @enum VolumeType
	VolumeTypeGp2 = "gp2"
)

const (
	// @enum VpcAttributeName
	VpcAttributeNameEnableDnsSupport = "enableDnsSupport"
	// @enum VpcAttributeName
	VpcAttributeNameEnableDnsHostnames = "enableDnsHostnames"
)

const (
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeInitiatingRequest = "initiating-request"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodePendingAcceptance = "pending-acceptance"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeActive = "active"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeDeleted = "deleted"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeRejected = "rejected"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeFailed = "failed"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeExpired = "expired"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeProvisioning = "provisioning"
	// @enum VpcPeeringConnectionStateReasonCode
	VpcPeeringConnectionStateReasonCodeDeleting = "deleting"
)

const (
	// @enum VpcState
	VpcStatePending = "pending"
	// @enum VpcState
	VpcStateAvailable = "available"
)

const (
	// @enum VpnState
	VpnStatePending = "pending"
	// @enum VpnState
	VpnStateAvailable = "available"
	// @enum VpnState
	VpnStateDeleting = "deleting"
	// @enum VpnState
	VpnStateDeleted = "deleted"
)

const (
	// @enum VpnStaticRouteSource
	VpnStaticRouteSourceStatic = "Static"
)
