package v1

// This file contains methods that can be used by the go-restful package to generate Swagger
// documentation for the object types found in 'types.go' This file is automatically generated
// by hack/update-generated-swagger-descriptions.sh and should be run after a full build of OpenShift.
// ==== DO NOT EDIT THIS FILE MANUALLY ====

var map_ActiveDirectoryConfig = map[string]string{
	"":                          "ActiveDirectoryConfig holds the necessary configuration options to define how an LDAP group sync interacts with an LDAP server using the Active Directory schema",
	"usersQuery":                "AllUsersQuery holds the template for an LDAP query that returns user entries.",
	"userNameAttributes":        "UserNameAttributes defines which attributes on an LDAP user entry will be interpreted as its OpenShift user name.",
	"groupMembershipAttributes": "GroupMembershipAttributes defines which attributes on an LDAP user entry will be interpreted as the groups it is a member of",
}

func (ActiveDirectoryConfig) SwaggerDoc() map[string]string {
	return map_ActiveDirectoryConfig
}

var map_AdmissionConfig = map[string]string{
	"":                    "AdmissionConfig holds the necessary configuration options for admission",
	"pluginConfig":        "PluginConfig allows specifying a configuration file per admission control plugin",
	"pluginOrderOverride": "PluginOrderOverride is a list of admission control plugin names that will be installed on the master. Order is significant. If empty, a default list of plugins is used.",
}

func (AdmissionConfig) SwaggerDoc() map[string]string {
	return map_AdmissionConfig
}

var map_AdmissionPluginConfig = map[string]string{
	"":              "AdmissionPluginConfig holds the necessary configuration options for admission plugins",
	"location":      "Location is the path to a configuration file that contains the plugin's configuration",
	"configuration": "Configuration is an embedded configuration object to be used as the plugin's configuration. If present, it will be used instead of the path to the configuration file.",
}

func (AdmissionPluginConfig) SwaggerDoc() map[string]string {
	return map_AdmissionPluginConfig
}

var map_AllowAllPasswordIdentityProvider = map[string]string{
	"": "AllowAllPasswordIdentityProvider provides identities for users authenticating using non-empty passwords",
}

func (AllowAllPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_AllowAllPasswordIdentityProvider
}

var map_AssetConfig = map[string]string{
	"":                     "AssetConfig holds the necessary configuration options for serving assets",
	"servingInfo":          "ServingInfo is the HTTP serving information for these assets",
	"publicURL":            "PublicURL is where you can find the asset server (TODO do we really need this?)",
	"logoutURL":            "LogoutURL is an optional, absolute URL to redirect web browsers to after logging out of the web console. If not specified, the built-in logout page is shown.",
	"masterPublicURL":      "MasterPublicURL is how the web console can access the OpenShift v1 server",
	"loggingPublicURL":     "LoggingPublicURL is the public endpoint for logging (optional)",
	"metricsPublicURL":     "MetricsPublicURL is the public endpoint for metrics (optional)",
	"extensionScripts":     "ExtensionScripts are file paths on the asset server files to load as scripts when the Web Console loads",
	"extensionProperties":  "ExtensionProperties are key(string) and value(string) pairs that will be injected into the console under the global variable OPENSHIFT_EXTENSION_PROPERTIES",
	"extensionStylesheets": "ExtensionStylesheets are file paths on the asset server files to load as stylesheets when the Web Console loads",
	"extensions":           "Extensions are files to serve from the asset server filesystem under a subcontext",
	"extensionDevelopment": "ExtensionDevelopment when true tells the asset server to reload extension scripts and stylesheets for every request rather than only at startup. It lets you develop extensions without having to restart the server for every change.",
}

func (AssetConfig) SwaggerDoc() map[string]string {
	return map_AssetConfig
}

var map_AssetExtensionsConfig = map[string]string{
	"":                "AssetExtensionsConfig holds the necessary configuration options for asset extensions",
	"name":            "SubContext is the path under /<context>/extensions/ to serve files from SourceDirectory",
	"sourceDirectory": "SourceDirectory is a directory on the asset server to serve files under Name in the Web Console. It may have nested folders.",
	"html5Mode":       "HTML5Mode determines whether to redirect to the root index.html when a file is not found. This is needed for apps that use the HTML5 history API like AngularJS apps with HTML5 mode enabled. If HTML5Mode is true, also rewrite the base element in index.html with the Web Console's context root. Defaults to false.",
}

func (AssetExtensionsConfig) SwaggerDoc() map[string]string {
	return map_AssetExtensionsConfig
}

var map_AuditConfig = map[string]string{
	"":        "AuditConfig holds configuration for the audit capabilities",
	"enabled": "If this flag is set, basic audit log will be printed in the logs. The logs contains, method, user and a requested URL.",
}

func (AuditConfig) SwaggerDoc() map[string]string {
	return map_AuditConfig
}

var map_AugmentedActiveDirectoryConfig = map[string]string{
	"":                          "AugmentedActiveDirectoryConfig holds the necessary configuration options to define how an LDAP group sync interacts with an LDAP server using the augmented Active Directory schema",
	"usersQuery":                "AllUsersQuery holds the template for an LDAP query that returns user entries.",
	"userNameAttributes":        "UserNameAttributes defines which attributes on an LDAP user entry will be interpreted as its OpenShift user name.",
	"groupMembershipAttributes": "GroupMembershipAttributes defines which attributes on an LDAP user entry will be interpreted as the groups it is a member of",
	"groupsQuery":               "AllGroupsQuery holds the template for an LDAP query that returns group entries.",
	"groupUIDAttribute":         "GroupUIDAttributes defines which attribute on an LDAP group entry will be interpreted as its unique identifier. (ldapGroupUID)",
	"groupNameAttributes":       "GroupNameAttributes defines which attributes on an LDAP group entry will be interpreted as its name to use for an OpenShift group",
}

func (AugmentedActiveDirectoryConfig) SwaggerDoc() map[string]string {
	return map_AugmentedActiveDirectoryConfig
}

var map_BasicAuthPasswordIdentityProvider = map[string]string{
	"": "BasicAuthPasswordIdentityProvider provides identities for users authenticating using HTTP basic auth credentials",
}

func (BasicAuthPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_BasicAuthPasswordIdentityProvider
}

var map_CertInfo = map[string]string{
	"":         "CertInfo relates a certificate with a private key",
	"certFile": "CertFile is a file containing a PEM-encoded certificate",
	"keyFile":  "KeyFile is a file containing a PEM-encoded private key for the certificate specified by CertFile",
}

func (CertInfo) SwaggerDoc() map[string]string {
	return map_CertInfo
}

var map_ClientConnectionOverrides = map[string]string{
	"":                   "ClientConnectionOverrides are a set of overrides to the default client connection settings.",
	"acceptContentTypes": "AcceptContentTypes defines the Accept header sent by clients when connecting to a server, overriding the default value of 'application/json'. This field will control all connections to the server used by a particular client.",
	"contentType":        "ContentType is the content type used when sending data to the server from this client.",
	"qps":                "QPS controls the number of queries per second allowed for this connection.",
	"burst":              "Burst allows extra queries to accumulate when a client is exceeding its rate.",
}

func (ClientConnectionOverrides) SwaggerDoc() map[string]string {
	return map_ClientConnectionOverrides
}

var map_ControllerConfig = map[string]string{
	"":                   "ControllerConfig holds configuration values for controllers",
	"serviceServingCert": "ServiceServingCert holds configuration for service serving cert signer which creates cert/key pairs for pods fulfilling a service to serve with.",
}

func (ControllerConfig) SwaggerDoc() map[string]string {
	return map_ControllerConfig
}

var map_DNSConfig = map[string]string{
	"":                      "DNSConfig holds the necessary configuration options for DNS",
	"bindAddress":           "BindAddress is the ip:port to serve DNS on",
	"bindNetwork":           "BindNetwork is the type of network to bind to - defaults to \"tcp4\", accepts \"tcp\", \"tcp4\", and \"tcp6\"",
	"allowRecursiveQueries": "AllowRecursiveQueries allows the DNS server on the master to answer queries recursively. Note that open resolvers can be used for DNS amplification attacks and the master DNS should not be made accessible to public networks.",
}

func (DNSConfig) SwaggerDoc() map[string]string {
	return map_DNSConfig
}

var map_DefaultAdmissionConfig = map[string]string{
	"":        "DefaultAdmissionConfig can be used to enable or disable various admission plugins. When this type is present as the `configuration` object under `pluginConfig` and *if* the admission plugin supports it, this will cause an \"off by default\" admission plugin to be enabled",
	"disable": "Disable turns off an admission plugin that is enabled by default.",
}

func (DefaultAdmissionConfig) SwaggerDoc() map[string]string {
	return map_DefaultAdmissionConfig
}

var map_DenyAllPasswordIdentityProvider = map[string]string{
	"": "DenyAllPasswordIdentityProvider provides no identities for users",
}

func (DenyAllPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_DenyAllPasswordIdentityProvider
}

var map_DockerConfig = map[string]string{
	"":                "DockerConfig holds Docker related configuration options.",
	"execHandlerName": "ExecHandlerName is the name of the handler to use for executing commands in Docker containers.",
}

func (DockerConfig) SwaggerDoc() map[string]string {
	return map_DockerConfig
}

var map_EtcdConfig = map[string]string{
	"":                 "EtcdConfig holds the necessary configuration options for connecting with an etcd database",
	"servingInfo":      "ServingInfo describes how to start serving the etcd master",
	"address":          "Address is the advertised host:port for client connections to etcd",
	"peerServingInfo":  "PeerServingInfo describes how to start serving the etcd peer",
	"peerAddress":      "PeerAddress is the advertised host:port for peer connections to etcd",
	"storageDirectory": "StorageDir is the path to the etcd storage directory",
}

func (EtcdConfig) SwaggerDoc() map[string]string {
	return map_EtcdConfig
}

var map_EtcdConnectionInfo = map[string]string{
	"":     "EtcdConnectionInfo holds information necessary for connecting to an etcd server",
	"urls": "URLs are the URLs for etcd",
	"ca":   "CA is a file containing trusted roots for the etcd server certificates",
}

func (EtcdConnectionInfo) SwaggerDoc() map[string]string {
	return map_EtcdConnectionInfo
}

var map_EtcdStorageConfig = map[string]string{
	"": "EtcdStorageConfig holds the necessary configuration options for the etcd storage underlying OpenShift and Kubernetes",
	"kubernetesStorageVersion": "KubernetesStorageVersion is the API version that Kube resources in etcd should be serialized to. This value should *not* be advanced until all clients in the cluster that read from etcd have code that allows them to read the new version.",
	"kubernetesStoragePrefix":  "KubernetesStoragePrefix is the path within etcd that the Kubernetes resources will be rooted under. This value, if changed, will mean existing objects in etcd will no longer be located. The default value is 'kubernetes.io'.",
	"openShiftStorageVersion":  "OpenShiftStorageVersion is the API version that OS resources in etcd should be serialized to. This value should *not* be advanced until all clients in the cluster that read from etcd have code that allows them to read the new version.",
	"openShiftStoragePrefix":   "OpenShiftStoragePrefix is the path within etcd that the OpenShift resources will be rooted under. This value, if changed, will mean existing objects in etcd will no longer be located. The default value is 'openshift.io'.",
}

func (EtcdStorageConfig) SwaggerDoc() map[string]string {
	return map_EtcdStorageConfig
}

var map_GitHubIdentityProvider = map[string]string{
	"":              "GitHubIdentityProvider provides identities for users authenticating using GitHub credentials",
	"clientID":      "ClientID is the oauth client ID",
	"clientSecret":  "ClientSecret is the oauth client secret",
	"organizations": "Organizations optionally restricts which organizations are allowed to log in",
}

func (GitHubIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitHubIdentityProvider
}

var map_GitLabIdentityProvider = map[string]string{
	"":             "GitLabIdentityProvider provides identities for users authenticating using GitLab credentials",
	"ca":           "CA is the optional trusted certificate authority bundle to use when making requests to the server If empty, the default system roots are used",
	"url":          "URL is the oauth server base URL",
	"clientID":     "ClientID is the oauth client ID",
	"clientSecret": "ClientSecret is the oauth client secret",
}

func (GitLabIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitLabIdentityProvider
}

var map_GoogleIdentityProvider = map[string]string{
	"":             "GoogleIdentityProvider provides identities for users authenticating using Google credentials",
	"clientID":     "ClientID is the oauth client ID",
	"clientSecret": "ClientSecret is the oauth client secret",
	"hostedDomain": "HostedDomain is the optional Google App domain (e.g. \"mycompany.com\") to restrict logins to",
}

func (GoogleIdentityProvider) SwaggerDoc() map[string]string {
	return map_GoogleIdentityProvider
}

var map_GrantConfig = map[string]string{
	"":                     "GrantConfig holds the necessary configuration options for grant handlers",
	"method":               "Method determines the default strategy to use when an OAuth client requests a grant. This method will be used only if the specific OAuth client doesn't provide a strategy of their own. Valid grant handling methods are:\n - auto:   always approves grant requests, useful for trusted clients\n - prompt: prompts the end user for approval of grant requests, useful for third-party clients\n - deny:   always denies grant requests, useful for black-listed clients",
	"serviceAccountMethod": "ServiceAccountMethod is used for determining client authorization for service account oauth client. It must be either: deny, prompt",
}

func (GrantConfig) SwaggerDoc() map[string]string {
	return map_GrantConfig
}

var map_HTPasswdPasswordIdentityProvider = map[string]string{
	"":     "HTPasswdPasswordIdentityProvider provides identities for users authenticating using htpasswd credentials",
	"file": "File is a reference to your htpasswd file",
}

func (HTPasswdPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_HTPasswdPasswordIdentityProvider
}

var map_HTTPServingInfo = map[string]string{
	"": "HTTPServingInfo holds configuration for serving HTTP",
	"maxRequestsInFlight":   "MaxRequestsInFlight is the number of concurrent requests allowed to the server. If zero, no limit.",
	"requestTimeoutSeconds": "RequestTimeoutSeconds is the number of seconds before requests are timed out. The default is 60 minutes, if -1 there is no limit on requests.",
}

func (HTTPServingInfo) SwaggerDoc() map[string]string {
	return map_HTTPServingInfo
}

var map_IdentityProvider = map[string]string{
	"":              "IdentityProvider provides identities for users authenticating using credentials",
	"name":          "Name is used to qualify the identities returned by this provider",
	"challenge":     "UseAsChallenger indicates whether to issue WWW-Authenticate challenges for this provider",
	"login":         "UseAsLogin indicates whether to use this identity provider for unauthenticated browsers to login against",
	"mappingMethod": "MappingMethod determines how identities from this provider are mapped to users",
	"provider":      "Provider contains the information about how to set up a specific identity provider",
}

func (IdentityProvider) SwaggerDoc() map[string]string {
	return map_IdentityProvider
}

var map_ImageConfig = map[string]string{
	"":       "ImageConfig holds the necessary configuration options for building image names for system components",
	"format": "Format is the format of the name to be built for the system component",
	"latest": "Latest determines if the latest tag will be pulled from the registry",
}

func (ImageConfig) SwaggerDoc() map[string]string {
	return map_ImageConfig
}

var map_ImagePolicyConfig = map[string]string{
	"": "ImagePolicyConfig holds the necessary configuration options for limits and behavior for importing images",
	"maxImagesBulkImportedPerRepository":         "MaxImagesBulkImportedPerRepository controls the number of images that are imported when a user does a bulk import of a Docker repository. This number defaults to 5 to prevent users from importing large numbers of images accidentally. Set -1 for no limit.",
	"disableScheduledImport":                     "DisableScheduledImport allows scheduled background import of images to be disabled.",
	"scheduledImageImportMinimumIntervalSeconds": "ScheduledImageImportMinimumIntervalSeconds is the minimum number of seconds that can elapse between when image streams scheduled for background import are checked against the upstream repository. The default value is 15 minutes.",
	"maxScheduledImageImportsPerMinute":          "MaxScheduledImageImportsPerMinute is the maximum number of scheduled image streams that will be imported in the background per minute. The default value is 60. Set to -1 for unlimited.",
}

func (ImagePolicyConfig) SwaggerDoc() map[string]string {
	return map_ImagePolicyConfig
}

var map_JenkinsPipelineConfig = map[string]string{
	"": "JenkinsPipelineConfig holds configuration for the Jenkins pipeline strategy",
	"autoProvisionEnabled": "AutoProvisionEnabled determines whether a Jenkins server will be spawned from the provided template when the first build config in the project with type JenkinsPipeline is created. When not specified this option defaults to false.",
	"templateNamespace":    "TemplateNamespace contains the namespace name where the Jenkins template is stored",
	"templateName":         "TemplateName is the name of the default Jenkins template",
	"serviceName":          "ServiceName is the name of the Jenkins service OpenShift uses to detect whether a Jenkins pipeline handler has already been installed in a project. This value *must* match a service name in the provided template.",
	"parameters":           "Parameters specifies a set of optional parameters to the Jenkins template.",
}

func (JenkinsPipelineConfig) SwaggerDoc() map[string]string {
	return map_JenkinsPipelineConfig
}

var map_KeystonePasswordIdentityProvider = map[string]string{
	"":           "KeystonePasswordIdentityProvider provides identities for users authenticating using keystone password credentials",
	"domainName": "Domain Name is required for keystone v3",
}

func (KeystonePasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_KeystonePasswordIdentityProvider
}

var map_KubeletConnectionInfo = map[string]string{
	"":     "KubeletConnectionInfo holds information necessary for connecting to a kubelet",
	"port": "Port is the port to connect to kubelets on",
	"ca":   "CA is the CA for verifying TLS connections to kubelets",
}

func (KubeletConnectionInfo) SwaggerDoc() map[string]string {
	return map_KubeletConnectionInfo
}

var map_KubernetesMasterConfig = map[string]string{
	"":                         "KubernetesMasterConfig holds the necessary configuration options for the Kubernetes master",
	"apiLevels":                "APILevels is a list of API levels that should be enabled on startup: v1 as examples",
	"disabledAPIGroupVersions": "DisabledAPIGroupVersions is a map of groups to the versions (or *) that should be disabled.",
	"masterIP":                 "MasterIP is the public IP address of kubernetes stuff.  If empty, the first result from net.InterfaceAddrs will be used.",
	"masterCount":              "MasterCount is the number of expected masters that should be running. This value defaults to 1 and may be set to a positive integer, or if set to -1, indicates this is part of a cluster.",
	"servicesSubnet":           "ServicesSubnet is the subnet to use for assigning service IPs",
	"servicesNodePortRange":    "ServicesNodePortRange is the range to use for assigning service public ports on a host.",
	"staticNodeNames":          "StaticNodeNames is the list of nodes that are statically known",
	"schedulerConfigFile":      "SchedulerConfigFile points to a file that describes how to set up the scheduler. If empty, you get the default scheduling rules.",
	"podEvictionTimeout":       "PodEvictionTimeout controls grace period for deleting pods on failed nodes. It takes valid time duration string. If empty, you get the default pod eviction timeout.",
	"proxyClientInfo":          "ProxyClientInfo specifies the client cert/key to use when proxying to pods",
	"admissionConfig":          "AdmissionConfig contains admission control plugin configuration.",
	"apiServerArguments":       "APIServerArguments are key value pairs that will be passed directly to the Kube apiserver that match the apiservers's command line arguments.  These are not migrated, but if you reference a value that does not exist the server will not start. These values may override other settings in KubernetesMasterConfig which may cause invalid configurations.",
	"controllerArguments":      "ControllerArguments are key value pairs that will be passed directly to the Kube controller manager that match the controller manager's command line arguments.  These are not migrated, but if you reference a value that does not exist the server will not start. These values may override other settings in KubernetesMasterConfig which may cause invalid configurations.",
	"schedulerArguments":       "SchedulerArguments are key value pairs that will be passed directly to the Kube scheduler that match the scheduler's command line arguments.  These are not migrated, but if you reference a value that does not exist the server will not start. These values may override other settings in KubernetesMasterConfig which may cause invalid configurations.",
}

func (KubernetesMasterConfig) SwaggerDoc() map[string]string {
	return map_KubernetesMasterConfig
}

var map_LDAPAttributeMapping = map[string]string{
	"":                  "LDAPAttributeMapping maps LDAP attributes to OpenShift identity fields",
	"id":                "ID is the list of attributes whose values should be used as the user ID. Required. LDAP standard identity attribute is \"dn\"",
	"preferredUsername": "PreferredUsername is the list of attributes whose values should be used as the preferred username. LDAP standard login attribute is \"uid\"",
	"name":              "Name is the list of attributes whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity LDAP standard display name attribute is \"cn\"",
	"email":             "Email is the list of attributes whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
}

func (LDAPAttributeMapping) SwaggerDoc() map[string]string {
	return map_LDAPAttributeMapping
}

var map_LDAPPasswordIdentityProvider = map[string]string{
	"":             "LDAPPasswordIdentityProvider provides identities for users authenticating using LDAP credentials",
	"url":          "URL is an RFC 2255 URL which specifies the LDAP search parameters to use. The syntax of the URL is\n   ldap://host:port/basedn?attribute?scope?filter",
	"bindDN":       "BindDN is an optional DN to bind with during the search phase.",
	"bindPassword": "BindPassword is an optional password to bind with during the search phase.",
	"insecure":     "Insecure, if true, indicates the connection should not use TLS. Cannot be set to true with a URL scheme of \"ldaps://\" If false, \"ldaps://\" URLs connect using TLS, and \"ldap://\" URLs are upgraded to a TLS connection using StartTLS as specified in https://tools.ietf.org/html/rfc2830",
	"ca":           "CA is the optional trusted certificate authority bundle to use when making requests to the server If empty, the default system roots are used",
	"attributes":   "Attributes maps LDAP attributes to identities",
}

func (LDAPPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_LDAPPasswordIdentityProvider
}

var map_LDAPQuery = map[string]string{
	"":             "LDAPQuery holds the options necessary to build an LDAP query",
	"baseDN":       "The DN of the branch of the directory where all searches should start from",
	"scope":        "The (optional) scope of the search. Can be: base: only the base object, one:  all object on the base level, sub:  the entire subtree Defaults to the entire subtree if not set",
	"derefAliases": "The (optional) behavior of the search with regards to alisases. Can be: never:  never dereference aliases, search: only dereference in searching, base:   only dereference in finding the base object, always: always dereference Defaults to always dereferencing if not set",
	"timeout":      "TimeLimit holds the limit of time in seconds that any request to the server can remain outstanding before the wait for a response is given up. If this is 0, no client-side limit is imposed",
	"filter":       "Filter is a valid LDAP search filter that retrieves all relevant entries from the LDAP server with the base DN",
	"pageSize":     "PageSize is the maximum preferred page size, measured in LDAP entries. A page size of 0 means no paging will be done.",
}

func (LDAPQuery) SwaggerDoc() map[string]string {
	return map_LDAPQuery
}

var map_LDAPSyncConfig = map[string]string{
	"":             "LDAPSyncConfig holds the necessary configuration options to define an LDAP group sync",
	"url":          "Host is the scheme, host and port of the LDAP server to connect to: scheme://host:port",
	"bindDN":       "BindDN is an optional DN to bind to the LDAP server with",
	"bindPassword": "BindPassword is an optional password to bind with during the search phase.",
	"insecure":     "Insecure, if true, indicates the connection should not use TLS. Cannot be set to true with a URL scheme of \"ldaps://\" If false, \"ldaps://\" URLs connect using TLS, and \"ldap://\" URLs are upgraded to a TLS connection using StartTLS as specified in https://tools.ietf.org/html/rfc2830",
	"ca":           "CA is the optional trusted certificate authority bundle to use when making requests to the server If empty, the default system roots are used",
	"groupUIDNameMapping":      "LDAPGroupUIDToOpenShiftGroupNameMapping is an optional direct mapping of LDAP group UIDs to OpenShift Group names",
	"rfc2307":                  "RFC2307Config holds the configuration for extracting data from an LDAP server set up in a fashion similar to RFC2307: first-class group and user entries, with group membership determined by a multi-valued attribute on the group entry listing its members",
	"activeDirectory":          "ActiveDirectoryConfig holds the configuration for extracting data from an LDAP server set up in a fashion similar to that used in Active Directory: first-class user entries, with group membership determined by a multi-valued attribute on members listing groups they are a member of",
	"augmentedActiveDirectory": "AugmentedActiveDirectoryConfig holds the configuration for extracting data from an LDAP server set up in a fashion similar to that used in Active Directory as described above, with one addition: first-class group entries exist and are used to hold metadata but not group membership",
}

func (LDAPSyncConfig) SwaggerDoc() map[string]string {
	return map_LDAPSyncConfig
}

var map_LocalQuota = map[string]string{
	"":           "LocalQuota contains options for controlling local volume quota on the node.",
	"perFSGroup": "FSGroup can be specified to enable a quota on local storage use per unique FSGroup ID. At present this is only implemented for emptyDir volumes, and if the underlying volumeDirectory is on an XFS filesystem.",
}

func (LocalQuota) SwaggerDoc() map[string]string {
	return map_LocalQuota
}

var map_MasterClients = map[string]string{
	"": "MasterClients holds references to `.kubeconfig` files that qualify master clients for OpenShift and Kubernetes",
	"openshiftLoopbackKubeConfig":                 "OpenShiftLoopbackKubeConfig is a .kubeconfig filename for system components to loopback to this master",
	"externalKubernetesKubeConfig":                "ExternalKubernetesKubeConfig is a .kubeconfig filename for proxying to Kubernetes",
	"openshiftLoopbackClientConnectionOverrides":  "OpenShiftLoopbackClientConnectionOverrides specifies client overrides for system components to loop back to this master.",
	"externalKubernetesClientConnectionOverrides": "ExternalKubernetesClientConnectionOverrides specifies client overrides for proxying to Kubernetes.",
}

func (MasterClients) SwaggerDoc() map[string]string {
	return map_MasterClients
}

var map_MasterConfig = map[string]string{
	"":                       "MasterConfig holds the necessary configuration options for the OpenShift master",
	"servingInfo":            "ServingInfo describes how to start serving",
	"corsAllowedOrigins":     "CORSAllowedOrigins",
	"apiLevels":              "APILevels is a list of API levels that should be enabled on startup: v1 as examples",
	"masterPublicURL":        "MasterPublicURL is how clients can access the OpenShift API server",
	"controllers":            "Controllers is a list of the controllers that should be started. If set to \"none\", no controllers will start automatically. The default value is \"*\" which will start all controllers. When using \"*\", you may exclude controllers by prepending a \"-\" in front of their name. No other values are recognized at this time.",
	"pauseControllers":       "PauseControllers instructs the master to not automatically start controllers, but instead to wait until a notification to the server is received before launching them.",
	"controllerLeaseTTL":     "ControllerLeaseTTL enables controller election, instructing the master to attempt to acquire a lease before controllers start and renewing it within a number of seconds defined by this value. Setting this value non-negative forces pauseControllers=true. This value defaults off (0, or omitted) and controller election can be disabled with -1.",
	"admissionConfig":        "AdmissionConfig contains admission control plugin configuration.",
	"controllerConfig":       "ControllerConfig holds configuration values for controllers",
	"disabledFeatures":       "DisabledFeatures is a list of features that should not be started.  We omitempty here because its very unlikely that anyone will want to manually disable features and we don't want to encourage it.",
	"etcdStorageConfig":      "EtcdStorageConfig contains information about how API resources are stored in Etcd. These values are only relevant when etcd is the backing store for the cluster.",
	"etcdClientInfo":         "EtcdClientInfo contains information about how to connect to etcd",
	"kubeletClientInfo":      "KubeletClientInfo contains information about how to connect to kubelets",
	"kubernetesMasterConfig": "KubernetesMasterConfig, if present start the kubernetes master in this process",
	"etcdConfig":             "EtcdConfig, if present start etcd in this process",
	"oauthConfig":            "OAuthConfig, if present start the /oauth endpoint in this process",
	"assetConfig":            "AssetConfig, if present start the asset server in this process",
	"dnsConfig":              "DNSConfig, if present start the DNS server in this process",
	"serviceAccountConfig":   "ServiceAccountConfig holds options related to service accounts",
	"masterClients":          "MasterClients holds all the client connection information for controllers and other system components",
	"imageConfig":            "ImageConfig holds options that describe how to build image names for system components",
	"imagePolicyConfig":      "ImagePolicyConfig controls limits and behavior for importing images",
	"policyConfig":           "PolicyConfig holds information about where to locate critical pieces of bootstrapping policy",
	"projectConfig":          "ProjectConfig holds information about project creation and defaults",
	"routingConfig":          "RoutingConfig holds information about routing and route generation",
	"networkConfig":          "NetworkConfig to be passed to the compiled in network plugin",
	"volumeConfig":           "MasterVolumeConfig contains options for configuring volume plugins in the master node.",
	"jenkinsPipelineConfig":  "JenkinsPipelineConfig holds information about the default Jenkins template used for JenkinsPipeline build strategy.",
	"auditConfig":            "AuditConfig holds information related to auditing capabilities.",
}

func (MasterConfig) SwaggerDoc() map[string]string {
	return map_MasterConfig
}

var map_MasterNetworkConfig = map[string]string{
	"":                       "MasterNetworkConfig to be passed to the compiled in network plugin",
	"networkPluginName":      "NetworkPluginName is the name of the network plugin to use",
	"clusterNetworkCIDR":     "ClusterNetworkCIDR is the CIDR string to specify the global overlay network's L3 space",
	"hostSubnetLength":       "HostSubnetLength is the number of bits to allocate to each host's subnet e.g. 8 would mean a /24 network on the host",
	"serviceNetworkCIDR":     "ServiceNetwork is the CIDR string to specify the service networks",
	"externalIPNetworkCIDRs": "ExternalIPNetworkCIDRs controls what values are acceptable for the service external IP field. If empty, no externalIP may be set. It may contain a list of CIDRs which are checked for access. If a CIDR is prefixed with !, IPs in that CIDR will be rejected. Rejections will be applied first, then the IP checked against one of the allowed CIDRs. You should ensure this range does not overlap with your nodes, pods, or service CIDRs for security reasons.",
	"ingressIPNetworkCIDR":   "IngressIPNetworkCIDR controls the range to assign ingress ips from for services of type LoadBalancer on bare metal. If empty, ingress ips will not be assigned. It may contain a single CIDR that will be allocated from. For security reasons, you should ensure that this range does not overlap with the CIDRs reserved for external ips, nodes, pods, or services.",
}

func (MasterNetworkConfig) SwaggerDoc() map[string]string {
	return map_MasterNetworkConfig
}

var map_MasterVolumeConfig = map[string]string{
	"": "MasterVolumeConfig contains options for configuring volume plugins in the master node.",
	"dynamicProvisioningEnabled": "DynamicProvisioningEnabled is a boolean that toggles dynamic provisioning off when false, defaults to true",
}

func (MasterVolumeConfig) SwaggerDoc() map[string]string {
	return map_MasterVolumeConfig
}

var map_NamedCertificate = map[string]string{
	"":      "NamedCertificate specifies a certificate/key, and the names it should be served for",
	"names": "Names is a list of DNS names this certificate should be used to secure A name can be a normal DNS name, or can contain leading wildcard segments.",
}

func (NamedCertificate) SwaggerDoc() map[string]string {
	return map_NamedCertificate
}

var map_NodeAuthConfig = map[string]string{
	"": "NodeAuthConfig holds authn/authz configuration options",
	"authenticationCacheTTL":  "AuthenticationCacheTTL indicates how long an authentication result should be cached. It takes a valid time duration string (e.g. \"5m\"). If empty, you get the default timeout. If zero (e.g. \"0m\"), caching is disabled",
	"authenticationCacheSize": "AuthenticationCacheSize indicates how many authentication results should be cached. If 0, the default cache size is used.",
	"authorizationCacheTTL":   "AuthorizationCacheTTL indicates how long an authorization result should be cached. It takes a valid time duration string (e.g. \"5m\"). If empty, you get the default timeout. If zero (e.g. \"0m\"), caching is disabled",
	"authorizationCacheSize":  "AuthorizationCacheSize indicates how many authorization results should be cached. If 0, the default cache size is used.",
}

func (NodeAuthConfig) SwaggerDoc() map[string]string {
	return map_NodeAuthConfig
}

var map_NodeConfig = map[string]string{
	"":                                "NodeConfig is the fully specified config starting an OpenShift node",
	"nodeName":                        "NodeName is the value used to identify this particular node in the cluster.  If possible, this should be your fully qualified hostname. If you're describing a set of static nodes to the master, this value must match one of the values in the list",
	"nodeIP":                          "Node may have multiple IPs, specify the IP to use for pod traffic routing If not specified, network parse/lookup on the nodeName is performed and the first non-loopback address is used",
	"servingInfo":                     "ServingInfo describes how to start serving",
	"masterKubeConfig":                "MasterKubeConfig is a filename for the .kubeconfig file that describes how to connect this node to the master",
	"masterClientConnectionOverrides": "MasterClientConnectionOverrides provides overrides to the client connection used to connect to the master.",
	"dnsDomain":                       "DNSDomain holds the domain suffix",
	"dnsIP":                           "DNSIP holds the IP",
	"networkPluginName":               "Deprecated and maintained for backward compatibility, use NetworkConfig.NetworkPluginName instead",
	"networkConfig":                   "NetworkConfig provides network options for the node",
	"volumeDirectory":                 "VolumeDirectory is the directory that volumes will be stored under",
	"imageConfig":                     "ImageConfig holds options that describe how to build image names for system components",
	"allowDisabledDocker":             "AllowDisabledDocker if true, the Kubelet will ignore errors from Docker.  This means that a node can start on a machine that doesn't have docker started.",
	"podManifestConfig":               "PodManifestConfig holds the configuration for enabling the Kubelet to create pods based from a manifest file(s) placed locally on the node",
	"authConfig":                      "AuthConfig holds authn/authz configuration options",
	"dockerConfig":                    "DockerConfig holds Docker related configuration options.",
	"kubeletArguments":                "KubeletArguments are key value pairs that will be passed directly to the Kubelet that match the Kubelet's command line arguments.  These are not migrated or validated, so if you use them they may become invalid. These values override other settings in NodeConfig which may cause invalid configurations.",
	"proxyArguments":                  "ProxyArguments are key value pairs that will be passed directly to the Proxy that match the Proxy's command line arguments.  These are not migrated or validated, so if you use them they may become invalid. These values override other settings in NodeConfig which may cause invalid configurations.",
	"iptablesSyncPeriod":              "IPTablesSyncPeriod is how often iptable rules are refreshed",
	"enableUnidling":                  "EnableUnidling controls whether or not the hybrid unidling proxy will be set up",
	"volumeConfig":                    "VolumeConfig contains options for configuring volumes on the node.",
}

func (NodeConfig) SwaggerDoc() map[string]string {
	return map_NodeConfig
}

var map_NodeNetworkConfig = map[string]string{
	"":                  "NodeNetworkConfig provides network options for the node",
	"networkPluginName": "NetworkPluginName is a string specifying the networking plugin",
	"mtu":               "Maximum transmission unit for the network packets",
}

func (NodeNetworkConfig) SwaggerDoc() map[string]string {
	return map_NodeNetworkConfig
}

var map_NodeVolumeConfig = map[string]string{
	"":           "NodeVolumeConfig contains options for configuring volumes on the node.",
	"localQuota": "LocalQuota contains options for controlling local volume quota on the node.",
}

func (NodeVolumeConfig) SwaggerDoc() map[string]string {
	return map_NodeVolumeConfig
}

var map_OAuthConfig = map[string]string{
	"":                            "OAuthConfig holds the necessary configuration options for OAuth authentication",
	"masterCA":                    "MasterCA is the CA for verifying the TLS connection back to the MasterURL.",
	"masterURL":                   "MasterURL is used for making server-to-server calls to exchange authorization codes for access tokens",
	"masterPublicURL":             "MasterPublicURL is used for building valid client redirect URLs for external access",
	"assetPublicURL":              "AssetPublicURL is used for building valid client redirect URLs for external access",
	"alwaysShowProviderSelection": "AlwaysShowProviderSelection will force the provider selection page to render even when there is only a single provider.",
	"identityProviders":           "IdentityProviders is an ordered list of ways for a user to identify themselves",
	"grantConfig":                 "GrantConfig describes how to handle grants",
	"sessionConfig":               "SessionConfig hold information about configuring sessions.",
	"tokenConfig":                 "TokenConfig contains options for authorization and access tokens",
	"templates":                   "Templates allow you to customize pages like the login page.",
}

func (OAuthConfig) SwaggerDoc() map[string]string {
	return map_OAuthConfig
}

var map_OAuthTemplates = map[string]string{
	"":                  "OAuthTemplates allow for customization of pages like the login page",
	"login":             "Login is a path to a file containing a go template used to render the login page. If unspecified, the default login page is used.",
	"providerSelection": "ProviderSelection is a path to a file containing a go template used to render the provider selection page. If unspecified, the default provider selection page is used.",
	"error":             "Error is a path to a file containing a go template used to render error pages during the authentication or grant flow If unspecified, the default error page is used.",
}

func (OAuthTemplates) SwaggerDoc() map[string]string {
	return map_OAuthTemplates
}

var map_OpenIDClaims = map[string]string{
	"":                  "OpenIDClaims contains a list of OpenID claims to use when authenticating with an OpenID identity provider",
	"id":                "ID is the list of claims whose values should be used as the user ID. Required. OpenID standard identity claim is \"sub\"",
	"preferredUsername": "PreferredUsername is the list of claims whose values should be used as the preferred username. If unspecified, the preferred username is determined from the value of the id claim",
	"name":              "Name is the list of claims whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity",
	"email":             "Email is the list of claims whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
}

func (OpenIDClaims) SwaggerDoc() map[string]string {
	return map_OpenIDClaims
}

var map_OpenIDIdentityProvider = map[string]string{
	"":                         "OpenIDIdentityProvider provides identities for users authenticating using OpenID credentials",
	"ca":                       "CA is the optional trusted certificate authority bundle to use when making requests to the server If empty, the default system roots are used",
	"clientID":                 "ClientID is the oauth client ID",
	"clientSecret":             "ClientSecret is the oauth client secret",
	"extraScopes":              "ExtraScopes are any scopes to request in addition to the standard \"openid\" scope.",
	"extraAuthorizeParameters": "ExtraAuthorizeParameters are any custom parameters to add to the authorize request.",
	"urls":   "URLs to use to authenticate",
	"claims": "Claims mappings",
}

func (OpenIDIdentityProvider) SwaggerDoc() map[string]string {
	return map_OpenIDIdentityProvider
}

var map_OpenIDURLs = map[string]string{
	"":          "OpenIDURLs are URLs to use when authenticating with an OpenID identity provider",
	"authorize": "Authorize is the oauth authorization URL",
	"token":     "Token is the oauth token granting URL",
	"userInfo":  "UserInfo is the optional userinfo URL. If present, a granted access_token is used to request claims If empty, a granted id_token is parsed for claims",
}

func (OpenIDURLs) SwaggerDoc() map[string]string {
	return map_OpenIDURLs
}

var map_PodManifestConfig = map[string]string{
	"":     "PodManifestConfig holds the necessary configuration options for using pod manifests",
	"path": "Path specifies the path for the pod manifest file or directory If its a directory, its expected to contain on or more manifest files This is used by the Kubelet to create pods on the node",
	"fileCheckIntervalSeconds": "FileCheckIntervalSeconds is the interval in seconds for checking the manifest file(s) for new data The interval needs to be a positive value",
}

func (PodManifestConfig) SwaggerDoc() map[string]string {
	return map_PodManifestConfig
}

var map_PolicyConfig = map[string]string{
	"": "\n holds the necessary configuration options for",
	"bootstrapPolicyFile":               "BootstrapPolicyFile points to a template that contains roles and rolebindings that will be created if no policy object exists in the master namespace",
	"openshiftSharedResourcesNamespace": "OpenShiftSharedResourcesNamespace is the namespace where shared OpenShift resources live (like shared templates)",
	"openshiftInfrastructureNamespace":  "OpenShiftInfrastructureNamespace is the namespace where OpenShift infrastructure resources live (like controller service accounts)",
	"userAgentMatchingConfig":           "UserAgentMatchingConfig controls how API calls from *voluntarily* identifying clients will be handled.  THIS DOES NOT DEFEND AGAINST MALICIOUS CLIENTS!",
}

func (PolicyConfig) SwaggerDoc() map[string]string {
	return map_PolicyConfig
}

var map_ProjectConfig = map[string]string{
	"": "\n holds the necessary configuration options for",
	"defaultNodeSelector":    "DefaultNodeSelector holds default project node label selector",
	"projectRequestMessage":  "ProjectRequestMessage is the string presented to a user if they are unable to request a project via the projectrequest api endpoint",
	"projectRequestTemplate": "ProjectRequestTemplate is the template to use for creating projects in response to projectrequest. It is in the format namespace/template and it is optional. If it is not specified, a default template is used.",
	"securityAllocator":      "SecurityAllocator controls the automatic allocation of UIDs and MCS labels to a project. If nil, allocation is disabled.",
}

func (ProjectConfig) SwaggerDoc() map[string]string {
	return map_ProjectConfig
}

var map_RFC2307Config = map[string]string{
	"":                               "RFC2307Config holds the necessary configuration options to define how an LDAP group sync interacts with an LDAP server using the RFC2307 schema",
	"groupsQuery":                    "AllGroupsQuery holds the template for an LDAP query that returns group entries.",
	"groupUIDAttribute":              "GroupUIDAttributes defines which attribute on an LDAP group entry will be interpreted as its unique identifier. (ldapGroupUID)",
	"groupNameAttributes":            "GroupNameAttributes defines which attributes on an LDAP group entry will be interpreted as its name to use for an OpenShift group",
	"groupMembershipAttributes":      "GroupMembershipAttributes defines which attributes on an LDAP group entry will be interpreted  as its members. The values contained in those attributes must be queryable by your UserUIDAttribute",
	"usersQuery":                     "AllUsersQuery holds the template for an LDAP query that returns user entries.",
	"userUIDAttribute":               "UserUIDAttribute defines which attribute on an LDAP user entry will be interpreted as its unique identifier. It must correspond to values that will be found from the GroupMembershipAttributes",
	"userNameAttributes":             "UserNameAttributes defines which attributes on an LDAP user entry will be used, in order, as its OpenShift user name. The first attribute with a non-empty value is used. This should match your PreferredUsername setting for your LDAPPasswordIdentityProvider",
	"tolerateMemberNotFoundErrors":   "TolerateMemberNotFoundErrors determines the behavior of the LDAP sync job when missing user entries are encountered. If 'true', an LDAP query for users that doesn't find any will be tolerated and an only and error will be logged. If 'false', the LDAP sync job will fail if a query for users doesn't find any. The default value is 'false'. Misconfigured LDAP sync jobs with this flag set to 'true' can cause group membership to be removed, so it is recommended to use this flag with caution.",
	"tolerateMemberOutOfScopeErrors": "TolerateMemberOutOfScopeErrors determines the behavior of the LDAP sync job when out-of-scope user entries are encountered. If 'true', an LDAP query for a user that falls outside of the base DN given for the all user query will be tolerated and only an error will be logged. If 'false', the LDAP sync job will fail if a user query would search outside of the base DN specified by the all user query. Misconfigured LDAP sync jobs with this flag set to 'true' can result in groups missing users, so it is recommended to use this flag with caution.",
}

func (RFC2307Config) SwaggerDoc() map[string]string {
	return map_RFC2307Config
}

var map_RemoteConnectionInfo = map[string]string{
	"":    "RemoteConnectionInfo holds information necessary for establishing a remote connection",
	"url": "URL is the remote URL to connect to",
	"ca":  "CA is the CA for verifying TLS connections",
}

func (RemoteConnectionInfo) SwaggerDoc() map[string]string {
	return map_RemoteConnectionInfo
}

var map_RequestHeaderIdentityProvider = map[string]string{
	"":                         "RequestHeaderIdentityProvider provides identities for users authenticating using request header credentials",
	"loginURL":                 "LoginURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect interactive logins will be redirected here ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}",
	"challengeURL":             "ChallengeURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect WWW-Authenticate challenges will be redirected here ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}",
	"clientCA":                 "ClientCA is a file with the trusted signer certs.  If empty, no request verification is done, and any direct request to the OAuth server can impersonate any identity from this provider, merely by setting a request header.",
	"clientCommonNames":        "ClientCommonNames is an optional list of common names to require a match from. If empty, any client certificate validated against the clientCA bundle is considered authoritative.",
	"headers":                  "Headers is the set of headers to check for identity information",
	"preferredUsernameHeaders": "PreferredUsernameHeaders is the set of headers to check for the preferred username",
	"nameHeaders":              "NameHeaders is the set of headers to check for the display name",
	"emailHeaders":             "EmailHeaders is the set of headers to check for the email address",
}

func (RequestHeaderIdentityProvider) SwaggerDoc() map[string]string {
	return map_RequestHeaderIdentityProvider
}

var map_RoutingConfig = map[string]string{
	"":          "RoutingConfig holds the necessary configuration options for routing to subdomains",
	"subdomain": "Subdomain is the suffix appended to $service.$namespace. to form the default route hostname DEPRECATED: This field is being replaced by routers setting their own defaults. This is the \"default\" route.",
}

func (RoutingConfig) SwaggerDoc() map[string]string {
	return map_RoutingConfig
}

var map_SecurityAllocator = map[string]string{
	"":                    "SecurityAllocator controls the automatic allocation of UIDs and MCS labels to a project. If nil, allocation is disabled.",
	"uidAllocatorRange":   "UIDAllocatorRange defines the total set of Unix user IDs (UIDs) that will be allocated to projects automatically, and the size of the block each namespace gets. For example, 1000-1999/10 will allocate ten UIDs per namespace, and will be able to allocate up to 100 blocks before running out of space. The default is to allocate from 1 billion to 2 billion in 10k blocks (which is the expected size of the ranges Docker images will use once user namespaces are started).",
	"mcsAllocatorRange":   "MCSAllocatorRange defines the range of MCS categories that will be assigned to namespaces. The format is \"<prefix>/<numberOfLabels>[,<maxCategory>]\". The default is \"s0/2\" and will allocate from c0 -> c1023, which means a total of 535k labels are available (1024 choose 2 ~ 535k). If this value is changed after startup, new projects may receive labels that are already allocated to other projects. Prefix may be any valid SELinux set of terms (including user, role, and type), although leaving them as the default will allow the server to set them automatically.\n\nExamples: * s0:/2     - Allocate labels from s0:c0,c0 to s0:c511,c511 * s0:/2,512 - Allocate labels from s0:c0,c0,c0 to s0:c511,c511,511",
	"mcsLabelsPerProject": "MCSLabelsPerProject defines the number of labels that should be reserved per project. The default is 5 to match the default UID and MCS ranges (100k namespaces, 535k/5 labels).",
}

func (SecurityAllocator) SwaggerDoc() map[string]string {
	return map_SecurityAllocator
}

var map_ServiceAccountConfig = map[string]string{
	"":                      "ServiceAccountConfig holds the necessary configuration options for a service account",
	"managedNames":          "ManagedNames is a list of service account names that will be auto-created in every namespace. If no names are specified, the ServiceAccountsController will not be started.",
	"limitSecretReferences": "LimitSecretReferences controls whether or not to allow a service account to reference any secret in a namespace without explicitly referencing them",
	"privateKeyFile":        "PrivateKeyFile is a file containing a PEM-encoded private RSA key, used to sign service account tokens. If no private key is specified, the service account TokensController will not be started.",
	"publicKeyFiles":        "PublicKeyFiles is a list of files, each containing a PEM-encoded public RSA key. (If any file contains a private key, the public portion of the key is used) The list of public keys is used to verify presented service account tokens. Each key is tried in order until the list is exhausted or verification succeeds. If no keys are specified, no service account authentication will be available.",
	"masterCA":              "MasterCA is the CA for verifying the TLS connection back to the master.  The service account controller will automatically inject the contents of this file into pods so they can verify connections to the master.",
}

func (ServiceAccountConfig) SwaggerDoc() map[string]string {
	return map_ServiceAccountConfig
}

var map_ServiceServingCert = map[string]string{
	"":       "ServiceServingCert holds configuration for service serving cert signer which creates cert/key pairs for pods fulfilling a service to serve with.",
	"signer": "Signer holds the signing information used to automatically sign serving certificates. If this value is nil, then certs are not signed automatically.",
}

func (ServiceServingCert) SwaggerDoc() map[string]string {
	return map_ServiceServingCert
}

var map_ServingInfo = map[string]string{
	"":                  "ServingInfo holds information about serving web pages",
	"bindAddress":       "BindAddress is the ip:port to serve on",
	"bindNetwork":       "BindNetwork is the type of network to bind to - defaults to \"tcp4\", accepts \"tcp\", \"tcp4\", and \"tcp6\"",
	"clientCA":          "ClientCA is the certificate bundle for all the signers that you'll recognize for incoming client certificates",
	"namedCertificates": "NamedCertificates is a list of certificates to use to secure requests to specific hostnames",
}

func (ServingInfo) SwaggerDoc() map[string]string {
	return map_ServingInfo
}

var map_SessionConfig = map[string]string{
	"":                     "SessionConfig specifies options for cookie-based sessions. Used by AuthRequestHandlerSession",
	"sessionSecretsFile":   "SessionSecretsFile is a reference to a file containing a serialized SessionSecrets object If no file is specified, a random signing and encryption key are generated at each server start",
	"sessionMaxAgeSeconds": "SessionMaxAgeSeconds specifies how long created sessions last. Used by AuthRequestHandlerSession",
	"sessionName":          "SessionName is the cookie name used to store the session",
}

func (SessionConfig) SwaggerDoc() map[string]string {
	return map_SessionConfig
}

var map_SessionSecret = map[string]string{
	"":               "SessionSecret is a secret used to authenticate/decrypt cookie-based sessions",
	"authentication": "Authentication is used to authenticate sessions using HMAC. Recommended to use a secret with 32 or 64 bytes.",
	"encryption":     "Encryption is used to encrypt sessions. Must be 16, 24, or 32 characters long, to select AES-128, AES-",
}

func (SessionSecret) SwaggerDoc() map[string]string {
	return map_SessionSecret
}

var map_SessionSecrets = map[string]string{
	"":        "SessionSecrets list the secrets to use to sign/encrypt and authenticate/decrypt created sessions.",
	"secrets": "Secrets is a list of secrets New sessions are signed and encrypted using the first secret. Existing sessions are decrypted/authenticated by each secret until one succeeds. This allows rotating secrets.",
}

func (SessionSecrets) SwaggerDoc() map[string]string {
	return map_SessionSecrets
}

var map_StringSource = map[string]string{
	"": "StringSource allows specifying a string inline, or externally via env var or file. When it contains only a string value, it marshals to a simple JSON string.",
}

func (StringSource) SwaggerDoc() map[string]string {
	return map_StringSource
}

var map_StringSourceSpec = map[string]string{
	"":        "StringSourceSpec specifies a string value, or external location",
	"value":   "Value specifies the cleartext value, or an encrypted value if keyFile is specified.",
	"env":     "Env specifies an envvar containing the cleartext value, or an encrypted value if the keyFile is specified.",
	"file":    "File references a file containing the cleartext value, or an encrypted value if a keyFile is specified.",
	"keyFile": "KeyFile references a file containing the key to use to decrypt the value.",
}

func (StringSourceSpec) SwaggerDoc() map[string]string {
	return map_StringSourceSpec
}

var map_TokenConfig = map[string]string{
	"": "TokenConfig holds the necessary configuration options for authorization and access tokens",
	"authorizeTokenMaxAgeSeconds": "AuthorizeTokenMaxAgeSeconds defines the maximum age of authorize tokens",
	"accessTokenMaxAgeSeconds":    "AccessTokenMaxAgeSeconds defines the maximum age of access tokens",
}

func (TokenConfig) SwaggerDoc() map[string]string {
	return map_TokenConfig
}

var map_UserAgentDenyRule = map[string]string{
	"":                 "UserAgentDenyRule adds a rejection message that can be used to help a user figure out how to get an approved client",
	"rejectionMessage": "RejectionMessage is the message shown when rejecting a client.  If it is not a set, the default message is used.",
}

func (UserAgentDenyRule) SwaggerDoc() map[string]string {
	return map_UserAgentDenyRule
}

var map_UserAgentMatchRule = map[string]string{
	"":          "UserAgentMatchRule describes how to match a given request based on User-Agent and HTTPVerb",
	"regex":     "UserAgentRegex is a regex that is checked against the User-Agent. Known variants of oc clients 1. oc accessing kube resources: oc/v1.2.0 (linux/amd64) kubernetes/bc4550d 2. oc accessing openshift resources: oc/v1.1.3 (linux/amd64) openshift/b348c2f 3. openshift kubectl accessing kube resources:  openshift/v1.2.0 (linux/amd64) kubernetes/bc4550d 4. openshit kubectl accessing openshift resources: openshift/v1.1.3 (linux/amd64) openshift/b348c2f 5. oadm accessing kube resources: oadm/v1.2.0 (linux/amd64) kubernetes/bc4550d 6. oadm accessing openshift resources: oadm/v1.1.3 (linux/amd64) openshift/b348c2f 7. openshift cli accessing kube resources: openshift/v1.2.0 (linux/amd64) kubernetes/bc4550d 8. openshift cli accessing openshift resources: openshift/v1.1.3 (linux/amd64) openshift/b348c2f",
	"httpVerbs": "HTTPVerbs specifies which HTTP verbs should be matched.  An empty list means \"match all verbs\".",
}

func (UserAgentMatchRule) SwaggerDoc() map[string]string {
	return map_UserAgentMatchRule
}

var map_UserAgentMatchingConfig = map[string]string{
	"":                        "UserAgentMatchingConfig controls how API calls from *voluntarily* identifying clients will be handled.  THIS DOES NOT DEFEND AGAINST MALICIOUS CLIENTS!",
	"requiredClients":         "If this list is non-empty, then a User-Agent must match one of the UserAgentRegexes to be allowed",
	"deniedClients":           "If this list is non-empty, then a User-Agent must not match any of the UserAgentRegexes",
	"defaultRejectionMessage": "DefaultRejectionMessage is the message shown when rejecting a client.  If it is not a set, a generic message is given.",
}

func (UserAgentMatchingConfig) SwaggerDoc() map[string]string {
	return map_UserAgentMatchingConfig
}
