// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	build_api "github.com/openshift/origin/pkg/build/api"
	api "k8s.io/kubernetes/pkg/api"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	conversion "k8s.io/kubernetes/pkg/conversion"
	time "time"
)

func init() {
	if err := api.Scheme.AddGeneratedConversionFuncs(
		Convert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions,
		Convert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions,
		Convert_v1_BinaryBuildSource_To_api_BinaryBuildSource,
		Convert_api_BinaryBuildSource_To_v1_BinaryBuildSource,
		Convert_v1_Build_To_api_Build,
		Convert_api_Build_To_v1_Build,
		Convert_v1_BuildConfig_To_api_BuildConfig,
		Convert_api_BuildConfig_To_v1_BuildConfig,
		Convert_v1_BuildConfigList_To_api_BuildConfigList,
		Convert_api_BuildConfigList_To_v1_BuildConfigList,
		Convert_v1_BuildConfigSpec_To_api_BuildConfigSpec,
		Convert_api_BuildConfigSpec_To_v1_BuildConfigSpec,
		Convert_v1_BuildConfigStatus_To_api_BuildConfigStatus,
		Convert_api_BuildConfigStatus_To_v1_BuildConfigStatus,
		Convert_v1_BuildList_To_api_BuildList,
		Convert_api_BuildList_To_v1_BuildList,
		Convert_v1_BuildLog_To_api_BuildLog,
		Convert_api_BuildLog_To_v1_BuildLog,
		Convert_v1_BuildLogOptions_To_api_BuildLogOptions,
		Convert_api_BuildLogOptions_To_v1_BuildLogOptions,
		Convert_v1_BuildOutput_To_api_BuildOutput,
		Convert_api_BuildOutput_To_v1_BuildOutput,
		Convert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec,
		Convert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec,
		Convert_v1_BuildRequest_To_api_BuildRequest,
		Convert_api_BuildRequest_To_v1_BuildRequest,
		Convert_v1_BuildSource_To_api_BuildSource,
		Convert_api_BuildSource_To_v1_BuildSource,
		Convert_v1_BuildSpec_To_api_BuildSpec,
		Convert_api_BuildSpec_To_v1_BuildSpec,
		Convert_v1_BuildStatus_To_api_BuildStatus,
		Convert_api_BuildStatus_To_v1_BuildStatus,
		Convert_v1_BuildStrategy_To_api_BuildStrategy,
		Convert_api_BuildStrategy_To_v1_BuildStrategy,
		Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause,
		Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause,
		Convert_v1_BuildTriggerPolicy_To_api_BuildTriggerPolicy,
		Convert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy,
		Convert_v1_CommonSpec_To_api_CommonSpec,
		Convert_api_CommonSpec_To_v1_CommonSpec,
		Convert_v1_CustomBuildStrategy_To_api_CustomBuildStrategy,
		Convert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy,
		Convert_v1_DockerBuildStrategy_To_api_DockerBuildStrategy,
		Convert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy,
		Convert_v1_GenericWebHookCause_To_api_GenericWebHookCause,
		Convert_api_GenericWebHookCause_To_v1_GenericWebHookCause,
		Convert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent,
		Convert_v1_GitBuildSource_To_api_GitBuildSource,
		Convert_api_GitBuildSource_To_v1_GitBuildSource,
		Convert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause,
		Convert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause,
		Convert_v1_GitInfo_To_api_GitInfo,
		Convert_v1_GitSourceRevision_To_api_GitSourceRevision,
		Convert_api_GitSourceRevision_To_v1_GitSourceRevision,
		Convert_v1_ImageChangeCause_To_api_ImageChangeCause,
		Convert_api_ImageChangeCause_To_v1_ImageChangeCause,
		Convert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger,
		Convert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger,
		Convert_v1_ImageSource_To_api_ImageSource,
		Convert_api_ImageSource_To_v1_ImageSource,
		Convert_v1_ImageSourcePath_To_api_ImageSourcePath,
		Convert_api_ImageSourcePath_To_v1_ImageSourcePath,
		Convert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy,
		Convert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy,
		Convert_v1_SecretBuildSource_To_api_SecretBuildSource,
		Convert_api_SecretBuildSource_To_v1_SecretBuildSource,
		Convert_v1_SecretSpec_To_api_SecretSpec,
		Convert_api_SecretSpec_To_v1_SecretSpec,
		Convert_v1_SourceBuildStrategy_To_api_SourceBuildStrategy,
		Convert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy,
		Convert_v1_SourceControlUser_To_api_SourceControlUser,
		Convert_api_SourceControlUser_To_v1_SourceControlUser,
		Convert_v1_SourceRevision_To_api_SourceRevision,
		Convert_api_SourceRevision_To_v1_SourceRevision,
		Convert_v1_WebHookTrigger_To_api_WebHookTrigger,
		Convert_api_WebHookTrigger_To_v1_WebHookTrigger,
	); err != nil {
		// if one of the conversion functions is malformed, detect it immediately.
		panic(err)
	}
}

func autoConvert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions(in *BinaryBuildRequestOptions, out *build_api.BinaryBuildRequestOptions, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

func Convert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions(in *BinaryBuildRequestOptions, out *build_api.BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *build_api.BinaryBuildRequestOptions, out *BinaryBuildRequestOptions, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

func Convert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *build_api.BinaryBuildRequestOptions, out *BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_v1_BinaryBuildSource_To_api_BinaryBuildSource(in *BinaryBuildSource, out *build_api.BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

func Convert_v1_BinaryBuildSource_To_api_BinaryBuildSource(in *BinaryBuildSource, out *build_api.BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildSource_To_api_BinaryBuildSource(in, out, s)
}

func autoConvert_api_BinaryBuildSource_To_v1_BinaryBuildSource(in *build_api.BinaryBuildSource, out *BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

func Convert_api_BinaryBuildSource_To_v1_BinaryBuildSource(in *build_api.BinaryBuildSource, out *BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_api_BinaryBuildSource_To_v1_BinaryBuildSource(in, out, s)
}

func autoConvert_v1_Build_To_api_Build(in *Build, out *build_api.Build, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildSpec_To_api_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildStatus_To_api_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_Build_To_api_Build(in *Build, out *build_api.Build, s conversion.Scope) error {
	return autoConvert_v1_Build_To_api_Build(in, out, s)
}

func autoConvert_api_Build_To_v1_Build(in *build_api.Build, out *Build, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_BuildSpec_To_v1_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_BuildStatus_To_v1_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_Build_To_v1_Build(in *build_api.Build, out *Build, s conversion.Scope) error {
	return autoConvert_api_Build_To_v1_Build(in, out, s)
}

func autoConvert_v1_BuildConfig_To_api_BuildConfig(in *BuildConfig, out *build_api.BuildConfig, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildConfigSpec_To_api_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildConfigStatus_To_api_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_BuildConfig_To_v1_BuildConfig(in *build_api.BuildConfig, out *BuildConfig, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_BuildConfigSpec_To_v1_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_BuildConfigStatus_To_v1_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_BuildConfig_To_v1_BuildConfig(in *build_api.BuildConfig, out *BuildConfig, s conversion.Scope) error {
	return autoConvert_api_BuildConfig_To_v1_BuildConfig(in, out, s)
}

func autoConvert_v1_BuildConfigList_To_api_BuildConfigList(in *BuildConfigList, out *build_api.BuildConfigList, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]build_api.BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildConfig_To_api_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_BuildConfigList_To_api_BuildConfigList(in *BuildConfigList, out *build_api.BuildConfigList, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigList_To_api_BuildConfigList(in, out, s)
}

func autoConvert_api_BuildConfigList_To_v1_BuildConfigList(in *build_api.BuildConfigList, out *BuildConfigList, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_api_BuildConfig_To_v1_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_BuildConfigList_To_v1_BuildConfigList(in *build_api.BuildConfigList, out *BuildConfigList, s conversion.Scope) error {
	return autoConvert_api_BuildConfigList_To_v1_BuildConfigList(in, out, s)
}

func autoConvert_v1_BuildConfigSpec_To_api_BuildConfigSpec(in *BuildConfigSpec, out *build_api.BuildConfigSpec, s conversion.Scope) error {
	SetDefaults_BuildConfigSpec(in)
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]build_api.BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerPolicy_To_api_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.RunPolicy = build_api.BuildRunPolicy(in.RunPolicy)
	if err := Convert_v1_CommonSpec_To_api_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_BuildConfigSpec_To_api_BuildConfigSpec(in *BuildConfigSpec, out *build_api.BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigSpec_To_api_BuildConfigSpec(in, out, s)
}

func autoConvert_api_BuildConfigSpec_To_v1_BuildConfigSpec(in *build_api.BuildConfigSpec, out *BuildConfigSpec, s conversion.Scope) error {
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.RunPolicy = BuildRunPolicy(in.RunPolicy)
	if err := Convert_api_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_BuildConfigSpec_To_v1_BuildConfigSpec(in *build_api.BuildConfigSpec, out *BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_api_BuildConfigSpec_To_v1_BuildConfigSpec(in, out, s)
}

func autoConvert_v1_BuildConfigStatus_To_api_BuildConfigStatus(in *BuildConfigStatus, out *build_api.BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

func Convert_v1_BuildConfigStatus_To_api_BuildConfigStatus(in *BuildConfigStatus, out *build_api.BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigStatus_To_api_BuildConfigStatus(in, out, s)
}

func autoConvert_api_BuildConfigStatus_To_v1_BuildConfigStatus(in *build_api.BuildConfigStatus, out *BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

func Convert_api_BuildConfigStatus_To_v1_BuildConfigStatus(in *build_api.BuildConfigStatus, out *BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_api_BuildConfigStatus_To_v1_BuildConfigStatus(in, out, s)
}

func autoConvert_v1_BuildList_To_api_BuildList(in *BuildList, out *build_api.BuildList, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]build_api.Build, len(*in))
		for i := range *in {
			if err := Convert_v1_Build_To_api_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_BuildList_To_api_BuildList(in *BuildList, out *build_api.BuildList, s conversion.Scope) error {
	return autoConvert_v1_BuildList_To_api_BuildList(in, out, s)
}

func autoConvert_api_BuildList_To_v1_BuildList(in *build_api.BuildList, out *BuildList, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Build, len(*in))
		for i := range *in {
			if err := Convert_api_Build_To_v1_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_BuildList_To_v1_BuildList(in *build_api.BuildList, out *BuildList, s conversion.Scope) error {
	return autoConvert_api_BuildList_To_v1_BuildList(in, out, s)
}

func autoConvert_v1_BuildLog_To_api_BuildLog(in *BuildLog, out *build_api.BuildLog, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_BuildLog_To_api_BuildLog(in *BuildLog, out *build_api.BuildLog, s conversion.Scope) error {
	return autoConvert_v1_BuildLog_To_api_BuildLog(in, out, s)
}

func autoConvert_api_BuildLog_To_v1_BuildLog(in *build_api.BuildLog, out *BuildLog, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_BuildLog_To_v1_BuildLog(in *build_api.BuildLog, out *BuildLog, s conversion.Scope) error {
	return autoConvert_api_BuildLog_To_v1_BuildLog(in, out, s)
}

func autoConvert_v1_BuildLogOptions_To_api_BuildLogOptions(in *BuildLogOptions, out *build_api.BuildLogOptions, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = in.SinceSeconds
	out.SinceTime = in.SinceTime
	out.Timestamps = in.Timestamps
	out.TailLines = in.TailLines
	out.LimitBytes = in.LimitBytes
	out.NoWait = in.NoWait
	out.Version = in.Version
	return nil
}

func Convert_v1_BuildLogOptions_To_api_BuildLogOptions(in *BuildLogOptions, out *build_api.BuildLogOptions, s conversion.Scope) error {
	return autoConvert_v1_BuildLogOptions_To_api_BuildLogOptions(in, out, s)
}

func autoConvert_api_BuildLogOptions_To_v1_BuildLogOptions(in *build_api.BuildLogOptions, out *BuildLogOptions, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = in.SinceSeconds
	out.SinceTime = in.SinceTime
	out.Timestamps = in.Timestamps
	out.TailLines = in.TailLines
	out.LimitBytes = in.LimitBytes
	out.NoWait = in.NoWait
	out.Version = in.Version
	return nil
}

func Convert_api_BuildLogOptions_To_v1_BuildLogOptions(in *build_api.BuildLogOptions, out *BuildLogOptions, s conversion.Scope) error {
	return autoConvert_api_BuildLogOptions_To_v1_BuildLogOptions(in, out, s)
}

func autoConvert_v1_BuildOutput_To_api_BuildOutput(in *BuildOutput, out *build_api.BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	return nil
}

func autoConvert_api_BuildOutput_To_v1_BuildOutput(in *build_api.BuildOutput, out *BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	return nil
}

func Convert_api_BuildOutput_To_v1_BuildOutput(in *build_api.BuildOutput, out *BuildOutput, s conversion.Scope) error {
	return autoConvert_api_BuildOutput_To_v1_BuildOutput(in, out, s)
}

func autoConvert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(in *BuildPostCommitSpec, out *build_api.BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = in.Command
	out.Args = in.Args
	out.Script = in.Script
	return nil
}

func Convert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(in *BuildPostCommitSpec, out *build_api.BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(in, out, s)
}

func autoConvert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *build_api.BuildPostCommitSpec, out *BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = in.Command
	out.Args = in.Args
	out.Script = in.Script
	return nil
}

func Convert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *build_api.BuildPostCommitSpec, out *BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in, out, s)
}

func autoConvert_v1_BuildRequest_To_api_BuildRequest(in *BuildRequest, out *build_api.BuildRequest, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build_api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.Binary != nil {
		in, out := &in.Binary, &out.Binary
		*out = new(build_api.BinaryBuildSource)
		if err := Convert_v1_BinaryBuildSource_To_api_BinaryBuildSource(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Binary = nil
	}
	out.LastVersion = in.LastVersion
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]build_api.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_v1_BuildRequest_To_api_BuildRequest(in *BuildRequest, out *build_api.BuildRequest, s conversion.Scope) error {
	return autoConvert_v1_BuildRequest_To_api_BuildRequest(in, out, s)
}

func autoConvert_api_BuildRequest_To_v1_BuildRequest(in *build_api.BuildRequest, out *BuildRequest, s conversion.Scope) error {
	if err := api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.Binary != nil {
		in, out := &in.Binary, &out.Binary
		*out = new(BinaryBuildSource)
		if err := Convert_api_BinaryBuildSource_To_v1_BinaryBuildSource(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Binary = nil
	}
	out.LastVersion = in.LastVersion
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_api_BuildRequest_To_v1_BuildRequest(in *build_api.BuildRequest, out *BuildRequest, s conversion.Scope) error {
	return autoConvert_api_BuildRequest_To_v1_BuildRequest(in, out, s)
}

func autoConvert_v1_BuildSource_To_api_BuildSource(in *BuildSource, out *build_api.BuildSource, s conversion.Scope) error {
	SetDefaults_BuildSource(in)
	if in.Binary != nil {
		in, out := &in.Binary, &out.Binary
		*out = new(build_api.BinaryBuildSource)
		if err := Convert_v1_BinaryBuildSource_To_api_BinaryBuildSource(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Binary = nil
	}
	out.Dockerfile = in.Dockerfile
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(build_api.GitBuildSource)
		if err := Convert_v1_GitBuildSource_To_api_GitBuildSource(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]build_api.ImageSource, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageSource_To_api_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]build_api.SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretBuildSource_To_api_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	return nil
}

func Convert_v1_BuildSource_To_api_BuildSource(in *BuildSource, out *build_api.BuildSource, s conversion.Scope) error {
	return autoConvert_v1_BuildSource_To_api_BuildSource(in, out, s)
}

func autoConvert_api_BuildSource_To_v1_BuildSource(in *build_api.BuildSource, out *BuildSource, s conversion.Scope) error {
	if in.Binary != nil {
		in, out := &in.Binary, &out.Binary
		*out = new(BinaryBuildSource)
		if err := Convert_api_BinaryBuildSource_To_v1_BinaryBuildSource(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Binary = nil
	}
	out.Dockerfile = in.Dockerfile
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(GitBuildSource)
		if err := Convert_api_GitBuildSource_To_v1_GitBuildSource(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageSource, len(*in))
		for i := range *in {
			if err := Convert_api_ImageSource_To_v1_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_api_SecretBuildSource_To_v1_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	return nil
}

func autoConvert_v1_BuildSpec_To_api_BuildSpec(in *BuildSpec, out *build_api.BuildSpec, s conversion.Scope) error {
	if err := Convert_v1_CommonSpec_To_api_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]build_api.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_v1_BuildSpec_To_api_BuildSpec(in *BuildSpec, out *build_api.BuildSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildSpec_To_api_BuildSpec(in, out, s)
}

func autoConvert_api_BuildSpec_To_v1_BuildSpec(in *build_api.BuildSpec, out *BuildSpec, s conversion.Scope) error {
	if err := Convert_api_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_api_BuildSpec_To_v1_BuildSpec(in *build_api.BuildSpec, out *BuildSpec, s conversion.Scope) error {
	return autoConvert_api_BuildSpec_To_v1_BuildSpec(in, out, s)
}

func autoConvert_v1_BuildStatus_To_api_BuildStatus(in *BuildStatus, out *build_api.BuildStatus, s conversion.Scope) error {
	out.Phase = build_api.BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = build_api.StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = in.StartTimestamp
	out.CompletionTimestamp = in.CompletionTimestamp
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	return nil
}

func Convert_v1_BuildStatus_To_api_BuildStatus(in *BuildStatus, out *build_api.BuildStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildStatus_To_api_BuildStatus(in, out, s)
}

func autoConvert_api_BuildStatus_To_v1_BuildStatus(in *build_api.BuildStatus, out *BuildStatus, s conversion.Scope) error {
	out.Phase = BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = in.StartTimestamp
	out.CompletionTimestamp = in.CompletionTimestamp
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	return nil
}

func Convert_api_BuildStatus_To_v1_BuildStatus(in *build_api.BuildStatus, out *BuildStatus, s conversion.Scope) error {
	return autoConvert_api_BuildStatus_To_v1_BuildStatus(in, out, s)
}

func autoConvert_v1_BuildStrategy_To_api_BuildStrategy(in *BuildStrategy, out *build_api.BuildStrategy, s conversion.Scope) error {
	SetDefaults_BuildStrategy(in)
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(build_api.DockerBuildStrategy)
		if err := Convert_v1_DockerBuildStrategy_To_api_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(build_api.SourceBuildStrategy)
		if err := Convert_v1_SourceBuildStrategy_To_api_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(build_api.CustomBuildStrategy)
		if err := Convert_v1_CustomBuildStrategy_To_api_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	if in.JenkinsPipelineStrategy != nil {
		in, out := &in.JenkinsPipelineStrategy, &out.JenkinsPipelineStrategy
		*out = new(build_api.JenkinsPipelineBuildStrategy)
		if err := Convert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JenkinsPipelineStrategy = nil
	}
	return nil
}

func Convert_v1_BuildStrategy_To_api_BuildStrategy(in *BuildStrategy, out *build_api.BuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_BuildStrategy_To_api_BuildStrategy(in, out, s)
}

func autoConvert_api_BuildStrategy_To_v1_BuildStrategy(in *build_api.BuildStrategy, out *BuildStrategy, s conversion.Scope) error {
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(DockerBuildStrategy)
		if err := Convert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(SourceBuildStrategy)
		if err := Convert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(CustomBuildStrategy)
		if err := Convert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	if in.JenkinsPipelineStrategy != nil {
		in, out := &in.JenkinsPipelineStrategy, &out.JenkinsPipelineStrategy
		*out = new(JenkinsPipelineBuildStrategy)
		if err := Convert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JenkinsPipelineStrategy = nil
	}
	return nil
}

func autoConvert_v1_BuildTriggerCause_To_api_BuildTriggerCause(in *BuildTriggerCause, out *build_api.BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(build_api.GenericWebHookCause)
		if err := Convert_v1_GenericWebHookCause_To_api_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(build_api.GitHubWebHookCause)
		if err := Convert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(build_api.ImageChangeCause)
		if err := Convert_v1_ImageChangeCause_To_api_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	return nil
}

func Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause(in *BuildTriggerCause, out *build_api.BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_v1_BuildTriggerCause_To_api_BuildTriggerCause(in, out, s)
}

func autoConvert_api_BuildTriggerCause_To_v1_BuildTriggerCause(in *build_api.BuildTriggerCause, out *BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(GenericWebHookCause)
		if err := Convert_api_GenericWebHookCause_To_v1_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(GitHubWebHookCause)
		if err := Convert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(ImageChangeCause)
		if err := Convert_api_ImageChangeCause_To_v1_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	return nil
}

func Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause(in *build_api.BuildTriggerCause, out *BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_api_BuildTriggerCause_To_v1_BuildTriggerCause(in, out, s)
}

func autoConvert_v1_BuildTriggerPolicy_To_api_BuildTriggerPolicy(in *BuildTriggerPolicy, out *build_api.BuildTriggerPolicy, s conversion.Scope) error {
	SetDefaults_BuildTriggerPolicy(in)
	out.Type = build_api.BuildTriggerType(in.Type)
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(build_api.WebHookTrigger)
		if err := Convert_v1_WebHookTrigger_To_api_WebHookTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(build_api.WebHookTrigger)
		if err := Convert_v1_WebHookTrigger_To_api_WebHookTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(build_api.ImageChangeTrigger)
		if err := Convert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	return nil
}

func autoConvert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *build_api.BuildTriggerPolicy, out *BuildTriggerPolicy, s conversion.Scope) error {
	out.Type = BuildTriggerType(in.Type)
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(WebHookTrigger)
		if err := Convert_api_WebHookTrigger_To_v1_WebHookTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(WebHookTrigger)
		if err := Convert_api_WebHookTrigger_To_v1_WebHookTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(ImageChangeTrigger)
		if err := Convert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	return nil
}

func Convert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *build_api.BuildTriggerPolicy, out *BuildTriggerPolicy, s conversion.Scope) error {
	return autoConvert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in, out, s)
}

func autoConvert_v1_CommonSpec_To_api_CommonSpec(in *CommonSpec, out *build_api.CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_v1_BuildSource_To_api_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build_api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_v1_BuildStrategy_To_api_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildOutput_To_api_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ResourceRequirements_To_api_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = in.CompletionDeadlineSeconds
	return nil
}

func Convert_v1_CommonSpec_To_api_CommonSpec(in *CommonSpec, out *build_api.CommonSpec, s conversion.Scope) error {
	return autoConvert_v1_CommonSpec_To_api_CommonSpec(in, out, s)
}

func autoConvert_api_CommonSpec_To_v1_CommonSpec(in *build_api.CommonSpec, out *CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_api_BuildSource_To_v1_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_api_BuildStrategy_To_v1_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_api_BuildOutput_To_v1_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ResourceRequirements_To_v1_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = in.CompletionDeadlineSeconds
	return nil
}

func Convert_api_CommonSpec_To_v1_CommonSpec(in *build_api.CommonSpec, out *CommonSpec, s conversion.Scope) error {
	return autoConvert_api_CommonSpec_To_v1_CommonSpec(in, out, s)
}

func autoConvert_v1_CustomBuildStrategy_To_api_CustomBuildStrategy(in *CustomBuildStrategy, out *build_api.CustomBuildStrategy, s conversion.Scope) error {
	SetDefaults_CustomBuildStrategy(in)
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]build_api.SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretSpec_To_api_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

func autoConvert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *build_api.CustomBuildStrategy, out *CustomBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_api_SecretSpec_To_v1_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

func Convert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *build_api.CustomBuildStrategy, out *CustomBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(in, out, s)
}

func autoConvert_v1_DockerBuildStrategy_To_api_DockerBuildStrategy(in *DockerBuildStrategy, out *build_api.DockerBuildStrategy, s conversion.Scope) error {
	SetDefaults_DockerBuildStrategy(in)
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	return nil
}

func autoConvert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *build_api.DockerBuildStrategy, out *DockerBuildStrategy, s conversion.Scope) error {
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	return nil
}

func Convert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *build_api.DockerBuildStrategy, out *DockerBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(in, out, s)
}

func autoConvert_v1_GenericWebHookCause_To_api_GenericWebHookCause(in *GenericWebHookCause, out *build_api.GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build_api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_v1_GenericWebHookCause_To_api_GenericWebHookCause(in *GenericWebHookCause, out *build_api.GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookCause_To_api_GenericWebHookCause(in, out, s)
}

func autoConvert_api_GenericWebHookCause_To_v1_GenericWebHookCause(in *build_api.GenericWebHookCause, out *GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_api_GenericWebHookCause_To_v1_GenericWebHookCause(in *build_api.GenericWebHookCause, out *GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_api_GenericWebHookCause_To_v1_GenericWebHookCause(in, out, s)
}

func autoConvert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent(in *GenericWebHookEvent, out *build_api.GenericWebHookEvent, s conversion.Scope) error {
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(build_api.GitInfo)
		if err := Convert_v1_GitInfo_To_api_GitInfo(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	return nil
}

func Convert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent(in *GenericWebHookEvent, out *build_api.GenericWebHookEvent, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent(in, out, s)
}

func autoConvert_v1_GitBuildSource_To_api_GitBuildSource(in *GitBuildSource, out *build_api.GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	out.HTTPProxy = in.HTTPProxy
	out.HTTPSProxy = in.HTTPSProxy
	return nil
}

func Convert_v1_GitBuildSource_To_api_GitBuildSource(in *GitBuildSource, out *build_api.GitBuildSource, s conversion.Scope) error {
	return autoConvert_v1_GitBuildSource_To_api_GitBuildSource(in, out, s)
}

func autoConvert_api_GitBuildSource_To_v1_GitBuildSource(in *build_api.GitBuildSource, out *GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	out.HTTPProxy = in.HTTPProxy
	out.HTTPSProxy = in.HTTPSProxy
	return nil
}

func Convert_api_GitBuildSource_To_v1_GitBuildSource(in *build_api.GitBuildSource, out *GitBuildSource, s conversion.Scope) error {
	return autoConvert_api_GitBuildSource_To_v1_GitBuildSource(in, out, s)
}

func autoConvert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(in *GitHubWebHookCause, out *build_api.GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build_api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(in *GitHubWebHookCause, out *build_api.GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(in, out, s)
}

func autoConvert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *build_api.GitHubWebHookCause, out *GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *build_api.GitHubWebHookCause, out *GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(in, out, s)
}

func autoConvert_v1_GitInfo_To_api_GitInfo(in *GitInfo, out *build_api.GitInfo, s conversion.Scope) error {
	if err := Convert_v1_GitBuildSource_To_api_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_v1_GitSourceRevision_To_api_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_GitInfo_To_api_GitInfo(in *GitInfo, out *build_api.GitInfo, s conversion.Scope) error {
	return autoConvert_v1_GitInfo_To_api_GitInfo(in, out, s)
}

func autoConvert_v1_GitSourceRevision_To_api_GitSourceRevision(in *GitSourceRevision, out *build_api.GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_v1_SourceControlUser_To_api_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_v1_SourceControlUser_To_api_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

func Convert_v1_GitSourceRevision_To_api_GitSourceRevision(in *GitSourceRevision, out *build_api.GitSourceRevision, s conversion.Scope) error {
	return autoConvert_v1_GitSourceRevision_To_api_GitSourceRevision(in, out, s)
}

func autoConvert_api_GitSourceRevision_To_v1_GitSourceRevision(in *build_api.GitSourceRevision, out *GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_api_SourceControlUser_To_v1_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_api_SourceControlUser_To_v1_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

func Convert_api_GitSourceRevision_To_v1_GitSourceRevision(in *build_api.GitSourceRevision, out *GitSourceRevision, s conversion.Scope) error {
	return autoConvert_api_GitSourceRevision_To_v1_GitSourceRevision(in, out, s)
}

func autoConvert_v1_ImageChangeCause_To_api_ImageChangeCause(in *ImageChangeCause, out *build_api.ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

func Convert_v1_ImageChangeCause_To_api_ImageChangeCause(in *ImageChangeCause, out *build_api.ImageChangeCause, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeCause_To_api_ImageChangeCause(in, out, s)
}

func autoConvert_api_ImageChangeCause_To_v1_ImageChangeCause(in *build_api.ImageChangeCause, out *ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

func Convert_api_ImageChangeCause_To_v1_ImageChangeCause(in *build_api.ImageChangeCause, out *ImageChangeCause, s conversion.Scope) error {
	return autoConvert_api_ImageChangeCause_To_v1_ImageChangeCause(in, out, s)
}

func autoConvert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(in *ImageChangeTrigger, out *build_api.ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	return nil
}

func Convert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(in *ImageChangeTrigger, out *build_api.ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(in, out, s)
}

func autoConvert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *build_api.ImageChangeTrigger, out *ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	return nil
}

func Convert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *build_api.ImageChangeTrigger, out *ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(in, out, s)
}

func autoConvert_v1_ImageSource_To_api_ImageSource(in *ImageSource, out *build_api.ImageSource, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.Paths != nil {
		in, out := &in.Paths, &out.Paths
		*out = make([]build_api.ImageSourcePath, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageSourcePath_To_api_ImageSourcePath(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Paths = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

func Convert_v1_ImageSource_To_api_ImageSource(in *ImageSource, out *build_api.ImageSource, s conversion.Scope) error {
	return autoConvert_v1_ImageSource_To_api_ImageSource(in, out, s)
}

func autoConvert_api_ImageSource_To_v1_ImageSource(in *build_api.ImageSource, out *ImageSource, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.Paths != nil {
		in, out := &in.Paths, &out.Paths
		*out = make([]ImageSourcePath, len(*in))
		for i := range *in {
			if err := Convert_api_ImageSourcePath_To_v1_ImageSourcePath(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Paths = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

func Convert_api_ImageSource_To_v1_ImageSource(in *build_api.ImageSource, out *ImageSource, s conversion.Scope) error {
	return autoConvert_api_ImageSource_To_v1_ImageSource(in, out, s)
}

func autoConvert_v1_ImageSourcePath_To_api_ImageSourcePath(in *ImageSourcePath, out *build_api.ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_v1_ImageSourcePath_To_api_ImageSourcePath(in *ImageSourcePath, out *build_api.ImageSourcePath, s conversion.Scope) error {
	return autoConvert_v1_ImageSourcePath_To_api_ImageSourcePath(in, out, s)
}

func autoConvert_api_ImageSourcePath_To_v1_ImageSourcePath(in *build_api.ImageSourcePath, out *ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_api_ImageSourcePath_To_v1_ImageSourcePath(in *build_api.ImageSourcePath, out *ImageSourcePath, s conversion.Scope) error {
	return autoConvert_api_ImageSourcePath_To_v1_ImageSourcePath(in, out, s)
}

func autoConvert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy(in *JenkinsPipelineBuildStrategy, out *build_api.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	return nil
}

func Convert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy(in *JenkinsPipelineBuildStrategy, out *build_api.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *build_api.JenkinsPipelineBuildStrategy, out *JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	return nil
}

func Convert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *build_api.JenkinsPipelineBuildStrategy, out *JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_v1_SecretBuildSource_To_api_SecretBuildSource(in *SecretBuildSource, out *build_api.SecretBuildSource, s conversion.Scope) error {
	if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_v1_SecretBuildSource_To_api_SecretBuildSource(in *SecretBuildSource, out *build_api.SecretBuildSource, s conversion.Scope) error {
	return autoConvert_v1_SecretBuildSource_To_api_SecretBuildSource(in, out, s)
}

func autoConvert_api_SecretBuildSource_To_v1_SecretBuildSource(in *build_api.SecretBuildSource, out *SecretBuildSource, s conversion.Scope) error {
	if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_api_SecretBuildSource_To_v1_SecretBuildSource(in *build_api.SecretBuildSource, out *SecretBuildSource, s conversion.Scope) error {
	return autoConvert_api_SecretBuildSource_To_v1_SecretBuildSource(in, out, s)
}

func autoConvert_v1_SecretSpec_To_api_SecretSpec(in *SecretSpec, out *build_api.SecretSpec, s conversion.Scope) error {
	if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

func Convert_v1_SecretSpec_To_api_SecretSpec(in *SecretSpec, out *build_api.SecretSpec, s conversion.Scope) error {
	return autoConvert_v1_SecretSpec_To_api_SecretSpec(in, out, s)
}

func autoConvert_api_SecretSpec_To_v1_SecretSpec(in *build_api.SecretSpec, out *SecretSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

func Convert_api_SecretSpec_To_v1_SecretSpec(in *build_api.SecretSpec, out *SecretSpec, s conversion.Scope) error {
	return autoConvert_api_SecretSpec_To_v1_SecretSpec(in, out, s)
}

func autoConvert_v1_SourceBuildStrategy_To_api_SourceBuildStrategy(in *SourceBuildStrategy, out *build_api.SourceBuildStrategy, s conversion.Scope) error {
	SetDefaults_SourceBuildStrategy(in)
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = in.Incremental
	out.ForcePull = in.ForcePull
	if in.RuntimeImage != nil {
		in, out := &in.RuntimeImage, &out.RuntimeImage
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RuntimeImage = nil
	}
	if in.RuntimeArtifacts != nil {
		in, out := &in.RuntimeArtifacts, &out.RuntimeArtifacts
		*out = make([]build_api.ImageSourcePath, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageSourcePath_To_api_ImageSourcePath(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.RuntimeArtifacts = nil
	}
	return nil
}

func autoConvert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *build_api.SourceBuildStrategy, out *SourceBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = in.Incremental
	out.ForcePull = in.ForcePull
	if in.RuntimeImage != nil {
		in, out := &in.RuntimeImage, &out.RuntimeImage
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RuntimeImage = nil
	}
	if in.RuntimeArtifacts != nil {
		in, out := &in.RuntimeArtifacts, &out.RuntimeArtifacts
		*out = make([]ImageSourcePath, len(*in))
		for i := range *in {
			if err := Convert_api_ImageSourcePath_To_v1_ImageSourcePath(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.RuntimeArtifacts = nil
	}
	return nil
}

func Convert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *build_api.SourceBuildStrategy, out *SourceBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(in, out, s)
}

func autoConvert_v1_SourceControlUser_To_api_SourceControlUser(in *SourceControlUser, out *build_api.SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

func Convert_v1_SourceControlUser_To_api_SourceControlUser(in *SourceControlUser, out *build_api.SourceControlUser, s conversion.Scope) error {
	return autoConvert_v1_SourceControlUser_To_api_SourceControlUser(in, out, s)
}

func autoConvert_api_SourceControlUser_To_v1_SourceControlUser(in *build_api.SourceControlUser, out *SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

func Convert_api_SourceControlUser_To_v1_SourceControlUser(in *build_api.SourceControlUser, out *SourceControlUser, s conversion.Scope) error {
	return autoConvert_api_SourceControlUser_To_v1_SourceControlUser(in, out, s)
}

func autoConvert_v1_SourceRevision_To_api_SourceRevision(in *SourceRevision, out *build_api.SourceRevision, s conversion.Scope) error {
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(build_api.GitSourceRevision)
		if err := Convert_v1_GitSourceRevision_To_api_GitSourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	return nil
}

func Convert_v1_SourceRevision_To_api_SourceRevision(in *SourceRevision, out *build_api.SourceRevision, s conversion.Scope) error {
	return autoConvert_v1_SourceRevision_To_api_SourceRevision(in, out, s)
}

func autoConvert_api_SourceRevision_To_v1_SourceRevision(in *build_api.SourceRevision, out *SourceRevision, s conversion.Scope) error {
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(GitSourceRevision)
		if err := Convert_api_GitSourceRevision_To_v1_GitSourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	return nil
}

func autoConvert_v1_WebHookTrigger_To_api_WebHookTrigger(in *WebHookTrigger, out *build_api.WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	return nil
}

func Convert_v1_WebHookTrigger_To_api_WebHookTrigger(in *WebHookTrigger, out *build_api.WebHookTrigger, s conversion.Scope) error {
	return autoConvert_v1_WebHookTrigger_To_api_WebHookTrigger(in, out, s)
}

func autoConvert_api_WebHookTrigger_To_v1_WebHookTrigger(in *build_api.WebHookTrigger, out *WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	return nil
}

func Convert_api_WebHookTrigger_To_v1_WebHookTrigger(in *build_api.WebHookTrigger, out *WebHookTrigger, s conversion.Scope) error {
	return autoConvert_api_WebHookTrigger_To_v1_WebHookTrigger(in, out, s)
}
