/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/client-go/1.4/pkg/api/unversioned"
	pkg2_config "k8s.io/client-go/1.4/pkg/util/config"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 pkg2_config.ConfigurationMap
		var v2 time.Duration
		_, _, _ = v0, v1, v2
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [20]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(20)
			} else {
				yynn2 = 18
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy25 := *x.IPTablesMasqueradeBit
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(yy25))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy27 := *x.IPTablesMasqueradeBit
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(yy27))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy30 := &x.IPTablesSyncPeriod
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else if z.HasExtensions() && z.EncExt(yy30) {
				} else if !yym31 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy30)
				} else {
					z.EncFallback(yy30)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy32 := &x.IPTablesSyncPeriod
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else if z.HasExtensions() && z.EncExt(yy32) {
				} else if !yym33 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy32)
				} else {
					z.EncFallback(yy32)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym35 := z.EncBinary()
				_ = yym35
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym36 := z.EncBinary()
				_ = yym36
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym39 := z.EncBinary()
				_ = yym39
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym42 := z.EncBinary()
				_ = yym42
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy44 := *x.OOMScoreAdj
					yym45 := z.EncBinary()
					_ = yym45
					if false {
					} else {
						r.EncodeInt(int64(yy44))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy46 := *x.OOMScoreAdj
					yym47 := z.EncBinary()
					_ = yym47
					if false {
					} else {
						r.EncodeInt(int64(yy46))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym50 := z.EncBinary()
				_ = yym50
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym51 := z.EncBinary()
				_ = yym51
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym53 := z.EncBinary()
				_ = yym53
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceContainer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym54 := z.EncBinary()
				_ = yym54
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy56 := &x.UDPIdleTimeout
				yym57 := z.EncBinary()
				_ = yym57
				if false {
				} else if z.HasExtensions() && z.EncExt(yy56) {
				} else if !yym57 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy56)
				} else {
					z.EncFallback(yy56)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy58 := &x.UDPIdleTimeout
				yym59 := z.EncBinary()
				_ = yym59
				if false {
				} else if z.HasExtensions() && z.EncExt(yy58) {
				} else if !yym59 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy58)
				} else {
					z.EncFallback(yy58)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym61 := z.EncBinary()
				_ = yym61
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMax"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym64 := z.EncBinary()
				_ = yym64
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMaxPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym65 := z.EncBinary()
				_ = yym65
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy67 := &x.ConntrackTCPEstablishedTimeout
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else if z.HasExtensions() && z.EncExt(yy67) {
				} else if !yym68 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy67)
				} else {
					z.EncFallback(yy67)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPEstablishedTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy69 := &x.ConntrackTCPEstablishedTimeout
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else if z.HasExtensions() && z.EncExt(yy69) {
				} else if !yym70 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy69)
				} else {
					z.EncFallback(yy69)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym71 := z.DecBinary()
	_ = yym71
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct72 := r.ContainerType()
		if yyct72 == codecSelferValueTypeMap1234 {
			yyl72 := r.ReadMapStart()
			if yyl72 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl72, d)
			}
		} else if yyct72 == codecSelferValueTypeArray1234 {
			yyl72 := r.ReadArrayStart()
			if yyl72 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl72, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys73Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys73Slc
	var yyhl73 bool = l >= 0
	for yyj73 := 0; ; yyj73++ {
		if yyhl73 {
			if yyj73 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys73Slc = r.DecodeBytes(yys73Slc, true, true)
		yys73 := string(yys73Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys73 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				if x.IPTablesMasqueradeBit != nil {
					x.IPTablesMasqueradeBit = nil
				}
			} else {
				if x.IPTablesMasqueradeBit == nil {
					x.IPTablesMasqueradeBit = new(int32)
				}
				yym82 := z.DecBinary()
				_ = yym82
				if false {
				} else {
					*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
				}
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv83 := &x.IPTablesSyncPeriod
				yym84 := z.DecBinary()
				_ = yym84
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv83) {
				} else if !yym84 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv83)
				} else {
					z.DecFallback(yyv83, false)
				}
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int32)
				}
				yym89 := z.DecBinary()
				_ = yym89
				if false {
				} else {
					*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "resourceContainer":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv93 := &x.UDPIdleTimeout
				yym94 := z.DecBinary()
				_ = yym94
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv93) {
				} else if !yym94 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv93)
				} else {
					z.DecFallback(yyv93, false)
				}
			}
		case "conntrackMax":
			if r.TryDecodeAsNil() {
				x.ConntrackMax = 0
			} else {
				x.ConntrackMax = int32(r.DecodeInt(32))
			}
		case "conntrackMaxPerCore":
			if r.TryDecodeAsNil() {
				x.ConntrackMaxPerCore = 0
			} else {
				x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
			}
		case "conntrackTCPEstablishedTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv97 := &x.ConntrackTCPEstablishedTimeout
				yym98 := z.DecBinary()
				_ = yym98
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv97) {
				} else if !yym98 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv97)
				} else {
					z.DecFallback(yyv97, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys73)
		} // end switch yys73
	} // end for yyj73
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj99 int
	var yyb99 bool
	var yyhl99 bool = l >= 0
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.IPTablesMasqueradeBit != nil {
			x.IPTablesMasqueradeBit = nil
		}
	} else {
		if x.IPTablesMasqueradeBit == nil {
			x.IPTablesMasqueradeBit = new(int32)
		}
		yym108 := z.DecBinary()
		_ = yym108
		if false {
		} else {
			*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv109 := &x.IPTablesSyncPeriod
		yym110 := z.DecBinary()
		_ = yym110
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv109) {
		} else if !yym110 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv109)
		} else {
			z.DecFallback(yyv109, false)
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int32)
		}
		yym115 := z.DecBinary()
		_ = yym115
		if false {
		} else {
			*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv119 := &x.UDPIdleTimeout
		yym120 := z.DecBinary()
		_ = yym120
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv119) {
		} else if !yym120 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv119)
		} else {
			z.DecFallback(yyv119, false)
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMax = 0
	} else {
		x.ConntrackMax = int32(r.DecodeInt(32))
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMaxPerCore = 0
	} else {
		x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv123 := &x.ConntrackTCPEstablishedTimeout
		yym124 := z.DecBinary()
		_ = yym124
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv123) {
		} else if !yym124 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv123)
		} else {
			z.DecFallback(yyv123, false)
		}
	}
	for {
		yyj99++
		if yyhl99 {
			yyb99 = yyj99 > l
		} else {
			yyb99 = r.CheckBreak()
		}
		if yyb99 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj99-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym125 := z.EncBinary()
	_ = yym125
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym126 := z.DecBinary()
	_ = yym126
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x HairpinMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym127 := z.EncBinary()
	_ = yym127
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *HairpinMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym128 := z.DecBinary()
	_ = yym128
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym129 := z.EncBinary()
		_ = yym129
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep130 := !z.EncBinary()
			yy2arr130 := z.EncBasicHandle().StructToArray
			var yyq130 [107]bool
			_, _, _ = yysep130, yyq130, yy2arr130
			const yyr130 bool = false
			yyq130[0] = x.Kind != ""
			yyq130[1] = x.APIVersion != ""
			yyq130[53] = x.CloudProvider != ""
			yyq130[54] = x.CloudConfigFile != ""
			yyq130[55] = x.KubeletCgroups != ""
			yyq130[56] = x.CgroupsPerQOS != false
			yyq130[57] = x.RuntimeCgroups != ""
			yyq130[58] = x.SystemCgroups != ""
			yyq130[59] = x.CgroupRoot != ""
			yyq130[63] = true
			yyq130[64] = x.RktPath != ""
			yyq130[65] = x.RktAPIEndpoint != ""
			yyq130[66] = x.RktStage1Image != ""
			yyq130[87] = true
			yyq130[88] = x.NodeIP != ""
			yyq130[92] = x.EvictionHard != ""
			yyq130[93] = x.EvictionSoft != ""
			yyq130[94] = x.EvictionSoftGracePeriod != ""
			yyq130[95] = true
			yyq130[96] = x.EvictionMaxPodGracePeriod != 0
			yyq130[97] = x.EvictionMinimumReclaim != ""
			yyq130[106] = len(x.AllowedUnsafeSysctls) != 0
			var yynn130 int
			if yyr130 || yy2arr130 {
				r.EncodeArrayStart(107)
			} else {
				yynn130 = 85
				for _, b := range yyq130 {
					if b {
						yynn130++
					}
				}
				r.EncodeMapStart(yynn130)
				yynn130 = 0
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[0] {
					yym132 := z.EncBinary()
					_ = yym132
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[1] {
					yym135 := z.EncBinary()
					_ = yym135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym136 := z.EncBinary()
					_ = yym136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym138 := z.EncBinary()
				_ = yym138
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podManifestPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym139 := z.EncBinary()
				_ = yym139
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy141 := &x.SyncFrequency
				yym142 := z.EncBinary()
				_ = yym142
				if false {
				} else if z.HasExtensions() && z.EncExt(yy141) {
				} else if !yym142 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy141)
				} else {
					z.EncFallback(yy141)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("syncFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy143 := &x.SyncFrequency
				yym144 := z.EncBinary()
				_ = yym144
				if false {
				} else if z.HasExtensions() && z.EncExt(yy143) {
				} else if !yym144 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy143)
				} else {
					z.EncFallback(yy143)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy146 := &x.FileCheckFrequency
				yym147 := z.EncBinary()
				_ = yym147
				if false {
				} else if z.HasExtensions() && z.EncExt(yy146) {
				} else if !yym147 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy146)
				} else {
					z.EncFallback(yy146)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fileCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy148 := &x.FileCheckFrequency
				yym149 := z.EncBinary()
				_ = yym149
				if false {
				} else if z.HasExtensions() && z.EncExt(yy148) {
				} else if !yym149 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy148)
				} else {
					z.EncFallback(yy148)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy151 := &x.HTTPCheckFrequency
				yym152 := z.EncBinary()
				_ = yym152
				if false {
				} else if z.HasExtensions() && z.EncExt(yy151) {
				} else if !yym152 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy151)
				} else {
					z.EncFallback(yy151)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("httpCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy153 := &x.HTTPCheckFrequency
				yym154 := z.EncBinary()
				_ = yym154
				if false {
				} else if z.HasExtensions() && z.EncExt(yy153) {
				} else if !yym154 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy153)
				} else {
					z.EncFallback(yy153)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym157 := z.EncBinary()
				_ = yym157
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURLHeader"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym160 := z.EncBinary()
				_ = yym160
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableServer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym163 := z.EncBinary()
				_ = yym163
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym165 := z.EncBinary()
				_ = yym165
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym166 := z.EncBinary()
				_ = yym166
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym168 := z.EncBinary()
				_ = yym168
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym169 := z.EncBinary()
				_ = yym169
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym171 := z.EncBinary()
				_ = yym171
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("readOnlyPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym172 := z.EncBinary()
				_ = yym172
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym174 := z.EncBinary()
				_ = yym174
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym175 := z.EncBinary()
				_ = yym175
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym177 := z.EncBinary()
				_ = yym177
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsPrivateKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym178 := z.EncBinary()
				_ = yym178
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym180 := z.EncBinary()
				_ = yym180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("certDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym181 := z.EncBinary()
				_ = yym181
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym183 := z.EncBinary()
				_ = yym183
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym184 := z.EncBinary()
				_ = yym184
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym186 := z.EncBinary()
				_ = yym186
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podInfraContainerImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym187 := z.EncBinary()
				_ = yym187
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym189 := z.EncBinary()
				_ = yym189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym190 := z.EncBinary()
				_ = yym190
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym192 := z.EncBinary()
				_ = yym192
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym193 := z.EncBinary()
				_ = yym193
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym195 := z.EncBinary()
				_ = yym195
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seccompProfileRoot"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym196 := z.EncBinary()
				_ = yym196
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym198 := z.EncBinary()
				_ = yym198
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowPrivileged"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym199 := z.EncBinary()
				_ = yym199
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym201 := z.EncBinary()
					_ = yym201
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostNetworkSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym202 := z.EncBinary()
					_ = yym202
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym204 := z.EncBinary()
					_ = yym204
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostPIDSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym205 := z.EncBinary()
					_ = yym205
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym207 := z.EncBinary()
					_ = yym207
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostIPCSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym208 := z.EncBinary()
					_ = yym208
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym210 := z.EncBinary()
				_ = yym210
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryPullQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym211 := z.EncBinary()
				_ = yym211
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym213 := z.EncBinary()
				_ = yym213
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym214 := z.EncBinary()
				_ = yym214
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym216 := z.EncBinary()
				_ = yym216
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventRecordQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym217 := z.EncBinary()
				_ = yym217
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym219 := z.EncBinary()
				_ = yym219
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym220 := z.EncBinary()
				_ = yym220
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym222 := z.EncBinary()
				_ = yym222
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDebuggingHandlers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym223 := z.EncBinary()
				_ = yym223
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy225 := &x.MinimumGCAge
				yym226 := z.EncBinary()
				_ = yym226
				if false {
				} else if z.HasExtensions() && z.EncExt(yy225) {
				} else if !yym226 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy225)
				} else {
					z.EncFallback(yy225)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy227 := &x.MinimumGCAge
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else if z.HasExtensions() && z.EncExt(yy227) {
				} else if !yym228 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy227)
				} else {
					z.EncFallback(yy227)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym230 := z.EncBinary()
				_ = yym230
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPerPodContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym231 := z.EncBinary()
				_ = yym231
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym233 := z.EncBinary()
				_ = yym233
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym234 := z.EncBinary()
				_ = yym234
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym236 := z.EncBinary()
				_ = yym236
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cAdvisorPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym237 := z.EncBinary()
				_ = yym237
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym239 := z.EncBinary()
				_ = yym239
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym240 := z.EncBinary()
				_ = yym240
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym242 := z.EncBinary()
				_ = yym242
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym243 := z.EncBinary()
				_ = yym243
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym245 := z.EncBinary()
				_ = yym245
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym246 := z.EncBinary()
				_ = yym246
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym248 := z.EncBinary()
				_ = yym248
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerNode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym249 := z.EncBinary()
				_ = yym249
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym251 := z.EncBinary()
				_ = yym251
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDomain"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym252 := z.EncBinary()
				_ = yym252
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym254 := z.EncBinary()
				_ = yym254
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masterServiceNamespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym255 := z.EncBinary()
				_ = yym255
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym257 := z.EncBinary()
				_ = yym257
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDNS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym258 := z.EncBinary()
				_ = yym258
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy260 := &x.StreamingConnectionIdleTimeout
				yym261 := z.EncBinary()
				_ = yym261
				if false {
				} else if z.HasExtensions() && z.EncExt(yy260) {
				} else if !yym261 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy260)
				} else {
					z.EncFallback(yy260)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("streamingConnectionIdleTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy262 := &x.StreamingConnectionIdleTimeout
				yym263 := z.EncBinary()
				_ = yym263
				if false {
				} else if z.HasExtensions() && z.EncExt(yy262) {
				} else if !yym263 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy262)
				} else {
					z.EncFallback(yy262)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy265 := &x.NodeStatusUpdateFrequency
				yym266 := z.EncBinary()
				_ = yym266
				if false {
				} else if z.HasExtensions() && z.EncExt(yy265) {
				} else if !yym266 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy265)
				} else {
					z.EncFallback(yy265)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStatusUpdateFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy267 := &x.NodeStatusUpdateFrequency
				yym268 := z.EncBinary()
				_ = yym268
				if false {
				} else if z.HasExtensions() && z.EncExt(yy267) {
				} else if !yym268 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy267)
				} else {
					z.EncFallback(yy267)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy270 := &x.ImageMinimumGCAge
				yym271 := z.EncBinary()
				_ = yym271
				if false {
				} else if z.HasExtensions() && z.EncExt(yy270) {
				} else if !yym271 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy270)
				} else {
					z.EncFallback(yy270)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageMinimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy272 := &x.ImageMinimumGCAge
				yym273 := z.EncBinary()
				_ = yym273
				if false {
				} else if z.HasExtensions() && z.EncExt(yy272) {
				} else if !yym273 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy272)
				} else {
					z.EncFallback(yy272)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym275 := z.EncBinary()
				_ = yym275
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCHighThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym276 := z.EncBinary()
				_ = yym276
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym278 := z.EncBinary()
				_ = yym278
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCLowThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym279 := z.EncBinary()
				_ = yym279
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym281 := z.EncBinary()
				_ = yym281
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lowDiskSpaceThresholdMB"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym282 := z.EncBinary()
				_ = yym282
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy284 := &x.VolumeStatsAggPeriod
				yym285 := z.EncBinary()
				_ = yym285
				if false {
				} else if z.HasExtensions() && z.EncExt(yy284) {
				} else if !yym285 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy284)
				} else {
					z.EncFallback(yy284)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeStatsAggPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy286 := &x.VolumeStatsAggPeriod
				yym287 := z.EncBinary()
				_ = yym287
				if false {
				} else if z.HasExtensions() && z.EncExt(yy286) {
				} else if !yym287 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy286)
				} else {
					z.EncFallback(yy286)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym289 := z.EncBinary()
				_ = yym289
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym290 := z.EncBinary()
				_ = yym290
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym292 := z.EncBinary()
				_ = yym292
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginMTU"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym293 := z.EncBinary()
				_ = yym293
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym295 := z.EncBinary()
				_ = yym295
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym296 := z.EncBinary()
				_ = yym296
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym298 := z.EncBinary()
				_ = yym298
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniConfDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym299 := z.EncBinary()
				_ = yym299
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym301 := z.EncBinary()
				_ = yym301
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniBinDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym302 := z.EncBinary()
				_ = yym302
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym304 := z.EncBinary()
				_ = yym304
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym305 := z.EncBinary()
				_ = yym305
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[53] {
					yym307 := z.EncBinary()
					_ = yym307
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[53] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym308 := z.EncBinary()
					_ = yym308
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[54] {
					yym310 := z.EncBinary()
					_ = yym310
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[54] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym311 := z.EncBinary()
					_ = yym311
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[55] {
					yym313 := z.EncBinary()
					_ = yym313
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[55] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym314 := z.EncBinary()
					_ = yym314
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[56] {
					yym316 := z.EncBinary()
					_ = yym316
					if false {
					} else {
						r.EncodeBool(bool(x.CgroupsPerQOS))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq130[56] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("CgroupsPerQOS"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym317 := z.EncBinary()
					_ = yym317
					if false {
					} else {
						r.EncodeBool(bool(x.CgroupsPerQOS))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[57] {
					yym319 := z.EncBinary()
					_ = yym319
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[57] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym320 := z.EncBinary()
					_ = yym320
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[58] {
					yym322 := z.EncBinary()
					_ = yym322
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[58] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("systemCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym323 := z.EncBinary()
					_ = yym323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[59] {
					yym325 := z.EncBinary()
					_ = yym325
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[59] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym326 := z.EncBinary()
					_ = yym326
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym328 := z.EncBinary()
				_ = yym328
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym329 := z.EncBinary()
				_ = yym329
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym331 := z.EncBinary()
				_ = yym331
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteRuntimeEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym332 := z.EncBinary()
				_ = yym332
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym334 := z.EncBinary()
				_ = yym334
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteImageEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym335 := z.EncBinary()
				_ = yym335
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[63] {
					yy337 := &x.RuntimeRequestTimeout
					yym338 := z.EncBinary()
					_ = yym338
					if false {
					} else if z.HasExtensions() && z.EncExt(yy337) {
					} else if !yym338 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy337)
					} else {
						z.EncFallback(yy337)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[63] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeRequestTimeout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy339 := &x.RuntimeRequestTimeout
					yym340 := z.EncBinary()
					_ = yym340
					if false {
					} else if z.HasExtensions() && z.EncExt(yy339) {
					} else if !yym340 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy339)
					} else {
						z.EncFallback(yy339)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[64] {
					yym342 := z.EncBinary()
					_ = yym342
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[64] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym343 := z.EncBinary()
					_ = yym343
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[65] {
					yym345 := z.EncBinary()
					_ = yym345
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[65] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktAPIEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym346 := z.EncBinary()
					_ = yym346
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[66] {
					yym348 := z.EncBinary()
					_ = yym348
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[66] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktStage1Image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym349 := z.EncBinary()
					_ = yym349
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym351 := z.EncBinary()
				_ = yym351
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lockFilePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym352 := z.EncBinary()
				_ = yym352
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym354 := z.EncBinary()
				_ = yym354
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitOnLockContention"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym355 := z.EncBinary()
				_ = yym355
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym357 := z.EncBinary()
				_ = yym357
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCbr0"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym358 := z.EncBinary()
				_ = yym358
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym360 := z.EncBinary()
				_ = yym360
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hairpinMode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym361 := z.EncBinary()
				_ = yym361
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym363 := z.EncBinary()
				_ = yym363
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("babysitDaemons"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym364 := z.EncBinary()
				_ = yym364
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym366 := z.EncBinary()
				_ = yym366
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym367 := z.EncBinary()
				_ = yym367
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym369 := z.EncBinary()
				_ = yym369
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nvidiaGPUs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym370 := z.EncBinary()
				_ = yym370
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym372 := z.EncBinary()
				_ = yym372
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerExecHandlerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym373 := z.EncBinary()
				_ = yym373
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym375 := z.EncBinary()
				_ = yym375
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym376 := z.EncBinary()
				_ = yym376
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym378 := z.EncBinary()
				_ = yym378
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resolvConf"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym379 := z.EncBinary()
				_ = yym379
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym381 := z.EncBinary()
				_ = yym381
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cpuCFSQuota"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym382 := z.EncBinary()
				_ = yym382
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym384 := z.EncBinary()
				_ = yym384
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerized"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym385 := z.EncBinary()
				_ = yym385
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym387 := z.EncBinary()
				_ = yym387
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxOpenFiles"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym388 := z.EncBinary()
				_ = yym388
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym390 := z.EncBinary()
				_ = yym390
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcileCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym391 := z.EncBinary()
				_ = yym391
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym393 := z.EncBinary()
				_ = yym393
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerSchedulable"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym394 := z.EncBinary()
				_ = yym394
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym396 := z.EncBinary()
				_ = yym396
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym397 := z.EncBinary()
				_ = yym397
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym399 := z.EncBinary()
				_ = yym399
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym400 := z.EncBinary()
				_ = yym400
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym402 := z.EncBinary()
				_ = yym402
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym403 := z.EncBinary()
				_ = yym403
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym405 := z.EncBinary()
				_ = yym405
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serializeImagePulls"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym406 := z.EncBinary()
				_ = yym406
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym408 := z.EncBinary()
				_ = yym408
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("experimentalFlannelOverlay"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym409 := z.EncBinary()
				_ = yym409
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[87] {
					yy411 := &x.OutOfDiskTransitionFrequency
					yym412 := z.EncBinary()
					_ = yym412
					if false {
					} else if z.HasExtensions() && z.EncExt(yy411) {
					} else if !yym412 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy411)
					} else {
						z.EncFallback(yy411)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[87] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("outOfDiskTransitionFrequency"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy413 := &x.OutOfDiskTransitionFrequency
					yym414 := z.EncBinary()
					_ = yym414
					if false {
					} else if z.HasExtensions() && z.EncExt(yy413) {
					} else if !yym414 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy413)
					} else {
						z.EncFallback(yy413)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[88] {
					yym416 := z.EncBinary()
					_ = yym416
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[88] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym417 := z.EncBinary()
					_ = yym417
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym419 := z.EncBinary()
					_ = yym419
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeLabels"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym420 := z.EncBinary()
					_ = yym420
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym422 := z.EncBinary()
				_ = yym422
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nonMasqueradeCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym423 := z.EncBinary()
				_ = yym423
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym425 := z.EncBinary()
				_ = yym425
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableCustomMetrics"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym426 := z.EncBinary()
				_ = yym426
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[92] {
					yym428 := z.EncBinary()
					_ = yym428
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[92] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionHard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym429 := z.EncBinary()
					_ = yym429
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[93] {
					yym431 := z.EncBinary()
					_ = yym431
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[93] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoft"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym432 := z.EncBinary()
					_ = yym432
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[94] {
					yym434 := z.EncBinary()
					_ = yym434
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[94] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoftGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym435 := z.EncBinary()
					_ = yym435
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[95] {
					yy437 := &x.EvictionPressureTransitionPeriod
					yym438 := z.EncBinary()
					_ = yym438
					if false {
					} else if z.HasExtensions() && z.EncExt(yy437) {
					} else if !yym438 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy437)
					} else {
						z.EncFallback(yy437)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[95] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionPressureTransitionPeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy439 := &x.EvictionPressureTransitionPeriod
					yym440 := z.EncBinary()
					_ = yym440
					if false {
					} else if z.HasExtensions() && z.EncExt(yy439) {
					} else if !yym440 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy439)
					} else {
						z.EncFallback(yy439)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[96] {
					yym442 := z.EncBinary()
					_ = yym442
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq130[96] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMaxPodGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym443 := z.EncBinary()
					_ = yym443
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[97] {
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[97] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMinimumReclaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym446 := z.EncBinary()
					_ = yym446
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym448 := z.EncBinary()
				_ = yym448
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podsPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym449 := z.EncBinary()
				_ = yym449
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym451 := z.EncBinary()
				_ = yym451
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableControllerAttachDetach"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym452 := z.EncBinary()
				_ = yym452
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym454 := z.EncBinary()
					_ = yym454
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym455 := z.EncBinary()
					_ = yym455
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym457 := z.EncBinary()
					_ = yym457
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym458 := z.EncBinary()
					_ = yym458
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym460 := z.EncBinary()
				_ = yym460
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protectKernelDefaults"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym461 := z.EncBinary()
				_ = yym461
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym463 := z.EncBinary()
				_ = yym463
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("makeIPTablesUtilChains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym464 := z.EncBinary()
				_ = yym464
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym466 := z.EncBinary()
				_ = yym466
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym467 := z.EncBinary()
				_ = yym467
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym469 := z.EncBinary()
				_ = yym469
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesDropBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym470 := z.EncBinary()
				_ = yym470
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[106] {
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym472 := z.EncBinary()
						_ = yym472
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[106] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalAllowedUnsafeSysctls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym473 := z.EncBinary()
						_ = yym473
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym474 := z.DecBinary()
	_ = yym474
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct475 := r.ContainerType()
		if yyct475 == codecSelferValueTypeMap1234 {
			yyl475 := r.ReadMapStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl475, d)
			}
		} else if yyct475 == codecSelferValueTypeArray1234 {
			yyl475 := r.ReadArrayStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl475, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys476Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys476Slc
	var yyhl476 bool = l >= 0
	for yyj476 := 0; ; yyj476++ {
		if yyhl476 {
			if yyj476 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys476Slc = r.DecodeBytes(yys476Slc, true, true)
		yys476 := string(yys476Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys476 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "podManifestPath":
			if r.TryDecodeAsNil() {
				x.PodManifestPath = ""
			} else {
				x.PodManifestPath = string(r.DecodeString())
			}
		case "syncFrequency":
			if r.TryDecodeAsNil() {
				x.SyncFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv480 := &x.SyncFrequency
				yym481 := z.DecBinary()
				_ = yym481
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv480) {
				} else if !yym481 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv480)
				} else {
					z.DecFallback(yyv480, false)
				}
			}
		case "fileCheckFrequency":
			if r.TryDecodeAsNil() {
				x.FileCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv482 := &x.FileCheckFrequency
				yym483 := z.DecBinary()
				_ = yym483
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv482) {
				} else if !yym483 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv482)
				} else {
					z.DecFallback(yyv482, false)
				}
			}
		case "httpCheckFrequency":
			if r.TryDecodeAsNil() {
				x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv484 := &x.HTTPCheckFrequency
				yym485 := z.DecBinary()
				_ = yym485
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv484) {
				} else if !yym485 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv484)
				} else {
					z.DecFallback(yyv484, false)
				}
			}
		case "manifestURL":
			if r.TryDecodeAsNil() {
				x.ManifestURL = ""
			} else {
				x.ManifestURL = string(r.DecodeString())
			}
		case "manifestURLHeader":
			if r.TryDecodeAsNil() {
				x.ManifestURLHeader = ""
			} else {
				x.ManifestURLHeader = string(r.DecodeString())
			}
		case "enableServer":
			if r.TryDecodeAsNil() {
				x.EnableServer = false
			} else {
				x.EnableServer = bool(r.DecodeBool())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "readOnlyPort":
			if r.TryDecodeAsNil() {
				x.ReadOnlyPort = 0
			} else {
				x.ReadOnlyPort = int32(r.DecodeInt(32))
			}
		case "tlsCertFile":
			if r.TryDecodeAsNil() {
				x.TLSCertFile = ""
			} else {
				x.TLSCertFile = string(r.DecodeString())
			}
		case "tlsPrivateKeyFile":
			if r.TryDecodeAsNil() {
				x.TLSPrivateKeyFile = ""
			} else {
				x.TLSPrivateKeyFile = string(r.DecodeString())
			}
		case "certDirectory":
			if r.TryDecodeAsNil() {
				x.CertDirectory = ""
			} else {
				x.CertDirectory = string(r.DecodeString())
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "podInfraContainerImage":
			if r.TryDecodeAsNil() {
				x.PodInfraContainerImage = ""
			} else {
				x.PodInfraContainerImage = string(r.DecodeString())
			}
		case "dockerEndpoint":
			if r.TryDecodeAsNil() {
				x.DockerEndpoint = ""
			} else {
				x.DockerEndpoint = string(r.DecodeString())
			}
		case "rootDirectory":
			if r.TryDecodeAsNil() {
				x.RootDirectory = ""
			} else {
				x.RootDirectory = string(r.DecodeString())
			}
		case "seccompProfileRoot":
			if r.TryDecodeAsNil() {
				x.SeccompProfileRoot = ""
			} else {
				x.SeccompProfileRoot = string(r.DecodeString())
			}
		case "allowPrivileged":
			if r.TryDecodeAsNil() {
				x.AllowPrivileged = false
			} else {
				x.AllowPrivileged = bool(r.DecodeBool())
			}
		case "hostNetworkSources":
			if r.TryDecodeAsNil() {
				x.HostNetworkSources = nil
			} else {
				yyv501 := &x.HostNetworkSources
				yym502 := z.DecBinary()
				_ = yym502
				if false {
				} else {
					z.F.DecSliceStringX(yyv501, false, d)
				}
			}
		case "hostPIDSources":
			if r.TryDecodeAsNil() {
				x.HostPIDSources = nil
			} else {
				yyv503 := &x.HostPIDSources
				yym504 := z.DecBinary()
				_ = yym504
				if false {
				} else {
					z.F.DecSliceStringX(yyv503, false, d)
				}
			}
		case "hostIPCSources":
			if r.TryDecodeAsNil() {
				x.HostIPCSources = nil
			} else {
				yyv505 := &x.HostIPCSources
				yym506 := z.DecBinary()
				_ = yym506
				if false {
				} else {
					z.F.DecSliceStringX(yyv505, false, d)
				}
			}
		case "registryPullQPS":
			if r.TryDecodeAsNil() {
				x.RegistryPullQPS = 0
			} else {
				x.RegistryPullQPS = int32(r.DecodeInt(32))
			}
		case "registryBurst":
			if r.TryDecodeAsNil() {
				x.RegistryBurst = 0
			} else {
				x.RegistryBurst = int32(r.DecodeInt(32))
			}
		case "eventRecordQPS":
			if r.TryDecodeAsNil() {
				x.EventRecordQPS = 0
			} else {
				x.EventRecordQPS = int32(r.DecodeInt(32))
			}
		case "eventBurst":
			if r.TryDecodeAsNil() {
				x.EventBurst = 0
			} else {
				x.EventBurst = int32(r.DecodeInt(32))
			}
		case "enableDebuggingHandlers":
			if r.TryDecodeAsNil() {
				x.EnableDebuggingHandlers = false
			} else {
				x.EnableDebuggingHandlers = bool(r.DecodeBool())
			}
		case "minimumGCAge":
			if r.TryDecodeAsNil() {
				x.MinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv512 := &x.MinimumGCAge
				yym513 := z.DecBinary()
				_ = yym513
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv512) {
				} else if !yym513 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv512)
				} else {
					z.DecFallback(yyv512, false)
				}
			}
		case "maxPerPodContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxPerPodContainerCount = 0
			} else {
				x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
			}
		case "maxContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxContainerCount = 0
			} else {
				x.MaxContainerCount = int32(r.DecodeInt(32))
			}
		case "cAdvisorPort":
			if r.TryDecodeAsNil() {
				x.CAdvisorPort = 0
			} else {
				x.CAdvisorPort = int32(r.DecodeInt(32))
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				x.OOMScoreAdj = 0
			} else {
				x.OOMScoreAdj = int32(r.DecodeInt(32))
			}
		case "registerNode":
			if r.TryDecodeAsNil() {
				x.RegisterNode = false
			} else {
				x.RegisterNode = bool(r.DecodeBool())
			}
		case "clusterDomain":
			if r.TryDecodeAsNil() {
				x.ClusterDomain = ""
			} else {
				x.ClusterDomain = string(r.DecodeString())
			}
		case "masterServiceNamespace":
			if r.TryDecodeAsNil() {
				x.MasterServiceNamespace = ""
			} else {
				x.MasterServiceNamespace = string(r.DecodeString())
			}
		case "clusterDNS":
			if r.TryDecodeAsNil() {
				x.ClusterDNS = ""
			} else {
				x.ClusterDNS = string(r.DecodeString())
			}
		case "streamingConnectionIdleTimeout":
			if r.TryDecodeAsNil() {
				x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv524 := &x.StreamingConnectionIdleTimeout
				yym525 := z.DecBinary()
				_ = yym525
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv524) {
				} else if !yym525 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv524)
				} else {
					z.DecFallback(yyv524, false)
				}
			}
		case "nodeStatusUpdateFrequency":
			if r.TryDecodeAsNil() {
				x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv526 := &x.NodeStatusUpdateFrequency
				yym527 := z.DecBinary()
				_ = yym527
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv526) {
				} else if !yym527 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv526)
				} else {
					z.DecFallback(yyv526, false)
				}
			}
		case "imageMinimumGCAge":
			if r.TryDecodeAsNil() {
				x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv528 := &x.ImageMinimumGCAge
				yym529 := z.DecBinary()
				_ = yym529
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv528) {
				} else if !yym529 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv528)
				} else {
					z.DecFallback(yyv528, false)
				}
			}
		case "imageGCHighThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCHighThresholdPercent = 0
			} else {
				x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
			}
		case "imageGCLowThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCLowThresholdPercent = 0
			} else {
				x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
			}
		case "lowDiskSpaceThresholdMB":
			if r.TryDecodeAsNil() {
				x.LowDiskSpaceThresholdMB = 0
			} else {
				x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
			}
		case "volumeStatsAggPeriod":
			if r.TryDecodeAsNil() {
				x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv533 := &x.VolumeStatsAggPeriod
				yym534 := z.DecBinary()
				_ = yym534
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv533) {
				} else if !yym534 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv533)
				} else {
					z.DecFallback(yyv533, false)
				}
			}
		case "networkPluginName":
			if r.TryDecodeAsNil() {
				x.NetworkPluginName = ""
			} else {
				x.NetworkPluginName = string(r.DecodeString())
			}
		case "networkPluginMTU":
			if r.TryDecodeAsNil() {
				x.NetworkPluginMTU = 0
			} else {
				x.NetworkPluginMTU = int32(r.DecodeInt(32))
			}
		case "networkPluginDir":
			if r.TryDecodeAsNil() {
				x.NetworkPluginDir = ""
			} else {
				x.NetworkPluginDir = string(r.DecodeString())
			}
		case "cniConfDir":
			if r.TryDecodeAsNil() {
				x.CNIConfDir = ""
			} else {
				x.CNIConfDir = string(r.DecodeString())
			}
		case "cniBinDir":
			if r.TryDecodeAsNil() {
				x.CNIBinDir = ""
			} else {
				x.CNIBinDir = string(r.DecodeString())
			}
		case "volumePluginDir":
			if r.TryDecodeAsNil() {
				x.VolumePluginDir = ""
			} else {
				x.VolumePluginDir = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.KubeletCgroups = ""
			} else {
				x.KubeletCgroups = string(r.DecodeString())
			}
		case "CgroupsPerQOS":
			if r.TryDecodeAsNil() {
				x.CgroupsPerQOS = false
			} else {
				x.CgroupsPerQOS = bool(r.DecodeBool())
			}
		case "runtimeCgroups":
			if r.TryDecodeAsNil() {
				x.RuntimeCgroups = ""
			} else {
				x.RuntimeCgroups = string(r.DecodeString())
			}
		case "systemCgroups":
			if r.TryDecodeAsNil() {
				x.SystemCgroups = ""
			} else {
				x.SystemCgroups = string(r.DecodeString())
			}
		case "cgroupRoot":
			if r.TryDecodeAsNil() {
				x.CgroupRoot = ""
			} else {
				x.CgroupRoot = string(r.DecodeString())
			}
		case "containerRuntime":
			if r.TryDecodeAsNil() {
				x.ContainerRuntime = ""
			} else {
				x.ContainerRuntime = string(r.DecodeString())
			}
		case "remoteRuntimeEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteRuntimeEndpoint = ""
			} else {
				x.RemoteRuntimeEndpoint = string(r.DecodeString())
			}
		case "remoteImageEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteImageEndpoint = ""
			} else {
				x.RemoteImageEndpoint = string(r.DecodeString())
			}
		case "runtimeRequestTimeout":
			if r.TryDecodeAsNil() {
				x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv551 := &x.RuntimeRequestTimeout
				yym552 := z.DecBinary()
				_ = yym552
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv551) {
				} else if !yym552 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv551)
				} else {
					z.DecFallback(yyv551, false)
				}
			}
		case "rktPath":
			if r.TryDecodeAsNil() {
				x.RktPath = ""
			} else {
				x.RktPath = string(r.DecodeString())
			}
		case "rktAPIEndpoint":
			if r.TryDecodeAsNil() {
				x.RktAPIEndpoint = ""
			} else {
				x.RktAPIEndpoint = string(r.DecodeString())
			}
		case "rktStage1Image":
			if r.TryDecodeAsNil() {
				x.RktStage1Image = ""
			} else {
				x.RktStage1Image = string(r.DecodeString())
			}
		case "lockFilePath":
			if r.TryDecodeAsNil() {
				x.LockFilePath = ""
			} else {
				x.LockFilePath = string(r.DecodeString())
			}
		case "exitOnLockContention":
			if r.TryDecodeAsNil() {
				x.ExitOnLockContention = false
			} else {
				x.ExitOnLockContention = bool(r.DecodeBool())
			}
		case "configureCbr0":
			if r.TryDecodeAsNil() {
				x.ConfigureCBR0 = false
			} else {
				x.ConfigureCBR0 = bool(r.DecodeBool())
			}
		case "hairpinMode":
			if r.TryDecodeAsNil() {
				x.HairpinMode = ""
			} else {
				x.HairpinMode = string(r.DecodeString())
			}
		case "babysitDaemons":
			if r.TryDecodeAsNil() {
				x.BabysitDaemons = false
			} else {
				x.BabysitDaemons = bool(r.DecodeBool())
			}
		case "maxPods":
			if r.TryDecodeAsNil() {
				x.MaxPods = 0
			} else {
				x.MaxPods = int32(r.DecodeInt(32))
			}
		case "nvidiaGPUs":
			if r.TryDecodeAsNil() {
				x.NvidiaGPUs = 0
			} else {
				x.NvidiaGPUs = int32(r.DecodeInt(32))
			}
		case "dockerExecHandlerName":
			if r.TryDecodeAsNil() {
				x.DockerExecHandlerName = ""
			} else {
				x.DockerExecHandlerName = string(r.DecodeString())
			}
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "resolvConf":
			if r.TryDecodeAsNil() {
				x.ResolverConfig = ""
			} else {
				x.ResolverConfig = string(r.DecodeString())
			}
		case "cpuCFSQuota":
			if r.TryDecodeAsNil() {
				x.CPUCFSQuota = false
			} else {
				x.CPUCFSQuota = bool(r.DecodeBool())
			}
		case "containerized":
			if r.TryDecodeAsNil() {
				x.Containerized = false
			} else {
				x.Containerized = bool(r.DecodeBool())
			}
		case "maxOpenFiles":
			if r.TryDecodeAsNil() {
				x.MaxOpenFiles = 0
			} else {
				x.MaxOpenFiles = int64(r.DecodeInt(64))
			}
		case "reconcileCIDR":
			if r.TryDecodeAsNil() {
				x.ReconcileCIDR = false
			} else {
				x.ReconcileCIDR = bool(r.DecodeBool())
			}
		case "registerSchedulable":
			if r.TryDecodeAsNil() {
				x.RegisterSchedulable = false
			} else {
				x.RegisterSchedulable = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = int32(r.DecodeInt(32))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "serializeImagePulls":
			if r.TryDecodeAsNil() {
				x.SerializeImagePulls = false
			} else {
				x.SerializeImagePulls = bool(r.DecodeBool())
			}
		case "experimentalFlannelOverlay":
			if r.TryDecodeAsNil() {
				x.ExperimentalFlannelOverlay = false
			} else {
				x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
			}
		case "outOfDiskTransitionFrequency":
			if r.TryDecodeAsNil() {
				x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv576 := &x.OutOfDiskTransitionFrequency
				yym577 := z.DecBinary()
				_ = yym577
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv576) {
				} else if !yym577 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv576)
				} else {
					z.DecFallback(yyv576, false)
				}
			}
		case "nodeIP":
			if r.TryDecodeAsNil() {
				x.NodeIP = ""
			} else {
				x.NodeIP = string(r.DecodeString())
			}
		case "nodeLabels":
			if r.TryDecodeAsNil() {
				x.NodeLabels = nil
			} else {
				yyv579 := &x.NodeLabels
				yym580 := z.DecBinary()
				_ = yym580
				if false {
				} else {
					z.F.DecMapStringStringX(yyv579, false, d)
				}
			}
		case "nonMasqueradeCIDR":
			if r.TryDecodeAsNil() {
				x.NonMasqueradeCIDR = ""
			} else {
				x.NonMasqueradeCIDR = string(r.DecodeString())
			}
		case "enableCustomMetrics":
			if r.TryDecodeAsNil() {
				x.EnableCustomMetrics = false
			} else {
				x.EnableCustomMetrics = bool(r.DecodeBool())
			}
		case "evictionHard":
			if r.TryDecodeAsNil() {
				x.EvictionHard = ""
			} else {
				x.EvictionHard = string(r.DecodeString())
			}
		case "evictionSoft":
			if r.TryDecodeAsNil() {
				x.EvictionSoft = ""
			} else {
				x.EvictionSoft = string(r.DecodeString())
			}
		case "evictionSoftGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionSoftGracePeriod = ""
			} else {
				x.EvictionSoftGracePeriod = string(r.DecodeString())
			}
		case "evictionPressureTransitionPeriod":
			if r.TryDecodeAsNil() {
				x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv586 := &x.EvictionPressureTransitionPeriod
				yym587 := z.DecBinary()
				_ = yym587
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv586) {
				} else if !yym587 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv586)
				} else {
					z.DecFallback(yyv586, false)
				}
			}
		case "evictionMaxPodGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionMaxPodGracePeriod = 0
			} else {
				x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
			}
		case "evictionMinimumReclaim":
			if r.TryDecodeAsNil() {
				x.EvictionMinimumReclaim = ""
			} else {
				x.EvictionMinimumReclaim = string(r.DecodeString())
			}
		case "podsPerCore":
			if r.TryDecodeAsNil() {
				x.PodsPerCore = 0
			} else {
				x.PodsPerCore = int32(r.DecodeInt(32))
			}
		case "enableControllerAttachDetach":
			if r.TryDecodeAsNil() {
				x.EnableControllerAttachDetach = false
			} else {
				x.EnableControllerAttachDetach = bool(r.DecodeBool())
			}
		case "systemReserved":
			if r.TryDecodeAsNil() {
				x.SystemReserved = nil
			} else {
				yyv592 := &x.SystemReserved
				yym593 := z.DecBinary()
				_ = yym593
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv592) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv592), d)
				}
			}
		case "kubeReserved":
			if r.TryDecodeAsNil() {
				x.KubeReserved = nil
			} else {
				yyv594 := &x.KubeReserved
				yym595 := z.DecBinary()
				_ = yym595
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv594) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv594), d)
				}
			}
		case "protectKernelDefaults":
			if r.TryDecodeAsNil() {
				x.ProtectKernelDefaults = false
			} else {
				x.ProtectKernelDefaults = bool(r.DecodeBool())
			}
		case "makeIPTablesUtilChains":
			if r.TryDecodeAsNil() {
				x.MakeIPTablesUtilChains = false
			} else {
				x.MakeIPTablesUtilChains = bool(r.DecodeBool())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				x.IPTablesMasqueradeBit = 0
			} else {
				x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
			}
		case "iptablesDropBit":
			if r.TryDecodeAsNil() {
				x.IPTablesDropBit = 0
			} else {
				x.IPTablesDropBit = int32(r.DecodeInt(32))
			}
		case "experimentalAllowedUnsafeSysctls":
			if r.TryDecodeAsNil() {
				x.AllowedUnsafeSysctls = nil
			} else {
				yyv600 := &x.AllowedUnsafeSysctls
				yym601 := z.DecBinary()
				_ = yym601
				if false {
				} else {
					z.F.DecSliceStringX(yyv600, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys476)
		} // end switch yys476
	} // end for yyj476
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj602 int
	var yyb602 bool
	var yyhl602 bool = l >= 0
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodManifestPath = ""
	} else {
		x.PodManifestPath = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SyncFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv606 := &x.SyncFrequency
		yym607 := z.DecBinary()
		_ = yym607
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv606) {
		} else if !yym607 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv606)
		} else {
			z.DecFallback(yyv606, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FileCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv608 := &x.FileCheckFrequency
		yym609 := z.DecBinary()
		_ = yym609
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv608) {
		} else if !yym609 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv608)
		} else {
			z.DecFallback(yyv608, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv610 := &x.HTTPCheckFrequency
		yym611 := z.DecBinary()
		_ = yym611
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv610) {
		} else if !yym611 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv610)
		} else {
			z.DecFallback(yyv610, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURL = ""
	} else {
		x.ManifestURL = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURLHeader = ""
	} else {
		x.ManifestURLHeader = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableServer = false
	} else {
		x.EnableServer = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyPort = 0
	} else {
		x.ReadOnlyPort = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSCertFile = ""
	} else {
		x.TLSCertFile = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSPrivateKeyFile = ""
	} else {
		x.TLSPrivateKeyFile = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CertDirectory = ""
	} else {
		x.CertDirectory = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodInfraContainerImage = ""
	} else {
		x.PodInfraContainerImage = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerEndpoint = ""
	} else {
		x.DockerEndpoint = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootDirectory = ""
	} else {
		x.RootDirectory = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SeccompProfileRoot = ""
	} else {
		x.SeccompProfileRoot = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowPrivileged = false
	} else {
		x.AllowPrivileged = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetworkSources = nil
	} else {
		yyv627 := &x.HostNetworkSources
		yym628 := z.DecBinary()
		_ = yym628
		if false {
		} else {
			z.F.DecSliceStringX(yyv627, false, d)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPIDSources = nil
	} else {
		yyv629 := &x.HostPIDSources
		yym630 := z.DecBinary()
		_ = yym630
		if false {
		} else {
			z.F.DecSliceStringX(yyv629, false, d)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPCSources = nil
	} else {
		yyv631 := &x.HostIPCSources
		yym632 := z.DecBinary()
		_ = yym632
		if false {
		} else {
			z.F.DecSliceStringX(yyv631, false, d)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryPullQPS = 0
	} else {
		x.RegistryPullQPS = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryBurst = 0
	} else {
		x.RegistryBurst = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventRecordQPS = 0
	} else {
		x.EventRecordQPS = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventBurst = 0
	} else {
		x.EventBurst = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDebuggingHandlers = false
	} else {
		x.EnableDebuggingHandlers = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv638 := &x.MinimumGCAge
		yym639 := z.DecBinary()
		_ = yym639
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv638) {
		} else if !yym639 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv638)
		} else {
			z.DecFallback(yyv638, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPerPodContainerCount = 0
	} else {
		x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxContainerCount = 0
	} else {
		x.MaxContainerCount = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CAdvisorPort = 0
	} else {
		x.CAdvisorPort = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OOMScoreAdj = 0
	} else {
		x.OOMScoreAdj = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterNode = false
	} else {
		x.RegisterNode = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDomain = ""
	} else {
		x.ClusterDomain = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasterServiceNamespace = ""
	} else {
		x.MasterServiceNamespace = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDNS = ""
	} else {
		x.ClusterDNS = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv650 := &x.StreamingConnectionIdleTimeout
		yym651 := z.DecBinary()
		_ = yym651
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv650) {
		} else if !yym651 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv650)
		} else {
			z.DecFallback(yyv650, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv652 := &x.NodeStatusUpdateFrequency
		yym653 := z.DecBinary()
		_ = yym653
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv652) {
		} else if !yym653 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv652)
		} else {
			z.DecFallback(yyv652, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv654 := &x.ImageMinimumGCAge
		yym655 := z.DecBinary()
		_ = yym655
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv654) {
		} else if !yym655 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv654)
		} else {
			z.DecFallback(yyv654, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCHighThresholdPercent = 0
	} else {
		x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCLowThresholdPercent = 0
	} else {
		x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LowDiskSpaceThresholdMB = 0
	} else {
		x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv659 := &x.VolumeStatsAggPeriod
		yym660 := z.DecBinary()
		_ = yym660
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv659) {
		} else if !yym660 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv659)
		} else {
			z.DecFallback(yyv659, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginName = ""
	} else {
		x.NetworkPluginName = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginMTU = 0
	} else {
		x.NetworkPluginMTU = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginDir = ""
	} else {
		x.NetworkPluginDir = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIConfDir = ""
	} else {
		x.CNIConfDir = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIBinDir = ""
	} else {
		x.CNIBinDir = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePluginDir = ""
	} else {
		x.VolumePluginDir = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletCgroups = ""
	} else {
		x.KubeletCgroups = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupsPerQOS = false
	} else {
		x.CgroupsPerQOS = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeCgroups = ""
	} else {
		x.RuntimeCgroups = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemCgroups = ""
	} else {
		x.SystemCgroups = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupRoot = ""
	} else {
		x.CgroupRoot = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntime = ""
	} else {
		x.ContainerRuntime = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteRuntimeEndpoint = ""
	} else {
		x.RemoteRuntimeEndpoint = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteImageEndpoint = ""
	} else {
		x.RemoteImageEndpoint = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv677 := &x.RuntimeRequestTimeout
		yym678 := z.DecBinary()
		_ = yym678
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv677) {
		} else if !yym678 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv677)
		} else {
			z.DecFallback(yyv677, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktPath = ""
	} else {
		x.RktPath = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktAPIEndpoint = ""
	} else {
		x.RktAPIEndpoint = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktStage1Image = ""
	} else {
		x.RktStage1Image = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LockFilePath = ""
	} else {
		x.LockFilePath = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitOnLockContention = false
	} else {
		x.ExitOnLockContention = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCBR0 = false
	} else {
		x.ConfigureCBR0 = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HairpinMode = ""
	} else {
		x.HairpinMode = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BabysitDaemons = false
	} else {
		x.BabysitDaemons = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPods = 0
	} else {
		x.MaxPods = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NvidiaGPUs = 0
	} else {
		x.NvidiaGPUs = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerExecHandlerName = ""
	} else {
		x.DockerExecHandlerName = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResolverConfig = ""
	} else {
		x.ResolverConfig = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CPUCFSQuota = false
	} else {
		x.CPUCFSQuota = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containerized = false
	} else {
		x.Containerized = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxOpenFiles = 0
	} else {
		x.MaxOpenFiles = int64(r.DecodeInt(64))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcileCIDR = false
	} else {
		x.ReconcileCIDR = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterSchedulable = false
	} else {
		x.RegisterSchedulable = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SerializeImagePulls = false
	} else {
		x.SerializeImagePulls = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalFlannelOverlay = false
	} else {
		x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv702 := &x.OutOfDiskTransitionFrequency
		yym703 := z.DecBinary()
		_ = yym703
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv702) {
		} else if !yym703 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv702)
		} else {
			z.DecFallback(yyv702, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeIP = ""
	} else {
		x.NodeIP = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeLabels = nil
	} else {
		yyv705 := &x.NodeLabels
		yym706 := z.DecBinary()
		_ = yym706
		if false {
		} else {
			z.F.DecMapStringStringX(yyv705, false, d)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonMasqueradeCIDR = ""
	} else {
		x.NonMasqueradeCIDR = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCustomMetrics = false
	} else {
		x.EnableCustomMetrics = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionHard = ""
	} else {
		x.EvictionHard = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoft = ""
	} else {
		x.EvictionSoft = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoftGracePeriod = ""
	} else {
		x.EvictionSoftGracePeriod = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv712 := &x.EvictionPressureTransitionPeriod
		yym713 := z.DecBinary()
		_ = yym713
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv712) {
		} else if !yym713 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv712)
		} else {
			z.DecFallback(yyv712, false)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMaxPodGracePeriod = 0
	} else {
		x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMinimumReclaim = ""
	} else {
		x.EvictionMinimumReclaim = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodsPerCore = 0
	} else {
		x.PodsPerCore = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableControllerAttachDetach = false
	} else {
		x.EnableControllerAttachDetach = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemReserved = nil
	} else {
		yyv718 := &x.SystemReserved
		yym719 := z.DecBinary()
		_ = yym719
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv718) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv718), d)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeReserved = nil
	} else {
		yyv720 := &x.KubeReserved
		yym721 := z.DecBinary()
		_ = yym721
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv720) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv720), d)
		}
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProtectKernelDefaults = false
	} else {
		x.ProtectKernelDefaults = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MakeIPTablesUtilChains = false
	} else {
		x.MakeIPTablesUtilChains = bool(r.DecodeBool())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMasqueradeBit = 0
	} else {
		x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesDropBit = 0
	} else {
		x.IPTablesDropBit = int32(r.DecodeInt(32))
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedUnsafeSysctls = nil
	} else {
		yyv726 := &x.AllowedUnsafeSysctls
		yym727 := z.DecBinary()
		_ = yym727
		if false {
		} else {
			z.F.DecSliceStringX(yyv726, false, d)
		}
	}
	for {
		yyj602++
		if yyhl602 {
			yyb602 = yyj602 > l
		} else {
			yyb602 = r.CheckBreak()
		}
		if yyb602 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj602-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeSchedulerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym728 := z.EncBinary()
		_ = yym728
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep729 := !z.EncBinary()
			yy2arr729 := z.EncBasicHandle().StructToArray
			var yyq729 [14]bool
			_, _, _ = yysep729, yyq729, yy2arr729
			const yyr729 bool = false
			yyq729[0] = x.Kind != ""
			yyq729[1] = x.APIVersion != ""
			var yynn729 int
			if yyr729 || yy2arr729 {
				r.EncodeArrayStart(14)
			} else {
				yynn729 = 12
				for _, b := range yyq729 {
					if b {
						yynn729++
					}
				}
				r.EncodeMapStart(yynn729)
				yynn729 = 0
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq729[0] {
					yym731 := z.EncBinary()
					_ = yym731
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq729[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym732 := z.EncBinary()
					_ = yym732
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq729[1] {
					yym734 := z.EncBinary()
					_ = yym734
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq729[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym735 := z.EncBinary()
					_ = yym735
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym737 := z.EncBinary()
				_ = yym737
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym738 := z.EncBinary()
				_ = yym738
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym740 := z.EncBinary()
				_ = yym740
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym741 := z.EncBinary()
				_ = yym741
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym743 := z.EncBinary()
				_ = yym743
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("algorithmProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym744 := z.EncBinary()
				_ = yym744
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym746 := z.EncBinary()
				_ = yym746
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("policyConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym747 := z.EncBinary()
				_ = yym747
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym749 := z.EncBinary()
				_ = yym749
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym750 := z.EncBinary()
				_ = yym750
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym752 := z.EncBinary()
				_ = yym752
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym753 := z.EncBinary()
				_ = yym753
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym755 := z.EncBinary()
				_ = yym755
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym756 := z.EncBinary()
				_ = yym756
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym758 := z.EncBinary()
				_ = yym758
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym759 := z.EncBinary()
				_ = yym759
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym761 := z.EncBinary()
				_ = yym761
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym762 := z.EncBinary()
				_ = yym762
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym764 := z.EncBinary()
				_ = yym764
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hardPodAffinitySymmetricWeight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym765 := z.EncBinary()
				_ = yym765
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym767 := z.EncBinary()
				_ = yym767
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("failureDomains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym768 := z.EncBinary()
				_ = yym768
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy770 := &x.LeaderElection
				yy770.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy771 := &x.LeaderElection
				yy771.CodecEncodeSelf(e)
			}
			if yyr729 || yy2arr729 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeSchedulerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym772 := z.DecBinary()
	_ = yym772
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct773 := r.ContainerType()
		if yyct773 == codecSelferValueTypeMap1234 {
			yyl773 := r.ReadMapStart()
			if yyl773 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl773, d)
			}
		} else if yyct773 == codecSelferValueTypeArray1234 {
			yyl773 := r.ReadArrayStart()
			if yyl773 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl773, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys774Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys774Slc
	var yyhl774 bool = l >= 0
	for yyj774 := 0; ; yyj774++ {
		if yyhl774 {
			if yyj774 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys774Slc = r.DecodeBytes(yys774Slc, true, true)
		yys774 := string(yys774Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys774 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "algorithmProvider":
			if r.TryDecodeAsNil() {
				x.AlgorithmProvider = ""
			} else {
				x.AlgorithmProvider = string(r.DecodeString())
			}
		case "policyConfigFile":
			if r.TryDecodeAsNil() {
				x.PolicyConfigFile = ""
			} else {
				x.PolicyConfigFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				x.SchedulerName = string(r.DecodeString())
			}
		case "hardPodAffinitySymmetricWeight":
			if r.TryDecodeAsNil() {
				x.HardPodAffinitySymmetricWeight = 0
			} else {
				x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failureDomains":
			if r.TryDecodeAsNil() {
				x.FailureDomains = ""
			} else {
				x.FailureDomains = string(r.DecodeString())
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv788 := &x.LeaderElection
				yyv788.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys774)
		} // end switch yys774
	} // end for yyj774
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj789 int
	var yyb789 bool
	var yyhl789 bool = l >= 0
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AlgorithmProvider = ""
	} else {
		x.AlgorithmProvider = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PolicyConfigFile = ""
	} else {
		x.PolicyConfigFile = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		x.SchedulerName = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HardPodAffinitySymmetricWeight = 0
	} else {
		x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureDomains = ""
	} else {
		x.FailureDomains = string(r.DecodeString())
	}
	yyj789++
	if yyhl789 {
		yyb789 = yyj789 > l
	} else {
		yyb789 = r.CheckBreak()
	}
	if yyb789 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv803 := &x.LeaderElection
		yyv803.CodecDecodeSelf(d)
	}
	for {
		yyj789++
		if yyhl789 {
			yyb789 = yyj789 > l
		} else {
			yyb789 = r.CheckBreak()
		}
		if yyb789 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj789-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym804 := z.EncBinary()
		_ = yym804
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep805 := !z.EncBinary()
			yy2arr805 := z.EncBasicHandle().StructToArray
			var yyq805 [4]bool
			_, _, _ = yysep805, yyq805, yy2arr805
			const yyr805 bool = false
			var yynn805 int
			if yyr805 || yy2arr805 {
				r.EncodeArrayStart(4)
			} else {
				yynn805 = 4
				for _, b := range yyq805 {
					if b {
						yynn805++
					}
				}
				r.EncodeMapStart(yynn805)
				yynn805 = 0
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym807 := z.EncBinary()
				_ = yym807
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym808 := z.EncBinary()
				_ = yym808
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy810 := &x.LeaseDuration
				yym811 := z.EncBinary()
				_ = yym811
				if false {
				} else if z.HasExtensions() && z.EncExt(yy810) {
				} else if !yym811 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy810)
				} else {
					z.EncFallback(yy810)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy812 := &x.LeaseDuration
				yym813 := z.EncBinary()
				_ = yym813
				if false {
				} else if z.HasExtensions() && z.EncExt(yy812) {
				} else if !yym813 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy812)
				} else {
					z.EncFallback(yy812)
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy815 := &x.RenewDeadline
				yym816 := z.EncBinary()
				_ = yym816
				if false {
				} else if z.HasExtensions() && z.EncExt(yy815) {
				} else if !yym816 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy815)
				} else {
					z.EncFallback(yy815)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy817 := &x.RenewDeadline
				yym818 := z.EncBinary()
				_ = yym818
				if false {
				} else if z.HasExtensions() && z.EncExt(yy817) {
				} else if !yym818 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy817)
				} else {
					z.EncFallback(yy817)
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy820 := &x.RetryPeriod
				yym821 := z.EncBinary()
				_ = yym821
				if false {
				} else if z.HasExtensions() && z.EncExt(yy820) {
				} else if !yym821 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy820)
				} else {
					z.EncFallback(yy820)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy822 := &x.RetryPeriod
				yym823 := z.EncBinary()
				_ = yym823
				if false {
				} else if z.HasExtensions() && z.EncExt(yy822) {
				} else if !yym823 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy822)
				} else {
					z.EncFallback(yy822)
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym824 := z.DecBinary()
	_ = yym824
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct825 := r.ContainerType()
		if yyct825 == codecSelferValueTypeMap1234 {
			yyl825 := r.ReadMapStart()
			if yyl825 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl825, d)
			}
		} else if yyct825 == codecSelferValueTypeArray1234 {
			yyl825 := r.ReadArrayStart()
			if yyl825 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl825, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys826Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys826Slc
	var yyhl826 bool = l >= 0
	for yyj826 := 0; ; yyj826++ {
		if yyhl826 {
			if yyj826 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys826Slc = r.DecodeBytes(yys826Slc, true, true)
		yys826 := string(yys826Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys826 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_unversioned.Duration{}
			} else {
				yyv828 := &x.LeaseDuration
				yym829 := z.DecBinary()
				_ = yym829
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv828) {
				} else if !yym829 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv828)
				} else {
					z.DecFallback(yyv828, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_unversioned.Duration{}
			} else {
				yyv830 := &x.RenewDeadline
				yym831 := z.DecBinary()
				_ = yym831
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv830) {
				} else if !yym831 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv830)
				} else {
					z.DecFallback(yyv830, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv832 := &x.RetryPeriod
				yym833 := z.DecBinary()
				_ = yym833
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv832) {
				} else if !yym833 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv832)
				} else {
					z.DecFallback(yyv832, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys826)
		} // end switch yys826
	} // end for yyj826
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj834 int
	var yyb834 bool
	var yyhl834 bool = l >= 0
	yyj834++
	if yyhl834 {
		yyb834 = yyj834 > l
	} else {
		yyb834 = r.CheckBreak()
	}
	if yyb834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj834++
	if yyhl834 {
		yyb834 = yyj834 > l
	} else {
		yyb834 = r.CheckBreak()
	}
	if yyb834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_unversioned.Duration{}
	} else {
		yyv836 := &x.LeaseDuration
		yym837 := z.DecBinary()
		_ = yym837
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv836) {
		} else if !yym837 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv836)
		} else {
			z.DecFallback(yyv836, false)
		}
	}
	yyj834++
	if yyhl834 {
		yyb834 = yyj834 > l
	} else {
		yyb834 = r.CheckBreak()
	}
	if yyb834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_unversioned.Duration{}
	} else {
		yyv838 := &x.RenewDeadline
		yym839 := z.DecBinary()
		_ = yym839
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv838) {
		} else if !yym839 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv838)
		} else {
			z.DecFallback(yyv838, false)
		}
	}
	yyj834++
	if yyhl834 {
		yyb834 = yyj834 > l
	} else {
		yyb834 = r.CheckBreak()
	}
	if yyb834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv840 := &x.RetryPeriod
		yym841 := z.DecBinary()
		_ = yym841
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv840) {
		} else if !yym841 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv840)
		} else {
			z.DecFallback(yyv840, false)
		}
	}
	for {
		yyj834++
		if yyhl834 {
			yyb834 = yyj834 > l
		} else {
			yyb834 = r.CheckBreak()
		}
		if yyb834 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj834-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeControllerManagerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym842 := z.EncBinary()
		_ = yym842
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep843 := !z.EncBinary()
			yy2arr843 := z.EncBasicHandle().StructToArray
			var yyq843 [59]bool
			_, _, _ = yysep843, yyq843, yy2arr843
			const yyr843 bool = false
			yyq843[0] = x.Kind != ""
			yyq843[1] = x.APIVersion != ""
			var yynn843 int
			if yyr843 || yy2arr843 {
				r.EncodeArrayStart(59)
			} else {
				yynn843 = 57
				for _, b := range yyq843 {
					if b {
						yynn843++
					}
				}
				r.EncodeMapStart(yynn843)
				yynn843 = 0
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq843[0] {
					yym845 := z.EncBinary()
					_ = yym845
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq843[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym846 := z.EncBinary()
					_ = yym846
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq843[1] {
					yym848 := z.EncBinary()
					_ = yym848
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq843[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym849 := z.EncBinary()
					_ = yym849
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym851 := z.EncBinary()
				_ = yym851
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym852 := z.EncBinary()
				_ = yym852
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym854 := z.EncBinary()
				_ = yym854
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym855 := z.EncBinary()
				_ = yym855
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym857 := z.EncBinary()
				_ = yym857
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym858 := z.EncBinary()
				_ = yym858
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym860 := z.EncBinary()
				_ = yym860
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym861 := z.EncBinary()
				_ = yym861
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym863 := z.EncBinary()
				_ = yym863
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentEndpointSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym864 := z.EncBinary()
				_ = yym864
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym866 := z.EncBinary()
				_ = yym866
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRSSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym867 := z.EncBinary()
				_ = yym867
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym869 := z.EncBinary()
				_ = yym869
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym870 := z.EncBinary()
				_ = yym870
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym872 := z.EncBinary()
				_ = yym872
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentServiceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym873 := z.EncBinary()
				_ = yym873
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym875 := z.EncBinary()
				_ = yym875
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentResourceQuotaSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym876 := z.EncBinary()
				_ = yym876
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym878 := z.EncBinary()
				_ = yym878
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDeploymentSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym879 := z.EncBinary()
				_ = yym879
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym881 := z.EncBinary()
				_ = yym881
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDaemonSetSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym882 := z.EncBinary()
				_ = yym882
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym884 := z.EncBinary()
				_ = yym884
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentJobSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym885 := z.EncBinary()
				_ = yym885
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym887 := z.EncBinary()
				_ = yym887
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentNamespaceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym888 := z.EncBinary()
				_ = yym888
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym890 := z.EncBinary()
				_ = yym890
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentSATokenSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym891 := z.EncBinary()
				_ = yym891
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym893 := z.EncBinary()
				_ = yym893
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRC"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym894 := z.EncBinary()
				_ = yym894
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym896 := z.EncBinary()
				_ = yym896
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym897 := z.EncBinary()
				_ = yym897
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym899 := z.EncBinary()
				_ = yym899
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForDaemonSet"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym900 := z.EncBinary()
				_ = yym900
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy902 := &x.ServiceSyncPeriod
				yym903 := z.EncBinary()
				_ = yym903
				if false {
				} else if z.HasExtensions() && z.EncExt(yy902) {
				} else if !yym903 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy902)
				} else {
					z.EncFallback(yy902)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy904 := &x.ServiceSyncPeriod
				yym905 := z.EncBinary()
				_ = yym905
				if false {
				} else if z.HasExtensions() && z.EncExt(yy904) {
				} else if !yym905 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy904)
				} else {
					z.EncFallback(yy904)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy907 := &x.NodeSyncPeriod
				yym908 := z.EncBinary()
				_ = yym908
				if false {
				} else if z.HasExtensions() && z.EncExt(yy907) {
				} else if !yym908 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy907)
				} else {
					z.EncFallback(yy907)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy909 := &x.NodeSyncPeriod
				yym910 := z.EncBinary()
				_ = yym910
				if false {
				} else if z.HasExtensions() && z.EncExt(yy909) {
				} else if !yym910 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy909)
				} else {
					z.EncFallback(yy909)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy912 := &x.ResourceQuotaSyncPeriod
				yym913 := z.EncBinary()
				_ = yym913
				if false {
				} else if z.HasExtensions() && z.EncExt(yy912) {
				} else if !yym913 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy912)
				} else {
					z.EncFallback(yy912)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceQuotaSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy914 := &x.ResourceQuotaSyncPeriod
				yym915 := z.EncBinary()
				_ = yym915
				if false {
				} else if z.HasExtensions() && z.EncExt(yy914) {
				} else if !yym915 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy914)
				} else {
					z.EncFallback(yy914)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy917 := &x.NamespaceSyncPeriod
				yym918 := z.EncBinary()
				_ = yym918
				if false {
				} else if z.HasExtensions() && z.EncExt(yy917) {
				} else if !yym918 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy917)
				} else {
					z.EncFallback(yy917)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy919 := &x.NamespaceSyncPeriod
				yym920 := z.EncBinary()
				_ = yym920
				if false {
				} else if z.HasExtensions() && z.EncExt(yy919) {
				} else if !yym920 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy919)
				} else {
					z.EncFallback(yy919)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy922 := &x.PVClaimBinderSyncPeriod
				yym923 := z.EncBinary()
				_ = yym923
				if false {
				} else if z.HasExtensions() && z.EncExt(yy922) {
				} else if !yym923 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy922)
				} else {
					z.EncFallback(yy922)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pvClaimBinderSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy924 := &x.PVClaimBinderSyncPeriod
				yym925 := z.EncBinary()
				_ = yym925
				if false {
				} else if z.HasExtensions() && z.EncExt(yy924) {
				} else if !yym925 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy924)
				} else {
					z.EncFallback(yy924)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy927 := &x.MinResyncPeriod
				yym928 := z.EncBinary()
				_ = yym928
				if false {
				} else if z.HasExtensions() && z.EncExt(yy927) {
				} else if !yym928 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy927)
				} else {
					z.EncFallback(yy927)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minResyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy929 := &x.MinResyncPeriod
				yym930 := z.EncBinary()
				_ = yym930
				if false {
				} else if z.HasExtensions() && z.EncExt(yy929) {
				} else if !yym930 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy929)
				} else {
					z.EncFallback(yy929)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym932 := z.EncBinary()
				_ = yym932
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("terminatedPodGCThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym933 := z.EncBinary()
				_ = yym933
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy935 := &x.HorizontalPodAutoscalerSyncPeriod
				yym936 := z.EncBinary()
				_ = yym936
				if false {
				} else if z.HasExtensions() && z.EncExt(yy935) {
				} else if !yym936 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy935)
				} else {
					z.EncFallback(yy935)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("horizontalPodAutoscalerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy937 := &x.HorizontalPodAutoscalerSyncPeriod
				yym938 := z.EncBinary()
				_ = yym938
				if false {
				} else if z.HasExtensions() && z.EncExt(yy937) {
				} else if !yym938 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy937)
				} else {
					z.EncFallback(yy937)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy940 := &x.DeploymentControllerSyncPeriod
				yym941 := z.EncBinary()
				_ = yym941
				if false {
				} else if z.HasExtensions() && z.EncExt(yy940) {
				} else if !yym941 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy940)
				} else {
					z.EncFallback(yy940)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deploymentControllerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy942 := &x.DeploymentControllerSyncPeriod
				yym943 := z.EncBinary()
				_ = yym943
				if false {
				} else if z.HasExtensions() && z.EncExt(yy942) {
				} else if !yym943 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy942)
				} else {
					z.EncFallback(yy942)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy945 := &x.PodEvictionTimeout
				yym946 := z.EncBinary()
				_ = yym946
				if false {
				} else if z.HasExtensions() && z.EncExt(yy945) {
				} else if !yym946 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy945)
				} else {
					z.EncFallback(yy945)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podEvictionTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy947 := &x.PodEvictionTimeout
				yym948 := z.EncBinary()
				_ = yym948
				if false {
				} else if z.HasExtensions() && z.EncExt(yy947) {
				} else if !yym948 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy947)
				} else {
					z.EncFallback(yy947)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym950 := z.EncBinary()
				_ = yym950
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsQps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym951 := z.EncBinary()
				_ = yym951
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym953 := z.EncBinary()
				_ = yym953
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym954 := z.EncBinary()
				_ = yym954
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy956 := &x.NodeMonitorGracePeriod
				yym957 := z.EncBinary()
				_ = yym957
				if false {
				} else if z.HasExtensions() && z.EncExt(yy956) {
				} else if !yym957 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy956)
				} else {
					z.EncFallback(yy956)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy958 := &x.NodeMonitorGracePeriod
				yym959 := z.EncBinary()
				_ = yym959
				if false {
				} else if z.HasExtensions() && z.EncExt(yy958) {
				} else if !yym959 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy958)
				} else {
					z.EncFallback(yy958)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym961 := z.EncBinary()
				_ = yym961
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerRetryCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym962 := z.EncBinary()
				_ = yym962
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy964 := &x.NodeStartupGracePeriod
				yym965 := z.EncBinary()
				_ = yym965
				if false {
				} else if z.HasExtensions() && z.EncExt(yy964) {
				} else if !yym965 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy964)
				} else {
					z.EncFallback(yy964)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStartupGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy966 := &x.NodeStartupGracePeriod
				yym967 := z.EncBinary()
				_ = yym967
				if false {
				} else if z.HasExtensions() && z.EncExt(yy966) {
				} else if !yym967 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy966)
				} else {
					z.EncFallback(yy966)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy969 := &x.NodeMonitorPeriod
				yym970 := z.EncBinary()
				_ = yym970
				if false {
				} else if z.HasExtensions() && z.EncExt(yy969) {
				} else if !yym970 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy969)
				} else {
					z.EncFallback(yy969)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy971 := &x.NodeMonitorPeriod
				yym972 := z.EncBinary()
				_ = yym972
				if false {
				} else if z.HasExtensions() && z.EncExt(yy971) {
				} else if !yym972 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy971)
				} else {
					z.EncFallback(yy971)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym974 := z.EncBinary()
				_ = yym974
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym975 := z.EncBinary()
				_ = yym975
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym977 := z.EncBinary()
				_ = yym977
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym978 := z.EncBinary()
				_ = yym978
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym980 := z.EncBinary()
				_ = yym980
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym981 := z.EncBinary()
				_ = yym981
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym983 := z.EncBinary()
				_ = yym983
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("approveAllKubeletCSRsForGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym984 := z.EncBinary()
				_ = yym984
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym986 := z.EncBinary()
				_ = yym986
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym987 := z.EncBinary()
				_ = yym987
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym989 := z.EncBinary()
				_ = yym989
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym990 := z.EncBinary()
				_ = yym990
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym992 := z.EncBinary()
				_ = yym992
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym993 := z.EncBinary()
				_ = yym993
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym995 := z.EncBinary()
				_ = yym995
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym996 := z.EncBinary()
				_ = yym996
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym998 := z.EncBinary()
				_ = yym998
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeCIDRMaskSize"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym999 := z.EncBinary()
				_ = yym999
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1001 := z.EncBinary()
				_ = yym1001
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allocateNodeCIDRs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1002 := z.EncBinary()
				_ = yym1002
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1004 := z.EncBinary()
				_ = yym1004
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCloudRoutes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1005 := z.EncBinary()
				_ = yym1005
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1007 := z.EncBinary()
				_ = yym1007
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1008 := z.EncBinary()
				_ = yym1008
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1010 := z.EncBinary()
				_ = yym1010
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1011 := z.EncBinary()
				_ = yym1011
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1013 := z.EncBinary()
				_ = yym1013
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1014 := z.EncBinary()
				_ = yym1014
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1016 := z.EncBinary()
				_ = yym1016
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1017 := z.EncBinary()
				_ = yym1017
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1019 := &x.LeaderElection
				yy1019.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1020 := &x.LeaderElection
				yy1020.CodecEncodeSelf(e)
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1022 := &x.VolumeConfiguration
				yy1022.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1023 := &x.VolumeConfiguration
				yy1023.CodecEncodeSelf(e)
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1025 := &x.ControllerStartInterval
				yym1026 := z.EncBinary()
				_ = yym1026
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1025) {
				} else if !yym1026 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1025)
				} else {
					z.EncFallback(yy1025)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("controllerStartInterval"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1027 := &x.ControllerStartInterval
				yym1028 := z.EncBinary()
				_ = yym1028
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1027) {
				} else if !yym1028 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1027)
				} else {
					z.EncFallback(yy1027)
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1030 := z.EncBinary()
				_ = yym1030
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableGarbageCollector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1031 := z.EncBinary()
				_ = yym1031
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1033 := z.EncBinary()
				_ = yym1033
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentGCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1034 := z.EncBinary()
				_ = yym1034
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1036 := z.EncBinary()
				_ = yym1036
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1037 := z.EncBinary()
				_ = yym1037
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1039 := z.EncBinary()
				_ = yym1039
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secondaryNodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1040 := z.EncBinary()
				_ = yym1040
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1042 := z.EncBinary()
				_ = yym1042
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("largeClusterSizeThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1045 := z.EncBinary()
				_ = yym1045
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("unhealthyZoneThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1046 := z.EncBinary()
				_ = yym1046
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeControllerManagerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1047 := z.DecBinary()
	_ = yym1047
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1048 := r.ContainerType()
		if yyct1048 == codecSelferValueTypeMap1234 {
			yyl1048 := r.ReadMapStart()
			if yyl1048 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1048, d)
			}
		} else if yyct1048 == codecSelferValueTypeArray1234 {
			yyl1048 := r.ReadArrayStart()
			if yyl1048 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1048, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1049Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1049Slc
	var yyhl1049 bool = l >= 0
	for yyj1049 := 0; ; yyj1049++ {
		if yyhl1049 {
			if yyj1049 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1049Slc = r.DecodeBytes(yys1049Slc, true, true)
		yys1049 := string(yys1049Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1049 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "concurrentEndpointSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentEndpointSyncs = 0
			} else {
				x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRSSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRSSyncs = 0
			} else {
				x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRCSyncs = 0
			} else {
				x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentServiceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentServiceSyncs = 0
			} else {
				x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentResourceQuotaSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentResourceQuotaSyncs = 0
			} else {
				x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDeploymentSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDeploymentSyncs = 0
			} else {
				x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDaemonSetSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDaemonSetSyncs = 0
			} else {
				x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentJobSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentJobSyncs = 0
			} else {
				x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentNamespaceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentNamespaceSyncs = 0
			} else {
				x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentSATokenSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentSATokenSyncs = 0
			} else {
				x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRC":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRC = 0
			} else {
				x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRS":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRS = 0
			} else {
				x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForDaemonSet":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForDaemonSet = 0
			} else {
				x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
			}
		case "serviceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1069 := &x.ServiceSyncPeriod
				yym1070 := z.DecBinary()
				_ = yym1070
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1069) {
				} else if !yym1070 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1069)
				} else {
					z.DecFallback(yyv1069, false)
				}
			}
		case "nodeSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NodeSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1071 := &x.NodeSyncPeriod
				yym1072 := z.DecBinary()
				_ = yym1072
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1071) {
				} else if !yym1072 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1071)
				} else {
					z.DecFallback(yyv1071, false)
				}
			}
		case "resourceQuotaSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1073 := &x.ResourceQuotaSyncPeriod
				yym1074 := z.DecBinary()
				_ = yym1074
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1073) {
				} else if !yym1074 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1073)
				} else {
					z.DecFallback(yyv1073, false)
				}
			}
		case "namespaceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1075 := &x.NamespaceSyncPeriod
				yym1076 := z.DecBinary()
				_ = yym1076
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1075) {
				} else if !yym1076 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1075)
				} else {
					z.DecFallback(yyv1075, false)
				}
			}
		case "pvClaimBinderSyncPeriod":
			if r.TryDecodeAsNil() {
				x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1077 := &x.PVClaimBinderSyncPeriod
				yym1078 := z.DecBinary()
				_ = yym1078
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1077) {
				} else if !yym1078 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1077)
				} else {
					z.DecFallback(yyv1077, false)
				}
			}
		case "minResyncPeriod":
			if r.TryDecodeAsNil() {
				x.MinResyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1079 := &x.MinResyncPeriod
				yym1080 := z.DecBinary()
				_ = yym1080
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1079) {
				} else if !yym1080 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1079)
				} else {
					z.DecFallback(yyv1079, false)
				}
			}
		case "terminatedPodGCThreshold":
			if r.TryDecodeAsNil() {
				x.TerminatedPodGCThreshold = 0
			} else {
				x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
			}
		case "horizontalPodAutoscalerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1082 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1083 := z.DecBinary()
				_ = yym1083
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1082) {
				} else if !yym1083 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1082)
				} else {
					z.DecFallback(yyv1082, false)
				}
			}
		case "deploymentControllerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1084 := &x.DeploymentControllerSyncPeriod
				yym1085 := z.DecBinary()
				_ = yym1085
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1084) {
				} else if !yym1085 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1084)
				} else {
					z.DecFallback(yyv1084, false)
				}
			}
		case "podEvictionTimeout":
			if r.TryDecodeAsNil() {
				x.PodEvictionTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv1086 := &x.PodEvictionTimeout
				yym1087 := z.DecBinary()
				_ = yym1087
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1086) {
				} else if !yym1087 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1086)
				} else {
					z.DecFallback(yyv1086, false)
				}
			}
		case "deletingPodsQps":
			if r.TryDecodeAsNil() {
				x.DeletingPodsQps = 0
			} else {
				x.DeletingPodsQps = float32(r.DecodeFloat(true))
			}
		case "deletingPodsBurst":
			if r.TryDecodeAsNil() {
				x.DeletingPodsBurst = 0
			} else {
				x.DeletingPodsBurst = int32(r.DecodeInt(32))
			}
		case "nodeMonitorGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1090 := &x.NodeMonitorGracePeriod
				yym1091 := z.DecBinary()
				_ = yym1091
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1090) {
				} else if !yym1091 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1090)
				} else {
					z.DecFallback(yyv1090, false)
				}
			}
		case "registerRetryCount":
			if r.TryDecodeAsNil() {
				x.RegisterRetryCount = 0
			} else {
				x.RegisterRetryCount = int32(r.DecodeInt(32))
			}
		case "nodeStartupGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1093 := &x.NodeStartupGracePeriod
				yym1094 := z.DecBinary()
				_ = yym1094
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1093) {
				} else if !yym1094 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1093)
				} else {
					z.DecFallback(yyv1093, false)
				}
			}
		case "nodeMonitorPeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1095 := &x.NodeMonitorPeriod
				yym1096 := z.DecBinary()
				_ = yym1096
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1095) {
				} else if !yym1096 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1095)
				} else {
					z.DecFallback(yyv1095, false)
				}
			}
		case "serviceAccountKeyFile":
			if r.TryDecodeAsNil() {
				x.ServiceAccountKeyFile = ""
			} else {
				x.ServiceAccountKeyFile = string(r.DecodeString())
			}
		case "clusterSigningCertFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningCertFile = ""
			} else {
				x.ClusterSigningCertFile = string(r.DecodeString())
			}
		case "clusterSigningKeyFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningKeyFile = ""
			} else {
				x.ClusterSigningKeyFile = string(r.DecodeString())
			}
		case "approveAllKubeletCSRsForGroup":
			if r.TryDecodeAsNil() {
				x.ApproveAllKubeletCSRsForGroup = ""
			} else {
				x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "serviceCIDR":
			if r.TryDecodeAsNil() {
				x.ServiceCIDR = ""
			} else {
				x.ServiceCIDR = string(r.DecodeString())
			}
		case "nodeCIDRMaskSize":
			if r.TryDecodeAsNil() {
				x.NodeCIDRMaskSize = 0
			} else {
				x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
			}
		case "allocateNodeCIDRs":
			if r.TryDecodeAsNil() {
				x.AllocateNodeCIDRs = false
			} else {
				x.AllocateNodeCIDRs = bool(r.DecodeBool())
			}
		case "configureCloudRoutes":
			if r.TryDecodeAsNil() {
				x.ConfigureCloudRoutes = false
			} else {
				x.ConfigureCloudRoutes = bool(r.DecodeBool())
			}
		case "rootCAFile":
			if r.TryDecodeAsNil() {
				x.RootCAFile = ""
			} else {
				x.RootCAFile = string(r.DecodeString())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv1112 := &x.LeaderElection
				yyv1112.CodecDecodeSelf(d)
			}
		case "volumeConfiguration":
			if r.TryDecodeAsNil() {
				x.VolumeConfiguration = VolumeConfiguration{}
			} else {
				yyv1113 := &x.VolumeConfiguration
				yyv1113.CodecDecodeSelf(d)
			}
		case "controllerStartInterval":
			if r.TryDecodeAsNil() {
				x.ControllerStartInterval = pkg1_unversioned.Duration{}
			} else {
				yyv1114 := &x.ControllerStartInterval
				yym1115 := z.DecBinary()
				_ = yym1115
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1114) {
				} else if !yym1115 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1114)
				} else {
					z.DecFallback(yyv1114, false)
				}
			}
		case "enableGarbageCollector":
			if r.TryDecodeAsNil() {
				x.EnableGarbageCollector = false
			} else {
				x.EnableGarbageCollector = bool(r.DecodeBool())
			}
		case "concurrentGCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentGCSyncs = 0
			} else {
				x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
			}
		case "nodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.NodeEvictionRate = 0
			} else {
				x.NodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "secondaryNodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.SecondaryNodeEvictionRate = 0
			} else {
				x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "largeClusterSizeThreshold":
			if r.TryDecodeAsNil() {
				x.LargeClusterSizeThreshold = 0
			} else {
				x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
			}
		case "unhealthyZoneThreshold":
			if r.TryDecodeAsNil() {
				x.UnhealthyZoneThreshold = 0
			} else {
				x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1049)
		} // end switch yys1049
	} // end for yyj1049
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1122 int
	var yyb1122 bool
	var yyhl1122 bool = l >= 0
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentEndpointSyncs = 0
	} else {
		x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRSSyncs = 0
	} else {
		x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRCSyncs = 0
	} else {
		x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentServiceSyncs = 0
	} else {
		x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentResourceQuotaSyncs = 0
	} else {
		x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDeploymentSyncs = 0
	} else {
		x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDaemonSetSyncs = 0
	} else {
		x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentJobSyncs = 0
	} else {
		x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentNamespaceSyncs = 0
	} else {
		x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentSATokenSyncs = 0
	} else {
		x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRC = 0
	} else {
		x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRS = 0
	} else {
		x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForDaemonSet = 0
	} else {
		x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1142 := &x.ServiceSyncPeriod
		yym1143 := z.DecBinary()
		_ = yym1143
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1142) {
		} else if !yym1143 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1142)
		} else {
			z.DecFallback(yyv1142, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1144 := &x.NodeSyncPeriod
		yym1145 := z.DecBinary()
		_ = yym1145
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1144) {
		} else if !yym1145 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1144)
		} else {
			z.DecFallback(yyv1144, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1146 := &x.ResourceQuotaSyncPeriod
		yym1147 := z.DecBinary()
		_ = yym1147
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1146) {
		} else if !yym1147 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1146)
		} else {
			z.DecFallback(yyv1146, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1148 := &x.NamespaceSyncPeriod
		yym1149 := z.DecBinary()
		_ = yym1149
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1148) {
		} else if !yym1149 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1148)
		} else {
			z.DecFallback(yyv1148, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1150 := &x.PVClaimBinderSyncPeriod
		yym1151 := z.DecBinary()
		_ = yym1151
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1150) {
		} else if !yym1151 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1150)
		} else {
			z.DecFallback(yyv1150, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinResyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1152 := &x.MinResyncPeriod
		yym1153 := z.DecBinary()
		_ = yym1153
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1152) {
		} else if !yym1153 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1152)
		} else {
			z.DecFallback(yyv1152, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminatedPodGCThreshold = 0
	} else {
		x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1155 := &x.HorizontalPodAutoscalerSyncPeriod
		yym1156 := z.DecBinary()
		_ = yym1156
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1155) {
		} else if !yym1156 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1155)
		} else {
			z.DecFallback(yyv1155, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1157 := &x.DeploymentControllerSyncPeriod
		yym1158 := z.DecBinary()
		_ = yym1158
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1157) {
		} else if !yym1158 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1157)
		} else {
			z.DecFallback(yyv1157, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodEvictionTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv1159 := &x.PodEvictionTimeout
		yym1160 := z.DecBinary()
		_ = yym1160
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1159) {
		} else if !yym1160 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1159)
		} else {
			z.DecFallback(yyv1159, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsQps = 0
	} else {
		x.DeletingPodsQps = float32(r.DecodeFloat(true))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsBurst = 0
	} else {
		x.DeletingPodsBurst = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1163 := &x.NodeMonitorGracePeriod
		yym1164 := z.DecBinary()
		_ = yym1164
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1163) {
		} else if !yym1164 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1163)
		} else {
			z.DecFallback(yyv1163, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterRetryCount = 0
	} else {
		x.RegisterRetryCount = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1166 := &x.NodeStartupGracePeriod
		yym1167 := z.DecBinary()
		_ = yym1167
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1166) {
		} else if !yym1167 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1166)
		} else {
			z.DecFallback(yyv1166, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1168 := &x.NodeMonitorPeriod
		yym1169 := z.DecBinary()
		_ = yym1169
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1168) {
		} else if !yym1169 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1168)
		} else {
			z.DecFallback(yyv1168, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountKeyFile = ""
	} else {
		x.ServiceAccountKeyFile = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningCertFile = ""
	} else {
		x.ClusterSigningCertFile = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningKeyFile = ""
	} else {
		x.ClusterSigningKeyFile = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ApproveAllKubeletCSRsForGroup = ""
	} else {
		x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceCIDR = ""
	} else {
		x.ServiceCIDR = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeCIDRMaskSize = 0
	} else {
		x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllocateNodeCIDRs = false
	} else {
		x.AllocateNodeCIDRs = bool(r.DecodeBool())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCloudRoutes = false
	} else {
		x.ConfigureCloudRoutes = bool(r.DecodeBool())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootCAFile = ""
	} else {
		x.RootCAFile = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv1185 := &x.LeaderElection
		yyv1185.CodecDecodeSelf(d)
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeConfiguration = VolumeConfiguration{}
	} else {
		yyv1186 := &x.VolumeConfiguration
		yyv1186.CodecDecodeSelf(d)
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ControllerStartInterval = pkg1_unversioned.Duration{}
	} else {
		yyv1187 := &x.ControllerStartInterval
		yym1188 := z.DecBinary()
		_ = yym1188
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1187) {
		} else if !yym1188 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1187)
		} else {
			z.DecFallback(yyv1187, false)
		}
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableGarbageCollector = false
	} else {
		x.EnableGarbageCollector = bool(r.DecodeBool())
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentGCSyncs = 0
	} else {
		x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeEvictionRate = 0
	} else {
		x.NodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecondaryNodeEvictionRate = 0
	} else {
		x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LargeClusterSizeThreshold = 0
	} else {
		x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
	}
	yyj1122++
	if yyhl1122 {
		yyb1122 = yyj1122 > l
	} else {
		yyb1122 = r.CheckBreak()
	}
	if yyb1122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnhealthyZoneThreshold = 0
	} else {
		x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
	}
	for {
		yyj1122++
		if yyhl1122 {
			yyb1122 = yyj1122 > l
		} else {
			yyb1122 = r.CheckBreak()
		}
		if yyb1122 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1122-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1195 := z.EncBinary()
		_ = yym1195
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1196 := !z.EncBinary()
			yy2arr1196 := z.EncBasicHandle().StructToArray
			var yyq1196 [4]bool
			_, _, _ = yysep1196, yyq1196, yy2arr1196
			const yyr1196 bool = false
			var yynn1196 int
			if yyr1196 || yy2arr1196 {
				r.EncodeArrayStart(4)
			} else {
				yynn1196 = 4
				for _, b := range yyq1196 {
					if b {
						yynn1196++
					}
				}
				r.EncodeMapStart(yynn1196)
				yynn1196 = 0
			}
			if yyr1196 || yy2arr1196 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1198 := z.EncBinary()
				_ = yym1198
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableHostPathProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1199 := z.EncBinary()
				_ = yym1199
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			}
			if yyr1196 || yy2arr1196 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1201 := z.EncBinary()
				_ = yym1201
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDynamicProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1202 := z.EncBinary()
				_ = yym1202
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			}
			if yyr1196 || yy2arr1196 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1204 := &x.PersistentVolumeRecyclerConfiguration
				yy1204.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("persitentVolumeRecyclerConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1205 := &x.PersistentVolumeRecyclerConfiguration
				yy1205.CodecEncodeSelf(e)
			}
			if yyr1196 || yy2arr1196 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1207 := z.EncBinary()
				_ = yym1207
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("flexVolumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1208 := z.EncBinary()
				_ = yym1208
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			}
			if yyr1196 || yy2arr1196 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1209 := z.DecBinary()
	_ = yym1209
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1210 := r.ContainerType()
		if yyct1210 == codecSelferValueTypeMap1234 {
			yyl1210 := r.ReadMapStart()
			if yyl1210 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1210, d)
			}
		} else if yyct1210 == codecSelferValueTypeArray1234 {
			yyl1210 := r.ReadArrayStart()
			if yyl1210 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1210, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1211Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1211Slc
	var yyhl1211 bool = l >= 0
	for yyj1211 := 0; ; yyj1211++ {
		if yyhl1211 {
			if yyj1211 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1211Slc = r.DecodeBytes(yys1211Slc, true, true)
		yys1211 := string(yys1211Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1211 {
		case "enableHostPathProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableHostPathProvisioning = false
			} else {
				x.EnableHostPathProvisioning = bool(r.DecodeBool())
			}
		case "enableDynamicProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableDynamicProvisioning = false
			} else {
				x.EnableDynamicProvisioning = bool(r.DecodeBool())
			}
		case "persitentVolumeRecyclerConfiguration":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
			} else {
				yyv1214 := &x.PersistentVolumeRecyclerConfiguration
				yyv1214.CodecDecodeSelf(d)
			}
		case "flexVolumePluginDir":
			if r.TryDecodeAsNil() {
				x.FlexVolumePluginDir = ""
			} else {
				x.FlexVolumePluginDir = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1211)
		} // end switch yys1211
	} // end for yyj1211
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1216 int
	var yyb1216 bool
	var yyhl1216 bool = l >= 0
	yyj1216++
	if yyhl1216 {
		yyb1216 = yyj1216 > l
	} else {
		yyb1216 = r.CheckBreak()
	}
	if yyb1216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableHostPathProvisioning = false
	} else {
		x.EnableHostPathProvisioning = bool(r.DecodeBool())
	}
	yyj1216++
	if yyhl1216 {
		yyb1216 = yyj1216 > l
	} else {
		yyb1216 = r.CheckBreak()
	}
	if yyb1216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDynamicProvisioning = false
	} else {
		x.EnableDynamicProvisioning = bool(r.DecodeBool())
	}
	yyj1216++
	if yyhl1216 {
		yyb1216 = yyj1216 > l
	} else {
		yyb1216 = r.CheckBreak()
	}
	if yyb1216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
	} else {
		yyv1219 := &x.PersistentVolumeRecyclerConfiguration
		yyv1219.CodecDecodeSelf(d)
	}
	yyj1216++
	if yyhl1216 {
		yyb1216 = yyj1216 > l
	} else {
		yyb1216 = r.CheckBreak()
	}
	if yyb1216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FlexVolumePluginDir = ""
	} else {
		x.FlexVolumePluginDir = string(r.DecodeString())
	}
	for {
		yyj1216++
		if yyhl1216 {
			yyb1216 = yyj1216 > l
		} else {
			yyb1216 = r.CheckBreak()
		}
		if yyb1216 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1216-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1221 := z.EncBinary()
		_ = yym1221
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1222 := !z.EncBinary()
			yy2arr1222 := z.EncBasicHandle().StructToArray
			var yyq1222 [7]bool
			_, _, _ = yysep1222, yyq1222, yy2arr1222
			const yyr1222 bool = false
			var yynn1222 int
			if yyr1222 || yy2arr1222 {
				r.EncodeArrayStart(7)
			} else {
				yynn1222 = 7
				for _, b := range yyq1222 {
					if b {
						yynn1222++
					}
				}
				r.EncodeMapStart(yynn1222)
				yynn1222 = 0
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1224 := z.EncBinary()
				_ = yym1224
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maximumRetry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1225 := z.EncBinary()
				_ = yym1225
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1227 := z.EncBinary()
				_ = yym1227
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1228 := z.EncBinary()
				_ = yym1228
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1230 := z.EncBinary()
				_ = yym1230
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1231 := z.EncBinary()
				_ = yym1231
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1233 := z.EncBinary()
				_ = yym1233
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1234 := z.EncBinary()
				_ = yym1234
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1236 := z.EncBinary()
				_ = yym1236
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1237 := z.EncBinary()
				_ = yym1237
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1239 := z.EncBinary()
				_ = yym1239
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1240 := z.EncBinary()
				_ = yym1240
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1242 := z.EncBinary()
				_ = yym1242
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1243 := z.EncBinary()
				_ = yym1243
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			}
			if yyr1222 || yy2arr1222 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1244 := z.DecBinary()
	_ = yym1244
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1245 := r.ContainerType()
		if yyct1245 == codecSelferValueTypeMap1234 {
			yyl1245 := r.ReadMapStart()
			if yyl1245 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1245, d)
			}
		} else if yyct1245 == codecSelferValueTypeArray1234 {
			yyl1245 := r.ReadArrayStart()
			if yyl1245 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1245, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1246Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1246Slc
	var yyhl1246 bool = l >= 0
	for yyj1246 := 0; ; yyj1246++ {
		if yyhl1246 {
			if yyj1246 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1246Slc = r.DecodeBytes(yys1246Slc, true, true)
		yys1246 := string(yys1246Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1246 {
		case "maximumRetry":
			if r.TryDecodeAsNil() {
				x.MaximumRetry = 0
			} else {
				x.MaximumRetry = int32(r.DecodeInt(32))
			}
		case "minimumTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutNFS = 0
			} else {
				x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathNFS":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathNFS = ""
			} else {
				x.PodTemplateFilePathNFS = string(r.DecodeString())
			}
		case "incrementTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutNFS = 0
			} else {
				x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathHostPath":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathHostPath = ""
			} else {
				x.PodTemplateFilePathHostPath = string(r.DecodeString())
			}
		case "minimumTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutHostPath = 0
			} else {
				x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
			}
		case "incrementTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutHostPath = 0
			} else {
				x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1246)
		} // end switch yys1246
	} // end for yyj1246
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1254 int
	var yyb1254 bool
	var yyhl1254 bool = l >= 0
	yyj1254++
	if yyhl1254 {
		yyb1254 = yyj1254 > l
	} else {
		yyb1254 = r.CheckBreak()
	}
	if yyb1254 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaximumRetry = 0
	} else {
		x.MaximumRetry = int32(r.DecodeInt(32))
	}
	yyj1254++
	if yyhl1254 {
		yyb1254 = yyj1254 > l
	} else {
		yyb1254 = r.CheckBreak()
	}
	if yyb1254 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutNFS = 0
	} else {
		x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1254++
	if yyhl1254 {
		yyb1254 = yyj1254 > l
	} else {
		yyb1254 = r.CheckBreak()
	}
	if yyb1254 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathNFS = ""
	} else {
		x.PodTemplateFilePathNFS = string(r.DecodeString())
	}
	yyj1254++
	if yyhl1254 {
		yyb1254 = yyj1254 > l
	} else {
		yyb1254 = r.CheckBreak()
	}
	if yyb1254 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutNFS = 0
	} else {
		x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1254++
	if yyhl1254 {
		yyb1254 = yyj1254 > l
	} else {
		yyb1254 = r.CheckBreak()
	}
	if yyb1254 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathHostPath = ""
	} else {
		x.PodTemplateFilePathHostPath = string(r.DecodeString())
	}
	yyj1254++
	if yyhl1254 {
		yyb1254 = yyj1254 > l
	} else {
		yyb1254 = r.CheckBreak()
	}
	if yyb1254 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutHostPath = 0
	} else {
		x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
	}
	yyj1254++
	if yyhl1254 {
		yyb1254 = yyj1254 > l
	} else {
		yyb1254 = r.CheckBreak()
	}
	if yyb1254 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutHostPath = 0
	} else {
		x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
	}
	for {
		yyj1254++
		if yyhl1254 {
			yyb1254 = yyj1254 > l
		} else {
			yyb1254 = r.CheckBreak()
		}
		if yyb1254 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1254-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encconfig_ConfigurationMap(v pkg2_config.ConfigurationMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk1262, yyv1262 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym1263 := z.EncBinary()
		_ = yym1263
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk1262))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yym1264 := z.EncBinary()
		_ = yym1264
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1262))
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decconfig_ConfigurationMap(v *pkg2_config.ConfigurationMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1265 := *v
	yyl1265 := r.ReadMapStart()
	yybh1265 := z.DecBasicHandle()
	if yyv1265 == nil {
		yyrl1265, _ := z.DecInferLen(yyl1265, yybh1265.MaxInitLen, 32)
		yyv1265 = make(map[string]string, yyrl1265)
		*v = yyv1265
	}
	var yymk1265 string
	var yymv1265 string
	var yymg1265 bool
	if yybh1265.MapValueReset {
	}
	if yyl1265 > 0 {
		for yyj1265 := 0; yyj1265 < yyl1265; yyj1265++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1265 = ""
			} else {
				yymk1265 = string(r.DecodeString())
			}

			if yymg1265 {
				yymv1265 = yyv1265[yymk1265]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1265 = ""
			} else {
				yymv1265 = string(r.DecodeString())
			}

			if yyv1265 != nil {
				yyv1265[yymk1265] = yymv1265
			}
		}
	} else if yyl1265 < 0 {
		for yyj1265 := 0; !r.CheckBreak(); yyj1265++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1265 = ""
			} else {
				yymk1265 = string(r.DecodeString())
			}

			if yymg1265 {
				yymv1265 = yyv1265[yymk1265]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1265 = ""
			} else {
				yymv1265 = string(r.DecodeString())
			}

			if yyv1265 != nil {
				yyv1265[yymk1265] = yymv1265
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}
