/*
 * Copyright Red Hat
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * $Id: //eng/uds-releases/jasper/src/uds/zone.c#4 $
 */

#include "zone.h"

#include "logger.h"
#include "threads.h"

/**********************************************************************/
unsigned int getZoneCount(const struct uds_parameters *userParams)
{
  unsigned int zoneCount = (userParams == NULL) ? 0 : userParams->zone_count;
  if (zoneCount == 0) {
    zoneCount = getNumCores() / 2;
  }
  if (zoneCount < 1) {
    zoneCount = 1;
  }
  if (zoneCount > MAX_ZONES) {
    zoneCount = MAX_ZONES;
  }
  logInfo("Using %u indexing zone%s for concurrency.", zoneCount,
          zoneCount == 1 ? "" : "s");
  return zoneCount;
}
