/*
 * Common module linker script, always used when linking a module.
 * Archs are free to supply their own linker scripts.  ld will
 * combine them automatically.
 */
#ifdef CONFIG_UNWIND_TABLES
#define DISCARD_EH_FRAME
#else
#define DISCARD_EH_FRAME	*(.eh_frame)
#endif

#include <asm-generic/codetag.lds.h>

SECTIONS {
	/DISCARD/ : {
		*(.discard)
		*(.discard.*)
		*(.export_symbol)
	}

	__ksymtab		0 : { *(SORT(___ksymtab+*)) }
	__ksymtab_gpl		0 : { *(SORT(___ksymtab_gpl+*)) }
	__kcrctab		0 : { *(SORT(___kcrctab+*)) }
	__kcrctab_gpl		0 : { *(SORT(___kcrctab_gpl+*)) }

	.ctors			0 : ALIGN(8) { *(SORT(.ctors.*)) *(.ctors) }
	.init_array		0 : ALIGN(8) { *(SORT(.init_array.*)) *(.init_array) }

	.altinstructions	0 : ALIGN(8) { KEEP(*(.altinstructions)) }
	__bug_table		0 : ALIGN(8) { KEEP(*(__bug_table)) }
	__jump_table		0 : ALIGN(8) { KEEP(*(__jump_table)) }

	__patchable_function_entries : { *(__patchable_function_entries) }

	__klp_funcs		0: ALIGN(8) { KEEP(*(__klp_funcs)) }

	__klp_objects		0: ALIGN(8) {
		__start_klp_objects = .;
		KEEP(*(__klp_objects))
		__stop_klp_objects = .;
	}

#ifdef CONFIG_ARCH_USES_CFI_TRAPS
	__kcfi_traps		: { KEEP(*(.kcfi_traps)) }
#endif

	.text : {
		*(.text .text.[0-9a-zA-Z_]*)
	}

	.bss : {
		*(.bss .bss.[0-9a-zA-Z_]*)
		*(.bss..L*)
	}

	.data : {
		*(.data .data.[0-9a-zA-Z_]*)
		*(.data..L*)
	}

	.rodata : {
		*(.rodata .rodata.[0-9a-zA-Z_]*)
		*(.rodata..L*)
	}

	MOD_SEPARATE_CODETAG_SECTIONS()
}

/* bring in arch-specific sections */
#include <asm/module.lds.h>
