#!/usr/bin/env bats
# Purpose: This test checks SPDX-License-Identifier: tags in all source files against redhat/LICENSES.

load test-lib.bash

SPEC=$BATS_TEST_DIRNAME/../kernel.spec.template

ERRMSG="ERROR: The kernel RPM spec file License: field does not match the licenses available in the source tree.
Fedora, Centos Stream, and RHEL require that the RPM License field match the licenses in the source tree.  See
https://docs.fedoraproject.org/en-US/legal/license-approval/ for further information.
A list of licenses can be generated by executing the redhat/scripts/license/kspdx.py utility.  New licenses can
be added to the RPM License field only if they are listed in the Allowed Licenses list
https://docs.fedoraproject.org/en-US/legal/allowed-licenses/).   Licenses cannot be added if they are in the
'Not Allowed' Licenses (https://docs.fedoraproject.org/en-US/legal/not-allowed-licenses/). Licenses can be added
to the 'Allowed' or 'Not Allowed' Licenses by following the License Review Process
(https://docs.fedoraproject.org/en-US/legal/license-review-process/)."

_verify_one_license_tag() {
	if [[ $(grep -c '^License:' $SPEC) != "1" ]]; then
	   echo "ERROR: The specfile is supposed to have exactly one License: tag!"
	   return 1
	fi
}

_verify_spdx_licenses() {
	spec_licenses=`mktemp`
	source_licenses=`mktemp`
	grep '^License:' $SPEC | sed 's,License[[:space:]]*:[[:space:]]*,,' | sed 's, AND ,\n,g' | sed 's,^(\(.*\))$,\1,' | sort -u > $spec_licenses

	if ! $BATS_TEST_DIRNAME/../scripts/kspdx-tool/kspdx.py $BATS_TEST_DIRNAME/../../ > $source_licenses; then
	   echo "ERROR: Failed to gather SPDX-License-Identifier: information from source files!"
	   return 1
	fi
	sort -o $source_licenses $source_licenses
	if ! diff -u $spec_licenses $source_licenses; then
	    echo $ERRMSG
	    ret=1
	else
	    ret=0
	fi
	rm -f $spec_licenses $source_licenses
	return $ret
}

@test "Verify SPDX-License-Identifier tags" {
	if ! test -x $BATS_TEST_DIRNAME/../scripts/kspdx-tool/kspdx.py ; then
	    skip "kspdx-tool is missing"
	fi

	run _verify_one_license_tag
	check_status

	_verify_spdx_licenses
	check_status
}
