/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The contents of this file are subject to the terms of either the Universal Permissive License
 * v 1.0 as shown at http://oss.oracle.com/licenses/upl
 *
 * or the following license:
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions
 * and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided with
 * the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
	private static final String BUNDLE_NAME = "org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.messages"; //$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

	public static final String AllocationByClassRule_RULE_NAME = "AllocationByClassRule_RULE_NAME"; //$NON-NLS-1$
	public static final String AllocationByClassRule_TEXT_MESSAGE = "AllocationByClassRule_TEXT_MESSAGE"; //$NON-NLS-1$
	public static final String AllocationByThreadRule_RULE_NAME = "AllocationByThreadRule_RULE_NAME"; //$NON-NLS-1$
	public static final String AllocationByThreadRule_TEXT_MESSAGE = "AllocationByThreadRule_TEXT_MESSAGE"; //$NON-NLS-1$
	public static final String AllocationRuleFactory_TEXT_CLASS_INFO_LONG = "AllocationRuleFactory_TEXT_CLASS_INFO_LONG"; //$NON-NLS-1$
	public static final String AllocationRuleFactory_TEXT_THREAD_INFO_LONG = "AllocationRuleFactory_TEXT_THREAD_INFO_LONG"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_EXTRA_EVENT_TYPES = "ApplicationHaltsRule_EXTRA_EVENT_TYPES"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_HALTS_INFO_LIMIT = "ApplicationHaltsRule_HALTS_INFO_LIMIT"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_HALTS_INFO_LIMIT_DESC = "ApplicationHaltsRule_HALTS_INFO_LIMIT_DESC"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_HALTS_WARNING_LIMIT = "ApplicationHaltsRule_HALTS_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_HALTS_WARNING_LIMIT_DESC = "ApplicationHaltsRule_HALTS_WARNING_LIMIT_DESC"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_HALTS_WINDOW_SIZE = "ApplicationHaltsRule_HALTS_WINDOW_SIZE"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_HALTS_WINDOW_SIZE_DESC = "ApplicationHaltsRule_HALTS_WINDOW_SIZE_DESC"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_RULE_NAME = "ApplicationHaltsRule_RULE_NAME"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_RULE_TEXT = "ApplicationHaltsRule_RULE_TEXT"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_RULE_TEXT_LONG = "ApplicationHaltsRule_RULE_TEXT_LONG"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_RULE_TEXT_OK = "ApplicationHaltsRule_RULE_TEXT_OK"; //$NON-NLS-1$
	public static final String ApplicationHaltsRule_RULE_TEXT_RECOMMENDATION = "ApplicationHaltsRule_RULE_TEXT_RECOMMENDATION"; //$NON-NLS-1$
	public static final String AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT = "AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT"; //$NON-NLS-1$
	public static final String AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT_DESC = "AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT_DESC"; //$NON-NLS-1$
	public static final String AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT = "AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT_DESC = "AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT_DESC"; //$NON-NLS-1$
	public static final String AutoboxingRule_RESULT_AUTOBOXING_RATIO = "AutoboxingRule_RESULT_AUTOBOXING_RATIO"; //$NON-NLS-1$
	public static final String AutoboxingRule_RESULT_LONG = "AutoboxingRule_RESULT_LONG"; //$NON-NLS-1$
	public static final String AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE = "AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE"; //$NON-NLS-1$
	public static final String AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE_LONG = "AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE_LONG"; //$NON-NLS-1$
	public static final String AutoboxingRule_RESULT_NO_AUTOBOXING = "AutoboxingRule_RESULT_NO_AUTOBOXING"; //$NON-NLS-1$
	public static final String AutoboxingRule_RULE_NAME = "AutoboxingRule_RULE_NAME"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT = "BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT_LONG = "BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationPauseRule_RULE_NAME = "BiasedLockingRevocationPauseRule_RULE_NAME"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationPauseRule_TEXT_INFO_LONG = "BiasedLockingRevocationPauseRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationPauseRule_TEXT_MESSAGE = "BiasedLockingRevocationPauseRule_TEXT_MESSAGE"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationPauseRule_TEXT_OK = "BiasedLockingRevocationPauseRule_TEXT_OK"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_CONFIG_FILTERED_CLASSES = "BiasedLockingRevocationRule_CONFIG_FILTERED_CLASSES"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_CONFIG_FILTERED_CLASSES_LONG = "BiasedLockingRevocationRule_CONFIG_FILTERED_CLASSES_LONG"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT = "BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT_LONG = "BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_NAME = "BiasedLockingRevocationRule_NAME"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_TEXT_EPILOGUE = "BiasedLockingRevocationRule_TEXT_EPILOGUE"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_TEXT_OK = "BiasedLockingRevocationRule_TEXT_OK"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_TEXT_REVOKED_CLASSES_FOUND = "BiasedLockingRevocationRule_TEXT_REVOKED_CLASSES_FOUND"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_TEXT_REVOKED_CLASSES_FOUND_LONG = "BiasedLockingRevocationRule_TEXT_REVOKED_CLASSES_FOUND_LONG"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_TEXT_REVOKE_LIMIT_CLASSES_FOUND = "BiasedLockingRevocationRule_TEXT_REVOKE_LIMIT_CLASSES_FOUND"; //$NON-NLS-1$
	public static final String BiasedLockingRevocationRule_TEXT_REVOKE_LIMIT_CLASSES_FOUND_LONG = "BiasedLockingRevocationRule_TEXT_REVOKE_LIMIT_CLASSES_FOUND_LONG"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_DROPPED_COUNT_NAME = "BufferLostRuleFactory_RESULT_DROPPED_COUNT_NAME"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_DROPPED_COUNT_DESCRIPTION = "BufferLostRuleFactory_RESULT_DROPPED_COUNT_DESCRIPTION"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_DROPPED_SIZE_NAME = "BufferLostRuleFactory_RESULT_DROPPED_SIZE_NAME"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_DROPPED_SIZE_DESCRIPTION = "BufferLostRuleFactory_RESULT_DROPPED_SIZE_DESCRIPTION"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_FIRST_DROPPED_BUFFER_TIME_NAME = "BufferLostRuleFactory_RESULT_FIRST_DROPPED_BUFFER_TIME_NAME"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_FIRST_DROPPED_BUFFER_TIME_DESCRIPTION = "BufferLostRuleFactory_RESULT_FIRST_DROPPED_BUFFER_TIME_DESCRIPTION"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_CONFIG_WARN_LIMIT = "BufferLostRuleFactory_CONFIG_WARN_LIMIT"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_CONFIG_WARN_LIMIT_LONG = "BufferLostRuleFactory_CONFIG_WARN_LIMIT_LONG"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RULE_NAME = "BufferLostRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_SUMMARY_OK = "BufferLostRuleFactory_RESULT_SUMMARY_OK"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_SUMMARY = "BufferLostRuleFactory_RESULT_SUMMARY"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_EXPLANATION = "BufferLostRuleFactory_RESULT_EXPLANATION"; //$NON-NLS-1$
	public static final String BufferLostRuleFactory_RESULT_SOLUTION = "BufferLostRuleFactory_RESULT_SOLUTION"; //$NON-NLS-1$
	public static final String ClassLeakingRule_CONFIG_WARNING_LIMIT = "ClassLeakingRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String ClassLeakingRule_CONFIG_WARNING_LIMIT_LONG = "ClassLeakingRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ClassLeakingRule_NAME = "ClassLeakingRule_NAME"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_SUMMARY = "ClassLeakingRule_RESULT_SUMMARY"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_EXPLANATION = "ClassLeakingRule_RESULT_EXPLANATION"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_LOADED_CLASSES_NAME = "ClassLeakingRule_RESULT_LOADED_CLASSES_NAME"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_LOADED_CLASSES_DESCRIPTION = "ClassLeakingRule_RESULT_LOADED_CLASSES_DESCRIPTION"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_MOST_LOADED_CLASS_NAME = "ClassLeakingRule_RESULT_MOST_LOADED_CLASS_NAME"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_MOST_LOADED_CLASS_DESCRIPTION = "ClassLeakingRule_RESULT_MOST_LOADED_CLASS_DESCRIPTION"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_MOST_LOADED_CLASS_LOADS_NAME = "ClassLeakingRule_RESULT_MOST_LOADED_CLASS_LOADS_NAME"; //$NON-NLS-1$
	public static final String ClassLeakingRule_RESULT_MOST_LOADED_CLASS_LOADS_DESCRIPTION = "ClassLeakingRule_RESULT_MOST_LOADED_CLASS_LOADS_DESCRIPTION"; //$NON-NLS-1$
	public static final String ClassLeakingRule_TEXT_OK = "ClassLeakingRule_TEXT_OK"; //$NON-NLS-1$;
	public static final String ClassLeakingRule_TEXT_WARN = "ClassLeakingRule_TEXT_WARN"; //$NON-NLS-1$;
	public static final String ClassLeakingRule_TEXT_WARN_LONG = "ClassLeakingRule_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String ClassLoadingRuleFactory_RULE_NAME = "ClassLoadingRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String ClassLoadingRuleFactory_RULE_TEXT_OK = "ClassLoadingRuleFactory_RULE_TEXT_OK"; //$NON-NLS-1$
	public static final String ClassLoadingRuleFactory_TEXT_INFO = "ClassLoadingRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String ClassLoadingRuleFactory_TEXT_INFO_LONG = "ClassLoadingRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ClassLoadingRule_CONFIG_DURATION_LIMIT = "ClassLoadingRule_CONFIG_DURATION_LIMIT"; //$NON-NLS-1$
	public static final String ClassLoadingRule_CONFIG_DURATION_LIMIT_LONG = "ClassLoadingRule_CONFIG_DURATION_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ClassLoadingRule_CONFIG_RATIO_LIMIT = "ClassLoadingRule_CONFIG_RATIO_LIMIT"; //$NON-NLS-1$
	public static final String ClassLoadingRule_CONFIG_RATIO_LIMIT_LONG = "ClassLoadingRule_CONFIG_RATIO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_LONGEST_LOAD_NAME = "ClassLoadingRule_RESULT_LONGEST_LOAD_NAME"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_LONGEST_LOAD_DESCRIPTION = "ClassLoadingRule_RESULT_LONGEST_LOAD_DESCRIPTION"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_TOTAL_LOAD_COUNT_NAME = "ClassLoadingRule_RESULT_TOTAL_LOAD_COUNT_NAME"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_TOTAL_LOAD_COUNT_DESCRIPTION = "ClassLoadingRule_RESULT_TOTAL_LOAD_COUNT_DESCRIPTION"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_TOTAL_LOAD_TIME_NAME = "ClassLoadingRule_RESULT_TOTAL_LOAD_TIME_NAME"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_TOTAL_LOAD_TIME_DESCRIPTION = "ClassLoadingRule_RESULT_TOTAL_LOAD_TIME_DESCRIPTION"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_SUMMARY = "ClassLoadingRule_RESULT_SUMMARY"; //$NON-NLS-1$
	public static final String ClassLoadingRule_RESULT_EXPLANATION = "ClassLoadingRule_RESULT_EXPLANATION"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_BLOG_REFERENCE = "CodeCacheRuleFactory_BLOG_REFERENCE"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_DEFAULT_LONG_DESCRIPTION = "CodeCacheRuleFactory_DEFAULT_LONG_DESCRIPTION"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_JDK8_TEXT_WARN = "CodeCacheRuleFactory_JDK8_TEXT_WARN"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_RULE_NAME = "CodeCacheRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_SIZE_INFO_LIMIT = "CodeCacheRuleFactory_SIZE_INFO_LIMIT"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_SIZE_INFO_LIMIT_DESC = "CodeCacheRuleFactory_SIZE_INFO_LIMIT_DESC"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_SIZE_WARN_LIMIT = "CodeCacheRuleFactory_SIZE_WARN_LIMIT"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_SIZE_WARN_LIMIT_DESC = "CodeCacheRuleFactory_SIZE_WARN_LIMIT_DESC"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_TEXT_OK = "CodeCacheRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_TEXT_WARN = "CodeCacheRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_TEXT_WARN_LONG = "CodeCacheRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_WARN_LONG_DESCRIPTION = "CodeCacheRuleFactory_WARN_LONG_DESCRIPTION"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_WARN_SEGMENTED_HEAPS_SHORT_DESCRIPTION = "CodeCacheRuleFactory_WARN_SEGMENTED_HEAPS_SHORT_DESCRIPTION"; //$NON-NLS-1$
	public static final String CodeCacheRuleFactory_WARN_SEGMENTED_HEAP_SHORT_DESCRIPTION = "CodeCacheRuleFactory_WARN_SEGMENTED_HEAP_SHORT_DESCRIPTION"; //$NON-NLS-1$
	public static final String CompareCpuRule_INFO_LIMIT = "CompareCpuRule_INFO_LIMIT"; //$NON-NLS-1$
	public static final String CompareCpuRule_INFO_LIMIT_LONG = "CompareCpuRule_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String CompareCpuRule_RULE_NAME = "CompareCpuRule_RULE_NAME"; //$NON-NLS-1$
	public static final String CompareCpuRule_TEXT_INFO_LONG = "CompareCpuRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String CompareCpuRule_TEXT_MESSAGE = "CompareCpuRule_TEXT_MESSAGE"; //$NON-NLS-1$
	public static final String CompareCpuRule_TEXT_TOO_FEW_SAMPLES = "CompareCpuRule_TEXT_TOO_FEW_SAMPLES"; //$NON-NLS-1$
	public static final String CompareCpuRule_WARNING_LIMIT = "CompareCpuRule_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String CompareCpuRule_WARNING_LIMIT_LONG = "CompareCpuRule_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String CompressedOopsRuleFactory_RULE_NAME = "CompressedOopsRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String CompressedOopsRuleFactory_TEXT_INFO = "CompressedOopsRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String CompressedOopsRuleFactory_TEXT_INFO_LONG = "CompressedOopsRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String CompressedOopsRuleFactory_TEXT_OK = "CompressedOopsRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String ConcurrentFailedRuleFactory_TEXT_WARN = "ConcurrentFailedRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String ConcurrentFailedRuleFactory_TEXT_WARN_LONG = "ConcurrentFailedRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String ContextSwitchRuleFactory_RULE_NAME = "ContextSwitchRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String ContextSwitchRuleFactory_TEXT_INFO = "ContextSwitchRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String ContextSwitchRuleFactory_TEXT_INFO_LONG = "ContextSwitchRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ContextSwitchRuleFactory_TEXT_OK = "ContextSwitchRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String ContextSwitchRule_AGGR_MAX_BLOCKS = "ContextSwitchRule_AGGR_MAX_BLOCKS"; //$NON-NLS-1$
	public static final String ContextSwitchRule_CONFIG_WARNING_LIMIT = "ContextSwitchRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String ContextSwitchRule_CONFIG_WARNING_LIMIT_LONG = "ContextSwitchRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String DMSIncidentRuleFactory_RULE_NAME = "DMSIncidentRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String DMSIncidentRuleFactory_TEXT_OK = "DMSIncidentRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String DMSIncidentRuleFactory_TEXT_WARN = "DMSIncidentRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String DMSIncidentRuleFactory_TEXT_WARN_LONG = "DMSIncidentRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String DMSIncidentRule_AGGR_INCIDENTS_COUNT = "DMSIncidentRule_AGGR_INCIDENTS_COUNT"; //$NON-NLS-1$
	public static final String DMSIncidentRule_AGGR_INCIDENTS_COUNT_DESC = "DMSIncidentRule_AGGR_INCIDENTS_COUNT_DESC"; //$NON-NLS-1$
	public static final String DMSIncidentRule_CONFIG_WARNING_LIMIT = "DMSIncidentRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String DMSIncidentRule_CONFIG_WARNING_LIMIT_LONG = "DMSIncidentRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String DebugNonSafepointsRule_DISABLED_RESULT_SUMMARY = "DebugNonSafepointsRule_DISABLED_RESULT_SUMMARY"; //$NON-NLS-1$
	public static final String DebugNonSafepointsRule_IMPLICIT_TEXT_OK = "DebugNonSafepointsRule_IMPLICIT_TEXT_OK"; //$NON-NLS-1$
	public static final String DebugNonSafepointsRule_NOT_ENABLED_RESULT_SUMMARY = "DebugNonSafepointsRule_NOT_ENABLED_RESULT_SUMMARY"; //$NON-NLS-1$
	public static final String DebugNonSafepointsRule_NOT_ENABLED_RESULT_EXPLANATION = "DebugNonSafepointsRule_NOT_ENABLED_RESULT_EXPLANATION"; //$NON-NLS-1$
	public static final String DebugNonSafepointsRule_NOT_ENABLED_RESULT_SOLUTION = "DebugNonSafepointsRule_NOT_ENABLED_RESULT_SOLUTION"; //$NON-NLS-1$
	public static final String DebugNonSafepointsRule_RULE_NAME = "DebugNonSafepointsRule_RULE_NAME"; //$NON-NLS-1$
	public static final String DebugNonSafepointsRule_TEXT_OK = "DebugNonSafepointsRule_TEXT_OK"; //$NON-NLS-1$
	public static final String DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG = "DeprecatedGcRuleFactory_TEXT_WARN_PERMGEN_LONG"; //$NON-NLS-1$
	public static final String DiscouragedGcOptionsRule_RULE_NAME = "DiscouragedGcOptionsRule_RULE_NAME"; //$NON-NLS-1$
	public static final String DiscouragedGcOptionsRule_TEXT_OK = "DiscouragedGcOptionsRule_TEXT_OK"; //$NON-NLS-1$
	public static final String DiscouragedVmOptionsRule_BOTH_EXPERIMENTAL_AND_IGNORE = "DiscouragedVmOptionsRule_BOTH_EXPERIMENTAL_AND_IGNORE"; //$NON-NLS-1$
	public static final String DiscouragedVmOptionsRule_RULE_NAME = "DiscouragedVmOptionsRule_RULE_NAME"; //$NON-NLS-1$
	public static final String DiscouragedVmOptionsRule_TEXT_OK = "DiscouragedVmOptionsRule_TEXT_OK"; //$NON-NLS-1$
	public static final String DumpReasonRule_COREDUMP_SCORE = "DumpReasonRule_COREDUMP_SCORE"; //$NON-NLS-1$
	public static final String DumpReasonRule_COREDUMP_SCORE_LONG = "DumpReasonRule_COREDUMP_SCORE_LONG"; //$NON-NLS-1$
	public static final String DumpReasonRule_CRASH_SCORE = "DumpReasonRule_CRASH_SCORE"; //$NON-NLS-1$
	public static final String DumpReasonRule_CRASH_SCORE_LONG = "DumpReasonRule_CRASH_SCORE_LONG"; //$NON-NLS-1$
	public static final String DumpReasonRule_OOM_SCORE = "DumpReasonRule_OOM_SCORE"; //$NON-NLS-1$
	public static final String DumpReasonRule_OOM_SCORE_LONG = "DumpReasonRule_OOM_SCORE_LONG"; //$NON-NLS-1$
	public static final String DumpReasonRule_TEXT_INFO = "DumpReasonRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String DumpReasonRule_TEXT_INFO_UNKNOWN = "DumpReasonRule_TEXT_INFO_UNKNOWN"; //$NON-NLS-1$
	public static final String DumpReasonRule_TEXT_LONG_COREDUMP = "DumpReasonRule_TEXT_LONG_COREDUMP"; //$NON-NLS-1$
	public static final String DumpReasonRule_TEXT_LONG_CRASH = "DumpReasonRule_TEXT_LONG_CRASH"; //$NON-NLS-1$
	public static final String DumpReasonRule_TEXT_LONG_OOM = "DumpReasonRule_TEXT_LONG_OOM"; //$NON-NLS-1$
	public static final String DumpReasonRule_TEXT_LONG_UNKNOWN = "DumpReasonRule_TEXT_LONG_UNKNOWN"; //$NON-NLS-1$
	public static final String DumpReasonRule_TEXT_OK = "DumpReasonRule_TEXT_OK"; //$NON-NLS-1$
	public static final String DumpReason_RULE_NAME = "DumpReason_RULE_NAME"; //$NON-NLS-1$
	public static final String DuplicateFlagsRuleFactory_RULE_NAME = "DuplicateFlagsRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_NAME = "DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_NAME"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_DESCRIPTION = "DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_DESCRIPTION"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_COUNT_NAME = "DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_COUNT_NAME"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_COUNT_DESCRIPTION = "DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_COUNT_DESCRIPTION"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_SUMMARY = "DuplicateFlagsRule_RESULT_SUMMARY"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_EXPLANATION = "DuplicateFlagsRule_RESULT_EXPLANATION"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_SOLUTION = "DuplicateFlagsRule_RESULT_SOLUTION"; //$NON-NLS-1$
	public static final String DuplicateFlagsRule_RESULT_SUMMARY_OK = "DuplicateFlagsRule_RESULT_SUMMARY_OK"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_EXCLUDED_ERRORS = "ErrorRule_CONFIG_EXCLUDED_ERRORS"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_EXCLUDED_ERRORS_LONG = "ErrorRule_CONFIG_EXCLUDED_ERRORS_LONG"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_INFO_LIMIT = "ErrorRule_CONFIG_INFO_LIMIT"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_INFO_LIMIT_LONG = "ErrorRule_CONFIG_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_WARN_LIMIT = "ErrorRule_CONFIG_WARN_LIMIT"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_WARN_LIMIT_LONG = "ErrorRule_CONFIG_WARN_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_WINDOW_SIZE = "ErrorRule_CONFIG_WINDOW_SIZE"; //$NON-NLS-1$
	public static final String ErrorRule_CONFIG_WINDOW_SIZE_LONG = "ErrorRule_CONFIG_WINDOW_SIZE_LONG"; //$NON-NLS-1$
	public static final String ErrorRule_RULE_NAME = "ErrorRule_RULE_NAME"; //$NON-NLS-1$
	public static final String ErrorRule_TEXT_OK = "ErrorRule_TEXT_OK"; //$NON-NLS-1$
	public static final String ErrorRule_TEXT_WARN = "ErrorRule_TEXT_WARN"; //$NON-NLS-1$
	public static final String ErrorRule_TEXT_WARN_EXCLUDED_INFO = "ErrorRule_TEXT_WARN_EXCLUDED_INFO"; //$NON-NLS-1$
	public static final String ErrorRule_TEXT_WARN_LONG = "ErrorRule_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String ExceptionRule_CONFIG_INFO_LIMIT = "ExceptionRule_CONFIG_INFO_LIMIT"; //$NON-NLS-1$
	public static final String ExceptionRule_CONFIG_INFO_LIMIT_LONG = "ExceptionRule_CONFIG_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ExceptionRule_CONFIG_WARN_LIMIT = "ExceptionRule_CONFIG_WARN_LIMIT"; //$NON-NLS-1$
	public static final String ExceptionRule_CONFIG_WARN_LIMIT_LONG = "ExceptionRule_CONFIG_WARN_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ExceptionRule_RULE_NAME = "ExceptionRule_RULE_NAME"; //$NON-NLS-1$
	public static final String ExceptionRule_TEXT_INFO_LONG = "ExceptionRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ExceptionRule_TEXT_MESSAGE = "ExceptionRule_TEXT_MESSAGE"; //$NON-NLS-1$
	public static final String FatalErrorRule_RULE_NAME = "FatalErrorRule_RULE_NAME"; //$NON-NLS-1$
	public static final String FatalErrorRule_TEXT_OK = "FatalErrorRule_TEXT_OK"; //$NON-NLS-1$
	public static final String FatalErrorRule_TEXT_INFO = "FatalErrorRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String FatalErrorRule_TEXT_WARN = "FatalErrorRule_TEXT_WARN"; //$NON-NLS-1$
	public static final String FasttimeRule_TEXT_WARN = "FasttimeRule_TEXT_WARN"; //$NON-NLS-1$
	public static final String FasttimeRule_TEXT_WARN_LONG = "FasttimeRule_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD = "FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD_DESC = "FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD_DESC"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_APPLICATION_IDLE = "FewSampledThreadsRule_APPLICATION_IDLE"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_APPLICATION_IDLE_LONG = "FewSampledThreadsRule_APPLICATION_IDLE_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_CPU_WINDOW_SIZE = "FewSampledThreadsRule_CPU_WINDOW_SIZE"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_CPU_WINDOW_SIZE_LONG = "FewSampledThreadsRule_CPU_WINDOW_SIZE_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_MIN_CPU_RATIO = "FewSampledThreadsRule_MIN_CPU_RATIO"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_MIN_CPU_RATIO_LONG = "FewSampledThreadsRule_MIN_CPU_RATIO_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_MIN_SAMPLE_COUNT = "FewSampledThreadsRule_MIN_SAMPLE_COUNT"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_MIN_SAMPLE_COUNT_LONG = "FewSampledThreadsRule_MIN_SAMPLE_COUNT_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD = "FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD_LONG = "FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_RULE_NAME = "FewSampledThreadsRule_RULE_NAME"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT = "FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT_LONG = "FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_TEXT_INFO = "FewSampledThreadsRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_TEXT_INFO_LONG = "FewSampledThreadsRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_TEXT_NOT_ENOUGH_SAMPLES = "FewSampledThreadsRule_TEXT_NOT_ENOUGH_SAMPLES"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_TEXT_OK = "FewSampledThreadsRule_TEXT_OK"; //$NON-NLS-1$
	public static final String FewSampledThreadsRule_TEXT_OK_LONG = "FewSampledThreadsRule_TEXT_OK_LONG"; //$NON-NLS-1$
	public static final String FileReadRuleFactory_RULE_NAME = "FileReadRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String FileReadRuleFactory_TEXT_NO_EVENTS = "FileReadRuleFactory_TEXT_NO_EVENTS"; //$NON-NLS-1$
	public static final String FileReadRuleFactory_TEXT_OK = "FileReadRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String FileReadRuleFactory_TEXT_WARN = "FileReadRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String FileReadRuleFactory_TEXT_WARN_LONG = "FileReadRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String FileReadRule_CONFIG_WARNING_LIMIT = "FileReadRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String FileReadRule_CONFIG_WARNING_LIMIT_LONG = "FileReadRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String FileWriteRuleFactory_RULE_NAME = "FileWriteRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String FileWriteRuleFactory_TEXT_NO_EVENTS = "FileWriteRuleFactory_TEXT_NO_EVENTS"; //$NON-NLS-1$
	public static final String FileWriteRuleFactory_TEXT_OK = "FileWriteRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String FileWriteRuleFactory_TEXT_WARN = "FileWriteRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String FileWriteRuleFactory_TEXT_WARN_LONG = "FileWriteRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String FileWriteRule_CONFIG_WARNING_LIMIT = "FileWriteRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String FileWriteRule_CONFIG_WARNING_LIMIT_LONG = "FileWriteRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String FlightRecordingSupportRule_EA_TEXT_WARN_LONG = "FlightRecordingSupportRule_EA_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String FlightRecordingSupportRule_EA_TEXT_WARN_SHORT = "FlightRecordingSupportRule_EA_TEXT_WARN_SHORT"; //$NON-NLS-1$
	public static final String FlightRecordingSupportRule_NO_JVM_VERSION_EVENTS_TEXT = "FlightRecordingSupportRule_NO_JVM_VERSION_EVENTS_TEXT"; //$NON-NLS-1$
	public static final String FlightRecordingSupportRule_RULE_NAME = "FlightRecordingSupportRule_RULE_NAME"; //$NON-NLS-1$
	public static final String FlightRecordingSupportRule_TEXT_OK = "FlightRecordingSupportRule_TEXT_OK"; //$NON-NLS-1$
	public static final String FlightRecordingSupportRule_UNSUPPORTED_TEXT_WARN_LONG = "FlightRecordingSupportRule_UNSUPPORTED_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String FlightRecordingSupportRule_UNSUPPORTED_TEXT_WARN_SHORT = "FlightRecordingSupportRule_UNSUPPORTED_TEXT_WARN_SHORT"; //$NON-NLS-1$
	public static final String FullGcRule_RULE_NAME = "FullGcRule_RULE_NAME"; //$NON-NLS-1$
	public static final String FullGcRule_OTHER_COLLECTOR_IN_USE = "FullGcRule_OTHER_COLLECTOR_IN_USE"; //$NON-NLS-1$
	public static final String FullGcRule_FULL_GC_OCCURRED_TITLE = "FullGcRule_FULL_GC_OCCURRED_TITLE"; //$NON-NLS-1$
	public static final String FullGcRule_FULL_GC_OCCURRED_DESC = "FullGcRule_FULL_GC_OCCURRED_DESC"; //$NON-NLS-1$
	public static final String FullGcRule_NO_FULL_GC_OCCURRED = "FullGcRule_NO_FULL_GC_OCCURRED"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_FEW_GCS_LIMIT = "GcFreedRatioRule_FEW_GCS_LIMIT"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_FEW_GCS_LIMIT_DESC = "GcFreedRatioRule_FEW_GCS_LIMIT_DESC"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_GC_FREED_RATIO_INFO_LIMIT = "GcFreedRatioRule_GC_FREED_RATIO_INFO_LIMIT"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_GC_FREED_RATIO_INFO_LIMIT_DESC = "GcFreedRatioRule_GC_FREED_RATIO_INFO_LIMIT_DESC"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_RESULT_FEW_GCS = "GcFreedRatioRule_RESULT_FEW_GCS"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_RESULT_LONG_DESCRIPTION = "GcFreedRatioRule_RESULT_LONG_DESCRIPTION"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_RESULT_MORE_INFO = "GcFreedRatioRule_RESULT_MORE_INFO"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_RESULT_NOT_OK = "GcFreedRatioRule_RESULT_NOT_OK"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_RESULT_OK = "GcFreedRatioRule_RESULT_OK"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_RESULT_SHORT_DESCRIPTION = "GcFreedRatioRule_RESULT_SHORT_DESCRIPTION"; //$NON-NLS-1$
	public static final String GarbageCollectionInfo_RULE_NAME = "GarbageCollectionInfo_RULE_NAME"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_RULE_NAME = "GcFreedRatioRule_RULE_NAME"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_WINDOW_SIZE = "GcFreedRatioRule_WINDOW_SIZE"; //$NON-NLS-1$
	public static final String GcFreedRatioRule_WINDOW_SIZE_DESC = "GcFreedRatioRule_WINDOW_SIZE_DESC"; //$NON-NLS-1$
	public static final String GcLockerRuleFactory_RULE_NAME = "GcLockerRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String GcLockerRuleFactory_TEXT_INFO = "GcLockerRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String GcLockerRuleFactory_TEXT_INFO_LONG = "GcLockerRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String GcLockerRuleFactory_TEXT_OK = "GcLockerRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String GcLockerRule_CONFIG_WARNING_LIMIT = "GcLockerRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String GcLockerRule_CONFIG_WARNING_LIMIT_LONG = "GcLockerRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String GcLockerRule_TEXT_NA = "GcLockerRule_TEXT_NA"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_INFO_LIMIT = "GcPauseRatioRule_INFO_LIMIT"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_INFO_LIMIT_DESC = "GcPauseRatioRule_INFO_LIMIT_DESC"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_RULE_NAME = "GcPauseRatioRule_RULE_NAME"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_RULE_TEXT = "GcPauseRatioRule_RULE_TEXT"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_RULE_TEXT_LONG = "GcPauseRatioRule_RULE_TEXT_LONG"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_RULE_TEXT_OK = "GcPauseRatioRule_RULE_TEXT_OK"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_RULE_TEXT_RECOMMENDATION = "GcPauseRatioRule_RULE_TEXT_RECOMMENDATION"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_WARNING_LIMIT = "GcPauseRatioRule_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_WARNING_LIMIT_DESC = "GcPauseRatioRule_WARNING_LIMIT_DESC"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_WINDOW_SIZE = "GcPauseRatioRule_WINDOW_SIZE"; //$NON-NLS-1$
	public static final String GcPauseRatioRule_WINDOW_SIZE_DESC = "GcPauseRatioRule_WINDOW_SIZE_DESC"; //$NON-NLS-1$
	public static final String GcStallRule_RULE_NAME = "GcStallRule_RULE_NAME"; //$NON-NLS-1$
	public static final String GcStallRule_TEXT_OK = "GcStallRule_TEXT_OK"; //$NON-NLS-1$
	public static final String General_CONFIG_CLASS_LIMIT = "General_CONFIG_CLASS_LIMIT"; //$NON-NLS-1$
	public static final String General_CONFIG_CLASS_LIMIT_LONG = "General_CONFIG_CLASS_LIMIT_LONG"; //$NON-NLS-1$
	public static final String General_NO_STACK_TRACE_AVAILABLE = "General_NO_STACK_TRACE_AVAILABLE"; //$NON-NLS-1$
	public static final String General_RULE_REQUIRES_EVENTS_FROM_ONE_OF_MANY = "General_RULE_REQUIRES_EVENTS_FROM_ONE_OF_MANY"; //$NON-NLS-1$
	public static final String General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION = "General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION"; //$NON-NLS-1$
	public static final String General_UNKNOWN_ADDRESS = "General_UNKNOWN_ADDRESS"; //$NON-NLS-1$
	public static final String General_UNKNOWN_FILE_NAME = "General_UNKNOWN_FILE_NAME"; //$NON-NLS-1$
	public static final String HeapContentRuleFactory_RULE_NAME = "HeapContentRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String HeapContentRuleFactory_TEXT_INFO = "HeapContentRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String HeapContentRuleFactory_TEXT_INFO_LONG = "HeapContentRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String HeapContentRuleFactory_TEXT_OK = "HeapContentRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String HeapContentRule_AGGR_CLASS_SCORE = "HeapContentRule_AGGR_CLASS_SCORE"; //$NON-NLS-1$
	public static final String HeapDumpRule_RULE_NAME = "HeapDumpRule_RULE_NAME"; //$NON-NLS-1$
	public static final String HeapDumpRule_TEXT_INFO = "HeapDumpRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String HeapDumpRule_TEXT_OK = "HeapDumpRule_TEXT_OK"; //$NON-NLS-1$
	public static final String HeapInspectionGcRuleFactory_RULE_NAME = "HeapInspectionGcRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String HeapInspectionGcRuleFactory_TEXT_INFO = "HeapInspectionGcRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String HeapInspectionGcRuleFactory_TEXT_INFO_LONG = "HeapInspectionGcRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String HeapInspectionGcRuleFactory_TEXT_INFO_LONG_JFR = "HeapInspectionGcRuleFactory_TEXT_INFO_LONG_JFR"; //$NON-NLS-1$
	public static final String HeapInspectionGcRuleFactory_TEXT_OK = "HeapInspectionGcRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String HeapInspectionGcRuleFactory_TEXT_OK_LONG = "HeapInspectionGcRuleFactory_TEXT_OK_LONG"; //$NON-NLS-1$
	public static final String HeapInspectionRule_CONFIG_WARNING_LIMIT = "HeapInspectionRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String HeapInspectionRule_CONFIG_WARNING_LIMIT_LONG = "HeapInspectionRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String HighGcRuleFactory_RULE_NAME = "HighGcRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String HighGcRuleFactory_TEXT_INFO = "HighGcRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String HighGcRuleFactory_TEXT_INFO_LONG = "HighGcRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String HighGcRuleFactory_TEXT_OK = "HighGcRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_AGGR_MAX_ENDTIME = "HighJvmCpuRule_AGGR_MAX_ENDTIME"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_AGGR_MIN_ENDTIME = "HighJvmCpuRule_AGGR_MIN_ENDTIME"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT = "HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT_LONG = "HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_CONFIG_MIN_CPULOAD = "HighJvmCpuRule_CONFIG_MIN_CPULOAD"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_CONFIG_MIN_CPU_LIMIT_LONG = "HighJvmCpuRule_CONFIG_MIN_CPU_LIMIT_LONG"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_CONFIG_SAMPLE_LIMIT = "HighJvmCpuRule_CONFIG_SAMPLE_LIMIT"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_CONFIG_SAMPLE_LIMIT_LONG = "HighJvmCpuRule_CONFIG_SAMPLE_LIMIT_LONG"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_FEW_SAMPLES = "HighJvmCpuRule_FEW_SAMPLES"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_FEW_SAMPLES_LONG = "HighJvmCpuRule_FEW_SAMPLES_LONG"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_LONG_CPU_LOAD_PERIOD = "HighJvmCpuRule_LONG_CPU_LOAD_PERIOD"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_LONG_CPU_LOAD_PERIOD_LONG = "HighJvmCpuRule_LONG_CPU_LOAD_PERIOD_LONG"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_RULE_NAME = "HighJvmCpuRule_RULE_NAME"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_TEXT_OK = "HighJvmCpuRule_TEXT_OK"; //$NON-NLS-1$
	public static final String HighJvmCpuRule_TEXT_WARN = "HighJvmCpuRule_TEXT_WARN"; //$NON-NLS-1$
	public static final String HotMethodsRuleFactory_NOT_ENOUGH_SAMPLES = "HotMethodsRuleFactory_NOT_ENOUGH_SAMPLES"; //$NON-NLS-1$
	public static final String HotMethodsRuleFactory_TEXT_INFO = "HotMethodsRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String HotMethodsRuleFactory_TEXT_INFO_LONG = "HotMethodsRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String HotMethodsRuleFactory_TEXT_OK = "HotMethodsRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO = "IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG = "IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRuleFactory_RULE_NAME = "IncreasingLiveSetRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRuleFactory_TEXT_INFO = "IncreasingLiveSetRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRuleFactory_TEXT_INFO_LONG = "IncreasingLiveSetRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_CANDIDATE_REFERRED_BY = "IncreasingLiveSetRule_CANDIDATE_REFERRED_BY"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_ELLIPSIS = "IncreasingLiveSetRule_ELLIPSIS"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_LEAK_CANDIDATES = "IncreasingLiveSetRule_LEAK_CANDIDATES"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_LOADED_CLASSES_PERCENT = "IncreasingLiveSetRule_LOADED_CLASSES_PERCENT"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_LOADED_CLASSES_PERCENT_DESC = "IncreasingLiveSetRule_LOADED_CLASSES_PERCENT_DESC"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_RELEVANCE_THRESHOLD = "IncreasingLiveSetRule_RELEVANCE_THRESHOLD"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_RELEVANCE_THRESHOLD_DESC = "IncreasingLiveSetRule_RELEVANCE_THRESHOLD_DESC"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_TEXT_INFO_BALANCED = "IncreasingLiveSetRule_TEXT_INFO_BALANCED"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_TEXT_INFO_LONG = "IncreasingLiveSetRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_TEXT_INFO_NO_CANDIDATES = "IncreasingLiveSetRule_TEXT_INFO_NO_CANDIDATES"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_TEXT_INFO_UNBALANCED = "IncreasingLiveSetRule_TEXT_INFO_UNBALANCED"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_TEXT_OK = "IncreasingLiveSetRule_TEXT_OK"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD = "IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD"; //$NON-NLS-1$
	public static final String IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD_DESC = "IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD_DESC"; //$NON-NLS-1$
	public static final String IncreasingMetaspaceLiveSetRuleFactory_RULE_NAME = "IncreasingMetaspaceLiveSetRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO = "IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO_LONG = "IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK = "IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String JavaBlockingRule_AGGR_BALANCE_BY_INSTANCE = "JavaBlockingRule_AGGR_BALANCE_BY_INSTANCE"; //$NON-NLS-1$
	public static final String JavaBlockingRule_AGGR_BALANCE_BY_THREAD = "JavaBlockingRule_AGGR_BALANCE_BY_THREAD"; //$NON-NLS-1$
	public static final String JavaBlockingRule_CONFIG_EXCLUDED_THREADS = "JavaBlockingRule_CONFIG_EXCLUDED_THREADS"; //$NON-NLS-1$
	public static final String JavaBlockingRule_CONFIG_EXCLUDED_THREADS_LONG = "JavaBlockingRule_CONFIG_EXCLUDED_THREADS_LONG"; //$NON-NLS-1$
	public static final String JavaBlockingRule_TEXT_EXCLUDED_THREADS = "JavaBlockingRule_TEXT_EXCLUDED_THREADS"; //$NON-NLS-1$
	public static final String JavaBlockingRule_TEXT_INFO = "JavaBlockingRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String JavaBlockingRule_TEXT_MESSAGE = "JavaBlockingRule_TEXT_MESSAGE"; //$NON-NLS-1$
	public static final String JavaBlockingRule_TEXT_MOST_BLOCKED_CLASS = "JavaBlockingRule_TEXT_MOST_BLOCKED_CLASS"; //$NON-NLS-1$
	public static final String JavaBlockingRule_TEXT_MOST_BLOCKED_THREAD = "JavaBlockingRule_TEXT_MOST_BLOCKED_THREAD"; //$NON-NLS-1$
	public static final String JavaBlockingRule_TEXT_OK = "JavaBlockingRule_TEXT_OK"; //$NON-NLS-1$
	public static final String JavaBlocking_RULE_NAME = "JavaBlocking_RULE_NAME"; //$NON-NLS-1$
	public static final String JfrPeriodicEventsFixRule_NO_JVM_VERSION_EVENTS_TEXT = "JfrPeriodicEventsFixRule_NO_JVM_VERSION_EVENTS_TEXT"; //$NON-NLS-1$
	public static final String JfrPeriodicEventsFixRule_RULE_NAME = "JfrPeriodicEventsFixRule_RULE_NAME"; //$NON-NLS-1$
	public static final String JfrPeriodicEventsFixRule_TEXT_OK = "JfrPeriodicEventsFixRule_TEXT_OK"; //$NON-NLS-1$
	public static final String JfrPeriodicEventsFixRule_TEXT_WARN_LONG = "JfrPeriodicEventsFixRule_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String JfrPeriodicEventsFixRule_TEXT_WARN_SHORT = "JfrPeriodicEventsFixRule_TEXT_WARN_SHORT"; //$NON-NLS-1$
	public static final String LongGcPauseRuleFactory_RULE_NAME = "LongGcPauseRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String LongGcPauseRuleFactory_TEXT_INFO = "LongGcPauseRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String LongGcPauseRuleFactory_TEXT_INFO_G1 = "LongGcPauseRuleFactory_TEXT_INFO_G1"; //$NON-NLS-1$
	public static final String LongGcPauseRuleFactory_TEXT_INFO_MX = "LongGcPauseRuleFactory_TEXT_INFO_MX"; //$NON-NLS-1$
	public static final String LongGcPauseRuleFactory_TEXT_INFO_REFERENCES = "LongGcPauseRuleFactory_TEXT_INFO_REFERENCES"; //$NON-NLS-1$
	public static final String LongGcPauseRuleFactory_TEXT_OK = "LongGcPauseRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String LongGcPauseRule_CONFIG_INFO_LIMIT = "LongGcPauseRule_CONFIG_INFO_LIMIT"; //$NON-NLS-1$
	public static final String LongGcPauseRule_CONFIG_INFO_LIMIT_LONG = "LongGcPauseRule_CONFIG_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String LowOnPhysicalMemoryFactory_RULE_NAME = "LowOnPhysicalMemoryFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String LowOnPhysicalMemoryFactory_TEXT_INFO = "LowOnPhysicalMemoryFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String LowOnPhysicalMemoryFactory_TEXT_INFO_LONG = "LowOnPhysicalMemoryFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String LowOnPhysicalMemoryFactory_TEXT_OK = "LowOnPhysicalMemoryFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String LuceneVersionRule_LONG_DESCRIPTION_LUCENE = "LuceneVersionRule_LONG_DESCRIPTION_LUCENE"; //$NON-NLS-1$
	public static final String LuceneVersionRule_LONG_DESCRIPTION_ES = "LuceneVersionRule_LONG_DESCRIPTION_ES"; //$NON-NLS-1$
	public static final String LuceneVersionRule_LONG_DESCRIPTION_SOLR = "LuceneVersionRule_LONG_DESCRIPTION_SOLR"; //$NON-NLS-1$
	public static final String LuceneVersionRule_SHORT_DESCRIPTION_LUCENE = "LuceneVersionRule_SHORT_DESCRIPTION_LUCENE"; //$NON-NLS-1$
	public static final String LuceneVersionRule_SHORT_DESCRIPTION_ES = "LuceneVersionRule_SHORT_DESCRIPTION_ES"; //$NON-NLS-1$
	public static final String LuceneVersionRule_SHORT_DESCRIPTION_SOLR = "LuceneVersionRule_SHORT_DESCRIPTION_SOLR"; //$NON-NLS-1$
	public static final String LuceneVersionRule_OK_TEXT_LUCENE = "LuceneVersionRule_OK_TEXT_LUCENE"; //$NON-NLS-1$
	public static final String LuceneVersionRule_OK_TEXT_ES = "LuceneVersionRule_OK_TEXT_ES"; //$NON-NLS-1$
	public static final String LuceneVersionRule_OK_TEXT_SOLR = "LuceneVersionRule_OK_TEXT_SOLR"; //$NON-NLS-1$
	public static final String LuceneVersionRule_NA_TEXT = "LuceneVersionRule_NA_TEXT"; //$NON-NLS-1$
	public static final String LuceneVersionRule_RULE_NAME = "LuceneVersionRule_RULE_NAME"; //$NON-NLS-1$
	public static final String ManagementAgentRule_TEXT_INFO = "ManagementAgentRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String ManagementAgentRule_TEXT_INFO_LONG = "ManagementAgentRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_RULE_NAME = "ManagmentAgentRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED = "ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED_LONG = "ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED_LONG"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_OK = "ManagmentAgentRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED = "ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED_LONG = "ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED_LONG"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED = "ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED_LONG = "ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED_LONG"; //$NON-NLS-1$
	public static final String ManagmentAgentRuleFactory_TEXT_WARN_CONFIGURE_GUIDE = "ManagmentAgentRuleFactory_TEXT_WARN_CONFIGURE_GUIDE"; //$NON-NLS-1$
	public static final String ManyRunningProcessesRule_INFO_LIMIT = "ManyRunningProcessesRule_INFO_LIMIT"; //$NON-NLS-1$
	public static final String ManyRunningProcessesRule_INFO_LIMIT_LONG = "ManyRunningProcessesRule_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String ManyRunningProcessesRule_RULE_NAME = "ManyRunningProcessesRule_RULE_NAME"; //$NON-NLS-1$
	public static final String ManyRunningProcessesRule_TEXT_INFO = "ManyRunningProcessesRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String ManyRunningProcessesRule_TEXT_INFO_LONG = "ManyRunningProcessesRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ManyRunningProcessesRule_TEXT_RECOMMENDATION = "ManyRunningProcessesRule_TEXT_RECOMMENDATION"; //$NON-NLS-1$
	public static final String MetaspaceOomRuleFactory_RULE_NAME = "MetaspaceOomRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String MetaspaceOomRuleFactory_TEXT_OK = "MetaspaceOomRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String MetaspaceOomRuleFactory_TEXT_WARN = "MetaspaceOomRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String MetaspaceOomRuleFactory_TEXT_WARN_LONG = "MetaspaceOomRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA = "MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA"; //$NON-NLS-1$
	public static final String MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA_DESC = "MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA_DESC"; //$NON-NLS-1$
	public static final String MethodProfilingDataProvider_AGGR_MAX_ENDTIME = "MethodProfilingDataProvider_AGGR_MAX_ENDTIME"; //$NON-NLS-1$
	public static final String MethodProfilingDataProvider_AGGR_MIN_ENDTIME = "MethodProfilingDataProvider_AGGR_MIN_ENDTIME"; //$NON-NLS-1$
	public static final String MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE = "MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE"; //$NON-NLS-1$
	public static final String MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE_DESC = "MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE_DESC"; //$NON-NLS-1$
	public static final String MethodProfilingRule_RULE_NAME = "MethodProfilingRule_RULE_NAME"; //$NON-NLS-1$
	public static final String MethodProfilingRule_WINDOW_SIZE = "MethodProfilingRule_WINDOW_SIZE"; //$NON-NLS-1$
	public static final String MethodProfilingRule_WINDOW_SIZE_DESC = "MethodProfilingRule_WINDOW_SIZE_DESC"; //$NON-NLS-1$
	public static final String MethodProfilingRule_EXCLUDED_PACKAGES = "MethodProfilingRule_EXCLUDED_PACKAGES"; //$NON-NLS-1$
	public static final String MethodProfilingRule_EXCLUDED_PACKAGES_DESC = "MethodProfilingRule_EXCLUDED_PACKAGES_DESC"; //$NON-NLS-1$
	public static final String NumberOfGcThreadsRuleFactory_TEXT_INFO = "NumberOfGcThreadsRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String NumberOfGcThreadsRuleFactory_TEXT_INFO_LONG = "NumberOfGcThreadsRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ObjectStatisticsDataProvider_AGGR_LIVE_SIZE_INCREASE = "ObjectStatisticsDataProvider_AGGR_LIVE_SIZE_INCREASE"; //$NON-NLS-1$
	public static final String ObjectStatisticsDataProvider_AGGR_LIVE_SIZE_INCREASE_DESC = "ObjectStatisticsDataProvider_AGGR_LIVE_SIZE_INCREASE_DESC"; //$NON-NLS-1$
	public static final String OptionsCheckRule_CONFIG_ACCEPTED_OPTIONS = "OptionsCheckRule_CONFIG_ACCEPTED_OPTIONS"; //$NON-NLS-1$
	public static final String OptionsCheckRule_CONFIG_ACCEPTED_OPTIONS_LONG = "OptionsCheckRule_CONFIG_ACCEPTED_OPTIONS_LONG"; //$NON-NLS-1$
	public static final String OptionsCheckRule_RULE_NAME = "OptionsCheckRule_RULE_NAME"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_DEPR = "OptionsCheckRule_TEXT_DEPR"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_DEPRECATED = "OptionsCheckRule_TEXT_DEPRECATED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_DEPRECATED_IGNORED = "OptionsCheckRule_TEXT_DEPRECATED_IGNORED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_DEPRECATED_IGNORED_REMOVED = "OptionsCheckRule_TEXT_DEPRECATED_IGNORED_REMOVED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_DEPRECATED_REMOVED = "OptionsCheckRule_TEXT_DEPRECATED_REMOVED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_DEPRECATED_WARNING = "OptionsCheckRule_TEXT_DEPRECATED_WARNING"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_DEPR_NOTREC = "OptionsCheckRule_TEXT_DEPR_NOTREC"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_GENERAL_PROBLEM = "OptionsCheckRule_TEXT_GENERAL_PROBLEM"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_IGNORED = "OptionsCheckRule_TEXT_IGNORED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_IGNORED_REMOVED = "OptionsCheckRule_TEXT_IGNORED_REMOVED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_NA = "OptionsCheckRule_TEXT_NA"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_NOTREC = "OptionsCheckRule_TEXT_NOTREC"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_OK = "OptionsCheckRule_TEXT_OK"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_OPTIONS_DEPRECATED = "OptionsCheckRule_TEXT_OPTIONS_DEPRECATED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_OPTIONS_NOT_DOCUMENTED = "OptionsCheckRule_TEXT_OPTIONS_NOT_DOCUMENTED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_OPTIONS_NOT_RECOMMENDED = "OptionsCheckRule_TEXT_OPTIONS_NOT_RECOMMENDED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_OPTION_DEPRECATED = "OptionsCheckRule_TEXT_OPTION_DEPRECATED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_OPTION_NOT_DOCUMENTED = "OptionsCheckRule_TEXT_OPTION_NOT_DOCUMENTED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_OPTION_NOT_RECOMMENDED = "OptionsCheckRule_TEXT_OPTION_NOT_RECOMMENDED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_REMOVED = "OptionsCheckRule_TEXT_REMOVED"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_UNDOC = "OptionsCheckRule_TEXT_UNDOC"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_UNDOCUMENTED_WARNING = "OptionsCheckRule_TEXT_UNDOCUMENTED_WARNING"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_UNDOC_DEPR = "OptionsCheckRule_TEXT_UNDOC_DEPR"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_UNDOC_DEPR_NOTREC = "OptionsCheckRule_TEXT_UNDOC_DEPR_NOTREC"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_UNDOC_NOTREC = "OptionsCheckRule_TEXT_UNDOC_NOTREC"; //$NON-NLS-1$
	public static final String OptionsCheckRule_TEXT_USE_MAXRAMFRACTION = "OptionsCheckRule_TEXT_USE_MAXRAMFRACTION"; //$NON-NLS-1$
	public static final String OverAggressiveRecordingSettingRuleFactory_RULE_NAME = "OverAggressiveRecordingSettingRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String OverAggressiveRecordingSettingRuleFactory_RULE_TEXT_OK = "OverAggressiveRecordingSettingRuleFactory_RULE_TEXT_OK"; //$NON-NLS-1$
	public static final String OverAggressiveRecordingSettingRuleFactory_TEXT_INFO = "OverAggressiveRecordingSettingRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String OverAggressiveRecordingSettingRuleFactory_TEXT_INFO_LONG = "OverAggressiveRecordingSettingRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ParGcFewThreadsRuleFactory_TEXT_INFO = "ParGcFewThreadsRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String ParGcFewThreadsRuleFactory_TEXT_INFO_LONG = "ParGcFewThreadsRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String ParallelOnSingleCpuRuleFactory_TEXT_INFO = "ParallelOnSingleCpuRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String ParallelOnSingleCpuRuleFactory_TEXT_INFO_LONG = "ParallelOnSingleCpuRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String PasswordsInArgsRule_CONFIG_EXCLUDED_STRINGS = "PasswordsInArgsRule_CONFIG_EXCLUDED_STRINGS"; //$NON-NLS-1$
	public static final String PasswordsInArgsRule_CONFIG_EXCLUDED_STRINGS_LONG = "PasswordsInArgsRule_CONFIG_EXCLUDED_STRINGS_LONG"; //$NON-NLS-1$
	public static final String PasswordsInArgsRule_JAVAARGS_TEXT_INFO = "PasswordsInArgsRule_JAVAARGS_TEXT_INFO"; //$NON-NLS-1$
	public static final String PasswordsInArgsRule_JAVAARGS_TEXT_INFO_LONG = "PasswordsInArgsRule_JAVAARGS_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String PasswordsInArgsRule_JAVAARGS_TEXT_SOLUTION = "PasswordsInArgsRule_JAVAARGS_TEXT_SOLUTION"; //$NON-NLS-1$
	public static final String PasswordsInArgsRule_RULE_NAME = "PasswordsInArgsRule_RULE_NAME"; //$NON-NLS-1$
	public static final String PasswordsInArgsRule_TEXT_INFO_EXCLUDED = "PasswordsInArgsRule_TEXT_INFO_EXCLUDED"; //$NON-NLS-1$	
	public static final String PasswordsInArgsRule_TEXT_OK = "PasswordsInArgsRule_TEXT_OK"; //$NON-NLS-1$
	public static final String PasswordsInEnvironmentRuleFactory_CONFIG_EXCLUDED_STRINGS = "PasswordsInEnvironmentRuleFactory_CONFIG_EXCLUDED_STRINGS"; //$NON-NLS-1$
	public static final String PasswordsInEnvironmentRuleFactory_CONFIG_EXCLUDED_STRINGS_LONG = "PasswordsInEnvironmentRuleFactory_CONFIG_EXCLUDED_STRINGS_LONG"; //$NON-NLS-1$
	public static final String PasswordsInEnvironmentRuleFactory_RULE_NAME = "PasswordsInEnvironmentRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String PasswordsInEnvironmentRuleFactory_TEXT_INFO = "PasswordsInEnvironmentRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String PasswordsInEnvironmentRuleFactory_TEXT_INFO_EXCLUDED_INFO = "PasswordsInEnvironmentRuleFactory_TEXT_INFO_EXCLUDED_INFO"; //$NON-NLS-1$	
	public static final String PasswordsInEnvironmentRuleFactory_TEXT_INFO_LONG = "PasswordsInEnvironmentRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String PasswordsInEnvironmentRuleFactory_TEXT_SOLUTION = "PasswordsInEnvironmentRuleFactory_TEXT_SOLUTION"; //$NON-NLS-1$
	public static final String PasswordsInEnvironmentRuleFactory_TEXT_OK = "PasswordsInEnvironmentRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_CONFIG_EXCLUDED_STRINGS = "PasswordsInSystemPropertiesRule_CONFIG_EXCLUDED_STRINGS"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_CONFIG_EXCLUDED_STRINGS_LONG = "PasswordsInSystemPropertiesRule_CONFIG_EXCLUDED_STRINGS_LONG"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_RULE_NAME = "PasswordsInSystemPropertiesRule_RULE_NAME"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_TEXT_INFO = "PasswordsInSystemPropertiesRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_TEXT_INFO_EXCLUDED_INFO = "PasswordsInSystemPropertiesRule_TEXT_INFO_EXCLUDED_INFO"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_TEXT_INFO_LONG = "PasswordsInSystemPropertiesRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_TEXT_SOLUTION = "PasswordsInSystemPropertiesRule_TEXT_SOLUTION"; //$NON-NLS-1$
	public static final String PasswordsInSystemPropertiesRule_TEXT_OK = "PasswordsInSystemPropertiesRule_TEXT_OK"; //$NON-NLS-1$
	public static final String Preference_SHORT_RECORDING = "Preference_SHORT_RECORDING"; //$NON-NLS-1$
	public static final String Preference_SHORT_RECORDING_LONG = "Preference_SHORT_RECORDING_LONG"; //$NON-NLS-1$
	public static final String ProcessStartedRule_RULE_NAME = "ProcessStartedRule_RULE_NAME"; //$NON-NLS-1$
	public static final String ProcessStartedRule_TEXT_INFO = "ProcessStartedRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String ProcessStartedRule_TEXT_OK = "ProcessStartedRule_TEXT_OK"; //$NON-NLS-1$
	public static final String ReferenceStatisticsType_FINAL_REFERENCES = "ReferenceStatisticsType_FINAL_REFERENCES"; //$NON-NLS-1$
	public static final String ReferenceStatisticsType_PHANTOM_REFERENCES = "ReferenceStatisticsType_PHANTOM_REFERENCES"; //$NON-NLS-1$
	public static final String ReferenceStatisticsType_SOFT_REFERENCES = "ReferenceStatisticsType_SOFT_REFERENCES"; //$NON-NLS-1$
	public static final String ReferenceStatisticsType_WEAK_REFERENCES = "ReferenceStatisticsType_WEAK_REFERENCES"; //$NON-NLS-1$
	public static final String SerialGcOnMultiCpuRuleFactory_TEXT_INFO = "SerialGcOnMultiCpuRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String SerialGcOnMultiCpuRuleFactory_TEXT_INFO_LONG = "SerialGcOnMultiCpuRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String SerialOldRuleFactory_TEXT_WARN_CMS = "SerialOldRuleFactory_TEXT_WARN_CMS"; //$NON-NLS-1$
	public static final String SerialOldRuleFactory_TEXT_WARN_CMS_LONG = "SerialOldRuleFactory_TEXT_WARN_CMS_LONG"; //$NON-NLS-1$
	public static final String SerialOldRuleFactory_TEXT_WARN_G1 = "SerialOldRuleFactory_TEXT_WARN_G1"; //$NON-NLS-1$
	public static final String SerialOldRuleFactory_TEXT_WARN_G1_LONG = "SerialOldRuleFactory_TEXT_WARN_G1_LONG"; //$NON-NLS-1$
	public static final String SocketReadRuleFactory_RULE_NAME = "SocketReadRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String SocketReadRuleFactory_TEXT_NO_EVENTS = "SocketReadRuleFactory_TEXT_NO_EVENTS"; //$NON-NLS-1$
	public static final String SocketReadRuleFactory_TEXT_OK = "SocketReadRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String SocketReadRuleFactory_TEXT_RMI_NOTE = "SocketReadRuleFactory_TEXT_RMI_NOTE"; //$NON-NLS-1$
	public static final String SocketReadRuleFactory_TEXT_WARN = "SocketReadRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String SocketReadRuleFactory_TEXT_WARN_LONG = "SocketReadRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String SocketReadRule_CONFIG_INFO_LIMIT = "SocketReadRule_CONFIG_INFO_LIMIT"; //$NON-NLS-1$
	public static final String SocketReadRule_CONFIG_INFO_LIMIT_LONG = "SocketReadRule_CONFIG_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String SocketReadRule_CONFIG_WARNING_LIMIT = "SocketReadRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String SocketReadRule_CONFIG_WARNING_LIMIT_LONG = "SocketReadRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String SocketWriteRuleFactory_RULE_NAME = "SocketWriteRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String SocketWriteRuleFactory_TEXT_NO_EVENTS = "SocketWriteRuleFactory_TEXT_NO_EVENTS"; //$NON-NLS-1$
	public static final String SocketWriteRuleFactory_TEXT_OK = "SocketWriteRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String SocketWriteRuleFactory_TEXT_RMI_NOTE = "SocketWriteRuleFactory_TEXT_RMI_NOTE"; //$NON-NLS-1$
	public static final String SocketWriteRuleFactory_TEXT_WARN = "SocketWriteRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String SocketWriteRuleFactory_TEXT_WARN_LONG = "SocketWriteRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String SocketWriteRule_CONFIG_INFO_LIMIT = "SocketWriteRule_CONFIG_INFO_LIMIT"; //$NON-NLS-1$
	public static final String SocketWriteRule_CONFIG_INFO_LIMIT_LONG = "SocketWriteRule_CONFIG_INFO_LIMIT_LONG"; //$NON-NLS-1$
	public static final String SocketWriteRule_CONFIG_WARNING_LIMIT = "SocketWriteRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String SocketWriteRule_CONFIG_WARNING_LIMIT_LONG = "SocketWriteRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String StackdepthSettingRule_RULE_NAME = "StackdepthSettingRule_RULE_NAME"; //$NON-NLS-1$
	public static final String StackdepthSettingRule_TEXT_INFO = "StackdepthSettingRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String StackdepthSettingRule_TEXT_INFO_LONG = "StackdepthSettingRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String StackdepthSettingRule_TEXT_INFO_LONG_DEFAULT = "StackdepthSettingRule_TEXT_INFO_LONG_DEFAULT"; //$NON-NLS-1$
	public static final String StackdepthSettingRule_TEXT_NA = "StackdepthSettingRule_TEXT_NA"; //$NON-NLS-1$
	public static final String StackdepthSettingRule_TEXT_OK = "StackdepthSettingRule_TEXT_OK"; //$NON-NLS-1$
	public static final String StackdepthSettingRule_TYPE_LIST_TEMPLATE = "StackdepthSettingRule_TYPE_LIST_TEMPLATE"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_DONT_RECOMMEND_STRING_DEDUPLICATION = "StringDeduplicationRule_RESULT_DONT_RECOMMEND_STRING_DEDUPLICATION"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_HEAP_USAGE = "StringDeduplicationRule_RESULT_HEAP_USAGE"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_LONG_DESCRIPTION = "StringDeduplicationRule_RESULT_LONG_DESCRIPTION"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_GC_LONG = "StringDeduplicationRule_RESULT_GC_LONG"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_NO_ALLOC_ITEMS = "StringDeduplicationRule_RESULT_NO_ALLOC_ITEMS"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_NO_MAX_HEAP_INFO = "StringDeduplicationRule_RESULT_NO_MAX_HEAP_INFO"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_RECOMMEND_STRING_DEDUPLICATION = "StringDeduplicationRule_RESULT_RECOMMEND_STRING_DEDUPLICATION"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_STRING_ARRAY_ALLOCATION_RATIO = "StringDeduplicationRule_RESULT_STRING_ARRAY_ALLOCATION_RATIO"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_STRING_ARRAY_LIVESET_RATIO = "StringDeduplicationRule_RESULT_STRING_ARRAY_LIVESET_RATIO"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RESULT_USE_STRING_DEDUPLICATION_ENABLED = "StringDeduplicationRule_RESULT_USE_STRING_DEDUPLICATION_ENABLED"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_RULE_NAME = "StringDeduplicationRule_RULE_NAME"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES = "StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES_DESC = "StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES_DESC"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT = "StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT_DESC = "StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT_DESC"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT = "StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT"; //$NON-NLS-1$
	public static final String StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT_DESC = "StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT_DESC"; //$NON-NLS-1$
	public static final String SystemGcRuleFactory_RULE_NAME = "SystemGcRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String SystemGcRuleFactory_TEXT_INFO = "SystemGcRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String SystemGcRuleFactory_TEXT_INFO_LONG = "SystemGcRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String SystemGcRuleFactory_TEXT_OK = "SystemGcRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String SystemGcRule_CONFIG_WARNING_LIMIT = "SystemGcRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String SystemGcRule_CONFIG_WARNING_LIMIT_LONG = "SystemGcRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String TlabAllocationRatioRuleFactory_RULE_NAME = "TlabAllocationRatioRuleFactory_RULE_NAME"; //$NON-NLS-1$
	public static final String TlabAllocationRatioRuleFactory_TEXT_INFO = "TlabAllocationRatioRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE = "TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE"; //$NON-NLS-1$
	public static final String TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE_LONG = "TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE_LONG"; //$NON-NLS-1$
	public static final String TlabAllocationRatioRuleFactory_TEXT_OK_NO_OUTSIDE = "TlabAllocationRatioRuleFactory_TEXT_OK_NO_OUTSIDE"; //$NON-NLS-1$
	public static final String TlabAllocationRatioRuleFactory_TEXT_RECOMMEND_LESS_ALLOCATION = "TlabAllocationRatioRuleFactory_TEXT_RECOMMEND_LESS_ALLOCATION"; //$NON-NLS-1$
	public static final String UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO = "UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO"; //$NON-NLS-1$
	public static final String UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG = "UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String VMOperationRuleFactory_TEXT_OK = "VMOperationRuleFactory_TEXT_OK"; //$NON-NLS-1$
	public static final String VMOperationRuleFactory_TEXT_OK_COMBINED_DURATION = "VMOperationRuleFactory_TEXT_OK_COMBINED_DURATION"; //$NON-NLS-1$
	public static final String VMOperationRuleFactory_TEXT_WARN = "VMOperationRuleFactory_TEXT_WARN"; //$NON-NLS-1$
	public static final String VMOperationRuleFactory_TEXT_WARN_COMBINED_DURATION = "VMOperationRuleFactory_TEXT_WARN_COMBINED_DURATION"; //$NON-NLS-1$
	public static final String VMOperationRuleFactory_TEXT_WARN_LONG = "VMOperationRuleFactory_TEXT_WARN_LONG"; //$NON-NLS-1$
	public static final String VMOperationRuleFactory_TEXT_WARN_LONG_COMBINED_DURATION = "VMOperationRuleFactory_TEXT_WARN_LONG_COMBINED_DURATION"; //$NON-NLS-1$
	public static final String VMOperationRule_CONFIG_WARNING_LIMIT = "VMOperationRule_CONFIG_WARNING_LIMIT"; //$NON-NLS-1$
	public static final String VMOperationRule_CONFIG_WARNING_LIMIT_LONG = "VMOperationRule_CONFIG_WARNING_LIMIT_LONG"; //$NON-NLS-1$
	public static final String VMOperations_RULE_NAME = "VMOperations_RULE_NAME"; //$NON-NLS-1$
	public static final String VerifyNoneRule_RULE_NAME = "VerifyNoneRule_RULE_NAME"; //$NON-NLS-1$
	public static final String VerifyNoneRule_TEXT_INFO = "VerifyNoneRule_TEXT_INFO"; //$NON-NLS-1$
	public static final String VerifyNoneRule_TEXT_INFO_LONG = "VerifyNoneRule_TEXT_INFO_LONG"; //$NON-NLS-1$
	public static final String VerifyNoneRule_TEXT_OK = "VerifyNoneRule_TEXT_OK"; //$NON-NLS-1$
	public static final String VerifyNoneRule_WLS_TEXT_INFO = "VerifyNoneRule_WLS_TEXT_INFO"; //$NON-NLS-1$
	public static final String VerifyNoneRule_WLS_TEXT_INFO_LONG = "VerifyNoneRule_WLS_TEXT_INFO_LONG"; //$NON-NLS-1$

	private Messages() {
	}

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
}
