/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The contents of this file are subject to the terms of either the Universal Permissive License
 * v 1.0 as shown at http://oss.oracle.com/licenses/upl
 *
 * or the following license:
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions
 * and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided with
 * the distribution.
 * 
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

/**
 * Class that holds reference to the icons and images used by the Flight Recorder plug-in
 */
public class ImageConstants {
	public static final String ICON_ARROW_DOWN = "arrow-down.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_UP = "arrow-up.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_DOWN_END = "arrow-down-end.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_UP_END = "arrow-up-end.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_CURVED_DOWN = "arrow-curved-down.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_CURVED_UP = "arrow-curved-up.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_FORK3_DOWN = "arrow-fork3-down.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_FORK3_UP = "arrow-fork3-up.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_FORK3_RIGHT = "arrow-fork3-right.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_FORK3_LEFT = "arrow-fork3-left.png"; //$NON-NLS-1$
	public static final String ICON_ARROW_FORK3_STAR = "arrow-fork3-star.png"; //$NON-NLS-1$

	public static final String ICON_START_FLIGHT_BANNER = "tape.png"; //$NON-NLS-1$
	public static final String ICON_DOWNLOAD_TIME_INTERVAL = "download_time.gif"; //$NON-NLS-1$
	public static final String ICON_BUILDER = "builder.png"; //$NON-NLS-1$
	public static final String ICON_DEBUG = "debug.png"; //$NON-NLS-1$
	public static final String ICON_CLEAR = "clear_co.gif"; //$NON-NLS-1$

	public static final String IMAGE_BANNER_EXTRACT_WIZ = "extstr_wiz.gif"; //$NON-NLS-1$
	public static final String IMAGE_BANNER_IMPORT_PREFS = "importpref_wiz.gif"; //$NON-NLS-1$
	public static final String ICON_EVENT = "event-general-16.png"; //$NON-NLS-1$
	public static final String ICON_EVENT_PROPERTIES = "event-properties-16.png"; //$NON-NLS-1$
	public static final String ICON_EVENT_TYPE_SELECTOR = "event-selector-16.png"; //$NON-NLS-1$
	public static final String FILTER_BANNER = "filter_wiz.png"; //$NON-NLS-1$
	public static final String FILTER_ICON = "filter.gif"; //$NON-NLS-1$
	public static final String ICON_TIMESPAN = "time-span-16.png"; //$NON-NLS-1$

	public static final String ICON_ECID = "ecid.png"; //$NON-NLS-1$
	public static final String ICON_LOG = "log.gif"; //$NON-NLS-1$
	public static final String ICON_OVERLAY_ERROR_DR = "error_co_dr.gif"; //$NON-NLS-1$
	public static final String ICON_OVERLAY_WARNING_DR = "warning_co_dr.gif"; //$NON-NLS-1$

	public static final String ICON_CHECK_GREEN = "check-green.png"; //$NON-NLS-1$
	public static final String ICON_CHECK_BLUE = "check-blue.png"; //$NON-NLS-1$
	public static final String ICON_IMPACT_HIGH = "impact_high.png"; //$NON-NLS-1$
	public static final String ICON_IMPACT_LOW = "impact_low.png"; //$NON-NLS-1$

	public static final String ICON_CHART_BAR = "chart_bar_16x16.gif"; //$NON-NLS-1$
	public static final String ICON_CHART_CURVE = "chart_curve_16x16.png"; //$NON-NLS-1$
	public static final String ICON_CHART_LINE = "chart_line_16x16.png"; //$NON-NLS-1$
	public static final String ICON_CHART_PIE = "chart_pie_16x16.png"; //$NON-NLS-1$

	public static final String ICON_OK = "ok.png"; //$NON-NLS-1$
	public static final String ICON_NA = "na.png"; //$NON-NLS-1$
	public static final String ICON_INFO = "info.png"; //$NON-NLS-1$
	public static final String ICON_WARNING = "warning.png"; //$NON-NLS-1$
	public static final String ICON_ERROR = "Erreur-icon.png"; //$NON-NLS-1$
	public static final String ICON_STOP = "stop.png"; //$NON-NLS-1$

	public static final String ICON_HEATMAP = "heatmap.png"; //$NON-NLS-1$
	public static final String ICON_OVERVIEW = "overview.png"; //$NON-NLS-1$
	public static final String ICON_TABLE = "table.gif"; //$NON-NLS-1$

	public static final String ICON_WARNING_OVERLAY = "warning_overlay.png"; //$NON-NLS-1$
	public static final String ICON_INFO_OVERLAY = "info_overlay.png"; //$NON-NLS-1$

	public static final String ICON_PARTS = "parts.png"; //$NON-NLS-1$
	public static final String ICON_GROUP_BY = "group_by.png"; //$NON-NLS-1$
	public static final String ICON_GROUP_BY_COMBINE = "group_by_combine.png"; //$NON-NLS-1$

	public static final String ICON_NEW_PAGE = "new_page.png"; //$NON-NLS-1$

	public static final String ICON_LANES = "lanes.gif"; //$NON-NLS-1$
	public static final String ICON_LANES_EDIT = "lanes_edit.gif"; //$NON-NLS-1$
	public static final String ICON_LANE = "lane.gif"; //$NON-NLS-1$

	public static final String ICON_EXCEPTION_BY_CLASS = "exceptions_by_class.png"; //$NON-NLS-1$
	public static final String ICON_EXCEPTION_BY_MESSAGE = "exceptions_by_message.png"; //$NON-NLS-1$
	public static final String ICON_EXCEPTION_BY_CLASS_AND_MESSAGE = "exceptions_by_class_and_message.png"; //$NON-NLS-1$

	public static final String ICON_IO_BY_HOST = "io_by_host.png"; //$NON-NLS-1$
	public static final String ICON_IO_BY_PORT = "io_by_port.png"; //$NON-NLS-1$
	public static final String ICON_IO_BY_HOST_AND_PORT = "io_by_host_and_port.png"; //$NON-NLS-1$

	public static final String ICON_MAGNIFIER = "magnifier.png"; //$NON-NLS-1$

	public static final String PAGE_CONSTANT_POOL = "pages/cpool.png"; //$NON-NLS-1$
	public static final String PAGE_JAVA_APPLICATION = "pages/methodprofiling.png"; //$NON-NLS-1$
	public static final String PAGE_METHOD = "pages/method.png"; //$NON-NLS-1$
	public static final String PAGE_HEAP = "pages/objectstatistics.png"; //$NON-NLS-1$
	public static final String PAGE_LOCKINSTANCES = "pages/locks.png"; //$NON-NLS-1$
	public static final String PAGE_IO = "pages/io.png"; //$NON-NLS-1$
	public static final String PAGE_LATENCIES = "pages/latencies.png"; //$NON-NLS-1$
	public static final String PAGE_GENERAL = "pages/general.png"; //$NON-NLS-1$
	public static final String PAGE_EXCEPTIONS = "pages/exceptions.png"; //$NON-NLS-1$
	public static final String PAGE_THREAD_DUMPS = "pages/threaddumps.png"; //$NON-NLS-1$
	public static final String PAGE_THREADS = "pages/threadgraph.png"; //$NON-NLS-1$
	public static final String PAGE_JVM_INTERNALS = "pages/jvminformation.png"; //$NON-NLS-1$
	public static final String PAGE_GC = "pages/gc.png"; //$NON-NLS-1$
	public static final String PAGE_GC_CONFIGURATION = "pages/gcconfig.png"; //$NON-NLS-1$
	public static final String PAGE_COMPILATIONS = "pages/compilations.png"; //$NON-NLS-1$
	public static final String PAGE_CLASSLOADING = "pages/classloading.png"; //$NON-NLS-1$
	public static final String PAGE_TLAB_ALLOCATIONS = "pages/allocations.png"; //$NON-NLS-1$
	public static final String PAGE_ENVIRONMENT = "pages/system.png"; //$NON-NLS-1$
	public static final String PAGE_PROCESSES = "pages/processes.png"; //$NON-NLS-1$
	public static final String PAGE_ENVIRONMENT_VARIABLES = "pages/environment.png"; //$NON-NLS-1$
	public static final String PAGE_SYSTEM_PROPERTIES = "pages/systemproperties.png"; //$NON-NLS-1$
	public static final String PAGE_RECORDING = "pages/recording.png"; //$NON-NLS-1$
	public static final String PAGE_NATIVE_LIBRARY = "pages/nativelibraries.png"; //$NON-NLS-1$ //FIXME!
}
