/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.util;

import org.eclipse.core.runtime.IStatus;

public class StatusTool {
    public static String collectProblems(IStatus status) {
        return StatusTool.statusToString(status, false);
    }

    public static String toLogMessage(IStatus status) {
        return StatusTool.statusToString(status, true);
    }

    private static String statusToString(IStatus status, boolean multiLine) {
        if (!StatusTool.hasChildren(status)) {
            return status.getMessage();
        }
        StatusStringBuilder builder = new StatusStringBuilder();
        HierarchyFormatter formatter = multiLine ? new HierarchyFormatter(":\n", "   ", "\n", "") : new HierarchyFormatter(": [", null, "; ", "]");
        builder.appendStatusAndChildren(status, formatter);
        return builder.toString();
    }

    public static Throwable findException(IStatus status) {
        Throwable rootException = status.getException();
        if (rootException != null) {
            return rootException;
        }
        if (StatusTool.hasChildren(status)) {
            return StatusTool.findExceptionInChildren(status.getChildren());
        }
        return null;
    }

    private static Throwable findExceptionInChildren(IStatus[] children) {
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            Throwable childException = StatusTool.findException(child);
            if (childException != null) {
                return childException;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasChildren(IStatus status) {
        return status.getChildren() != null && status.getChildren().length > 0;
    }

    private static class HierarchyFormatter {
        private final String indentationIncrement;
        final String indentationString;
        final String childrenStartString;
        final String childrenEndString;
        final String listSeparatorString;

        HierarchyFormatter(String childrenStart, String indentationIncrement, String listSeparator, String childrenEnd) {
            this("", childrenStart, indentationIncrement, listSeparator, childrenEnd);
        }

        private HierarchyFormatter(String indentation, String childrenStart, String indentationIncrement, String listSeparator, String childrenEnd) {
            this.indentationString = indentation;
            this.indentationIncrement = indentationIncrement;
            this.childrenStartString = childrenStart;
            this.childrenEndString = childrenEnd;
            this.listSeparatorString = listSeparator;
        }

        public HierarchyFormatter getChildLevelFormatter() {
            if (this.indentationIncrement == null) {
                return this;
            }
            return new HierarchyFormatter(String.valueOf(this.indentationString) + this.indentationIncrement, this.childrenStartString, this.indentationIncrement, this.listSeparatorString, this.childrenEndString);
        }
    }

    private static class StatusStringBuilder {
        private StringBuilder result = new StringBuilder();

        private StatusStringBuilder() {
        }

        void appendStatusAndChildren(IStatus status, HierarchyFormatter formatter) {
            this.appendStatusMessage(status, formatter);
            if (StatusTool.hasChildren(status)) {
                this.appendChildren(status, formatter);
            }
        }

        private void appendStatusMessage(IStatus status, HierarchyFormatter formatter) {
            this.result.append(formatter.indentationString);
            this.result.append(status.getMessage());
        }

        private void appendChildren(IStatus status, HierarchyFormatter formatter) {
            this.result.append(formatter.childrenStartString);
            this.appendStatusList(status.getChildren(), formatter.getChildLevelFormatter());
            this.result.append(formatter.childrenEndString);
        }

        private void appendStatusList(IStatus[] statusList, HierarchyFormatter formatter) {
            boolean trailingSeparator = false;
            IStatus[] iStatusArray = statusList;
            int n = statusList.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                if (!status.isOK()) {
                    this.appendStatusAndChildren(status, formatter);
                    this.result.append(formatter.listSeparatorString);
                    trailingSeparator = true;
                }
                ++n2;
            }
            if (trailingSeparator) {
                this.result.setLength(this.result.length() - formatter.listSeparatorString.length());
            }
        }

        public String toString() {
            return this.result.toString();
        }
    }
}

