/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.util;

import java.util.Map;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.MavenRepositoryCoordinates;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;

public class GAVArtifactDescriptorBase
extends ArtifactDescriptor {
    protected final MavenRepositoryCoordinates coordinates;

    protected GAVArtifactDescriptorBase(IArtifactDescriptor base, MavenRepositoryCoordinates mavenCoordinates, boolean storeMavenCoordinates) {
        super(base);
        this.coordinates = mavenCoordinates;
        if (this.coordinates == null) {
            throw new NullPointerException();
        }
        if (storeMavenCoordinates) {
            this.setMavenCoordinateProperties();
        }
    }

    protected GAVArtifactDescriptorBase(IArtifactKey p2Key, MavenRepositoryCoordinates mavenCoordinates, boolean storeMavenCoordinates) {
        super(p2Key);
        this.coordinates = mavenCoordinates;
        if (this.coordinates == null) {
            throw new NullPointerException();
        }
        if (storeMavenCoordinates) {
            this.setMavenCoordinateProperties();
        }
    }

    protected final void setMavenCoordinateProperties() {
        this.properties.put("maven-groupId", this.coordinates.getGroupId());
        this.properties.put("maven-artifactId", this.coordinates.getArtifactId());
        this.properties.put("maven-version", this.coordinates.getVersion());
        GAVArtifactDescriptorBase.putOrRemoveOnNull(this.properties, "maven-classifier", this.coordinates.getClassifier());
        GAVArtifactDescriptorBase.putOrRemoveOnNull(this.properties, "maven-extension", this.coordinates.getExtension());
    }

    private static void putOrRemoveOnNull(Map<String, String> properties, String key, String value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    public static MavenRepositoryCoordinates readMavenCoordinateProperties(IArtifactDescriptor descriptor) {
        GAV gav = RepositoryLayoutHelper.getGAV((Map)descriptor.getProperties());
        if (gav == null) {
            return null;
        }
        String classifier = RepositoryLayoutHelper.getClassifier((Map)descriptor.getProperties());
        String extension = RepositoryLayoutHelper.getExtension((Map)descriptor.getProperties());
        return new MavenRepositoryCoordinates(gav, classifier, extension);
    }

    public final MavenRepositoryCoordinates getMavenCoordinates() {
        return this.coordinates;
    }
}

