/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.tycho.p2.maven.repository.AbstractMetadataRepository2;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;

class ModuleMetadataRepository
extends AbstractMetadataRepository2 {
    public static final String REPOSITORY_TYPE = "org.eclipse.tycho.repository.module.ModuleMetadataRepository";
    private File storage;
    private Set<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();

    public ModuleMetadataRepository(IProvisioningAgent agent, File location) throws ProvisionException {
        super(agent, ModuleMetadataRepository.generateName(location), REPOSITORY_TYPE, location);
        this.setLocation(location.toURI());
        this.storage = ModuleMetadataRepository.getStorageFile(location);
        if (this.storage.isFile()) {
            this.load();
        } else {
            this.storeOrThrowProvisioningException();
        }
    }

    private static String generateName(File location) {
        return "module-metadata-repository@" + location;
    }

    private void load() throws ProvisionException {
        try {
            MetadataIO io = new MetadataIO();
            FileInputStream is = new FileInputStream(this.storage);
            this.units.addAll(io.readXML(is));
        }
        catch (IOException e) {
            String message = "I/O error while reading repository from " + this.storage;
            int code = 1002;
            Status status = new Status(4, "org.eclipse.tycho.p2.maven.repository", code, message, (Throwable)e);
            throw new ProvisionException((IStatus)status);
        }
    }

    private void storeOrThrowProvisioningException() throws ProvisionException {
        try {
            this.storeWithoutExceptionHandling();
        }
        catch (IOException e) {
            String message = "I/O error while writing repository to " + this.storage;
            int code = 1003;
            Status status = new Status(4, "org.eclipse.tycho.p2.maven.repository", code, message, (Throwable)e);
            throw new ProvisionException((IStatus)status);
        }
    }

    private void storeOrThrowRuntimeException() {
        try {
            this.storeWithoutExceptionHandling();
        }
        catch (IOException iOException) {
            String message = "I/O error while writing repository to " + this.storage;
            throw new RuntimeException(message);
        }
    }

    private void storeWithoutExceptionHandling() throws IOException {
        this.storage.getParentFile().mkdirs();
        MetadataIO io = new MetadataIO();
        io.writeXML(this.units, this.storage);
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return query.perform(this.units.iterator());
    }

    public boolean isModifiable() {
        return true;
    }

    public void addInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        this.units.addAll(installableUnits);
        this.storeOrThrowRuntimeException();
    }

    public boolean removeInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        boolean result = this.units.removeAll(installableUnits);
        this.storeOrThrowRuntimeException();
        return result;
    }

    public void removeAll() {
        this.units.clear();
        this.storeOrThrowRuntimeException();
    }

    File getPersistenceFile() {
        return this.storage;
    }

    static boolean canAttemptRead(File repositoryDir) {
        File requiredP2MetadataFile = ModuleMetadataRepository.getStorageFile(repositoryDir);
        return requiredP2MetadataFile.isFile();
    }

    private static File getStorageFile(File repositoryDir) {
        return new File(repositoryDir, "p2content.xml");
    }
}

