/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local.index;

import java.io.File;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;
import org.eclipse.tycho.repository.local.index.FileBasedTychoRepositoryIndex;

public class LocalRepositoryP2IndicesImpl
implements LocalRepositoryP2Indices {
    private FileLockService fileLockService;
    private File localRepositoryRoot;
    private MavenLogger logger;
    private boolean initialized = false;
    private TychoRepositoryIndex artifactsIndex;
    private TychoRepositoryIndex metadataIndex;

    public LocalRepositoryP2IndicesImpl() {
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.localRepositoryRoot = mavenContext.getLocalRepositoryRoot();
        this.logger = mavenContext.getLogger();
    }

    public void setFileLockService(FileLockService fileLockService) {
        this.fileLockService = fileLockService;
    }

    public LocalRepositoryP2IndicesImpl(File localRepositoryRoot, FileLockService fileLockService) {
        this.localRepositoryRoot = localRepositoryRoot;
        this.fileLockService = fileLockService;
    }

    private void checkInitialized() {
        if (this.initialized) {
            return;
        }
        this.artifactsIndex = FileBasedTychoRepositoryIndex.createArtifactsIndex(this.localRepositoryRoot, this.fileLockService, this.logger);
        this.metadataIndex = FileBasedTychoRepositoryIndex.createMetadataIndex(this.localRepositoryRoot, this.fileLockService, this.logger);
        this.initialized = true;
    }

    public TychoRepositoryIndex getArtifactsIndex() {
        this.checkInitialized();
        return this.artifactsIndex;
    }

    public TychoRepositoryIndex getMetadataIndex() {
        this.checkInitialized();
        return this.metadataIndex;
    }

    public File getBasedir() {
        return this.localRepositoryRoot;
    }
}

