/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.support;

import java.io.Serializable;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.runner.Description;

@API(status=API.Status.INTERNAL, since="4.12")
public class UniqueIdReader
implements Function<Description, Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(UniqueIdReader.class);
    private final String fieldName;

    public UniqueIdReader() {
        this("fUniqueId");
    }

    UniqueIdReader(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public Serializable apply(Description description) {
        return ReflectionUtils.tryToReadFieldValue(Description.class, this.fieldName, description).andThenTry(Serializable.class::cast).ifFailure(cause -> logger.warn((Throwable)cause, () -> String.format("Could not read unique ID for Description; using display name instead: %s", description))).toOptional().orElseGet(() -> ((Description)description).getDisplayName());
    }
}

