/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class RecordingSettingsRule
implements IRule {
    private static final String RECORDING_SETTINGS_RESULT_ID = "OverAggressiveRecordingSetting";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.InitialSystemProperty", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedCollectionResult<String> NO_THRESHOLD_EVENT_TYPES = new TypedCollectionResult("noThresholdEventTypes", "No Threshold Event Types", "Event types that have no threshold.", UnitLookup.PLAIN_TEXT, String.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(NO_THRESHOLD_EVENT_TYPES);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        String names = RulesToolkit.getTypesWithZeroThreshold((IItemCollection)items, (String[])new String[]{"jdk.ThreadPark", "jdk.JavaMonitorEnter"});
        if (names != null && !names.isEmpty()) {
            String[] types = names.split(",");
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("OverAggressiveRecordingSettingRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("OverAggressiveRecordingSettingRuleFactory_TEXT_INFO_LONG")).addResult(NO_THRESHOLD_EVENT_TYPES, Arrays.asList(types)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("OverAggressiveRecordingSettingRuleFactory_RULE_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return RecordingSettingsRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RECORDING_SETTINGS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("OverAggressiveRecordingSettingRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "recording";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

