/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.cpu;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanLimit;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class CompareCpuRule
extends AbstractRule {
    public static final TypedPreference<IQuantity> OTHER_CPU_WARNING_LIMIT = new TypedPreference("other.cpu.warning.limit", Messages.getString("CompareCpuRule_WARNING_LIMIT"), Messages.getString("CompareCpuRule_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(40L));
    public static final TypedPreference<IQuantity> OTHER_CPU_INFO_LIMIT = new TypedPreference("other.cpu.info.limit", Messages.getString("CompareCpuRule_INFO_LIMIT"), Messages.getString("CompareCpuRule_INFO_LIMIT_LONG"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(20L));
    private static final Collection<TypedPreference<?>> CONFIGURATION_ATTRIBUTES = Arrays.asList(OTHER_CPU_INFO_LIMIT, OTHER_CPU_WARNING_LIMIT);
    public static final TypedResult<IQuantity> AVERAGE_CPU_LOAD = new TypedResult("avgCpuLoad", "Average CPU Load", "The average CPU load detected.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IRange<IQuantity>> AVERAGE_CPU_LOAD_WINDOW = new TypedResult("avgCpuLoadWindow", "Average CPU Load Window", "The window during which the high CPU load was detected.", UnitLookup.TIMERANGE);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, AVERAGE_CPU_LOAD, AVERAGE_CPU_LOAD_WINDOW);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.CPULoad", RulesToolkit.EventAvailability.AVAILABLE).build();

    public CompareCpuRule() {
        super("CompareCpu", Messages.getString("CompareCpuRule_RULE_NAME"), "processes", CONFIGURATION_ATTRIBUTES, RESULT_ATTRIBUTES, REQUIRED_EVENTS);
    }

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        double warningLimit = ((IQuantity)vp.getPreferenceValue(OTHER_CPU_WARNING_LIMIT)).doubleValue() / 100.0;
        double infoLimit = ((IQuantity)vp.getPreferenceValue(OTHER_CPU_INFO_LIMIT)).doubleValue() / 100.0;
        IItemCollection cpuItems = items.apply(JdkFilters.CPU_LOAD);
        IType cpuLoadType = RulesToolkit.getType((IItemCollection)cpuItems, (String)"jdk.CPULoad");
        if (!cpuLoadType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.JVM_TOTAL)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)cpuLoadType, (IAttribute)JdkAttributes.JVM_TOTAL, (IPreferenceValueProvider)vp);
        }
        SpanLimit maxOtherCpu = SpanToolkit.getMaxSpanLimit(cpuItems, (IAttribute<IQuantity>)JdkAttributes.OTHER_CPU, (IAttribute<IQuantity>)JfrAttributes.END_TIME, warningLimit);
        SpanLimit maxOtherCpuRatio = SpanToolkit.getMaxSpanLimit(cpuItems, (IAttribute<IQuantity>)JdkAttributes.OTHER_CPU_RATIO, (IAttribute<IQuantity>)JfrAttributes.END_TIME, warningLimit);
        if (maxOtherCpu == null || maxOtherCpuRatio == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.NA).setSummary(Messages.getString("CompareCpuRule_TEXT_TOO_FEW_SAMPLES")).build();
        }
        double score = RulesToolkit.mapExp100((double)maxOtherCpuRatio.value, (double)infoLimit, (double)warningLimit);
        IRange cpuLoadWindow = QuantityRange.createWithEnd((IQuantity)UnitLookup.EPOCH_NS.quantity(maxOtherCpu.start), (IQuantity)UnitLookup.EPOCH_NS.quantity(maxOtherCpu.end));
        ITypedQuantity otherCpuMaxValue = UnitLookup.PERCENT.quantity(Math.round(maxOtherCpu.value * 100.0));
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("CompareCpuRule_TEXT_MESSAGE")).setExplanation(Messages.getString("CompareCpuRule_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(AVERAGE_CPU_LOAD, (Object)otherCpuMaxValue).addResult(AVERAGE_CPU_LOAD_WINDOW, (Object)cpuLoadWindow).build();
    }
}

