/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input.awt;

import org.jemmy.JemmyException;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.input.awt.AWTMap;
import org.jemmy.input.awt.DragImpl;
import org.jemmy.input.awt.KeyboardImpl;
import org.jemmy.input.awt.MouseImpl;
import org.jemmy.input.awt.RobotDriver;
import org.jemmy.input.awt.RobotExecutor;
import org.jemmy.interfaces.ControlInterface;
import org.jemmy.interfaces.ControlInterfaceFactory;
import org.jemmy.interfaces.Drag;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Mouse;
import org.jemmy.interfaces.TypeControlInterface;
import org.jemmy.operators.Screen;
import org.jemmy.operators.awt.AWTScreen;

public class AWTRobotInputFactory
implements ControlInterfaceFactory {
    public static final String OTHER_VM_PROPERTY = "awt.robot.othervm";
    public static final String OTHER_VM_HOST_PROPERTY = "awt.robot.othervm.host";
    public static final String OTHER_VM_PORT_PROPERTY = "awt.robot.othervm.port";
    public static final String OTHER_VM_CONNECTION_TIMEOUT_PROPERTY = "awt.robot.othervm.connection.timeout";
    public static final String ROBOT_DELAY_TIMEOUT_NAME = "RobotDriver.DelayTimeout";
    public static final String ROBOT_MOUSE_SMOOTHNESS_PROPERTY = "awt.robot.mouse.smoothness";

    public static void runInOtherJVM(boolean runInOtherJVM) {
        RobotExecutor.get().setRunInOtherJVM(runInOtherJVM);
    }

    public static boolean isRunInOtherJVM() {
        return RobotExecutor.get().isRunInOtherJVM();
    }

    public static void setMouseSmoothness(int mouseSmoothness) {
        if (mouseSmoothness <= 0) {
            throw new IllegalArgumentException("Mouse smoothness should be greater than zero.");
        }
        RobotDriver.setMouseSmoothness(mouseSmoothness);
    }

    public static int getMouseSmoothness() {
        return RobotDriver.getMouseSmoothness();
    }

    public AWTMap getAwtMap() {
        return RobotExecutor.get().getAWTMap();
    }

    public void setAwtMap(AWTMap awtMap) {
        RobotExecutor.get().setAWTMap(awtMap);
    }

    public <INTERFACE extends ControlInterface> INTERFACE create(Wrap<?> control, Class<INTERFACE> interfaceClass) {
        if (Mouse.class.isAssignableFrom(interfaceClass)) {
            return (INTERFACE)new MouseImpl(control);
        }
        if (Keyboard.class.isAssignableFrom(interfaceClass)) {
            return (INTERFACE)new KeyboardImpl(control);
        }
        if (Drag.class.isAssignableFrom(interfaceClass)) {
            return (INTERFACE)new DragImpl(control);
        }
        throw new JemmyException(AWTRobotInputFactory.class.getName() + " does not support " + interfaceClass.getName());
    }

    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> INTERFACE create(Wrap<?> control, Class<INTERFACE> interfaceClass, Class<TYPE> type) {
        throw new JemmyException(AWTRobotInputFactory.class.getName() + " does not support " + interfaceClass.getName());
    }

    public String toString() {
        return this.getClass().getName() + "[otherVM=" + AWTRobotInputFactory.isRunInOtherJVM() + ", mouseSmoothness=" + AWTRobotInputFactory.getMouseSmoothness() + "]";
    }

    static {
        if (Screen.SCREEN == null) {
            Screen.setSCREEN((Screen)new AWTScreen(Environment.getEnvironment()));
        }
    }
}

