/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.awt;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jemmy.image.awt.DiffDialog;

class ImageTool {
    ImageTool() {
    }

    public static BufferedImage enlargeImage(BufferedImage image, int zoom) {
        int wight = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(wight * zoom, height * zoom, image.getType());
        for (int x = 0; x < wight; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = image.getRGB(x, y);
                for (int i = 0; i < zoom; ++i) {
                    for (int j = 0; j < zoom; ++j) {
                        result.setRGB(x * zoom + i, y * zoom + j, rgb);
                    }
                }
            }
        }
        return result;
    }

    public static BufferedImage subtractImage(BufferedImage minuend, BufferedImage deduction) {
        return ImageTool.subtractImage(minuend, deduction, 0, 0, null);
    }

    public static BufferedImage subtractImage(BufferedImage minuend, BufferedImage deduction, Color highlight) {
        return ImageTool.subtractImage(minuend, deduction, 0, 0, highlight);
    }

    public static BufferedImage subtractImage(BufferedImage minuend, BufferedImage deduction, int relativeX, int relativeY) {
        return ImageTool.subtractImage(minuend, deduction, relativeX, relativeY, null);
    }

    public static BufferedImage subtractImage(BufferedImage minuend, BufferedImage deduction, int relativeX, int relativeY, Color highlight) {
        int mWidth = minuend.getWidth();
        int mHeight = minuend.getHeight();
        int dWidth = deduction.getWidth();
        int dHeight = deduction.getHeight();
        int maxWidth = mWidth > relativeX + dWidth ? mWidth : relativeX + dWidth;
        int maxHeight = mHeight > relativeY + dHeight ? mHeight : relativeY + dHeight;
        BufferedImage result = new BufferedImage(maxWidth, maxHeight, 1);
        for (int x = 0; x < maxWidth; ++x) {
            for (int y = 0; y < maxHeight; ++y) {
                int dColor;
                int mColor = x >= mWidth || y >= mHeight ? 0 : minuend.getRGB(x, y);
                result.setRGB(x, y, mColor != (dColor = x >= dWidth + relativeX || y >= dHeight + relativeY || x < relativeX || y < relativeY ? 0 : deduction.getRGB(x - relativeX, y - relativeY)) ? ImageTool.subtractColor(highlight != null ? highlight.getRGB() : 0, mColor, dColor) : 0);
            }
        }
        return result;
    }

    public static double distance(int rgb1, int rgb2) {
        float[] buffer1 = new float[3];
        float[] buffer2 = new float[3];
        Color c1 = new Color(rgb1);
        Color c2 = new Color(rgb2);
        c1.getRGBColorComponents(buffer1);
        c2.getRGBColorComponents(buffer2);
        double distSquare = 0.0;
        for (int i = 0; i < 3; ++i) {
            distSquare += (double)((buffer1[i] - buffer2[i]) * (buffer1[i] - buffer2[i]));
        }
        return Math.sqrt(distSquare);
    }

    private static int subtractColor(int highlight, int m, int d) {
        if (highlight == 0) {
            float scale = (float)(ImageTool.distance(m, d) / Math.sqrt(3.0));
            return new Color(scale, scale, scale).getRGB();
        }
        return highlight;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            ImageTool.usage();
            System.exit(1);
        }
        ImageTool.compare(new File(args[0]).getAbsoluteFile(), new File(args[1]).getAbsoluteFile());
    }

    private static void compare(File golden, File results) throws IOException {
        if (golden.isDirectory()) {
            for (File fl : golden.listFiles()) {
                ImageTool.compare(fl, new File(results.getAbsolutePath() + File.separator + fl.getName()));
            }
            for (File fl : results.listFiles()) {
                File rfl = new File(golden.getAbsolutePath() + File.separator + fl.getName());
                if (rfl.exists()) continue;
                ImageTool.compare(rfl, fl);
            }
        } else {
            DiffDialog dialog = new DiffDialog();
            dialog.setImages(golden.exists() ? ImageIO.read(golden) : null, results.exists() ? ImageIO.read(results) : null);
            dialog.setVisible(true);
            switch (dialog.status) {
                case -2: {
                    System.exit(0);
                }
                case -1: {
                    ImageTool.copy(results, golden);
                    break;
                }
                case 1: {
                    golden.delete();
                }
            }
        }
    }

    private static void usage() {
        System.out.println("java -jar JemmyAWTInput.jar <golden image set> <test result image set>");
    }

    private static void copy(File results, File golden) throws FileNotFoundException, IOException {
        int bytesRead;
        if (golden.exists()) {
            golden.delete();
        }
        FileInputStream from = new FileInputStream(results);
        FileOutputStream to = new FileOutputStream(golden);
        byte[] buffer = new byte[4096];
        while ((bytesRead = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytesRead);
        }
    }
}

