/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.containers;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.binders.SpaceModule;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.containers.SisuContainer;
import org.sonatype.guice.bean.containers.SisuStaticContext;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.inject.BeanScanning;
import org.sonatype.inject.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main
implements Module {
    private final Map<String, String> properties;
    private final String[] args;

    private Main(Map<String, String> properties, String ... args) {
        this.properties = Collections.unmodifiableMap(properties);
        this.args = args;
    }

    public static void main(String ... args) {
        Main.boot(System.getProperties(), args);
    }

    public static <T> T boot(Class<T> type, String ... args) {
        return (T)Main.boot(System.getProperties(), args).getInstance(type);
    }

    public static Injector boot(Properties properties, String ... args) {
        return Main.boot((Map<String, String>)properties, args);
    }

    public static Injector boot(Map<String, String> properties, String ... args) {
        BeanScanning scanning = Main.selectScanning(properties);
        Module app = Main.wire(scanning, new Main(properties, args));
        Injector injector = Guice.createInjector((Module[])new Module[]{app});
        SisuContainer.context(new SisuStaticContext(injector));
        return injector;
    }

    public static Module wire(BeanScanning scanning, Module ... bindings) {
        Module[] modules = new Module[bindings.length + 1];
        System.arraycopy(bindings, 0, modules, 0, bindings.length);
        URLClassSpace space = new URLClassSpace(Thread.currentThread().getContextClassLoader());
        modules[bindings.length] = new SpaceModule(space, scanning);
        return new WireModule(modules);
    }

    public void configure(Binder binder) {
        binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
        binder.bind(ShutdownThread.class).asEagerSingleton();
    }

    @Provides
    @Parameters
    String[] parameters() {
        return (String[])this.args.clone();
    }

    static BeanScanning selectScanning(Map<String, String> properties) {
        String option = properties.get(BeanScanning.class.getName());
        if (null == option || option.length() == 0) {
            return BeanScanning.ON;
        }
        for (BeanScanning value : BeanScanning.values()) {
            if (!value.name().equalsIgnoreCase(option)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown BeanScanning option: " + option);
    }

    static final class ShutdownThread
    extends Thread {
        private final MutableBeanLocator locator;

        @Inject
        ShutdownThread(MutableBeanLocator locator) {
            this.locator = locator;
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void run() {
            this.locator.clear();
        }
    }
}

