/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.artifacts.configuration.TargetPlatformFilterConfigurationReader;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.resolver.TargetPlatformConfigurationException;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.resolver.shared.PlatformPropertiesUtils;
import org.eclipse.tycho.core.shared.BuildFailureException;
import org.eclipse.tycho.core.shared.TargetEnvironment;

@Component(role=DefaultTargetPlatformConfigurationReader.class)
public class DefaultTargetPlatformConfigurationReader {
    public static final String TARGET_DEFINITION_INCLUDE_SOURCE = "targetDefinitionIncludeSource";
    public static final String INCLUDE_PACKED_ARTIFACTS = "includePackedArtifacts";
    public static final String DEPENDENCY_RESOLUTION = "dependency-resolution";
    public static final String OPTIONAL_DEPENDENCIES = "optionalDependencies";
    public static final String FILTERS = "filters";
    public static final String RESOLVE_WITH_EXECUTION_ENVIRONMENT_CONSTRAINTS = "resolveWithExecutionEnvironmentConstraints";
    public static final String BREE_HEADER_SELECTION_POLICY = "breeHeaderSelectionPolicy";
    public static final String EXECUTION_ENVIRONMENT_DEFAULT = "executionEnvironmentDefault";
    public static final String EXECUTION_ENVIRONMENT = "executionEnvironment";
    public static final String ALLOW_CONFLICTING_DEPENDENCIES = "allowConflictingDependencies";
    public static final String POM_DEPENDENCIES = "pomDependencies";
    public static final String TARGET = "target";
    public static final String RESOLVER = "resolver";
    public static final String ENVIRONMENTS = "environments";
    private static final String OPTIONAL_RESOLUTION_REQUIRE = "require";
    private static final String OPTIONAL_RESOLUTION_IGNORE = "ignore";
    private static final String OPTIONAL_RESOLUTION_OPTIONAL = "optional";
    private static final String FILE_EXTENSION = ".target";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private Map<String, TychoProject> projectTypes;
    @Requirement
    private TargetPlatformFilterConfigurationReader filterReader;

    public TargetPlatformConfiguration getTargetPlatformConfiguration(MavenSession session, MavenProject project) throws BuildFailureException {
        TargetEnvironment env;
        TychoProject projectType;
        Xpp3Dom configuration;
        TargetPlatformConfiguration result = new TargetPlatformConfiguration();
        Plugin plugin = project.getPlugin("org.eclipse.tycho:target-platform-configuration");
        if (plugin != null && (configuration = (Xpp3Dom)plugin.getConfiguration()) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("target-platform-configuration for " + project.toString() + ":\n" + configuration.toString());
            }
            this.addTargetEnvironments(result, project, configuration);
            this.setTargetPlatformResolver(result, configuration);
            try {
                this.setTarget(result, session, project, configuration);
            }
            catch (MojoExecutionException e) {
                throw new BuildFailureException("Setting target failed", (Throwable)e);
            }
            this.setPomDependencies(result, configuration);
            this.setAllowConflictingDependencies(result, configuration);
            this.setDisableP2Mirrors(configuration);
            this.setExecutionEnvironment(result, configuration);
            this.setExecutionEnvironmentDefault(result, configuration);
            this.setBREEHeaderSelectionPolicy(result, configuration);
            this.setResolveWithEEContraints(result, configuration);
            this.readFilters(result, configuration);
            this.readDependencyResolutionConfiguration(result, configuration);
            this.setIncludePackedArtifacts(result, configuration);
            this.setTargetDefinitionIncludeSources(result, configuration);
        }
        if (result.getEnvironments().isEmpty() && (projectType = this.projectTypes.get(project.getPackaging())) != null && (env = projectType.getImplicitTargetEnvironment(project)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Implicit target environment for " + project.toString() + ": " + env.toString());
            }
            result.addEnvironment(env);
        }
        if (result.getEnvironments().isEmpty()) {
            this.logger.warn("No explicit target runtime environment configuration. Build is platform dependent.");
            Properties properties = (Properties)DefaultReactorProject.adapt(project).getContextValue(TychoConstants.CTX_MERGED_PROPERTIES);
            String os = PlatformPropertiesUtils.getOS((Properties)properties);
            String ws = PlatformPropertiesUtils.getWS((Properties)properties);
            String arch = PlatformPropertiesUtils.getArch((Properties)properties);
            result.addEnvironment(new TargetEnvironment(os, ws, arch));
            result.setImplicitTargetEnvironment(true);
        } else {
            result.setImplicitTargetEnvironment(false);
        }
        return result;
    }

    private void setIncludePackedArtifacts(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(INCLUDE_PACKED_ARTIFACTS));
        if (value == null) {
            return;
        }
        result.setIncludePackedArtifacts(Boolean.parseBoolean(value));
    }

    private void setTargetDefinitionIncludeSources(TargetPlatformConfiguration result, Xpp3Dom configuration) throws BuildFailureException {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(TARGET_DEFINITION_INCLUDE_SOURCE));
        if (value == null) {
            return;
        }
        try {
            result.setTargetDefinitionIncludeSourceMode(IncludeSourceMode.valueOf((String)value));
        }
        catch (IllegalArgumentException e) {
            throw new BuildFailureException("Illegal value of <targetDefinitionIncludeSource> target platform configuration parameter: " + value, (Throwable)e);
        }
    }

    protected void readDependencyResolutionConfiguration(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        Xpp3Dom resolverDom = configuration.getChild(DEPENDENCY_RESOLUTION);
        if (resolverDom == null) {
            return;
        }
        this.setOptionalDependencies(result, resolverDom);
        this.readExtraRequirements(result, resolverDom);
        this.readProfileProperties(result, resolverDom);
    }

    private void setOptionalDependencies(TargetPlatformConfiguration result, Xpp3Dom resolverDom) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(resolverDom.getChild(OPTIONAL_DEPENDENCIES));
        if (value == null) {
            return;
        }
        if (OPTIONAL_RESOLUTION_REQUIRE.equals(value)) {
            result.setOptionalResolutionAction(OptionalResolutionAction.REQUIRE);
        } else if (OPTIONAL_RESOLUTION_IGNORE.equals(value)) {
            result.setOptionalResolutionAction(OptionalResolutionAction.IGNORE);
        } else if (OPTIONAL_RESOLUTION_OPTIONAL.equals(value)) {
            result.setOptionalResolutionAction(OptionalResolutionAction.OPTIONAL);
        } else {
            throw new BuildFailureException("Illegal value of <optionalDependencies> dependency resolution parameter: " + value);
        }
    }

    protected void readExtraRequirements(TargetPlatformConfiguration result, Xpp3Dom resolverDom) throws BuildFailureException {
        Xpp3Dom requirementsDom = resolverDom.getChild("extraRequirements");
        if (requirementsDom == null) {
            return;
        }
        for (Xpp3Dom requirementDom : requirementsDom.getChildren("requirement")) {
            if (requirementDom.getChild("type") == null) {
                throw new BuildFailureException("Element <type> is missing in <extraRequirements><requirement> section.");
            }
            if (requirementDom.getChild("id") == null) {
                throw new BuildFailureException("Element <id> is missing in <extraRequirements><requirement> section.");
            }
            if (requirementDom.getChild("versionRange") == null) {
                throw new BuildFailureException("Element <versionRange> is missing in <extraRequirements><requirement> section.");
            }
            result.addExtraRequirement((ArtifactKey)new DefaultArtifactKey(requirementDom.getChild("type").getValue(), requirementDom.getChild("id").getValue(), requirementDom.getChild("versionRange").getValue()));
        }
    }

    private void readProfileProperties(TargetPlatformConfiguration result, Xpp3Dom resolverDom) {
        Xpp3Dom[] propertyDomList;
        Xpp3Dom propertiesDom = resolverDom.getChild("profileProperties");
        if (propertiesDom == null) {
            return;
        }
        for (Xpp3Dom propertyDom : propertyDomList = propertiesDom.getChildren()) {
            result.addProfileProperty(propertyDom.getName(), propertyDom.getValue().trim());
        }
    }

    private void setExecutionEnvironment(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(EXECUTION_ENVIRONMENT));
        if (value == null) {
            return;
        }
        result.setExecutionEnvironment(value);
    }

    private void setExecutionEnvironmentDefault(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(EXECUTION_ENVIRONMENT_DEFAULT));
        if (value == null) {
            return;
        }
        result.setExecutionEnvironmentDefault(value);
    }

    private void setBREEHeaderSelectionPolicy(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(BREE_HEADER_SELECTION_POLICY));
        if (value == null) {
            return;
        }
        try {
            result.setBREEHeaderSelectionPolicy(TargetPlatformConfiguration.BREEHeaderSelectionPolicy.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Illegal value of <breeHeaderSelectionPolicy> target platform parameter: " + value);
        }
    }

    private void setResolveWithEEContraints(TargetPlatformConfiguration result, Xpp3Dom resolverDom) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(resolverDom.getChild(RESOLVE_WITH_EXECUTION_ENVIRONMENT_CONSTRAINTS));
        if (value == null) {
            return;
        }
        result.setResolveWithEEContraints(Boolean.valueOf(value));
    }

    private void setDisableP2Mirrors(Xpp3Dom configuration) {
        Xpp3Dom disableP2mirrorsDom = configuration.getChild("disableP2Mirrors");
        if (disableP2mirrorsDom != null) {
            this.logger.warn("Unsupported target-platform-configuration <disableP2Mirrors>. Use tycho.disableP2Mirrors -D command line parameter or settings.xml property.");
        }
    }

    private void setAllowConflictingDependencies(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(ALLOW_CONFLICTING_DEPENDENCIES));
        if (value == null) {
            return;
        }
        result.setAllowConflictingDependencies(Boolean.parseBoolean(value));
    }

    private void addTargetEnvironments(TargetPlatformConfiguration result, MavenProject project, Xpp3Dom configuration) {
        try {
            Xpp3Dom environmentsDom;
            TargetEnvironment deprecatedTargetEnvironmentSpec = this.getDeprecatedTargetEnvironment(configuration);
            if (deprecatedTargetEnvironmentSpec != null) {
                result.addEnvironment(deprecatedTargetEnvironmentSpec);
            }
            if ((environmentsDom = configuration.getChild(ENVIRONMENTS)) != null) {
                if (deprecatedTargetEnvironmentSpec != null) {
                    String message = "Deprecated target-platform-configuration <environment> element must not be combined with new <environments> element; check the (inherited) configuration of " + project.getId();
                    throw new RuntimeException(message);
                }
                for (Xpp3Dom environmentDom : environmentsDom.getChildren("environment")) {
                    result.addEnvironment(DefaultTargetPlatformConfigurationReader.newTargetEnvironment(environmentDom));
                }
            }
        }
        catch (TargetPlatformConfigurationException e) {
            throw new RuntimeException("target-platform-configuration error in project " + project.getId(), e);
        }
    }

    protected TargetEnvironment getDeprecatedTargetEnvironment(Xpp3Dom configuration) throws TargetPlatformConfigurationException {
        Xpp3Dom environmentDom = configuration.getChild("environment");
        if (environmentDom != null) {
            this.logger.warn("target-platform-configuration <environment> element is deprecated; use <environments> instead");
            return DefaultTargetPlatformConfigurationReader.newTargetEnvironment(environmentDom);
        }
        return null;
    }

    private void setPomDependencies(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(POM_DEPENDENCIES));
        if (value == null) {
            return;
        }
        result.setPomDependencies(TargetPlatformConfiguration.PomDependencies.valueOf(value));
    }

    private void setTarget(TargetPlatformConfiguration result, MavenSession session, MavenProject project, Xpp3Dom configuration) throws MojoExecutionException {
        Xpp3Dom[] fileDomArray;
        Xpp3Dom targetDom = configuration.getChild(TARGET);
        if (targetDom == null) {
            return;
        }
        Xpp3Dom[] artifactDomArray = targetDom.getChildren("artifact");
        if (artifactDomArray != null && artifactDomArray.length > 0) {
            for (Xpp3Dom artifactDom : artifactDomArray) {
                this.addTargetArtifact(result, session, project, artifactDom);
            }
        }
        if ((fileDomArray = targetDom.getChildren("file")) != null && fileDomArray.length > 0) {
            Path basedir = Paths.get(project.getBasedir().getAbsolutePath(), new String[0]);
            int n = 0;
            Xpp3Dom[] xpp3DomArray = fileDomArray;
            int n2 = xpp3DomArray.length;
            if (n < n2) {
                Xpp3Dom fileDom = xpp3DomArray[n];
                String file = fileDom.getValue();
                File target = basedir.resolve(file).toFile();
                if (DefaultTargetPlatformConfigurationReader.isTargetFile(target)) {
                    result.addTarget(target);
                    return;
                }
                throw new MojoExecutionException("target definition file '" + target.getAbsolutePath() + "' not found for project '" + project.getName() + "'.");
            }
        }
    }

    protected void addTargetArtifact(TargetPlatformConfiguration result, MavenSession session, MavenProject project, Xpp3Dom artifactDom) throws MojoExecutionException {
        Xpp3Dom groupIdDom = artifactDom.getChild("groupId");
        Xpp3Dom artifactIdDom = artifactDom.getChild("artifactId");
        Xpp3Dom versionDom = artifactDom.getChild("version");
        if (groupIdDom == null || artifactIdDom == null || versionDom == null) {
            throw new BuildFailureException("The target artifact configuration is invalid - <groupId>, <artifactId> and <version> are mandatory");
        }
        Xpp3Dom classifierDom = artifactDom.getChild("classifier");
        String groupId = groupIdDom.getValue();
        String artifactId = artifactIdDom.getValue();
        String version = versionDom.getValue();
        String classifier = classifierDom != null ? classifierDom.getValue() : null;
        for (MavenProject otherProject : session.getProjects()) {
            if (!groupId.equals(otherProject.getGroupId()) || !artifactId.equals(otherProject.getArtifactId()) || !version.equals(otherProject.getVersion())) continue;
            if (classifier == null) {
                File[] targetFiles;
                for (File targetFile : targetFiles = DefaultTargetPlatformConfigurationReader.listTargetFiles(otherProject.getBasedir())) {
                    if (!DefaultTargetPlatformConfigurationReader.isPrimaryTarget(otherProject, targetFile, targetFiles)) continue;
                    result.addTarget(targetFile);
                    return;
                }
                DefaultTargetPlatformConfigurationReader.throwNoPrimaryTargetFound(otherProject, targetFiles);
                continue;
            }
            File target = new File(otherProject.getBasedir(), classifier + FILE_EXTENSION);
            if (DefaultTargetPlatformConfigurationReader.isTargetFile(target)) {
                result.addTarget(target);
                return;
            }
            throw new MojoExecutionException("target definition file '" + target + "' not found in project '" + project.getName() + "'.");
        }
        Artifact artifact = this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, TARGET, classifier);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(session.getLocalRepository());
        request.setRemoteRepositories(project.getRemoteArtifactRepositories());
        this.repositorySystem.resolve(request);
        if (artifact.isResolved()) {
            result.addTarget(artifact.getFile());
            return;
        }
        throw new RuntimeException("Could not resolve target platform specification artifact " + artifact);
    }

    private void setTargetPlatformResolver(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(RESOLVER));
        if (value == null) {
            return;
        }
        result.setResolver(value);
    }

    private void readFilters(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        Xpp3Dom filtersDom = configuration.getChild(FILTERS);
        if (filtersDom != null) {
            result.setFilters(this.filterReader.parseFilterConfiguration(filtersDom));
        }
    }

    private static TargetEnvironment newTargetEnvironment(Xpp3Dom environmentDom) throws TargetPlatformConfigurationException {
        Xpp3Dom osDom = environmentDom.getChild("os");
        if (osDom == null) {
            String message = "<os> element is missing within target-platform-configuration (element <environment>)";
            throw new TargetPlatformConfigurationException(message);
        }
        Xpp3Dom wsDom = environmentDom.getChild("ws");
        if (wsDom == null) {
            String message = "<ws> element is missing within target-platform-configuration (element <environment>)";
            throw new TargetPlatformConfigurationException(message);
        }
        Xpp3Dom archDom = environmentDom.getChild("arch");
        if (archDom == null) {
            String message = "<arch> element is missing within target-platform-configuration (element <environment>)";
            throw new TargetPlatformConfigurationException(message);
        }
        return new TargetEnvironment(osDom.getValue(), wsDom.getValue(), archDom.getValue());
    }

    private static String getStringValue(Xpp3Dom element) {
        if (element == null) {
            return null;
        }
        String value = element.getValue().trim();
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    public static File[] listTargetFiles(File folder) {
        File[] targetFiles;
        if (folder.isDirectory() && (targetFiles = folder.listFiles(DefaultTargetPlatformConfigurationReader::isTargetFile)) != null) {
            return targetFiles;
        }
        return new File[0];
    }

    public static boolean isTargetFile(File file) {
        return file != null && file.isFile() && file.getName().toLowerCase().endsWith(FILE_EXTENSION) && !file.getName().startsWith(".polyglot.");
    }

    public static boolean isPrimaryTarget(MavenProject project, File targetFile, File[] otherTargetFiles) {
        String baseName;
        if (otherTargetFiles != null && otherTargetFiles.length == 1) {
            return DefaultTargetPlatformConfigurationReader.isTargetFile(otherTargetFiles[0]);
        }
        String name = targetFile.getName();
        return name.toLowerCase().endsWith(FILE_EXTENSION) && (baseName = FilenameUtils.getBaseName((String)name)).equalsIgnoreCase(project.getArtifactId());
    }

    public static void throwNoPrimaryTargetFound(MavenProject project, File[] targetFiles) throws MojoExecutionException {
        if (targetFiles == null || targetFiles.length == 0) {
            throw new MojoExecutionException("No target definition file(s) found in project '" + project.getName() + "'.");
        }
        throw new MojoExecutionException("One target file must be named  '" + project.getArtifactId() + ".target' when multiple targets are present");
    }
}

