/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;

public class ArtifactTypeHelper {
    public static IQuery<IInstallableUnit> createQueryFor(String type, String id, VersionRange versionRange) throws IllegalArtifactReferenceException {
        if ("eclipse-plugin".equals(type)) {
            return QueryUtil.createMatchQuery((IExpression)ArtifactTypeHelper.createBundleRequirement(id, versionRange).getMatches(), (Object[])new Object[0]);
        }
        if ("eclipse-feature".equals(type)) {
            return QueryUtil.createPipeQuery((IQuery)QueryUtil.createIUQuery((String)(String.valueOf(id) + ".feature.group"), (VersionRange)versionRange), (IQuery)QueryUtil.createIUGroupQuery());
        }
        if ("eclipse-product".equals(type)) {
            return QueryUtil.createPipeQuery((IQuery)QueryUtil.createIUQuery((String)id, (VersionRange)versionRange), (IQuery)QueryUtil.createIUProductQuery());
        }
        if ("p2-installable-unit".equals(type)) {
            return QueryUtil.createIUQuery((String)id, (VersionRange)versionRange);
        }
        throw new IllegalArtifactReferenceException("Unknown artifact type \"" + type + "\"");
    }

    public static IRequirement createRequirementFor(String type, String id, VersionRange versionRange) throws IllegalArtifactReferenceException {
        if ("eclipse-plugin".equals(type)) {
            return ArtifactTypeHelper.createBundleRequirement(id, versionRange);
        }
        if ("eclipse-feature".equals(type)) {
            return ArtifactTypeHelper.createFeatureRequirement(id, versionRange);
        }
        if ("p2-installable-unit".equals(type)) {
            return ArtifactTypeHelper.createProductRequirement(id, versionRange);
        }
        if ("eclipse-product".equals(type)) {
            return ArtifactTypeHelper.createProductRequirement(id, versionRange);
        }
        throw new IllegalArtifactReferenceException("Unknown artifact type \"" + type + "\"");
    }

    private static IRequirement createBundleRequirement(String id, VersionRange versionRange) {
        return MetadataFactory.createRequirement((String)"osgi.bundle", (String)id, (VersionRange)versionRange, null, (boolean)false, (boolean)true);
    }

    private static IRequirement createFeatureRequirement(String id, VersionRange versionRange) {
        return ArtifactTypeHelper.createIURequirement(String.valueOf(id) + ".feature.group", versionRange);
    }

    private static IRequirement createProductRequirement(String id, VersionRange versionRange) {
        return ArtifactTypeHelper.createIURequirement(id, versionRange);
    }

    private static IRequirement createIURequirement(String id, VersionRange versionRange) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)versionRange, null, (boolean)false, (boolean)true);
    }

    public static ArtifactKey toTychoArtifact(IInstallableUnit unit) {
        if (Boolean.parseBoolean(unit.getProperty("org.eclipse.equinox.p2.type.group"))) {
            String id = unit.getId();
            return new DefaultArtifactKey("eclipse-feature", id.substring(0, id.length() - ".feature.group".length()), unit.getVersion().toString());
        }
        throw new IllegalArgumentException(unit.toString());
    }

    public static IArtifactKey toP2ArtifactKey(ArtifactKey artifact) {
        if ("eclipse-plugin".equals(artifact.getType())) {
            return ArtifactTypeHelper.createP2ArtifactKey("osgi.bundle", artifact);
        }
        if ("eclipse-feature".equals(artifact.getType())) {
            return ArtifactTypeHelper.createP2ArtifactKey("org.eclipse.update.feature", artifact);
        }
        return null;
    }

    private static IArtifactKey createP2ArtifactKey(String type, ArtifactKey artifact) {
        return new org.eclipse.equinox.internal.p2.metadata.ArtifactKey(type, artifact.getId(), Version.parseVersion((String)artifact.getVersion()));
    }
}

