/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.version.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.Manifest;
import org.eclipse.tycho.p2.metadata.ArtifactFacadeProxy;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;

public final class WrappedArtifact
extends ArtifactFacadeProxy {
    private static final String WRAPPED_CLASSIFIER = "wrapped";
    private final File file;
    private final String classifier;
    private String wrappedBsn;
    private String wrappedVersion;
    private Manifest manifest;

    private WrappedArtifact(File file, IArtifactFacade wrapped, String classifier, String wrappedBsn, String wrappedVersion, Manifest manifest) {
        super(wrapped);
        this.file = file;
        this.classifier = classifier;
        this.wrappedBsn = wrappedBsn;
        this.wrappedVersion = wrappedVersion;
        this.manifest = manifest;
    }

    public File getLocation() {
        return this.file;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getPackagingType() {
        return "bundle";
    }

    public String getWrappedBsn() {
        return this.wrappedBsn;
    }

    public String getWrappedVersion() {
        return this.wrappedVersion;
    }

    public String getReferenceHint() {
        return "The artifact can be referenced in feature files with the following data: <plugin id=\"" + this.wrappedBsn + "\" version=\"" + this.wrappedVersion + "\" download-size=\"0\" install-size=\"0\" unpack=\"false\"/>";
    }

    public String getGeneratedManifest() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.manifest.write(bout);
        }
        catch (IOException e) {
            throw new AssertionError("should never happen", e);
        }
        return bout.toString(StandardCharsets.UTF_8);
    }

    public String toString() {
        return "WrappedArtifact [file=" + this.file + ", wrapped=" + super.toString() + ", classifier=" + this.classifier + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.classifier, this.file);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WrappedArtifact other = (WrappedArtifact)((Object)obj);
        return Objects.equals(this.classifier, other.classifier) && Objects.equals(this.file, other.file);
    }

    public static WrappedArtifact createWrappedArtifact(IArtifactFacade mavenArtifact, String prefix, File wrappedFile) throws Exception {
        return WrappedArtifact.createWrappedArtifact(mavenArtifact, WrappedArtifact.createPropertiesForPrefix(prefix), wrappedFile);
    }

    /*
     * Loose catch block
     */
    public static WrappedArtifact createWrappedArtifact(IArtifactFacade mavenArtifact, Properties bndInstructions, File wrappedFile) throws Exception {
        String wrappedClassifier = WRAPPED_CLASSIFIER;
        String classifier = mavenArtifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            wrappedClassifier = String.valueOf(classifier) + "-" + WRAPPED_CLASSIFIER;
        }
        wrappedFile.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var6_7 = null;
        try (Jar jar = new Jar(mavenArtifact.getLocation());){
            WrappedArtifact wrappedArtifact;
            Analyzer analyzer;
            Throwable throwable2;
            block21: {
                Manifest originalManifest = jar.getManifest();
                throwable2 = null;
                Object var10_13 = null;
                analyzer = new Analyzer();
                analyzer.setJar(jar);
                if (originalManifest != null) {
                    analyzer.mergeManifest(originalManifest);
                }
                analyzer.setProperty("mvnGroupId", mavenArtifact.getGroupId());
                analyzer.setProperty("mvnArtifactId", mavenArtifact.getArtifactId());
                analyzer.setProperty("mvnVersion", mavenArtifact.getVersion());
                analyzer.setProperty("mvnClassifier", Objects.requireNonNullElse(mavenArtifact.getClassifier(), ""));
                analyzer.setProperty("generatedOSGiVersion", WrappedArtifact.createOSGiVersionFromArtifact(mavenArtifact).toString());
                analyzer.setProperties(bndInstructions);
                Manifest manifest = analyzer.calcManifest();
                jar.setManifest(manifest);
                jar.write(wrappedFile);
                wrappedArtifact = new WrappedArtifact(wrappedFile, mavenArtifact, wrappedClassifier, manifest.getMainAttributes().getValue("Bundle-SymbolicName"), manifest.getMainAttributes().getValue("Bundle-Version"), manifest);
                if (analyzer == null) break block21;
                analyzer.close();
            }
            return wrappedArtifact;
            {
                catch (Throwable throwable3) {
                    try {
                        if (analyzer != null) {
                            analyzer.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static Properties createPropertiesForPrefix(String prefix) {
        Properties properties = new Properties();
        properties.setProperty("Bundle-Name", "Bundle derived from maven artifact ${mvnGroupId}:${mvnArtifactId}:${mvnVersion}");
        properties.setProperty("Bundle-SymbolicName", String.valueOf(prefix) + ".${mvnGroupId}.${mvnArtifactId}");
        properties.setProperty("version", " ${version_cleanup;${mvnVersion}}");
        properties.setProperty("Bundle-Version", "${version}");
        properties.setProperty("Import-Package", "*;resolution:=optional");
        properties.setProperty("Export-Package", "*;version=\"${version}\";-noimport:=true");
        properties.setProperty("DynamicImport-Package", "*");
        return properties;
    }

    public static String createClassifierFromArtifact(IArtifactFacade mavenArtifact) {
        String classifier = mavenArtifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            return String.valueOf(classifier) + "-" + WRAPPED_CLASSIFIER;
        }
        return WRAPPED_CLASSIFIER;
    }

    public static String createBundleSymbolicNameFromArtifact(String prefix, IArtifactFacade mavenArtifact) {
        String generatedBsn = String.valueOf(prefix) + "." + mavenArtifact.getGroupId() + "." + mavenArtifact.getArtifactId();
        String classifier = mavenArtifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            generatedBsn = String.valueOf(generatedBsn) + "." + classifier;
        }
        return generatedBsn;
    }

    public static Version createOSGiVersionFromArtifact(IArtifactFacade mavenArtifact) {
        String version = mavenArtifact.getVersion();
        try {
            int index = version.indexOf(45);
            if (index > -1) {
                StringBuilder sb = new StringBuilder(version);
                sb.setCharAt(index, '.');
                return Version.parseVersion((String)sb.toString());
            }
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            return new Version(0, 0, 1, version);
        }
    }
}

