/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.io.IOResourceSet;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.Node;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;
import org.openjdk.jmc.flightrecorder.test.util.StacktraceTestToolkit;

public class StacktraceTreeModelTest {
    private static IItemCollection testRecording;
    private static final FrameSeparator separator;

    @BeforeClass
    public static void beforeAll() throws IOException, CouldNotLoadRecordingException {
        IOResourceSet[] testResources = StacktraceTestToolkit.getTestResources();
        IOResourceSet resourceSet = testResources[0];
        testRecording = RecordingToolkit.getFlightRecording(resourceSet);
    }

    @Test
    public void testTreeModelWithAttributeNormalStacks() {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording, separator, false, JdkAttributes.ALLOCATION_SIZE);
        Node root = model.getRoot();
        Assert.assertEquals((long)3L, (long)root.getChildren().size());
        Map<String, List<Double>> leafValues = this.getLeafNodeValues(root);
        Assert.assertEquals((long)leafValues.size(), (long)3L);
        HashMap<String, List<Double>> expected = new HashMap<String, List<Double>>();
        expected.put("Arrays.copyOfRange(char[], int, int)", Arrays.asList(104.0));
        expected.put("TimerThread.mainLoop()", Arrays.asList(112.0));
        expected.put("AbstractCollection.toArray()", Arrays.asList(24.0));
        Assert.assertEquals(expected, leafValues);
    }

    @Test
    public void testTreeModelWithAttributeInvertedStacks() {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording, separator, true, JdkAttributes.ALLOCATION_SIZE);
        Node root = model.getRoot();
        Assert.assertEquals((long)3L, (long)root.getChildren().size());
        Map<String, List<Double>> leafValues = this.getLeafNodeValues(root);
        Assert.assertEquals((long)leafValues.size(), (long)3L);
        HashMap<String, List<Double>> expected = new HashMap<String, List<Double>>();
        expected.put("JFRImpl.onNewChunk()", Arrays.asList(24.0));
        expected.put("TimerThread.run()", Arrays.asList(112.0));
        expected.put("Thread.run()", Arrays.asList(104.0));
        Assert.assertEquals(expected, leafValues);
    }

    @Test
    public void testTreeModelWithoutAttributeNormalStacks() {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording, separator);
        Node root = model.getRoot();
        Assert.assertEquals((long)6L, (long)root.getChildren().size());
        Map<String, List<Double>> leafValues = this.getLeafNodeValues(root);
        HashMap<String, List<Double>> expected = new HashMap<String, List<Double>>();
        expected.put("AbstractCollection.toArray()", Arrays.asList(1.0));
        expected.put("Buffer.checkIndex(int)", Arrays.asList(1.0));
        expected.put("Object.wait(long)", Arrays.asList(10.0, 98.0));
        expected.put("ObjectOutputStream$BlockDataOutputStream.writeUTF(String)", Arrays.asList(1.0));
        expected.put("SocketInputStream.read(byte[], int, int, int)", Arrays.asList(9.0));
        expected.put("Arrays.copyOfRange(char[], int, int)", Arrays.asList(1.0));
        Assert.assertEquals(expected, leafValues);
    }

    @Test
    public void testTreeModelWithoutAttributeInvertedStacks() {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording, separator, true);
        Node root = model.getRoot();
        Assert.assertEquals((long)7L, (long)root.getChildren().size());
        Map<String, List<Double>> leafValues = this.getLeafNodeValues(model.getRoot());
        HashMap<String, List<Double>> expected = new HashMap<String, List<Double>>();
        expected.put("TimerThread.run()", Arrays.asList(1.0, 10.0));
        expected.put("JFRImpl.onNewChunk()", Arrays.asList(1.0));
        expected.put("OGLRenderQueue$QueueFlusher.run()", Arrays.asList(98.0));
        expected.put("InstantEvent.commit()", Arrays.asList(1.0));
        expected.put("Thread.run()", Arrays.asList(1.0, 9.0));
        expected.put("ArrayList.writeObject(ObjectOutputStream)", Arrays.asList(1.0));
        Assert.assertEquals(expected, leafValues);
    }

    private Map<String, List<Double>> getLeafNodeValues(Node root) {
        HashMap<String, List<Double>> leafValues = new HashMap<String, List<Double>>();
        this.pickLeaves(root, leafValues);
        return leafValues;
    }

    private void pickLeaves(Node node, Map<String, List<Double>> accumulator) {
        if (node.isLeaf()) {
            String name = node.getFrame().getHumanReadableShortString();
            accumulator.computeIfAbsent(name, k -> new ArrayList());
            accumulator.get(name).add(node.getWeight());
            accumulator.get(name).sort(Comparator.naturalOrder());
        } else {
            for (Node child : node.getChildren()) {
                this.pickLeaves(child, accumulator);
            }
        }
    }

    static {
        separator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
    }
}

