/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.platform.commons.util.BlacklistedExceptions;

class TimeoutInvocation<T>
implements InvocationInterceptor.Invocation<T> {
    private final InvocationInterceptor.Invocation<T> delegate;
    private final TimeoutDuration timeout;
    private final ScheduledExecutorService executor;
    private final Supplier<String> descriptionSupplier;

    TimeoutInvocation(InvocationInterceptor.Invocation<T> delegate, TimeoutDuration timeout, ScheduledExecutorService executor, Supplier<String> descriptionSupplier) {
        this.delegate = delegate;
        this.timeout = timeout;
        this.executor = executor;
        this.descriptionSupplier = descriptionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T proceed() throws Throwable {
        InterruptTask interruptTask = new InterruptTask(Thread.currentThread());
        ScheduledFuture<?> future = this.executor.schedule(interruptTask, this.timeout.getValue(), this.timeout.getUnit());
        Throwable failure = null;
        Object result = null;
        try {
            result = this.delegate.proceed();
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted(t);
            failure = t;
        }
        finally {
            boolean cancelled = future.cancel(false);
            if (!cancelled) {
                future.get();
            }
            if (interruptTask.executed) {
                Thread.interrupted();
                failure = this.createTimeoutException(failure);
            }
        }
        if (failure != null) {
            throw failure;
        }
        return (T)result;
    }

    private TimeoutException createTimeoutException(Throwable failure) {
        String message = String.format("%s timed out after %s", this.descriptionSupplier.get(), this.timeout);
        TimeoutException timeoutError = new TimeoutException(message);
        if (failure != null) {
            timeoutError.addSuppressed(failure);
        }
        return timeoutError;
    }

    static class InterruptTask
    implements Runnable {
        private final Thread thread;
        private volatile boolean executed;

        InterruptTask(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void run() {
            this.executed = true;
            this.thread.interrupt();
        }
    }
}

