/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.utils;

import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.reficio.p2.utils.BundleUtils;
import org.reficio.p2.utils.Utils;
import org.reficio.p2.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JarUtils {
    static Comparator<File> fileComparator = new Comparator<File>(){

        @Override
        public int compare(File arg0, File arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    };

    public static void adjustSnapshotOutputVersion(File inputFile, File outputFile, String version) {
        Jar jar = null;
        try {
            jar = new Jar(inputFile);
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Bundle-Version", version);
            jar.write(outputFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot open jar " + outputFile, e);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    public static void adjustFeatureXml(File inputFile, File outputFile, File pluginDir, Log log, String timestamp) {
        Jar jar = null;
        File newXml = null;
        try {
            jar = new Jar(inputFile);
            Resource res = jar.getResource("feature.xml");
            Document featureSpec = XmlUtils.parseXml(res.openInputStream());
            JarUtils.adjustFeatureQualifierVersionWithTimestamp(featureSpec, timestamp);
            JarUtils.adjustFeaturePluginData(featureSpec, pluginDir, log);
            File temp = new File(outputFile.getParentFile(), "temp");
            temp.mkdir();
            newXml = new File(temp, "feature.xml");
            XmlUtils.writeXml(featureSpec, newXml);
            FileResource newRes = new FileResource(newXml);
            jar.putResource("feature.xml", (Resource)newRes, true);
            jar.write(outputFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot open jar " + outputFile, e);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
            if (newXml != null) {
                newXml.delete();
            }
        }
    }

    public static void adjustFeatureQualifierVersionWithTimestamp(Document featureSpec, String timestamp) {
        String version = featureSpec.getDocumentElement().getAttributeNode("version").getValue();
        String newVersion = Utils.eclipseQualifierToTimeStamp(version, timestamp);
        featureSpec.getDocumentElement().getAttributeNode("version").setValue(newVersion);
    }

    public static void adjustFeaturePluginData(Document featureSpec, File pluginDir, Log log) throws IOException {
        NodeList plugins = featureSpec.getElementsByTagName("plugin");
        for (int i = 0; i < plugins.getLength(); ++i) {
            Node n = plugins.item(i);
            if (!(n instanceof Element)) continue;
            Element el = (Element)n;
            String pluginId = el.getAttribute("id");
            Object[] files = JarUtils.findFiles(pluginDir, pluginId);
            if (files.length == 0) {
                log.error((CharSequence)("Cannot find plugin " + pluginId));
                continue;
            }
            Arrays.sort((Object[])files, fileComparator);
            Object lastFile = files[files.length - 1];
            String lastVersion = BundleUtils.INSTANCE.getBundleVersion(new Jar((File)lastFile));
            log.info((CharSequence)("Adjusting version for plugin " + pluginId + " to " + lastVersion));
            el.setAttribute("version", lastVersion);
        }
    }

    static File[] findFiles(File pluginDir, final String pluginId) {
        return pluginDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(pluginId) && name.endsWith(".jar");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSignature(File jar) {
        File unsignedJar = new File(jar.getParent(), jar.getName() + ".tmp");
        try {
            if (unsignedJar.exists()) {
                FileUtils.deleteQuietly((File)unsignedJar);
                unsignedJar = new File(jar.getParent(), jar.getName() + ".tmp");
            }
            if (!unsignedJar.createNewFile()) {
                throw new RuntimeException("Cannot create file " + unsignedJar);
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(unsignedJar));
            try {
                ZipFile zip = new ZipFile(jar);
                Enumeration<? extends ZipEntry> list = zip.entries();
                while (list.hasMoreElements()) {
                    ZipEntry entry = list.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || name.endsWith(".RSA") || name.endsWith(".DSA") || name.endsWith(".SF")) continue;
                    InputStream zipInputStream = zip.getInputStream(entry);
                    zipOutputStream.putNextEntry(entry);
                    try {
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                    }
                    finally {
                        zipInputStream.close();
                    }
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                FileUtils.copyFile((File)unsignedJar, (File)jar);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)unsignedJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsSignature(File jarToUnsign) {
        try {
            ZipFile zip = new ZipFile(jarToUnsign);
            try {
                Enumeration<? extends ZipEntry> list = zip.entries();
                while (list.hasMoreElements()) {
                    ZipEntry entry = list.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.endsWith(".RSA") && !name.endsWith(".DSA") && !name.endsWith(".SF")) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                zip.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createJar(File directory, File destJar) throws IOException {
        FileOutputStream fos = new FileOutputStream(destJar);
        Manifest mf = new Manifest();
        JarOutputStream jar = new JarOutputStream((OutputStream)fos, mf);
        JarUtils.addToJar(jar, directory);
        jar.close();
    }

    private static void addToJar(JarOutputStream jar, File content) throws IOException {
        for (File f : FileUtils.listFiles((File)content, null, (boolean)true)) {
            JarEntry entry;
            String fname = f.getPath().replace("\\", "/");
            if (f.isDirectory()) {
                if (!fname.endsWith("/")) {
                    fname = fname + "/";
                }
                entry = new JarEntry(fname);
                entry.setTime(f.lastModified());
                jar.putNextEntry(entry);
                jar.closeEntry();
                continue;
            }
            entry = new JarEntry(fname);
            entry.setTime(f.lastModified());
            jar.putNextEntry(entry);
            jar.write(IOUtils.toByteArray((InputStream)new FileInputStream(f)));
            jar.closeEntry();
        }
    }
}

