/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCollisionHook;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.SystemModule;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.internal.framework.AliasMapper;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.targetplatform.MultiEnvironmentDependencyArtifacts;
import org.eclipse.tycho.core.shared.BuildPropertiesParser;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

@Component(role=EquinoxResolver.class)
public class EquinoxResolver {
    private static final boolean KEEP_USES = Boolean.getBoolean("tycho.equinox.resolver.uses");
    private static final String BATCH_SIZE = System.getProperty("tycho.equinox.resolver.batch.size", KEEP_USES ? null : "1");
    private static final String BATCH_TIMEOUT = System.getProperty("tycho.equinox.resolver.batch.timeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
    private static final int THREAD_COUNT = Integer.getInteger("tycho.equinox.resolver.executor.threads", 1);
    @Requirement
    private BundleReader manifestReader;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;
    @Requirement
    private Logger logger;
    @Requirement
    private ToolchainManager toolchainManager;
    private static final AliasMapper ALIAS_MAPPER = new AliasMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContainer newResolvedState(ReactorProject project, MavenSession mavenSession, ExecutionEnvironment ee, DependencyArtifacts artifacts) throws BundleException {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(THREAD_COUNT);
        try {
            Properties properties = this.getPlatformProperties(project, mavenSession, artifacts, ee);
            ModuleContainer container = this.newState(artifacts, properties, mavenSession, executorService);
            ResolutionReport report = container.resolve(null, false);
            Module module = container.getModule(EquinoxResolver.getNormalizedPath(project.getBasedir()));
            if (module == null) {
                Module systemModule = container.getModule("System Bundle");
                if (project.getBasedir().equals(systemModule.getCurrentRevision().getRevisionInfo())) {
                    module = systemModule;
                }
            }
            ModuleRevision moduleRevision = module.getCurrentRevision();
            if (report.getEntries().isEmpty()) {
                Collection toUninstall = null;
                toUninstall = (moduleRevision.getTypes() & 1) != 0 ? (Collection)moduleRevision.getWiring().getRequiredModuleWires("osgi.wiring.host").stream().map(ModuleWire::getProvider).flatMap(host -> host.getWiring().getProvidedModuleWires("osgi.wiring.host").stream()).map(ModuleWire::getRequirer).filter(Predicate.not(moduleRevision::equals)).filter(fragment -> (fragment.getTypes() & 1) != 0).map(revision -> revision.getRevisions().getModule()).collect(Collectors.toSet()) : (Collection)moduleRevision.getWiring().getProvidedModuleWires("osgi.wiring.host").stream().map(ModuleWire::getRequirer).filter(fragment -> (fragment.getTypes() & 1) != 0).map(revision -> revision.getRevisions().getModule()).collect(Collectors.toSet());
                if (!toUninstall.isEmpty()) {
                    for (Module uninstall : toUninstall) {
                        try {
                            container.uninstall(uninstall);
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                    }
                    report = container.refresh(null);
                }
            }
            this.assertResolved(report, moduleRevision);
            ModuleContainer moduleContainer = container;
            return moduleContainer;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContainer newResolvedState(File basedir, MavenSession mavenSession, ExecutionEnvironment ee, DependencyArtifacts artifacts) throws BundleException {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(THREAD_COUNT);
        try {
            Properties properties = this.getPlatformProperties(new Properties(), mavenSession, null, ee);
            ModuleContainer container = this.newState(artifacts, properties, mavenSession, executorService);
            ResolutionReport report = container.resolve(null, false);
            ModuleRevision bundleDescription = container.getModule(EquinoxResolver.getNormalizedPath(basedir)).getCurrentRevision();
            this.assertResolved(report, bundleDescription);
            ModuleContainer moduleContainer = container;
            return moduleContainer;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected Properties getPlatformProperties(ReactorProject project, MavenSession mavenSession, DependencyArtifacts artifacts, ExecutionEnvironment ee) {
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration(project);
        TargetEnvironment environment = configuration.getEnvironments().get(0);
        if (artifacts instanceof MultiEnvironmentDependencyArtifacts) {
            environment = ((MultiEnvironmentDependencyArtifacts)artifacts).getPlatforms().stream().findFirst().orElse(environment);
        }
        this.logger.debug("Using TargetEnvironment " + environment.toFilterExpression() + " to create resolver properties");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)((Properties)project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES)));
        return this.getPlatformProperties(properties, mavenSession, environment, ee);
    }

    protected Properties getPlatformProperties(Properties properties, MavenSession mavenSession, TargetEnvironment environment, ExecutionEnvironment ee) {
        if (environment != null) {
            properties.put("osgi.os", environment.getOs());
            properties.put("osgi.ws", environment.getWs());
            properties.put("osgi.arch", environment.getArch());
        }
        if (ee != null) {
            ExecutionEnvironmentUtils.applyProfileProperties(properties, ee);
        } else {
            StringJoiner allSystemPackages = new StringJoiner(",");
            StringJoiner allSystemCapabilities = new StringJoiner(",");
            for (String profile : ExecutionEnvironmentUtils.getProfileNames()) {
                String currentSystemCapabilities;
                StandardExecutionEnvironment executionEnvironment = ExecutionEnvironmentUtils.getExecutionEnvironment(profile, this.toolchainManager, mavenSession, this.logger);
                String currentSystemPackages = (String)executionEnvironment.getProfileProperties().get("org.osgi.framework.system.packages");
                if (currentSystemPackages != null && !currentSystemPackages.isEmpty()) {
                    allSystemPackages.add(currentSystemPackages);
                }
                if ((currentSystemCapabilities = (String)executionEnvironment.getProfileProperties().get("org.osgi.framework.system.capabilities")) == null || currentSystemCapabilities.isEmpty()) continue;
                allSystemCapabilities.add(currentSystemCapabilities);
            }
            properties.put("org.osgi.framework.system.packages", allSystemPackages.toString());
            properties.put("org.osgi.framework.system.capabilities", allSystemCapabilities.toString());
        }
        return properties;
    }

    protected ModuleContainer newState(DependencyArtifacts artifacts, Properties properties, MavenSession mavenSession, final ScheduledExecutorService executorService) throws BundleException {
        Object systemBundleInfo;
        Map<String, String> systemBundleManifest;
        ModuleContainer moduleContainer;
        final ModuleContainer[] moduleContainerAccessor = new ModuleContainer[1];
        ModuleContainerAdaptor moduleContainerAdaptor = new ModuleContainerAdaptor(){

            public String getProperty(String key) {
                switch (key) {
                    case "equinox.resolver.revision.batch.size": {
                        return BATCH_SIZE;
                    }
                    case "equinox.resolver.batch.timeout": {
                        return BATCH_TIMEOUT;
                    }
                }
                return super.getProperty(key);
            }

            public void publishModuleEvent(ModuleContainerAdaptor.ModuleEvent type, Module module, Module origin) {
            }

            public void publishContainerEvent(ModuleContainerAdaptor.ContainerEvent type, Module module, Throwable error, FrameworkListener ... listeners) {
            }

            public ResolverHookFactory getResolverHookFactory() {
                return triggers -> new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                    }

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                    }

                    public void end() {
                    }
                };
            }

            public ModuleCollisionHook getModuleCollisionHook() {
                return (operationType, target, collisionCandidates) -> {};
            }

            public SystemModule createSystemModule() {
                return new SystemModule(moduleContainerAccessor[0]){

                    public Bundle getBundle() {
                        return null;
                    }

                    protected void cleanup(ModuleRevision revision) {
                    }
                };
            }

            public Module createModule(String location, long id, EnumSet<Module.Settings> settings, int startlevel) {
                return new Module(id, location, moduleContainerAccessor[0], settings, startlevel){

                    public Bundle getBundle() {
                        return null;
                    }

                    protected void cleanup(ModuleRevision revision) {
                    }
                };
            }

            public ScheduledExecutorService getScheduledExecutor() {
                return executorService;
            }
        };
        ModuleDatabase moduleDatabase = new ModuleDatabase(moduleContainerAdaptor);
        moduleContainerAccessor[0] = moduleContainer = new ModuleContainer(moduleContainerAdaptor, moduleDatabase);
        LinkedHashMap<File, OsgiManifest> systemBundles = new LinkedHashMap<File, OsgiManifest>();
        LinkedHashMap<File, OsgiManifest> externalBundles = new LinkedHashMap<File, OsgiManifest>();
        LinkedHashMap<File, OsgiManifest> projects = new LinkedHashMap<File, OsgiManifest>();
        List list = artifacts.getArtifacts("eclipse-plugin");
        for (ArtifactDescriptor artifact : list) {
            File location = artifact.getLocation(true);
            OsgiManifest mf = this.loadManifest(location);
            if (this.isFrameworkImplementation(mf)) {
                systemBundles.put(location, mf);
                continue;
            }
            ReactorProject mavenProject = artifact.getMavenProject();
            if (mavenProject != null) {
                Collection additionalBundles = this.buildPropertiesParser.parse(mavenProject.getBasedir()).getAdditionalBundles();
                if (additionalBundles.size() > 0) {
                    ArrayList<String> reqb = new ArrayList<String>();
                    String value = mf.getValue("Require-Bundle");
                    if (value != null) {
                        reqb.add(value);
                    }
                    reqb.addAll(additionalBundles.stream().map(b -> b + ";resolution:=optional").collect(Collectors.toList()));
                    mf.getHeaders().put("Require-Bundle", String.join((CharSequence)",", reqb));
                }
                projects.put(location, mf);
                continue;
            }
            externalBundles.put(location, mf);
        }
        String systemExtraCapabilities = EquinoxResolver.getSystemExtraCapabilities(properties);
        if (!systemBundles.isEmpty()) {
            Map.Entry systemBundle = systemBundles.entrySet().iterator().next();
            systemBundleManifest = ((OsgiManifest)systemBundle.getValue()).getHeaders();
            systemBundleInfo = systemBundle.getKey();
        } else {
            systemBundleManifest = Map.of("Bundle-SymbolicName", "system.bundle");
            systemBundleInfo = null;
        }
        ModuleRevisionBuilder systemBundleRevisionBuilder = OSGiManifestBuilderFactory.createBuilder(systemBundleManifest, (String)"system.bundle", (String)properties.getProperty("org.osgi.framework.system.packages"), (String)systemExtraCapabilities);
        EquinoxResolver.install(moduleContainer, null, "System Bundle", systemBundleRevisionBuilder, systemBundleInfo);
        for (Map.Entry external : externalBundles.entrySet()) {
            EquinoxResolver.install(moduleContainer, null, ((File)external.getKey()).getAbsolutePath(), OSGiManifestBuilderFactory.createBuilder(((OsgiManifest)external.getValue()).getHeaders()), external.getKey());
        }
        for (Map.Entry entry : projects.entrySet()) {
            Map<String, String> headers = ((OsgiManifest)entry.getValue()).getHeaders();
            ModuleRevisionBuilder builder = OSGiManifestBuilderFactory.createBuilder(headers);
            EquinoxResolver.install(moduleContainer, null, ((File)entry.getKey()).getAbsolutePath(), builder, entry.getKey());
        }
        return moduleContainer;
    }

    private static Module install(ModuleContainer moduleContainer, Module origin, String location, ModuleRevisionBuilder builder, Object revisionInfo) throws BundleException {
        if (!KEEP_USES) {
            List capabilities = builder.getCapabilities();
            for (ModuleRevisionBuilder.GenericInfo genericInfo : capabilities) {
                genericInfo.getDirectives().remove("uses");
            }
        }
        return moduleContainer.install(origin, location, builder, revisionInfo);
    }

    private boolean isFrameworkImplementation(OsgiManifest mf) {
        String value = mf.getHeaders().get("Export-Package");
        if (value != null) {
            try {
                ManifestElement[] exports;
                for (ManifestElement export : exports = ManifestElement.parseHeader((String)"Export-Package", (String)value)) {
                    if (!"org.osgi.framework".equals(export.getValue())) continue;
                    return true;
                }
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return false;
    }

    private static String getNormalizedPath(File file) {
        return file.getAbsolutePath();
    }

    private static String getSystemExtraCapabilities(Properties equinoxConfig) {
        StringBuilder result = new StringBuilder();
        String systemCapabilities = equinoxConfig.getProperty("org.osgi.framework.system.capabilities");
        if (systemCapabilities != null && systemCapabilities.trim().length() > 0) {
            result.append(systemCapabilities).append(", ");
        }
        String os = equinoxConfig.getProperty("osgi.os");
        String ws = equinoxConfig.getProperty("osgi.ws");
        String osArch = equinoxConfig.getProperty("osgi.arch");
        String nl = equinoxConfig.getProperty("osgi.nl");
        result.append("eclipse.platform").append("; ");
        result.append("osgi.os").append("=").append(os).append("; ");
        result.append("osgi.ws").append("=").append(ws).append("; ");
        result.append("osgi.arch").append("=").append(osArch).append("; ");
        result.append("osgi.nl").append("=").append(nl);
        String osName = os == null ? null : ALIAS_MAPPER.getCanonicalOSName(os);
        String processor = osArch == null ? null : ALIAS_MAPPER.getCanonicalProcessor(osArch);
        result.append(", ").append("osgi.native");
        if (osName != null) {
            String osNames = EquinoxResolver.getStringList(ALIAS_MAPPER.getOSNameAliases(osName));
            result.append("; ").append("osgi.native.osname").append(osNames);
        }
        if (processor != null) {
            String processors = EquinoxResolver.getStringList(ALIAS_MAPPER.getProcessorAliases(processor));
            result.append("; ").append("osgi.native.processor").append(processors);
        }
        return result.toString();
    }

    private static String getStringList(Collection<String> elements) {
        return ":List<String>=\"" + String.join((CharSequence)",", elements) + "\"";
    }

    private OsgiManifest loadManifest(File bundleLocation) {
        if (bundleLocation == null || !bundleLocation.exists()) {
            throw new IllegalArgumentException("bundleLocation not found: " + bundleLocation);
        }
        return this.manifestReader.loadManifest(bundleLocation);
    }

    public void assertResolved(ResolutionReport report, ModuleRevision desc) throws BundleException {
        if (desc.getRevisions().getModule().getState() == Module.State.RESOLVED || report == null || report.getEntries() == null || report.getEntries().isEmpty()) {
            return;
        }
        List errors = (List)report.getEntries().get(desc);
        if (errors != null && !errors.isEmpty()) {
            throw new BundleException("Bundle " + desc.getSymbolicName() + " cannot be resolved:" + report.getResolutionReportMessage((Resource)desc));
        }
    }
}

