/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.version;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.version.JavaVersion;

public class JavaVersionTest {
    @Test
    public void testJava9NewShortGEQJava9OldVersion() {
        JavaVersion ver1 = new JavaVersion("9");
        JavaVersion ver2 = new JavaVersion("1.9.foo");
        Assert.assertTrue((boolean)ver1.isGreaterOrEqualThan(ver2));
    }

    @Test
    public void testJava9NewShortEQJava9NewLongSameVersion() {
        JavaVersion version9 = new JavaVersion("9-ea");
        JavaVersion version9000 = new JavaVersion("9.0.0.0-ea");
        Assert.assertTrue((boolean)version9000.equals((Object)version9));
    }

    @Test
    public void testJava9NewShortWithExtraEQJava9NewLongSameVersion() {
        JavaVersion version190 = new JavaVersion("9-ea+19-BR-435345");
        JavaVersion version900 = new JavaVersion("9.0.0.0-ea");
        Assert.assertTrue((boolean)version900.equals((Object)version190));
    }

    @Test
    public void testJava9NewWithExtraGEQJava9OldVersion() {
        JavaVersion version913 = new JavaVersion("9.1.3.0");
        JavaVersion version190 = new JavaVersion("1.9.0-ea+19-BR-435345");
        Assert.assertTrue((boolean)version913.isGreaterOrEqualThan(version190));
    }

    @Test
    public void testJava9OldVersionGEQJava9NewWithExtra() {
        JavaVersion version913 = new JavaVersion("9.1.3.0");
        JavaVersion version192 = new JavaVersion("1.9.2-ea+19-BR-435345");
        Assert.assertTrue((boolean)version192.isGreaterOrEqualThan(version913));
    }

    @Test
    public void testJava9LongVersionisGreaterOrEqualsJava9ShortVersion() {
        JavaVersion version9 = new JavaVersion("9");
        JavaVersion version921 = new JavaVersion("9.2.1.0");
        Assert.assertTrue((boolean)version921.isGreaterOrEqualThan(version9));
    }

    @Test
    public void testJava9isGreaterOrEqualsVersion() {
        JavaVersion version913 = new JavaVersion("9.1.3.0-ea");
        JavaVersion version921 = new JavaVersion("9.2.1.0");
        Assert.assertTrue((boolean)version921.isGreaterOrEqualThan(version913));
    }

    @Test
    public void testJava9isGreaterOrEqualsVersionEA() {
        JavaVersion version921ea = new JavaVersion("9.2.1.0-ea");
        JavaVersion version921 = new JavaVersion("9.2.1.0");
        Assert.assertTrue((boolean)version921.isGreaterOrEqualThan(version921ea));
        Assert.assertTrue((!version921ea.isGreaterOrEqualThan(version921) ? 1 : 0) != 0);
    }

    @Test
    public void testGreaterOrEqualsMediumVsLongVersion() {
        JavaVersion version123 = new JavaVersion("1.2.3");
        JavaVersion version12245 = new JavaVersion("1.2.2.4.5");
        Assert.assertTrue((boolean)version123.isGreaterOrEqualThan(version12245));
    }

    @Test
    public void testGreaterOrEqualsLongVsMediumVersion() {
        JavaVersion version12345 = new JavaVersion("1.2.3.4.5");
        JavaVersion version12 = new JavaVersion("1.2");
        Assert.assertTrue((boolean)version12345.isGreaterOrEqualThan(version12));
    }

    @Test
    public void testJava9isGreaterOrEqualsThanJava8Version() {
        JavaVersion version903 = new JavaVersion("9.0.3.0-ea");
        JavaVersion version8u40 = new JavaVersion("1.8.0_40");
        Assert.assertTrue((boolean)version903.isGreaterOrEqualThan(version8u40));
    }

    @Test
    public void testGEQ() {
        JavaVersion version16 = new JavaVersion("1.6.0_14ea");
        JavaVersion version17 = new JavaVersion("1.7.0_0");
        Assert.assertTrue((boolean)version17.isGreaterOrEqualThan(version16));
        Assert.assertFalse((boolean)version16.isGreaterOrEqualThan(version17));
        Assert.assertTrue((boolean)version16.isGreaterOrEqualThan(version16));
        Assert.assertTrue((boolean)version17.equals((Object)version17));
    }

    @Test
    public void testGEQJava7EA() {
        JavaVersion version17ea = new JavaVersion("1.7.0_0ea");
        JavaVersion version17 = new JavaVersion("1.7.0_0");
        Assert.assertTrue((boolean)version17.isGreaterOrEqualThan(version17ea));
        Assert.assertFalse((boolean)version17ea.isGreaterOrEqualThan(version17));
    }

    @Test
    public void testGEQWithMicro() {
        JavaVersion version142 = new JavaVersion("1.4.2_14");
        JavaVersion version131 = new JavaVersion("1.3.1_67");
        Assert.assertTrue((boolean)version142.isGreaterOrEqualThan(version131));
        Assert.assertFalse((boolean)version131.isGreaterOrEqualThan(version142));
        Assert.assertTrue((boolean)version131.isGreaterOrEqualThan(version131));
        Assert.assertTrue((boolean)version142.equals((Object)version142));
    }

    @Test
    public void testGEQCropped() {
        JavaVersion version17 = new JavaVersion("1.7");
        JavaVersion version17u12 = new JavaVersion("1.7.0_12");
        Assert.assertTrue((boolean)version17u12.isGreaterOrEqualThan(version17));
        Assert.assertFalse((boolean)version17u12.equals((Object)version17));
    }

    @Test
    public void testIsReverseNumbers() {
        JavaVersion version17u13 = new JavaVersion("1.7.12_13ea");
        JavaVersion version17u31 = new JavaVersion("1.7.12_31");
        Assert.assertTrue((boolean)version17u31.isGreaterOrEqualThan(version17u13));
        Assert.assertFalse((boolean)version17u31.equals((Object)version17u13));
    }

    @Test
    public void testOldVersionShortAndLongEquals() {
        JavaVersion version17u0 = new JavaVersion("1.7.0_0");
        JavaVersion version17 = new JavaVersion("1.7");
        Assert.assertTrue((boolean)version17u0.equals((Object)version17));
    }

    @Test
    public void testNullStringArgument() {
        JavaVersion nullVersion = new JavaVersion((String)null);
        Assert.assertEquals((long)-1L, (long)nullVersion.getMajorVersion());
    }
}

