/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.item;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.mock.item.MockAttributes;
import org.openjdk.jmc.common.test.mock.item.MockCollections;
import org.openjdk.jmc.common.unit.IQuantity;

public class StreamTest {
    @Test
    public void testIItemIterableStream() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(99, 100.0));
        List iterables = mockDoubleCollection.stream().collect(Collectors.toList());
        List ids = mockDoubleCollection.stream().map(iterable -> iterable.getType().getIdentifier()).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)iterables.size());
        Assert.assertEquals((Object)"mock/MockNumberItem", ids.get(0));
    }

    @Test
    public void testIItemStream() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(999, 100.0));
        List items = mockDoubleCollection.stream().flatMap(iterable -> iterable.stream()).collect(Collectors.toList());
        Assert.assertEquals((long)999L, (long)items.size());
    }

    @Test
    public void testValues() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(99, 100.0));
        List<IQuantity> values = ((Stream)mockDoubleCollection.values(MockAttributes.DOUBLE_VALUE).get()).collect(Collectors.toList());
        Assert.assertEquals((long)99L, (long)values.size());
        values.forEach(value -> Assert.assertTrue((value.doubleValue() >= 0.0 && value.doubleValue() <= 100.0 ? 1 : 0) != 0));
    }
}

