/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.lookup;

import org.jemmy.Rectangle;
import org.jemmy.control.Wrap;
import org.jemmy.control.Wrapper;
import org.jemmy.image.Image;
import org.jemmy.lookup.LookupCriteria;

public class ImageLookup<T>
implements LookupCriteria<T> {
    private Wrapper wrapper;
    private Image image;
    private Class<T> type;
    private Rectangle subArea;
    private Image lastDiff = null;
    private Image lastImage = null;

    public ImageLookup(Wrapper wrapper, Class<T> type, Image image, Rectangle subArea) {
        this.wrapper = wrapper;
        this.type = type;
        this.image = image;
        this.subArea = subArea;
    }

    public ImageLookup(Wrapper wrapper, Class<T> type, Image image) {
        this(wrapper, type, image, null);
    }

    @Override
    public boolean check(T control) {
        Wrap<T> wrap = this.wrapper.wrap(this.type, control);
        this.lastImage = this.subArea == null ? wrap.getScreenImage() : wrap.getScreenImage(this.subArea);
        this.lastDiff = this.image.compareTo(this.lastImage);
        return this.lastDiff == null;
    }

    public Image getLastDiff() {
        return this.lastDiff;
    }

    public Image getLastImage() {
        return this.lastImage;
    }
}

