/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import org.jemmy.Dimension;
import org.jemmy.image.pixel.PixelImageComparator;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.ThresholdComparator;

public class AverageDistanceComparator
extends ThresholdComparator {
    public static final Raster.Component[] DISTANCE_COMPONENTS = new Raster.Component[]{Raster.Component.RED, Raster.Component.BLUE, Raster.Component.GREEN};

    public AverageDistanceComparator(double threshold) {
        super(0.0, Math.sqrt(3.0));
        this.setThreshold(threshold);
    }

    @Override
    public boolean compare(Raster image1, Raster image2) {
        Dimension size = PixelImageComparator.computeDiffSize(image1, image2);
        if (size == null) {
            return false;
        }
        int totalPixels = size.width * size.height;
        double distance = 0.0;
        double[] colors1 = new double[image1.getSupported().length];
        double[] colors2 = new double[image2.getSupported().length];
        for (int x = 0; x < size.width; ++x) {
            for (int y = 0; y < size.height; ++y) {
                image1.getColors(x, y, colors1);
                image2.getColors(x, y, colors2);
                distance += AverageDistanceComparator.distance(image1.getSupported(), colors1, image2.getSupported(), colors2) / (double)totalPixels;
            }
        }
        return distance < this.getThreshold();
    }

    static double distance(Raster.Component[] comps1, double[] colors1, Raster.Component[] comps2, double[] colors2) {
        double res = 0.0;
        for (Raster.Component c : DISTANCE_COMPONENTS) {
            double diff = colors2[PixelImageComparator.arrayIndexOf(comps2, c)] - colors1[PixelImageComparator.arrayIndexOf(comps1, c)];
            res += diff * diff;
        }
        return Math.sqrt(res);
    }

    @Override
    public String getID() {
        return AverageDistanceComparator.class.getName() + ":" + this.getThreshold();
    }
}

