/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.env;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TestOut {
    private InputStream input;
    private PrintWriter output;
    private PrintWriter errput;
    private BufferedReader buffInput;
    private boolean autoFlushMode = true;

    public TestOut(InputStream in, PrintStream out, PrintStream err) {
        this(in, out, err, null);
    }

    public TestOut(InputStream in, PrintStream out, PrintStream err, PrintStream golden) {
        PrintWriter tout = null;
        if (out != null) {
            tout = new PrintWriter(out);
        }
        PrintWriter terr = null;
        if (err != null) {
            terr = new PrintWriter(err);
        }
        this.initStreams(in, tout, terr);
    }

    public TestOut(InputStream in, PrintWriter out, PrintWriter err) {
        this.initStreams(in, out, err);
        this.autoFlushMode = true;
    }

    public TestOut() {
        this(System.in, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static TestOut getNullOutput() {
        return new TestOut((InputStream)null, (PrintWriter)null, (PrintWriter)null);
    }

    public boolean setAutoFlushMode(boolean autoFlushMode) {
        boolean oldValue = this.getAutoFlushMode();
        this.autoFlushMode = autoFlushMode;
        return oldValue;
    }

    public boolean getAutoFlushMode() {
        return this.autoFlushMode;
    }

    public int read() throws IOException {
        if (this.input != null) {
            return this.input.read();
        }
        return -1;
    }

    public String readln() throws IOException {
        if (this.buffInput != null) {
            return this.buffInput.readLine();
        }
        return null;
    }

    public void print(String line) {
        if (this.output != null) {
            this.output.print(line);
        }
    }

    public void println(String line) {
        if (this.output != null) {
            this.output.println(line);
            if (this.autoFlushMode) {
                this.output.flush();
            }
        }
    }

    public void printerrln(String line) {
        if (this.errput != null) {
            this.errput.println(line);
            if (this.autoFlushMode) {
                this.errput.flush();
            }
        }
    }

    public void println(boolean toOut, String line) {
        if (toOut) {
            this.println(line);
        } else {
            this.printerrln(line);
        }
    }

    public void printerr(String text) {
        this.printerrln("Error:");
        this.printerrln(text);
    }

    public void printStackTrace(Throwable e) {
        if (this.errput != null) {
            e.printStackTrace(this.errput);
            if (this.autoFlushMode) {
                this.errput.flush();
            }
        }
    }

    public InputStream getInput() {
        return this.input;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public PrintWriter getErrput() {
        return this.errput;
    }

    public TestOut createErrorOutput() {
        return new TestOut(null, null, this.getErrput());
    }

    public void flush() {
        if (this.output != null) {
            this.output.flush();
        }
        if (this.errput != null) {
            this.errput.flush();
        }
    }

    private void initStreams(InputStream in, PrintWriter out, PrintWriter err) {
        this.input = in;
        this.output = out;
        this.errput = err;
        this.buffInput = this.input != null ? new BufferedReader(new InputStreamReader(in)) : null;
    }
}

