/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.json;

import java.io.Writer;
import org.openjdk.jmc.flightrecorder.serializers.json.StructuredWriter;

abstract class JsonWriter
extends StructuredWriter {
    JsonWriter(Writer p) {
        super(p);
    }

    protected void writeField(boolean first, String fieldName, Object value) {
        this.nextField(first, fieldName);
        if (!this.writeIfNull(value)) {
            if (value instanceof Boolean) {
                this.writeAsString(value);
                return;
            }
            if (value instanceof Double) {
                double dValue = (Double)value;
                if (Double.isNaN(dValue) || Double.isInfinite(dValue)) {
                    this.writeNull();
                    return;
                }
                this.writeAsString(value);
                return;
            }
            if (value instanceof Float) {
                float fValue = ((Float)value).floatValue();
                if (Float.isNaN(fValue) || Float.isInfinite(fValue)) {
                    this.writeNull();
                    return;
                }
                this.writeAsString(value);
                return;
            }
            if (value instanceof Number) {
                this.write(this.stringify("", value, false));
                return;
            }
            this.writeStringValue(this.stringify(value));
        }
    }

    protected void nextElement(boolean first) {
        if (!first) {
            this.write(", ");
        }
    }

    protected void nextField(boolean first, String fieldName) {
        if (!first) {
            this.writeln(", ");
        }
        this.writeFieldName(fieldName);
    }

    protected boolean writeIfNull(Object value) {
        if (value == null) {
            this.writeNull();
            return true;
        }
        return false;
    }

    protected void writeNull() {
        this.write("null");
    }

    protected void writeObjectBegin() {
        this.writeln("{");
        this.indent();
    }

    protected void writeObjectEnd() {
        this.retract();
        this.writeln();
        this.writeIndent();
        this.write("}");
    }

    protected void writeArrayEnd() {
        this.write("]");
    }

    protected void writeArrayBegin() {
        this.write("[");
    }

    protected void writeStringValue(String value) {
        this.write("\"");
        this.writeEscaped(value);
        this.write("\"");
    }

    private void writeFieldName(String text) {
        this.writeIndent();
        this.write("\"");
        this.write(text);
        this.write("\": ");
    }

    private void writeEscaped(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.writeEscaped(text.charAt(i));
        }
    }

    private void writeEscaped(char c) {
        if (c == '\b') {
            this.write("\\b");
            return;
        }
        if (c == '\n') {
            this.write("\\n");
            return;
        }
        if (c == '\t') {
            this.write("\\t");
            return;
        }
        if (c == '\f') {
            this.write("\\f");
            return;
        }
        if (c == '\r') {
            this.write("\\r");
            return;
        }
        if (c == '\"') {
            this.write("\\\"");
            return;
        }
        if (c == '\\') {
            this.write("\\\\");
            return;
        }
        if (c > '\u007f' || c < ' ') {
            this.write("\\u");
            this.write(Integer.toHexString(65536 + c).substring(1));
            return;
        }
        this.write(c);
    }
}

