/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.flightrecorder.serializers.json.JsonWriter;

public class IItemCollectionJsonSerializer
extends JsonWriter {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.flightrecorder.json");

    public static String toJsonString(IItemCollection items) {
        StringWriter sw = new StringWriter();
        IItemCollectionJsonSerializer marshaller = new IItemCollectionJsonSerializer(sw);
        try {
            marshaller.writeRecording(items);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to serialize recording to JSON", e);
        }
        return sw.getBuffer().toString();
    }

    public static String toJsonString(Iterable<IItem> items) {
        StringWriter sw = new StringWriter();
        IItemCollectionJsonSerializer marshaller = new IItemCollectionJsonSerializer(sw);
        try {
            marshaller.writeEvents(items);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to serialize items to JSON", e);
        }
        return sw.getBuffer().toString();
    }

    private IItemCollectionJsonSerializer(Writer w) {
        super(w);
    }

    private void writeRecording(IItemCollection recording) throws IOException {
        this.writeObjectBegin();
        this.nextField(true, "events");
        this.writeArrayBegin();
        int count = 0;
        for (IItemIterable events : recording) {
            for (IItem event : events) {
                this.nextElement(count == 0);
                this.writeEvent(event);
                ++count;
            }
        }
        this.writeArrayEnd();
        this.writeObjectEnd();
        this.flush();
    }

    void writeEvents(Iterable<IItem> events) throws IOException {
        this.writeObjectBegin();
        this.nextField(true, "events");
        this.writeArrayBegin();
        int count = 0;
        for (IItem event : events) {
            this.nextElement(count == 0);
            this.writeEvent(event);
            ++count;
        }
        this.writeArrayEnd();
        this.writeObjectEnd();
        this.flush();
    }

    private void writeEvent(IItem event) {
        this.writeObjectBegin();
        IType type = event.getType();
        this.writeField(true, "eventType", type.getIdentifier());
        this.nextField(false, "attributes");
        this.writeObjectBegin();
        this.writeEventAttributes(event);
        this.writeObjectEnd();
        this.writeObjectEnd();
    }

    private void writeStackTrace(boolean first, IMCStackTrace trace) {
        this.nextField(first, "stackTrace");
        this.writeObjectBegin();
        this.nextField(true, "frames");
        this.writeArrayBegin();
        boolean firstFrame = true;
        for (IMCFrame frame : trace.getFrames()) {
            this.nextElement(firstFrame);
            this.writeFrame(frame);
            firstFrame = false;
        }
        this.writeArrayEnd();
        this.writeObjectEnd();
    }

    private void writeFrame(IMCFrame frame) {
        Integer lineNumber = frame.getFrameLineNumber();
        IMCMethod method = frame.getMethod();
        this.writeObjectBegin();
        this.writeField(true, "name", method != null ? this.stringifyMethod(method) : null);
        this.writeField(false, "line", lineNumber);
        this.writeField(false, "type", frame.getType());
        this.writeObjectEnd();
    }

    private void writeEventAttributes(IItem event) {
        IType itemType = ItemToolkit.getItemType((IItem)event);
        boolean first = true;
        for (Map.Entry e : itemType.getAccessorKeys().entrySet()) {
            IMemberAccessor accessor = itemType.getAccessor((IAccessorKey)e.getKey());
            IAccessorKey attribute = (IAccessorKey)e.getKey();
            Object value = accessor.getMember((Object)event);
            if (value instanceof IMCStackTrace) {
                this.writeStackTrace(first, (IMCStackTrace)value);
            } else {
                this.writeField(first, attribute.getIdentifier(), value);
            }
            first = false;
        }
    }
}

