/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.util.Objects;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;

public class ClassifiedArtifactKey {
    public final ArtifactKey artifactKey;
    public final String classifier;

    public ClassifiedArtifactKey(ArtifactKey key, String classifier) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.artifactKey = key;
        this.classifier = classifier;
    }

    public ClassifiedArtifactKey(IArtifactFacade artifact) {
        this((ArtifactKey)new DefaultArtifactKey(artifact.getPackagingType(), artifact.getArtifactId(), artifact.getVersion()), artifact.getClassifier());
    }

    public int hashCode() {
        return Objects.hash(this.artifactKey, this.classifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassifiedArtifactKey)) {
            return false;
        }
        ClassifiedArtifactKey other = (ClassifiedArtifactKey)obj;
        return Objects.equals(this.artifactKey, other.artifactKey) && Objects.equals(this.classifier, other.classifier);
    }
}

