/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.util;

import java.util.regex.Pattern;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.repository.util.LoggingProgressMonitor;

public final class DuplicateFilteringLoggingProgressMonitor
extends LoggingProgressMonitor {
    private final Pattern PROGRESS_WITH_UNKNOWN_SPEED = Pattern.compile("\\(.* at 0B/s\\)");
    private static final String NON_MATCHING_LINE = "";
    private String lastLoggedFile = "";
    private boolean lastLoggedFileFiltered = false;

    public DuplicateFilteringLoggingProgressMonitor(MavenLogger logger) {
        super(logger);
    }

    @Override
    protected boolean suppressOutputOf(String text) {
        if (text.equals("1 operation remaining.")) {
            return true;
        }
        boolean isUnneededLine = this.checkIfDuplicateOfLastOutput(text);
        return isUnneededLine;
    }

    private boolean checkIfDuplicateOfLastOutput(String message) {
        int startOfByteProgress = message.indexOf(40);
        if (startOfByteProgress > 0) {
            if (startOfByteProgress == this.lastLoggedFile.length() && message.startsWith(this.lastLoggedFile)) {
                if (!this.lastLoggedFileFiltered && this.PROGRESS_WITH_UNKNOWN_SPEED.matcher(message.substring(startOfByteProgress)).matches()) {
                    this.lastLoggedFileFiltered = true;
                    return true;
                }
            } else {
                this.lastLoggedFile = message.substring(0, startOfByteProgress);
                this.lastLoggedFileFiltered = false;
            }
        } else {
            this.lastLoggedFile = NON_MATCHING_LINE;
            this.lastLoggedFileFiltered = false;
        }
        return false;
    }
}

