/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class VMOperationRule
implements IRule {
    private static final String RESULT_ID = "VMOperations";
    private static final double MAX_SECONDS_BETWEEN_EVENTS = 0.01;
    public static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("vm.vmoperation.warning.limit", Messages.getString("VMOperationRule_CONFIG_WARNING_LIMIT"), Messages.getString("VMOperationRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(2000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ExecuteVMOperation", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IQuantity> LONGEST_OPERATION_DURATION = new TypedResult("longestOperationDuration", "Longest Operation Duration", "The duration of the longest running VM operation.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<String> LONGEST_OPERATION = new TypedResult("longestOperation", "Longest Operation", "The type of vm operation that took longest to complete.", UnitLookup.PLAIN_TEXT, String.class);
    public static final TypedResult<IMCThread> LONGEST_OPERATION_CALLER = new TypedResult("longestOperationCaller", "Longest Operation Caller", "The thread that initiated the vm operation took the longest to complete.", UnitLookup.THREAD, IMCThread.class);
    public static final TypedResult<IQuantity> LONGEST_OPERATION_START_TIME = new TypedResult("longestOperationStartTime", "Longest Operation Start", "The time the vm operation that took the longest to complete was started.", (ContentType)UnitLookup.TIMESTAMP, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_OPERATION_DURATION, LONGEST_OPERATION, LONGEST_OPERATION_CALLER, LONGEST_OPERATION_START_TIME);

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider vp, final IResultValueProvider rp) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return VMOperationRule.this.evaluate(items, vp, rp);
            }
        });
        return evaluationTask;
    }

    private IResult evaluate(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        boolean isCombinedDuration;
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(WARNING_LIMIT);
        IQuantity infoLimit = warningLimit.multiply(0.5);
        Pair<IItem, IQuantity> longestEventInfo = this.findLongestEventInfo(items.apply(JdkFilters.VM_OPERATIONS_BLOCKING_OR_SAFEPOINT));
        IItem startingEvent = (IItem)longestEventInfo.left;
        if (startingEvent == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("VMOperationRuleFactory_TEXT_OK")).addResult(LONGEST_OPERATION_DURATION, (Object)UnitLookup.SECOND.quantity(0L)).build();
        }
        IQuantity longestOperationStart = this.getStartTime(startingEvent);
        IQuantity longestDuration = (IQuantity)longestEventInfo.right;
        String operation = this.getOperation(startingEvent);
        IMCThread caller = this.getCaller(startingEvent);
        double score = RulesToolkit.mapExp100((double)longestDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        boolean bl = isCombinedDuration = this.getDuration(startingEvent).compareTo((Object)longestDuration) != 0;
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String longMessage = isCombinedDuration ? Messages.getString("VMOperationRuleFactory_TEXT_WARN_LONG_COMBINED_DURATION") : Messages.getString("VMOperationRuleFactory_TEXT_WARN_LONG");
            String shortMessage = isCombinedDuration ? Messages.getString("VMOperationRuleFactory_TEXT_WARN_COMBINED_DURATION") : Messages.getString("VMOperationRuleFactory_TEXT_WARN");
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(shortMessage).setExplanation(longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_OPERATION, (Object)operation).addResult(LONGEST_OPERATION_CALLER, (Object)caller).addResult(LONGEST_OPERATION_DURATION, (Object)longestDuration).addResult(LONGEST_OPERATION_START_TIME, (Object)longestOperationStart).build();
        }
        String shortMessage = isCombinedDuration ? Messages.getString("VMOperationRuleFactory_TEXT_OK_COMBINED_DURATION") : Messages.getString("VMOperationRuleFactory_TEXT_OK");
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).setSummary(shortMessage).addResult(LONGEST_OPERATION, (Object)operation).addResult(LONGEST_OPERATION_DURATION, (Object)longestDuration).build();
    }

    private Pair<IItem, IQuantity> findLongestEventInfo(IItemCollection items) {
        IItem startingEvent = null;
        IQuantity longestDuration = null;
        IItem curStartingEvent = null;
        IQuantity prevEndTime = null;
        IQuantity curCombinedDur = null;
        List<IItem> sortedEvents = this.sortEventsByStartTime(items);
        for (IItem event : sortedEvents) {
            if (curStartingEvent == null) {
                curStartingEvent = event;
                curCombinedDur = this.getDuration(event);
            } else {
                IQuantity startTime = this.getStartTime(event);
                IQuantity duration = this.getDuration(event);
                double timeBetweenEvents = startTime.subtract(prevEndTime).doubleValueIn((IUnit)UnitLookup.SECOND);
                if (this.getOperation(curStartingEvent).equals(this.getOperation(event)) && Objects.equals(this.getCaller(curStartingEvent), this.getCaller(event)) && timeBetweenEvents <= 0.01) {
                    curCombinedDur = curCombinedDur.add(duration);
                } else {
                    curCombinedDur = duration;
                    curStartingEvent = event;
                }
            }
            if (longestDuration == null || longestDuration.compareTo((Object)curCombinedDur) < 0) {
                longestDuration = curCombinedDur;
                startingEvent = curStartingEvent;
            }
            prevEndTime = this.getEndTime(event);
        }
        return new Pair(startingEvent, longestDuration);
    }

    private List<IItem> sortEventsByStartTime(IItemCollection items) {
        ArrayList<IItem> sortedEvents = new ArrayList<IItem>();
        for (IItemIterable iter : items) {
            for (IItem event : iter) {
                sortedEvents.add(event);
            }
        }
        sortedEvents.sort(new Comparator<IItem>(){

            @Override
            public int compare(IItem e1, IItem e2) {
                return VMOperationRule.this.getStartTime(e1).compareTo((Object)VMOperationRule.this.getStartTime(e2));
            }
        });
        return sortedEvents;
    }

    private IQuantity getStartTime(IItem event) {
        return (IQuantity)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JfrAttributes.START_TIME);
    }

    private IQuantity getEndTime(IItem event) {
        return (IQuantity)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JfrAttributes.END_TIME);
    }

    private IQuantity getDuration(IItem event) {
        return (IQuantity)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JfrAttributes.DURATION);
    }

    private IMCThread getCaller(IItem event) {
        return (IMCThread)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JdkAttributes.CALLER);
    }

    private String getOperation(IItem event) {
        return (String)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JdkAttributes.OPERATION);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("VMOperations_RULE_NAME");
    }

    public String getTopic() {
        return "vm_operations";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

