/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;

public class ClassifiedLocation {
    private final File location;
    private final String classifier;

    public ClassifiedLocation(File location, String classifier) {
        if (location == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.classifier = classifier;
    }

    public ClassifiedLocation(IArtifactFacade artifact) {
        this(artifact.getLocation(), artifact.getClassifier());
    }

    public File getLocation() {
        return this.location;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.location.getAbsolutePath());
        if (this.classifier != null) {
            sb.append('[').append(this.classifier).append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = this.location.hashCode();
        hash = 17 * hash + (this.classifier != null ? this.classifier.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassifiedLocation)) {
            return false;
        }
        ClassifiedLocation other = (ClassifiedLocation)obj;
        return ClassifiedLocation.eq(this.location, other.location) && ClassifiedLocation.eq(this.classifier, other.classifier);
    }

    static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }
}

