/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.test.io.IOResourceSet;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;
import org.openjdk.jmc.flightrecorder.parser.filter.FilterExtension;
import org.openjdk.jmc.flightrecorder.parser.filter.IOnLoadFilter;
import org.openjdk.jmc.flightrecorder.parser.filter.OnLoadFilters;
import org.openjdk.jmc.flightrecorder.test.util.PrintoutsToolkit;

public class FilteredRecordingTest {
    private static final String JVM_INFORMATION_REGEXP = ".*JVMInformation";
    private static final String COM_ORACLE_JDK_JVM_INFORMATION = "jdk.JVMInformation";

    @Test
    public void testIncludeEventTypeFilter() throws IOException, CouldNotLoadRecordingException {
        this.checkFilter(OnLoadFilters.includeEvents(Arrays.asList(COM_ORACLE_JDK_JVM_INFORMATION)), COM_ORACLE_JDK_JVM_INFORMATION, true, "Expected all event types except 'jdk.JVMInformation'");
    }

    @Test
    public void testExcludeEventTypeFilter() throws IOException, CouldNotLoadRecordingException {
        this.checkFilter(OnLoadFilters.excludeEvents(Arrays.asList(COM_ORACLE_JDK_JVM_INFORMATION)), COM_ORACLE_JDK_JVM_INFORMATION, false, "Expected event type 'jdk.JVMInformation'");
    }

    @Test
    public void testIncludeRegexpFilter() throws IOException, CouldNotLoadRecordingException {
        this.checkFilter(OnLoadFilters.includeEvents((Pattern)Pattern.compile(JVM_INFORMATION_REGEXP)), COM_ORACLE_JDK_JVM_INFORMATION, true, "Expected all event types except those matching '.*JVMInformation'");
    }

    @Test
    public void testExcludeRegexpFilter() throws IOException, CouldNotLoadRecordingException {
        this.checkFilter(OnLoadFilters.excludeEvents((Pattern)Pattern.compile(JVM_INFORMATION_REGEXP)), COM_ORACLE_JDK_JVM_INFORMATION, false, "Expected event types matching '.*JVMInformation'");
    }

    private void checkFilter(IOnLoadFilter onLoadFilter, String typeToCheck, boolean expect, String unexpectedAfterFilterString) throws IOException, CouldNotLoadRecordingException, AssertionError {
        for (IOResourceSet resourceSet : PrintoutsToolkit.getTestResources()) {
            try (InputStream recordingStream = resourceSet.getResource(0).open();){
                ArrayList<FilterExtension> extensions = new ArrayList<FilterExtension>(ParserExtensionRegistry.getParserExtensions());
                extensions.add(new FilterExtension(onLoadFilter));
                IItemCollection items = JfrLoaderToolkit.loadEvents((InputStream)recordingStream, extensions);
                Assert.assertTrue((String)"Expected some events to pass through the filter", (boolean)items.hasItems());
                for (IItemIterable ii : items) {
                    if (expect == ii.getType().getIdentifier().equals(typeToCheck)) continue;
                    Assert.fail((String)(unexpectedAfterFilterString + " to be filtered from recording, but the following event type was included: '" + ii.getType().getIdentifier() + "'"));
                }
            }
            catch (AssertionError ae) {
                throw new AssertionError(((Throwable)((Object)ae)).getMessage() + " (Recording: " + resourceSet.getResource(0).getName() + ")", (Throwable)((Object)ae));
            }
        }
    }
}

