/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.FOSFactory;
import com.atlassian.clover.util.ChecksummingReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class FileUtils {
    private final long PLATFORM_FS_RESOLUTION;
    private static final int DEFAULT_FS_RESOLUTION = 1000;
    private static FileUtils INSTANCE;

    private FileUtils(long res) {
        this.PLATFORM_FS_RESOLUTION = res;
    }

    public static synchronized FileUtils getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new FileUtils(FileUtils.calcFSResolution());
        return INSTANCE;
    }

    public long getPlatformFSResolution() {
        return this.PLATFORM_FS_RESOLUTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int calcFSResolution() {
        int n;
        block7: {
            File temp = File.createTempFile("clover_fs_rez_test", ".txt");
            try {
                int rez;
                AccessController.checkPermission(new FilePermission(temp.getAbsolutePath(), "delete"));
                for (rez = 1; rez <= 1000; rez *= 10) {
                    temp.setLastModified(rez);
                    if (temp.lastModified() == (long)rez) break;
                }
                n = rez;
                if (temp == null) break block7;
                temp.delete();
            }
            catch (Throwable throwable) {
                try {
                    if (temp != null) {
                        temp.delete();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return 1000;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readerCopy(Reader src, Writer dest) throws IOException {
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            in = new BufferedReader(src);
            out = new PrintWriter(dest);
            String line = in.readLine();
            while (line != null) {
                out.println(line);
                line = in.readLine();
            }
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(in);
        FileUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File dest) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dest));
            int b = ((InputStream)in).read();
            while (b >= 0) {
                ((OutputStream)out).write(b);
                b = ((InputStream)in).read();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(in);
        FileUtils.close(out);
    }

    public static void dirCopy(File srcDir, File destDir, boolean deleteDestDir) throws IOException {
        File[] files;
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir.getAbsolutePath() + "' is not a directory");
        }
        if (srcDir.getAbsolutePath().equals(destDir.getAbsolutePath())) {
            throw new IOException("Target '" + destDir.getAbsolutePath() + "' is same as source '" + srcDir.getAbsolutePath() + "'");
        }
        if (FileUtils.isAncestorOf(srcDir, destDir)) {
            throw new IOException("Target '" + destDir.getAbsolutePath() + "' is sub-directory of source '" + srcDir.getAbsolutePath() + "'");
        }
        if (deleteDestDir && destDir.exists() && !FileUtils.deltree(destDir)) {
            throw new IOException("Unable to delete destination directory '" + destDir.getAbsolutePath() + "'");
        }
        if (!destDir.exists() && !destDir.mkdir()) {
            throw new IOException("Failed to create destination directory '" + destDir.getAbsolutePath() + "'");
        }
        for (File file : files = srcDir.listFiles()) {
            File destFile = new File(destDir, file.getName());
            if (file.isDirectory()) {
                FileUtils.dirCopy(file, destFile, deleteDestDir);
                continue;
            }
            FileUtils.fileCopy(file, destFile);
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                Logger.getInstance().verbose("Failed to close input stream: " + in, e);
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                Logger.getInstance().verbose("Failed to close output stream: " + out, e);
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                Logger.getInstance().verbose("Failed to close reader: " + reader, e);
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                Logger.getInstance().verbose("Failed to close writer: " + writer, e);
            }
        }
    }

    public static boolean deltree(File rootDir) {
        if (rootDir.isDirectory()) {
            String[] files;
            for (String file : files = rootDir.list()) {
                if (FileUtils.deltree(new File(rootDir, file))) continue;
                return false;
            }
        }
        return rootDir.delete();
    }

    public static String getNormalizedPath(String inputPath) {
        return inputPath == null ? null : inputPath.replace('\\', '/');
    }

    public static String getPlatformSpecificPath(String inputPath) {
        return inputPath == null ? null : inputPath.replace('\\', '/').replace('/', File.separatorChar);
    }

    public static String getRelativePath(String a, String b, String pathSep) {
        String[] pathA = FileUtils.getPaths(a);
        String[] pathB = FileUtils.getPaths(b);
        int indexA = -1;
        int indexB = -1;
        for (int i = pathA.length; 0 < i; --i) {
            if (FileUtils.lastIndexOf(pathA[i - 1], pathB) == -1) continue;
            indexA = i - 1;
            indexB = FileUtils.lastIndexOf(pathA[i - 1], pathB);
            break;
        }
        if (indexA == -1 || indexB == -1) {
            return null;
        }
        int pathADistance = pathA.length - (indexA + 1);
        int pathBDistance = pathB.length - (indexB + 1);
        String relativePath = "";
        for (int i = 0; i < pathADistance; ++i) {
            relativePath = relativePath + ".." + pathSep;
        }
        String[] pathBComponents = FileUtils.getPathComponents(b);
        String sep = "";
        for (int i = pathB.length - pathBDistance; i < pathB.length; ++i) {
            relativePath = relativePath + sep + pathBComponents[i];
            sep = pathSep;
        }
        return relativePath;
    }

    public static String getRelativePath(String a, String b) {
        return FileUtils.getRelativePath(a, b, File.separator);
    }

    public static String getRelativePath(File a, File b, String pathSep) {
        return FileUtils.getRelativePath(a.getAbsolutePath(), b.getAbsolutePath(), pathSep);
    }

    public static String getRelativePath(File a, File b) {
        return FileUtils.getRelativePath(a.getAbsolutePath(), b.getAbsolutePath(), File.separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calcAdlerChecksum(File f, String encoding) throws IOException {
        long l;
        char[] buffer = new char[8192];
        ChecksummingReader reader = null;
        try {
            InputStreamReader in = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(f), encoding) : new FileReader(f);
            reader = new ChecksummingReader(new BufferedReader(in));
            while (reader.read(buffer) >= 0) {
            }
            l = reader.getChecksum();
        }
        catch (Throwable throwable) {
            FileUtils.close(reader);
            throw throwable;
        }
        FileUtils.close(reader);
        return l;
    }

    private static int lastIndexOf(String str, String[] path) {
        for (int i = path.length; 0 < i; --i) {
            if (path[i - 1].compareTo(str) != 0) continue;
            return i - 1;
        }
        return -1;
    }

    private static String[] getPathComponents(String str) {
        StringTokenizer tokens = new StringTokenizer(str, "\\/", false);
        String[] result = new String[tokens.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokens.nextToken();
        }
        return result;
    }

    private static String[] getPaths(String str) {
        StringTokenizer tokens = new StringTokenizer(str, "\\/", false);
        String[] result = new String[tokens.countTokens()];
        String currentPath = "";
        String pathSep = "";
        for (int i = 0; i < result.length; ++i) {
            result[i] = currentPath = currentPath + pathSep + tokens.nextToken();
            pathSep = File.separator;
        }
        return result;
    }

    public static boolean isAncestorOf(File a, File b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        for (File ancestor = b.getParentFile(); ancestor != null; ancestor = ancestor.getParentFile()) {
            if (!ancestor.equals(a)) continue;
            return true;
        }
        return false;
    }

    public static String fromURI(String uri) {
        if (!uri.startsWith("file:")) {
            throw new IllegalArgumentException("Can only handle file: URIs");
        }
        uri = uri.startsWith("file://") ? uri.substring(7) : uri.substring(5);
        uri = uri.replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public int compareLastModified(long date, File file) {
        return this.compareLastModified(date, file.lastModified());
    }

    private int compareLastModified(long date1, long date2) {
        long diff = date1 - date2;
        if (Math.abs(diff) <= this.PLATFORM_FS_RESOLUTION / 2L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public static File[] listMatchingFilesForDir(File dir, final String regex) throws IOException {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().matches(regex);
            }
        });
        if (files == null) {
            throw new IOException("Unable to read directory " + dir);
        }
        return files;
    }

    public static File createTempDir(String name) throws IOException {
        return FileUtils.createTempDir(name, null);
    }

    public static File createTempDir(String name, File parent) throws IOException {
        File temp;
        if (parent != null) {
            parent.mkdirs();
            temp = File.createTempFile(name, "", parent);
        } else {
            temp = File.createTempFile(name, "");
        }
        temp.delete();
        temp.mkdirs();
        return temp;
    }

    public static File createEmptyDir(File parent, String name) throws IOException {
        File emptyDir = new File(parent, name);
        FileUtils.deltree(emptyDir);
        emptyDir.mkdirs();
        return emptyDir;
    }

    public static void writeChars(String str, DataOutputStream out) throws IOException {
        str = str == null ? "" : str;
        out.writeInt(str.length());
        out.writeChars(str);
    }

    public static String readChars(DataInputStream in) throws IOException {
        int len = in.readInt();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buf.append(in.readChar());
        }
        return buf.toString();
    }

    public static OutputStream createDeflateOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new DeflaterOutputStream((OutputStream)FOSFactory.newFOS(file), new Deflater(1), 8192));
    }

    public static InputStream createInflaterInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new InflaterInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public static File getCurrentDirIfNull(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        return dir;
    }
}

