/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.filters;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.BaseInvertableFilter;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.util.FilterUtils;
import java.io.File;
import java.util.Arrays;

public class AntPatternTestFilter
extends BaseInvertableFilter {
    private final String[] includeFilter;
    private final String[] excludeFilter;
    private final String root;

    AntPatternTestFilter(boolean inverted, String root, String[] includePattern, String[] excludePattern) {
        super(inverted);
        this.root = root == null || root.endsWith(File.separator) ? root : root + File.separator;
        this.includeFilter = includePattern;
        this.excludeFilter = excludePattern;
    }

    public AntPatternTestFilter(String root, String[] includePattern, String[] excludePattern) {
        this(false, root, includePattern, excludePattern);
    }

    public AntPatternTestFilter(String root) {
        this(root, new String[0], new String[0]);
    }

    public AntPatternTestFilter invert() {
        return new AntPatternTestFilter(!this.isInverted(), this.root, this.includeFilter, this.excludeFilter);
    }

    public boolean accept(HasMetrics hm) {
        if (hm instanceof FullClassInfo) {
            FullClassInfo ci = (FullClassInfo)hm;
            File file = ((FullFileInfo)ci.getContainingFile()).getPhysicalFile();
            String path = file.getPath();
            String relative = this.root != null && path.startsWith(this.root) ? path.substring(this.root.length()) : path;
            return this.isInverted() ^ FilterUtils.isIncluded(relative, this.excludeFilter, this.includeFilter, false);
        }
        return true;
    }

    public String toString() {
        return "AntPatternTestFilter:[" + this.root + "]" + Arrays.toString(this.includeFilter) + Arrays.toString(this.excludeFilter);
    }
}

