/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.RuntimeType;
import com.atlassian.clover.recorder.BaseCoverageRecording;
import com.atlassian.clover.recorder.PerTestRecording;
import com.atlassian.clover.recorder.RecordingTranscript;
import com.atlassian.clover.util.CloverBitSet;
import com.atlassian.clover.util.CloverUtils;
import com.atlassian.clover.util.FileUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;

public class PerTestRecordingTranscript
extends BaseCoverageRecording
implements PerTestRecording,
RecordingTranscript {
    private CloverBitSet coverage;
    private String testTypeName;
    private String testMethodName;
    private String runtimeTestName;
    private String exitMessage;
    private String stackTrace;
    private int exitStatus = -1;
    private long start;

    public PerTestRecordingTranscript(BaseCoverageRecording.Header header, File fileOnDisk) {
        super(header, fileOnDisk);
    }

    public PerTestRecordingTranscript(CloverBitSet coverage, File fileOnDisk, long dbVersion, String testMethodName, String runtimeTestName, long start, long end, RuntimeType testType, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
        super(new BaseCoverageRecording.Header(dbVersion, end, 1), fileOnDisk);
        this.coverage = coverage;
        this.testMethodName = testMethodName;
        this.runtimeTestName = runtimeTestName;
        this.testTypeName = testType.name;
        this.exitStatus = exitStatus;
        this.exitMessage = errorInfo == null ? null : errorInfo.getMessage();
        this.stackTrace = errorInfo == null ? null : errorInfo.getStackTrace();
        this.start = start;
    }

    public void read(DataInputStream in, CoverageDataSpec spec) throws IOException {
        this.testTypeName = in.readUTF().replace('$', '.');
        this.testMethodName = in.readUTF();
        this.runtimeTestName = in.readUTF();
        if (this.runtimeTestName.length() == 0) {
            this.runtimeTestName = null;
        }
        this.exitStatus = in.readInt();
        if (this.exitStatus == 0) {
            this.exitMessage = FileUtils.readChars(in);
            this.stackTrace = CloverUtils.transformStackTrace(FileUtils.readChars(in), spec.isFilterTraces());
        }
        this.start = in.readLong();
        this.coverage = CloverBitSet.read(in);
    }

    CloverBitSet getCoverage() {
        return this.coverage;
    }

    public boolean get(int slotIndex) {
        return this.coverage.member(slotIndex);
    }

    public String getTestTypeName() {
        return this.testTypeName;
    }

    public String getTestMethodName() {
        return this.testMethodName;
    }

    public String getRuntimeTestName() {
        return this.runtimeTestName;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.header.getWriteTimeStamp();
    }

    public boolean hasResult() {
        return this.exitStatus != -1;
    }

    public boolean isResultPassed() {
        return this.exitStatus == 1;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public String toString() {
        return "PerTestRecordingTranscript[coverage.size=" + this.coverage.size() + ", testTypeName='" + this.testTypeName + '\'' + ", testMethodName='" + this.testMethodName + '\'' + ", exitMessage='" + this.exitMessage + '\'' + ", stackTrace='" + this.stackTrace + '\'' + ", exitStatus=" + (this.exitStatus == 0 ? "'Abnormal'" : (this.exitStatus == -1 ? "'None'" : "'Normal'")) + ", start=" + this.start + ']';
    }

    public void applyTo(BitSet hits) {
        this.coverage.applyTo(hits);
    }
}

